/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.desugar;

import io.ballerina.identifier.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class IdentifierDesugar {
    public static HashMap<String, String> encodeModuleIdentifiers(BIRNode.BIRPackage module) {
        HashMap<String, String> encodedVsInitialIds = new HashMap<String, String>();
        IdentifierDesugar.encodePackageIdentifiers(module.packageID, encodedVsInitialIds);
        IdentifierDesugar.encodeGlobalVariableIdentifiers(module.globalVars, encodedVsInitialIds);
        IdentifierDesugar.encodeImportedGlobalVariableIdentifiers(module.importedGlobalVarsDummyVarDcls, encodedVsInitialIds);
        IdentifierDesugar.encodeFunctionIdentifiers(module.functions, encodedVsInitialIds);
        IdentifierDesugar.encodeTypeDefIdentifiers(module.typeDefs, encodedVsInitialIds);
        return encodedVsInitialIds;
    }

    private static void encodePackageIdentifiers(PackageID packageID, HashMap<String, String> encodedVsInitialIds) {
        packageID.orgName = Names.fromString(IdentifierDesugar.encodeNonFunctionIdentifier(packageID.orgName.value, encodedVsInitialIds));
        packageID.name = Names.fromString(IdentifierDesugar.encodeNonFunctionIdentifier(packageID.name.value, encodedVsInitialIds));
    }

    private static void encodeTypeDefIdentifiers(List<BIRNode.BIRTypeDefinition> typeDefs, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRTypeDefinition typeDefinition : typeDefs) {
            typeDefinition.type.tsymbol.name = Names.fromString(IdentifierDesugar.encodeNonFunctionIdentifier(typeDefinition.type.tsymbol.name.value, encodedVsInitialIds));
            typeDefinition.internalName = Names.fromString(IdentifierDesugar.encodeNonFunctionIdentifier(typeDefinition.internalName.value, encodedVsInitialIds));
            if (typeDefinition.referenceType != null) {
                typeDefinition.referenceType.tsymbol.name = Names.fromString(IdentifierDesugar.encodeNonFunctionIdentifier(typeDefinition.referenceType.tsymbol.name.value, encodedVsInitialIds));
            }
            IdentifierDesugar.encodeFunctionIdentifiers(typeDefinition.attachedFuncs, encodedVsInitialIds);
            BType bType = JvmCodeGenUtil.getImpliedType(typeDefinition.type);
            if (bType.tag == 34) {
                BObjectType objectType = (BObjectType)bType;
                BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)bType.tsymbol;
                if (objectTypeSymbol.attachedFuncs != null) {
                    IdentifierDesugar.encodeAttachedFunctionIdentifiers(objectTypeSymbol.attachedFuncs, encodedVsInitialIds);
                }
                for (BField field : objectType.fields.values()) {
                    field.name = Names.fromString(IdentifierDesugar.encodeNonFunctionIdentifier(field.name.value, encodedVsInitialIds));
                }
            }
            if (bType.tag != 12) continue;
            BRecordType recordType = (BRecordType)bType;
            for (BField field : recordType.fields.values()) {
                field.name = Names.fromString(IdentifierDesugar.encodeNonFunctionIdentifier(field.name.value, encodedVsInitialIds));
            }
        }
    }

    private static void encodeFunctionIdentifiers(List<BIRNode.BIRFunction> functions, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRFunction function : functions) {
            function.name = Names.fromString(IdentifierDesugar.encodeFunctionIdentifier(function.name.value, encodedVsInitialIds));
            for (BIRNode.BIRVariableDcl bIRVariableDcl : function.localVars) {
                if (bIRVariableDcl.metaVarName == null) continue;
                bIRVariableDcl.metaVarName = IdentifierDesugar.encodeNonFunctionIdentifier(bIRVariableDcl.metaVarName, encodedVsInitialIds);
            }
            for (BIRNode.BIRParameter bIRParameter : function.requiredParams) {
                bIRParameter.name = Names.fromString(IdentifierDesugar.encodeNonFunctionIdentifier(bIRParameter.name.value, encodedVsInitialIds));
            }
            if (function.type.tsymbol != null) {
                for (BVarSymbol bVarSymbol : ((BInvokableTypeSymbol)function.type.tsymbol).params) {
                    bVarSymbol.name = Names.fromString(IdentifierDesugar.encodeNonFunctionIdentifier(bVarSymbol.name.value, encodedVsInitialIds));
                }
            }
            IdentifierDesugar.encodeDefaultFunctionName(function.type, encodedVsInitialIds);
            IdentifierDesugar.encodeWorkerName(function, encodedVsInitialIds);
        }
    }

    private static void encodeDefaultFunctionName(BInvokableType type, HashMap<String, String> encodedVsInitialIds) {
        BInvokableTypeSymbol typeSymbol = (BInvokableTypeSymbol)type.tsymbol;
        if (typeSymbol == null) {
            return;
        }
        for (BInvokableSymbol defaultFunc : typeSymbol.defaultValues.values()) {
            defaultFunc.name = Names.fromString(IdentifierDesugar.encodeFunctionIdentifier(defaultFunc.name.value, encodedVsInitialIds));
        }
    }

    private static void encodeWorkerName(BIRNode.BIRFunction function, HashMap<String, String> encodedVsInitialIds) {
        if (function.workerName != null) {
            function.workerName = Names.fromString(IdentifierDesugar.encodeNonFunctionIdentifier(function.workerName.value, encodedVsInitialIds));
        }
    }

    private static void encodeAttachedFunctionIdentifiers(List<BAttachedFunction> functions, HashMap<String, String> encodedVsInitialIds) {
        for (BAttachedFunction function : functions) {
            function.funcName = Names.fromString(IdentifierDesugar.encodeFunctionIdentifier(function.funcName.value, encodedVsInitialIds));
        }
    }

    private static void encodeGlobalVariableIdentifiers(List<BIRNode.BIRGlobalVariableDcl> globalVars, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRGlobalVariableDcl globalVar : globalVars) {
            globalVar.name = Names.fromString(IdentifierDesugar.encodeNonFunctionIdentifier(globalVar.name.value, encodedVsInitialIds));
        }
    }

    private static void encodeImportedGlobalVariableIdentifiers(Set<BIRNode.BIRGlobalVariableDcl> globalVars, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRGlobalVariableDcl globalVar : globalVars) {
            globalVar.name = Names.fromString(IdentifierDesugar.encodeNonFunctionIdentifier(globalVar.name.value, encodedVsInitialIds));
        }
    }

    public static void replaceEncodedModuleIdentifiers(BIRNode.BIRPackage module, HashMap<String, String> encodedVsInitialIds) {
        IdentifierDesugar.replaceEncodedPackageIdentifiers(module.packageID, encodedVsInitialIds);
        IdentifierDesugar.replaceEncodedGlobalVariableIdentifiers(module.globalVars, encodedVsInitialIds);
        IdentifierDesugar.replaceEncodedFunctionIdentifiers(module.functions, encodedVsInitialIds);
        IdentifierDesugar.replaceEncodedTypeDefIdentifiers(module.typeDefs, encodedVsInitialIds);
    }

    private static void replaceEncodedPackageIdentifiers(PackageID packageID, HashMap<String, String> encodedVsInitialIds) {
        packageID.orgName = IdentifierDesugar.getInitialIdString(packageID.orgName, encodedVsInitialIds);
        packageID.name = IdentifierDesugar.getInitialIdString(packageID.name, encodedVsInitialIds);
    }

    private static void replaceEncodedTypeDefIdentifiers(List<BIRNode.BIRTypeDefinition> typeDefs, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRTypeDefinition typeDefinition : typeDefs) {
            typeDefinition.type.tsymbol.name = IdentifierDesugar.getInitialIdString(typeDefinition.type.tsymbol.name, encodedVsInitialIds);
            typeDefinition.internalName = IdentifierDesugar.getInitialIdString(typeDefinition.internalName, encodedVsInitialIds);
            IdentifierDesugar.replaceEncodedFunctionIdentifiers(typeDefinition.attachedFuncs, encodedVsInitialIds);
            BType bType = JvmCodeGenUtil.getImpliedType(typeDefinition.type);
            if (bType.tag == 34) {
                BObjectType objectType = (BObjectType)bType;
                BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)bType.tsymbol;
                if (objectTypeSymbol.attachedFuncs != null) {
                    IdentifierDesugar.replaceEncodedAttachedFunctionIdentifiers(objectTypeSymbol.attachedFuncs, encodedVsInitialIds);
                }
                for (BField field : objectType.fields.values()) {
                    field.name = IdentifierDesugar.getInitialIdString(field.name, encodedVsInitialIds);
                }
            }
            if (bType.tag != 12) continue;
            BRecordType recordType = (BRecordType)bType;
            for (BField field : recordType.fields.values()) {
                field.name = IdentifierDesugar.getInitialIdString(field.name, encodedVsInitialIds);
            }
        }
    }

    private static void replaceEncodedFunctionIdentifiers(List<BIRNode.BIRFunction> functions, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRFunction function : functions) {
            function.name = IdentifierDesugar.getInitialIdString(function.name, encodedVsInitialIds);
            for (BIRNode.BIRParameter bIRParameter : function.requiredParams) {
                bIRParameter.name = IdentifierDesugar.getInitialIdString(bIRParameter.name, encodedVsInitialIds);
            }
            if (function.type.tsymbol != null) {
                for (BVarSymbol bVarSymbol : ((BInvokableTypeSymbol)function.type.tsymbol).params) {
                    bVarSymbol.name = IdentifierDesugar.getInitialIdString(bVarSymbol.name, encodedVsInitialIds);
                }
            }
            IdentifierDesugar.replaceEncodedDefaultFunctionName(function.type, encodedVsInitialIds);
            IdentifierDesugar.replaceEncodedWorkerName(function, encodedVsInitialIds);
        }
    }

    private static void replaceEncodedDefaultFunctionName(BInvokableType type, HashMap<String, String> encodedVsInitialIds) {
        BInvokableTypeSymbol typeSymbol = (BInvokableTypeSymbol)type.tsymbol;
        if (typeSymbol == null) {
            return;
        }
        for (BInvokableSymbol defaultFunc : typeSymbol.defaultValues.values()) {
            defaultFunc.name = IdentifierDesugar.getInitialIdString(defaultFunc.name, encodedVsInitialIds);
        }
    }

    private static void replaceEncodedWorkerName(BIRNode.BIRFunction function, HashMap<String, String> encodedVsInitialIds) {
        if (function.workerName != null) {
            function.workerName = IdentifierDesugar.getInitialIdString(function.workerName, encodedVsInitialIds);
        }
    }

    private static void replaceEncodedAttachedFunctionIdentifiers(List<BAttachedFunction> functions, HashMap<String, String> encodedVsInitialIds) {
        for (BAttachedFunction function : functions) {
            function.funcName = IdentifierDesugar.getInitialIdString(function.funcName, encodedVsInitialIds);
        }
    }

    private static void replaceEncodedGlobalVariableIdentifiers(List<BIRNode.BIRGlobalVariableDcl> globalVars, HashMap<String, String> encodedVsInitialIds) {
        for (BIRNode.BIRGlobalVariableDcl globalVar : globalVars) {
            globalVar.name = IdentifierDesugar.getInitialIdString(globalVar.name, encodedVsInitialIds);
        }
    }

    private static String encodeFunctionIdentifier(String identifier, HashMap<String, String> encodedVsInitialIds) {
        if (encodedVsInitialIds.containsKey(identifier)) {
            return identifier;
        }
        String encodedString = Utils.encodeFunctionIdentifier((String)identifier);
        encodedVsInitialIds.putIfAbsent(encodedString, identifier);
        return encodedString;
    }

    private static String encodeNonFunctionIdentifier(String identifier, HashMap<String, String> encodedVsInitialIds) {
        if (encodedVsInitialIds.containsKey(identifier)) {
            return identifier;
        }
        String encodedString = Utils.encodeNonFunctionIdentifier((String)identifier);
        encodedVsInitialIds.putIfAbsent(encodedString, identifier);
        return encodedString;
    }

    private static Name getInitialIdString(Name encodedIdString, HashMap<String, String> encodedVsInitialIds) {
        String initialString = encodedVsInitialIds.get(encodedIdString.value);
        if (initialString != null) {
            return Names.fromString(initialString);
        }
        return encodedIdString;
    }
}

