/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.desugar;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadBirBasicBlock;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadingDataCollector;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.util.Names;

public class LazyLoadingDesugar {
    private final LazyLoadingDataCollector lazyLoadingDataCollector;
    private int nextLocalVarBBIndex = 0;
    private int nextLocalVarIndex = 0;

    public LazyLoadingDesugar(LazyLoadingDataCollector lazyLoadingDataCollector) {
        this.lazyLoadingDataCollector = lazyLoadingDataCollector;
    }

    public void lazyLoadInitFunctions(List<BIRNode.BIRFunction> functions) {
        for (BIRNode.BIRFunction function : functions) {
            if (!function.originalName.value.contains(Names.INIT_FUNCTION_SUFFIX.value)) continue;
            this.lazyLoadInitFunction(function);
            this.removeUnusedLocalVars(function);
            this.reset();
        }
    }

    private void lazyLoadInitFunction(BIRNode.BIRFunction function) {
        List<BIRNode.BIRBasicBlock> basicBlocks = function.basicBlocks;
        for (int i = 0; i < basicBlocks.size(); ++i) {
            BIRNode.BIRBasicBlock basicBlock = basicBlocks.get(i);
            boolean isLastInstructionGlobalVar = this.lazyLoadInstructions(basicBlock, i);
            boolean isLastTerminatorsIsGlobal = this.lazyLoadTerminator(function.basicBlocks, basicBlock, i);
            if (!isLastInstructionGlobalVar || !isLastTerminatorsIsGlobal) continue;
            this.nextLocalVarIndex = 0;
            ++this.nextLocalVarBBIndex;
        }
    }

    private boolean lazyLoadInstructions(BIRNode.BIRBasicBlock bb, int currentBBIndex) {
        List<BIRNonTerminator> instructions = bb.instructions;
        if (bb.instructions.isEmpty()) {
            return true;
        }
        BIROperand lhsOp = null;
        for (int i = 0; i < instructions.size(); ++i) {
            BIRNonTerminator instruction = instructions.get(i);
            lhsOp = instruction.lhsOp;
            if (lhsOp == null || lhsOp.variableDcl.kind != VarKind.GLOBAL && lhsOp.variableDcl.kind != VarKind.CONSTANT) continue;
            if (currentBBIndex != this.nextLocalVarBBIndex) {
                this.nextLocalVarIndex = i + 1;
                this.nextLocalVarBBIndex = currentBBIndex;
                continue;
            }
            this.copyInstructions(lhsOp, instructions, i);
            i = this.nextLocalVarIndex - 1;
        }
        return lhsOp != null && (lhsOp.variableDcl.kind == VarKind.GLOBAL || lhsOp.variableDcl.kind == VarKind.CONSTANT);
    }

    private boolean lazyLoadTerminator(List<BIRNode.BIRBasicBlock> basicBlocks, BIRNode.BIRBasicBlock bb, int currentBBIndex) {
        BIRTerminator terminator = bb.terminator;
        BIROperand lhsOp = terminator.lhsOp;
        if (terminator.kind == InstructionKind.CALL) {
            BIRTerminator.Call call = (BIRTerminator.Call)terminator;
            String callName = call.name.value;
            if (callName.contains("$annot_func$")) {
                return this.lazyLoadAnnotationProcessCall(bb, basicBlocks.get(currentBBIndex + 1), call);
            }
            if (callName.equals(Names.START_TRANSACTION_COORDINATOR.value)) {
                return true;
            }
            if (call.args.isEmpty() && lhsOp != null && (lhsOp.variableDcl.kind == VarKind.GLOBAL || lhsOp.variableDcl.kind == VarKind.CONSTANT) && callName.contains("$split$_")) {
                this.lazyLoadSplitCall(call, lhsOp.variableDcl.name.value, bb, basicBlocks, currentBBIndex);
            }
        }
        return lhsOp != null && (lhsOp.variableDcl.kind == VarKind.GLOBAL || lhsOp.variableDcl.kind == VarKind.CONSTANT) || terminator.kind == InstructionKind.GOTO;
    }

    private void copyInstructions(BIROperand lhsOp, List<BIRNonTerminator> instructions, int currentInsIndex) {
        String varName = lhsOp.variableDcl.name.value;
        int startIndex = this.nextLocalVarIndex;
        ArrayList<BIRNonTerminator> lazyInsList = new ArrayList<BIRNonTerminator>();
        for (int i = startIndex; i <= currentInsIndex; ++i) {
            lazyInsList.add(instructions.remove(startIndex));
        }
        LazyLoadBirBasicBlock lazyLoadBirBasicBlock = this.lazyLoadingDataCollector.lazyLoadingBBMap.get(varName);
        if (lazyLoadBirBasicBlock != null) {
            List<BIRNonTerminator> insList = lazyLoadBirBasicBlock.instructions;
            if (insList == null) {
                lazyLoadBirBasicBlock.instructions = lazyInsList;
                return;
            }
            insList.addAll(lazyInsList);
            return;
        }
        this.lazyLoadingDataCollector.lazyLoadingBBMap.put(varName, new LazyLoadBirBasicBlock(lazyInsList, null));
    }

    private boolean lazyLoadAnnotationProcessCall(BIRNode.BIRBasicBlock currentBB, BIRNode.BIRBasicBlock nextBB, BIRTerminator.Call call) {
        List<BIRNonTerminator> instructions = nextBB.instructions;
        if (nextBB.instructions.isEmpty()) {
            return false;
        }
        ArrayList<BIRNonTerminator> annotationsInsList = new ArrayList<BIRNonTerminator>();
        ArrayList<BIRNonTerminator> nextBBInstructions = new ArrayList<BIRNonTerminator>();
        int size = instructions.size();
        String typeName = null;
        for (int i = 0; i < size; ++i) {
            BIRNonTerminator instruction = instructions.get(i);
            annotationsInsList.add(instruction);
            if (instruction.kind != InstructionKind.MAP_STORE) continue;
            typeName = ((BIRNonTerminator.ConstantLoad)instructions.get((int)(i - 1))).value.toString();
            break;
        }
        for (int j = i + 1; j < instructions.size(); ++j) {
            nextBBInstructions.add(instructions.get(j));
        }
        nextBB.instructions = nextBBInstructions;
        LazyLoadBirBasicBlock lazyBB = new LazyLoadBirBasicBlock(annotationsInsList, call);
        this.lazyLoadingDataCollector.lazyLoadingAnnotationsBBMap.put(typeName, lazyBB);
        currentBB.terminator = new BIRTerminator.GOTO(call.pos, nextBB);
        return true;
    }

    private void lazyLoadSplitCall(BIRTerminator.Call call, String varName, BIRNode.BIRBasicBlock bb, List<BIRNode.BIRBasicBlock> basicBlocks, int currentBBIndex) {
        BIRNode.BIRBasicBlock nextBB = basicBlocks.get(currentBBIndex + 1);
        LazyLoadBirBasicBlock lazyBB = new LazyLoadBirBasicBlock(null, call);
        this.lazyLoadingDataCollector.lazyLoadingBBMap.put(varName, lazyBB);
        bb.terminator = new BIRTerminator.GOTO(call.pos, nextBB);
    }

    private void removeUnusedLocalVars(BIRNode.BIRFunction function) {
        HashSet<BIRNode.BIRVariableDcl> usedLocalVars = new HashSet<BIRNode.BIRVariableDcl>();
        List<BIRNode.BIRBasicBlock> basicBlocks = function.basicBlocks;
        for (BIRNode.BIRBasicBlock basicBlock : basicBlocks) {
            List<BIRNonTerminator> instructions = basicBlock.instructions;
            BIRTerminator terminator = basicBlock.terminator;
            for (BIRNonTerminator instruction : instructions) {
                BIROperand lhsOp = instruction.lhsOp;
                if (lhsOp != null) {
                    usedLocalVars.add(lhsOp.variableDcl);
                }
                for (BIROperand rhsOperand : instruction.getRhsOperands()) {
                    usedLocalVars.add(rhsOperand.variableDcl);
                }
            }
            BIROperand lhsOp = terminator.lhsOp;
            if (lhsOp == null) continue;
            usedLocalVars.add(lhsOp.variableDcl);
        }
        ArrayList<BIRNode.BIRVariableDcl> newLocalVars = new ArrayList<BIRNode.BIRVariableDcl>();
        for (BIRNode.BIRVariableDcl localVar : function.localVars) {
            if (!usedLocalVars.contains(localVar)) continue;
            newLocalVars.add(localVar);
        }
        function.localVars = newLocalVars;
    }

    private void reset() {
        this.nextLocalVarIndex = 0;
        this.nextLocalVarBBIndex = 0;
    }
}

