/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.internal;

import io.ballerina.projects.ProjectException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;

public class JarEntries {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final JarOutputStream entries;

    protected JarEntries(String mainClassName) {
        try {
            this.entries = new JarOutputStream((OutputStream)this.byteArrayOutputStream, JarEntries.getManifest(mainClassName));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to create the JarOutputStream to cache jar entries", e);
        }
    }

    private static Manifest getManifest(String mainClassName) {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.put(Attributes.Name.MAIN_CLASS, mainClassName);
        return manifest;
    }

    public void put(String key, byte[] value) {
        JarEntry entry = new JarEntry(key);
        try {
            this.entries.putNextEntry(entry);
            this.entries.write(value);
            this.entries.closeEntry();
        }
        catch (IOException e) {
            throw new ProjectException("Failed to put the jar entry", e);
        }
    }

    public void putResourceEntries(Map<String, byte[]> resources) {
        try {
            for (Map.Entry<String, byte[]> entry : resources.entrySet()) {
                JarArchiveEntry e = new JarArchiveEntry(entry.getKey());
                this.entries.putNextEntry((ZipEntry)e);
                this.entries.write(entry.getValue());
                this.entries.closeEntry();
            }
        }
        catch (IOException e) {
            throw new ProjectException("Failed to put the resource entries", e);
        }
    }

    protected ByteArrayOutputStream getByteArrayOutputStream() throws IOException {
        this.entries.close();
        return this.byteArrayOutputStream;
    }
}

