/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import io.ballerina.types.Env;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmErrorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.desugar.BirDesugar;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LabelGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JFieldMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.InitMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.model.CatchIns;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JCast;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JErrorEntry;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JFieldBIRFunction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JIConstructorCall;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JIMethodCall;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethodBIRFunction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethodKind;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JType;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JavaField;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public final class InteropMethodGen {
    static void genJFieldForInteropField(JFieldBIRFunction birFunc, ClassWriter classWriter, PackageID birModule, JvmPackageGen jvmPackageGen, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen, JvmConstantsGen jvmConstantsGen, AsyncDataCollector asyncDataCollector, Types types) {
        int birFuncParamIndex;
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        indexMap.addIfNotExists("$_strand_$", jvmPackageGen.symbolTable.stringType);
        BType retType = birFunc.type.retType;
        if (Symbols.isFlagOn(retType.getFlags(), 0x4000000L)) {
            retType = JvmCodeGenUtil.UNIFIER.build(types.typeEnv(), birFunc.type.retType);
        }
        String desc = JvmCodeGenUtil.getMethodDesc(types.typeEnv(), birFunc.type.paramTypes, retType);
        int access = birFunc.receiver != null ? 1 : 9;
        MethodVisitor mv = classWriter.visitMethod(access, birFunc.name.value, desc, null, null);
        JvmInstructionGen instGen = new JvmInstructionGen(mv, indexMap, birModule, jvmPackageGen, jvmTypeGen, jvmCastGen, jvmConstantsGen, asyncDataCollector);
        JvmErrorGen errorGen = new JvmErrorGen(mv, indexMap, instGen);
        LabelGenerator labelGen = new LabelGenerator();
        JvmTerminatorGen termGen = new JvmTerminatorGen(mv, indexMap, labelGen, errorGen, birModule, instGen, jvmPackageGen, jvmTypeGen, jvmCastGen, asyncDataCollector);
        mv.visitCode();
        Label paramLoadLabel = labelGen.getLabel("param_load");
        mv.visitLabel(paramLoadLabel);
        mv.visitLineNumber(birFunc.pos.lineRange().startLine().line() + 1, paramLoadLabel);
        ArrayList<BIRNode.BIRFunctionParameter> birFuncParams = new ArrayList<BIRNode.BIRFunctionParameter>();
        for (BIRNode.BIRVariableDcl birLocalVarOptional : birFunc.localVars) {
            if (!(birLocalVarOptional instanceof BIRNode.BIRFunctionParameter)) continue;
            BIRNode.BIRFunctionParameter functionParameter = (BIRNode.BIRFunctionParameter)birLocalVarOptional;
            birFuncParams.add(functionParameter);
            indexMap.addIfNotExists(functionParameter.name.value, functionParameter.type);
        }
        JavaField jField = birFunc.javaField;
        JType jFieldType = JInterop.getJType(jField.getFieldType());
        if (!jField.isStatic()) {
            BIRNode.BIRVariableDcl var = (BIRNode.BIRVariableDcl)birFuncParams.getFirst();
            int receiverLocalVarIndex = indexMap.addIfNotExists(var.name.value, var.type);
            mv.visitVarInsn(25, receiverLocalVarIndex);
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
            mv.visitTypeInsn(192, jField.getDeclaringClassName());
            Label ifNonNullLabel = labelGen.getLabel("receiver_null_check");
            mv.visitLabel(ifNonNullLabel);
            mv.visitInsn(89);
            Label elseBlockLabel = labelGen.getLabel("receiver_null_check_else");
            mv.visitJumpInsn(199, elseBlockLabel);
            Label thenBlockLabel = labelGen.getLabel("receiver_null_check_then");
            mv.visitLabel(thenBlockLabel);
            mv.visitFieldInsn(178, "io/ballerina/runtime/internal/errors/ErrorReasons", "JAVA_NULL_REFERENCE_ERROR", "Ljava/lang/String;");
            mv.visitFieldInsn(178, "io/ballerina/runtime/internal/errors/ErrorCodes", "JAVA_NULL_REFERENCE", "Lio/ballerina/runtime/internal/errors/ErrorCodes;");
            mv.visitInsn(3);
            mv.visitTypeInsn(189, "java/lang/Object");
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/errors/ErrorHelper", "getRuntimeException", "(Ljava/lang/String;Lio/ballerina/runtime/internal/errors/ErrorCodes;[Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/ErrorValue;", false);
            mv.visitInsn(191);
            mv.visitLabel(elseBlockLabel);
        }
        int n = birFuncParamIndex = jField.isStatic() ? 0 : 1;
        if (birFuncParamIndex < birFuncParams.size()) {
            BIRNode.BIRFunctionParameter birFuncParam = (BIRNode.BIRFunctionParameter)birFuncParams.get(birFuncParamIndex);
            int paramLocalVarIndex = indexMap.addIfNotExists(birFuncParam.name.value, birFuncParam.type);
            InteropMethodGen.loadMethodParamToStackInInteropFunction(mv, birFuncParam, jFieldType, paramLocalVarIndex, instGen, jvmCastGen);
        }
        if (jField.isStatic()) {
            if (jField.method == JFieldMethod.ACCESS) {
                mv.visitFieldInsn(178, jField.getDeclaringClassName(), jField.getName(), jField.getSignature());
            } else {
                mv.visitFieldInsn(179, jField.getDeclaringClassName(), jField.getName(), jField.getSignature());
            }
        } else if (jField.method == JFieldMethod.ACCESS) {
            mv.visitFieldInsn(180, jField.getDeclaringClassName(), jField.getName(), jField.getSignature());
        } else {
            mv.visitFieldInsn(181, jField.getDeclaringClassName(), jField.getName(), jField.getSignature());
        }
        BIRNode.BIRVariableDcl retVarDcl = new BIRNode.BIRVariableDcl(retType, new Name("$_ret_var_$"), null, VarKind.LOCAL);
        int returnVarRefIndex = indexMap.addIfNotExists(retVarDcl.name.value, retType);
        int retTypeTag = JvmCodeGenUtil.getImpliedType((BType)retType).tag;
        if (retTypeTag == 10) {
            mv.visitInsn(1);
        } else if (retTypeTag == 37) {
            int returnJObjectVarRefIndex = indexMap.addIfNotExists("$_ret_jobject_var_$", jvmPackageGen.symbolTable.anyType);
            mv.visitVarInsn(58, returnJObjectVarRefIndex);
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/HandleValue");
            mv.visitInsn(89);
            mv.visitVarInsn(25, returnJObjectVarRefIndex);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/HandleValue", "<init>", "(Ljava/lang/Object;)V", false);
        } else if (jField.getFieldType().isPrimitive()) {
            InteropMethodGen.performWideningPrimitiveConversion(mv, retType, jFieldType);
        } else {
            jvmCastGen.addUnboxInsn(mv, retType);
        }
        instGen.generateVarStore(mv, retVarDcl);
        Label retLabel = labelGen.getLabel("return_lable");
        mv.visitLabel(retLabel);
        mv.visitLineNumber(birFunc.pos.lineRange().endLine().line() + 1, retLabel);
        termGen.genReturnTerm(returnVarRefIndex, birFunc, -1, -1, -1, -1);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, birFunc.name.value, birFunc.javaField.getDeclaringClassName());
        mv.visitEnd();
    }

    public static void desugarInteropFuncs(Env typeEnv, JMethodBIRFunction birFunc, InitMethodGen initMethodGen) {
        boolean isJavaInstanceMethod;
        BType retType = birFunc.type.retType;
        if (Symbols.isFlagOn(retType.getFlags(), 0x4000000L)) {
            retType = JvmCodeGenUtil.UNIFIER.build(typeEnv, birFunc.type.retType);
        }
        JMethod jMethod = birFunc.jMethod;
        Class<?>[] jMethodParamTypes = jMethod.getParamTypes();
        JType jMethodRetType = JInterop.getJType(jMethod.getReturnType());
        if (jMethodRetType == JType.J_VOID && jMethod.isBalEnvAcceptingMethod()) {
            jMethodRetType = JType.getJTypeForBType(birFunc.returnVariable.type);
        }
        initMethodGen.resetIds();
        BIRNode.BIRBasicBlock beginBB = BirDesugar.insertAndGetNextBasicBlock(birFunc.basicBlocks, initMethodGen);
        BIROperand receiverOp = null;
        ArrayList<BIROperand> args = new ArrayList<BIROperand>();
        ArrayList<BIROperand> resourcePathArgs = new ArrayList<BIROperand>();
        ArrayList<BIROperand> functionArgs = new ArrayList<BIROperand>();
        List birFuncParams = birFunc.parameters;
        int birFuncParamIndex = 0;
        int bReceiverParamIndex = 0;
        boolean bl = isJavaInstanceMethod = jMethod.kind == JMethodKind.METHOD && !jMethod.isStatic();
        if (isJavaInstanceMethod) {
            int pathParamCount = 0;
            for (BIRNode.BIRFunctionParameter birFuncParam : birFuncParams) {
                if (!birFuncParam.isPathParameter) continue;
                ++pathParamCount;
            }
            bReceiverParamIndex = pathParamCount;
            BIRNode.BIRFunctionParameter birFuncParam = (BIRNode.BIRFunctionParameter)birFuncParams.get(bReceiverParamIndex);
            BIROperand argRef = new BIROperand(birFuncParam);
            args.add(argRef);
        }
        JType varArgType = null;
        int jMethodParamIndex = 0;
        if (jMethod.getReceiverType() != null) {
            ++jMethodParamIndex;
            receiverOp = new BIROperand(birFunc.receiver);
        }
        if (jMethod.isBalEnvAcceptingMethod()) {
            ++jMethodParamIndex;
        }
        int paramCount = birFuncParams.size();
        while (birFuncParamIndex < paramCount) {
            boolean isVarArg;
            if (birFuncParamIndex == bReceiverParamIndex && isJavaInstanceMethod) {
                ++birFuncParamIndex;
                continue;
            }
            BIRNode.BIRFunctionParameter birFuncParam = (BIRNode.BIRFunctionParameter)birFuncParams.get(birFuncParamIndex);
            BType bPType = birFuncParam.type;
            BIROperand argRef = new BIROperand(birFuncParam);
            boolean bl2 = isVarArg = birFuncParamIndex == paramCount - 1 && birFunc.restParam != null;
            if (jMethod.hasBundledPathParams && birFuncParam.isPathParameter) {
                if (resourcePathArgs.isEmpty()) {
                    ++jMethodParamIndex;
                }
                resourcePathArgs.add(argRef);
                ++birFuncParamIndex;
                continue;
            }
            if (jMethod.hasBundledFunctionParams && !birFuncParam.isPathParameter) {
                if (functionArgs.isEmpty()) {
                    ++jMethodParamIndex;
                }
                functionArgs.add(argRef);
                ++birFuncParamIndex;
                continue;
            }
            JType jPType = JInterop.getJType(jMethodParamTypes[jMethodParamIndex]);
            if (!isVarArg && !InteropMethodGen.isMatchingBAndJType(bPType, jPType)) {
                String varName = "$_param_jobject_var" + birFuncParamIndex + "_$";
                BIRNode.BIRVariableDcl paramVarDcl = new BIRNode.BIRVariableDcl(jPType, new Name(varName), null, VarKind.LOCAL);
                birFunc.localVars.add(paramVarDcl);
                BIROperand bIROperand = new BIROperand(paramVarDcl);
                JCast jToBCast = new JCast(birFunc.pos);
                jToBCast.lhsOp = bIROperand;
                jToBCast.rhsOp = argRef;
                jToBCast.targetType = jPType;
                argRef = bIROperand;
                beginBB.instructions.add(jToBCast);
            }
            if (isVarArg) {
                varArgType = jPType;
            }
            args.add(argRef);
            ++birFuncParamIndex;
            ++jMethodParamIndex;
        }
        int invocationType = 184;
        if (jMethod.kind == JMethodKind.METHOD && !jMethod.isStatic()) {
            invocationType = jMethod.isDeclaringClassInterface() ? 185 : 182;
        } else if (jMethod.kind != JMethodKind.METHOD || !jMethod.isStatic()) {
            invocationType = 183;
        }
        BIROperand jRetVarRef = null;
        BIRNode.BIRBasicBlock thenBB = BirDesugar.insertAndGetNextBasicBlock(birFunc.basicBlocks, initMethodGen);
        BIRNode.BIRBasicBlock retBB = new BIRNode.BIRBasicBlock(BirDesugar.getNextDesugarBBId(initMethodGen));
        thenBB.terminator = new BIRTerminator.GOTO(birFunc.pos, retBB);
        BIROperand retRef = new BIROperand((BIRNode.BIRVariableDcl)birFunc.localVars.getFirst());
        if (JvmCodeGenUtil.getImpliedType((BType)retType).tag != 10 && JType.J_VOID != jMethodRetType) {
            BIROperand castVarRef;
            BIRNode.BIRVariableDcl retJObjectVarDcl = new BIRNode.BIRVariableDcl(jMethodRetType, new Name("$_ret_jobject_var_$"), null, VarKind.LOCAL);
            birFunc.localVars.add(retJObjectVarDcl);
            jRetVarRef = castVarRef = new BIROperand(retJObjectVarDcl);
            JCast jCast = new JCast(birFunc.pos);
            jCast.lhsOp = retRef;
            jCast.rhsOp = castVarRef;
            jCast.targetType = retType;
            thenBB.instructions.add(jCast);
        }
        BIRNode.BIRBasicBlock catchBB = new BIRNode.BIRBasicBlock(BirDesugar.getNextDesugarBBId(initMethodGen));
        JErrorEntry ee = new JErrorEntry(beginBB, thenBB, retRef, catchBB);
        for (Class<?> exception : birFunc.jMethod.getExceptionTypes()) {
            BIRTerminator.Return exceptionRet = new BIRTerminator.Return(birFunc.pos);
            CatchIns catchIns = new CatchIns();
            catchIns.errorClass = exception.getName().replace(".", "/");
            catchIns.term = exceptionRet;
            ee.catchIns.add(catchIns);
        }
        birFunc.errorTable.add(ee);
        if (jMethod.kind == JMethodKind.CONSTRUCTOR) {
            JIConstructorCall jIConstructorCall = new JIConstructorCall(birFunc.pos);
            jIConstructorCall.args = args;
            jIConstructorCall.receiver = receiverOp;
            jIConstructorCall.resourcePathArgs = resourcePathArgs;
            jIConstructorCall.functionArgs = functionArgs;
            jIConstructorCall.varArgExist = birFunc.restParam != null;
            jIConstructorCall.varArgType = varArgType;
            jIConstructorCall.lhsOp = jRetVarRef;
            jIConstructorCall.jClassName = jMethod.getClassName().replace(".", "/");
            jIConstructorCall.name = jMethod.getName();
            jIConstructorCall.jMethodVMSig = jMethod.getSignature();
            jIConstructorCall.thenBB = thenBB;
            beginBB.terminator = jIConstructorCall;
        } else {
            JIMethodCall jIMethodCall = new JIMethodCall(birFunc.pos);
            jIMethodCall.args = args;
            jIMethodCall.receiver = receiverOp;
            jIMethodCall.resourcePathArgs = resourcePathArgs;
            jIMethodCall.functionArgs = functionArgs;
            jIMethodCall.varArgExist = birFunc.restParam != null;
            jIMethodCall.varArgType = varArgType;
            jIMethodCall.lhsOp = jRetVarRef;
            jIMethodCall.jClassName = jMethod.getClassName().replace(".", "/");
            jIMethodCall.name = jMethod.getName();
            jIMethodCall.jMethodVMSig = jMethod.getSignature();
            jIMethodCall.invocationType = invocationType;
            jIMethodCall.thenBB = thenBB;
            beginBB.terminator = jIMethodCall;
        }
        birFunc.basicBlocks.add(retBB);
        retBB.terminator = new BIRTerminator.Return(birFunc.pos);
    }

    private static boolean isMatchingBAndJType(BType sourceType, JType targetType) {
        int sourceTypeTag = JvmCodeGenUtil.getImpliedType((BType)sourceType).tag;
        return TypeTags.isIntegerTypeTag(sourceTypeTag) && targetType.jTag == 5 || sourceTypeTag == 3 && targetType.jTag == 7 || sourceTypeTag == 6 && targetType.jTag == 8;
    }

    private static void performWideningPrimitiveConversion(MethodVisitor mv, BType bType, JType jType) {
        int typeTag = JvmCodeGenUtil.getImpliedType((BType)bType).tag;
        if (!(TypeTags.isIntegerTypeTag(typeTag) && jType.jTag == 5 || typeTag == 3 && jType.jTag == 7)) {
            if (TypeTags.isIntegerTypeTag(typeTag)) {
                mv.visitInsn(133);
            } else if (typeTag == 3) {
                if (jType.jTag == 5) {
                    mv.visitInsn(138);
                } else if (jType.jTag == 6) {
                    mv.visitInsn(141);
                } else {
                    mv.visitInsn(135);
                }
            }
        }
    }

    private static void loadMethodParamToStackInInteropFunction(MethodVisitor mv, BIRNode.BIRFunctionParameter birFuncParam, JType jMethodParamType, int localVarIndex, JvmInstructionGen jvmInstructionGen, JvmCastGen jvmCastGen) {
        BType bFuncParamType = birFuncParam.type;
        jvmInstructionGen.generateVarLoad(mv, birFuncParam);
        jvmCastGen.generateBToJCheckCast(mv, bFuncParamType, jMethodParamType);
    }

    public static String getJTypeSignature(JType jType) {
        if (jType.jTag == 10) {
            return "L" + ((JType.JRefType)jType).typeValue + ";";
        }
        if (jType.jTag == 9) {
            JType eType = ((JType.JArrayType)jType).elementType;
            return "[" + InteropMethodGen.getJTypeSignature(eType);
        }
        return switch (jType.jTag) {
            case 1 -> "B";
            case 2 -> "C";
            case 3 -> "S";
            case 4 -> "I";
            case 5 -> "J";
            case 6 -> "F";
            case 7 -> "D";
            case 8 -> "Z";
            default -> throw new BLangCompilerException("invalid element type: " + String.valueOf(jType));
        };
    }

    public static String getSignatureForJType(JType jType) {
        if (jType.jTag == 10) {
            return ((JType.JRefType)jType).typeValue;
        }
        if (jType.jTag == 9) {
            JType eType = ((JType.JArrayType)jType).elementType;
            StringBuilder sig = new StringBuilder("[");
            while (eType.jTag == 9) {
                eType = ((JType.JArrayType)eType).elementType;
                sig.append("[");
            }
            return switch (eType.jTag) {
                case 10 -> String.valueOf(sig) + "L" + InteropMethodGen.getSignatureForJType(eType) + ";";
                case 1 -> String.valueOf(sig) + "B";
                case 2 -> String.valueOf(sig) + "C";
                case 3 -> String.valueOf(sig) + "S";
                case 4 -> String.valueOf(sig) + "I";
                case 5 -> String.valueOf(sig) + "J";
                case 6 -> String.valueOf(sig) + "F";
                case 7 -> String.valueOf(sig) + "D";
                case 8 -> String.valueOf(sig) + "Z";
                default -> throw new BLangCompilerException("invalid element type: " + String.valueOf(eType));
            };
        }
        throw new BLangCompilerException("invalid element type: " + String.valueOf(jType));
    }

    public static void genVarArg(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, BType bType, JType jvmType, int varArgIndex, SymbolTable symbolTable, JvmCastGen jvmCastGen) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        if (jvmType.jTag != 9 || bType.tag != 20) {
            throw new BLangCompilerException("invalid type for var-arg: " + String.valueOf(jvmType));
        }
        JType jElementType = ((JType.JArrayType)jvmType).elementType;
        BType bElementType = ((BArrayType)bType).eType;
        int varArgsLenVarIndex = indexMap.addIfNotExists("$varArgsLen", symbolTable.intType);
        int indexVarIndex = indexMap.addIfNotExists("$index", symbolTable.intType);
        int valueArrayIndex = indexMap.addIfNotExists("$valueArray", symbolTable.anyType);
        mv.visitVarInsn(25, varArgIndex);
        mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "size", "()I", true);
        mv.visitInsn(89);
        mv.visitVarInsn(54, varArgsLenVarIndex);
        InteropMethodGen.genArrayNew(mv, jElementType);
        mv.visitVarInsn(58, valueArrayIndex);
        mv.visitInsn(3);
        mv.visitVarInsn(54, indexVarIndex);
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitLabel(l1);
        mv.visitVarInsn(21, indexVarIndex);
        mv.visitVarInsn(21, varArgsLenVarIndex);
        mv.visitJumpInsn(162, l2);
        mv.visitVarInsn(25, valueArrayIndex);
        mv.visitVarInsn(21, indexVarIndex);
        mv.visitVarInsn(25, varArgIndex);
        mv.visitVarInsn(21, indexVarIndex);
        mv.visitInsn(133);
        int elementTypeTag = JvmCodeGenUtil.getImpliedType((BType)bElementType).tag;
        if (TypeTags.isIntegerTypeTag(elementTypeTag)) {
            mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getInt", "(J)J", true);
        } else if (TypeTags.isStringTypeTag(elementTypeTag)) {
            mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getBString", "(J)Lio/ballerina/runtime/api/values/BString;", true);
        } else {
            switch (elementTypeTag) {
                case 6: {
                    mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getBoolean", "(J)Z", true);
                    break;
                }
                case 2: {
                    mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getByte", "(J)B", true);
                    break;
                }
                case 3: {
                    mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getFloat", "(J)D", true);
                    break;
                }
                case 37: {
                    mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getRefValue", "(J)Ljava/lang/Object;", true);
                    mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/HandleValue");
                    break;
                }
                default: {
                    mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getRefValue", "(J)Ljava/lang/Object;", true);
                }
            }
        }
        jvmCastGen.generateBToJCheckCast(mv, bElementType, jElementType);
        InteropMethodGen.genArrayStore(mv, jElementType);
        mv.visitIincInsn(indexVarIndex, 1);
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, valueArrayIndex);
    }

    private static void genArrayStore(MethodVisitor mv, JType jType) {
        int code = switch (jType.jTag) {
            case 4 -> 79;
            case 5 -> 80;
            case 7 -> 82;
            case 1, 8 -> 84;
            case 3 -> 86;
            case 2 -> 85;
            case 6 -> 81;
            default -> 83;
        };
        mv.visitInsn(code);
    }

    private static void genArrayNew(MethodVisitor mv, JType elementType) {
        switch (elementType.jTag) {
            case 4: {
                mv.visitIntInsn(188, 10);
                break;
            }
            case 5: {
                mv.visitIntInsn(188, 11);
                break;
            }
            case 7: {
                mv.visitIntInsn(188, 7);
                break;
            }
            case 1: 
            case 8: {
                mv.visitIntInsn(188, 4);
                break;
            }
            case 3: {
                mv.visitIntInsn(188, 9);
                break;
            }
            case 2: {
                mv.visitIntInsn(188, 5);
                break;
            }
            case 6: {
                mv.visitIntInsn(188, 6);
                break;
            }
            case 9: 
            case 10: {
                mv.visitTypeInsn(189, InteropMethodGen.getSignatureForJType(elementType));
                break;
            }
            default: {
                throw new BLangCompilerException("invalid type for var-arg: " + String.valueOf(elementType));
            }
        }
    }

    private InteropMethodGen() {
    }
}

