/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import io.ballerina.projects.CompilerBackend;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.PlatformLibrary;
import io.ballerina.projects.PlatformLibraryScope;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.bir.codegen.exceptions.JInteropException;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.AnnotationProc;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidationRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JFieldMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodResolver;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JFieldBIRFunction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethodBIRFunction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JavaField;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class InteropValidator {
    private static final CompilerContext.Key<InteropValidator> INTEROP_VALIDATE = new CompilerContext.Key();
    private final SymbolTable symbolTable;
    private final BLangDiagnosticLog dlog;

    private InteropValidator(CompilerContext compilerContext) {
        compilerContext.put(INTEROP_VALIDATE, this);
        this.symbolTable = SymbolTable.getInstance(compilerContext);
        this.dlog = BLangDiagnosticLog.getInstance(compilerContext);
    }

    public static InteropValidator getInstance(CompilerContext context) {
        InteropValidator interopValidator = context.get(INTEROP_VALIDATE);
        if (interopValidator == null) {
            interopValidator = new InteropValidator(context);
        }
        return interopValidator;
    }

    public void validate(ModuleId moduleId, CompilerBackend compilerBackend, BLangPackage bLangPackage) {
        this.dlog.setCurrentPackageId(bLangPackage.packageID);
        this.validateModulePackages(moduleId, compilerBackend, bLangPackage);
        this.validateTestPackages(moduleId, compilerBackend, bLangPackage);
    }

    private void validateModulePackages(ModuleId moduleId, CompilerBackend compilerBackend, BLangPackage bLangPackage) {
        Set<Path> moduleDependencyPaths = this.getPlatformDependencyPaths(moduleId, compilerBackend, PlatformLibraryScope.DEFAULT);
        moduleDependencyPaths.addAll(this.getPlatformDependencyPaths(moduleId, compilerBackend, PlatformLibraryScope.PROVIDED));
        Path runtimeJar = compilerBackend.runtimeLibrary().path();
        if (Files.exists(runtimeJar, new LinkOption[0])) {
            moduleDependencyPaths.add(runtimeJar);
        }
        ClassLoader classLoader = this.makeClassLoader(moduleDependencyPaths);
        BIRNode.BIRPackage birPackage = bLangPackage.symbol.bir;
        this.validateFunctions(classLoader, birPackage);
    }

    private void validateTestPackages(ModuleId moduleId, CompilerBackend compilerBackend, BLangPackage bLangPackage) {
        if (bLangPackage.moduleContextDataHolder.skipTests() || !bLangPackage.hasTestablePackage()) {
            return;
        }
        Set<Path> testDependencies = this.getPlatformDependencyPaths(moduleId, compilerBackend, PlatformLibraryScope.DEFAULT);
        testDependencies.addAll(this.getPlatformDependencyPaths(moduleId, compilerBackend, PlatformLibraryScope.PROVIDED));
        testDependencies.addAll(this.getPlatformDependencyPaths(moduleId, compilerBackend, PlatformLibraryScope.TEST_ONLY));
        Path runtimeJar = compilerBackend.runtimeLibrary().path();
        if (Files.exists(runtimeJar, new LinkOption[0])) {
            testDependencies.add(runtimeJar);
        }
        ClassLoader classLoader = this.makeClassLoader(testDependencies);
        bLangPackage.getTestablePkgs().forEach(testablePackage -> {
            BIRNode.BIRPackage testBirPackage = testablePackage.symbol.bir;
            this.validateFunctions(classLoader, testBirPackage);
        });
    }

    private void validateFunctions(ClassLoader classLoader, BIRNode.BIRPackage testBirPackage) {
        this.validateModuleFunctions(testBirPackage, classLoader);
        this.validateTypeAttachedFunctions(testBirPackage, classLoader);
    }

    private Set<Path> getPlatformDependencyPaths(ModuleId moduleId, CompilerBackend compilerBackend, PlatformLibraryScope scope) {
        return this.getPlatformDependencyPaths(compilerBackend.platformLibraryDependencies(moduleId.packageId(), scope));
    }

    public Set<Path> getPlatformDependencyPaths(Collection<PlatformLibrary> platformLibraries) {
        HashSet<Path> set = new HashSet<Path>();
        for (PlatformLibrary platformLibrary : platformLibraries) {
            Path path = platformLibrary.path();
            set.add(path);
        }
        return set;
    }

    private void validateModuleFunctions(BIRNode.BIRPackage module, ClassLoader classLoader) {
        List<BIRNode.BIRFunction> functions = module.functions;
        ArrayList<BIRNode.BIRFunction> jBirFunctions = new ArrayList<BIRNode.BIRFunction>(functions.size());
        for (BIRNode.BIRFunction func : functions) {
            try {
                jBirFunctions.add(this.getBirFunction(func, classLoader));
            }
            catch (JInteropException e) {
                this.dlog.error(func.pos, e.getCode(), e.getMessage());
            }
        }
        module.functions.clear();
        module.functions.addAll(jBirFunctions);
    }

    private void validateTypeAttachedFunctions(BIRNode.BIRPackage module, ClassLoader classLoader) {
        List<BIRNode.BIRTypeDefinition> typeDefs = module.typeDefs;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            List<BIRNode.BIRFunction> attachedFuncs = optionalTypeDef.attachedFuncs;
            ArrayList<BIRNode.BIRFunction> jAttachedFuncs = new ArrayList<BIRNode.BIRFunction>(attachedFuncs.size());
            for (BIRNode.BIRFunction func : attachedFuncs) {
                try {
                    jAttachedFuncs.add(this.getBirFunction(func, classLoader));
                }
                catch (JInteropException e) {
                    this.dlog.error(func.pos, e.getCode(), e.getMessage());
                }
                optionalTypeDef.attachedFuncs = jAttachedFuncs;
            }
        }
    }

    private ClassLoader makeClassLoader(Set<Path> moduleDependencies) {
        if (moduleDependencies == null || moduleDependencies.isEmpty()) {
            return Thread.currentThread().getContextClassLoader();
        }
        ArrayList<URL> dependentJars = new ArrayList<URL>();
        for (Path dependency : moduleDependencies) {
            try {
                dependentJars.add(dependency.toUri().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return new URLClassLoader(dependentJars.toArray(new URL[0]), ClassLoader.getPlatformClassLoader());
    }

    JMethod validateAndGetJMethod(InteropValidationRequest.MethodValidationRequest methodValidationRequest, ClassLoader classLoader) {
        JMethodRequest jMethodRequest = JMethodRequest.build(this.symbolTable.typeEnv(), methodValidationRequest, classLoader);
        JMethodResolver methodResolver = new JMethodResolver(classLoader, this.symbolTable);
        return methodResolver.resolve(jMethodRequest);
    }

    private BIRNode.BIRFunction getBirFunction(BIRNode.BIRFunction birFunc, ClassLoader classLoader) {
        InteropValidationRequest jInteropValidationReq;
        if (JvmCodeGenUtil.isExternFunc(birFunc) && (jInteropValidationReq = AnnotationProc.getInteropAnnotValue(birFunc)) != null) {
            return this.createJInteropFunction(jInteropValidationReq, birFunc, classLoader);
        }
        return birFunc;
    }

    BIRNode.BIRFunction createJInteropFunction(InteropValidationRequest jInteropValidationReq, BIRNode.BIRFunction birFunc, ClassLoader classLoader) {
        if (jInteropValidationReq instanceof InteropValidationRequest.MethodValidationRequest) {
            InteropValidationRequest.MethodValidationRequest methodValidationRequest = (InteropValidationRequest.MethodValidationRequest)jInteropValidationReq;
            methodValidationRequest.restParamExist = birFunc.restParam != null;
            JMethod jMethod = this.validateAndGetJMethod(methodValidationRequest, classLoader);
            return new JMethodBIRFunction(birFunc, jMethod);
        }
        InteropValidationRequest.FieldValidationRequest fieldValidationRequest = (InteropValidationRequest.FieldValidationRequest)jInteropValidationReq;
        JavaField jField = this.validateAndGetJField(fieldValidationRequest, classLoader);
        return new JFieldBIRFunction(birFunc, jField);
    }

    JavaField validateAndGetJField(InteropValidationRequest.FieldValidationRequest fieldValidationRequest, ClassLoader classLoader) {
        JavaField javaField;
        JFieldMethod method = fieldValidationRequest.fieldMethod;
        String className = fieldValidationRequest.klass;
        Class<?> clazz = JInterop.loadClass(className, classLoader);
        String fieldName = fieldValidationRequest.name;
        try {
            Field field = clazz.getField(fieldName);
            javaField = new JavaField(method, field);
        }
        catch (NoSuchFieldException e) {
            throw new JInteropException(DiagnosticErrorCode.FIELD_NOT_FOUND, "No such field '" + fieldName + "' found in class '" + className + "'");
        }
        if (javaField.isStatic()) {
            this.validateJStaticField(method, fieldValidationRequest.bFuncType.paramTypes.size(), fieldName, className);
        } else {
            this.validateJInstanceField(method, fieldValidationRequest.bFuncType.paramTypes, fieldName, className);
        }
        return javaField;
    }

    void validateJStaticField(JFieldMethod method, int bFuncParamCount, String fieldName, String className) {
        if (method == JFieldMethod.MUTATE) {
            if (bFuncParamCount != 1) {
                throw new JInteropException(DiagnosticErrorCode.INVALID_NUMBER_OF_PARAMETERS, "One parameter is required to set the value to the static field '" + fieldName + "' in class '" + className + "'");
            }
        } else if (bFuncParamCount != 0) {
            throw new JInteropException(DiagnosticErrorCode.INVALID_NUMBER_OF_PARAMETERS, "No parameter is required to get the value of the static field '" + fieldName + "' in class '" + className + "'");
        }
    }

    void validateJInstanceField(JFieldMethod method, List<BType> bFuncParamTypes, String fieldName, String className) {
        int bFuncParamCount = bFuncParamTypes.size();
        if (method == JFieldMethod.MUTATE) {
            if (bFuncParamCount != 2) {
                throw new JInteropException(DiagnosticErrorCode.INVALID_NUMBER_OF_PARAMETERS, "Two parameters are required to set the value to the instance field '" + fieldName + "' in class '" + className + "'");
            }
            if (bFuncParamTypes.getFirst().tag != 37) {
                throw new JInteropException(DiagnosticErrorCode.INVALID_PARAMETER_TYPE, "First parameter needs to be of the handle type to set the value to the instance field '" + fieldName + "' in class '" + className + "'");
            }
        } else {
            if (bFuncParamCount != 1) {
                throw new JInteropException(DiagnosticErrorCode.INVALID_NUMBER_OF_PARAMETERS, "One parameter is required to get the value of the instance field '" + fieldName + "' in class '" + className + "'");
            }
            if (bFuncParamTypes.getFirst().tag != 37) {
                throw new JInteropException(DiagnosticErrorCode.INVALID_PARAMETER_TYPE, "The parameter needs to be of the handle type to get the value of the instance field '" + fieldName + "' in class '" + className + "'");
            }
        }
    }
}

