/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BFuture;
import io.ballerina.runtime.api.values.BHandle;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BRegexpValue;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.bir.codegen.exceptions.JInteropException;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ParamTypeConstraint;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethodKind;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.TypeTags;

class JMethodResolver {
    private final ClassLoader classLoader;
    private final SymbolTable symbolTable;
    private final BType[] definedReadOnlyMemberTypes;

    JMethodResolver(ClassLoader classLoader, SymbolTable symbolTable) {
        this.classLoader = classLoader;
        this.symbolTable = symbolTable;
        this.definedReadOnlyMemberTypes = new BType[]{symbolTable.nilType, symbolTable.booleanType, symbolTable.intType, symbolTable.signed8IntType, symbolTable.signed16IntType, symbolTable.signed32IntType, symbolTable.unsigned32IntType, symbolTable.unsigned16IntType, symbolTable.unsigned8IntType, symbolTable.floatType, symbolTable.decimalType, symbolTable.stringType, symbolTable.charStringType};
    }

    JMethod resolve(JMethodRequest jMethodRequest) {
        List<JMethod> jMethods = this.resolveByMethodName(jMethodRequest.declaringClass, jMethodRequest.methodName, jMethodRequest.kind);
        if (jMethods.isEmpty()) {
            if (jMethodRequest.kind == JMethodKind.CONSTRUCTOR) {
                throw new JInteropException(DiagnosticErrorCode.CONSTRUCTOR_NOT_FOUND, "No such public constructor found in class '" + jMethodRequest.declaringClass.getName() + "'");
            }
            throw new JInteropException(DiagnosticErrorCode.METHOD_NOT_FOUND, "No such public method '" + jMethodRequest.methodName + "' found in class '" + jMethodRequest.declaringClass.getName() + "'");
        }
        if ((jMethods = this.resolveByParamCount(jMethods, jMethodRequest)).isEmpty()) {
            this.throwMethodNotFoundError(jMethodRequest);
        }
        JMethod jMethod = this.resolve(jMethodRequest, jMethods);
        this.validateMethodSignature(jMethodRequest, jMethod);
        return jMethod;
    }

    private List<JMethod> resolveByMethodName(Class<?> declaringClass, String methodName, JMethodKind kind) {
        ArrayList<JMethod> list = new ArrayList<JMethod>();
        for (Executable executable : this.getExecutables(declaringClass, methodName, kind)) {
            JMethod build = JMethod.build(kind, executable, null);
            list.add(build);
        }
        return list;
    }

    private List<JMethod> resolveByParamCount(List<JMethod> jMethods, JMethodRequest jMethodRequest) {
        ArrayList<JMethod> list = new ArrayList<JMethod>();
        for (JMethod jMethod : jMethods) {
            if (!this.hasEqualParamCounts(jMethodRequest, jMethod) && !this.hasEquivalentPathAndFunctionParamCount(jMethodRequest, jMethod) && !this.hasEquivalentPathParamCount(jMethodRequest, jMethod) && !this.hasEquivalentFunctionParamCount(jMethodRequest, jMethod)) continue;
            list.add(jMethod);
        }
        return list;
    }

    private boolean hasEqualParamCounts(JMethodRequest jMethodRequest, JMethod jMethod) {
        int expectedCount = this.getBFuncParamCount(jMethodRequest, jMethod);
        int count = jMethod.getParamTypes().length;
        if (count == expectedCount) {
            return true;
        }
        if (count == expectedCount + 1) {
            if (jMethod.isBalEnvAcceptingMethod()) {
                return true;
            }
            jMethod.setReceiverType(jMethodRequest.receiverType);
            return jMethodRequest.receiverType != null;
        }
        if (count == expectedCount + 2) {
            if (jMethodRequest.receiverType != null) {
                jMethod.setReceiverType(jMethodRequest.receiverType);
            }
            return jMethod.isBalEnvAcceptingMethod();
        }
        return false;
    }

    private boolean hasEquivalentPathAndFunctionParamCount(JMethodRequest jMethodRequest, JMethod jMethod) {
        Class<?>[] paramTypes = jMethod.getParamTypes();
        int count = paramTypes.length;
        if (jMethodRequest.receiverType == null || jMethodRequest.pathParamCount == 0 || count < 3 || count > 4) {
            return false;
        }
        if (!this.isParamAssignableToBArray(paramTypes[count - 1]) || !this.isParamAssignableToBArray(paramTypes[count - 2]) || this.isFirstPathParamARestParam(jMethodRequest, jMethod) || this.isFunctionParamARestParam(jMethodRequest, jMethod)) {
            return false;
        }
        if (count == 3) {
            jMethod.setReceiverType(jMethodRequest.receiverType);
            return true;
        }
        jMethod.setReceiverType(jMethodRequest.receiverType);
        return jMethod.isBalEnvAcceptingMethod();
    }

    private boolean hasEquivalentPathParamCount(JMethodRequest jMethodRequest, JMethod jMethod) {
        int reducedParamCount;
        if (jMethodRequest.receiverType == null || jMethodRequest.pathParamCount == 0 || this.isFirstPathParamARestParam(jMethodRequest, jMethod)) {
            return false;
        }
        Class<?>[] paramTypes = jMethod.getParamTypes();
        int count = paramTypes.length;
        if (count < (reducedParamCount = this.getBundledPathParamCount(jMethodRequest, jMethod)) || count > reducedParamCount + 2) {
            return false;
        }
        if (count == reducedParamCount && paramTypes.length > 0 && this.isParamAssignableToBArray(paramTypes[0])) {
            return true;
        }
        if (count == reducedParamCount + 1 && paramTypes.length > 1 && this.isParamAssignableToBArray(paramTypes[1])) {
            jMethod.setReceiverType(jMethodRequest.receiverType);
            return true;
        }
        if (count == reducedParamCount + 2 && paramTypes.length > 2 && this.isParamAssignableToBArray(paramTypes[2])) {
            jMethod.setReceiverType(jMethodRequest.receiverType);
            return jMethod.isBalEnvAcceptingMethod();
        }
        return false;
    }

    private boolean hasEquivalentFunctionParamCount(JMethodRequest jMethodRequest, JMethod jMethod) {
        Class<?>[] paramTypes = jMethod.getParamTypes();
        int count = paramTypes.length;
        int reducedParamCount = jMethodRequest.pathParamCount + 1;
        int functionParamCount = this.getBFuncParamCount(jMethodRequest, jMethod) - jMethodRequest.pathParamCount;
        if (jMethodRequest.receiverType == null || functionParamCount < 1 || count < reducedParamCount || count > reducedParamCount + 2 || Symbols.isFlagOn(jMethodRequest.bParamTypes[0].getFlags(), 262144L)) {
            return false;
        }
        if (!this.isParamAssignableToBArray(paramTypes[count - 1]) || this.isFunctionParamARestParam(jMethodRequest, jMethod)) {
            return false;
        }
        if (count == reducedParamCount) {
            return true;
        }
        if (count == reducedParamCount + 1) {
            jMethod.setReceiverType(jMethodRequest.receiverType);
            return true;
        }
        if (count == reducedParamCount + 2) {
            jMethod.setReceiverType(jMethodRequest.receiverType);
            return jMethod.isBalEnvAcceptingMethod();
        }
        return false;
    }

    private boolean isParamAssignableToBArray(Class<?> paramType) {
        try {
            return this.classLoader.loadClass(BArray.class.getCanonicalName()).isAssignableFrom(paramType);
        }
        catch (ClassNotFoundException e) {
            throw new JInteropException(DiagnosticErrorCode.CLASS_NOT_FOUND, e.getMessage(), e);
        }
    }

    private JMethod resolve(JMethodRequest jMethodRequest, List<JMethod> jMethods) {
        JMethod jMethod;
        boolean noConstraints = this.noConstraintsSpecified(jMethodRequest.paramTypeConstraints);
        if (jMethods.size() == 1 && noConstraints) {
            return jMethods.getFirst();
        }
        if (noConstraints) {
            if (this.areAllMethodsOverridden(jMethods, jMethodRequest.declaringClass)) {
                return jMethods.getFirst();
            }
            this.throwOverloadedMethodError(jMethodRequest, jMethods.getFirst().getParamTypes().length);
        }
        if ((jMethod = this.resolveExactMethod(jMethodRequest.declaringClass, jMethodRequest.methodName, jMethodRequest.kind, jMethodRequest.paramTypeConstraints, jMethodRequest.receiverType)) == JMethod.NO_SUCH_METHOD) {
            return this.resolveMatchingMethod(jMethodRequest, jMethods);
        }
        return jMethod;
    }

    private boolean areAllMethodsOverridden(List<JMethod> jMethods, Class<?> clazz) {
        if (jMethods.getFirst().getKind() == JMethodKind.CONSTRUCTOR) {
            return false;
        }
        for (int i = 0; i < jMethods.size(); ++i) {
            Method method1 = (Method)jMethods.get(i).getMethod();
            for (int k = i + 1; k < jMethods.size(); ++k) {
                Method method2 = (Method)jMethods.get(k).getMethod();
                if (this.isOverridden(method1, method2, clazz)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isOverridden(Method method1, Method method2, Class<?> clazz) {
        Method otherMethod;
        Method currentMethod;
        if (method1.getParameterCount() != method2.getParameterCount()) {
            throw new JInteropException(DiagnosticErrorCode.OVERLOADED_METHODS, "Overloaded methods cannot be differentiated. Please specify the parameter types for each parameter in 'paramTypes' field in the annotation");
        }
        if (method2.getReturnType().isAssignableFrom(method1.getReturnType())) {
            currentMethod = method1;
            otherMethod = method2;
        } else if (method1.getReturnType().isAssignableFrom(method2.getReturnType())) {
            currentMethod = method2;
            otherMethod = method1;
        } else {
            return false;
        }
        try {
            Method superMethod = clazz.getSuperclass().getDeclaredMethod(currentMethod.getName(), currentMethod.getParameterTypes());
            return Arrays.equals(superMethod.getParameterTypes(), otherMethod.getParameterTypes()) && superMethod.getReturnType().equals(otherMethod.getReturnType());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private void validateMethodSignature(JMethodRequest jMethodRequest, JMethod jMethod) {
        this.validateExceptionTypes(jMethodRequest, jMethod);
        this.validateArgumentTypes(jMethodRequest, jMethod);
        this.validateReturnTypes(jMethodRequest, jMethod);
    }

    private void validateExceptionTypes(JMethodRequest jMethodRequest, JMethod jMethod) {
        Executable method = jMethod.getMethod();
        boolean throwsCheckedException = false;
        try {
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                if (this.classLoader.loadClass(RuntimeException.class.getCanonicalName()).isAssignableFrom(exceptionType)) continue;
                throwsCheckedException = true;
                break;
            }
            boolean returnsErrorValue = method instanceof Method && (this.classLoader.loadClass(BError.class.getCanonicalName()).isAssignableFrom(((Method)method).getReturnType()) || this.classLoader.loadClass(Object.class.getCanonicalName()).isAssignableFrom(((Method)method).getReturnType()));
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticErrorCode.CLASS_NOT_FOUND, e.getMessage(), e);
        }
        BType returnType = jMethodRequest.bReturnType;
        if (throwsCheckedException && !jMethodRequest.returnsBErrorType) {
            String expectedRetTypeName = this.getExpectedReturnType(returnType);
            throw new JInteropException(DiagnosticErrorCode.METHOD_SIGNATURE_DOES_NOT_MATCH, "Incompatible ballerina return type for Java method '" + jMethodRequest.methodName + "' which throws checked exception found in class '" + jMethodRequest.declaringClass.getName() + "': expected '" + expectedRetTypeName + "', found '" + String.valueOf(returnType) + "'");
        }
    }

    private String getExpectedReturnType(BType retType) {
        if (retType.tag == 10 || retType instanceof BTypeReferenceType && ((BTypeReferenceType)retType).referredType.tag == 29) {
            return "error";
        }
        if (retType instanceof BUnionType) {
            BUnionType bUnionReturnType = (BUnionType)retType;
            BUnionType modifiedRetType = BUnionType.create(this.symbolTable.typeEnv(), null, this.getNonErrorMembers(bUnionReturnType));
            return String.valueOf(modifiedRetType) + "|error";
        }
        return String.valueOf(retType) + "|error";
    }

    private LinkedHashSet<BType> getNonErrorMembers(BUnionType bUnionReturnType) {
        LinkedHashSet<BType> memTypes = new LinkedHashSet<BType>();
        for (BType bType : bUnionReturnType.getMemberTypes()) {
            if (bType.tag == 29 || bType instanceof BTypeReferenceType && ((BTypeReferenceType)bType).referredType.tag == 29) continue;
            memTypes.add(bType);
        }
        return memTypes;
    }

    private void validateArgumentTypes(JMethodRequest jMethodRequest, JMethod jMethod) {
        BType bParamType;
        Class<?>[] jParamTypes = jMethod.getParamTypes();
        if (this.hasEquivalentPathAndFunctionParamCount(jMethodRequest, jMethod)) {
            this.bundleBothPathAndFunctionParameter(jMethodRequest, jMethod);
        } else if (this.hasEquivalentPathParamCount(jMethodRequest, jMethod)) {
            this.bundlePathParams(jMethodRequest, jMethod);
        } else if (this.hasEquivalentFunctionParamCount(jMethodRequest, jMethod)) {
            this.bundleFunctionParams(jMethodRequest, jMethod);
        }
        BType[] bParamTypes = jMethodRequest.bParamTypes;
        int bParamCount = bParamTypes.length;
        int i = 0;
        int j = 0;
        if (jMethod.getReceiverType() != null) {
            Class<?> jParamType = jMethod.isBalEnvAcceptingMethod() ? jParamTypes[1] : jParamTypes[0];
            if (this.isInvalidParamBType(jParamType, bParamType = jMethod.getReceiverType(), false, jMethodRequest.restParamExist)) {
                this.throwNoSuchMethodError(jMethodRequest.methodName, jParamType, bParamType, jMethodRequest.declaringClass);
            }
            ++bParamCount;
            ++j;
        }
        if (jMethod.isInstanceMethod()) {
            if (bParamCount != jParamTypes.length + 1) {
                if (jMethod.isBalEnvAcceptingMethod()) {
                    ++j;
                } else {
                    this.throwParamCountMismatchError(jMethodRequest);
                }
            }
            int receiverIndex = 0;
            if (!jMethodRequest.pathParamSymbols.isEmpty()) {
                receiverIndex = jMethodRequest.pathParamCount;
            }
            BType receiverType = bParamTypes[receiverIndex];
            if (receiverType.tag != 37) {
                this.throwMethodNotFoundError(jMethodRequest);
            }
            for (int k = receiverIndex; k < bParamTypes.length - 1; ++k) {
                bParamTypes[k] = bParamTypes[k + 1];
            }
            BType[] bParamTypesWithoutReceiver = new BType[bParamTypes.length - 1];
            System.arraycopy(bParamTypes, 0, bParamTypesWithoutReceiver, 0, bParamTypesWithoutReceiver.length);
            bParamTypes = bParamTypesWithoutReceiver;
        } else if (bParamCount != jParamTypes.length) {
            if (jMethod.isBalEnvAcceptingMethod()) {
                ++j;
            } else {
                this.throwParamCountMismatchError(jMethodRequest);
            }
        }
        for (int k = j; k < jParamTypes.length; ++k) {
            boolean isLastPram;
            bParamType = bParamTypes[i];
            Class<?> jParamType = jParamTypes[k];
            boolean bl = isLastPram = jParamTypes.length == k + 1;
            if (this.isInvalidParamBType(jParamType, bParamType, isLastPram, jMethodRequest.restParamExist)) {
                this.throwNoSuchMethodError(jMethodRequest.methodName, jParamType, bParamType, jMethodRequest.declaringClass);
            }
            ++i;
        }
    }

    private void bundlePathParams(JMethodRequest jMethodRequest, JMethod jMethod) {
        List<BVarSymbol> pathParamSymbols = jMethodRequest.pathParamSymbols;
        if (pathParamSymbols.isEmpty()) {
            return;
        }
        ArrayList<BType> paramTypes = new ArrayList<BType>(Arrays.asList(jMethodRequest.bParamTypes));
        int initialPathParamIndex = paramTypes.indexOf(pathParamSymbols.getFirst().type);
        for (BVarSymbol param : pathParamSymbols) {
            paramTypes.remove(param.type);
        }
        paramTypes.add(initialPathParamIndex, new BArrayType(this.symbolTable.typeEnv(), this.symbolTable.anydataType));
        jMethodRequest.bParamTypes = paramTypes.toArray(new BType[0]);
        jMethodRequest.bFuncParamCount = jMethodRequest.bFuncParamCount - pathParamSymbols.size() + 1;
        jMethodRequest.pathParamCount = 1;
        jMethod.hasBundledPathParams = true;
    }

    private void bundleFunctionParams(JMethodRequest jMethodRequest, JMethod jMethod) {
        ArrayList<BType> paramTypes = new ArrayList<BType>(Arrays.asList(jMethodRequest.bParamTypes));
        if (jMethodRequest.bFuncParamCount > jMethodRequest.pathParamCount) {
            paramTypes.subList(jMethodRequest.pathParamCount, jMethodRequest.bFuncParamCount).clear();
        }
        paramTypes.add(new BArrayType(this.symbolTable.typeEnv(), this.symbolTable.anyType));
        jMethodRequest.bParamTypes = paramTypes.toArray(new BType[0]);
        jMethodRequest.bFuncParamCount = jMethodRequest.pathParamCount + 1;
        jMethod.hasBundledFunctionParams = true;
    }

    private void bundleBothPathAndFunctionParameter(JMethodRequest jMethodRequest, JMethod jMethod) {
        ArrayList<BArrayType> paramTypes = new ArrayList<BArrayType>();
        paramTypes.add(new BArrayType(this.symbolTable.typeEnv(), this.symbolTable.anydataType));
        paramTypes.add(new BArrayType(this.symbolTable.typeEnv(), this.symbolTable.anyType));
        jMethodRequest.bParamTypes = paramTypes.toArray(new BType[0]);
        jMethodRequest.bFuncParamCount = 2;
        jMethodRequest.pathParamCount = 1;
        jMethod.hasBundledFunctionParams = true;
        jMethod.hasBundledPathParams = true;
    }

    private void validateReturnTypes(JMethodRequest jMethodRequest, JMethod jMethod) {
        BType bReturnType;
        Class<?> jReturnType = jMethod.getReturnType();
        if (!(this.isValidReturnBType(jReturnType, bReturnType = jMethodRequest.bReturnType, jMethodRequest) || jMethod.isBalEnvAcceptingMethod() && jReturnType.equals(Void.TYPE))) {
            throw new JInteropException(DiagnosticErrorCode.METHOD_SIGNATURE_DOES_NOT_MATCH, "Incompatible return type for method '" + jMethodRequest.methodName + "' in class '" + jMethodRequest.declaringClass.getName() + "': Java type '" + jReturnType.getName() + "' will not be matched to ballerina type '" + String.valueOf(bReturnType.tag == 33 ? bReturnType.tsymbol.name.value : bReturnType) + "'");
        }
    }

    private boolean isInvalidParamBType(Class<?> jType, BType bType, boolean isLastParam, boolean restParamExist) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        try {
            String jTypeName = jType.getTypeName();
            switch (bType.tag) {
                case 11: 
                case 18: {
                    if (jTypeName.equals(JInterop.J_STRING_TNAME)) {
                        return true;
                    }
                    return jType.isPrimitive();
                }
                case 37: {
                    return jType.isPrimitive();
                }
                case 10: {
                    return !jTypeName.equals(JInterop.J_VOID_TNAME);
                }
                case 1: 
                case 2: 
                case 3: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return false;
                    }
                    if (TypeTags.isIntegerTypeTag(bType.tag) && jTypeName.equals(JInterop.J_LONG_OBJ_TNAME)) {
                        return false;
                    }
                    if (bType.tag == 2 && jTypeName.equals(JInterop.J_INTEGER_OBJ_TNAME)) {
                        return false;
                    }
                    if (bType.tag == 3 && jTypeName.equals(JInterop.J_DOUBLE_OBJ_TNAME)) {
                        return false;
                    }
                    return !jType.isPrimitive() || !jTypeName.equals(JInterop.J_PRIMITIVE_INT_TNAME) && !jTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME) && !jTypeName.equals(JInterop.J_PRIMITIVE_SHORT_TNAME) && !jTypeName.equals(JInterop.J_PRIMITIVE_LONG_TNAME) && !jTypeName.equals(JInterop.J_PRIMITIVE_CHAR_TNAME) && !jTypeName.equals(JInterop.J_PRIMITIVE_FLOAT_TNAME) && !jTypeName.equals(JInterop.J_PRIMITIVE_DOUBLE_TNAME);
                }
                case 6: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME) || jTypeName.equals(JInterop.J_BOOLEAN_OBJ_TNAME)) {
                        return false;
                    }
                    return !jType.isPrimitive() || !jTypeName.equals(JInterop.J_PRIMITIVE_BOOLEAN_TNAME);
                }
                case 4: {
                    return !this.classLoader.loadClass(BDecimal.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 5: 
                case 45: {
                    return !this.classLoader.loadClass(BString.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 12: 
                case 16: {
                    return !this.classLoader.loadClass(BMap.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 7: 
                case 38: {
                    return !jTypeName.equals(JInterop.J_OBJECT_TNAME);
                }
                case 34: {
                    return !this.classLoader.loadClass(BObject.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 29: {
                    return !this.classLoader.loadClass(BError.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 8: 
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    return !this.classLoader.loadClass(BXml.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 20: 
                case 31: {
                    return !this.isValidListType(jType, isLastParam, restParamExist);
                }
                case 21: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return false;
                    }
                    Set members = ((BUnionType)bType).getMemberTypes();
                    for (BType member : members) {
                        if (!this.isInvalidParamBType(jType, member, isLastParam, restParamExist)) continue;
                        return true;
                    }
                    return false;
                }
                case 33: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return false;
                    }
                    for (BType t : SemTypeHelper.broadTypes((BFiniteType)bType, this.symbolTable)) {
                        if (!this.isInvalidParamBType(jType, t, isLastParam, restParamExist)) continue;
                        return true;
                    }
                    return false;
                }
                case 17: 
                case 36: {
                    return !this.classLoader.loadClass(BFunctionPointer.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 32: {
                    return !this.classLoader.loadClass(BFuture.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 13: {
                    return !this.classLoader.loadClass(BTypedesc.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 15: {
                    return !this.classLoader.loadClass(BStream.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 9: {
                    return !this.classLoader.loadClass(BTable.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 53: {
                    return !this.classLoader.loadClass(BRegexpValue.class.getCanonicalName()).isAssignableFrom(jType);
                }
            }
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticErrorCode.CLASS_NOT_FOUND, e.getMessage(), e);
        }
    }

    private boolean isValidReturnBType(Class<?> jType, BType bType, JMethodRequest jMethodRequest) {
        LinkedHashSet visitedSet = new LinkedHashSet();
        return this.isValidReturnBType(jType, bType, jMethodRequest, visitedSet);
    }

    private boolean isValidReturnBType(Class<?> jType, BType bType, JMethodRequest jMethodRequest, LinkedHashSet<Class<?>> visitedSet) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        try {
            String jTypeName = jType.getTypeName();
            switch (bType.tag) {
                case 11: 
                case 18: {
                    if (jTypeName.equals(JInterop.J_STRING_TNAME)) {
                        return false;
                    }
                    return !jType.isPrimitive();
                }
                case 37: {
                    return !jType.isPrimitive();
                }
                case 10: {
                    return jTypeName.equals(JInterop.J_VOID_TNAME);
                }
                case 1: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (jType.isPrimitive()) {
                        return jTypeName.equals(JInterop.J_PRIMITIVE_INT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_SHORT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_LONG_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_CHAR_TNAME);
                    }
                    return jTypeName.equals(JInterop.J_LONG_OBJ_TNAME);
                }
                case 2: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (jType.isPrimitive()) {
                        return jTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME);
                    }
                    return jTypeName.equals(JInterop.J_INTEGER_OBJ_TNAME);
                }
                case 3: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (jType.isPrimitive()) {
                        return jTypeName.equals(JInterop.J_PRIMITIVE_INT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_SHORT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_LONG_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_CHAR_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_FLOAT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_DOUBLE_TNAME);
                    }
                    return jTypeName.equals(JInterop.J_DOUBLE_OBJ_TNAME);
                }
                case 6: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME) || jTypeName.equals(JInterop.J_BOOLEAN_OBJ_TNAME)) {
                        return true;
                    }
                    return jType.isPrimitive() && jTypeName.equals(JInterop.J_PRIMITIVE_BOOLEAN_TNAME);
                }
                case 4: {
                    return this.classLoader.loadClass(BDecimal.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 5: 
                case 45: {
                    return this.classLoader.loadClass(BString.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 12: 
                case 16: {
                    return this.classLoader.loadClass(BMap.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 7: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (!visitedSet.add(jType)) {
                        return true;
                    }
                    return this.isValidReturnBType(jType, this.symbolTable.jsonType, jMethodRequest, visitedSet);
                }
                case 34: {
                    return this.classLoader.loadClass(BObject.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 29: {
                    return this.classLoader.loadClass(BError.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 8: 
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    return this.classLoader.loadClass(BXml.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 20: 
                case 31: {
                    return this.isValidListType(jType, true, jMethodRequest.restParamExist);
                }
                case 21: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (!visitedSet.add(jType)) {
                        return true;
                    }
                    Set members = ((BUnionType)bType).getMemberTypes();
                    for (BType member : members) {
                        if (!this.isValidReturnBType(jType, member, jMethodRequest, visitedSet)) continue;
                        return true;
                    }
                    return false;
                }
                case 38: {
                    return this.isReadOnlyCompatibleReturnType(jType, jMethodRequest);
                }
                case 33: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    for (BType t : SemTypeHelper.broadTypes((BFiniteType)bType, this.symbolTable)) {
                        if (!this.isValidReturnBType(jType, t, jMethodRequest, visitedSet)) continue;
                        return true;
                    }
                    return false;
                }
                case 17: 
                case 36: {
                    return this.classLoader.loadClass(BFunctionPointer.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 32: {
                    return this.classLoader.loadClass(BFuture.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 13: {
                    return this.classLoader.loadClass(BTypedesc.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 15: {
                    return this.classLoader.loadClass(BStream.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 9: {
                    return this.classLoader.loadClass(BTable.class.getCanonicalName()).isAssignableFrom(jType);
                }
            }
            return false;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticErrorCode.CLASS_NOT_FOUND, e.getMessage(), e);
        }
    }

    private boolean isValidListType(Class<?> jType, boolean isLastParam, boolean restParamExists) throws ClassNotFoundException {
        if (isLastParam && restParamExists) {
            return jType.isArray();
        }
        return this.classLoader.loadClass(BArray.class.getCanonicalName()).isAssignableFrom(jType);
    }

    private boolean isReadOnlyCompatibleReturnType(Class<?> jType, JMethodRequest jMethodRequest) throws ClassNotFoundException {
        if (jType.getTypeName().equals(JInterop.J_OBJECT_TNAME)) {
            return true;
        }
        for (BType member : this.definedReadOnlyMemberTypes) {
            if (!this.isValidReturnBType(jType, member, jMethodRequest)) continue;
            return true;
        }
        return this.isAssignableFrom(BError.class, jType) || this.isAssignableFrom(BFunctionPointer.class, jType) || this.isAssignableFrom(BObject.class, jType) || this.isAssignableFrom(BTypedesc.class, jType) || this.isAssignableFrom(BHandle.class, jType) || this.isAssignableFrom(BXml.class, jType) || this.isValidListType(jType, true, jMethodRequest.restParamExist) || this.isAssignableFrom(BMap.class, jType) || this.isAssignableFrom(BTable.class, jType);
    }

    private boolean isAssignableFrom(Class<?> targetType, Class<?> jType) throws ClassNotFoundException {
        return this.classLoader.loadClass(targetType.getCanonicalName()).isAssignableFrom(jType);
    }

    private JMethod resolveExactMethod(Class<?> clazz, String name, JMethodKind kind, ParamTypeConstraint[] constraints, BType receiverType) {
        Executable executable;
        Class[] paramTypes = new Class[constraints.length];
        for (int constraintIndex = 0; constraintIndex < constraints.length; ++constraintIndex) {
            paramTypes[constraintIndex] = constraints[constraintIndex].get();
        }
        Executable executable2 = executable = kind == JMethodKind.CONSTRUCTOR ? this.resolveConstructor(clazz, paramTypes) : this.resolveMethod(clazz, name, paramTypes);
        if (executable == null) {
            executable = this.tryResolveExactWithBalEnv(paramTypes, clazz, name);
        }
        if (executable != null) {
            if (kind == JMethodKind.CONSTRUCTOR) {
                return JMethod.build(kind, executable, null);
            }
            return JMethod.build(kind, executable, receiverType);
        }
        return JMethod.NO_SUCH_METHOD;
    }

    private Executable tryResolveExactWithBalEnv(Class<?>[] paramTypes, Class<?> clazz, String name) {
        Class[] paramTypesWithBalEnv = new Class[paramTypes.length + 1];
        System.arraycopy(paramTypes, 0, paramTypesWithBalEnv, 1, paramTypes.length);
        paramTypesWithBalEnv[0] = Environment.class;
        return this.resolveMethod(clazz, name, paramTypesWithBalEnv);
    }

    private JMethod resolveMatchingMethod(JMethodRequest jMethodRequest, List<JMethod> jMethods) {
        int paramTypesInitialIndex;
        int constraintsSize;
        ParamTypeConstraint[] constraints = jMethodRequest.paramTypeConstraints;
        String paramTypesSig = this.getParamTypesAsString(constraints);
        if (jMethodRequest.receiverType != null) {
            constraintsSize = constraints.length + 1;
            paramTypesInitialIndex = 1;
        } else {
            constraintsSize = constraints.length;
            paramTypesInitialIndex = 0;
        }
        ArrayList<JMethod> resolvedJMethods = new ArrayList<JMethod>();
        if (constraints.length > 0) {
            for (JMethod jMethod : jMethods) {
                boolean resolved = true;
                Class<?>[] formalParamTypes = jMethod.getParamTypes();
                if (constraintsSize != formalParamTypes.length) continue;
                int paramIndex = paramTypesInitialIndex;
                int constraintIndex = 0;
                while (paramIndex < formalParamTypes.length) {
                    Class<?> formalParamType = formalParamTypes[paramIndex];
                    if (!formalParamType.isAssignableFrom(constraints[constraintIndex].get())) {
                        resolved = false;
                        break;
                    }
                    ++paramIndex;
                    ++constraintIndex;
                }
                if (!resolved) continue;
                resolvedJMethods.add(jMethod);
            }
        }
        if (resolvedJMethods.isEmpty()) {
            if (jMethodRequest.kind == JMethodKind.CONSTRUCTOR) {
                throw new JInteropException(DiagnosticErrorCode.CONSTRUCTOR_NOT_FOUND, "No such public constructor that matches with parameter types '" + paramTypesSig + "' found in class '" + jMethodRequest.declaringClass.getName() + "'");
            }
            throw new JInteropException(DiagnosticErrorCode.METHOD_NOT_FOUND, "No such public method '" + jMethodRequest.methodName + "' that matches with parameter types '" + paramTypesSig + "' found in class '" + jMethodRequest.declaringClass.getName() + "'");
        }
        if (resolvedJMethods.size() > 1) {
            if (jMethodRequest.kind == JMethodKind.CONSTRUCTOR) {
                throw new JInteropException(DiagnosticErrorCode.OVERLOADED_METHODS, "More than one public constructors that match with the parameter types '" + paramTypesSig + "' found in class '" + String.valueOf(jMethodRequest.declaringClass) + "'");
            }
            throw new JInteropException(DiagnosticErrorCode.OVERLOADED_METHODS, "More than one public methods '" + jMethodRequest.methodName + "' that match with the parameter types '" + paramTypesSig + "' found in class '" + String.valueOf(jMethodRequest.declaringClass) + "'");
        }
        return (JMethod)resolvedJMethods.getFirst();
    }

    private Executable resolveConstructor(Class<?> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Executable resolveMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        try {
            return clazz.getMethod(name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private List<Executable> getExecutables(Class<?> clazz, String methodName, JMethodKind kind) {
        if (kind == JMethodKind.CONSTRUCTOR) {
            if (Modifier.isAbstract(clazz.getModifiers())) {
                throw new JInteropException(DiagnosticErrorCode.INSTANTIATION_ERROR, "'" + clazz.getName() + "' is abstract, and cannot be instantiated");
            }
            return Arrays.asList(this.getConstructors(clazz));
        }
        ArrayList<Executable> list = new ArrayList<Executable>();
        for (Method method : this.getMethods(clazz)) {
            if (!method.getName().equals(methodName)) continue;
            list.add(method);
        }
        return list;
    }

    private Method[] getMethods(Class<?> clazz) {
        try {
            return clazz.getMethods();
        }
        catch (NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticErrorCode.NO_CLASS_DEF_FOUND, "Class definition '" + e.getMessage() + "' not found");
        }
    }

    private Constructor<?>[] getConstructors(Class<?> clazz) {
        try {
            return clazz.getConstructors();
        }
        catch (NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticErrorCode.NO_CLASS_DEF_FOUND, "Class definition '" + e.getMessage() + "' not found");
        }
    }

    private boolean noConstraintsSpecified(ParamTypeConstraint[] constraints) {
        if (constraints == null) {
            return true;
        }
        if (constraints.length == 0) {
            return false;
        }
        for (ParamTypeConstraint constraint : constraints) {
            if (constraint == ParamTypeConstraint.NO_CONSTRAINT) continue;
            return false;
        }
        return true;
    }

    private int getBFuncParamCount(JMethodRequest jMethodRequest, JMethod jMethod) {
        int bFuncParamCount = jMethodRequest.bFuncParamCount;
        if (jMethodRequest.kind == JMethodKind.METHOD) {
            boolean isStaticMethod = jMethod.isStatic();
            bFuncParamCount = isStaticMethod ? bFuncParamCount : bFuncParamCount - 1;
        }
        return bFuncParamCount;
    }

    private int getBundledPathParamCount(JMethodRequest jMethodRequest, JMethod jMethod) {
        return this.getBFuncParamCount(jMethodRequest, jMethod) - jMethodRequest.pathParamCount + 1;
    }

    private boolean isFirstPathParamARestParam(JMethodRequest jMethodRequest, JMethod jMethod) {
        if (jMethodRequest.kind != JMethodKind.METHOD) {
            return false;
        }
        return jMethod.isStatic() ? jMethodRequest.bParamTypes[0].tag == 20 : jMethodRequest.bParamTypes[1].tag == 20 && jMethodRequest.bParamTypes[0].tag == 37;
    }

    private boolean isFunctionParamARestParam(JMethodRequest jMethodRequest, JMethod jMethod) {
        int funcParamCount = this.getBFuncParamCount(jMethodRequest, jMethod) - jMethodRequest.pathParamCount;
        return (jMethod.isStatic() ? jMethodRequest.bParamTypes[jMethodRequest.pathParamCount].tag == 20 : jMethodRequest.bParamTypes[jMethodRequest.pathParamCount + 1].tag == 20 && jMethodRequest.bParamTypes[0].tag == 37) && funcParamCount == 1;
    }

    private String getParamTypesAsString(ParamTypeConstraint[] constraints) {
        StringJoiner stringJoiner = new StringJoiner(",", "(", ")");
        for (ParamTypeConstraint paramTypeConstraint : constraints) {
            stringJoiner.add(paramTypeConstraint.get().getName());
        }
        return stringJoiner.toString();
    }

    private void throwMethodNotFoundError(JMethodRequest jMethodRequest) throws JInteropException {
        if (jMethodRequest.kind == JMethodKind.CONSTRUCTOR) {
            throw new JInteropException(DiagnosticErrorCode.CONSTRUCTOR_NOT_FOUND, "No such public constructor with '" + jMethodRequest.bFuncParamCount + "' parameter(s) found in class '" + jMethodRequest.declaringClass.getName() + "'");
        }
        if (jMethodRequest.bFuncParamCount == 0 || jMethodRequest.bParamTypes[0].tag != 37) {
            throw new JInteropException(DiagnosticErrorCode.METHOD_NOT_FOUND, "No such public static method '" + jMethodRequest.methodName + "' with '" + jMethodRequest.bFuncParamCount + "' parameter(s) found in class '" + jMethodRequest.declaringClass.getName() + "'");
        }
        throw new JInteropException(DiagnosticErrorCode.METHOD_NOT_FOUND, "No such public method '" + jMethodRequest.methodName + "' with '" + jMethodRequest.bFuncParamCount + "' parameter(s) found in class '" + jMethodRequest.declaringClass.getName() + "'");
    }

    private void throwNoSuchMethodError(String methodName, Class<?> jType, BType bType, Class<?> declaringClass) throws JInteropException {
        throw new JInteropException(DiagnosticErrorCode.METHOD_SIGNATURE_DOES_NOT_MATCH, "Incompatible param type for method '" + methodName + "' in class '" + declaringClass.getName() + "': Java type '" + jType.getName() + "' will not be matched to ballerina type '" + String.valueOf(bType.tag == 33 ? bType.tsymbol.name.value : bType) + "'");
    }

    private void throwParamCountMismatchError(JMethodRequest jMethodRequest) throws JInteropException {
        throw new JInteropException(DiagnosticErrorCode.METHOD_SIGNATURE_DOES_NOT_MATCH, "Parameter count does not match with Java method '" + jMethodRequest.methodName + "' found in class '" + jMethodRequest.declaringClass.getName() + "'");
    }

    private void throwOverloadedMethodError(JMethodRequest jMethodRequest, int paramCount) throws JInteropException {
        if (jMethodRequest.kind == JMethodKind.CONSTRUCTOR) {
            throw new JInteropException(DiagnosticErrorCode.OVERLOADED_METHODS, "Overloaded constructors with '" + paramCount + "' parameter(s) in class '" + jMethodRequest.declaringClass.getName() + "', please specify the parameter types for each parameter in 'paramTypes' field in the annotation");
        }
        throw new JInteropException(DiagnosticErrorCode.OVERLOADED_METHODS, "Overloaded methods '" + jMethodRequest.methodName + "' with '" + paramCount + "' parameter(s) in class '" + jMethodRequest.declaringClass.getName() + "', please specify the parameter types for each parameter in 'paramTypes' field in the annotation");
    }
}

