/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.methodgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.types.RecordType;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class MainMethodGen {
    public static final String RUNTIME_VAR = "$runtime";
    public static final String FUTURE_VAR = "$future";
    public static final String SCHEDULER_VAR = "$schedulerVar";
    public static final String CONFIG_VAR = "$configVar";
    private final SymbolTable symbolTable;
    private final String globalVarsPkgName;
    private final BIRVarToJVMIndexMap indexMap;
    private final JvmTypeGen jvmTypeGen;
    private final boolean isRemoteMgtEnabled;

    public MainMethodGen(SymbolTable symbolTable, JvmTypeGen jvmTypeGen, boolean isRemoteMgtEnabled, String globalVarsPkgName) {
        this.symbolTable = symbolTable;
        this.indexMap = new BIRVarToJVMIndexMap(1);
        this.jvmTypeGen = jvmTypeGen;
        this.isRemoteMgtEnabled = isRemoteMgtEnabled;
        this.globalVarsPkgName = globalVarsPkgName;
    }

    public void generateMainMethod(BIRNode.BIRFunction userMainFunc, ClassWriter cw, BIRNode.BIRPackage pkg, String initClass, boolean serviceEPAvailable, boolean isTestable) {
        int runtimeVarIndex = this.indexMap.addIfNotExists(RUNTIME_VAR, this.symbolTable.anyType);
        int schedulerVarIndex = this.indexMap.addIfNotExists(SCHEDULER_VAR, this.symbolTable.anyType);
        int futureVarIndex = this.indexMap.addIfNotExists(FUTURE_VAR, this.symbolTable.anyType);
        MethodVisitor mv = cw.visitMethod(9, "main", "([Ljava/lang/String;)V", null, null);
        mv.visitCode();
        Label tryCatchStart = new Label();
        Label tryCatchEnd = new Label();
        Label tryCatchHandle = new Label();
        mv.visitTryCatchBlock(tryCatchStart, tryCatchEnd, tryCatchHandle, "java/lang/Error");
        mv.visitLabel(tryCatchStart);
        this.generateJavaCompatibilityCheck(mv);
        this.generateBallerinaRuntimeInformation(mv);
        this.genRuntimeAndGetScheduler(mv, initClass, runtimeVarIndex, schedulerVarIndex);
        this.invokeConfigInit(mv, pkg.packageID, runtimeVarIndex);
        this.genStartTrapSignalHandler(mv);
        if (!isTestable) {
            this.genShutdownHook(mv, initClass, runtimeVarIndex);
        }
        boolean hasInitFunction = MethodGenUtils.hasInitFunction(pkg);
        this.generateSetModuleInitialedAndStarted(mv, runtimeVarIndex);
        this.generateExecuteFunctionCall(initClass, mv, userMainFunc, isTestable, schedulerVarIndex, futureVarIndex);
        this.handleFutureValue(mv, isTestable, futureVarIndex);
        if (isTestable) {
            this.generateModuleStopCall(initClass, mv, runtimeVarIndex);
        } else {
            if (hasInitFunction) {
                this.setListenerFound(mv, serviceEPAvailable, runtimeVarIndex);
            }
            if (!serviceEPAvailable) {
                JvmCodeGenUtil.generateExitRuntime(mv);
            }
        }
        mv.visitLabel(tryCatchEnd);
        mv.visitInsn(177);
        mv.visitLabel(tryCatchHandle);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/RuntimeUtils", "handleThrowable", "(Ljava/lang/Throwable;)V", false);
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "main", initClass);
        mv.visitEnd();
    }

    private void generateBallerinaRuntimeInformation(MethodVisitor mv) {
        String property = System.getProperty("ballerina.home");
        mv.visitLdcInsn((Object)(property == null ? "" : property));
        property = System.getProperty("ballerina.version");
        mv.visitLdcInsn((Object)(property == null ? "" : property));
        if (this.isRemoteMgtEnabled) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/repository/RepositoryImpl", "addBallerinaRuntimeInformation", "(Ljava/lang/String;Ljava/lang/String;Z)V", false);
    }

    private void generateSetModuleInitialedAndStarted(MethodVisitor mv, int runtimeVarIndex) {
        mv.visitVarInsn(25, runtimeVarIndex);
        mv.visitInsn(4);
        mv.visitFieldInsn(181, "io/ballerina/runtime/internal/BalRuntime", "moduleInitialized", "Z");
        mv.visitVarInsn(25, runtimeVarIndex);
        mv.visitInsn(4);
        mv.visitFieldInsn(181, "io/ballerina/runtime/internal/BalRuntime", "moduleStarted", "Z");
    }

    private void generateExecuteFunctionCall(String initClass, MethodVisitor mv, BIRNode.BIRFunction userMainFunc, boolean isTestable, int schedulerVarIndex, int futureVarIndex) {
        mv.visitVarInsn(25, schedulerVarIndex);
        this.genSubmitToScheduler(initClass, mv, userMainFunc, isTestable, futureVarIndex);
    }

    private void generateModuleStopCall(String initClass, MethodVisitor mv, int runtimeVarIndex) {
        mv.visitVarInsn(25, runtimeVarIndex);
        mv.visitMethodInsn(184, initClass, "$currentModuleStop", "(Lio/ballerina/runtime/internal/BalRuntime;)V", false);
    }

    private void invokeConfigInit(MethodVisitor mv, PackageID packageID, int runtimeVarIndex) {
        String configClass = JvmModuleUtils.getModuleLevelClassName(packageID, "$configurationMapper");
        mv.visitTypeInsn(187, "java/util/HashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        mv.visitVarInsn(58, 6);
        mv.visitVarInsn(25, 6);
        if (!packageID.isTestPkg) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/launch/LaunchUtils", "getConfigurationDetails", "()Lio/ballerina/runtime/internal/configurable/providers/ConfigDetails;", false);
        } else {
            this.loadCLIArgsForTestConfigInit(mv);
            String initClass = JvmModuleUtils.getModuleLevelClassName(packageID, "$_init");
            mv.visitFieldInsn(178, initClass, "$currentModule", "Lio/ballerina/runtime/api/Module;");
            mv.visitLdcInsn((Object)packageID.pkgName.toString());
            mv.visitLdcInsn((Object)packageID.sourceRoot);
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/launch/LaunchUtils", "getTestConfigPaths", "(Lio/ballerina/runtime/api/Module;Ljava/lang/String;Ljava/lang/String;)Lio/ballerina/runtime/internal/configurable/providers/ConfigDetails;", false);
        }
        int configDetailsIndex = this.indexMap.addIfNotExists(CONFIG_VAR, this.symbolTable.anyType);
        mv.visitVarInsn(58, configDetailsIndex);
        mv.visitVarInsn(25, configDetailsIndex);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/configurable/providers/ConfigDetails", "paths", "[Ljava/nio/file/Path;");
        mv.visitVarInsn(25, configDetailsIndex);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/configurable/providers/ConfigDetails", "configContent", "Ljava/lang/String;");
        mv.visitVarInsn(25, runtimeVarIndex);
        mv.visitMethodInsn(184, configClass, "$configureInit", "(Ljava/util/Map;[Ljava/lang/String;[Ljava/nio/file/Path;Ljava/lang/String;Lio/ballerina/runtime/internal/BalRuntime;)V", false);
        String moduleInitClass = JvmModuleUtils.getModuleLevelClassName(packageID, "$_init");
        mv.visitFieldInsn(178, moduleInitClass, "$currentModule", "Lio/ballerina/runtime/api/Module;");
        mv.visitVarInsn(25, 6);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, configDetailsIndex);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/configurable/providers/ConfigDetails", "paths", "[Ljava/nio/file/Path;");
        mv.visitVarInsn(25, configDetailsIndex);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/configurable/providers/ConfigDetails", "configContent", "Ljava/lang/String;");
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/launch/LaunchUtils", "initConfigurableVariables", "(Lio/ballerina/runtime/api/Module;Ljava/util/Map;[Ljava/lang/String;[Ljava/nio/file/Path;Ljava/lang/String;)V", false);
    }

    private void generateJavaCompatibilityCheck(MethodVisitor mv) {
        mv.visitLdcInsn((Object)this.getJavaVersion());
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/CompatibilityChecker", "verifyJavaCompatibility", "(Ljava/lang/String;)V", false);
    }

    private String getJavaVersion() {
        String versionProperty = "java.version";
        String javaVersion = System.getProperty(versionProperty);
        return Objects.requireNonNullElse(javaVersion, "");
    }

    private void genStartTrapSignalHandler(MethodVisitor mv) {
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/launch/LaunchUtils", "startTrapSignalHandler", "()V", false);
    }

    private void genShutdownHook(MethodVisitor mv, String initClass, int runtimeVarIndex) {
        String shutdownClassName = initClass + "$SignalListener";
        mv.visitMethodInsn(184, "java/lang/Runtime", "getRuntime", "()Ljava/lang/Runtime;", false);
        mv.visitTypeInsn(187, shutdownClassName);
        mv.visitInsn(89);
        mv.visitVarInsn(25, runtimeVarIndex);
        mv.visitMethodInsn(183, shutdownClassName, "<init>", "(Lio/ballerina/runtime/internal/BalRuntime;)V", false);
        mv.visitMethodInsn(182, "java/lang/Runtime", "addShutdownHook", "(Ljava/lang/Thread;)V", false);
    }

    private void genRuntimeAndGetScheduler(MethodVisitor mv, String initClass, int runtimeVarIndex, int schedulerVarIndex) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/BalRuntime");
        mv.visitInsn(89);
        mv.visitFieldInsn(178, initClass, "$currentModule", "Lio/ballerina/runtime/api/Module;");
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/BalRuntime", "<init>", "(Lio/ballerina/runtime/api/Module;)V", false);
        mv.visitInsn(89);
        mv.visitVarInsn(58, runtimeVarIndex);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/BalRuntime", "scheduler", "Lio/ballerina/runtime/internal/scheduling/Scheduler;");
        mv.visitVarInsn(58, schedulerVarIndex);
    }

    private void setListenerFound(MethodVisitor mv, boolean serviceEPAvailable, int runtimeVarIndex) {
        mv.visitVarInsn(25, runtimeVarIndex);
        if (serviceEPAvailable) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/BalRuntime", "waitOnListeners", "(Z)V", false);
    }

    private void loadCLIArgsForMain(MethodVisitor mv, List<BIRNode.BIRFunctionParameter> params, List<BIRNode.BIRAnnotationAttachment> annotAttachments) {
        mv.visitInsn(5);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitInsn(1);
        mv.visitInsn(83);
        mv.visitInsn(89);
        mv.visitInsn(4);
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/cli/CliSpec");
        mv.visitInsn(89);
        List<String> defaultableNames = this.getDefaultableNames(annotAttachments);
        this.createFunctionInfoArray(mv, params, defaultableNames);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/cli/CliSpec", "<init>", "(Lio/ballerina/runtime/internal/cli/Option;[Lio/ballerina/runtime/internal/cli/Operand;[Ljava/lang/String;)V", false);
        mv.visitInsn(83);
    }

    private void loadCLIArgsForTestConfigInit(MethodVisitor mv) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/testable/TestConfigArguments");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/testable/TestConfigArguments", "<init>", "([Ljava/lang/String;)V", false);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/testable/TestConfigArguments", "getConfigCliArgs", "()[Ljava/lang/String;", false);
    }

    private void loadCLIArgsForTestExecute(MethodVisitor mv) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/testable/TestArguments");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/testable/TestArguments", "<init>", "([Ljava/lang/String;)V", false);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/testable/TestArguments", "getArgValues", "()[Ljava/lang/Object;", false);
    }

    private void createFunctionInfoArray(MethodVisitor mv, List<BIRNode.BIRFunctionParameter> params, List<String> defaultableNames) {
        int size = params.size();
        if (!params.isEmpty() && JvmCodeGenUtil.getImpliedType(params.get((int)(size - 1)).type) instanceof RecordType) {
            param = params.get(size - 1);
            this.createOption(mv, param, size - 1);
            --size;
        } else if (params.size() >= 2 && JvmCodeGenUtil.getImpliedType(params.get((int)(size - 2)).type) instanceof RecordType) {
            param = params.get(size - 2);
            this.createOption(mv, param, size - 2);
            --size;
        } else {
            mv.visitInsn(1);
        }
        mv.visitIntInsn(16, size);
        mv.visitTypeInsn(189, "io/ballerina/runtime/internal/cli/Operand");
        int defaultableIndex = 0;
        int arrIndex = 0;
        for (BIRNode.BIRFunctionParameter birFunctionParameter : params) {
            if (birFunctionParameter != null && JvmCodeGenUtil.getImpliedType(birFunctionParameter.type) instanceof RecordType) {
                ++defaultableIndex;
                continue;
            }
            mv.visitInsn(89);
            mv.visitIntInsn(16, arrIndex++);
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/cli/Operand");
            mv.visitInsn(89);
            if (birFunctionParameter != null) {
                if (birFunctionParameter.hasDefaultExpr) {
                    mv.visitInsn(4);
                } else {
                    mv.visitInsn(3);
                }
                if (!defaultableNames.isEmpty()) {
                    mv.visitLdcInsn((Object)defaultableNames.get(defaultableIndex++));
                }
                this.jvmTypeGen.loadType(mv, birFunctionParameter.type);
            }
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/cli/Operand", "<init>", "(ZLjava/lang/String;Lio/ballerina/runtime/api/types/Type;)V", false);
            mv.visitInsn(83);
        }
    }

    private void createOption(MethodVisitor mv, BIRNode.BIRFunctionParameter param, int location) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/cli/Option");
        mv.visitInsn(89);
        this.jvmTypeGen.loadType(mv, param.type);
        mv.visitIntInsn(16, location);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/cli/Option", "<init>", "(Lio/ballerina/runtime/api/types/Type;I)V", false);
    }

    private List<String> getDefaultableNames(List<BIRNode.BIRAnnotationAttachment> annotAttachments) {
        ArrayList<String> defaultableNames = new ArrayList<String>();
        int defaultableIndex = 0;
        for (BIRNode.BIRAnnotationAttachment attachment : annotAttachments) {
            BIRNode.ConstValue[] annotArrayValue;
            if (attachment == null || !attachment.annotTagRef.value.equals("DefaultableArgs")) continue;
            Map annotFieldMap = (Map)((BIRNode.BIRConstAnnotationAttachment)attachment).annotValue.value;
            BIRNode.ConstValue annConstValue = (BIRNode.ConstValue)annotFieldMap.get("args");
            for (BIRNode.ConstValue entryOptional : annotArrayValue = (BIRNode.ConstValue[])annConstValue.value) {
                defaultableNames.add(defaultableIndex, (String)entryOptional.value);
                ++defaultableIndex;
            }
        }
        return defaultableNames;
    }

    private void genSubmitToScheduler(String initClass, MethodVisitor mv, BIRNode.BIRFunction userMainFunc, boolean isTestable, int futureVarIndex) {
        JvmCodeGenUtil.createFunctionPointer(mv, initClass, "$lambda$$moduleExecute$");
        mv.visitInsn(1);
        BType anyType = this.symbolTable.anyType;
        this.jvmTypeGen.loadType(mv, anyType);
        mv.visitLdcInsn((Object)"main");
        mv.visitInsn(1);
        if (userMainFunc != null) {
            this.loadCLIArgsForMain(mv, userMainFunc.parameters, userMainFunc.annotAttachments);
        } else if (isTestable) {
            this.loadCLIArgsForTestExecute(mv);
        } else {
            mv.visitIntInsn(16, 1);
            mv.visitTypeInsn(189, "java/lang/Object");
        }
        if (userMainFunc != null && (userMainFunc.flags & 0x20000000L) == 0x20000000L) {
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler", "startIsolatedWorker", "(Lio/ballerina/runtime/internal/values/FPValue;Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/api/types/Type;Ljava/lang/String;Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;[Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/FutureValue;", false);
        } else {
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler", "startNonIsolatedWorker", "(Lio/ballerina/runtime/internal/values/FPValue;Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/api/types/Type;Ljava/lang/String;Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;[Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/FutureValue;", false);
        }
        mv.visitVarInsn(58, futureVarIndex);
    }

    private void handleFutureValue(MethodVisitor mv, boolean isTestable, int futureVarIndex) {
        mv.visitVarInsn(25, futureVarIndex);
        if (isTestable) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/RuntimeUtils", "handleFutureAndReturnIsPanic", "(Lio/ballerina/runtime/internal/values/FutureValue;)Z", false);
            Label ifLabel = new Label();
            mv.visitJumpInsn(153, ifLabel);
            mv.visitInsn(10);
            String testExecutionStateGlobalClass = JvmCodeGenUtil.getVarStoreClass(this.globalVarsPkgName, "__gH7W16nQmp0TestExecState__");
            mv.visitFieldInsn(179, testExecutionStateGlobalClass, "v", "J");
            mv.visitLabel(ifLabel);
        } else {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/RuntimeUtils", "handleFutureAndExit", "(Lio/ballerina/runtime/internal/values/FutureValue;)V", false);
        }
    }
}

