/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.methodgen;

import io.ballerina.identifier.Utils;
import io.ballerina.types.Env;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmErrorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.FunctionParamComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LabelGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ExternalMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JType;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BirScope;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class MethodGen {
    private final JvmPackageGen jvmPackageGen;
    private final SymbolTable symbolTable;
    private final Env typeEnv;

    public MethodGen(JvmPackageGen jvmPackageGen, Types types) {
        this.jvmPackageGen = jvmPackageGen;
        this.symbolTable = jvmPackageGen.symbolTable;
        this.typeEnv = types.typeEnv();
    }

    public void generateMethod(BIRNode.BIRFunction birFunc, ClassWriter cw, BIRNode.BIRPackage birModule, BType attachedType, String moduleClassName, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen, JvmConstantsGen jvmConstantsGen, AsyncDataCollector asyncDataCollector) {
        if (JvmCodeGenUtil.isExternFunc(birFunc)) {
            ExternalMethodGen.genJMethodForBExternalFunc(birFunc, cw, birModule, attachedType, this, this.jvmPackageGen, jvmTypeGen, jvmCastGen, jvmConstantsGen, moduleClassName, asyncDataCollector, this.jvmPackageGen.types);
        } else {
            this.genJMethodForBFunc(birFunc, cw, birModule, jvmTypeGen, jvmCastGen, jvmConstantsGen, moduleClassName, attachedType, asyncDataCollector, false);
        }
    }

    public void genJMethodWithBObjectMethodCall(BIRNode.BIRFunction func, ClassWriter cw, BIRNode.BIRPackage module, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen, JvmConstantsGen jvmConstantsGen, String moduleClassName, AsyncDataCollector asyncDataCollector, String splitClassName) {
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        indexMap.addIfNotExists("self", this.symbolTable.anyType);
        indexMap.addIfNotExists("strand", this.symbolTable.stringType);
        String funcName = func.name.value;
        BType retType = this.getReturnType(func);
        String desc = JvmCodeGenUtil.getMethodDesc(this.typeEnv, func.type.paramTypes, retType);
        MethodVisitor mv = cw.visitMethod(1, funcName, desc, null, null);
        mv.visitCode();
        Label methodStartLabel = new Label();
        mv.visitLabel(methodStartLabel);
        JvmInstructionGen instGen = new JvmInstructionGen(mv, indexMap, module.packageID, this.jvmPackageGen, jvmTypeGen, jvmCastGen, jvmConstantsGen, asyncDataCollector);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        String encodedMethodName = Utils.encodeFunctionIdentifier((String)funcName);
        for (BIRNode.BIRFunctionParameter parameter : func.parameters) {
            instGen.generateVarLoad(mv, parameter);
        }
        String methodDesc = JvmCodeGenUtil.getMethodDesc(this.typeEnv, func.type.paramTypes, retType, moduleClassName);
        mv.visitMethodInsn(184, splitClassName, encodedMethodName, methodDesc, false);
        Label methodEndLabel = new Label();
        mv.visitLabel(methodEndLabel);
        this.generateReturnTermFromType(retType, mv);
        mv.visitLocalVariable("self", "Lio/ballerina/runtime/api/values/BObject;", null, methodStartLabel, methodEndLabel, 0);
        mv.visitLocalVariable("__strand", "Lio/ballerina/runtime/internal/scheduling/Strand;", null, methodStartLabel, methodEndLabel, 1);
        for (BIRNode.BIRFunctionParameter parameter : func.parameters) {
            String metaVarName = parameter.metaVarName;
            if (!this.isValidArg(parameter) || !this.isCompilerAddedVars(metaVarName)) continue;
            mv.visitLocalVariable(metaVarName, this.getJVMTypeSign(parameter.type), null, methodStartLabel, methodEndLabel, indexMap.addIfNotExists(parameter.name.value, parameter.type));
        }
        JvmCodeGenUtil.visitMaxStackForMethod(mv, funcName, moduleClassName);
        mv.visitEnd();
    }

    private void generateReturnTermFromType(BType bType, MethodVisitor mv) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            mv.visitInsn(173);
            return;
        }
        switch (bType.tag) {
            case 2: 
            case 6: {
                mv.visitInsn(172);
                break;
            }
            case 3: {
                mv.visitInsn(175);
                break;
            }
            default: {
                mv.visitInsn(176);
            }
        }
    }

    public void genJMethodForBFunc(BIRNode.BIRFunction func, ClassWriter cw, BIRNode.BIRPackage module, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen, JvmConstantsGen jvmConstantsGen, String moduleClassName, BType attachedType, AsyncDataCollector asyncDataCollector, boolean isObjectMethodSplit) {
        int localVarOffset;
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        int access = 1;
        if (attachedType != null && !isObjectMethodSplit) {
            localVarOffset = 1;
            indexMap.addIfNotExists("self", this.symbolTable.anyType);
        } else {
            localVarOffset = 0;
            access += 8;
        }
        indexMap.addIfNotExists("strand", this.symbolTable.stringType);
        if (isObjectMethodSplit) {
            indexMap.addIfNotExists("self", this.symbolTable.anyType);
        }
        String funcName = func.name.value;
        BType retType = this.getReturnType(func);
        String desc = isObjectMethodSplit ? JvmCodeGenUtil.getMethodDesc(this.typeEnv, func.type.paramTypes, retType, moduleClassName) : JvmCodeGenUtil.getMethodDesc(this.typeEnv, func.type.paramTypes, retType);
        MethodVisitor mv = cw.visitMethod(access, funcName, desc, null, null);
        mv.visitCode();
        this.visitStartFunction(module.packageID, funcName, mv);
        Label methodStartLabel = new Label();
        mv.visitLabel(methodStartLabel);
        this.genLocalVars(indexMap, mv, func.localVars);
        int returnVarRefIndex = this.getReturnVarRefIndex(func, indexMap, retType, mv);
        int channelMapVarIndex = this.getWorkerChannelMapVarIndex(func, indexMap, mv);
        ArrayList<BIRNode.ChannelDetails> sendWorkerChannels = new ArrayList<BIRNode.ChannelDetails>();
        ArrayList<BIRNode.ChannelDetails> receiveWorkerChannels = new ArrayList<BIRNode.ChannelDetails>();
        MethodGen.filterWorkerChannels(func, sendWorkerChannels, receiveWorkerChannels);
        int sendWorkerChannelNamesVar = this.getSendWorkerChannelNamesVarIndex(func, indexMap, mv, sendWorkerChannels, channelMapVarIndex, localVarOffset);
        int receiveWorkerChannelNamesVar = this.getReceiveWorkerChannelNamesVarIndex(func, indexMap, mv, receiveWorkerChannels, channelMapVarIndex, localVarOffset);
        LabelGenerator labelGen = new LabelGenerator();
        this.handleDependantModuleForInit(mv, module.packageID, funcName);
        this.handleParentModuleStart(mv, module.packageID, funcName);
        Label tryLabel = new Label();
        Label catchLabel = new Label();
        Label handleThrowableLabel = new Label();
        MethodGen.createWorkerPanicLabels(func, mv, tryLabel);
        JvmInstructionGen instGen = new JvmInstructionGen(mv, indexMap, module.packageID, this.jvmPackageGen, jvmTypeGen, jvmCastGen, jvmConstantsGen, asyncDataCollector);
        JvmErrorGen errorGen = new JvmErrorGen(mv, indexMap, instGen);
        JvmTerminatorGen termGen = new JvmTerminatorGen(mv, indexMap, labelGen, errorGen, module.packageID, instGen, this.jvmPackageGen, jvmTypeGen, jvmCastGen, asyncDataCollector);
        this.generateBasicBlocks(mv, labelGen, errorGen, instGen, termGen, moduleClassName, func, returnVarRefIndex, channelMapVarIndex, localVarOffset, module, attachedType, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar);
        termGen.genReturnTerm(returnVarRefIndex, func, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar, localVarOffset);
        MethodGen.handleWorkerPanic(func, mv, tryLabel, catchLabel, handleThrowableLabel, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar, localVarOffset);
        Label methodEndLabel = new Label();
        mv.visitLabel(methodEndLabel);
        this.createLocalVariableTable(func, indexMap, localVarOffset, mv, methodStartLabel, labelGen, methodEndLabel, isObjectMethodSplit);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, funcName, moduleClassName);
        mv.visitEnd();
    }

    private void handleDependantModuleForInit(MethodVisitor mv, PackageID packageID, String funcName) {
        if (this.isModuleInitFunction(funcName)) {
            String moduleClass = JvmModuleUtils.getModuleLevelClassName(packageID, "$_init");
            mv.visitFieldInsn(178, moduleClass, "$noOfDependantModules", "I");
            mv.visitInsn(4);
            mv.visitInsn(96);
            mv.visitFieldInsn(179, moduleClass, "$noOfDependantModules", "I");
            Label labelIf = new Label();
            mv.visitFieldInsn(178, moduleClass, "$noOfDependantModules", "I");
            mv.visitInsn(4);
            mv.visitJumpInsn(159, labelIf);
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitLabel(labelIf);
        }
    }

    private void handleParentModuleStart(MethodVisitor mv, PackageID packageID, String funcName) {
        if (this.isModuleStartFunction(funcName)) {
            String moduleClass = JvmModuleUtils.getModuleLevelClassName(packageID, "$_init");
            mv.visitFieldInsn(178, moduleClass, "$parentModuleStartAttempted", "Z");
            Label labelIf = new Label();
            mv.visitJumpInsn(153, labelIf);
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitLabel(labelIf);
            mv.visitInsn(4);
            mv.visitFieldInsn(179, moduleClass, "$parentModuleStartAttempted", "Z");
        }
    }

    private BType getReturnType(BIRNode.BIRFunction func) {
        BType retType = func.type.retType;
        if (JvmCodeGenUtil.isExternFunc(func) && Symbols.isFlagOn(retType.getFlags(), 0x4000000L)) {
            retType = JvmCodeGenUtil.UNIFIER.build(this.typeEnv, func.type.retType);
        }
        return retType;
    }

    private void visitStartFunction(PackageID packageID, String funcName, MethodVisitor mv) {
        if (!this.isStartFunction(funcName)) {
            return;
        }
        mv.visitInsn(4);
        mv.visitFieldInsn(179, JvmModuleUtils.getModuleLevelClassName(packageID, "$_init"), "$moduleStartAttempted", "Z");
    }

    private void genLocalVars(BIRVarToJVMIndexMap indexMap, MethodVisitor mv, List<BIRNode.BIRVariableDcl> localVars) {
        localVars.sort(new FunctionParamComparator());
        for (int i = 1; i < localVars.size(); ++i) {
            BIRNode.BIRVariableDcl localVar = localVars.get(i);
            int index = indexMap.addIfNotExists(localVar.name.value, localVar.type);
            if (localVar.kind == VarKind.ARG) continue;
            BType bType = localVar.type;
            this.genDefaultValue(mv, bType, index);
        }
    }

    private int getReturnVarRefIndex(BIRNode.BIRFunction func, BIRVarToJVMIndexMap indexMap, BType retType, MethodVisitor mv) {
        BIRNode.BIRVariableDcl varDcl = func.localVars.getFirst();
        int returnVarRefIndex = indexMap.addIfNotExists(varDcl.name.value, varDcl.type);
        this.genDefaultValue(mv, retType, returnVarRefIndex);
        return returnVarRefIndex;
    }

    private int getWorkerChannelMapVarIndex(BIRNode.BIRFunction func, BIRVarToJVMIndexMap indexMap, MethodVisitor mv) {
        if (!func.hasWorkers) {
            return -1;
        }
        int channelMapVarIndex = indexMap.addIfNotExists("$channelMap", this.symbolTable.anyType);
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/scheduling/WorkerChannelMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/scheduling/WorkerChannelMap", "<init>", "()V", false);
        mv.visitVarInsn(58, channelMapVarIndex);
        return channelMapVarIndex;
    }

    private static void filterWorkerChannels(BIRNode.BIRFunction func, List<BIRNode.ChannelDetails> sendWorkerChannels, List<BIRNode.ChannelDetails> receiveWorkerChannels) {
        for (BIRNode.ChannelDetails workerChannel : func.workerChannels) {
            if (workerChannel.send) {
                sendWorkerChannels.add(workerChannel);
                continue;
            }
            receiveWorkerChannels.add(workerChannel);
        }
    }

    private int getSendWorkerChannelNamesVarIndex(BIRNode.BIRFunction func, BIRVarToJVMIndexMap indexMap, MethodVisitor mv, List<BIRNode.ChannelDetails> sendWorkerChannels, int channelMapVarIndex, int localVarOffset) {
        if (func.workerChannels.length == 0) {
            return -1;
        }
        int sendWorkerChannelNamesVar = indexMap.addIfNotExists("$sendWorkerChannelNames", this.symbolTable.anyType);
        if (sendWorkerChannels.isEmpty()) {
            mv.visitInsn(1);
            mv.visitVarInsn(58, sendWorkerChannelNamesVar);
            return sendWorkerChannelNamesVar;
        }
        int channelSize = sendWorkerChannels.size();
        mv.visitIntInsn(16, channelSize);
        mv.visitTypeInsn(189, "java/lang/String");
        int count = 0;
        for (BIRNode.ChannelDetails sendWorkerChannel : sendWorkerChannels) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, count++);
            mv.visitLdcInsn((Object)sendWorkerChannel.name);
            mv.visitInsn(83);
        }
        mv.visitVarInsn(58, sendWorkerChannelNamesVar);
        JvmCodeGenUtil.loadWorkerChannelMap(mv, func, channelMapVarIndex, localVarOffset);
        mv.visitVarInsn(25, sendWorkerChannelNamesVar);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/WorkerUtils", "addWorkerChannels", "(Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;[Ljava/lang/String;)V", false);
        return sendWorkerChannelNamesVar;
    }

    private int getReceiveWorkerChannelNamesVarIndex(BIRNode.BIRFunction func, BIRVarToJVMIndexMap indexMap, MethodVisitor mv, List<BIRNode.ChannelDetails> receiveWorkerChannels, int channelMapVarIndex, int localVarOffset) {
        if (func.workerChannels.length == 0) {
            return -1;
        }
        int receiveWorkerChannelNamesVar = indexMap.addIfNotExists("$receiveWorkerChannelNames", this.symbolTable.anyType);
        if (receiveWorkerChannels.isEmpty()) {
            mv.visitInsn(1);
            mv.visitVarInsn(58, receiveWorkerChannelNamesVar);
            return receiveWorkerChannelNamesVar;
        }
        int channelSize = receiveWorkerChannels.size();
        mv.visitIntInsn(16, channelSize);
        mv.visitTypeInsn(189, "java/lang/String");
        int count = 0;
        for (BIRNode.ChannelDetails sendWorkerChannel : receiveWorkerChannels) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, count++);
            mv.visitLdcInsn((Object)sendWorkerChannel.name);
            mv.visitInsn(83);
        }
        mv.visitVarInsn(58, receiveWorkerChannelNamesVar);
        JvmCodeGenUtil.loadWorkerChannelMap(mv, func, channelMapVarIndex, localVarOffset);
        mv.visitVarInsn(25, receiveWorkerChannelNamesVar);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/WorkerUtils", "addWorkerChannels", "(Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;[Ljava/lang/String;)V", false);
        return receiveWorkerChannelNamesVar;
    }

    private void genDefaultValue(MethodVisitor mv, BType bType, int index) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            mv.visitInsn(9);
            mv.visitVarInsn(55, index);
            return;
        }
        if (TypeTags.isStringTypeTag(bType.tag) || TypeTags.isXMLTypeTag(bType.tag)) {
            mv.visitInsn(1);
            mv.visitVarInsn(58, index);
            return;
        }
        switch (bType.tag) {
            case 2: 
            case 6: {
                mv.visitInsn(3);
                mv.visitVarInsn(54, index);
                break;
            }
            case 3: {
                mv.visitInsn(14);
                mv.visitVarInsn(57, index);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 45: 
            case 50: 
            case 53: {
                mv.visitInsn(1);
                mv.visitVarInsn(58, index);
                break;
            }
            case 0x7FFFFFFF: {
                this.genJDefaultValue(mv, (JType)bType, index);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(bType));
            }
        }
    }

    private void genJDefaultValue(MethodVisitor mv, JType jType, int index) {
        switch (jType.jTag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                mv.visitInsn(3);
                mv.visitVarInsn(54, index);
                break;
            }
            case 5: {
                mv.visitInsn(9);
                mv.visitVarInsn(55, index);
                break;
            }
            case 6: {
                mv.visitInsn(11);
                mv.visitVarInsn(56, index);
                break;
            }
            case 7: {
                mv.visitInsn(14);
                mv.visitVarInsn(57, index);
                break;
            }
            case 9: 
            case 10: {
                mv.visitInsn(1);
                mv.visitVarInsn(58, index);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(jType));
            }
        }
    }

    void generateBasicBlocks(MethodVisitor mv, LabelGenerator labelGen, JvmErrorGen errorGen, JvmInstructionGen instGen, JvmTerminatorGen termGen, String moduleClassName, BIRNode.BIRFunction func, int returnVarRefIndex, int channelMapVarIndex, int localVarOffset, BIRNode.BIRPackage module, BType attachedType, int sendWorkerChannelNamesVar, int receiveWorkerChannelNamesVar) {
        String funcName = func.name.value;
        BirScope lastScope = null;
        HashSet<BirScope> visitedScopesSet = new HashSet<BirScope>();
        for (int i = 0; i < func.basicBlocks.size(); ++i) {
            BIRNode.BIRBasicBlock bb = func.basicBlocks.get(i);
            Label bbLabel = labelGen.getLabel(funcName + bb.id.value);
            mv.visitLabel(bbLabel);
            lastScope = JvmCodeGenUtil.getLastScopeFromBBInsGen(mv, labelGen, instGen, localVarOffset, funcName, bb, visitedScopesSet, lastScope);
            Label bbEndLabel = labelGen.getLabel(funcName + bb.id.value + "beforeTerm");
            mv.visitLabel(bbEndLabel);
            BIRTerminator terminator = bb.terminator;
            this.processTerminator(mv, module, funcName, terminator);
            termGen.genTerminator(terminator, moduleClassName, func, funcName, localVarOffset, returnVarRefIndex, attachedType, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar);
            lastScope = JvmCodeGenUtil.getLastScopeFromTerminator(mv, bb, funcName, labelGen, lastScope, visitedScopesSet);
            errorGen.generateTryCatch(func, funcName, bb, termGen, labelGen, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar, localVarOffset);
            BIRNode.BIRBasicBlock thenBB = terminator.thenBB;
            JvmCodeGenUtil.genGotoThenBB(mv, thenBB, labelGen, terminator, funcName);
        }
    }

    private static void createWorkerPanicLabels(BIRNode.BIRFunction func, MethodVisitor mv, Label tryLabel) {
        if (func.workerChannels.length == 0) {
            return;
        }
        mv.visitLabel(tryLabel);
    }

    private static void handleWorkerPanic(BIRNode.BIRFunction func, MethodVisitor mv, Label tryLabel, Label catchLabel, Label handleThrowableLabel, int channelMapVarIndex, int sendWorkerChannelNamesVar, int receiveWorkerChannelNamesVar, int localVarOffset) {
        if (func.workerChannels.length == 0) {
            return;
        }
        mv.visitTryCatchBlock(tryLabel, catchLabel, handleThrowableLabel, "java/lang/Throwable");
        mv.visitLabel(catchLabel);
        Label label3 = new Label();
        mv.visitJumpInsn(167, label3);
        mv.visitLabel(handleThrowableLabel);
        mv.visitVarInsn(58, 2);
        JvmCodeGenUtil.loadWorkerChannelMap(mv, func, channelMapVarIndex, localVarOffset);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, sendWorkerChannelNamesVar);
        mv.visitVarInsn(25, receiveWorkerChannelNamesVar);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/WorkerUtils", "completeWorkerChannelsWithPanic", "(Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;Ljava/lang/Throwable;[Ljava/lang/String;[Ljava/lang/String;)V", false);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(191);
        mv.visitLabel(label3);
    }

    private void processTerminator(MethodVisitor mv, BIRNode.BIRPackage module, String funcName, BIRTerminator terminator) {
        if (terminator.kind == InstructionKind.GOTO && ((BIRTerminator.GOTO)terminator).targetBB.terminator.kind == InstructionKind.RETURN && ((BIRTerminator.GOTO)terminator).targetBB.terminator.pos != null) {
            Label label = new Label();
            mv.visitLabel(label);
            mv.visitLineNumber(((BIRTerminator.GOTO)terminator).targetBB.terminator.pos.lineRange().endLine().line() + 1, label);
        } else if (terminator.kind != InstructionKind.RETURN) {
            JvmCodeGenUtil.generateDiagnosticPos(terminator.pos, mv);
        }
        if (this.isStartFunction(funcName) && terminator.kind == InstructionKind.RETURN) {
            mv.visitInsn(4);
            mv.visitFieldInsn(179, JvmModuleUtils.getModuleLevelClassName(module.packageID, "$_init"), "$moduleStarted", "Z");
        }
    }

    private boolean isModuleTestInitFunction(BIRNode.BIRFunction func) {
        return func.name.value.equals(MethodGenUtils.encodeModuleSpecialFuncName(".<testinit>"));
    }

    private boolean isStartFunction(String functionName) {
        return functionName.equals(MethodGenUtils.encodeModuleSpecialFuncName(".<start>"));
    }

    private boolean isModuleInitFunction(String functionName) {
        return functionName.equals(MethodGenUtils.encodeModuleSpecialFuncName("$moduleInit"));
    }

    private boolean isModuleStartFunction(String functionName) {
        return functionName.equals(MethodGenUtils.encodeModuleSpecialFuncName("$moduleStart"));
    }

    private void createLocalVariableTable(BIRNode.BIRFunction func, BIRVarToJVMIndexMap indexMap, int localVarOffset, MethodVisitor mv, Label methodStartLabel, LabelGenerator labelGen, Label methodEndLabel, boolean isObjectMethodSplit) {
        String funcName = func.name.value;
        mv.visitLocalVariable("__strand", "Lio/ballerina/runtime/internal/scheduling/Strand;", null, methodStartLabel, methodEndLabel, localVarOffset);
        if (func.receiver != null) {
            int selfIndex = isObjectMethodSplit ? 1 : 0;
            mv.visitLocalVariable("self", "Lio/ballerina/runtime/api/values/BObject;", null, methodStartLabel, methodEndLabel, selfIndex);
        }
        for (int i = localVarOffset; i < func.localVars.size(); ++i) {
            String metaVarName;
            BIRNode.BIRVariableDcl localVar = func.localVars.get(i);
            Label startLabel = methodStartLabel;
            Label endLabel = methodEndLabel;
            if (!this.isValidArg(localVar)) continue;
            if (localVar.kind == VarKind.LOCAL) {
                if (localVar.startBB != null) {
                    startLabel = labelGen.getLabel(funcName + "_SCOPE_" + localVar.insScope.id());
                }
                if (localVar.endBB != null) {
                    endLabel = labelGen.getLabel(funcName + localVar.endBB.id.value + "beforeTerm");
                }
            }
            if (!this.isCompilerAddedVars(metaVarName = localVar.metaVarName)) continue;
            mv.visitLocalVariable(metaVarName, this.getJVMTypeSign(localVar.type), null, startLabel, endLabel, indexMap.addIfNotExists(localVar.name.value, localVar.type));
        }
    }

    private boolean isValidArg(BIRNode.BIRVariableDcl localVar) {
        boolean localArg = localVar.kind == VarKind.LOCAL || localVar.kind == VarKind.ARG;
        boolean synArg = JvmCodeGenUtil.getImpliedType((BType)localVar.type).tag == 6 && localVar.name.value.startsWith("%syn");
        boolean lambdaMapArg = localVar.metaVarName != null && localVar.metaVarName.startsWith("$map$block$") && localVar.kind == VarKind.SYNTHETIC;
        return localArg && !synArg || lambdaMapArg;
    }

    private boolean isCompilerAddedVars(String metaVarName) {
        return !(metaVarName == null || metaVarName.isEmpty() || metaVarName.startsWith("$") && metaVarName.endsWith("$") || metaVarName.startsWith("$$") && metaVarName.endsWith("$$") || metaVarName.startsWith("_$$_"));
    }

    private String getJVMTypeSign(BType bType) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return "J";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return "Ljava/lang/String;";
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return "Lio/ballerina/runtime/internal/values/XmlValue;";
        }
        if (53 == bType.tag) {
            return "Lio/ballerina/runtime/internal/values/RegExpValue;";
        }
        return switch (bType.tag) {
            case 2 -> "I";
            case 3 -> "D";
            case 6 -> "Z";
            case 4 -> "Lio/ballerina/runtime/internal/values/DecimalValue;";
            case 12, 16 -> "Lio/ballerina/runtime/internal/values/MapValue;";
            case 15 -> "Lio/ballerina/runtime/internal/values/StreamValue;";
            case 9 -> "Lio/ballerina/runtime/internal/values/TableValue;";
            case 20, 31 -> "Lio/ballerina/runtime/internal/values/ArrayValue;";
            case 34 -> "Lio/ballerina/runtime/api/values/BObject;";
            case 29 -> "Lio/ballerina/runtime/internal/values/ErrorValue;";
            case 32 -> "Lio/ballerina/runtime/internal/values/FutureValue;";
            case 17 -> "Lio/ballerina/runtime/internal/values/FPValue;";
            case 37 -> "Lio/ballerina/runtime/internal/values/HandleValue;";
            case 13 -> "Lio/ballerina/runtime/internal/values/TypedescValue;";
            case 7, 10, 11, 18, 21, 33, 38, 50 -> "Ljava/lang/Object;";
            case Integer.MAX_VALUE -> InteropMethodGen.getJTypeSignature((JType)bType);
            default -> throw new BLangCompilerException("JVM code generation is not supported for type " + String.valueOf(bType));
        };
    }
}

