/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.methodgen;

import io.ballerina.identifier.Utils;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;
import org.wso2.ballerinalang.compiler.util.Names;

public final class MethodGenUtils {
    static boolean hasInitFunction(BIRNode.BIRPackage pkg) {
        for (BIRNode.BIRFunction func : pkg.functions) {
            if (func == null || !MethodGenUtils.isModuleInitFunction(func)) continue;
            return true;
        }
        return false;
    }

    static boolean isModuleInitFunction(BIRNode.BIRFunction func) {
        return func.name.value.equals(MethodGenUtils.encodeModuleSpecialFuncName(".<init>"));
    }

    public static void visitReturn(MethodVisitor mv, String funcName, String className) {
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, funcName, className);
        mv.visitEnd();
    }

    public static String encodeModuleSpecialFuncName(String funcSuffix) {
        return Utils.encodeFunctionIdentifier((String)funcSuffix);
    }

    static String calculateLambdaStopFuncName(PackageID id) {
        String orgName = id.orgName.value;
        Object moduleName = id.isTestPkg ? id.name.value + String.valueOf(Names.TEST_PACKAGE) : id.name.value;
        String version = CompilerUtils.getMajorVersion(id.version.value);
        String funcSuffix = ".<stop>";
        String funcName = ((String)moduleName).equals("&0046") ? ".." + funcSuffix : (version.isEmpty() ? (String)moduleName + "." + funcSuffix : (String)moduleName + ":" + version + "." + funcSuffix);
        if (!orgName.equalsIgnoreCase("$anon")) {
            funcName = orgName + "/" + funcName;
        }
        return "$lambda$" + Utils.encodeFunctionIdentifier((String)funcName);
    }

    private MethodGenUtils() {
    }
}

