/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.model;

import io.ballerina.runtime.api.Environment;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.bir.codegen.exceptions.JInteropException;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethodKind;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JMethod {
    public static final JMethod NO_SUCH_METHOD = new JMethod(null, null, null);
    public static final String BAL_ENV_CANONICAL_NAME = Environment.class.getCanonicalName();
    public JMethodKind kind;
    private final Executable method;
    private BType receiverType;
    public boolean hasBundledPathParams = false;
    public boolean hasBundledFunctionParams = false;

    private JMethod(JMethodKind kind, Executable executable, BType receiverType) {
        this.kind = kind;
        this.method = executable;
        this.receiverType = receiverType;
    }

    public static JMethod build(JMethodKind kind, Executable executable, BType receiverType) {
        return new JMethod(kind, executable, receiverType);
    }

    public String getClassName() {
        return this.method.getDeclaringClass().getName();
    }

    public boolean isDeclaringClassInterface() {
        return this.method.getDeclaringClass().isInterface();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public boolean isInstanceMethod() {
        return !this.isStatic() && !(this.method instanceof Constructor);
    }

    public String getName() {
        if (this.kind == JMethodKind.CONSTRUCTOR) {
            return "<init>";
        }
        return this.method.getName();
    }

    public JMethodKind getKind() {
        return this.kind;
    }

    public Executable getMethod() {
        return this.method;
    }

    public String getSignature() {
        if (this.kind == JMethodKind.CONSTRUCTOR) {
            return JvmCodeGenUtil.getMethodSig(Void.TYPE, this.method.getParameterTypes());
        }
        return JvmCodeGenUtil.getMethodSig(this.getReturnType(), this.method.getParameterTypes());
    }

    public Class<?>[] getParamTypes() {
        return this.method.getParameterTypes();
    }

    public Class<?> getReturnType() {
        if (this.kind == JMethodKind.CONSTRUCTOR) {
            return this.method.getDeclaringClass();
        }
        return ((Method)this.method).getReturnType();
    }

    public BType getReceiverType() {
        return this.receiverType;
    }

    public void setReceiverType(BType receiverType) {
        this.receiverType = receiverType;
    }

    public Class<?>[] getExceptionTypes() {
        ArrayList checkedExceptions = new ArrayList();
        try {
            Class<?> runtimeException = ClassLoader.getSystemClassLoader().loadClass(RuntimeException.class.getCanonicalName());
            for (Class<?> exceptionType : this.method.getExceptionTypes()) {
                if (runtimeException.isAssignableFrom(exceptionType)) continue;
                checkedExceptions.add(exceptionType);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticErrorCode.CLASS_NOT_FOUND, e.getMessage(), e);
        }
        return checkedExceptions.toArray(new Class[0]);
    }

    public boolean isBalEnvAcceptingMethod() {
        Class<?>[] paramTypes = this.getParamTypes();
        return paramTypes.length > 0 && paramTypes[0].getCanonicalName().equals(BAL_ENV_CANONICAL_NAME);
    }
}

