/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split;

import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BTypeHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadingDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmArrayTypeConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmBStringConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmErrorTypeConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmFunctionTypeConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmModuleConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmRefTypeConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmTupleTypeConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmUnionTypeConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeHashVisitor;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;

public class JvmConstantsGen {
    private final JvmUnionTypeConstantsGen unionTypeConstantsGen;
    private final JvmErrorTypeConstantsGen errorTypeConstantsGen;
    private final JvmBStringConstantsGen stringConstantsGen;
    private final JvmModuleConstantsGen moduleConstantsGen;
    private final JvmTupleTypeConstantsGen tupleTypeConstantsGen;
    private final JvmArrayTypeConstantsGen arrayTypeConstantsGen;
    private final JvmRefTypeConstantsGen refTypeConstantsGen;
    private final JvmFunctionTypeConstantsGen functionTypeConstantsGen;
    public final BTypeHashComparator bTypeHashComparator;
    public final String allConstantsClassName;
    public final String allGlobalVarsClassName;
    public final String constantsPkgName;
    public final String globalVarsPkgName;

    public JvmConstantsGen(BIRNode.BIRPackage module, Types types, TypeHashVisitor typeHashVisitor, JarEntries jarEntries) {
        this.bTypeHashComparator = new BTypeHashComparator(typeHashVisitor);
        this.stringConstantsGen = new JvmBStringConstantsGen(module.packageID);
        this.moduleConstantsGen = new JvmModuleConstantsGen(module);
        this.functionTypeConstantsGen = new JvmFunctionTypeConstantsGen(module.packageID, this);
        this.unionTypeConstantsGen = new JvmUnionTypeConstantsGen(module.packageID, this.bTypeHashComparator, jarEntries);
        this.errorTypeConstantsGen = new JvmErrorTypeConstantsGen(module.packageID, this.bTypeHashComparator, jarEntries);
        this.tupleTypeConstantsGen = new JvmTupleTypeConstantsGen(module.packageID, this.bTypeHashComparator, jarEntries);
        this.arrayTypeConstantsGen = new JvmArrayTypeConstantsGen(module.packageID, this.bTypeHashComparator, types, jarEntries);
        this.refTypeConstantsGen = new JvmRefTypeConstantsGen(module, this.bTypeHashComparator, jarEntries);
        this.globalVarsPkgName = JvmModuleUtils.getModuleLevelClassName(module.packageID, "identifiers/global_vars/");
        this.constantsPkgName = JvmModuleUtils.getModuleLevelClassName(module.packageID, "identifiers/constants/");
        this.allGlobalVarsClassName = JvmModuleUtils.getModuleLevelClassName(module.packageID, "$global_vars");
        this.allConstantsClassName = JvmModuleUtils.getModuleLevelClassName(module.packageID, "$constants");
    }

    public void loadBStringConstant(MethodVisitor mv, String value, String varName, String constantVarClassName, boolean isConstant) {
        this.stringConstantsGen.loadBStringConstant(mv, value, varName, constantVarClassName, isConstant);
    }

    public String getModuleConstantVar(PackageID packageID) {
        return this.moduleConstantsGen.addModule(packageID);
    }

    public void setJvmCreateTypeGen(JvmCreateTypeGen jvmCreateTypeGen) {
        this.unionTypeConstantsGen.setJvmUnionTypeGen(jvmCreateTypeGen.getJvmUnionTypeGen());
        this.errorTypeConstantsGen.setJvmErrorTypeGen(jvmCreateTypeGen.getJvmErrorTypeGen());
        this.tupleTypeConstantsGen.setJvmTupleTypeGen(jvmCreateTypeGen.getJvmTupleTypeGen());
        this.arrayTypeConstantsGen.setJvmArrayTypeGen(jvmCreateTypeGen.getJvmArrayTypeGen());
        this.refTypeConstantsGen.setJvmRefTypeGen(jvmCreateTypeGen.getJvmRefTypeGen());
        this.functionTypeConstantsGen.setJvmTypeGen(jvmCreateTypeGen.getJvmTypeGen());
    }

    public void generateConstants(JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, List<BIRNode.BIRFunction> sortedFunctions, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector, JarEntries jarEntries) {
        this.functionTypeConstantsGen.generateClass(jvmPackageGen, jvmCastGen, sortedFunctions, asyncDataCollector, lazyLoadingDataCollector, jarEntries);
        this.moduleConstantsGen.generateConstantInit(jarEntries);
        this.stringConstantsGen.generateConstantInit(jarEntries);
    }

    public void generateGetBErrorType(MethodVisitor mv, String varName) {
        this.errorTypeConstantsGen.generateGetBErrorType(mv, varName);
    }

    public void generateGetBUnionType(MethodVisitor mv, String varName) {
        this.unionTypeConstantsGen.generateGetBUnionType(mv, varName);
    }

    public void generateGetBTupleType(MethodVisitor mv, String varName) {
        this.tupleTypeConstantsGen.generateGetBTupleType(mv, varName);
    }

    public String getErrorTypeConstantsVar(BType type) {
        return this.errorTypeConstantsGen.add((BErrorType)type);
    }

    public String getArrayTypeConstantsVar(BType type) {
        return this.arrayTypeConstantsGen.add((BArrayType)type);
    }

    public String getTupleTypeConstantsVar(BType type, SymbolTable symbolTable) {
        return this.tupleTypeConstantsGen.add((BTupleType)type, symbolTable);
    }

    public void getRefTypeConstantsVar(BIRNode.BIRTypeDefinition typeDef, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector) {
        this.refTypeConstantsGen.add(typeDef, jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector);
    }

    public String getUnionTypeConstantsVar(BType type, SymbolTable symbolTable) {
        return this.unionTypeConstantsGen.add((BUnionType)type, symbolTable);
    }

    public String getModuleConstantClass(String varName) {
        return this.moduleConstantsGen.getModuleConstantsClass(varName);
    }

    public String getFunctionTypeConstantClass(String varName) {
        return this.functionTypeConstantsGen.getFunctionTypeConstantClass(varName);
    }

    public void generateGetBArrayType(MethodVisitor mv, String varName) {
        this.arrayTypeConstantsGen.generateGetBArrayType(mv, varName);
    }
}

