/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split;

import io.ballerina.identifier.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadBirBasicBlock;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadingDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.TypeDefHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.model.DoubleCheckLabelsRecord;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmArrayTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmErrorTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmObjectTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmRecordTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmRefTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmTupleTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmUnionTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmConstantGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.LazyLoadingCodeGenUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeHashVisitor;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.NamedNode;

public class JvmCreateTypeGen {
    private static final Type VOID_METHOD_DESC_TYPE = Type.getType((String)"()V");
    private final JvmTypeGen jvmTypeGen;
    private final JvmConstantsGen jvmConstantsGen;
    private final JvmRecordTypeGen jvmRecordTypeGen;
    private final JvmObjectTypeGen jvmObjectTypeGen;
    private final JvmErrorTypeGen jvmErrorTypeGen;
    private final JvmUnionTypeGen jvmUnionTypeGen;
    private final JvmTupleTypeGen jvmTupleTypeGen;
    private final JvmArrayTypeGen jvmArrayTypeGen;
    private final JvmRefTypeGen jvmRefTypeGen;
    private final TypeHashVisitor typeHashVisitor;
    public final TypeDefHashComparator typeDefHashComparator;
    private final String anonTypesClass;
    private final String recordTypesClass;
    private final String functionTypesClass;
    private final String allTypesVarClassName;
    private final String annotationVarClassName;

    public JvmCreateTypeGen(JvmTypeGen jvmTypeGen, JvmConstantsGen jvmConstantsGen, BIRNode.BIRPackage module, TypeHashVisitor typeHashVisitor) {
        this.jvmTypeGen = jvmTypeGen;
        this.jvmConstantsGen = jvmConstantsGen;
        this.jvmRecordTypeGen = new JvmRecordTypeGen(this, jvmTypeGen, jvmConstantsGen);
        this.jvmObjectTypeGen = new JvmObjectTypeGen(this, jvmTypeGen, jvmConstantsGen);
        this.jvmErrorTypeGen = new JvmErrorTypeGen(this, jvmTypeGen, jvmConstantsGen);
        this.jvmUnionTypeGen = new JvmUnionTypeGen(this, jvmTypeGen, jvmConstantsGen);
        this.jvmTupleTypeGen = new JvmTupleTypeGen(this, jvmTypeGen, jvmConstantsGen);
        this.jvmRefTypeGen = new JvmRefTypeGen(this, jvmTypeGen, jvmConstantsGen);
        this.jvmArrayTypeGen = new JvmArrayTypeGen(jvmTypeGen);
        this.typeHashVisitor = typeHashVisitor;
        this.typeDefHashComparator = new TypeDefHashComparator(typeHashVisitor);
        this.allTypesVarClassName = JvmModuleUtils.getModuleLevelClassName(module.packageID, "$types");
        this.anonTypesClass = JvmModuleUtils.getModuleLevelClassName(module.packageID, "types/anon_types");
        this.recordTypesClass = JvmModuleUtils.getModuleLevelClassName(module.packageID, "types/record_types");
        this.functionTypesClass = JvmModuleUtils.getModuleLevelClassName(module.packageID, "types/function_types");
        this.annotationVarClassName = JvmCodeGenUtil.getVarStoreClass(jvmConstantsGen.globalVarsPkgName, "$annotation_data");
    }

    public void createTypes(BIRNode.BIRPackage module, JarEntries jarEntries, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector) {
        BallerinaClassWriter allTypesCW = new BallerinaClassWriter(2);
        allTypesCW.visit(65, 33, this.allTypesVarClassName, null, "java/lang/Object", null);
        block6: for (BIRNode.BIRTypeDefinition typeDef : module.typeDefs) {
            BType bType = typeDef.type;
            int bTypeTag = bType.tag;
            switch (bTypeTag) {
                case 12: {
                    this.createRecordType(typeDef, allTypesCW, module, jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector, jarEntries);
                    continue block6;
                }
                case 34: {
                    this.createObjectType(typeDef, allTypesCW, jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector, jarEntries);
                    continue block6;
                }
                case 29: {
                    this.createErrorType(typeDef, allTypesCW, jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector, jarEntries);
                    continue block6;
                }
                case 31: {
                    this.createTupleType(typeDef, allTypesCW, jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector, jarEntries);
                    continue block6;
                }
            }
            this.createUnionType(typeDef, allTypesCW, jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector, jarEntries);
        }
        allTypesCW.visitEnd();
        String typesClass = this.allTypesVarClassName + ".class";
        jarEntries.put(typesClass, jvmPackageGen.getBytes(allTypesCW, module));
    }

    private void createRecordType(BIRNode.BIRTypeDefinition typeDef, ClassWriter allTypesCW, BIRNode.BIRPackage module, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector, JarEntries jarEntries) {
        BType bType = typeDef.type;
        int bTypeTag = bType.tag;
        if (JvmCodeGenUtil.needNoTypeGeneration(bTypeTag)) {
            return;
        }
        String varName = typeDef.internalName.value;
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        JvmCreateTypeGen.genFieldsForInitFlags(cw);
        String typeClass = this.jvmTypeGen.recordTypesPkgName + typeDef.internalName.value;
        JvmConstantGenUtils.generateConstantsClassInit(cw, typeClass);
        this.loadAnnotations(cw, varName, typeClass, "Lio/ballerina/runtime/internal/types/BRecordType;", jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector);
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        this.jvmRecordTypeGen.createRecordType(cw, mv, module, typeClass, (BRecordType)bType, varName, true, jvmPackageGen.symbolTable);
        JvmCodeGenUtil.genMethodReturn(mv);
        cw.visitEnd();
        jarEntries.put(typeClass + ".class", cw.toByteArray());
        LazyLoadingCodeGenUtils.addDebugField(allTypesCW, varName);
    }

    private void createObjectType(BIRNode.BIRTypeDefinition typeDef, ClassWriter allTypesCW, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector, JarEntries jarEntries) {
        BObjectType bType = (BObjectType)typeDef.type;
        int bTypeTag = bType.tag;
        if (JvmCodeGenUtil.needNoTypeGeneration(bTypeTag)) {
            return;
        }
        String varName = typeDef.internalName.value;
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        JvmCreateTypeGen.genFieldsForInitFlags(cw);
        String typeClass = this.jvmTypeGen.objectTypesPkgName + typeDef.internalName.value;
        JvmConstantGenUtils.generateConstantsClassInit(cw, typeClass);
        boolean isAnnotatedType = false;
        if (!typeDef.isBuiltin || typeDef.referenceType == null) {
            boolean constructorsPopulated = Symbols.isFlagOn(bType.getFlags(), 0x100000000L);
            this.loadAnnotations(cw, bType, varName, typeClass, constructorsPopulated, jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector);
            isAnnotatedType = true;
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        this.jvmObjectTypeGen.createObjectType(cw, mv, typeClass, bType, varName, isAnnotatedType, new BIRVarToJVMIndexMap(), jvmPackageGen.symbolTable);
        JvmCodeGenUtil.genMethodReturn(mv);
        cw.visitEnd();
        jarEntries.put(typeClass + ".class", cw.toByteArray());
        LazyLoadingCodeGenUtils.addDebugField(allTypesCW, varName);
    }

    private void createErrorType(BIRNode.BIRTypeDefinition typeDef, ClassWriter allTypesCW, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector, JarEntries jarEntries) {
        BType bType = typeDef.type;
        int bTypeTag = bType.tag;
        if (JvmCodeGenUtil.needNoTypeGeneration(bTypeTag)) {
            return;
        }
        String varName = typeDef.internalName.value;
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        JvmCreateTypeGen.genFieldsForInitFlags(cw);
        String typeClass = this.jvmTypeGen.errorTypesPkgName + typeDef.internalName.value;
        JvmConstantGenUtils.generateConstantsClassInit(cw, typeClass);
        boolean isAnnotatedType = false;
        if (!typeDef.isBuiltin || typeDef.referenceType == null) {
            this.loadAnnotations(cw, varName, typeClass, "Lio/ballerina/runtime/internal/types/BErrorType;", jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector);
            isAnnotatedType = true;
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        this.jvmErrorTypeGen.createErrorType(cw, mv, (BErrorType)bType, typeClass, isAnnotatedType);
        JvmCodeGenUtil.genMethodReturn(mv);
        cw.visitEnd();
        jarEntries.put(typeClass + ".class", cw.toByteArray());
        LazyLoadingCodeGenUtils.addDebugField(allTypesCW, varName);
    }

    private void createTupleType(BIRNode.BIRTypeDefinition typeDef, ClassWriter allTypesCW, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector, JarEntries jarEntries) {
        BType bType = typeDef.type;
        int bTypeTag = bType.tag;
        if (JvmCodeGenUtil.needNoTypeGeneration(bTypeTag)) {
            return;
        }
        String varName = typeDef.internalName.value;
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        JvmCreateTypeGen.genFieldsForInitFlags(cw);
        String typeClass = this.jvmTypeGen.tupleTypesPkgName + typeDef.internalName.value;
        JvmConstantGenUtils.generateConstantsClassInit(cw, typeClass);
        boolean isAnnotatedType = false;
        if (!typeDef.isBuiltin || typeDef.referenceType == null) {
            this.loadAnnotations(cw, varName, typeClass, "Lio/ballerina/runtime/internal/types/BTupleType;", jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector);
            isAnnotatedType = true;
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        this.jvmTupleTypeGen.createTupleType(cw, mv, typeClass, (BTupleType)bType, isAnnotatedType, jvmPackageGen.symbolTable, 2);
        JvmCodeGenUtil.genMethodReturn(mv);
        cw.visitEnd();
        jarEntries.put(typeClass + ".class", cw.toByteArray());
        LazyLoadingCodeGenUtils.addDebugField(allTypesCW, varName);
    }

    private void createUnionType(BIRNode.BIRTypeDefinition typeDef, ClassWriter allTypesCW, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector, JarEntries jarEntries) {
        BType bType = typeDef.type;
        int bTypeTag = bType.tag;
        if (JvmCodeGenUtil.needNoTypeGeneration(bTypeTag)) {
            return;
        }
        String varName = typeDef.internalName.value;
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        JvmCreateTypeGen.genFieldsForInitFlags(cw);
        String typeClass = this.jvmTypeGen.unionTypesPkgName + typeDef.internalName.value;
        JvmConstantGenUtils.generateConstantsClassInit(cw, typeClass);
        boolean isAnnotatedType = false;
        if (!typeDef.isBuiltin || typeDef.referenceType == null || bTypeTag == 12) {
            this.loadAnnotations(cw, varName, typeClass, "Lio/ballerina/runtime/internal/types/BUnionType;", jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector);
            isAnnotatedType = true;
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        this.jvmUnionTypeGen.createUnionType(cw, mv, typeClass, varName, (BUnionType)bType, isAnnotatedType, jvmPackageGen.symbolTable);
        JvmCodeGenUtil.genMethodReturn(mv);
        cw.visitEnd();
        jarEntries.put(typeClass + ".class", cw.toByteArray());
        LazyLoadingCodeGenUtils.addDebugField(allTypesCW, varName);
    }

    public static void genFieldsForInitFlags(ClassWriter cw) {
        cw.visitField(74, "i", "Z", null, null).visitEnd();
        cw.visitField(74, "o", "Z", null, null).visitEnd();
    }

    public static DoubleCheckLabelsRecord genDoubleCheckGetStart(MethodVisitor mv, String typeClass, String typeDescriptor) {
        Label tryStart = new Label();
        Label tryEnd = new Label();
        Label tryHandler = new Label();
        mv.visitTryCatchBlock(tryStart, tryEnd, tryHandler, null);
        mv.visitFieldInsn(178, typeClass, "i", "Z");
        Label ifInit = new Label();
        mv.visitJumpInsn(153, ifInit);
        mv.visitFieldInsn(178, typeClass, "t", typeDescriptor);
        mv.visitInsn(176);
        mv.visitLabel(ifInit);
        mv.visitFieldInsn(178, typeClass, "o", "Z");
        Label ifOnInitWithLock = new Label();
        mv.visitJumpInsn(153, ifOnInitWithLock);
        mv.visitFieldInsn(178, "io/ballerina/runtime/internal/TypeInitializer", "TYPE_INITIALIZING_GLOBAL_LOCK", "Ljava/util/concurrent/locks/ReentrantLock;");
        mv.visitMethodInsn(182, "java/util/concurrent/locks/ReentrantLock", "isHeldByCurrentThread", "()Z", false);
        mv.visitJumpInsn(153, ifOnInitWithLock);
        mv.visitFieldInsn(178, typeClass, "t", typeDescriptor);
        mv.visitInsn(176);
        mv.visitLabel(ifOnInitWithLock);
        mv.visitFieldInsn(178, "io/ballerina/runtime/internal/TypeInitializer", "TYPE_INITIALIZING_GLOBAL_LOCK", "Ljava/util/concurrent/locks/ReentrantLock;");
        mv.visitMethodInsn(182, "java/util/concurrent/locks/ReentrantLock", "lock", "()V", false);
        mv.visitLabel(tryStart);
        mv.visitFieldInsn(178, typeClass, "i", "Z");
        mv.visitJumpInsn(154, tryEnd);
        mv.visitInsn(4);
        mv.visitFieldInsn(179, typeClass, "o", "Z");
        return new DoubleCheckLabelsRecord(tryEnd, tryHandler);
    }

    public static void endDoubleCheckGetEnd(MethodVisitor mv, String typeClass, String typeDescriptor, DoubleCheckLabelsRecord checkLabelsRecord, boolean isAnnotatedType) {
        if (isAnnotatedType) {
            mv.visitInvokeDynamicInsn("run", "()Ljava/lang/Runnable;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), new Object[]{VOID_METHOD_DESC_TYPE, new Handle(6, typeClass, "loadAnnotations", "()V", false), VOID_METHOD_DESC_TYPE});
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeInitializer", "loadTypeAnnotations", "(Ljava/lang/Runnable;)V", false);
        } else {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeInitializer", "loadTypeAnnotations", "()V", false);
        }
        if (!isAnnotatedType) {
            JvmCreateTypeGen.setTypeInitStatus(mv, typeClass);
        }
        mv.visitLabel(checkLabelsRecord.tryEnd());
        mv.visitFieldInsn(178, "io/ballerina/runtime/internal/TypeInitializer", "TYPE_INITIALIZING_GLOBAL_LOCK", "Ljava/util/concurrent/locks/ReentrantLock;");
        mv.visitMethodInsn(182, "java/util/concurrent/locks/ReentrantLock", "unlock", "()V", false);
        Label label5 = new Label();
        mv.visitJumpInsn(167, label5);
        mv.visitLabel(checkLabelsRecord.tryHandler());
        mv.visitVarInsn(58, 0);
        mv.visitFieldInsn(178, "io/ballerina/runtime/internal/TypeInitializer", "TYPE_INITIALIZING_GLOBAL_LOCK", "Ljava/util/concurrent/locks/ReentrantLock;");
        mv.visitMethodInsn(182, "java/util/concurrent/locks/ReentrantLock", "unlock", "()V", false);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(191);
        mv.visitLabel(label5);
        mv.visitFieldInsn(178, typeClass, "t", typeDescriptor);
        mv.visitInsn(176);
    }

    private static void setTypeInitStatus(MethodVisitor mv, String typeClass) {
        mv.visitInsn(4);
        mv.visitFieldInsn(179, typeClass, "i", "Z");
        mv.visitInsn(3);
        mv.visitFieldInsn(179, typeClass, "o", "Z");
    }

    public Optional<BIntersectionType> getImmutableType(BType type, SymbolTable symbolTable) {
        if (type.tsymbol == null) {
            return Optional.empty();
        }
        return Types.getImmutableType(symbolTable, type.tsymbol.pkgID, (SelectivelyImmutableReferenceType)((Object)type));
    }

    public void loadTypeIdSet(MethodVisitor mv, BTypeIdSet typeIdSet) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BTypeIdSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTypeIdSet", "<init>", "()V", false);
        for (BTypeIdSet.BTypeId typeId : typeIdSet.getPrimary()) {
            this.addTypeId(mv, typeId, true);
        }
        for (BTypeIdSet.BTypeId typeId : typeIdSet.getSecondary()) {
            this.addTypeId(mv, typeId, false);
        }
    }

    private void addTypeId(MethodVisitor mv, BTypeIdSet.BTypeId typeId, boolean isPrimaryTypeId) {
        mv.visitInsn(89);
        String moduleVar = this.jvmConstantsGen.getModuleConstantVar(typeId.packageID);
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(moduleVar), moduleVar, "Lio/ballerina/runtime/api/Module;");
        mv.visitLdcInsn((Object)typeId.name);
        mv.visitInsn(isPrimaryTypeId ? 4 : 3);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BTypeIdSet", "add", "(Lio/ballerina/runtime/api/Module;Ljava/lang/String;Z)V", false);
    }

    public static List<Label> createLabelsForSwitch(MethodVisitor mv, int nameRegIndex, List<? extends NamedNode> nodes, int start, int length, Label defaultCaseLabel) {
        return JvmCreateTypeGen.createLabelsForSwitch(mv, nameRegIndex, nodes, start, length, defaultCaseLabel, true);
    }

    public static List<Label> createLabelsForSwitch(MethodVisitor mv, int nameRegIndex, List<? extends NamedNode> nodes, int start, int length, Label defaultCaseLabel, boolean decodeCase) {
        mv.visitVarInsn(25, nameRegIndex);
        mv.visitMethodInsn(182, "java/lang/String", "hashCode", "()I", false);
        int i = 0;
        ArrayList<Label> labels = new ArrayList<Label>();
        int[] hashCodes = new int[length];
        for (int j = start; j < start + length; ++j) {
            NamedNode node = nodes.get(j);
            if (node == null) continue;
            labels.add(i, new Label());
            String name = decodeCase ? Utils.decodeIdentifier((String)node.getName().value) : node.getName().value;
            hashCodes[i] = name.hashCode();
            ++i;
        }
        mv.visitLookupSwitchInsn(defaultCaseLabel, hashCodes, labels.toArray(new Label[0]));
        return labels;
    }

    public static List<Label> createLabelsForEqualCheck(MethodVisitor mv, int nameRegIndex, List<? extends NamedNode> nodes, int start, int length, List<Label> labels, Label defaultCaseLabel) {
        return JvmCreateTypeGen.createLabelsForEqualCheck(mv, nameRegIndex, nodes, start, length, labels, defaultCaseLabel, true);
    }

    public static List<Label> createLabelsForEqualCheck(MethodVisitor mv, int nameRegIndex, List<? extends NamedNode> nodes, int start, int length, List<Label> labels, Label defaultCaseLabel, boolean decodeCase) {
        ArrayList<Label> targetLabels = new ArrayList<Label>();
        int i = 0;
        for (int j = start; j < start + length; ++j) {
            NamedNode node = nodes.get(j);
            if (node == null) continue;
            mv.visitLabel(labels.get(i));
            mv.visitVarInsn(25, nameRegIndex);
            if (decodeCase) {
                mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)node.getName().value));
            } else {
                mv.visitLdcInsn((Object)node.getName().value);
            }
            mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
            Label targetLabel = new Label();
            mv.visitJumpInsn(154, targetLabel);
            mv.visitJumpInsn(167, defaultCaseLabel);
            targetLabels.add(i, targetLabel);
            ++i;
        }
        return targetLabels;
    }

    public void loadAnnotations(ClassWriter cw, String typeName, String typeClass, String descriptor, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector) {
        MethodVisitor mv = cw.visitMethod(9, "loadAnnotations", "()V", null, null);
        mv.visitCode();
        LazyLoadBirBasicBlock lazyBB = lazyLoadingDataCollector.lazyLoadingAnnotationsBBMap.get(typeName);
        if (lazyBB != null) {
            JvmCodeGenUtil.lazyLoadAnnotations(mv, lazyBB, jvmPackageGen, jvmCastGen, this.jvmConstantsGen, this.jvmTypeGen, asyncDataCollector);
        }
        this.processAnnotations(typeClass, descriptor, mv);
        JvmCreateTypeGen.setTypeInitStatus(mv, typeClass);
        JvmCodeGenUtil.genMethodReturn(mv);
    }

    public void loadAnnotations(ClassWriter cw, BObjectType bObjectType, String typeName, String typeClass, boolean constructorsPopulated, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector) {
        MethodVisitor mv = cw.visitMethod(9, "loadAnnotations", "()V", null, null);
        mv.visitCode();
        Map<String, LazyLoadBirBasicBlock> lazyLoadingAnnotationsBBMap = lazyLoadingDataCollector.lazyLoadingAnnotationsBBMap;
        LazyLoadBirBasicBlock lazyBB = lazyLoadingAnnotationsBBMap.get(typeName);
        if (lazyBB != null) {
            JvmCodeGenUtil.lazyLoadAnnotations(mv, lazyBB, jvmPackageGen, jvmCastGen, this.jvmConstantsGen, this.jvmTypeGen, asyncDataCollector);
        }
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)bObjectType.tsymbol;
        List attachedFunctions = objectTypeSymbol.attachedFuncs;
        for (BAttachedFunction attachedFunction : attachedFunctions) {
            lazyBB = lazyLoadingAnnotationsBBMap.get(typeName + "." + String.valueOf(attachedFunction.symbol.originalName));
            if (lazyBB == null) continue;
            JvmCodeGenUtil.lazyLoadAnnotations(mv, lazyBB, jvmPackageGen, jvmCastGen, this.jvmConstantsGen, this.jvmTypeGen, asyncDataCollector);
        }
        if (!constructorsPopulated) {
            this.processAnnotations(typeClass, "Lio/ballerina/runtime/internal/types/BObjectType;", mv);
        }
        JvmCreateTypeGen.setTypeInitStatus(mv, typeClass);
        JvmCodeGenUtil.genMethodReturn(mv);
    }

    private void processAnnotations(String typeClass, String descriptor, MethodVisitor mv) {
        mv.visitFieldInsn(178, this.annotationVarClassName, "v", "Lio/ballerina/runtime/internal/values/MapValue;");
        mv.visitFieldInsn(178, typeClass, "t", descriptor);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/AnnotationUtils", "processAnnotations", "(Lio/ballerina/runtime/internal/values/MapValue;Lio/ballerina/runtime/api/types/Type;)V", false);
    }

    public void generateAnonTypeClass(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, JarEntries jarEntries) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(65, 33, this.anonTypesClass, null, "java/lang/Object", null);
        this.generateGetAnonTypeMainMethod(cw, module.typeDefs);
        cw.visitEnd();
        byte[] bytes = jvmPackageGen.getBytes(cw, module);
        jarEntries.put(this.anonTypesClass + ".class", bytes);
    }

    private void generateGetAnonTypeMainMethod(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefinitions) {
        MethodVisitor mv = cw.visitMethod(9, "getAnonType", "(ILjava/lang/String;)Lio/ballerina/runtime/api/types/Type;", null, null);
        mv.visitCode();
        TreeSet<BIRNode.BIRTypeDefinition> typeDefSet = new TreeSet<BIRNode.BIRTypeDefinition>(this.typeDefHashComparator);
        for (BIRNode.BIRTypeDefinition t : typeDefinitions) {
            if (!Symbols.isFlagOn(t.type.getFlags(), 2048L)) continue;
            typeDefSet.add(t);
        }
        AnonTypeHashInfo anonTypeHashSwitch = this.createLabelsForAnonTypeHashSwitch(typeDefSet);
        if (anonTypeHashSwitch.labelFieldMapping.isEmpty()) {
            Label defaultCaseLabel = new Label();
            JvmCodeGenUtil.createDefaultCaseThrowError(mv, defaultCaseLabel, 1, "No such type: ");
        } else {
            mv.visitVarInsn(21, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, this.anonTypesClass, "getAnonType0", "(ILjava/lang/String;)Lio/ballerina/runtime/api/types/Type;", false);
            mv.visitInsn(176);
            this.generateGetAnonTypeSplitMethods(cw, anonTypeHashSwitch);
        }
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "getAnonType", this.anonTypesClass);
        mv.visitEnd();
    }

    void generateGetAnonTypeSplitMethods(ClassWriter cw, AnonTypeHashInfo anonTypeHashSwitch) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        int hashParamRegIndex = 0;
        int shapeParamRegIndex = 1;
        Label defaultCaseLabel = new Label();
        Map<String, Label> labelFieldMapping = anonTypeHashSwitch.labelFieldMapping;
        int i = 0;
        for (Map.Entry<String, Label> labelEntry : labelFieldMapping.entrySet()) {
            if (bTypesCount % 100 == 0) {
                mv = cw.visitMethod(10, "getAnonType" + methodCount++, "(ILjava/lang/String;)Lio/ballerina/runtime/api/types/Type;", null, null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                mv.visitVarInsn(21, hashParamRegIndex);
                int remainingCases = labelFieldMapping.size() - bTypesCount;
                if (remainingCases > 100) {
                    remainingCases = 100;
                }
                int[] hashes = Arrays.copyOfRange(anonTypeHashSwitch.hashes, bTypesCount, bTypesCount + remainingCases);
                Label[] labels = Arrays.copyOfRange(anonTypeHashSwitch.labels, bTypesCount, bTypesCount + remainingCases);
                mv.visitLookupSwitchInsn(defaultCaseLabel, hashes, labels);
            }
            mv.visitVarInsn(21, hashParamRegIndex);
            String fieldName = labelEntry.getKey();
            Label targetLabel = labelEntry.getValue();
            mv.visitLabel(targetLabel);
            BType type = anonTypeHashSwitch.nameTypeMapping.get(fieldName);
            this.jvmTypeGen.getUserDefinedType(mv, type);
            mv.visitInsn(176);
            ++i;
            if (++bTypesCount % 100 != 0) continue;
            if (bTypesCount == labelFieldMapping.size()) {
                JvmCodeGenUtil.createDefaultCaseThrowError(mv, defaultCaseLabel, shapeParamRegIndex, "No such type: ");
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(21, hashParamRegIndex);
                mv.visitVarInsn(25, shapeParamRegIndex);
                mv.visitMethodInsn(184, this.anonTypesClass, "getAnonType" + methodCount, "(ILjava/lang/String;)Lio/ballerina/runtime/api/types/Type;", false);
                mv.visitInsn(176);
            }
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 100 != 0) {
            JvmCodeGenUtil.createDefaultCaseThrowError(mv, defaultCaseLabel, shapeParamRegIndex, "No such type: ");
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
    }

    private AnonTypeHashInfo createLabelsForAnonTypeHashSwitch(Set<BIRNode.BIRTypeDefinition> nodes) {
        LinkedHashMap<String, Label> labelFieldMapping = new LinkedHashMap<String, Label>();
        LinkedHashMap<Integer, Label> labelHashMapping = new LinkedHashMap<Integer, Label>();
        LinkedHashMap<String, BType> nameTypeMapping = new LinkedHashMap<String, BType>();
        for (BIRNode.BIRTypeDefinition node : nodes) {
            if (node == null) continue;
            BType type = node.type;
            String fieldName = node.internalName.value;
            Integer typeHash = this.typeHashVisitor.visit(type);
            boolean fieldExists = labelFieldMapping.containsKey(fieldName);
            boolean hashExists = labelHashMapping.containsKey(typeHash);
            if (!fieldExists && !hashExists) {
                Label label = new Label();
                labelFieldMapping.put(fieldName, label);
                labelHashMapping.put(typeHash, label);
                nameTypeMapping.put(fieldName, type);
            } else assert (fieldExists && hashExists);
            this.typeHashVisitor.reset();
        }
        int[] hashes = new int[10];
        int count = 0;
        for (Integer integer : labelHashMapping.keySet()) {
            int intValue = integer;
            if (hashes.length == count) {
                hashes = Arrays.copyOf(hashes, count * 2);
            }
            hashes[count++] = intValue;
        }
        hashes = Arrays.copyOfRange(hashes, 0, count);
        Label[] labels = labelHashMapping.values().toArray(new Label[0]);
        return new AnonTypeHashInfo(hashes, labels, labelFieldMapping, nameTypeMapping);
    }

    public void generateRefTypeConstants(List<BIRNode.BIRTypeDefinition> typeDefs, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector) {
        for (BIRNode.BIRTypeDefinition typeDef : typeDefs) {
            if (typeDef.referenceType == null) continue;
            this.jvmConstantsGen.getRefTypeConstantsVar(typeDef, jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector);
        }
    }

    public void generateRecordTypeClass(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, JarEntries jarEntries, List<BIRNode.BIRTypeDefinition> recordTypeDefList) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(65, 33, this.recordTypesClass, null, "java/lang/Object", null);
        this.generateGetRecordTypeMainMethod(cw, recordTypeDefList);
        cw.visitEnd();
        byte[] bytes = jvmPackageGen.getBytes(cw, module);
        jarEntries.put(this.recordTypesClass + ".class", bytes);
    }

    private void generateGetRecordTypeMainMethod(ClassWriter cw, List<BIRNode.BIRTypeDefinition> recordTypeDefList) {
        MethodVisitor mv = cw.visitMethod(9, "getRecordType", "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/RecordType;", null, null);
        mv.visitCode();
        if (recordTypeDefList.isEmpty()) {
            mv.visitInsn(1);
            mv.visitInsn(176);
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, this.recordTypesClass, "getRecordType0", "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/RecordType;", false);
            mv.visitInsn(176);
            this.generateGetRecordTypeSplitMethods(cw, recordTypeDefList);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    void generateGetRecordTypeSplitMethods(ClassWriter cw, List<BIRNode.BIRTypeDefinition> recordTypeDefList) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        int funcNameRegIndex = 0;
        Label defaultCaseLabel = new Label();
        int i = 0;
        List<Object> targetLabels = new ArrayList();
        for (BIRNode.BIRTypeDefinition recordType : recordTypeDefList) {
            if (bTypesCount % 100 == 0) {
                mv = cw.visitMethod(10, "getRecordType" + methodCount++, "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/RecordType;", null, null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                int remainingCases = recordTypeDefList.size() - bTypesCount;
                if (remainingCases > 100) {
                    remainingCases = 100;
                }
                List<Label> labels = JvmCreateTypeGen.createLabelsForSwitch(mv, funcNameRegIndex, recordTypeDefList, bTypesCount, remainingCases, defaultCaseLabel);
                targetLabels = JvmCreateTypeGen.createLabelsForEqualCheck(mv, funcNameRegIndex, recordTypeDefList, bTypesCount, remainingCases, labels, defaultCaseLabel);
                i = 0;
            }
            Label targetLabel = (Label)targetLabels.get(i);
            mv.visitLabel(targetLabel);
            this.jvmTypeGen.getUserDefinedType(mv, recordType.type);
            mv.visitInsn(176);
            ++i;
            if (++bTypesCount % 100 != 0) continue;
            if (bTypesCount == recordTypeDefList.size()) {
                JvmCodeGenUtil.createDefaultCaseReturnNull(mv, defaultCaseLabel);
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(184, this.recordTypesClass, "getRecordType" + methodCount, "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/RecordType;", false);
                mv.visitInsn(176);
            }
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 100 != 0) {
            JvmCodeGenUtil.createDefaultCaseReturnNull(mv, defaultCaseLabel);
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
    }

    public void generateFunctionTypeClass(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, JarEntries jarEntries, List<BIRNode.BIRFunction> sortedFunctions) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(65, 33, this.functionTypesClass, null, "java/lang/Object", null);
        this.generateGetFunctionTypeMainMethod(cw, sortedFunctions);
        cw.visitEnd();
        byte[] bytes = jvmPackageGen.getBytes(cw, module);
        jarEntries.put(this.functionTypesClass + ".class", bytes);
    }

    private void generateGetFunctionTypeMainMethod(ClassWriter cw, List<BIRNode.BIRFunction> sortedFunctions) {
        MethodVisitor mv = cw.visitMethod(9, "getFunctionType", "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/FunctionType;", null, null);
        mv.visitCode();
        if (sortedFunctions.isEmpty()) {
            Label defaultCaseLabel = new Label();
            JvmCodeGenUtil.createDefaultCaseThrowError(mv, defaultCaseLabel, 1, "No such function type: ");
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, this.functionTypesClass, "getFunctionType0", "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/FunctionType;", false);
            mv.visitInsn(176);
            this.generateGetFunctionTypeSplitMethods(cw, sortedFunctions);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    void generateGetFunctionTypeSplitMethods(ClassWriter cw, List<BIRNode.BIRFunction> sortedFunctions) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        int funcNameRegIndex = 0;
        Label defaultCaseLabel = new Label();
        int i = 0;
        List<Object> targetLabels = new ArrayList();
        for (BIRNode.BIRFunction func : sortedFunctions) {
            if (bTypesCount % 100 == 0) {
                mv = cw.visitMethod(10, "getFunctionType" + methodCount++, "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/FunctionType;", null, null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                int remainingCases = sortedFunctions.size() - bTypesCount;
                if (remainingCases > 100) {
                    remainingCases = 100;
                }
                List<Label> labels = JvmCreateTypeGen.createLabelsForSwitch(mv, funcNameRegIndex, sortedFunctions, bTypesCount, remainingCases, defaultCaseLabel, false);
                targetLabels = JvmCreateTypeGen.createLabelsForEqualCheck(mv, funcNameRegIndex, sortedFunctions, bTypesCount, remainingCases, labels, defaultCaseLabel, false);
                i = 0;
            }
            Label targetLabel = (Label)targetLabels.get(i);
            mv.visitLabel(targetLabel);
            String functionName = func.name.value;
            String functionTypeConstantClass = this.jvmConstantsGen.getFunctionTypeConstantClass(functionName);
            mv.visitFieldInsn(178, functionTypeConstantClass, "v", "Lio/ballerina/runtime/api/types/FunctionType;");
            mv.visitInsn(176);
            ++i;
            if (++bTypesCount % 100 != 0) continue;
            if (bTypesCount == sortedFunctions.size()) {
                JvmCodeGenUtil.createDefaultCaseThrowError(mv, defaultCaseLabel, funcNameRegIndex, "No such function type: ");
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(184, this.functionTypesClass, "getFunctionType" + methodCount, "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/FunctionType;", false);
                mv.visitInsn(176);
            }
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 100 != 0) {
            JvmCodeGenUtil.createDefaultCaseThrowError(mv, defaultCaseLabel, funcNameRegIndex, "No such function type: ");
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
    }

    public void splitAddFields(ClassWriter cw, BStructureType bType, String typeClassName) {
        int fieldMapIndex = 0;
        MethodVisitor mv = null;
        int methodCount = 0;
        int fieldsCount = 0;
        Object addFieldMethod = "addFields";
        for (BField field : bType.fields.values()) {
            if (fieldsCount % 500 == 0) {
                mv = cw.visitMethod(10, (String)addFieldMethod, "(Ljava/util/LinkedHashMap;)V", null, null);
                mv.visitCode();
                addFieldMethod = "addFields$" + ++methodCount;
            }
            mv.visitVarInsn(25, fieldMapIndex);
            mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)field.name.value));
            this.createField(mv, field);
            mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitInsn(87);
            if (++fieldsCount % 500 != 0) continue;
            if (fieldsCount != bType.fields.size()) {
                mv.visitVarInsn(25, fieldMapIndex);
                mv.visitMethodInsn(184, typeClassName, (String)addFieldMethod, "(Ljava/util/LinkedHashMap;)V", false);
            }
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)addFieldMethod, typeClassName);
            mv.visitEnd();
        }
        if (methodCount != 0 && fieldsCount % 500 != 0) {
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)addFieldMethod, typeClassName);
            mv.visitEnd();
        }
    }

    private void createField(MethodVisitor mv, BField field) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BField");
        mv.visitInsn(89);
        this.jvmTypeGen.loadType(mv, field.symbol.type);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)field.name.value));
        mv.visitLdcInsn((Object)field.symbol.flags);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BField", "<init>", "(Lio/ballerina/runtime/api/types/Type;Ljava/lang/String;J)V", false);
    }

    public void splitAddDefaultValues(ClassWriter cw, String typeClassName, BRecordType recordType, Map<String, String> fieldNameFPNameMap) {
        int fieldMapIndex = 0;
        MethodVisitor mv = null;
        int methodCount = 0;
        int fieldsCount = 0;
        Object addDefaultValueMethod = "addDefaultValues";
        LinkedHashMap fields = recordType.fields;
        for (Map.Entry<String, String> field : fieldNameFPNameMap.entrySet()) {
            if (fieldsCount % 500 == 0) {
                mv = cw.visitMethod(10, (String)addDefaultValueMethod, "(Ljava/util/LinkedHashMap;)V", null, null);
                mv.visitCode();
                addDefaultValueMethod = "addDefaultValue$" + ++methodCount;
            }
            mv.visitVarInsn(25, fieldMapIndex);
            mv.visitLdcInsn((Object)Utils.unescapeBallerina((String)field.getKey()));
            this.loadDefaultValueFp(mv, field.getValue());
            mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            mv.visitInsn(87);
            if (++fieldsCount % 500 != 0) continue;
            if (fieldsCount != fields.size()) {
                mv.visitVarInsn(25, fieldMapIndex);
                mv.visitMethodInsn(184, typeClassName, (String)addDefaultValueMethod, "(Ljava/util/LinkedHashMap;)V", false);
            }
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)addDefaultValueMethod, typeClassName);
            mv.visitEnd();
        }
        if (methodCount != 0 && fieldsCount % 500 != 0) {
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)addDefaultValueMethod, typeClassName);
            mv.visitEnd();
        }
    }

    private void loadDefaultValueFp(MethodVisitor mv, String functionName) {
        String varClass = JvmCodeGenUtil.getVarStoreClass(this.jvmConstantsGen.globalVarsPkgName, functionName);
        mv.visitFieldInsn(178, varClass, "v", "Lio/ballerina/runtime/internal/values/FPValue;");
    }

    public JvmUnionTypeGen getJvmUnionTypeGen() {
        return this.jvmUnionTypeGen;
    }

    public JvmErrorTypeGen getJvmErrorTypeGen() {
        return this.jvmErrorTypeGen;
    }

    public JvmTupleTypeGen getJvmTupleTypeGen() {
        return this.jvmTupleTypeGen;
    }

    public JvmArrayTypeGen getJvmArrayTypeGen() {
        return this.jvmArrayTypeGen;
    }

    public JvmRefTypeGen getJvmRefTypeGen() {
        return this.jvmRefTypeGen;
    }

    public JvmTypeGen getJvmTypeGen() {
        return this.jvmTypeGen;
    }

    static class AnonTypeHashInfo {
        int[] hashes;
        Label[] labels;
        Map<String, Label> labelFieldMapping;
        Map<String, BType> nameTypeMapping;

        public AnonTypeHashInfo(int[] hashes, Label[] labels, Map<String, Label> labelFieldMapping, Map<String, BType> nameTypeMapping) {
            this.hashes = hashes;
            this.labels = labels;
            this.labelFieldMapping = labelFieldMapping;
            this.nameTypeMapping = nameTypeMapping;
        }
    }
}

