/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.Map;
import java.util.TreeMap;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BTypeHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmArrayTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmConstantGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmArrayTypeConstantsGen {
    private final JarEntries jarEntries;
    private final Map<BArrayType, String> arrayTypeVarMap;
    private JvmArrayTypeGen jvmArrayTypeGen;
    private final Types types;
    private int constantIndex = 0;
    private final String arrayConstantsPkgName;

    public JvmArrayTypeConstantsGen(PackageID packageID, BTypeHashComparator bTypeHashComparator, Types types, JarEntries jarEntries) {
        this.arrayTypeVarMap = new TreeMap<BType, String>(bTypeHashComparator);
        this.types = types;
        this.jarEntries = jarEntries;
        this.arrayConstantsPkgName = JvmModuleUtils.getModuleLevelClassName(packageID, "constants/array_types/");
    }

    public void setJvmArrayTypeGen(JvmArrayTypeGen jvmArrayTypeGen) {
        this.jvmArrayTypeGen = jvmArrayTypeGen;
    }

    public String add(BArrayType arrayType) {
        String varName = this.arrayTypeVarMap.get(arrayType);
        if (varName == null) {
            varName = this.generateBArrayInits(arrayType);
            this.arrayTypeVarMap.put(arrayType, varName);
        }
        return varName;
    }

    private String generateBArrayInits(BArrayType arrayType) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        String varName = "t" + this.constantIndex++;
        String arrayConstantClass = this.arrayConstantsPkgName + varName;
        JvmConstantGenUtils.generateConstantsClassInit(cw, arrayConstantClass);
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        this.jvmArrayTypeGen.createArrayType(cw, mv, arrayType, this.types, arrayConstantClass);
        JvmCodeGenUtil.genMethodReturn(mv);
        cw.visitEnd();
        this.jarEntries.put(arrayConstantClass + ".class", cw.toByteArray());
        return varName;
    }

    public void generateGetBArrayType(MethodVisitor mv, String varName) {
        mv.visitFieldInsn(178, this.arrayConstantsPkgName + varName, "t", "Lio/ballerina/runtime/internal/types/BArrayType;");
    }
}

