/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmConstantGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;

public class JvmBStringConstantsGen {
    private final Map<String, Integer> bStringConstantsMap;
    private final Map<String, String> bStringBallerinaConstantMap;
    private final Map<String, Map<String, String>> largeStringVarMap = new HashMap<String, Map<String, String>>();
    private int bStringConstantIndex = 0;
    private final String stringConstantsPkgName;

    public JvmBStringConstantsGen(PackageID packageID) {
        this.bStringConstantsMap = new LinkedHashMap<String, Integer>();
        this.bStringBallerinaConstantMap = new LinkedHashMap<String, String>();
        this.stringConstantsPkgName = JvmModuleUtils.getModuleLevelClassName(packageID, "constants/strings/");
    }

    public void loadBStringConstant(MethodVisitor mv, String value, String varName, String constantVarClassName, boolean isConstant) {
        Integer index = this.bStringConstantsMap.get(value);
        if (index != null) {
            String stringConstantVarClass = this.stringConstantsPkgName + "s" + index;
            mv.visitFieldInsn(178, stringConstantVarClass, "s", "Lio/ballerina/runtime/api/values/BString;");
            return;
        }
        String stringConstantClass = this.bStringBallerinaConstantMap.get(value);
        if (stringConstantClass != null) {
            mv.visitFieldInsn(178, stringConstantClass, "v", "Lio/ballerina/runtime/api/values/BString;");
            return;
        }
        if (isConstant) {
            int[] highSurrogates = this.listHighSurrogates(value);
            this.createDirectBString(mv, value, varName, highSurrogates, constantVarClassName);
            this.bStringBallerinaConstantMap.put(value, constantVarClassName);
            return;
        }
        index = this.bStringConstantIndex;
        this.bStringConstantsMap.put(value, index);
        ++this.bStringConstantIndex;
        this.splitLargeStrings(value, index);
        String stringConstantVarClass = this.stringConstantsPkgName + "s" + index;
        mv.visitFieldInsn(178, stringConstantVarClass, "s", "Lio/ballerina/runtime/api/values/BString;");
    }

    public void generateConstantInit(JarEntries jarEntries) {
        this.generateBStringClasses(this.largeStringVarMap, jarEntries);
    }

    private void generateBStringClasses(Map<String, Map<String, String>> stringVarMap, JarEntries jarEntries) {
        for (Map.Entry<String, Integer> entry : this.bStringConstantsMap.entrySet()) {
            String bString = entry.getKey();
            int varIndex = entry.getValue();
            String bStringVarName = "s" + varIndex;
            String constantClassName = this.stringConstantsPkgName + bStringVarName;
            BallerinaClassWriter cw = new BallerinaClassWriter(2);
            JvmConstantGenUtils.generateConstantsClassInit(cw, constantClassName);
            this.visitBStringField(cw);
            MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
            int[] highSurrogates = this.listHighSurrogates(bString);
            if (stringVarMap.containsKey(bStringVarName)) {
                this.visitStringField(cw, stringVarMap.get(bStringVarName));
                Map<String, String> stringChunkMap = stringVarMap.get(bStringVarName);
                this.createConcatenatedBString(mv, highSurrogates, bStringVarName, stringChunkMap, constantClassName);
            } else {
                this.createDirectBString(mv, bString, bStringVarName, highSurrogates, constantClassName);
                mv.visitFieldInsn(179, constantClassName, "s", "Lio/ballerina/runtime/api/values/BString;");
            }
            mv.visitInsn(177);
            mv.visitMaxs(10, 10);
            mv.visitEnd();
            if (highSurrogates.length > 0) {
                this.generateGetHighSurrogateArrayMethod(cw, constantClassName, bStringVarName, highSurrogates);
            }
            cw.visitEnd();
            jarEntries.put(constantClassName + ".class", cw.toByteArray());
        }
    }

    private void generateGetHighSurrogateArrayMethod(ClassWriter cw, String constantClassName, String varName, int[] values) {
        List<String> splitMethodNames = this.generateSplitGetSurrogateArrayMethod(cw, constantClassName, varName, values);
        String highSurrogateMethodName = this.getHighSurrogateMethodName(varName);
        MethodVisitor mv = cw.visitMethod(8, highSurrogateMethodName, "()[I", null, null);
        mv.visitLdcInsn((Object)values.length);
        mv.visitIntInsn(188, 10);
        mv.visitVarInsn(58, 0);
        for (String methodName : splitMethodNames) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, constantClassName, methodName, "([I)V", false);
        }
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, highSurrogateMethodName, constantClassName);
        mv.visitEnd();
    }

    private List<String> generateSplitGetSurrogateArrayMethod(ClassWriter cw, String constantClassName, String varName, int[] values) {
        ArrayList<String> methods = new ArrayList<String>();
        MethodVisitor mv = null;
        int indexCount = 0;
        int methodCount = 0;
        Object methodName = this.getHighSurrogateMethodName(varName);
        for (int i = 0; i < values.length; ++i) {
            if (indexCount % 5000 == 0) {
                methodName = (String)methodName + methodCount++;
                mv = cw.visitMethod(8, (String)methodName, "([I)V", null, null);
                methods.add((String)methodName);
            }
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn((Object)i);
            mv.visitLdcInsn((Object)values[i]);
            mv.visitInsn(79);
            if (++indexCount % 5000 != 0) continue;
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)methodName, constantClassName);
            mv.visitEnd();
        }
        if (indexCount % 5000 != 0) {
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)methodName, constantClassName);
            mv.visitEnd();
        }
        return methods;
    }

    private void visitStringField(ClassWriter cw, Map<String, String> varList) {
        for (String varName : varList.keySet()) {
            FieldVisitor fv = cw.visitField(9, varName, "Ljava/lang/String;", null, null);
            fv.visitEnd();
        }
    }

    private String getStringVarName(String bStringVar, int index) {
        return bStringVar + "sc" + index;
    }

    private void splitLargeStrings(String str, int index) {
        String varName = "s" + index;
        Map<String, String> splitStrings = this.splitStringByByteLength(str, varName);
        if (!splitStrings.isEmpty()) {
            this.largeStringVarMap.put(varName, splitStrings);
        }
    }

    private Map<String, String> splitStringByByteLength(String str, String varName) {
        int byteLength = 0;
        LinkedHashMap<String, String> splitStrings = new LinkedHashMap<String, String>();
        int beginIndex = 0;
        int chunkCount = 0;
        for (int i = 0; i < str.length(); ++i) {
            char charValue = str.charAt(i);
            byteLength = charValue >= '\u0001' && charValue <= '\u007f' ? ++byteLength : (charValue <= '\u07ff' ? (byteLength += 2) : (byteLength += 3));
            if (byteLength < 65000) continue;
            splitStrings.put(this.getStringVarName(varName, chunkCount++), str.substring(beginIndex, i + 1));
            beginIndex = i + 1;
            byteLength = 0;
            ++this.bStringConstantIndex;
        }
        if (!splitStrings.isEmpty()) {
            splitStrings.put(this.getStringVarName(varName, chunkCount), str.substring(beginIndex));
            ++this.bStringConstantIndex;
        }
        return splitStrings;
    }

    private void visitBStringField(ClassWriter cw) {
        FieldVisitor fv = cw.visitField(9, "s", "Lio/ballerina/runtime/api/values/BString;", null, null);
        fv.visitEnd();
    }

    private String getHighSurrogateMethodName(String bStringVar) {
        return "getSurrogateArray" + bStringVar + "$";
    }

    private void createConcatenatedBString(MethodVisitor mv, int[] highSurrogates, String bStringVarName, Map<String, String> stringChunks, String constantClassName) {
        for (Map.Entry<String, String> stringEntry : stringChunks.entrySet()) {
            mv.visitLdcInsn((Object)stringEntry.getValue());
            mv.visitFieldInsn(179, constantClassName, stringEntry.getKey(), "Ljava/lang/String;");
        }
        if (highSurrogates.length > 0) {
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/NonBmpStringValue");
            this.generateAppendStringConstants(mv, stringChunks, constantClassName);
            mv.visitMethodInsn(184, constantClassName, this.getHighSurrogateMethodName(bStringVarName), "()[I", false);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/NonBmpStringValue", "<init>", "(Ljava/lang/String;[I)V", false);
        } else {
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/BmpStringValue");
            this.generateAppendStringConstants(mv, stringChunks, constantClassName);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/BmpStringValue", "<init>", "(Ljava/lang/String;)V", false);
        }
        mv.visitFieldInsn(179, constantClassName, "s", "Lio/ballerina/runtime/api/values/BString;");
    }

    private void generateAppendStringConstants(MethodVisitor mv, Map<String, String> stringChunks, String constantClassName) {
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        for (Map.Entry<String, String> stringEntry : stringChunks.entrySet()) {
            mv.visitFieldInsn(178, constantClassName, stringEntry.getKey(), "Ljava/lang/String;");
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
    }

    private void createDirectBString(MethodVisitor mv, String bString, String bStringVarName, int[] highSurrogates, String constantClassName) {
        if (highSurrogates.length > 0) {
            this.createNonBmpString(mv, bString, bStringVarName, constantClassName);
        } else {
            this.createBmpString(mv, bString);
        }
    }

    private void createBmpString(MethodVisitor mv, String val) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/BmpStringValue");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)val);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/BmpStringValue", "<init>", "(Ljava/lang/String;)V", false);
    }

    private void createNonBmpString(MethodVisitor mv, String val, String varName, String constantClassName) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/NonBmpStringValue");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)val);
        mv.visitMethodInsn(184, constantClassName, this.getHighSurrogateMethodName(varName), "()[I", false);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/NonBmpStringValue", "<init>", "(Ljava/lang/String;[I)V", false);
    }

    private int[] listHighSurrogates(String str) {
        ArrayList<Integer> highSurrogates = new ArrayList<Integer>();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isHighSurrogate(c)) continue;
            highSurrogates.add(i - highSurrogates.size());
        }
        int[] highSurrogatesArr = new int[highSurrogates.size()];
        for (int i = 0; i < highSurrogates.size(); ++i) {
            Integer highSurrogate = (Integer)highSurrogates.get(i);
            highSurrogatesArr[i] = highSurrogate;
        }
        return highSurrogatesArr;
    }
}

