/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.Map;
import java.util.TreeMap;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BTypeHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmErrorTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmConstantGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmErrorTypeConstantsGen {
    private final JarEntries jarEntries;
    private JvmErrorTypeGen jvmErrorTypeGen;
    private final Map<BErrorType, String> errorTypeVarMap;
    private int constantIndex = 0;
    private final String errorVarConstantsPkgName;

    public JvmErrorTypeConstantsGen(PackageID packageID, BTypeHashComparator bTypeHashComparator, JarEntries jarEntries) {
        this.errorTypeVarMap = new TreeMap<BType, String>(bTypeHashComparator);
        this.jarEntries = jarEntries;
        this.errorVarConstantsPkgName = JvmModuleUtils.getModuleLevelClassName(packageID, "constants/error_types/");
    }

    public void setJvmErrorTypeGen(JvmErrorTypeGen jvmErrorTypeGen) {
        this.jvmErrorTypeGen = jvmErrorTypeGen;
    }

    public String add(BErrorType type) {
        String varName = this.errorTypeVarMap.get(type);
        if (varName == null) {
            varName = this.generateBErrorInits(type);
            this.errorTypeVarMap.put(type, varName);
        }
        return varName;
    }

    private String generateBErrorInits(BErrorType errorType) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        JvmCreateTypeGen.genFieldsForInitFlags(cw);
        String varName = "t" + this.constantIndex++;
        String errorTypeClass = this.errorVarConstantsPkgName + varName;
        JvmConstantGenUtils.generateConstantsClassInit(cw, errorTypeClass);
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        this.jvmErrorTypeGen.createErrorType(cw, mv, errorType, errorTypeClass, false);
        JvmCodeGenUtil.genMethodReturn(mv);
        cw.visitEnd();
        this.jarEntries.put(errorTypeClass + ".class", cw.toByteArray());
        return varName;
    }

    public void generateGetBErrorType(MethodVisitor mv, String varName) {
        String typeClass = this.errorVarConstantsPkgName + varName;
        mv.visitMethodInsn(184, typeClass, "get", "()Lio/ballerina/runtime/internal/types/BErrorType;", false);
    }
}

