/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import io.ballerina.identifier.Utils;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadBirBasicBlock;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadingDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;

public class JvmFunctionTypeConstantsGen {
    private JvmTypeGen jvmTypeGen;
    private final JvmConstantsGen jvmConstantsGen;
    private final String functionTypeConstantsPkgName;

    public JvmFunctionTypeConstantsGen(PackageID module, JvmConstantsGen jvmConstantsGen) {
        this.functionTypeConstantsPkgName = JvmModuleUtils.getModuleLevelClassName(module, "constants/function_types/");
        this.jvmConstantsGen = jvmConstantsGen;
    }

    public void generateClass(JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, List<BIRNode.BIRFunction> sortedFunctions, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector, JarEntries jarEntries) {
        this.generateFunctionTypeInits(jvmPackageGen, jvmCastGen, sortedFunctions, asyncDataCollector, lazyLoadingDataCollector, jarEntries);
    }

    private void generateFunctionTypeInits(JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, List<BIRNode.BIRFunction> sortedFunctions, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector, JarEntries jarEntries) {
        for (BIRNode.BIRFunction function : sortedFunctions) {
            BallerinaClassWriter cw = new BallerinaClassWriter(2);
            String functionName = function.name.value;
            String functionTypeConstantClassName = this.functionTypeConstantsPkgName + functionName;
            cw.visit(65, 33, functionTypeConstantClassName, null, "java/lang/Object", null);
            MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
            this.jvmTypeGen.loadFunctionType(mv, function.type, functionName);
            mv.visitFieldInsn(179, functionTypeConstantClassName, "v", "Lio/ballerina/runtime/api/types/FunctionType;");
            LazyLoadBirBasicBlock lazyBB = lazyLoadingDataCollector.lazyLoadingAnnotationsBBMap.get(functionName);
            if (lazyBB != null) {
                JvmCodeGenUtil.lazyLoadAnnotations(mv, lazyBB, jvmPackageGen, jvmCastGen, this.jvmConstantsGen, this.jvmTypeGen, asyncDataCollector);
            }
            JvmCodeGenUtil.genMethodReturn(mv);
            this.visitFunctionTypeFields(cw);
            cw.visitEnd();
            jarEntries.put(functionTypeConstantClassName + ".class", cw.toByteArray());
        }
    }

    private void visitFunctionTypeFields(ClassWriter cw) {
        FieldVisitor fv = cw.visitField(9, "v", "Lio/ballerina/runtime/api/types/FunctionType;", null, null);
        fv.visitEnd();
    }

    public void setJvmTypeGen(JvmTypeGen jvmTypeGen) {
        this.jvmTypeGen = jvmTypeGen;
    }

    public String getFunctionTypeConstantClass(String functionName) {
        return this.functionTypeConstantsPkgName + Utils.encodeFunctionIdentifier((String)functionName);
    }
}

