/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import io.ballerina.identifier.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmConstantGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;

public class JvmModuleConstantsGen {
    private final HashMap<PackageID, String> moduleVarMap;
    private final AtomicInteger constantIndex = new AtomicInteger();
    private final String moduleConstantsPkgName;

    public JvmModuleConstantsGen(BIRNode.BIRPackage module) {
        this.moduleVarMap = new HashMap();
        this.moduleConstantsPkgName = JvmModuleUtils.getModuleLevelClassName(module.packageID, "constants/modules/");
    }

    public String addModule(PackageID packageID) {
        return this.moduleVarMap.computeIfAbsent(packageID, s -> "m" + this.constantIndex.getAndIncrement());
    }

    public void generateConstantInit(JarEntries jarEntries) {
        for (Map.Entry<PackageID, String> entry : this.moduleVarMap.entrySet()) {
            PackageID packageID = entry.getKey();
            String varName = entry.getValue();
            String moduleConstantClassName = this.moduleConstantsPkgName + varName;
            BallerinaClassWriter cw = new BallerinaClassWriter(2);
            JvmConstantGenUtils.generateConstantsClassInit(cw, moduleConstantClassName);
            JvmModuleConstantsGen.generateModuleConstant(cw, packageID, moduleConstantClassName, varName);
            this.visitModuleField(cw, varName);
            cw.visitEnd();
            jarEntries.put(moduleConstantClassName + ".class", cw.toByteArray());
        }
    }

    private static void generateModuleConstant(ClassWriter cw, PackageID packageID, String moduleConstantClassName, String varName) {
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitTypeInsn(187, "io/ballerina/runtime/api/Module");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)packageID.orgName.value));
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)packageID.name.value));
        mv.visitLdcInsn((Object)CompilerUtils.getMajorVersion(packageID.version.value));
        if (packageID.isTestPkg) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitMethodInsn(183, "io/ballerina/runtime/api/Module", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
        mv.visitFieldInsn(179, moduleConstantClassName, varName, "Lio/ballerina/runtime/api/Module;");
        JvmCodeGenUtil.genMethodReturn(mv);
    }

    private void visitModuleField(ClassWriter cw, String varName) {
        FieldVisitor fv = cw.visitField(9, varName, "Lio/ballerina/runtime/api/Module;", null, null);
        fv.visitEnd();
    }

    public String getModuleConstantsClass(String varName) {
        return this.moduleConstantsPkgName + varName;
    }
}

