/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.Map;
import java.util.TreeMap;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BTypeHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadingDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmRefTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmConstantGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;

public class JvmRefTypeConstantsGen {
    private final JarEntries jarEntries;
    private JvmRefTypeGen jvmRefTypeGen;
    private final Map<BTypeReferenceType, String> typeRefVarMap;
    private final String typeRefVarConstantsPkgName;

    public JvmRefTypeConstantsGen(BIRNode.BIRPackage module, BTypeHashComparator bTypeHashComparator, JarEntries jarEntries) {
        this.typeRefVarMap = new TreeMap<BType, String>(bTypeHashComparator);
        this.jarEntries = jarEntries;
        this.typeRefVarConstantsPkgName = JvmModuleUtils.getModuleLevelClassName(module.packageID, "constants/type_ref_types/");
    }

    public void setJvmRefTypeGen(JvmRefTypeGen jvmRefTypeGen) {
        this.jvmRefTypeGen = jvmRefTypeGen;
    }

    public String add(BIRNode.BIRTypeDefinition typeDef, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector) {
        BTypeReferenceType referenceType = (BTypeReferenceType)typeDef.referenceType;
        String varName = this.typeRefVarMap.get(referenceType);
        if (varName == null) {
            varName = this.generateTypeRefTypeInitMethod(typeDef, referenceType, jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector);
            this.typeRefVarMap.put(referenceType, varName);
        }
        return varName;
    }

    private String generateTypeRefTypeInitMethod(BIRNode.BIRTypeDefinition typeDef, BTypeReferenceType referenceType, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, LazyLoadingDataCollector lazyLoadingDataCollector) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        boolean isAnnotatedType = referenceType.referredType.tag != 12;
        JvmCreateTypeGen.genFieldsForInitFlags(cw);
        String varName = JvmCodeGenUtil.getRefTypeConstantName(referenceType);
        String typeRefConstantClass = this.typeRefVarConstantsPkgName + varName;
        JvmConstantGenUtils.generateConstantsClassInit(cw, typeRefConstantClass);
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        this.jvmRefTypeGen.createTypeRefType(cw, mv, typeDef, referenceType, typeRefConstantClass, isAnnotatedType, jvmPackageGen, jvmCastGen, asyncDataCollector, lazyLoadingDataCollector);
        JvmCodeGenUtil.genMethodReturn(mv);
        cw.visitEnd();
        this.jarEntries.put(typeRefConstantClass + ".class", cw.toByteArray());
        return varName;
    }
}

