/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.Map;
import java.util.TreeMap;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BTypeHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmTupleTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmConstantGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmTupleTypeConstantsGen {
    private final JarEntries jarEntries;
    private final Map<BTupleType, String> tupleTypeVarMap;
    private JvmTupleTypeGen jvmTupleTypeGen;
    private int constantIndex = 0;
    private final String tupleVarConstantsPkgName;

    public JvmTupleTypeConstantsGen(PackageID packageID, BTypeHashComparator bTypeHashComparator, JarEntries jarEntries) {
        this.jarEntries = jarEntries;
        this.tupleTypeVarMap = new TreeMap<BType, String>(bTypeHashComparator);
        this.tupleVarConstantsPkgName = JvmModuleUtils.getModuleLevelClassName(packageID, "constants/tuple_types/");
    }

    public void setJvmTupleTypeGen(JvmTupleTypeGen jvmTupleTypeGen) {
        this.jvmTupleTypeGen = jvmTupleTypeGen;
    }

    public String add(BTupleType type, SymbolTable symbolTable) {
        Object varName = this.tupleTypeVarMap.get(type);
        if (varName == null) {
            varName = "t" + this.constantIndex++;
            this.tupleTypeVarMap.put(type, (String)varName);
            this.generateBTupleInits(type, (String)varName, symbolTable);
        }
        return varName;
    }

    private void generateBTupleInits(BTupleType type, String varName, SymbolTable symbolTable) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        JvmCreateTypeGen.genFieldsForInitFlags(cw);
        String tupleTypeClass = this.tupleVarConstantsPkgName + varName;
        JvmConstantGenUtils.generateConstantsClassInit(cw, tupleTypeClass);
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        this.jvmTupleTypeGen.createTupleType(cw, mv, tupleTypeClass, type, false, symbolTable, 1);
        JvmCodeGenUtil.genMethodReturn(mv);
        cw.visitEnd();
        this.jarEntries.put(tupleTypeClass + ".class", cw.toByteArray());
    }

    public void generateGetBTupleType(MethodVisitor mv, String varName) {
        String typeClass = this.tupleVarConstantsPkgName + varName;
        mv.visitMethodInsn(184, typeClass, "get", "()Lio/ballerina/runtime/internal/types/BTupleType;", false);
    }
}

