/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.Map;
import java.util.TreeMap;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BTypeHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmUnionTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmConstantGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;

public class JvmUnionTypeConstantsGen {
    private final JarEntries jarEntries;
    private final Map<BUnionType, String> unionTypeVarMap;
    private JvmUnionTypeGen jvmUnionTypeGen;
    private int constantIndex = 0;
    private final String unionVarConstantsPkgName;

    public JvmUnionTypeConstantsGen(PackageID packageID, BTypeHashComparator bTypeHashComparator, JarEntries jarEntries) {
        this.jarEntries = jarEntries;
        this.unionTypeVarMap = new TreeMap<BType, String>(bTypeHashComparator);
        this.unionVarConstantsPkgName = JvmModuleUtils.getModuleLevelClassName(packageID, "constants/union_types/");
    }

    public void setJvmUnionTypeGen(JvmUnionTypeGen jvmUnionTypeGen) {
        this.jvmUnionTypeGen = jvmUnionTypeGen;
    }

    public String add(BUnionType type, SymbolTable symbolTable) {
        Object varName = this.unionTypeVarMap.get(type);
        if (varName == null) {
            varName = "t" + this.constantIndex++;
            this.unionTypeVarMap.put(type, (String)varName);
            this.generateBUnionInits(type, (String)varName, symbolTable);
        }
        return varName;
    }

    private void generateBUnionInits(BUnionType type, String varName, SymbolTable symbolTable) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        JvmCreateTypeGen.genFieldsForInitFlags(cw);
        String unionTypeClass = this.unionVarConstantsPkgName + varName;
        JvmConstantGenUtils.generateConstantsClassInit(cw, unionTypeClass);
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        this.jvmUnionTypeGen.createUnionType(cw, mv, unionTypeClass, varName, type, false, symbolTable);
        JvmCodeGenUtil.genMethodReturn(mv);
        cw.visitEnd();
        this.jarEntries.put(unionTypeClass + ".class", cw.toByteArray());
    }

    public void generateGetBUnionType(MethodVisitor mv, String varName) {
        String typeClass = this.unionVarConstantsPkgName + varName;
        mv.visitMethodInsn(184, typeClass, "get", "()Lio/ballerina/runtime/internal/types/BUnionType;", false);
    }
}

