/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.creators;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;

public class JvmErrorCreatorGen {
    private final JvmTypeGen jvmTypeGen;
    private final String errorsClass;

    public JvmErrorCreatorGen(PackageID packageID, JvmTypeGen jvmTypeGen) {
        this.jvmTypeGen = jvmTypeGen;
        this.errorsClass = JvmModuleUtils.getModuleLevelClassName(packageID, "creators/errors");
    }

    public void generateErrorsClass(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, JarEntries jarEntries, List<BIRNode.BIRTypeDefinition> errorTypeDefList, SymbolTable symbolTable) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(65, 33, this.errorsClass, null, "java/lang/Object", null);
        this.generateCreateErrorMethods(cw, errorTypeDefList, this.errorsClass, symbolTable);
        cw.visitEnd();
        byte[] bytes = jvmPackageGen.getBytes(cw, module);
        jarEntries.put(this.errorsClass + ".class", bytes);
    }

    private void generateCreateErrorMethods(ClassWriter cw, List<BIRNode.BIRTypeDefinition> errorTypeDefList, String typeOwnerClass, SymbolTable symbolTable) {
        MethodVisitor mv = cw.visitMethod(9, "createErrorValue", "(Ljava/lang/String;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BError;Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BError;", null, null);
        mv.visitCode();
        if (errorTypeDefList.isEmpty()) {
            JvmCodeGenUtil.createDefaultCaseThrowError(mv, new Label(), 0, "No such error: ");
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(184, typeOwnerClass, "createErrorValue0", "(Ljava/lang/String;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BError;Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BError;", false);
            mv.visitInsn(176);
            this.generateCreateErrorMethodSplits(cw, errorTypeDefList, typeOwnerClass, symbolTable);
        }
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "createErrorValue", this.errorsClass);
        mv.visitEnd();
    }

    private void generateCreateErrorMethodSplits(ClassWriter cw, List<BIRNode.BIRTypeDefinition> errorTypeDefList, String typeOwnerClass, SymbolTable symbolTable) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        List<Object> targetLabels = new ArrayList();
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        int errorNameIndex = indexMap.addIfNotExists("errorTypeName", symbolTable.stringType);
        int messageIndex = indexMap.addIfNotExists("message", symbolTable.stringType);
        int causeIndex = indexMap.addIfNotExists("cause", symbolTable.errorType);
        int detailsIndex = indexMap.addIfNotExists("details", symbolTable.anyType);
        Label defaultCaseLabel = new Label();
        errorTypeDefList.sort(JvmCodeGenUtil.NAME_HASH_COMPARATOR);
        int i = 0;
        for (BIRNode.BIRTypeDefinition errorDefinition : errorTypeDefList) {
            if (bTypesCount % 100 == 0) {
                mv = cw.visitMethod(9, "createErrorValue" + methodCount++, "(Ljava/lang/String;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BError;Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BError;", null, null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                int remainingCases = errorTypeDefList.size() - bTypesCount;
                if (remainingCases > 100) {
                    remainingCases = 100;
                }
                List<Label> labels = JvmCreateTypeGen.createLabelsForSwitch(mv, errorNameIndex, errorTypeDefList, bTypesCount, remainingCases, defaultCaseLabel);
                targetLabels = JvmCreateTypeGen.createLabelsForEqualCheck(mv, errorNameIndex, errorTypeDefList, bTypesCount, remainingCases, labels, defaultCaseLabel);
                i = 0;
            }
            Label targetLabel = (Label)targetLabels.get(i);
            mv.visitLabel(targetLabel);
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ErrorValue");
            mv.visitInsn(89);
            this.jvmTypeGen.loadType(mv, errorDefinition.referenceType);
            mv.visitVarInsn(25, messageIndex);
            mv.visitVarInsn(25, causeIndex);
            mv.visitVarInsn(25, detailsIndex);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ErrorValue", "<init>", "(Lio/ballerina/runtime/api/types/Type;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BError;Lio/ballerina/runtime/api/values/BMap;)V", false);
            mv.visitInsn(176);
            ++i;
            if (++bTypesCount % 100 != 0) continue;
            if (bTypesCount == errorTypeDefList.size()) {
                JvmCodeGenUtil.createDefaultCaseThrowError(mv, defaultCaseLabel, errorNameIndex, "No such error: ");
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(184, typeOwnerClass, "createErrorValue" + methodCount, "(Ljava/lang/String;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BError;Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BError;", false);
                mv.visitInsn(176);
            }
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 100 != 0) {
            JvmCodeGenUtil.createDefaultCaseThrowError(mv, defaultCaseLabel, errorNameIndex, "No such error: ");
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
    }
}

