/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.creators;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmValueGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmObjectCreatorGen {
    private final String objectsClass;
    private final String objectTypesPkgName;

    public JvmObjectCreatorGen(PackageID packageID) {
        this.objectsClass = JvmModuleUtils.getModuleLevelClassName(packageID, "creators/objects");
        this.objectTypesPkgName = JvmModuleUtils.getModuleLevelClassName(packageID, "types/object_types/");
    }

    public void generateObjectsClass(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, JarEntries jarEntries, List<BIRNode.BIRTypeDefinition> objectTypeDefList, SymbolTable symbolTable) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(65, 33, this.objectsClass, null, "java/lang/Object", null);
        this.generateCreateObjectMethods(cw, objectTypeDefList, module.packageID, this.objectsClass, symbolTable);
        cw.visitEnd();
        byte[] bytes = jvmPackageGen.getBytes(cw, module);
        jarEntries.put(this.objectsClass + ".class", bytes);
    }

    private void generateCreateObjectMethods(ClassWriter cw, List<BIRNode.BIRTypeDefinition> objectTypeDefList, PackageID moduleId, String typeOwnerClass, SymbolTable symbolTable) {
        MethodVisitor mv = cw.visitMethod(9, "createObjectValue", "(Ljava/lang/String;Lio/ballerina/runtime/internal/scheduling/Strand;[Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BObject;", null, null);
        mv.visitCode();
        if (objectTypeDefList.isEmpty()) {
            JvmCodeGenUtil.createDefaultCaseThrowError(mv, new Label(), 0, "No such object: ");
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(184, typeOwnerClass, "createObjectValue0", "(Ljava/lang/String;Lio/ballerina/runtime/internal/scheduling/Strand;[Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BObject;", false);
            mv.visitInsn(176);
            this.generateCreateObjectMethodSplits(cw, objectTypeDefList, moduleId, typeOwnerClass, symbolTable);
        }
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "createObjectValue", this.objectsClass);
        mv.visitEnd();
    }

    private void generateCreateObjectMethodSplits(ClassWriter cw, List<BIRNode.BIRTypeDefinition> objectTypeDefList, PackageID moduleId, String typeOwnerClass, SymbolTable symbolTable) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        List<Object> targetLabels = new ArrayList();
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        int var1Index = indexMap.addIfNotExists("var1", symbolTable.stringType);
        int parentIndex = indexMap.addIfNotExists("parent", symbolTable.anyType);
        int argsIndex = indexMap.addIfNotExists("args", symbolTable.anyType);
        Label defaultCaseLabel = new Label();
        objectTypeDefList.sort(JvmCodeGenUtil.NAME_HASH_COMPARATOR);
        int i = 0;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : objectTypeDefList) {
            if (bTypesCount % 100 == 0) {
                mv = cw.visitMethod(9, "createObjectValue" + methodCount++, "(Ljava/lang/String;Lio/ballerina/runtime/internal/scheduling/Strand;[Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BObject;", null, null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                int remainingCases = objectTypeDefList.size() - bTypesCount;
                if (remainingCases > 100) {
                    remainingCases = 100;
                }
                List<Label> labels = JvmCreateTypeGen.createLabelsForSwitch(mv, var1Index, objectTypeDefList, bTypesCount, remainingCases, defaultCaseLabel);
                targetLabels = JvmCreateTypeGen.createLabelsForEqualCheck(mv, var1Index, objectTypeDefList, bTypesCount, remainingCases, labels, defaultCaseLabel);
                i = 0;
            }
            BType type = optionalTypeDef.type;
            String fieldName = JvmCodeGenUtil.toNameString(type);
            Label targetLabel = (Label)targetLabels.get(i);
            mv.visitLabel(targetLabel);
            mv.visitVarInsn(25, 0);
            String className = JvmValueGen.getTypeValueClassName(moduleId, optionalTypeDef.internalName.value);
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            String objectTypeClass = this.objectTypesPkgName + fieldName;
            mv.visitMethodInsn(184, objectTypeClass, "get", "()Lio/ballerina/runtime/internal/types/BObjectType;", false);
            mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
            mv.visitMethodInsn(183, className, "<init>", "(Lio/ballerina/runtime/api/types/Type;)V", false);
            int tempVarIndex = indexMap.addIfNotExists("tempVar", type);
            mv.visitVarInsn(58, tempVarIndex);
            mv.visitVarInsn(25, tempVarIndex);
            mv.visitVarInsn(25, parentIndex);
            mv.visitLdcInsn((Object)"$init$");
            mv.visitVarInsn(25, argsIndex);
            mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BObject", "call", "(Lio/ballerina/runtime/internal/scheduling/Strand;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", true);
            int tempResultIndex = indexMap.addIfNotExists("tempResult", symbolTable.anyType);
            mv.visitVarInsn(58, tempResultIndex);
            mv.visitVarInsn(25, tempResultIndex);
            mv.visitTypeInsn(193, "io/ballerina/runtime/api/values/BError");
            Label noErrorLabel = new Label();
            mv.visitJumpInsn(153, noErrorLabel);
            mv.visitVarInsn(25, tempResultIndex);
            mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BError");
            mv.visitInsn(191);
            mv.visitLabel(noErrorLabel);
            mv.visitVarInsn(25, tempVarIndex);
            mv.visitInsn(176);
            ++i;
            if (++bTypesCount % 100 != 0) continue;
            if (bTypesCount == objectTypeDefList.size()) {
                JvmCodeGenUtil.createDefaultCaseThrowError(mv, defaultCaseLabel, var1Index, "No such object: ");
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(184, typeOwnerClass, "createObjectValue" + methodCount, "(Ljava/lang/String;Lio/ballerina/runtime/internal/scheduling/Strand;[Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BObject;", false);
                mv.visitInsn(176);
            }
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 100 != 0) {
            JvmCodeGenUtil.createDefaultCaseThrowError(mv, defaultCaseLabel, var1Index, "No such object: ");
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
    }
}

