/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.identifiers;

import java.util.Map;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadBirBasicBlock;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadingDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.LazyLoadingCodeGenUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmBallerinaConstantsGen {
    private final JvmConstantsGen jvmConstantsGen;
    private final BIRNode.BIRPackage module;
    private final LazyLoadingDataCollector lazyLoadingDataCollector;

    public JvmBallerinaConstantsGen(BIRNode.BIRPackage module, JvmConstantsGen jvmConstantsGen, LazyLoadingDataCollector lazyLoadingDataCollector) {
        this.jvmConstantsGen = jvmConstantsGen;
        this.module = module;
        this.lazyLoadingDataCollector = lazyLoadingDataCollector;
    }

    public void generateConstantsClasses(JvmPackageGen jvmPackageGen, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector, JarEntries jarEntries) {
        if (this.module.constants.isEmpty()) {
            return;
        }
        Map<String, LazyLoadBirBasicBlock> lazyBBMap = this.lazyLoadingDataCollector.lazyLoadingBBMap;
        BallerinaClassWriter allConstantsCW = new BallerinaClassWriter(2);
        allConstantsCW.visit(65, 33, this.jvmConstantsGen.allConstantsClassName, null, "java/lang/Object", null);
        for (BIRNode.BIRConstant constant : this.module.constants) {
            BIRNode.ConstValue constValue = constant.constValue;
            BType bType = JvmCodeGenUtil.getImpliedType(constValue.type);
            BallerinaClassWriter cw = new BallerinaClassWriter(2);
            cw.visitSource(constant.pos.lineRange().fileName(), null);
            String varName = constant.name.value;
            String constantVarClassName = JvmCodeGenUtil.getVarStoreClass(this.jvmConstantsGen.constantsPkgName, varName);
            String descriptor = JvmCodeGenUtil.getFieldTypeSignature(bType);
            LazyLoadingCodeGenUtils.genLazyLoadingClass(cw, constantVarClassName, descriptor);
            LazyLoadingCodeGenUtils.addDebugField(allConstantsCW, varName);
            if (JvmCodeGenUtil.isSimpleBasicType(bType)) {
                MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
                mv.visitCode();
                JvmCodeGenUtil.loadConstantValue(constValue.type, constValue.value, varName, mv, this.jvmConstantsGen, constantVarClassName, true);
                mv.visitFieldInsn(179, constantVarClassName, "v", descriptor);
                JvmCodeGenUtil.genMethodReturn(mv);
            }
            LazyLoadingCodeGenUtils.loadIdentifierValue(cw, varName, this.module, lazyBBMap, jvmPackageGen, jvmTypeGen, jvmCastGen, this.jvmConstantsGen, asyncDataCollector);
            cw.visitEnd();
            jarEntries.put(constantVarClassName + ".class", jvmPackageGen.getBytes(cw, this.module));
        }
        LazyLoadingCodeGenUtils.genLoadDebugVariablesMethod(allConstantsCW);
        allConstantsCW.visitEnd();
        String constantsClass = this.jvmConstantsGen.allConstantsClassName + ".class";
        jarEntries.put(constantsClass, jvmPackageGen.getBytes(allConstantsCW, this.module));
    }
}

