/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.identifiers;

import java.util.List;
import java.util.Map;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadBirBasicBlock;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadingDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.LazyLoadingCodeGenUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmGlobalVariablesGen {
    private final BIRNode.BIRPackage module;
    private final LazyLoadingDataCollector lazyLoadingDataCollector;
    private final String globalVarsPkgName;

    public JvmGlobalVariablesGen(BIRNode.BIRPackage module, LazyLoadingDataCollector lazyLoadingDataCollector) {
        this.module = module;
        this.lazyLoadingDataCollector = lazyLoadingDataCollector;
        this.globalVarsPkgName = JvmModuleUtils.getModuleLevelClassName(module.packageID, "identifiers/global_vars/");
    }

    public void generateGlobalVarClasses(JvmPackageGen jvmPackageGen, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen, JvmConstantsGen jvmConstantsGen, AsyncDataCollector asyncDataCollector, JarEntries jarEntries) {
        if (this.module.globalVars.isEmpty()) {
            return;
        }
        Map<String, LazyLoadBirBasicBlock> lazyBBMap = this.lazyLoadingDataCollector.lazyLoadingBBMap;
        List<BIRNode.BIRGlobalVariableDcl> globalVariableDcls = this.module.globalVars;
        BallerinaClassWriter allGlobalVarsCW = new BallerinaClassWriter(2);
        allGlobalVarsCW.visit(65, 33, jvmConstantsGen.allGlobalVarsClassName, null, "java/lang/Object", null);
        for (BIRNode.BIRGlobalVariableDcl globalVar : globalVariableDcls) {
            String varName = globalVar.name.value;
            if (varName.equals("_")) continue;
            BallerinaClassWriter cw = new BallerinaClassWriter(2);
            String globalVarClassName = JvmCodeGenUtil.getVarStoreClass(this.globalVarsPkgName, varName);
            if (globalVar.pos != null) {
                cw.visitSource(globalVar.pos.lineRange().fileName(), null);
            }
            BType bType = JvmCodeGenUtil.getImpliedType(globalVar.type);
            String descriptor = JvmCodeGenUtil.getFieldTypeSignature(bType);
            LazyLoadingCodeGenUtils.genLazyLoadingClass(cw, globalVarClassName, descriptor);
            LazyLoadingCodeGenUtils.addDebugField(allGlobalVarsCW, varName);
            LazyLoadingCodeGenUtils.loadIdentifierValue(cw, varName, this.module, lazyBBMap, jvmPackageGen, jvmTypeGen, jvmCastGen, jvmConstantsGen, asyncDataCollector);
            cw.visitEnd();
            jarEntries.put(globalVarClassName + ".class", jvmPackageGen.getBytes(cw, this.module));
        }
        LazyLoadingCodeGenUtils.genLoadDebugVariablesMethod(allGlobalVarsCW);
        allGlobalVarsCW.visitEnd();
        String globalVarsClass = jvmConstantsGen.allGlobalVarsClassName + ".class";
        jarEntries.put(globalVarsClass, jvmPackageGen.getBytes(allGlobalVarsCW, this.module));
    }
}

