/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.types;

import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmArrayTypeGen {
    private final JvmTypeGen jvmTypeGen;

    public JvmArrayTypeGen(JvmTypeGen jvmTypeGen) {
        this.jvmTypeGen = jvmTypeGen;
    }

    public void createArrayType(ClassWriter cw, MethodVisitor mv, BArrayType arrayType, Types types, String arrayConstantClass) {
        cw.visitField(9, "t", "Lio/ballerina/runtime/internal/types/BArrayType;", null, null).visitEnd();
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BArrayType");
        mv.visitInsn(89);
        if (TypeTags.isSimpleBasicType(arrayType.eType.tag)) {
            this.jvmTypeGen.loadType(mv, arrayType.eType);
            int arraySize = arrayType.getSize();
            mv.visitLdcInsn((Object)arraySize);
            mv.visitInsn(136);
            this.jvmTypeGen.loadReadonlyFlag(mv, arrayType);
            mv.visitLdcInsn((Object)this.jvmTypeGen.typeFlag(arrayType.eType));
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BArrayType", "<init>", "(Lio/ballerina/runtime/api/types/Type;IZI)V", false);
            mv.visitFieldInsn(179, arrayConstantClass, "t", "Lio/ballerina/runtime/internal/types/BArrayType;");
            this.populateArray(mv, arrayType, arrayConstantClass);
            return;
        }
        mv.visitLdcInsn((Object)this.jvmTypeGen.typeFlag(arrayType.eType));
        int arraySize = arrayType.getSize();
        mv.visitLdcInsn((Object)arraySize);
        mv.visitInsn(136);
        this.jvmTypeGen.loadReadonlyFlag(mv, arrayType);
        mv.visitInsn(types.hasFillerValue(arrayType.eType) ? 4 : 3);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BArrayType", "<init>", "(IIZZ)V", false);
        mv.visitFieldInsn(179, arrayConstantClass, "t", "Lio/ballerina/runtime/internal/types/BArrayType;");
        this.populateArray(mv, arrayType, arrayConstantClass);
    }

    private void populateArray(MethodVisitor mv, BArrayType bType, String arrayConstantClass) {
        mv.visitFieldInsn(178, arrayConstantClass, "t", "Lio/ballerina/runtime/internal/types/BArrayType;");
        this.jvmTypeGen.loadType(mv, bType.eType);
        this.loadDimension(mv, bType.eType, 1);
        this.jvmTypeGen.loadReadonlyFlag(mv, bType.eType);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BArrayType", "setElementType", "(Lio/ballerina/runtime/api/types/Type;IZ)V", false);
    }

    private void loadDimension(MethodVisitor mv, BType eType, int dimension) {
        switch (eType.tag) {
            case 20: {
                this.loadDimension(mv, ((BArrayType)eType).eType, dimension + 1);
                break;
            }
            case 14: {
                this.loadDimension(mv, ((BTypeReferenceType)eType).referredType, dimension);
                break;
            }
            case 22: {
                this.loadDimension(mv, ((BIntersectionType)eType).effectiveType, dimension);
                break;
            }
            default: {
                mv.visitLdcInsn((Object)dimension);
            }
        }
    }
}

