/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.types;

import io.ballerina.identifier.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.model.DoubleCheckLabelsRecord;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.util.Name;

public class JvmObjectTypeGen {
    private final JvmCreateTypeGen jvmCreateTypeGen;
    private final JvmTypeGen jvmTypeGen;
    private final JvmConstantsGen jvmConstantsGen;
    public int methodCount = 0;

    public JvmObjectTypeGen(JvmCreateTypeGen jvmCreateTypeGen, JvmTypeGen jvmTypeGen, JvmConstantsGen jvmConstantsGen) {
        this.jvmCreateTypeGen = jvmCreateTypeGen;
        this.jvmTypeGen = jvmTypeGen;
        this.jvmConstantsGen = jvmConstantsGen;
    }

    public void createObjectType(ClassWriter cw, MethodVisitor mv, String objectTypeClass, BObjectType objectType, String fieldName, boolean isAnnotatedType, BIRVarToJVMIndexMap indexMap, SymbolTable symbolTable) {
        cw.visitField(25, "t", "Lio/ballerina/runtime/internal/types/BObjectType;", null, null).visitEnd();
        String objectClassName = Symbols.isService(objectType.tsymbol) ? "io/ballerina/runtime/internal/types/BServiceType" : (Symbols.isClient(objectType.tsymbol) ? "io/ballerina/runtime/internal/types/BClientType" : "io/ballerina/runtime/internal/types/BObjectType");
        mv.visitTypeInsn(187, objectClassName);
        mv.visitInsn(89);
        BTypeSymbol typeSymbol = objectType.tsymbol;
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)typeSymbol.name.getValue()));
        String moduleVar = this.jvmConstantsGen.getModuleConstantVar(objectType.tsymbol.pkgID);
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(moduleVar), moduleVar, "Lio/ballerina/runtime/api/Module;");
        mv.visitLdcInsn((Object)typeSymbol.flags);
        mv.visitMethodInsn(183, objectClassName, "<init>", "(Ljava/lang/String;Lio/ballerina/runtime/api/Module;J)V", false);
        mv.visitFieldInsn(179, objectTypeClass, "t", "Lio/ballerina/runtime/internal/types/BObjectType;");
        this.genGetTypeMethod(cw, objectType, objectTypeClass, fieldName, moduleVar, isAnnotatedType, symbolTable, indexMap);
    }

    private void genGetTypeMethod(ClassWriter cw, BObjectType objectType, String objectTypeClass, String fieldName, String moduleVar, boolean isAnnotatedType, SymbolTable symbolTable, BIRVarToJVMIndexMap indexMap) {
        MethodVisitor mv = cw.visitMethod(9, "get", "()Lio/ballerina/runtime/internal/types/BObjectType;", null, null);
        mv.visitCode();
        DoubleCheckLabelsRecord checkLabelsRecord = JvmCreateTypeGen.genDoubleCheckGetStart(mv, objectTypeClass, "Lio/ballerina/runtime/internal/types/BObjectType;");
        this.populateObject(cw, mv, objectTypeClass, fieldName, moduleVar, objectType, symbolTable, indexMap);
        JvmCreateTypeGen.endDoubleCheckGetEnd(mv, objectTypeClass, "Lio/ballerina/runtime/internal/types/BObjectType;", checkLabelsRecord, isAnnotatedType);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public void populateObject(ClassWriter cw, MethodVisitor mv, String objectTypeClass, String fieldName, String moduleVar, BObjectType bType, SymbolTable symbolTable, BIRVarToJVMIndexMap indexMap) {
        Optional<BIntersectionType> immutableType = this.jvmCreateTypeGen.getImmutableType(bType, symbolTable);
        BTypeIdSet objTypeIdSet = bType.typeIdSet;
        mv.visitFieldInsn(178, objectTypeClass, "t", "Lio/ballerina/runtime/internal/types/BObjectType;");
        mv.visitInsn(89);
        if (immutableType.isPresent()) {
            mv.visitInsn(89);
        }
        if (!objTypeIdSet.isEmpty()) {
            mv.visitInsn(89);
        }
        this.addObjectFields(cw, mv, objectTypeClass, bType);
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)bType.tsymbol;
        this.addObjectInitFunction(mv, objectTypeClass, objectTypeSymbol.generatedInitializerFunc, bType, indexMap, "$init$", moduleVar, symbolTable, true);
        this.addObjectInitFunction(mv, objectTypeClass, objectTypeSymbol.initializerFunc, bType, indexMap, "init", moduleVar, symbolTable, false);
        this.addResourceMethods(cw, mv, objectTypeClass, fieldName, moduleVar, objectTypeSymbol.attachedFuncs, bType, symbolTable);
        this.addObjectAttachedFunctions(cw, mv, objectTypeClass, fieldName, moduleVar, objectTypeSymbol.attachedFuncs, bType, symbolTable);
        if (immutableType.isPresent()) {
            this.jvmTypeGen.loadType(mv, immutableType.get());
            mv.visitMethodInsn(185, "io/ballerina/runtime/api/types/Type", "setImmutableType", "(Lio/ballerina/runtime/api/types/IntersectionType;)V", true);
        }
        if (!objTypeIdSet.isEmpty()) {
            this.jvmCreateTypeGen.loadTypeIdSet(mv, objTypeIdSet);
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setTypeIdSet", "(Lio/ballerina/runtime/internal/types/BTypeIdSet;)V", false);
        }
    }

    private void addObjectAttachedFunctions(ClassWriter cw, MethodVisitor mv, String objectTypeClass, String fieldName, String moduleVar, List<BAttachedFunction> attachedFunctions, BObjectType objType, SymbolTable symbolTable) {
        mv.visitLdcInsn((Object)((long)attachedFunctions.size() - JvmObjectTypeGen.resourceFunctionCount(attachedFunctions)));
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/internal/types/BMethodType");
        String methodName = "$populate" + fieldName + "$attachedFunctions";
        int methodCount = this.splitObjectAttachedFunctions(cw, objectTypeClass, methodName, moduleVar, attachedFunctions, objType, symbolTable);
        if (methodCount > 0) {
            mv.visitVarInsn(58, 0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, objectTypeClass, methodName + "0", "([Lio/ballerina/runtime/internal/types/BMethodType;)V", false);
            mv.visitVarInsn(25, 0);
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setMethods", "([Lio/ballerina/runtime/api/types/MethodType;)V", false);
    }

    private int splitObjectAttachedFunctions(ClassWriter cw, String objectTypeClass, String methodName, String moduleVar, List<BAttachedFunction> attachedFunctions, BObjectType objType, SymbolTable symbolTable) {
        int fTypeCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        ArrayList<BAttachedFunction> nonResourceFunctions = new ArrayList<BAttachedFunction>();
        for (BAttachedFunction attachedFunc : attachedFunctions) {
            if (attachedFunc == null || attachedFunc instanceof BResourceFunction) continue;
            nonResourceFunctions.add(attachedFunc);
        }
        indexMap.addIfNotExists("$array", symbolTable.anyType);
        for (BAttachedFunction attachedFunc : nonResourceFunctions) {
            if (fTypeCount % 100 == 0) {
                mv = cw.visitMethod(9, methodName + methodCount++, "([Lio/ballerina/runtime/internal/types/BMethodType;)V", null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
            }
            this.createObjectMemberFunction(mv, objectTypeClass, moduleVar, attachedFunc);
            int attachedFunctionVarIndex = indexMap.addIfNotExists(JvmCodeGenUtil.toNameString(objType) + attachedFunc.funcName.value, symbolTable.anyType);
            mv.visitVarInsn(58, attachedFunctionVarIndex);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)fTypeCount);
            mv.visitInsn(136);
            mv.visitVarInsn(25, attachedFunctionVarIndex);
            mv.visitInsn(83);
            if (++fTypeCount % 100 != 0) continue;
            if (fTypeCount != nonResourceFunctions.size()) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(184, objectTypeClass, methodName + methodCount, "([Lio/ballerina/runtime/internal/types/BMethodType;)V", false);
            }
            mv.visitInsn(177);
            mv.visitMaxs(fTypeCount + 10, fTypeCount + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && fTypeCount % 100 != 0) {
            mv.visitInsn(177);
            mv.visitMaxs(fTypeCount + 10, fTypeCount + 10);
            mv.visitEnd();
        }
        return methodCount;
    }

    private void addObjectInitFunction(MethodVisitor mv, String objectTypeClass, BAttachedFunction initFunction, BObjectType objType, BIRVarToJVMIndexMap indexMap, String funcName, String moduleVar, SymbolTable symbolTable, boolean isGeneratedInit) {
        if (initFunction == null || !initFunction.funcName.value.contains(funcName)) {
            return;
        }
        mv.visitInsn(89);
        this.createObjectMemberFunction(mv, objectTypeClass, moduleVar, initFunction);
        int attachedFunctionVarIndex = indexMap.addIfNotExists(String.valueOf(objType.name) + initFunction.funcName.value, symbolTable.anyType);
        mv.visitVarInsn(58, attachedFunctionVarIndex);
        mv.visitVarInsn(25, attachedFunctionVarIndex);
        mv.visitInsn(89);
        mv.visitInsn(87);
        if (isGeneratedInit) {
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setGeneratedInitMethod", "(Lio/ballerina/runtime/internal/types/BMethodType;)V", false);
        } else {
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setInitMethod", "(Lio/ballerina/runtime/api/types/MethodType;)V", false);
        }
    }

    private void addResourceMethods(ClassWriter cw, MethodVisitor mv, String objectTypeClass, String fieldName, String moduleVar, List<BAttachedFunction> attachedFunctions, BObjectType objType, SymbolTable symbolTable) {
        if (!Symbols.isService(objType.tsymbol) && !Symbols.isClient(objType.tsymbol)) {
            return;
        }
        String objectClassName = Symbols.isService(objType.tsymbol) ? "io/ballerina/runtime/internal/types/BServiceType" : "io/ballerina/runtime/internal/types/BClientType";
        mv.visitInsn(89);
        mv.visitTypeInsn(192, objectClassName);
        mv.visitLdcInsn((Object)JvmObjectTypeGen.resourceFunctionCount(attachedFunctions));
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/api/types/ResourceMethodType");
        String methodName = "$populate" + fieldName + "$resourceFunctions";
        int methodCount = this.splitResourceMethods(cw, objectTypeClass, methodName, moduleVar, attachedFunctions, objType, symbolTable);
        if (methodCount > 0) {
            mv.visitVarInsn(58, 0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, objectTypeClass, methodName + "0", "([Lio/ballerina/runtime/api/types/ResourceMethodType;)V", false);
            mv.visitVarInsn(25, 0);
        }
        mv.visitMethodInsn(182, objectClassName, "setResourceMethods", "([Lio/ballerina/runtime/api/types/ResourceMethodType;)V", false);
    }

    private int splitResourceMethods(ClassWriter cw, String objectTypeClass, String methodName, String moduleVar, List<BAttachedFunction> attachedFunctions, BObjectType objType, SymbolTable symbolTable) {
        int resourcesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        ArrayList<BAttachedFunction> resourceFunctions = new ArrayList<BAttachedFunction>();
        for (BAttachedFunction attachedFunc : attachedFunctions) {
            if (!(attachedFunc instanceof BResourceFunction)) continue;
            resourceFunctions.add(attachedFunc);
        }
        indexMap.addIfNotExists("$array", symbolTable.anyType);
        for (BAttachedFunction attachedFunc : resourceFunctions) {
            if (resourcesCount % 100 == 0) {
                mv = cw.visitMethod(9, methodName + methodCount++, "([Lio/ballerina/runtime/api/types/ResourceMethodType;)V", null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
            }
            BResourceFunction resourceFunction = (BResourceFunction)attachedFunc;
            this.createResourceFunction(mv, objectTypeClass, moduleVar, resourceFunction);
            String varRefName = JvmCodeGenUtil.toNameString(objType) + resourceFunction.funcName.value + "$r$func";
            int rFuncVarIndex = indexMap.addIfNotExists(varRefName, symbolTable.anyType);
            mv.visitVarInsn(58, rFuncVarIndex);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)resourcesCount);
            mv.visitInsn(136);
            mv.visitVarInsn(25, rFuncVarIndex);
            mv.visitInsn(83);
            if (++resourcesCount % 100 != 0) continue;
            if (resourcesCount != resourceFunctions.size()) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(184, objectTypeClass, methodName + methodCount, "([Lio/ballerina/runtime/api/types/ResourceMethodType;)V", false);
            }
            mv.visitInsn(177);
            mv.visitMaxs(resourcesCount + 10, resourcesCount + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && resourcesCount % 100 != 0) {
            mv.visitInsn(177);
            mv.visitMaxs(resourcesCount + 10, resourcesCount + 10);
            mv.visitEnd();
        }
        return methodCount;
    }

    private static long resourceFunctionCount(List<BAttachedFunction> attachedFunctions) {
        int i = 0;
        for (BAttachedFunction attachedFunction : attachedFunctions) {
            if (!(attachedFunction instanceof BResourceFunction)) continue;
            ++i;
        }
        return i;
    }

    private void createObjectMemberFunction(MethodVisitor mv, String objectTypeClass, String moduleVar, BAttachedFunction attachedFunc) {
        if (Symbols.isRemote(attachedFunc.symbol)) {
            this.createRemoteFunction(mv, objectTypeClass, moduleVar, attachedFunc);
            return;
        }
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BMethodType");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)attachedFunc.funcName.value));
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(moduleVar), moduleVar, "Lio/ballerina/runtime/api/Module;");
        mv.visitFieldInsn(178, objectTypeClass, "t", "Lio/ballerina/runtime/internal/types/BObjectType;");
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
        this.jvmTypeGen.loadType(mv, attachedFunc.type);
        mv.visitLdcInsn((Object)attachedFunc.symbol.flags);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BMethodType", "<init>", "(Ljava/lang/String;Lio/ballerina/runtime/api/Module;Lio/ballerina/runtime/internal/types/BObjectType;Lio/ballerina/runtime/internal/types/BFunctionType;J)V", false);
    }

    private void createRemoteFunction(MethodVisitor mv, String objectTypeClass, String moduleVar, BAttachedFunction attachedFunc) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BRemoteMethodType");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)attachedFunc.funcName.value));
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(moduleVar), moduleVar, "Lio/ballerina/runtime/api/Module;");
        mv.visitFieldInsn(178, objectTypeClass, "t", "Lio/ballerina/runtime/internal/types/BObjectType;");
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
        this.jvmTypeGen.loadType(mv, attachedFunc.type);
        mv.visitLdcInsn((Object)attachedFunc.symbol.flags);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BRemoteMethodType", "<init>", "(Ljava/lang/String;Lio/ballerina/runtime/api/Module;Lio/ballerina/runtime/internal/types/BObjectType;Lio/ballerina/runtime/internal/types/BFunctionType;J)V", false);
    }

    private void createResourceFunction(MethodVisitor mv, String objectTypeClass, String moduleVar, BResourceFunction resourceFunction) {
        int i;
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BResourceMethodType");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)resourceFunction.funcName.value);
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(moduleVar), moduleVar, "Lio/ballerina/runtime/api/Module;");
        mv.visitFieldInsn(178, objectTypeClass, "t", "Lio/ballerina/runtime/internal/types/BObjectType;");
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
        this.jvmTypeGen.loadType(mv, resourceFunction.type);
        List<BResourcePathSegmentSymbol> pathSegmentSymbols = resourceFunction.pathSegmentSymbols;
        int pathSegmentSize = pathSegmentSymbols.size();
        mv.visitLdcInsn((Object)pathSegmentSize);
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/api/types/Type");
        for (i = 0; i < pathSegmentSize; ++i) {
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitInsn(136);
            this.jvmTypeGen.loadType(mv, pathSegmentSymbols.get((int)i).type);
            mv.visitInsn(83);
        }
        mv.visitLdcInsn((Object)resourceFunction.symbol.flags);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)resourceFunction.accessor.value));
        mv.visitLdcInsn((Object)pathSegmentSize);
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "java/lang/String");
        for (i = 0; i < pathSegmentSize; ++i) {
            Name path = pathSegmentSymbols.get((int)i).name;
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitInsn(136);
            mv.visitLdcInsn((Object)path.value);
            mv.visitInsn(83);
        }
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BResourceMethodType", "<init>", "(Ljava/lang/String;Lio/ballerina/runtime/api/Module;Lio/ballerina/runtime/internal/types/BObjectType;Lio/ballerina/runtime/internal/types/BFunctionType;[Lio/ballerina/runtime/api/types/Type;JLjava/lang/String;[Ljava/lang/String;)V", false);
    }

    private void addObjectFields(ClassWriter cw, MethodVisitor mv, String objectTypesClass, BObjectType bType) {
        mv.visitTypeInsn(187, "java/util/LinkedHashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        if (!bType.fields.isEmpty()) {
            mv.visitInsn(89);
            mv.visitMethodInsn(184, objectTypesClass, "addFields", "(Ljava/util/LinkedHashMap;)V", false);
            this.jvmCreateTypeGen.splitAddFields(cw, bType, objectTypesClass);
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setFields", "(Ljava/util/Map;)V", false);
    }
}

