/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.types;

import io.ballerina.identifier.Utils;
import java.util.Map;
import java.util.Optional;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.model.DoubleCheckLabelsRecord;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmRecordTypeGen {
    private final JvmCreateTypeGen jvmCreateTypeGen;
    private final JvmTypeGen jvmTypeGen;
    private final JvmConstantsGen jvmConstantsGen;

    public JvmRecordTypeGen(JvmCreateTypeGen jvmCreateTypeGen, JvmTypeGen jvmTypeGen, JvmConstantsGen jvmConstantsGen) {
        this.jvmCreateTypeGen = jvmCreateTypeGen;
        this.jvmTypeGen = jvmTypeGen;
        this.jvmConstantsGen = jvmConstantsGen;
    }

    public void createRecordType(ClassWriter cw, MethodVisitor mv, BIRNode.BIRPackage module, String recordTypeClass, BRecordType recordType, String varName, boolean isAnnotatedType, SymbolTable symbolTable) {
        cw.visitField(25, "t", "Lio/ballerina/runtime/internal/types/BRecordType;", null, null).visitEnd();
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BRecordType");
        mv.visitInsn(89);
        String name = this.getFullName(recordType);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)name));
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)varName));
        String moduleVar = this.jvmConstantsGen.getModuleConstantVar(recordType.tsymbol.pkgID);
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(moduleVar), moduleVar, "Lio/ballerina/runtime/api/Module;");
        mv.visitLdcInsn((Object)recordType.tsymbol.flags);
        mv.visitLdcInsn((Object)recordType.sealed);
        mv.visitLdcInsn((Object)this.jvmTypeGen.typeFlag(recordType));
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BRecordType", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lio/ballerina/runtime/api/Module;JZI)V", false);
        mv.visitFieldInsn(179, recordTypeClass, "t", "Lio/ballerina/runtime/internal/types/BRecordType;");
        this.genGetTypeMethod(cw, recordType, recordTypeClass, module, isAnnotatedType, symbolTable);
    }

    private void genGetTypeMethod(ClassWriter cw, BRecordType recordType, String recordTypeClass, BIRNode.BIRPackage module, boolean isAnnotatedType, SymbolTable symbolTable) {
        MethodVisitor mv = cw.visitMethod(9, "get", "()Lio/ballerina/runtime/internal/types/BRecordType;", null, null);
        mv.visitCode();
        DoubleCheckLabelsRecord checkLabelsRecord = JvmCreateTypeGen.genDoubleCheckGetStart(mv, recordTypeClass, "Lio/ballerina/runtime/internal/types/BRecordType;");
        this.populateRecord(cw, mv, module, recordTypeClass, recordType, symbolTable);
        JvmCreateTypeGen.endDoubleCheckGetEnd(mv, recordTypeClass, "Lio/ballerina/runtime/internal/types/BRecordType;", checkLabelsRecord, isAnnotatedType);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public void populateRecord(ClassWriter cw, MethodVisitor mv, BIRNode.BIRPackage module, String recordTypeClass, BRecordType bType, SymbolTable symbolTable) {
        Optional<BIntersectionType> immutableType = this.jvmCreateTypeGen.getImmutableType(bType, symbolTable);
        Map<String, String> fieldNameFPNameMap = module.recordDefaultValueMap.get(bType.tsymbol.name.value);
        mv.visitFieldInsn(178, recordTypeClass, "t", "Lio/ballerina/runtime/internal/types/BRecordType;");
        mv.visitInsn(89);
        if (immutableType.isPresent()) {
            mv.visitInsn(89);
        }
        if (fieldNameFPNameMap != null) {
            mv.visitInsn(89);
        }
        this.addRecordFields(cw, mv, recordTypeClass, bType);
        if (fieldNameFPNameMap != null) {
            this.addRecordDefaultValues(cw, mv, recordTypeClass, bType, fieldNameFPNameMap);
        }
        this.addRecordRestField(mv, bType.restFieldType);
        if (immutableType.isPresent()) {
            this.jvmTypeGen.loadType(mv, immutableType.get());
            mv.visitMethodInsn(185, "io/ballerina/runtime/api/types/Type", "setImmutableType", "(Lio/ballerina/runtime/api/types/IntersectionType;)V", true);
        }
    }

    private void addRecordFields(ClassWriter cw, MethodVisitor mv, String typeClass, BRecordType bType) {
        mv.visitTypeInsn(187, "java/util/LinkedHashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        if (!bType.fields.isEmpty()) {
            mv.visitInsn(89);
            mv.visitMethodInsn(184, typeClass, "addFields", "(Ljava/util/LinkedHashMap;)V", false);
            this.jvmCreateTypeGen.splitAddFields(cw, bType, typeClass);
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BRecordType", "setFields", "(Ljava/util/Map;)V", false);
    }

    private void addRecordDefaultValues(ClassWriter cw, MethodVisitor mv, String typeClass, BRecordType recordType, Map<String, String> fieldNameFPNameMap) {
        mv.visitTypeInsn(187, "java/util/LinkedHashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        mv.visitInsn(89);
        mv.visitMethodInsn(184, typeClass, "addDefaultValues", "(Ljava/util/LinkedHashMap;)V", false);
        this.jvmCreateTypeGen.splitAddDefaultValues(cw, typeClass, recordType, fieldNameFPNameMap);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BRecordType", "setDefaultValues", "(Ljava/util/Map;)V", false);
    }

    private void addRecordRestField(MethodVisitor mv, BType restFieldType) {
        this.jvmTypeGen.loadType(mv, restFieldType);
        mv.visitFieldInsn(181, "io/ballerina/runtime/internal/types/BRecordType", "restFieldType", "Lio/ballerina/runtime/api/types/Type;");
    }

    private String getFullName(BRecordType recordType) {
        String fullName = recordType.shouldPrintShape() ? recordType.toString() : recordType.tsymbol.name.value;
        return fullName;
    }
}

