/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.types;

import io.ballerina.identifier.Utils;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.model.DoubleCheckLabelsRecord;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmTupleTypeGen {
    private final JvmCreateTypeGen jvmCreateTypeGen;
    private final JvmTypeGen jvmTypeGen;
    private final JvmConstantsGen jvmConstantsGen;
    public int methodCount = 0;

    public JvmTupleTypeGen(JvmCreateTypeGen jvmCreateTypeGen, JvmTypeGen jvmTypeGen, JvmConstantsGen jvmConstantsGen) {
        this.jvmCreateTypeGen = jvmCreateTypeGen;
        this.jvmTypeGen = jvmTypeGen;
        this.jvmConstantsGen = jvmConstantsGen;
    }

    public void createTupleType(ClassWriter cw, MethodVisitor mv, String tupleTypeClass, BTupleType tupleType, boolean isAnnotatedType, SymbolTable symbolTable, int access) {
        cw.visitField(8 | access | 0x10, "t", "Lio/ballerina/runtime/internal/types/BTupleType;", null, null).visitEnd();
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BTupleType");
        mv.visitInsn(89);
        BTypeSymbol typeSymbol = tupleType.tsymbol;
        if (typeSymbol == null) {
            mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)tupleType.name.getValue()));
            mv.visitInsn(1);
        } else {
            mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)typeSymbol.name.getValue()));
            String moduleVar = this.jvmConstantsGen.getModuleConstantVar(typeSymbol.pkgID);
            mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(moduleVar), moduleVar, "Lio/ballerina/runtime/api/Module;");
        }
        mv.visitLdcInsn((Object)this.jvmTypeGen.typeFlag(tupleType));
        this.jvmTypeGen.loadCyclicFlag(mv, tupleType);
        this.jvmTypeGen.loadReadonlyFlag(mv, tupleType);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTupleType", "<init>", "(Ljava/lang/String;Lio/ballerina/runtime/api/Module;IZZ)V", false);
        mv.visitFieldInsn(179, tupleTypeClass, "t", "Lio/ballerina/runtime/internal/types/BTupleType;");
        this.genGetTypeMethod(cw, tupleType, tupleTypeClass, isAnnotatedType, symbolTable);
    }

    private void genGetTypeMethod(ClassWriter cw, BTupleType tupleType, String tupleTypeClass, boolean isAnnotatedType, SymbolTable symbolTable) {
        MethodVisitor mv = cw.visitMethod(9, "get", "()Lio/ballerina/runtime/internal/types/BTupleType;", null, null);
        mv.visitCode();
        DoubleCheckLabelsRecord checkLabelsRecord = JvmCreateTypeGen.genDoubleCheckGetStart(mv, tupleTypeClass, "Lio/ballerina/runtime/internal/types/BTupleType;");
        this.populateTuple(mv, tupleType, tupleTypeClass, symbolTable);
        JvmCreateTypeGen.endDoubleCheckGetEnd(mv, tupleTypeClass, "Lio/ballerina/runtime/internal/types/BTupleType;", checkLabelsRecord, isAnnotatedType);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public void populateTuple(MethodVisitor mv, BTupleType bType, String tupleTypeClass, SymbolTable symbolTable) {
        Optional<BIntersectionType> immutableType = this.jvmCreateTypeGen.getImmutableType(bType, symbolTable);
        mv.visitFieldInsn(178, tupleTypeClass, "t", "Lio/ballerina/runtime/internal/types/BTupleType;");
        mv.visitInsn(89);
        if (immutableType.isPresent()) {
            mv.visitInsn(89);
        }
        this.addCyclicFlag(mv, bType);
        this.addTupleMembers(mv, bType);
        if (immutableType.isPresent()) {
            this.jvmTypeGen.loadType(mv, immutableType.get());
            mv.visitMethodInsn(185, "io/ballerina/runtime/api/types/Type", "setImmutableType", "(Lio/ballerina/runtime/api/types/IntersectionType;)V", true);
        }
    }

    private void addTupleMembers(MethodVisitor mv, BTupleType tupleType) {
        this.createTupleMembersList(mv, tupleType.getMembers());
        BType restType = tupleType.restType;
        if (restType == null) {
            mv.visitInsn(1);
        } else {
            this.jvmTypeGen.loadType(mv, restType);
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BTupleType", "setMemberTypes", "(Ljava/util/List;Lio/ballerina/runtime/api/types/Type;)V", false);
    }

    private void addCyclicFlag(MethodVisitor mv, BType userDefinedType) {
        this.jvmTypeGen.loadCyclicFlag(mv, userDefinedType);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BTupleType", "setCyclic", "(Z)V", false);
    }

    private void createTupleMembersList(MethodVisitor mv, List<BTupleMember> members) {
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
        for (BTupleMember tupleType : members) {
            mv.visitInsn(89);
            this.jvmTypeGen.loadType(mv, tupleType.type);
            mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
        }
    }
}

