/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.utils;

import io.ballerina.identifier.Utils;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.Env;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmConstants;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmErrorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LabelGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadBirBasicBlock;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.NameHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JType;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRAbstractInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BirScope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.compiler.util.Unifier;

public final class JvmCodeGenUtil {
    public static final Unifier UNIFIER = new Unifier();
    private static final Pattern JVM_RESERVED_CHAR_SET = Pattern.compile("[.:/<>]");
    public static final String SCOPE_PREFIX = "_SCOPE_";
    public static final NameHashComparator NAME_HASH_COMPARATOR = new NameHashComparator();
    private static final Type PASS_OBJECT_RETURN_OBJECT_TYPE = Type.getType((String)"(Ljava/lang/Object;)Ljava/lang/Object;");
    private static final Type PASS_OBJECT_ARRAY_RETURN_OBJECT_TYPE = Type.getType((String)"([Ljava/lang/Object;)Ljava/lang/Object;");

    private JvmCodeGenUtil() {
    }

    public static void visitInvokeDynamic(MethodVisitor mv, String currentClass, String lambdaName, int size) {
        String mapDesc = JvmCodeGenUtil.getMapsDesc(size);
        mv.visitInvokeDynamicInsn("apply", "(" + mapDesc + ")Ljava/util/function/Function;", JvmConstants.LAMBDA_META_FACTORY_HANDLE, new Object[]{PASS_OBJECT_RETURN_OBJECT_TYPE, new Handle(6, currentClass, lambdaName, "(" + mapDesc + "[Ljava/lang/Object;)Ljava/lang/Object;", false), PASS_OBJECT_ARRAY_RETURN_OBJECT_TYPE});
    }

    private static String getMapsDesc(long count) {
        StringBuilder builder = new StringBuilder();
        for (long i = count; i > 0L; --i) {
            builder.append("Lio/ballerina/runtime/internal/values/MapValue;");
        }
        return builder.toString();
    }

    public static void createFunctionPointer(MethodVisitor mv, String className, String lambdaName) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/FPValue");
        mv.visitInsn(89);
        JvmCodeGenUtil.visitInvokeDynamic(mv, className, lambdaName, 0);
        mv.visitInsn(1);
        mv.visitLdcInsn((Object)lambdaName);
        mv.visitInsn(3);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/FPValue", "<init>", "(Ljava/util/function/Function;Lio/ballerina/runtime/api/types/Type;Ljava/lang/String;Z)V", false);
    }

    public static String cleanupPathSeparators(String name) {
        name = JvmCodeGenUtil.cleanupBalExt(name);
        return name.replace("\\", "/");
    }

    public static String rewriteVirtualCallTypeName(String value, BType objectType) {
        objectType = JvmCodeGenUtil.getImpliedType(objectType);
        String typeName = objectType.tsymbol.name.value;
        Name originalName = objectType.tsymbol.originalName;
        if (value.startsWith(typeName)) {
            value = value.replace(typeName + ".", "").trim();
        } else if (originalName != null && value.startsWith(originalName.value)) {
            value = value.replace(String.valueOf(originalName) + ".", "").trim();
        }
        return Utils.encodeFunctionIdentifier((String)value);
    }

    public static boolean isModuleInitializerMethod(String methodName) {
        return methodName.equals("$moduleInit") || methodName.equals("$moduleStart");
    }

    private static String cleanupBalExt(String name) {
        if (name.endsWith(".bal")) {
            return name.substring(0, name.length() - 4);
        }
        return name;
    }

    public static String getFieldTypeSignature(BType bType) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return "J";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return "Lio/ballerina/runtime/api/values/BString;";
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return "Lio/ballerina/runtime/internal/values/XmlValue;";
        }
        return switch (bType.tag) {
            case 2 -> "I";
            case 3 -> "D";
            case 4 -> "Lio/ballerina/runtime/internal/values/DecimalValue;";
            case 6 -> "Z";
            case 7, 10, 11, 18, 21, 33, 38, 50 -> "Ljava/lang/Object;";
            case 12, 16 -> "Lio/ballerina/runtime/internal/values/MapValue;";
            case 15 -> "Lio/ballerina/runtime/internal/values/StreamValue;";
            case 9 -> "Lio/ballerina/runtime/internal/values/TableValue;";
            case 20, 31 -> "Lio/ballerina/runtime/internal/values/ArrayValue;";
            case 29 -> "Lio/ballerina/runtime/internal/values/ErrorValue;";
            case 32 -> "Lio/ballerina/runtime/internal/values/FutureValue;";
            case 34 -> "Lio/ballerina/runtime/api/values/BObject;";
            case 13 -> "Lio/ballerina/runtime/internal/values/TypedescValue;";
            case 17 -> "Lio/ballerina/runtime/internal/values/FPValue;";
            case 37 -> "Lio/ballerina/runtime/internal/values/HandleValue;";
            case Integer.MAX_VALUE -> InteropMethodGen.getJTypeSignature((JType)bType);
            case 53 -> "Lio/ballerina/runtime/internal/values/RegExpValue;";
            default -> throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(bType));
        };
    }

    public static void generateDefaultConstructor(ClassWriter cw, String ownerClass) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, ownerClass, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public static void generateInitClassConstructor(ClassWriter cw, String ownerClass) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lio/ballerina/runtime/internal/BalRuntime;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, ownerClass, "<init>", "(Lio/ballerina/runtime/internal/BalRuntime;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public static boolean isExternFunc(BIRNode.BIRFunction func) {
        return (func.flags & 2L) == 2L;
    }

    public static void generateExitRuntime(MethodVisitor mv) {
        mv.visitMethodInsn(184, "java/lang/Runtime", "getRuntime", "()Ljava/lang/Runtime;", false);
        mv.visitInsn(3);
        mv.visitMethodInsn(182, "java/lang/Runtime", "exit", "(I)V", false);
    }

    public static String getMethodDesc(Env typeEnv, List<BType> paramTypes, BType retType) {
        return "(Lio/ballerina/runtime/internal/scheduling/Strand;" + JvmCodeGenUtil.getMethodDescParams(paramTypes) + JvmCodeGenUtil.generateReturnType(retType, typeEnv);
    }

    public static String getMethodDesc(Env typeEnv, List<BType> paramTypes, BType retType, BType attachedType) {
        return "(Lio/ballerina/runtime/internal/scheduling/Strand;" + JvmCodeGenUtil.getArgTypeSignature(attachedType) + JvmCodeGenUtil.getMethodDescParams(paramTypes) + JvmCodeGenUtil.generateReturnType(retType, typeEnv);
    }

    public static String getMethodDesc(Env typeEnv, List<BType> paramTypes, BType retType, String attachedTypeClassName) {
        return "(Lio/ballerina/runtime/internal/scheduling/Strand;L" + attachedTypeClassName + ";" + JvmCodeGenUtil.getMethodDescParams(paramTypes) + JvmCodeGenUtil.generateReturnType(retType, typeEnv);
    }

    public static String getMethodDescParams(List<BType> paramTypes) {
        StringBuilder descBuilder = new StringBuilder();
        for (BType type : paramTypes) {
            descBuilder.append(JvmCodeGenUtil.getArgTypeSignature(type));
        }
        return descBuilder.toString();
    }

    public static String getArgTypeSignature(BType bType) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return "J";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return "Lio/ballerina/runtime/api/values/BString;";
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return "Lio/ballerina/runtime/internal/values/XmlValue;";
        }
        return switch (bType.tag) {
            case 2 -> "I";
            case 3 -> "D";
            case 4 -> "Lio/ballerina/runtime/internal/values/DecimalValue;";
            case 6 -> "Z";
            case 7, 10, 11, 18, 21, 33, 38, 50 -> "Ljava/lang/Object;";
            case 20, 31 -> "Lio/ballerina/runtime/internal/values/ArrayValue;";
            case 29 -> "Lio/ballerina/runtime/internal/values/ErrorValue;";
            case 12, 16 -> "Lio/ballerina/runtime/internal/values/MapValue;";
            case 32 -> "Lio/ballerina/runtime/internal/values/FutureValue;";
            case 15 -> "Lio/ballerina/runtime/internal/values/StreamValue;";
            case 9 -> "Lio/ballerina/runtime/internal/values/TableValue;";
            case 17 -> "Lio/ballerina/runtime/internal/values/FPValue;";
            case 13 -> "Lio/ballerina/runtime/internal/values/TypedescValue;";
            case 34 -> "Lio/ballerina/runtime/api/values/BObject;";
            case 37 -> "Lio/ballerina/runtime/internal/values/HandleValue;";
            case 53 -> "Lio/ballerina/runtime/internal/values/RegExpValue;";
            default -> throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(bType));
        };
    }

    public static String generateReturnType(BType bType, Env typeEnv) {
        if ((bType = JvmCodeGenUtil.getImpliedType(bType)) == null) {
            return ")Ljava/lang/Object;";
        }
        if ((bType = UNIFIER.build(typeEnv, bType)) == null || bType.tag == 10 || bType.tag == 50) {
            return ")Ljava/lang/Object;";
        }
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return ")J";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return ")Lio/ballerina/runtime/api/values/BString;";
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return ")Lio/ballerina/runtime/internal/values/XmlValue;";
        }
        return switch (bType.tag) {
            case 2 -> ")I";
            case 3 -> ")D";
            case 4 -> ")Lio/ballerina/runtime/internal/values/DecimalValue;";
            case 6 -> ")Z";
            case 20, 31 -> ")Lio/ballerina/runtime/internal/values/ArrayValue;";
            case 12, 16 -> ")Lio/ballerina/runtime/internal/values/MapValue;";
            case 29 -> ")Lio/ballerina/runtime/internal/values/ErrorValue;";
            case 15 -> ")Lio/ballerina/runtime/internal/values/StreamValue;";
            case 9 -> ")Lio/ballerina/runtime/internal/values/TableValue;";
            case 32 -> ")Lio/ballerina/runtime/internal/values/FutureValue;";
            case 13 -> ")Lio/ballerina/runtime/internal/values/TypedescValue;";
            case 7, 11, 18, 21, 22, 33, 38 -> ")Ljava/lang/Object;";
            case 34 -> ")Lio/ballerina/runtime/api/values/BObject;";
            case 17 -> ")Lio/ballerina/runtime/internal/values/FPValue;";
            case 37 -> ")Lio/ballerina/runtime/internal/values/HandleValue;";
            case 53 -> ")Lio/ballerina/runtime/internal/values/RegExpValue;";
            default -> throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(bType));
        };
    }

    public static String toNameString(BType t) {
        BTypeSymbol typeSymbol = t.tsymbol;
        if ((typeSymbol.kind == SymbolKind.RECORD || typeSymbol.kind == SymbolKind.OBJECT) && ((BStructureTypeSymbol)typeSymbol).typeDefinitionSymbol != null) {
            return Utils.encodeNonFunctionIdentifier((String)((BStructureTypeSymbol)typeSymbol).typeDefinitionSymbol.name.value);
        }
        return Utils.encodeNonFunctionIdentifier((String)typeSymbol.name.value);
    }

    public static BirScope getLastScopeFromBBInsGen(MethodVisitor mv, LabelGenerator labelGen, JvmInstructionGen instGen, int localVarOffset, String funcName, BIRNode.BIRBasicBlock bb, Set<BirScope> visitedScopesSet, BirScope lastScope) {
        int insCount = bb.instructions.size();
        for (int i = 0; i < insCount; ++i) {
            Label insLabel = labelGen.getLabel(funcName + bb.id.value + "ins" + i);
            mv.visitLabel(insLabel);
            BIRAbstractInstruction inst = bb.instructions.get(i);
            if (inst == null) continue;
            JvmCodeGenUtil.generateDiagnosticPos(inst.pos, mv);
            instGen.generateInstructions(localVarOffset, inst);
            lastScope = JvmCodeGenUtil.getLastScope(inst, funcName, labelGen, visitedScopesSet, lastScope, mv);
        }
        return lastScope;
    }

    public static void generateDiagnosticPos(Location pos, MethodVisitor mv) {
        Label label = new Label();
        if (pos != null && pos.lineRange().startLine().line() != Integer.MIN_VALUE) {
            mv.visitLabel(label);
            mv.visitLineNumber(pos.lineRange().startLine().line() + 1, label);
        }
    }

    public static void lazyLoadAnnotations(MethodVisitor mv, LazyLoadBirBasicBlock lazyBB, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen, JvmConstantsGen jvmConstantsGen, JvmTypeGen jvmTypeGen, AsyncDataCollector asyncDataCollector) {
        BIRTerminator.Call call = lazyBB.call;
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        PackageID packageID = jvmPackageGen.currentModule.packageID;
        JvmInstructionGen instructionGen = new JvmInstructionGen(mv, indexMap, packageID, jvmPackageGen, jvmTypeGen, jvmCastGen, jvmConstantsGen, asyncDataCollector);
        if (call != null) {
            JvmErrorGen errorGen = new JvmErrorGen(mv, indexMap, instructionGen);
            LabelGenerator labelGen = new LabelGenerator();
            JvmTerminatorGen termGen = new JvmTerminatorGen(mv, indexMap, labelGen, errorGen, packageID, instructionGen, jvmPackageGen, jvmTypeGen, jvmCastGen, asyncDataCollector);
            JvmCodeGenUtil.generateDiagnosticPos(call.pos, mv);
            mv.visitInsn(1);
            mv.visitVarInsn(58, 1);
            termGen.genCall(call, call.calleePkg, 1);
            termGen.storeReturnFromCallIns(call.lhsOp != null ? call.lhsOp.variableDcl : null);
        }
        for (BIRNonTerminator instruction : lazyBB.instructions) {
            JvmCodeGenUtil.generateDiagnosticPos(instruction.pos, mv);
            instructionGen.generateInstructions(0, instruction);
        }
    }

    private static BirScope getLastScope(BIRAbstractInstruction instruction, String funcName, LabelGenerator labelGen, Set<BirScope> visitedScopesSet, BirScope lastScope, MethodVisitor mv) {
        BirScope scope = instruction.scope;
        if (scope != null && scope != lastScope) {
            lastScope = scope;
            Label scopeLabel = labelGen.getLabel(funcName + SCOPE_PREFIX + scope.id());
            mv.visitLabel(scopeLabel);
            JvmCodeGenUtil.storeLabelForParentScopes(scope, scopeLabel, labelGen, funcName, visitedScopesSet);
            visitedScopesSet.add(scope);
        }
        return lastScope;
    }

    private static void storeLabelForParentScopes(BirScope scope, Label scopeLabel, LabelGenerator labelGen, String funcName, Set<BirScope> visitedScopesSet) {
        BirScope parent = scope.parent();
        if (parent != null && !visitedScopesSet.contains(parent)) {
            String labelName = funcName + SCOPE_PREFIX + parent.id();
            labelGen.putLabel(labelName, scopeLabel);
            visitedScopesSet.add(parent);
            JvmCodeGenUtil.storeLabelForParentScopes(parent, scopeLabel, labelGen, funcName, visitedScopesSet);
        }
    }

    public static BirScope getLastScopeFromTerminator(MethodVisitor mv, BIRNode.BIRBasicBlock bb, String funcName, LabelGenerator labelGen, BirScope lastScope, Set<BirScope> visitedScopesSet) {
        BirScope scope = bb.terminator.scope;
        if (scope != null && scope != lastScope) {
            lastScope = scope;
            Label scopeLabel = labelGen.getLabel(funcName + SCOPE_PREFIX + scope.id());
            mv.visitLabel(scopeLabel);
            visitedScopesSet.add(scope);
        }
        return lastScope;
    }

    public static void genGotoThenBB(MethodVisitor mv, BIRNode.BIRBasicBlock thenBB, LabelGenerator labelGen, BIRTerminator terminator, String funcName) {
        if (thenBB != null) {
            Label gotoLabel = labelGen.getLabel(funcName + terminator.thenBB.id.value);
            mv.visitJumpInsn(167, gotoLabel);
        }
    }

    public static String cleanupFunctionName(String functionName) {
        return StringUtils.containsAny((CharSequence)functionName, (CharSequence)"\\.:/<>") ? "$" + JVM_RESERVED_CHAR_SET.matcher(functionName).replaceAll("_") : functionName;
    }

    public static boolean isSimpleBasicType(BType bType) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        return switch (bType.tag) {
            case 2, 3, 4, 6, 10, 50 -> true;
            default -> TypeTags.isIntegerTypeTag(bType.tag) || TypeTags.isStringTypeTag(bType.tag);
        };
    }

    public static boolean needNoTypeGeneration(int bTypeTag) {
        return switch (bTypeTag) {
            case 12, 21, 29, 31, 34 -> false;
            default -> true;
        };
    }

    public static BType getImpliedType(BType type) {
        if (type == null) {
            return null;
        }
        if (type.tag == 14) {
            return JvmCodeGenUtil.getImpliedType(((BTypeReferenceType)type).referredType);
        }
        if (type.tag == 22) {
            return JvmCodeGenUtil.getImpliedType(((BIntersectionType)type).effectiveType);
        }
        return type;
    }

    public static void loadConstantValue(BType bType, Object constVal, String varName, MethodVisitor mv, JvmConstantsGen jvmConstantsGen, String constantVarClassName, boolean isConstant) {
        int typeTag = JvmCodeGenUtil.getImpliedType((BType)bType).tag;
        if (TypeTags.isIntegerTypeTag(typeTag)) {
            long intValue = constVal instanceof Long ? (Long)constVal : Long.parseLong(String.valueOf(constVal));
            mv.visitLdcInsn((Object)intValue);
            return;
        }
        if (TypeTags.isStringTypeTag(typeTag)) {
            String val = String.valueOf(constVal);
            jvmConstantsGen.loadBStringConstant(mv, val, varName, constantVarClassName, isConstant);
            return;
        }
        switch (typeTag) {
            case 2: {
                int byteValue = ((Number)constVal).intValue();
                mv.visitLdcInsn((Object)byteValue);
                break;
            }
            case 3: {
                double doubleValue = constVal instanceof Double ? (Double)constVal : Double.parseDouble(String.valueOf(constVal));
                mv.visitLdcInsn((Object)doubleValue);
                break;
            }
            case 6: {
                boolean booleanVal = constVal instanceof Boolean ? (Boolean)constVal : Boolean.parseBoolean(String.valueOf(constVal));
                mv.visitLdcInsn((Object)booleanVal);
                break;
            }
            case 4: {
                mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/DecimalValue");
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)JvmCodeGenUtil.removeDecimalDiscriminator(String.valueOf(constVal)));
                mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/DecimalValue", "<init>", "(Ljava/lang/String;)V", false);
                break;
            }
            case 10: 
            case 50: {
                mv.visitInsn(1);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type : " + String.valueOf(bType));
            }
        }
    }

    public static String removeDecimalDiscriminator(String value) {
        int length = value.length();
        if (length < 2) {
            return value;
        }
        char lastChar = value.charAt(length - 1);
        if (lastChar == 'd' || lastChar == 'D') {
            return value.substring(0, length - 1);
        }
        return value;
    }

    public static void createDefaultCaseReturnNull(MethodVisitor mv, Label defaultCaseLabel) {
        mv.visitLabel(defaultCaseLabel);
        mv.visitInsn(1);
        mv.visitInsn(176);
    }

    public static void createDefaultCaseThrowError(MethodVisitor mv, Label defaultCaseLabel, int nameRegIndex, String errorMessage) {
        mv.visitLabel(defaultCaseLabel);
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ErrorValue");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)errorMessage);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
        mv.visitVarInsn(25, nameRegIndex);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(184, "io/ballerina/runtime/api/utils/StringUtils", "fromString", "(Ljava/lang/String;)Lio/ballerina/runtime/api/values/BString;", false);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ErrorValue", "<init>", "(Lio/ballerina/runtime/api/values/BString;)V", false);
        mv.visitInsn(191);
    }

    public static void castToJavaString(MethodVisitor mv, int fieldNameRegIndex, int strKeyVarIndex) {
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BString");
        mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BString", "getValue", "()Ljava/lang/String;", true);
        mv.visitVarInsn(58, strKeyVarIndex);
    }

    public static String getRefTypeConstantName(BTypeReferenceType type) {
        return Utils.encodeNonFunctionIdentifier((String)type.tsymbol.name.value);
    }

    public static void visitMaxStackForMethod(MethodVisitor mv, String funcName, String className) {
        try {
            mv.visitMaxs(0, 0);
        }
        catch (Throwable e) {
            throw new BLangCompilerException("error while generating method '" + Utils.decodeIdentifier((String)funcName) + "' in class '" + Utils.decodeIdentifier((String)className) + "'", e);
        }
    }

    public static String getMethodSig(Class<?> returnType, Class<?> ... parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Class<?> type : parameterTypes) {
            sb.append(JvmCodeGenUtil.getSig(type));
        }
        sb.append(')');
        return sb.append(JvmCodeGenUtil.getSig(returnType)).toString();
    }

    public static String getSig(Class<?> c) {
        if (c.isPrimitive()) {
            if (Integer.TYPE == c) {
                return "I";
            }
            if (Long.TYPE == c) {
                return "J";
            }
            if (Boolean.TYPE == c) {
                return "Z";
            }
            if (Byte.TYPE == c) {
                return "B";
            }
            if (Short.TYPE == c) {
                return "S";
            }
            if (Character.TYPE == c) {
                return "C";
            }
            if (Float.TYPE == c) {
                return "F";
            }
            if (Double.TYPE == c) {
                return "D";
            }
            return "V";
        }
        if (Void.TYPE == c || Void.class == c) {
            return "V";
        }
        String className = c.getName().replace('.', '/');
        if (c.isArray()) {
            return className;
        }
        return "L" + className + ";";
    }

    public static void loadStrand(MethodVisitor mv, int localVarOffset) {
        if (localVarOffset == -1) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/Scheduler", "getStrand", "()Lio/ballerina/runtime/internal/scheduling/Strand;", false);
        } else {
            mv.visitVarInsn(25, localVarOffset);
        }
    }

    public static void loadWorkerChannelMap(MethodVisitor mv, BIRNode.BIRFunction func, int channelMapVarIndex, int localVarOffset) {
        if (func.hasWorkers) {
            mv.visitVarInsn(25, channelMapVarIndex);
        } else {
            JvmCodeGenUtil.loadStrand(mv, localVarOffset);
            mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "workerChannelMap", "Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;");
        }
    }

    public static String getVarStoreClass(String varClassPkgName, String varName) {
        return varClassPkgName + varName;
    }

    public static void genMethodReturn(MethodVisitor mv) {
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public static boolean canSkipFromCallByFunctionName(String functionName) {
        if (functionName.charAt(0) != '$') {
            return false;
        }
        return functionName.startsWith("$r$") || functionName.startsWith("$split$_") || functionName.startsWith("$annot_func$");
    }
}

