/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.utils;

import io.ballerina.identifier.Utils;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class JvmModuleUtils {
    private JvmModuleUtils() {
    }

    public static String getPackageName(PackageID packageID) {
        return JvmModuleUtils.getPackageNameWithSeparator(packageID, "/");
    }

    private static String getPackageNameWithSeparator(PackageID packageID, String separator) {
        Object packageName = "";
        String orgName = Utils.encodeNonFunctionIdentifier((String)packageID.orgName.value);
        Object moduleName = !packageID.isTestPkg ? Utils.encodeNonFunctionIdentifier((String)packageID.name.value) : Utils.encodeNonFunctionIdentifier((String)packageID.name.value) + Names.TEST_PACKAGE.value;
        if (!((String)moduleName).equals("&0046")) {
            if (!packageID.version.value.isEmpty()) {
                packageName = CompilerUtils.getMajorVersion(packageID.version.value) + separator;
            }
            packageName = (String)moduleName + separator + (String)packageName;
        }
        if (!orgName.equalsIgnoreCase("$anon")) {
            packageName = orgName + separator + (String)packageName;
        }
        return packageName;
    }

    public static String getModuleLevelClassName(PackageID packageID, String sourceFileName) {
        return JvmModuleUtils.getModuleLevelClassName(packageID, sourceFileName, "/");
    }

    public static String getModuleLevelClassName(PackageID packageID, String sourceFileName, String separator) {
        String className = JvmModuleUtils.cleanupSourceFileName(sourceFileName);
        if (className.startsWith("/")) {
            className = className.substring(1);
        }
        return JvmModuleUtils.getPackageNameWithSeparator(packageID, separator) + className;
    }

    public static String getModuleLevelClassName(PackageID packageID, String prefix, String sourceFileName, String separator) {
        String className = JvmModuleUtils.cleanupSourceFileName(sourceFileName);
        if (className.startsWith("/")) {
            className = className.substring(1);
        }
        return JvmModuleUtils.getPackageNameWithSeparator(packageID, separator) + prefix + className;
    }

    public static boolean isBallerinaBuiltinModule(String orgName, String moduleName) {
        return orgName.equals("ballerina") && moduleName.equals("builtin");
    }

    public static PackageID cleanupPackageID(PackageID pkgID) {
        Name org = new Name(Utils.encodeNonFunctionIdentifier((String)pkgID.orgName.value));
        Name module = new Name(Utils.encodeNonFunctionIdentifier((String)pkgID.name.value));
        return new PackageID(org, module, pkgID.version);
    }

    public static boolean isBuiltInPackage(PackageID packageID) {
        packageID = JvmModuleUtils.cleanupPackageID(packageID);
        return "ballerina".equals(packageID.orgName.value) && "lang&0046annotations".equals(packageID.name.value);
    }

    public static boolean isSameModule(PackageID moduleId, PackageID importModule) {
        PackageID cleanedPkg = JvmModuleUtils.cleanupPackageID(importModule);
        if (!moduleId.orgName.value.equals(cleanedPkg.orgName.value)) {
            return false;
        }
        if (!moduleId.name.value.equals(cleanedPkg.name.value)) {
            return false;
        }
        return CompilerUtils.getMajorVersion(moduleId.version.value).equals(CompilerUtils.getMajorVersion(cleanedPkg.version.value));
    }

    private static String cleanupSourceFileName(String name) {
        return name.replace(".", "$$$");
    }
}

