/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.utils;

import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmErrorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LabelGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadBirBasicBlock;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;

public final class LazyLoadingCodeGenUtils {
    private LazyLoadingCodeGenUtils() {
    }

    public static void generateConstantsClassInit(ClassWriter cw, String constantsClass) {
        cw.visit(65, 33, constantsClass, null, "java/lang/Object", null);
        MethodVisitor methodVisitor = cw.visitMethod(2, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        JvmCodeGenUtil.genMethodReturn(methodVisitor);
    }

    public static void genLazyLoadingClass(ClassWriter cw, String lazyLoadingClass, String descriptor) {
        cw.visit(65, 33, lazyLoadingClass, null, "java/lang/Object", null);
        FieldVisitor fv = cw.visitField(9, "v", descriptor, null, null);
        fv.visitEnd();
        LazyLoadingCodeGenUtils.generateConstantsClassInit(cw, lazyLoadingClass);
    }

    public static void addDebugField(ClassWriter cw, String varName) {
        if (varName.startsWith("$")) {
            return;
        }
        FieldVisitor fv = cw.visitField(2, varName, "B", null, null);
        fv.visitEnd();
    }

    public static void loadIdentifierValue(ClassWriter cw, String varName, BIRNode.BIRPackage module, Map<String, LazyLoadBirBasicBlock> lazyBBMap, JvmPackageGen jvmPackageGen, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen, JvmConstantsGen jvmConstantsGen, AsyncDataCollector asyncDataCollector) {
        List<BIRNonTerminator> instructions;
        LazyLoadBirBasicBlock lazyBB = lazyBBMap.get(varName);
        if (lazyBB == null) {
            return;
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        JvmInstructionGen instructionGen = new JvmInstructionGen(mv, indexMap, module.packageID, jvmPackageGen, jvmTypeGen, jvmCastGen, jvmConstantsGen, asyncDataCollector);
        BIRTerminator.Call call = lazyBB.call;
        if (call != null) {
            JvmErrorGen errorGen = new JvmErrorGen(mv, indexMap, instructionGen);
            LabelGenerator labelGen = new LabelGenerator();
            PackageID packageID = module.packageID;
            JvmTerminatorGen termGen = new JvmTerminatorGen(mv, indexMap, labelGen, errorGen, packageID, instructionGen, jvmPackageGen, jvmTypeGen, jvmCastGen, asyncDataCollector);
            JvmCodeGenUtil.generateDiagnosticPos(call.pos, mv);
            mv.visitInsn(1);
            mv.visitVarInsn(58, 1);
            termGen.genCall(call, call.calleePkg, -1);
            termGen.storeReturnFromCallIns(call.lhsOp != null ? call.lhsOp.variableDcl : null);
        }
        if ((instructions = lazyBB.instructions) != null) {
            for (BIRNonTerminator instruction : instructions) {
                JvmCodeGenUtil.generateDiagnosticPos(instruction.pos, mv);
                instructionGen.generateInstructions(-1, instruction);
            }
        }
        JvmCodeGenUtil.genMethodReturn(mv);
    }

    public static void genLoadDebugVariablesMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(9, "loadDebugVariables", "()V", null, null);
        mv.visitCode();
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

