/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.emit;

import java.util.List;
import java.util.stream.Collectors;
import org.wso2.ballerinalang.compiler.bir.emit.EmitterUtils;
import org.wso2.ballerinalang.compiler.bir.emit.TypeEmitter;
import org.wso2.ballerinalang.compiler.bir.model.BIRAbstractInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

final class InstructionEmitter {
    private static final byte INITIAL_VALUE_COUNT = 10;

    private InstructionEmitter() {
    }

    static String emitInstructions(List<? extends BIRInstruction> instructions, int tabs) {
        StringBuilder insStr = new StringBuilder();
        for (BIRInstruction bIRInstruction : instructions) {
            insStr.append(InstructionEmitter.emitInstruction(bIRInstruction, tabs));
            insStr.append(EmitterUtils.emitLBreaks(1));
        }
        return insStr.toString();
    }

    private static String emitInstruction(BIRInstruction ins, int tabs) {
        InstructionKind kind = ins.getKind();
        if (EmitterUtils.isBinaryInstructionKind(kind)) {
            return InstructionEmitter.emitInsBinaryOp((BIRNonTerminator.BinaryOp)ins, tabs);
        }
        if (EmitterUtils.isUnaryInstructionKind(kind)) {
            return InstructionEmitter.emitInsUnaryOp((BIRNonTerminator.UnaryOP)ins, tabs);
        }
        return switch (kind) {
            case InstructionKind.CONST_LOAD -> InstructionEmitter.emitInsConstantLoad((BIRNonTerminator.ConstantLoad)ins, tabs);
            case InstructionKind.NEW_STRUCTURE -> InstructionEmitter.emitInsNewMap((BIRNonTerminator.NewStructure)ins, tabs);
            case InstructionKind.NEW_INSTANCE -> InstructionEmitter.emitInsNewInstance((BIRNonTerminator.NewInstance)ins, tabs);
            case InstructionKind.NEW_ARRAY -> InstructionEmitter.emitInsNewArray((BIRNonTerminator.NewArray)ins, tabs);
            case InstructionKind.NEW_ERROR -> InstructionEmitter.emitInsNewError((BIRNonTerminator.NewError)ins, tabs);
            case InstructionKind.FP_LOAD -> InstructionEmitter.emitInsFPLoad((BIRNonTerminator.FPLoad)ins, tabs);
            case InstructionKind.RECORD_DEFAULT_FP_LOAD -> InstructionEmitter.emitInsRecordDefaultFpLoad((BIRNonTerminator.RecordDefaultFPLoad)ins, tabs);
            case InstructionKind.MAP_LOAD, InstructionKind.MAP_STORE, InstructionKind.ARRAY_LOAD, InstructionKind.ARRAY_STORE, InstructionKind.OBJECT_LOAD, InstructionKind.OBJECT_STORE, InstructionKind.XML_ATTRIBUTE_LOAD, InstructionKind.XML_ATTRIBUTE_STORE, InstructionKind.XML_SEQ_LOAD, InstructionKind.STRING_LOAD, InstructionKind.TABLE_LOAD, InstructionKind.TABLE_STORE -> InstructionEmitter.emitInsFieldAccess((BIRNonTerminator.FieldAccess)ins, tabs);
            case InstructionKind.TYPE_CAST -> InstructionEmitter.emitInsTypeCast((BIRNonTerminator.TypeCast)ins, tabs);
            case InstructionKind.IS_LIKE -> InstructionEmitter.emitInsIsLike((BIRNonTerminator.IsLike)ins, tabs);
            case InstructionKind.TYPE_TEST -> InstructionEmitter.emitInsTypeTest((BIRNonTerminator.TypeTest)ins, tabs);
            case InstructionKind.MOVE -> InstructionEmitter.emitInsMove((BIRNonTerminator.Move)ins, tabs);
            case InstructionKind.NEW_XML_ELEMENT -> InstructionEmitter.emitInsNewXMLElement((BIRNonTerminator.NewXMLElement)ins, tabs);
            case InstructionKind.NEW_XML_SEQUENCE -> InstructionEmitter.emitInsNewXMLSequence((BIRNonTerminator.NewXMLSequence)ins, tabs);
            case InstructionKind.NEW_XML_QNAME -> InstructionEmitter.emitInsNewXMLQName((BIRNonTerminator.NewXMLQName)ins, tabs);
            case InstructionKind.NEW_STRING_XML_QNAME -> InstructionEmitter.emitInsNewStringXMLQName((BIRNonTerminator.NewStringXMLQName)ins, tabs);
            case InstructionKind.XML_LOAD_ALL, InstructionKind.XML_SEQ_STORE -> InstructionEmitter.emitInsXMLAccess((BIRNonTerminator.XMLAccess)ins, tabs);
            case InstructionKind.NEW_XML_TEXT -> InstructionEmitter.emitInsNewXMLText((BIRNonTerminator.NewXMLText)ins, tabs);
            case InstructionKind.NEW_XML_COMMENT -> InstructionEmitter.emitInsNewXMLComment((BIRNonTerminator.NewXMLComment)ins, tabs);
            case InstructionKind.NEW_XML_PI -> InstructionEmitter.emitInsNewXMLPI((BIRNonTerminator.NewXMLProcIns)ins, tabs);
            case InstructionKind.NEW_TYPEDESC -> InstructionEmitter.emitInsNewTypeDesc((BIRNonTerminator.NewTypeDesc)ins, tabs);
            case InstructionKind.NEW_TABLE -> InstructionEmitter.emitInsNewTable((BIRNonTerminator.NewTable)ins, tabs);
            default -> InstructionEmitter.emitBIRInstruction(ins.getClass().getSimpleName(), ((BIRAbstractInstruction)ins).lhsOp, ((BIRAbstractInstruction)ins).getRhsOperands(), tabs);
        };
    }

    private static String emitInsRecordDefaultFpLoad(BIRNonTerminator.RecordDefaultFPLoad ins, int tabs) {
        Object anonLoadIns = "";
        anonLoadIns = (String)anonLoadIns + EmitterUtils.emitTabs(tabs);
        anonLoadIns = (String)anonLoadIns + "_";
        anonLoadIns = (String)anonLoadIns + EmitterUtils.emitSpaces(1);
        anonLoadIns = (String)anonLoadIns + "=";
        anonLoadIns = (String)anonLoadIns + EmitterUtils.emitSpaces(1);
        anonLoadIns = (String)anonLoadIns + TypeEmitter.emitTypeRef(ins.enclosedType, tabs);
        anonLoadIns = (String)anonLoadIns + " Default => ";
        anonLoadIns = (String)anonLoadIns + ins.fieldName;
        anonLoadIns = (String)anonLoadIns + EmitterUtils.emitSpaces(1);
        anonLoadIns = (String)anonLoadIns + "<";
        anonLoadIns = (String)anonLoadIns + EmitterUtils.emitVarRef(ins.lhsOp);
        anonLoadIns = (String)anonLoadIns + ">";
        return anonLoadIns;
    }

    private static String emitBIRInstruction(String ins, BIROperand lhsOp, BIROperand[] rhsOperands, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + ins;
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitVarRefs(rhsOperands);
        str = (String)str + ";";
        return str;
    }

    private static String emitInsConstantLoad(BIRNonTerminator.ConstantLoad ins, int tabs) {
        Object cnstLStr = "";
        cnstLStr = (String)cnstLStr + EmitterUtils.emitTabs(tabs);
        cnstLStr = (String)cnstLStr + EmitterUtils.emitVarRef(ins.lhsOp);
        cnstLStr = (String)cnstLStr + EmitterUtils.emitSpaces(1);
        cnstLStr = (String)cnstLStr + "=";
        cnstLStr = (String)cnstLStr + EmitterUtils.emitSpaces(1);
        cnstLStr = (String)cnstLStr + "ConstLoad";
        cnstLStr = (String)cnstLStr + EmitterUtils.emitSpaces(1);
        cnstLStr = (String)cnstLStr + EmitterUtils.emitValue(ins.value, ins.type);
        cnstLStr = (String)cnstLStr + ";";
        return cnstLStr;
    }

    private static String emitInsNewMap(BIRNonTerminator.NewStructure ins, int tabs) {
        Object nMapStr = "";
        nMapStr = (String)nMapStr + EmitterUtils.emitTabs(tabs);
        nMapStr = (String)nMapStr + EmitterUtils.emitVarRef(ins.lhsOp);
        nMapStr = (String)nMapStr + EmitterUtils.emitSpaces(1);
        nMapStr = (String)nMapStr + "=";
        nMapStr = (String)nMapStr + EmitterUtils.emitSpaces(1);
        nMapStr = (String)nMapStr + "NewMap";
        nMapStr = (String)nMapStr + EmitterUtils.emitSpaces(1);
        nMapStr = (String)nMapStr + EmitterUtils.emitVarRef(ins.rhsOp);
        nMapStr = (String)nMapStr + "{";
        nMapStr = (String)nMapStr + InstructionEmitter.emitMapValues(ins.initialValues);
        nMapStr = (String)nMapStr + "}";
        nMapStr = (String)nMapStr + ";";
        return nMapStr;
    }

    private static String emitMapValues(List<BIRNode.BIRMappingConstructorEntry> initialValues) {
        if (initialValues.isEmpty()) {
            return "";
        }
        StringBuilder outStr = new StringBuilder();
        for (int i = 0; i < Math.min(initialValues.size(), 10); ++i) {
            BIRNode.BIRMappingConstructorEntry mappingEntry = initialValues.get(i);
            if (mappingEntry instanceof BIRNode.BIRMappingConstructorKeyValueEntry) {
                BIRNode.BIRMappingConstructorKeyValueEntry entry = (BIRNode.BIRMappingConstructorKeyValueEntry)mappingEntry;
                outStr.append(EmitterUtils.emitVarRef(entry.keyOp)).append(":").append(EmitterUtils.emitVarRef(entry.valueOp)).append(",");
                continue;
            }
            outStr.append(EmitterUtils.emitVarRef(((BIRNode.BIRMappingConstructorSpreadFieldEntry)mappingEntry).exprOp)).append(",");
        }
        return initialValues.size() > 10 ? outStr.append("...").toString() : outStr.substring(0, outStr.length() - 1);
    }

    private static String emitInsNewTable(BIRNonTerminator.NewTable ins, int tabs) {
        Object nMapStr = "";
        nMapStr = (String)nMapStr + EmitterUtils.emitTabs(tabs);
        nMapStr = (String)nMapStr + EmitterUtils.emitVarRef(ins.lhsOp);
        nMapStr = (String)nMapStr + EmitterUtils.emitSpaces(1);
        nMapStr = (String)nMapStr + "=";
        nMapStr = (String)nMapStr + EmitterUtils.emitSpaces(1);
        nMapStr = (String)nMapStr + "NewTable";
        nMapStr = (String)nMapStr + EmitterUtils.emitSpaces(1);
        nMapStr = (String)nMapStr + "<";
        nMapStr = (String)nMapStr + EmitterUtils.emitVarRef(ins.dataOp);
        nMapStr = (String)nMapStr + ">";
        nMapStr = (String)nMapStr + EmitterUtils.emitSpaces(1);
        nMapStr = (String)nMapStr + "key(";
        nMapStr = (String)nMapStr + EmitterUtils.emitVarRef(ins.dataOp);
        nMapStr = (String)nMapStr + ");";
        return nMapStr;
    }

    private static String emitInsNewInstance(BIRNonTerminator.NewInstance ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "new";
        str = (String)str + EmitterUtils.emitSpaces(1);
        if (ins.isExternalDef) {
            str = (String)str + EmitterUtils.emitModuleID(ins.externalPackageId);
            str = (String)str + ":";
            str = (String)str + ins.objectName;
        } else {
            str = (String)str + EmitterUtils.emitName(ins.def.internalName);
        }
        str = (String)str + ";";
        return str;
    }

    private static String emitInsNewArray(BIRNonTerminator.NewArray ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "newArray";
        str = (String)str + EmitterUtils.emitSpaces(1);
        BType type = Types.getImpliedType(ins.type);
        str = type.tag == 31 ? (String)str + EmitterUtils.emitVarRef(ins.typedescOp) : (String)str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = (String)str + "[";
        str = (String)str + EmitterUtils.emitVarRef(ins.sizeOp);
        str = (String)str + "]";
        if (ins.elementTypedescOp != null) {
            str = (String)str + " elementTypeDesc " + EmitterUtils.emitVarRef(ins.elementTypedescOp);
        }
        str = (String)str + "{";
        str = (String)str + InstructionEmitter.emitArrayValues(ins.values);
        str = (String)str + "}";
        str = (String)str + ";";
        return str;
    }

    private static String emitArrayValues(List<BIRNode.BIRListConstructorEntry> values) {
        int operandArraySize = Math.min(10, values.size());
        BIROperand[] valueOperands = new BIROperand[operandArraySize];
        for (int i = 0; i < operandArraySize; ++i) {
            valueOperands[i] = values.get((int)i).exprOp;
        }
        String result = EmitterUtils.emitVarRefs(valueOperands);
        return values.size() > 10 ? result + ",..." : result;
    }

    private static String emitInsNewError(BIRNonTerminator.NewError ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "error";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = (String)str + "(";
        str = (String)str + EmitterUtils.emitVarRef(ins.messageOp);
        str = (String)str + ",";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitVarRef(ins.causeOp);
        str = (String)str + ",";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitVarRef(ins.detailOp);
        str = (String)str + ")";
        str = (String)str + ";";
        return str;
    }

    private static String emitInsFPLoad(BIRNonTerminator.FPLoad ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "fp";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitModuleID(ins.pkgId);
        str = (String)str + "::";
        str = (String)str + EmitterUtils.emitName(ins.funcName);
        str = (String)str + InstructionEmitter.emitClosureParams(ins.closureMaps);
        str = (String)str + ";";
        return str;
    }

    private static String emitClosureParams(List<BIROperand> closureVars) {
        Object str = "";
        if (!closureVars.isEmpty()) {
            str = (String)str + "(";
            str = (String)str + closureVars.stream().map(EmitterUtils::emitVarRef).collect(Collectors.joining(","));
            str = (String)str + ")";
        }
        return str;
    }

    private static String emitInsFieldAccess(BIRNonTerminator.FieldAccess ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        if (ins.kind == InstructionKind.MAP_LOAD || ins.kind == InstructionKind.ARRAY_LOAD) {
            str = (String)str + EmitterUtils.emitSpaces(1);
            str = (String)str + "=";
            str = (String)str + EmitterUtils.emitSpaces(1);
            str = (String)str + EmitterUtils.emitVarRef(ins.rhsOp);
            str = (String)str + "[";
            str = (String)str + EmitterUtils.emitVarRef(ins.keyOp);
            str = (String)str + "]";
        } else if (ins.kind == InstructionKind.MAP_STORE || ins.kind == InstructionKind.ARRAY_STORE || ins.kind == InstructionKind.OBJECT_STORE) {
            str = (String)str + "[";
            str = (String)str + EmitterUtils.emitVarRef(ins.keyOp);
            str = (String)str + "]";
            str = (String)str + EmitterUtils.emitSpaces(1);
            str = (String)str + "=";
            str = (String)str + EmitterUtils.emitSpaces(1);
            str = (String)str + EmitterUtils.emitVarRef(ins.rhsOp);
        }
        str = (String)str + ";";
        return str;
    }

    private static String emitInsTypeCast(BIRNonTerminator.TypeCast ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "<";
        str = (String)str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = (String)str + ">";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitVarRef(ins.rhsOp);
        str = (String)str + ";";
        return str;
    }

    private static String emitInsIsLike(BIRNonTerminator.IsLike ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitVarRef(ins.rhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "isLike";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = (String)str + ";";
        return str;
    }

    private static String emitInsTypeTest(BIRNonTerminator.TypeTest ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitVarRef(ins.rhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "is";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = (String)str + ";";
        return str;
    }

    private static String emitInsMove(BIRNonTerminator.Move ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitVarRef(ins.rhsOp);
        str = (String)str + ";";
        return str;
    }

    private static String emitInsBinaryOp(BIRNonTerminator.BinaryOp ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitVarRef(ins.rhsOp1);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitBinaryOpInstructionKind(ins.kind);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitVarRef(ins.rhsOp2);
        str = (String)str + ";";
        return str;
    }

    private static String emitInsNewXMLElement(BIRNonTerminator.NewXMLElement ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "new xml:Element";
        str = (String)str + "(";
        str = (String)str + EmitterUtils.emitVarRef(ins.startTagOp);
        str = (String)str + ",";
        str = (String)str + EmitterUtils.emitVarRef(ins.defaultNsURIOp);
        str = (String)str + ")";
        str = (String)str + ";";
        return str;
    }

    private static String emitInsNewXMLSequence(BIRNonTerminator.NewXMLSequence ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "new xml:Sequence";
        str = (String)str + "()";
        str = (String)str + ";";
        return str;
    }

    private static String emitInsNewXMLQName(BIRNonTerminator.NewXMLQName ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "new xml:QName";
        str = (String)str + "(";
        str = (String)str + EmitterUtils.emitVarRef(ins.localnameOp);
        str = (String)str + ",";
        str = (String)str + "{";
        str = (String)str + EmitterUtils.emitVarRef(ins.nsURIOp);
        str = (String)str + "}";
        str = (String)str + ",";
        str = (String)str + EmitterUtils.emitVarRef(ins.prefixOp);
        str = (String)str + ")";
        str = (String)str + ";";
        return str;
    }

    private static String emitInsNewStringXMLQName(BIRNonTerminator.NewStringXMLQName ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "new xml:StringQName";
        str = (String)str + "(";
        str = (String)str + EmitterUtils.emitVarRef(ins.stringQNameOP);
        str = (String)str + ")";
        str = (String)str + ";";
        return str;
    }

    private static String emitInsXMLAccess(BIRNonTerminator.XMLAccess ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        if (ins.kind == InstructionKind.XML_LOAD_ALL) {
            str = (String)str + "new xml:Load";
        } else if (ins.kind == InstructionKind.XML_SEQ_STORE) {
            str = (String)str + "new xml:SequenceStore";
        }
        str = (String)str + "(";
        str = (String)str + EmitterUtils.emitVarRef(ins.rhsOp);
        str = (String)str + ")";
        str = (String)str + ";";
        return str;
    }

    private static String emitInsNewXMLText(BIRNonTerminator.NewXMLText ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "new xml:Text";
        str = (String)str + "(";
        str = (String)str + EmitterUtils.emitVarRef(ins.textOp);
        str = (String)str + ")";
        str = (String)str + ";";
        return str;
    }

    private static String emitInsNewXMLComment(BIRNonTerminator.NewXMLComment ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "new xml:Comment";
        str = (String)str + "(";
        str = (String)str + EmitterUtils.emitVarRef(ins.textOp);
        str = (String)str + ")";
        str = (String)str + ";";
        return str;
    }

    private static String emitInsNewXMLPI(BIRNonTerminator.NewXMLProcIns ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "new xml:ProcessingInstruction";
        str = (String)str + "(";
        str = (String)str + EmitterUtils.emitVarRef(ins.targetOp);
        str = (String)str + ",";
        str = (String)str + EmitterUtils.emitVarRef(ins.dataOp);
        str = (String)str + ")";
        str = (String)str + ";";
        return str;
    }

    private static String emitInsUnaryOp(BIRNonTerminator.UnaryOP ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + ins.kind.toString().toLowerCase();
        str = (String)str + " ";
        str = (String)str + EmitterUtils.emitVarRef(ins.rhsOp);
        str = (String)str + ";";
        return str;
    }

    private static String emitInsNewTypeDesc(BIRNonTerminator.NewTypeDesc ins, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(ins.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "newType";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + TypeEmitter.emitTypeRef(ins.type, 0);
        str = (String)str + InstructionEmitter.emitClosureParams(ins.closureVars);
        str = (String)str + ";";
        return str;
    }

    static String emitTerminator(BIRTerminator term, int tabs) {
        return switch (term.kind) {
            case InstructionKind.WAIT -> InstructionEmitter.emitWait((BIRTerminator.Wait)term, tabs);
            case InstructionKind.FLUSH -> InstructionEmitter.emitFlush((BIRTerminator.Flush)term, tabs);
            case InstructionKind.WK_RECEIVE -> InstructionEmitter.emitWorkerReceive((BIRTerminator.WorkerReceive)term, tabs);
            case InstructionKind.WK_SEND -> InstructionEmitter.emitWorkerSend((BIRTerminator.WorkerSend)term, tabs);
            case InstructionKind.CALL -> InstructionEmitter.emitCall((BIRTerminator.Call)term, tabs);
            case InstructionKind.ASYNC_CALL -> InstructionEmitter.emitAsyncCall((BIRTerminator.AsyncCall)term, tabs);
            case InstructionKind.BRANCH -> InstructionEmitter.emitBranch((BIRTerminator.Branch)term, tabs);
            case InstructionKind.GOTO -> InstructionEmitter.emitGOTO((BIRTerminator.GOTO)term, tabs);
            case InstructionKind.LOCK -> InstructionEmitter.emitLock((BIRTerminator.Lock)term, tabs);
            case InstructionKind.FIELD_LOCK -> InstructionEmitter.emitFieldLock((BIRTerminator.FieldLock)term, tabs);
            case InstructionKind.UNLOCK -> InstructionEmitter.emitUnlock((BIRTerminator.Unlock)term, tabs);
            case InstructionKind.RETURN -> InstructionEmitter.emitReturn(tabs);
            case InstructionKind.PANIC -> InstructionEmitter.emitPanic((BIRTerminator.Panic)term, tabs);
            case InstructionKind.FP_CALL -> InstructionEmitter.emitFPCall((BIRTerminator.FPCall)term, tabs);
            case InstructionKind.WAIT_ALL -> InstructionEmitter.emitWaitAll((BIRTerminator.WaitAll)term, tabs);
            default -> InstructionEmitter.emitBIRTerminator(term.getClass().getSimpleName(), term.lhsOp, term.getRhsOperands(), tabs, term.thenBB);
        };
    }

    private static String emitBIRTerminator(String ins, BIROperand lhsOp, BIROperand[] rhsOperands, int tabs, BIRNode.BIRBasicBlock thenBB) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + ins;
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitVarRefs(rhsOperands);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "->";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitBasicBlockRef(thenBB);
        str = (String)str + ";";
        return str;
    }

    private static String emitWait(BIRTerminator.Wait term, int tabs) {
        StringBuilder str = new StringBuilder();
        str.append(EmitterUtils.emitTabs(tabs));
        str.append(EmitterUtils.emitVarRef(term.lhsOp));
        str.append(EmitterUtils.emitSpaces(1));
        str.append("=");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("wait");
        str.append(EmitterUtils.emitSpaces(1));
        int i = 0;
        int argLength = term.exprList.size();
        while (i < argLength) {
            BIROperand ref = term.exprList.get(i);
            if (ref == null) continue;
            str.append(EmitterUtils.emitVarRef(ref));
            if (++i >= argLength) continue;
            str.append(EmitterUtils.emitSpaces(1));
            str.append("|");
            str.append(EmitterUtils.emitSpaces(1));
        }
        str.append(EmitterUtils.emitSpaces(1));
        str.append("->");
        str.append(EmitterUtils.emitSpaces(1));
        str.append(EmitterUtils.emitBasicBlockRef(term.thenBB));
        str.append(";");
        return str.toString();
    }

    private static String emitFlush(BIRTerminator.Flush term, int tabs) {
        StringBuilder str = new StringBuilder();
        str.append(EmitterUtils.emitTabs(tabs));
        str.append(EmitterUtils.emitVarRef(term.lhsOp));
        str.append(EmitterUtils.emitSpaces(1));
        str.append("=");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("flush");
        str.append(EmitterUtils.emitSpaces(1));
        int i = 0;
        int argLength = term.channels.length;
        while (i < argLength) {
            BIRNode.ChannelDetails ref = term.channels[i];
            str.append(ref.name);
            if (++i >= argLength) continue;
            str.append(",");
            str.append(EmitterUtils.emitSpaces(1));
        }
        str.append(EmitterUtils.emitSpaces(1));
        str.append("->");
        str.append(EmitterUtils.emitSpaces(1));
        str.append(EmitterUtils.emitBasicBlockRef(term.thenBB));
        str.append(";");
        return str.toString();
    }

    private static String emitWorkerReceive(BIRTerminator.WorkerReceive term, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(term.lhsOp);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "<=";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitName(term.workerName);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "->";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitBasicBlockRef(term.thenBB);
        str = (String)str + ";";
        return str;
    }

    private static String emitWorkerSend(BIRTerminator.WorkerSend term, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        BIROperand lhsOp = term.lhsOp;
        if (lhsOp != null) {
            str = (String)str + EmitterUtils.emitVarRef(lhsOp);
            str = (String)str + EmitterUtils.emitSpaces(1);
            str = (String)str + "=";
            str = (String)str + EmitterUtils.emitSpaces(1);
        }
        str = (String)str + EmitterUtils.emitVarRef(term.data);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = term.isSync ? (String)str + "=>" : (String)str + "=>>";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitName(term.channel);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "->";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitBasicBlockRef(term.thenBB);
        str = (String)str + ";";
        return str;
    }

    private static String emitCall(BIRTerminator.Call term, int tabs) {
        StringBuilder callStr = new StringBuilder();
        callStr.append(EmitterUtils.emitTabs(tabs));
        BIROperand lhsOp = term.lhsOp;
        if (lhsOp != null) {
            callStr.append(EmitterUtils.emitVarRef(lhsOp));
            callStr.append(EmitterUtils.emitSpaces(1));
            callStr.append("=");
            callStr.append(EmitterUtils.emitSpaces(1));
        }
        callStr.append(EmitterUtils.emitName(term.name));
        callStr.append("(");
        int i = 0;
        int argLength = term.args.size();
        for (BIROperand ref : term.args) {
            if (ref == null) continue;
            callStr.append(EmitterUtils.emitVarRef(ref));
            if (++i >= argLength) continue;
            callStr.append(",");
            callStr.append(EmitterUtils.emitSpaces(1));
        }
        callStr.append(")");
        callStr.append(EmitterUtils.emitSpaces(1));
        callStr.append("->");
        callStr.append(EmitterUtils.emitSpaces(1));
        callStr.append(EmitterUtils.emitBasicBlockRef(term.thenBB));
        callStr.append(";");
        return callStr.toString();
    }

    private static String emitAsyncCall(BIRTerminator.AsyncCall term, int tabs) {
        StringBuilder str = new StringBuilder();
        str.append(EmitterUtils.emitTabs(tabs));
        BIROperand lhsOp = term.lhsOp;
        if (lhsOp != null) {
            str.append(EmitterUtils.emitVarRef(lhsOp));
            str.append(EmitterUtils.emitSpaces(1));
            str.append("=");
            str.append(EmitterUtils.emitSpaces(1));
        }
        str.append("start");
        str.append(EmitterUtils.emitSpaces(1));
        str.append(EmitterUtils.emitName(term.name));
        str.append("(");
        int i = 0;
        int argLength = term.args.size();
        for (BIROperand ref : term.args) {
            if (ref == null) continue;
            str.append(EmitterUtils.emitVarRef(ref));
            if (++i >= argLength) continue;
            str.append(",");
            str.append(EmitterUtils.emitSpaces(1));
        }
        str.append(")");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("->");
        str.append(EmitterUtils.emitSpaces(1));
        str.append(EmitterUtils.emitBasicBlockRef(term.thenBB));
        str.append(";");
        return str.toString();
    }

    private static String emitBranch(BIRTerminator.Branch term, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitVarRef(term.op);
        str = (String)str + "?";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitBasicBlockRef(term.trueBB);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + ":";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitBasicBlockRef(term.falseBB);
        str = (String)str + ";";
        return str;
    }

    private static String emitGOTO(BIRTerminator.GOTO term, int tabs) {
        Object retStr = "";
        retStr = (String)retStr + EmitterUtils.emitTabs(tabs);
        retStr = (String)retStr + "GOTO";
        retStr = (String)retStr + EmitterUtils.emitSpaces(1);
        retStr = (String)retStr + EmitterUtils.emitBasicBlockRef(term.targetBB);
        retStr = (String)retStr + ";";
        return retStr;
    }

    private static String emitLock(BIRTerminator.Lock term, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + "lock";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "->";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitBasicBlockRef(term.lockedBB);
        str = (String)str + ";";
        return str;
    }

    private static String emitFieldLock(BIRTerminator.FieldLock term, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + "lock";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + term.field;
        str = (String)str + "[\"";
        str = (String)str + term.field;
        str = (String)str + "\"]";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + "->";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + EmitterUtils.emitBasicBlockRef(term.lockedBB);
        str = (String)str + ";";
        return str;
    }

    private static String emitUnlock(BIRTerminator.Unlock term, int tabs) {
        return EmitterUtils.emitTabs(tabs) + "unlock" + EmitterUtils.emitSpaces(1) + "->" + EmitterUtils.emitSpaces(1) + EmitterUtils.emitBasicBlockRef(term.unlockBB) + ";";
    }

    private static String emitReturn(int tabs) {
        Object retStr = "";
        retStr = (String)retStr + EmitterUtils.emitTabs(tabs);
        retStr = (String)retStr + "return";
        retStr = (String)retStr + ";";
        return retStr;
    }

    private static String emitPanic(BIRTerminator.Panic term, int tabs) {
        Object retStr = "";
        retStr = (String)retStr + EmitterUtils.emitTabs(tabs);
        retStr = (String)retStr + "panic";
        retStr = (String)retStr + EmitterUtils.emitSpaces(1);
        retStr = (String)retStr + EmitterUtils.emitVarRef(term.errorOp);
        retStr = (String)retStr + ";";
        return retStr;
    }

    private static String emitFPCall(BIRTerminator.FPCall term, int tabs) {
        StringBuilder callStr = new StringBuilder();
        callStr.append(EmitterUtils.emitTabs(tabs));
        BIROperand lhsOp = term.lhsOp;
        if (lhsOp != null) {
            callStr.append(EmitterUtils.emitVarRef(lhsOp));
            callStr.append(EmitterUtils.emitSpaces(1));
            callStr.append("=");
            callStr.append(EmitterUtils.emitSpaces(1));
        }
        callStr.append("FPCall");
        callStr.append(EmitterUtils.emitSpaces(1));
        callStr.append(EmitterUtils.emitVarRef(term.fp));
        callStr.append("(");
        int i = 0;
        int argLength = term.args.size();
        for (BIROperand ref : term.args) {
            if (ref == null) continue;
            callStr.append(EmitterUtils.emitVarRef(ref));
            if (++i >= argLength) continue;
            callStr.append(",");
            callStr.append(EmitterUtils.emitSpaces(1));
        }
        callStr.append(")");
        callStr.append(EmitterUtils.emitSpaces(1));
        callStr.append("->");
        callStr.append(EmitterUtils.emitSpaces(1));
        callStr.append(EmitterUtils.emitBasicBlockRef(term.thenBB));
        callStr.append(";");
        return callStr.toString();
    }

    private static String emitWaitAll(BIRTerminator.WaitAll term, int tabs) {
        StringBuilder str = new StringBuilder();
        str.append(EmitterUtils.emitTabs(tabs));
        str.append(EmitterUtils.emitVarRef(term.lhsOp));
        str.append(EmitterUtils.emitSpaces(1));
        str.append("=");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("waitAll");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("{");
        int i = 0;
        int argLength = term.valueExprs.size();
        while (i < argLength) {
            BIROperand ref = term.valueExprs.get(i);
            String key = term.keys.get(i);
            if (ref == null) continue;
            str.append("\"");
            str.append(key);
            str.append("\"");
            str.append(":");
            str.append(EmitterUtils.emitSpaces(1));
            str.append(EmitterUtils.emitVarRef(ref));
            if (++i >= argLength) continue;
            str.append(",");
            str.append(EmitterUtils.emitSpaces(1));
        }
        str.append("}");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("->");
        str.append(EmitterUtils.emitSpaces(1));
        str.append(EmitterUtils.emitBasicBlockRef(term.thenBB));
        str.append(";");
        return str.toString();
    }
}

