/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.emit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringJoiner;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.emit.EmitterUtils;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;

final class TypeEmitter {
    static final Map<String, BType> B_TYPES = new HashMap<String, BType>();

    private TypeEmitter() {
    }

    static String emitType(BType bType, int tabs) {
        return switch (bType.tag) {
            case 1 -> "int";
            case 39 -> "int:Signed32";
            case 40 -> "int:Signed16";
            case 41 -> "int:Signed8";
            case 42 -> "int:Unsigned32";
            case 43 -> "int:Unsigned16";
            case 44 -> "int:Unsigned8";
            case 6 -> "boolean";
            case 18 -> "any";
            case 10 -> "()";
            case 50 -> "never";
            case 2 -> "byte";
            case 3 -> "float";
            case 5 -> "string";
            case 11 -> "anydata";
            case 38 -> "readonly";
            case 24 -> "none";
            case 7 -> "json";
            case 8 -> "xml";
            case 49 -> "xml:Text";
            case 46 -> "xml:Element";
            case 48 -> "xml:Comment";
            case 47 -> "xml:ProcessingInstruction";
            case 4 -> "decimal";
            case 45 -> "string:Char";
            case 53 -> "regexp:RegExp";
            case 21 -> TypeEmitter.emitBUnionType((BUnionType)bType, tabs);
            case 22 -> TypeEmitter.emitBIntersectionType((BIntersectionType)bType, tabs);
            case 31 -> TypeEmitter.emitBTupleType((BTupleType)bType, tabs);
            case 17 -> TypeEmitter.emitBInvokableType((BInvokableType)bType, tabs);
            case 20 -> TypeEmitter.emitBArrayType((BArrayType)bType, tabs);
            case 12 -> TypeEmitter.emitBRecordType((BRecordType)bType, tabs);
            case 34 -> TypeEmitter.emitBObjectType((BObjectType)bType, tabs);
            case 16 -> TypeEmitter.emitBMapType((BMapType)bType, tabs);
            case 9 -> TypeEmitter.emitTableType((BTableType)bType, tabs);
            case 29 -> TypeEmitter.emitBErrorType((BErrorType)bType, tabs);
            case 32 -> TypeEmitter.emitBFutureType((BFutureType)bType, tabs);
            case 13 -> TypeEmitter.emitBTypeDesc((BTypedescType)bType, tabs);
            case 33 -> TypeEmitter.emitBFiniteType((BFiniteType)bType, tabs);
            case 37 -> TypeEmitter.emitBTypeHandle((BHandleType)bType, tabs);
            case 15 -> TypeEmitter.emitBStreamType((BStreamType)bType, tabs);
            case 14 -> TypeEmitter.emitTypeRefDesc((BTypeReferenceType)bType, tabs);
            case 52 -> TypeEmitter.emitParameterizedType((BParameterizedType)bType, tabs);
            default -> throw new IllegalStateException("Invalid type");
        };
    }

    private static String emitParameterizedType(BParameterizedType type, int tabs) {
        Object str = "parameterized ";
        str = (String)str + "<";
        str = (String)str + TypeEmitter.emitTypeRef(type.paramValueType, 0);
        str = (String)str + ">";
        return str;
    }

    private static String emitTableType(BTableType bType, int tabs) {
        Object stringRep;
        boolean readonly = Symbols.isFlagOn(bType.getFlags(), 32L);
        if (bType.constraint == null) {
            return readonly ? bType.toString().concat(" & readonly") : bType.toString();
        }
        StringBuilder keyStringBuilder = new StringBuilder();
        if (!bType.fieldNameList.isEmpty()) {
            for (String fieldName : bType.fieldNameList) {
                if (!keyStringBuilder.toString().isEmpty()) {
                    keyStringBuilder.append(", ");
                }
                keyStringBuilder.append(fieldName);
            }
            stringRep = bType.toString() + "<" + TypeEmitter.emitType(bType.constraint, tabs) + "> key(" + keyStringBuilder.toString() + ")";
        } else {
            stringRep = (bType.toString() + "<" + TypeEmitter.emitType(bType.constraint, tabs) + "> " + (String)(bType.keyTypeConstraint != null ? "key<" + TypeEmitter.emitType(bType.keyTypeConstraint, tabs) + ">" : "")).trim();
        }
        return readonly ? ((String)stringRep).concat(" & readonly") : stringRep;
    }

    private static String emitBUnionType(BUnionType bType, int tabs) {
        if (bType.isCyclic) {
            return bType.toString();
        }
        StringBuilder unionStr = new StringBuilder();
        int length = ((HashSet)bType.getMemberTypes()).size();
        int i = 0;
        for (BType mType : bType.getMemberTypes()) {
            if (mType == null) continue;
            unionStr.append(TypeEmitter.emitTypeRef(mType, tabs));
            if (++i >= length) continue;
            unionStr.append("|");
        }
        return unionStr.toString();
    }

    private static String emitTypeRefDesc(BTypeReferenceType bType, int tabs) {
        Object str = "typeRefDesc";
        str = (String)str + "<";
        str = (String)str + EmitterUtils.getTypeName(bType);
        str = (String)str + ">";
        return str;
    }

    private static String emitBIntersectionType(BIntersectionType bType, int tabs) {
        StringJoiner strJoiner = new StringJoiner(" & ");
        for (BType type : bType.getConstituentTypes()) {
            strJoiner.add(TypeEmitter.emitTypeRef(type, tabs));
        }
        return strJoiner.toString();
    }

    private static String emitBTupleType(BTupleType bType, int tabs) {
        if (bType.isCyclic) {
            return bType.toString();
        }
        StringBuilder tupleStr = new StringBuilder("(");
        int length = bType.getMembers().size();
        int i = 0;
        for (BTupleMember tupleMember : bType.getMembers()) {
            if (tupleMember == null) continue;
            tupleStr.append(TypeEmitter.emitTypeRef(tupleMember.type, tabs));
            if (++i >= length) continue;
            tupleStr.append(",");
            tupleStr.append(EmitterUtils.emitSpaces(1));
        }
        tupleStr.append(")");
        return tupleStr.toString();
    }

    private static String emitBInvokableType(BInvokableType bType, int tabs) {
        StringBuilder invString = new StringBuilder("function(");
        int i = 0;
        if (bType.paramTypes != null) {
            int pLength = bType.paramTypes.size();
            for (BType pType : bType.paramTypes) {
                if (pType == null) continue;
                invString.append(TypeEmitter.emitTypeRef(pType, tabs));
                if (++i >= pLength) continue;
                invString.append(",");
                invString.append(EmitterUtils.emitSpaces(1));
            }
        }
        invString.append(")");
        BType retType = bType.retType;
        if (retType != null) {
            invString.append(EmitterUtils.emitSpaces(1));
            invString.append("->");
            invString.append(EmitterUtils.emitSpaces(1));
            invString.append(TypeEmitter.emitTypeRef(retType, tabs));
        }
        return invString.toString();
    }

    private static String emitBArrayType(BArrayType bType, int tabs) {
        Object arrStr = TypeEmitter.emitTypeRef(bType.eType, 0);
        arrStr = (String)arrStr + "[";
        if (bType.getSize() > 0) {
            arrStr = (String)arrStr + bType.getSize();
        }
        arrStr = (String)arrStr + "]";
        return arrStr;
    }

    private static String emitBRecordType(BRecordType bType, int tabs) {
        StringBuilder recordStr = new StringBuilder("record");
        recordStr.append(EmitterUtils.emitSpaces(1));
        recordStr.append("{");
        recordStr.append(EmitterUtils.emitLBreaks(1));
        for (BField bField : bType.fields.values()) {
            if (bField == null) continue;
            recordStr.append(EmitterUtils.emitTabs(tabs + 1));
            String flags = EmitterUtils.emitFlags(bField.type.getFlags());
            recordStr.append(flags);
            if (!flags.isEmpty()) {
                recordStr.append(EmitterUtils.emitSpaces(1));
            }
            recordStr.append(TypeEmitter.emitTypeRef(bField.type, tabs + 1));
            recordStr.append(EmitterUtils.emitSpaces(1));
            recordStr.append(EmitterUtils.emitName(bField.name));
            recordStr.append(";");
            recordStr.append(EmitterUtils.emitLBreaks(1));
        }
        recordStr.append("}");
        return recordStr.toString();
    }

    private static String emitBObjectType(BObjectType bType, int tabs) {
        boolean isService = Symbols.isFlagOn(bType.getFlags(), 262144L);
        StringBuilder str = new StringBuilder();
        str.append(isService ? "service object" : "object");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("{");
        str.append(EmitterUtils.emitLBreaks(1));
        for (BField bField : bType.fields.values()) {
            if (bField == null) continue;
            str.append(EmitterUtils.emitTabs(tabs + 1));
            String flags = EmitterUtils.emitFlags(bField.type.getFlags());
            str.append(flags);
            if (!flags.isEmpty()) {
                str.append(EmitterUtils.emitSpaces(1));
            }
            str.append(TypeEmitter.emitTypeRef(bField.type, tabs + 1));
            str.append(EmitterUtils.emitSpaces(1));
            str.append(EmitterUtils.emitName(bField.name));
            str.append(";");
            str.append(EmitterUtils.emitLBreaks(1));
        }
        int nTab = tabs + 1;
        BObjectTypeSymbol objectSymbol = (BObjectTypeSymbol)bType.tsymbol;
        BAttachedFunction generatedInitializerFunc = objectSymbol.generatedInitializerFunc;
        if (generatedInitializerFunc != null) {
            str.append(TypeEmitter.emitBAttachedFunction(generatedInitializerFunc, nTab));
        }
        str.append(EmitterUtils.emitLBreaks(1));
        BAttachedFunction initializerFunc = objectSymbol.initializerFunc;
        if (initializerFunc != null) {
            str.append(TypeEmitter.emitBAttachedFunction(initializerFunc, nTab));
        }
        str.append(EmitterUtils.emitLBreaks(1));
        for (BAttachedFunction attachedFunc : objectSymbol.attachedFuncs) {
            if (attachedFunc == null) continue;
            str.append(TypeEmitter.emitBAttachedFunction(attachedFunc, nTab));
            str.append(EmitterUtils.emitLBreaks(1));
        }
        str.append("}");
        return str.toString();
    }

    private static String emitBAttachedFunction(BAttachedFunction func, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitName(func.funcName);
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + TypeEmitter.emitType(func.type, 0);
        return str;
    }

    private static String emitBMapType(BMapType bType, int tabs) {
        Object str = "map";
        str = (String)str + "<";
        str = (String)str + TypeEmitter.emitTypeRef(bType.constraint, 0);
        str = (String)str + ">";
        return str;
    }

    private static String emitBErrorType(BErrorType bType, int tabs) {
        Object errStr = "error{";
        errStr = (String)errStr + TypeEmitter.emitTypeRef(bType.detailType, tabs);
        errStr = (String)errStr + "}";
        return errStr;
    }

    private static String emitBFutureType(BFutureType bType, int tabs) {
        Object str = "future";
        str = (String)str + "<";
        str = (String)str + TypeEmitter.emitTypeRef(bType.getConstraint(), 0);
        str = (String)str + ">";
        return str;
    }

    private static String emitBTypeDesc(BTypedescType bType, int tabs) {
        Object str = "typeDesc";
        str = (String)str + "<";
        str = (String)str + TypeEmitter.emitTypeRef(bType.constraint, 0);
        str = (String)str + ">";
        return str;
    }

    private static String emitBFiniteType(BFiniteType bType, int tabs) {
        return "[" + bType.toString() + "]";
    }

    private static String emitBTypeHandle(BHandleType bType, int tabs) {
        Object str = "handle";
        str = (String)str + "<";
        str = (String)str + ">";
        return str;
    }

    private static String emitBStreamType(BStreamType bType, int tabs) {
        StringBuilder str = new StringBuilder();
        str.append("stream");
        str.append("<");
        str.append(TypeEmitter.emitTypeRef(bType.constraint, 0));
        if (bType.completionType.tag != 10) {
            str.append(",");
            str.append(EmitterUtils.emitSpaces(1));
            str.append(TypeEmitter.emitTypeRef(bType.completionType, 0));
        }
        str.append(">");
        return str.toString();
    }

    static String emitTypeRef(BType type, int tabs) {
        BType bType = JvmCodeGenUtil.getImpliedType(type);
        String tName = EmitterUtils.getTypeName(bType);
        if (!"".equals(tName)) {
            return tName;
        }
        if (bType.tag == 29) {
            B_TYPES.put(bType.tsymbol.toString(), bType);
        }
        if (bType.tag == 12 || bType.tag == 34) {
            return bType.tsymbol.toString();
        }
        return TypeEmitter.emitType(type, tabs);
    }
}

