/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.model;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;
import org.wso2.ballerinalang.compiler.bir.model.BirScope;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.NamedNode;
import org.wso2.ballerinalang.compiler.util.Name;

public abstract class BIRNode {
    public final Location pos;

    protected BIRNode(Location pos) {
        this.pos = pos;
    }

    public abstract void accept(BIRVisitor var1);

    public static class BIRServiceDeclaration
    extends BIRDocumentableNode {
        public List<String> attachPoint;
        public String attachPointLiteral;
        public List<BType> listenerTypes;
        public Name generatedName;
        public Name associatedClassName;
        public BType type;
        public SymbolOrigin origin;
        public long flags;

        public BIRServiceDeclaration(List<String> attachPoint, String attachPointLiteral, List<BType> listenerTypes, Name generatedName, Name associatedClassName, BType type, SymbolOrigin origin, long flags, Location location) {
            super(location);
            this.attachPoint = attachPoint;
            this.attachPointLiteral = attachPointLiteral;
            this.listenerTypes = listenerTypes;
            this.generatedName = generatedName;
            this.associatedClassName = associatedClassName;
            this.type = type;
            this.origin = origin;
            this.flags = flags;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRListConstructorExprEntry
    extends BIRListConstructorEntry {
        public BIRListConstructorExprEntry(BIROperand exprOp) {
            this.exprOp = exprOp;
        }
    }

    public static class BIRListConstructorSpreadMemberEntry
    extends BIRListConstructorEntry {
        public BIRListConstructorSpreadMemberEntry(BIROperand exprOp) {
            this.exprOp = exprOp;
        }
    }

    public static abstract class BIRListConstructorEntry {
        public BIROperand exprOp;
    }

    public static class BIRMappingConstructorSpreadFieldEntry
    extends BIRMappingConstructorEntry {
        public BIROperand exprOp;

        public BIRMappingConstructorSpreadFieldEntry(BIROperand exprOp) {
            this.exprOp = exprOp;
        }

        @Override
        public boolean isKeyValuePair() {
            return false;
        }
    }

    public static class BIRMappingConstructorKeyValueEntry
    extends BIRMappingConstructorEntry {
        public BIROperand keyOp;
        public BIROperand valueOp;

        public BIRMappingConstructorKeyValueEntry(BIROperand keyOp, BIROperand valueOp) {
            this.keyOp = keyOp;
            this.valueOp = valueOp;
        }
    }

    public static abstract class BIRMappingConstructorEntry {
        public boolean isKeyValuePair() {
            return true;
        }
    }

    public static class BIRLockDetailsHolder {
        private final List<BIRTerminator.Lock> locks = new ArrayList<BIRTerminator.Lock>();

        public boolean isEmpty() {
            return this.locks.isEmpty();
        }

        public void removeLastLock() {
            this.locks.remove(this.size() - 1);
        }

        public BIRTerminator.Lock getLock(int index) {
            return this.locks.get(index);
        }

        public void addLock(BIRTerminator.Lock lock) {
            this.locks.add(lock);
        }

        public int size() {
            return this.locks.size();
        }
    }

    public static abstract class BIRDocumentableNode
    extends BIRNode {
        public MarkdownDocAttachment markdownDocAttachment;

        protected BIRDocumentableNode(Location pos) {
            super(pos);
        }

        public void setMarkdownDocAttachment(MarkdownDocAttachment markdownDocAttachment) {
            this.markdownDocAttachment = markdownDocAttachment;
        }
    }

    public static class ConstValue {
        public BType type;
        public Object value;

        public ConstValue(Object value, BType type) {
            this.value = value;
            this.type = type;
        }
    }

    public static class BIRConstAnnotationAttachment
    extends BIRAnnotationAttachment {
        public ConstValue annotValue;

        public BIRConstAnnotationAttachment(Location pos, PackageID annotPkgId, Name annotTagRef, ConstValue annotValue) {
            super(pos, annotPkgId, annotTagRef);
            this.annotValue = annotValue;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRAnnotationAttachment
    extends BIRNode {
        public PackageID annotPkgId;
        public Name annotTagRef;

        public BIRAnnotationAttachment(Location pos, PackageID annotPkgId, Name annotTagRef) {
            super(pos);
            this.annotPkgId = annotPkgId;
            this.annotTagRef = annotTagRef;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRConstant
    extends BIRDocumentableNode {
        public Name name;
        public long flags;
        public BType type;
        public ConstValue constValue;
        public SymbolOrigin origin;
        public List<BIRAnnotationAttachment> annotAttachments;

        public BIRConstant(Location pos, Name name, long flags, BType type, ConstValue constValue, SymbolOrigin origin) {
            super(pos);
            this.name = name;
            this.flags = flags;
            this.type = type;
            this.constValue = constValue;
            this.origin = origin;
            this.annotAttachments = new ArrayList<BIRAnnotationAttachment>();
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRAnnotation
    extends BIRDocumentableNode {
        public Name name;
        public Name originalName;
        public long flags;
        public SymbolOrigin origin;
        public Set<AttachPoint> attachPoints;
        public BType annotationType;
        public PackageID packageID;
        public List<BIRAnnotationAttachment> annotAttachments;

        public BIRAnnotation(Location pos, Name name, Name originalName, long flags, Set<AttachPoint> points, BType annotationType, SymbolOrigin origin) {
            super(pos);
            this.name = name;
            this.originalName = originalName;
            this.flags = flags;
            this.attachPoints = points;
            this.annotationType = annotationType;
            this.origin = origin;
            this.annotAttachments = new ArrayList<BIRAnnotationAttachment>();
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ChannelDetails {
        public String name;
        public boolean channelInSameStrand;
        public boolean send;

        public ChannelDetails(String name, boolean channelInSameStrand, boolean send) {
            this.name = name;
            this.channelInSameStrand = channelInSameStrand;
            this.send = send;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class BIRErrorEntry
    extends BIRNode {
        public BIRBasicBlock trapBB;
        public BIRBasicBlock endBB;
        public BIROperand errorOp;
        public BIRBasicBlock targetBB;

        public BIRErrorEntry(BIRBasicBlock trapBB, BIRBasicBlock endBB, BIROperand errorOp, BIRBasicBlock targetBB) {
            super(null);
            this.trapBB = trapBB;
            this.endBB = endBB;
            this.errorOp = errorOp;
            this.targetBB = targetBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRTypeDefinition
    extends BIRDocumentableNode
    implements NamedNode {
        public Name name;
        public Name originalName;
        public Name internalName;
        public List<BIRFunction> attachedFuncs;
        public long flags;
        public BType type;
        public boolean isBuiltin;
        public List<BType> referencedTypes;
        public BType referenceType;
        public SymbolOrigin origin;
        public List<BIRAnnotationAttachment> annotAttachments;
        public int index;

        public BIRTypeDefinition(Location pos, Name internalName, long flags, boolean isBuiltin, BType type, List<BIRFunction> attachedFuncs, SymbolOrigin origin, Name name, Name originalName) {
            super(pos);
            this.internalName = internalName;
            this.flags = flags;
            this.isBuiltin = isBuiltin;
            this.type = type;
            this.attachedFuncs = attachedFuncs;
            this.referencedTypes = new ArrayList<BType>();
            this.origin = origin;
            this.name = name;
            this.originalName = originalName;
            this.annotAttachments = new ArrayList<BIRAnnotationAttachment>();
        }

        public BIRTypeDefinition(Location pos, Name name, Name originalName, long flags, boolean isBuiltin, BType type, List<BIRFunction> attachedFuncs, SymbolOrigin origin) {
            this(pos, name, flags, isBuiltin, type, attachedFuncs, origin, name, originalName);
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return String.valueOf(this.type) + " " + String.valueOf(this.internalName);
        }

        @Override
        public Name getName() {
            return this.name;
        }
    }

    public static class BIRBasicBlock
    extends BIRNode {
        public int number;
        public Name id;
        public List<BIRNonTerminator> instructions;
        public BIRTerminator terminator;
        public static final String BIR_BASIC_BLOCK_PREFIX = "bb";

        public BIRBasicBlock(Name id, int number) {
            super(null);
            this.number = number;
            this.id = id;
            this.instructions = new ArrayList<BIRNonTerminator>();
            this.terminator = null;
        }

        public BIRBasicBlock(int number) {
            this(new Name(BIR_BASIC_BLOCK_PREFIX + number), number);
        }

        public BIRBasicBlock(String idPrefix, int number) {
            this(new Name(idPrefix + number), number);
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return this.id.value;
        }
    }

    public static class BIRFunction
    extends BIRDocumentableNode
    implements NamedNode {
        public Name name;
        public Name originalName;
        public long flags;
        public SymbolOrigin origin;
        public BInvokableType type;
        public List<BIRParameter> requiredParams;
        public BIRVariableDcl receiver;
        public BIRParameter restParam;
        public int argsCount;
        public List<BIRVariableDcl> localVars;
        public BIRVariableDcl returnVariable;
        public List<BIRFunctionParameter> parameters;
        public List<BIRBasicBlock> basicBlocks;
        public List<BIRErrorEntry> errorTable;
        public Name workerName;
        public ChannelDetails[] workerChannels;
        public List<BIRAnnotationAttachment> annotAttachments;
        public List<BIRAnnotationAttachment> annotAttachmentsOnExternal = null;
        public List<BIRAnnotationAttachment> returnTypeAnnots;
        public Set<BIRGlobalVariableDcl> dependentGlobalVars = new TreeSet<BIRGlobalVariableDcl>();
        public List<BIRVariableDcl> pathParams;
        public BIRVariableDcl restPathParam;
        public List<Name> resourcePath;
        public List<Location> resourcePathSegmentPosList;
        public Name accessor;
        public List<BType> pathSegmentTypeList;
        public boolean hasWorkers;

        public BIRFunction(Location pos, Name name, Name originalName, long flags, SymbolOrigin origin, BInvokableType type, List<BIRParameter> requiredParams, BIRVariableDcl receiver, BIRParameter restParam, int argsCount, List<BIRVariableDcl> localVars, BIRVariableDcl returnVariable, List<BIRFunctionParameter> parameters, List<BIRBasicBlock> basicBlocks, List<BIRErrorEntry> errorTable, Name workerName, ChannelDetails[] workerChannels, List<BIRAnnotationAttachment> annotAttachments, List<BIRAnnotationAttachment> returnTypeAnnots, Set<BIRGlobalVariableDcl> dependentGlobalVars) {
            super(pos);
            this.name = name;
            this.originalName = originalName;
            this.flags = flags;
            this.origin = origin;
            this.type = type;
            this.requiredParams = requiredParams;
            this.receiver = receiver;
            this.restParam = restParam;
            this.argsCount = argsCount;
            this.localVars = localVars;
            this.returnVariable = returnVariable;
            this.parameters = parameters;
            this.basicBlocks = basicBlocks;
            this.errorTable = errorTable;
            this.workerName = workerName;
            this.workerChannels = workerChannels;
            this.annotAttachments = annotAttachments;
            this.returnTypeAnnots = returnTypeAnnots;
            this.dependentGlobalVars = dependentGlobalVars;
        }

        public BIRFunction(Location pos, Name name, Name originalName, long flags, BInvokableType type, Name workerName, int sendInsCount, SymbolOrigin origin) {
            super(pos);
            this.name = name;
            this.originalName = originalName;
            this.flags = flags;
            this.type = type;
            this.localVars = new ArrayList<BIRVariableDcl>();
            this.parameters = new ArrayList<BIRFunctionParameter>();
            this.requiredParams = new ArrayList<BIRParameter>();
            this.basicBlocks = new ArrayList<BIRBasicBlock>();
            this.errorTable = new ArrayList<BIRErrorEntry>();
            this.workerName = workerName;
            this.workerChannels = new ChannelDetails[sendInsCount];
            this.annotAttachments = new ArrayList<BIRAnnotationAttachment>();
            this.returnTypeAnnots = new ArrayList<BIRAnnotationAttachment>();
            this.origin = origin;
        }

        public BIRFunction(Location pos, Name name, long flags, BInvokableType type, Name workerName, int sendInsCount, SymbolOrigin origin) {
            this(pos, name, name, flags, type, workerName, sendInsCount, origin);
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public BIRFunction duplicate() {
            BIRFunction f = new BIRFunction(this.pos, this.name, this.originalName, this.flags, this.type, this.workerName, 0, this.origin);
            f.localVars = this.localVars;
            f.parameters = this.parameters;
            f.requiredParams = this.requiredParams;
            f.basicBlocks = this.basicBlocks;
            f.errorTable = this.errorTable;
            f.workerChannels = this.workerChannels;
            f.annotAttachments = this.annotAttachments;
            f.annotAttachmentsOnExternal = this.annotAttachmentsOnExternal;
            f.returnTypeAnnots = this.returnTypeAnnots;
            return f;
        }

        @Override
        public Name getName() {
            return this.name;
        }
    }

    public static class BIRFunctionParameter
    extends BIRVariableDcl {
        public final boolean hasDefaultExpr;
        public boolean isPathParameter;

        public BIRFunctionParameter(Location pos, BType type, Name name, VarScope scope, VarKind kind, String metaVarName, boolean hasDefaultExpr) {
            super(pos, type, name, scope, kind, metaVarName);
            this.hasDefaultExpr = hasDefaultExpr;
        }

        public BIRFunctionParameter(Location pos, BType type, Name name, VarScope scope, VarKind kind, String metaVarName, boolean hasDefaultExpr, boolean isPathParameter) {
            this(pos, type, name, scope, kind, metaVarName, hasDefaultExpr);
            this.isPathParameter = isPathParameter;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRGlobalVariableDcl
    extends BIRVariableDcl {
        public long flags;
        public PackageID pkgId;
        public SymbolOrigin origin;
        public List<BIRAnnotationAttachment> annotAttachments;

        public BIRGlobalVariableDcl(Location pos, long flags, BType type, PackageID pkgId, Name name, Name originalName, VarScope scope, VarKind kind, String metaVarName, SymbolOrigin origin) {
            super(pos, type, name, originalName, scope, kind, metaVarName);
            this.flags = flags;
            this.pkgId = pkgId;
            this.origin = origin;
            this.annotAttachments = new ArrayList<BIRAnnotationAttachment>();
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRParameter
    extends BIRNode {
        public Name name;
        public long flags;
        public List<BIRAnnotationAttachment> annotAttachments;

        public BIRParameter(Location pos, Name name, long flags) {
            super(pos);
            this.name = name;
            this.flags = flags;
            this.annotAttachments = new ArrayList<BIRAnnotationAttachment>();
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRVariableDcl
    extends BIRDocumentableNode {
        public BType type;
        public Name name;
        public Name originalName;
        public String metaVarName;
        public String jvmVarName;
        public VarKind kind;
        public VarScope scope;
        public boolean ignoreVariable;
        public BIRBasicBlock endBB;
        public BIRBasicBlock startBB;
        public int insOffset;
        public boolean onlyUsedInSingleBB;
        public boolean initialized = false;
        public BirScope insScope;

        public BIRVariableDcl(Location pos, BType type, Name name, Name originalName, VarScope scope, VarKind kind, String metaVarName) {
            super(pos);
            this.type = type;
            this.name = name;
            this.originalName = originalName;
            this.scope = scope;
            this.kind = kind;
            this.metaVarName = metaVarName;
            this.jvmVarName = name.value.replace("%", "_");
        }

        public BIRVariableDcl(Location pos, BType type, Name name, VarScope scope, VarKind kind, String metaVarName) {
            this(pos, type, name, name, scope, kind, metaVarName);
        }

        public BIRVariableDcl(BType type, Name name, VarScope scope, VarKind kind) {
            this(null, type, name, scope, kind, null);
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BIRVariableDcl)) {
                return false;
            }
            BIRVariableDcl otherVarDecl = (BIRVariableDcl)other;
            return this.name.equals(otherVarDecl.name);
        }

        public int hashCode() {
            return this.name.value.hashCode();
        }

        public String toString() {
            return this.name.toString();
        }
    }

    public static class BIRImportModule
    extends BIRNode {
        public final PackageID packageID;

        public BIRImportModule(Location pos, Name org, Name name, Name version) {
            super(pos);
            this.packageID = new PackageID(org, name, version);
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.packageID.equals(((BIRImportModule)o).packageID);
        }

        public int hashCode() {
            return this.packageID.hashCode();
        }
    }

    public static class BIRPackage
    extends BIRNode {
        public final PackageID packageID;
        public final Set<BIRImportModule> importModules;
        public final List<BIRTypeDefinition> typeDefs;
        public final List<BIRGlobalVariableDcl> globalVars;
        public final Set<BIRGlobalVariableDcl> importedGlobalVarsDummyVarDcls;
        public final List<BIRFunction> functions;
        public final List<BIRAnnotation> annotations;
        public final List<BIRConstant> constants;
        public final List<BIRServiceDeclaration> serviceDecls;
        public boolean isListenerAvailable;
        public Map<String, Map<String, String>> recordDefaultValueMap = new HashMap<String, Map<String, String>>();

        public BIRPackage(Location pos, Name org, Name pkgName, Name name, Name version, Name sourceFileName, String sourceRoot, boolean skipTest) {
            this(pos, org, pkgName, name, version, sourceFileName, sourceRoot, skipTest, false);
        }

        public BIRPackage(Location pos, Name org, Name pkgName, Name name, Name version, Name sourceFileName, String sourceRoot, boolean skipTest, boolean isTestPkg) {
            super(pos);
            this.packageID = new PackageID(org, pkgName, name, version, sourceFileName, sourceRoot, isTestPkg, skipTest);
            this.importModules = new LinkedHashSet<BIRImportModule>();
            this.typeDefs = new ArrayList<BIRTypeDefinition>();
            this.globalVars = new ArrayList<BIRGlobalVariableDcl>();
            this.importedGlobalVarsDummyVarDcls = new HashSet<BIRGlobalVariableDcl>();
            this.functions = new ArrayList<BIRFunction>();
            this.annotations = new ArrayList<BIRAnnotation>();
            this.constants = new ArrayList<BIRConstant>();
            this.serviceDecls = new ArrayList<BIRServiceDeclaration>();
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }
}

