/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.writer;

import java.util.Objects;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class CPEntry {
    public Type entryType;

    public CPEntry(Type entryType) {
        this.entryType = entryType;
    }

    public static enum Type {
        CP_ENTRY_INTEGER(1),
        CP_ENTRY_FLOAT(2),
        CP_ENTRY_BOOLEAN(3),
        CP_ENTRY_STRING(4),
        CP_ENTRY_PACKAGE(5),
        CP_ENTRY_BYTE(6),
        CP_ENTRY_SHAPE(7);

        final byte value;

        private Type(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static class ShapeCPEntry
    extends CPEntry {
        public final BType shape;

        public ShapeCPEntry(BType shape) {
            super(Type.CP_ENTRY_SHAPE);
            this.shape = shape;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShapeCPEntry that = (ShapeCPEntry)o;
            return Objects.equals(this.shape, that.shape);
        }

        public int hashCode() {
            return Objects.hash(this.shape);
        }
    }

    public static class PackageCPEntry
    extends CPEntry {
        public int orgNameCPIndex;
        public int pkgNameCPIndex;
        public int moduleNameCPIndex;
        public int versionCPIndex;

        public PackageCPEntry(int orgNameCPIndex, int pkgNameCPIndex, int moduleNameCPIndex, int versionCPIndex) {
            super(Type.CP_ENTRY_PACKAGE);
            this.orgNameCPIndex = orgNameCPIndex;
            this.pkgNameCPIndex = pkgNameCPIndex;
            this.moduleNameCPIndex = moduleNameCPIndex;
            this.versionCPIndex = versionCPIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackageCPEntry that = (PackageCPEntry)o;
            return this.orgNameCPIndex == that.orgNameCPIndex && this.pkgNameCPIndex == that.pkgNameCPIndex && this.moduleNameCPIndex == that.moduleNameCPIndex && this.versionCPIndex == that.versionCPIndex;
        }

        public int hashCode() {
            return Objects.hash(this.orgNameCPIndex, this.pkgNameCPIndex, this.moduleNameCPIndex, this.versionCPIndex);
        }
    }

    public static class ByteCPEntry
    extends CPEntry {
        public int value;

        public ByteCPEntry(int value) {
            super(Type.CP_ENTRY_BYTE);
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteCPEntry that = (ByteCPEntry)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static class StringCPEntry
    extends CPEntry {
        public String value;

        public StringCPEntry(String value) {
            super(Type.CP_ENTRY_STRING);
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringCPEntry that = (StringCPEntry)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static class BooleanCPEntry
    extends CPEntry {
        public boolean value;

        public BooleanCPEntry(boolean value) {
            super(Type.CP_ENTRY_BOOLEAN);
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BooleanCPEntry that = (BooleanCPEntry)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static class FloatCPEntry
    extends CPEntry {
        public double value;

        public FloatCPEntry(double value) {
            super(Type.CP_ENTRY_FLOAT);
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FloatCPEntry that = (FloatCPEntry)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static class IntegerCPEntry
    extends CPEntry {
        public long value;

        public IntegerCPEntry(long value) {
            super(Type.CP_ENTRY_INTEGER);
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntegerCPEntry that = (IntegerCPEntry)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

