/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.Env;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.ClassClosureDesugar;
import org.wso2.ballerinalang.compiler.desugar.Desugar;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeyTypeConstraint;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.OCEDynamicEnvironmentData;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAlternateWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangDynamicArgExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownDocumentationLine;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownReturnParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMultipleWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRegExpTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerAsyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.FieldKind;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class ClosureDesugar
extends BLangNodeVisitor {
    private static final CompilerContext.Key<ClosureDesugar> CLOSURE_DESUGAR_KEY = new CompilerContext.Key();
    private static final String BLOCK_MAP_SYM_NAME = "$map$block$_";
    private static final String FUNCTION_MAP_SYM_NAME = "$map$func$_";
    private static final String OBJECT_CTOR_MAP_SYM_NAME = "$map$objectCtor_";
    private static final String PARAMETER_MAP_NAME = "$paramMap$_";
    private static final BVarSymbol CLOSURE_MAP_NOT_FOUND = new BVarSymbol(0L, new Name("$not$found"), null, null, null, null, SymbolOrigin.VIRTUAL);
    private SymbolResolver symResolver;
    private final SymbolTable symTable;
    private SymbolEnv env;
    private BLangNode result;
    private final Types types;
    private final Desugar desugar;
    private final Names names;
    private final ClassClosureDesugar classClosureDesugar;
    private int funClosureMapCount = 1;
    private int blockClosureMapCount = 1;

    public static ClosureDesugar getInstance(CompilerContext context) {
        ClosureDesugar desugar = context.get(CLOSURE_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new ClosureDesugar(context);
        }
        return desugar;
    }

    private ClosureDesugar(CompilerContext context) {
        context.put(CLOSURE_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
        this.desugar = Desugar.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.classClosureDesugar = ClassClosureDesugar.getInstance(context);
        ClosureDesugar.CLOSURE_MAP_NOT_FOUND.pos = this.symTable.builtinPos;
        this.symResolver = SymbolResolver.getInstance(context);
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        pkgNode.services.forEach(service -> this.rewrite(service, pkgEnv));
        pkgNode.globalVars.forEach(globalVar -> this.rewrite(globalVar, pkgEnv));
        pkgNode.typeDefinitions.forEach(typeDefinition -> this.rewrite(typeDefinition, pkgEnv));
        pkgNode.xmlnsList.forEach(xmlns -> this.rewrite(xmlns, pkgEnv));
        pkgNode.constants.forEach(constant -> this.rewrite(constant, pkgEnv));
        pkgNode.annotations.forEach(annotation -> this.rewrite(annotation, pkgEnv));
        pkgNode.initFunction = this.rewrite(pkgNode.initFunction, pkgEnv);
        for (BLangFunction bLangFunction : pkgNode.functions) {
            if (bLangFunction.flagSet.contains((Object)Flag.LAMBDA)) continue;
            this.rewrite(bLangFunction, pkgEnv);
        }
        for (BLangClassDefinition classDef : pkgNode.classDefinitions) {
            if (!classDef.isObjectContructorDecl) continue;
            this.updateClassClosureMap(classDef);
        }
        for (BLangFunction function : pkgNode.functions) {
            ClosureDesugar.updateFunctionParams(this.types.typeEnv(), function);
        }
        this.result = pkgNode;
    }

    private boolean isObjectConstructorRelated(TopLevelNode pkgLevelNode) {
        if (pkgLevelNode.getKind() == NodeKind.CLASS_DEFN && ((BLangClassDefinition)pkgLevelNode).isObjectContructorDecl) {
            return true;
        }
        if (pkgLevelNode.getKind() == NodeKind.FUNCTION && ((BLangFunction)pkgLevelNode).flagSet.contains((Object)Flag.OBJECT_CTOR)) {
            return false;
        }
        return false;
    }

    private void createClosureMapUpdateExpression(BLangClassDefinition classDef, BVarSymbol blockMap, BVarSymbol classMapSymbol) {
        OCEDynamicEnvironmentData oceEnvData = classDef.oceEnvData;
        BVarSymbol oceMap = oceEnvData.mapBlockMapSymbol;
        BLangFunction function = classDef.generatedInitFunction;
        BVarSymbol selfSymbol = function.receiver.symbol;
        BLangSimpleVarRef selfVarRef = ASTBuilderUtil.createVariableRef(function.pos, selfSymbol);
        BLangSimpleVarRef refToBlockClosureMap = ASTBuilderUtil.createVariableRef(function.pos, blockMap);
        BLangIdentifier identifierNode = ASTBuilderUtil.createIdentifier(function.pos, blockMap.name.value);
        BLangFieldBasedAccess fieldAccess = ASTBuilderUtil.createFieldAccessExpr(selfVarRef, identifierNode);
        fieldAccess.symbol = oceMap;
        fieldAccess.setBType(classMapSymbol.type);
        fieldAccess.expectedType = classMapSymbol.type;
        fieldAccess.isStoreOnCreation = true;
        fieldAccess.isLValue = true;
        fieldAccess.fieldKind = FieldKind.SINGLE;
        fieldAccess.leafNode = true;
        BLangAssignment assignmentStmt = (BLangAssignment)TreeBuilder.createAssignmentNode();
        assignmentStmt.expr = refToBlockClosureMap;
        assignmentStmt.pos = function.pos;
        assignmentStmt.setVariable(fieldAccess);
        fieldAccess.parent = assignmentStmt;
        BLangFunction generatedInitFunction = classDef.generatedInitFunction;
        BLangBlockFunctionBody generatedInitFnBody = (BLangBlockFunctionBody)generatedInitFunction.body;
        generatedInitFnBody.stmts.add(0, assignmentStmt);
        assignmentStmt.parent = generatedInitFnBody;
        this.desugar.rewrite(assignmentStmt, oceEnvData.objMethodsEnv);
    }

    private void addClosureMapToInit(BLangClassDefinition classDef, BVarSymbol mapSymbol) {
        OCEDynamicEnvironmentData oceData = classDef.oceEnvData;
        BLangSimpleVarRef refToBlockClosureMap = ASTBuilderUtil.createVariableRef(classDef.pos, mapSymbol);
        BLangTypeInit typeInit = oceData.typeInit;
        BLangInvocation initInvocation = (BLangInvocation)oceData.initInvocation;
        if (typeInit.argsExpr == null) {
            typeInit.argsExpr = new ArrayList<BLangExpression>();
        }
        typeInit.argsExpr.add(refToBlockClosureMap);
        initInvocation.requiredArgs.add(refToBlockClosureMap);
        initInvocation.argExprs.add(refToBlockClosureMap);
        BLangSimpleVariable blockClosureMap = ASTBuilderUtil.createVariable(this.symTable.builtinPos, mapSymbol.name.value, mapSymbol.getType(), null, mapSymbol);
        blockClosureMap.flagSet.add(Flag.REQUIRED_PARAM);
        BObjectTypeSymbol typeSymbol = (BObjectTypeSymbol)classDef.getBType().tsymbol;
        if (typeSymbol.generatedInitializerFunc != null) {
            BAttachedFunction attachedInitFunction = typeSymbol.generatedInitializerFunc;
            attachedInitFunction.symbol.params.add(mapSymbol);
        }
        BLangFunction initFunction = classDef.generatedInitFunction;
        initFunction.desugared = false;
        initFunction.requiredParams.add(blockClosureMap);
        SymbolEnv env = oceData.objMethodsEnv;
        BVarSymbol paramSym = new BVarSymbol(4L, mapSymbol.name, env.scope.owner.pkgID, mapSymbol.type, initFunction.symbol, classDef.pos, SymbolOrigin.VIRTUAL);
        initFunction.symbol.scope.define(paramSym.name, paramSym);
        initFunction.symbol.params.add(paramSym);
        BInvokableType initFuncSymbolType = (BInvokableType)initFunction.symbol.type;
        initFuncSymbolType.addParamType(mapSymbol.type);
        BInvokableType initFnType = (BInvokableType)initFunction.getBType();
        initFnType.addParamType(mapSymbol.type);
        BAttachedFunction attachedFunction = ((BObjectTypeSymbol)classDef.getBType().tsymbol).generatedInitializerFunc;
        attachedFunction.symbol.params.add(paramSym);
        classDef.generatedInitFunction = this.desugar.rewrite(classDef.generatedInitFunction, oceData.objMethodsEnv);
        this.addMapToCalleeExpression(mapSymbol, oceData);
    }

    private void addMapToCalleeExpression(BVarSymbol mapSymbol, OCEDynamicEnvironmentData oceData) {
        BLangSimpleVarRef.BLangLocalVarRef blockLevelMapLocalVarRef = new BLangSimpleVarRef.BLangLocalVarRef(mapSymbol);
        oceData.attachedFunctionInvocation.requiredArgs.add(blockLevelMapLocalVarRef);
    }

    private void addMapSymbolAsAField(BLangClassDefinition classDef, BVarSymbol mapSymbol) {
        BLangSimpleVariable mapVar = ASTBuilderUtil.createVariable(this.symTable.builtinPos, mapSymbol.name.value, mapSymbol.type, null, mapSymbol);
        BObjectType object = (BObjectType)classDef.getBType();
        object.fields.put(mapSymbol.name.value, new BField(mapSymbol.name, classDef.pos, mapSymbol));
        classDef.fields.add(0, mapVar);
    }

    private BVarSymbol addFunctionMapMapToClassDefinition(BLangClassDefinition classDef, BVarSymbol functionMapSymbol) {
        BVarSymbol classFunctionMapSymbol;
        if (classDef.oceEnvData.classEnclosedFunctionMap != null) {
            return classDef.oceEnvData.classEnclosedFunctionMap;
        }
        BVarSymbol functionMap = functionMapSymbol;
        classDef.oceEnvData.classEnclosedFunctionMap = classFunctionMapSymbol = this.createFunctionMapSymbolIfAbsent(classDef, functionMapSymbol.name.value);
        this.addMapSymbolAsAField(classDef, classFunctionMapSymbol);
        this.createClosureMapUpdateExpression(classDef, functionMap, classFunctionMapSymbol);
        this.addClosureMapToInit(classDef, functionMap);
        classDef.oceEnvData.functionMapUpdatedInInitMethod = true;
        return classDef.oceEnvData.classEnclosedFunctionMap;
    }

    private BLangNode getNextPossibleNode(SymbolEnv envArg) {
        NodeKind kind;
        SymbolEnv localEnv = envArg;
        BLangNode node = localEnv.node;
        while ((kind = node.getKind()) != NodeKind.PACKAGE && kind != NodeKind.CLASS_DEFN && kind != NodeKind.BLOCK_FUNCTION_BODY && kind != NodeKind.BLOCK && kind != NodeKind.FUNCTION && kind != NodeKind.RESOURCE_FUNC) {
            localEnv = localEnv.enclEnv;
            node = localEnv.node;
        }
        return node;
    }

    private void updateClassClosureMap(BLangClassDefinition classDef) {
        if (!classDef.hasClosureVars) {
            return;
        }
        OCEDynamicEnvironmentData oceData = classDef.oceEnvData;
        SymbolEnv env = oceData.capturedClosureEnv;
        if (env.enclEnv.node == null) {
            return;
        }
        if (!oceData.closureBlockSymbols.isEmpty()) {
            BLangNode node = this.getNextPossibleNode(env.enclEnv);
            if (node.getKind() == NodeKind.FUNCTION) {
                BLangFunction function = (BLangFunction)node;
                node = function.body;
            }
            BVarSymbol blockMap = this.createMapSymbolIfAbsent(node, oceData.closureBlockSymbols.size());
            this.addClosureMapToInit(classDef, blockMap);
        }
        if (!oceData.closureFuncSymbols.isEmpty()) {
            BLangFunction function = (BLangFunction)oceData.capturedClosureEnv.enclInvokable;
            BVarSymbol functionMap = this.createMapSymbolIfAbsent(function, oceData.closureFuncSymbols.size());
            this.addClosureMapToInit(classDef, functionMap);
        }
        if (oceData.mapBlockMapSymbol == null && oceData.mapFunctionMapSymbol == null) {
            return;
        }
        BVarSymbol selfSymbol = classDef.generatedInitFunction.receiver.symbol;
        BLangBlockFunctionBody initBody = (BLangBlockFunctionBody)classDef.generatedInitFunction.body;
        int i = initBody.stmts.size() - 1;
        for (BLangSimpleVariable field : classDef.fields) {
            if (!field.symbol.isDefaultable || field.expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) continue;
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)field.expr;
            if (!varRef.symbol.closure) continue;
            BVarSymbol mapSymbol = oceData.mapBlockMapSymbol;
            BSymbol fieldExprSymbol = ((BLangSimpleVarRef)field.expr).symbol;
            if (oceData.closureFuncSymbols.contains(fieldExprSymbol)) {
                mapSymbol = oceData.mapFunctionMapSymbol;
            }
            BLangLiteral mapIndex = ASTBuilderUtil.createLiteral(field.pos, this.symTable.stringType, field.name);
            BLangSimpleVarRef.BLangLocalVarRef localSelfVarRefForMap = new BLangSimpleVarRef.BLangLocalVarRef(selfSymbol);
            localSelfVarRefForMap.setBType(classDef.getBType());
            BLangIndexBasedAccess.BLangStructFieldAccessExpr mapAccessExpr = new BLangIndexBasedAccess.BLangStructFieldAccessExpr(field.pos, localSelfVarRefForMap, mapIndex, field.symbol, true);
            mapAccessExpr.isStoreOnCreation = true;
            mapAccessExpr.setBType(field.getBType());
            BLangSimpleVarRef.BLangLocalVarRef localSelfVarRef = new BLangSimpleVarRef.BLangLocalVarRef(selfSymbol);
            localSelfVarRef.setBType(classDef.getBType());
            localSelfVarRef.closureDesugared = true;
            BLangIndexBasedAccess.BLangStructFieldAccessExpr accessExprForClassField = new BLangIndexBasedAccess.BLangStructFieldAccessExpr(field.pos, localSelfVarRef, ASTBuilderUtil.createLiteral(field.pos, this.symTable.stringType, mapSymbol.name), mapSymbol, false, true);
            accessExprForClassField.setBType(mapSymbol.type);
            BLangIndexBasedAccess.BLangMapAccessExpr closureMapAccessForField = new BLangIndexBasedAccess.BLangMapAccessExpr(field.pos, accessExprForClassField, ASTBuilderUtil.createLiteral(field.pos, this.symTable.stringType, varRef.symbol.name));
            closureMapAccessForField.setBType(field.getBType());
            BLangTypeConversionExpr castExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
            castExpr.expr = closureMapAccessForField;
            castExpr.setBType(field.getBType());
            castExpr.targetType = field.getBType();
            BLangAssignment assignFromPassedMapToInternalMap = ASTBuilderUtil.createAssignmentStmt(field.pos, mapAccessExpr, castExpr);
            assignFromPassedMapToInternalMap.parent = classDef.generatedInitFunction.body;
            initBody.stmts.add(i, assignFromPassedMapToInternalMap);
            ++i;
        }
        BLangFunction initFunction = classDef.generatedInitFunction;
        this.desugar.visit((BLangBlockFunctionBody)initFunction.body);
    }

    @Override
    public void visit(BLangResourceFunction resourceFunction) {
        this.visit((BLangFunction)resourceFunction);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        BLangSimpleVariable receiver;
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.originalFuncSymbol.scope, this.env);
        ++this.funClosureMapCount;
        Optional<BVarSymbol> paramsExposed = funcNode.symbol.params.stream().filter(bVarSymbol -> bVarSymbol.closure).findAny();
        int position = 1;
        if (paramsExposed.isPresent()) {
            this.createFunctionMap(funcNode, funcEnv);
            for (BVarSymbol paramSymbol : funcNode.symbol.params) {
                if (!paramSymbol.closure) continue;
                this.addToFunctionMap(funcNode, funcEnv, position, paramSymbol, paramSymbol.type);
                ++position;
            }
        }
        if (funcNode.symbol.restParam != null && funcNode.symbol.restParam.closure) {
            this.createFunctionMap(funcNode, funcEnv);
            this.addToFunctionMap(funcNode, funcEnv, position, funcNode.symbol.restParam, funcNode.symbol.restParam.type);
            ++position;
        }
        if ((receiver = funcNode.receiver) != null && receiver.symbol.closure && funcNode.flagSet.contains((Object)Flag.ATTACHED)) {
            this.createFunctionMap(funcNode, funcEnv);
            this.addToFunctionMap(funcNode, funcEnv, position, receiver.symbol, receiver.getBType());
        }
        this.rewriteParamsAndReturnTypeOfFunction(funcNode, funcEnv);
        funcNode.body = this.rewrite(funcNode.body, funcEnv);
        this.result = funcNode;
    }

    public void rewriteParamsAndReturnTypeOfFunction(BLangFunction funcNode, SymbolEnv funcEnv) {
        for (BLangSimpleVariable bLangSimpleVariable : funcNode.requiredParams) {
            bLangSimpleVariable.typeNode = this.rewrite(bLangSimpleVariable.typeNode, funcEnv);
        }
        if (funcNode.restParam != null) {
            funcNode.restParam = this.rewrite(funcNode.restParam, funcEnv);
        }
        if (funcNode.returnTypeNode != null) {
            funcNode.returnTypeNode = this.rewrite(funcNode.returnTypeNode, funcEnv);
        }
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        SymbolEnv blockEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        ++this.blockClosureMapCount;
        this.rewriteStmts(body.stmts, blockEnv);
        if (body.mapSymbol != null) {
            body.stmts.add(0, this.getClosureMap(body.mapSymbol, blockEnv));
        }
        this.result = body;
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
        this.result = body;
    }

    private void createFunctionMap(BLangFunction funcNode, SymbolEnv funcEnv) {
        if (funcNode.mapSymbol == null) {
            funcNode.mapSymbol = this.createMapSymbol(FUNCTION_MAP_SYM_NAME + this.funClosureMapCount, funcEnv);
        }
        if (funcNode.mapSymbolUpdated) {
            return;
        }
        BLangRecordLiteral emptyRecord = ASTBuilderUtil.createEmptyRecordLiteral(funcNode.pos, this.symTable.mapAllType);
        BLangSimpleVariable mapVar = ASTBuilderUtil.createVariable(funcNode.pos, funcNode.mapSymbol.name.value, funcNode.mapSymbol.type, emptyRecord, funcNode.mapSymbol);
        mapVar.typeNode = ASTBuilderUtil.createTypeNode(funcNode.mapSymbol.type);
        BLangSimpleVariableDef mapVarDef = ASTBuilderUtil.createVariableDef(funcNode.pos, mapVar);
        mapVarDef = this.desugar.rewrite(mapVarDef, funcEnv);
        if (funcNode.body == null) {
            funcNode.body = ASTBuilderUtil.createBlockFunctionBody(funcNode.pos);
        }
        if (funcNode.body.getKind() == NodeKind.BLOCK_FUNCTION_BODY) {
            ((BLangBlockFunctionBody)funcNode.body).stmts.add(0, mapVarDef);
        }
        funcNode.mapSymbolUpdated = true;
    }

    private static void updateFunctionParams(Env typeEnv, BLangFunction funcNode) {
        BInvokableSymbol dupFuncSymbol;
        funcNode.symbol = dupFuncSymbol = ASTBuilderUtil.duplicateInvokableSymbol(typeEnv, funcNode.symbol);
        BInvokableType dupFuncType = (BInvokableType)dupFuncSymbol.type;
        int i = 0;
        ArrayList<BType> newParamTypes = new ArrayList<BType>(dupFuncType.paramTypes);
        for (Map.Entry<Integer, BVarSymbol> entry : funcNode.paramClosureMap.entrySet()) {
            BVarSymbol mapSymbol = entry.getValue();
            dupFuncSymbol.params.add(i, mapSymbol);
            newParamTypes.add(i, mapSymbol.type);
            ++i;
        }
        dupFuncType.setParamTypes(newParamTypes);
    }

    private void addToFunctionMap(BLangFunction funcNode, SymbolEnv symbolEnv, int position, BVarSymbol paramSymbol, BType type) {
        BLangSimpleVarRef.BLangLocalVarRef localVarRef = new BLangSimpleVarRef.BLangLocalVarRef(paramSymbol);
        localVarRef.closureDesugared = true;
        localVarRef.setBType(type);
        BLangIndexBasedAccess accessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(funcNode.pos, type, funcNode.mapSymbol, ASTBuilderUtil.createLiteral(funcNode.pos, this.symTable.stringType, paramSymbol.name.value));
        accessExpr.setBType(((BMapType)funcNode.mapSymbol.type).constraint);
        accessExpr.isLValue = true;
        BLangAssignment stmt = this.desugar.rewrite(ASTBuilderUtil.createAssignmentStmt(funcNode.pos, accessExpr, localVarRef), symbolEnv);
        if (funcNode.body.getKind() == NodeKind.BLOCK_FUNCTION_BODY) {
            ((BLangBlockFunctionBody)funcNode.body).stmts.add(position, stmt);
        }
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(blockNode, this.env);
        ++this.blockClosureMapCount;
        this.rewriteStmts(blockNode.stmts, blockEnv);
        if (blockNode.mapSymbol != null) {
            blockNode.stmts.add(0, this.getClosureMap(blockNode.mapSymbol, blockEnv));
        }
        this.result = blockNode;
    }

    private BLangSimpleVariableDef getClosureMap(BVarSymbol mapSymbol, SymbolEnv blockEnv) {
        BLangRecordLiteral emptyRecord = ASTBuilderUtil.createEmptyRecordLiteral(this.symTable.builtinPos, mapSymbol.type);
        BLangSimpleVariable mapVar = ASTBuilderUtil.createVariable(this.symTable.builtinPos, mapSymbol.name.value, mapSymbol.type, emptyRecord, mapSymbol);
        mapVar.typeNode = ASTBuilderUtil.createTypeNode(mapSymbol.type);
        BLangSimpleVariableDef mapVarDef = ASTBuilderUtil.createVariableDef(this.symTable.builtinPos, mapVar);
        return this.desugar.rewrite(mapVarDef, blockEnv);
    }

    @Override
    public void visit(BLangService serviceNode) {
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        if (!varDefNode.var.symbol.closure) {
            varDefNode.var = this.rewrite(varDefNode.var, this.env);
            this.result = varDefNode;
            return;
        }
        varDefNode.var.typeNode = this.rewrite(varDefNode.var.typeNode, this.env);
        if (varDefNode.var.expr != null) {
            BLangAssignment stmt = this.createAssignmentToClosureMap(varDefNode);
            this.result = this.rewrite(stmt, this.env);
        } else {
            this.createMapSymbolIfAbsent(this.env.node, this.blockClosureMapCount);
            this.result = varDefNode;
        }
    }

    private BLangAssignment createAssignmentToClosureMap(BLangSimpleVariableDef varDefNode) {
        int absoluteLevel = ClosureDesugar.findResolvedLevel(this.env, varDefNode.var.symbol);
        BVarSymbol mapSymbol = this.findClosureMapSymbol(absoluteLevel);
        BLangIndexBasedAccess accessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(varDefNode.pos, varDefNode.getBType(), mapSymbol, ASTBuilderUtil.createLiteral(varDefNode.pos, this.symTable.stringType, varDefNode.var.name.value));
        accessExpr.setBType(((BMapType)mapSymbol.type).constraint);
        accessExpr.isLValue = true;
        return ASTBuilderUtil.createAssignmentStmt(varDefNode.pos, accessExpr, varDefNode.var.expr);
    }

    private BVarSymbol findClosureMapSymbol(int absoluteLevel) {
        SymbolEnv symbolEnv = this.env;
        while (symbolEnv.node.getKind() != NodeKind.PACKAGE) {
            if (symbolEnv.envCount == absoluteLevel) {
                return this.createMapSymbolIfAbsent(symbolEnv.node, symbolEnv.envCount);
            }
            symbolEnv = symbolEnv.enclEnv;
        }
        throw new IllegalStateException("Failed to find the closure symbol defined scope");
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangNode node, int closureMapCount) {
        NodeKind kind = node.getKind();
        return switch (kind) {
            case NodeKind.BLOCK_FUNCTION_BODY -> this.createMapSymbolIfAbsent((BLangBlockFunctionBody)node, closureMapCount);
            case NodeKind.BLOCK -> this.createMapSymbolIfAbsent((BLangBlockStmt)node, closureMapCount);
            case NodeKind.FUNCTION -> this.createMapSymbolIfAbsent((BLangFunction)node, closureMapCount);
            case NodeKind.RESOURCE_FUNC -> this.createMapSymbolIfAbsent((BLangResourceFunction)node, closureMapCount);
            case NodeKind.CLASS_DEFN -> this.createMapSymbolIfAbsent((BLangClassDefinition)node, closureMapCount);
            default -> null;
        };
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangBlockFunctionBody body, int closureMapCount) {
        if (body.mapSymbol == null) {
            body.mapSymbol = this.createMapSymbol(BLOCK_MAP_SYM_NAME + closureMapCount, this.env);
        }
        return body.mapSymbol;
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangBlockStmt blockStmt, int closureMapCount) {
        if (blockStmt.mapSymbol == null) {
            blockStmt.mapSymbol = this.createMapSymbol(BLOCK_MAP_SYM_NAME + closureMapCount, this.env);
        }
        return blockStmt.mapSymbol;
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangFunction function, int closureMapCount) {
        if (function.mapSymbol == null) {
            function.mapSymbol = this.createMapSymbol(FUNCTION_MAP_SYM_NAME + closureMapCount, this.env);
        }
        return function.mapSymbol;
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangClassDefinition classDef, int closureMapCount) {
        if (classDef.oceEnvData.mapBlockMapSymbol == null) {
            classDef.oceEnvData.mapBlockMapSymbol = this.createMapSymbol(OBJECT_CTOR_MAP_SYM_NAME + closureMapCount, classDef.oceEnvData.capturedClosureEnv);
        }
        return classDef.oceEnvData.mapBlockMapSymbol;
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangClassDefinition classDef, String mapName, boolean blockMap) {
        BVarSymbol mapSymbol;
        if (blockMap) {
            if (classDef.oceEnvData.mapBlockMapSymbol == null) {
                classDef.oceEnvData.mapBlockMapSymbol = this.createMapSymbol(mapName, classDef.oceEnvData.capturedClosureEnv);
            }
            mapSymbol = classDef.oceEnvData.mapBlockMapSymbol;
        } else {
            if (classDef.oceEnvData.mapFunctionMapSymbol == null) {
                classDef.oceEnvData.mapFunctionMapSymbol = this.createMapSymbol(mapName, classDef.oceEnvData.capturedClosureEnv);
            }
            mapSymbol = classDef.oceEnvData.mapFunctionMapSymbol;
        }
        return mapSymbol;
    }

    private BVarSymbol createFunctionMapSymbolIfAbsent(BLangClassDefinition classDef, String mapName) {
        if (classDef.oceEnvData.classEnclosedFunctionMap == null) {
            classDef.oceEnvData.classEnclosedFunctionMap = this.createMapSymbol(mapName, classDef.oceEnvData.capturedClosureEnv);
        }
        return classDef.oceEnvData.classEnclosedFunctionMap;
    }

    private static BVarSymbol getMapSymbol(BLangNode node) {
        switch (node.getKind()) {
            case BLOCK_FUNCTION_BODY: {
                return ((BLangBlockFunctionBody)node).mapSymbol;
            }
            case BLOCK: {
                return ((BLangBlockStmt)node).mapSymbol;
            }
            case FUNCTION: 
            case RESOURCE_FUNC: {
                return ((BLangFunction)node).mapSymbol;
            }
            case CLASS_DEFN: {
                BLangClassDefinition classNode = (BLangClassDefinition)node;
                if (!classNode.isObjectContructorDecl) {
                    return CLOSURE_MAP_NOT_FOUND;
                }
                return classNode.oceEnvData.mapBlockMapSymbol;
            }
        }
        return CLOSURE_MAP_NOT_FOUND;
    }

    @Override
    public void visit(BLangReturn returnNode) {
        if (returnNode.expr != null) {
            returnNode.expr = this.rewriteExpr(returnNode.expr);
        }
        this.result = returnNode;
    }

    @Override
    public void visit(BLangInvocation.BLangAttachedFunctionInvocation invocation) {
        this.rewriteInvocationExpr(invocation);
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        this.result = importPkgNode;
    }

    @Override
    public void visit(BLangTypeDefinition typeDef) {
        typeDef.typeNode = this.rewrite(typeDef.typeNode, this.env);
        this.result = typeDef;
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
        ArrayList<BLangType> rewrittenConstituents = new ArrayList<BLangType>();
        for (BLangType constituentTypeNode : intersectionTypeNode.constituentTypeNodes) {
            rewrittenConstituents.add(this.rewrite(constituentTypeNode, this.env));
        }
        intersectionTypeNode.constituentTypeNodes = rewrittenConstituents;
        this.result = intersectionTypeNode;
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        if (!classDefinition.isObjectContructorDecl) {
            this.result = classDefinition;
            return;
        }
        OCEDynamicEnvironmentData oceData = classDefinition.oceEnvData;
        BVarSymbol mapSymbol = oceData.mapBlockMapSymbol;
        if (mapSymbol == null) {
            this.result = classDefinition;
            return;
        }
        this.desugar.visit(classDefinition);
        this.result = classDefinition;
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        for (BLangSimpleVariable field : objectTypeNode.fields) {
            this.rewrite(field, this.env);
        }
        this.result = objectTypeNode;
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        for (BLangSimpleVariable field : recordTypeNode.fields) {
            field.typeNode = this.rewrite(field.typeNode, this.env);
        }
        recordTypeNode.restFieldType = this.rewrite(recordTypeNode.restFieldType, this.env);
        this.result = recordTypeNode;
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        ArrayList<BLangSimpleVariable> rewrittenMembers = new ArrayList<BLangSimpleVariable>();
        tupleTypeNode.members.forEach(member -> rewrittenMembers.add(this.rewrite(member, this.env)));
        tupleTypeNode.members = rewrittenMembers;
        tupleTypeNode.restParamType = this.rewrite(tupleTypeNode.restParamType, this.env);
        this.result = tupleTypeNode;
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        this.result = finiteTypeNode;
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        arrayType.elemtype = this.rewrite(arrayType.elemtype, this.env);
        this.result = arrayType;
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
        this.result = userDefinedType;
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        ArrayList<BLangType> rewrittenMembers = new ArrayList<BLangType>();
        unionTypeNode.memberTypeNodes.forEach(typeNode -> rewrittenMembers.add(this.rewrite(typeNode, this.env)));
        unionTypeNode.memberTypeNodes = rewrittenMembers;
        this.result = unionTypeNode;
    }

    @Override
    public void visit(BLangValueType valueType) {
        this.result = valueType;
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefTypeNode) {
        this.result = builtInRefTypeNode;
    }

    @Override
    public void visit(BLangStreamType streamType) {
        streamType.constraint = this.rewrite(streamType.constraint, this.env);
        streamType.error = this.rewrite(streamType.error, this.env);
        this.result = streamType;
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        constrainedType.constraint = this.rewrite(constrainedType.constraint, this.env);
        this.result = constrainedType;
    }

    @Override
    public void visit(BLangErrorType errorType) {
        errorType.detailType = this.rewrite(errorType.detailType, this.env);
        this.result = errorType;
    }

    @Override
    public void visit(BLangTableTypeNode tableTypeNode) {
        tableTypeNode.constraint = this.rewrite(tableTypeNode.constraint, this.env);
        tableTypeNode.tableKeyTypeConstraint = this.rewrite(tableTypeNode.tableKeyTypeConstraint, this.env);
        this.result = tableTypeNode;
    }

    @Override
    public void visit(BLangTableKeyTypeConstraint keyTypeConstraint) {
        keyTypeConstraint.keyType = this.rewrite(keyTypeConstraint.keyType, this.env);
        this.result = keyTypeConstraint;
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(functionTypeNode, functionTypeNode.getBType().tsymbol.scope, this.env);
        for (BLangVariable bLangVariable : functionTypeNode.params) {
            bLangVariable.typeNode = this.rewrite(bLangVariable.typeNode, typeDefEnv);
        }
        if (functionTypeNode.restParam != null) {
            functionTypeNode.restParam.typeNode = this.rewrite(functionTypeNode.restParam.typeNode, this.env);
        }
        if (functionTypeNode.returnTypeNode != null) {
            functionTypeNode.returnTypeNode = this.rewrite(functionTypeNode.returnTypeNode, this.env);
        }
        this.result = functionTypeNode;
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        varNode.typeNode = this.rewrite(varNode.typeNode, this.env);
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangTupleVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangRecordVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangErrorVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangTupleVariableDef varDefNode) {
        varDefNode.var = this.rewrite(varDefNode.var, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangRecordVariableDef varDefNode) {
        varDefNode.var = this.rewrite(varDefNode.var, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangErrorVariableDef varDefNode) {
        varDefNode.errorVariable = this.rewrite(varDefNode.errorVariable, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        assignNode.varRef = this.rewriteExpr(assignNode.varRef);
        if (assignNode.expr.impConversionExpr != null) {
            this.types.setImplicitCastExpr(assignNode.expr.impConversionExpr, assignNode.expr.impConversionExpr.getBType(), assignNode.varRef.getBType());
        } else {
            this.types.setImplicitCastExpr(assignNode.expr, assignNode.expr.getBType(), assignNode.varRef.getBType());
        }
        assignNode.expr = this.rewriteExpr(assignNode.expr);
        this.result = assignNode;
    }

    @Override
    public void visit(BLangTupleDestructure tupleDestructure) {
        this.result = tupleDestructure;
    }

    @Override
    public void visit(BLangRecordDestructure recordDestructure) {
        this.result = recordDestructure;
    }

    @Override
    public void visit(BLangErrorDestructure errorDestructure) {
        this.result = errorDestructure;
    }

    @Override
    public void visit(BLangRetry retryNode) {
        retryNode.retryBody = this.rewrite(retryNode.retryBody, this.env);
        this.result = retryNode;
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        retryTransaction.transaction = this.rewrite(retryTransaction.transaction, this.env);
        this.result = retryTransaction;
    }

    @Override
    public void visit(BLangContinue nextNode) {
        this.result = nextNode;
    }

    @Override
    public void visit(BLangBreak breakNode) {
        this.result = breakNode;
    }

    @Override
    public void visit(BLangPanic panicNode) {
        panicNode.expr = this.rewriteExpr(panicNode.expr);
        this.result = panicNode;
    }

    @Override
    public void visit(BLangDo doNode) {
        doNode.body = this.rewrite(doNode.body, this.env);
        this.result = doNode;
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        xmlnsStmtNode.xmlnsDecl = this.rewrite(xmlnsStmtNode.xmlnsDecl, this.env);
        this.result = xmlnsStmtNode;
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        exprStmtNode.expr = this.rewriteExpr(exprStmtNode.expr);
        this.result = exprStmtNode;
    }

    @Override
    public void visit(BLangFail failNode) {
        if (failNode.exprStmt != null) {
            failNode.exprStmt = this.rewrite(failNode.exprStmt, this.env);
        }
        this.result = failNode;
    }

    @Override
    public void visit(BLangIf ifNode) {
        ifNode.expr = this.rewriteExpr(ifNode.expr);
        ifNode.body = this.rewrite(ifNode.body, this.env);
        ifNode.elseStmt = this.rewrite(ifNode.elseStmt, this.env);
        this.result = ifNode;
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.result = foreach;
    }

    @Override
    public void visit(BLangWhile whileNode) {
        whileNode.expr = this.rewriteExpr(whileNode.expr);
        whileNode.body = this.rewrite(whileNode.body, this.env);
        this.result = whileNode;
    }

    @Override
    public void visit(BLangLock lockNode) {
        lockNode.body = this.rewrite(lockNode.body, this.env);
        this.result = lockNode;
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockNode) {
        this.result = lockNode;
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockNode) {
        this.result = unLockNode;
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        transactionNode.transactionBody = this.rewrite(transactionNode.transactionBody, this.env);
        this.result = transactionNode;
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        rollbackNode.expr = this.rewriteExpr(rollbackNode.expr);
        this.result = rollbackNode;
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
        this.result = transactionalExpr;
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
        this.result = commitExpr;
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        this.result = forkJoin;
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        this.result = literalExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangListConstructorSpreadOpExpr listConstructorSpreadOpExpr) {
        listConstructorSpreadOpExpr.expr = this.rewriteExpr(listConstructorSpreadOpExpr.expr);
        this.result = listConstructorSpreadOpExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        this.rewriteExprs(listConstructorExpr.exprs);
        this.result = listConstructorExpr;
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        this.rewriteExprs(tableConstructorExpr.recordLiteralList);
        this.result = tableConstructorExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteral) {
        this.rewriteExprs(jsonArrayLiteral.exprs);
        this.result = jsonArrayLiteral;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
        this.rewriteExprs(tupleLiteral.exprs);
        this.result = tupleLiteral;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral arrayLiteral) {
        this.rewriteExprs(arrayLiteral.exprs);
        this.result = arrayLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        recordLiteral.fields.forEach(field -> {
            BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
            keyValue.key.expr = this.rewriteExpr(keyValue.key.expr);
            keyValue.valueExpr = this.rewriteExpr(keyValue.valueExpr);
        });
        this.result = recordLiteral;
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        fieldAccessExpr.expr = this.rewriteExpr(fieldAccessExpr.expr);
        this.result = fieldAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.result = this.desugar.rewriteExpr(indexAccessExpr);
    }

    public BPackageSymbol getPackageSymbol(BSymbol symbol) {
        BSymbol owner = symbol.owner;
        if (owner.getKind() == SymbolKind.PACKAGE) {
            return (BPackageSymbol)owner;
        }
        return this.getPackageSymbol(owner);
    }

    @Override
    public void visit(BLangInvocation invocation) {
        this.rewriteInvocationExpr(invocation);
    }

    public void rewriteInvocationExpr(BLangInvocation invocation) {
        this.rewriteExprs(invocation.requiredArgs);
        this.rewriteExprs(invocation.restArgs);
        this.result = invocation;
    }

    public BLangSimpleVariableDef createVarDef(String name, BType type, BLangExpression expr, Location location) {
        BVarSymbol symbol = new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, type, ((BLangFunction)this.env.enclInvokable).originalFuncSymbol, location, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable simpleVariable = ASTBuilderUtil.createVariable(location, name, type, expr, symbol);
        BLangSimpleVariableDef simpleVariableDef = ASTBuilderUtil.createVariableDef(location);
        simpleVariableDef.var = simpleVariable;
        simpleVariableDef.setBType(simpleVariable.getBType());
        return simpleVariableDef;
    }

    @Override
    public void visit(BLangErrorConstructorExpr errorConstructorExpr) {
        this.rewriteExprs(errorConstructorExpr.positionalArgs);
        errorConstructorExpr.errorDetail = this.rewriteExpr(errorConstructorExpr.errorDetail);
        this.result = errorConstructorExpr;
    }

    @Override
    public void visit(BLangTypeInit typeInitExpr) {
        typeInitExpr.initInvocation = this.rewriteExpr(typeInitExpr.initInvocation);
        this.result = typeInitExpr;
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        ternaryExpr.expr = this.rewriteExpr(ternaryExpr.expr);
        ternaryExpr.thenExpr = this.rewriteExpr(ternaryExpr.thenExpr);
        ternaryExpr.elseExpr = this.rewriteExpr(ternaryExpr.elseExpr);
        this.result = ternaryExpr;
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        ArrayList<BLangExpression> exprList = new ArrayList<BLangExpression>();
        waitExpr.exprList.forEach(expression -> exprList.add(this.rewriteExpr(expression)));
        waitExpr.exprList = exprList;
        this.result = waitExpr;
    }

    @Override
    public void visit(BLangWaitForAllExpr waitExpr) {
        this.result = waitExpr;
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        trapExpr.expr = this.rewriteExpr(trapExpr.expr);
        this.result = trapExpr;
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        binaryExpr.lhsExpr.parent = binaryExpr;
        binaryExpr.lhsExpr = this.rewriteExpr(binaryExpr.lhsExpr);
        binaryExpr.rhsExpr.parent = binaryExpr;
        binaryExpr.rhsExpr = this.rewriteExpr(binaryExpr.rhsExpr);
        this.result = binaryExpr;
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.result = elvisExpr;
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        groupExpr.expression = this.rewriteExpr(groupExpr.expression);
        this.result = groupExpr;
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        unaryExpr.expr = this.rewriteExpr(unaryExpr.expr);
        this.result = unaryExpr;
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        if (conversionExpr.expr.impConversionExpr != null) {
            this.result = conversionExpr;
            return;
        }
        conversionExpr.expr = this.rewriteExpr(conversionExpr.expr);
        conversionExpr.typeNode = this.rewrite(conversionExpr.typeNode, this.env);
        this.result = conversionExpr;
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        bLangLambdaFunction.capturedClosureEnv = this.env;
        bLangLambdaFunction.function = this.rewrite(bLangLambdaFunction.function, this.env);
        if (this.env.enclInvokable != null) {
            BLangFunction enclInvokable = (BLangFunction)this.env.enclInvokable;
            bLangLambdaFunction.paramMapSymbolsOfEnclInvokable = enclInvokable.paramClosureMap;
            boolean isWorker = bLangLambdaFunction.function.flagSet.contains((Object)Flag.WORKER);
            bLangLambdaFunction.enclMapSymbols = this.collectClosureMapSymbols(this.env, enclInvokable, isWorker);
        }
        bLangLambdaFunction.capturedClosureEnv = null;
        this.result = bLangLambdaFunction;
    }

    private TreeMap<Integer, BVarSymbol> collectClosureMapSymbols(SymbolEnv symbolEnv, BLangInvokableNode enclInvokable, boolean isWorker) {
        TreeMap<Integer, BVarSymbol> enclMapSymbols = new TreeMap<Integer, BVarSymbol>();
        while (symbolEnv != null && symbolEnv.enclInvokable == enclInvokable) {
            BVarSymbol mapSym = ClosureDesugar.getMapSymbol(symbolEnv.node);
            if (mapSym == CLOSURE_MAP_NOT_FOUND) {
                symbolEnv = symbolEnv.enclEnv;
                continue;
            }
            if (mapSym != null) {
                enclMapSymbols.putIfAbsent(symbolEnv.envCount, mapSym);
            } else if (isWorker) {
                BVarSymbol mapSymbolIfAbsent = this.createMapSymbolIfAbsent(this.env.node, this.blockClosureMapCount);
                enclMapSymbols.putIfAbsent(symbolEnv.envCount, mapSymbolIfAbsent);
            }
            symbolEnv = symbolEnv.enclEnv;
        }
        return enclMapSymbols;
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        this.result = bLangArrowFunction;
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        this.result = xmlQName;
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        xmlAttribute.name = this.rewriteExpr(xmlAttribute.name);
        xmlAttribute.value = this.rewriteExpr(xmlAttribute.value);
        this.result = xmlAttribute;
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        xmlElementLiteral.startTagName = this.rewriteExpr(xmlElementLiteral.startTagName);
        xmlElementLiteral.endTagName = this.rewriteExpr(xmlElementLiteral.endTagName);
        this.rewriteExprs(xmlElementLiteral.modifiedChildren);
        this.rewriteExprs(xmlElementLiteral.attributes);
        this.result = xmlElementLiteral;
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        xmlTextLiteral.concatExpr = this.rewriteExpr(xmlTextLiteral.concatExpr);
        this.result = xmlTextLiteral;
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        xmlCommentLiteral.concatExpr = this.rewriteExpr(xmlCommentLiteral.concatExpr);
        this.result = xmlCommentLiteral;
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        xmlProcInsLiteral.target = this.rewriteExpr(xmlProcInsLiteral.target);
        xmlProcInsLiteral.dataFragments.forEach(this::rewriteExpr);
        this.result = xmlProcInsLiteral;
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        xmlQuotedString.concatExpr = this.rewriteExpr(xmlQuotedString.concatExpr);
        this.result = xmlQuotedString;
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        stringTemplateLiteral.exprs.forEach(this::rewriteExpr);
        this.result = stringTemplateLiteral;
    }

    @Override
    public void visit(BLangWorkerAsyncSendExpr asyncSendExpr) {
        asyncSendExpr.expr = this.rewriteExpr(asyncSendExpr.expr);
        this.result = asyncSendExpr;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        syncSendExpr.expr = this.rewriteExpr(syncSendExpr.expr);
        this.result = syncSendExpr;
    }

    @Override
    public void visit(BLangAlternateWorkerReceive altWorkerReceive) {
        this.result = altWorkerReceive;
    }

    @Override
    public void visit(BLangMultipleWorkerReceive multipleWorkerReceive) {
        this.result = multipleWorkerReceive;
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        this.result = workerReceiveNode;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        this.result = workerFlushExpr;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangLocalVarRef localVarRef) {
        BSymbol varRefSym = localVarRef.symbol;
        BLangInvokableNode enclInvokable = this.env.enclInvokable;
        if (!varRefSym.closure || localVarRef.closureDesugared || enclInvokable == null) {
            this.result = localVarRef;
            return;
        }
        int selfRelativeCount = this.env.relativeEnvCount;
        int selfAbsoluteLevel = this.env.envCount;
        int absoluteLevel = ClosureDesugar.findResolvedLevel(this.env, (BVarSymbol)localVarRef.varSymbol);
        if (selfRelativeCount >= selfAbsoluteLevel - absoluteLevel) {
            BVarSymbol mapSym = this.findClosureMapSymbol(absoluteLevel);
            this.updateClosureVars(localVarRef, mapSym);
        } else {
            BLangFunction invokableFunc = (BLangFunction)this.env.enclInvokable;
            if (invokableFunc.flagSet.contains((Object)Flag.OBJECT_CTOR) && invokableFunc.attachedFunction) {
                BLangClassDefinition classDef = (BLangClassDefinition)invokableFunc.parent;
                BLangFunction enclosedFunction = (BLangFunction)classDef.oceEnvData.capturedClosureEnv.enclInvokable;
                BInvokableSymbol enclosedFuncSymbol = enclosedFunction.symbol;
                if (enclosedFuncSymbol.params.contains(localVarRef.symbol)) {
                    BVarSymbol classFunctionMapSymbol = this.addFunctionMapMapToClassDefinition(classDef, enclosedFunction.mapSymbol);
                    this.updateClosureVarsWithMapAccessExpression(classDef, invokableFunc.receiver.symbol, localVarRef, classFunctionMapSymbol);
                } else {
                    this.updateClosureVarsForAttachedObjects(classDef, invokableFunc.receiver.symbol, localVarRef);
                }
            } else {
                invokableFunc.paramClosureMap.putIfAbsent(absoluteLevel, this.createMapSymbol(PARAMETER_MAP_NAME + absoluteLevel, this.env));
                this.updateClosureVars(localVarRef, ((BLangFunction)this.env.enclInvokable).paramClosureMap.get(absoluteLevel));
            }
            this.updatePrecedingFunc(this.env, absoluteLevel);
        }
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
        this.result = ignoreExpr;
    }

    @Override
    public void visit(BLangDynamicArgExpr dynamicParamExpr) {
        dynamicParamExpr.condition = this.rewriteExpr(dynamicParamExpr.condition);
        dynamicParamExpr.conditionalArgument = this.rewriteExpr(dynamicParamExpr.conditionalArgument);
        this.result = dynamicParamExpr;
    }

    @Override
    public void visit(BLangRegExpTemplateLiteral regExpTemplateLiteral) {
        List<BLangExpression> interpolationsList = this.symResolver.getListOfInterpolations(regExpTemplateLiteral.reDisjunction.sequenceList);
        interpolationsList.forEach(this::rewriteExpr);
        this.result = regExpTemplateLiteral;
    }

    private static int findResolvedLevel(SymbolEnv symbolEnv, BVarSymbol varSymbol) {
        SymbolEnv resolvedSymbolEnv = symbolEnv;
        while (resolvedSymbolEnv != null && resolvedSymbolEnv.node.getKind() != NodeKind.PACKAGE) {
            Scope.ScopeEntry entry = resolvedSymbolEnv.scope.lookup(varSymbol.name);
            if (entry != Scope.NOT_FOUND_ENTRY && varSymbol == entry.symbol) {
                return resolvedSymbolEnv.envCount;
            }
            resolvedSymbolEnv = resolvedSymbolEnv.enclEnv;
        }
        return 0;
    }

    private void updatePrecedingFunc(SymbolEnv symbolEnv, int resolvedLevel) {
        while (symbolEnv != null && symbolEnv.node.getKind() != NodeKind.PACKAGE) {
            if (symbolEnv.envCount == resolvedLevel) {
                return;
            }
            if (symbolEnv.node.getKind() != NodeKind.FUNCTION) {
                symbolEnv = symbolEnv.enclEnv;
                continue;
            }
            BLangFunction bLangFunction = (BLangFunction)symbolEnv.node;
            if (symbolEnv.enclInvokable == this.env.enclInvokable) {
                symbolEnv = symbolEnv.enclEnv;
                continue;
            }
            if (bLangFunction.paramClosureMap.containsKey(resolvedLevel)) {
                return;
            }
            bLangFunction.paramClosureMap.put(resolvedLevel, this.createMapSymbol(PARAMETER_MAP_NAME + resolvedLevel, symbolEnv));
            symbolEnv = symbolEnv.enclEnv;
        }
    }

    private BVarSymbol createMapSymbol(String mapName, SymbolEnv symbolEnv) {
        return new BVarSymbol(0L, Names.fromString(mapName), symbolEnv.scope.owner.pkgID, this.symTable.mapAllType, symbolEnv.scope.owner, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
    }

    private void updateClosureVars(BLangSimpleVarRef varRefExpr, BVarSymbol mapSymbol) {
        BLangLiteral indexExpr = ASTBuilderUtil.createLiteral(varRefExpr.pos, this.symTable.stringType, varRefExpr.varSymbol.name.value);
        BLangIndexBasedAccess accessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(varRefExpr.pos, varRefExpr.getBType(), mapSymbol, indexExpr);
        this.result = this.rewriteExpr(accessExpr);
    }

    private void updateClosureVarsWithMapAccessExpression(BLangClassDefinition classDef, BVarSymbol selfSymbol, BLangSimpleVarRef varRefExpr, BVarSymbol mapSymbol) {
        BLangSimpleVarRef.BLangLocalVarRef localSelfVarRef = new BLangSimpleVarRef.BLangLocalVarRef(selfSymbol);
        localSelfVarRef.setBType(classDef.getBType());
        Location pos = varRefExpr.pos;
        BLangIndexBasedAccess.BLangStructFieldAccessExpr accessExprForClassField = new BLangIndexBasedAccess.BLangStructFieldAccessExpr(pos, localSelfVarRef, ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, mapSymbol.name), mapSymbol, false, true);
        accessExprForClassField.setBType(mapSymbol.type);
        accessExprForClassField.isLValue = true;
        BLangIndexBasedAccess.BLangMapAccessExpr closureMapAccessForField = new BLangIndexBasedAccess.BLangMapAccessExpr(pos, accessExprForClassField, ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, varRefExpr.symbol.name));
        closureMapAccessForField.setBType(varRefExpr.symbol.type);
        closureMapAccessForField.isLValue = false;
        BLangTypeConversionExpr castExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
        castExpr.expr = closureMapAccessForField;
        castExpr.setBType(varRefExpr.symbol.type);
        castExpr.targetType = varRefExpr.symbol.type;
        this.result = this.desugar.rewrite(castExpr, classDef.oceEnvData.objMethodsEnv);
    }

    private void updateClosureVarsForAttachedObjects(BLangClassDefinition classDef, BVarSymbol classSelfSymbol, BLangSimpleVarRef varRefExpr) {
        OCEDynamicEnvironmentData oceEnvData = classDef.oceEnvData;
        SymbolEnv enclEnv = oceEnvData.capturedClosureEnv.enclEnv;
        BLangNode nodeKeepingClosureMap = enclEnv.node;
        if (!enclEnv.scope.entries.containsKey(varRefExpr.symbol.name) && nodeKeepingClosureMap.getKind() == NodeKind.FUNCTION) {
            BLangBlockFunctionBody blockFunctionBody = (BLangBlockFunctionBody)((BLangFunction)nodeKeepingClosureMap).body;
            nodeKeepingClosureMap = blockFunctionBody;
        }
        BVarSymbol blockMap = this.createMapSymbolIfAbsent(nodeKeepingClosureMap, this.blockClosureMapCount);
        BVarSymbol classMapSymbol = this.createMapSymbolIfAbsent(classDef, blockMap.name.value, true);
        BVarSymbol parentBlockMap = null;
        if (!oceEnvData.parents.isEmpty()) {
            BLangClassDefinition parentClass = oceEnvData.parents.get(0);
            BVarSymbol symbol = (BVarSymbol)varRefExpr.symbol;
            OCEDynamicEnvironmentData parentData = parentClass.oceEnvData;
            if (parentData.closureBlockSymbols.contains(symbol)) {
                this.updateClassClosureMap(parentClass);
                parentBlockMap = parentData.mapBlockMapSymbol;
            }
            if (nodeKeepingClosureMap.getKind() == NodeKind.BLOCK_FUNCTION_BODY) {
                BLangFunction function = (BLangFunction)nodeKeepingClosureMap.parent;
                BLangBlockFunctionBody body = (BLangBlockFunctionBody)nodeKeepingClosureMap;
                if (function.flagSet.contains((Object)Flag.OBJECT_CTOR) && function.flagSet.contains((Object)Flag.ATTACHED) && parentBlockMap != null) {
                    BVarSymbol selfSymbol = function.receiver.symbol;
                    BLangSimpleVarRef selfVarRef = ASTBuilderUtil.createVariableRef(function.pos, selfSymbol);
                    BLangIdentifier identifierNode = ASTBuilderUtil.createIdentifier(function.pos, parentBlockMap.name.value);
                    BLangFieldBasedAccess fieldAccess = ASTBuilderUtil.createFieldAccessExpr(selfVarRef, identifierNode);
                    fieldAccess.symbol = parentBlockMap;
                    fieldAccess.setBType(classMapSymbol.type);
                    fieldAccess.expectedType = classMapSymbol.type;
                    fieldAccess.isStoreOnCreation = true;
                    fieldAccess.isLValue = false;
                    fieldAccess.fieldKind = FieldKind.SINGLE;
                    fieldAccess.leafNode = true;
                    SymbolEnv env = parentData.capturedClosureEnv;
                    BVarSymbol parentBlockSymbol = new BVarSymbol(0L, Names.fromString("$passThroughMap"), env.scope.owner.pkgID, parentBlockMap.getType(), env.scope.owner, body.pos, SymbolOrigin.VIRTUAL);
                    BLangSimpleVariable blockMapVar = ASTBuilderUtil.createVariable(body.pos, parentBlockMap.name.value, parentBlockMap.getType(), fieldAccess, parentBlockSymbol);
                    body.scope.define(blockMapVar.symbol.name, parentBlockSymbol);
                    BLangSimpleVariableDef returnResultDef = ASTBuilderUtil.createVariableDef(body.pos, blockMapVar);
                    returnResultDef = this.desugar.rewrite(returnResultDef, env);
                    BLangSimpleVarRef blockRef = ASTBuilderUtil.createVariableRef(function.pos, blockMap);
                    BLangSimpleVarRef rempVar = ASTBuilderUtil.createVariableRef(function.pos, parentBlockSymbol);
                    BLangAssignment assignmentStmt = (BLangAssignment)TreeBuilder.createAssignmentNode();
                    assignmentStmt.expr = rempVar;
                    assignmentStmt.pos = function.pos;
                    assignmentStmt.setVariable(blockRef);
                    assignmentStmt = this.desugar.rewrite(assignmentStmt, env);
                    body.stmts.add(0, returnResultDef);
                    body.stmts.add(1, assignmentStmt);
                }
            }
        }
        this.updateClosureVarsWithMapAccessExpression(classDef, classSelfSymbol, varRefExpr, classMapSymbol);
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFieldVarRef fieldVarRef) {
        this.result = fieldVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangPackageVarRef packageVarRef) {
        this.result = packageVarRef;
    }

    @Override
    public void visit(BLangConstRef constRef) {
        this.result = constRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFunctionVarRef functionVarRef) {
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr fieldAccessExpr) {
        fieldAccessExpr.indexExpr = this.rewriteExpr(fieldAccessExpr.indexExpr);
        fieldAccessExpr.expr = this.rewriteExpr(fieldAccessExpr.expr);
        this.result = fieldAccessExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef functionVarRef) {
        functionVarRef.expr = this.rewriteExpr(functionVarRef.expr);
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr mapKeyAccessExpr) {
        mapKeyAccessExpr.indexExpr = this.rewriteExpr(mapKeyAccessExpr.indexExpr);
        mapKeyAccessExpr.expr = this.rewriteExpr(mapKeyAccessExpr.expr);
        this.result = mapKeyAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTableAccessExpr tableKeyAccessExpr) {
        tableKeyAccessExpr.indexExpr = this.rewriteExpr(tableKeyAccessExpr.indexExpr);
        tableKeyAccessExpr.expr = this.rewriteExpr(tableKeyAccessExpr.expr);
        this.result = tableKeyAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr arrayIndexAccessExpr) {
        arrayIndexAccessExpr.indexExpr = this.rewriteExpr(arrayIndexAccessExpr.indexExpr);
        arrayIndexAccessExpr.expr = this.rewriteExpr(arrayIndexAccessExpr.expr);
        this.result = arrayIndexAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTupleAccessExpr arrayIndexAccessExpr) {
        arrayIndexAccessExpr.indexExpr = this.rewriteExpr(arrayIndexAccessExpr.indexExpr);
        arrayIndexAccessExpr.expr = this.rewriteExpr(arrayIndexAccessExpr.expr);
        this.result = arrayIndexAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangXMLAccessExpr xmlIndexAccessExpr) {
        xmlIndexAccessExpr.indexExpr = this.rewriteExpr(xmlIndexAccessExpr.indexExpr);
        xmlIndexAccessExpr.expr = this.rewriteExpr(xmlIndexAccessExpr.expr);
        this.result = xmlIndexAccessExpr;
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        xmlElementAccess.expr = this.rewriteExpr(xmlElementAccess.expr);
        this.result = xmlElementAccess;
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        xmlNavigation.expr = this.rewriteExpr(xmlNavigation.expr);
        this.result = xmlNavigation;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangJSONAccessExpr jsonAccessExpr) {
        jsonAccessExpr.indexExpr = this.rewriteExpr(jsonAccessExpr.indexExpr);
        jsonAccessExpr.expr = this.rewriteExpr(jsonAccessExpr.expr);
        this.result = jsonAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStringAccessExpr stringAccessExpr) {
        stringAccessExpr.indexExpr = this.rewriteExpr(stringAccessExpr.indexExpr);
        stringAccessExpr.expr = this.rewriteExpr(stringAccessExpr.expr);
        this.result = stringAccessExpr;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral mapLiteral) {
        for (RecordLiteralNode.RecordField field : mapLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                keyValueField.key.expr = this.rewriteExpr(keyValueField.key.expr);
                keyValueField.valueExpr = this.rewriteExpr(keyValueField.valueExpr);
                continue;
            }
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            spreadField.expr = this.rewriteExpr(spreadField.expr);
        }
        this.result = mapLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral structLiteral) {
        for (RecordLiteralNode.RecordField field : structLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                keyValueField.key.expr = this.rewriteExpr(keyValueField.key.expr);
                keyValueField.valueExpr = this.rewriteExpr(keyValueField.valueExpr);
                continue;
            }
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            spreadField.expr = this.rewriteExpr(spreadField.expr);
        }
        this.result = structLiteral;
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
        waitLiteral.keyValuePairs.forEach(keyValue -> {
            if (keyValue.valueExpr != null) {
                keyValue.valueExpr = this.rewriteExpr(keyValue.valueExpr);
            } else {
                keyValue.keyExpr = this.rewriteExpr(keyValue.keyExpr);
            }
        });
        this.result = waitLiteral;
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        assignableExpr.lhsExpr = this.rewriteExpr(assignableExpr.lhsExpr);
        this.result = assignableExpr;
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation fpInvocation) {
        fpInvocation.expr = this.rewriteExpr(fpInvocation.expr);
        this.rewriteInvocationExpr(fpInvocation);
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
        this.result = accessExpr;
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.result = this.rewriteExpr(bLangVarArgsExpression.expr);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        bLangNamedArgsExpression.expr = this.rewriteExpr(bLangNamedArgsExpression.expr);
        this.result = bLangNamedArgsExpression.expr;
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.result = checkedExpr;
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        this.result = serviceConstructorExpr;
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        typeTestExpr.expr = this.rewriteExpr(typeTestExpr.expr);
        this.result = typeTestExpr;
    }

    @Override
    public void visit(BLangIsLikeExpr isLikeExpr) {
        isLikeExpr.expr = this.rewriteExpr(isLikeExpr.expr);
        this.result = isLikeExpr;
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        annotAccessExpr.expr = this.rewriteExpr(annotAccessExpr.expr);
        this.result = annotAccessExpr;
    }

    @Override
    public void visit(BLangStatementExpression bLangStatementExpression) {
        BLangStatement exprStmt = bLangStatementExpression.stmt;
        if (exprStmt.getKind() == NodeKind.BLOCK) {
            BLangBlockStmt bLangBlockStmt = (BLangBlockStmt)exprStmt;
            if (bLangBlockStmt.isLetExpr) {
                if (bLangBlockStmt.mapSymbol == null && Types.getImpliedType((BType)bLangStatementExpression.getBType()).tag == 34 && this.env.node.getKind() == NodeKind.BLOCK_FUNCTION_BODY) {
                    bLangBlockStmt.mapSymbol = ((BLangBlockFunctionBody)this.env.node).mapSymbol;
                }
                bLangStatementExpression.stmt = this.rewrite(exprStmt, this.env);
            } else {
                for (int i = 0; i < bLangBlockStmt.stmts.size(); ++i) {
                    BLangStatement stmt = bLangBlockStmt.stmts.remove(i);
                    bLangBlockStmt.stmts.add(i, this.rewrite(stmt, this.env));
                }
            }
        } else {
            bLangStatementExpression.stmt = this.rewrite(exprStmt, this.env);
        }
        bLangStatementExpression.expr = this.rewriteExpr(bLangStatementExpression.expr);
        this.result = bLangStatementExpression;
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation invocation) {
        this.rewriteInvocationExpr(invocation);
    }

    @Override
    public void visit(BLangIdentifier identifierNode) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
    }

    @Override
    public void visit(BLangConstant constant) {
        this.result = constant;
    }

    @Override
    public void visit(BLangNumericLiteral literalExpr) {
        this.result = literalExpr;
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangTypeLoad typeLoad) {
        this.result = typeLoad;
    }

    @Override
    public void visit(BLangXMLNS.BLangLocalXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangXMLNS.BLangPackageXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangXMLSequenceLiteral xmlSequenceLiteral) {
        xmlSequenceLiteral.xmlItems.forEach(this::rewriteExpr);
        this.result = xmlSequenceLiteral;
    }

    @Override
    public void visit(BLangMarkdownDocumentationLine bLangMarkdownDocumentationLine) {
    }

    @Override
    public void visit(BLangMarkdownParameterDocumentation bLangDocumentationParameter) {
    }

    @Override
    public void visit(BLangMarkdownReturnParameterDocumentation bLangMarkdownReturnParameterDocumentation) {
    }

    @Override
    public void visit(BLangMarkdownDocumentation bLangMarkdownDocumentation) {
    }

    private <E extends BLangNode> E rewrite(E node, SymbolEnv env) {
        if (node == null) {
            return null;
        }
        SymbolEnv previousEnv = this.env;
        this.env = env;
        node.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        this.env = previousEnv;
        return (E)resultNode;
    }

    private <E extends BLangExpression> E rewriteExpr(E node, SymbolEnv env) {
        SymbolEnv previousEnv = this.env;
        this.env = env;
        Object expr = node;
        if (node.impConversionExpr != null) {
            expr = node.impConversionExpr;
            node.impConversionExpr = null;
        }
        expr.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        this.env = previousEnv;
        return (E)((BLangExpression)resultNode);
    }

    private <E extends BLangExpression> E rewriteExpr(E node) {
        if (node == null) {
            return null;
        }
        Object expr = node;
        if (node.impConversionExpr != null) {
            expr = node.impConversionExpr;
            node.impConversionExpr = null;
        }
        expr.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        return (E)((BLangExpression)resultNode);
    }

    private <E extends BLangStatement> void rewriteStmts(List<E> nodeList, SymbolEnv env) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewrite((BLangStatement)nodeList.get(i), env));
        }
    }

    private <E extends BLangExpression> void rewriteExprs(List<E> nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewriteExpr((BLangExpression)nodeList.get(i)));
        }
    }
}

