/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.statements.VariableDefinitionNode;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangCollectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupingKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAlternateWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCollectContextInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExtendedXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInferredTypedescDefaultNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMultipleWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNaturalExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAssertion;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomCharOrEscape;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCapturingGroups;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharSet;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharSetRange;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharacterClass;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReDisjunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReFlagExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReFlagsOnOff;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReSequence;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRegExpTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerAsyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLFilterStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLIndexedStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLMethodCallStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangConstPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangFieldMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangListMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMappingMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangVarBindingPatternMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangWildCardMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class ConstantPropagation
extends BLangNodeVisitor {
    private static final CompilerContext.Key<ConstantPropagation> CONSTANT_PROPAGATION_KEY = new CompilerContext.Key();
    private BLangNode result;
    private final Types types;

    public static ConstantPropagation getInstance(CompilerContext context) {
        ConstantPropagation constantPropagation = context.get(CONSTANT_PROPAGATION_KEY);
        if (constantPropagation == null) {
            constantPropagation = new ConstantPropagation(context);
        }
        return constantPropagation;
    }

    private ConstantPropagation(CompilerContext context) {
        context.put(CONSTANT_PROPAGATION_KEY, this);
        this.types = Types.getInstance(context);
    }

    public BLangPackage perform(BLangPackage pkgNode) {
        return this.rewrite(pkgNode);
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.CONSTANT_PROPAGATION)) {
            return;
        }
        for (TopLevelNode topLevelNode : pkgNode.topLevelNodes) {
            this.rewrite((BLangNode)((Object)topLevelNode));
        }
        pkgNode.completedPhases.add(CompilerPhase.CONSTANT_PROPAGATION);
        this.result = pkgNode;
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        if (typeDefinition.typeNode.getKind() == NodeKind.OBJECT_TYPE || typeDefinition.typeNode.getKind() == NodeKind.RECORD_TYPE || typeDefinition.typeNode.getKind() == NodeKind.ERROR_TYPE || typeDefinition.typeNode.getKind() == NodeKind.FINITE_TYPE_NODE) {
            typeDefinition.typeNode = this.rewrite(typeDefinition.typeNode);
        }
        this.rewrite(typeDefinition.annAttachments);
        this.result = typeDefinition;
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        this.rewrite(classDefinition.functions);
        this.rewrite(classDefinition.fields);
        classDefinition.initFunction = this.rewrite(classDefinition.initFunction);
        classDefinition.receiver = this.rewrite(classDefinition.receiver);
        this.rewrite(classDefinition.annAttachments);
        this.result = classDefinition;
    }

    @Override
    public void visit(BLangObjectConstructorExpression objectConstructorExpression) {
        this.result = this.rewrite(objectConstructorExpression.typeInit);
    }

    @Override
    public void visit(BLangSimpleVariableDef varNode) {
        varNode.var = this.rewrite(varNode.var);
        this.result = varNode;
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        this.rewrite(varNode.annAttachments);
        varNode.expr = this.rewrite(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        this.rewrite(recordTypeNode.fields);
        this.result = recordTypeNode;
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        annAttachmentNode.expr = this.rewrite(annAttachmentNode.expr);
        this.result = annAttachmentNode;
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        this.rewrite(annotationNode.annAttachments);
        this.result = annotationNode;
    }

    @Override
    public void visit(BLangResourceFunction resourceFunction) {
        this.visit((BLangFunction)resourceFunction);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        this.rewrite(funcNode.requiredParams);
        funcNode.body = this.rewrite(funcNode.body);
        this.rewrite(funcNode.annAttachments);
        if (funcNode.returnTypeNode != null) {
            this.rewrite(funcNode.returnTypeAnnAttachments);
        }
        this.result = funcNode;
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        this.result = literalExpr;
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        this.rewrite(blockNode.stmts);
        this.result = blockNode;
    }

    @Override
    public void visit(BLangReturn langReturn) {
        langReturn.expr = this.rewrite(langReturn.expr);
        this.result = langReturn;
    }

    @Override
    public void visit(BLangConstant constant) {
        constant.expr = this.rewrite(constant.expr);
        this.result = constant;
    }

    @Override
    public void visit(BLangErrorType errorType) {
        this.result = errorType;
    }

    @Override
    public void visit(BLangInvocation bLangInvocationNode) {
        bLangInvocationNode.expr = this.rewrite(bLangInvocationNode.expr);
        this.rewrite(bLangInvocationNode.requiredArgs);
        this.rewrite(bLangInvocationNode.restArgs);
        this.result = bLangInvocationNode;
    }

    @Override
    public void visit(BLangCollectContextInvocation collectContextInvocation) {
        collectContextInvocation.invocation = this.rewrite(collectContextInvocation.invocation);
        this.result = collectContextInvocation;
    }

    @Override
    public void visit(BLangErrorConstructorExpr errorConstructorExpr) {
        this.rewrite(errorConstructorExpr.positionalArgs);
        this.rewrite(errorConstructorExpr.namedArgs);
        this.result = errorConstructorExpr;
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInv) {
        actionInv.expr = this.rewrite(actionInv.expr);
        this.rewrite(actionInv.requiredArgs);
        this.rewrite(actionInv.restArgs);
        this.result = actionInv;
    }

    @Override
    public void visit(BLangInvocation.BLangResourceAccessInvocation resourceActionInvocation) {
        resourceActionInvocation.expr = this.rewrite(resourceActionInvocation.expr);
        this.rewrite(resourceActionInvocation.requiredArgs);
        this.rewrite(resourceActionInvocation.restArgs);
        resourceActionInvocation.resourceAccessPathSegments = this.rewrite(resourceActionInvocation.resourceAccessPathSegments);
        this.result = resourceActionInvocation;
    }

    @Override
    public void visit(BLangNamedArgsExpression namedArgsExpression) {
        namedArgsExpression.expr = this.rewrite(namedArgsExpression.expr);
        this.result = namedArgsExpression;
    }

    @Override
    public void visit(BLangIf ifNode) {
        ifNode.expr = this.rewrite(ifNode.expr);
        ifNode.body = this.rewrite(ifNode.body);
        ifNode.elseStmt = this.rewrite(ifNode.elseStmt);
        this.result = ifNode;
    }

    @Override
    public void visit(BLangGroupExpr bLangGroupExpr) {
        bLangGroupExpr.expression = this.rewrite(bLangGroupExpr.expression);
        this.result = bLangGroupExpr;
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        typeTestExpr.expr = this.rewrite(typeTestExpr.expr);
        this.result = typeTestExpr;
    }

    @Override
    public void visit(BLangPanic panic) {
        panic.expr = this.rewrite(panic.expr);
        this.result = panic;
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        checkedExpr.expr = this.rewrite(checkedExpr.expr);
        this.result = checkedExpr;
    }

    @Override
    public void visit(BLangFail failNode) {
        failNode.expr = this.rewrite(failNode.expr);
        this.result = failNode;
    }

    @Override
    public void visit(BLangTypeInit bLangTypeInit) {
        this.rewrite(bLangTypeInit.argsExpr);
        bLangTypeInit.initInvocation = this.rewrite(bLangTypeInit.initInvocation);
        this.result = bLangTypeInit;
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        this.rewrite(objectTypeNode.functions);
        this.rewrite(objectTypeNode.fields);
        this.result = objectTypeNode;
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        assignNode.varRef = this.rewrite(assignNode.varRef);
        assignNode.expr = this.rewrite(assignNode.expr);
        this.result = assignNode;
    }

    @Override
    public void visit(BLangRecordLiteral bLangRecordLiteral) {
        List<RecordLiteralNode.RecordField> fields = bLangRecordLiteral.fields;
        ArrayList<RecordLiteralNode.RecordField> updatedFields = new ArrayList<RecordLiteralNode.RecordField>(fields.size());
        for (RecordLiteralNode.RecordField field : fields) {
            RecordLiteralNode.RecordField updatedField;
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                keyValueField.valueExpr = this.rewrite(keyValueField.valueExpr);
                updatedField = keyValueField;
            } else {
                updatedField = field;
            }
            updatedFields.add(updatedField);
        }
        bLangRecordLiteral.fields = updatedFields;
        this.result = bLangRecordLiteral;
    }

    @Override
    public void visit(BLangExpressionStmt stmt) {
        stmt.expr = this.rewrite(stmt.expr);
        this.result = stmt;
    }

    @Override
    public void visit(BLangLock lock) {
        lock.body = this.rewrite(lock.body);
        lock.onFailClause = this.rewrite(lock.onFailClause);
        this.result = lock;
    }

    @Override
    public void visit(BLangWhile whileNode) {
        whileNode.expr = this.rewrite(whileNode.expr);
        whileNode.body = this.rewrite(whileNode.body);
        whileNode.onFailClause = this.rewrite(whileNode.onFailClause);
        this.result = whileNode;
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        binaryExpr.rhsExpr = this.rewrite(binaryExpr.rhsExpr);
        binaryExpr.lhsExpr = this.rewrite(binaryExpr.lhsExpr);
        this.result = binaryExpr;
    }

    @Override
    public void visit(BLangService serviceNode) {
        this.rewrite(serviceNode.annAttachments);
        this.rewrite(serviceNode.attachedExprs);
        this.result = serviceNode;
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockStmtNode) {
        this.result = lockStmtNode;
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignNode) {
        compoundAssignNode.varRef = this.rewrite(compoundAssignNode.varRef);
        compoundAssignNode.modifiedExpr = this.rewrite(compoundAssignNode.modifiedExpr);
        compoundAssignNode.expr = this.rewrite(compoundAssignNode.expr);
        this.result = compoundAssignNode;
    }

    @Override
    public void visit(BLangMatchStatement matchStatement) {
        matchStatement.expr = this.rewrite(matchStatement.expr);
        this.rewrite(matchStatement.matchClauses);
        matchStatement.onFailClause = this.rewrite(matchStatement.onFailClause);
        this.result = matchStatement;
    }

    @Override
    public void visit(BLangMatchClause matchClause) {
        this.rewrite(matchClause.matchPatterns);
        matchClause.blockStmt = this.rewrite(matchClause.blockStmt);
        this.result = matchClause;
    }

    @Override
    public void visit(BLangConstPattern constMatchPattern) {
        constMatchPattern.expr = this.rewrite(constMatchPattern.expr);
        this.result = constMatchPattern;
    }

    @Override
    public void visit(BLangWildCardMatchPattern wildCardMatchPattern) {
        this.result = wildCardMatchPattern;
    }

    @Override
    public void visit(BLangVarBindingPatternMatchPattern varBindingPattern) {
        this.result = varBindingPattern;
    }

    @Override
    public void visit(BLangErrorMatchPattern errorMatchPattern) {
        this.result = errorMatchPattern;
    }

    @Override
    public void visit(BLangListMatchPattern listMatchPattern) {
        this.result = listMatchPattern;
    }

    @Override
    public void visit(BLangMappingMatchPattern mappingMatchPattern) {
        this.result = mappingMatchPattern;
    }

    @Override
    public void visit(BLangFieldMatchPattern fieldMatchPattern) {
        this.result = fieldMatchPattern;
    }

    @Override
    public void visit(BLangForeach foreach) {
        foreach.collection = this.rewrite(foreach.collection);
        foreach.body = this.rewrite(foreach.body);
        foreach.onFailClause = this.rewrite(foreach.onFailClause);
        this.result = foreach;
    }

    @Override
    public void visit(BLangDo doNode) {
        doNode.body = this.rewrite(doNode.body);
        doNode.onFailClause = this.rewrite(doNode.onFailClause);
        this.result = doNode;
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        transactionNode.transactionBody = this.rewrite(transactionNode.transactionBody);
        transactionNode.onFailClause = this.rewrite(transactionNode.onFailClause);
        this.result = transactionNode;
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        rollbackNode.expr = this.rewrite(rollbackNode.expr);
        this.result = rollbackNode;
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        stmt.varRef = this.rewrite(stmt.varRef);
        stmt.expr = this.rewrite(stmt.expr);
        this.result = stmt;
    }

    @Override
    public void visit(BLangRecordDestructure stmt) {
        stmt.varRef = this.rewrite(stmt.varRef);
        stmt.expr = this.rewrite(stmt.expr);
        this.result = stmt;
    }

    @Override
    public void visit(BLangErrorDestructure stmt) {
        stmt.varRef = this.rewrite(stmt.varRef);
        stmt.expr = this.rewrite(stmt.expr);
        this.result = stmt;
    }

    @Override
    public void visit(BLangWorkerAsyncSendExpr asyncSendExpr) {
        asyncSendExpr.expr = this.rewrite(asyncSendExpr.expr);
        this.result = asyncSendExpr;
    }

    @Override
    public void visit(BLangAlternateWorkerReceive alternateWorkerReceive) {
        this.result = alternateWorkerReceive;
    }

    @Override
    public void visit(BLangMultipleWorkerReceive multipleWorkerReceive) {
        this.result = multipleWorkerReceive;
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        this.result = workerReceiveNode;
    }

    @Override
    public void visit(BLangNumericLiteral literalExpr) {
        this.result = literalExpr;
    }

    @Override
    public void visit(BLangConstRef constRef) {
        this.result = constRef;
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        this.rewrite(varRefExpr.expressions);
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        fieldAccessExpr.expr = this.rewrite(fieldAccessExpr.expr);
        this.result = fieldAccessExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess prefixedFieldBasedAccess) {
        prefixedFieldBasedAccess.expr = this.rewrite(prefixedFieldBasedAccess.expr);
        this.result = prefixedFieldBasedAccess;
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        indexAccessExpr.expr = this.rewrite(indexAccessExpr.expr);
        indexAccessExpr.indexExpr = this.rewrite(indexAccessExpr.indexExpr);
        this.result = indexAccessExpr;
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        ternaryExpr.expr = this.rewrite(ternaryExpr.expr);
        ternaryExpr.thenExpr = this.rewrite(ternaryExpr.thenExpr);
        ternaryExpr.elseExpr = this.rewrite(ternaryExpr.elseExpr);
        this.result = ternaryExpr;
    }

    @Override
    public void visit(BLangWaitExpr awaitExpr) {
        this.rewrite(awaitExpr.exprList);
        this.result = awaitExpr;
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        trapExpr.expr = this.rewrite(trapExpr.expr);
        this.result = trapExpr;
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        elvisExpr.lhsExpr = this.rewrite(elvisExpr.lhsExpr);
        elvisExpr.rhsExpr = this.rewrite(elvisExpr.rhsExpr);
        this.result = elvisExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        this.rewrite(listConstructorExpr.exprs);
        this.result = listConstructorExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangListConstructorSpreadOpExpr listConstructorSpreadOpExpr) {
        this.rewrite(listConstructorSpreadOpExpr.expr);
        this.result = listConstructorSpreadOpExpr;
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        this.rewrite(tableConstructorExpr.recordLiteralList);
        this.result = tableConstructorExpr;
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        unaryExpr.expr = this.rewrite(unaryExpr.expr);
        this.result = unaryExpr;
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        this.rewrite(conversionExpr.annAttachments);
        conversionExpr.expr = this.rewrite(conversionExpr.expr);
        this.result = conversionExpr;
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        this.rewrite(stringTemplateLiteral.exprs);
        this.result = stringTemplateLiteral;
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        this.rewrite(rawTemplateLiteral.strings);
        this.rewrite(rawTemplateLiteral.insertions);
        this.result = rawTemplateLiteral;
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        bLangLambdaFunction.function = this.rewrite(bLangLambdaFunction.function);
        this.result = bLangLambdaFunction;
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        bLangArrowFunction.body = this.rewrite(bLangArrowFunction.body);
        this.result = bLangArrowFunction;
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        bLangVarArgsExpression.expr = this.rewrite(bLangVarArgsExpression.expr);
        this.result = bLangVarArgsExpression;
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        serviceConstructorExpr.serviceNode = this.rewrite(serviceConstructorExpr.serviceNode);
        this.result = serviceConstructorExpr;
    }

    @Override
    public void visit(BLangIsLikeExpr typeTestExpr) {
        typeTestExpr.expr = this.rewrite(typeTestExpr.expr);
        this.result = typeTestExpr;
    }

    @Override
    public void visit(BLangStatementExpression bLangStatementExpression) {
        bLangStatementExpression.expr = this.rewrite(bLangStatementExpression.expr);
        this.result = bLangStatementExpression;
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanickedExpr) {
        checkPanickedExpr.expr = this.rewrite(checkPanickedExpr.expr);
        this.result = checkPanickedExpr;
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        this.result = finiteTypeNode;
    }

    @Override
    public void visit(BLangBreak breakNode) {
        this.result = breakNode;
    }

    @Override
    public void visit(BLangContinue continueNode) {
        this.result = continueNode;
    }

    @Override
    public void visit(BLangTupleVariableDef tupleVariableDef) {
        tupleVariableDef.var = this.rewrite(tupleVariableDef.var);
        this.result = tupleVariableDef;
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        bLangTupleVariable.expr = this.rewrite(bLangTupleVariable.expr);
        this.result = bLangTupleVariable;
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        bLangRecordVariable.expr = this.rewrite(bLangRecordVariable.expr);
        this.result = bLangRecordVariable;
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        bLangErrorVariable.expr = this.rewrite(bLangErrorVariable.expr);
        this.result = bLangErrorVariable;
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
        this.result = accessExpr;
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        annotAccessExpr.expr = this.rewrite(annotAccessExpr.expr);
        this.result = annotAccessExpr;
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        this.result = xmlElementLiteral;
    }

    @Override
    public void visit(BLangXMLSequenceLiteral xmlSequenceLiteral) {
        this.rewrite(xmlSequenceLiteral.xmlItems);
        this.result = xmlSequenceLiteral;
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        this.rewrite(xmlTextLiteral.textFragments);
        this.result = xmlTextLiteral;
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        this.result = waitForAllExpr;
    }

    @Override
    public void visit(BLangXMLElementFilter xmlElementFilter) {
        this.result = xmlElementFilter;
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        this.result = xmlElementAccess;
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        this.result = xmlNavigation;
    }

    @Override
    public void visit(BLangExtendedXMLNavigationAccess extendedXmlNavigationAccess) {
        List<BLangXMLStepExtend> extensions = extendedXmlNavigationAccess.extensions;
        for (int i = 0; i < extensions.size(); ++i) {
            BLangXMLStepExtend extension = extensions.get(i);
            extensions.set(i, this.rewrite(extension));
        }
        this.result = extendedXmlNavigationAccess;
    }

    @Override
    public void visit(BLangXMLIndexedStepExtend xmlIndexedStepExtend) {
        xmlIndexedStepExtend.indexExpr = this.rewrite(xmlIndexedStepExtend.indexExpr);
        this.result = xmlIndexedStepExtend;
    }

    @Override
    public void visit(BLangXMLFilterStepExtend xmlFilterStepExtend) {
        this.result = xmlFilterStepExtend;
    }

    @Override
    public void visit(BLangXMLMethodCallStepExtend xmlMethodCallStepExtend) {
        xmlMethodCallStepExtend.invocation = this.rewrite(xmlMethodCallStepExtend.invocation);
        this.result = xmlMethodCallStepExtend;
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.result = xmlnsStmtNode;
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        this.result = xmlAttribute;
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        this.rewrite(xmlCommentLiteral.textFragments);
        this.result = xmlCommentLiteral;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        this.result = workerFlushExpr;
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
        this.result = transactionalExpr;
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
        this.result = commitExpr;
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        this.result = bLangRecordVariableDef;
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        this.result = forkJoin;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        this.result = syncSendExpr;
    }

    @Override
    public void visit(BLangRetry retryNode) {
        retryNode.retryBody = this.rewrite(retryNode.retryBody);
        retryNode.onFailClause = this.rewrite(retryNode.onFailClause);
        this.result = retryNode;
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        this.result = retryTransaction;
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        this.result = xmlProcInsLiteral;
    }

    @Override
    public void visit(BLangValueType valueType) {
        this.result = valueType;
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        this.result = bLangErrorVariableDef;
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        List<BLangNode> clauses = queryExpr.getQueryClauses();
        for (int i = 0; i < clauses.size(); ++i) {
            BLangNode clause = clauses.get(i);
            clauses.set(i, this.rewrite(clause));
        }
        this.result = queryExpr;
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        fromClause.collection = this.rewrite(fromClause.collection);
        this.result = fromClause;
    }

    @Override
    public void visit(BLangJoinClause joinClause) {
        joinClause.collection = this.rewrite(joinClause.collection);
        if (joinClause.onClause != null) {
            joinClause.onClause = this.rewrite(joinClause.onClause);
        }
        this.result = joinClause;
    }

    @Override
    public void visit(BLangLetClause letClause) {
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            letVariable.definitionNode = (VariableDefinitionNode)((Object)this.rewrite((BLangNode)((Object)letVariable.definitionNode)));
        }
        this.result = letClause;
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        selectClause.expression = this.rewrite(selectClause.expression);
        this.result = selectClause;
    }

    @Override
    public void visit(BLangCollectClause collectClause) {
        collectClause.expression = this.rewrite(collectClause.expression);
        this.result = collectClause;
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        whereClause.expression = this.rewrite(whereClause.expression);
        this.result = whereClause;
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause) {
        onConflictClause.expression = this.rewrite(onConflictClause.expression);
        this.result = onConflictClause;
    }

    @Override
    public void visit(BLangLimitClause limitClause) {
        limitClause.expression = this.rewrite(limitClause.expression);
        this.result = limitClause;
    }

    @Override
    public void visit(BLangOnClause onClause) {
        onClause.lhsExpr = this.rewrite(onClause.lhsExpr);
        onClause.rhsExpr = this.rewrite(onClause.rhsExpr);
        this.result = onClause;
    }

    @Override
    public void visit(BLangOrderKey orderKeyClause) {
        orderKeyClause.expression = this.rewrite(orderKeyClause.expression);
        this.result = orderKeyClause;
    }

    @Override
    public void visit(BLangOrderByClause orderByClause) {
        orderByClause.orderByKeyList.forEach(value -> this.rewrite((BLangNode)((Object)value)));
        this.result = orderByClause;
    }

    @Override
    public void visit(BLangGroupByClause groupByClause) {
        groupByClause.groupingKeyList.forEach(value -> this.rewrite(value));
        this.result = groupByClause;
    }

    @Override
    public void visit(BLangGroupingKey groupingKey) {
        groupingKey.setGroupingKey(this.rewrite((BLangNode)groupingKey.getGroupingKey()));
        this.result = groupingKey;
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        List<BLangNode> clauses = queryAction.getQueryClauses();
        for (int i = 0; i < clauses.size(); ++i) {
            BLangNode clause = clauses.get(i);
            clauses.set(i, this.rewrite(clause));
        }
        this.result = queryAction;
    }

    @Override
    public void visit(BLangDoClause doClause) {
        doClause.body = this.rewrite(doClause.body);
        this.result = doClause;
    }

    @Override
    public void visit(BLangOnFailClause onFailClause) {
        onFailClause.body = this.rewrite(onFailClause.body);
        this.result = onFailClause;
    }

    @Override
    public void visit(BLangExternalFunctionBody externFuncBody) {
        this.rewrite(externFuncBody.annAttachments);
        this.result = externFuncBody;
    }

    @Override
    public void visit(BLangBlockFunctionBody blockFuncBody) {
        this.rewrite(blockFuncBody.stmts);
        this.result = blockFuncBody;
    }

    @Override
    public void visit(BLangExprFunctionBody exprFuncBody) {
        exprFuncBody.expr = this.rewrite(exprFuncBody.expr);
        this.result = exprFuncBody;
    }

    @Override
    public void visit(BLangLetExpression letExpr) {
        letExpr.expr = this.rewrite(letExpr.expr);
        for (BLangLetVariable var : letExpr.letVarDeclarations) {
            var.definitionNode = (VariableDefinitionNode)((Object)this.rewrite((BLangNode)((Object)var.definitionNode)));
        }
        this.result = letExpr;
    }

    @Override
    public void visit(BLangInferredTypedescDefaultNode inferTypedescExpr) {
        this.result = inferTypedescExpr;
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        if (varRefExpr.symbol == null) {
            this.result = varRefExpr;
            return;
        }
        BSymbol ownerSymbol = varRefExpr.symbol.owner;
        if (((ownerSymbol.tag & 0x1001L) == 4097L || (ownerSymbol.tag & 0x84L) == 132L) && (varRefExpr.symbol.tag & 0x100001CL) == 0x100001CL) {
            BConstantSymbol constSymbol = (BConstantSymbol)varRefExpr.symbol;
            BType literalType = Types.getImpliedType(constSymbol.literalType);
            BType varRefType = Types.getImpliedType(varRefExpr.getBType());
            if (literalType.tag == 1 && this.types.isContainSubtypeOfInt(varRefType)) {
                literalType = varRefType;
            }
            if (literalType.tag <= 6 || literalType.tag == 10) {
                BLangConstRef constRef = ASTBuilderUtil.createBLangConstRef(varRefExpr.pos, literalType, constSymbol.value.value);
                constRef.variableName = varRefExpr.variableName;
                constRef.symbol = constSymbol;
                constRef.pkgAlias = varRefExpr.pkgAlias;
                if (varRefExpr.impConversionExpr != null) {
                    BLangTypeConversionExpr implConversionExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
                    implConversionExpr.expr = constRef;
                    implConversionExpr.pos = varRefExpr.impConversionExpr.pos;
                    implConversionExpr.setBType(varRefExpr.impConversionExpr.getBType());
                    implConversionExpr.targetType = varRefExpr.impConversionExpr.targetType;
                    constRef.impConversionExpr = implConversionExpr;
                } else {
                    this.types.setImplicitCastExpr(constRef, constRef.getBType(), varRefType);
                }
                this.result = constRef;
                return;
            }
        }
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangRegExpTemplateLiteral regExpTemplateLiteral) {
        this.rewrite(regExpTemplateLiteral.reDisjunction);
        this.result = regExpTemplateLiteral;
    }

    @Override
    public void visit(BLangReSequence reSequence) {
        this.rewrite(reSequence.termList);
        this.result = reSequence;
    }

    @Override
    public void visit(BLangReAtomQuantifier reAtomQuantifier) {
        this.rewrite(reAtomQuantifier.atom);
        this.rewrite(reAtomQuantifier.quantifier);
        this.result = reAtomQuantifier;
    }

    @Override
    public void visit(BLangReAtomCharOrEscape reAtomCharOrEscape) {
        this.rewrite(reAtomCharOrEscape.charOrEscape);
        this.result = reAtomCharOrEscape;
    }

    @Override
    public void visit(BLangReQuantifier reQuantifier) {
        this.rewrite(reQuantifier.quantifier);
        this.rewrite(reQuantifier.nonGreedyChar);
        this.result = reQuantifier;
    }

    @Override
    public void visit(BLangReCharacterClass reCharacterClass) {
        this.rewrite(reCharacterClass.characterClassStart);
        this.rewrite(reCharacterClass.negation);
        this.rewrite(reCharacterClass.charSet);
        this.rewrite(reCharacterClass.characterClassEnd);
        this.result = reCharacterClass;
    }

    @Override
    public void visit(BLangReCharSet reCharSet) {
        this.rewrite(reCharSet.charSetAtoms);
        this.result = reCharSet;
    }

    @Override
    public void visit(BLangReCharSetRange reCharSetRange) {
        this.rewrite(reCharSetRange.lhsCharSetAtom);
        this.rewrite(reCharSetRange.dash);
        this.rewrite(reCharSetRange.rhsCharSetAtom);
        this.result = reCharSetRange;
    }

    @Override
    public void visit(BLangReAssertion reAssertion) {
        this.rewrite(reAssertion.assertion);
        this.result = reAssertion;
    }

    @Override
    public void visit(BLangReCapturingGroups reCapturingGroups) {
        this.rewrite(reCapturingGroups.openParen);
        this.rewrite(reCapturingGroups.flagExpr);
        this.rewrite(reCapturingGroups.disjunction);
        this.rewrite(reCapturingGroups.closeParen);
        this.result = reCapturingGroups;
    }

    @Override
    public void visit(BLangReDisjunction reDisjunction) {
        this.rewrite(reDisjunction.sequenceList);
        this.result = reDisjunction;
    }

    @Override
    public void visit(BLangReFlagsOnOff reFlagsOnOff) {
        this.rewrite(reFlagsOnOff.flags);
        this.result = reFlagsOnOff;
    }

    @Override
    public void visit(BLangReFlagExpression reFlagExpression) {
        this.rewrite(reFlagExpression.questionMark);
        this.rewrite(reFlagExpression.flagsOnOff);
        this.rewrite(reFlagExpression.colon);
        this.result = reFlagExpression;
    }

    @Override
    public void visit(BLangNaturalExpression naturalExpression) {
        this.rewrite(naturalExpression.arguments);
        this.rewrite(naturalExpression.strings);
        this.rewrite(naturalExpression.insertions);
        this.result = naturalExpression;
    }

    <E extends BLangNode> E rewrite(E node) {
        if (node == null) {
            return null;
        }
        if (node.constantPropagated) {
            return node;
        }
        node.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        resultNode.constantPropagated = true;
        return (E)resultNode;
    }

    private <E extends BLangNode> void rewrite(List<E> nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewrite((BLangNode)nodeList.get(i)));
        }
    }
}

