/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangResourcePathSegment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class DeclarativeAuthDesugar {
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final Names names;
    private static final String ORG_NAME = "ballerina";
    private static final String HTTP_PACKAGE_NAME = "http";
    private static final String GRPC_PACKAGE_NAME = "grpc";
    private static final String WEBSOCKET_PACKAGE_NAME = "websocket";
    private static final String AUTHENTICATE_RESOURCE = "authenticateResource";
    private static final CompilerContext.Key<DeclarativeAuthDesugar> DECLARATIVE_AUTH_DESUGAR_KEY = new CompilerContext.Key();

    public static DeclarativeAuthDesugar getInstance(CompilerContext context) {
        DeclarativeAuthDesugar desugar = context.get(DECLARATIVE_AUTH_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new DeclarativeAuthDesugar(context);
        }
        return desugar;
    }

    private DeclarativeAuthDesugar(CompilerContext context) {
        context.put(DECLARATIVE_AUTH_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
    }

    void desugarFunction(BLangFunction functionNode, SymbolEnv env, List<BType> expressionTypes) {
        if (this.isDefinedInStdLibPackage(expressionTypes, HTTP_PACKAGE_NAME)) {
            this.addAuthDesugarFunctionInvocation(functionNode, env, HTTP_PACKAGE_NAME);
        } else if (this.isDefinedInStdLibPackage(expressionTypes, GRPC_PACKAGE_NAME)) {
            this.addAuthDesugarFunctionInvocation(functionNode, env, GRPC_PACKAGE_NAME);
        } else if (this.isDefinedInStdLibPackage(expressionTypes, WEBSOCKET_PACKAGE_NAME)) {
            this.addAuthDesugarFunctionInvocation(functionNode, env, WEBSOCKET_PACKAGE_NAME);
        }
    }

    boolean isDefinedInStdLibPackage(List<BType> expressionTypes, String packageName) {
        for (BType expressionType : expressionTypes) {
            expressionType = Types.getImpliedType(expressionType);
            if (expressionType.tag == 21) {
                for (BType memberType : ((BUnionType)expressionType).getMemberTypes()) {
                    memberType = Types.getImpliedType(memberType);
                    if (memberType.tag != 34 || !this.isDefinedInStdLibPackage((BObjectType)memberType, packageName)) continue;
                    return true;
                }
                continue;
            }
            if (expressionType.tag != 34 || !this.isDefinedInStdLibPackage((BObjectType)expressionType, packageName)) continue;
            return true;
        }
        return false;
    }

    private boolean isDefinedInStdLibPackage(BObjectType type, String packageName) {
        return type.tsymbol.pkgID.orgName.value.equals(ORG_NAME) && type.tsymbol.pkgID.name.value.equals(packageName);
    }

    void addAuthDesugarFunctionInvocation(BLangFunction functionNode, SymbolEnv env, String packageName) {
        BPackageSymbol packageSymbol = this.getPackageSymbol(env, packageName);
        if (packageSymbol == null) {
            return;
        }
        BSymbol methodSym = this.symResolver.lookupMethodInModule(packageSymbol, Names.fromString(AUTHENTICATE_RESOURCE), env);
        if (methodSym == this.symTable.notFoundSymbol || !(methodSym instanceof BInvokableSymbol)) {
            return;
        }
        BInvokableSymbol invocationSymbol = (BInvokableSymbol)methodSym;
        Location pos = functionNode.getPosition();
        BLangSimpleVarRef selfRef = ASTBuilderUtil.createVariableRef(pos, functionNode.symbol.receiverSymbol);
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        args.add(selfRef);
        if (packageName.equals(HTTP_PACKAGE_NAME)) {
            BLangResourceFunction resourceNode = (BLangResourceFunction)functionNode;
            BLangLiteral methodNameLiteral = ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, resourceNode.methodName.value);
            ArrayList<BLangLiteral> pathLiterals = new ArrayList<BLangLiteral>();
            for (BLangResourcePathSegment pathSegment : resourceNode.resourcePathSegments) {
                pathLiterals.add(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, pathSegment.name.value));
            }
            BLangListConstructorExpr.BLangArrayLiteral resourcePathLiteral = ASTBuilderUtil.createEmptyArrayLiteral(pos, (BArrayType)this.symTable.stringArrayType);
            resourcePathLiteral.exprs = pathLiterals;
            args.add(methodNameLiteral);
            args.add(resourcePathLiteral);
        }
        BLangInvocation invocationExpr = ASTBuilderUtil.createInvocationExprForMethod(pos, invocationSymbol, args, this.symResolver);
        BLangSimpleVariableDef result = ASTBuilderUtil.createVariableDef(pos, ASTBuilderUtil.createVariable(pos, "$temp$auth$desugar$result", this.symTable.anyType, invocationExpr, null));
        List<BLangStatement> statements = this.getFunctionBodyStatementList(functionNode);
        statements.add(0, result);
        BVarSymbol resultSymbol = new BVarSymbol(0L, this.names.fromIdNode(result.var.name), env.enclPkg.packageID, result.var.getBType(), functionNode.symbol, pos, SymbolOrigin.VIRTUAL);
        functionNode.symbol.scope.define(resultSymbol.name, resultSymbol);
        result.var.symbol = resultSymbol;
    }

    private BPackageSymbol getPackageSymbol(SymbolEnv env, String packageName) {
        for (BLangImportPackage pkg : env.enclPkg.imports) {
            if (!pkg.symbol.pkgID.orgName.value.equals(ORG_NAME) || !pkg.symbol.pkgID.name.value.equals(packageName)) continue;
            return pkg.symbol;
        }
        while (env.enclEnv != null) {
            if (env.enclEnv.scope.owner.pkgID.orgName.value.equals(ORG_NAME) && env.enclEnv.scope.owner.pkgID.name.value.equals(packageName)) {
                return env.enclEnv.enclPkg.symbol;
            }
            env = env.enclEnv;
        }
        return null;
    }

    private List<BLangStatement> getFunctionBodyStatementList(BLangFunction functionNode) {
        List<BLangStatement> statements;
        if (functionNode.body.getKind() == NodeKind.EXPR_FUNCTION_BODY) {
            BLangExprFunctionBody exprFunctionBody = (BLangExprFunctionBody)functionNode.body;
            BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(functionNode.getPosition());
            statements = blockStmt.stmts;
            exprFunctionBody.expr = ASTBuilderUtil.createStatementExpression(blockStmt, exprFunctionBody.expr);
        } else {
            statements = ((BLangBlockFunctionBody)functionNode.body).stmts;
        }
        return statements;
    }
}

