/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.identifier.Utils;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.BlockFunctionBodyNode;
import org.ballerinalang.model.tree.BlockNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.NamedArgNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.expressions.XMLNavigationAccess;
import org.ballerinalang.model.tree.statements.VariableDefinitionNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.AnnotationDesugar;
import org.wso2.ballerinalang.compiler.desugar.ClassClosureDesugar;
import org.wso2.ballerinalang.compiler.desugar.ClosureDesugar;
import org.wso2.ballerinalang.compiler.desugar.ClosureGenerator;
import org.wso2.ballerinalang.compiler.desugar.Code2CloudDesugar;
import org.wso2.ballerinalang.compiler.desugar.LargeMethodSplitter;
import org.wso2.ballerinalang.compiler.desugar.MockDesugar;
import org.wso2.ballerinalang.compiler.desugar.ObservabilityDesugar;
import org.wso2.ballerinalang.compiler.desugar.QueryDesugar;
import org.wso2.ballerinalang.compiler.desugar.ServiceDesugar;
import org.wso2.ballerinalang.compiler.desugar.TransactionDesugar;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.parser.NodeCloner;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemanticAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.SchedulerPolicy;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLSubType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangRetrySpec;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeyTypeConstraint;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.OCEDynamicEnvironmentData;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangCaptureBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorCauseBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorFieldBindingPatterns;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorMessageBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangFieldBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangListBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangMappingBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangNamedArgBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangRestBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangSimpleBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangWildCardBindingPattern;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAlternateWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangDynamicArgExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExtendedXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInferredTypedescDefaultNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMultipleWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNaturalExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAssertion;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomCharOrEscape;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCapturingGroups;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharSet;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharSetRange;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharacterClass;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReDisjunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReFlagExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReFlagsOnOff;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReSequence;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRegExpTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangValueExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerAsyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSendReceiveExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLFilterStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLIndexedStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLMethodCallStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangConstPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorCauseMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorFieldMatchPatterns;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorMessageMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangFieldMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangListMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMappingMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangNamedArgMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangRestMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangSimpleMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangVarBindingPatternMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangWildCardMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.ClosureVarSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;
import org.wso2.ballerinalang.compiler.util.FieldKind;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.compiler.util.Unifier;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.Lists;

public class Desugar
extends BLangNodeVisitor {
    private static final CompilerContext.Key<Desugar> DESUGAR_KEY = new CompilerContext.Key();
    private static final String ERROR_MESSAGE_FUNCTION_NAME = "message";
    private static final String ERROR_CAUSE_FUNCTION_NAME = "cause";
    private static final String ERROR_DETAIL_FUNCTION_NAME = "detail";
    private static final String TO_STRING_FUNCTION_NAME = "toString";
    private static final String LENGTH_FUNCTION_NAME = "length";
    private static final String ERROR_REASON_NULL_REFERENCE_ERROR = "NullReferenceException";
    private static final String CLONE_WITH_TYPE = "cloneWithType";
    private static final String PUSH_LANGLIB_METHOD = "push";
    private static final String DESUGARED_VARARG_KEY = "$vararg$";
    private static final String GENERATED_ERROR_VAR = "$error$";
    private static final String TYPEDESC = "$td$";
    private static final String HAS_KEY = "hasKey";
    private static final String CREATE_RECORD_VALUE = "createRecordFromMap";
    private static final String CHANNEL_AUTO_CLOSE_FUNC_NAME = "autoClose";
    private static final String GENERATE = "generate";
    private static final String ESCAPED_BACKTICK = "\"`\"";
    public static final String XML_INTERNAL_CHILDREN = "children";
    public static final String XML_MAP = "map";
    public static final String XML_GET_DESCENDANTS = "getDescendants";
    public static final String XML_INTERNAL_GET_ELEMENT_NAME_NIL_LIFTING = "getElementNameNilLifting";
    public static final String XML_INTERNAL_GET_ATTRIBUTE = "getAttribute";
    public static final String XML_INTERNAL_GET_ELEMENTS = "getElements";
    public static final String XML_ELEMENTS = "elements";
    public static final String ANNOT_RESOLVE_POINT = "$AnnotResolvePoint";
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final SymbolEnter symbolEnter;
    private final ClosureDesugar closureDesugar;
    private final ClosureGenerator closureGenerator;
    private final QueryDesugar queryDesugar;
    private final TransactionDesugar transactionDesugar;
    private final ObservabilityDesugar observabilityDesugar;
    private final Code2CloudDesugar code2CloudDesugar;
    private final AnnotationDesugar annotationDesugar;
    private final Types types;
    private Names names;
    private final ServiceDesugar serviceDesugar;
    private BLangNode result;
    private final NodeCloner nodeCloner;
    private final SemanticAnalyzer semanticAnalyzer;
    private final BLangAnonymousModelHelper anonModelHelper;
    private final Unifier unifier;
    private final MockDesugar mockDesugar;
    private final ClassClosureDesugar classClosureDesugar;
    private final LargeMethodSplitter largeMethodSplitter;
    public Deque<BLangLock.BLangLockStmt> enclLocks = new ArrayDeque<BLangLock.BLangLockStmt>();
    private BLangOnFailClause onFailClause;
    private boolean shouldReturnErrors;
    private int transactionBlockCount;
    private BLangLiteral trxBlockId;
    private final List<BLangOnFailClause> enclosingOnFailClause = new ArrayList<BLangOnFailClause>();
    private final Map<BLangOnFailClause, BLangSimpleVarRef> enclosingShouldPanic = new HashMap<BLangOnFailClause, BLangSimpleVarRef>();
    private final List<BLangSimpleVarRef> enclosingShouldContinue = new ArrayList<BLangSimpleVarRef>();
    private List<BLangSimpleVariableDef> typedescList = new ArrayList<BLangSimpleVariableDef>();
    private BLangSimpleVarRef shouldRetryRef;
    private SymbolEnv env;
    private int lambdaFunctionCount = 0;
    private int recordCount = 0;
    private int errorCount = 0;
    private int errorDetailCount = 0;
    private int annonVarCount = 0;
    private int indexExprCount = 0;
    private int letCount = 0;
    private int varargCount = 0;
    private int funcParamCount = 1;
    private boolean isVisitingQuery;
    private boolean desugarToReturn;
    private int typedescCount = 0;
    private Set<BLangWorkerSendReceiveExpr.Channel> channelsWithinIfStmt = new LinkedHashSet<BLangWorkerSendReceiveExpr.Channel>();
    private Deque<BLangMatchStatement> matchStmtStack = new ArrayDeque<BLangMatchStatement>();
    Deque<BLangExpression> accessExprStack = new ArrayDeque<BLangExpression>();
    private BLangMatchClause successClause;
    private BLangAssignment safeNavigationAssignment;
    static boolean isJvmTarget = false;
    private Map<BSymbol, Set<BVarSymbol>> globalVariablesDependsOn;
    private final List<BLangStatement> matchStmtsForPattern = new ArrayList<BLangStatement>();
    private final Map<String, BLangSimpleVarRef> declaredVarDef = new HashMap<String, BLangSimpleVarRef>();
    private List<BLangXMLNS> inlineXMLNamespaces;
    private Map<Name, BLangStatement> stmtsToBePropagatedToQuery = new HashMap<Name, BLangStatement>();
    private BLangAnnotationAttachment strandAnnotAttachement;
    private BLangAnonymousModelHelper anonymousModelHelper;

    public static Desugar getInstance(CompilerContext context) {
        Desugar desugar = context.get(DESUGAR_KEY);
        if (desugar == null) {
            desugar = new Desugar(context);
        }
        return desugar;
    }

    private Desugar(CompilerContext context) {
        isJvmTarget = true;
        context.put(DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.closureDesugar = ClosureDesugar.getInstance(context);
        this.closureGenerator = ClosureGenerator.getInstance(context);
        this.queryDesugar = QueryDesugar.getInstance(context);
        this.transactionDesugar = TransactionDesugar.getInstance(context);
        this.observabilityDesugar = ObservabilityDesugar.getInstance(context);
        this.code2CloudDesugar = Code2CloudDesugar.getInstance(context);
        this.annotationDesugar = AnnotationDesugar.getInstance(context);
        this.largeMethodSplitter = LargeMethodSplitter.getInstance(context);
        this.types = Types.getInstance(context);
        this.names = Names.getInstance(context);
        this.names = Names.getInstance(context);
        this.serviceDesugar = ServiceDesugar.getInstance(context);
        this.nodeCloner = NodeCloner.getInstance(context);
        this.semanticAnalyzer = SemanticAnalyzer.getInstance(context);
        this.anonModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.mockDesugar = MockDesugar.getInstance(context);
        this.classClosureDesugar = ClassClosureDesugar.getInstance(context);
        this.unifier = new Unifier();
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
    }

    public BLangPackage perform(BLangPackage pkgNode) {
        SymbolEnv env = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        this.globalVariablesDependsOn = env.enclPkg.globalVariableDependencies;
        return this.rewrite(pkgNode, env);
    }

    private void addAttachedFunctionsToPackageLevel(BLangPackage pkgNode, SymbolEnv env) {
        for (BLangTypeDefinition typeDef : pkgNode.typeDefinitions) {
            BSymbol typeSymbol;
            if (typeDef.typeNode.getKind() == NodeKind.USER_DEFINED_TYPE) continue;
            BSymbol bSymbol = typeSymbol = typeDef.symbol.tag == 32796L ? typeDef.symbol.type.tsymbol : typeDef.symbol;
            if (typeSymbol.tag != 98396L) continue;
            BLangObjectTypeNode objectTypeNode = (BLangObjectTypeNode)typeDef.typeNode;
            objectTypeNode.functions.forEach(f -> {
                if (!pkgNode.objAttachedFunctions.contains(f.symbol)) {
                    pkgNode.functions.add((BLangFunction)f);
                    pkgNode.topLevelNodes.add((TopLevelNode)f);
                }
            });
        }
        int toplevelNodeCount = pkgNode.topLevelNodes.size();
        for (int i = 0; i < toplevelNodeCount; ++i) {
            TopLevelNode topLevelNode = pkgNode.topLevelNodes.get(i);
            if (topLevelNode.getKind() != NodeKind.CLASS_DEFN) continue;
            this.addClassMemberFunctionsToTopLevel(pkgNode, env, (BLangClassDefinition)topLevelNode);
        }
    }

    private void addClassMemberFunctionsToTopLevel(BLangPackage pkgNode, SymbolEnv env, BLangClassDefinition classDefinition) {
        for (BLangFunction function : classDefinition.functions) {
            if (pkgNode.objAttachedFunctions.contains(function.symbol)) continue;
            pkgNode.functions.add(function);
            pkgNode.topLevelNodes.add(function);
        }
        BLangFunction tempGeneratedInitFunction = this.createGeneratedInitializerFunction(classDefinition, env);
        tempGeneratedInitFunction.clonedEnv = SymbolEnv.createFunctionEnv(tempGeneratedInitFunction, tempGeneratedInitFunction.symbol.scope, env);
        this.semanticAnalyzer.analyzeNode((BLangNode)tempGeneratedInitFunction, env);
        classDefinition.generatedInitFunction = tempGeneratedInitFunction;
        pkgNode.functions.add(classDefinition.generatedInitFunction);
        pkgNode.topLevelNodes.add(classDefinition.generatedInitFunction);
        if (classDefinition.initFunction != null) {
            pkgNode.functions.add(classDefinition.initFunction);
            pkgNode.topLevelNodes.add(classDefinition.initFunction);
        }
    }

    private BLangFunction createGeneratedInitializerFunction(BLangClassDefinition classDefinition, SymbolEnv env) {
        BLangFunction generatedInitFunc = this.createInitFunctionForClassDefn(classDefinition, env);
        if (classDefinition.initFunction == null) {
            return this.rewrite(generatedInitFunc, env);
        }
        return this.wireUpGeneratedInitFunction(generatedInitFunc, (BObjectTypeSymbol)classDefinition.symbol, classDefinition.initFunction);
    }

    private BLangFunction wireUpGeneratedInitFunction(BLangFunction generatedInitFunc, BObjectTypeSymbol objectTypeSymbol, BLangFunction initFunction) {
        this.addReturnIfNotPresent(generatedInitFunc);
        BAttachedFunction initializerFunc = objectTypeSymbol.initializerFunc;
        BAttachedFunction generatedInitializerFunc = objectTypeSymbol.generatedInitializerFunc;
        this.addRequiredParamsToGeneratedInitFunction(initFunction, generatedInitFunc, generatedInitializerFunc);
        this.addRestParamsToGeneratedInitFunction(initFunction, generatedInitFunc, generatedInitializerFunc);
        generatedInitFunc.returnTypeNode = initFunction.returnTypeNode;
        generatedInitializerFunc.symbol.retType = generatedInitFunc.returnTypeNode.getBType();
        ((BInvokableType)generatedInitFunc.symbol.type).paramTypes = initializerFunc.type.paramTypes;
        ((BInvokableType)generatedInitFunc.symbol.type).retType = initializerFunc.type.retType;
        ((BInvokableType)generatedInitFunc.symbol.type).restType = initializerFunc.type.restType;
        generatedInitFunc.symbol.type.tsymbol = initializerFunc.type.tsymbol;
        generatedInitializerFunc.type = initializerFunc.type;
        generatedInitFunc.desugared = false;
        return generatedInitFunc;
    }

    private void addRequiredParamsToGeneratedInitFunction(BLangFunction initFunction, BLangFunction generatedInitFunc, BAttachedFunction generatedInitializerFunc) {
        if (initFunction.requiredParams.isEmpty()) {
            return;
        }
        for (BLangSimpleVariable requiredParameter : initFunction.requiredParams) {
            BLangSimpleVariable var = ASTBuilderUtil.createVariable(initFunction.pos, requiredParameter.name.getValue(), requiredParameter.getBType(), this.createRequiredParamExpr(requiredParameter.expr), new BVarSymbol(Flags.asMask(requiredParameter.flagSet), Names.fromString(requiredParameter.name.getValue()), requiredParameter.symbol.pkgID, requiredParameter.getBType(), requiredParameter.symbol.owner, initFunction.pos, SymbolOrigin.VIRTUAL));
            generatedInitFunc.requiredParams.add(var);
            generatedInitializerFunc.symbol.params.add(var.symbol);
        }
    }

    private BLangExpression createRequiredParamExpr(BLangExpression expr) {
        if (expr == null) {
            return null;
        }
        if (expr.getKind() == NodeKind.LAMBDA) {
            BLangFunction func = ((BLangLambdaFunction)expr).function;
            return this.createLambdaFunction(func.pos, func.name.value, func.requiredParams, func.returnTypeNode, func.body);
        }
        ++expr.cloneAttempt;
        BLangExpression expression = this.nodeCloner.cloneNode(expr);
        if (expression.getKind() == NodeKind.ARROW_EXPR) {
            BLangIdentifier func = (BLangIdentifier)((BLangArrowFunction)expression).functionName;
            ((BLangArrowFunction)expression).functionName = ASTBuilderUtil.createIdentifier(func.pos, "$" + func.getValue() + "$");
        }
        return expression;
    }

    private void addRestParamsToGeneratedInitFunction(BLangFunction initFunction, BLangFunction generatedInitFunc, BAttachedFunction generatedInitializerFunc) {
        if (initFunction.restParam == null) {
            return;
        }
        BLangSimpleVariable restParam = initFunction.restParam;
        generatedInitFunc.restParam = ASTBuilderUtil.createVariable(initFunction.pos, restParam.name.getValue(), restParam.getBType(), null, new BVarSymbol(0L, Names.fromString(restParam.name.getValue()), restParam.symbol.pkgID, restParam.getBType(), restParam.symbol.owner, restParam.pos, SymbolOrigin.VIRTUAL));
        generatedInitializerFunc.symbol.restParam = generatedInitFunc.restParam.symbol;
    }

    private void createPackageInitFunctions(BLangPackage pkgNode, SymbolEnv env) {
        String alias = "";
        pkgNode.initFunction = ASTBuilderUtil.createInitFunctionWithErrorOrNilReturn(pkgNode.pos, alias, Names.INIT_FUNCTION_SUFFIX, this.symTable);
        BLangBlockFunctionBody initFnBody = (BLangBlockFunctionBody)pkgNode.initFunction.body;
        for (BLangXMLNS xmlns : pkgNode.xmlnsList) {
            initFnBody.addStatement(this.createNamespaceDeclrStatement(xmlns));
        }
        pkgNode.startFunction = ASTBuilderUtil.createInitFunctionWithErrorOrNilReturn(pkgNode.pos, alias, Names.START_FUNCTION_SUFFIX, this.symTable);
        pkgNode.stopFunction = ASTBuilderUtil.createInitFunctionWithErrorOrNilReturn(pkgNode.pos, alias, Names.STOP_FUNCTION_SUFFIX, this.symTable);
        this.createInvokableSymbol(pkgNode.initFunction, env);
        this.createInvokableSymbol(pkgNode.startFunction, env);
        this.createInvokableSymbol(pkgNode.stopFunction, env);
    }

    private void addUserDefinedModuleInitInvocationAndReturn(BLangPackage pkgNode) {
        Optional<BLangFunction> userDefInitOptional = pkgNode.functions.stream().filter(bLangFunction -> !bLangFunction.attachedFunction && bLangFunction.name.value.equals(Names.USER_DEFINED_INIT_SUFFIX.value)).findFirst();
        BLangBlockFunctionBody initFnBody = (BLangBlockFunctionBody)pkgNode.initFunction.body;
        if (!userDefInitOptional.isPresent()) {
            this.addNilReturnStatement(initFnBody);
            return;
        }
        BLangFunction userDefInit = userDefInitOptional.get();
        BLangInvocation userDefInitInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        userDefInitInvocation.pos = pkgNode.initFunction.pos;
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(userDefInit.name.value);
        userDefInitInvocation.name = name;
        userDefInitInvocation.symbol = userDefInit.symbol;
        BLangIdentifier pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        pkgAlias.setLiteral(false);
        pkgAlias.setValue(pkgNode.packageID.name.value);
        userDefInitInvocation.pkgAlias = pkgAlias;
        userDefInitInvocation.setBType(userDefInit.returnTypeNode.getBType());
        userDefInitInvocation.requiredArgs = Collections.emptyList();
        BLangReturn returnStmt = (BLangReturn)TreeBuilder.createReturnNode();
        returnStmt.pos = pkgNode.initFunction.pos;
        returnStmt.expr = userDefInitInvocation;
        initFnBody.stmts.add(returnStmt);
    }

    protected void createInvokableSymbol(BLangFunction bLangFunction, SymbolEnv env) {
        BType returnType = bLangFunction.returnTypeNode.getBType() == null ? this.symResolver.resolveTypeNode(bLangFunction.returnTypeNode, env) : bLangFunction.returnTypeNode.getBType();
        BInvokableType invokableType = new BInvokableType(this.symTable.typeEnv(), List.of(), this.getRestType(bLangFunction), returnType, null);
        BInvokableSymbol functionSymbol = Symbols.createFunctionSymbol(Flags.asMask(bLangFunction.flagSet), new Name(bLangFunction.name.value), new Name(bLangFunction.name.originalValue), env.enclPkg.packageID, invokableType, env.enclPkg.symbol, true, bLangFunction.pos, SymbolOrigin.VIRTUAL);
        functionSymbol.retType = returnType;
        functionSymbol.originalName = new Name(bLangFunction.name.originalValue);
        for (BLangVariable param : bLangFunction.requiredParams) {
            functionSymbol.params.add(param.symbol);
        }
        functionSymbol.scope = new Scope(functionSymbol);
        bLangFunction.symbol = functionSymbol;
    }

    private void addNilReturnStatement(BlockNode bLangBlockStmt) {
        BLangReturn returnStmt = ASTBuilderUtil.createNilReturnStmt(((BLangNode)((Object)bLangBlockStmt)).pos, this.symTable.nilType);
        bLangBlockStmt.addStatement(returnStmt);
    }

    private BLangXMLNSStatement createNamespaceDeclrStatement(BLangXMLNS xmlns) {
        BLangXMLNSStatement xmlnsStmt = (BLangXMLNSStatement)TreeBuilder.createXMLNSDeclrStatementNode();
        xmlnsStmt.xmlnsDecl = xmlns;
        xmlnsStmt.pos = xmlns.pos;
        return xmlnsStmt;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.DESUGAR)) {
            this.result = pkgNode;
            return;
        }
        this.observabilityDesugar.addObserveInternalModuleImport(pkgNode);
        this.code2CloudDesugar.addCode2CloudModuleImport(pkgNode);
        this.createPackageInitFunctions(pkgNode, this.env);
        this.addAttachedFunctionsToPackageLevel(pkgNode, this.env);
        if (!pkgNode.testablePkgs.isEmpty() && pkgNode.getTestablePkg().getMockFunctionNamesMap() != null) {
            this.mockDesugar.generateMockFunctions(pkgNode);
        }
        this.closureGenerator.visit(pkgNode);
        this.annotationDesugar.initializeAnnotationMap(pkgNode);
        pkgNode.constants = this.removeDuplicateConstants(pkgNode);
        for (BLangConstant constant : pkgNode.constants) {
            if (constant.expr.getKind() != NodeKind.LITERAL && constant.expr.getKind() != NodeKind.NUMERIC_LITERAL || constant.expr.getBType().tag == 31) continue;
            pkgNode.typeDefinitions.add(constant.associatedTypeDefinition);
        }
        BLangBlockStmt serviceAttachments = this.serviceDesugar.rewriteServiceVariables(pkgNode.services, this.env);
        pkgNode.services.forEach(service -> this.serviceDesugar.engageCustomServiceDesugar((BLangService)service, this.env));
        this.desugarTopLevelNodes(pkgNode);
        this.annotationDesugar.rewritePackageAnnotations(pkgNode, this.env);
        this.rewrite(pkgNode.xmlnsList, this.env);
        this.rewrite(pkgNode.constants, this.env);
        this.rewrite(pkgNode.globalVars, this.env);
        this.rewrite(pkgNode.classDefinitions, this.env);
        this.addUserDefinedModuleInitInvocationAndReturn(pkgNode);
        this.serviceDesugar.rewriteListeners(pkgNode.globalVars, this.env, pkgNode.startFunction, pkgNode.stopFunction);
        ASTBuilderUtil.appendStatements(serviceAttachments, (BLangBlockFunctionBody)pkgNode.initFunction.body);
        this.addNilReturnStatement((BLangBlockFunctionBody)pkgNode.startFunction.body);
        this.addNilReturnStatement((BLangBlockFunctionBody)pkgNode.stopFunction.body);
        if (isJvmTarget) {
            this.largeMethodSplitter.splitLargeFunctions(pkgNode, this.env);
        }
        pkgNode.initFunction = this.rewrite(pkgNode.initFunction, this.env);
        pkgNode.startFunction = this.rewrite(pkgNode.startFunction, this.env);
        pkgNode.stopFunction = this.rewrite(pkgNode.stopFunction, this.env);
        for (int i = 0; i < pkgNode.functions.size(); ++i) {
            BLangFunction function = pkgNode.functions.get(i);
            if (function.flagSet.contains((Object)Flag.LAMBDA) && !function.name.value.contains("$MOCK_")) continue;
            pkgNode.functions.set(i, this.rewrite(pkgNode.functions.get(i), this.env));
        }
        for (BLangLambdaFunction lambdaFunction : pkgNode.lambdaFunctions) {
            this.rewrite(lambdaFunction, lambdaFunction.capturedClosureEnv);
        }
        this.closureDesugar.visit(pkgNode);
        for (BLangTestablePackage testablePkg : pkgNode.getTestablePkgs()) {
            this.rewrite(testablePkg, this.symTable.pkgEnvMap.get(testablePkg.symbol));
        }
        pkgNode.completedPhases.add(CompilerPhase.DESUGAR);
        this.clearGlobalVariables();
        this.result = pkgNode;
    }

    private void desugarConstant(BLangConstant constant, List<BLangVariable> desugaredGlobalVarList, BLangBlockFunctionBody initFnBody, SymbolEnv initFunctionEnv) {
        BType constType = Types.getReferredType(constant.symbol.type);
        if (constType.tag != 22) {
            return;
        }
        BConstantSymbol constSymbol = constant.symbol;
        BType impliedType = Types.getImpliedType(constSymbol.literalType);
        int tag = impliedType.tag;
        if ((tag == 12 || tag == 16) && constant.expr.getKind() == NodeKind.RECORD_LITERAL_EXPR || tag == 31 && constant.expr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
            BLangIntersectionTypeNode blangIntersection = (BLangIntersectionTypeNode)TreeBuilder.createIntersectionTypeNode();
            blangIntersection.setBType(constSymbol.literalType);
            blangIntersection.pos = constSymbol.literalType.tsymbol.pos;
            this.createTypedescVariableForAnonType(blangIntersection);
        }
        this.addTypeDescStmtsToInitFunction(initFunctionEnv, desugaredGlobalVarList, initFnBody);
        BLangSimpleVarRef constVarRef = ASTBuilderUtil.createVariableRef(constant.pos, constant.symbol);
        BLangAssignment constInit = ASTBuilderUtil.createAssignmentStmt(constant.pos, constVarRef, constant.expr);
        initFnBody.stmts.add(constInit);
        constant.expr = null;
    }

    private void createTypedescVariable(BType type, Location pos) {
        BType finalType = type;
        if (Types.getReferredType((BType)type).tag != 22 && this.env.enclPkg.typeDefinitions.stream().anyMatch(typeDef -> Types.getReferredType((BType)typeDef.typeNode.getBType()).tag == 22 && typeDef.symbol.name.value.equals(finalType.tsymbol.name.value))) {
            return;
        }
        Name name = this.generateTypedescVariableName(type);
        if (type.tag == 14) {
            BType referredType = ((BTypeReferenceType)type).referredType;
            int tag = referredType.tag;
            if (tag == 12) {
                type = referredType;
            }
        }
        BTypedescType typedescType = new BTypedescType(this.symTable.typeEnv(), type, this.symTable.typeDesc.tsymbol);
        BSymbol owner = this.env.scope.owner;
        BVarSymbol varSymbol = new BVarSymbol(0L, name, owner.pkgID, typedescType, owner, pos, SymbolOrigin.VIRTUAL);
        BLangTypedescExpr typedescExpr = ASTBuilderUtil.createTypedescExpr(pos, typedescType, type);
        this.typedescList.add(this.createSimpleVariableDef(pos, name.value, typedescType, typedescExpr, varSymbol));
    }

    private void createTypedescVariableForAnonType(BLangType typeNode) {
        BLangNode parentNode = typeNode.parent;
        if (parentNode != null && parentNode.getKind() == NodeKind.TYPE_DEFINITION) {
            BSymbol typeDefSymbol = ((BLangTypeDefinition)parentNode).symbol;
            if (typeDefSymbol.kind == SymbolKind.TYPE_DEF && typeDefSymbol.origin != SymbolOrigin.VIRTUAL) {
                return;
            }
        }
        this.createTypedescVariable(typeNode.getBType(), typeNode.pos);
    }

    private Name generateTypedescVariableName(BType targetType) {
        Name name;
        if (targetType.tag == 16 || targetType.tsymbol.name.value.isEmpty()) {
            int n = this.typedescCount++;
            name = new Name(TYPEDESC + n);
        } else {
            name = new Name(TYPEDESC + targetType.tsymbol.name.value);
        }
        return name;
    }

    private BLangSimpleVariableDef createSimpleVariableDef(Location pos, String name, BType type, BLangExpression expr, BVarSymbol varSymbol) {
        BLangSimpleVariable simpleVariable = ASTBuilderUtil.createVariable(pos, name, type, expr, varSymbol);
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDef(pos);
        variableDef.var = simpleVariable;
        variableDef.setBType(type);
        return variableDef;
    }

    private List<BLangConstant> removeDuplicateConstants(BLangPackage pkgNode) {
        HashSet<String> elements = new HashSet<String>();
        for (int i = 0; i < pkgNode.constants.size(); ++i) {
            String next = pkgNode.constants.get((int)i).symbol.name.value;
            if (elements.contains(next)) {
                pkgNode.constants.remove(i);
                --i;
                continue;
            }
            elements.add(next);
        }
        return pkgNode.constants;
    }

    private BLangStatementExpression createIfElseFromConfigurable(BLangSimpleVariable configurableVar, SymbolEnv initFunctionEnv) {
        List<BLangExpression> args = this.getConfigurableLangLibInvocationParam(configurableVar);
        BLangInvocation hasValueInvocation = this.createLangLibInvocationNode("hasConfigurableValue", args, this.symTable.booleanType, configurableVar.pos);
        BLangInvocation getValueInvocation = this.createLangLibInvocationNode("getConfigurableValue", args, this.symTable.anydataType, configurableVar.pos);
        BLangBlockStmt thenBody = ASTBuilderUtil.createBlockStmt(configurableVar.pos);
        BLangBlockStmt elseBody = ASTBuilderUtil.createBlockStmt(configurableVar.pos);
        BLangSimpleVarRef thenResultVarRef = ASTBuilderUtil.createVariableRef(configurableVar.pos, configurableVar.symbol);
        BLangAssignment thenAssignment = ASTBuilderUtil.createAssignmentStmt(configurableVar.pos, thenResultVarRef, getValueInvocation);
        thenBody.addStatement(thenAssignment);
        BLangSimpleVarRef elseResultVarRef = ASTBuilderUtil.createVariableRef(configurableVar.pos, configurableVar.symbol);
        BLangAssignment elseAssignment = ASTBuilderUtil.createAssignmentStmt(configurableVar.pos, elseResultVarRef, configurableVar.expr);
        elseBody.addStatement(elseAssignment);
        BLangIf ifElse = ASTBuilderUtil.createIfElseStmt(configurableVar.pos, hasValueInvocation, thenBody, elseBody);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(configurableVar.pos, configurableVar.symbol);
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(ifElse, resultVarRef);
        stmtExpr.setBType(configurableVar.getBType());
        return stmtExpr;
    }

    private List<BLangExpression> getConfigurableLangLibInvocationParam(BLangSimpleVariable configurableVar) {
        String orgName = this.env.enclPkg.packageID.orgName.getValue();
        BLangLiteral orgLiteral = ASTBuilderUtil.createLiteral(configurableVar.pos, this.symTable.stringType, orgName);
        String moduleName = this.env.enclPkg.packageID.name.getValue();
        BLangLiteral moduleNameLiteral = ASTBuilderUtil.createLiteral(configurableVar.pos, this.symTable.stringType, moduleName);
        String versionNumber = CompilerUtils.getMajorVersion(this.env.enclPkg.packageID.version.getValue());
        BLangLiteral versionLiteral = ASTBuilderUtil.createLiteral(configurableVar.pos, this.symTable.stringType, versionNumber);
        String configVarName = configurableVar.name.getValue();
        BLangLiteral configNameLiteral = ASTBuilderUtil.createLiteral(configurableVar.pos, this.symTable.stringType, configVarName);
        BType type = configurableVar.getBType();
        BTypedescType typedescType = new BTypedescType(this.symTable.typeEnv(), type, this.symTable.typeDesc.tsymbol);
        BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
        typedescExpr.resolvedType = type;
        typedescExpr.setBType(typedescType);
        return new ArrayList<BLangExpression>(Arrays.asList(orgLiteral, moduleNameLiteral, versionLiteral, configNameLiteral, typedescExpr));
    }

    private void desugarTopLevelNodes(BLangPackage pkgNode) {
        ArrayList<BLangVariable> desugaredGlobalVarList = new ArrayList<BLangVariable>();
        this.typedescList = new ArrayList<BLangSimpleVariableDef>();
        BLangBlockFunctionBody initFnBody = (BLangBlockFunctionBody)pkgNode.initFunction.body;
        SymbolEnv initFunctionEnv = SymbolEnv.createFunctionEnv(pkgNode.initFunction, pkgNode.initFunction.symbol.scope, this.env);
        block7: for (int i = 0; i < pkgNode.topLevelNodes.size(); ++i) {
            TopLevelNode topLevelNode = pkgNode.topLevelNodes.get(i);
            switch (topLevelNode.getKind()) {
                case TUPLE_VARIABLE: 
                case RECORD_VARIABLE: 
                case ERROR_VARIABLE: {
                    this.desugarVariable((BLangVariable)topLevelNode, initFunctionEnv, initFnBody, desugaredGlobalVarList);
                    continue block7;
                }
                case VARIABLE: {
                    this.desugarGlobalVariable(initFunctionEnv, desugaredGlobalVarList, (BLangVariable)topLevelNode, initFnBody);
                    continue block7;
                }
                case CONSTANT: {
                    this.desugarConstant((BLangConstant)topLevelNode, desugaredGlobalVarList, initFnBody, initFunctionEnv);
                    continue block7;
                }
                case TYPE_DEFINITION: {
                    this.rewrite((BLangTypeDefinition)topLevelNode, this.env);
                    this.addTypeDescStmtsToInitFunction(initFunctionEnv, desugaredGlobalVarList, initFnBody);
                    continue block7;
                }
                case FUNCTION: {
                    BLangFunction function = (BLangFunction)topLevelNode;
                    if (function.annAttachments.isEmpty()) continue block7;
                    this.createAnnotationResolvePoint((BLangFunction)topLevelNode, initFnBody);
                }
            }
        }
        pkgNode.globalVars = desugaredGlobalVarList;
    }

    private void createAnnotationResolvePoint(BLangFunction function, BLangBlockFunctionBody initFnBody) {
        BLangSimpleVariable simpleVariable = ASTBuilderUtil.createVariable(null, "$" + String.valueOf(function.symbol.name) + ANNOT_RESOLVE_POINT, null, null, function.symbol);
        BLangSimpleVariableDef simpleVariableDef = ASTBuilderUtil.createVariableDef(null);
        simpleVariableDef.var = simpleVariable;
        simpleVariableDef.setBType(simpleVariable.getBType());
        initFnBody.addStatement(simpleVariableDef);
    }

    private void addTypeDescStmtsToInitFunction(SymbolEnv initFunctionEnv, List<BLangVariable> desugaredGlobalVarList, BLangBlockFunctionBody initFnBody) {
        BSymbol owner = this.env.scope.owner;
        for (BLangSimpleVariableDef variableDef : this.typedescList) {
            BVarSymbol varSymbol = variableDef.var.symbol;
            varSymbol.pkgID = owner.pkgID;
            varSymbol.owner = owner;
            this.rewrite(variableDef, initFunctionEnv);
            this.addToInitFunction(variableDef.var, initFnBody);
            desugaredGlobalVarList.add(variableDef.var);
        }
        this.typedescList.clear();
    }

    private void desugarVariable(BLangVariable variable, SymbolEnv initFunctionEnv, BLangBlockFunctionBody initFnBody, List<BLangVariable> desugaredGlobalVarList) {
        BLangVariable blockStatementNode = this.rewrite(variable, initFunctionEnv);
        List<BLangStatement> statements = ((BLangBlockStmt)((Object)blockStatementNode)).stmts;
        this.addTypeDescStmtsToInitFunction(initFunctionEnv, desugaredGlobalVarList, initFnBody);
        for (BLangStatement statement : statements) {
            this.addToGlobalVariableList(statement, initFnBody, variable, desugaredGlobalVarList);
        }
    }

    private void desugarGlobalVariable(SymbolEnv initFunctionEnv, List<BLangVariable> desugaredGlobalVarList, BLangVariable globalVar, BLangBlockFunctionBody initFnBody) {
        BLangType typeNode;
        long globalVarFlags = globalVar.symbol.flags;
        BLangSimpleVariable simpleGlobalVar = (BLangSimpleVariable)globalVar;
        if (Symbols.isFlagOn(globalVarFlags, 0x80000000L)) {
            this.handleConfigurableGlobalVariable(simpleGlobalVar, initFunctionEnv);
        }
        if (Symbols.isFlagOn(globalVarFlags, 524288L) && this.containsErrorType(globalVar.expr.getBType())) {
            this.handleListenerWithErrorType(globalVar);
        }
        if ((typeNode = simpleGlobalVar.typeNode) != null && typeNode.getKind() != null) {
            this.rewrite(typeNode, initFunctionEnv);
        }
        this.addTypeDescStmtsToInitFunction(initFunctionEnv, desugaredGlobalVarList, initFnBody);
        this.addToInitFunction(simpleGlobalVar, initFnBody);
        desugaredGlobalVarList.add(simpleGlobalVar);
    }

    private void handleConfigurableGlobalVariable(BLangSimpleVariable simpleGlobalVar, SymbolEnv initFunctionEnv) {
        long globalVarFlags = simpleGlobalVar.symbol.flags;
        if (Symbols.isFlagOn(globalVarFlags, 256L)) {
            List<BLangExpression> args = this.getConfigurableLangLibInvocationParam(simpleGlobalVar);
            simpleGlobalVar.expr = this.createLangLibInvocationNode("getConfigurableValue", args, this.symTable.anydataType, simpleGlobalVar.pos);
        } else {
            simpleGlobalVar.expr = this.createIfElseFromConfigurable(simpleGlobalVar, initFunctionEnv);
        }
    }

    private void handleListenerWithErrorType(BLangVariable globalVar) {
        globalVar.expr = ASTBuilderUtil.createCheckExpr(globalVar.expr.pos, globalVar.expr, globalVar.getBType());
    }

    private boolean containsErrorType(BType type) {
        return this.types.containsErrorType(type);
    }

    private void addToGlobalVariableList(BLangStatement bLangStatement, BLangBlockFunctionBody initFnBody, BLangVariable globalVar, List<BLangVariable> desugaredGlobalVarList) {
        if (bLangStatement.getKind() == NodeKind.ASSIGNMENT || bLangStatement.getKind() == NodeKind.BLOCK) {
            initFnBody.stmts.add(bLangStatement);
            return;
        }
        if (bLangStatement.getKind() == NodeKind.VARIABLE_DEF) {
            BLangSimpleVariable simpleVar = ((BLangSimpleVariableDef)bLangStatement).var;
            if ((simpleVar.symbol.owner.tag & 0x1001L) != 4097L) {
                initFnBody.stmts.add(bLangStatement);
                return;
            }
            simpleVar.annAttachments = globalVar.getAnnotationAttachments();
            this.addToInitFunction(simpleVar, initFnBody);
            desugaredGlobalVarList.add(simpleVar);
        }
    }

    private void addToInitFunction(BLangSimpleVariable globalVar, BLangBlockFunctionBody initFnBody) {
        if (globalVar.expr == null) {
            return;
        }
        BLangAssignment assignment = this.createAssignmentStmt(globalVar);
        initFnBody.stmts.add(assignment);
        globalVar.expr = null;
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        BPackageSymbol pkgSymbol = importPkgNode.symbol;
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgSymbol);
        this.rewrite(pkgEnv.node, pkgEnv);
        this.result = importPkgNode;
    }

    @Override
    public void visit(BLangTypeDefinition typeDef) {
        BSymbol typeDefSymbol = typeDef.symbol;
        if (typeDefSymbol.kind == SymbolKind.TYPE_DEF && typeDefSymbol.origin != SymbolOrigin.VIRTUAL) {
            BTypeReferenceType referenceType = ((BTypeDefinitionSymbol)typeDefSymbol).referenceType;
            int typeTag = Types.getImpliedType((BType)referenceType).tag;
            if (typeTag == 12 || typeTag == 16 || typeTag == 31) {
                this.createTypedescVariable(referenceType, typeDefSymbol.pos);
            }
        }
        if (!Symbols.isFlagOn(typeDef.symbol.flags, 0x100000000000L)) {
            typeDef.typeNode = this.rewrite(typeDef.typeNode, this.env);
        }
        typeDef.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        this.result = typeDef;
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        finiteTypeNode.valueSpace.forEach(param -> this.rewrite(param, this.env));
        this.result = finiteTypeNode;
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        objectTypeNode.fields.forEach(field -> this.rewrite(field, this.env));
        objectTypeNode.fields.addAll(objectTypeNode.includedFields);
        this.result = objectTypeNode;
    }

    @Override
    public void visit(BLangClassDefinition classDef) {
        BLangClassDefinition classDefinition = classDef;
        if (classDef.flagSet.contains((Object)Flag.OBJECT_CTOR) && !classDef.definitionCompleted && classDef.cloneRef != null) {
            BLangClassDefinition originalClass = classDefinition.oceEnvData.originalClass;
            classDefinition = (BLangClassDefinition)originalClass.cloneRef;
        }
        classDefinition.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        classDefinition.fields.addAll(classDefinition.referencedFields);
        for (BLangSimpleVariable bLangSimpleVariable : classDefinition.fields) {
            bLangSimpleVariable.typeNode = this.rewrite(bLangSimpleVariable.typeNode, this.env);
        }
        BLangFunction generatedInitFunction = classDefinition.generatedInitFunction;
        if (classDef.flagSet.contains((Object)Flag.OBJECT_CTOR)) {
            generatedInitFunction.flagSet.add(Flag.OBJECT_CTOR);
            generatedInitFunction.parent = classDef;
            this.classClosureDesugar.desugar(classDef);
        }
        Map<BSymbol, BLangStatement> initFuncStmts = generatedInitFunction.initFunctionStmts;
        for (BLangSimpleVariable field : classDefinition.fields) {
            if (field.symbol.isDefaultable && field.expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangSimpleVarRef varRef = (BLangSimpleVarRef)field.expr;
                if (varRef.symbol.closure) {
                    this.visit((BLangSimpleVarRef)field.expr);
                    continue;
                }
            }
            if (initFuncStmts.containsKey(field.symbol) || field.expr == null) continue;
            initFuncStmts.put(field.symbol, this.createStructFieldUpdate(generatedInitFunction, field, generatedInitFunction.receiver.symbol));
        }
        BLangStatement[] initStmts = initFuncStmts.values().toArray(new BLangStatement[0]);
        BLangBlockFunctionBody generatedInitFnBody = (BLangBlockFunctionBody)generatedInitFunction.body;
        int i = generatedInitFnBody.stmts.size() - 1;
        int j = 0;
        int length = i + initStmts.length;
        while (i < length) {
            generatedInitFnBody.stmts.add(i, initStmts[j]);
            ++i;
            ++j;
        }
        if (classDefinition.initFunction != null) {
            ((BLangReturn)generatedInitFnBody.stmts.get((int)(generatedInitFnBody.stmts.size() - 1))).expr = this.createUserDefinedInitInvocation(classDefinition.pos, (BObjectTypeSymbol)classDefinition.symbol, generatedInitFunction);
        }
        for (BLangFunction fn : classDefinition.functions) {
            this.rewrite(fn, this.env);
        }
        this.rewrite(generatedInitFunction, this.env);
        this.rewrite(classDefinition.initFunction, this.env);
        this.result = classDefinition;
    }

    private BLangExpression createUserDefinedInitInvocation(Location location, BObjectTypeSymbol objectTypeSymbol, BLangFunction generatedInitFunction) {
        ArrayList<BLangExpression> paramRefs = new ArrayList<BLangExpression>(generatedInitFunction.requiredParams.size());
        for (BLangSimpleVariable var : generatedInitFunction.requiredParams) {
            paramRefs.add(ASTBuilderUtil.createVariableRef(location, var.symbol));
        }
        BLangInvocation invocation = ASTBuilderUtil.createInvocationExprMethod(null, objectTypeSymbol.initializerFunc.symbol, paramRefs, Collections.emptyList(), this.symResolver);
        if (generatedInitFunction.restParam != null) {
            BLangSimpleVarRef restVarRef = ASTBuilderUtil.createVariableRef(location, generatedInitFunction.restParam.symbol);
            invocation.restArgs.add(this.createRestArgsExpression(restVarRef));
        }
        invocation.exprSymbol = objectTypeSymbol.generatedInitializerFunc.symbol.receiverSymbol;
        return invocation;
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        this.createTypedescVariableForAnonType(recordTypeNode);
        recordTypeNode.fields.addAll(recordTypeNode.includedFields);
        BRecordTypeSymbol recordTypeSymbol = (BRecordTypeSymbol)recordTypeNode.getBType().tsymbol;
        for (BLangType type : recordTypeNode.typeRefs) {
            if (type.getBType().tag != 12) continue;
            BRecordTypeSymbol typeSymbol = (BRecordTypeSymbol)type.getBType().tsymbol;
            recordTypeSymbol.defaultValues.putAll(typeSymbol.defaultValues);
        }
        for (BLangSimpleVariable bLangSimpleVariable : recordTypeNode.fields) {
            bLangSimpleVariable.typeNode = this.rewrite(bLangSimpleVariable.typeNode, this.env);
        }
        recordTypeNode.restFieldType = this.rewrite(recordTypeNode.restFieldType, this.env);
        if (recordTypeNode.isAnonymous && recordTypeNode.isLocal) {
            BLangUserDefinedType userDefinedType = this.desugarLocalAnonRecordTypeNode(recordTypeNode);
            TypeDefBuilderHelper.createTypeDefinitionForTSymbol(recordTypeNode.getBType(), recordTypeNode.getBType().tsymbol, recordTypeNode, this.env);
            recordTypeNode.desugared = true;
            this.result = userDefinedType;
            return;
        }
        this.result = recordTypeNode;
    }

    private BLangUserDefinedType desugarLocalAnonRecordTypeNode(BLangRecordTypeNode recordTypeNode) {
        return ASTBuilderUtil.createUserDefineTypeNode(recordTypeNode.symbol.name.value, recordTypeNode.getBType(), recordTypeNode.pos);
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        arrayType.elemtype = this.rewrite(arrayType.elemtype, this.env);
        this.result = arrayType;
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        if (constrainedType.getBType() != null && constrainedType.getBType().tag == 16) {
            this.createTypedescVariableForAnonType(constrainedType);
        }
        constrainedType.constraint = this.rewrite(constrainedType.constraint, this.env);
        this.result = constrainedType;
    }

    @Override
    public void visit(BLangStreamType streamType) {
        streamType.constraint = this.rewrite(streamType.constraint, this.env);
        streamType.error = this.rewrite(streamType.error, this.env);
        this.result = streamType;
    }

    @Override
    public void visit(BLangTableTypeNode tableTypeNode) {
        tableTypeNode.constraint = this.rewrite(tableTypeNode.constraint, this.env);
        tableTypeNode.tableKeyTypeConstraint = this.rewrite(tableTypeNode.tableKeyTypeConstraint, this.env);
        this.result = tableTypeNode;
    }

    @Override
    public void visit(BLangTableKeyTypeConstraint keyTypeConstraint) {
        keyTypeConstraint.keyType = this.rewrite(keyTypeConstraint.keyType, this.env);
        this.result = keyTypeConstraint;
    }

    @Override
    public void visit(BLangValueType valueType) {
        this.result = valueType;
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
        this.result = userDefinedType;
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        ArrayList<BLangType> rewrittenMembers = new ArrayList<BLangType>();
        unionTypeNode.memberTypeNodes.forEach(typeNode -> rewrittenMembers.add(this.rewrite(typeNode, this.env)));
        unionTypeNode.memberTypeNodes = rewrittenMembers;
        this.result = unionTypeNode;
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
        int tag = Types.getImpliedType((BType)intersectionTypeNode.getBType()).tag;
        if (tag == 12 || tag == 31 || tag == 16) {
            this.createTypedescVariableForAnonType(intersectionTypeNode);
        }
        ArrayList<BLangType> rewrittenConstituents = new ArrayList<BLangType>();
        for (BLangType constituentTypeNode : intersectionTypeNode.constituentTypeNodes) {
            rewrittenConstituents.add(this.rewrite(constituentTypeNode, this.env));
        }
        intersectionTypeNode.constituentTypeNodes = rewrittenConstituents;
        this.result = intersectionTypeNode;
    }

    @Override
    public void visit(BLangErrorType errorType) {
        boolean hasTypeParam;
        errorType.detailType = this.rewrite(errorType.detailType, this.env);
        boolean bl = hasTypeParam = errorType.getDetailsTypeNode() != null;
        if (errorType.isLocal && errorType.isAnonymous && hasTypeParam) {
            BLangUserDefinedType userDefinedType = this.desugarLocalAnonRecordTypeNode(errorType);
            TypeDefBuilderHelper.createTypeDefinitionForTSymbol(errorType.getBType(), errorType.getBType().tsymbol, errorType, this.env);
            errorType.desugared = true;
            this.result = userDefinedType;
            return;
        }
        this.result = errorType;
    }

    private BLangUserDefinedType desugarLocalAnonRecordTypeNode(BLangErrorType errorTypeNode) {
        return ASTBuilderUtil.createUserDefineTypeNode(errorTypeNode.getBType().tsymbol.name.value, errorTypeNode.getBType(), errorTypeNode.pos);
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(functionTypeNode, functionTypeNode.getBType().tsymbol.scope, this.env);
        for (BLangSimpleVariable param : functionTypeNode.params) {
            this.rewrite(param, typeDefEnv);
        }
        if (functionTypeNode.restParam != null) {
            this.rewrite(functionTypeNode.restParam, typeDefEnv);
        }
        functionTypeNode.returnTypeNode = this.rewrite(functionTypeNode.returnTypeNode, typeDefEnv);
        this.result = functionTypeNode;
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode refTypeNode) {
        this.result = refTypeNode;
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        this.createTypedescVariableForAnonType(tupleTypeNode);
        tupleTypeNode.members.forEach(member -> {
            member.typeNode = this.rewrite(member.typeNode, this.env);
        });
        tupleTypeNode.restParamType = this.rewrite(tupleTypeNode.restParamType, this.env);
        this.result = tupleTypeNode;
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        body.stmts = this.rewriteStmt(body.stmts, bodyEnv);
        this.result = body;
    }

    @Override
    public void visit(BLangExprFunctionBody exprBody) {
        BLangBlockFunctionBody body = ASTBuilderUtil.createBlockFunctionBody(exprBody.pos, new ArrayList<BLangStatement>());
        BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(exprBody.pos, body);
        returnStmt.expr = this.rewriteExpr(exprBody.expr);
        this.result = body;
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
        for (BLangAnnotationAttachment attachment : body.annAttachments) {
            this.rewrite(attachment, this.env);
        }
        this.result = body;
    }

    @Override
    public void visit(BLangResourceFunction resourceFunction) {
        this.visit((BLangFunction)resourceFunction);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        BLangOnFailClause onFailClause = this.onFailClause;
        this.onFailClause = null;
        Map<Name, BLangStatement> prevXmlnsDecls = this.stmtsToBePropagatedToQuery;
        if (!funcNode.flagSet.contains((Object)Flag.QUERY_LAMBDA)) {
            this.stmtsToBePropagatedToQuery = new HashMap<Name, BLangStatement>();
        }
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        if (!funcNode.interfaceFunction) {
            this.addReturnIfNotPresent(funcNode);
        }
        funcNode.originalFuncSymbol = funcNode.symbol;
        funcNode.symbol = ASTBuilderUtil.duplicateInvokableSymbol(this.types.typeEnv(), funcNode.symbol);
        funcNode.requiredParams = this.rewrite(funcNode.requiredParams, funcEnv);
        funcNode.restParam = this.rewrite(funcNode.restParam, funcEnv);
        if (funcNode.returnTypeNode != null && funcNode.returnTypeNode.getKind() != null) {
            funcNode.returnTypeNode = this.rewrite(funcNode.returnTypeNode, funcEnv);
        }
        funcNode.body = this.rewrite(funcNode.body, funcEnv);
        funcNode.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        if (funcNode.returnTypeNode != null) {
            funcNode.returnTypeAnnAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        }
        this.stmtsToBePropagatedToQuery = prevXmlnsDecls;
        this.result = funcNode;
        this.onFailClause = onFailClause;
    }

    @Override
    public void visit(BLangInferredTypedescDefaultNode inferTypedescExpr) {
        BType constraintType = ((BTypedescType)inferTypedescExpr.getBType()).constraint;
        this.result = ASTBuilderUtil.createTypedescExpr(inferTypedescExpr.pos, inferTypedescExpr.getBType(), constraintType);
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        annotationNode.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        if (annAttachmentNode.expr == null && annAttachmentNode.annotationSymbol.attachedType != null) {
            BType attachedType = Types.getImpliedType(annAttachmentNode.annotationSymbol.attachedType);
            if (attachedType.tag != 33) {
                annAttachmentNode.expr = ASTBuilderUtil.createEmptyRecordLiteral(annAttachmentNode.pos, attachedType.tag == 20 ? ((BArrayType)attachedType).eType : attachedType);
            }
        }
        if (annAttachmentNode.expr != null) {
            annAttachmentNode.expr = this.rewrite(annAttachmentNode.expr, this.env);
            for (AttachPoint point : annAttachmentNode.annotationSymbol.points) {
                if (point.source) continue;
                annAttachmentNode.expr = this.visitCloneReadonly(annAttachmentNode.expr, annAttachmentNode.expr.getBType());
                break;
            }
        }
        this.result = annAttachmentNode;
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        BLangExpression bLangExpression;
        if (varNode.typeNode != null && varNode.typeNode.getKind() != null) {
            varNode.typeNode = this.rewrite(varNode.typeNode, this.env);
        }
        if (Symbols.isFlagOn(varNode.symbol.flags, 0x1000000000L)) {
            bLangExpression = varNode.expr;
        } else {
            bLangExpression = this.rewriteExpr(varNode.expr);
            if (bLangExpression != null) {
                bLangExpression = this.types.addConversionExprIfRequired(bLangExpression, varNode.getBType());
            }
        }
        varNode.expr = bLangExpression;
        varNode.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        this.result = varNode;
    }

    @Override
    public void visit(BLangLetExpression letExpression) {
        SymbolEnv prevEnv = this.env;
        letExpression.env.enclInvokable = this.env.enclInvokable;
        this.env = letExpression.env;
        BLangExpression expr = letExpression.expr;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(letExpression.pos);
        blockStmt.scope = letExpression.env.scope;
        blockStmt.isLetExpr = true;
        for (BLangLetVariable letVariable : letExpression.letVarDeclarations) {
            BLangNode node = this.rewrite((BLangNode)((Object)letVariable.definitionNode), this.env);
            if (node.getKind() == NodeKind.BLOCK) {
                blockStmt.stmts.addAll(((BLangBlockStmt)node).stmts);
                continue;
            }
            blockStmt.addStatement((BLangSimpleVariableDef)node);
        }
        BLangSimpleVariableDef tempVarDef = this.createVarDef(String.format("$let_var_%d_$", this.letCount++), expr.getBType(), expr, expr.pos);
        BLangSimpleVarRef tempVarRef = ASTBuilderUtil.createVariableRef(expr.pos, tempVarDef.var.symbol);
        blockStmt.addStatement(tempVarDef);
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, tempVarRef);
        stmtExpr.setBType(expr.getBType());
        this.result = this.rewrite(stmtExpr, this.env);
        this.env = prevEnv;
    }

    @Override
    public void visit(BLangTupleVariable varNode) {
        varNode.typeNode = this.rewrite(varNode.typeNode, this.env);
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(varNode.pos);
        String name = this.anonModelHelper.getNextTupleVarKey(this.env.enclPkg.packageID);
        BSymbol owner = varNode.symbol != null ? varNode.symbol.owner : this.env.scope.owner;
        BLangSimpleVariable tuple = ASTBuilderUtil.createVariable(varNode.pos, name, this.symTable.arrayAllType, null, new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, this.symTable.arrayAllType, owner, varNode.pos, SymbolOrigin.VIRTUAL));
        tuple.expr = varNode.expr;
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(varNode.pos, blockStmt);
        variableDef.var = tuple;
        this.createVarDefStmts(varNode, blockStmt, tuple.symbol, null);
        this.createRestFieldVarDefStmts(varNode, blockStmt, tuple.symbol, varNode.expr);
        this.result = this.rewrite(blockStmt, this.env);
    }

    @Override
    public void visit(BLangRecordVariable varNode) {
        varNode.typeNode = this.rewrite(varNode.typeNode, this.env);
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(varNode.pos);
        String name = this.anonModelHelper.getNextRecordVarKey(this.env.enclPkg.packageID);
        BSymbol owner = varNode.symbol != null ? varNode.symbol.owner : this.env.scope.owner;
        BLangSimpleVariable mapVariable = ASTBuilderUtil.createVariable(varNode.pos, name, this.symTable.mapAllType, null, new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, this.symTable.mapAllType, owner, varNode.pos, SymbolOrigin.VIRTUAL));
        mapVariable.expr = varNode.expr;
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(varNode.pos, blockStmt);
        variableDef.var = mapVariable;
        this.createVarDefStmts(varNode, blockStmt, mapVariable.symbol, null);
        this.result = this.rewrite(blockStmt, this.env);
    }

    @Override
    public void visit(BLangErrorVariable varNode) {
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(varNode.pos);
        BType errorType = varNode.getBType() == null ? this.symTable.errorType : varNode.getBType();
        String name = this.anonModelHelper.getNextErrorVarKey(this.env.enclPkg.packageID);
        BSymbol owner = varNode.symbol != null ? varNode.symbol.owner : this.env.scope.owner;
        BVarSymbol errorVarSymbol = new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, errorType, owner, varNode.pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable error = ASTBuilderUtil.createVariable(varNode.pos, name, errorType, null, errorVarSymbol);
        error.expr = varNode.expr;
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(varNode.pos, blockStmt);
        variableDef.var = error;
        this.createVarDefStmts(varNode, blockStmt, error.symbol, null);
        this.result = this.rewrite(blockStmt, this.env);
    }

    @Override
    public void visit(BLangBlockStmt block) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(block, this.env);
        block.stmts = this.rewriteStmt(block.stmts, blockEnv);
        this.result = block;
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        varDefNode.var = this.rewrite(varDefNode.var, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangTupleVariableDef varDefNode) {
        this.result = this.rewrite(varDefNode.var, this.env);
    }

    private void createRestFieldVarDefStmts(BLangTupleVariable parentTupleVariable, BLangBlockStmt blockStmt, BVarSymbol tupleVarSymbol, BLangExpression tupleExpr) {
        BLangSimpleVariable arrayVar = (BLangSimpleVariable)parentTupleVariable.restVariable;
        Location pos = blockStmt.pos;
        if (arrayVar != null) {
            boolean isIndexBasedAccessExpr;
            BLangListConstructorExpr.BLangArrayLiteral arrayExpr = this.createArrayLiteralExprNode();
            arrayExpr.setBType(arrayVar.getBType());
            arrayVar.expr = arrayExpr;
            BLangSimpleVariableDef arrayVarDef = ASTBuilderUtil.createVariableDefStmt(arrayVar.pos, blockStmt);
            arrayVarDef.var = arrayVar;
            BLangSimpleVarRef arrayVarRef = ASTBuilderUtil.createVariableRef(pos, arrayVar.symbol);
            BType restType = Types.getImpliedType(parentTupleVariable.restVariable.getBType());
            BLangExpression countExpr = ASTBuilderUtil.createLiteral(pos, this.symTable.intType, parentTupleVariable.memberVariables.size());
            boolean bl = isIndexBasedAccessExpr = tupleExpr.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR;
            if (restType.tag == 31) {
                BTupleType restTupleType = (BTupleType)restType;
                List<BType> restTupleMemberTypes = restTupleType.getTupleTypes();
                for (int index = 0; index < restTupleMemberTypes.size(); ++index) {
                    BLangLiteral indexExpr = ASTBuilderUtil.createLiteral(pos, this.symTable.intType, index);
                    BLangIndexBasedAccess tupleValueExpr = ASTBuilderUtil.createIndexAccessExpr(arrayVarRef, indexExpr);
                    tupleValueExpr.setBType(restTupleMemberTypes.get(index));
                    if (isIndexBasedAccessExpr) {
                        this.createAssignmentStmt(tupleValueExpr, blockStmt, countExpr, tupleVarSymbol, (BLangIndexBasedAccess)tupleExpr);
                    } else {
                        this.createAssignmentStmt(tupleValueExpr, blockStmt, countExpr, tupleVarSymbol, null);
                    }
                    countExpr = ASTBuilderUtil.createBinaryExpr(pos, countExpr, ASTBuilderUtil.createLiteral(pos, this.symTable.intType, 1L), this.symTable.intType, OperatorKind.ADD, null);
                }
                if (restTupleType.restType == null) {
                    return;
                }
            }
            BLangInvocation lengthInvocation = this.createLengthInvocation(pos, tupleExpr);
            BLangInvocation intRangeInvocation = this.replaceWithIntRange(pos, countExpr, this.getModifiedIntRangeEndExpr(lengthInvocation));
            BLangForeach foreach = (BLangForeach)TreeBuilder.createForeachNode();
            foreach.pos = pos;
            foreach.collection = intRangeInvocation;
            this.types.setForeachTypedBindingPatternType(foreach);
            BLangSimpleVariable foreachVariable = ASTBuilderUtil.createVariable(pos, "$foreach$i", foreach.varType);
            foreachVariable.symbol = new BVarSymbol(0L, this.names.fromIdNode(foreachVariable.name), this.env.scope.owner.pkgID, foreachVariable.getBType(), this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
            BLangSimpleVarRef foreachVarRef = ASTBuilderUtil.createVariableRef(pos, foreachVariable.symbol);
            foreach.variableDefinitionNode = ASTBuilderUtil.createVariableDef(pos, foreachVariable);
            foreach.isDeclaredWithVar = true;
            BLangBlockStmt foreachBody = ASTBuilderUtil.createBlockStmt(pos);
            BLangIndexBasedAccess indexAccessExpr = ASTBuilderUtil.createIndexAccessExpr(arrayVarRef, this.createLengthInvocation(pos, arrayVarRef));
            if (restType.tag == 31) {
                indexAccessExpr.setBType(((BTupleType)restType).restType);
            } else {
                indexAccessExpr.setBType(((BArrayType)restType).eType);
            }
            if (isIndexBasedAccessExpr) {
                this.createAssignmentStmt(indexAccessExpr, foreachBody, foreachVarRef, tupleVarSymbol, (BLangIndexBasedAccess)tupleExpr);
            } else {
                this.createAssignmentStmt(indexAccessExpr, foreachBody, foreachVarRef, tupleVarSymbol, null);
            }
            foreach.body = foreachBody;
            blockStmt.addStatement(foreach);
        }
    }

    @Override
    public void visit(BLangRecordVariableDef varDefNode) {
        this.result = this.rewrite(varDefNode.var, this.env);
    }

    @Override
    public void visit(BLangErrorVariableDef varDefNode) {
        this.result = this.rewrite(varDefNode.errorVariable, this.env);
    }

    private void createVarDefStmts(BLangTupleVariable parentTupleVariable, BLangBlockStmt parentBlockStmt, BVarSymbol tupleVarSymbol, BLangIndexBasedAccess parentIndexAccessExpr) {
        List<BLangVariable> memberVars = parentTupleVariable.memberVariables;
        for (int index = 0; index < memberVars.size(); ++index) {
            BLangVariable variable = memberVars.get(index);
            BLangLiteral indexExpr = ASTBuilderUtil.createLiteral(variable.pos, this.symTable.intType, index);
            if (NodeKind.VARIABLE == variable.getKind()) {
                this.createSimpleVarDefStmt((BLangSimpleVariable)variable, parentBlockStmt, indexExpr, tupleVarSymbol, parentIndexAccessExpr);
                continue;
            }
            if (variable.getKind() == NodeKind.TUPLE_VARIABLE) {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)variable;
                BLangIndexBasedAccess arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(tupleVariable.pos, new BArrayType(this.symTable.typeEnv(), this.symTable.anyType), tupleVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarDefStmts((BLangTupleVariable)variable, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
                this.createRestFieldVarDefStmts(tupleVariable, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
                continue;
            }
            if (variable.getKind() == NodeKind.RECORD_VARIABLE) {
                BLangIndexBasedAccess arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentTupleVariable.pos, this.symTable.mapType, tupleVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarDefStmts((BLangRecordVariable)variable, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
                continue;
            }
            if (variable.getKind() != NodeKind.ERROR_VARIABLE) continue;
            BType accessedElemType = this.symTable.errorType;
            BType tupleVarType = Types.getImpliedType(tupleVarSymbol.type);
            if (tupleVarType.tag == 20) {
                BArrayType arrayType = (BArrayType)tupleVarType;
                accessedElemType = arrayType.eType;
            }
            BLangIndexBasedAccess arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentTupleVariable.pos, accessedElemType, tupleVarSymbol, indexExpr);
            if (parentIndexAccessExpr != null) {
                arrayAccessExpr.expr = parentIndexAccessExpr;
            }
            this.createVarDefStmts((BLangErrorVariable)variable, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
        }
    }

    private void createVarDefStmts(BLangRecordVariable parentRecordVariable, BLangBlockStmt parentBlockStmt, BVarSymbol recordVarSymbol, BLangIndexBasedAccess parentIndexAccessExpr) {
        List<BLangRecordVariable.BLangRecordVariableKeyValue> variableList = parentRecordVariable.variableList;
        for (BLangRecordVariable.BLangRecordVariableKeyValue recordFieldKeyValue : variableList) {
            BLangIndexBasedAccess arrayAccessExpr;
            BLangVariable variable = recordFieldKeyValue.valueBindingPattern;
            BLangLiteral indexExpr = ASTBuilderUtil.createLiteral(variable.pos, this.symTable.stringType, Utils.unescapeJava((String)recordFieldKeyValue.key.value));
            if (recordFieldKeyValue.valueBindingPattern.getKind() == NodeKind.VARIABLE) {
                this.createSimpleVarDefStmt((BLangSimpleVariable)recordFieldKeyValue.valueBindingPattern, parentBlockStmt, indexExpr, recordVarSymbol, parentIndexAccessExpr);
                continue;
            }
            if (recordFieldKeyValue.valueBindingPattern.getKind() == NodeKind.TUPLE_VARIABLE) {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)recordFieldKeyValue.valueBindingPattern;
                BLangIndexBasedAccess arrayAccessExpr2 = ASTBuilderUtil.createIndexBasesAccessExpr(tupleVariable.pos, new BArrayType(this.symTable.typeEnv(), this.symTable.anyType), recordVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr2.expr = parentIndexAccessExpr;
                }
                this.createVarDefStmts((BLangTupleVariable)recordFieldKeyValue.valueBindingPattern, parentBlockStmt, recordVarSymbol, arrayAccessExpr2);
                continue;
            }
            if (recordFieldKeyValue.valueBindingPattern.getKind() == NodeKind.RECORD_VARIABLE) {
                arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentRecordVariable.pos, this.symTable.mapType, recordVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarDefStmts((BLangRecordVariable)recordFieldKeyValue.valueBindingPattern, parentBlockStmt, recordVarSymbol, arrayAccessExpr);
                continue;
            }
            if (variable.getKind() != NodeKind.ERROR_VARIABLE) continue;
            arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentRecordVariable.pos, variable.getBType(), recordVarSymbol, indexExpr);
            if (parentIndexAccessExpr != null) {
                arrayAccessExpr.expr = parentIndexAccessExpr;
            }
            this.createVarDefStmts((BLangErrorVariable)variable, parentBlockStmt, recordVarSymbol, arrayAccessExpr);
        }
        if (parentRecordVariable.restParam != null) {
            BLangSimpleVarRef variableReference;
            Location pos = parentBlockStmt.pos;
            BType restParamType = parentRecordVariable.restParam.getBType();
            if (parentIndexAccessExpr != null) {
                BLangSimpleVariable mapVariable = ASTBuilderUtil.createVariable(pos, "$map$_1", parentIndexAccessExpr.getBType(), null, new BVarSymbol(0L, Names.fromString("$map$_1"), this.env.scope.owner.pkgID, parentIndexAccessExpr.getBType(), this.env.scope.owner, pos, SymbolOrigin.VIRTUAL));
                mapVariable.expr = parentIndexAccessExpr;
                BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(pos, parentBlockStmt);
                variableDef.var = mapVariable;
                variableReference = ASTBuilderUtil.createVariableRef(pos, mapVariable.symbol);
            } else {
                variableReference = ASTBuilderUtil.createVariableRef(pos, ((BLangSimpleVariableDef)parentBlockStmt.stmts.get((int)0)).var.symbol);
            }
            List<String> keysToRemove = parentRecordVariable.variableList.stream().map(var -> var.getKey().getValue()).toList();
            BLangSimpleVariable filteredDetail = this.generateRestFilter(variableReference, pos, keysToRemove, restParamType, parentBlockStmt);
            BLangSimpleVarRef varRef = ASTBuilderUtil.createVariableRef(pos, filteredDetail.symbol);
            BLangSimpleVariable restParam = (BLangSimpleVariable)parentRecordVariable.restParam;
            BLangSimpleVariableDef restParamVarDef = ASTBuilderUtil.createVariableDefStmt(pos, parentBlockStmt);
            restParamVarDef.var = restParam;
            restParamVarDef.var.setBType(restParamType);
            restParam.expr = varRef;
        }
    }

    private void createVarDefStmts(BLangErrorVariable parentErrorVariable, BLangBlockStmt parentBlockStmt, BVarSymbol errorVariableSymbol, BLangIndexBasedAccess parentIndexBasedAccess) {
        BVarSymbol convertedErrorVarSymbol;
        BLangStatement errorVarDef;
        if (parentIndexBasedAccess != null) {
            BType prevType = parentIndexBasedAccess.getBType();
            parentIndexBasedAccess.setBType(this.symTable.anyType);
            errorVarDef = this.createVarDef("$error$_" + this.errorCount++, this.symTable.errorType, this.types.addConversionExprIfRequired(parentIndexBasedAccess, this.symTable.errorType), parentErrorVariable.pos);
            parentIndexBasedAccess.setBType(prevType);
            parentBlockStmt.addStatement(errorVarDef);
            convertedErrorVarSymbol = errorVarDef.var.symbol;
        } else {
            convertedErrorVarSymbol = errorVariableSymbol;
        }
        if (parentErrorVariable.message != null) {
            parentErrorVariable.message.expr = this.generateErrorMessageBuiltinFunction(parentErrorVariable.message.pos, parentErrorVariable.message.getBType(), convertedErrorVarSymbol, null);
            if (this.names.fromIdNode(parentErrorVariable.message.name) == Names.IGNORE) {
                parentErrorVariable.message = null;
            } else {
                BLangSimpleVariableDef messageVariableDef = ASTBuilderUtil.createVariableDefStmt(parentErrorVariable.message.pos, parentBlockStmt);
                messageVariableDef.var = parentErrorVariable.message;
            }
        }
        if (parentErrorVariable.cause != null) {
            parentErrorVariable.cause.expr = this.generateErrorCauseLanglibFunction(parentErrorVariable.cause.pos, parentErrorVariable.cause.getBType(), convertedErrorVarSymbol, null);
            BLangVariable errorCause = parentErrorVariable.cause;
            if (errorCause.getKind() == NodeKind.ERROR_VARIABLE) {
                errorVarDef = ASTBuilderUtil.createErrorVariableDef(errorCause.pos, (BLangErrorVariable)errorCause);
                BLangSimpleVariableDef blockStatementNode = this.rewrite(errorVarDef, this.env);
                List<BLangStatement> statements = ((BLangBlockStmt)((Object)blockStatementNode)).stmts;
                for (BLangStatement statement : statements) {
                    parentBlockStmt.addStatement(statement);
                }
            } else {
                BLangSimpleVariableDef causeVariableDef = ASTBuilderUtil.createVariableDefStmt(parentErrorVariable.cause.pos, parentBlockStmt);
                causeVariableDef.var = (BLangSimpleVariable)parentErrorVariable.cause;
            }
        }
        if ((parentErrorVariable.detail == null || parentErrorVariable.detail.isEmpty()) && parentErrorVariable.restDetail == null) {
            return;
        }
        parentErrorVariable.detailExpr = this.generateErrorDetailBuiltinFunction(parentErrorVariable.pos, convertedErrorVarSymbol, null);
        BLangSimpleVariableDef detailTempVarDef = this.createVarDef("$error$detail_" + this.errorDetailCount++, parentErrorVariable.detailExpr.getBType(), parentErrorVariable.detailExpr, parentErrorVariable.pos);
        detailTempVarDef.var.symbol.owner = errorVariableSymbol.owner;
        detailTempVarDef.setBType(parentErrorVariable.detailExpr.getBType());
        parentBlockStmt.addStatement(detailTempVarDef);
        this.env.scope.define(this.names.fromIdNode(detailTempVarDef.var.name), detailTempVarDef.var.symbol);
        for (BLangErrorVariable.BLangErrorDetailEntry detailEntry : parentErrorVariable.detail) {
            BLangExpression detailEntryVar = this.createErrorDetailVar(detailEntry, detailTempVarDef.var.symbol);
            this.createAndAddBoundVariableDef(parentBlockStmt, detailEntry, detailEntryVar);
        }
        if (parentErrorVariable.restDetail != null && !parentErrorVariable.restDetail.name.value.equals(Names.IGNORE.value)) {
            Location pos = parentErrorVariable.restDetail.pos;
            BLangSimpleVarRef detailVarRef = ASTBuilderUtil.createVariableRef(pos, detailTempVarDef.var.symbol);
            List<String> keysToRemove = parentErrorVariable.detail.stream().map(detail -> detail.key.getValue()).toList();
            BLangSimpleVariable filteredDetail = this.generateRestFilter(detailVarRef, parentErrorVariable.pos, keysToRemove, parentErrorVariable.restDetail.getBType(), parentBlockStmt);
            BLangSimpleVariableDef variableDefStmt = ASTBuilderUtil.createVariableDefStmt(pos, parentBlockStmt);
            variableDefStmt.var = ASTBuilderUtil.createVariable(pos, parentErrorVariable.restDetail.name.value, filteredDetail.getBType(), ASTBuilderUtil.createVariableRef(pos, filteredDetail.symbol), parentErrorVariable.restDetail.symbol);
        }
    }

    private BLangSimpleVariableDef forceCastIfApplicable(BVarSymbol errorVarySymbol, Location pos, BType targetType) {
        BVarSymbol errorVarSym = new BVarSymbol(1L, Names.fromString("$cast$temp$"), this.env.enclPkg.packageID, targetType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVarRef variableRef = ASTBuilderUtil.createVariableRef(pos, errorVarySymbol);
        BLangExpression expr = targetType.tag == 12 ? variableRef : this.types.addConversionExprIfRequired(variableRef, targetType);
        BLangSimpleVariable errorVar = ASTBuilderUtil.createVariable(pos, errorVarSym.name.value, targetType, expr, errorVarSym);
        return ASTBuilderUtil.createVariableDef(pos, errorVar);
    }

    private BType getRestFilterConstraintType(BType targetType) {
        BType constraintType;
        targetType = Types.getImpliedType(targetType);
        if (targetType.tag == 12) {
            BRecordType recordType = (BRecordType)targetType;
            Map<String, BField> remainingFields = recordType.fields.entrySet().stream().filter(entry -> Types.getImpliedType((BType)((BField)entry.getValue()).type).tag != 50).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            constraintType = this.symbolEnter.getRestMatchPatternConstraintType(recordType, remainingFields, recordType.restFieldType);
        } else {
            constraintType = ((BMapType)targetType).constraint;
        }
        return constraintType;
    }

    private BLangSimpleVariable generateRestFilter(BLangSimpleVarRef mapVarRef, Location pos, List<String> keysToRemove, BType targetType, BLangBlockStmt parentBlockStmt) {
        BLangSimpleVariable filtered;
        BLangExpression typeCastExpr = this.types.addConversionExprIfRequired(mapVarRef, targetType);
        int restNum = this.annonVarCount++;
        String name = "$map$ref$_" + restNum;
        BLangSimpleVariable mapVariable = this.defVariable(pos, targetType, parentBlockStmt, typeCastExpr, name);
        BLangInvocation entriesInvocation = this.generateMapEntriesInvocation(ASTBuilderUtil.createVariableRef(pos, mapVariable.symbol), typeCastExpr.getBType());
        String entriesVarName = "$map$ref$entries$_" + restNum;
        BType constraintType = this.getRestFilterConstraintType(targetType);
        BVarSymbol varSymbol = new BVarSymbol(constraintType.getFlags(), null, null, constraintType, null, null, null);
        BVarSymbol stringVarSymbol = new BVarSymbol(0L, null, null, this.symTable.stringType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        BMapType entriesType = new BMapType(this.symTable.typeEnv(), 16, new BTupleType(this.symTable.typeEnv(), Arrays.asList(new BTupleMember(this.symTable.stringType, stringVarSymbol), new BTupleMember(constraintType, varSymbol))), null);
        BLangSimpleVariable entriesInvocationVar = this.defVariable(pos, entriesType, parentBlockStmt, this.types.addConversionExprIfRequired(entriesInvocation, entriesType), entriesVarName);
        BLangLambdaFunction filter = this.createFuncToFilterOutRestParam(keysToRemove, pos);
        BLangInvocation filterInvocation = this.generateMapFilterInvocation(pos, entriesInvocationVar, filter);
        String filteredEntriesName = "$filtered$detail$entries" + restNum;
        BLangSimpleVariable filteredVar = this.defVariable(pos, entriesType, parentBlockStmt, filterInvocation, filteredEntriesName);
        String filteredVarName = "$detail$filtered" + restNum;
        BLangLambdaFunction backToMapLambda = this.generateEntriesToMapLambda(pos, constraintType);
        BLangInvocation mapInvocation = this.generateMapMapInvocation(pos, filteredVar, backToMapLambda);
        BLangSimpleVariable converted = filtered = this.defVariable(pos, targetType, parentBlockStmt, mapInvocation, filteredVarName);
        if (Types.getImpliedType((BType)targetType).tag == 12) {
            String filteredRecVarName = "$filteredRecord";
            BLangInvocation recordConversion = this.generateCreateRecordValueInvocation(pos, targetType, filtered.symbol);
            converted = this.defVariable(pos, targetType, parentBlockStmt, recordConversion, filteredRecVarName);
        }
        String filteredRestVarName = "$restVar$_" + restNum;
        return this.defVariable(pos, targetType, parentBlockStmt, this.types.addConversionExprIfRequired(ASTBuilderUtil.createVariableRef(pos, converted.symbol), targetType), filteredRestVarName);
    }

    private BLangInvocation generateMapEntriesInvocation(BLangExpression expr, BType type) {
        BLangInvocation invocationNode = this.createInvocationNode("entries", new ArrayList<BLangExpression>(), type);
        invocationNode.expr = expr;
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(type, Names.fromString("entries"), this.env);
        invocationNode.requiredArgs = Lists.of(expr);
        invocationNode.setBType(invocationNode.symbol.type.getReturnType());
        invocationNode.langLibInvocation = true;
        return invocationNode;
    }

    private BLangInvocation generateMapMapInvocation(Location pos, BLangSimpleVariable filteredVar, BLangLambdaFunction backToMapLambda) {
        BLangInvocation invocationNode = this.createInvocationNode(XML_MAP, new ArrayList<BLangExpression>(), filteredVar.getBType());
        invocationNode.expr = ASTBuilderUtil.createVariableRef(pos, filteredVar.symbol);
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(filteredVar.getBType(), Names.fromString(XML_MAP), this.env);
        invocationNode.requiredArgs = Lists.of(ASTBuilderUtil.createVariableRef(pos, filteredVar.symbol));
        invocationNode.setBType(invocationNode.symbol.type.getReturnType());
        invocationNode.requiredArgs.add(backToMapLambda);
        return invocationNode;
    }

    private BLangLambdaFunction generateEntriesToMapLambda(Location pos, BType constraint) {
        String anonfuncName = "$anonGetValFunc$_" + this.lambdaFunctionCount++;
        BLangFunction function = ASTBuilderUtil.createFunction(pos, anonfuncName);
        BVarSymbol keyValSymbol = new BVarSymbol(0L, Names.fromString("$lambdaArg$_0"), this.env.scope.owner.pkgID, this.getStringAnyTupleType(), this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable inputParameter = ASTBuilderUtil.createVariable(pos, null, this.getStringAnyTupleType(), null, keyValSymbol);
        function.requiredParams.add(inputParameter);
        BLangUserDefinedType constraintTypeNode = (BLangUserDefinedType)TreeBuilder.createUserDefinedTypeNode();
        constraintTypeNode.setBType(constraint);
        function.returnTypeNode = constraintTypeNode;
        BLangBlockFunctionBody functionBlock = ASTBuilderUtil.createBlockFunctionBody(pos, new ArrayList<BLangStatement>());
        function.body = functionBlock;
        BLangIndexBasedAccess indexBasesAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(pos, constraint, keyValSymbol, ASTBuilderUtil.createLiteral(pos, this.symTable.intType, 1L));
        BLangSimpleVariableDef tupSecondElem = this.createVarDef("$val", indexBasesAccessExpr.getBType(), indexBasesAccessExpr, pos);
        functionBlock.addStatement(tupSecondElem);
        BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(pos, functionBlock);
        returnStmt.expr = ASTBuilderUtil.createVariableRef(pos, tupSecondElem.var.symbol);
        BInvokableSymbol functionSymbol = Symbols.createFunctionSymbol(Flags.asMask(function.flagSet), new Name(function.name.value), new Name(function.name.originalValue), this.env.enclPkg.packageID, function.getBType(), this.env.enclEnv.enclVarSym, true, function.pos, SymbolOrigin.VIRTUAL);
        functionSymbol.originalName = new Name(function.name.originalValue);
        functionSymbol.retType = function.returnTypeNode.getBType();
        functionSymbol.params = function.requiredParams.stream().map(param -> param.symbol).toList();
        functionSymbol.scope = this.env.scope;
        functionSymbol.type = new BInvokableType(this.symTable.typeEnv(), Collections.singletonList(this.getStringAnyTupleType()), constraint, null);
        function.symbol = functionSymbol;
        this.rewrite(function, this.env);
        this.env.enclPkg.addFunction(function);
        return this.createLambdaFunction(function, functionSymbol, this.env);
    }

    private BLangInvocation generateMapFilterInvocation(Location pos, BLangSimpleVariable entriesInvocationVar, BLangLambdaFunction filter) {
        BLangInvocation invocationNode = this.createInvocationNode("filter", new ArrayList<BLangExpression>(), entriesInvocationVar.getBType());
        invocationNode.expr = ASTBuilderUtil.createVariableRef(pos, entriesInvocationVar.symbol);
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(entriesInvocationVar.getBType(), Names.fromString("filter"), this.env);
        invocationNode.requiredArgs = Lists.of(ASTBuilderUtil.createVariableRef(pos, entriesInvocationVar.symbol));
        invocationNode.setBType(invocationNode.symbol.type.getReturnType());
        invocationNode.requiredArgs.add(filter);
        return invocationNode;
    }

    private BLangSimpleVariable defVariable(Location pos, BType varType, BLangBlockStmt parentBlockStmt, BLangExpression expression, String name) {
        Name varName = Names.fromString(name);
        BLangSimpleVariable detailMap = ASTBuilderUtil.createVariable(pos, name, varType, expression, new BVarSymbol(1L, varName, this.env.enclPkg.packageID, varType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL));
        BLangSimpleVariableDef constructedMap = ASTBuilderUtil.createVariableDef(pos, detailMap);
        constructedMap.setBType(varType);
        parentBlockStmt.addStatement(constructedMap);
        this.env.scope.define(varName, detailMap.symbol);
        return detailMap;
    }

    private void createAndAddBoundVariableDef(BLangBlockStmt parentBlockStmt, BLangErrorVariable.BLangErrorDetailEntry detailEntry, BLangExpression detailEntryVar) {
        BLangVariable valueBindingPattern = detailEntry.valueBindingPattern;
        NodeKind valueBindingPatternKind = valueBindingPattern.getKind();
        if (valueBindingPatternKind == NodeKind.VARIABLE) {
            BLangSimpleVariableDef errorDetailVar = this.createVarDef(((BLangSimpleVariable)valueBindingPattern).name.value, valueBindingPattern.getBType(), detailEntryVar, valueBindingPattern.pos);
            errorDetailVar.var.symbol = valueBindingPattern.symbol;
            parentBlockStmt.addStatement(errorDetailVar);
            return;
        }
        valueBindingPattern.expr = detailEntryVar;
        BLangVariable blockStatementNode = this.rewrite(valueBindingPattern, this.env);
        List<BLangStatement> statements = ((BLangBlockStmt)((Object)blockStatementNode)).stmts;
        for (BLangStatement statement : statements) {
            parentBlockStmt.addStatement(statement);
        }
    }

    private BLangExpression createErrorDetailVar(BLangErrorVariable.BLangErrorDetailEntry detailEntry, BVarSymbol tempDetailVarSymbol) {
        BLangExpression detailEntryVar = this.createIndexBasedAccessExpr(detailEntry.valueBindingPattern.getBType(), detailEntry.valueBindingPattern.pos, this.createStringLiteral(detailEntry.key.pos, detailEntry.key.value), tempDetailVarSymbol, null);
        if (detailEntryVar.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
            BLangIndexBasedAccess bLangIndexBasedAccess = (BLangIndexBasedAccess)detailEntryVar;
            bLangIndexBasedAccess.originalType = this.symTable.cloneableType;
        }
        return detailEntryVar;
    }

    private BLangExpression constructStringTemplateConcatExpression(List<BLangExpression> exprs) {
        BLangExpression concatExpr = null;
        Iterator<BLangExpression> iterator = exprs.iterator();
        while (iterator.hasNext()) {
            BLangExpression expr;
            BLangExpression currentExpr = expr = iterator.next();
            int exprTypeTag = Types.getImpliedType((BType)expr.getBType()).tag;
            if (exprTypeTag != 5 && exprTypeTag != 8) {
                currentExpr = this.getToStringInvocationOnExpr(expr);
            }
            if (concatExpr == null) {
                concatExpr = currentExpr;
                continue;
            }
            BType binaryExprType = TypeTags.isXMLTypeTag(Types.getImpliedType((BType)concatExpr.getBType()).tag) || TypeTags.isXMLTypeTag(Types.getImpliedType((BType)currentExpr.getBType()).tag) ? this.symTable.xmlType : this.symTable.stringType;
            concatExpr = ASTBuilderUtil.createBinaryExpr(concatExpr.pos, concatExpr, currentExpr, binaryExprType, OperatorKind.ADD, null);
        }
        return concatExpr;
    }

    private BLangInvocation getToStringInvocationOnExpr(final BLangExpression expression) {
        final BInvokableSymbol symbol = (BInvokableSymbol)this.symTable.langValueModuleSymbol.scope.lookup((Name)Names.fromString((String)TO_STRING_FUNCTION_NAME)).symbol;
        ArrayList<BLangExpression> requiredArgs = new ArrayList<BLangExpression>(){
            {
                this.add(Desugar.this.types.addConversionExprIfRequired(expression, symbol.params.get((int)0).type));
            }
        };
        return ASTBuilderUtil.createInvocationExprMethod(expression.pos, symbol, (List<BLangExpression>)requiredArgs, new ArrayList<BLangSimpleVariable>(), this.symResolver);
    }

    private BLangInvocation generateErrorDetailBuiltinFunction(Location pos, BVarSymbol errorVarySymbol, BLangIndexBasedAccess parentIndexBasedAccess) {
        BLangIndexBasedAccess onExpr = parentIndexBasedAccess != null ? parentIndexBasedAccess : ASTBuilderUtil.createVariableRef(pos, errorVarySymbol);
        return this.createLangLibInvocationNode(ERROR_DETAIL_FUNCTION_NAME, onExpr, new ArrayList<BLangExpression>(), null, pos);
    }

    private BLangInvocation generateErrorMessageBuiltinFunction(Location pos, BType reasonType, BVarSymbol errorVarSymbol, BLangIndexBasedAccess parentIndexBasedAccess) {
        BLangValueExpression onExpr = parentIndexBasedAccess != null ? parentIndexBasedAccess : ASTBuilderUtil.createVariableRef(pos, errorVarSymbol);
        return this.createLangLibInvocationNode(ERROR_MESSAGE_FUNCTION_NAME, onExpr, new ArrayList<BLangExpression>(), reasonType, pos);
    }

    private BLangInvocation generateErrorCauseLanglibFunction(Location pos, BType causeType, BVarSymbol errorVarSymbol, BLangIndexBasedAccess parentIndexBasedAccess) {
        BLangValueExpression onExpr = parentIndexBasedAccess != null ? parentIndexBasedAccess : ASTBuilderUtil.createVariableRef(pos, errorVarSymbol);
        return this.createLangLibInvocationNode(ERROR_CAUSE_FUNCTION_NAME, onExpr, new ArrayList<BLangExpression>(), causeType, pos);
    }

    private BLangInvocation generateCreateRecordValueInvocation(Location pos, BType targetType, BVarSymbol source) {
        BTypedescType typedescType = new BTypedescType(this.symTable.typeEnv(), targetType, this.symTable.typeDesc.tsymbol);
        BLangInvocation invocationNode = this.createInvocationNode(CREATE_RECORD_VALUE, new ArrayList<BLangExpression>(), typedescType);
        BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
        typedescExpr.resolvedType = targetType;
        typedescExpr.setBType(typedescType);
        invocationNode.expr = typedescExpr;
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(typedescType, Names.fromString(CREATE_RECORD_VALUE), this.env);
        invocationNode.requiredArgs = Lists.of(ASTBuilderUtil.createVariableRef(pos, source), typedescExpr);
        invocationNode.setBType(BUnionType.create(this.symTable.typeEnv(), null, targetType, this.symTable.errorType));
        return invocationNode;
    }

    private BLangInvocation generateCloneWithTypeInvocation(Location pos, BType targetType, BVarSymbol source) {
        BTypedescType typedescType = new BTypedescType(this.symTable.typeEnv(), targetType, this.symTable.typeDesc.tsymbol);
        BLangInvocation invocationNode = this.createInvocationNode(CLONE_WITH_TYPE, new ArrayList<BLangExpression>(), typedescType);
        BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
        typedescExpr.resolvedType = targetType;
        typedescExpr.setBType(typedescType);
        invocationNode.expr = typedescExpr;
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(typedescType, Names.fromString(CLONE_WITH_TYPE), this.env);
        invocationNode.requiredArgs = Lists.of(ASTBuilderUtil.createVariableRef(pos, source), typedescExpr);
        invocationNode.setBType(BUnionType.create(this.symTable.typeEnv(), null, targetType, this.symTable.errorType));
        return invocationNode;
    }

    private BLangLambdaFunction createFuncToFilterOutRestParam(List<String> toRemoveList, Location pos) {
        String anonfuncName = "$anonRestParamFilterFunc$_" + this.lambdaFunctionCount++;
        BLangFunction function = ASTBuilderUtil.createFunction(pos, anonfuncName);
        BVarSymbol keyValSymbol = new BVarSymbol(0L, Names.fromString("$lambdaArg$_0"), this.env.scope.owner.pkgID, this.getStringAnyTupleType(), this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangBlockFunctionBody functionBlock = this.createAnonymousFunctionBlock(pos, function, keyValSymbol);
        BLangIndexBasedAccess indexBasesAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(pos, this.symTable.anyType, keyValSymbol, ASTBuilderUtil.createLiteral(pos, this.symTable.intType, 0L));
        BLangSimpleVariableDef tupFirstElem = this.createVarDef("$key", indexBasesAccessExpr.getBType(), indexBasesAccessExpr, pos);
        functionBlock.addStatement(tupFirstElem);
        for (String toRemoveItem : toRemoveList) {
            this.createIfStmt(pos, tupFirstElem.var.symbol, functionBlock, toRemoveItem);
        }
        BInvokableSymbol functionSymbol = this.createReturnTrueStatement(pos, function, functionBlock);
        return this.createLambdaFunction(function, functionSymbol, this.env);
    }

    private BLangLambdaFunction createFuncToFilterOutRestParam(BLangRecordVariable recordVariable, Location location) {
        List<String> fieldNamesToRemove = recordVariable.variableList.stream().map(var -> var.getKey().getValue()).toList();
        return this.createFuncToFilterOutRestParam(fieldNamesToRemove, location);
    }

    private void createIfStmt(Location location, BVarSymbol inputParamSymbol, BLangBlockFunctionBody blockStmt, String key) {
        BLangSimpleVarRef firstElemRef = ASTBuilderUtil.createVariableRef(location, inputParamSymbol);
        BLangExpression converted = this.types.addConversionExprIfRequired(firstElemRef, this.symTable.stringType);
        BLangIf ifStmt = ASTBuilderUtil.createIfStmt(location, blockStmt);
        BLangBlockStmt ifBlock = ASTBuilderUtil.createBlockStmt(location, new ArrayList<BLangStatement>());
        BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(location, ifBlock);
        returnStmt.expr = ASTBuilderUtil.createLiteral(location, this.symTable.booleanType, false);
        ifStmt.body = ifBlock;
        BLangGroupExpr groupExpr = new BLangGroupExpr();
        groupExpr.setBType(this.symTable.booleanType);
        BLangBinaryExpr binaryExpr = ASTBuilderUtil.createBinaryExpr(location, converted, ASTBuilderUtil.createLiteral(location, this.symTable.stringType, key), this.symTable.booleanType, OperatorKind.EQUAL, null);
        binaryExpr.opSymbol = (BOperatorSymbol)this.symResolver.resolveBinaryOperator(binaryExpr.opKind, binaryExpr.lhsExpr.getBType(), binaryExpr.rhsExpr.getBType());
        groupExpr.expression = binaryExpr;
        ifStmt.expr = groupExpr;
    }

    BLangLambdaFunction createLambdaFunction(BLangFunction function, BInvokableSymbol functionSymbol, SymbolEnv env) {
        BLangLambdaFunction lambdaFunction = (BLangLambdaFunction)TreeBuilder.createLambdaFunctionNode();
        lambdaFunction.function = function;
        lambdaFunction.setBType(functionSymbol.type);
        lambdaFunction.capturedClosureEnv = env;
        return lambdaFunction;
    }

    private BInvokableSymbol createReturnTrueStatement(Location pos, BLangFunction function, BLangBlockFunctionBody functionBlock) {
        BLangReturn trueReturnStmt = ASTBuilderUtil.createReturnStmt(pos, functionBlock);
        trueReturnStmt.expr = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true);
        BInvokableSymbol functionSymbol = Symbols.createFunctionSymbol(Flags.asMask(function.flagSet), new Name(function.name.value), new Name(function.name.originalValue), this.env.enclPkg.packageID, function.getBType(), this.env.enclEnv.enclVarSym, true, function.pos, SymbolOrigin.VIRTUAL);
        functionSymbol.originalName = new Name(function.name.originalValue);
        functionSymbol.retType = function.returnTypeNode.getBType();
        functionSymbol.params = function.requiredParams.stream().map(param -> param.symbol).toList();
        functionSymbol.scope = this.env.scope;
        functionSymbol.type = new BInvokableType(this.symTable.typeEnv(), Collections.singletonList(this.getStringAnyTupleType()), this.getRestType(functionSymbol), this.symTable.booleanType, null);
        function.symbol = functionSymbol;
        this.rewrite(function, this.env);
        this.env.enclPkg.addFunction(function);
        return functionSymbol;
    }

    private BLangBlockFunctionBody createAnonymousFunctionBlock(Location pos, BLangFunction function, BVarSymbol keyValSymbol) {
        BLangSimpleVariable inputParameter = ASTBuilderUtil.createVariable(pos, null, this.getStringAnyTupleType(), null, keyValSymbol);
        function.requiredParams.add(inputParameter);
        BLangValueType booleanTypeKind = new BLangValueType();
        booleanTypeKind.typeKind = TypeKind.BOOLEAN;
        booleanTypeKind.setBType(this.symTable.booleanType);
        function.returnTypeNode = booleanTypeKind;
        BLangBlockFunctionBody functionBlock = ASTBuilderUtil.createBlockFunctionBody(pos, new ArrayList<BLangStatement>());
        function.body = functionBlock;
        return functionBlock;
    }

    private BTupleType getStringAnyTupleType() {
        final BVarSymbol stringVarSymbol = new BVarSymbol(0L, null, null, this.symTable.stringType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        final BVarSymbol anyVarSymbol = new BVarSymbol(0L, null, null, this.symTable.anyType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        ArrayList<BTupleMember> typeList = new ArrayList<BTupleMember>(){
            {
                this.add(new BTupleMember(Desugar.this.symTable.stringType, stringVarSymbol));
                this.add(new BTupleMember(Desugar.this.symTable.anyType, anyVarSymbol));
            }
        };
        return new BTupleType(this.symTable.typeEnv(), (List<BTupleMember>)typeList);
    }

    private void createSimpleVarDefStmt(BLangSimpleVariable simpleVariable, BLangBlockStmt parentBlockStmt, BLangLiteral indexExpr, BVarSymbol tupleVarSymbol, BLangIndexBasedAccess parentArrayAccessExpr) {
        Name varName = this.names.fromIdNode(simpleVariable.name);
        if (varName == Names.IGNORE) {
            return;
        }
        BLangSimpleVariableDef simpleVariableDef = ASTBuilderUtil.createVariableDefStmt(simpleVariable.pos, parentBlockStmt);
        simpleVariableDef.var = simpleVariable;
        simpleVariable.expr = this.createIndexBasedAccessExpr(simpleVariable.getBType(), simpleVariable.pos, indexExpr, tupleVarSymbol, parentArrayAccessExpr);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        boolean addNilToCastingType = Desugar.shouldWidenExpressionTypeWithNil(assignNode);
        assignNode.varRef = this.rewriteExpr(assignNode.varRef);
        assignNode.expr = this.rewriteExpr(assignNode.expr);
        BType castingType = assignNode.varRef.getBType();
        if (addNilToCastingType) {
            castingType = this.types.addNilForNillableAccessType(castingType);
        }
        assignNode.expr = this.types.addConversionExprIfRequired(this.rewriteExpr(assignNode.expr), castingType);
        this.result = assignNode;
    }

    private static boolean shouldWidenExpressionTypeWithNil(BLangAssignment assignNode) {
        if (!assignNode.expr.getBType().isNullable() || !CompilerUtils.isAssignmentToOptionalField(assignNode)) {
            return false;
        }
        BLangFieldBasedAccess fieldAccessNode = (BLangFieldBasedAccess)assignNode.varRef;
        BRecordType recordType = (BRecordType)Types.getImpliedType(fieldAccessNode.expr.getBType());
        BField field = (BField)recordType.fields.get(fieldAccessNode.field.value);
        BType fieldType = Types.getImpliedType(field.getType());
        return TypeTags.isSimpleBasicType(fieldType.tag);
    }

    @Override
    public void visit(BLangTupleDestructure tupleDestructure) {
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(tupleDestructure.pos);
        BArrayType runTimeType = new BArrayType(this.symTable.typeEnv(), this.symTable.anyType);
        String name = "tuple";
        BLangSimpleVariable tuple = ASTBuilderUtil.createVariable(tupleDestructure.pos, name, runTimeType, null, new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, runTimeType, this.env.scope.owner, tupleDestructure.pos, SymbolOrigin.VIRTUAL));
        tuple.expr = tupleDestructure.expr;
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(tupleDestructure.pos, blockStmt);
        variableDef.var = tuple;
        this.createVarRefAssignmentStmts(tupleDestructure.varRef, blockStmt, tuple.symbol, null);
        this.createRestFieldAssignmentStmt(tupleDestructure.varRef, blockStmt, tuple.symbol, tupleDestructure.expr);
        this.result = this.rewrite(blockStmt, this.env);
    }

    private void createRestFieldAssignmentStmt(BLangTupleVarRef tupleVarRef, BLangBlockStmt blockStmt, BVarSymbol tupleVarSymbol, BLangExpression tupleExpr) {
        boolean isIndexBasedAccessExpr;
        if (tupleVarRef.restParam == null) {
            return;
        }
        Location pos = blockStmt.pos;
        BLangSimpleVarRef restParam = (BLangSimpleVarRef)tupleVarRef.restParam;
        BType restParamType = restParam.getBType();
        BType referredRestParamType = Types.getImpliedType(restParamType);
        BLangListConstructorExpr.BLangArrayLiteral arrayExpr = this.createArrayLiteralExprNode();
        arrayExpr.setBType(restParamType);
        BLangAssignment restParamAssignment = ASTBuilderUtil.createAssignmentStmt(pos, blockStmt);
        restParamAssignment.varRef = restParam;
        restParamAssignment.varRef.setBType(restParamType);
        restParamAssignment.expr = arrayExpr;
        BLangExpression countExpr = ASTBuilderUtil.createLiteral(pos, this.symTable.intType, tupleVarRef.expressions.size());
        boolean bl = isIndexBasedAccessExpr = tupleExpr.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR;
        if (referredRestParamType.tag == 31) {
            BTupleType restTupleType = (BTupleType)referredRestParamType;
            BLangIndexBasedAccess modifiedTupleExpr = ASTBuilderUtil.createIndexAccessExpr(tupleExpr, countExpr);
            modifiedTupleExpr.setBType(tupleExpr.getBType());
            tupleExpr = modifiedTupleExpr;
            isIndexBasedAccessExpr = true;
            List<BType> restTupleMemberTypes = restTupleType.getTupleTypes();
            for (int index = 0; index < restTupleMemberTypes.size(); ++index) {
                BLangLiteral indexExpr = ASTBuilderUtil.createLiteral(pos, this.symTable.intType, index);
                BLangIndexBasedAccess tupleValueExpr = ASTBuilderUtil.createIndexAccessExpr(restParam, indexExpr);
                tupleValueExpr.setBType(restTupleMemberTypes.get(index));
                this.createAssignmentStmt(tupleValueExpr, blockStmt, indexExpr, tupleVarSymbol, (BLangIndexBasedAccess)tupleExpr);
                countExpr = ASTBuilderUtil.createBinaryExpr(pos, indexExpr, ASTBuilderUtil.createLiteral(pos, this.symTable.intType, 1L), this.symTable.intType, OperatorKind.ADD, null);
            }
            if (restTupleType.restType == null) {
                return;
            }
        }
        BLangInvocation lengthInvocation = this.createLengthInvocation(pos, tupleExpr);
        BLangInvocation intRangeInvocation = this.replaceWithIntRange(pos, countExpr, this.getModifiedIntRangeEndExpr(lengthInvocation));
        BLangForeach foreach = (BLangForeach)TreeBuilder.createForeachNode();
        foreach.pos = pos;
        foreach.collection = intRangeInvocation;
        this.types.setForeachTypedBindingPatternType(foreach);
        BLangSimpleVariable foreachVariable = ASTBuilderUtil.createVariable(pos, "$foreach$i", foreach.varType);
        foreachVariable.symbol = new BVarSymbol(0L, this.names.fromIdNode(foreachVariable.name), this.env.scope.owner.pkgID, foreachVariable.getBType(), this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVarRef foreachVarRef = ASTBuilderUtil.createVariableRef(pos, foreachVariable.symbol);
        foreach.variableDefinitionNode = ASTBuilderUtil.createVariableDef(pos, foreachVariable);
        foreach.isDeclaredWithVar = true;
        BLangBlockStmt foreachBody = ASTBuilderUtil.createBlockStmt(pos);
        BLangIndexBasedAccess indexAccessExpr = ASTBuilderUtil.createIndexAccessExpr(restParam, this.createLengthInvocation(pos, restParam));
        if (referredRestParamType.tag == 31) {
            indexAccessExpr.setBType(((BTupleType)referredRestParamType).restType);
        } else {
            indexAccessExpr.setBType(((BArrayType)referredRestParamType).eType);
        }
        if (isIndexBasedAccessExpr) {
            this.createAssignmentStmt(indexAccessExpr, foreachBody, foreachVarRef, tupleVarSymbol, (BLangIndexBasedAccess)tupleExpr);
        } else {
            this.createAssignmentStmt(indexAccessExpr, foreachBody, foreachVarRef, tupleVarSymbol, null);
        }
        foreach.body = foreachBody;
        blockStmt.addStatement(foreach);
    }

    private BLangInvocation createLengthInvocation(Location pos, BLangExpression collection) {
        BInvokableSymbol lengthInvokableSymbol = (BInvokableSymbol)this.symResolver.lookupLangLibMethod(collection.getBType(), Names.fromString(LENGTH_FUNCTION_NAME), this.env);
        BLangInvocation lengthInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, lengthInvokableSymbol, Lists.of(collection), this.symResolver);
        lengthInvocation.argExprs = lengthInvocation.requiredArgs;
        lengthInvocation.setBType(lengthInvokableSymbol.type.getReturnType());
        return lengthInvocation;
    }

    private void createVarRefAssignmentStmts(BLangTupleVarRef parentTupleVariable, BLangBlockStmt parentBlockStmt, BVarSymbol tupleVarSymbol, BLangIndexBasedAccess parentIndexAccessExpr) {
        List<BLangExpression> expressions = parentTupleVariable.expressions;
        for (int index = 0; index < expressions.size(); ++index) {
            BLangIndexBasedAccess arrayAccessExpr;
            BLangLiteral indexExpr;
            BLangExpression expression = expressions.get(index);
            if (NodeKind.SIMPLE_VARIABLE_REF == expression.getKind() || NodeKind.FIELD_BASED_ACCESS_EXPR == expression.getKind() || NodeKind.INDEX_BASED_ACCESS_EXPR == expression.getKind() || NodeKind.XML_ATTRIBUTE_ACCESS_EXPR == expression.getKind()) {
                BLangLiteral indexExpr2 = ASTBuilderUtil.createLiteral(expression.pos, this.symTable.intType, index);
                this.createAssignmentStmt(expression, parentBlockStmt, indexExpr2, tupleVarSymbol, parentIndexAccessExpr);
                continue;
            }
            if (expression.getKind() == NodeKind.TUPLE_VARIABLE_REF) {
                BLangTupleVarRef tupleVarRef = (BLangTupleVarRef)expression;
                indexExpr = ASTBuilderUtil.createLiteral(tupleVarRef.pos, this.symTable.intType, index);
                arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(tupleVarRef.pos, new BArrayType(this.symTable.typeEnv(), this.symTable.anyType), tupleVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarRefAssignmentStmts((BLangTupleVarRef)expression, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
                this.createRestFieldAssignmentStmt((BLangTupleVarRef)expression, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
                continue;
            }
            if (expression.getKind() == NodeKind.RECORD_VARIABLE_REF) {
                BLangRecordVarRef recordVarRef = (BLangRecordVarRef)expression;
                indexExpr = ASTBuilderUtil.createLiteral(recordVarRef.pos, this.symTable.intType, index);
                arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentTupleVariable.pos, this.symTable.mapType, tupleVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarRefAssignmentStmts((BLangRecordVarRef)expression, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
                BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode((BRecordType)recordVarRef.getBType(), this.env.enclPkg.packageID, this.symTable, recordVarRef.pos);
                TypeDefBuilderHelper.createTypeDefinitionForTSymbol(recordVarRef.getBType(), recordVarRef.getBType().tsymbol, recordTypeNode, this.env);
                continue;
            }
            if (expression.getKind() != NodeKind.ERROR_VARIABLE_REF) continue;
            BLangErrorVarRef errorVarRef = (BLangErrorVarRef)expression;
            indexExpr = ASTBuilderUtil.createLiteral(errorVarRef.pos, this.symTable.intType, index);
            arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentTupleVariable.pos, expression.getBType(), tupleVarSymbol, indexExpr);
            if (parentIndexAccessExpr != null) {
                arrayAccessExpr.expr = parentIndexAccessExpr;
            }
            this.createVarRefAssignmentStmts((BLangErrorVarRef)expression, parentBlockStmt, tupleVarSymbol, arrayAccessExpr);
        }
    }

    private void createAssignmentStmt(BLangExpression accessibleExpression, BLangBlockStmt parentBlockStmt, BLangExpression indexExpr, BVarSymbol tupleVarSymbol, BLangIndexBasedAccess parentArrayAccessExpr) {
        Name varName;
        if (accessibleExpression.getKind() == NodeKind.SIMPLE_VARIABLE_REF && (varName = this.names.fromIdNode(((BLangSimpleVarRef)accessibleExpression).variableName)) == Names.IGNORE) {
            return;
        }
        BLangExpression assignmentExpr = this.createIndexBasedAccessExpr(accessibleExpression.getBType(), accessibleExpression.pos, indexExpr, tupleVarSymbol, parentArrayAccessExpr);
        assignmentExpr = this.types.addConversionExprIfRequired(assignmentExpr, accessibleExpression.getBType());
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(parentBlockStmt.pos, parentBlockStmt);
        assignmentStmt.varRef = accessibleExpression;
        assignmentStmt.expr = assignmentExpr;
    }

    private BLangExpression createIndexBasedAccessExpr(BType varType, Location varLocation, BLangExpression indexExpr, BVarSymbol tupleVarSymbol, BLangIndexBasedAccess parentExpr) {
        BLangExpression assignmentExpr;
        BLangIndexBasedAccess arrayAccess = ASTBuilderUtil.createIndexBasesAccessExpr(varLocation, this.symTable.anyType, tupleVarSymbol, indexExpr);
        arrayAccess.originalType = varType;
        if (parentExpr != null) {
            arrayAccess.expr = parentExpr;
        }
        if (this.types.isValueType(varType)) {
            BLangTypeConversionExpr castExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
            castExpr.expr = arrayAccess;
            castExpr.setBType(varType);
            assignmentExpr = castExpr;
        } else {
            assignmentExpr = arrayAccess;
        }
        return assignmentExpr;
    }

    @Override
    public void visit(BLangRecordDestructure recordDestructure) {
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(recordDestructure.pos);
        BMapType runTimeType = new BMapType(this.symTable.typeEnv(), 16, this.symTable.anyType, null);
        String name = "$map$_0";
        BLangSimpleVariable mapVariable = ASTBuilderUtil.createVariable(recordDestructure.pos, name, runTimeType, null, new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, runTimeType, this.env.scope.owner, recordDestructure.pos, SymbolOrigin.VIRTUAL));
        mapVariable.expr = recordDestructure.expr;
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(recordDestructure.pos, blockStmt);
        variableDef.var = mapVariable;
        this.createVarRefAssignmentStmts(recordDestructure.varRef, blockStmt, mapVariable.symbol, null);
        this.result = this.rewrite(blockStmt, this.env);
    }

    @Override
    public void visit(BLangErrorDestructure errorDestructure) {
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(errorDestructure.pos);
        BLangSimpleVariable errorVar = ASTBuilderUtil.createVariable(errorDestructure.pos, GENERATED_ERROR_VAR, this.symTable.errorType, null, new BVarSymbol(0L, Names.fromString(GENERATED_ERROR_VAR), this.env.scope.owner.pkgID, this.symTable.errorType, this.env.scope.owner, errorDestructure.pos, SymbolOrigin.VIRTUAL));
        errorVar.expr = errorDestructure.expr;
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(errorDestructure.pos, blockStmt);
        variableDef.var = errorVar;
        this.createVarRefAssignmentStmts(errorDestructure.varRef, blockStmt, errorVar.symbol, null);
        this.result = this.rewrite(blockStmt, this.env);
    }

    private void createVarRefAssignmentStmts(BLangRecordVarRef parentRecordVarRef, BLangBlockStmt parentBlockStmt, BVarSymbol recordVarSymbol, BLangIndexBasedAccess parentIndexAccessExpr) {
        List<BLangRecordVarRef.BLangRecordVarRefKeyValue> variableRefList = parentRecordVarRef.recordRefFields;
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue varRefKeyValue : variableRefList) {
            BLangIndexBasedAccess arrayAccessExpr;
            BLangExpression expression = varRefKeyValue.variableReference;
            BLangLiteral indexExpr = ASTBuilderUtil.createLiteral(expression.pos, this.symTable.stringType, Utils.unescapeJava((String)varRefKeyValue.variableName.getValue()));
            if (NodeKind.SIMPLE_VARIABLE_REF == expression.getKind() || NodeKind.FIELD_BASED_ACCESS_EXPR == expression.getKind() || NodeKind.INDEX_BASED_ACCESS_EXPR == expression.getKind() || NodeKind.XML_ATTRIBUTE_ACCESS_EXPR == expression.getKind()) {
                this.createAssignmentStmt(expression, parentBlockStmt, indexExpr, recordVarSymbol, parentIndexAccessExpr);
                continue;
            }
            if (NodeKind.RECORD_VARIABLE_REF == expression.getKind()) {
                BLangRecordVarRef recordVariable = (BLangRecordVarRef)expression;
                arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(parentRecordVarRef.pos, this.symTable.mapType, recordVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarRefAssignmentStmts(recordVariable, parentBlockStmt, recordVarSymbol, arrayAccessExpr);
                continue;
            }
            if (NodeKind.TUPLE_VARIABLE_REF == expression.getKind()) {
                BLangTupleVarRef tupleVariable = (BLangTupleVarRef)expression;
                arrayAccessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(tupleVariable.pos, this.symTable.tupleType, recordVarSymbol, indexExpr);
                if (parentIndexAccessExpr != null) {
                    arrayAccessExpr.expr = parentIndexAccessExpr;
                }
                this.createVarRefAssignmentStmts(tupleVariable, parentBlockStmt, recordVarSymbol, arrayAccessExpr);
                continue;
            }
            if (NodeKind.ERROR_VARIABLE_REF != expression.getKind()) continue;
            BLangIndexBasedAccess arrayAccessExpr2 = ASTBuilderUtil.createIndexBasesAccessExpr(expression.pos, this.symTable.errorType, recordVarSymbol, indexExpr);
            if (parentIndexAccessExpr != null) {
                arrayAccessExpr2.expr = parentIndexAccessExpr;
            }
            this.createVarRefAssignmentStmts((BLangErrorVarRef)expression, parentBlockStmt, recordVarSymbol, arrayAccessExpr2);
        }
        if (parentRecordVarRef.restParam != null) {
            BLangSimpleVarRef variableReference;
            Location pos = parentBlockStmt.pos;
            BLangSimpleVarRef restParamRef = (BLangSimpleVarRef)parentRecordVarRef.restParam;
            BType restParamType = restParamRef.getBType();
            if (parentIndexAccessExpr != null) {
                BLangSimpleVariable mapVariable = ASTBuilderUtil.createVariable(pos, "$map$_1", restParamType, null, new BVarSymbol(0L, Names.fromString("$map$_1"), this.env.scope.owner.pkgID, restParamType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL));
                mapVariable.expr = parentIndexAccessExpr;
                BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDefStmt(pos, parentBlockStmt);
                variableDef.var = mapVariable;
                variableReference = ASTBuilderUtil.createVariableRef(pos, mapVariable.symbol);
            } else {
                variableReference = ASTBuilderUtil.createVariableRef(pos, ((BLangSimpleVariableDef)parentBlockStmt.stmts.get((int)0)).var.symbol);
            }
            BLangSimpleVarRef restParam = (BLangSimpleVarRef)parentRecordVarRef.restParam;
            List<String> keysToRemove = parentRecordVarRef.recordRefFields.stream().map(field -> field.variableName.value).toList();
            BLangSimpleVariable filteredDetail = this.generateRestFilter(variableReference, pos, keysToRemove, restParamType, parentBlockStmt);
            BLangSimpleVarRef varRef = ASTBuilderUtil.createVariableRef(pos, filteredDetail.symbol);
            BLangAssignment restParamAssignment = ASTBuilderUtil.createAssignmentStmt(pos, parentBlockStmt);
            restParamAssignment.varRef = restParam;
            restParamAssignment.varRef.setBType(restParamType);
            restParamAssignment.expr = varRef;
        }
    }

    private void createVarRefAssignmentStmts(BLangErrorVarRef parentErrorVarRef, BLangBlockStmt parentBlockStmt, BVarSymbol errorVarySymbol, BLangIndexBasedAccess parentIndexAccessExpr) {
        if (parentErrorVarRef.message != null && this.names.fromIdNode(((BLangSimpleVarRef)parentErrorVarRef.message).variableName) != Names.IGNORE) {
            BLangAssignment message = ASTBuilderUtil.createAssignmentStmt(parentBlockStmt.pos, parentBlockStmt);
            message.expr = this.generateErrorMessageBuiltinFunction(parentErrorVarRef.message.pos, this.symTable.stringType, errorVarySymbol, parentIndexAccessExpr);
            message.expr = this.types.addConversionExprIfRequired(message.expr, parentErrorVarRef.message.getBType());
            message.varRef = parentErrorVarRef.message;
        }
        if (parentErrorVarRef.cause != null && (parentErrorVarRef.cause.getKind() != NodeKind.SIMPLE_VARIABLE_REF || this.names.fromIdNode(((BLangSimpleVarRef)parentErrorVarRef.cause).variableName) != Names.IGNORE)) {
            BLangAssignment cause = ASTBuilderUtil.createAssignmentStmt(parentBlockStmt.pos, parentBlockStmt);
            cause.expr = this.generateErrorCauseLanglibFunction(parentErrorVarRef.cause.pos, this.symTable.errorType, errorVarySymbol, parentIndexAccessExpr);
            cause.expr = this.types.addConversionExprIfRequired(cause.expr, parentErrorVarRef.cause.getBType());
            cause.varRef = parentErrorVarRef.cause;
        }
        if (parentErrorVarRef.detail.isEmpty() && this.isIgnoredErrorRefRestVar(parentErrorVarRef)) {
            return;
        }
        BLangInvocation errorDetailBuiltinFunction = this.generateErrorDetailBuiltinFunction(parentErrorVarRef.pos, errorVarySymbol, parentIndexAccessExpr);
        BLangSimpleVariableDef detailTempVarDef = this.createVarDef("$error$detail$_" + this.errorCount++, this.symTable.detailType, errorDetailBuiltinFunction, parentErrorVarRef.pos);
        detailTempVarDef.setBType(this.symTable.detailType);
        parentBlockStmt.addStatement(detailTempVarDef);
        this.env.scope.define(this.names.fromIdNode(detailTempVarDef.var.name), detailTempVarDef.var.symbol);
        ArrayList<String> extractedKeys = new ArrayList<String>();
        for (BLangNamedArgsExpression detail : parentErrorVarRef.detail) {
            extractedKeys.add(detail.name.value);
            BLangVariableReference ref = (BLangVariableReference)detail.expr;
            BLangExpression detailEntryVar = this.createIndexBasedAccessExpr(ref.getBType(), ref.pos, this.createStringLiteral(detail.name.pos, detail.name.value), detailTempVarDef.var.symbol, null);
            if (detailEntryVar.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
                BLangIndexBasedAccess bLangIndexBasedAccess = (BLangIndexBasedAccess)detailEntryVar;
                bLangIndexBasedAccess.originalType = this.symTable.cloneableType;
            }
            BLangAssignment detailAssignment = ASTBuilderUtil.createAssignmentStmt(ref.pos, parentBlockStmt);
            detailAssignment.varRef = ref;
            detailAssignment.expr = detailEntryVar;
        }
        if (!this.isIgnoredErrorRefRestVar(parentErrorVarRef)) {
            BLangSimpleVarRef detailVarRef = ASTBuilderUtil.createVariableRef(parentErrorVarRef.restVar.pos, detailTempVarDef.var.symbol);
            BLangSimpleVariable filteredDetail = this.generateRestFilter(detailVarRef, parentErrorVarRef.restVar.pos, extractedKeys, parentErrorVarRef.restVar.getBType(), parentBlockStmt);
            BLangAssignment restAssignment = ASTBuilderUtil.createAssignmentStmt(parentErrorVarRef.restVar.pos, parentBlockStmt);
            restAssignment.varRef = parentErrorVarRef.restVar;
            restAssignment.expr = ASTBuilderUtil.createVariableRef(parentErrorVarRef.restVar.pos, filteredDetail.symbol);
        }
    }

    private boolean isIgnoredErrorRefRestVar(BLangErrorVarRef parentErrorVarRef) {
        if (parentErrorVarRef.restVar == null) {
            return true;
        }
        if (parentErrorVarRef.restVar.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            return ((BLangSimpleVarRef)parentErrorVarRef.restVar).variableName.value.equals(Names.IGNORE.value);
        }
        return false;
    }

    @Override
    public void visit(BLangRetry retryNode) {
        if (retryNode.onFailClause != null) {
            BLangOnFailClause onFailClause = retryNode.onFailClause;
            retryNode.onFailClause = null;
            retryNode.retryBody.failureBreakMode = BLangBlockStmt.FailureBreakMode.NOT_BREAKABLE;
            BLangDo doStmt = this.wrapStatementWithinDo(retryNode.pos, retryNode, onFailClause);
            this.result = this.rewrite(doStmt, this.env);
        } else {
            Location pos = retryNode.retryBody.pos;
            BLangSimpleVarRef prevShouldRetryRef = this.shouldRetryRef;
            BLangBlockStmt retryBlockStmt = ASTBuilderUtil.createBlockStmt(retryNode.pos);
            retryBlockStmt.parent = this.env.enclInvokable;
            retryBlockStmt.scope = new Scope(this.env.scope.owner);
            if (retryNode.commonStmtForRetries != null) {
                BLangSimpleVariableDef prevAttemptDef = (BLangSimpleVariableDef)retryNode.commonStmtForRetries;
                retryBlockStmt.scope.define(prevAttemptDef.var.symbol.name, prevAttemptDef.var.symbol);
                retryBlockStmt.stmts.add(retryNode.commonStmtForRetries);
            }
            BLangSimpleVariableDef retryManagerVarDef = this.createRetryManagerDef(retryNode.retrySpec, retryNode.pos);
            retryBlockStmt.stmts.add(retryManagerVarDef);
            BLangSimpleVarRef retryManagerVarRef = ASTBuilderUtil.createVariableRef(pos, retryManagerVarDef.var.symbol);
            BVarSymbol retryMangerRefVarSymbol = new BVarSymbol(0L, Names.fromString("$retryManagerRef$"), this.env.scope.owner.pkgID, retryManagerVarDef.var.symbol.type, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
            retryMangerRefVarSymbol.closure = true;
            BLangSimpleVariable retryMangerRefVar = ASTBuilderUtil.createVariable(pos, "$retryManagerRef$", retryManagerVarDef.var.symbol.type, retryManagerVarRef, retryMangerRefVarSymbol);
            retryBlockStmt.scope.define(retryMangerRefVarSymbol.name, retryMangerRefVarSymbol);
            BLangSimpleVariableDef retryMangerRefDef = ASTBuilderUtil.createVariableDef(pos, retryMangerRefVar);
            BLangSimpleVarRef retryManagerRef = ASTBuilderUtil.createVariableRef(pos, retryMangerRefVarSymbol);
            retryBlockStmt.stmts.add(retryMangerRefDef);
            BLangLiteral nillLiteral = ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, null);
            BVarSymbol retryResultVarSymbol = new BVarSymbol(0L, Names.fromString("$retryResult$"), this.env.scope.owner.pkgID, this.symTable.errorOrNilType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
            retryResultVarSymbol.closure = true;
            BLangSimpleVariable retryResultVariable = ASTBuilderUtil.createVariable(pos, "$retryResult$", this.symTable.errorOrNilType, nillLiteral, retryResultVarSymbol);
            retryBlockStmt.scope.define(retryResultVarSymbol.name, retryResultVarSymbol);
            BLangSimpleVariableDef retryResultDef = ASTBuilderUtil.createVariableDef(pos, retryResultVariable);
            BLangSimpleVarRef retryResultRef = ASTBuilderUtil.createVariableRef(pos, retryResultVarSymbol);
            retryBlockStmt.stmts.add(retryResultDef);
            BLangLiteral falseLiteral = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, false);
            BVarSymbol shouldRetryVarSymbol = new BVarSymbol(0L, Names.fromString("$shouldRetry$"), this.env.scope.owner.pkgID, this.symTable.booleanType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
            shouldRetryVarSymbol.closure = true;
            BLangSimpleVariable shouldRetryVariable = ASTBuilderUtil.createVariable(pos, "$shouldRetry$", this.symTable.booleanType, falseLiteral, shouldRetryVarSymbol);
            retryBlockStmt.scope.define(shouldRetryVarSymbol.name, shouldRetryVarSymbol);
            BLangSimpleVariableDef shouldRetryDef = ASTBuilderUtil.createVariableDef(pos, shouldRetryVariable);
            this.shouldRetryRef = ASTBuilderUtil.createVariableRef(pos, shouldRetryVarSymbol);
            retryBlockStmt.stmts.add(shouldRetryDef);
            BLangWhile whileLoop = this.createRetryWhileLoop(pos, retryNode.retryBody, retryManagerRef, retryResultRef, this.shouldRetryRef);
            retryBlockStmt.stmts.add(whileLoop);
            if (!this.enclosingShouldContinue.isEmpty() && this.enclosingShouldContinue.size() > 1) {
                BLangSimpleVarRef nestedLoopShouldContinue = this.enclosingShouldContinue.get(this.enclosingShouldContinue.size() - 2);
                BLangBlockStmt shouldContinueBlock = ASTBuilderUtil.createBlockStmt(pos);
                BLangContinue loopContinueStmt = (BLangContinue)TreeBuilder.createContinueNode();
                loopContinueStmt.pos = pos;
                shouldContinueBlock.stmts.add(loopContinueStmt);
                BLangIf shouldContinue = ASTBuilderUtil.createIfElseStmt(pos, nestedLoopShouldContinue, shouldContinueBlock, null);
                retryBlockStmt.stmts.add(shouldContinue);
            }
            this.result = this.rewrite(retryBlockStmt, this.env);
            this.enclosingShouldContinue.remove(this.enclosingShouldContinue.size() - 1);
            this.shouldRetryRef = prevShouldRetryRef;
        }
    }

    protected BLangWhile createRetryWhileLoop(Location pos, BLangBlockStmt retryBody, BLangSimpleVarRef retryManagerRef, BLangSimpleVarRef retryResultRef, BLangSimpleVarRef shouldRetryRef) {
        BLangWhile whileNode = (BLangWhile)TreeBuilder.createWhileNode();
        whileNode.pos = pos;
        BLangBlockStmt whileBody = ASTBuilderUtil.createBlockStmt(pos);
        whileBody.scope = new Scope(this.env.scope.owner);
        BLangLiteral falseLiteral = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, false);
        BVarSymbol returnResultSymbol = new BVarSymbol(0L, Names.fromString("$returnErrorResult$"), this.env.scope.owner.pkgID, this.symTable.booleanType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        returnResultSymbol.closure = true;
        BLangSimpleVariable returnResultVariable = ASTBuilderUtil.createVariable(pos, "$returnErrorResult$", this.symTable.booleanType, falseLiteral, returnResultSymbol);
        whileBody.scope.define(returnResultSymbol.name, returnResultSymbol);
        BLangSimpleVariableDef returnResultDef = ASTBuilderUtil.createVariableDef(pos, returnResultVariable);
        BLangSimpleVarRef returnResultRef = ASTBuilderUtil.createVariableRef(pos, returnResultSymbol);
        whileBody.stmts.add(returnResultDef);
        BVarSymbol continueLoopVarSymbol = new BVarSymbol(0L, Names.fromString("$continueLoop$"), this.env.scope.owner.pkgID, this.symTable.booleanType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        continueLoopVarSymbol.closure = true;
        BLangSimpleVariable continueLoopVariable = ASTBuilderUtil.createVariable(pos, "$continueLoop$", this.symTable.booleanType, falseLiteral, continueLoopVarSymbol);
        whileBody.scope.define(continueLoopVarSymbol.name, continueLoopVarSymbol);
        BLangSimpleVariableDef continueLoopDef = ASTBuilderUtil.createVariableDef(pos, continueLoopVariable);
        BLangSimpleVarRef continueLoopRef = ASTBuilderUtil.createVariableRef(pos, continueLoopVarSymbol);
        whileBody.stmts.add(continueLoopDef);
        BLangOnFailClause internalOnFail = this.createRetryInternalOnFail(pos, retryResultRef, retryManagerRef, shouldRetryRef, continueLoopRef, returnResultRef);
        this.enclosingShouldContinue.add(continueLoopRef);
        BLangDo retryDo = this.wrapStatementWithinDo(pos, retryBody, internalOnFail);
        BLangTypeTestExpr isErrorCheck = this.createTypeCheckExpr(pos, retryResultRef, this.getErrorTypeNode());
        BLangBinaryExpr shouldRetryCheck = ASTBuilderUtil.createBinaryExpr(pos, isErrorCheck, shouldRetryRef, this.symTable.booleanType, OperatorKind.AND, null);
        BLangGroupExpr rhsCheck = new BLangGroupExpr();
        rhsCheck.setBType(this.symTable.booleanType);
        rhsCheck.expression = shouldRetryCheck;
        BLangLiteral nillLiteral = ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, null);
        BLangBinaryExpr equalToNullCheck = ASTBuilderUtil.createBinaryExpr(pos, retryResultRef, nillLiteral, this.symTable.booleanType, OperatorKind.EQUAL, null);
        BLangGroupExpr lhsCheck = new BLangGroupExpr();
        lhsCheck.setBType(this.symTable.booleanType);
        lhsCheck.expression = equalToNullCheck;
        whileNode.expr = ASTBuilderUtil.createBinaryExpr(pos, lhsCheck, rhsCheck, this.symTable.booleanType, OperatorKind.OR, null);
        BLangAssignment shouldRetryFalse = ASTBuilderUtil.createAssignmentStmt(pos, shouldRetryRef, ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, false));
        whileBody.stmts.add(shouldRetryFalse);
        whileBody.stmts.add(retryDo);
        BLangBlockStmt returnBlock = ASTBuilderUtil.createBlockStmt(pos);
        BLangReturn errorReturn = ASTBuilderUtil.createReturnStmt(pos, this.rewrite(retryResultRef, this.env));
        errorReturn.desugared = true;
        returnBlock.stmts.add(errorReturn);
        BLangIf exitIf = ASTBuilderUtil.createIfElseStmt(pos, returnResultRef, returnBlock, null);
        whileBody.stmts.add(exitIf);
        BLangBlockStmt shouldContinueBlock = ASTBuilderUtil.createBlockStmt(pos);
        BLangContinue loopContinueStmt = (BLangContinue)TreeBuilder.createContinueNode();
        loopContinueStmt.pos = pos;
        shouldContinueBlock.stmts.add(loopContinueStmt);
        BLangBlockStmt elseBlock = ASTBuilderUtil.createBlockStmt(pos);
        BLangBreak breakStmt = (BLangBreak)TreeBuilder.createBreakNode();
        breakStmt.pos = pos;
        elseBlock.stmts.add(breakStmt);
        BLangIf shouldContinue = ASTBuilderUtil.createIfElseStmt(pos, continueLoopRef, shouldContinueBlock, elseBlock);
        whileBody.stmts.add(shouldContinue);
        whileNode.body = whileBody;
        return whileNode;
    }

    protected BLangSimpleVariableDef createRetryManagerDef(BLangRetrySpec retrySpec, Location pos) {
        BSymbol retryManagerTypeSymbol = this.symTable.langErrorModuleSymbol.scope.lookup((Name)Names.fromString((String)"DefaultRetryManager")).symbol;
        BType retryManagerType = retryManagerTypeSymbol.type;
        if (retrySpec.retryManagerType != null) {
            retryManagerType = retrySpec.retryManagerType.getBType();
        }
        BVarSymbol retryMangerSymbol = new BVarSymbol(0L, Names.fromString("$retryManager$"), this.env.scope.owner.pkgID, retryManagerType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangTypeInit managerInit = ASTBuilderUtil.createEmptyTypeInit(pos, retryManagerType);
        ((BLangInvocation)managerInit.initInvocation).requiredArgs = retrySpec.argExprs;
        BLangSimpleVariable retryManagerVariable = ASTBuilderUtil.createVariable(pos, "$retryManager$", retryManagerType, managerInit, retryMangerSymbol);
        return ASTBuilderUtil.createVariableDef(pos, retryManagerVariable);
    }

    BLangInvocation createRetryManagerShouldRetryInvocation(Location location, BLangSimpleVarRef managerVarRef, BLangExpression trapResultRef) {
        BInvokableSymbol shouldRetryFuncSymbol = this.getShouldRetryFunc((BVarSymbol)((BVarSymbol)managerVarRef.symbol)).symbol;
        BLangInvocation shouldRetryInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        shouldRetryInvocation.pos = location;
        shouldRetryInvocation.expr = managerVarRef;
        shouldRetryInvocation.requiredArgs = Lists.of(trapResultRef);
        shouldRetryInvocation.argExprs = shouldRetryInvocation.requiredArgs;
        shouldRetryInvocation.symbol = shouldRetryFuncSymbol;
        shouldRetryInvocation.setBType(shouldRetryFuncSymbol.retType);
        shouldRetryInvocation.langLibInvocation = false;
        return shouldRetryInvocation;
    }

    private BAttachedFunction getShouldRetryFunc(BVarSymbol retryManagerSymbol) {
        BObjectTypeSymbol typeSymbol = (BObjectTypeSymbol)retryManagerSymbol.type.tsymbol;
        for (BAttachedFunction bAttachedFunction : typeSymbol.attachedFuncs) {
            if (!bAttachedFunction.funcName.value.equals("shouldRetry")) continue;
            return bAttachedFunction;
        }
        return null;
    }

    protected BLangTypeTestExpr createTypeCheckExpr(Location pos, BLangExpression expr, BLangType type) {
        BLangTypeTestExpr testExpr = ASTBuilderUtil.createTypeTestExpr(pos, expr, type);
        testExpr.setBType(this.symTable.booleanType);
        return testExpr;
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        BLangSimpleVariableDef prevAttemptVarDef = this.transactionDesugar.createPrevAttemptInfoVarDef(this.env, retryTransaction.pos);
        retryTransaction.transaction.prevAttemptInfo = ASTBuilderUtil.createVariableRef(retryTransaction.pos, prevAttemptVarDef.var.symbol);
        retryTransaction.pos = null;
        retryTransaction.retrySpec.pos = null;
        retryTransaction.transaction.pos = null;
        retryTransaction.transaction.transactionBody.pos = null;
        BLangBlockStmt retryBody = ASTBuilderUtil.createBlockStmt(null);
        retryBody.stmts.add(retryTransaction.transaction);
        BLangRetry retry = (BLangRetry)TreeBuilder.createRetryNode();
        retry.commonStmtForRetries = prevAttemptVarDef;
        retry.retryBody = retryBody;
        retry.retrySpec = retryTransaction.retrySpec;
        this.result = this.rewrite(retry, this.env);
    }

    protected BLangNode createExpressionStatement(Location location, BLangStatementExpression retryTransactionStmtExpr, boolean retryReturns, SymbolEnv env) {
        if (retryReturns) {
            BLangReturn bLangReturn = ASTBuilderUtil.createReturnStmt(location, this.rewrite(retryTransactionStmtExpr, env));
            return this.rewrite(bLangReturn, env);
        }
        BLangExpressionStmt transactionExprStmt = (BLangExpressionStmt)TreeBuilder.createExpressionStatementNode();
        transactionExprStmt.pos = location;
        transactionExprStmt.expr = retryTransactionStmtExpr;
        transactionExprStmt.setBType(this.symTable.nilType);
        return this.rewrite(transactionExprStmt, env);
    }

    void failFastForErrorResult(Location pos, BlockNode blockStmt, BLangTypeTestExpr typeTestExpr, BLangExpression resultRef) {
        BLangIf returnError = ASTBuilderUtil.createIfStmt(pos, blockStmt);
        returnError.expr = typeTestExpr;
        returnError.body = ASTBuilderUtil.createBlockStmt(pos);
        BLangFail failExpressionNode = (BLangFail)TreeBuilder.createFailNode();
        failExpressionNode.expr = this.types.addConversionExprIfRequired(resultRef, this.symTable.errorType);
        returnError.body.stmts.add(failExpressionNode);
    }

    @Override
    public void visit(BLangContinue nextNode) {
        this.result = nextNode;
    }

    @Override
    public void visit(BLangBreak breakNode) {
        this.result = breakNode;
    }

    @Override
    public void visit(BLangReturn returnNode) {
        if (returnNode.expr != null) {
            returnNode.expr = this.rewriteExpr(returnNode.expr);
        }
        this.result = returnNode;
    }

    @Override
    public void visit(BLangPanic panicNode) {
        panicNode.expr = this.rewriteExpr(panicNode.expr);
        this.result = panicNode;
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        xmlnsStmtNode.xmlnsDecl = this.rewrite(xmlnsStmtNode.xmlnsDecl, this.env);
        this.stmtsToBePropagatedToQuery.put(xmlnsStmtNode.xmlnsDecl.symbol.name, xmlnsStmtNode);
        this.result = xmlnsStmtNode;
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        BSymbol ownerSymbol = xmlnsNode.symbol.owner;
        BLangXMLNS generatedXMLNSNode = (ownerSymbol.tag & 0x100L) == 256L || (ownerSymbol.tag & 0x84L) == 132L ? new BLangXMLNS.BLangLocalXMLNS() : new BLangXMLNS.BLangPackageXMLNS();
        generatedXMLNSNode.namespaceURI = xmlnsNode.namespaceURI;
        generatedXMLNSNode.prefix = xmlnsNode.prefix;
        generatedXMLNSNode.symbol = xmlnsNode.symbol;
        this.result = generatedXMLNSNode;
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignment) {
        BLangValueExpression varRef = compoundAssignment.varRef;
        if (compoundAssignment.varRef.getKind() != NodeKind.INDEX_BASED_ACCESS_EXPR) {
            this.result = ASTBuilderUtil.createAssignmentStmt(compoundAssignment.pos, this.rewriteExpr(varRef), this.rewriteExpr(compoundAssignment.modifiedExpr));
            return;
        }
        ArrayList<BLangStatement> statements = new ArrayList<BLangStatement>();
        ArrayList<BLangSimpleVarRef> varRefs = new ArrayList<BLangSimpleVarRef>();
        ArrayList<BType> types = new ArrayList<BType>();
        do {
            BLangSimpleVariableDef tempIndexVarDef = this.createVarDef("$temp" + ++this.indexExprCount + "$", ((BLangIndexBasedAccess)varRef).indexExpr.getBType(), ((BLangIndexBasedAccess)varRef).indexExpr, compoundAssignment.pos);
            BLangSimpleVarRef tempVarRef = ASTBuilderUtil.createVariableRef(tempIndexVarDef.pos, tempIndexVarDef.var.symbol);
            statements.add(0, tempIndexVarDef);
            varRefs.add(0, tempVarRef);
            types.add(0, varRef.getBType());
        } while ((varRef = (BLangValueExpression)((BLangIndexBasedAccess)varRef).expr).getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR);
        BLangValueExpression var = varRef;
        for (int ref = 0; ref < varRefs.size(); ++ref) {
            BLangIndexBasedAccess indexAccessExpr = ASTBuilderUtil.createIndexAccessExpr(var, (BLangExpression)varRefs.get(ref));
            indexAccessExpr.originalType = (BType)types.get(ref);
            var = indexAccessExpr;
            var.setBType(indexAccessExpr.originalType);
        }
        var.setBType(compoundAssignment.varRef.getBType());
        BLangBinaryExpr rhsExpression = ASTBuilderUtil.createBinaryExpr(compoundAssignment.pos, var, compoundAssignment.expr, compoundAssignment.getBType(), compoundAssignment.opKind, null);
        rhsExpression.setBType(compoundAssignment.modifiedExpr.getBType());
        BLangAssignment assignStmt = ASTBuilderUtil.createAssignmentStmt(compoundAssignment.pos, var, rhsExpression);
        statements.add(assignStmt);
        BLangBlockStmt bLangBlockStmt = ASTBuilderUtil.createBlockStmt(compoundAssignment.pos, statements);
        this.result = this.rewrite(bLangBlockStmt, this.env);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        exprStmtNode.expr = this.rewriteExpr(exprStmtNode.expr);
        this.result = exprStmtNode;
    }

    @Override
    public void visit(BLangIf ifNode) {
        Set<BLangWorkerSendReceiveExpr.Channel> prevChannels = this.channelsWithinIfStmt;
        ifNode.expr = this.rewriteExpr(ifNode.expr);
        LinkedHashSet<BLangWorkerSendReceiveExpr.Channel> ifBlockChannels = new LinkedHashSet<BLangWorkerSendReceiveExpr.Channel>();
        this.channelsWithinIfStmt = ifBlockChannels;
        ifNode.body = this.rewrite(ifNode.body, this.env);
        LinkedHashSet<BLangWorkerSendReceiveExpr.Channel> elseBlockChannels = new LinkedHashSet<BLangWorkerSendReceiveExpr.Channel>();
        this.channelsWithinIfStmt = elseBlockChannels;
        ifNode.elseStmt = this.rewrite(ifNode.elseStmt, this.env);
        this.addWorkerChannelAutoCloseStmts(ifNode, ifBlockChannels, elseBlockChannels);
        prevChannels.addAll(ifBlockChannels);
        prevChannels.addAll(elseBlockChannels);
        this.channelsWithinIfStmt = prevChannels;
        this.result = ifNode;
    }

    private void addWorkerChannelAutoCloseStmts(BLangIf ifNode, Set<BLangWorkerSendReceiveExpr.Channel> ifBlockChannels, Set<BLangWorkerSendReceiveExpr.Channel> elseBlockChannels) {
        if (!elseBlockChannels.isEmpty()) {
            ifNode.body.stmts.add(0, this.generateChannelAutoCloseStmt(elseBlockChannels));
        }
        if (!ifBlockChannels.isEmpty()) {
            BLangStatement elseStmt = ifNode.elseStmt;
            if (elseStmt == null) {
                ArrayList<BLangStatement> stmts = new ArrayList<BLangStatement>(Collections.singletonList(this.generateChannelAutoCloseStmt(ifBlockChannels)));
                ifNode.elseStmt = this.rewrite(ASTBuilderUtil.createBlockStmt(this.symTable.builtinPos, stmts), this.env);
            } else if (elseStmt.getKind() == NodeKind.BLOCK) {
                ((BLangBlockStmt)elseStmt).stmts.add(0, this.generateChannelAutoCloseStmt(ifBlockChannels));
            } else {
                assert (elseStmt.getKind() == NodeKind.IF);
                ArrayList<BLangStatement> stmts = new ArrayList<BLangStatement>(2);
                stmts.add(this.generateChannelAutoCloseStmt(ifBlockChannels));
                stmts.add(elseStmt);
                ifNode.elseStmt = this.rewrite(ASTBuilderUtil.createBlockStmt(elseStmt.pos, stmts), this.env);
            }
        }
    }

    private BLangExpressionStmt generateChannelAutoCloseStmt(Set<BLangWorkerSendReceiveExpr.Channel> channels) {
        List<BLangExpression> restArgs = this.generateChannelIdLiteralList(channels);
        BLangInvocation funcInvocation = this.createLangLibInvocationNode(CHANNEL_AUTO_CLOSE_FUNC_NAME, new ArrayList<BLangExpression>(), restArgs, this.symTable.nilType, this.symTable.builtinPos);
        funcInvocation.internal = true;
        BLangExpressionStmt exprStmt = (BLangExpressionStmt)TreeBuilder.createExpressionStatementNode();
        exprStmt.internal = true;
        exprStmt.expr = funcInvocation;
        exprStmt.pos = this.symTable.builtinPos;
        return this.rewrite(exprStmt, this.env);
    }

    private List<BLangExpression> generateChannelIdLiteralList(Set<BLangWorkerSendReceiveExpr.Channel> channels) {
        ArrayList<BLangExpression> exprs = new ArrayList<BLangExpression>();
        for (BLangWorkerSendReceiveExpr.Channel channel : channels) {
            BLangLiteral channelIdLiteral = this.createStringLiteral(this.symTable.builtinPos, channel.channelId());
            exprs.add(channelIdLiteral);
        }
        return exprs;
    }

    @Override
    public void visit(BLangMatchStatement matchStatement) {
        BLangOnFailClause currentOnFailClause = this.onFailClause;
        BLangBlockStmt matchBlockStmt = (BLangBlockStmt)TreeBuilder.createBlockNode();
        matchBlockStmt.pos = matchStatement.pos;
        BLangBlockStmt.FailureBreakMode failureBreakMode = matchBlockStmt.failureBreakMode = matchStatement.onFailClause != null ? BLangBlockStmt.FailureBreakMode.BREAK_TO_OUTER_BLOCK : BLangBlockStmt.FailureBreakMode.NOT_BREAKABLE;
        if (matchStatement.onFailClause != null) {
            this.rewrite(matchStatement.onFailClause, this.env);
        }
        String matchExprVarName = Names.GEN_VAR_PREFIX.value + "t_match_var";
        BLangExpression matchExpr = matchStatement.expr;
        BLangSimpleVariable matchExprVar = ASTBuilderUtil.createVariable(matchExpr.pos, matchExprVarName, matchExpr.getBType(), matchExpr, new BVarSymbol(0L, Names.fromString(matchExprVarName), this.env.scope.owner.pkgID, matchExpr.getBType(), this.env.scope.owner, matchExpr.pos, SymbolOrigin.VIRTUAL));
        BLangSimpleVariableDef matchExprVarDef = ASTBuilderUtil.createVariableDef(matchBlockStmt.pos, matchExprVar);
        matchBlockStmt.stmts.add(matchExprVarDef);
        matchBlockStmt.stmts.add(this.convertMatchClausesToIfElseStmt(matchStatement.matchClauses, matchExprVar));
        this.rewrite(matchBlockStmt, this.env);
        this.result = matchBlockStmt;
        this.onFailClause = currentOnFailClause;
    }

    private BLangStatement convertMatchClausesToIfElseStmt(List<BLangMatchClause> matchClauses, BLangSimpleVariable matchExprVar) {
        BLangIf parentIfNode;
        BLangDo outerScopeBlock;
        BLangDo innerScopeBlock = outerScopeBlock = this.rewriteMatchClauseScope(matchClauses.get((int)0).pos, matchClauses.get(0));
        BLangIf currentIfNode = parentIfNode = this.convertMatchClauseToIfStmt(matchClauses.get(0), matchExprVar);
        for (int i = 1; i < matchClauses.size(); ++i) {
            BLangDo currentScopeBlock = this.rewriteMatchClauseScope(matchClauses.get((int)i).pos, matchClauses.get(i));
            innerScopeBlock.body.stmts.add(0, currentScopeBlock);
            innerScopeBlock = currentScopeBlock;
            currentIfNode.elseStmt = this.convertMatchClauseToIfStmt(matchClauses.get(i), matchExprVar);
            currentIfNode = (BLangIf)currentIfNode.elseStmt;
        }
        innerScopeBlock.body.stmts.add(parentIfNode);
        return outerScopeBlock;
    }

    private BLangDo rewriteMatchClauseScope(Location pos, BLangMatchClause matchClause) {
        BLangDo doStmt = (BLangDo)TreeBuilder.createDoNode();
        BLangBlockStmt scopeBlock = ASTBuilderUtil.createBlockStmt(pos);
        scopeBlock.scope = new Scope(matchClause.blockStmt.scope.owner);
        scopeBlock.scope.entries = matchClause.blockStmt.scope.entries;
        matchClause.blockStmt.scope = new Scope(scopeBlock.scope.owner);
        doStmt.body = scopeBlock;
        return doStmt;
    }

    private BLangIf convertMatchClauseToIfStmt(BLangMatchClause matchClause, BLangSimpleVariable matchExprVar) {
        BLangExpression ifCondition = this.createConditionFromMatchPatterns(matchClause, matchExprVar, matchClause.pos);
        if (matchClause.matchGuard != null) {
            ifCondition = ASTBuilderUtil.createBinaryExpr(matchClause.pos, ifCondition, matchClause.matchGuard.expr, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
        }
        return ASTBuilderUtil.createIfElseStmt(matchClause.pos, ifCondition, matchClause.blockStmt, null);
    }

    private BLangExpression createConditionFromMatchPatterns(BLangMatchClause matchClause, BLangSimpleVariable matchExprVar, Location pos) {
        BLangIf parentIfElse;
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$result$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        BLangBlockStmt mainBlock = ASTBuilderUtil.createBlockStmt(pos);
        mainBlock.addStatement(resultVarDef);
        this.defineVars(mainBlock, new ArrayList<BVarSymbol>(matchClause.declaredVars.values()));
        BLangBlockStmt successBody = this.createSuccessOrFailureBody(true, resultVarRef, pos);
        List<BLangMatchPattern> matchPatterns = matchClause.matchPatterns;
        BLangIf currentIfElse = parentIfElse = this.createIfElseStmtFromMatchPattern(matchPatterns.get(0), matchExprVar, successBody, pos);
        for (int i = 1; i < matchPatterns.size(); ++i) {
            successBody = this.createSuccessOrFailureBody(true, resultVarRef, pos);
            currentIfElse.elseStmt = this.createIfElseStmtFromMatchPattern(matchPatterns.get(i), matchExprVar, successBody, matchPatterns.get((int)i).pos);
            currentIfElse = (BLangIf)currentIfElse.elseStmt;
        }
        currentIfElse.elseStmt = this.createSuccessOrFailureBody(false, resultVarRef, pos);
        mainBlock.addStatement(parentIfElse);
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(mainBlock, resultVarRef);
        return this.rewriteExpr(stmtExpr);
    }

    private void defineVars(BLangBlockStmt blockStmt, List<BVarSymbol> vars) {
        for (BVarSymbol var : vars) {
            BLangSimpleVariable simpleVariable = ASTBuilderUtil.createVariable(var.pos, var.name.value, var.type, null, var);
            BLangSimpleVariableDef simpleVariableDef = ASTBuilderUtil.createVariableDef(var.pos, simpleVariable);
            BLangSimpleVarRef simpleVarRef = ASTBuilderUtil.createVariableRef(var.pos, var);
            this.declaredVarDef.put(var.name.value, simpleVarRef);
            blockStmt.addStatement(simpleVariableDef);
        }
    }

    private BLangBlockStmt createSuccessOrFailureBody(boolean status, BLangSimpleVarRef varRef, Location pos) {
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(pos);
        BLangAssignment bLangAssignment = ASTBuilderUtil.createAssignmentStmt(pos, varRef, this.getBooleanLiteral(status));
        blockStmt.addStatement(bLangAssignment);
        return blockStmt;
    }

    private BLangIf createIfElseStmtFromMatchPattern(BLangMatchPattern matchPattern, BLangSimpleVariable matchExprVar, BLangBlockStmt successBody, Location pos) {
        BLangSimpleVarRef matchExprVarRef = ASTBuilderUtil.createVariableRef(matchExprVar.pos, matchExprVar.symbol);
        BLangExpression condition = this.createConditionForMatchPattern(matchPattern, matchExprVarRef);
        successBody.getStatements().addAll(this.matchStmtsForPattern);
        this.matchStmtsForPattern.clear();
        return ASTBuilderUtil.createIfElseStmt(pos, condition, successBody, null);
    }

    private BLangExpression createConditionForMatchPattern(BLangMatchPattern matchPattern, BLangSimpleVarRef matchExprVarRef) {
        NodeKind patternKind = matchPattern.getKind();
        return switch (patternKind) {
            case NodeKind.WILDCARD_MATCH_PATTERN -> this.createConditionForWildCardMatchPattern((BLangWildCardMatchPattern)matchPattern, matchExprVarRef);
            case NodeKind.CONST_MATCH_PATTERN -> this.createConditionForConstMatchPattern((BLangConstPattern)matchPattern, matchExprVarRef);
            case NodeKind.VAR_BINDING_PATTERN_MATCH_PATTERN -> this.createConditionForVarBindingPatternMatchPattern((BLangVarBindingPatternMatchPattern)matchPattern, matchExprVarRef);
            case NodeKind.LIST_MATCH_PATTERN -> this.createConditionForListMatchPattern((BLangListMatchPattern)matchPattern, matchExprVarRef);
            case NodeKind.MAPPING_MATCH_PATTERN -> this.createConditionForMappingMatchPattern((BLangMappingMatchPattern)matchPattern, matchExprVarRef);
            case NodeKind.ERROR_MATCH_PATTERN -> this.createConditionForErrorMatchPattern((BLangErrorMatchPattern)matchPattern, matchExprVarRef);
            default -> null;
        };
    }

    private BLangExpression createConditionForWildCardMatchPattern(BLangWildCardMatchPattern wildCardMatchPattern, BLangSimpleVarRef matchExprVarRef) {
        BLangLiteral lhsCheck = ASTBuilderUtil.createLiteral(wildCardMatchPattern.pos, this.symTable.booleanType, this.types.isAssignable(matchExprVarRef.getBType(), wildCardMatchPattern.getBType()));
        BLangValueType anyType = (BLangValueType)TreeBuilder.createValueTypeNode();
        anyType.setBType(this.symTable.anyType);
        anyType.typeKind = TypeKind.ANY;
        BLangTypeTestExpr rhsCheck = this.createTypeCheckExpr(wildCardMatchPattern.pos, matchExprVarRef, anyType);
        return ASTBuilderUtil.createBinaryExpr(wildCardMatchPattern.pos, lhsCheck, rhsCheck, this.symTable.booleanType, OperatorKind.OR, null);
    }

    private BLangExpression createConditionForConstMatchPattern(BLangConstPattern constPattern, BLangSimpleVarRef matchExprVarRef) {
        return this.createBinaryExpression(constPattern.pos, matchExprVarRef, constPattern.expr);
    }

    private BLangExpression createConditionForWildCardBindingPattern(BLangWildCardBindingPattern wildCardBindingPattern, BLangSimpleVarRef matchExprVarRef) {
        return ASTBuilderUtil.createLiteral(wildCardBindingPattern.pos, this.symTable.booleanType, this.types.isAssignable(matchExprVarRef.getBType(), wildCardBindingPattern.getBType()));
    }

    private BLangExpression createConditionForCaptureBindingPattern(BLangCaptureBindingPattern captureBindingPattern, BLangSimpleVarRef matchExprVarRef) {
        Location pos = captureBindingPattern.pos;
        BLangSimpleVarRef captureBindingPatternVarRef = this.declaredVarDef.get(captureBindingPattern.getIdentifier().getValue());
        this.matchStmtsForPattern.add(ASTBuilderUtil.createAssignmentStmt(pos, captureBindingPatternVarRef, matchExprVarRef));
        return ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true);
    }

    private BLangExpression createConditionForListBindingPattern(BLangListBindingPattern listBindingPattern, BLangSimpleVarRef matchExprVarRef) {
        Location pos = listBindingPattern.pos;
        BType bindingPatternType = listBindingPattern.getBType();
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$listBindingPatternResult$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        BLangBlockStmt mainBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        mainBlockStmt.addStatement(resultVarDef);
        if (bindingPatternType == this.symTable.noType) {
            return this.createConditionForUnmatchedPattern(resultVarRef, mainBlockStmt);
        }
        BLangAssignment failureResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(false));
        BLangAssignment successResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(true));
        mainBlockStmt.addStatement(failureResult);
        BLangIsLikeExpr typeCheckCondition = this.createIsLikeExpression(listBindingPattern.pos, matchExprVarRef, bindingPatternType);
        BLangExpression typeConvertedExpr = this.types.addConversionExprIfRequired(matchExprVarRef, bindingPatternType);
        BLangSimpleVariableDef tempCastVarDef = this.createVarDef("$castTemp$", bindingPatternType, typeConvertedExpr, pos);
        BLangSimpleVarRef tempCastVarRef = ASTBuilderUtil.createVariableRef(pos, tempCastVarDef.var.symbol);
        BLangBlockStmt ifBlock = ASTBuilderUtil.createBlockStmt(pos);
        ifBlock.addStatement(tempCastVarDef);
        BLangIf ifStmt = ASTBuilderUtil.createIfElseStmt(pos, typeCheckCondition, ifBlock, null);
        mainBlockStmt.addStatement(ifStmt);
        List<BLangBindingPattern> bindingPatterns = listBindingPattern.bindingPatterns;
        BLangExpression condition = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true);
        for (int i = 0; i < bindingPatterns.size(); ++i) {
            BLangExpression memberPatternCondition = this.createConditionForListMemberPattern(i, bindingPatterns.get(i), tempCastVarDef, ifBlock, bindingPatterns.get(i).getBType(), pos);
            if (memberPatternCondition.getKind() == NodeKind.LITERAL && ((Boolean)((BLangLiteral)memberPatternCondition).value).booleanValue()) continue;
            condition = ASTBuilderUtil.createBinaryExpr(pos, condition, memberPatternCondition, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
        }
        BLangBlockStmt tempBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        tempBlockStmt.addStatement(successResult);
        if (listBindingPattern.restBindingPattern != null) {
            BLangRestBindingPattern restBindingPattern = listBindingPattern.restBindingPattern;
            BLangSimpleVarRef restBindingPatternVarRef = this.declaredVarDef.get(restBindingPattern.variableName.value);
            this.matchStmtsForPattern.add(ASTBuilderUtil.createAssignmentStmt(pos, restBindingPatternVarRef, this.createLangLibInvocationNode("slice", tempCastVarRef, new ArrayList<BLangExpression>(Arrays.asList(new BLangLiteral(bindingPatterns.size(), this.symTable.intType))), null, pos)));
        }
        BLangIf ifStmtForMatchPatterns = ASTBuilderUtil.createIfElseStmt(pos, condition, tempBlockStmt, null);
        ifBlock.addStatement(ifStmtForMatchPatterns);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(mainBlockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        return statementExpression;
    }

    private BLangExpression createConditionForListMemberPattern(int index, BLangBindingPattern bindingPattern, BLangSimpleVariableDef tempCastVarDef, BLangBlockStmt blockStmt, BType type, Location pos) {
        BLangExpression indexExpr = this.createIndexBasedAccessExpr(type, pos, new BLangLiteral(index, this.symTable.intType), tempCastVarDef.var.symbol, null);
        BLangSimpleVariableDef tempVarDef = this.createVarDef("$memberVarTemp$" + index + "_$", type, indexExpr, bindingPattern.pos);
        BLangSimpleVarRef tempVarRef = ASTBuilderUtil.createVariableRef(pos, tempVarDef.var.symbol);
        blockStmt.addStatement(tempVarDef);
        return this.createVarCheckCondition(bindingPattern, tempVarRef);
    }

    private BLangExpression createVarCheckCondition(BLangBindingPattern bindingPattern, BLangSimpleVarRef varRef) {
        NodeKind bindingPatternKind = bindingPattern.getKind();
        return switch (bindingPatternKind) {
            case NodeKind.WILDCARD_BINDING_PATTERN -> this.createConditionForWildCardBindingPattern((BLangWildCardBindingPattern)bindingPattern, varRef);
            case NodeKind.CAPTURE_BINDING_PATTERN -> this.createConditionForCaptureBindingPattern((BLangCaptureBindingPattern)bindingPattern, varRef);
            case NodeKind.LIST_BINDING_PATTERN -> this.createVarCheckConditionForListBindingPattern((BLangListBindingPattern)bindingPattern, varRef);
            case NodeKind.MAPPING_BINDING_PATTERN -> this.createVarCheckConditionForMappingBindingPattern((BLangMappingBindingPattern)bindingPattern, varRef);
            case NodeKind.ERROR_BINDING_PATTERN -> this.createConditionForErrorBindingPattern((BLangErrorBindingPattern)bindingPattern, varRef);
            default -> null;
        };
    }

    private BLangExpression createVarCheckConditionForListBindingPattern(BLangListBindingPattern listBindingPattern, BLangSimpleVarRef varRef) {
        Location pos = listBindingPattern.pos;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(pos);
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$listPatternVarResult$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        blockStmt.addStatement(resultVarDef);
        if (listBindingPattern.getBType() == this.symTable.noType) {
            return this.createConditionForUnmatchedPattern(resultVarRef, blockStmt);
        }
        BLangAssignment failureResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(false));
        BLangAssignment successResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(true));
        blockStmt.addStatement(failureResult);
        List<BType> memberTupleTypes = ((BTupleType)listBindingPattern.getBType()).getTupleTypes();
        List<BLangBindingPattern> bindingPatterns = listBindingPattern.bindingPatterns;
        BLangSimpleVariableDef tempCastVarDef = this.createVarDef("$castTemp$", listBindingPattern.getBType(), varRef, pos);
        BLangSimpleVarRef tempCastVarRef = ASTBuilderUtil.createVariableRef(pos, tempCastVarDef.var.symbol);
        blockStmt.addStatement(tempCastVarDef);
        BLangBlockStmt tempBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        tempBlockStmt.addStatement(successResult);
        if (!bindingPatterns.isEmpty()) {
            BLangExpression condition = this.createConditionForListMemberPattern(0, bindingPatterns.get(0), tempCastVarDef, blockStmt, memberTupleTypes.get(0), pos);
            for (int i = 1; i < bindingPatterns.size(); ++i) {
                BLangExpression memberPatternCondition = this.createConditionForListMemberPattern(i, bindingPatterns.get(i), tempCastVarDef, blockStmt, memberTupleTypes.get(i), pos);
                condition = ASTBuilderUtil.createBinaryExpr(pos, condition, memberPatternCondition, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
            }
            BLangIf ifStmtForMatchPatterns = ASTBuilderUtil.createIfElseStmt(pos, condition, tempBlockStmt, null);
            blockStmt.addStatement(ifStmtForMatchPatterns);
        } else {
            blockStmt.addStatement(tempBlockStmt);
        }
        if (listBindingPattern.restBindingPattern != null) {
            BLangRestBindingPattern restBindingPattern = listBindingPattern.restBindingPattern;
            BLangSimpleVarRef restBindingPatternVarRef = this.declaredVarDef.get(restBindingPattern.variableName.value);
            this.matchStmtsForPattern.add(ASTBuilderUtil.createAssignmentStmt(pos, restBindingPatternVarRef, this.createLangLibInvocationNode("slice", tempCastVarRef, new ArrayList<BLangExpression>(Arrays.asList(new BLangLiteral(bindingPatterns.size(), this.symTable.intType))), null, pos)));
        }
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        return statementExpression;
    }

    private BLangExpression createConditionForVarBindingPatternMatchPattern(BLangVarBindingPatternMatchPattern varBindingPatternMatchPattern, BLangSimpleVarRef matchExprVarRef) {
        BLangBindingPattern bindingPattern = varBindingPatternMatchPattern.getBindingPattern();
        Location pos = bindingPattern.pos;
        return switch (bindingPattern.getKind()) {
            case NodeKind.WILDCARD_BINDING_PATTERN -> this.createConditionForWildCardBindingPattern((BLangWildCardBindingPattern)bindingPattern, matchExprVarRef);
            case NodeKind.CAPTURE_BINDING_PATTERN -> this.createConditionForCaptureBindingPattern((BLangCaptureBindingPattern)bindingPattern, matchExprVarRef, pos);
            case NodeKind.LIST_BINDING_PATTERN -> this.createConditionForListBindingPattern((BLangListBindingPattern)bindingPattern, matchExprVarRef);
            case NodeKind.MAPPING_BINDING_PATTERN -> this.createConditionForMappingBindingPattern((BLangMappingBindingPattern)bindingPattern, matchExprVarRef);
            case NodeKind.ERROR_BINDING_PATTERN -> this.createConditionForErrorBindingPattern((BLangErrorBindingPattern)bindingPattern, matchExprVarRef);
            default -> null;
        };
    }

    private BLangExpression createConditionForCaptureBindingPattern(BLangCaptureBindingPattern captureBindingPattern, BLangSimpleVarRef matchExprVarRef, Location pos) {
        BLangSimpleVarRef captureBindingPatternVarRef = this.declaredVarDef.get(captureBindingPattern.getIdentifier().getValue());
        this.matchStmtsForPattern.add(ASTBuilderUtil.createAssignmentStmt(pos, captureBindingPatternVarRef, matchExprVarRef));
        return ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true);
    }

    private BLangExpression createConditionForMappingBindingPattern(BLangMappingBindingPattern mappingBindingPattern, BLangSimpleVarRef matchExprVarRef) {
        BType bindingPatternType = mappingBindingPattern.getBType();
        Location pos = mappingBindingPattern.pos;
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$mappingBindingPatternResult$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        BLangBlockStmt mainBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        mainBlockStmt.addStatement(resultVarDef);
        if (bindingPatternType == this.symTable.noType) {
            return this.createConditionForUnmatchedPattern(resultVarRef, mainBlockStmt);
        }
        BLangAssignment failureResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(false));
        BLangAssignment successResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(true));
        mainBlockStmt.addStatement(failureResult);
        BLangIsLikeExpr typeCheckCondition = this.createIsLikeExpression(pos, matchExprVarRef, bindingPatternType);
        BLangExpression typeConvertedExpr = this.types.addConversionExprIfRequired(matchExprVarRef, bindingPatternType);
        BLangSimpleVariableDef tempCastVarDef = this.createVarDef("$castTemp$", bindingPatternType, typeConvertedExpr, pos);
        BLangSimpleVarRef tempCastVarRef = ASTBuilderUtil.createVariableRef(pos, tempCastVarDef.var.symbol);
        BLangBlockStmt ifBlock = ASTBuilderUtil.createBlockStmt(pos);
        ifBlock.addStatement(tempCastVarDef);
        BLangIf ifStmt = ASTBuilderUtil.createIfElseStmt(pos, typeCheckCondition, ifBlock, null);
        mainBlockStmt.addStatement(ifStmt);
        BLangExpression condition = this.createConditionForFieldBindingPatterns(mappingBindingPattern.fieldBindingPatterns, tempCastVarDef, ifBlock, pos);
        BLangBlockStmt tempBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        tempBlockStmt.addStatement(successResult);
        if (mappingBindingPattern.restBindingPattern != null) {
            BLangRestBindingPattern restBindingPattern = mappingBindingPattern.restBindingPattern;
            Location restPatternPos = restBindingPattern.pos;
            List<String> keysToRemove = this.getKeysToRemove(mappingBindingPattern);
            BLangSimpleVarRef restMatchPatternVarRef = this.declaredVarDef.get(restBindingPattern.getIdentifier().getValue());
            this.createRestPattern(restPatternPos, keysToRemove, tempCastVarRef, restBindingPattern.getBType(), tempBlockStmt, restMatchPatternVarRef);
        }
        BLangIf ifStmtForMatchPatterns = ASTBuilderUtil.createIfElseStmt(pos, condition, tempBlockStmt, null);
        ifBlock.addStatement(ifStmtForMatchPatterns);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(mainBlockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        this.addAsRecordTypeDefinition(bindingPatternType, pos);
        return statementExpression;
    }

    private BLangExpression createConditionForErrorBindingPattern(BLangErrorBindingPattern errorBindingPattern, BLangSimpleVarRef matchExprVarRef) {
        BType bindingPatternType = errorBindingPattern.getBType();
        Location pos = errorBindingPattern.pos;
        BLangSimpleVariableDef resultVarDef = this.createVarDef("errorBindingPatternResult$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        BLangBlockStmt mainBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        mainBlockStmt.addStatement(resultVarDef);
        if (bindingPatternType == this.symTable.noType) {
            return this.createConditionForUnmatchedPattern(resultVarRef, mainBlockStmt);
        }
        BLangAssignment failureResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(false));
        BLangAssignment successResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(true));
        mainBlockStmt.addStatement(failureResult);
        BLangIsLikeExpr typeCheckCondition = this.createIsLikeExpression(pos, matchExprVarRef, bindingPatternType);
        BLangExpression typeConvertedExpr = this.types.addConversionExprIfRequired(matchExprVarRef, bindingPatternType);
        BLangSimpleVariableDef tempCastVarDef = this.createVarDef("$castTemp$", bindingPatternType, typeConvertedExpr, pos);
        BLangSimpleVarRef tempCastVarRef = ASTBuilderUtil.createVariableRef(pos, tempCastVarDef.var.symbol);
        BLangBlockStmt ifBlock = ASTBuilderUtil.createBlockStmt(pos);
        ifBlock.addStatement(tempCastVarDef);
        BLangIf ifStmt = ASTBuilderUtil.createIfElseStmt(pos, typeCheckCondition, ifBlock, null);
        mainBlockStmt.addStatement(ifStmt);
        BLangBlockStmt tempBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        BLangExpression condition = this.createConditionForErrorArgListBindingPattern(errorBindingPattern, ifBlock, tempBlockStmt, tempCastVarRef, pos);
        tempBlockStmt.addStatement(successResult);
        BLangIf ifStmtForMatchPatterns = ASTBuilderUtil.createIfElseStmt(pos, condition, tempBlockStmt, null);
        ifBlock.addStatement(ifStmtForMatchPatterns);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(mainBlockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        return statementExpression;
    }

    private BLangExpression createConditionForErrorArgListBindingPattern(BLangErrorBindingPattern errorBindingPattern, BLangBlockStmt ifBlock, BLangBlockStmt restPatternBlock, BLangSimpleVarRef varRef, Location pos) {
        BLangExpression condition = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true);
        if (errorBindingPattern.errorMessageBindingPattern != null) {
            Location messagePos = errorBindingPattern.errorMessageBindingPattern.pos;
            BLangInvocation messageInvocation = this.createLangLibInvocationNode(ERROR_MESSAGE_FUNCTION_NAME, varRef, new ArrayList<BLangExpression>(), null, messagePos);
            BLangSimpleVariableDef messageVarDef = this.createVarDef("$errorMessage$", messageInvocation.getBType(), messageInvocation, messagePos);
            ifBlock.addStatement(messageVarDef);
            BLangSimpleVarRef messageVarRef = ASTBuilderUtil.createVariableRef(messagePos, messageVarDef.var.symbol);
            condition = this.createConditionForErrorMessageBindingPattern(errorBindingPattern.errorMessageBindingPattern, messageVarRef);
        }
        if (errorBindingPattern.errorCauseBindingPattern != null) {
            Location errorCausePos = errorBindingPattern.errorCauseBindingPattern.pos;
            BLangInvocation causeInvocation = this.createLangLibInvocationNode(ERROR_CAUSE_FUNCTION_NAME, varRef, new ArrayList<BLangExpression>(), null, errorCausePos);
            BLangSimpleVariableDef causeVarDef = this.createVarDef("$errorCause$", causeInvocation.getBType(), causeInvocation, errorCausePos);
            ifBlock.addStatement(causeVarDef);
            BLangSimpleVarRef causeVarRef = ASTBuilderUtil.createVariableRef(errorCausePos, causeVarDef.var.symbol);
            BLangExpression errorCauseCondition = this.createConditionForErrorCauseBindingPattern(errorBindingPattern.errorCauseBindingPattern, causeVarRef);
            condition = ASTBuilderUtil.createBinaryExpr(pos, condition, errorCauseCondition, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
        }
        if (errorBindingPattern.errorFieldBindingPatterns != null) {
            Location errorFieldPos = errorBindingPattern.errorFieldBindingPatterns.pos;
            BLangInvocation errorDetailInvocation = this.createLangLibInvocationNode(ERROR_DETAIL_FUNCTION_NAME, varRef, new ArrayList<BLangExpression>(), null, errorFieldPos);
            BLangSimpleVariableDef errorDetailVarDef = this.createVarDef("$errorDetail$", errorDetailInvocation.getBType(), errorDetailInvocation, errorFieldPos);
            ifBlock.addStatement(errorDetailVarDef);
            BLangSimpleVarRef errorDetailVarRef = ASTBuilderUtil.createVariableRef(errorFieldPos, errorDetailVarDef.var.symbol);
            BLangExpression errorDetailCondition = this.createConditionForErrorFieldBindingPatterns(errorBindingPattern.errorFieldBindingPatterns, errorDetailVarRef);
            condition = condition != null ? ASTBuilderUtil.createBinaryExpr(pos, condition, errorDetailCondition, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType)) : errorDetailCondition;
            if (errorBindingPattern.errorFieldBindingPatterns.restBindingPattern != null) {
                BLangRestBindingPattern restBindingPattern = errorBindingPattern.errorFieldBindingPatterns.restBindingPattern;
                Location restPatternPos = restBindingPattern.pos;
                List<String> keysToRemove = this.getKeysToRemove(errorBindingPattern.errorFieldBindingPatterns);
                BVarSymbol stringVarSymbol = new BVarSymbol(0L, null, null, this.symTable.stringType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
                BVarSymbol anydataVarSymbol = new BVarSymbol(0L, null, null, this.symTable.anydataType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
                BMapType entriesType = new BMapType(this.symTable.typeEnv(), 16, new BTupleType(this.symTable.typeEnv(), Arrays.asList(new BTupleMember(this.symTable.stringType, stringVarSymbol), new BTupleMember(this.symTable.anydataType, anydataVarSymbol))), null);
                BLangInvocation entriesInvocation = this.generateMapEntriesInvocation(errorDetailVarRef, entriesType);
                BLangSimpleVariableDef entriesVarDef = this.createVarDef("$entries$", entriesType, entriesInvocation, restPatternPos);
                restPatternBlock.addStatement(entriesVarDef);
                BLangLambdaFunction filteringFunction = this.createFuncToFilterOutRestParam(keysToRemove, restPatternPos);
                BLangInvocation filterInvocation = this.generateMapFilterInvocation(pos, entriesVarDef.var, filteringFunction);
                BLangSimpleVariableDef filtersVarDef = this.createVarDef("$filteredVarDef$", entriesType, filterInvocation, restPatternPos);
                restPatternBlock.addStatement(filtersVarDef);
                BType errFieldRestType = errorBindingPattern.errorFieldBindingPatterns.restBindingPattern.getBType();
                BLangLambdaFunction backToMapLambda = this.generateEntriesToMapLambda(restPatternPos, ((BMapType)errFieldRestType).constraint);
                BLangInvocation mapInvocation = this.generateMapMapInvocation(restPatternPos, filtersVarDef.var, backToMapLambda);
                BLangSimpleVarRef restMatchPatternVarRef = this.declaredVarDef.get(restBindingPattern.getIdentifier().getValue());
                restPatternBlock.addStatement(ASTBuilderUtil.createAssignmentStmt(pos, restMatchPatternVarRef, mapInvocation));
            }
        }
        return condition;
    }

    private BLangExpression createConditionForListMatchPattern(BLangListMatchPattern listMatchPattern, BLangSimpleVarRef matchExprVarRef) {
        Location pos = listMatchPattern.pos;
        BType matchPatternType = listMatchPattern.getBType();
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$listPatternResult$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        BLangBlockStmt mainBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        mainBlockStmt.addStatement(resultVarDef);
        if (matchPatternType == this.symTable.noType) {
            return this.createConditionForUnmatchedPattern(resultVarRef, mainBlockStmt);
        }
        BLangAssignment failureResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(false));
        BLangAssignment successResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(true));
        mainBlockStmt.addStatement(failureResult);
        BLangIsLikeExpr typeCheckCondition = this.createIsLikeExpression(listMatchPattern.pos, matchExprVarRef, matchPatternType);
        BLangExpression typeConvertedExpr = this.types.addConversionExprIfRequired(matchExprVarRef, matchPatternType);
        BLangSimpleVariableDef tempCastVarDef = this.createVarDef("$castTemp$", matchPatternType, typeConvertedExpr, pos);
        BLangSimpleVarRef tempCastVarRef = ASTBuilderUtil.createVariableRef(pos, tempCastVarDef.var.symbol);
        BLangBlockStmt ifBlock = ASTBuilderUtil.createBlockStmt(pos);
        ifBlock.addStatement(tempCastVarDef);
        BLangIf ifStmt = ASTBuilderUtil.createIfElseStmt(pos, typeCheckCondition, ifBlock, null);
        mainBlockStmt.addStatement(ifStmt);
        List<BLangMatchPattern> matchPatterns = listMatchPattern.matchPatterns;
        BLangExpression condition = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true);
        for (int i = 0; i < matchPatterns.size(); ++i) {
            BLangExpression memberPatternCondition = this.createConditionForListMemberPattern(i, matchPatterns.get(i), tempCastVarDef, ifBlock, matchPatterns.get(i).getBType(), pos);
            if (memberPatternCondition.getKind() == NodeKind.LITERAL && ((Boolean)((BLangLiteral)memberPatternCondition).value).booleanValue()) continue;
            condition = ASTBuilderUtil.createBinaryExpr(pos, condition, memberPatternCondition, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
        }
        BLangBlockStmt tempBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        tempBlockStmt.addStatement(successResult);
        if (listMatchPattern.restMatchPattern != null) {
            BLangRestMatchPattern restMatchPattern = listMatchPattern.restMatchPattern;
            BLangSimpleVarRef restMatchPatternVarRef = this.declaredVarDef.get(restMatchPattern.getIdentifier().getValue());
            this.matchStmtsForPattern.add(ASTBuilderUtil.createAssignmentStmt(pos, restMatchPatternVarRef, this.createLangLibInvocationNode("slice", tempCastVarRef, new ArrayList<BLangExpression>(Arrays.asList(new BLangLiteral(matchPatterns.size(), this.symTable.intType))), null, pos)));
        }
        BLangIf ifStmtForMatchPatterns = ASTBuilderUtil.createIfElseStmt(pos, condition, tempBlockStmt, null);
        ifBlock.addStatement(ifStmtForMatchPatterns);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(mainBlockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        return statementExpression;
    }

    private BLangExpression createConditionForListMemberPattern(int index, BLangMatchPattern listMemberMatchPattern, BLangSimpleVariableDef tempCastVarDef, BLangBlockStmt blockStmt, BType type, Location pos) {
        BLangExpression indexExpr = this.createIndexBasedAccessExpr(type, pos, new BLangLiteral(index, this.symTable.intType), tempCastVarDef.var.symbol, null);
        BLangSimpleVariableDef tempVarDef = this.createVarDef("$memberVarTemp$" + index + "_$", type, indexExpr, listMemberMatchPattern.pos);
        BLangSimpleVarRef tempVarRef = ASTBuilderUtil.createVariableRef(pos, tempVarDef.var.symbol);
        blockStmt.addStatement(tempVarDef);
        return this.createVarCheckCondition(listMemberMatchPattern, tempVarRef);
    }

    private BLangExpression createConditionForMappingMatchPattern(BLangMappingMatchPattern mappingMatchPattern, BLangSimpleVarRef matchExprVarRef) {
        BType matchPatternType = mappingMatchPattern.getBType();
        Location pos = mappingMatchPattern.pos;
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$mappingPatternResult$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        BLangBlockStmt mainBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        mainBlockStmt.addStatement(resultVarDef);
        if (matchPatternType == this.symTable.noType) {
            return this.createConditionForUnmatchedPattern(resultVarRef, mainBlockStmt);
        }
        BLangAssignment failureResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(false));
        BLangAssignment successResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(true));
        mainBlockStmt.addStatement(failureResult);
        BLangIsLikeExpr typeCheckCondition = this.createIsLikeExpression(mappingMatchPattern.pos, matchExprVarRef, matchPatternType);
        BLangExpression typeConvertedExpr = this.types.addConversionExprIfRequired(matchExprVarRef, matchPatternType);
        BLangSimpleVariableDef tempCastVarDef = this.createVarDef("$castTemp$", matchPatternType, typeConvertedExpr, pos);
        BLangSimpleVarRef tempCastVarRef = ASTBuilderUtil.createVariableRef(pos, tempCastVarDef.var.symbol);
        BLangBlockStmt ifBlock = ASTBuilderUtil.createBlockStmt(pos);
        ifBlock.addStatement(tempCastVarDef);
        BLangIf ifStmt = ASTBuilderUtil.createIfElseStmt(pos, typeCheckCondition, ifBlock, null);
        mainBlockStmt.addStatement(ifStmt);
        BLangExpression condition = this.createConditionForFieldMatchPatterns(mappingMatchPattern.fieldMatchPatterns, tempCastVarDef, ifBlock, pos);
        BLangBlockStmt tempBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        tempBlockStmt.addStatement(successResult);
        if (mappingMatchPattern.restMatchPattern != null) {
            BLangRestMatchPattern restMatchPattern = mappingMatchPattern.restMatchPattern;
            Location restPatternPos = restMatchPattern.pos;
            List<String> keysToRemove = this.getKeysToRemove(mappingMatchPattern);
            BLangSimpleVarRef restMatchPatternVarRef = this.declaredVarDef.get(restMatchPattern.getIdentifier().getValue());
            this.createRestPattern(restPatternPos, keysToRemove, tempCastVarRef, restMatchPattern.getBType(), tempBlockStmt, restMatchPatternVarRef);
        }
        BLangIf ifStmtForMatchPatterns = ASTBuilderUtil.createIfElseStmt(pos, condition, tempBlockStmt, null);
        ifBlock.addStatement(ifStmtForMatchPatterns);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(mainBlockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        this.addAsRecordTypeDefinition(matchPatternType, pos);
        return statementExpression;
    }

    private void createRestPattern(Location pos, List<String> keysToRemove, BLangSimpleVarRef matchExprVarRef, BType targetType, BLangBlockStmt blockStmt, BLangSimpleVarRef restMatchPatternVarRef) {
        BType constraintType = this.getRestFilterConstraintType(targetType);
        BVarSymbol varSymbol = new BVarSymbol(constraintType.getFlags(), null, null, constraintType, null, null, null);
        BVarSymbol stringVarSymbol = new BVarSymbol(0L, null, null, this.symTable.stringType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        BMapType entriesType = new BMapType(this.symTable.typeEnv(), 16, new BTupleType(this.symTable.typeEnv(), Arrays.asList(new BTupleMember(this.symTable.stringType, stringVarSymbol), new BTupleMember(constraintType, varSymbol))), null);
        BLangInvocation entriesInvocation = this.generateMapEntriesInvocation(matchExprVarRef, entriesType);
        BLangSimpleVariableDef entriesVarDef = this.createVarDef("$entries$", entriesType, entriesInvocation, pos);
        blockStmt.addStatement(entriesVarDef);
        BLangLambdaFunction filteringFunction = this.createFuncToFilterOutRestParam(keysToRemove, pos);
        BLangInvocation filterInvocation = this.generateMapFilterInvocation(pos, entriesVarDef.var, filteringFunction);
        BLangSimpleVariableDef filtersVarDef = this.createVarDef("$filteredVarDef$", entriesType, filterInvocation, pos);
        blockStmt.addStatement(filtersVarDef);
        BLangLambdaFunction backToMapLambda = this.generateEntriesToMapLambda(pos, constraintType);
        BLangInvocation mapInvocation = this.generateMapMapInvocation(pos, filtersVarDef.var, backToMapLambda);
        BLangSimpleVariableDef mappedVarDef = this.createVarDef("$mappedVarDef$", entriesType, mapInvocation, pos);
        blockStmt.addStatement(mappedVarDef);
        BLangInvocation recordConversion = this.generateCreateRecordValueInvocation(pos, targetType, mappedVarDef.var.symbol);
        BLangSimpleVariableDef recordVarDef = this.createVarDef("$recordVarDef$", entriesType, recordConversion, pos);
        blockStmt.addStatement(recordVarDef);
        blockStmt.addStatement(ASTBuilderUtil.createAssignmentStmt(pos, restMatchPatternVarRef, this.types.addConversionExprIfRequired(ASTBuilderUtil.createVariableRef(pos, recordVarDef.var.symbol), targetType)));
    }

    private List<String> getKeysToRemove(BLangMappingMatchPattern mappingMatchPattern) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (BLangFieldMatchPattern fieldMatchPattern : mappingMatchPattern.fieldMatchPatterns) {
            keysToRemove.add(fieldMatchPattern.fieldName.value);
        }
        return keysToRemove;
    }

    private List<String> getKeysToRemove(BLangMappingBindingPattern mappingBindingPattern) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        List<BLangFieldBindingPattern> fieldBindingPatterns = mappingBindingPattern.fieldBindingPatterns;
        for (BLangFieldBindingPattern fieldBindingPattern : fieldBindingPatterns) {
            keysToRemove.add(fieldBindingPattern.fieldName.value);
        }
        return keysToRemove;
    }

    private BLangExpression createConditionForFieldMatchPatterns(List<BLangFieldMatchPattern> fieldMatchPatterns, BLangSimpleVariableDef varDef, BLangBlockStmt blockStmt, Location pos) {
        BLangExpression condition = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true);
        for (int i = 0; i < fieldMatchPatterns.size(); ++i) {
            BLangExpression fieldMatchPatternCondition = this.createConditionForFieldMatchPattern(i, fieldMatchPatterns.get(i), varDef, blockStmt);
            condition = ASTBuilderUtil.createBinaryExpr(pos, condition, fieldMatchPatternCondition, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
        }
        return condition;
    }

    private BLangExpression createConditionForFieldMatchPattern(int index, BLangFieldMatchPattern fieldMatchPattern, BLangSimpleVariableDef tempCastVarDef, BLangBlockStmt blockStmt) {
        String fieldName = fieldMatchPattern.fieldName.value;
        BLangMatchPattern matchPattern = fieldMatchPattern.matchPattern;
        BLangFieldBasedAccess fieldBasedAccessExpr = this.getFieldAccessExpression(fieldMatchPattern.pos, fieldName, matchPattern.getBType(), tempCastVarDef.var.symbol);
        BLangSimpleVariableDef tempVarDef = this.createVarDef("$memberVarTemp$" + index + "_$", matchPattern.getBType(), fieldBasedAccessExpr, matchPattern.pos);
        BLangSimpleVarRef tempVarRef = ASTBuilderUtil.createVariableRef(matchPattern.pos, tempVarDef.var.symbol);
        blockStmt.addStatement(tempVarDef);
        return this.createVarCheckCondition(matchPattern, tempVarRef);
    }

    private BLangExpression createConditionForFieldBindingPatterns(List<BLangFieldBindingPattern> fieldBindingPatterns, BLangSimpleVariableDef varDef, BLangBlockStmt blockStmt, Location pos) {
        BLangExpression condition = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true);
        if (fieldBindingPatterns.isEmpty()) {
            return condition;
        }
        condition = this.createConditionForFieldBindingPattern(0, fieldBindingPatterns.get(0), varDef, blockStmt);
        for (int i = 1; i < fieldBindingPatterns.size(); ++i) {
            BLangExpression fieldMatchPatternCondition = this.createConditionForFieldBindingPattern(i, fieldBindingPatterns.get(i), varDef, blockStmt);
            condition = ASTBuilderUtil.createBinaryExpr(pos, condition, fieldMatchPatternCondition, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
        }
        return condition;
    }

    private BLangExpression createConditionForFieldBindingPattern(int index, BLangFieldBindingPattern fieldBindingPattern, BLangSimpleVariableDef tempCastVarDef, BLangBlockStmt blockStmt) {
        String fieldName = fieldBindingPattern.fieldName.value;
        BLangBindingPattern bindingPattern = fieldBindingPattern.bindingPattern;
        BLangFieldBasedAccess fieldBasedAccessExpr = this.getFieldAccessExpression(fieldBindingPattern.pos, fieldName, bindingPattern.getBType(), tempCastVarDef.var.symbol);
        BLangSimpleVariableDef tempVarDef = this.createVarDef("$memberVarTemp$" + index + "_$", bindingPattern.getBType(), fieldBasedAccessExpr, bindingPattern.pos);
        BLangSimpleVarRef tempVarRef = ASTBuilderUtil.createVariableRef(bindingPattern.pos, tempVarDef.var.symbol);
        blockStmt.addStatement(tempVarDef);
        return this.createVarCheckCondition(bindingPattern, tempVarRef);
    }

    private BLangExpression createVarCheckCondition(BLangMatchPattern matchPattern, BLangSimpleVarRef varRef) {
        NodeKind patternKind = matchPattern.getKind();
        return switch (patternKind) {
            case NodeKind.WILDCARD_MATCH_PATTERN -> this.createConditionForWildCardMatchPattern((BLangWildCardMatchPattern)matchPattern, varRef);
            case NodeKind.CONST_MATCH_PATTERN -> this.createConditionForConstMatchPattern((BLangConstPattern)matchPattern, varRef);
            case NodeKind.VAR_BINDING_PATTERN_MATCH_PATTERN -> this.createVarCheckCondition(((BLangVarBindingPatternMatchPattern)matchPattern).getBindingPattern(), varRef);
            case NodeKind.LIST_MATCH_PATTERN -> this.createVarCheckConditionForListMatchPattern((BLangListMatchPattern)matchPattern, varRef);
            case NodeKind.MAPPING_MATCH_PATTERN -> this.createVarCheckConditionForMappingMatchPattern((BLangMappingMatchPattern)matchPattern, varRef);
            case NodeKind.ERROR_MATCH_PATTERN -> this.createConditionForErrorMatchPattern((BLangErrorMatchPattern)matchPattern, varRef);
            default -> null;
        };
    }

    private BLangExpression createVarCheckConditionForMappingBindingPattern(BLangMappingBindingPattern mappingBindingPattern, BLangSimpleVarRef varRef) {
        BType bindingPatternType = mappingBindingPattern.getBType();
        Location pos = mappingBindingPattern.pos;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(pos);
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$mappingBindingPatternVarResult$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        blockStmt.addStatement(resultVarDef);
        if (bindingPatternType == this.symTable.noType) {
            return this.createConditionForUnmatchedPattern(resultVarRef, blockStmt);
        }
        BLangAssignment failureResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(false));
        BLangAssignment successResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(true));
        blockStmt.addStatement(failureResult);
        BLangSimpleVariableDef tempCastVarDef = this.createVarDef("$castTemp$", bindingPatternType, varRef, pos);
        BLangSimpleVarRef tempCastVarRef = ASTBuilderUtil.createVariableRef(pos, tempCastVarDef.var.symbol);
        blockStmt.addStatement(tempCastVarDef);
        BLangExpression condition = this.createConditionForFieldBindingPatterns(mappingBindingPattern.fieldBindingPatterns, tempCastVarDef, blockStmt, pos);
        BLangBlockStmt tempBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        tempBlockStmt.addStatement(successResult);
        this.createRestBindingPatternCondition(mappingBindingPattern, tempBlockStmt, tempCastVarRef);
        BLangIf ifStmtForMatchPatterns = ASTBuilderUtil.createIfElseStmt(pos, condition, tempBlockStmt, null);
        blockStmt.addStatement(ifStmtForMatchPatterns);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        this.addAsRecordTypeDefinition(bindingPatternType, pos);
        return statementExpression;
    }

    private void createRestBindingPatternCondition(BLangMappingBindingPattern mappingBindingPattern, BLangBlockStmt blockStmt, BLangSimpleVarRef varRef) {
        BLangRestBindingPattern restBindingPattern = mappingBindingPattern.restBindingPattern;
        if (restBindingPattern == null) {
            return;
        }
        Location restPatternPos = restBindingPattern.pos;
        List<String> keysToRemove = this.getKeysToRemove(mappingBindingPattern);
        BType restType = ((BRecordType)restBindingPattern.getBType()).restFieldType;
        BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(restType);
        BVarSymbol stringVarSymbol = new BVarSymbol(0L, null, null, this.symTable.stringType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        BMapType entriesType = new BMapType(this.symTable.typeEnv(), 16, new BTupleType(this.symTable.typeEnv(), Arrays.asList(new BTupleMember(this.symTable.stringType, stringVarSymbol), new BTupleMember(restType, varSymbol))), null);
        BLangInvocation entriesInvocation = this.generateMapEntriesInvocation(varRef, entriesType);
        BLangSimpleVariableDef entriesVarDef = this.createVarDef("$entries$", entriesType, entriesInvocation, restPatternPos);
        blockStmt.addStatement(entriesVarDef);
        BLangLambdaFunction filteringFunction = this.createFuncToFilterOutRestParam(keysToRemove, restPatternPos);
        BLangInvocation filterInvocation = this.generateMapFilterInvocation(restPatternPos, entriesVarDef.var, filteringFunction);
        BLangSimpleVariableDef filtersVarDef = this.createVarDef("$filteredVarDef$", entriesType, filterInvocation, restPatternPos);
        blockStmt.addStatement(filtersVarDef);
        BLangLambdaFunction backToMapLambda = this.generateEntriesToMapLambda(restPatternPos, ((BRecordType)restBindingPattern.getBType()).restFieldType);
        BLangInvocation mapInvocation = this.generateMapMapInvocation(restPatternPos, filtersVarDef.var, backToMapLambda);
        BLangSimpleVarRef restMatchPatternVarRef = this.declaredVarDef.get(restBindingPattern.getIdentifier().getValue());
        blockStmt.addStatement(ASTBuilderUtil.createAssignmentStmt(restPatternPos, restMatchPatternVarRef, mapInvocation));
    }

    private BLangExpression createVarCheckConditionForListMatchPattern(BLangListMatchPattern listMatchPattern, BLangSimpleVarRef varRef) {
        Location pos = listMatchPattern.pos;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(pos);
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$listPatternVarResult$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        blockStmt.addStatement(resultVarDef);
        BLangAssignment failureResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(false));
        BLangAssignment successResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(true));
        blockStmt.addStatement(failureResult);
        List<BType> memberTupleTypes = ((BTupleType)listMatchPattern.getBType()).getTupleTypes();
        List<BLangMatchPattern> matchPatterns = listMatchPattern.matchPatterns;
        BLangSimpleVariableDef tempCastVarDef = this.createVarDef("$castTemp$", listMatchPattern.getBType(), varRef, pos);
        BLangSimpleVarRef tempCastVarRef = ASTBuilderUtil.createVariableRef(pos, tempCastVarDef.var.symbol);
        blockStmt.addStatement(tempCastVarDef);
        BLangBlockStmt tempBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        tempBlockStmt.addStatement(successResult);
        if (!matchPatterns.isEmpty()) {
            BLangExpression condition = this.createConditionForListMemberPattern(0, matchPatterns.get(0), tempCastVarDef, blockStmt, memberTupleTypes.get(0), pos);
            for (int i = 1; i < matchPatterns.size(); ++i) {
                BLangExpression memberPatternCondition = this.createConditionForListMemberPattern(i, matchPatterns.get(i), tempCastVarDef, blockStmt, memberTupleTypes.get(i), pos);
                condition = ASTBuilderUtil.createBinaryExpr(pos, condition, memberPatternCondition, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
            }
            BLangIf ifStmtForMatchPatterns = ASTBuilderUtil.createIfElseStmt(pos, condition, tempBlockStmt, null);
            blockStmt.addStatement(ifStmtForMatchPatterns);
        } else {
            blockStmt.addStatement(tempBlockStmt);
        }
        if (listMatchPattern.restMatchPattern != null) {
            BLangRestMatchPattern restMatchPattern = listMatchPattern.restMatchPattern;
            BLangSimpleVarRef restMatchPatternVarRef = this.declaredVarDef.get(restMatchPattern.getIdentifier().getValue());
            this.matchStmtsForPattern.add(ASTBuilderUtil.createAssignmentStmt(pos, restMatchPatternVarRef, this.createLangLibInvocationNode("slice", tempCastVarRef, new ArrayList<BLangExpression>(Arrays.asList(new BLangLiteral(matchPatterns.size(), this.symTable.intType))), null, pos)));
        }
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        return statementExpression;
    }

    private BLangExpression createVarCheckConditionForMappingMatchPattern(BLangMappingMatchPattern mappingMatchPattern, BLangSimpleVarRef varRef) {
        BRecordType recordType = (BRecordType)mappingMatchPattern.getBType();
        Location pos = mappingMatchPattern.pos;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(pos);
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$mappingPatternVarResult$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        blockStmt.addStatement(resultVarDef);
        BLangAssignment failureResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(false));
        BLangAssignment successResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(true));
        blockStmt.addStatement(failureResult);
        BLangSimpleVariableDef tempCastVarDef = this.createVarDef("$castTemp$", mappingMatchPattern.getBType(), varRef, pos);
        BLangSimpleVarRef tempCastVarRef = ASTBuilderUtil.createVariableRef(pos, tempCastVarDef.var.symbol);
        blockStmt.addStatement(tempCastVarDef);
        BLangExpression condition = this.createConditionForFieldMatchPatterns(mappingMatchPattern.fieldMatchPatterns, tempCastVarDef, blockStmt, pos);
        BLangBlockStmt tempBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        tempBlockStmt.addStatement(successResult);
        if (mappingMatchPattern.restMatchPattern != null) {
            BLangRestMatchPattern restMatchPattern = mappingMatchPattern.restMatchPattern;
            Location restPatternPos = restMatchPattern.pos;
            List<String> keysToRemove = this.getKeysToRemove(mappingMatchPattern);
            BType restType = ((BRecordType)restMatchPattern.getBType()).restFieldType;
            BVarSymbol varSymbol = new BVarSymbol(restType.getFlags(), null, null, restType, null, null, null);
            BVarSymbol stringVarSymbol = new BVarSymbol(0L, null, null, this.symTable.stringType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
            BMapType entriesType = new BMapType(this.symTable.typeEnv(), 16, new BTupleType(this.symTable.typeEnv(), Arrays.asList(new BTupleMember(this.symTable.stringType, stringVarSymbol), new BTupleMember(restType, varSymbol))), null);
            BLangInvocation entriesInvocation = this.generateMapEntriesInvocation(tempCastVarRef, entriesType);
            BLangSimpleVariableDef entriesVarDef = this.createVarDef("$entries$", entriesType, entriesInvocation, restPatternPos);
            tempBlockStmt.addStatement(entriesVarDef);
            BLangLambdaFunction filteringFunction = this.createFuncToFilterOutRestParam(keysToRemove, restPatternPos);
            BLangInvocation filterInvocation = this.generateMapFilterInvocation(pos, entriesVarDef.var, filteringFunction);
            BLangSimpleVariableDef filtersVarDef = this.createVarDef("$filteredVarDef$", entriesType, filterInvocation, restPatternPos);
            tempBlockStmt.addStatement(filtersVarDef);
            BLangLambdaFunction backToMapLambda = this.generateEntriesToMapLambda(restPatternPos, ((BRecordType)restMatchPattern.getBType()).restFieldType);
            BLangInvocation mapInvocation = this.generateMapMapInvocation(restPatternPos, filtersVarDef.var, backToMapLambda);
            BLangSimpleVarRef restMatchPatternVarRef = this.declaredVarDef.get(restMatchPattern.getIdentifier().getValue());
            tempBlockStmt.addStatement(ASTBuilderUtil.createAssignmentStmt(pos, restMatchPatternVarRef, mapInvocation));
        }
        BLangIf ifStmtForMatchPatterns = ASTBuilderUtil.createIfElseStmt(pos, condition, tempBlockStmt, null);
        blockStmt.addStatement(ifStmtForMatchPatterns);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        this.addAsRecordTypeDefinition(recordType, pos);
        return statementExpression;
    }

    private void addAsRecordTypeDefinition(BType type, Location pos) {
        if (type.tag == 22) {
            type = ((BIntersectionType)type).effectiveType;
        }
        if (type.tag == 21) {
            for (BType memberType : ((BUnionType)type).getMemberTypes()) {
                this.addAsRecordTypeDefinition(memberType, pos);
            }
            return;
        }
        if (type.tag != 12) {
            return;
        }
        BRecordType recordType = (BRecordType)type;
        if (this.isRecordTypeDefExist(recordType.tsymbol, this.env)) {
            return;
        }
        BLangRecordTypeNode recordTypeNode = new BLangRecordTypeNode();
        recordTypeNode.pos = pos;
        recordTypeNode.setBType(recordType);
        ArrayList<BLangSimpleVariable> typeDefFields = new ArrayList<BLangSimpleVariable>();
        for (BField field : recordType.fields.values()) {
            typeDefFields.add(ASTBuilderUtil.createVariable(field.pos, field.name.value, field.type, null, field.symbol));
        }
        recordTypeNode.fields = typeDefFields;
        recordTypeNode.symbol = recordType.tsymbol;
        recordTypeNode.isAnonymous = true;
        recordTypeNode.isLocal = true;
        recordTypeNode.getBType().tsymbol.scope = new Scope(recordTypeNode.getBType().tsymbol);
        TypeDefBuilderHelper.createTypeDefinitionForTSymbol(recordType, recordType.tsymbol, recordTypeNode, this.env);
    }

    private boolean isRecordTypeDefExist(BTypeSymbol recordTypeSymbol, SymbolEnv env) {
        for (BLangTypeDefinition typeDef : env.enclPkg.getTypeDefinitions()) {
            if (typeDef.symbol != recordTypeSymbol) continue;
            return true;
        }
        return false;
    }

    private BLangExpression createConditionForErrorMatchPattern(BLangErrorMatchPattern errorMatchPattern, BLangSimpleVarRef matchExprVarRef) {
        BType matchPatternType = errorMatchPattern.getBType();
        Location pos = errorMatchPattern.pos;
        BLangSimpleVariableDef resultVarDef = this.createVarDef("errorPatternResult$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        BLangBlockStmt mainBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        mainBlockStmt.addStatement(resultVarDef);
        if (matchPatternType == this.symTable.noType) {
            return this.createConditionForUnmatchedPattern(resultVarRef, mainBlockStmt);
        }
        BLangAssignment failureResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(false));
        BLangAssignment successResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(true));
        mainBlockStmt.addStatement(failureResult);
        BLangIsLikeExpr typeCheckCondition = this.createIsLikeExpression(pos, matchExprVarRef, matchPatternType);
        BLangExpression typeConvertedExpr = this.types.addConversionExprIfRequired(matchExprVarRef, matchPatternType);
        BLangSimpleVariableDef tempCastVarDef = this.createVarDef("$castTemp$", matchPatternType, typeConvertedExpr, pos);
        BLangSimpleVarRef tempCastVarRef = ASTBuilderUtil.createVariableRef(pos, tempCastVarDef.var.symbol);
        BLangBlockStmt ifBlock = ASTBuilderUtil.createBlockStmt(pos);
        ifBlock.addStatement(tempCastVarDef);
        BLangIf ifStmt = ASTBuilderUtil.createIfElseStmt(pos, typeCheckCondition, ifBlock, null);
        mainBlockStmt.addStatement(ifStmt);
        BLangBlockStmt tempBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        BLangExpression condition = this.createConditionForErrorArgListMatchPattern(errorMatchPattern, ifBlock, tempBlockStmt, tempCastVarRef, pos);
        tempBlockStmt.addStatement(successResult);
        BLangIf ifStmtForMatchPatterns = ASTBuilderUtil.createIfElseStmt(pos, condition, tempBlockStmt, null);
        ifBlock.addStatement(ifStmtForMatchPatterns);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(mainBlockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        return statementExpression;
    }

    private BLangExpression createConditionForErrorArgListMatchPattern(BLangErrorMatchPattern errorMatchPattern, BLangBlockStmt ifBlock, BLangBlockStmt restPatternBlock, BLangSimpleVarRef varRef, Location pos) {
        BLangExpression condition = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true);
        if (errorMatchPattern.errorMessageMatchPattern != null) {
            Location messagePos = errorMatchPattern.errorMessageMatchPattern.pos;
            BLangInvocation messageInvocation = this.createLangLibInvocationNode(ERROR_MESSAGE_FUNCTION_NAME, varRef, new ArrayList<BLangExpression>(), null, messagePos);
            BLangSimpleVariableDef messageVarDef = this.createVarDef("$errorMessage$", messageInvocation.getBType(), messageInvocation, messagePos);
            ifBlock.addStatement(messageVarDef);
            BLangSimpleVarRef messageVarRef = ASTBuilderUtil.createVariableRef(messagePos, messageVarDef.var.symbol);
            condition = this.createConditionForErrorMessageMatchPattern(errorMatchPattern.errorMessageMatchPattern, messageVarRef);
        }
        if (errorMatchPattern.errorCauseMatchPattern != null) {
            Location errorCausePos = errorMatchPattern.errorCauseMatchPattern.pos;
            BLangInvocation causeInvocation = this.createLangLibInvocationNode(ERROR_CAUSE_FUNCTION_NAME, varRef, new ArrayList<BLangExpression>(), null, errorCausePos);
            BLangSimpleVariableDef causeVarDef = this.createVarDef("$errorCause$", causeInvocation.getBType(), causeInvocation, errorCausePos);
            ifBlock.addStatement(causeVarDef);
            BLangSimpleVarRef causeVarRef = ASTBuilderUtil.createVariableRef(errorCausePos, causeVarDef.var.symbol);
            BLangExpression errorCauseCondition = this.createConditionForErrorCauseMatchPattern(errorMatchPattern.errorCauseMatchPattern, causeVarRef);
            condition = ASTBuilderUtil.createBinaryExpr(pos, condition, errorCauseCondition, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
        }
        if (errorMatchPattern.errorFieldMatchPatterns != null) {
            Location errorFieldPos = errorMatchPattern.errorFieldMatchPatterns.pos;
            BLangInvocation errorDetailInvocation = this.createLangLibInvocationNode(ERROR_DETAIL_FUNCTION_NAME, varRef, new ArrayList<BLangExpression>(), null, errorFieldPos);
            BLangSimpleVariableDef errorDetailVarDef = this.createVarDef("$errorDetail$", errorDetailInvocation.getBType(), errorDetailInvocation, errorFieldPos);
            ifBlock.addStatement(errorDetailVarDef);
            BLangSimpleVarRef errorDetailVarRef = ASTBuilderUtil.createVariableRef(errorFieldPos, errorDetailVarDef.var.symbol);
            BLangExpression errorDetailCondition = this.createConditionForErrorFieldMatchPatterns(errorMatchPattern.errorFieldMatchPatterns, errorDetailVarRef);
            condition = ASTBuilderUtil.createBinaryExpr(pos, condition, errorDetailCondition, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
            if (errorMatchPattern.errorFieldMatchPatterns.restMatchPattern != null) {
                BLangRestMatchPattern restMatchPattern = errorMatchPattern.errorFieldMatchPatterns.restMatchPattern;
                Location restPatternPos = restMatchPattern.pos;
                List<String> keysToRemove = this.getKeysToRemove(errorMatchPattern.errorFieldMatchPatterns);
                BVarSymbol stringVarSymbol = new BVarSymbol(0L, null, null, this.symTable.stringType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
                BVarSymbol anydataVarSymbol = new BVarSymbol(0L, null, null, this.symTable.anydataType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
                BMapType entriesType = new BMapType(this.symTable.typeEnv(), 16, new BTupleType(this.symTable.typeEnv(), Arrays.asList(new BTupleMember(this.symTable.stringType, stringVarSymbol), new BTupleMember(this.symTable.anydataType, anydataVarSymbol))), null);
                BLangInvocation entriesInvocation = this.generateMapEntriesInvocation(errorDetailVarRef, entriesType);
                BLangSimpleVariableDef entriesVarDef = this.createVarDef("$entries$", entriesType, entriesInvocation, restPatternPos);
                restPatternBlock.addStatement(entriesVarDef);
                BLangLambdaFunction filteringFunction = this.createFuncToFilterOutRestParam(keysToRemove, restPatternPos);
                BLangInvocation filterInvocation = this.generateMapFilterInvocation(pos, entriesVarDef.var, filteringFunction);
                BLangSimpleVariableDef filtersVarDef = this.createVarDef("$filteredVarDef$", entriesType, filterInvocation, restPatternPos);
                restPatternBlock.addStatement(filtersVarDef);
                BLangLambdaFunction backToMapLambda = this.generateEntriesToMapLambda(restPatternPos, ((BMapType)errorMatchPattern.errorFieldMatchPatterns.restMatchPattern.getBType()).constraint);
                BLangInvocation mapInvocation = this.generateMapMapInvocation(restPatternPos, filtersVarDef.var, backToMapLambda);
                BLangSimpleVarRef restMatchPatternVarRef = this.declaredVarDef.get(restMatchPattern.getIdentifier().getValue());
                restPatternBlock.addStatement(ASTBuilderUtil.createAssignmentStmt(restPatternPos, restMatchPatternVarRef, mapInvocation));
            }
        }
        return condition;
    }

    private List<String> getKeysToRemove(BLangErrorFieldMatchPatterns errorFieldMatchPattern) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (BLangNamedArgMatchPattern namedArgMatchPattern : errorFieldMatchPattern.namedArgMatchPatterns) {
            keysToRemove.add(namedArgMatchPattern.argName.value);
        }
        return keysToRemove;
    }

    private List<String> getKeysToRemove(BLangErrorFieldBindingPatterns errorFieldBindingPattern) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (BLangNamedArgBindingPattern namedArgBindingPattern : errorFieldBindingPattern.namedArgBindingPatterns) {
            keysToRemove.add(namedArgBindingPattern.argName.value);
        }
        return keysToRemove;
    }

    private BLangExpression createConditionForErrorFieldMatchPatterns(BLangErrorFieldMatchPatterns errorFieldMatchPatterns, BLangSimpleVarRef matchExprVarRef) {
        Location pos = errorFieldMatchPatterns.pos;
        BLangSimpleVariableDef resultVarDef = this.createVarDef("errorFieldResult$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        BLangBlockStmt mainBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        mainBlockStmt.addStatement(resultVarDef);
        BLangAssignment failureResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(false));
        BLangAssignment successResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(true));
        mainBlockStmt.addStatement(failureResult);
        BLangExpression condition = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true);
        for (int i = 0; i < errorFieldMatchPatterns.namedArgMatchPatterns.size(); ++i) {
            BLangNamedArgMatchPattern namedArgMatchPattern = errorFieldMatchPatterns.namedArgMatchPatterns.get(i);
            String argName = namedArgMatchPattern.argName.value;
            BLangMatchPattern matchPattern = namedArgMatchPattern.matchPattern;
            Location matchPatternPos = matchPattern.pos;
            BLangFieldBasedAccess fieldBasedAccessExpr = this.getFieldAccessExpression(matchPatternPos, argName, this.symTable.anydataOrReadonly, (BVarSymbol)matchExprVarRef.symbol);
            BLangSimpleVariableDef tempVarDef = this.createVarDef("$errorFieldVarTemp$" + i + "_$", this.symTable.anydataOrReadonly, fieldBasedAccessExpr, matchPatternPos);
            mainBlockStmt.addStatement(tempVarDef);
            BLangSimpleVarRef tempVarRef = ASTBuilderUtil.createVariableRef(matchPatternPos, tempVarDef.var.symbol);
            BLangExpression varCheckCondition = this.createConditionForNamedArgMatchPattern(matchPattern, tempVarRef);
            BLangIsLikeExpr typeCheckCondition = this.createIsLikeExpression(matchPatternPos, tempVarRef, matchPattern.getBType());
            varCheckCondition = ASTBuilderUtil.createBinaryExpr(pos, typeCheckCondition, varCheckCondition, this.symTable.booleanType, OperatorKind.AND, null);
            condition = i == 0 ? varCheckCondition : ASTBuilderUtil.createBinaryExpr(matchPatternPos, condition, varCheckCondition, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
        }
        BType matchingType = this.createMatchingRecordType(errorFieldMatchPatterns);
        BLangIsLikeExpr isLikeExpr = this.createIsLikeExpression(errorFieldMatchPatterns.pos, matchExprVarRef, matchingType);
        condition = ASTBuilderUtil.createBinaryExpr(errorFieldMatchPatterns.pos, condition, isLikeExpr, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
        BLangBlockStmt tempBLock = ASTBuilderUtil.createBlockStmt(pos);
        tempBLock.addStatement(successResult);
        BLangIf ifStmtForFieldMatchPatterns = ASTBuilderUtil.createIfElseStmt(pos, condition, tempBLock, null);
        mainBlockStmt.addStatement(ifStmtForFieldMatchPatterns);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(mainBlockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        return statementExpression;
    }

    private BType createMatchingRecordType(BLangErrorFieldMatchPatterns errorFieldMatchPatterns) {
        BRecordType detailRecordType = this.createAnonRecordType(errorFieldMatchPatterns.pos);
        ArrayList<BLangSimpleVariable> typeDefFields = new ArrayList<BLangSimpleVariable>();
        for (BLangNamedArgMatchPattern bindingPattern : errorFieldMatchPatterns.namedArgMatchPatterns) {
            Name fieldName = this.names.fromIdNode(bindingPattern.argName);
            BVarSymbol declaredVarSym = (BVarSymbol)bindingPattern.declaredVars.get(fieldName.value);
            if (declaredVarSym == null) continue;
            BType fieldType = declaredVarSym.type;
            BVarSymbol fieldSym = new BVarSymbol(1L, fieldName, detailRecordType.tsymbol.pkgID, fieldType, detailRecordType.tsymbol, bindingPattern.pos, SymbolOrigin.VIRTUAL);
            detailRecordType.fields.put(fieldName.value, new BField(fieldName, bindingPattern.pos, fieldSym));
            detailRecordType.tsymbol.scope.define(fieldName, fieldSym);
            typeDefFields.add(ASTBuilderUtil.createVariable(null, fieldName.value, fieldType, null, fieldSym));
        }
        BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(typeDefFields, detailRecordType, errorFieldMatchPatterns.pos);
        TypeDefBuilderHelper.createTypeDefinitionForTSymbol(detailRecordType, detailRecordType.tsymbol, recordTypeNode, this.env);
        return detailRecordType;
    }

    private BLangExpression createConditionForErrorFieldBindingPatterns(BLangErrorFieldBindingPatterns errorFieldBindingPatterns, BLangSimpleVarRef matchExprVarRef) {
        Location pos = errorFieldBindingPatterns.pos;
        BLangSimpleVariableDef resultVarDef = this.createVarDef("errorFieldResult$", this.symTable.booleanType, null, pos);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVarDef.var.symbol);
        BLangBlockStmt mainBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        mainBlockStmt.addStatement(resultVarDef);
        if (errorFieldBindingPatterns.namedArgBindingPatterns.isEmpty()) {
            return this.createConditionForUnmatchedPattern(resultVarRef, mainBlockStmt);
        }
        BLangAssignment failureResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(false));
        BLangAssignment successResult = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.getBooleanLiteral(true));
        mainBlockStmt.addStatement(failureResult);
        BLangExpression condition = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true);
        for (int i = 0; i < errorFieldBindingPatterns.namedArgBindingPatterns.size(); ++i) {
            BLangNamedArgBindingPattern namedArgBindingPattern = errorFieldBindingPatterns.namedArgBindingPatterns.get(i);
            String argName = namedArgBindingPattern.argName.value;
            BLangBindingPattern bindingPattern = namedArgBindingPattern.bindingPattern;
            Location matchPatternPos = bindingPattern.pos;
            BLangFieldBasedAccess fieldBasedAccessExpr = this.getFieldAccessExpression(matchPatternPos, argName, this.symTable.anydataOrReadonly, (BVarSymbol)matchExprVarRef.symbol);
            BLangSimpleVariableDef tempVarDef = this.createVarDef("$errorFieldVarTemp$" + i + "_$", this.symTable.anydataOrReadonly, fieldBasedAccessExpr, matchPatternPos);
            mainBlockStmt.addStatement(tempVarDef);
            BLangSimpleVarRef tempVarRef = ASTBuilderUtil.createVariableRef(matchPatternPos, tempVarDef.var.symbol);
            BLangExpression varCheckCondition = this.createConditionForNamedArgBindingPattern(bindingPattern, tempVarRef);
            BLangIsLikeExpr typeCheckCondition = this.createIsLikeExpression(matchPatternPos, tempVarRef, bindingPattern.getBType());
            varCheckCondition = ASTBuilderUtil.createBinaryExpr(pos, typeCheckCondition, varCheckCondition, this.symTable.booleanType, OperatorKind.AND, null);
            condition = i == 0 ? varCheckCondition : ASTBuilderUtil.createBinaryExpr(matchPatternPos, condition, varCheckCondition, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
        }
        BType matchingType = this.createMatchingRecordType(errorFieldBindingPatterns);
        BLangIsLikeExpr isLikeExpr = this.createIsLikeExpression(errorFieldBindingPatterns.pos, matchExprVarRef, matchingType);
        condition = ASTBuilderUtil.createBinaryExpr(errorFieldBindingPatterns.pos, condition, isLikeExpr, this.symTable.booleanType, OperatorKind.AND, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.AND, this.symTable.booleanType, this.symTable.booleanType));
        BLangBlockStmt tempBLock = ASTBuilderUtil.createBlockStmt(pos);
        tempBLock.addStatement(successResult);
        BLangIf ifStmtForFieldMatchPatterns = ASTBuilderUtil.createIfElseStmt(pos, condition, tempBLock, null);
        mainBlockStmt.addStatement(ifStmtForFieldMatchPatterns);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(mainBlockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        return statementExpression;
    }

    private BType createMatchingRecordType(BLangErrorFieldBindingPatterns errorFieldBindingPatterns) {
        BRecordType detailRecordType = this.createAnonRecordType(errorFieldBindingPatterns.pos);
        ArrayList<BLangSimpleVariable> typeDefFields = new ArrayList<BLangSimpleVariable>();
        for (BLangNamedArgBindingPattern bindingPattern : errorFieldBindingPatterns.namedArgBindingPatterns) {
            Name fieldName = this.names.fromIdNode(bindingPattern.argName);
            BVarSymbol declaredVarSym = (BVarSymbol)bindingPattern.declaredVars.get(fieldName.value);
            if (declaredVarSym == null) continue;
            BType fieldType = declaredVarSym.type;
            BVarSymbol fieldSym = new BVarSymbol(1L, fieldName, detailRecordType.tsymbol.pkgID, fieldType, detailRecordType.tsymbol, bindingPattern.pos, SymbolOrigin.VIRTUAL);
            detailRecordType.fields.put(fieldName.value, new BField(fieldName, bindingPattern.pos, fieldSym));
            detailRecordType.tsymbol.scope.define(fieldName, fieldSym);
            typeDefFields.add(ASTBuilderUtil.createVariable(null, fieldName.value, fieldType, null, fieldSym));
        }
        BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(typeDefFields, detailRecordType, errorFieldBindingPatterns.pos);
        TypeDefBuilderHelper.createTypeDefinitionForTSymbol(detailRecordType, detailRecordType.tsymbol, recordTypeNode, this.env);
        return detailRecordType;
    }

    private BLangExpression createConditionForNamedArgMatchPattern(BLangMatchPattern matchPattern, BLangSimpleVarRef matchExprVarRef) {
        return this.createVarCheckCondition(matchPattern, matchExprVarRef);
    }

    private BLangExpression createConditionForNamedArgBindingPattern(BLangBindingPattern bindingPattern, BLangSimpleVarRef matchExprVarRef) {
        return this.createVarCheckCondition(bindingPattern, matchExprVarRef);
    }

    private BLangExpression createConditionForErrorCauseMatchPattern(BLangErrorCauseMatchPattern errorCausePattern, BLangSimpleVarRef matchExprVarRef) {
        if (errorCausePattern.simpleMatchPattern != null) {
            return this.createConditionForSimpleMatchPattern(errorCausePattern.simpleMatchPattern, matchExprVarRef);
        }
        return this.createConditionForErrorMatchPattern(errorCausePattern.errorMatchPattern, matchExprVarRef);
    }

    private BLangExpression createConditionForErrorCauseBindingPattern(BLangErrorCauseBindingPattern errorCausePattern, BLangSimpleVarRef matchExprVarRef) {
        if (errorCausePattern.simpleBindingPattern != null) {
            return this.createConditionForSimpleBindingPattern(errorCausePattern.simpleBindingPattern, matchExprVarRef);
        }
        return this.createConditionForErrorBindingPattern(errorCausePattern.errorBindingPattern, matchExprVarRef);
    }

    private BLangExpression createConditionForErrorMessageMatchPattern(BLangErrorMessageMatchPattern errorMsgPattern, BLangSimpleVarRef matchExprVarRef) {
        return this.createConditionForSimpleMatchPattern(errorMsgPattern.simpleMatchPattern, matchExprVarRef);
    }

    private BLangExpression createConditionForErrorMessageBindingPattern(BLangErrorMessageBindingPattern errorMsgPattern, BLangSimpleVarRef matchExprVarRef) {
        return this.createConditionForSimpleBindingPattern(errorMsgPattern.simpleBindingPattern, matchExprVarRef);
    }

    private BLangExpression createConditionForSimpleMatchPattern(BLangSimpleMatchPattern simpleMatchPattern, BLangSimpleVarRef matchExprVarRef) {
        if (simpleMatchPattern.wildCardMatchPattern != null) {
            return this.createVarCheckCondition(simpleMatchPattern.wildCardMatchPattern, matchExprVarRef);
        }
        if (simpleMatchPattern.constPattern != null) {
            return this.createVarCheckCondition(simpleMatchPattern.constPattern, matchExprVarRef);
        }
        return this.createVarCheckCondition(simpleMatchPattern.varVariableName, matchExprVarRef);
    }

    private BLangExpression createConditionForSimpleBindingPattern(BLangSimpleBindingPattern simpleBindingPattern, BLangSimpleVarRef matchExprVarRef) {
        if (simpleBindingPattern.wildCardBindingPattern != null) {
            return this.createVarCheckCondition(simpleBindingPattern.wildCardBindingPattern, matchExprVarRef);
        }
        return this.createVarCheckCondition(simpleBindingPattern.captureBindingPattern, matchExprVarRef);
    }

    private BLangExpression createConditionForUnmatchedPattern(BLangSimpleVarRef resultVarRef, BLangBlockStmt blockStmt) {
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        statementExpression.setBType(this.symTable.booleanType);
        return statementExpression;
    }

    @Override
    public void visit(BLangForeach foreach) {
        if (foreach.onFailClause != null) {
            BLangOnFailClause onFailClause = foreach.onFailClause;
            foreach.onFailClause = null;
            foreach.body.failureBreakMode = BLangBlockStmt.FailureBreakMode.NOT_BREAKABLE;
            BLangDo doStmt = this.wrapStatementWithinDo(foreach.pos, foreach, onFailClause);
            this.result = this.rewrite(doStmt, this.env);
        } else if (this.canEliminateIterator(foreach)) {
            this.result = this.rewrite(this.desugarForeachToWhileWithoutIterator(foreach), this.env);
        } else {
            BVarSymbol dataSymbol = new BVarSymbol(0L, Names.fromString("$data$"), this.env.scope.owner.pkgID, foreach.collection.getBType(), this.env.scope.owner, foreach.pos, SymbolOrigin.VIRTUAL);
            BLangSimpleVariable dataVariable = ASTBuilderUtil.createVariable(foreach.pos, "$data$", foreach.collection.getBType(), foreach.collection, dataSymbol);
            BLangSimpleVariableDef dataVarDef = ASTBuilderUtil.createVariableDef(foreach.pos, dataVariable);
            BLangBlockStmt blockNode = this.desugarForeachStmt(dataVariable.symbol, foreach.collection.getBType(), foreach, dataVarDef);
            this.rewrite(blockNode, this.env);
            this.result = blockNode;
        }
    }

    private boolean canEliminateIterator(BLangForeach loop) {
        BLangExpression collection = loop.collection;
        if (collection.getKind() == NodeKind.BINARY_EXPR) {
            return true;
        }
        TypeKind kind = collection.getBType().getKind();
        return kind == TypeKind.ARRAY || kind == TypeKind.TUPLE;
    }

    private BLangBlockStmt desugarForeachToWhileWithoutIterator(BLangForeach foreach) {
        Location pos = foreach.pos;
        BLangBlockStmt scopeBlock = ASTBuilderUtil.createBlockStmt(pos);
        if (foreach.collection.getKind() == NodeKind.BINARY_EXPR) {
            BLangBinaryExpr rangeExpr = (BLangBinaryExpr)foreach.collection;
            OperatorKind comparisonOp = rangeExpr.opKind == OperatorKind.HALF_OPEN_RANGE ? OperatorKind.LESS_THAN : OperatorKind.LESS_EQUAL;
            Function<BLangVariableReference, BLangExpression> loopValueGenerator = indexVarRef -> indexVarRef;
            this.finishDesugarForeachToWhile(foreach, rangeExpr.lhsExpr, rangeExpr.rhsExpr, comparisonOp, loopValueGenerator, scopeBlock);
            return scopeBlock;
        }
        BSymbol listSymbol = this.addTemporaryVariableToScope(pos, "$data$", foreach.collection, foreach.collection.expectedType, scopeBlock);
        BLangSimpleVarRef listRef = ASTBuilderUtil.createVariableRef(pos, listSymbol);
        BLangLiteral indexInitVal = ASTBuilderUtil.createLiteral(pos, this.symTable.intType, 0L);
        BLangInvocation indexMaxVal = this.createLangLibInvocationNode(LENGTH_FUNCTION_NAME, listRef, new ArrayList<BLangExpression>(), this.symTable.intType, pos);
        OperatorKind comparisonOp = OperatorKind.LESS_THAN;
        Function<BLangVariableReference, BLangExpression> loopValueGenerator = indexVarRef -> {
            BLangVariable loopVal = (BLangVariable)foreach.variableDefinitionNode.getVariable();
            return ASTBuilderUtil.createIndexBasesAccessExpr(pos, loopVal.getBType(), (BVarSymbol)listSymbol, indexVarRef);
        };
        this.finishDesugarForeachToWhile(foreach, indexInitVal, indexMaxVal, comparisonOp, loopValueGenerator, scopeBlock);
        return scopeBlock;
    }

    private void finishDesugarForeachToWhile(BLangForeach foreach, BLangExpression indexInitVal, BLangExpression indexMaxVal, OperatorKind comparisonOp, Function<BLangVariableReference, BLangExpression> loopValueGenerator, BLangBlockStmt scopeBlock) {
        Location pos = foreach.pos;
        BSymbol indexSymbol = this.addTemporaryVariableToScope(pos, "$index$", indexInitVal, this.symTable.intType, scopeBlock);
        BSymbol indexMaxSymbol = this.addTemporaryVariableToScope(pos, "$indexMax$", indexMaxVal, this.symTable.intType, scopeBlock);
        BLangBinaryExpr condition = ASTBuilderUtil.createBinaryExpr(pos, ASTBuilderUtil.createVariableRef(pos, indexSymbol), ASTBuilderUtil.createVariableRef(pos, indexMaxSymbol), this.symTable.booleanType, comparisonOp, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.EQUAL, this.symTable.booleanType, this.symTable.booleanType));
        BLangBlockStmt whileBody = ASTBuilderUtil.createBlockStmt(pos);
        whileBody.scope = foreach.body.scope;
        VariableDefinitionNode loopValDef = foreach.variableDefinitionNode;
        Location loopValPos = loopValDef.getPosition();
        BLangSimpleVarRef indexRef = ASTBuilderUtil.createVariableRef(loopValPos, indexSymbol);
        loopValDef.getVariable().setInitialExpression(loopValueGenerator.apply(indexRef));
        whileBody.addStatement(loopValDef);
        whileBody.addStatement(ASTBuilderUtil.createAssignmentStmt(pos, indexRef, ASTBuilderUtil.createBinaryExpr(pos, indexRef, ASTBuilderUtil.createLiteral(pos, this.symTable.intType, 1L), this.symTable.intType, OperatorKind.ADD, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.ADD, this.symTable.intType, this.symTable.intType))));
        whileBody.stmts.addAll(foreach.body.stmts);
        BLangWhile whileLoop = ASTBuilderUtil.createWhile(pos, condition, whileBody);
        scopeBlock.addStatement(whileLoop);
    }

    private BSymbol addTemporaryVariableToScope(Location pos, String name, BLangExpression initValue, BType type, BLangBlockStmt scopeBlock) {
        BLangSimpleVariable var = ASTBuilderUtil.createVariable(pos, name, type, initValue, new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, type, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL));
        scopeBlock.addStatement(ASTBuilderUtil.createVariableDef(pos, var));
        return var.symbol;
    }

    BLangBlockStmt desugarForeachStmt(BVarSymbol collectionSymbol, BType collectionType, BLangForeach foreach, BLangSimpleVariableDef dataVarDef) {
        switch (Types.getImpliedType((BType)collectionType).tag) {
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 20: 
            case 31: 
            case 49: {
                BInvokableSymbol iteratorSymbol = this.getLangLibIteratorInvokableSymbol(collectionSymbol);
                return this.desugarForeachWithIteratorDef(foreach, dataVarDef, collectionSymbol, iteratorSymbol, true);
            }
            case 34: {
                BInvokableSymbol iteratorSymbol = this.getIterableObjectIteratorInvokableSymbol(collectionSymbol);
                return this.desugarForeachWithIteratorDef(foreach, dataVarDef, collectionSymbol, iteratorSymbol, false);
            }
        }
        BLangBlockStmt blockNode = ASTBuilderUtil.createBlockStmt(foreach.pos);
        blockNode.stmts.add(0, dataVarDef);
        return blockNode;
    }

    @Override
    public void visit(BLangDo doNode) {
        BLangOnFailClause currentOnFailClause = this.onFailClause;
        boolean prevDesugarToReturn = this.desugarToReturn;
        this.analyzeOnFailClause(doNode.onFailClause, doNode.body);
        if (this.onFailClause != null) {
            this.desugarToReturn = false;
        }
        this.result = this.rewrite(doNode.body, this.env);
        this.swapAndResetEnclosingOnFail(currentOnFailClause);
        this.desugarToReturn = prevDesugarToReturn;
    }

    private void swapAndResetEnclosingOnFail(BLangOnFailClause onFailClause) {
        this.enclosingOnFailClause.remove(onFailClause);
        this.onFailClause = onFailClause;
    }

    public void resetSkipFailStmtRewrite() {
        this.isVisitingQuery = false;
    }

    private void analyzeOnFailClause(BLangOnFailClause onFailClause, BLangBlockStmt blockStmt) {
        if (onFailClause != null) {
            this.enclosingOnFailClause.add(this.onFailClause);
            this.onFailClause = onFailClause;
            if (onFailClause.bodyContainsFail) {
                blockStmt.failureBreakMode = onFailClause.isInternal ? BLangBlockStmt.FailureBreakMode.NOT_BREAKABLE : BLangBlockStmt.FailureBreakMode.BREAK_WITHIN_BLOCK;
            } else {
                this.rewrite(onFailClause, this.env);
            }
        }
    }

    private BLangFail createOnFailInvocation(BLangOnFailClause onFailClause, BLangFail fail) {
        BLangBlockStmt onFailBody = ASTBuilderUtil.createBlockStmt(onFailClause.pos);
        onFailBody.stmts.addAll(onFailClause.body.stmts);
        this.env.scope.entries.putAll(onFailClause.body.scope.entries);
        onFailBody.failureBreakMode = onFailClause.body.failureBreakMode;
        this.handleOnFailErrorVarDefNode(onFailClause.variableDefinitionNode, onFailBody, fail);
        if (onFailClause.isInternal && fail.exprStmt != null) {
            if (fail.exprStmt instanceof BLangPanic) {
                this.setPanicErrorToTrue(onFailBody, onFailClause);
            } else {
                onFailBody.stmts.add((BLangStatement)fail.exprStmt);
            }
        }
        BLangLiteral nilLiteral = ASTBuilderUtil.createLiteral(fail.pos, this.symTable.nilType, Names.NIL_VALUE.value);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(onFailBody, nilLiteral);
        statementExpression.setBType(this.symTable.nilType);
        fail.exprStmt = this.rewrite(statementExpression, this.env);
        return fail;
    }

    private void handleOnFailErrorVarDefNode(VariableDefinitionNode onFailVarDefNode, BLangBlockStmt onFailBody, BLangFail fail) {
        if (onFailVarDefNode == null) {
            return;
        }
        BLangVariable variableNode = (BLangVariable)onFailVarDefNode.getVariable();
        onFailBody.stmts.add(0, variableNode.getKind() == NodeKind.ERROR_VARIABLE ? this.handleErrorBPInOnFail((BLangErrorVariable)variableNode, fail) : this.handleCaptureBPInOnFail((BLangSimpleVariable)variableNode, fail));
    }

    private BLangStatement handleErrorBPInOnFail(BLangErrorVariable varNode, BLangFail fail) {
        BLangErrorVariable errorVar = ASTBuilderUtil.createErrorVariable(varNode.pos, varNode.getBType(), this.rewrite(fail.expr, this.env), varNode.message, varNode.cause, varNode.restDetail, varNode.detail);
        BLangErrorVariableDef errorVarDef = ASTBuilderUtil.createErrorVariableDef(varNode.pos, errorVar);
        return this.rewrite(errorVarDef, this.env);
    }

    private BLangStatement handleCaptureBPInOnFail(BLangSimpleVariable varNode, BLangFail fail) {
        BVarSymbol onFailErrorVariableSymbol = varNode.symbol;
        BLangSimpleVariable errorVar = ASTBuilderUtil.createVariable(onFailErrorVariableSymbol.pos, onFailErrorVariableSymbol.name.value, onFailErrorVariableSymbol.type, this.rewrite(fail.expr, this.env), onFailErrorVariableSymbol);
        BLangSimpleVariableDef errorVarDef = ASTBuilderUtil.createVariableDef(this.onFailClause.pos, errorVar);
        this.env.scope.define(onFailErrorVariableSymbol.name, onFailErrorVariableSymbol);
        return errorVarDef;
    }

    private BLangBlockStmt rewriteNestedOnFail(BLangOnFailClause onFailClause, BLangFail fail) {
        BLangOnFailClause currentOnFail = this.onFailClause;
        BLangBlockStmt onFailBody = ASTBuilderUtil.createBlockStmt(onFailClause.pos);
        onFailBody.stmts.addAll(onFailClause.body.stmts);
        onFailBody.scope = onFailClause.body.scope;
        onFailBody.mapSymbol = onFailClause.body.mapSymbol;
        onFailBody.failureBreakMode = onFailClause.body.failureBreakMode;
        this.handleOnFailErrorVarDefNode(onFailClause.variableDefinitionNode, onFailBody, fail);
        int currentOnFailIndex = this.enclosingOnFailClause.indexOf(this.onFailClause);
        int enclosingOnFailIndex = currentOnFailIndex <= 0 ? this.enclosingOnFailClause.size() - 1 : currentOnFailIndex - 1;
        this.onFailClause = this.enclosingOnFailClause.get(enclosingOnFailIndex);
        onFailBody = this.rewrite(onFailBody, this.env);
        BLangFail failToEndBlock = new BLangFail();
        if (onFailClause.isInternal && fail.exprStmt != null) {
            if (fail.exprStmt instanceof BLangPanic) {
                this.setPanicErrorToTrue(onFailBody, onFailClause);
            } else {
                onFailBody.stmts.add((BLangStatement)fail.exprStmt);
            }
        }
        if (onFailClause.bodyContainsFail && !onFailClause.isInternal) {
            onFailBody.stmts.add(failToEndBlock);
        }
        this.onFailClause = currentOnFail;
        return onFailBody;
    }

    @Override
    public void visit(BLangOnFailClause onFailClause) {
        this.onFailClause = onFailClause;
        this.result = this.onFailClause;
    }

    private void setPanicErrorToTrue(BLangBlockStmt onfailBlock, BLangOnFailClause onFailClause) {
        BLangSimpleVarRef shouldPanic = this.enclosingShouldPanic.get(onFailClause);
        BLangAssignment assignment = ASTBuilderUtil.createAssignmentStmt(onFailClause.pos, shouldPanic, ASTBuilderUtil.createLiteral(onFailClause.pos, this.symTable.booleanType, true));
        onfailBlock.stmts.add(0, this.rewrite(assignment, this.env));
    }

    private BLangBlockStmt desugarForeachWithIteratorDef(BLangForeach foreach, BLangSimpleVariableDef dataVariableDefinition, BVarSymbol collectionSymbol, BInvokableSymbol iteratorInvokableSymbol, boolean isIteratorFuncFromLangLib) {
        BLangSimpleVariableDef iteratorVarDef = this.getIteratorVariableDefinition(foreach.pos, collectionSymbol, iteratorInvokableSymbol, isIteratorFuncFromLangLib);
        BLangBlockStmt blockNode = this.desugarForeachToWhileWithIterator(foreach, iteratorVarDef);
        blockNode.stmts.add(0, dataVariableDefinition);
        return blockNode;
    }

    public BInvokableSymbol getIterableObjectIteratorInvokableSymbol(BVarSymbol collectionSymbol) {
        BObjectTypeSymbol typeSymbol = (BObjectTypeSymbol)Types.getImpliedType((BType)collectionSymbol.type).tsymbol;
        BAttachedFunction iteratorFunc = null;
        for (BAttachedFunction func : typeSymbol.attachedFuncs) {
            if (!func.funcName.value.equals("iterator")) continue;
            iteratorFunc = func;
            break;
        }
        BAttachedFunction function = iteratorFunc;
        return function.symbol;
    }

    BInvokableSymbol getLangLibIteratorInvokableSymbol(BVarSymbol collectionSymbol) {
        return (BInvokableSymbol)this.symResolver.lookupLangLibMethod(collectionSymbol.type, Names.fromString("iterator"), this.env);
    }

    private BLangBlockStmt desugarForeachToWhileWithIterator(BLangForeach foreach, BLangSimpleVariableDef varDef) {
        BVarSymbol iteratorSymbol = varDef.var.symbol;
        BVarSymbol resultSymbol = new BVarSymbol(0L, Names.fromString("$result$"), this.env.scope.owner.pkgID, foreach.nillableResultType, this.env.scope.owner, foreach.pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariableDef resultVariableDefinition = this.getIteratorNextVariableDefinition(foreach.pos, foreach.nillableResultType, iteratorSymbol, resultSymbol);
        BLangSimpleVarRef resultReferenceInWhile = ASTBuilderUtil.createVariableRef(foreach.pos, resultSymbol);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(resultVariableDefinition, resultReferenceInWhile);
        statementExpression.setBType(foreach.nillableResultType);
        BLangType userDefineType = this.getUserDefineTypeNode(foreach.resultType);
        BLangTypeTestExpr typeTestExpr = ASTBuilderUtil.createTypeTestExpr(foreach.pos, statementExpression, userDefineType);
        BLangWhile whileNode = (BLangWhile)TreeBuilder.createWhileNode();
        whileNode.pos = foreach.pos;
        whileNode.expr = typeTestExpr;
        whileNode.body = foreach.body;
        VariableDefinitionNode variableDefinitionNode = foreach.variableDefinitionNode;
        BLangFieldBasedAccess valueAccessExpr = this.getValueAccessExpression(foreach.pos, foreach.varType, resultSymbol);
        BLangExpression expr = valueAccessExpr.expr;
        valueAccessExpr.expr = this.types.addConversionExprIfRequired(expr, this.symTable.mapAllType);
        variableDefinitionNode.getVariable().setInitialExpression(this.types.addConversionExprIfRequired(valueAccessExpr, foreach.varType));
        whileNode.body.stmts.add(0, (BLangStatement)((Object)variableDefinitionNode));
        BLangBlockStmt blockNode = ASTBuilderUtil.createBlockStmt(foreach.pos);
        blockNode.addStatement(varDef);
        blockNode.addStatement(whileNode);
        return blockNode;
    }

    private BLangType getUserDefineTypeNode(BType type) {
        BLangUserDefinedType recordType = new BLangUserDefinedType(ASTBuilderUtil.createIdentifier(null, ""), ASTBuilderUtil.createIdentifier(null, ""));
        recordType.setBType(type);
        return recordType;
    }

    @Override
    public void visit(BLangWhile whileNode) {
        if (whileNode.onFailClause != null) {
            BLangOnFailClause onFailClause = whileNode.onFailClause;
            whileNode.onFailClause = null;
            whileNode.body.failureBreakMode = BLangBlockStmt.FailureBreakMode.NOT_BREAKABLE;
            BLangDo doStmt = this.wrapStatementWithinDo(whileNode.pos, whileNode, onFailClause);
            this.result = this.rewrite(doStmt, this.env);
        } else {
            whileNode.expr = this.rewriteExpr(whileNode.expr);
            whileNode.body = this.rewrite(whileNode.body, this.env);
            this.result = whileNode;
        }
    }

    private BLangDo wrapStatementWithinDo(Location location, BLangStatement statement, BLangOnFailClause onFailClause) {
        BLangDo bLDo = (BLangDo)TreeBuilder.createDoNode();
        BLangBlockStmt doBlock = ASTBuilderUtil.createBlockStmt(location);
        doBlock.scope = new Scope(this.env.scope.owner);
        bLDo.body = doBlock;
        bLDo.pos = location;
        bLDo.onFailClause = onFailClause;
        bLDo.body.failureBreakMode = BLangBlockStmt.FailureBreakMode.BREAK_TO_OUTER_BLOCK;
        doBlock.stmts.add(statement);
        return bLDo;
    }

    @Override
    public void visit(BLangLock lockNode) {
        BLangOnFailClause currentOnFailClause = this.onFailClause;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(lockNode.pos);
        if (lockNode.onFailClause != null) {
            blockStmt.failureBreakMode = BLangBlockStmt.FailureBreakMode.BREAK_TO_OUTER_BLOCK;
            this.rewrite(lockNode.onFailClause, this.env);
        }
        BLangLock.BLangLockStmt lockStmt = new BLangLock.BLangLockStmt(lockNode.pos);
        blockStmt.addStatement(lockStmt);
        this.enclLocks.push(lockStmt);
        BLangLiteral nilLiteral = ASTBuilderUtil.createLiteral(lockNode.pos, this.symTable.nilType, Names.NIL_VALUE.value);
        BUnionType nillableError = BUnionType.create(this.symTable.typeEnv(), null, this.symTable.errorType, this.symTable.nilType);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(lockNode.body, nilLiteral);
        statementExpression.setBType(this.symTable.nilType);
        BLangTrapExpr trapExpr = (BLangTrapExpr)TreeBuilder.createTrapExpressionNode();
        trapExpr.setBType(nillableError);
        trapExpr.expr = statementExpression;
        BVarSymbol nillableErrorVarSymbol = new BVarSymbol(0L, Names.fromString("$errorResult"), this.env.scope.owner.pkgID, nillableError, this.env.scope.owner, lockNode.pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable simpleVariable = ASTBuilderUtil.createVariable(lockNode.pos, "$errorResult", nillableError, trapExpr, nillableErrorVarSymbol);
        BLangSimpleVariableDef simpleVariableDef = ASTBuilderUtil.createVariableDef(lockNode.pos, simpleVariable);
        blockStmt.addStatement(simpleVariableDef);
        BLangLock.BLangUnLockStmt unLockStmt = new BLangLock.BLangUnLockStmt(lockNode.pos);
        unLockStmt.relatedLock = lockStmt;
        blockStmt.addStatement(unLockStmt);
        BLangSimpleVarRef varRef = ASTBuilderUtil.createVariableRef(lockNode.pos, nillableErrorVarSymbol);
        BLangBlockStmt ifBody = ASTBuilderUtil.createBlockStmt(lockNode.pos);
        BLangPanic panicNode = (BLangPanic)TreeBuilder.createPanicNode();
        panicNode.pos = lockNode.pos;
        panicNode.expr = this.types.addConversionExprIfRequired(varRef, this.symTable.errorType);
        ifBody.addStatement(panicNode);
        BLangTypeTestExpr isErrorTest = ASTBuilderUtil.createTypeTestExpr(lockNode.pos, varRef, this.getErrorTypeNode());
        isErrorTest.setBType(this.symTable.booleanType);
        BLangIf ifelse = ASTBuilderUtil.createIfElseStmt(lockNode.pos, isErrorTest, ifBody, null);
        blockStmt.addStatement(ifelse);
        this.result = this.rewrite(blockStmt, this.env);
        this.enclLocks.pop();
        this.onFailClause = currentOnFailClause;
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockStmt) {
        this.result = lockStmt;
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockStmt) {
        this.result = unLockStmt;
    }

    private BLangOnFailClause createTrxInternalOnFail(Location pos, BLangSimpleVarRef shouldPanicRef, BLangSimpleVarRef shouldRetryRef) {
        BLangOnFailClause trxOnFailClause = (BLangOnFailClause)TreeBuilder.createOnFailClauseNode();
        trxOnFailClause.pos = pos;
        trxOnFailClause.body = ASTBuilderUtil.createBlockStmt(pos);
        trxOnFailClause.body.scope = new Scope(this.env.scope.owner);
        trxOnFailClause.isInternal = true;
        BVarSymbol trxOnFailErrorSym = new BVarSymbol(0L, Names.fromString("$trxError$"), this.env.scope.owner.pkgID, this.symTable.errorType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable trxOnFailError = ASTBuilderUtil.createVariable(pos, "$trxError$", this.symTable.errorType, null, trxOnFailErrorSym);
        trxOnFailClause.variableDefinitionNode = ASTBuilderUtil.createVariableDef(pos, trxOnFailError);
        trxOnFailClause.body.scope.define(trxOnFailErrorSym.name, trxOnFailErrorSym);
        this.transactionDesugar.createRollbackIfFailed(pos, trxOnFailClause.body, trxOnFailErrorSym, this.trxBlockId, shouldRetryRef);
        BLangGroupExpr shouldNotPanic = new BLangGroupExpr();
        shouldNotPanic.setBType(this.symTable.booleanType);
        shouldNotPanic.expression = this.createNotBinaryExpression(pos, shouldPanicRef);
        BLangSimpleVarRef caughtError = ASTBuilderUtil.createVariableRef(pos, trxOnFailErrorSym);
        BLangBlockStmt failBlock = ASTBuilderUtil.createBlockStmt(pos);
        BLangPanic panicNode = (BLangPanic)TreeBuilder.createPanicNode();
        panicNode.pos = pos;
        panicNode.expr = caughtError;
        BLangIf exitIf = ASTBuilderUtil.createIfElseStmt(pos, shouldNotPanic, failBlock, panicNode);
        trxOnFailClause.body.stmts.add(exitIf);
        BLangFail failStmt = (BLangFail)TreeBuilder.createFailNode();
        failStmt.pos = pos;
        failStmt.expr = caughtError;
        failBlock.stmts.add(failStmt);
        trxOnFailClause.bodyContainsFail = true;
        return trxOnFailClause;
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        if (transactionNode.onFailClause != null) {
            BLangOnFailClause onFailClause = transactionNode.onFailClause;
            transactionNode.onFailClause = null;
            transactionNode.transactionBody.failureBreakMode = BLangBlockStmt.FailureBreakMode.NOT_BREAKABLE;
            BLangDo doStmt = this.wrapStatementWithinDo(transactionNode.pos, transactionNode, onFailClause);
            this.result = this.rewrite(doStmt, this.env);
        } else {
            BLangLiteral currentTrxBlockId = this.trxBlockId;
            String uniqueId = String.valueOf(++this.transactionBlockCount);
            this.trxBlockId = ASTBuilderUtil.createLiteral(transactionNode.pos, this.symTable.stringType, uniqueId);
            boolean currShouldReturnErrors = this.shouldReturnErrors;
            this.shouldReturnErrors = true;
            BLangOnFailClause currOnFailClause = this.onFailClause;
            BLangLiteral falseLiteral = ASTBuilderUtil.createLiteral(transactionNode.pos, this.symTable.booleanType, false);
            BVarSymbol shouldPanicVarSymbol = new BVarSymbol(0L, Names.fromString("$shouldPanic$"), this.env.scope.owner.pkgID, this.symTable.booleanType, this.env.scope.owner, transactionNode.pos, SymbolOrigin.VIRTUAL);
            shouldPanicVarSymbol.closure = true;
            BLangSimpleVariable shouldPanicVariable = ASTBuilderUtil.createVariable(transactionNode.pos, "$shouldPanic$", this.symTable.booleanType, falseLiteral, shouldPanicVarSymbol);
            BLangSimpleVariableDef shouldPanicDef = ASTBuilderUtil.createVariableDef(transactionNode.pos, shouldPanicVariable);
            BLangSimpleVarRef shouldPanicRef = ASTBuilderUtil.createVariableRef(transactionNode.pos, shouldPanicVarSymbol);
            BLangOnFailClause trxInternalOnFail = this.createTrxInternalOnFail(transactionNode.pos, shouldPanicRef, this.shouldRetryRef);
            this.enclosingShouldPanic.put(trxInternalOnFail, shouldPanicRef);
            boolean userDefinedOnFailAvbl = this.onFailClause != null;
            this.analyzeOnFailClause(trxInternalOnFail, transactionNode.transactionBody);
            BLangBlockStmt transactionStmtBlock = this.transactionDesugar.rewrite(transactionNode, this.trxBlockId, this.env, uniqueId);
            transactionStmtBlock.stmts.add(0, shouldPanicDef);
            transactionStmtBlock.scope.define(shouldPanicVarSymbol.name, shouldPanicVarSymbol);
            transactionStmtBlock.failureBreakMode = userDefinedOnFailAvbl ? BLangBlockStmt.FailureBreakMode.NOT_BREAKABLE : BLangBlockStmt.FailureBreakMode.BREAK_TO_OUTER_BLOCK;
            this.result = this.rewrite(transactionStmtBlock, this.env);
            this.shouldReturnErrors = currShouldReturnErrors;
            this.trxBlockId = currentTrxBlockId;
            this.swapAndResetEnclosingOnFail(currOnFailClause);
        }
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        BLangBlockStmt rollbackStmtExpr = this.transactionDesugar.desugar(rollbackNode, this.trxBlockId, this.shouldRetryRef);
        this.result = this.rewrite(rollbackStmtExpr, this.env);
    }

    private BLangOnFailClause createRetryInternalOnFail(Location pos, BLangSimpleVarRef retryResultRef, BLangSimpleVarRef retryManagerRef, BLangSimpleVarRef shouldRetryRef, BLangSimpleVarRef continueLoopRef, BLangSimpleVarRef returnResult) {
        BLangOnFailClause internalOnFail = (BLangOnFailClause)TreeBuilder.createOnFailClauseNode();
        internalOnFail.pos = pos;
        internalOnFail.body = ASTBuilderUtil.createBlockStmt(pos);
        internalOnFail.body.scope = new Scope(this.env.scope.owner);
        BVarSymbol caughtErrorSym = new BVarSymbol(0L, Names.fromString("$caughtError$"), this.env.scope.owner.pkgID, this.symTable.errorType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable caughtError = ASTBuilderUtil.createVariable(pos, "$caughtError$", this.symTable.errorType, null, caughtErrorSym);
        internalOnFail.variableDefinitionNode = ASTBuilderUtil.createVariableDef(pos, caughtError);
        this.env.scope.define(caughtErrorSym.name, caughtErrorSym);
        BLangSimpleVarRef caughtErrorRef = ASTBuilderUtil.createVariableRef(pos, caughtErrorSym);
        BLangAssignment errorAssignment = ASTBuilderUtil.createAssignmentStmt(pos, retryResultRef, caughtErrorRef);
        internalOnFail.body.stmts.add(errorAssignment);
        BLangAssignment continueLoopTrue = ASTBuilderUtil.createAssignmentStmt(pos, continueLoopRef, ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true));
        internalOnFail.body.stmts.add(continueLoopTrue);
        BLangInvocation shouldRetryInvocation = this.createRetryManagerShouldRetryInvocation(pos, retryManagerRef, caughtErrorRef);
        BLangAssignment shouldRetryAssignment = ASTBuilderUtil.createAssignmentStmt(pos, shouldRetryRef, shouldRetryInvocation);
        internalOnFail.body.stmts.add(shouldRetryAssignment);
        BLangGroupExpr shouldNotRetryCheck = new BLangGroupExpr();
        shouldNotRetryCheck.setBType(this.symTable.booleanType);
        shouldNotRetryCheck.expression = this.createNotBinaryExpression(pos, shouldRetryRef);
        BLangGroupExpr exitCheck = new BLangGroupExpr();
        exitCheck.setBType(this.symTable.booleanType);
        exitCheck.expression = shouldNotRetryCheck;
        BLangBlockStmt exitLogicBlock = ASTBuilderUtil.createBlockStmt(pos);
        BLangIf exitIf = ASTBuilderUtil.createIfElseStmt(pos, exitCheck, exitLogicBlock, null);
        if (this.onFailClause != null) {
            BLangFail failStmt = (BLangFail)TreeBuilder.createFailNode();
            failStmt.pos = pos;
            failStmt.expr = retryResultRef;
            exitLogicBlock.stmts.add(failStmt);
            internalOnFail.bodyContainsFail = true;
            internalOnFail.body.stmts.add(exitIf);
            BLangContinue loopContinueStmt = (BLangContinue)TreeBuilder.createContinueNode();
            loopContinueStmt.pos = pos;
            internalOnFail.body.stmts.add(loopContinueStmt);
        } else {
            BLangAssignment returnErrorTrue = ASTBuilderUtil.createAssignmentStmt(pos, returnResult, ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true));
            exitLogicBlock.stmts.add(returnErrorTrue);
            internalOnFail.body.stmts.add(exitIf);
        }
        return internalOnFail;
    }

    BLangUnaryExpr createNotBinaryExpression(Location pos, BLangExpression expression) {
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        paramTypes.add(this.symTable.booleanType);
        BInvokableType type = new BInvokableType(this.symTable.typeEnv(), paramTypes, this.symTable.booleanType, null);
        BOperatorSymbol notOperatorSymbol = new BOperatorSymbol(Names.fromString(OperatorKind.NOT.value()), this.symTable.rootPkgSymbol.pkgID, type, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        return ASTBuilderUtil.createUnaryExpr(pos, expression, this.symTable.booleanType, OperatorKind.NOT, notOperatorSymbol);
    }

    BLangLambdaFunction createLambdaFunction(Location pos, String functionNamePrefix, List<BLangSimpleVariable> lambdaFunctionVariable, TypeNode returnType, BLangFunctionBody lambdaBody) {
        BLangFunction func;
        BLangLambdaFunction lambdaFunction = (BLangLambdaFunction)TreeBuilder.createLambdaFunctionNode();
        lambdaFunction.function = func = ASTBuilderUtil.createFunction(pos, functionNamePrefix + "_" + this.lambdaFunctionCount++);
        func.requiredParams.addAll(lambdaFunctionVariable);
        func.setReturnTypeNode(returnType);
        func.desugaredReturnType = true;
        this.defineFunction(func, this.env.enclPkg);
        lambdaFunctionVariable = func.requiredParams;
        func.body = lambdaBody;
        func.desugared = false;
        lambdaFunction.pos = pos;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        lambdaFunctionVariable.forEach(variable -> paramTypes.add(variable.symbol.type));
        lambdaFunction.setBType(new BInvokableType(this.symTable.typeEnv(), paramTypes, func.symbol.type.getReturnType(), null));
        return lambdaFunction;
    }

    private void defineFunction(BLangFunction funcNode, BLangPackage targetPkg) {
        BPackageSymbol packageSymbol = targetPkg.symbol;
        SymbolEnv packageEnv = this.symTable.pkgEnvMap.get(packageSymbol);
        this.symbolEnter.defineNode(funcNode, packageEnv);
        packageEnv.enclPkg.functions.add(funcNode);
        packageEnv.enclPkg.topLevelNodes.add(funcNode);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        this.result = forkJoin;
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        int tag = Types.getImpliedType((BType)literalExpr.getBType()).tag;
        if (tag == 20 || tag == 31) {
            this.result = this.rewriteBlobLiteral(literalExpr);
            return;
        }
        this.result = literalExpr;
    }

    private BLangNode rewriteBlobLiteral(BLangLiteral literalExpr) {
        byte[] values = this.types.convertToByteArray((String)literalExpr.value);
        BLangListConstructorExpr.BLangArrayLiteral arrayLiteralNode = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        arrayLiteralNode.setBType(literalExpr.getBType());
        arrayLiteralNode.pos = literalExpr.pos;
        arrayLiteralNode.exprs = new ArrayList();
        for (byte b : values) {
            arrayLiteralNode.exprs.add(this.createByteLiteral(literalExpr.pos, b));
        }
        return arrayLiteralNode;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangListConstructorSpreadOpExpr listConstructorSpreadOpExpr) {
        listConstructorSpreadOpExpr.expr = this.rewriteExpr(listConstructorSpreadOpExpr.expr);
        this.result = listConstructorSpreadOpExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructor) {
        listConstructor.exprs = this.rewriteExprs(listConstructor.exprs);
        BType listConstructorType = Types.getImpliedType(listConstructor.getBType());
        if (listConstructorType.tag == 31) {
            BLangListConstructorExpr.BLangTupleLiteral expr = new BLangListConstructorExpr.BLangTupleLiteral(listConstructor.pos, listConstructor.exprs, listConstructor.getBType());
            this.result = this.rewriteExpr(expr);
        } else if (listConstructorType.tag == 7) {
            BLangListConstructorExpr.BLangJSONArrayLiteral expr = new BLangListConstructorExpr.BLangJSONArrayLiteral(listConstructor.exprs, new BArrayType(this.symTable.typeEnv(), listConstructor.getBType()));
            this.result = this.rewriteExpr(expr);
        } else if (this.getElementType((BType)listConstructorType).tag == 7) {
            BLangListConstructorExpr.BLangJSONArrayLiteral expr = new BLangListConstructorExpr.BLangJSONArrayLiteral(listConstructor.exprs, listConstructor.getBType());
            this.result = this.rewriteExpr(expr);
        } else if (listConstructorType.tag == 13) {
            BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
            typedescExpr.resolvedType = listConstructor.typedescType;
            typedescExpr.setBType(this.symTable.typeDesc);
            this.result = this.rewriteExpr(typedescExpr);
        } else {
            BLangListConstructorExpr.BLangArrayLiteral expr = new BLangListConstructorExpr.BLangArrayLiteral(listConstructor.pos, listConstructor.exprs, listConstructor.getBType());
            this.result = this.rewriteExpr(expr);
        }
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        this.rewriteExprs(tableConstructorExpr.recordLiteralList);
        this.result = tableConstructorExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral arrayLiteral) {
        arrayLiteral.exprs = this.rewriteExprs(arrayLiteral.exprs);
        BType arrayLiteralType = Types.getImpliedType(arrayLiteral.getBType());
        if (arrayLiteralType.tag == 7) {
            this.result = new BLangListConstructorExpr.BLangJSONArrayLiteral(arrayLiteral.exprs, new BArrayType(this.symTable.typeEnv(), arrayLiteral.getBType()));
            return;
        }
        if (this.getElementType((BType)arrayLiteralType).tag == 7) {
            this.result = new BLangListConstructorExpr.BLangJSONArrayLiteral(arrayLiteral.exprs, arrayLiteral.getBType());
            return;
        }
        this.result = arrayLiteral;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
        if (tupleLiteral.isTypedescExpr) {
            BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
            typedescExpr.resolvedType = tupleLiteral.typedescType;
            typedescExpr.setBType(this.symTable.typeDesc);
            this.result = this.rewriteExpr(typedescExpr);
            return;
        }
        List exprs = tupleLiteral.exprs;
        BTupleType tupleType = (BTupleType)Types.getImpliedType(tupleLiteral.getBType());
        List<BType> tupleMemberTypes = tupleType.getTupleTypes();
        int tupleMemberTypeSize = tupleMemberTypes.size();
        int tupleExprSize = exprs.size();
        boolean isInRestType = false;
        int i = 0;
        for (BLangExpression expr : exprs) {
            if (expr.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                BType spreadOpType = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr.getBType();
                spreadOpType = Types.getImpliedType(spreadOpType);
                if (spreadOpType.tag == 20) {
                    BArrayType spreadOpBArray = (BArrayType)spreadOpType;
                    if (spreadOpBArray.getSize() >= 0) {
                        i += spreadOpBArray.getSize();
                        continue;
                    }
                } else {
                    BTupleType spreadOpTuple;
                    BTupleType bTupleType = spreadOpTuple = spreadOpType.tag == 22 ? (BTupleType)((BIntersectionType)spreadOpType).effectiveType : (BTupleType)spreadOpType;
                    if (this.types.isFixedLengthTuple(spreadOpTuple)) {
                        i += spreadOpTuple.getMembers().size();
                        continue;
                    }
                }
                isInRestType = true;
                continue;
            }
            BType expType = expr.impConversionExpr == null ? expr.getBType() : expr.impConversionExpr.getBType();
            BType targetType = tupleType.restType;
            if (!isInRestType && i < tupleMemberTypeSize) {
                targetType = tupleMemberTypes.get(i);
            }
            this.types.setImplicitCastExpr(expr, expType, targetType);
            ++i;
        }
        tupleLiteral.exprs = this.rewriteExprs(tupleLiteral.exprs);
        this.result = tupleLiteral;
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.result = this.rewriteExpr(groupExpr.expression);
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        List<RecordLiteralNode.RecordField> fields = recordLiteral.fields;
        this.generateFieldsForUserUnspecifiedRecordFields(recordLiteral, fields);
        fields.sort((v1, v2) -> Boolean.compare(this.isComputedKey((RecordLiteralNode.RecordField)v1), this.isComputedKey((RecordLiteralNode.RecordField)v2)));
        this.result = this.rewriteExpr(this.rewriteMappingConstructor(recordLiteral));
    }

    private SymbolEnv findEnclosingInvokableEnv(SymbolEnv env, BLangInvokableNode encInvokable) {
        if (env.enclEnv.node != null && env.enclEnv.node.getKind() == NodeKind.ARROW_EXPR) {
            return env.enclEnv;
        }
        if (env.enclEnv.node != null && env.enclEnv.node.getKind() == NodeKind.ON_FAIL) {
            return env.enclEnv;
        }
        if (env.enclInvokable != null && env.enclInvokable == encInvokable) {
            return this.findEnclosingInvokableEnv(env.enclEnv, encInvokable);
        }
        return env;
    }

    private void updateClosureVariable(BVarSymbol varSymbol, BLangInvokableNode encInvokable, Location pos) {
        SymbolEnv encInvokableEnv;
        BSymbol resolvedSymbol;
        if (!varSymbol.closure && (resolvedSymbol = this.symResolver.lookupClosureVarSymbol(encInvokableEnv = this.findEnclosingInvokableEnv(this.env, encInvokable), varSymbol)) != this.symTable.notFoundSymbol) {
            varSymbol.closure = true;
            ((BLangFunction)encInvokable).closureVarSymbols.add(new ClosureVarSymbol(varSymbol, pos));
        }
    }

    private List<String> getNamesOfUserSpecifiedRecordFields(List<RecordLiteralNode.RecordField> userSpecifiedFields) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (RecordLiteralNode.RecordField field : userSpecifiedFields) {
            if (field.isKeyValueField()) {
                BLangExpression key = ((BLangRecordLiteral.BLangRecordKeyValueField)field).key.expr;
                if (key.getKind() == NodeKind.LITERAL) {
                    fieldNames.add(Utils.unescapeBallerina((String)((BLangLiteral)key).value.toString()));
                    continue;
                }
                if (key.getKind() != NodeKind.SIMPLE_VARIABLE_REF) continue;
                fieldNames.add(Utils.unescapeBallerina((String)((BLangSimpleVarRef)key).variableName.value));
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                fieldNames.add(Utils.unescapeBallerina((String)((BLangSimpleVarRef)((Object)field)).variableName.value));
                continue;
            }
            this.addRequiredFieldsFromSpreadOperator(field, fieldNames);
        }
        return fieldNames;
    }

    private void addRequiredFieldsFromSpreadOperator(RecordLiteralNode.RecordField field, List<String> fieldNames) {
        BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOpField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
        BType type = Types.getReferredType(spreadOpField.expr.getBType());
        if (type.tag != 12) {
            return;
        }
        for (BField bField : ((BRecordType)type).fields.values()) {
            fieldNames.add(Utils.unescapeBallerina((String)bField.name.value));
        }
    }

    private void generateFieldsForUserUnspecifiedRecordFields(List<RecordLiteralNode.RecordField> fields, List<String> fieldNames, Map<String, BInvokableSymbol> defaultValues, Location pos, boolean isReadonly) {
        for (Map.Entry<String, BInvokableSymbol> entry : defaultValues.entrySet()) {
            String fieldName = entry.getKey();
            if (fieldNames.contains(fieldName)) continue;
            fieldNames.add(fieldName);
            BInvokableSymbol invokableSymbol = entry.getValue();
            BLangExpression expression = this.getFunctionPointerInvocation(invokableSymbol);
            if (isReadonly && !Symbols.isFlagOn(invokableSymbol.retType.getFlags(), 32L)) {
                expression = this.visitCloneReadonly(expression, invokableSymbol.retType);
            }
            if (this.env.enclInvokable != null) {
                BLangInvocation invocation = expression;
                if (invocation.expr.getKind() == NodeKind.INVOCATION) {
                    this.updateClosureVariable((BVarSymbol)((BLangInvocation)invocation.expr).symbol, this.env.enclInvokable, pos);
                } else {
                    this.updateClosureVariable((BVarSymbol)invocation.symbol, this.env.enclInvokable, pos);
                }
            }
            BLangRecordLiteral.BLangRecordKeyValueField member = this.createRecordKeyValueField(pos, fieldName, expression);
            fields.add(member);
        }
    }

    private BLangRecordLiteral.BLangRecordKeyValueField createRecordKeyValueField(Location pos, String fieldName, BLangExpression expression) {
        BLangRecordLiteral.BLangRecordKeyValueField member = new BLangRecordLiteral.BLangRecordKeyValueField();
        member.key = new BLangRecordLiteral.BLangRecordKey(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, Utils.unescapeJava((String)fieldName)));
        member.valueExpr = this.types.addConversionExprIfRequired(expression, expression.getBType());
        return member;
    }

    public void generateFieldsForUserUnspecifiedRecordFields(BLangRecordLiteral recordLiteral, List<RecordLiteralNode.RecordField> userSpecifiedFields) {
        BType type = Types.getImpliedType(recordLiteral.getBType());
        if (type.getKind() != TypeKind.RECORD || this.isSpreadingAnOpenRecord(userSpecifiedFields)) {
            return;
        }
        List<String> fieldNames = this.getNamesOfUserSpecifiedRecordFields(userSpecifiedFields);
        Location pos = recordLiteral.pos;
        BRecordType recordType = (BRecordType)type;
        boolean isReadonly = Symbols.isFlagOn(recordType.getFlags(), 32L);
        this.generateFieldsForUserUnspecifiedRecordFields(recordType, userSpecifiedFields, fieldNames, pos, isReadonly);
    }

    private boolean isSpreadingAnOpenRecord(List<RecordLiteralNode.RecordField> userSpecifiedFields) {
        for (RecordLiteralNode.RecordField field : userSpecifiedFields) {
            if (!(field instanceof BLangRecordLiteral.BLangRecordSpreadOperatorField)) continue;
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOperatorField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            BType type = Types.getReferredType(spreadOperatorField.expr.getBType());
            if (!(type instanceof BRecordType)) {
                return true;
            }
            BRecordType recordType = (BRecordType)type;
            if (recordType.restFieldType == null || this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(recordType.restFieldType)) continue;
            return true;
        }
        return false;
    }

    private void generateFieldsForUserUnspecifiedRecordFields(BRecordType recordType, List<RecordLiteralNode.RecordField> fields, List<String> fieldNames, Location pos, boolean isReadonly) {
        Map<String, BInvokableSymbol> defaultValues = ((BRecordTypeSymbol)recordType.tsymbol).defaultValues;
        this.generateFieldsForUserUnspecifiedRecordFields(fields, fieldNames, defaultValues, pos, isReadonly);
        List typeInclusions = recordType.typeInclusions;
        for (BType typeInclusion : typeInclusions) {
            this.generateFieldsForUserUnspecifiedRecordFields((BRecordType)Types.getImpliedType(typeInclusion), fields, fieldNames, pos, isReadonly);
        }
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        BLangSimpleVarRef genVarRefExpr = varRefExpr;
        if (varRefExpr.pkgSymbol != null && varRefExpr.pkgSymbol.tag == 8193L) {
            BLangXMLQName qnameExpr = new BLangXMLQName(varRefExpr.variableName);
            qnameExpr.nsSymbol = (BXMLNSSymbol)varRefExpr.pkgSymbol;
            qnameExpr.localname = varRefExpr.variableName;
            qnameExpr.prefix = varRefExpr.pkgAlias;
            qnameExpr.namespaceURI = qnameExpr.nsSymbol.namespaceURI;
            qnameExpr.isUsedInXML = false;
            qnameExpr.pos = varRefExpr.pos;
            qnameExpr.setBType(this.symTable.stringType);
            this.result = qnameExpr;
            return;
        }
        if (varRefExpr.symbol == null) {
            this.result = varRefExpr;
            return;
        }
        if ((varRefExpr.symbol.tag & 0x34L) == 52L) {
            BVarSymbol varSymbol = (BVarSymbol)varRefExpr.symbol;
            if (varSymbol.originalSymbol != null) {
                varRefExpr.symbol = varSymbol.originalSymbol;
                if (varSymbol.closure) {
                    varRefExpr.symbol.closure = true;
                }
            }
        }
        BType type = varRefExpr.getBType();
        BSymbol ownerSymbol = varRefExpr.symbol.owner;
        if ((varRefExpr.symbol.tag & 0x334L) == 820L && Types.getImpliedType((BType)varRefExpr.symbol.type).tag == 17) {
            genVarRefExpr = new BLangSimpleVarRef.BLangFunctionVarRef((BVarSymbol)varRefExpr.symbol);
        } else if ((varRefExpr.symbol.tag & 0xCL) == 12L && (varRefExpr.symbol.tag & 0x100001CL) != 0x100001CL) {
            genVarRefExpr = new BLangSimpleVarRef.BLangTypeLoad(varRefExpr.symbol);
        } else if ((ownerSymbol.tag & 0x100L) == 256L || (ownerSymbol.tag & 0x200801CL) == 33587228L || (ownerSymbol.tag & 0x8000000L) == 0x8000000L) {
            genVarRefExpr = new BLangSimpleVarRef.BLangLocalVarRef((BVarSymbol)varRefExpr.symbol);
        } else if ((ownerSymbol.tag & 0x5CL) == 92L) {
            genVarRefExpr = new BLangSimpleVarRef.BLangFieldVarRef((BVarSymbol)varRefExpr.symbol);
        } else if ((ownerSymbol.tag & 0x1001L) == 4097L || (ownerSymbol.tag & 0x84L) == 132L) {
            if ((varRefExpr.symbol.tag & 0x100001CL) == 0x100001CL) {
                BConstantSymbol constSymbol = (BConstantSymbol)varRefExpr.symbol;
                BType referredType = Types.getImpliedType(constSymbol.literalType);
                if (referredType.tag <= 6 || referredType.tag == 10) {
                    BLangLiteral literal = ASTBuilderUtil.createLiteral(varRefExpr.pos, constSymbol.literalType, constSymbol.value.value);
                    this.result = this.rewriteExpr(this.types.addConversionExprIfRequired(literal, varRefExpr.getBType()));
                    return;
                }
            }
            genVarRefExpr = new BLangSimpleVarRef.BLangPackageVarRef((BVarSymbol)varRefExpr.symbol);
            if (!this.enclLocks.isEmpty()) {
                BVarSymbol symbol = (BVarSymbol)varRefExpr.symbol;
                BLangLock.BLangLockStmt lockStmt = this.enclLocks.peek();
                lockStmt.addLockVariable(symbol);
                lockStmt.addLockVariable(this.globalVariablesDependsOn.getOrDefault(symbol, new HashSet()));
            }
        }
        genVarRefExpr.setBType(type);
        genVarRefExpr.pos = varRefExpr.pos;
        if (varRefExpr.isLValue || genVarRefExpr.symbol.name.equals(Names.IGNORE)) {
            genVarRefExpr.isLValue = varRefExpr.isLValue;
            genVarRefExpr.setBType(varRefExpr.symbol.type);
            this.result = genVarRefExpr;
            return;
        }
        genVarRefExpr.isLValue = false;
        BType targetType = genVarRefExpr.getBType();
        genVarRefExpr.setBType(genVarRefExpr.symbol.type);
        BLangExpression expression = this.types.addConversionExprIfRequired(genVarRefExpr, targetType);
        this.result = expression.impConversionExpr != null ? expression.impConversionExpr : expression;
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess prefixedFieldBasedAccess) {
        this.rewriteFieldBasedAccess(prefixedFieldBasedAccess, true);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void rewriteFieldBasedAccess(BLangFieldBasedAccess fieldAccessExpr, boolean prefixedFieldBased) {
        void var3_10;
        if (this.safeNavigate(fieldAccessExpr)) {
            this.result = prefixedFieldBased ? this.rewriteExpr(this.rewriteSafeNavigationExpr(fieldAccessExpr)) : this.rewriteExpr(this.rewriteSafeFieldBasedAccessExpr(fieldAccessExpr));
            return;
        }
        BLangFieldBasedAccess bLangFieldBasedAccess = fieldAccessExpr;
        BType varRefType = this.types.getTypeWithEffectiveIntersectionTypes(fieldAccessExpr.expr.getBType());
        fieldAccessExpr.expr = this.rewriteExpr(fieldAccessExpr.expr);
        if (!this.types.isSameType(fieldAccessExpr.expr.getBType(), varRefType)) {
            fieldAccessExpr.expr = this.types.addConversionExprIfRequired(fieldAccessExpr.expr, varRefType);
        }
        BLangLiteral stringLit = this.createStringLiteral(fieldAccessExpr.field.pos, Utils.unescapeJava((String)fieldAccessExpr.field.value));
        BType refType = Types.getImpliedType(varRefType);
        int varRefTypeTag = refType.tag;
        if (varRefTypeTag == 34 || varRefTypeTag == 21 && Types.getImpliedType((BType)((BType)((HashSet)((BUnionType)refType).getMemberTypes()).iterator().next())).tag == 34) {
            if (fieldAccessExpr.symbol != null && Types.getImpliedType((BType)fieldAccessExpr.symbol.type).tag == 17 && (fieldAccessExpr.symbol.flags & 8L) == 8L) {
                this.result = this.rewriteObjectMemberAccessAsField(fieldAccessExpr);
                return;
            }
            boolean isStoreOnCreation = fieldAccessExpr.isStoreOnCreation;
            if (!isStoreOnCreation && varRefTypeTag == 34 && this.env.enclInvokable != null) {
                BInvokableSymbol originalFuncSymbol = ((BLangFunction)this.env.enclInvokable).originalFuncSymbol;
                BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)refType.tsymbol;
                BAttachedFunction initializerFunc = objectTypeSymbol.initializerFunc;
                BAttachedFunction generatedInitializerFunc = objectTypeSymbol.generatedInitializerFunc;
                if (generatedInitializerFunc != null && originalFuncSymbol == generatedInitializerFunc.symbol || initializerFunc != null && originalFuncSymbol == initializerFunc.symbol) {
                    isStoreOnCreation = true;
                }
            }
            BLangIndexBasedAccess.BLangStructFieldAccessExpr bLangStructFieldAccessExpr = new BLangIndexBasedAccess.BLangStructFieldAccessExpr(fieldAccessExpr.pos, fieldAccessExpr.expr, stringLit, (BVarSymbol)fieldAccessExpr.symbol, false, isStoreOnCreation);
        } else if (varRefTypeTag == 12 || varRefTypeTag == 21 && Types.getImpliedType((BType)((BType)((HashSet)((BUnionType)refType).getMemberTypes()).iterator().next())).tag == 12) {
            if (fieldAccessExpr.symbol != null && Types.getImpliedType((BType)fieldAccessExpr.symbol.type).tag == 17 && (fieldAccessExpr.symbol.flags & 8L) == 8L) {
                BLangFieldBasedAccess.BLangStructFunctionVarRef bLangStructFunctionVarRef = new BLangFieldBasedAccess.BLangStructFunctionVarRef(fieldAccessExpr.expr, (BVarSymbol)fieldAccessExpr.symbol);
            } else {
                BLangIndexBasedAccess.BLangStructFieldAccessExpr bLangStructFieldAccessExpr = new BLangIndexBasedAccess.BLangStructFieldAccessExpr(fieldAccessExpr.pos, fieldAccessExpr.expr, stringLit, (BVarSymbol)fieldAccessExpr.symbol, false, fieldAccessExpr.isStoreOnCreation);
            }
        } else if (this.types.isLaxFieldAccessAllowed(refType)) {
            if (this.types.isAssignable(refType, this.symTable.xmlType)) {
                fieldAccessExpr.expr = this.types.addConversionExprIfRequired(fieldAccessExpr.expr, this.symTable.xmlType);
                BLangInvocation xmlAccessInvocation = this.rewriteXMLAttributeOrElemNameAccess(fieldAccessExpr);
                xmlAccessInvocation.setBType(fieldAccessExpr.getBType());
                this.result = xmlAccessInvocation;
                return;
            }
            if (varRefTypeTag == 16 && TypeTags.isXMLTypeTag(Types.getImpliedType((BType)((BMapType)refType).constraint).tag)) {
                this.result = this.rewriteExpr(this.rewriteLaxMapAccess(fieldAccessExpr));
                return;
            }
            fieldAccessExpr.expr = this.types.addConversionExprIfRequired(fieldAccessExpr.expr, this.symTable.jsonType);
            BLangIndexBasedAccess.BLangJSONAccessExpr bLangJSONAccessExpr = new BLangIndexBasedAccess.BLangJSONAccessExpr(fieldAccessExpr.pos, fieldAccessExpr.expr, stringLit);
        } else if (varRefTypeTag == 16) {
            BLangIndexBasedAccess.BLangMapAccessExpr bLangMapAccessExpr = new BLangIndexBasedAccess.BLangMapAccessExpr(fieldAccessExpr.pos, fieldAccessExpr.expr, stringLit, fieldAccessExpr.isStoreOnCreation);
        } else if (TypeTags.isXMLTypeTag(varRefTypeTag)) {
            BLangIndexBasedAccess.BLangXMLAccessExpr bLangXMLAccessExpr = new BLangIndexBasedAccess.BLangXMLAccessExpr(fieldAccessExpr.pos, fieldAccessExpr.expr, stringLit, fieldAccessExpr.fieldKind);
        }
        var3_10.isLValue = fieldAccessExpr.isLValue;
        var3_10.setBType(fieldAccessExpr.getBType());
        var3_10.optionalFieldAccess = fieldAccessExpr.optionalFieldAccess;
        this.result = var3_10;
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        this.rewriteFieldBasedAccess(fieldAccessExpr, false);
    }

    private BLangNode rewriteObjectMemberAccessAsField(BLangFieldBasedAccess fieldAccessExpr) {
        Location pos = fieldAccessExpr.pos;
        BInvokableSymbol originalMemberFuncSymbol = (BInvokableSymbol)fieldAccessExpr.symbol;
        BLangFunction func = (BLangFunction)TreeBuilder.createFunctionNode();
        String funcName = "$anon$method$delegate$" + originalMemberFuncSymbol.name.value + "$" + this.lambdaFunctionCount++;
        BInvokableSymbol funcSymbol = new BInvokableSymbol(256L, 0x100800L, Names.fromString(funcName), this.env.enclPkg.packageID, originalMemberFuncSymbol.type, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        funcSymbol.retType = originalMemberFuncSymbol.retType;
        funcSymbol.bodyExist = true;
        funcSymbol.params = new ArrayList<BVarSymbol>();
        funcSymbol.scope = new Scope(funcSymbol);
        func.pos = pos;
        func.name = ASTBuilderUtil.createIdentifier(pos, funcName);
        func.flagSet.add(Flag.LAMBDA);
        func.flagSet.add(Flag.ANONYMOUS);
        func.body = (BLangBlockFunctionBody)TreeBuilder.createBlockFunctionBodyNode();
        func.symbol = funcSymbol;
        func.setBType(funcSymbol.type);
        func.closureVarSymbols = new LinkedHashSet<ClosureVarSymbol>();
        Object receiver = fieldAccessExpr.expr;
        BLangSimpleVariableDef intermediateObjDef = null;
        if (receiver.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BSymbol receiverSymbol = ((BLangVariableReference)receiver).symbol;
            receiverSymbol.closure = true;
            func.closureVarSymbols.add(new ClosureVarSymbol(receiverSymbol, pos));
        } else {
            BLangSimpleVariableDef varDef;
            intermediateObjDef = varDef = this.createVarDef("$$temp$obj$" + this.annonVarCount++, ((BLangNode)receiver).getBType(), (BLangExpression)receiver, pos);
            varDef.var.symbol.closure = true;
            this.env.scope.define(varDef.var.symbol.name, varDef.var.symbol);
            BLangSimpleVarRef variableRef = ASTBuilderUtil.createVariableRef(pos, varDef.var.symbol);
            func.closureVarSymbols.add(new ClosureVarSymbol(varDef.var.symbol, pos));
            receiver = variableRef;
        }
        ArrayList<BLangExpression> requiredArgs = new ArrayList<BLangExpression>();
        for (BVarSymbol param : originalMemberFuncSymbol.params) {
            BLangSimpleVariable fParam = (BLangSimpleVariable)TreeBuilder.createSimpleVariableNode();
            fParam.symbol = new BVarSymbol(0L, param.name, this.env.enclPkg.packageID, param.type, funcSymbol, pos, SymbolOrigin.VIRTUAL);
            fParam.pos = pos;
            fParam.name = ASTBuilderUtil.createIdentifier(pos, param.name.value);
            fParam.setBType(param.type);
            func.requiredParams.add(fParam);
            funcSymbol.params.add(fParam.symbol);
            funcSymbol.scope.define(fParam.symbol.name, fParam.symbol);
            BLangSimpleVarRef paramRef = ASTBuilderUtil.createVariableRef(pos, fParam.symbol);
            requiredArgs.add(paramRef);
        }
        ArrayList<BLangExpression> restArgs = new ArrayList<BLangExpression>();
        if (originalMemberFuncSymbol.restParam != null) {
            BLangSimpleVariable restParam;
            func.restParam = restParam = (BLangSimpleVariable)TreeBuilder.createSimpleVariableNode();
            BVarSymbol restSym = originalMemberFuncSymbol.restParam;
            restParam.name = ASTBuilderUtil.createIdentifier(pos, restSym.name.value);
            restParam.symbol = new BVarSymbol(0L, restSym.name, this.env.enclPkg.packageID, restSym.type, funcSymbol, pos, SymbolOrigin.VIRTUAL);
            restParam.pos = pos;
            restParam.setBType(restSym.type);
            funcSymbol.restParam = restParam.symbol;
            funcSymbol.scope.define(restParam.symbol.name, restParam.symbol);
            BLangSimpleVarRef restArg = ASTBuilderUtil.createVariableRef(pos, restParam.symbol);
            restArgs.add(this.createRestArgsExpression(restArg));
        }
        BLangIdentifier field = fieldAccessExpr.field;
        BLangReturn retStmt = (BLangReturn)TreeBuilder.createReturnNode();
        retStmt.expr = this.createObjectMethodInvocation((BLangExpression)receiver, field, fieldAccessExpr.symbol, requiredArgs, restArgs);
        ((BLangBlockFunctionBody)func.body).addStatement(retStmt);
        BLangLambdaFunction lambdaFunction = (BLangLambdaFunction)TreeBuilder.createLambdaFunctionNode();
        lambdaFunction.function = func;
        lambdaFunction.capturedClosureEnv = this.env;
        this.env.enclPkg.functions.add(func);
        this.env.enclPkg.topLevelNodes.add(func);
        lambdaFunction.parent = this.env.enclInvokable;
        lambdaFunction.setBType(func.getBType());
        if (intermediateObjDef == null) {
            return this.rewrite(lambdaFunction, this.env);
        }
        BLangStatementExpression expr = ASTBuilderUtil.createStatementExpression(intermediateObjDef, this.rewrite(lambdaFunction, this.env));
        expr.setBType(lambdaFunction.getBType());
        return this.rewrite(expr, this.env);
    }

    private BLangInvocation createObjectMethodInvocation(BLangExpression receiver, BLangIdentifier field, BSymbol invocableSymbol, List<BLangExpression> requiredArgs, List<BLangExpression> restArgs) {
        BLangInvocation invocationNode = (BLangInvocation)TreeBuilder.createInvocationNode();
        invocationNode.name = field;
        invocationNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        invocationNode.expr = receiver;
        invocationNode.symbol = invocableSymbol;
        invocationNode.setBType(((BInvokableType)invocableSymbol.type).retType);
        invocationNode.requiredArgs = requiredArgs;
        invocationNode.restArgs = restArgs;
        return invocationNode;
    }

    private BLangStatementExpression rewriteLaxMapAccess(BLangFieldBasedAccess fieldAccessExpr) {
        BLangBlockStmt resultNilBody;
        BLangStatementExpression statementExpression = new BLangStatementExpression();
        BLangBlockStmt block = new BLangBlockStmt();
        statementExpression.stmt = block;
        BUnionType fieldAccessType = BUnionType.create(this.symTable.typeEnv(), null, fieldAccessExpr.getBType(), this.symTable.errorType);
        Location pos = fieldAccessExpr.pos;
        BLangSimpleVariableDef result = this.createVarDef("$mapAccessResult$", fieldAccessType, null, pos);
        block.addStatement(result);
        BLangSimpleVarRef resultRef = ASTBuilderUtil.createVariableRef(pos, result.var.symbol);
        resultRef.setBType(fieldAccessType);
        statementExpression.setBType(fieldAccessType);
        BLangLiteral mapIndex = ASTBuilderUtil.createLiteral(fieldAccessExpr.field.pos, this.symTable.stringType, fieldAccessExpr.field.value);
        BLangIndexBasedAccess.BLangMapAccessExpr mapAccessExpr = new BLangIndexBasedAccess.BLangMapAccessExpr(pos, fieldAccessExpr.expr, mapIndex);
        BUnionType xmlOrNil = BUnionType.create(this.symTable.typeEnv(), null, fieldAccessExpr.getBType(), this.symTable.nilType);
        mapAccessExpr.setBType(xmlOrNil);
        BLangSimpleVariableDef mapResult = this.createVarDef("$mapAccess", xmlOrNil, mapAccessExpr, pos);
        BLangSimpleVarRef mapResultRef = ASTBuilderUtil.createVariableRef(pos, mapResult.var.symbol);
        block.addStatement(mapResult);
        BLangIf ifStmt = ASTBuilderUtil.createIfStmt(pos, block);
        BLangIsLikeExpr isLikeNilExpr = this.createIsLikeExpression(pos, mapResultRef, this.symTable.nilType);
        ifStmt.expr = isLikeNilExpr;
        ifStmt.body = resultNilBody = new BLangBlockStmt();
        BLangBlockStmt resultHasValueBody = new BLangBlockStmt();
        ifStmt.elseStmt = resultHasValueBody;
        BLangErrorConstructorExpr errorConstructorExpr = (BLangErrorConstructorExpr)TreeBuilder.createErrorConstructorExpressionNode();
        BSymbol symbol = this.symResolver.lookupMainSpaceSymbolInPackage(errorConstructorExpr.pos, this.env, Names.fromString(""), Names.fromString("error"));
        errorConstructorExpr.setBType(symbol.type);
        ArrayList<BLangExpression> positionalArgs = new ArrayList<BLangExpression>();
        ArrayList<BLangNamedArgsExpression> namedArgs = new ArrayList<BLangNamedArgsExpression>();
        positionalArgs.add(this.createStringLiteral(pos, "{lang.map}InvalidKey"));
        BLangNamedArgsExpression message = new BLangNamedArgsExpression();
        message.name = ASTBuilderUtil.createIdentifier(pos, "key");
        message.expr = this.createStringLiteral(pos, fieldAccessExpr.field.value);
        namedArgs.add(message);
        errorConstructorExpr.positionalArgs = positionalArgs;
        errorConstructorExpr.namedArgs = namedArgs;
        BLangSimpleVariableDef errorDef = this.createVarDef("$_invalid_key_error", this.symTable.errorType, errorConstructorExpr, pos);
        resultNilBody.addStatement(errorDef);
        BLangSimpleVarRef errorRef = ASTBuilderUtil.createVariableRef(pos, errorDef.var.symbol);
        BLangAssignment errorVarAssignment = ASTBuilderUtil.createAssignmentStmt(pos, resultNilBody);
        errorVarAssignment.varRef = resultRef;
        errorVarAssignment.expr = errorRef;
        BLangAssignment mapResultAssignment = ASTBuilderUtil.createAssignmentStmt(pos, resultHasValueBody);
        mapResultAssignment.varRef = resultRef;
        mapResultAssignment.expr = mapResultRef;
        statementExpression.expr = resultRef;
        return statementExpression;
    }

    private BLangInvocation rewriteXMLAttributeOrElemNameAccess(BLangFieldBasedAccess fieldAccessExpr) {
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        String fieldName = fieldAccessExpr.field.value;
        if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
            BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess prefixAccess = (BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess)fieldAccessExpr;
            fieldName = prefixAccess.symbol.getKind() == SymbolKind.CONSTANT ? (String)((BConstantSymbol)prefixAccess.symbol).value.value : this.createExpandedQName(((BXMLNSSymbol)prefixAccess.symbol).namespaceURI, fieldName);
        }
        if (fieldName.equals("_")) {
            return this.createLanglibXMLInvocation(fieldAccessExpr.pos, XML_INTERNAL_GET_ELEMENT_NAME_NIL_LIFTING, fieldAccessExpr.expr, Collections.emptyList(), Collections.emptyList());
        }
        BLangLiteral attributeNameLiteral = this.createStringLiteral(fieldAccessExpr.field.pos, fieldName);
        args.add(attributeNameLiteral);
        args.add(this.isOptionalAccessToLiteral(fieldAccessExpr));
        return this.createLanglibXMLInvocation(fieldAccessExpr.pos, XML_INTERNAL_GET_ATTRIBUTE, fieldAccessExpr.expr, args, Collections.emptyList());
    }

    private BLangExpression isOptionalAccessToLiteral(BLangFieldBasedAccess fieldAccessExpr) {
        return this.rewrite(ASTBuilderUtil.createLiteral(fieldAccessExpr.pos, this.symTable.booleanType, fieldAccessExpr.isOptionalFieldAccess()), this.env);
    }

    private String createExpandedQName(String nsURI, String localName) {
        return "{" + nsURI + "}" + localName;
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        if (this.safeNavigate(indexAccessExpr)) {
            this.result = this.rewriteExpr(this.rewriteSafeNavigationExpr(indexAccessExpr));
            return;
        }
        BLangIndexBasedAccess targetVarRef = indexAccessExpr;
        indexAccessExpr.indexExpr = this.rewriteExpr(indexAccessExpr.indexExpr);
        BType effectiveType = this.types.getTypeWithEffectiveIntersectionTypes(indexAccessExpr.expr.getBType());
        BType varRefType = Types.getImpliedType(effectiveType);
        indexAccessExpr.expr = this.rewriteExpr(indexAccessExpr.expr);
        if (!this.types.isSameType(indexAccessExpr.expr.getBType(), varRefType)) {
            indexAccessExpr.expr = this.types.addConversionExprIfRequired(indexAccessExpr.expr, varRefType);
        }
        if (varRefType.tag == 16) {
            targetVarRef = new BLangIndexBasedAccess.BLangMapAccessExpr(indexAccessExpr.pos, indexAccessExpr.expr, indexAccessExpr.indexExpr, indexAccessExpr.isStoreOnCreation);
        } else if (this.types.isSubTypeOfMapping(this.types.getNilLiftType(varRefType.semType()))) {
            targetVarRef = new BLangIndexBasedAccess.BLangStructFieldAccessExpr(indexAccessExpr.pos, indexAccessExpr.expr, indexAccessExpr.indexExpr, (BVarSymbol)indexAccessExpr.symbol, false);
        } else if (this.types.isSubTypeOfList(varRefType)) {
            targetVarRef = new BLangIndexBasedAccess.BLangArrayAccessExpr(indexAccessExpr.pos, indexAccessExpr.expr, indexAccessExpr.indexExpr);
        } else if (this.types.isAssignable(varRefType, this.symTable.xmlType)) {
            BLangExpression indexAccessExprExpr = indexAccessExpr.expr;
            if (Types.getImpliedType((BType)indexAccessExprExpr.getBType()).tag == 21) {
                indexAccessExprExpr = this.createTypeCastExpr(indexAccessExprExpr, this.symTable.xmlType);
            }
            targetVarRef = new BLangIndexBasedAccess.BLangXMLAccessExpr(indexAccessExpr.pos, indexAccessExprExpr, indexAccessExpr.indexExpr);
        } else if (this.types.isAssignable(varRefType, this.symTable.stringType)) {
            indexAccessExpr.expr = this.types.addConversionExprIfRequired(indexAccessExpr.expr, this.symTable.stringType);
            targetVarRef = new BLangIndexBasedAccess.BLangStringAccessExpr(indexAccessExpr.pos, indexAccessExpr.expr, indexAccessExpr.indexExpr);
        } else if (varRefType.tag == 9) {
            targetVarRef = new BLangIndexBasedAccess.BLangTableAccessExpr(indexAccessExpr.pos, indexAccessExpr.expr, indexAccessExpr.indexExpr);
        }
        targetVarRef.isLValue = indexAccessExpr.isLValue;
        targetVarRef.setBType(indexAccessExpr.getBType());
        this.result = targetVarRef;
    }

    @Override
    public void visit(BLangInvocation iExpr) {
        BLangExpression invocation = this.rewriteInvocation(iExpr, false);
        if (invocation.getKind() == NodeKind.TYPE_CONVERSION_EXPR) {
            ((BLangTypeConversionExpr)invocation).expr = this.createStmtExpr((BLangInvocation)((BLangTypeConversionExpr)invocation).expr);
            this.result = invocation;
        } else {
            this.result = this.createStmtExpr((BLangInvocation)invocation);
        }
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation invocation) {
        this.visitArgs(invocation);
        invocation.expr = this.rewriteExpr(invocation.expr);
        this.result = invocation;
    }

    private void visitArgs(BLangInvocation invocation) {
        this.reorderArguments(invocation);
        this.rewriteExprs(invocation.requiredArgs);
        this.fixStreamAndXmlTypeCastsInInvocationParams(invocation);
        this.fixNonRestArgTypeCastInTypeParamInvocation(invocation);
        this.rewriteExprs(invocation.restArgs);
    }

    private BLangStatementExpression createStmtExpr(BLangInvocation invocation) {
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(invocation.pos);
        BType type = Types.getImpliedType(invocation.symbol.type);
        BInvokableTypeSymbol invokableTypeSymbol = (BInvokableTypeSymbol)type.tsymbol;
        if (invokableTypeSymbol == null) {
            BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, invocation);
            stmtExpr.setBType(invocation.getBType());
            return stmtExpr;
        }
        TreeMap<String, BLangExpression> arguments = new TreeMap<String, BLangExpression>();
        Map<String, BInvokableSymbol> defaultValues = invokableTypeSymbol.defaultValues;
        for (int i = 0; i < invokableTypeSymbol.params.size(); ++i) {
            BLangSimpleVarRef simpleVarRef;
            BLangSimpleVariableDef variableDef;
            BLangExpression arg = invocation instanceof BLangInvocation.BLangAttachedFunctionInvocation ? invocation.requiredArgs.get(i + 1) : invocation.requiredArgs.get(i);
            BVarSymbol param = invokableTypeSymbol.params.get(i);
            String paramName = param.name.value;
            if (arg.getKind() != NodeKind.IGNORE_EXPR) {
                if (invocation.expr == arg) {
                    arguments.put(paramName, arg);
                    continue;
                }
                variableDef = arg.impConversionExpr != null ? this.createSimpleVarDef("$" + paramName + "$" + this.funcParamCount++, param.type, arg) : this.createSimpleVarDef("$" + paramName + "$" + this.funcParamCount++, arg.getBType(), arg);
                simpleVarRef = ASTBuilderUtil.createVariableRef(invocation.pos, variableDef.var.symbol);
                simpleVarRef = this.rewrite(simpleVarRef, this.env);
                blockStmt.addStatement(variableDef);
                arguments.put(paramName, simpleVarRef);
                if (invocation instanceof BLangInvocation.BLangAttachedFunctionInvocation) {
                    invocation.requiredArgs.set(i + 1, simpleVarRef);
                    continue;
                }
                invocation.requiredArgs.set(i, simpleVarRef);
                continue;
            }
            BInvokableSymbol invokableSymbol = defaultValues.get(Utils.unescapeBallerina((String)paramName));
            BLangInvocation closureInvocation = this.getFunctionPointerInvocation(invokableSymbol);
            for (int m = 0; m < invokableSymbol.params.size(); ++m) {
                String langLibFuncParam = invokableSymbol.params.get((int)m).name.value;
                closureInvocation.requiredArgs.add((BLangExpression)arguments.get(langLibFuncParam));
            }
            variableDef = this.createVarDef("$" + paramName + "$" + this.funcParamCount++, closureInvocation.getBType(), closureInvocation, arg.pos);
            simpleVarRef = ASTBuilderUtil.createVariableRef(invocation.pos, variableDef.var.symbol);
            simpleVarRef = this.rewrite(simpleVarRef, this.env);
            blockStmt.addStatement(variableDef);
            arguments.put(paramName, simpleVarRef);
            if (invocation instanceof BLangInvocation.BLangAttachedFunctionInvocation) {
                invocation.requiredArgs.set(i + 1, simpleVarRef);
                continue;
            }
            invocation.requiredArgs.set(i, simpleVarRef);
        }
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, invocation);
        stmtExpr.setBType(invocation.getBType());
        return stmtExpr;
    }

    private BLangInvocation getFunctionPointerInvocation(BInvokableSymbol symbol) {
        BLangInvocation funcInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        funcInvocation.setBType(symbol.retType);
        funcInvocation.symbol = symbol;
        funcInvocation.name = ASTBuilderUtil.createIdentifier(symbol.pos, symbol.name.value);
        return this.visitFunctionPointerInvocation(funcInvocation);
    }

    @Override
    public void visit(BLangErrorConstructorExpr errorConstructorExpr) {
        BLangExpression errorDetail;
        if (errorConstructorExpr.positionalArgs.size() == 1) {
            errorConstructorExpr.positionalArgs.add(this.createNilLiteral());
        }
        errorConstructorExpr.positionalArgs.set(1, this.types.addConversionExprIfRequired(errorConstructorExpr.positionalArgs.get(1), this.symTable.errorType));
        this.rewriteExprs(errorConstructorExpr.positionalArgs);
        BLangRecordLiteral recordLiteral = ASTBuilderUtil.createEmptyRecordLiteral(errorConstructorExpr.pos, ((BErrorType)Types.getImpliedType((BType)errorConstructorExpr.getBType())).detailType);
        if (errorConstructorExpr.namedArgs.isEmpty()) {
            errorDetail = this.visitCloneReadonly(this.rewriteExpr(recordLiteral), recordLiteral.getBType());
        } else {
            for (BLangNamedArgsExpression namedArg : errorConstructorExpr.namedArgs) {
                BLangRecordLiteral.BLangRecordKeyValueField member = new BLangRecordLiteral.BLangRecordKeyValueField();
                member.key = new BLangRecordLiteral.BLangRecordKey(ASTBuilderUtil.createLiteral(namedArg.name.pos, this.symTable.stringType, Utils.unescapeJava((String)namedArg.name.value)));
                member.valueExpr = Types.getImpliedType((BType)recordLiteral.getBType()).tag == 12 ? this.types.addConversionExprIfRequired(namedArg.expr, this.symTable.anyType) : this.types.addConversionExprIfRequired(namedArg.expr, namedArg.expr.getBType());
                recordLiteral.fields.add(member);
            }
            errorDetail = this.visitCloneReadonly(this.rewriteExpr(recordLiteral), ((BErrorType)Types.getImpliedType((BType)errorConstructorExpr.getBType())).detailType);
        }
        errorConstructorExpr.errorDetail = errorDetail;
        this.result = errorConstructorExpr;
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocation) {
        BLangExpression invocation;
        if (!actionInvocation.async && actionInvocation.invokedInsideTransaction) {
            this.transactionDesugar.startTransactionCoordinatorOnce(this.env, actionInvocation.pos);
        }
        if (actionInvocation.async && Symbols.isFlagOn(actionInvocation.symbol.type.getFlags(), 0x20000000L)) {
            this.addStrandAnnotationWithThreadAny(actionInvocation.pos);
            actionInvocation.addAnnotationAttachment(this.strandAnnotAttachement);
            ((BInvokableSymbol)actionInvocation.symbol).addAnnotation(this.strandAnnotAttachement.annotationAttachmentSymbol);
        }
        if ((invocation = this.rewriteInvocation(actionInvocation, actionInvocation.async)).getKind() == NodeKind.TYPE_CONVERSION_EXPR) {
            ((BLangTypeConversionExpr)invocation).expr = this.createStmtExpr((BLangInvocation)((BLangTypeConversionExpr)invocation).expr);
            this.result = invocation;
        } else {
            this.result = this.createStmtExpr((BLangInvocation)invocation);
        }
    }

    private void addStrandAnnotationWithThreadAny(Location pos) {
        if (this.strandAnnotAttachement == null) {
            this.strandAnnotAttachement = this.annotationDesugar.createStrandAnnotationWithThreadAny(pos, this.env);
        }
    }

    @Override
    public void visit(BLangInvocation.BLangResourceAccessInvocation resourceAccessInvocation) {
        if (resourceAccessInvocation.invokedInsideTransaction) {
            this.transactionDesugar.startTransactionCoordinatorOnce(this.env, resourceAccessInvocation.pos);
        }
        BLangInvocation pathParamInvocation = this.createInvocationForPathParams(resourceAccessInvocation);
        this.reorderArguments(pathParamInvocation);
        BResourceFunction targetResourceFunc = resourceAccessInvocation.targetResourceFunc;
        List<BResourcePathSegmentSymbol> pathSegmentSymbols = targetResourceFunc.pathSegmentSymbols;
        int pathParamInvocationRequiredArgCount = pathParamInvocation.requiredArgs.size();
        BLangInvocation bLangInvocation = new BLangInvocation();
        BLangStatementExpression firstRequiredArgFromRestArg = null;
        boolean isFirstRequiredArgFromRestArgIncluded = false;
        for (int i = 0; i < pathParamInvocationRequiredArgCount; ++i) {
            BLangExpression requiredArg = pathParamInvocation.requiredArgs.get(i);
            Name resourcePathName = pathSegmentSymbols.get((int)i).name;
            if (firstRequiredArgFromRestArg == null && requiredArg.getKind() == NodeKind.STATEMENT_EXPRESSION) {
                firstRequiredArgFromRestArg = (BLangStatementExpression)requiredArg;
                if (resourcePathName.value.equals("^")) {
                    isFirstRequiredArgFromRestArgIncluded = true;
                    bLangInvocation.requiredArgs.add(requiredArg);
                    continue;
                }
            }
            if (!resourcePathName.value.equals("^")) continue;
            if (firstRequiredArgFromRestArg != null && !isFirstRequiredArgFromRestArgIncluded) {
                BLangStatementExpression statementExpression = new BLangStatementExpression();
                statementExpression.expr = requiredArg;
                statementExpression.stmt = firstRequiredArgFromRestArg.stmt;
                statementExpression.setBType(requiredArg.getBType());
                bLangInvocation.requiredArgs.add(statementExpression);
                isFirstRequiredArgFromRestArgIncluded = true;
                continue;
            }
            bLangInvocation.requiredArgs.add(requiredArg);
        }
        Name lastResourcePathName = pathSegmentSymbols.get((int)(pathSegmentSymbols.size() - 1)).name;
        if (lastResourcePathName.value.equals("^^")) {
            for (BLangExpression restArg : pathParamInvocation.restArgs) {
                if (firstRequiredArgFromRestArg != null && !isFirstRequiredArgFromRestArgIncluded && restArg.getKind() == NodeKind.STATEMENT_EXPRESSION) {
                    BLangStatementExpression restArgStmtExpr = (BLangStatementExpression)restArg;
                    ((BLangBlockStmt)restArgStmtExpr.stmt).stmts.add(0, ((BLangBlockStmt)firstRequiredArgFromRestArg.stmt).stmts.get(0));
                }
                bLangInvocation.requiredArgs.add(restArg);
            }
        }
        bLangInvocation.requiredArgs.addAll(resourceAccessInvocation.requiredArgs);
        bLangInvocation.pkgAlias = resourceAccessInvocation.pkgAlias;
        bLangInvocation.name = resourceAccessInvocation.name;
        bLangInvocation.expr = resourceAccessInvocation.expr;
        bLangInvocation.restArgs = resourceAccessInvocation.restArgs;
        bLangInvocation.symbol = resourceAccessInvocation.symbol;
        bLangInvocation.setBType(resourceAccessInvocation.getBType());
        bLangInvocation.parent = resourceAccessInvocation.parent;
        bLangInvocation.pos = resourceAccessInvocation.pos;
        this.result = this.rewriteExpr(bLangInvocation);
    }

    private BLangInvocation createInvocationForPathParams(BLangInvocation.BLangResourceAccessInvocation resourceAccessInvocation) {
        BLangInvocation bLangInvocation = new BLangInvocation();
        BInvokableSymbol invokableSymbol = new BInvokableSymbol(resourceAccessInvocation.symbol.tag, resourceAccessInvocation.symbol.flags, resourceAccessInvocation.symbol.name, resourceAccessInvocation.symbol.pkgID, resourceAccessInvocation.symbol.type, resourceAccessInvocation.symbol, resourceAccessInvocation.symbol.pos, SymbolOrigin.VIRTUAL);
        BResourceFunction targetResourceFunc = resourceAccessInvocation.targetResourceFunc;
        List<BResourcePathSegmentSymbol> pathSegmentSymbols = targetResourceFunc.pathSegmentSymbols;
        List<BLangExpression> resourceAccessPathSegments = resourceAccessInvocation.resourceAccessPathSegments.exprs;
        ArrayList<BVarSymbol> invocationParams = new ArrayList<BVarSymbol>(pathSegmentSymbols.size());
        int pathSegmentCount = pathSegmentSymbols.size();
        BResourcePathSegmentSymbol lastPathSegmentSym = pathSegmentSymbols.get(pathSegmentSymbols.size() - 1);
        if (lastPathSegmentSym.kind == SymbolKind.RESOURCE_PATH_REST_PARAM_SEGMENT) {
            invokableSymbol.restParam = new BVarSymbol(0L, Names.EMPTY, this.env.scope.owner.pkgID, new BArrayType(this.symTable.typeEnv(), lastPathSegmentSym.type), this.env.scope.owner, lastPathSegmentSym.pos, SymbolOrigin.VIRTUAL);
            --pathSegmentCount;
        }
        if (pathSegmentCount > 0 && lastPathSegmentSym.kind != SymbolKind.RESOURCE_ROOT_PATH_SEGMENT) {
            invocationParams.addAll(pathSegmentSymbols.subList(0, pathSegmentCount).stream().map(s -> new BVarSymbol(0L, Names.EMPTY, this.env.scope.owner.pkgID, s.type, this.env.scope.owner, s.pos, SymbolOrigin.VIRTUAL)).toList());
        }
        invokableSymbol.params = invocationParams;
        bLangInvocation.symbol = invokableSymbol;
        for (int i = 0; i < resourceAccessPathSegments.size(); ++i) {
            BLangExpression resourceAccessPathSeg = resourceAccessPathSegments.get(i);
            if (resourceAccessPathSeg.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                bLangInvocation.restArgs.add(this.createRestArgsExpression(((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)resourceAccessPathSeg).expr));
                continue;
            }
            if (i > invocationParams.size() - 1) {
                bLangInvocation.restArgs.add(resourceAccessPathSeg);
                continue;
            }
            bLangInvocation.requiredArgs.add(resourceAccessPathSeg);
        }
        return bLangInvocation;
    }

    private BLangRestArgsExpression createRestArgsExpression(BLangExpression expr) {
        BLangRestArgsExpression bLangRestArgsExpression = new BLangRestArgsExpression();
        bLangRestArgsExpression.expr = expr;
        bLangRestArgsExpression.pos = expr.pos;
        bLangRestArgsExpression.setBType(expr.getBType());
        bLangRestArgsExpression.expectedType = bLangRestArgsExpression.getBType();
        return bLangRestArgsExpression;
    }

    private BLangExpression rewriteInvocation(BLangInvocation invocation, boolean async) {
        BLangInvocation invRef = invocation;
        if (!this.enclLocks.isEmpty()) {
            BLangLock.BLangLockStmt lock = this.enclLocks.peek();
            lock.lockVariables.addAll(((BInvokableSymbol)invocation.symbol).dependentGlobalVars);
        }
        this.visitArgs(invocation);
        this.annotationDesugar.defineStatementAnnotations(invocation.annAttachments, invocation.pos, invocation.symbol.pkgID, invocation.symbol.owner, this.env);
        if (invocation.functionPointerInvocation) {
            return this.visitFunctionPointerInvocation(invocation);
        }
        this.result = invRef;
        BInvokableSymbol invSym = (BInvokableSymbol)invocation.symbol;
        if (Symbols.isFlagOn(invSym.retType.getFlags(), 0x4000000L)) {
            BType retType = this.unifier.build(this.symTable.typeEnv(), invSym.retType);
            invocation.setBType(invocation.async ? new BFutureType(this.symTable.typeEnv(), retType, null) : retType);
        }
        if (invocation.expr == null) {
            BLangExpression expression = this.fixTypeCastInTypeParamInvocation(invocation, invRef);
            if (invocation.exprSymbol == null) {
                return expression;
            }
            invocation.expr = ASTBuilderUtil.createVariableRef(invocation.pos, invocation.exprSymbol);
            invocation.expr = this.rewriteExpr(invocation.expr);
        }
        switch (Types.getImpliedType((BType)invocation.expr.getBType()).tag) {
            case 12: 
            case 21: 
            case 34: {
                if (invocation.langLibInvocation) break;
                invocation.expr = this.rewriteExpr(invocation.expr);
                ArrayList<BLangExpression> argExprs = new ArrayList<BLangExpression>(invocation.requiredArgs);
                argExprs.add(0, invocation.expr);
                BLangInvocation.BLangAttachedFunctionInvocation attachedFunctionInvocation = new BLangInvocation.BLangAttachedFunctionInvocation(invocation.pos, argExprs, invocation.restArgs, invocation.symbol, invocation.getBType(), invocation.expr, async);
                attachedFunctionInvocation.name = invocation.name;
                attachedFunctionInvocation.annAttachments = invocation.annAttachments;
                invRef = attachedFunctionInvocation;
            }
        }
        this.populateOCEInvocation(invocation, invRef);
        return this.fixTypeCastInTypeParamInvocation(invocation, invRef);
    }

    private void populateOCEInvocation(BLangInvocation invocation, BLangInvocation invRef) {
        if (invocation.objectInitMethod && Symbols.isFlagOn(invocation.expr.getBType().getFlags(), 0x100000000L)) {
            BObjectType initializingObject = (BObjectType)invocation.expr.getBType();
            BLangClassDefinition classDef = initializingObject.classDef;
            if (classDef.hasClosureVars) {
                OCEDynamicEnvironmentData oceEnvData = initializingObject.classDef.oceEnvData;
                if (oceEnvData.attachedFunctionInvocation == null) {
                    oceEnvData.attachedFunctionInvocation = (BLangInvocation.BLangAttachedFunctionInvocation)invRef;
                }
            }
        }
    }

    private void fixNonRestArgTypeCastInTypeParamInvocation(BLangInvocation iExpr) {
        if (!iExpr.langLibInvocation) {
            return;
        }
        List<BLangExpression> requiredArgs = iExpr.requiredArgs;
        List<BVarSymbol> params = ((BInvokableSymbol)iExpr.symbol).params;
        for (int i = 0; i < requiredArgs.size(); ++i) {
            requiredArgs.set(i, this.types.addConversionExprIfRequired(requiredArgs.get(i), params.get((int)i).type));
        }
    }

    private BLangExpression fixTypeCastInTypeParamInvocation(BLangInvocation iExpr, BLangInvocation genIExpr) {
        BType returnTypeOfInvokable = ((BInvokableSymbol)iExpr.symbol).retType;
        if (!iExpr.langLibInvocation && !TypeParamAnalyzer.containsTypeParam(returnTypeOfInvokable)) {
            return genIExpr;
        }
        BType originalInvType = genIExpr.getBType();
        if (!genIExpr.async) {
            genIExpr.setBType(returnTypeOfInvokable);
        }
        return this.types.addConversionExprIfRequired(genIExpr, originalInvType);
    }

    private void fixStreamAndXmlTypeCastsInInvocationParams(BLangInvocation iExpr) {
        List<BLangExpression> requiredArgs = iExpr.requiredArgs;
        List<BVarSymbol> params = ((BInvokableSymbol)iExpr.symbol).params;
        if (!params.isEmpty()) {
            for (int i = 0; i < requiredArgs.size(); ++i) {
                BVarSymbol param = params.get(i);
                int tag = Types.getImpliedType((BType)param.type).tag;
                if (tag != 15 && tag != 8) continue;
                requiredArgs.set(i, this.types.addConversionExprIfRequired(requiredArgs.get(i), param.type));
            }
        }
    }

    private BLangLiteral createNilLiteral() {
        BLangLiteral literal = (BLangLiteral)TreeBuilder.createLiteralExpression();
        literal.value = null;
        literal.setBType(this.symTable.nilType);
        return literal;
    }

    @Override
    public void visit(BLangTypeInit typeInitExpr) {
        this.result = Types.getImpliedType((BType)typeInitExpr.getBType()).tag == 15 ? this.rewriteExpr(this.desugarStreamTypeInit(typeInitExpr)) : this.rewrite(this.desugarObjectTypeInit(typeInitExpr), this.env);
    }

    private BLangStatementExpression desugarObjectTypeInit(BLangTypeInit typeInitExpr) {
        typeInitExpr.desugared = true;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(typeInitExpr.pos);
        BLangInvocation initInvocation = (BLangInvocation)typeInitExpr.initInvocation;
        initInvocation.objectInitMethod = true;
        BType objType = this.getObjectType(typeInitExpr.getBType());
        BLangSimpleVariableDef objVarDef = this.createVarDef("$obj$", objType, typeInitExpr, typeInitExpr.pos);
        BLangSimpleVariableDef initInvRetValVarDef = this.createVarDef("$temp$", initInvocation.getBType(), initInvocation, initInvocation.pos);
        objVarDef.var.name.pos = this.symTable.builtinPos;
        BLangSimpleVarRef objVarRef = ASTBuilderUtil.createVariableRef(typeInitExpr.pos, objVarDef.var.symbol);
        BLangSimpleVarRef objInitVarRef = ASTBuilderUtil.createVariableRef(initInvocation.pos, initInvRetValVarDef.var.symbol);
        blockStmt.addStatement(objVarDef);
        blockStmt.addStatement(initInvRetValVarDef);
        initInvocation.exprSymbol = objVarDef.var.symbol;
        initInvocation.symbol = ((BObjectTypeSymbol)Types.getImpliedType((BType)objType).tsymbol).generatedInitializerFunc.symbol;
        if (initInvocation.getBType().tag == 10) {
            initInvocation.name.value = Names.GENERATED_INIT_SUFFIX.value;
            BLangNode parent = initInvocation.parent;
            if (parent != null && parent.getKind() == NodeKind.OBJECT_CTOR_EXPRESSION) {
                BLangObjectConstructorExpression oceExpression = (BLangObjectConstructorExpression)parent;
                OCEDynamicEnvironmentData oceData = oceExpression.classNode.oceEnvData;
                oceData.initInvocation = typeInitExpr.initInvocation;
            }
            typeInitExpr.initInvocation = objInitVarRef;
            BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, objVarRef);
            stmtExpr.setBType(objVarRef.symbol.type);
            return stmtExpr;
        }
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$result$", typeInitExpr.getBType(), null, typeInitExpr.pos);
        blockStmt.addStatement(resultVarDef);
        BLangSimpleVarRef initRetValVarRefInCondition = ASTBuilderUtil.createVariableRef(this.symTable.builtinPos, initInvRetValVarDef.var.symbol);
        BLangBlockStmt thenStmt = ASTBuilderUtil.createBlockStmt(this.symTable.builtinPos);
        BLangTypeTestExpr isErrorTest = ASTBuilderUtil.createTypeTestExpr(this.symTable.builtinPos, initRetValVarRefInCondition, this.getErrorTypeNode());
        isErrorTest.setBType(this.symTable.booleanType);
        BLangSimpleVarRef thenInitRetValVarRef = ASTBuilderUtil.createVariableRef(this.symTable.builtinPos, initInvRetValVarDef.var.symbol);
        BLangSimpleVarRef thenResultVarRef = ASTBuilderUtil.createVariableRef(this.symTable.builtinPos, resultVarDef.var.symbol);
        BLangAssignment errAssignment = ASTBuilderUtil.createAssignmentStmt(this.symTable.builtinPos, thenResultVarRef, thenInitRetValVarRef);
        thenStmt.addStatement(errAssignment);
        BLangSimpleVarRef elseResultVarRef = ASTBuilderUtil.createVariableRef(this.symTable.builtinPos, resultVarDef.var.symbol);
        BLangAssignment objAssignment = ASTBuilderUtil.createAssignmentStmt(this.symTable.builtinPos, elseResultVarRef, objVarRef);
        BLangBlockStmt elseStmt = ASTBuilderUtil.createBlockStmt(this.symTable.builtinPos);
        elseStmt.addStatement(objAssignment);
        BLangIf ifelse = ASTBuilderUtil.createIfElseStmt(this.symTable.builtinPos, isErrorTest, thenStmt, elseStmt);
        blockStmt.addStatement(ifelse);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(this.symTable.builtinPos, resultVarDef.var.symbol);
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        stmtExpr.setBType(resultVarRef.symbol.type);
        return stmtExpr;
    }

    private BLangInvocation desugarStreamTypeInit(BLangTypeInit typeInitExpr) {
        BInvokableSymbol symbol = (BInvokableSymbol)this.symTable.langInternalModuleSymbol.scope.lookup((Name)Names.CONSTRUCT_STREAM).symbol;
        BStreamType referredStreamType = (BStreamType)Types.getImpliedType(typeInitExpr.getBType());
        BType constraintType = referredStreamType.constraint;
        BTypedescType constraintTdType = new BTypedescType(this.symTable.typeEnv(), constraintType, this.symTable.typeDesc.tsymbol);
        BLangTypedescExpr constraintTdExpr = new BLangTypedescExpr();
        constraintTdExpr.resolvedType = constraintType;
        constraintTdExpr.setBType(constraintTdType);
        BType completionType = referredStreamType.completionType;
        BTypedescType completionTdType = new BTypedescType(this.symTable.typeEnv(), completionType, this.symTable.typeDesc.tsymbol);
        BLangTypedescExpr completionTdExpr = new BLangTypedescExpr();
        completionTdExpr.resolvedType = completionType;
        completionTdExpr.setBType(completionTdType);
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>(Lists.of(constraintTdExpr, completionTdExpr));
        if (!typeInitExpr.argsExpr.isEmpty()) {
            args.add((BLangTypedescExpr)typeInitExpr.argsExpr.get(0));
        }
        BLangInvocation streamConstructInvocation = ASTBuilderUtil.createInvocationExprForMethod(typeInitExpr.pos, symbol, args, this.symResolver);
        streamConstructInvocation.setBType(new BStreamType(this.symTable.typeEnv(), 15, constraintType, completionType, null));
        return streamConstructInvocation;
    }

    private BLangSimpleVariableDef createSimpleVarDef(String name, BType type, BLangExpression expr) {
        BVarSymbol varSymbol = new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, type, this.env.scope.owner, expr.pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable simpleVariable = ASTBuilderUtil.createVariable(expr.pos, name, type, expr, varSymbol);
        BLangSimpleVariableDef simpleVariableDef = ASTBuilderUtil.createVariableDef(expr.pos);
        simpleVariableDef.var = simpleVariable;
        simpleVariableDef.setBType(simpleVariable.getBType());
        return simpleVariableDef;
    }

    private BLangSimpleVariableDef createVarDef(String name, BType type, BLangExpression expr, Location location) {
        BSymbol objSym = this.symResolver.lookupSymbolInMainSpace(this.env, Names.fromString(name));
        if (objSym == null || objSym == this.symTable.notFoundSymbol) {
            objSym = new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, type, this.env.scope.owner, location, SymbolOrigin.VIRTUAL);
        }
        BLangSimpleVariable objVar = ASTBuilderUtil.createVariable(location, name, type, expr, (BVarSymbol)objSym);
        BLangSimpleVariableDef objVarDef = ASTBuilderUtil.createVariableDef(location);
        objVarDef.var = objVar;
        objVarDef.setBType(objVar.getBType());
        return objVarDef;
    }

    private BType getObjectType(BType bType) {
        BType type = Types.getImpliedType(bType);
        if (type.tag == 34) {
            return bType;
        }
        if (type.tag == 21) {
            return ((BUnionType)type).getMemberTypes().stream().filter(t -> Types.getImpliedType((BType)t).tag == 34).findFirst().orElse(this.symTable.noType);
        }
        throw new IllegalStateException("None object type '" + type.toString() + "' found in object init context");
    }

    BLangErrorType getErrorTypeNode() {
        BLangErrorType errorTypeNode = (BLangErrorType)TreeBuilder.createErrorTypeNode();
        errorTypeNode.setBType(this.symTable.errorType);
        errorTypeNode.pos = this.symTable.builtinPos;
        return errorTypeNode;
    }

    BLangErrorType getErrorOrNillTypeNode() {
        BLangErrorType errorTypeNode = (BLangErrorType)TreeBuilder.createErrorTypeNode();
        errorTypeNode.setBType(this.symTable.errorOrNilType);
        return errorTypeNode;
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$ternary_result$", ternaryExpr.getBType(), null, ternaryExpr.pos);
        BLangBlockStmt thenBody = ASTBuilderUtil.createBlockStmt(ternaryExpr.pos);
        BLangBlockStmt elseBody = ASTBuilderUtil.createBlockStmt(ternaryExpr.pos);
        BLangSimpleVarRef thenResultVarRef = ASTBuilderUtil.createVariableRef(ternaryExpr.pos, resultVarDef.var.symbol);
        BLangAssignment thenAssignment = ASTBuilderUtil.createAssignmentStmt(ternaryExpr.pos, thenResultVarRef, ternaryExpr.thenExpr);
        thenBody.addStatement(thenAssignment);
        BLangSimpleVarRef elseResultVarRef = ASTBuilderUtil.createVariableRef(ternaryExpr.pos, resultVarDef.var.symbol);
        BLangAssignment elseAssignment = ASTBuilderUtil.createAssignmentStmt(ternaryExpr.pos, elseResultVarRef, ternaryExpr.elseExpr);
        elseBody.addStatement(elseAssignment);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(ternaryExpr.pos, resultVarDef.var.symbol);
        BLangIf ifElse = ASTBuilderUtil.createIfElseStmt(ternaryExpr.pos, ternaryExpr.expr, thenBody, elseBody);
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(ternaryExpr.pos, Lists.of(resultVarDef, ifElse));
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        stmtExpr.setBType(ternaryExpr.getBType());
        this.result = this.rewriteExpr(stmtExpr);
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        waitExpr.exprList = waitExpr.getExpression().getKind() == NodeKind.BINARY_EXPR ? this.collectAllBinaryExprs((BLangBinaryExpr)waitExpr.getExpression(), new ArrayList<BLangExpression>()) : Collections.singletonList(this.rewriteExpr(waitExpr.getExpression()));
        this.result = waitExpr;
    }

    private List<BLangExpression> collectAllBinaryExprs(BLangBinaryExpr binaryExpr, List<BLangExpression> exprs) {
        this.visitBinaryExprOfWait(binaryExpr.lhsExpr, exprs);
        this.visitBinaryExprOfWait(binaryExpr.rhsExpr, exprs);
        return exprs;
    }

    private void visitBinaryExprOfWait(BLangExpression expr, List<BLangExpression> exprs) {
        if (expr.getKind() == NodeKind.BINARY_EXPR) {
            this.collectAllBinaryExprs((BLangBinaryExpr)expr, exprs);
        } else {
            expr = this.rewriteExpr(expr);
            exprs.add(expr);
        }
    }

    @Override
    public void visit(BLangWaitForAllExpr waitExpr) {
        waitExpr.keyValuePairs.forEach(keyValue -> {
            if (keyValue.valueExpr != null) {
                keyValue.valueExpr = this.rewriteExpr(keyValue.valueExpr);
            } else {
                keyValue.keyExpr = this.rewriteExpr(keyValue.keyExpr);
            }
        });
        BLangWaitForAllExpr.BLangWaitLiteral expr = new BLangWaitForAllExpr.BLangWaitLiteral(waitExpr.keyValuePairs, waitExpr.getBType());
        expr.pos = waitExpr.pos;
        this.result = this.rewriteExpr(expr);
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        trapExpr.expr = this.rewriteExpr(trapExpr.expr);
        if (Types.getImpliedType((BType)trapExpr.expr.getBType()).tag != 10) {
            trapExpr.expr = this.types.addConversionExprIfRequired(trapExpr.expr, trapExpr.getBType());
        }
        this.result = trapExpr;
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        if (this.isNullableBinaryExpr(binaryExpr)) {
            BLangStatementExpression stmtExpr = this.createStmtExprForNullableBinaryExpr(binaryExpr);
            this.result = this.rewrite(stmtExpr, this.env);
            return;
        }
        if (binaryExpr.opKind == OperatorKind.HALF_OPEN_RANGE || binaryExpr.opKind == OperatorKind.CLOSED_RANGE) {
            BLangExpression lhsExpr = binaryExpr.lhsExpr;
            BLangExpression rhsExpr = binaryExpr.rhsExpr;
            lhsExpr = this.createTypeCastExpr(lhsExpr, this.symTable.intType);
            rhsExpr = this.createTypeCastExpr(rhsExpr, this.symTable.intType);
            if (binaryExpr.opKind == OperatorKind.HALF_OPEN_RANGE) {
                rhsExpr = this.getModifiedIntRangeEndExpr(rhsExpr);
            }
            this.result = this.rewriteExpr(this.replaceWithIntRange(binaryExpr.pos, lhsExpr, rhsExpr));
            return;
        }
        if (binaryExpr.opKind == OperatorKind.AND || binaryExpr.opKind == OperatorKind.OR) {
            this.visitBinaryLogicalExpr(binaryExpr);
            return;
        }
        OperatorKind binaryOpKind = binaryExpr.opKind;
        if (binaryOpKind == OperatorKind.ADD || binaryOpKind == OperatorKind.SUB || binaryOpKind == OperatorKind.MUL || binaryOpKind == OperatorKind.DIV || binaryOpKind == OperatorKind.MOD || binaryOpKind == OperatorKind.BITWISE_AND || binaryOpKind == OperatorKind.BITWISE_OR || binaryOpKind == OperatorKind.BITWISE_XOR) {
            this.checkByteTypeIncompatibleOperations(binaryExpr);
        }
        binaryExpr.lhsExpr = this.rewriteExpr(binaryExpr.lhsExpr);
        binaryExpr.rhsExpr = this.rewriteExpr(binaryExpr.rhsExpr);
        this.result = binaryExpr;
        int rhsExprTypeTag = Types.getImpliedType((BType)binaryExpr.rhsExpr.getBType()).tag;
        int lhsExprTypeTag = Types.getImpliedType((BType)binaryExpr.lhsExpr.getBType()).tag;
        if (rhsExprTypeTag != lhsExprTypeTag && (binaryExpr.opKind == OperatorKind.EQUAL || binaryExpr.opKind == OperatorKind.NOT_EQUAL || binaryExpr.opKind == OperatorKind.REF_EQUAL || binaryExpr.opKind == OperatorKind.REF_NOT_EQUAL)) {
            if (TypeTags.isIntegerTypeTag(lhsExprTypeTag) && rhsExprTypeTag == 2) {
                binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, this.symTable.intType);
                return;
            }
            if (lhsExprTypeTag == 2 && TypeTags.isIntegerTypeTag(rhsExprTypeTag)) {
                binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, this.symTable.intType);
                return;
            }
        }
        boolean isBinaryShiftOperator = this.symResolver.isBinaryShiftOperator(binaryOpKind);
        boolean isArithmeticOperator = this.symResolver.isArithmeticOperator(binaryOpKind);
        if (lhsExprTypeTag == rhsExprTypeTag) {
            if (!isBinaryShiftOperator && !isArithmeticOperator) {
                return;
            }
            if (this.types.isValueType(binaryExpr.lhsExpr.getBType())) {
                return;
            }
        }
        if (binaryExpr.opKind == OperatorKind.ADD && TypeTags.isStringTypeTag(lhsExprTypeTag) && (rhsExprTypeTag == 8 || rhsExprTypeTag == 49)) {
            binaryExpr.lhsExpr = ASTBuilderUtil.createXMLTextLiteralNode(binaryExpr, binaryExpr.lhsExpr, binaryExpr.lhsExpr.pos, this.symTable.xmlType);
            return;
        }
        if (binaryExpr.opKind == OperatorKind.ADD && TypeTags.isStringTypeTag(rhsExprTypeTag) && (lhsExprTypeTag == 8 || lhsExprTypeTag == 49)) {
            binaryExpr.rhsExpr = ASTBuilderUtil.createXMLTextLiteralNode(binaryExpr, binaryExpr.rhsExpr, binaryExpr.rhsExpr.pos, this.symTable.xmlType);
            return;
        }
        if (this.symResolver.isBinaryComparisonOperator(binaryOpKind)) {
            this.createTypeCastExprForRelationalExpr(binaryExpr, lhsExprTypeTag, rhsExprTypeTag);
            return;
        }
        if (lhsExprTypeTag == 4) {
            binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, binaryExpr.lhsExpr.getBType());
            return;
        }
        if (rhsExprTypeTag == 4) {
            binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, binaryExpr.rhsExpr.getBType());
            return;
        }
        if (lhsExprTypeTag == 3) {
            binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, binaryExpr.lhsExpr.getBType());
            return;
        }
        if (rhsExprTypeTag == 3) {
            binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, binaryExpr.rhsExpr.getBType());
            return;
        }
        if (isArithmeticOperator) {
            this.createTypeCastExprForArithmeticExpr(binaryExpr, lhsExprTypeTag, rhsExprTypeTag);
            return;
        }
        if (isBinaryShiftOperator) {
            this.createTypeCastExprForBinaryShiftExpr(binaryExpr, lhsExprTypeTag, rhsExprTypeTag);
            return;
        }
    }

    private BLangStatementExpression createStmtExprForNullableBinaryExpr(BLangBinaryExpr binaryExpr) {
        BType lhsType;
        BType rhsType;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(binaryExpr.pos);
        BUnionType exprBType = (BUnionType)binaryExpr.getBType();
        BType nonNilType = (BType)((HashSet)exprBType.getMemberTypes()).iterator().next();
        if (this.symResolver.isArithmeticOperator(binaryExpr.opKind)) {
            rhsType = nonNilType;
            lhsType = nonNilType;
        } else {
            rhsType = this.getBinaryExprOperandNonNilType(binaryExpr.rhsExpr.getBType());
            lhsType = this.getBinaryExprOperandNonNilType(binaryExpr.lhsExpr.getBType());
        }
        if (binaryExpr.lhsExpr.getBType().isNullable()) {
            binaryExpr.lhsExpr = this.rewriteExpr(binaryExpr.lhsExpr);
        }
        BLangSimpleVariableDef tempVarDef = this.createVarDef("$result$", binaryExpr.getBType(), null, binaryExpr.pos);
        BLangSimpleVarRef tempVarRef = ASTBuilderUtil.createVariableRef(binaryExpr.pos, tempVarDef.var.symbol);
        blockStmt.addStatement(tempVarDef);
        BLangSimpleVariableDef lhsVarDef = this.createVarDef("$lhsExprVar$", binaryExpr.lhsExpr.getBType(), binaryExpr.lhsExpr, binaryExpr.pos);
        BLangSimpleVarRef lhsVarRef = ASTBuilderUtil.createVariableRef(binaryExpr.pos, lhsVarDef.var.symbol);
        blockStmt.addStatement(lhsVarDef);
        BLangSimpleVariableDef rhsVarDef = this.createVarDef("$rhsExprVar$", binaryExpr.rhsExpr.getBType(), binaryExpr.rhsExpr, binaryExpr.pos);
        BLangSimpleVarRef rhsVarRef = ASTBuilderUtil.createVariableRef(binaryExpr.pos, rhsVarDef.var.symbol);
        blockStmt.addStatement(rhsVarDef);
        BLangTypeTestExpr typeTestExprOne = this.getNilTypeTestExpr(binaryExpr.pos, lhsVarRef);
        BLangTypeTestExpr typeTestExprTwo = this.getNilTypeTestExpr(binaryExpr.pos, rhsVarRef);
        BLangBinaryExpr ifBlockCondition = ASTBuilderUtil.createBinaryExpr(binaryExpr.pos, typeTestExprOne, typeTestExprTwo, this.symTable.booleanType, OperatorKind.OR, binaryExpr.opSymbol);
        BLangBlockStmt ifBody = ASTBuilderUtil.createBlockStmt(binaryExpr.pos);
        BLangAssignment bLangAssignmentIf = ASTBuilderUtil.createAssignmentStmt(binaryExpr.pos, ifBody);
        bLangAssignmentIf.varRef = tempVarRef;
        bLangAssignmentIf.expr = this.createNilLiteral();
        BLangBlockStmt elseBody = ASTBuilderUtil.createBlockStmt(binaryExpr.pos);
        BLangAssignment bLangAssignmentElse = ASTBuilderUtil.createAssignmentStmt(binaryExpr.pos, elseBody);
        bLangAssignmentElse.varRef = tempVarRef;
        BLangBinaryExpr newBinaryExpr = ASTBuilderUtil.createBinaryExpr(binaryExpr.pos, lhsVarRef, rhsVarRef, nonNilType, binaryExpr.opKind, binaryExpr.opSymbol);
        newBinaryExpr.lhsExpr = this.createTypeCastExpr(lhsVarRef, lhsType);
        newBinaryExpr.rhsExpr = this.createTypeCastExpr(rhsVarRef, rhsType);
        bLangAssignmentElse.expr = newBinaryExpr;
        BLangIf ifStatement = ASTBuilderUtil.createIfStmt(binaryExpr.pos, blockStmt);
        ifStatement.expr = ifBlockCondition;
        ifStatement.body = ifBody;
        ifStatement.elseStmt = elseBody;
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, tempVarRef);
        stmtExpr.setBType(binaryExpr.getBType());
        return stmtExpr;
    }

    BLangTypeTestExpr getNilTypeTestExpr(Location pos, BLangExpression expr) {
        return this.createTypeCheckExpr(pos, expr, this.getNillTypeNode());
    }

    private BType getBinaryExprOperandNonNilType(BType operandType) {
        return operandType.isNullable() ? this.types.getSafeType(operandType, true, false) : operandType;
    }

    private boolean isNullableBinaryExpr(BLangBinaryExpr binaryExpr) {
        if (binaryExpr.lhsExpr.getBType() != null && binaryExpr.rhsExpr.getBType() != null && (binaryExpr.rhsExpr.getBType().isNullable() || binaryExpr.lhsExpr.getBType().isNullable())) {
            switch (binaryExpr.getOperatorKind()) {
                case ADD: 
                case SUB: 
                case MUL: 
                case DIV: 
                case MOD: 
                case BITWISE_LEFT_SHIFT: 
                case BITWISE_RIGHT_SHIFT: 
                case BITWISE_UNSIGNED_RIGHT_SHIFT: 
                case BITWISE_AND: 
                case BITWISE_OR: 
                case BITWISE_XOR: {
                    return true;
                }
            }
        }
        return false;
    }

    private void createTypeCastExprForArithmeticExpr(BLangBinaryExpr binaryExpr, int lhsExprTypeTag, int rhsExprTypeTag) {
        if (TypeTags.isIntegerTypeTag(lhsExprTypeTag) && TypeTags.isIntegerTypeTag(rhsExprTypeTag) || TypeTags.isStringTypeTag(lhsExprTypeTag) && TypeTags.isStringTypeTag(rhsExprTypeTag) || TypeTags.isXMLTypeTag(lhsExprTypeTag) && TypeTags.isXMLTypeTag(rhsExprTypeTag)) {
            return;
        }
        if (TypeTags.isXMLTypeTag(lhsExprTypeTag) && !TypeTags.isXMLTypeTag(rhsExprTypeTag)) {
            if (this.types.isStringSubType(binaryExpr.rhsExpr.getBType())) {
                binaryExpr.rhsExpr = ASTBuilderUtil.createXMLTextLiteralNode(binaryExpr, binaryExpr.rhsExpr, binaryExpr.rhsExpr.pos, this.symTable.xmlType);
                return;
            }
            binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, this.symTable.xmlType);
            return;
        }
        if (TypeTags.isXMLTypeTag(rhsExprTypeTag) && !TypeTags.isXMLTypeTag(lhsExprTypeTag)) {
            if (this.types.isStringSubType(binaryExpr.lhsExpr.getBType())) {
                binaryExpr.lhsExpr = ASTBuilderUtil.createXMLTextLiteralNode(binaryExpr, binaryExpr.lhsExpr, binaryExpr.rhsExpr.pos, this.symTable.xmlType);
                return;
            }
            binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, this.symTable.xmlType);
            return;
        }
        binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, binaryExpr.getBType());
        binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, binaryExpr.getBType());
    }

    private void createTypeCastExprForBinaryShiftExpr(BLangBinaryExpr binaryExpr, int lhsExprTypeTag, int rhsExprTypeTag) {
        boolean isLhsIntegerType = TypeTags.isIntegerTypeTag(lhsExprTypeTag);
        boolean isRhsIntegerType = TypeTags.isIntegerTypeTag(rhsExprTypeTag);
        if (isLhsIntegerType || lhsExprTypeTag == 2) {
            if (isRhsIntegerType || rhsExprTypeTag == 2) {
                return;
            }
            binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, this.symTable.intType);
            return;
        }
        if (isRhsIntegerType || rhsExprTypeTag == 2) {
            binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, this.symTable.intType);
            return;
        }
        binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, this.symTable.intType);
        binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, this.symTable.intType);
    }

    private void createTypeCastExprForRelationalExpr(BLangBinaryExpr binaryExpr, int lhsExprTypeTag, int rhsExprTypeTag) {
        boolean isLhsIntegerType = TypeTags.isIntegerTypeTag(lhsExprTypeTag);
        boolean isRhsIntegerType = TypeTags.isIntegerTypeTag(rhsExprTypeTag);
        BType lhsExprType = binaryExpr.lhsExpr.getBType();
        BType rhsExprType = binaryExpr.rhsExpr.getBType();
        if (isLhsIntegerType && isRhsIntegerType || lhsExprTypeTag == 2 && rhsExprTypeTag == 2) {
            return;
        }
        if (lhsExprTypeTag == 4) {
            this.addTypeCastForBinaryExprB(binaryExpr, lhsExprType, rhsExprType);
            return;
        }
        if (rhsExprTypeTag == 4) {
            this.addTypeCastForBinaryExprA(binaryExpr, rhsExprType, lhsExprType);
            return;
        }
        if (lhsExprTypeTag == 3) {
            this.addTypeCastForBinaryExprB(binaryExpr, lhsExprType, rhsExprType);
            return;
        }
        if (rhsExprTypeTag == 3) {
            this.addTypeCastForBinaryExprA(binaryExpr, rhsExprType, lhsExprType);
            return;
        }
        if (isLhsIntegerType) {
            this.addTypeCastForBinaryExprB(binaryExpr, this.symTable.intType, rhsExprType);
            return;
        }
        if (isRhsIntegerType) {
            this.addTypeCastForBinaryExprA(binaryExpr, this.symTable.intType, lhsExprType);
            return;
        }
        if (lhsExprTypeTag == 2 || rhsExprTypeTag == 2) {
            if (lhsExprTypeTag == 21 && lhsExprType.isNullable() || rhsExprTypeTag == 21 && rhsExprType.isNullable()) {
                binaryExpr.lhsExpr = this.addNilType(this.symTable.intType, binaryExpr.lhsExpr);
                binaryExpr.rhsExpr = this.addNilType(this.symTable.intType, binaryExpr.rhsExpr);
                return;
            }
            binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, this.symTable.intType);
            binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, this.symTable.intType);
            return;
        }
        boolean isLhsStringType = TypeTags.isStringTypeTag(lhsExprTypeTag);
        boolean isRhsStringType = TypeTags.isStringTypeTag(rhsExprTypeTag);
        if (isLhsStringType && isRhsStringType) {
            return;
        }
        if (isLhsStringType) {
            this.addTypeCastForBinaryExprB(binaryExpr, this.symTable.stringType, rhsExprType);
            return;
        }
        if (isRhsStringType) {
            this.addTypeCastForBinaryExprA(binaryExpr, this.symTable.stringType, lhsExprType);
        }
    }

    private void addTypeCastForBinaryExprA(BLangBinaryExpr binaryExpr, BType rhsExprType, BType lhsExprType) {
        if (Types.getImpliedType((BType)lhsExprType).tag == 21 && lhsExprType.isNullable()) {
            binaryExpr.rhsExpr = this.addNilType(rhsExprType, binaryExpr.rhsExpr);
        } else {
            binaryExpr.lhsExpr = this.createTypeCastExpr(binaryExpr.lhsExpr, rhsExprType);
        }
    }

    private void addTypeCastForBinaryExprB(BLangBinaryExpr binaryExpr, BType lhsExprType, BType rhsExprType) {
        if (Types.getImpliedType((BType)rhsExprType).tag == 21 && rhsExprType.isNullable()) {
            binaryExpr.lhsExpr = this.addNilType(lhsExprType, binaryExpr.lhsExpr);
        } else {
            binaryExpr.rhsExpr = this.createTypeCastExpr(binaryExpr.rhsExpr, lhsExprType);
        }
    }

    private BLangExpression addNilType(BType exprType, BLangExpression expr) {
        LinkedHashSet<BType> members = new LinkedHashSet<BType>(2);
        members.add(exprType);
        members.add(this.symTable.nilType);
        BUnionType unionType = new BUnionType(this.types.typeEnv(), null, members, false);
        return this.createTypeCastExpr(expr, unionType);
    }

    private BLangInvocation replaceWithIntRange(Location location, BLangExpression lhsExpr, BLangExpression rhsExpr) {
        BInvokableSymbol symbol = (BInvokableSymbol)this.symTable.langInternalModuleSymbol.scope.lookup((Name)Names.CREATE_INT_RANGE).symbol;
        BLangInvocation createIntRangeInvocation = ASTBuilderUtil.createInvocationExprForMethod(location, symbol, new ArrayList<BLangExpression>(Lists.of(lhsExpr, rhsExpr)), this.symResolver);
        createIntRangeInvocation.setBType(this.symTable.intRangeType);
        return createIntRangeInvocation;
    }

    private void checkByteTypeIncompatibleOperations(BLangBinaryExpr binaryExpr) {
        if (binaryExpr.expectedType == null) {
            return;
        }
        int rhsExprTypeTag = Types.getImpliedType((BType)binaryExpr.rhsExpr.getBType()).tag;
        int lhsExprTypeTag = Types.getImpliedType((BType)binaryExpr.lhsExpr.getBType()).tag;
        if (rhsExprTypeTag != 2 && lhsExprTypeTag != 2) {
            return;
        }
        int resultTypeTag = Types.getImpliedType((BType)binaryExpr.expectedType).tag;
        if (resultTypeTag == 1) {
            if (rhsExprTypeTag == 2) {
                binaryExpr.rhsExpr = this.types.addConversionExprIfRequired(binaryExpr.rhsExpr, this.symTable.intType);
            }
            if (lhsExprTypeTag == 2) {
                binaryExpr.lhsExpr = this.types.addConversionExprIfRequired(binaryExpr.lhsExpr, this.symTable.intType);
            }
        }
    }

    private boolean isBitwiseShiftOperation(BLangBinaryExpr binaryExpr) {
        return binaryExpr.opKind == OperatorKind.BITWISE_LEFT_SHIFT || binaryExpr.opKind == OperatorKind.BITWISE_RIGHT_SHIFT || binaryExpr.opKind == OperatorKind.BITWISE_UNSIGNED_RIGHT_SHIFT;
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        Location pos = elvisExpr.pos;
        String resultVarName = "_$result$_";
        BType resultType = elvisExpr.getBType();
        BLangSimpleVariable resultVar = ASTBuilderUtil.createVariable(pos, resultVarName, resultType, null, new BVarSymbol(0L, Names.fromString(resultVarName), this.env.scope.owner.pkgID, resultType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL));
        final BLangSimpleVariableDef resultVarDef = ASTBuilderUtil.createVariableDef(pos, resultVar);
        resultVarDef.desugared = true;
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVar.symbol);
        String lhsResultVarName = Names.GEN_VAR_PREFIX.value;
        BLangSimpleVariable lhsResultVar = ASTBuilderUtil.createVariable(pos, lhsResultVarName, elvisExpr.lhsExpr.getBType(), elvisExpr.lhsExpr, new BVarSymbol(0L, Names.fromString(lhsResultVarName), this.env.scope.owner.pkgID, elvisExpr.lhsExpr.getBType(), this.env.scope.owner, elvisExpr.pos, SymbolOrigin.VIRTUAL));
        final BLangSimpleVariableDef lhsResultVarDef = ASTBuilderUtil.createVariableDef(pos, lhsResultVar);
        BLangSimpleVarRef lhsResultVarRef = ASTBuilderUtil.createVariableRef(pos, lhsResultVar.symbol);
        BLangAssignment nilAssignment = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, elvisExpr.rhsExpr);
        BLangBlockStmt ifBody = ASTBuilderUtil.createBlockStmt(pos);
        ifBody.addStatement(nilAssignment);
        BLangAssignment notNilAssignment = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.createTypeCastExpr(lhsResultVarRef, resultType));
        BLangBlockStmt elseBody = ASTBuilderUtil.createBlockStmt(pos);
        elseBody.addStatement(notNilAssignment);
        final BLangIf ifStmt = ASTBuilderUtil.createIfElseStmt(pos, this.getNilTypeTestExpr(pos, lhsResultVarRef), ifBody, elseBody);
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(pos, (List<BLangStatement>)new ArrayList<BLangStatement>(){
            {
                this.add(resultVarDef);
                this.add(lhsResultVarDef);
                this.add(ifStmt);
            }
        });
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        stmtExpr.setBType(resultType);
        this.result = this.rewriteExpr(stmtExpr);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        if (this.isNullableUnaryExpr(unaryExpr)) {
            BLangStatementExpression statementExpression = this.createStmtExprForNilableUnaryExpr(unaryExpr);
            this.result = this.rewrite(statementExpression, this.env);
            return;
        }
        if (OperatorKind.BITWISE_COMPLEMENT == unaryExpr.operator) {
            this.rewriteBitwiseComplementOperator(unaryExpr);
            return;
        }
        if (this.types.isExpressionInUnaryValid(unaryExpr.expr) && Types.getImpliedType((BType)unaryExpr.expectedType).tag == 33) {
            this.result = this.rewriteExpr(Types.constructNumericLiteralFromUnaryExpr(unaryExpr));
            return;
        }
        OperatorKind opKind = unaryExpr.operator;
        if (opKind == OperatorKind.ADD || opKind == OperatorKind.SUB) {
            this.createTypeCastExprForUnaryPlusAndMinus(unaryExpr);
        }
        unaryExpr.expr = this.rewriteExpr(unaryExpr.expr);
        this.result = unaryExpr;
    }

    private void createTypeCastExprForUnaryPlusAndMinus(BLangUnaryExpr unaryExpr) {
        BLangExpression expr = unaryExpr.expr;
        if (TypeTags.isIntegerTypeTag(Types.getImpliedType((BType)expr.getBType()).tag)) {
            return;
        }
        unaryExpr.expr = this.createTypeCastExpr(expr, unaryExpr.getBType());
    }

    private void rewriteBitwiseComplementOperator(BLangUnaryExpr unaryExpr) {
        Location pos = unaryExpr.pos;
        BLangBinaryExpr binaryExpr = (BLangBinaryExpr)TreeBuilder.createBinaryExpressionNode();
        binaryExpr.pos = pos;
        binaryExpr.opKind = OperatorKind.BITWISE_XOR;
        binaryExpr.lhsExpr = unaryExpr.expr;
        if (2 == Types.getImpliedType((BType)unaryExpr.getBType()).tag) {
            binaryExpr.setBType(this.symTable.byteType);
            binaryExpr.rhsExpr = ASTBuilderUtil.createLiteral(pos, this.symTable.byteType, 255L);
            binaryExpr.opSymbol = (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.BITWISE_XOR, this.symTable.byteType, this.symTable.byteType);
        } else {
            binaryExpr.setBType(this.symTable.intType);
            binaryExpr.rhsExpr = ASTBuilderUtil.createLiteral(pos, this.symTable.intType, -1L);
            binaryExpr.opSymbol = (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.BITWISE_XOR, this.symTable.intType, this.symTable.intType);
        }
        this.result = this.rewriteExpr(binaryExpr);
    }

    private BLangStatementExpression createStmtExprForNilableUnaryExpr(BLangUnaryExpr unaryExpr) {
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(unaryExpr.pos);
        BUnionType exprBType = (BUnionType)unaryExpr.getBType();
        BType nilLiftType = (BType)((HashSet)exprBType.getMemberTypes()).iterator().next();
        unaryExpr.expr = this.rewriteExpr(unaryExpr.expr);
        BLangSimpleVariableDef tempVarDef = this.createVarDef("$result", unaryExpr.getBType(), this.createNilLiteral(), unaryExpr.pos);
        BLangSimpleVarRef tempVarRef = ASTBuilderUtil.createVariableRef(unaryExpr.pos, tempVarDef.var.symbol);
        blockStmt.addStatement(tempVarDef);
        BLangTypeTestExpr typeTestExpr = this.getNilTypeTestExpr(unaryExpr.pos, unaryExpr.expr);
        BLangBlockStmt ifBody = ASTBuilderUtil.createBlockStmt(unaryExpr.pos);
        BLangAssignment bLangAssignmentIf = ASTBuilderUtil.createAssignmentStmt(unaryExpr.pos, ifBody);
        bLangAssignmentIf.varRef = tempVarRef;
        bLangAssignmentIf.expr = this.createNilLiteral();
        BLangBlockStmt elseBody = ASTBuilderUtil.createBlockStmt(unaryExpr.pos);
        BLangAssignment bLangAssignmentElse = ASTBuilderUtil.createAssignmentStmt(unaryExpr.pos, elseBody);
        bLangAssignmentElse.varRef = tempVarRef;
        BLangExpression expr = this.createTypeCastExpr(unaryExpr.expr, nilLiftType);
        bLangAssignmentElse.expr = ASTBuilderUtil.createUnaryExpr(unaryExpr.pos, expr, nilLiftType, unaryExpr.operator, unaryExpr.opSymbol);
        BLangIf ifStatement = ASTBuilderUtil.createIfStmt(unaryExpr.pos, blockStmt);
        ifStatement.expr = typeTestExpr;
        ifStatement.body = ifBody;
        ifStatement.elseStmt = elseBody;
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, tempVarRef);
        stmtExpr.setBType(unaryExpr.getBType());
        return stmtExpr;
    }

    private boolean isNullableUnaryExpr(BLangUnaryExpr unaryExpr) {
        if (unaryExpr.getBType() != null && unaryExpr.getBType().isNullable()) {
            switch (unaryExpr.operator) {
                case ADD: 
                case SUB: 
                case BITWISE_COMPLEMENT: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        if (conversionExpr.typeNode == null && !conversionExpr.annAttachments.isEmpty()) {
            this.result = this.rewriteExpr(conversionExpr.expr);
            return;
        }
        BType targetType = conversionExpr.targetType;
        conversionExpr.typeNode = this.rewrite(conversionExpr.typeNode, this.env);
        conversionExpr.expr = this.rewriteExpr(conversionExpr.expr);
        this.result = conversionExpr;
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        BLangFunction function = bLangLambdaFunction.function = this.rewrite(bLangLambdaFunction.function, bLangLambdaFunction.capturedClosureEnv);
        if (function.flagSet.contains((Object)Flag.WORKER) && Symbols.isFlagOn(function.symbol.type.getFlags(), 0x20000000L) && Symbols.isFlagOn(this.env.enclInvokable.symbol.flags, 0x20000000L)) {
            this.addStrandAnnotationWithThreadAny(function.pos);
            function.addAnnotationAttachment(this.strandAnnotAttachement);
            BInvokableSymbol funcSymbol = function.symbol;
            funcSymbol.addAnnotation(this.strandAnnotAttachement.annotationAttachmentSymbol);
            funcSymbol.schedulerPolicy = SchedulerPolicy.ANY;
        }
        bLangLambdaFunction.capturedClosureEnv = null;
        this.result = bLangLambdaFunction;
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        BLangFunction bLangFunction = (BLangFunction)TreeBuilder.createFunctionNode();
        bLangFunction.setName(bLangArrowFunction.functionName);
        BLangLambdaFunction lambdaFunction = (BLangLambdaFunction)TreeBuilder.createLambdaFunctionNode();
        lambdaFunction.pos = bLangArrowFunction.pos;
        bLangFunction.addFlag(Flag.LAMBDA);
        lambdaFunction.function = bLangFunction;
        BLangValueType returnType = (BLangValueType)TreeBuilder.createValueTypeNode();
        returnType.setBType(bLangArrowFunction.body.expr.getBType());
        bLangFunction.setReturnTypeNode(returnType);
        bLangFunction.setBody(this.populateArrowExprBodyBlock(bLangArrowFunction));
        bLangArrowFunction.params.forEach(bLangFunction::addParameter);
        lambdaFunction.parent = bLangArrowFunction.parent;
        lambdaFunction.setBType(bLangArrowFunction.funcType);
        BLangFunction funcNode = lambdaFunction.function;
        BInvokableSymbol funcSymbol = Symbols.createFunctionSymbol(Flags.asMask(funcNode.flagSet), new Name(funcNode.name.value), new Name(funcNode.name.originalValue), this.env.enclPkg.symbol.pkgID, bLangArrowFunction.funcType, this.env.enclEnv.enclVarSym, true, bLangArrowFunction.pos, SymbolOrigin.VIRTUAL);
        funcSymbol.type.tsymbol.pkgID = funcSymbol.pkgID;
        funcSymbol.originalName = new Name(funcNode.name.originalValue);
        SymbolEnv invokableEnv = SymbolEnv.createFunctionEnv(funcNode, funcSymbol.scope, this.env);
        this.defineInvokableSymbol(funcNode, funcSymbol, invokableEnv);
        List<BVarSymbol> paramSymbols = funcNode.requiredParams.stream().peek(varNode -> {
            Scope enclScope = invokableEnv.scope;
            varNode.symbol.kind = SymbolKind.FUNCTION;
            varNode.symbol.owner = invokableEnv.scope.owner;
            enclScope.define(varNode.symbol.name, varNode.symbol);
        }).map(varNode -> varNode.symbol).toList();
        funcSymbol.params = paramSymbols;
        funcSymbol.restParam = this.getRestSymbol(funcNode);
        funcSymbol.retType = funcNode.returnTypeNode.getBType();
        ArrayList<BType> paramTypes = new ArrayList<BType>(paramSymbols.stream().map(paramSym -> paramSym.type).toList());
        funcNode.setBType(new BInvokableType(this.symTable.typeEnv(), paramTypes, this.getRestType(funcSymbol), funcNode.returnTypeNode.getBType(), funcSymbol.type.tsymbol));
        BType bType = bLangArrowFunction.getBType();
        if (bType != null && Symbols.isFlagOn(bType.getFlags(), 0x20000000L)) {
            funcSymbol.flags |= 0x20000000L;
            funcNode.getBType().addFlags(0x20000000L);
        }
        lambdaFunction.function.pos = bLangArrowFunction.pos;
        lambdaFunction.function.body.pos = bLangArrowFunction.pos;
        lambdaFunction.capturedClosureEnv = this.env;
        this.env.enclPkg.addFunction(lambdaFunction.function);
        this.result = this.rewriteExpr(lambdaFunction);
    }

    private void defineInvokableSymbol(BLangInvokableNode invokableNode, BInvokableSymbol funcSymbol, SymbolEnv invokableEnv) {
        invokableNode.symbol = funcSymbol;
        invokableEnv.scope = funcSymbol.scope = new Scope(funcSymbol);
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        this.result = xmlQName;
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        xmlAttribute.name = this.rewriteExpr(xmlAttribute.name);
        xmlAttribute.value = this.rewriteExpr(xmlAttribute.value);
        this.result = xmlAttribute;
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        xmlElementLiteral.attributes = this.rewriteExprs(xmlElementLiteral.attributes);
        for (BLangXMLAttribute attribute : xmlElementLiteral.attributes) {
            if (!attribute.isNamespaceDeclr) continue;
            BLangXMLNS xmlns = (xmlElementLiteral.scope.owner.tag & 0x1001L) == 4097L ? new BLangXMLNS.BLangPackageXMLNS() : new BLangXMLNS.BLangLocalXMLNS();
            xmlns.namespaceURI = attribute.value.concatExpr;
            xmlns.prefix = ((BLangXMLQName)attribute.name).localname;
            xmlns.symbol = attribute.symbol;
            xmlElementLiteral.inlineNamespaces.add(xmlns);
        }
        List<BLangXMLNS> prevInlineNamespaces = this.inlineXMLNamespaces;
        if (this.isVisitingQuery && this.inlineXMLNamespaces != null) {
            xmlElementLiteral.inlineNamespaces.addAll(this.inlineXMLNamespaces);
        }
        this.inlineXMLNamespaces = xmlElementLiteral.inlineNamespaces;
        xmlElementLiteral.startTagName = this.rewriteExpr(xmlElementLiteral.startTagName);
        xmlElementLiteral.endTagName = this.rewriteExpr(xmlElementLiteral.endTagName);
        xmlElementLiteral.modifiedChildren = this.rewriteExprs(xmlElementLiteral.modifiedChildren);
        this.inlineXMLNamespaces = prevInlineNamespaces;
        this.result = xmlElementLiteral;
    }

    @Override
    public void visit(BLangXMLSequenceLiteral xmlSequenceLiteral) {
        for (BLangExpression xmlItem : xmlSequenceLiteral.xmlItems) {
            this.rewriteExpr(xmlItem);
        }
        this.result = xmlSequenceLiteral;
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        xmlTextLiteral.concatExpr = this.rewriteExpr(this.constructStringTemplateConcatExpression(xmlTextLiteral.textFragments));
        this.result = xmlTextLiteral;
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        xmlCommentLiteral.concatExpr = this.rewriteExpr(this.constructStringTemplateConcatExpression(xmlCommentLiteral.textFragments));
        this.result = xmlCommentLiteral;
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        xmlProcInsLiteral.target = this.rewriteExpr(xmlProcInsLiteral.target);
        xmlProcInsLiteral.dataConcatExpr = this.rewriteExpr(this.constructStringTemplateConcatExpression(xmlProcInsLiteral.dataFragments));
        this.result = xmlProcInsLiteral;
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        xmlQuotedString.concatExpr = this.rewriteExpr(this.constructStringTemplateConcatExpression(xmlQuotedString.textFragments));
        this.result = xmlQuotedString;
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        this.result = this.rewriteExpr(this.constructStringTemplateConcatExpression(stringTemplateLiteral.exprs));
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        Location pos = rawTemplateLiteral.pos;
        BObjectType objType = (BObjectType)Types.getImpliedType(rawTemplateLiteral.getBType());
        BLangClassDefinition objClassDef = this.desugarTemplateLiteralObjectTypedef(rawTemplateLiteral.strings, objType, pos);
        BObjectType classObjType = (BObjectType)objClassDef.getBType();
        BVarSymbol insertionsSym = ((BField)classObjType.fields.get((Object)"insertions")).symbol;
        BLangListConstructorExpr insertionsList = ASTBuilderUtil.createListConstructorExpr(pos, insertionsSym.type);
        insertionsList.exprs.addAll(rawTemplateLiteral.insertions);
        insertionsList.expectedType = insertionsSym.type;
        BLangTypeInit typeNewExpr = ASTBuilderUtil.createEmptyTypeInit(pos, classObjType);
        typeNewExpr.argsExpr.add(insertionsList);
        BLangInvocation initInvocation = (BLangInvocation)typeNewExpr.initInvocation;
        initInvocation.argExprs.add(insertionsList);
        initInvocation.requiredArgs.add(insertionsList);
        this.result = this.rewriteExpr(typeNewExpr);
    }

    private BLangClassDefinition desugarTemplateLiteralObjectTypedef(List<BLangLiteral> strings, BObjectType objectType, Location pos) {
        BLangFunction userDefinedInitFunction;
        BObjectTypeSymbol tSymbol = (BObjectTypeSymbol)objectType.tsymbol;
        Name objectClassName = Names.fromString(this.anonModelHelper.getNextRawTemplateTypeKey(this.env.enclPkg.packageID, tSymbol.name));
        BClassSymbol classTSymbol = Symbols.createClassSymbol(tSymbol.flags, objectClassName, this.env.enclPkg.packageID, null, this.env.enclPkg.symbol, pos, SymbolOrigin.VIRTUAL, false);
        classTSymbol.flags |= 0x10000000L;
        BObjectType objectClassType = new BObjectType(this.symTable.typeEnv(), (BTypeSymbol)classTSymbol, classTSymbol.flags);
        objectClassType.fields = objectType.fields;
        classTSymbol.type = objectClassType;
        objectClassType.typeIdSet.add(objectType.typeIdSet);
        BLangClassDefinition classDef = TypeDefBuilderHelper.createClassDef(pos, classTSymbol, this.env);
        classDef.name = ASTBuilderUtil.createIdentifier(pos, objectClassType.tsymbol.name.value);
        BType stringsType = ((BField)objectClassType.fields.get((Object)"strings")).symbol.type;
        BLangListConstructorExpr stringsList = ASTBuilderUtil.createListConstructorExpr(pos, stringsType);
        stringsList.exprs.addAll(strings);
        stringsList.expectedType = stringsType;
        classDef.fields.get((int)0).expr = stringsList;
        classDef.initFunction = userDefinedInitFunction = this.createUserDefinedObjectInitFn(classDef, this.env);
        this.env.enclPkg.functions.add(userDefinedInitFunction);
        this.env.enclPkg.topLevelNodes.add(userDefinedInitFunction);
        BLangFunction tempGeneratedInitFunction = this.createGeneratedInitializerFunction(classDef, this.env);
        tempGeneratedInitFunction.clonedEnv = SymbolEnv.createFunctionEnv(tempGeneratedInitFunction, tempGeneratedInitFunction.symbol.scope, this.env);
        this.semanticAnalyzer.analyzeNode((BLangNode)tempGeneratedInitFunction, this.env);
        classDef.generatedInitFunction = tempGeneratedInitFunction;
        this.env.enclPkg.functions.add(classDef.generatedInitFunction);
        this.env.enclPkg.topLevelNodes.add(classDef.generatedInitFunction);
        return this.rewrite(classDef, this.env);
    }

    private BLangFunction createUserDefinedObjectInitFn(BLangClassDefinition classDefn, SymbolEnv env) {
        BLangFunction initFunction = TypeDefBuilderHelper.createInitFunctionForStructureType(classDefn.symbol, env, this.names, Names.USER_DEFINED_INIT_SUFFIX, this.symTable, classDefn.getBType());
        BObjectTypeSymbol typeSymbol = (BObjectTypeSymbol)classDefn.getBType().tsymbol;
        typeSymbol.initializerFunc = new BAttachedFunction(Names.USER_DEFINED_INIT_SUFFIX, initFunction.symbol, (BInvokableType)initFunction.getBType(), classDefn.pos);
        classDefn.initFunction = initFunction;
        initFunction.returnTypeNode.setBType(this.symTable.nilType);
        BLangBlockFunctionBody initFuncBody = (BLangBlockFunctionBody)initFunction.body;
        BInvokableType initFnType = (BInvokableType)initFunction.getBType();
        for (BLangSimpleVariable field : classDefn.fields) {
            if (field.expr != null) continue;
            BVarSymbol fieldSym = field.symbol;
            BVarSymbol paramSym = new BVarSymbol(4L, fieldSym.name, this.env.scope.owner.pkgID, fieldSym.type, initFunction.symbol, classDefn.pos, SymbolOrigin.VIRTUAL);
            BLangSimpleVariable param = ASTBuilderUtil.createVariable(classDefn.pos, fieldSym.name.value, fieldSym.type, null, paramSym);
            param.flagSet.add(Flag.FINAL);
            initFunction.symbol.scope.define(paramSym.name, paramSym);
            initFunction.symbol.params.add(paramSym);
            initFnType.addParamType(param.getBType());
            initFunction.requiredParams.add(param);
            BLangSimpleVarRef paramRef = ASTBuilderUtil.createVariableRef(initFunction.pos, paramSym);
            BLangAssignment fieldInit = this.createStructFieldUpdate(initFunction, paramRef, fieldSym, field.getBType(), initFunction.receiver.symbol, field.name);
            initFuncBody.addStatement(fieldInit);
        }
        return initFunction;
    }

    @Override
    public void visit(BLangWorkerAsyncSendExpr asyncSendExpr) {
        asyncSendExpr.expr = this.visitCloneInvocation(this.rewriteExpr(asyncSendExpr.expr), asyncSendExpr.expr.getBType());
        this.channelsWithinIfStmt.add(asyncSendExpr.getChannel());
        this.result = asyncSendExpr;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        syncSendExpr.expr = this.visitCloneInvocation(this.rewriteExpr(syncSendExpr.expr), syncSendExpr.expr.getBType());
        this.channelsWithinIfStmt.add(syncSendExpr.getChannel());
        this.result = syncSendExpr;
    }

    @Override
    public void visit(BLangAlternateWorkerReceive altWorkerReceive) {
        this.result = altWorkerReceive;
    }

    @Override
    public void visit(BLangMultipleWorkerReceive multipleWorkerReceive) {
        this.result = multipleWorkerReceive;
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        this.result = workerReceiveNode;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        workerFlushExpr.workerIdentifierList = workerFlushExpr.cachedWorkerSendStmts.stream().map(send -> send.workerIdentifier).distinct().toList();
        this.result = workerFlushExpr;
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
        BInvokableSymbol isTransactionalSymbol = (BInvokableSymbol)this.transactionDesugar.getInternalTransactionModuleInvokableSymbol(Names.IS_TRANSACTIONAL);
        this.result = ASTBuilderUtil.createInvocationExprMethod(transactionalExpr.pos, isTransactionalSymbol, Collections.emptyList(), Collections.emptyList(), this.symResolver);
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
        BLangStatementExpression stmtExpr = this.transactionDesugar.desugar(commitExpr, this.env);
        this.result = this.rewriteExpr(stmtExpr);
    }

    @Override
    public void visit(BLangFail failNode) {
        if (this.onFailClause != null && !this.desugarToReturn) {
            this.result = this.onFailClause.bodyContainsFail ? this.rewriteNestedOnFail(this.onFailClause, failNode) : this.createOnFailInvocation(this.onFailClause, failNode);
        } else {
            BLangReturn stmt = ASTBuilderUtil.createReturnStmt(failNode.pos, this.rewrite(failNode.expr, this.env));
            stmt.desugared = true;
            this.result = stmt;
        }
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangLocalVarRef localVarRef) {
        this.result = localVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFieldVarRef fieldVarRef) {
        this.result = fieldVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangPackageVarRef packageVarRef) {
        this.result = packageVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFunctionVarRef functionVarRef) {
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr fieldAccessExpr) {
        this.result = fieldAccessExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef functionVarRef) {
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr mapKeyAccessExpr) {
        this.result = mapKeyAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr arrayIndexAccessExpr) {
        this.result = arrayIndexAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTupleAccessExpr arrayIndexAccessExpr) {
        this.result = arrayIndexAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTableAccessExpr tableKeyAccessExpr) {
        this.result = tableKeyAccessExpr;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral mapLiteral) {
        this.result = mapLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral structLiteral) {
        this.result = structLiteral;
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
        this.result = waitLiteral;
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        xmlElementAccess.expr = this.rewriteExpr(xmlElementAccess.expr);
        ArrayList<BLangExpression> filters = this.expandFilters(xmlElementAccess.filters);
        BLangInvocation invocationNode = this.createLanglibXMLInvocation(xmlElementAccess.pos, XML_INTERNAL_GET_ELEMENTS, xmlElementAccess.expr, Collections.emptyList(), filters);
        this.result = this.rewriteExpr(invocationNode);
    }

    private ArrayList<BLangExpression> expandFilters(List<BLangXMLElementFilter> filters) {
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        for (BLangXMLElementFilter filter : filters) {
            BSymbol nsSymbol = filter.namespaceSymbol;
            String filterName = filter.name;
            if (!(nsSymbol == null || filter.namespace.equals("") && filterName.equals("*"))) {
                String expandedName = this.createExpandedQName(((BXMLNSSymbol)nsSymbol).namespaceURI, filterName);
                args.add(this.createStringLiteral(filter.elemNamePos, expandedName));
                continue;
            }
            args.add(this.createStringLiteral(filter.elemNamePos, filterName));
        }
        return args;
    }

    private BLangInvocation createLanglibXMLInvocation(Location pos, String functionName, BLangExpression invokeOnExpr, List<BLangExpression> args, List<BLangExpression> restArgs) {
        invokeOnExpr = this.rewriteExpr(invokeOnExpr);
        BLangInvocation invocationNode = (BLangInvocation)TreeBuilder.createInvocationNode();
        invocationNode.pos = pos;
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(functionName);
        name.pos = pos;
        invocationNode.name = name;
        invocationNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        invocationNode.expr = invokeOnExpr;
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(this.symTable.xmlType, Names.fromString(functionName), this.env);
        ArrayList<BLangExpression> requiredArgs = new ArrayList<BLangExpression>();
        requiredArgs.add(invokeOnExpr);
        requiredArgs.addAll(args);
        invocationNode.requiredArgs = requiredArgs;
        invocationNode.restArgs = this.rewriteExprs(restArgs);
        invocationNode.setBType(invocationNode.symbol.type.getReturnType());
        invocationNode.langLibInvocation = true;
        return invocationNode;
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        xmlNavigation.expr = this.rewriteExpr(xmlNavigation.expr);
        if (xmlNavigation.parent.getKind() == NodeKind.XML_EXTENDED_NAVIGATION) {
            this.result = xmlNavigation;
            return;
        }
        this.createMapFunctionForStepExpr(xmlNavigation, new ArrayList<BLangXMLStepExtend>());
    }

    @Override
    public void visit(BLangExtendedXMLNavigationAccess extendedXmlNavigationAccess) {
        BLangXMLNavigationAccess stepExpr = extendedXmlNavigationAccess.stepExpr;
        stepExpr.parent = extendedXmlNavigationAccess;
        extendedXmlNavigationAccess.stepExpr = this.rewriteExpr(stepExpr);
        this.createMapFunctionForStepExpr(extendedXmlNavigationAccess.stepExpr, extendedXmlNavigationAccess.extensions);
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        assignableExpr.lhsExpr = this.rewriteExpr(assignableExpr.lhsExpr);
        this.result = assignableExpr;
    }

    @Override
    public void visit(BLangTypedescExpr typedescExpr) {
        typedescExpr.typeNode = this.rewrite(typedescExpr.typeNode, this.env);
        this.result = typedescExpr;
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.result = this.rewriteExpr(bLangVarArgsExpression.expr);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        bLangNamedArgsExpression.expr = this.rewriteExpr(bLangNamedArgsExpression.expr);
        this.result = bLangNamedArgsExpression.expr;
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.visitCheckAndCheckPanicExpr(checkedExpr, false);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkedExpr) {
        this.visitCheckAndCheckPanicExpr(checkedExpr, true);
    }

    private void visitCheckAndCheckPanicExpr(BLangCheckedExpr checkedExpr, boolean isCheckPanic) {
        if (checkedExpr.isRedundantChecking) {
            this.result = this.rewriteExpr(checkedExpr.expr);
            return;
        }
        Location pos = checkedExpr.pos;
        String resultVarName = "_$result$_";
        BType resultType = checkedExpr.getBType();
        BLangSimpleVariable resultVar = ASTBuilderUtil.createVariable(pos, resultVarName, resultType, null, new BVarSymbol(0L, Names.fromString(resultVarName), this.env.scope.owner.pkgID, resultType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL));
        final BLangSimpleVariableDef resultVarDef = ASTBuilderUtil.createVariableDef(pos, resultVar);
        resultVarDef.desugared = true;
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(pos, resultVar.symbol);
        String checkedExprVarName = Names.GEN_VAR_PREFIX.value;
        BType checkedExprType = checkedExpr.expr.getBType();
        BLangSimpleVariable checkedExprVar = ASTBuilderUtil.createVariable(pos, checkedExprVarName, checkedExprType, checkedExpr.expr, new BVarSymbol(0L, Names.fromString(checkedExprVarName), this.env.scope.owner.pkgID, checkedExprType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL));
        final BLangSimpleVariableDef checkedExprVarDef = ASTBuilderUtil.createVariableDef(pos, checkedExprVar);
        BLangSimpleVarRef checkedExprVarRef = ASTBuilderUtil.createVariableRef(pos, checkedExprVar.symbol);
        BLangAssignment successAssignment = ASTBuilderUtil.createAssignmentStmt(pos, resultVarRef, this.createTypeCastExpr(checkedExprVarRef, resultType));
        BLangBlockStmt ifBody = ASTBuilderUtil.createBlockStmt(pos);
        ifBody.addStatement(successAssignment);
        BLangBlockStmt elseBody = this.getSafeErrorAssignment(pos, checkedExprVarRef, this.env.enclInvokable.symbol, checkedExpr.equivalentErrorTypeList, isCheckPanic);
        BLangValueType checkedExprTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        checkedExprTypeNode.setBType(resultType);
        checkedExprTypeNode.typeKind = resultType.getKind();
        final BLangIf ifStmt = ASTBuilderUtil.createIfElseStmt(pos, this.createTypeCheckExpr(pos, checkedExprVarRef, checkedExprTypeNode), ifBody, elseBody);
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(pos, (List<BLangStatement>)new ArrayList<BLangStatement>(){
            {
                this.add(resultVarDef);
                this.add(checkedExprVarDef);
                this.add(ifStmt);
            }
        });
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        stmtExpr.setBType(resultType);
        this.result = this.rewriteExpr(stmtExpr);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        BLangTypeInit typeInit = ASTBuilderUtil.createEmptyTypeInit(serviceConstructorExpr.pos, serviceConstructorExpr.serviceNode.serviceClass.symbol.type);
        serviceConstructorExpr.serviceNode.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        this.result = this.rewriteExpr(typeInit);
    }

    @Override
    public void visit(BLangObjectConstructorExpression bLangObjectConstructorExpression) {
        this.visit(bLangObjectConstructorExpression.classNode);
        bLangObjectConstructorExpression.classNode.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        this.result = this.rewriteExpr(bLangObjectConstructorExpression.typeInit);
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        BLangBinaryExpr binaryExpr = (BLangBinaryExpr)TreeBuilder.createBinaryExpressionNode();
        binaryExpr.pos = annotAccessExpr.pos;
        binaryExpr.opKind = OperatorKind.ANNOT_ACCESS;
        binaryExpr.lhsExpr = annotAccessExpr.expr;
        binaryExpr.rhsExpr = ASTBuilderUtil.createLiteral(annotAccessExpr.pkgAlias.pos, this.symTable.stringType, annotAccessExpr.annotationSymbol.bvmAlias());
        binaryExpr.setBType(annotAccessExpr.getBType());
        binaryExpr.opSymbol = new BOperatorSymbol(Names.fromString(OperatorKind.ANNOT_ACCESS.value()), null, new BInvokableType(this.symTable.typeEnv(), Lists.of(binaryExpr.lhsExpr.getBType(), binaryExpr.rhsExpr.getBType()), annotAccessExpr.getBType(), null), null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        this.result = this.rewriteExpr(binaryExpr);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        BLangExpression expr = typeTestExpr.expr;
        if (this.types.isValueType(expr.getBType())) {
            expr = this.types.addConversionExprIfRequired(expr, this.symTable.anyType);
        }
        if (typeTestExpr.isNegation) {
            BLangTypeTestExpr bLangTypeTestExpr = ASTBuilderUtil.createTypeTestExpr(typeTestExpr.pos, typeTestExpr.expr, typeTestExpr.typeNode);
            BLangGroupExpr bLangGroupExpr = (BLangGroupExpr)TreeBuilder.createGroupExpressionNode();
            bLangGroupExpr.expression = bLangTypeTestExpr;
            bLangGroupExpr.setBType(typeTestExpr.getBType());
            BLangUnaryExpr unaryExpr = ASTBuilderUtil.createUnaryExpr(typeTestExpr.pos, bLangGroupExpr, typeTestExpr.getBType(), OperatorKind.NOT, null);
            this.result = this.rewriteExpr(unaryExpr);
            return;
        }
        typeTestExpr.expr = this.rewriteExpr(expr);
        typeTestExpr.typeNode = this.rewrite(typeTestExpr.typeNode, this.env);
        this.result = typeTestExpr;
    }

    @Override
    public void visit(BLangIsLikeExpr isLikeExpr) {
        isLikeExpr.expr = this.rewriteExpr(isLikeExpr.expr);
        this.result = isLikeExpr;
    }

    @Override
    public void visit(BLangStatementExpression bLangStatementExpression) {
        bLangStatementExpression.expr = this.rewriteExpr(bLangStatementExpression.expr);
        bLangStatementExpression.stmt = this.rewrite(bLangStatementExpression.stmt, this.env);
        this.result = bLangStatementExpression;
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        boolean prevIsVisitingQuery = this.isVisitingQuery;
        boolean prevDesugarToReturn = this.desugarToReturn;
        this.isVisitingQuery = true;
        this.desugarToReturn = true;
        BLangStatementExpression stmtExpr = this.queryDesugar.desugar(queryExpr, this.env, this.getVisibleXMLNSStmts(this.env));
        this.result = this.rewrite(stmtExpr, this.env);
        this.isVisitingQuery = prevIsVisitingQuery;
        this.desugarToReturn = prevDesugarToReturn;
    }

    List<BLangStatement> getVisibleXMLNSStmts(SymbolEnv env) {
        Map<Name, BXMLNSSymbol> nameBXMLNSSymbolMap = this.symResolver.resolveAllNamespaces(env);
        return nameBXMLNSSymbolMap.keySet().stream().map(key -> this.stmtsToBePropagatedToQuery.get(key)).filter(Objects::nonNull).toList();
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        boolean prevIsVisitingQuery = this.isVisitingQuery;
        boolean prevDesugarToReturn = this.desugarToReturn;
        this.desugarToReturn = true;
        this.isVisitingQuery = true;
        BLangStatementExpression stmtExpr = this.queryDesugar.desugar(queryAction, this.env, this.getVisibleXMLNSStmts(this.env));
        this.result = this.rewrite(stmtExpr, this.env);
        this.isVisitingQuery = prevIsVisitingQuery;
        this.desugarToReturn = prevDesugarToReturn;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteral) {
        jsonArrayLiteral.exprs = this.rewriteExprs(jsonArrayLiteral.exprs);
        this.result = jsonArrayLiteral;
    }

    @Override
    public void visit(BLangConstant constant) {
        BConstantSymbol constSymbol = constant.symbol;
        BType impliedType = Types.getImpliedType(constSymbol.literalType);
        int tag = impliedType.tag;
        if (tag <= 6 || tag == 10) {
            if (tag != 10 && (constSymbol.value == null || constSymbol.value.value == null)) {
                throw new IllegalStateException();
            }
            BLangLiteral literal = ASTBuilderUtil.createLiteral(constant.expr.pos, constSymbol.literalType, constSymbol.value.value);
            constant.expr = this.rewriteExpr(literal);
        } else {
            constant.expr = this.rewriteExpr(constant.expr);
        }
        constant.annAttachments.forEach(attachment -> this.rewrite(attachment, this.env));
        this.result = constant;
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
        this.result = ignoreExpr;
    }

    @Override
    public void visit(BLangDynamicArgExpr dynamicParamExpr) {
        dynamicParamExpr.conditionalArgument = this.rewriteExpr(dynamicParamExpr.conditionalArgument);
        dynamicParamExpr.condition = this.rewriteExpr(dynamicParamExpr.condition);
        this.result = dynamicParamExpr;
    }

    @Override
    public void visit(BLangConstRef constantRef) {
        this.result = ASTBuilderUtil.createLiteral(constantRef.pos, constantRef.getBType(), constantRef.value);
    }

    @Override
    public void visit(BLangRegExpTemplateLiteral regExpTemplateLiteral) {
        regExpTemplateLiteral.reDisjunction = this.rewriteExpr(regExpTemplateLiteral.reDisjunction);
        this.result = regExpTemplateLiteral;
    }

    @Override
    public void visit(BLangReDisjunction reDisjunction) {
        reDisjunction.sequenceList.forEach(this::rewriteExpr);
        this.result = reDisjunction;
    }

    @Override
    public void visit(BLangReSequence reSequence) {
        reSequence.termList.forEach(this::rewriteExpr);
        this.result = reSequence;
    }

    @Override
    public void visit(BLangReAssertion reAssertion) {
        reAssertion.assertion = this.rewriteExpr(reAssertion.assertion);
        this.result = reAssertion;
    }

    @Override
    public void visit(BLangReAtomQuantifier reAtomQuantifier) {
        BLangExpression reAtom = reAtomQuantifier.atom;
        reAtomQuantifier.atom = this.symResolver.isReAtomNode(reAtom.getKind()) ? this.rewriteExpr(reAtom) : this.rewriteExpr(this.getToStringInvocationOnExpr(reAtom));
        if (reAtomQuantifier.quantifier == null) {
            reAtomQuantifier.quantifier = ASTBuilderUtil.createEmptyQuantifier(reAtomQuantifier.pos, this.symTable.anydataType, this.symTable.stringType);
        }
        reAtomQuantifier.quantifier = this.rewriteExpr(reAtomQuantifier.quantifier);
        this.result = reAtomQuantifier;
    }

    @Override
    public void visit(BLangReAtomCharOrEscape reAtomCharOrEscape) {
        reAtomCharOrEscape.charOrEscape = this.rewriteExpr(reAtomCharOrEscape.charOrEscape);
        this.result = reAtomCharOrEscape;
    }

    @Override
    public void visit(BLangReQuantifier reQuantifier) {
        reQuantifier.quantifier = this.rewriteExpr(reQuantifier.quantifier);
        if (reQuantifier.nonGreedyChar == null) {
            reQuantifier.nonGreedyChar = ASTBuilderUtil.createLiteral(reQuantifier.pos, this.symTable.stringType, "");
        }
        reQuantifier.nonGreedyChar = this.rewriteExpr(reQuantifier.nonGreedyChar);
        this.result = reQuantifier;
    }

    @Override
    public void visit(BLangReCharacterClass reCharacterClass) {
        reCharacterClass.characterClassStart = this.rewriteExpr(reCharacterClass.characterClassStart);
        if (reCharacterClass.negation == null) {
            reCharacterClass.negation = ASTBuilderUtil.createLiteral(reCharacterClass.pos, this.symTable.stringType, "");
        }
        reCharacterClass.negation = this.rewriteExpr(reCharacterClass.negation);
        if (reCharacterClass.charSet == null) {
            reCharacterClass.charSet = ASTBuilderUtil.createEmptyCharSet(this.symTable.anydataType);
        }
        reCharacterClass.charSet = this.rewriteExpr(reCharacterClass.charSet);
        reCharacterClass.characterClassEnd = this.rewriteExpr(reCharacterClass.characterClassEnd);
        this.result = reCharacterClass;
    }

    @Override
    public void visit(BLangReCharSet reCharSet) {
        reCharSet.charSetAtoms.forEach(this::rewriteExpr);
        this.result = reCharSet;
    }

    @Override
    public void visit(BLangReCharSetRange reCharSetRange) {
        reCharSetRange.lhsCharSetAtom = this.rewriteExpr(reCharSetRange.lhsCharSetAtom);
        reCharSetRange.dash = this.rewriteExpr(reCharSetRange.dash);
        reCharSetRange.rhsCharSetAtom = this.rewriteExpr(reCharSetRange.rhsCharSetAtom);
        this.result = reCharSetRange;
    }

    @Override
    public void visit(BLangReCapturingGroups reCapturingGroups) {
        reCapturingGroups.openParen = this.rewriteExpr(reCapturingGroups.openParen);
        if (reCapturingGroups.flagExpr == null) {
            reCapturingGroups.flagExpr = ASTBuilderUtil.createEmptyFlagExpression(reCapturingGroups.pos, this.symTable.anydataType, this.symTable.stringType);
        }
        reCapturingGroups.flagExpr = this.rewriteExpr(reCapturingGroups.flagExpr);
        reCapturingGroups.disjunction = this.rewriteExpr(reCapturingGroups.disjunction);
        reCapturingGroups.closeParen = this.rewriteExpr(reCapturingGroups.closeParen);
        this.result = reCapturingGroups;
    }

    @Override
    public void visit(BLangReFlagExpression reFlagExpression) {
        reFlagExpression.questionMark = this.rewriteExpr(reFlagExpression.questionMark);
        if (reFlagExpression.flagsOnOff == null) {
            reFlagExpression.flagsOnOff = ASTBuilderUtil.createEmptyFlagOnOff(reFlagExpression.pos, this.symTable.anydataType, this.symTable.stringType);
        }
        reFlagExpression.flagsOnOff = this.rewriteExpr(reFlagExpression.flagsOnOff);
        reFlagExpression.colon = this.rewriteExpr(reFlagExpression.colon);
        this.result = reFlagExpression;
    }

    @Override
    public void visit(BLangReFlagsOnOff reFlagsOnOff) {
        reFlagsOnOff.flags = this.rewriteExpr(reFlagsOnOff.flags);
        this.result = reFlagsOnOff;
    }

    @Override
    public void visit(BLangNaturalExpression naturalExpression) {
        if (naturalExpression.isConstExpr) {
            throw new IllegalStateException("'const' natural expression should be handled by the implementation");
        }
        Location pos = naturalExpression.pos;
        String varName = this.anonModelHelper.getNextNaturalGeneratorVariableName(this.env.enclPkg.packageID);
        BLangSimpleVariableDef generatorVariableDef = this.createGeneratorVariableDefinition(naturalExpression, varName, pos);
        BType bType = naturalExpression.getBType();
        BLangInvocation generatorGenerateCall = this.createGeneratorGenerateCall(pos, generatorVariableDef, naturalExpression, bType);
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(pos);
        blockStmt.addStatement(generatorVariableDef);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(blockStmt, generatorGenerateCall);
        statementExpression.setBType(bType);
        this.result = this.rewrite(statementExpression, this.env);
    }

    BLangSimpleVariableDef getIteratorVariableDefinition(Location pos, BVarSymbol collectionSymbol, BInvokableSymbol iteratorInvokableSymbol, boolean isIteratorFuncFromLangLib) {
        BLangSimpleVarRef dataReference = ASTBuilderUtil.createVariableRef(pos, collectionSymbol);
        BLangInvocation iteratorInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        iteratorInvocation.pos = pos;
        iteratorInvocation.expr = dataReference;
        iteratorInvocation.symbol = iteratorInvokableSymbol;
        iteratorInvocation.setBType(iteratorInvokableSymbol.retType);
        iteratorInvocation.argExprs = Lists.of(dataReference);
        iteratorInvocation.requiredArgs = iteratorInvocation.argExprs;
        iteratorInvocation.langLibInvocation = isIteratorFuncFromLangLib;
        BVarSymbol iteratorSymbol = new BVarSymbol(0L, Names.fromString("$iterator$"), this.env.scope.owner.pkgID, iteratorInvokableSymbol.retType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable iteratorVariable = ASTBuilderUtil.createVariable(pos, "$iterator$", iteratorInvokableSymbol.retType, iteratorInvocation, iteratorSymbol);
        return ASTBuilderUtil.createVariableDef(pos, iteratorVariable);
    }

    BLangSimpleVariableDef getIteratorNextVariableDefinition(Location pos, BType nillableResultType, BVarSymbol iteratorSymbol, BVarSymbol resultSymbol) {
        BLangInvocation nextInvocation = this.createIteratorNextInvocation(pos, iteratorSymbol);
        BLangSimpleVariable resultVariable = ASTBuilderUtil.createVariable(pos, "$result$", nillableResultType, nextInvocation, resultSymbol);
        return ASTBuilderUtil.createVariableDef(pos, resultVariable);
    }

    BLangInvocation createIteratorNextInvocation(Location pos, BVarSymbol iteratorSymbol) {
        BLangIdentifier nextIdentifier = ASTBuilderUtil.createIdentifier(pos, "next");
        BLangSimpleVarRef iteratorReferenceInNext = ASTBuilderUtil.createVariableRef(pos, iteratorSymbol);
        BInvokableSymbol nextFuncSymbol = this.getObjectMethod((BObjectType)((BObjectType)Types.getImpliedType((BType)iteratorSymbol.type)), (String)"next").symbol;
        BLangInvocation nextInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        nextInvocation.pos = pos;
        nextInvocation.name = nextIdentifier;
        nextInvocation.expr = iteratorReferenceInNext;
        nextInvocation.requiredArgs = Lists.of(ASTBuilderUtil.createVariableRef(pos, iteratorSymbol));
        nextInvocation.argExprs = nextInvocation.requiredArgs;
        nextInvocation.symbol = nextFuncSymbol;
        nextInvocation.setBType(nextFuncSymbol.retType);
        return nextInvocation;
    }

    private BAttachedFunction getObjectMethod(BObjectType objectType, String methodName) {
        BObjectTypeSymbol iteratorSymbol = (BObjectTypeSymbol)objectType.tsymbol;
        for (BAttachedFunction bAttachedFunction : iteratorSymbol.attachedFuncs) {
            if (!bAttachedFunction.funcName.value.equals(methodName)) continue;
            return bAttachedFunction;
        }
        return null;
    }

    BLangFieldBasedAccess getValueAccessExpression(Location location, BType varType, BVarSymbol resultSymbol) {
        return this.getFieldAccessExpression(location, "value", varType, resultSymbol);
    }

    BLangFieldBasedAccess getFieldAccessExpression(Location pos, String fieldName, BType varType, BVarSymbol resultSymbol) {
        BLangSimpleVarRef resultReferenceInVariableDef = ASTBuilderUtil.createVariableRef(pos, resultSymbol);
        BLangIdentifier valueIdentifier = ASTBuilderUtil.createIdentifier(pos, fieldName);
        BLangFieldBasedAccess fieldBasedAccessExpression = ASTBuilderUtil.createFieldAccessExpr(resultReferenceInVariableDef, valueIdentifier);
        fieldBasedAccessExpression.pos = pos;
        fieldBasedAccessExpression.setBType(varType);
        fieldBasedAccessExpression.originalType = fieldBasedAccessExpression.getBType();
        return fieldBasedAccessExpression;
    }

    private BlockFunctionBodyNode populateArrowExprBodyBlock(BLangArrowFunction bLangArrowFunction) {
        BlockFunctionBodyNode blockNode = TreeBuilder.createBlockFunctionBodyNode();
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.pos = bLangArrowFunction.body.expr.pos;
        returnNode.setExpression(bLangArrowFunction.body.expr);
        blockNode.addStatement(returnNode);
        return blockNode;
    }

    protected BLangInvocation createInvocationNode(String functionName, List<BLangExpression> args, BType retType) {
        BLangInvocation invocationNode = (BLangInvocation)TreeBuilder.createInvocationNode();
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(functionName);
        invocationNode.name = name;
        invocationNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        invocationNode.symbol = this.symTable.rootScope.lookup((Name)new Name((String)functionName)).symbol;
        invocationNode.setBType(retType);
        invocationNode.requiredArgs = args;
        return invocationNode;
    }

    protected BLangInvocation createLangLibInvocationNode(String functionName, BLangExpression onExpr, List<BLangExpression> args, BType retType, Location pos) {
        BLangInvocation invocationNode = (BLangInvocation)TreeBuilder.createInvocationNode();
        invocationNode.pos = pos;
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(functionName);
        name.pos = pos;
        invocationNode.name = name;
        invocationNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        invocationNode.expr = onExpr;
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(onExpr.getBType(), Names.fromString(functionName), this.env);
        ArrayList<BLangExpression> requiredArgs = new ArrayList<BLangExpression>();
        requiredArgs.add(onExpr);
        requiredArgs.addAll(args);
        invocationNode.requiredArgs = requiredArgs;
        invocationNode.setBType(retType != null ? retType : ((BInvokableSymbol)invocationNode.symbol).retType);
        invocationNode.langLibInvocation = true;
        return invocationNode;
    }

    private BLangInvocation createLangLibInvocationNode(String functionName, List<BLangExpression> requiredArgs, BType retType, Location pos) {
        return this.createLangLibInvocationNode(functionName, requiredArgs, new ArrayList<BLangExpression>(), retType, pos);
    }

    private BLangInvocation createLangLibInvocationNode(String functionName, List<BLangExpression> requiredArgs, List<BLangExpression> restArgs, BType retType, Location pos) {
        BLangInvocation invocationNode = (BLangInvocation)TreeBuilder.createInvocationNode();
        invocationNode.pos = pos;
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(functionName);
        name.pos = pos;
        invocationNode.name = name;
        invocationNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        invocationNode.symbol = this.symResolver.lookupMethodInModule(this.symTable.langInternalModuleSymbol, Names.fromString(functionName), this.env);
        invocationNode.requiredArgs = new ArrayList<BLangExpression>(requiredArgs);
        invocationNode.restArgs = new ArrayList<BLangExpression>(restArgs);
        invocationNode.setBType(retType != null ? retType : ((BInvokableSymbol)invocationNode.symbol).retType);
        invocationNode.langLibInvocation = true;
        return invocationNode;
    }

    private BLangListConstructorExpr.BLangArrayLiteral createArrayLiteralExprNode() {
        BLangListConstructorExpr.BLangArrayLiteral expr = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        expr.exprs = new ArrayList();
        expr.setBType(new BArrayType(this.symTable.typeEnv(), this.symTable.anyType));
        return expr;
    }

    private BLangInvocation.BFunctionPointerInvocation visitFunctionPointerInvocation(BLangInvocation iExpr) {
        BLangValueExpression rewritten = this.rewriteExpr(this.getFunctionPointerExpr(iExpr));
        return new BLangInvocation.BFunctionPointerInvocation(iExpr, rewritten);
    }

    protected BLangValueExpression getFunctionPointerExpr(BLangInvocation iExpr) {
        BLangValueExpression expr;
        if (iExpr.expr == null) {
            BLangSimpleVarRef varRef = new BLangSimpleVarRef();
            varRef.variableName = iExpr.name;
            expr = varRef;
        } else {
            BLangFieldBasedAccess fieldBasedAccess = new BLangFieldBasedAccess();
            fieldBasedAccess.expr = iExpr.expr;
            fieldBasedAccess.field = iExpr.name;
            expr = fieldBasedAccess;
        }
        expr.symbol = iExpr.symbol;
        expr.setBType(iExpr.symbol.type);
        return expr;
    }

    private BLangExpression visitCloneInvocation(BLangExpression expr, BType lhsType) {
        if (this.types.isValueType(expr.getBType())) {
            return expr;
        }
        if (Types.getImpliedType((BType)expr.getBType()).tag == 29) {
            return expr;
        }
        BLangInvocation cloneInvok = this.createLangLibInvocationNode("clone", expr, new ArrayList<BLangExpression>(), null, expr.pos);
        return this.types.addConversionExprIfRequired(cloneInvok, lhsType);
    }

    private BLangExpression visitCloneReadonly(BLangExpression expr, BType lhsType) {
        if (this.types.isValueType(expr.getBType())) {
            return expr;
        }
        if (Types.getImpliedType((BType)expr.getBType()).tag == 29) {
            return expr;
        }
        BLangInvocation cloneInvok = this.createLangLibInvocationNode("cloneReadOnly", expr, new ArrayList<BLangExpression>(), expr.getBType(), expr.pos);
        return this.types.addConversionExprIfRequired(cloneInvok, lhsType);
    }

    <E extends BLangNode> E rewrite(E node, SymbolEnv env) {
        if (node == null) {
            return null;
        }
        if (node.desugared) {
            return node;
        }
        SymbolEnv previousEnv = this.env;
        this.env = env;
        node.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        resultNode.desugared = true;
        this.env = previousEnv;
        return (E)resultNode;
    }

    <E extends BLangExpression> E rewriteExpr(E node) {
        if (node == null) {
            return null;
        }
        if (node.desugared) {
            return node;
        }
        Object expr = node;
        if (node.impConversionExpr != null) {
            expr = node.impConversionExpr;
            node.impConversionExpr = null;
        }
        expr.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        resultNode.desugared = true;
        return (E)((BLangExpression)resultNode);
    }

    <E extends BLangStatement> E rewrite(E statement, SymbolEnv env) {
        if (statement == null) {
            return null;
        }
        E stmt = this.rewrite(statement, env);
        return stmt;
    }

    private <E extends BLangStatement> List<E> rewriteStmt(List<E> nodeList, SymbolEnv env) {
        List<BLangSimpleVariableDef> prevTypedescList = this.typedescList;
        for (int i = 0; i < nodeList.size(); ++i) {
            this.typedescList = new ArrayList<BLangSimpleVariableDef>();
            nodeList.set(i, this.rewrite((BLangStatement)nodeList.get(i), env));
            for (BLangSimpleVariableDef variableDef : this.typedescList) {
                nodeList.add(i, this.rewrite(variableDef, env));
                BVarSymbol symbol = variableDef.var.symbol;
                env.scope.define(symbol.name, symbol);
                ++i;
            }
        }
        this.typedescList = prevTypedescList;
        return nodeList;
    }

    private <E extends BLangNode> List<E> rewrite(List<E> nodeList, SymbolEnv env) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewrite((BLangNode)nodeList.get(i), env));
        }
        return nodeList;
    }

    private <E extends BLangExpression> List<E> rewriteExprs(List<E> nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewriteExpr((BLangExpression)nodeList.get(i)));
        }
        return nodeList;
    }

    private BLangLiteral createStringLiteral(Location pos, String value) {
        BLangLiteral stringLit = new BLangLiteral(value, this.symTable.stringType);
        stringLit.pos = pos;
        return stringLit;
    }

    private BLangLiteral createIntLiteral(long value) {
        BLangLiteral literal = (BLangLiteral)TreeBuilder.createLiteralExpression();
        literal.value = value;
        literal.setBType(this.symTable.intType);
        return literal;
    }

    private BLangLiteral createByteLiteral(Location pos, Byte value) {
        BLangLiteral byteLiteral = new BLangLiteral(Byte.toUnsignedInt(value), this.symTable.byteType);
        byteLiteral.pos = pos;
        return byteLiteral;
    }

    private BLangExpression createTypeCastExpr(BLangExpression expr, BType targetType) {
        if (this.types.isSameTypeIncludingTags(expr.getBType(), targetType)) {
            return expr;
        }
        BLangTypeConversionExpr conversionExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
        conversionExpr.pos = expr.pos;
        conversionExpr.expr = expr;
        conversionExpr.setBType(targetType);
        conversionExpr.targetType = targetType;
        conversionExpr.internal = true;
        return conversionExpr;
    }

    private BType getElementType(BType bType) {
        BType type = Types.getImpliedType(bType);
        if (type.tag != 20) {
            return bType;
        }
        return this.getElementType(((BArrayType)type).getElementType());
    }

    private void addReturnIfNotPresent(BLangInvokableNode invokableNode) {
        if (Symbols.isNative(invokableNode.symbol) || invokableNode.hasBody() && invokableNode.body.getKind() != NodeKind.BLOCK_FUNCTION_BODY) {
            return;
        }
        BLangBlockFunctionBody funcBody = (BLangBlockFunctionBody)invokableNode.body;
        if (invokableNode.symbol.type.getReturnType().isNullable() && (funcBody.stmts.isEmpty() || funcBody.stmts.get(funcBody.stmts.size() - 1).getKind() != NodeKind.RETURN)) {
            Location invPos = invokableNode.pos;
            BLangDiagnosticLocation returnStmtPos = invPos != null && !invokableNode.name.value.contains(Names.GENERATED_INIT_SUFFIX.value) ? new BLangDiagnosticLocation(invPos.lineRange().fileName(), invPos.lineRange().endLine().line(), invPos.lineRange().endLine().line(), invPos.lineRange().startLine().offset(), invPos.lineRange().startLine().offset(), 0, 0) : null;
            BLangReturn returnStmt = ASTBuilderUtil.createNilReturnStmt(returnStmtPos, this.symTable.nilType);
            funcBody.addStatement(returnStmt);
        }
    }

    private void reorderArguments(BLangInvocation iExpr) {
        BSymbol symbol = iExpr.symbol;
        if (symbol == null || Types.getImpliedType((BType)symbol.type).tag != 17) {
            return;
        }
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)symbol;
        List<BLangExpression> restArgs = iExpr.restArgs;
        int originalRequiredArgCount = iExpr.requiredArgs.size();
        BLangSimpleVarRef varargRef = null;
        BLangBlockStmt blockStmt = null;
        BType varargVarType = null;
        int restArgCount = restArgs.size();
        if (restArgCount > 0 && restArgs.get(restArgCount - 1).getKind() == NodeKind.REST_ARGS_EXPR && originalRequiredArgCount < invokableSymbol.params.size()) {
            BLangExpression expr = ((BLangRestArgsExpression)restArgs.get((int)(restArgCount - 1))).expr;
            Location varargExpPos = expr.pos;
            varargVarType = expr.getBType();
            String varargVarName = "$vararg$_" + this.varargCount++;
            BVarSymbol varargVarSymbol = new BVarSymbol(0L, Names.fromString(varargVarName), this.env.scope.owner.pkgID, varargVarType, this.env.scope.owner, varargExpPos, SymbolOrigin.VIRTUAL);
            varargRef = ASTBuilderUtil.createVariableRef(varargExpPos, varargVarSymbol);
            BLangSimpleVariable var = ASTBuilderUtil.createVariable(varargExpPos, varargVarName, varargVarType, expr, varargVarSymbol);
            BLangSimpleVariableDef varDef = ASTBuilderUtil.createVariableDef(varargExpPos);
            varDef.var = var;
            varDef.setBType(varargVarType);
            blockStmt = ASTBuilderUtil.createBlockStmt(varargExpPos);
            blockStmt.stmts.add(varDef);
        }
        if (!invokableSymbol.params.isEmpty()) {
            this.reorderNamedArgs(iExpr, invokableSymbol, varargRef);
        }
        if (restArgCount == 0 || restArgs.get(restArgCount - 1).getKind() != NodeKind.REST_ARGS_EXPR) {
            if (invokableSymbol.restParam == null) {
                return;
            }
            BLangListConstructorExpr.BLangArrayLiteral arrayLiteral = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
            ArrayList<BLangExpression> exprs = new ArrayList<BLangExpression>();
            BArrayType arrayType = (BArrayType)invokableSymbol.restParam.type;
            BType elemType = arrayType.eType;
            for (BLangExpression restArg : restArgs) {
                exprs.add(this.types.addConversionExprIfRequired(restArg, elemType));
            }
            arrayLiteral.exprs = exprs;
            arrayLiteral.setBType(arrayType);
            if (restArgCount != 0) {
                iExpr.restArgs = new ArrayList<BLangExpression>();
            }
            iExpr.restArgs.add(arrayLiteral);
            return;
        }
        if (restArgCount == 1 && restArgs.get(0).getKind() == NodeKind.REST_ARGS_EXPR) {
            if (iExpr.requiredArgs.size() == originalRequiredArgCount) {
                return;
            }
            BLangExpression firstNonRestArg = iExpr.requiredArgs.remove(0);
            BLangStatementExpression stmtExpression = ASTBuilderUtil.createStatementExpression(blockStmt, firstNonRestArg);
            BType type = firstNonRestArg.impConversionExpr == null ? firstNonRestArg.getBType() : firstNonRestArg.impConversionExpr.targetType;
            stmtExpression.setBType(type);
            iExpr.requiredArgs.add(0, stmtExpression);
            if (invokableSymbol.restParam == null) {
                restArgs.remove(0);
                return;
            }
            BLangRestArgsExpression restArgsExpression = (BLangRestArgsExpression)restArgs.remove(0);
            BArrayType restParamType = (BArrayType)invokableSymbol.restParam.type;
            if (Types.getImpliedType((BType)restArgsExpression.getBType()).tag == 12) {
                BLangListConstructorExpr.BLangArrayLiteral expr = ASTBuilderUtil.createEmptyArrayLiteral(invokableSymbol.pos, restParamType);
                restArgs.add(expr);
                return;
            }
            Location pos = restArgsExpression.pos;
            BLangListConstructorExpr.BLangArrayLiteral newArrayLiteral = this.createArrayLiteralExprNode();
            newArrayLiteral.setBType(restParamType);
            String name = "$vararg$_" + this.varargCount++;
            BVarSymbol varSymbol = new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, restParamType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
            BLangSimpleVarRef arrayVarRef = ASTBuilderUtil.createVariableRef(pos, varSymbol);
            BLangSimpleVariable var = ASTBuilderUtil.createVariable(pos, name, restParamType, newArrayLiteral, varSymbol);
            BLangSimpleVariableDef varDef = ASTBuilderUtil.createVariableDef(pos);
            varDef.var = var;
            varDef.setBType(restParamType);
            BLangLiteral startIndex = this.createIntLiteral(invokableSymbol.params.size() - originalRequiredArgCount);
            BLangInvocation lengthInvocation = this.createLengthInvocation(pos, varargRef);
            BLangInvocation intRangeInvocation = this.replaceWithIntRange(pos, startIndex, this.getModifiedIntRangeEndExpr(lengthInvocation));
            BLangForeach foreach = (BLangForeach)TreeBuilder.createForeachNode();
            foreach.pos = pos;
            foreach.collection = intRangeInvocation;
            this.types.setForeachTypedBindingPatternType(foreach);
            BLangSimpleVariable foreachVariable = ASTBuilderUtil.createVariable(pos, "$foreach$i", foreach.varType);
            foreachVariable.symbol = new BVarSymbol(0L, this.names.fromIdNode(foreachVariable.name), this.env.scope.owner.pkgID, foreachVariable.getBType(), this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
            BLangSimpleVarRef foreachVarRef = ASTBuilderUtil.createVariableRef(pos, foreachVariable.symbol);
            foreach.variableDefinitionNode = ASTBuilderUtil.createVariableDef(pos, foreachVariable);
            foreach.isDeclaredWithVar = true;
            BLangBlockStmt foreachBody = ASTBuilderUtil.createBlockStmt(pos);
            BLangIndexBasedAccess valueExpr = ASTBuilderUtil.createIndexAccessExpr(varargRef, foreachVarRef);
            BType refType = Types.getImpliedType(varargVarType);
            if (refType.tag == 20) {
                BArrayType arrayType = (BArrayType)refType;
                if (arrayType.state == BArrayState.CLOSED && arrayType.getSize() == iExpr.requiredArgs.size() - originalRequiredArgCount) {
                    valueExpr.setBType(restParamType.eType);
                } else {
                    valueExpr.setBType(arrayType.eType);
                }
            } else {
                valueExpr.setBType(this.symTable.anyOrErrorType);
            }
            BLangExpression pushExpr = this.types.addConversionExprIfRequired(valueExpr, restParamType.eType);
            BLangExpressionStmt expressionStmt = ASTBuilderUtil.createExpressionStmt(pos, foreachBody);
            BLangInvocation pushInvocation = this.createLangLibInvocationNode(PUSH_LANGLIB_METHOD, arrayVarRef, List.of(pushExpr), (BType)restParamType, pos);
            pushInvocation.restArgs.add(pushInvocation.requiredArgs.remove(1));
            expressionStmt.expr = pushInvocation;
            foreach.body = foreachBody;
            BLangBlockStmt newArrayBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
            newArrayBlockStmt.addStatement(varDef);
            newArrayBlockStmt.addStatement(foreach);
            BLangStatementExpression newArrayStmtExpression = ASTBuilderUtil.createStatementExpression(newArrayBlockStmt, arrayVarRef);
            newArrayStmtExpression.setBType(restParamType);
            restArgs.add(this.types.addConversionExprIfRequired(newArrayStmtExpression, restParamType));
            return;
        }
        BArrayType restParamType = (BArrayType)invokableSymbol.restParam.type;
        BLangListConstructorExpr.BLangArrayLiteral arrayLiteral = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        arrayLiteral.setBType(restParamType);
        BType elemType = restParamType.eType;
        Location pos = restArgs.get((int)0).pos;
        ArrayList<BLangExpression> exprs = new ArrayList<BLangExpression>();
        for (int i = 0; i < restArgCount - 1; ++i) {
            exprs.add(this.types.addConversionExprIfRequired(restArgs.get(i), elemType));
        }
        arrayLiteral.exprs = exprs;
        final BLangRestArgsExpression pushRestArgsExpr = (BLangRestArgsExpression)TreeBuilder.createVarArgsNode();
        pushRestArgsExpr.pos = pos;
        pushRestArgsExpr.expr = restArgs.remove(restArgCount - 1);
        String name = "$vararg$_" + this.varargCount++;
        BVarSymbol varSymbol = new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, restParamType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVarRef arrayVarRef = ASTBuilderUtil.createVariableRef(pos, varSymbol);
        BLangSimpleVariable var = ASTBuilderUtil.createVariable(pos, name, restParamType, arrayLiteral, varSymbol);
        BLangSimpleVariableDef varDef = ASTBuilderUtil.createVariableDef(pos);
        varDef.var = var;
        varDef.setBType(restParamType);
        BLangBlockStmt pushBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        pushBlockStmt.stmts.add(varDef);
        BLangExpressionStmt expressionStmt = ASTBuilderUtil.createExpressionStmt(pos, pushBlockStmt);
        BLangInvocation pushInvocation = this.createLangLibInvocationNode(PUSH_LANGLIB_METHOD, arrayVarRef, (List<BLangExpression>)new ArrayList<BLangExpression>(){
            {
                this.add(pushRestArgsExpr);
            }
        }, (BType)restParamType, pos);
        pushInvocation.restArgs.add(pushInvocation.requiredArgs.remove(1));
        expressionStmt.expr = pushInvocation;
        final BLangStatementExpression stmtExpression = ASTBuilderUtil.createStatementExpression(pushBlockStmt, arrayVarRef);
        stmtExpression.setBType(restParamType);
        iExpr.restArgs = new ArrayList<BLangExpression>(1){
            {
                super(arg0);
                this.add(stmtExpression);
            }
        };
    }

    private void reorderNamedArgs(BLangInvocation iExpr, BInvokableSymbol invokableSymbol, BLangExpression varargRef) {
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        LinkedHashMap<String, BLangExpression> namedArgs = new LinkedHashMap<String, BLangExpression>();
        iExpr.requiredArgs.stream().filter(expr -> expr.getKind() == NodeKind.NAMED_ARGS_EXPR).forEach(expr -> namedArgs.put(((NamedArgNode)((Object)expr)).getName().value, (BLangExpression)expr));
        List<BVarSymbol> params = invokableSymbol.params;
        ArrayList<BLangRecordLiteral> incRecordLiterals = new ArrayList<BLangRecordLiteral>();
        BLangRecordLiteral incRecordParamAllowAdditionalFields = null;
        int varargIndex = 0;
        BType varargType = null;
        boolean tupleTypedVararg = false;
        if (varargRef != null) {
            varargType = Types.getImpliedType(varargRef.getBType());
            tupleTypedVararg = varargType.tag == 31;
        }
        for (int i = 0; i < params.size(); ++i) {
            BVarSymbol param = params.get(i);
            if (iExpr.requiredArgs.size() > i && iExpr.requiredArgs.get(i).getKind() != NodeKind.NAMED_ARGS_EXPR) {
                args.add(iExpr.requiredArgs.get(i));
                continue;
            }
            if (namedArgs.containsKey(param.name.value)) {
                args.add((BLangExpression)namedArgs.remove(param.name.value));
                continue;
            }
            if (param.getFlags().contains((Object)Flag.INCLUDED)) {
                BLangRecordLiteral recordLiteral = (BLangRecordLiteral)TreeBuilder.createRecordLiteralNode();
                BType paramType = param.type;
                recordLiteral.setBType(paramType);
                args.add(recordLiteral);
                incRecordLiterals.add(recordLiteral);
                if (((BRecordType)Types.getImpliedType((BType)paramType)).restFieldType == this.symTable.noType) continue;
                incRecordParamAllowAdditionalFields = recordLiteral;
                continue;
            }
            if (varargRef == null) {
                BLangIgnoreExpr expr2 = new BLangIgnoreExpr();
                expr2.setBType(param.type);
                args.add(expr2);
                continue;
            }
            if (Types.getImpliedType((BType)varargRef.getBType()).tag == 12) {
                if (param.isDefaultable) {
                    BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(varargRef.pos);
                    BLangInvocation hasKeyInvocation = this.createLangLibInvocationNode(HAS_KEY, varargRef, List.of(this.createStringLiteral(param.pos, param.name.value)), null, varargRef.pos);
                    BLangSimpleVariableDef variableDef = this.createVarDef("$hasKey$", hasKeyInvocation.getBType(), hasKeyInvocation, hasKeyInvocation.pos);
                    blockStmt.stmts.add(variableDef);
                    BLangSimpleVarRef simpleVarRef = ASTBuilderUtil.createVariableRef(variableDef.pos, variableDef.var.symbol);
                    BLangLiteral indexExpr = this.rewriteExpr(this.createStringLiteral(param.pos, param.name.value));
                    BLangIndexBasedAccess memberAccessExpr = ASTBuilderUtil.createMemberAccessExprNode(param.type, varargRef, indexExpr);
                    BLangExpression ignoreExpr = ASTBuilderUtil.createIgnoreExprNode(param.type);
                    BLangTernaryExpr ternaryExpr = ASTBuilderUtil.createTernaryExprNode(param.type, simpleVarRef, memberAccessExpr, ignoreExpr);
                    BLangDynamicArgExpr dynamicArgExpr = ASTBuilderUtil.createDynamicParamExpression(simpleVarRef, param, ternaryExpr);
                    BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, dynamicArgExpr);
                    stmtExpr.setBType(dynamicArgExpr.getBType());
                    args.add(this.rewriteExpr(stmtExpr));
                    continue;
                }
                BLangFieldBasedAccess fieldBasedAccessExpression = ASTBuilderUtil.createFieldAccessExpr(varargRef, ASTBuilderUtil.createIdentifier(param.pos, param.name.value));
                fieldBasedAccessExpression.setBType(param.type);
                args.add(fieldBasedAccessExpression);
                continue;
            }
            BLangLiteral indexExpr = this.rewriteExpr(this.createIntLiteral(varargIndex));
            BType memberAccessExprType = tupleTypedVararg ? ((BTupleType)varargType).getTupleTypes().get(varargIndex) : ((BArrayType)varargType).eType;
            args.add(this.types.addConversionExprIfRequired(ASTBuilderUtil.createMemberAccessExprNode(memberAccessExprType, varargRef, indexExpr), param.type));
            ++varargIndex;
        }
        if (!namedArgs.isEmpty()) {
            this.setFieldsForIncRecordLiterals(namedArgs, incRecordLiterals, incRecordParamAllowAdditionalFields);
        }
        iExpr.requiredArgs = args;
    }

    private void setFieldsForIncRecordLiterals(Map<String, BLangExpression> namedArgs, List<BLangRecordLiteral> incRecordLiterals, BLangRecordLiteral incRecordParamAllowAdditionalFields) {
        for (String name : namedArgs.keySet()) {
            boolean isAdditionalField = true;
            BLangNamedArgsExpression expr = (BLangNamedArgsExpression)namedArgs.get(name);
            for (BLangRecordLiteral recordLiteral : incRecordLiterals) {
                LinkedHashMap fields = ((BRecordType)Types.getImpliedType((BType)recordLiteral.getBType())).fields;
                if (!fields.containsKey(name) || Types.getImpliedType((BType)((BField)fields.get((Object)name)).type).tag == 50) continue;
                isAdditionalField = false;
                this.createAndAddRecordFieldForIncRecordLiteral(recordLiteral, expr);
                break;
            }
            if (!isAdditionalField) continue;
            this.createAndAddRecordFieldForIncRecordLiteral(incRecordParamAllowAdditionalFields, expr);
        }
    }

    private void createAndAddRecordFieldForIncRecordLiteral(BLangRecordLiteral recordLiteral, BLangNamedArgsExpression expr) {
        BLangSimpleVarRef varRef = new BLangSimpleVarRef();
        varRef.variableName = expr.name;
        BLangRecordLiteral.BLangRecordKeyValueField recordKeyValueField = ASTBuilderUtil.createBLangRecordKeyValue(varRef, expr.expr);
        recordLiteral.fields.add(recordKeyValueField);
    }

    private BLangBlockStmt getSafeErrorAssignment(Location location, BLangSimpleVarRef ref, BSymbol invokableSymbol, List<BType> equivalentErrorTypes, boolean isCheckPanicExpr) {
        final BType enclosingFuncReturnType = Types.getImpliedType(((BInvokableType)invokableSymbol.type).retType);
        Set<BType> returnTypeSet = enclosingFuncReturnType.tag == 21 ? ((BUnionType)enclosingFuncReturnType).getMemberTypes() : new LinkedHashSet<BType>(){
            {
                this.add(enclosingFuncReturnType);
            }
        };
        boolean returnOnError = equivalentErrorTypes.stream().allMatch(errorType -> returnTypeSet.stream().anyMatch(retType -> this.types.isAssignable((BType)errorType, (BType)retType)));
        String patternFailureCaseVarName = Names.GEN_VAR_PREFIX.value + "t_failure";
        BLangSimpleVariable errorVar = ASTBuilderUtil.createVariable(location, patternFailureCaseVarName, this.symTable.errorType, this.createTypeCastExpr(ref, this.symTable.errorType), new BVarSymbol(0L, Names.fromString(patternFailureCaseVarName), this.env.scope.owner.pkgID, this.symTable.errorType, this.env.scope.owner, location, SymbolOrigin.VIRTUAL));
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(location);
        BLangSimpleVariableDef errorVarDef = ASTBuilderUtil.createVariableDef(location, errorVar);
        blockStmt.addStatement(errorVarDef);
        BLangSimpleVarRef errorVarRef = ASTBuilderUtil.createVariableRef(location, errorVar.symbol);
        if (!isCheckPanicExpr && (returnOnError || this.onFailClause != null)) {
            BLangFail failStmt = (BLangFail)TreeBuilder.createFailNode();
            failStmt.pos = location;
            failStmt.expr = errorVarRef;
            blockStmt.addStatement(failStmt);
            if (returnOnError && this.shouldReturnErrors) {
                BLangReturn errorReturn = ASTBuilderUtil.createReturnStmt(location, this.rewrite(errorVarRef, this.env));
                errorReturn.desugared = true;
                failStmt.exprStmt = errorReturn;
            }
        } else {
            BLangPanic panicNode = (BLangPanic)TreeBuilder.createPanicNode();
            panicNode.pos = location;
            panicNode.expr = errorVarRef;
            blockStmt.addStatement(panicNode);
        }
        return blockStmt;
    }

    private BType getStructuredBindingPatternType(BLangVariable bindingPatternVariable) {
        if (NodeKind.TUPLE_VARIABLE == bindingPatternVariable.getKind()) {
            BLangTupleVariable tupleVariable = (BLangTupleVariable)bindingPatternVariable;
            ArrayList<BTupleMember> memberTypes = new ArrayList<BTupleMember>();
            for (int i = 0; i < tupleVariable.memberVariables.size(); ++i) {
                BType member = this.getStructuredBindingPatternType(tupleVariable.memberVariables.get(i));
                BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(member);
                memberTypes.add(new BTupleMember(member, varSymbol));
            }
            BTupleType tupleType = new BTupleType(this.symTable.typeEnv(), memberTypes);
            if (tupleVariable.restVariable != null) {
                BArrayType restArrayType = (BArrayType)this.getStructuredBindingPatternType(tupleVariable.restVariable);
                tupleType.restType = restArrayType.eType;
            }
            return tupleType;
        }
        if (NodeKind.RECORD_VARIABLE == bindingPatternVariable.getKind()) {
            BLangRecordVariable recordVariable = (BLangRecordVariable)bindingPatternVariable;
            BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(0L, Names.fromString("$anonRecordType$_" + this.recordCount++), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, recordVariable.pos, SymbolOrigin.VIRTUAL);
            recordSymbol.scope = new Scope(recordSymbol);
            LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
            ArrayList<BLangSimpleVariable> typeDefFields = new ArrayList<BLangSimpleVariable>();
            for (int i = 0; i < recordVariable.variableList.size(); ++i) {
                String fieldNameStr = recordVariable.variableList.get((int)i).key.value;
                Name fieldName = Names.fromString(fieldNameStr);
                BType fieldType = this.getStructuredBindingPatternType(recordVariable.variableList.get((int)i).valueBindingPattern);
                BVarSymbol fieldSymbol = new BVarSymbol(256L, fieldName, this.env.enclPkg.symbol.pkgID, fieldType, recordSymbol, bindingPatternVariable.pos, SymbolOrigin.VIRTUAL);
                fields.put(fieldName.value, new BField(fieldName, bindingPatternVariable.pos, fieldSymbol));
                typeDefFields.add(ASTBuilderUtil.createVariable(null, fieldNameStr, fieldType, null, fieldSymbol));
                recordSymbol.scope.define(fieldName, fieldSymbol);
            }
            BRecordType recordVarType = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)recordSymbol);
            recordVarType.fields = fields;
            recordVarType.restFieldType = recordVariable.restParam != null ? ((BRecordType)recordVariable.restParam.getBType()).restFieldType : this.symTable.anydataType;
            recordSymbol.type = recordVarType;
            recordVarType.tsymbol = recordSymbol;
            BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(typeDefFields, recordVarType, bindingPatternVariable.pos);
            TypeDefBuilderHelper.createTypeDefinitionForTSymbol(recordVarType, recordSymbol, recordTypeNode, this.env);
            return recordVarType;
        }
        if (NodeKind.ERROR_VARIABLE == bindingPatternVariable.getKind()) {
            BType detailType;
            BLangErrorVariable errorVariable = (BLangErrorVariable)bindingPatternVariable;
            BErrorTypeSymbol errorTypeSymbol = new BErrorTypeSymbol(294940L, 1L, Names.fromString("$anonErrorType$_" + this.errorCount++), this.env.enclPkg.symbol.pkgID, null, null, errorVariable.pos, SymbolOrigin.VIRTUAL);
            if ((errorVariable.detail == null || errorVariable.detail.isEmpty()) && errorVariable.restDetail != null) {
                detailType = this.symTable.detailType;
            } else {
                detailType = this.createDetailType(errorVariable.detail, errorVariable.restDetail, this.errorCount++, errorVariable.pos);
                BLangRecordTypeNode recordTypeNode = this.createRecordTypeNode(errorVariable, (BRecordType)detailType);
                TypeDefBuilderHelper.createTypeDefinitionForTSymbol(detailType, detailType.tsymbol, recordTypeNode, this.env);
            }
            BErrorType errorType = new BErrorType(this.symTable.typeEnv(), (BTypeSymbol)errorTypeSymbol, detailType);
            errorTypeSymbol.type = errorType;
            TypeDefBuilderHelper.createTypeDefinitionForTSymbol(errorType, errorTypeSymbol, this.createErrorTypeNode(errorType), this.env);
            return errorType;
        }
        return bindingPatternVariable.getBType();
    }

    private BLangRecordTypeNode createRecordTypeNode(BLangErrorVariable errorVariable, BRecordType detailType) {
        ArrayList<BLangSimpleVariable> fieldList = new ArrayList<BLangSimpleVariable>();
        for (BLangErrorVariable.BLangErrorDetailEntry field : errorVariable.detail) {
            BVarSymbol symbol = field.valueBindingPattern.symbol;
            if (symbol == null) {
                symbol = new BVarSymbol(1L, Names.fromString(field.key.value + "$"), this.env.enclPkg.packageID, this.symTable.pureType, null, field.valueBindingPattern.pos, SymbolOrigin.VIRTUAL);
            }
            BLangSimpleVariable fieldVar = ASTBuilderUtil.createVariable(field.valueBindingPattern.pos, symbol.name.value, field.valueBindingPattern.getBType(), field.valueBindingPattern.expr, symbol);
            fieldList.add(fieldVar);
        }
        return TypeDefBuilderHelper.createRecordTypeNode(fieldList, detailType, errorVariable.pos);
    }

    private BType createDetailType(List<BLangErrorVariable.BLangErrorDetailEntry> detail, BLangSimpleVariable restDetail, int errorNo, Location pos) {
        BRecordType detailRecordType = this.createAnonRecordType(pos);
        if (restDetail == null) {
            detailRecordType.sealed = true;
        }
        for (BLangErrorVariable.BLangErrorDetailEntry detailEntry : detail) {
            Name fieldName = this.names.fromIdNode(detailEntry.key);
            BType fieldType = this.getStructuredBindingPatternType(detailEntry.valueBindingPattern);
            BVarSymbol fieldSym = new BVarSymbol(1L, fieldName, detailRecordType.tsymbol.pkgID, fieldType, detailRecordType.tsymbol, detailEntry.key.pos, SymbolOrigin.VIRTUAL);
            detailRecordType.fields.put(fieldName.value, new BField(fieldName, detailEntry.key.pos, fieldSym));
            detailRecordType.tsymbol.scope.define(fieldName, fieldSym);
        }
        return detailRecordType;
    }

    private BRecordType createAnonRecordType(Location pos) {
        BRecordTypeSymbol detailRecordTypeSymbol = new BRecordTypeSymbol(163932L, 1L, Names.fromString(this.anonModelHelper.getNextRecordVarKey(this.env.enclPkg.packageID)), this.env.enclPkg.symbol.pkgID, null, null, pos, SymbolOrigin.VIRTUAL);
        detailRecordTypeSymbol.scope = new Scope(detailRecordTypeSymbol);
        BRecordType detailRecordType = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)detailRecordTypeSymbol);
        detailRecordType.restFieldType = this.symTable.anydataType;
        return detailRecordType;
    }

    BLangErrorType createErrorTypeNode(BErrorType errorType) {
        BLangErrorType errorTypeNode = (BLangErrorType)TreeBuilder.createErrorTypeNode();
        errorTypeNode.setBType(errorType);
        return errorTypeNode;
    }

    private BLangExpression createBinaryExpression(Location pos, BLangSimpleVarRef varRef, BLangExpression expression) {
        BLangBinaryExpr binaryExpr;
        if (NodeKind.GROUP_EXPR == expression.getKind()) {
            return this.createBinaryExpression(pos, varRef, ((BLangGroupExpr)expression).expression);
        }
        if (NodeKind.BINARY_EXPR == expression.getKind()) {
            binaryExpr = (BLangBinaryExpr)expression;
            BLangExpression lhsExpr = this.createBinaryExpression(pos, varRef, binaryExpr.lhsExpr);
            BLangExpression rhsExpr = this.createBinaryExpression(pos, varRef, binaryExpr.rhsExpr);
            binaryExpr = ASTBuilderUtil.createBinaryExpr(pos, lhsExpr, rhsExpr, this.symTable.booleanType, OperatorKind.OR, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.OR, this.symTable.booleanType, this.symTable.booleanType));
        } else {
            if (expression.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangSimpleVarRef)expression).variableName.value.equals(Names.IGNORE.value)) {
                BLangValueType anyType = (BLangValueType)TreeBuilder.createValueTypeNode();
                anyType.setBType(this.symTable.anyType);
                anyType.typeKind = TypeKind.ANY;
                return ASTBuilderUtil.createTypeTestExpr(pos, varRef, anyType);
            }
            binaryExpr = ASTBuilderUtil.createBinaryExpr(pos, varRef, expression, this.symTable.booleanType, OperatorKind.EQUAL, null);
            BSymbol opSymbol = this.symResolver.resolveBinaryOperator(OperatorKind.EQUAL, varRef.getBType(), expression.getBType());
            if (opSymbol == this.symTable.notFoundSymbol) {
                opSymbol = this.symResolver.getBinaryEqualityForTypeSets(OperatorKind.EQUAL, this.symTable.anydataType, expression.getBType(), binaryExpr, this.env);
            }
            binaryExpr.opSymbol = (BOperatorSymbol)opSymbol;
        }
        return binaryExpr;
    }

    private BLangIsLikeExpr createIsLikeExpression(Location pos, BLangExpression expr, BType type) {
        return ASTBuilderUtil.createIsLikeExpr(pos, expr, ASTBuilderUtil.createTypeNode(type), this.symTable.booleanType);
    }

    private BLangAssignment createAssignmentStmt(BLangSimpleVariable variable) {
        BLangSimpleVarRef varRef = (BLangSimpleVarRef)TreeBuilder.createSimpleVariableReferenceNode();
        varRef.pos = variable.pos;
        varRef.variableName = variable.name;
        varRef.symbol = variable.symbol;
        varRef.setBType(variable.getBType());
        BLangAssignment assignmentStmt = (BLangAssignment)TreeBuilder.createAssignmentNode();
        assignmentStmt.expr = variable.expr;
        assignmentStmt.pos = variable.pos;
        assignmentStmt.setVariable(varRef);
        return assignmentStmt;
    }

    private BLangAssignment createStructFieldUpdate(BLangFunction function, BLangSimpleVariable variable, BVarSymbol selfSymbol) {
        return this.createStructFieldUpdate(function, variable.expr, variable.symbol, variable.getBType(), selfSymbol, variable.name);
    }

    private BLangAssignment createStructFieldUpdate(BLangFunction function, BLangExpression expr, BVarSymbol fieldSymbol, BType fieldType, BVarSymbol selfSymbol, BLangIdentifier fieldName) {
        BLangSimpleVarRef selfVarRef = ASTBuilderUtil.createVariableRef(function.pos, selfSymbol);
        BLangFieldBasedAccess fieldAccess = ASTBuilderUtil.createFieldAccessExpr(selfVarRef, fieldName);
        fieldAccess.symbol = fieldSymbol;
        fieldAccess.setBType(fieldType);
        fieldAccess.isStoreOnCreation = true;
        BLangAssignment assignmentStmt = (BLangAssignment)TreeBuilder.createAssignmentNode();
        expr.pos = this.symTable.builtinPos;
        fieldName.pos = this.symTable.builtinPos;
        fieldSymbol.pos = this.symTable.builtinPos;
        assignmentStmt.expr = expr;
        assignmentStmt.pos = function.pos;
        assignmentStmt.setVariable(fieldAccess);
        SymbolEnv initFuncEnv = SymbolEnv.createFunctionEnv(function, function.symbol.scope, this.env);
        return this.rewrite(assignmentStmt, initFuncEnv);
    }

    private boolean safeNavigate(BLangAccessExpression accessExpr) {
        if (accessExpr.isLValue || accessExpr.expr == null) {
            return false;
        }
        if (accessExpr.errorSafeNavigation || accessExpr.nilSafeNavigation) {
            return true;
        }
        NodeKind kind = accessExpr.expr.getKind();
        if (kind == NodeKind.FIELD_BASED_ACCESS_EXPR || kind == NodeKind.INDEX_BASED_ACCESS_EXPR) {
            return this.safeNavigate((BLangAccessExpression)accessExpr.expr);
        }
        return false;
    }

    private BLangExpression rewriteSafeFieldBasedAccessExpr(BLangAccessExpression accessExpr) {
        Location pos = accessExpr.pos;
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(pos);
        String matchTempResultVarName = Names.GEN_VAR_PREFIX.value + "temp_result";
        BLangSimpleVariableDef tempResultVarDef = this.createVarDef(matchTempResultVarName, this.symTable.anyOrErrorType, null, pos);
        blockStmt.addStatement(tempResultVarDef);
        BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(pos, tempResultVarDef.var.symbol);
        this.createNestedIfForAccessExpression(blockStmt, accessExpr, tempResultVarRef, pos);
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, this.types.addConversionExprIfRequired(tempResultVarRef, accessExpr.getBType()));
        stmtExpr.setBType(accessExpr.getBType());
        return stmtExpr;
    }

    private BLangIf createNestedIfForAccessExpression(BLangBlockStmt blockStmt, BLangAccessExpression accessExpr, BLangSimpleVarRef tempResultVarRef, Location pos) {
        BLangExpression conditionExpr;
        NodeKind kind = accessExpr.expr.getKind();
        if (kind == NodeKind.FIELD_BASED_ACCESS_EXPR) {
            BLangIf ifStmt = this.createNestedIfForAccessExpression(blockStmt, (BLangAccessExpression)accessExpr.expr, tempResultVarRef, pos);
            blockStmt = ifStmt.body;
        } else {
            blockStmt.addStatement(ASTBuilderUtil.createAssignmentStmt(pos, tempResultVarRef, accessExpr.expr));
        }
        BLangType testTypeNode = null;
        if (accessExpr.errorSafeNavigation && accessExpr.nilSafeNavigation) {
            testTypeNode = this.getErrorOrNillTypeNode();
        } else if (accessExpr.errorSafeNavigation) {
            testTypeNode = this.getErrorTypeNode();
        } else if (accessExpr.nilSafeNavigation) {
            testTypeNode = this.getNillTypeNode();
        }
        if (testTypeNode == null) {
            conditionExpr = this.getBooleanLiteral(true);
        } else {
            BLangTypeTestExpr isNilOrErrorTest = this.createTypeCheckExpr(pos, tempResultVarRef, testTypeNode);
            isNilOrErrorTest.isNegation = true;
            isNilOrErrorTest.setBType(this.symTable.booleanType);
            conditionExpr = isNilOrErrorTest;
        }
        BType type = this.types.getSafeType(accessExpr.expr.getBType(), true, true);
        accessExpr.expr = this.types.addConversionExprIfRequired(tempResultVarRef, type);
        accessExpr.errorSafeNavigation = false;
        accessExpr.nilSafeNavigation = false;
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(this.symTable.builtinPos, tempResultVarRef, accessExpr);
        BLangBlockStmt ifBody = ASTBuilderUtil.createBlockStmt(this.symTable.builtinPos);
        ifBody.addStatement(assignmentStmt);
        BLangIf ifStmt = ASTBuilderUtil.createIfStmt(pos, blockStmt);
        ifStmt.setCondition(conditionExpr);
        ifStmt.body = ifBody;
        return ifStmt;
    }

    private BLangExpression rewriteSafeNavigationExpr(BLangAccessExpression accessExpr) {
        BType originalExprType = accessExpr.getBType();
        String matchTempResultVarName = Names.GEN_VAR_PREFIX.value + "temp_result";
        BLangSimpleVariable tempResultVar = ASTBuilderUtil.createVariable(accessExpr.pos, matchTempResultVarName, accessExpr.getBType(), null, new BVarSymbol(0L, Names.fromString(matchTempResultVarName), this.env.scope.owner.pkgID, accessExpr.getBType(), this.env.scope.owner, accessExpr.pos, SymbolOrigin.VIRTUAL));
        BLangSimpleVariableDef tempResultVarDef = ASTBuilderUtil.createVariableDef(accessExpr.pos, tempResultVar);
        BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(accessExpr.pos, tempResultVar.symbol);
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(accessExpr.pos);
        blockStmt.stmts.add(tempResultVarDef);
        this.handleSafeNavigation(blockStmt, accessExpr, accessExpr.getBType(), tempResultVar);
        BLangMatchStatement matchStmt = this.matchStmtStack.getLast();
        blockStmt.stmts.add(matchStmt);
        BLangStatementExpression stmtExpression = ASTBuilderUtil.createStatementExpression(blockStmt, tempResultVarRef);
        stmtExpression.setBType(originalExprType);
        this.matchStmtStack = new ArrayDeque<BLangMatchStatement>();
        this.accessExprStack = new ArrayDeque<BLangExpression>();
        this.successClause = null;
        this.safeNavigationAssignment = null;
        return stmtExpression;
    }

    private void handleSafeNavigation(BLangBlockStmt blockStmt, BLangAccessExpression accessExpr, BType type, BLangSimpleVariable tempResultVar) {
        if (accessExpr.expr == null) {
            return;
        }
        NodeKind kind = accessExpr.expr.getKind();
        if (kind == NodeKind.FIELD_BASED_ACCESS_EXPR || kind == NodeKind.INDEX_BASED_ACCESS_EXPR) {
            this.handleSafeNavigation(blockStmt, (BLangAccessExpression)accessExpr.expr, type, tempResultVar);
        }
        if (!accessExpr.errorSafeNavigation && !accessExpr.nilSafeNavigation) {
            BType originalType = Types.getImpliedType(accessExpr.originalType);
            if (this.isMapJson(originalType, false)) {
                accessExpr.setBType(BUnionType.create(this.symTable.typeEnv(), null, originalType, this.symTable.errorType));
            } else {
                accessExpr.setBType(originalType);
            }
            if (this.safeNavigationAssignment != null) {
                this.safeNavigationAssignment.expr = this.types.addConversionExprIfRequired(accessExpr, tempResultVar.getBType());
            }
            return;
        }
        BLangExpression matchExpr = accessExpr.expr;
        BLangSimpleVariableDef variableDef = this.createVarDef("$varDef$", matchExpr.getBType(), matchExpr, matchExpr.pos);
        BLangSimpleVarRef simpleVarRef = ASTBuilderUtil.createVariableRef(variableDef.pos, variableDef.var.symbol);
        accessExpr.expr = simpleVarRef;
        blockStmt.stmts.add(variableDef);
        Location pos = accessExpr.pos;
        BLangMatchStatement matchStmt = ASTBuilderUtil.createMatchStatement(simpleVarRef, pos);
        BType matchExprType = accessExpr.expr.getBType();
        boolean isAllTypesRecords = false;
        LinkedHashSet<BType> memTypes = new LinkedHashSet<BType>();
        BType referredType = Types.getImpliedType(matchExpr.getBType());
        if (referredType.tag == 21) {
            memTypes = new LinkedHashSet(((BUnionType)referredType).getMemberTypes());
            isAllTypesRecords = this.isAllTypesAreRecordsInUnion(memTypes);
        }
        if (accessExpr.nilSafeNavigation) {
            matchStmt.addMatchClause(this.getMatchNullClause(matchExpr, tempResultVar));
            matchStmt.setBType(type);
            memTypes.remove(this.symTable.nilType);
        }
        if (accessExpr.errorSafeNavigation) {
            matchStmt.addMatchClause(this.getMatchErrorClause(matchExpr, tempResultVar));
            matchStmt.setBType(type);
            matchStmt.pos = pos;
            memTypes.remove(this.symTable.errorType);
        }
        BLangMatchClause successClause = null;
        Name field = this.getFieldName(accessExpr);
        if (field == Names.EMPTY) {
            successClause = this.getSuccessPatternClause(matchExprType, matchExpr, accessExpr, tempResultVar, accessExpr.errorSafeNavigation);
            matchStmt.addMatchClause(successClause);
            this.pushToMatchStatementStack(matchStmt, successClause, pos);
            return;
        }
        if (isAllTypesRecords) {
            for (BType memberType : memTypes) {
                BRecordType recordType = (BRecordType)Types.getImpliedType(memberType);
                if (!recordType.fields.containsKey(field.value) && recordType.sealed) continue;
                successClause = this.getSuccessPatternClause(memberType, matchExpr, accessExpr, tempResultVar, accessExpr.errorSafeNavigation);
                matchStmt.addMatchClause(successClause);
            }
            matchStmt.addMatchClause(this.getMatchAllAndNilReturnClause(matchExpr, tempResultVar));
            this.pushToMatchStatementStack(matchStmt, successClause, pos);
            return;
        }
        successClause = this.getSuccessPatternClause(matchExprType, matchExpr, accessExpr, tempResultVar, accessExpr.errorSafeNavigation);
        matchStmt.addMatchClause(successClause);
        this.pushToMatchStatementStack(matchStmt, successClause, pos);
    }

    private boolean isMapJson(BType originalType, boolean fromMap) {
        originalType = Types.getImpliedType(originalType);
        return originalType.tag == 16 && this.isMapJson(((BMapType)originalType).getConstraint(), true) || originalType.tag == 7 && fromMap;
    }

    private void pushToMatchStatementStack(BLangMatchStatement matchStmt, BLangMatchClause successClause, Location pos) {
        this.matchStmtStack.push(matchStmt);
        if (this.successClause != null) {
            this.successClause.blockStmt = ASTBuilderUtil.createBlockStmt(pos, this.env.scope, Lists.of(matchStmt));
        }
        this.successClause = successClause;
    }

    private Name getFieldName(BLangAccessExpression accessExpr) {
        BLangExpression indexBasedExpression;
        Name field = Names.EMPTY;
        if (accessExpr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR) {
            field = new Name(((BLangFieldBasedAccess)accessExpr).field.value);
        } else if (accessExpr.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR && (indexBasedExpression = ((BLangIndexBasedAccess)accessExpr).indexExpr).getKind() == NodeKind.LITERAL) {
            field = new Name(((BLangLiteral)indexBasedExpression).value.toString());
        }
        return field;
    }

    private boolean isAllTypesAreRecordsInUnion(LinkedHashSet<BType> memTypes) {
        for (BType memType : memTypes) {
            int typeTag = Types.getImpliedType((BType)memType).tag;
            if (typeTag == 12 || typeTag == 29 || typeTag == 10) continue;
            return false;
        }
        return true;
    }

    private BLangMatchClause getMatchErrorClause(BLangExpression matchExpr, BLangSimpleVariable tempResultVar) {
        String errorPatternVarName = Names.GEN_VAR_PREFIX.value + "t_match_error";
        Location pos = matchExpr.pos;
        BVarSymbol errorPatternVarSymbol = new BVarSymbol(0L, Names.fromString(errorPatternVarName), this.env.scope.owner.pkgID, this.symTable.anyOrErrorType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangCaptureBindingPattern captureBindingPattern = ASTBuilderUtil.createCaptureBindingPattern(errorPatternVarSymbol, errorPatternVarName);
        BLangVarBindingPatternMatchPattern varBindingPatternMatchPattern = ASTBuilderUtil.createVarBindingPatternMatchPattern(captureBindingPattern, matchExpr);
        BLangSimpleVarRef assignmentRhsExpr = ASTBuilderUtil.createVariableRef(pos, errorPatternVarSymbol);
        BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(pos, tempResultVar.symbol);
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(pos, tempResultVarRef, assignmentRhsExpr);
        BLangBlockStmt clauseBody = ASTBuilderUtil.createBlockStmt(pos, this.env.scope, Lists.of(assignmentStmt));
        BLangTypeTestExpr matchGuard = ASTBuilderUtil.createTypeTestExpr(pos, assignmentRhsExpr, this.getErrorTypeNode());
        matchGuard.setBType(this.symTable.booleanType);
        return ASTBuilderUtil.createMatchClause(matchExpr, clauseBody, matchGuard, varBindingPatternMatchPattern);
    }

    private BLangMatchClause getMatchNullClause(BLangExpression matchExpr, BLangSimpleVariable tempResultVar) {
        String nullPatternVarName = Names.GEN_VAR_PREFIX.value + "t_match_null";
        Location pos = matchExpr.pos;
        BVarSymbol nullPatternVarSymbol = new BVarSymbol(0L, Names.fromString(nullPatternVarName), this.env.scope.owner.pkgID, this.symTable.anyOrErrorType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangCaptureBindingPattern captureBindingPattern = ASTBuilderUtil.createCaptureBindingPattern(nullPatternVarSymbol, nullPatternVarName);
        BLangVarBindingPatternMatchPattern varBindingPatternMatchPattern = ASTBuilderUtil.createVarBindingPatternMatchPattern(captureBindingPattern, matchExpr);
        BLangSimpleVarRef assignmentRhsExpr = ASTBuilderUtil.createVariableRef(pos, nullPatternVarSymbol);
        BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(pos, tempResultVar.symbol);
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(pos, tempResultVarRef, assignmentRhsExpr);
        BLangBlockStmt clauseBody = ASTBuilderUtil.createBlockStmt(pos, this.env.scope, Lists.of(assignmentStmt));
        BLangTypeTestExpr matchGuard = ASTBuilderUtil.createTypeTestExpr(pos, assignmentRhsExpr, this.getNillTypeNode());
        matchGuard.setBType(this.symTable.booleanType);
        return ASTBuilderUtil.createMatchClause(matchExpr, clauseBody, matchGuard, varBindingPatternMatchPattern);
    }

    private BLangMatchClause getMatchAllAndNilReturnClause(BLangExpression matchExpr, BLangSimpleVariable tempResultVar) {
        Location pos = matchExpr.pos;
        BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(pos, tempResultVar.symbol);
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(pos, tempResultVarRef, ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, Names.NIL_VALUE.value));
        BLangBlockStmt clauseBody = ASTBuilderUtil.createBlockStmt(pos, this.env.scope, Lists.of(assignmentStmt));
        BLangWildCardMatchPattern wildCardMatchPattern = ASTBuilderUtil.createWildCardMatchPattern(matchExpr);
        wildCardMatchPattern.setBType(this.symTable.anyType);
        return ASTBuilderUtil.createMatchClause(matchExpr, clauseBody, null, wildCardMatchPattern);
    }

    private BLangMatchClause getSuccessPatternClause(BType type, BLangExpression matchExpr, BLangAccessExpression accessExpr, BLangSimpleVariable tempResultVar, boolean liftError) {
        type = this.types.getSafeType(type, true, liftError);
        String successPatternVarName = Names.GEN_VAR_PREFIX.value + "t_match_success";
        Location pos = accessExpr.pos;
        BVarSymbol successPatternSymbol = Types.getImpliedType((BType)type).tag == 17 ? new BInvokableSymbol(52L, 0L, Names.fromString(successPatternVarName), this.env.scope.owner.pkgID, (BType)this.symTable.anyOrErrorType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL) : new BVarSymbol(0L, Names.fromString(successPatternVarName), this.env.scope.owner.pkgID, this.symTable.anyOrErrorType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable successPatternVar = ASTBuilderUtil.createVariable(accessExpr.pos, successPatternVarName, type, null, successPatternSymbol);
        BLangSimpleVarRef successPatternVarRef = ASTBuilderUtil.createVariableRef(accessExpr.pos, successPatternVar.symbol);
        BLangCaptureBindingPattern captureBindingPattern = ASTBuilderUtil.createCaptureBindingPattern(successPatternSymbol, successPatternVarName);
        BLangVarBindingPatternMatchPattern varBindingPatternMatchPattern = ASTBuilderUtil.createVarBindingPatternMatchPattern(captureBindingPattern, matchExpr);
        BLangAccessExpression tempAccessExpr = this.nodeCloner.cloneNode(accessExpr);
        if (accessExpr.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
            ((BLangIndexBasedAccess)tempAccessExpr).indexExpr = ((BLangIndexBasedAccess)accessExpr).indexExpr;
        }
        if (accessExpr instanceof BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess) {
            ((BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess)tempAccessExpr).symbol = ((BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess)accessExpr).symbol;
        }
        tempAccessExpr.expr = this.types.addConversionExprIfRequired(successPatternVarRef, type);
        tempAccessExpr.errorSafeNavigation = false;
        tempAccessExpr.nilSafeNavigation = false;
        accessExpr.cloneRef = null;
        if (TypeTags.isXMLTypeTag(Types.getImpliedType((BType)tempAccessExpr.expr.getBType()).tag)) {
            tempAccessExpr.setBType(BUnionType.create(this.symTable.typeEnv(), null, accessExpr.originalType, this.symTable.errorType, this.symTable.nilType));
        } else {
            tempAccessExpr.setBType(accessExpr.originalType);
        }
        tempAccessExpr.optionalFieldAccess = accessExpr.optionalFieldAccess;
        BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(accessExpr.pos, tempResultVar.symbol);
        BLangExpression assignmentRhsExpr = this.types.addConversionExprIfRequired(tempAccessExpr, tempResultVarRef.getBType());
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(accessExpr.pos, tempResultVarRef, assignmentRhsExpr);
        BLangBlockStmt clauseBody = ASTBuilderUtil.createBlockStmt(accessExpr.pos, this.env.scope, Lists.of(assignmentStmt));
        BLangTypeTestExpr matchGuard = ASTBuilderUtil.createTypeTestExpr(pos, successPatternVarRef, this.createTypeNode(type));
        matchGuard.setBType(this.symTable.booleanType);
        return ASTBuilderUtil.createMatchClause(matchExpr, clauseBody, matchGuard, varBindingPatternMatchPattern);
    }

    BLangValueType getNillTypeNode() {
        BLangValueType nillTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        nillTypeNode.typeKind = TypeKind.NIL;
        nillTypeNode.setBType(this.symTable.nilType);
        return nillTypeNode;
    }

    BLangValueType createTypeNode(BType type) {
        BLangValueType typeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        typeNode.typeKind = type.getKind();
        typeNode.setBType(type);
        return typeNode;
    }

    private BLangValueExpression cloneExpression(BLangExpression expr) {
        return switch (expr.getKind()) {
            case NodeKind.SIMPLE_VARIABLE_REF -> ASTBuilderUtil.createVariableRef(expr.pos, ((BLangSimpleVarRef)expr).symbol);
            case NodeKind.FIELD_BASED_ACCESS_EXPR, NodeKind.INDEX_BASED_ACCESS_EXPR -> this.cloneAccessExpr((BLangAccessExpression)expr);
            default -> throw new IllegalStateException();
        };
    }

    private BLangAccessExpression cloneAccessExpr(BLangAccessExpression originalAccessExpr) {
        if (originalAccessExpr.expr == null) {
            return originalAccessExpr;
        }
        NodeKind kind = originalAccessExpr.expr.getKind();
        BLangValueExpression varRef = kind == NodeKind.FIELD_BASED_ACCESS_EXPR || kind == NodeKind.INDEX_BASED_ACCESS_EXPR ? this.cloneAccessExpr((BLangAccessExpression)originalAccessExpr.expr) : this.cloneExpression(originalAccessExpr.expr);
        varRef.setBType(this.types.getSafeType(originalAccessExpr.expr.getBType(), true, false));
        BLangAccessExpression accessExpr = switch (originalAccessExpr.getKind()) {
            case NodeKind.FIELD_BASED_ACCESS_EXPR -> ASTBuilderUtil.createFieldAccessExpr(varRef, ((BLangFieldBasedAccess)originalAccessExpr).field);
            case NodeKind.INDEX_BASED_ACCESS_EXPR -> ASTBuilderUtil.createIndexAccessExpr(varRef, ((BLangIndexBasedAccess)originalAccessExpr).indexExpr);
            default -> throw new IllegalStateException();
        };
        accessExpr.originalType = originalAccessExpr.originalType;
        accessExpr.pos = originalAccessExpr.pos;
        accessExpr.isLValue = originalAccessExpr.isLValue;
        accessExpr.symbol = originalAccessExpr.symbol;
        accessExpr.errorSafeNavigation = false;
        accessExpr.nilSafeNavigation = false;
        accessExpr.setBType(originalAccessExpr.originalType);
        return accessExpr;
    }

    private BLangBinaryExpr getModifiedIntRangeStartExpr(BLangExpression expr) {
        BLangLiteral constOneLiteral = ASTBuilderUtil.createLiteral(expr.pos, this.symTable.intType, 1L);
        return ASTBuilderUtil.createBinaryExpr(expr.pos, expr, constOneLiteral, this.symTable.intType, OperatorKind.ADD, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.ADD, this.symTable.intType, this.symTable.intType));
    }

    private BLangBinaryExpr getModifiedIntRangeEndExpr(BLangExpression expr) {
        BLangLiteral constOneLiteral = ASTBuilderUtil.createLiteral(expr.pos, this.symTable.intType, 1L);
        return ASTBuilderUtil.createBinaryExpr(expr.pos, expr, constOneLiteral, this.symTable.intType, OperatorKind.SUB, (BOperatorSymbol)this.symResolver.resolveBinaryOperator(OperatorKind.SUB, this.symTable.intType, this.symTable.intType));
    }

    BLangLiteral getBooleanLiteral(boolean value) {
        BLangLiteral literal = (BLangLiteral)TreeBuilder.createLiteralExpression();
        literal.value = value;
        literal.setBType(this.symTable.booleanType);
        literal.pos = this.symTable.builtinPos;
        return literal;
    }

    private BLangFunction createInitFunctionForClassDefn(BLangClassDefinition classDefinition, SymbolEnv env) {
        BType returnType = this.symTable.nilType;
        if (classDefinition.initFunction != null) {
            returnType = classDefinition.initFunction.getBType().getReturnType();
        }
        BLangFunction initFunction = TypeDefBuilderHelper.createInitFunctionForStructureType(this.symTable.typeEnv(), classDefinition.symbol, env, this.names, Names.GENERATED_INIT_SUFFIX, classDefinition.getBType(), returnType);
        BObjectTypeSymbol typeSymbol = (BObjectTypeSymbol)classDefinition.getBType().tsymbol;
        typeSymbol.generatedInitializerFunc = new BAttachedFunction(Names.GENERATED_INIT_SUFFIX, initFunction.symbol, (BInvokableType)initFunction.getBType(), null);
        classDefinition.generatedInitFunction = initFunction;
        initFunction.returnTypeNode.setBType(returnType);
        return initFunction;
    }

    private void visitBinaryLogicalExpr(BLangBinaryExpr binaryExpr) {
        BLangSimpleVariableDef resultVarDef = this.createVarDef("$result$", binaryExpr.getBType(), null, this.symTable.builtinPos);
        BLangBlockStmt thenBody = ASTBuilderUtil.createBlockStmt(binaryExpr.pos);
        BLangBlockStmt elseBody = ASTBuilderUtil.createBlockStmt(binaryExpr.pos);
        BLangSimpleVarRef thenResultVarRef = ASTBuilderUtil.createVariableRef(this.symTable.builtinPos, resultVarDef.var.symbol);
        BLangExpression thenResult = binaryExpr.opKind == OperatorKind.AND ? binaryExpr.rhsExpr : this.getBooleanLiteral(true);
        BLangAssignment thenAssignment = ASTBuilderUtil.createAssignmentStmt(binaryExpr.pos, thenResultVarRef, thenResult);
        thenBody.addStatement(thenAssignment);
        BLangSimpleVarRef elseResultVarRef = ASTBuilderUtil.createVariableRef(this.symTable.builtinPos, resultVarDef.var.symbol);
        BLangExpression elseResult = binaryExpr.opKind == OperatorKind.AND ? this.getBooleanLiteral(false) : binaryExpr.rhsExpr;
        BLangAssignment elseAssignment = ASTBuilderUtil.createAssignmentStmt(binaryExpr.pos, elseResultVarRef, elseResult);
        elseBody.addStatement(elseAssignment);
        BLangSimpleVarRef resultVarRef = ASTBuilderUtil.createVariableRef(binaryExpr.pos, resultVarDef.var.symbol);
        BLangIf ifElse = ASTBuilderUtil.createIfElseStmt(binaryExpr.pos, binaryExpr.lhsExpr, thenBody, elseBody);
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(binaryExpr.pos, Lists.of(resultVarDef, ifElse));
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, resultVarRef);
        stmtExpr.setBType(binaryExpr.getBType());
        this.result = this.rewriteExpr(stmtExpr);
    }

    protected boolean isMappingOrObjectConstructorOrObjInit(BLangExpression expression) {
        return switch (expression.getKind()) {
            case NodeKind.TYPE_INIT_EXPR, NodeKind.RECORD_LITERAL_EXPR, NodeKind.OBJECT_CTOR_EXPRESSION -> true;
            case NodeKind.CHECK_EXPR -> this.isMappingOrObjectConstructorOrObjInit(((BLangCheckedExpr)expression).expr);
            case NodeKind.TYPE_CONVERSION_EXPR -> this.isMappingOrObjectConstructorOrObjInit(((BLangTypeConversionExpr)expression).expr);
            default -> false;
        };
    }

    private BType getRestType(BInvokableSymbol invokableSymbol) {
        if (invokableSymbol != null && invokableSymbol.restParam != null) {
            return invokableSymbol.restParam.type;
        }
        return null;
    }

    private BType getRestType(BLangFunction function) {
        if (function != null && function.restParam != null) {
            return function.restParam.getBType();
        }
        return null;
    }

    private BVarSymbol getRestSymbol(BLangFunction function) {
        if (function != null && function.restParam != null) {
            return function.restParam.symbol;
        }
        return null;
    }

    private boolean isComputedKey(RecordLiteralNode.RecordField field) {
        if (!field.isKeyValueField()) {
            return false;
        }
        return ((BLangRecordLiteral.BLangRecordKeyValueField)field).key.computedKey;
    }

    private BLangRecordLiteral rewriteMappingConstructor(BLangRecordLiteral mappingConstructorExpr) {
        List<RecordLiteralNode.RecordField> fields = mappingConstructorExpr.fields;
        BType type = mappingConstructorExpr.getBType();
        Location pos = mappingConstructorExpr.pos;
        ArrayList<RecordLiteralNode.RecordField> rewrittenFields = new ArrayList<RecordLiteralNode.RecordField>(fields.size());
        for (RecordLiteralNode.RecordField field : fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                BLangRecordLiteral.BLangRecordKey key = keyValueField.key;
                BLangExpression origKey = key.expr;
                BLangExpression keyExpr = key.computedKey ? origKey : (origKey.getKind() == NodeKind.SIMPLE_VARIABLE_REF ? this.createStringLiteral(pos, Utils.unescapeJava((String)((BLangSimpleVarRef)origKey).variableName.value)) : (BLangLiteral)origKey);
                BLangRecordLiteral.BLangRecordKeyValueField rewrittenField = ASTBuilderUtil.createBLangRecordKeyValue(this.rewriteExpr(keyExpr), this.rewriteExpr(keyValueField.valueExpr));
                rewrittenField.pos = keyValueField.pos;
                rewrittenField.key.pos = key.pos;
                rewrittenFields.add(rewrittenField);
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangSimpleVarRef varRefField = (BLangSimpleVarRef)((Object)field);
                rewrittenFields.add(ASTBuilderUtil.createBLangRecordKeyValue(this.rewriteExpr(this.createStringLiteral(pos, Utils.unescapeJava((String)varRefField.variableName.value))), this.rewriteExpr(varRefField)));
                continue;
            }
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOpField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            spreadOpField.expr = this.rewriteExpr(spreadOpField.expr);
            rewrittenFields.add(spreadOpField);
        }
        fields.clear();
        return new BLangRecordLiteral.BLangMapLiteral(pos, type, rewrittenFields);
    }

    protected void addTransactionInternalModuleImport() {
        if (!this.env.enclPkg.packageID.equals(PackageID.TRANSACTION_INTERNAL)) {
            BLangImportPackage importDcl = (BLangImportPackage)TreeBuilder.createImportPackageNode();
            ArrayList<BLangIdentifier> pkgNameComps = new ArrayList<BLangIdentifier>();
            pkgNameComps.add(ASTBuilderUtil.createIdentifier(this.env.enclPkg.pos, Names.TRANSACTION.value));
            importDcl.pkgNameComps = pkgNameComps;
            importDcl.pos = this.env.enclPkg.symbol.pos;
            importDcl.orgName = ASTBuilderUtil.createIdentifier(this.env.enclPkg.pos, Names.BALLERINA_INTERNAL_ORG.value);
            importDcl.alias = ASTBuilderUtil.createIdentifier(this.env.enclPkg.pos, "trx");
            importDcl.version = ASTBuilderUtil.createIdentifier(this.env.enclPkg.pos, "");
            importDcl.symbol = this.symTable.internalTransactionModuleSymbol;
            this.env.enclPkg.imports.add(importDcl);
            this.env.enclPkg.symbol.imports.add(importDcl.symbol);
        }
    }

    private void createMapFunctionForStepExpr(BLangXMLNavigationAccess xmlNavigation, List<BLangXMLStepExtend> extensions) {
        Location pos = xmlNavigation.pos;
        ArrayList<BLangExpression> filters = this.expandFilters(xmlNavigation.filters);
        List<BLangExpression> args = xmlNavigation.navAccessType == XMLNavigationAccess.NavAccessType.DESCENDANTS ? List.of(this.createArrowFunctionForNavigation(pos, extensions, XML_GET_DESCENDANTS, filters)) : List.of(this.createArrowFunctionForNavigation(pos, extensions, XML_INTERNAL_CHILDREN, filters));
        BLangInvocation elements = this.createLanglibXMLInvocation(pos, XML_ELEMENTS, xmlNavigation.expr, Collections.emptyList(), Collections.emptyList());
        BLangInvocation invocationNode = this.createLanglibXMLInvocation(pos, XML_MAP, elements, args, Collections.emptyList());
        this.result = this.rewriteExpr(invocationNode);
    }

    public BLangLambdaFunction createArrowFunctionForNavigation(Location pos, List<BLangXMLStepExtend> extensions, String func, List<BLangExpression> filters) {
        BVarSymbol symbol;
        BLangPackage enclPkg = this.env.enclPkg;
        PackageID pkgID = enclPkg.packageID;
        BType xmlType = this.symTable.xmlType;
        BXMLSubType xmlElementType = this.symTable.xmlElementType;
        BLangArrowFunction arrowFunction = (BLangArrowFunction)TreeBuilder.createArrowFunctionNode();
        arrowFunction.pos = pos;
        arrowFunction.functionName = ASTBuilderUtil.createIdentifier(pos, this.anonymousModelHelper.getNextAnonymousFunctionKey(pkgID));
        BInvokableTypeSymbol invokableTypeSymbol = Symbols.createInvokableTypeSymbol(33587228L, 1L, pkgID, xmlType, enclPkg.symbol.owner, pos, SymbolOrigin.VIRTUAL);
        arrowFunction.funcType = new BInvokableType(this.symTable.typeEnv(), List.of(xmlElementType), xmlType, invokableTypeSymbol);
        BSymbol owner = this.env.scope.owner;
        String parameterName = "$element$";
        BLangSimpleVariable param = (BLangSimpleVariable)TreeBuilder.createSimpleVariableNode();
        param.pos = pos;
        param.setName(ASTBuilderUtil.createIdentifier(pos, parameterName));
        param.symbol = symbol = new BVarSymbol(0L, Names.fromString(parameterName), owner.pkgID, xmlElementType, owner, pos, SymbolOrigin.SOURCE);
        param.typeNode = ASTBuilderUtil.createTypeNode(xmlElementType);
        param.setBType(xmlElementType);
        arrowFunction.params.add(param);
        BLangSimpleVarRef varRef = (BLangSimpleVarRef)TreeBuilder.createSimpleVariableReferenceNode();
        varRef.pos = pos;
        varRef.variableName = ASTBuilderUtil.createIdentifier(pos, parameterName);
        varRef.symbol = symbol;
        varRef.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        varRef.setBType(xmlElementType);
        BLangExpression expression = this.createLanglibXMLInvocation(pos, func, varRef, Collections.emptyList(), Collections.emptyList());
        expression = this.rewriteExpr(expression);
        if (filters.size() > 0) {
            expression = this.createLanglibXMLInvocation(pos, XML_INTERNAL_GET_ELEMENTS, expression, Collections.emptyList(), filters);
            expression = this.rewriteExpr(expression);
        }
        expression = this.createExpressionForExtensions(extensions, arrowFunction, expression);
        arrowFunction.body = new BLangExprFunctionBody();
        arrowFunction.body.expr = expression;
        arrowFunction.body.pos = arrowFunction.body.expr.pos;
        this.result = this.rewrite(arrowFunction, this.env);
        return (BLangLambdaFunction)this.result;
    }

    private BLangExpression createExpressionForExtensions(List<BLangXMLStepExtend> extensions, BLangArrowFunction arrowFunction, BLangExpression expression) {
        for (BLangXMLStepExtend extension : extensions) {
            switch (extension.getKind()) {
                case XML_STEP_INDEXED_EXTEND: {
                    expression = this.createExpressionForIndexedStepExtend(arrowFunction, expression, (BLangXMLIndexedStepExtend)extension);
                    break;
                }
                case XML_STEP_FILTER_EXTEND: {
                    expression = this.createExpressionForFilterStepExtend(expression, (BLangXMLFilterStepExtend)extension);
                    break;
                }
                case XML_STEP_METHOD_CALL_EXTEND: {
                    expression = this.createExpressionForMethodCallStepExtend(arrowFunction, expression, (BLangXMLMethodCallStepExtend)extension);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid xml step extension: " + String.valueOf((Object)extension.getKind()));
                }
            }
            expression.setBType(this.symTable.xmlType);
        }
        return expression;
    }

    private BLangExpression createExpressionForMethodCallStepExtend(BLangArrowFunction arrowFunction, BLangExpression expression, BLangXMLMethodCallStepExtend methodCallStepExtend) {
        BLangInvocation invocation = methodCallStepExtend.invocation;
        if (invocation.requiredArgs.size() > 0) {
            invocation.requiredArgs.remove(0);
        }
        for (BLangExpression arg : invocation.requiredArgs) {
            Desugar.markAndAddPossibleClosureVarsToArrowFunction(arrowFunction, arg);
        }
        expression = this.createLanglibXMLInvocation(methodCallStepExtend.pos, invocation.name.value, expression, invocation.requiredArgs, invocation.restArgs);
        expression = this.rewrite(expression, this.env);
        return this.types.addConversionExprIfRequired(expression, this.symTable.xmlType);
    }

    private BLangExpression createExpressionForFilterStepExtend(BLangExpression expression, BLangXMLFilterStepExtend filterStepExtend) {
        ArrayList<BLangExpression> filterExtensions = this.expandFilters(filterStepExtend.filters);
        return this.createLanglibXMLInvocation(filterStepExtend.pos, XML_INTERNAL_GET_ELEMENTS, expression, Collections.emptyList(), filterExtensions);
    }

    private BLangExpression createExpressionForIndexedStepExtend(BLangArrowFunction arrowFunction, BLangExpression expression, BLangXMLIndexedStepExtend indexedStepExtend) {
        BLangExpression indexExpr = indexedStepExtend.indexExpr;
        Desugar.markAndAddPossibleClosureVarsToArrowFunction(arrowFunction, indexExpr);
        BLangIndexBasedAccess indexAccessExpr = ASTBuilderUtil.createIndexAccessExpr(expression, indexExpr);
        indexAccessExpr.pos = indexedStepExtend.pos;
        return indexAccessExpr;
    }

    private static void markAndAddPossibleClosureVarsToArrowFunction(BLangArrowFunction arrFunction, BLangExpression expression) {
        if (expression.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return;
        }
        BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)expression;
        simpleVarRef.symbol.closure = true;
        arrFunction.closureVarSymbols.add(new ClosureVarSymbol(simpleVarRef.symbol, simpleVarRef.pos));
    }

    private void clearGlobalVariables() {
        this.typedescList = null;
    }

    private BLangSimpleVariableDef createGeneratorVariableDefinition(BLangNaturalExpression naturalExpression, String varName, Location pos) {
        BVarSymbol generatorVarSymbol = new BVarSymbol(0L, Names.fromString(varName), this.env.scope.owner.pkgID, this.symTable.naturalGeneratorType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable generatorVariable = ASTBuilderUtil.createVariable(pos, varName, this.symTable.naturalGeneratorType, naturalExpression.arguments.getFirst(), generatorVarSymbol);
        return ASTBuilderUtil.createVariableDef(pos, generatorVariable);
    }

    private BLangInvocation createGeneratorGenerateCall(Location pos, BLangSimpleVariableDef generatorVariableDef, BLangNaturalExpression naturalExpression, BType exprType) {
        BType nonErrorType = this.types.getSafeType(exprType, false, true);
        BTypedescType typedescType = new BTypedescType(this.symTable.typeEnv(), nonErrorType, this.symTable.typeDesc.tsymbol);
        BVarSymbol generatorVarSymbol = generatorVariableDef.var.symbol;
        BLangSimpleVarRef generatorVarRef = ASTBuilderUtil.createVariableRef(pos, generatorVarSymbol);
        BLangIdentifier generateIdentifier = ASTBuilderUtil.createIdentifier(pos, GENERATE);
        BInvokableSymbol generateMethodSymbol = this.getObjectMethod((BObjectType)((BObjectType)Types.getImpliedType((BType)this.symTable.naturalGeneratorType)), (String)GENERATE).symbol;
        BLangInvocation generateCall = (BLangInvocation)TreeBuilder.createInvocationNode();
        generateCall.pos = pos;
        generateCall.name = generateIdentifier;
        generateCall.expr = generatorVarRef;
        generateCall.requiredArgs = Lists.of(this.createPromptRawTemplate(naturalExpression), ASTBuilderUtil.createTypedescExpr(pos, typedescType, nonErrorType));
        generateCall.argExprs = generateCall.requiredArgs;
        generateCall.symbol = generateMethodSymbol;
        generateCall.setBType(exprType);
        return generateCall;
    }

    private BLangRawTemplateLiteral createPromptRawTemplate(BLangNaturalExpression naturalExpression) {
        Location pos = naturalExpression.pos;
        ArrayList<BLangLiteral> updatedStrings = new ArrayList<BLangLiteral>();
        ArrayList<BLangExpression> updatedInsertions = new ArrayList<BLangExpression>();
        List<BLangLiteral> strings = naturalExpression.strings;
        List<BLangExpression> insertions = naturalExpression.insertions;
        int insertionsSize = insertions.size();
        for (int i = 0; i < strings.size(); ++i) {
            BLangLiteral literal = strings.get(i);
            String text = (String)literal.value;
            String updatedText = text.replace("\\}", "}");
            if (text.equals(updatedText = updatedText.replace("`", ESCAPED_BACKTICK))) {
                updatedStrings.add(literal);
            } else {
                String[] split = updatedText.split(ESCAPED_BACKTICK);
                int length = split.length;
                for (int j = 0; j < length - 1; ++j) {
                    String part = split[j];
                    updatedStrings.add(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, part));
                    updatedInsertions.add(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, "`"));
                }
                updatedStrings.add(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, split[length - 1]));
                if (updatedText.endsWith(ESCAPED_BACKTICK)) {
                    updatedInsertions.add(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, "`"));
                }
            }
            if (i >= insertionsSize) continue;
            updatedInsertions.add(insertions.get(i));
        }
        return ASTBuilderUtil.createRawTemplateExpression(pos, this.symResolver.lookupPossibleMemberSymbol((Scope)this.symTable.langNaturalModuleSymbol.scope, (Name)Names.fromString((String)"Prompt"), (long)32796L).type, updatedStrings, updatedInsertions);
    }
}

