/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.projects.ProjectKind;
import java.util.ArrayList;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class ObservabilityDesugar {
    private static final CompilerContext.Key<ObservabilityDesugar> OBSERVE_DESUGAR_KEY = new CompilerContext.Key();
    private final PackageCache packageCache;

    public static ObservabilityDesugar getInstance(CompilerContext context) {
        ObservabilityDesugar desugar = context.get(OBSERVE_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new ObservabilityDesugar(context);
        }
        return desugar;
    }

    private ObservabilityDesugar(CompilerContext context) {
        context.put(OBSERVE_DESUGAR_KEY, this);
        this.packageCache = PackageCache.getInstance(context);
    }

    void addObserveInternalModuleImport(BLangPackage pkgNode) {
        if (pkgNode.moduleContextDataHolder != null && pkgNode.moduleContextDataHolder.isObservabiltyIncluded() && !pkgNode.moduleContextDataHolder.projectKind().equals((Object)ProjectKind.BALA_PROJECT)) {
            BLangImportPackage importDcl = (BLangImportPackage)TreeBuilder.createImportPackageNode();
            ArrayList<BLangIdentifier> pkgNameComps = new ArrayList<BLangIdentifier>();
            pkgNameComps.add(ASTBuilderUtil.createIdentifier(pkgNode.pos, Names.OBSERVE.value));
            importDcl.pkgNameComps = pkgNameComps;
            importDcl.pos = pkgNode.symbol.pos;
            importDcl.orgName = ASTBuilderUtil.createIdentifier(pkgNode.pos, Names.BALLERINA_INTERNAL_ORG.value);
            importDcl.alias = ASTBuilderUtil.createIdentifier(pkgNode.pos, "_");
            importDcl.version = ASTBuilderUtil.createIdentifier(pkgNode.pos, "");
            importDcl.symbol = this.packageCache.getSymbol(PackageID.OBSERVE_INTERNAL);
            pkgNode.imports.add(0, importDcl);
            pkgNode.symbol.imports.add(importDcl.symbol);
        }
    }
}

