/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.Context;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.clauses.OrderKeyNode;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.VariableNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.statements.VariableDefinitionNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.Desugar;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BSequenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownReferenceDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeySpecifier;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangCollectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupingKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangInputClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAlternateWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCollectContextInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExtendedXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchGuard;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMultipleWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNaturalExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRegExpTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerAsyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangConstPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangVarBindingPatternMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangWildCardMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.util.Lists;

public class QueryDesugar
extends BLangNodeVisitor {
    private static final Name QUERY_CREATE_PIPELINE_FUNCTION = new Name("createPipeline");
    private static final Name QUERY_CREATE_INPUT_FUNCTION = new Name("createInputFunction");
    private static final Name QUERY_CREATE_NESTED_FROM_FUNCTION = new Name("createNestedFromFunction");
    private static final Name QUERY_CREATE_LET_FUNCTION = new Name("createLetFunction");
    private static final Name QUERY_CREATE_INNER_JOIN_FUNCTION = new Name("createInnerJoinFunction");
    private static final Name QUERY_CREATE_OUTER_JOIN_FUNCTION = new Name("createOuterJoinFunction");
    private static final Name QUERY_CREATE_FILTER_FUNCTION = new Name("createFilterFunction");
    private static final Name QUERY_CREATE_ORDER_BY_FUNCTION = new Name("createOrderByFunction");
    private static final Name QUERY_CREATE_GROUP_BY_FUNCTION = new Name("createGroupByFunction");
    private static final Name QUERY_CREATE_COLLECT_FUNCTION = new Name("createCollectFunction");
    private static final Name QUERY_CREATE_SELECT_FUNCTION = new Name("createSelectFunction");
    private static final Name QUERY_CREATE_ON_CONFLICT_FUNCTION = new Name("createOnConflictFunction");
    private static final Name QUERY_CREATE_DO_FUNCTION = new Name("createDoFunction");
    private static final Name QUERY_CREATE_LIMIT_FUNCTION = new Name("createLimitFunction");
    private static final Name QUERY_ADD_STREAM_FUNCTION = new Name("addStreamFunction");
    private static final Name QUERY_CONSUME_STREAM_FUNCTION = new Name("consumeStream");
    private static final Name QUERY_TO_STREAM_FUNCTION = new Name("toStream");
    private static final Name QUERY_TO_ARRAY_FUNCTION = new Name("toArray");
    private static final Name COLLECT_QUERY_FUNCTION = new Name("collectQuery");
    private static final Name QUERY_TO_STRING_FUNCTION = new Name("toString");
    private static final Name QUERY_TO_XML_FUNCTION = new Name("toXML");
    private static final Name QUERY_ADD_TO_TABLE_FUNCTION = new Name("addToTable");
    private static final Name QUERY_ADD_TO_TABLE_FOR_ON_CONFLICT_FUNCTION = new Name("addToTableForOnConflict");
    private static final Name QUERY_ADD_TO_MAP_FUNCTION = new Name("addToMap");
    private static final Name QUERY_ADD_TO_MAP_FOR_ON_CONFLICT_FUNCTION = new Name("addToMapForOnConflict");
    private static final Name QUERY_GET_STREAM_FROM_PIPELINE_FUNCTION = new Name("getStreamFromPipeline");
    private static final Name QUERY_GET_STREAM_FOR_ON_CONFLICT_FROM_PIPELINE_FUNCTION = new Name("getStreamForOnConflictFromPipeline");
    private static final Name QUERY_GET_QUERY_ERROR_ROOT_CAUSE_FUNCTION = new Name("getQueryErrorRootCause");
    private static final String FRAME_PARAMETER_NAME = "$frame$";
    private static final Name QUERY_BODY_DISTINCT_ERROR_NAME = new Name("Error");
    private static final Name QUERY_PIPELINE_DISTINCT_ERROR_NAME = new Name("CompleteEarlyError");
    private static final Name QUERY_DISTINCT_UNION_ERROR_NAME = new Name("QueryErrorTypes");
    private static final CompilerContext.Key<QueryDesugar> QUERY_DESUGAR_KEY = new CompilerContext.Key();
    private BLangExpression onConflictExpr;
    private BVarSymbol currentFrameSymbol;
    private BLangBlockFunctionBody currentQueryLambdaBody;
    private Map<String, BSymbol> identifiers;
    private int streamElementCount = 0;
    private final Desugar desugar;
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final Names names;
    private final Types types;
    private SymbolEnv env;
    private SymbolEnv queryEnv;
    private boolean containsCheckExpr;
    private boolean withinQuery = false;
    private boolean withinLambdaOrArrowFunc = false;
    private HashSet<BType> checkedErrorList;
    private BLangNode result;

    private QueryDesugar(CompilerContext context) {
        context.put(QUERY_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
        this.types = Types.getInstance(context);
        this.desugar = Desugar.getInstance(context);
    }

    public static QueryDesugar getInstance(CompilerContext context) {
        QueryDesugar desugar = context.get(QUERY_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new QueryDesugar(context);
        }
        return desugar;
    }

    BLangStatementExpression desugar(BLangQueryExpr queryExpr, SymbolEnv env, List<BLangStatement> stmtsToBePropagated) {
        BLangVariableReference streamRef;
        this.containsCheckExpr = false;
        HashSet<BType> prevCheckedErrorList = this.checkedErrorList;
        this.checkedErrorList = new HashSet();
        List<BLangNode> clauses = queryExpr.getQueryClauses();
        Location pos = clauses.get((int)0).pos;
        BLangBlockStmt queryBlock = ASTBuilderUtil.createBlockStmt(pos);
        BLangVariableReference result = streamRef = this.buildStream(clauses, queryExpr.getBType(), env, queryBlock, stmtsToBePropagated);
        BLangLiteral isReadonly = ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, Symbols.isFlagOn(queryExpr.getBType().getFlags(), 32L));
        BType resultType = queryExpr.getBType();
        if (queryExpr.isStream) {
            resultType = streamRef.getBType();
            result = this.getStreamFunctionVariableRef(queryBlock, QUERY_TO_STREAM_FUNCTION, Lists.of(streamRef), pos);
        } else if (queryExpr.isTable) {
            BLangVariableReference tableRef = this.addTableConstructor(queryExpr, queryBlock);
            Name internalFuncName = this.onConflictExpr == null ? QUERY_ADD_TO_TABLE_FUNCTION : QUERY_ADD_TO_TABLE_FOR_ON_CONFLICT_FUNCTION;
            result = this.getStreamFunctionVariableRef(queryBlock, internalFuncName, Lists.of(streamRef, tableRef, isReadonly), pos);
            resultType = tableRef.getBType();
            this.onConflictExpr = null;
        } else if (queryExpr.isMap) {
            BMapType mapType = this.getMapType(queryExpr.getBType());
            BLangRecordLiteral.BLangMapLiteral mapLiteral = new BLangRecordLiteral.BLangMapLiteral(queryExpr.pos, mapType, new ArrayList<RecordLiteralNode.RecordField>());
            Name internalFuncName = this.onConflictExpr == null ? QUERY_ADD_TO_MAP_FUNCTION : QUERY_ADD_TO_MAP_FOR_ON_CONFLICT_FUNCTION;
            result = this.getStreamFunctionVariableRef(queryBlock, internalFuncName, Lists.of(streamRef, mapLiteral, isReadonly), pos);
            this.onConflictExpr = null;
        } else if (queryExpr.getFinalClause().getKind() == NodeKind.COLLECT) {
            result = this.getStreamFunctionVariableRef(queryBlock, COLLECT_QUERY_FUNCTION, Lists.of(streamRef), pos);
        } else {
            BType refType = Types.getImpliedType(queryExpr.getBType());
            SemType refSemType = refType.semType();
            SemType safeType = this.types.getNilAndErrorLiftType(refSemType);
            if (SemTypes.isSubtypeSimpleNotNever((SemType)safeType, (BasicTypeBitSet)PredefinedType.XML)) {
                if (this.types.isSubTypeOfReadOnly(refSemType)) {
                    isReadonly.value = true;
                }
                result = this.getStreamFunctionVariableRef(queryBlock, QUERY_TO_XML_FUNCTION, Lists.of(streamRef, isReadonly), pos);
            } else if (PredefinedType.STRING.equals((Object)safeType) || SemTypes.isSameType((Context)this.types.typeCtx(), (SemType)safeType, (SemType)PredefinedType.STRING_CHAR)) {
                result = this.getStreamFunctionVariableRef(queryBlock, QUERY_TO_STRING_FUNCTION, Lists.of(streamRef), pos);
            } else {
                BType arrayType = refType;
                if (refType.tag == 21) {
                    arrayType = ((BUnionType)refType).getMemberTypes().stream().filter(m -> Types.getImpliedType((BType)m).tag == 20).findFirst().orElse(this.symTable.arrayType);
                }
                BLangListConstructorExpr.BLangArrayLiteral arr = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
                arr.exprs = new ArrayList();
                arr.setBType(arrayType);
                result = this.getStreamFunctionVariableRef(queryBlock, QUERY_TO_ARRAY_FUNCTION, Lists.of(streamRef, arr, isReadonly), pos);
            }
        }
        this.handleErrorReturnsFromQuery(pos, result, queryBlock, false, resultType);
        BLangStatementExpression streamStmtExpr = ASTBuilderUtil.createStatementExpression(queryBlock, this.addTypeConversionExpr(result, queryExpr.getBType()));
        streamStmtExpr.setBType(resultType);
        this.checkedErrorList = prevCheckedErrorList;
        return streamStmtExpr;
    }

    private BMapType getMapType(BType type) {
        BMapType resultantType = (BMapType)Types.getImpliedType(this.types.getSafeType(type, false, true));
        return resultantType;
    }

    private boolean isXml(BType type) {
        BType refType = Types.getImpliedType(type);
        if (TypeTags.isXMLTypeTag(refType.tag)) {
            return true;
        }
        return switch (refType.tag) {
            case 21 -> {
                for (BType memberType : ((BUnionType)refType).getMemberTypes()) {
                    if (this.isXml(memberType)) continue;
                    yield false;
                }
                yield true;
            }
            default -> false;
        };
    }

    BLangStatementExpression desugar(BLangQueryAction queryAction, SymbolEnv env, List<BLangStatement> stmtsToBePropagated) {
        this.containsCheckExpr = false;
        HashSet<BType> prevCheckedErrorList = this.checkedErrorList;
        this.checkedErrorList = new HashSet();
        List<BLangNode> clauses = queryAction.getQueryClauses();
        Location pos = clauses.get((int)0).pos;
        BType returnType = this.symTable.errorOrNilType;
        if (queryAction.returnsWithinDoClause) {
            BInvokableSymbol invokableSymbol = env.enclInvokable.symbol;
            returnType = ((BInvokableType)invokableSymbol.type).retType;
        }
        BLangBlockStmt queryBlock = ASTBuilderUtil.createBlockStmt(pos);
        BLangVariableReference streamRef = this.buildStream(clauses, returnType, env, queryBlock, stmtsToBePropagated);
        BLangVariableReference result = this.getStreamFunctionVariableRef(queryBlock, QUERY_CONSUME_STREAM_FUNCTION, null, Lists.of(streamRef), pos);
        this.handleErrorReturnsFromQuery(pos, result, queryBlock, queryAction.returnsWithinDoClause, returnType);
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(queryBlock, this.addTypeConversionExpr(result, returnType));
        stmtExpr.setBType(returnType);
        this.checkedErrorList = prevCheckedErrorList;
        return stmtExpr;
    }

    private void handleErrorReturnsFromQuery(Location pos, BLangExpression resultRef, BLangBlockStmt queryBlock, boolean returnsWithinDoClause, BType returnType) {
        if (this.containsCheckExpr) {
            BLangInvocation getRootCauseError = this.createQueryLibInvocation(QUERY_GET_QUERY_ERROR_ROOT_CAUSE_FUNCTION, Lists.of(this.addTypeConversionExpr(resultRef, this.symTable.errorType)), pos);
            BSymbol queryErrorSymbol = this.symTable.langQueryModuleSymbol.scope.lookup((Name)QueryDesugar.QUERY_BODY_DISTINCT_ERROR_NAME).symbol;
            BType errorType = queryErrorSymbol.type;
            BLangErrorType queryErrorTypeNode = this.desugar.getErrorTypeNode();
            queryErrorTypeNode.setBType(errorType);
            BLangTypeTestExpr testExpr = ASTBuilderUtil.createTypeTestExpr(pos, resultRef, queryErrorTypeNode);
            testExpr.setBType(this.symTable.booleanType);
            this.desugar.failFastForErrorResult(pos, queryBlock, testExpr, getRootCauseError);
        }
        BLangIf ifStatement = ASTBuilderUtil.createIfStmt(pos, queryBlock);
        if (returnsWithinDoClause) {
            BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(pos, this.addTypeConversionExpr(resultRef, returnType));
            BLangBlockStmt ifBody = ASTBuilderUtil.createBlockStmt(pos);
            ifBody.stmts.add(returnStmt);
            BSymbol completeEarlyErrorSymbol = this.symTable.langQueryModuleSymbol.scope.lookup((Name)QueryDesugar.QUERY_PIPELINE_DISTINCT_ERROR_NAME).symbol;
            BType completeEarlyErrorType = completeEarlyErrorSymbol.type;
            BLangErrorType completeEarlyErrorTypeNode = (BLangErrorType)TreeBuilder.createErrorTypeNode();
            completeEarlyErrorTypeNode.setBType(completeEarlyErrorType);
            BLangTypeTestExpr completeEarlyTypeTestExpr = this.desugar.createTypeCheckExpr(pos, resultRef, completeEarlyErrorTypeNode);
            BLangTypeTestExpr nilTypeTestExpr = this.desugar.getNilTypeTestExpr(pos, resultRef);
            BLangBinaryExpr isNilOrErrorCheck = ASTBuilderUtil.createBinaryExpr(pos, nilTypeTestExpr, completeEarlyTypeTestExpr, this.symTable.booleanType, OperatorKind.OR, null);
            BLangGroupExpr notNilOrErrCheckExpr = new BLangGroupExpr();
            notNilOrErrCheckExpr.setBType(this.symTable.booleanType);
            notNilOrErrCheckExpr.expression = this.desugar.createNotBinaryExpression(pos, isNilOrErrorCheck);
            ifStatement.expr = notNilOrErrCheckExpr;
            ifStatement.body = ifBody;
        }
        BSymbol queryErrorUnionSymbol = this.symTable.langQueryModuleSymbol.scope.lookup((Name)QueryDesugar.QUERY_DISTINCT_UNION_ERROR_NAME).symbol;
        BType queryErrorUnionErrorType = queryErrorUnionSymbol.type;
        BLangErrorType queryErrorUnionErrorTypeNode = (BLangErrorType)TreeBuilder.createErrorTypeNode();
        queryErrorUnionErrorTypeNode.setBType(queryErrorUnionErrorType);
        BLangTypeTestExpr queryErrorUnionTypeTestExpr = this.desugar.createTypeCheckExpr(pos, resultRef, queryErrorUnionErrorTypeNode);
        BLangInvocation getRootCauseErrorInvo = this.createQueryLibInvocation(QUERY_GET_QUERY_ERROR_ROOT_CAUSE_FUNCTION, Lists.of(this.addTypeConversionExpr(resultRef, this.symTable.errorType)), pos);
        BLangBlockStmt ifErrorBody = ASTBuilderUtil.createBlockStmt(pos);
        BLangAssignment unwrapDistinctError = ASTBuilderUtil.createAssignmentStmt(pos, resultRef, this.types.addConversionExprIfRequired(getRootCauseErrorInvo, this.symTable.errorType));
        ifErrorBody.stmts.add(unwrapDistinctError);
        if (ifStatement.expr == null) {
            ifStatement.expr = queryErrorUnionTypeTestExpr;
            ifStatement.body = ifErrorBody;
        } else {
            BLangIf elseIfStmt = ASTBuilderUtil.createIfStmt(pos, queryBlock);
            elseIfStmt.expr = queryErrorUnionTypeTestExpr;
            elseIfStmt.body = ifErrorBody;
            ifStatement.elseStmt = elseIfStmt;
        }
    }

    BLangVariableReference buildStream(List<BLangNode> clauses, BType resultType, SymbolEnv env, BLangBlockStmt block, List<BLangStatement> stmtsToBePropagated) {
        this.env = env;
        BLangFromClause initFromClause = (BLangFromClause)clauses.get(0);
        BLangVariableReference initPipeline = this.addPipeline(block, initFromClause.pos, initFromClause.collection, resultType);
        BLangVariableReference initFrom = this.addInputFunction(block, initFromClause, stmtsToBePropagated);
        this.addStreamFunction(block, initPipeline, initFrom);
        for (BLangNode clause : clauses.subList(1, clauses.size())) {
            switch (clause.getKind()) {
                case FROM: {
                    BLangFromClause fromClause = (BLangFromClause)clause;
                    BLangVariableReference nestedFromFunc = this.addNestedFromFunction(block, fromClause, stmtsToBePropagated);
                    this.addStreamFunction(block, initPipeline, nestedFromFunc);
                    BLangVariableReference fromInputFunc = this.addInputFunction(block, fromClause, stmtsToBePropagated);
                    this.addStreamFunction(block, initPipeline, fromInputFunc);
                    break;
                }
                case JOIN: {
                    BLangJoinClause joinClause = (BLangJoinClause)clause;
                    BLangVariableReference joinPipeline = this.addPipeline(block, joinClause.pos, joinClause.collection, resultType);
                    BLangVariableReference joinInputFunc = this.addInputFunction(block, joinClause, stmtsToBePropagated);
                    this.addStreamFunction(block, joinPipeline, joinInputFunc);
                    BLangVariableReference joinFunc = this.addJoinFunction(block, joinClause, joinPipeline, stmtsToBePropagated);
                    this.addStreamFunction(block, initPipeline, joinFunc);
                    break;
                }
                case LET_CLAUSE: {
                    BLangVariableReference letFunc = this.addLetFunction(block, (BLangLetClause)clause, stmtsToBePropagated);
                    this.addStreamFunction(block, initPipeline, letFunc);
                    break;
                }
                case WHERE: {
                    BLangVariableReference whereFunc = this.addWhereFunction(block, (BLangWhereClause)clause, stmtsToBePropagated);
                    this.addStreamFunction(block, initPipeline, whereFunc);
                    break;
                }
                case ORDER_BY: {
                    BLangVariableReference orderFunc = this.addOrderByFunction(block, (BLangOrderByClause)clause, stmtsToBePropagated);
                    this.addStreamFunction(block, initPipeline, orderFunc);
                    break;
                }
                case GROUP_BY: {
                    BLangVariableReference groupByFunc = this.addGroupByFunction(block, (BLangGroupByClause)clause, stmtsToBePropagated, initPipeline);
                    this.addStreamFunction(block, initPipeline, groupByFunc);
                    break;
                }
                case SELECT: {
                    BLangVariableReference selectFunc = this.addSelectFunction(block, (BLangSelectClause)clause, stmtsToBePropagated);
                    this.addStreamFunction(block, initPipeline, selectFunc);
                    break;
                }
                case COLLECT: {
                    BLangVariableReference collectFunc = this.addCollectFunction(block, (BLangCollectClause)clause, stmtsToBePropagated);
                    this.addStreamFunction(block, initPipeline, collectFunc);
                    break;
                }
                case DO: {
                    BLangVariableReference doFunc = this.addDoFunction(block, (BLangDoClause)clause, stmtsToBePropagated);
                    this.addStreamFunction(block, initPipeline, doFunc);
                    break;
                }
                case LIMIT: {
                    BLangVariableReference limitFunc = this.addLimitFunction(block, (BLangLimitClause)clause);
                    this.addStreamFunction(block, initPipeline, limitFunc);
                    break;
                }
                case ON_CONFLICT: {
                    BLangOnConflictClause onConflict = (BLangOnConflictClause)clause;
                    this.onConflictExpr = onConflict.expression;
                    BLangVariableReference onConflictRef = this.addOnConflictFunction(block, onConflict, stmtsToBePropagated);
                    this.addStreamFunction(block, initPipeline, onConflictRef);
                }
            }
        }
        return this.addGetStreamFromPipeline(block, initPipeline);
    }

    BLangVariableReference addPipeline(BLangBlockStmt blockStmt, Location pos, BLangExpression collection, BType resultType) {
        String name = this.getNewVarName();
        BVarSymbol dataSymbol = new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, collection.getBType(), this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable dataVariable = ASTBuilderUtil.createVariable(pos, name, collection.getBType(), this.addTypeConversionExpr(collection, collection.getBType()), dataSymbol);
        BLangSimpleVariableDef dataVarDef = ASTBuilderUtil.createVariableDef(pos, dataVariable);
        BLangSimpleVarRef valueVarRef = ASTBuilderUtil.createVariableRef(pos, dataSymbol);
        blockStmt.addStatement(dataVarDef);
        BType constraintType = resultType;
        BType completionType = this.symTable.errorOrNilType;
        BType refType = Types.getImpliedType(resultType);
        boolean isStream = false;
        if (refType.tag == 20) {
            constraintType = ((BArrayType)refType).eType;
        } else if (refType.tag == 15) {
            isStream = true;
            constraintType = ((BStreamType)refType).constraint;
            completionType = ((BStreamType)refType).completionType;
        }
        BTypedescType constraintTdType = new BTypedescType(this.symTable.typeEnv(), constraintType, this.symTable.typeDesc.tsymbol);
        BLangTypedescExpr constraintTdExpr = new BLangTypedescExpr();
        constraintTdExpr.resolvedType = constraintType;
        constraintTdExpr.setBType(constraintTdType);
        BTypedescType completionTdType = new BTypedescType(this.symTable.typeEnv(), completionType, this.symTable.typeDesc.tsymbol);
        BLangTypedescExpr completionTdExpr = new BLangTypedescExpr();
        completionTdExpr.resolvedType = completionType;
        completionTdExpr.setBType(completionTdType);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_PIPELINE_FUNCTION, Lists.of(valueVarRef, constraintTdExpr, completionTdExpr, this.desugar.getBooleanLiteral(isStream)), pos);
    }

    BLangVariableReference addInputFunction(BLangBlockStmt blockStmt, BLangInputClause inputClause, List<BLangStatement> stmtsToBePropagated) {
        Location pos = inputClause.pos;
        BLangLambdaFunction lambda = this.createPassthroughLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        body.stmts.addAll(0, stmtsToBePropagated);
        BVarSymbol frameSymbol = ((BLangSimpleVariable)lambda.function.requiredParams.get((int)0)).symbol;
        List<BVarSymbol> symbols = this.getIntroducedSymbols((BLangVariable)inputClause.variableDefinitionNode.getVariable());
        this.shadowSymbolScope(pos, body, ASTBuilderUtil.createVariableRef(pos, frameSymbol), symbols);
        BLangFieldBasedAccess valueAccessExpr = this.desugar.getValueAccessExpression(inputClause.pos, this.symTable.anyOrErrorType, frameSymbol);
        valueAccessExpr.expr = this.types.addConversionExprIfRequired(valueAccessExpr.expr, this.types.getSafeType(valueAccessExpr.expr.getBType(), true, false));
        VariableDefinitionNode variableDefinitionNode = inputClause.variableDefinitionNode;
        BLangVariable variable = (BLangVariable)variableDefinitionNode.getVariable();
        this.setSymbolOwner(variable, this.env.scope.owner);
        variable.setInitialExpression(this.types.addConversionExprIfRequired(valueAccessExpr, inputClause.varType));
        body.stmts.add(0, (BLangStatement)((Object)variableDefinitionNode));
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_INPUT_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addNestedFromFunction(BLangBlockStmt blockStmt, BLangFromClause fromClause, List<BLangStatement> stmtsToBePropagated) {
        Location pos = fromClause.pos;
        BLangUnionTypeNode returnType = this.getAnyAndErrorTypeNode();
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.expr = fromClause.collection;
        returnNode.pos = pos;
        BLangLambdaFunction lambda = this.createLambdaFunction(pos, returnType, returnNode, false);
        ((BLangBlockFunctionBody)lambda.function.body).stmts.addAll(0, stmtsToBePropagated);
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_NESTED_FROM_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addJoinFunction(BLangBlockStmt blockStmt, BLangJoinClause joinClause, BLangVariableReference joinPipeline, List<BLangStatement> stmtsToBePropagated) {
        BLangExpression lhsExpr = (BLangExpression)joinClause.onClause.getLeftExpression();
        BLangExpression rhsExpr = (BLangExpression)joinClause.onClause.getRightExpression();
        BLangLambdaFunction lhsKeyFunction = this.createKeyFunction(lhsExpr, stmtsToBePropagated);
        BLangLambdaFunction rhsKeyFunction = this.createKeyFunction(rhsExpr, stmtsToBePropagated);
        if (joinClause.isOuterJoin) {
            return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_OUTER_JOIN_FUNCTION, Lists.of(joinPipeline, lhsKeyFunction, rhsKeyFunction), joinClause.pos);
        }
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_INNER_JOIN_FUNCTION, Lists.of(joinPipeline, lhsKeyFunction, rhsKeyFunction), joinClause.pos);
    }

    BLangVariableReference addLetFunction(BLangBlockStmt blockStmt, BLangLetClause letClause, List<BLangStatement> stmtsToBePropagated) {
        Location pos = letClause.pos;
        BLangLambdaFunction lambda = this.createPassthroughLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        BVarSymbol frameSymbol = ((BLangSimpleVariable)lambda.function.requiredParams.get((int)0)).symbol;
        List<BVarSymbol> symbols = this.getIntroducedSymbols(letClause);
        this.shadowSymbolScope(pos, body, ASTBuilderUtil.createVariableRef(pos, frameSymbol), symbols);
        Collections.reverse(letClause.letVarDeclarations);
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            body.stmts.add(0, (BLangStatement)((Object)letVariable.definitionNode));
            this.setSymbolOwner((BLangVariable)letVariable.definitionNode.getVariable(), this.env.scope.owner);
        }
        body.stmts.addAll(0, stmtsToBePropagated);
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_LET_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addWhereFunction(BLangBlockStmt blockStmt, BLangWhereClause whereClause, List<BLangStatement> stmtsToBePropagated) {
        Location pos = whereClause.pos;
        BLangLambdaFunction lambda = this.createFilterLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.pos = pos;
        body.stmts.addAll(0, stmtsToBePropagated);
        returnNode.expr = this.types.addConversionExprIfRequired(whereClause.expression, lambda.function.returnTypeNode.getBType());
        body.addStatement(returnNode);
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_FILTER_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addOrderByFunction(BLangBlockStmt blockStmt, BLangOrderByClause orderByClause, List<BLangStatement> stmtsToBePropagated) {
        Location pos = orderByClause.pos;
        BLangLambdaFunction lambda = this.createActionLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        body.stmts.addAll(0, stmtsToBePropagated);
        BVarSymbol frameSymbol = ((BLangSimpleVariable)lambda.function.requiredParams.get((int)0)).symbol;
        BLangSimpleVarRef frame = ASTBuilderUtil.createVariableRef(pos, frameSymbol);
        BLangListConstructorExpr.BLangArrayLiteral sortFieldsArrayExpr = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        sortFieldsArrayExpr.exprs = new ArrayList();
        sortFieldsArrayExpr.setBType(new BArrayType(this.symTable.typeEnv(), this.symTable.anydataType));
        BLangListConstructorExpr.BLangArrayLiteral sortModesArrayExpr = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        sortModesArrayExpr.exprs = new ArrayList();
        sortModesArrayExpr.setBType(new BArrayType(this.symTable.typeEnv(), this.symTable.booleanType));
        for (OrderKeyNode orderKeyNode : orderByClause.getOrderKeyList()) {
            BLangOrderKey orderKey = (BLangOrderKey)orderKeyNode;
            sortFieldsArrayExpr.exprs.add(orderKey.expression);
            sortModesArrayExpr.exprs.add(ASTBuilderUtil.createLiteral(orderKey.pos, this.symTable.booleanType, orderKey.getOrderDirection()));
        }
        BLangStatement orderKeyStmt = this.getAddToFrameStmt(pos, frame, "$orderKey$", sortFieldsArrayExpr);
        body.stmts.add(orderKeyStmt);
        BLangStatement orderDirectionStmt = this.getAddToFrameStmt(pos, frame, "$orderDirection$", sortModesArrayExpr);
        body.stmts.add(orderDirectionStmt);
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_ORDER_BY_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addGroupByFunction(BLangBlockStmt blockStmt, BLangGroupByClause groupByClause, List<BLangStatement> stmtsToBePropagated, BLangVariableReference initPipeline) {
        Location pos = groupByClause.pos;
        BLangListConstructorExpr.BLangArrayLiteral keys = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        keys.exprs = new ArrayList();
        keys.setBType(new BArrayType(this.symTable.typeEnv(), this.symTable.stringType));
        for (BLangGroupingKey key : groupByClause.groupingKeyList) {
            if (key.variableDef == null) {
                keys.exprs.add(this.createStringLiteral(key.pos, key.variableRef.variableName.value));
                continue;
            }
            keys.exprs.add(this.createStringLiteral(key.pos, key.variableDef.var.name.value));
            BLangSimpleVariableDef varDef = key.variableDef;
            BLangVariableReference letFunc = this.addLetFunction(blockStmt, this.createLetClauseFromVarDef(varDef), stmtsToBePropagated);
            this.addStreamFunction(blockStmt, initPipeline, letFunc);
        }
        BLangListConstructorExpr.BLangArrayLiteral nonGroupingKeys = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        nonGroupingKeys.exprs = new ArrayList();
        nonGroupingKeys.setBType(new BArrayType(this.symTable.typeEnv(), this.symTable.stringType));
        for (String nonGroupingKey : groupByClause.nonGroupingKeys) {
            nonGroupingKeys.exprs.add(this.createStringLiteral(pos, nonGroupingKey));
        }
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_GROUP_BY_FUNCTION, Lists.of(keys, nonGroupingKeys), pos);
    }

    BLangVariableReference addCollectFunction(BLangBlockStmt blockStmt, BLangCollectClause collectClause, List<BLangStatement> stmtsToBePropagated) {
        Location pos = collectClause.pos;
        BLangListConstructorExpr.BLangArrayLiteral nonGroupingKeys = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        nonGroupingKeys.exprs = new ArrayList();
        nonGroupingKeys.setBType(new BArrayType(this.symTable.typeEnv(), this.symTable.stringType));
        for (String nonGroupingKey : collectClause.nonGroupingKeys) {
            nonGroupingKeys.exprs.add(this.createStringLiteral(pos, nonGroupingKey));
        }
        BLangLambdaFunction lambda = this.createPassthroughLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        body.stmts.addAll(0, stmtsToBePropagated);
        BVarSymbol oldFrameSymbol = ((BLangSimpleVariable)lambda.function.requiredParams.get((int)0)).symbol;
        BLangSimpleVarRef frame = ASTBuilderUtil.createVariableRef(pos, oldFrameSymbol);
        BLangStatement assignment = this.getAddToFrameStmt(pos, frame, "$value$", collectClause.expression);
        body.stmts.add(body.stmts.size() - 1, assignment);
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_COLLECT_FUNCTION, Lists.of(nonGroupingKeys, lambda), pos);
    }

    BLangLetClause createLetClauseFromVarDef(BLangSimpleVariableDef varDef) {
        BLangLetClause letClause = (BLangLetClause)TreeBuilder.createLetClauseNode();
        letClause.pos = varDef.pos;
        letClause.letVarDeclarations = new ArrayList<BLangLetVariable>();
        BLangLetVariable letVar = TreeBuilder.createLetVariableNode();
        letVar.definitionNode = varDef;
        letVar.definitionNode.getVariable().addFlag(Flag.FINAL);
        letClause.letVarDeclarations.add(letVar);
        return letClause;
    }

    private BLangLiteral createStringLiteral(Location pos, String value) {
        BLangLiteral stringLit = new BLangLiteral(value, this.symTable.stringType);
        stringLit.pos = pos;
        return stringLit;
    }

    BLangVariableReference addSelectFunction(BLangBlockStmt blockStmt, BLangSelectClause selectClause, List<BLangStatement> stmtsToBePropagated) {
        Location pos = selectClause.pos;
        BLangLambdaFunction lambda = this.createPassthroughLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        body.stmts.addAll(0, stmtsToBePropagated);
        BVarSymbol oldFrameSymbol = ((BLangSimpleVariable)lambda.function.requiredParams.get((int)0)).symbol;
        BLangSimpleVarRef frame = ASTBuilderUtil.createVariableRef(pos, oldFrameSymbol);
        BLangStatement assignment = this.getAddToFrameStmt(pos, frame, "$value$", selectClause.expression);
        body.stmts.add(body.stmts.size() - 1, assignment);
        lambda = this.rewrite(lambda);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_SELECT_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addOnConflictFunction(BLangBlockStmt blockStmt, BLangOnConflictClause onConflictClause, List<BLangStatement> stmtsToBePropagated) {
        Location pos = onConflictClause.pos;
        BLangLambdaFunction lambda = this.createPassthroughLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        body.stmts.addAll(0, stmtsToBePropagated);
        BVarSymbol oldFrameSymbol = ((BLangSimpleVariable)lambda.function.requiredParams.get((int)0)).symbol;
        BLangSimpleVarRef frame = ASTBuilderUtil.createVariableRef(pos, oldFrameSymbol);
        BLangStatement assignment = this.getAddToFrameStmt(pos, frame, "$error$", onConflictClause.expression);
        body.stmts.add(body.stmts.size() - 1, assignment);
        lambda = this.rewrite(lambda);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_ON_CONFLICT_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addDoFunction(BLangBlockStmt blockStmt, BLangDoClause doClause, List<BLangStatement> stmtsToBePropagated) {
        Location pos = doClause.pos;
        BLangLambdaFunction lambda = this.createActionLambda(pos);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)lambda.function.body;
        body.stmts.addAll(0, stmtsToBePropagated);
        for (BLangStatement stmt : doClause.body.stmts) {
            body.addStatement(stmt);
        }
        lambda.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_DO_FUNCTION, Lists.of(lambda), pos);
    }

    BLangVariableReference addLimitFunction(BLangBlockStmt blockStmt, BLangLimitClause limitClause) {
        Location pos = limitClause.pos;
        BLangUnionTypeNode returnTypeNode = this.getIntErrorTypeNode();
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.expr = this.types.addConversionExprIfRequired(limitClause.expression, returnTypeNode.getBType());
        returnNode.pos = pos;
        BLangLambdaFunction limitFunction = this.createLambdaFunction(pos, returnTypeNode, returnNode, false);
        limitFunction.accept(this);
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_CREATE_LIMIT_FUNCTION, Lists.of(limitFunction), pos);
    }

    void addStreamFunction(BLangBlockStmt blockStmt, BLangVariableReference pipelineRef, BLangVariableReference functionRef) {
        BLangInvocation addStreamFunctionInvocation = this.createQueryLibInvocation(QUERY_ADD_STREAM_FUNCTION, Lists.of(pipelineRef, functionRef), pipelineRef.pos);
        BLangExpressionStmt stmt = ASTBuilderUtil.createExpressionStmt(pipelineRef.pos, blockStmt);
        stmt.expr = addStreamFunctionInvocation;
    }

    BLangVariableReference addGetStreamFromPipeline(BLangBlockStmt blockStmt, BLangVariableReference pipelineRef) {
        Location pos = pipelineRef.pos;
        if (this.onConflictExpr == null) {
            return this.getStreamFunctionVariableRef(blockStmt, QUERY_GET_STREAM_FROM_PIPELINE_FUNCTION, null, Lists.of(pipelineRef), pos);
        }
        return this.getStreamFunctionVariableRef(blockStmt, QUERY_GET_STREAM_FOR_ON_CONFLICT_FROM_PIPELINE_FUNCTION, null, Lists.of(pipelineRef), pos);
    }

    BLangVariableReference addTableConstructor(BLangQueryExpr queryExpr, BLangBlockStmt queryBlock) {
        Location pos = queryExpr.pos;
        BType type = queryExpr.getBType();
        String name = this.getNewVarName();
        BType tableType = type;
        BType refType = Types.getImpliedType(type);
        if (refType.tag == 21) {
            tableType = this.symTable.tableType;
            for (BType memberType : ((BUnionType)refType).getMemberTypes()) {
                int memberTypeTag = Types.getImpliedType((BType)memberType).tag;
                if (memberTypeTag != 9) continue;
                tableType = memberType;
            }
        }
        List<IdentifierNode> keyFieldIdentifiers = queryExpr.fieldNameIdentifierList;
        BLangTableConstructorExpr tableConstructorExpr = (BLangTableConstructorExpr)TreeBuilder.createTableConstructorExpressionNode();
        tableConstructorExpr.pos = pos;
        tableConstructorExpr.setBType(tableType);
        if (!keyFieldIdentifiers.isEmpty()) {
            BLangTableKeySpecifier keySpecifier = (BLangTableKeySpecifier)TreeBuilder.createTableKeySpecifierNode();
            keySpecifier.pos = pos;
            for (IdentifierNode identifier : keyFieldIdentifiers) {
                keySpecifier.addFieldNameIdentifier(identifier);
            }
            tableConstructorExpr.tableKeySpecifier = keySpecifier;
        }
        BVarSymbol tableSymbol = new BVarSymbol(0L, Names.fromString(name), this.env.scope.owner.pkgID, tableType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable tableVariable = ASTBuilderUtil.createVariable(pos, name, tableType, tableConstructorExpr, tableSymbol);
        queryBlock.addStatement(ASTBuilderUtil.createVariableDef(pos, tableVariable));
        return ASTBuilderUtil.createVariableRef(pos, tableSymbol);
    }

    private BLangExpression addTypeConversionExpr(BLangExpression expr, BType type) {
        BLangTypeConversionExpr conversionExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
        conversionExpr.expr = expr;
        conversionExpr.targetType = type;
        conversionExpr.setBType(type);
        conversionExpr.pos = expr.pos;
        conversionExpr.checkTypes = false;
        return conversionExpr;
    }

    private BLangLambdaFunction createPassthroughLambda(Location pos) {
        BLangUnionTypeNode returnType = this.getFrameErrorNilTypeNode();
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.pos = pos;
        return this.createLambdaFunction(pos, returnType, returnNode, true);
    }

    private BLangLambdaFunction createFilterLambda(Location pos) {
        BLangUnionTypeNode returnType = this.getBooleanErrorTypeNode();
        return this.createLambdaFunction(pos, returnType, null, false);
    }

    private BLangLambdaFunction createActionLambda(Location pos) {
        BLangUnionTypeNode returnType = this.getAnyAndErrorTypeNode();
        return this.createLambdaFunction(pos, returnType, null, false);
    }

    private BLangLambdaFunction createLambdaFunction(Location pos, TypeNode returnType, BLangReturn returnNode, boolean isPassthrough) {
        BType frameType = this.getFrameTypeSymbol().type;
        BVarSymbol frameSymbol = new BVarSymbol(0L, Names.fromString(FRAME_PARAMETER_NAME), this.env.scope.owner.pkgID, frameType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable frameVariable = ASTBuilderUtil.createVariable(pos, FRAME_PARAMETER_NAME, frameSymbol.type, null, frameSymbol);
        BLangSimpleVarRef frameVarRef = ASTBuilderUtil.createVariableRef(pos, frameSymbol);
        BLangBlockFunctionBody body = (BLangBlockFunctionBody)TreeBuilder.createBlockFunctionBodyNode();
        if (returnNode != null) {
            if (isPassthrough) {
                returnNode.setExpression(frameVarRef);
            }
            body.addStatement(returnNode);
        }
        return this.createLambdaFunction(pos, Lists.of(frameVariable), returnType, body);
    }

    private BLangLambdaFunction createLambdaFunction(Location pos, List<BLangSimpleVariable> requiredParams, TypeNode returnType, BLangFunctionBody lambdaBody) {
        BLangLambdaFunction lambdaFunction = this.desugar.createLambdaFunction(pos, "$streamLambda$", requiredParams, returnType, lambdaBody);
        lambdaFunction.function.addFlag(Flag.QUERY_LAMBDA);
        lambdaFunction.capturedClosureEnv = this.env;
        return lambdaFunction;
    }

    private BLangVariableReference getStreamFunctionVariableRef(BLangBlockStmt blockStmt, Name functionName, List<BLangExpression> requiredArgs, Location pos) {
        return this.getStreamFunctionVariableRef(blockStmt, functionName, null, requiredArgs, pos);
    }

    private BLangVariableReference getStreamFunctionVariableRef(BLangBlockStmt blockStmt, Name functionName, BType type, List<BLangExpression> requiredArgs, Location pos) {
        String name = this.getNewVarName();
        BLangInvocation queryLibInvocation = this.createQueryLibInvocation(functionName, requiredArgs, pos);
        type = type == null ? queryLibInvocation.getBType() : type;
        BVarSymbol varSymbol = new BVarSymbol(0L, new Name(name), this.env.scope.owner.pkgID, type, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable variable = ASTBuilderUtil.createVariable(pos, name, type, this.types.addConversionExprIfRequired(queryLibInvocation, type), varSymbol);
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDef(pos, variable);
        blockStmt.addStatement(variableDef);
        return ASTBuilderUtil.createVariableRef(pos, variable.symbol);
    }

    private String getNewVarName() {
        return "$streamElement$_" + this.streamElementCount++;
    }

    private BLangInvocation createQueryLibInvocation(Name functionName, List<BLangExpression> requiredArgs, Location pos) {
        BInvokableSymbol symbol = this.getQueryLibInvokableSymbol(functionName);
        BLangInvocation bLangInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, symbol, requiredArgs, this.symResolver);
        bLangInvocation.setBType(symbol.retType);
        return bLangInvocation;
    }

    private BInvokableSymbol getQueryLibInvokableSymbol(Name functionName) {
        return (BInvokableSymbol)this.symTable.langQueryModuleSymbol.scope.lookup((Name)functionName).symbol;
    }

    private BLangStatement getAddToFrameStmt(Location pos, BLangVariableReference frame, String key, BLangExpression value) {
        BLangIdentifier valueIdentifier = ASTBuilderUtil.createIdentifier(pos, key);
        BLangFieldBasedAccess valueAccess = ASTBuilderUtil.createFieldAccessExpr(frame, valueIdentifier);
        valueAccess.pos = pos;
        valueAccess.setBType(this.symTable.anyOrErrorType);
        valueAccess.originalType = valueAccess.getBType();
        return ASTBuilderUtil.createAssignmentStmt(pos, valueAccess, value);
    }

    private void shadowSymbolScope(Location pos, BLangBlockFunctionBody lambdaBody, BLangSimpleVarRef frameRef, List<BVarSymbol> symbols) {
        Collections.reverse(symbols);
        for (BVarSymbol symbol : symbols) {
            this.env.scope.entries.remove(symbol.name);
            this.env.enclPkg.globalVariableDependencies.values().forEach(d -> d.remove(symbol));
            BLangStatement addToFrameStmt = this.getAddToFrameStmt(pos, frameRef, symbol.name.value, ASTBuilderUtil.createVariableRef(pos, symbol));
            lambdaBody.stmts.add(0, addToFrameStmt);
        }
    }

    private void setSymbolOwner(BLangVariable variable, BSymbol owner) {
        if (variable == null) {
            return;
        }
        switch (variable.getKind()) {
            case VARIABLE: {
                if (variable.symbol == null) {
                    return;
                }
                variable.symbol.owner = owner;
                break;
            }
            case TUPLE_VARIABLE: {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)variable;
                tupleVariable.memberVariables.forEach(v -> this.setSymbolOwner((BLangVariable)v, owner));
                this.setSymbolOwner(tupleVariable.restVariable, owner);
                break;
            }
            case RECORD_VARIABLE: {
                BLangRecordVariable recordVariable = (BLangRecordVariable)variable;
                recordVariable.variableList.forEach(value -> this.setSymbolOwner(value.valueBindingPattern, owner));
                this.setSymbolOwner(recordVariable.restParam, owner);
                break;
            }
            case ERROR_VARIABLE: {
                BLangErrorVariable errorVariable = (BLangErrorVariable)variable;
                this.setSymbolOwner(errorVariable.message, owner);
                this.setSymbolOwner(errorVariable.restDetail, owner);
                errorVariable.detail.forEach(bLangErrorDetailEntry -> this.setSymbolOwner(bLangErrorDetailEntry.valueBindingPattern, owner));
            }
        }
    }

    private List<BVarSymbol> getIntroducedSymbols(BLangLetClause letClause) {
        ArrayList<BVarSymbol> symbols = new ArrayList<BVarSymbol>();
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            symbols.addAll(this.getIntroducedSymbols(letVariable));
        }
        return symbols;
    }

    private List<BVarSymbol> getIntroducedSymbols(BLangLetVariable variable) {
        return this.getIntroducedSymbols((BLangVariable)variable.definitionNode.getVariable());
    }

    private List<BVarSymbol> getIntroducedSymbols(BLangVariable variable) {
        if (variable != null) {
            ArrayList<BVarSymbol> symbols = new ArrayList<BVarSymbol>();
            if (variable.getKind() == NodeKind.RECORD_VARIABLE) {
                BLangRecordVariable record = (BLangRecordVariable)variable;
                for (BLangRecordVariable.BLangRecordVariableKeyValue keyValue : record.variableList) {
                    symbols.addAll(this.getIntroducedSymbols(keyValue.valueBindingPattern));
                }
                if (record.hasRestParam()) {
                    symbols.addAll(this.getIntroducedSymbols(record.restParam));
                }
            } else if (variable.getKind() == NodeKind.TUPLE_VARIABLE) {
                BLangTupleVariable tuple = (BLangTupleVariable)variable;
                for (BLangVariable memberVariable : tuple.memberVariables) {
                    symbols.addAll(this.getIntroducedSymbols(memberVariable));
                }
                if (tuple.restVariable != null) {
                    symbols.addAll(this.getIntroducedSymbols(tuple.restVariable));
                }
            } else if (variable.getKind() == NodeKind.ERROR_VARIABLE) {
                BLangErrorVariable error = (BLangErrorVariable)variable;
                if (error.message != null) {
                    symbols.addAll(this.getIntroducedSymbols(error.message));
                }
                if (error.restDetail != null) {
                    symbols.addAll(this.getIntroducedSymbols(error.restDetail));
                }
                for (BLangErrorVariable.BLangErrorDetailEntry entry : error.detail) {
                    symbols.addAll(this.getIntroducedSymbols(entry.valueBindingPattern));
                }
            } else if (variable.symbol != null) {
                symbols.add(variable.symbol);
            }
            return symbols;
        }
        return Collections.emptyList();
    }

    private BLangLambdaFunction createKeyFunction(BLangExpression expr, List<BLangStatement> stmtsToBePropagated) {
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.expr = this.types.addConversionExprIfRequired(expr, this.symTable.anyOrErrorType);
        returnNode.pos = expr.pos;
        BLangLambdaFunction keyFunction = this.createLambdaFunction(expr.pos, this.getAnyAndErrorTypeNode(), returnNode, false);
        ((BLangBlockFunctionBody)keyFunction.function.body).stmts.addAll(0, stmtsToBePropagated);
        keyFunction.accept(this);
        return keyFunction;
    }

    private BLangSimpleVarRef defineNilFrameForType(List<BVarSymbol> symbols, BLangBlockStmt blockStmt, Location pos) {
        BLangSimpleVarRef frame = this.defineFrameVariable(blockStmt, pos);
        for (BVarSymbol symbol : symbols) {
            BType type = symbol.type;
            String key = symbol.name.value;
            BType structureType = Types.getImpliedType(type);
            if (structureType.tag == 12 || structureType.tag == 34) {
                ArrayList<BVarSymbol> nestedSymbols = new ArrayList<BVarSymbol>();
                for (BField field : ((BStructureType)structureType).fields.values()) {
                    nestedSymbols.add(field.symbol);
                }
                this.addFrameValueToFrame(frame, key, this.defineNilFrameForType(nestedSymbols, blockStmt, pos), blockStmt, pos);
                continue;
            }
            this.addNilValueToFrame(frame, key, blockStmt, pos);
        }
        return frame;
    }

    private void addNilValueToFrame(BLangSimpleVarRef frameToAddValueTo, String key, BLangBlockStmt blockStmt, Location pos) {
        BLangStatement addToFrameStmt = this.getAddToFrameStmt(pos, frameToAddValueTo, key, ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, Names.NIL_VALUE.value));
        blockStmt.addStatement(addToFrameStmt);
    }

    private void addFrameValueToFrame(BLangSimpleVarRef frameToAddValueTo, String key, BLangSimpleVarRef frameValue, BLangBlockStmt blockStmt, Location pos) {
        BLangStatement addToFrameStmt = this.getAddToFrameStmt(pos, frameToAddValueTo, key, frameValue);
        blockStmt.addStatement(addToFrameStmt);
    }

    private BLangSimpleVarRef defineFrameVariable(BLangBlockStmt blockStmt, Location pos) {
        BSymbol frameTypeSymbol = this.getFrameTypeSymbol();
        BRecordType frameType = (BRecordType)frameTypeSymbol.type;
        String frameName = this.getNewVarName();
        BVarSymbol frameSymbol = new BVarSymbol(0L, Names.fromString(frameName), this.env.scope.owner.pkgID, frameType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangRecordLiteral frameInit = ASTBuilderUtil.createEmptyRecordLiteral(pos, frameType);
        BLangSimpleVariable frameVariable = ASTBuilderUtil.createVariable(pos, frameName, frameType, frameInit, frameSymbol);
        blockStmt.addStatement(ASTBuilderUtil.createVariableDef(pos, frameVariable));
        return ASTBuilderUtil.createVariableRef(pos, frameSymbol);
    }

    BLangValueType getNilTypeNode() {
        BLangValueType nilTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        nilTypeNode.typeKind = TypeKind.NIL;
        nilTypeNode.setBType(this.symTable.nilType);
        return nilTypeNode;
    }

    BLangValueType getAnyTypeNode() {
        BLangValueType anyTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        anyTypeNode.typeKind = TypeKind.ANY;
        anyTypeNode.setBType(this.symTable.anyType);
        return anyTypeNode;
    }

    BLangValueType getIntTypeNode() {
        BLangValueType intTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        intTypeNode.typeKind = TypeKind.INT;
        intTypeNode.setBType(this.symTable.intType);
        return intTypeNode;
    }

    BLangErrorType getErrorTypeNode() {
        BLangErrorType errorTypeNode = (BLangErrorType)TreeBuilder.createErrorTypeNode();
        errorTypeNode.setBType(this.symTable.errorType);
        return errorTypeNode;
    }

    private BLangValueType getBooleanTypeNode() {
        BLangValueType booleanTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        booleanTypeNode.typeKind = TypeKind.BOOLEAN;
        booleanTypeNode.setBType(this.symTable.booleanType);
        return booleanTypeNode;
    }

    private BLangUnionTypeNode getFrameErrorNilTypeNode() {
        BType frameType = this.getFrameTypeSymbol().type;
        BUnionType unionType = BUnionType.create(this.symTable.typeEnv(), null, frameType, this.symTable.errorType, this.symTable.nilType);
        BLangUnionTypeNode unionTypeNode = (BLangUnionTypeNode)TreeBuilder.createUnionTypeNode();
        unionTypeNode.setBType(unionType);
        unionTypeNode.memberTypeNodes.add(this.getFrameTypeNode());
        unionTypeNode.memberTypeNodes.add(this.getErrorTypeNode());
        unionTypeNode.memberTypeNodes.add(this.getNilTypeNode());
        unionTypeNode.desugared = true;
        return unionTypeNode;
    }

    private BLangUnionTypeNode getBooleanErrorTypeNode() {
        BUnionType unionType = BUnionType.create(this.symTable.typeEnv(), null, this.symTable.errorType, this.symTable.booleanType);
        BLangUnionTypeNode unionTypeNode = (BLangUnionTypeNode)TreeBuilder.createUnionTypeNode();
        unionTypeNode.setBType(unionType);
        unionTypeNode.memberTypeNodes.add(this.getErrorTypeNode());
        unionTypeNode.memberTypeNodes.add(this.getBooleanTypeNode());
        unionTypeNode.desugared = true;
        return unionTypeNode;
    }

    private BLangUnionTypeNode getIntErrorTypeNode() {
        BUnionType unionType = BUnionType.create(this.symTable.typeEnv(), null, this.symTable.errorType, this.symTable.intType);
        BLangUnionTypeNode unionTypeNode = (BLangUnionTypeNode)TreeBuilder.createUnionTypeNode();
        unionTypeNode.setBType(unionType);
        unionTypeNode.memberTypeNodes.add(this.getErrorTypeNode());
        unionTypeNode.memberTypeNodes.add(this.getIntTypeNode());
        unionTypeNode.desugared = true;
        return unionTypeNode;
    }

    private BLangUnionTypeNode getAnyAndErrorTypeNode() {
        BUnionType unionType = BUnionType.create(this.symTable.typeEnv(), null, this.symTable.anyType, this.symTable.errorType);
        BLangUnionTypeNode unionTypeNode = (BLangUnionTypeNode)TreeBuilder.createUnionTypeNode();
        unionTypeNode.memberTypeNodes.add(this.getAnyTypeNode());
        unionTypeNode.memberTypeNodes.add(this.getErrorTypeNode());
        unionTypeNode.setBType(unionType);
        unionTypeNode.desugared = true;
        return unionTypeNode;
    }

    private BLangRecordTypeNode getFrameTypeNode() {
        BSymbol frameTypeSymbol = this.getFrameTypeSymbol();
        BRecordType frameType = (BRecordType)frameTypeSymbol.type;
        BLangUnionTypeNode restFieldType = (BLangUnionTypeNode)TreeBuilder.createUnionTypeNode();
        restFieldType.setBType(frameType.restFieldType);
        restFieldType.memberTypeNodes.add(this.getErrorTypeNode());
        restFieldType.memberTypeNodes.add(this.getAnyTypeNode());
        BLangRecordTypeNode frameTypeNode = (BLangRecordTypeNode)TreeBuilder.createRecordTypeNode();
        frameTypeNode.setBType(frameType);
        frameTypeNode.restFieldType = restFieldType;
        frameTypeNode.symbol = frameType.tsymbol;
        frameTypeNode.desugared = true;
        return frameTypeNode;
    }

    private BSymbol getFrameTypeSymbol() {
        return this.symTable.langQueryModuleSymbol.scope.lookup((Name)Names.fromString((String)"_Frame")).symbol;
    }

    @Override
    public void visit(BLangLambdaFunction lambda) {
        lambda.function = this.rewrite(lambda.function);
        SymbolEnv prevEnv = new SymbolEnv(this.env.node, this.env.scope);
        this.env.copyTo(prevEnv, this.env.enclEnv);
        lambda.function = this.desugar.rewrite(lambda.function, lambda.capturedClosureEnv);
        this.env = prevEnv;
        this.result = lambda;
    }

    @Override
    public void visit(BLangFunction function) {
        if (function.flagSet.contains((Object)Flag.QUERY_LAMBDA)) {
            BLangBlockFunctionBody prevQueryLambdaBody = this.currentQueryLambdaBody;
            BVarSymbol prevFrameSymbol = this.currentFrameSymbol;
            Map<String, BSymbol> prevIdentifiers = this.identifiers;
            this.currentFrameSymbol = ((BLangSimpleVariable)function.requiredParams.get((int)0)).symbol;
            this.identifiers = new HashMap<String, BSymbol>();
            this.currentQueryLambdaBody = (BLangBlockFunctionBody)function.getBody();
            this.rewrite(this.currentQueryLambdaBody);
            this.currentFrameSymbol = prevFrameSymbol;
            this.identifiers = prevIdentifiers;
            this.currentQueryLambdaBody = prevQueryLambdaBody;
        } else {
            boolean prevWithinLambdaFunc = this.withinLambdaOrArrowFunc;
            this.withinLambdaOrArrowFunc = true;
            function.getBody().accept(this);
            this.withinLambdaOrArrowFunc = prevWithinLambdaFunc;
        }
        this.result = function;
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        ArrayList<BLangStatement> stmts = new ArrayList<BLangStatement>(body.getStatements());
        this.rewrite(stmts);
        this.result = body;
    }

    @Override
    public void visit(BLangExprFunctionBody exprBody) {
        exprBody.expr = this.rewrite(exprBody.expr);
        this.result = exprBody;
    }

    @Override
    public void visit(BLangSimpleVariableDef bLangSimpleVariableDef) {
        bLangSimpleVariableDef.getVariable().accept(this);
        this.result = bLangSimpleVariableDef;
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        bLangRecordVariableDef.var.accept(this);
        this.result = bLangRecordVariableDef;
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        bLangRecordVariable.variableList.forEach(v -> v.getValue().accept(this));
        bLangRecordVariable.expr = this.rewrite(bLangRecordVariable.expr);
        if (bLangRecordVariable.hasRestParam()) {
            bLangRecordVariable.restParam.accept(this);
        }
        this.result = bLangRecordVariable;
    }

    @Override
    public void visit(BLangSimpleVariable bLangSimpleVariable) {
        this.identifiers.putIfAbsent(bLangSimpleVariable.name.value, bLangSimpleVariable.symbol);
        bLangSimpleVariable.expr = this.rewrite(bLangSimpleVariable.expr);
        this.result = bLangSimpleVariable;
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        conversionExpr.expr = this.rewrite(conversionExpr.expr);
        this.result = conversionExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        fieldAccessExpr.expr = this.rewrite(fieldAccessExpr.expr);
        this.result = fieldAccessExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess prefixedFieldBasedAccess) {
        prefixedFieldBasedAccess.expr = this.rewrite(prefixedFieldBasedAccess.expr);
        this.result = prefixedFieldBasedAccess;
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef structFunctionVarRef) {
        structFunctionVarRef.expr = this.rewrite(structFunctionVarRef.expr);
        this.result = structFunctionVarRef;
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        exprStmtNode.expr = this.rewrite(exprStmtNode.expr);
        this.result = exprStmtNode;
    }

    @Override
    public void visit(BLangCollectContextInvocation collectContextInvocation) {
        BLangInvocation invocation = collectContextInvocation.invocation;
        invocation = this.rewrite(invocation);
        this.result = invocation;
        if (this.isNilReturnInvocationInCollectClause(invocation)) {
            Location pos = invocation.pos;
            BLangSimpleVarRef restArg = (BLangSimpleVarRef)invocation.argExprs.get(0);
            BUnionType invocationType = BUnionType.create(this.symTable.typeEnv(), null, invocation.getBType(), this.symTable.nilType);
            BLangSimpleVariable tempResultVar = ASTBuilderUtil.createVariable(pos, "$invocationResult$", invocationType, null, new BVarSymbol(0L, Names.fromString("$invocationResult$"), this.env.scope.owner.pkgID, invocationType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL));
            BLangSimpleVariableDef tempResultVarDef = ASTBuilderUtil.createVariableDef(pos, tempResultVar);
            BLangSimpleVarRef tempResultVarRef = ASTBuilderUtil.createVariableRef(pos, tempResultVar.symbol);
            BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(pos);
            blockStmt.addStatement(tempResultVarDef);
            BLangBlockStmt thenBody = ASTBuilderUtil.createBlockStmt(pos);
            BLangBlockStmt elseBody = ASTBuilderUtil.createBlockStmt(pos);
            BLangInvocation argLength = this.desugar.createLangLibInvocationNode("length", restArg, new ArrayList<BLangExpression>(), null, pos);
            BLangBinaryExpr binaryExpr = ASTBuilderUtil.createBinaryExpr(pos, argLength, ASTBuilderUtil.createLiteral(pos, this.symTable.intType, 0L), this.symTable.booleanType, OperatorKind.EQUAL, null);
            BLangIf ifElse = ASTBuilderUtil.createIfElseStmt(pos, binaryExpr, thenBody, elseBody);
            thenBody.addStatement(ASTBuilderUtil.createAssignmentStmt(pos, tempResultVarRef, ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, null)));
            elseBody.addStatement(ASTBuilderUtil.createAssignmentStmt(pos, tempResultVarRef, invocation));
            blockStmt.addStatement(ifElse);
            BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, tempResultVarRef);
            stmtExpr.setBType(invocationType);
            this.result = stmtExpr;
        }
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        List<BLangExpression> requiredArgs = invocationExpr.requiredArgs;
        if (invocationExpr.langLibInvocation && !requiredArgs.isEmpty()) {
            requiredArgs = requiredArgs.subList(1, requiredArgs.size());
        }
        requiredArgs.forEach(this::acceptNode);
        this.visitRestArgs(invocationExpr);
        if (invocationExpr.functionPointerInvocation) {
            BLangExpression expr = this.rewrite(this.desugar.getFunctionPointerExpr(invocationExpr));
            this.result = new BLangInvocation.BFunctionPointerInvocation(invocationExpr, expr);
        } else {
            invocationExpr.expr = this.rewrite(invocationExpr.expr);
            this.result = invocationExpr;
        }
    }

    private boolean isNilReturnInvocationInCollectClause(BLangInvocation invocation) {
        BInvokableSymbol symbol = (BInvokableSymbol)invocation.symbol;
        return symbol.restParam != null && !symbol.params.isEmpty() && invocation.argExprs.size() == 1 && invocation.restArgs.size() == 1;
    }

    private void visitRestArgs(BLangInvocation invocation) {
        List<BLangExpression> restArgs = invocation.restArgs;
        for (int i = 0; i < restArgs.size(); ++i) {
            BLangExpression arg = restArgs.get(i);
            if (arg.getKind() != NodeKind.SIMPLE_VARIABLE_REF) continue;
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)arg;
            BSymbol symbol = varRef.symbol;
            if (symbol == null || (symbol.tag & 0x100000004L) != 0x100000004L) continue;
            BType type = this.changeSeqSymbolType(symbol);
            varRef.setBType(type);
            restArgs.set(i, this.createRestArgsExpression(varRef, type));
        }
        restArgs.forEach(this::acceptNode);
    }

    private BType changeSeqSymbolType(BSymbol symbol) {
        if (symbol.type.tag == 54) {
            BType elementType = ((BSequenceType)symbol.type).elementType;
            ArrayList<BTupleMember> tupleMembers = new ArrayList<BTupleMember>(1);
            tupleMembers.add(new BTupleMember(elementType, Symbols.createVarSymbolForTupleMember(elementType)));
            symbol.type = new BTupleType(this.symTable.typeEnv(), null, tupleMembers, elementType, 0L);
        }
        return symbol.type;
    }

    private BLangRestArgsExpression createRestArgsExpression(BLangSimpleVarRef expr, BType type) {
        BLangRestArgsExpression bLangRestArgsExpression = new BLangRestArgsExpression();
        bLangRestArgsExpression.expr = expr;
        bLangRestArgsExpression.pos = expr.pos;
        bLangRestArgsExpression.setBType(type);
        bLangRestArgsExpression.expectedType = type;
        return bLangRestArgsExpression;
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation functionPointerInvocationExpr) {
        this.visit((BLangInvocation)functionPointerInvocationExpr);
        this.result = functionPointerInvocationExpr;
    }

    @Override
    public void visit(BLangInvocation.BLangAttachedFunctionInvocation attachedFunctionInvocation) {
        this.visit((BLangInvocation)attachedFunctionInvocation);
        this.result = attachedFunctionInvocation;
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        this.result = literalExpr;
    }

    @Override
    public void visit(BLangReturn bLangReturn) {
        bLangReturn.expr = this.rewrite(bLangReturn.expr);
        this.result = bLangReturn;
    }

    @Override
    public void visit(BLangBinaryExpr bLangBinaryExpr) {
        bLangBinaryExpr.lhsExpr = this.rewrite(bLangBinaryExpr.lhsExpr);
        bLangBinaryExpr.rhsExpr = this.rewrite(bLangBinaryExpr.rhsExpr);
        this.result = bLangBinaryExpr;
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
        this.result = commitExpr;
    }

    @Override
    public void visit(BLangAssignment bLangAssignment) {
        bLangAssignment.varRef = this.rewrite(bLangAssignment.varRef);
        bLangAssignment.expr = this.rewrite(bLangAssignment.expr);
        this.result = bLangAssignment;
    }

    @Override
    public void visit(BLangRecordLiteral bLangRecordLiteral) {
        bLangRecordLiteral.fields.forEach(field -> this.acceptNode((BLangNode)((Object)field)));
        this.result = bLangRecordLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral structLiteral) {
        this.visit((BLangRecordLiteral)structLiteral);
        this.result = structLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral mapLiteral) {
        this.visit((BLangRecordLiteral)mapLiteral);
        this.result = mapLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordKeyValueField recordKeyValue) {
        this.acceptNode(recordKeyValue.key.expr);
        recordKeyValue.valueExpr = this.rewrite(recordKeyValue.valueExpr);
        this.result = recordKeyValue;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOperatorField) {
        spreadOperatorField.expr = this.rewrite(spreadOperatorField.expr);
        this.result = spreadOperatorField;
    }

    @Override
    public void visit(BLangConstRef constRef) {
        this.result = constRef;
    }

    @Override
    public void visit(BLangNumericLiteral literalExpr) {
        this.result = literalExpr;
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        this.rewrite(varRefExpr.expressions);
        varRefExpr.restParam = this.rewrite(varRefExpr.restParam);
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue recordVarRef : varRefExpr.recordRefFields) {
            recordVarRef.variableReference = this.rewrite(recordVarRef.variableReference);
        }
        varRefExpr.restParam = this.rewrite(varRefExpr.restParam);
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        varRefExpr.message = this.rewrite(varRefExpr.message);
        varRefExpr.restVar = this.rewrite(varRefExpr.restVar);
        this.rewrite(varRefExpr.detail);
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangSimpleVarRef bLangSimpleVarRef) {
        String identifier;
        BVarSymbol originalSymbol;
        BSymbol symbol = bLangSimpleVarRef.symbol;
        if (symbol == null) {
            this.result = bLangSimpleVarRef;
            return;
        }
        if ((symbol.kind == SymbolKind.VARIABLE || symbol.kind == SymbolKind.FUNCTION) && (originalSymbol = ((BVarSymbol)symbol).originalSymbol) != null) {
            symbol = originalSymbol;
        }
        BSymbol resolvedSymbol = this.symResolver.lookupClosureVarSymbol(this.env, symbol);
        String string = identifier = bLangSimpleVarRef.variableName == null ? String.valueOf(bLangSimpleVarRef.varSymbol.name) : String.valueOf(bLangSimpleVarRef.variableName);
        if (symbol != resolvedSymbol && !FRAME_PARAMETER_NAME.equals(identifier)) {
            if (!(!this.withinLambdaOrArrowFunc && this.queryEnv != null && this.queryEnv.scope.entries.containsKey(symbol.name) || this.identifiers.containsKey(identifier))) {
                Location pos = this.currentQueryLambdaBody.pos;
                BLangFieldBasedAccess frameAccessExpr = this.desugar.getFieldAccessExpression(pos, identifier, this.symTable.anyOrErrorType, this.currentFrameSymbol);
                frameAccessExpr.expr = this.types.addConversionExprIfRequired(frameAccessExpr.expr, this.types.getSafeType(frameAccessExpr.expr.getBType(), true, false));
                if (symbol instanceof BVarSymbol) {
                    BVarSymbol varSymbol = (BVarSymbol)symbol;
                    varSymbol.originalSymbol = null;
                    if (this.withinLambdaOrArrowFunc || this.withinQuery) {
                        if (!this.withinLambdaOrArrowFunc || symbol.closure) {
                            symbol.closure = false;
                            symbol = new BVarSymbol(0L, symbol.name, this.env.scope.owner.pkgID, symbol.type, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
                            symbol.closure = true;
                            bLangSimpleVarRef.symbol = symbol;
                            bLangSimpleVarRef.varSymbol = symbol;
                            BLangSimpleVariable variable = ASTBuilderUtil.createVariable(pos, identifier, symbol.type, this.types.addConversionExprIfRequired(frameAccessExpr, symbol.type), (BVarSymbol)symbol);
                            BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDef(pos, variable);
                            this.currentQueryLambdaBody.stmts.add(0, variableDef);
                            SymbolEnv queryLambdaEnv = SymbolEnv.createFuncBodyEnv(this.currentQueryLambdaBody, this.env);
                            queryLambdaEnv.scope.define(symbol.name, symbol);
                        }
                    } else {
                        BLangSimpleVariable variable = ASTBuilderUtil.createVariable(pos, identifier, symbol.type, this.types.addConversionExprIfRequired(frameAccessExpr, symbol.type), (BVarSymbol)symbol);
                        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDef(pos, variable);
                        this.currentQueryLambdaBody.stmts.add(0, variableDef);
                        SymbolEnv queryLambdaEnv = SymbolEnv.createFuncBodyEnv(this.currentQueryLambdaBody, this.env);
                        queryLambdaEnv.scope.define(symbol.name, symbol);
                    }
                }
                this.identifiers.put(identifier, symbol);
            } else if (this.identifiers.containsKey(identifier)) {
                bLangSimpleVarRef.symbol = symbol = this.identifiers.get(identifier);
                bLangSimpleVarRef.varSymbol = symbol;
            }
        } else if (!resolvedSymbol.closure && resolvedSymbol != this.symTable.notFoundSymbol) {
            resolvedSymbol.closure = true;
        }
        this.result = bLangSimpleVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangPackageVarRef bLangPackageVarRef) {
        this.visit((BLangSimpleVarRef)bLangPackageVarRef);
        this.result = bLangPackageVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangLocalVarRef localVarRef) {
        this.visit((BLangSimpleVarRef)localVarRef);
        this.result = localVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFieldVarRef fieldVarRef) {
        this.visit((BLangSimpleVarRef)fieldVarRef);
        this.result = fieldVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFunctionVarRef functionVarRef) {
        this.visit((BLangSimpleVarRef)functionVarRef);
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        indexAccessExpr.indexExpr = this.rewrite(indexAccessExpr.indexExpr);
        indexAccessExpr.expr = this.rewrite(indexAccessExpr.expr);
        this.result = indexAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr structFieldAccessExpr) {
        this.visit((BLangIndexBasedAccess)structFieldAccessExpr);
        this.result = structFieldAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr mapAccessExpr) {
        this.visit((BLangIndexBasedAccess)mapAccessExpr);
        this.result = mapAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr arrayAccessExpr) {
        this.visit((BLangIndexBasedAccess)arrayAccessExpr);
        this.result = arrayAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTableAccessExpr tableAccessExpr) {
        this.visit((BLangIndexBasedAccess)tableAccessExpr);
        this.result = tableAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTupleAccessExpr tupleAccessExpr) {
        this.visit((BLangIndexBasedAccess)tupleAccessExpr);
        this.result = tupleAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStringAccessExpr stringAccessExpr) {
        this.visit((BLangIndexBasedAccess)stringAccessExpr);
        this.result = stringAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangXMLAccessExpr xmlAccessExpr) {
        this.visit((BLangIndexBasedAccess)xmlAccessExpr);
        this.result = xmlAccessExpr;
    }

    @Override
    public void visit(BLangTypeInit connectorInitExpr) {
        this.rewrite(connectorInitExpr.argsExpr);
        connectorInitExpr.initInvocation = this.rewrite(connectorInitExpr.initInvocation);
        this.result = connectorInitExpr;
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocationExpr) {
        this.rewrite(actionInvocationExpr.argExprs);
        actionInvocationExpr.expr = this.rewrite(actionInvocationExpr.expr);
        this.result = actionInvocationExpr;
    }

    @Override
    public void visit(BLangErrorConstructorExpr errorConstructorExpr) {
        this.acceptNode(errorConstructorExpr.errorTypeRef);
        if (errorConstructorExpr.namedArgs != null) {
            this.rewrite(errorConstructorExpr.namedArgs);
        }
        if (errorConstructorExpr.positionalArgs != null) {
            this.rewrite(errorConstructorExpr.positionalArgs);
        }
        errorConstructorExpr.errorDetail = this.rewrite(errorConstructorExpr.errorDetail);
        this.result = errorConstructorExpr;
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        ternaryExpr.expr = this.rewrite(ternaryExpr.expr);
        ternaryExpr.elseExpr = this.rewrite(ternaryExpr.elseExpr);
        ternaryExpr.thenExpr = this.rewrite(ternaryExpr.thenExpr);
        this.result = ternaryExpr;
    }

    @Override
    public void visit(BLangWaitExpr awaitExpr) {
        this.rewrite(awaitExpr.exprList);
        this.result = awaitExpr;
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        trapExpr.expr = this.rewrite(trapExpr.expr);
        this.result = trapExpr;
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        elvisExpr.lhsExpr = this.rewrite(elvisExpr.lhsExpr);
        elvisExpr.rhsExpr = this.rewrite(elvisExpr.rhsExpr);
        this.result = elvisExpr;
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        groupExpr.expression = this.rewrite(groupExpr.expression);
        this.result = groupExpr;
    }

    @Override
    public void visit(BLangLetExpression letExpr) {
        letExpr.letVarDeclarations.forEach(var -> this.acceptNode((BLangNode)((Object)var.definitionNode)));
        letExpr.expr = this.rewrite(letExpr.expr);
        this.result = letExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        List<BLangExpression> expressions = listConstructorExpr.exprs;
        this.convertSeqElementToSpread(expressions);
        this.rewrite(expressions);
        this.result = listConstructorExpr;
    }

    private void convertSeqElementToSpread(List<BLangExpression> expressions) {
        BType type;
        if (expressions.size() != 1) {
            return;
        }
        BLangExpression expr = expressions.get(0);
        if (expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return;
        }
        BSymbol symbol = ((BLangSimpleVarRef)expr).symbol;
        if (symbol == null || (symbol.tag & 0x100000004L) != 0x100000004L) {
            return;
        }
        expr.expectedType = type = this.changeSeqSymbolType(symbol);
        expr.setBType(type);
        BLangListConstructorExpr.BLangListConstructorSpreadOpExpr spreadOpExpr = new BLangListConstructorExpr.BLangListConstructorSpreadOpExpr();
        spreadOpExpr.expr = expr;
        spreadOpExpr.pos = expr.pos;
        expressions.clear();
        expressions.add(spreadOpExpr);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangListConstructorSpreadOpExpr spreadOpExpr) {
        spreadOpExpr.expr = this.rewrite(spreadOpExpr.expr);
        this.result = spreadOpExpr;
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        this.result = tableConstructorExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
        this.rewrite(tupleLiteral.exprs);
        this.result = tupleLiteral;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteral) {
        this.rewrite(jsonArrayLiteral.exprs);
        this.result = jsonArrayLiteral;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral arrayLiteral) {
        this.rewrite(arrayLiteral.exprs);
        this.result = arrayLiteral;
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        unaryExpr.expr = this.rewrite(unaryExpr.expr);
        this.result = unaryExpr;
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
        this.result = accessExpr;
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        this.result = xmlQName;
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        xmlAttribute.name = this.rewrite(xmlAttribute.name);
        xmlAttribute.value = this.rewrite(xmlAttribute.value);
        this.result = xmlAttribute;
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        xmlElementLiteral.startTagName = this.rewrite(xmlElementLiteral.startTagName);
        xmlElementLiteral.endTagName = this.rewrite(xmlElementLiteral.endTagName);
        this.rewrite(xmlElementLiteral.attributes);
        this.rewrite(xmlElementLiteral.children);
        this.result = xmlElementLiteral;
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        this.rewrite(xmlTextLiteral.textFragments);
        xmlTextLiteral.concatExpr = this.rewrite(xmlTextLiteral.concatExpr);
        this.result = xmlTextLiteral;
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        this.rewrite(xmlCommentLiteral.textFragments);
        xmlCommentLiteral.concatExpr = this.rewrite(xmlCommentLiteral.concatExpr);
        this.result = xmlCommentLiteral;
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        this.rewrite(xmlProcInsLiteral.dataFragments);
        xmlProcInsLiteral.dataConcatExpr = this.rewrite(xmlProcInsLiteral.dataConcatExpr);
        this.result = xmlProcInsLiteral;
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        this.rewrite(xmlQuotedString.textFragments);
        xmlQuotedString.concatExpr = this.rewrite(xmlQuotedString.concatExpr);
        this.result = xmlQuotedString;
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        this.rewrite(stringTemplateLiteral.exprs);
        this.result = stringTemplateLiteral;
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        this.rewrite(rawTemplateLiteral.strings);
        this.rewrite(rawTemplateLiteral.insertions);
        this.result = rawTemplateLiteral;
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        bLangArrowFunction.params.forEach(this::acceptNode);
        boolean prevWithinLambdaFunc = this.withinLambdaOrArrowFunc;
        this.withinLambdaOrArrowFunc = true;
        this.acceptNode(bLangArrowFunction.body);
        this.withinLambdaOrArrowFunc = prevWithinLambdaFunc;
        this.result = bLangArrowFunction;
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        bLangVarArgsExpression.expr = this.rewrite(bLangVarArgsExpression.expr);
        this.result = bLangVarArgsExpression;
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        bLangNamedArgsExpression.expr = this.rewrite(bLangNamedArgsExpression.expr);
        this.result = bLangNamedArgsExpression;
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        assignableExpr.lhsExpr = this.rewrite(assignableExpr.lhsExpr);
        this.result = assignableExpr;
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.containsCheckExpr = true;
        if (this.checkedErrorList != null && checkedExpr.equivalentErrorTypeList != null) {
            this.checkedErrorList.addAll(checkedExpr.equivalentErrorTypeList);
        }
        checkedExpr.expr = this.rewrite(checkedExpr.expr);
        this.result = checkedExpr;
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanickedExpr) {
        checkPanickedExpr.expr = this.rewrite(checkPanickedExpr.expr);
        this.result = checkPanickedExpr;
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        this.acceptNode(serviceConstructorExpr.serviceNode);
        this.result = serviceConstructorExpr;
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        typeTestExpr.expr = this.rewrite(typeTestExpr.expr);
        this.result = typeTestExpr;
    }

    @Override
    public void visit(BLangIsLikeExpr typeTestExpr) {
        typeTestExpr.expr = this.rewrite(typeTestExpr.expr);
        this.result = typeTestExpr;
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
        this.result = ignoreExpr;
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        this.result = annotAccessExpr;
    }

    @Override
    public void visit(BLangXMLNS.BLangLocalXMLNS xmlnsNode) {
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangXMLNS.BLangPackageXMLNS xmlnsNode) {
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangXMLSequenceLiteral bLangXMLSequenceLiteral) {
        this.rewrite(bLangXMLSequenceLiteral.xmlItems);
        this.result = bLangXMLSequenceLiteral;
    }

    @Override
    public void visit(BLangStatementExpression bLangStatementExpression) {
        bLangStatementExpression.expr = this.rewrite(bLangStatementExpression.expr);
        this.acceptNode(bLangStatementExpression.stmt);
        this.result = bLangStatementExpression;
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        this.acceptNode(bLangTupleVariable.restVariable);
        bLangTupleVariable.memberVariables.forEach(this::acceptNode);
        this.result = bLangTupleVariable;
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        this.acceptNode(bLangTupleVariableDef.var.restVariable);
        bLangTupleVariableDef.var.expr = this.rewrite(bLangTupleVariableDef.var.expr);
        if (bLangTupleVariableDef.var.memberVariables != null) {
            bLangTupleVariableDef.var.memberVariables.forEach(this::acceptNode);
        }
        this.result = bLangTupleVariableDef;
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        this.acceptNode(bLangErrorVariable.message);
        bLangErrorVariable.detail.forEach(var -> this.acceptNode(var.valueBindingPattern));
        this.acceptNode(bLangErrorVariable.restDetail);
        bLangErrorVariable.detailExpr = this.rewrite(bLangErrorVariable.detailExpr);
        this.result = bLangErrorVariable;
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        this.acceptNode(bLangErrorVariableDef.errorVariable);
        this.result = bLangErrorVariableDef;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        this.result = workerFlushExpr;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        this.result = syncSendExpr;
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        waitForAllExpr.keyValuePairs.forEach(this::acceptNode);
        this.result = waitForAllExpr;
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
        this.result = waitLiteral;
    }

    @Override
    public void visit(BLangMarkdownReferenceDocumentation bLangMarkdownReferenceDocumentation) {
        this.result = bLangMarkdownReferenceDocumentation;
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitKeyValue waitKeyValue) {
        waitKeyValue.key = this.rewrite(waitKeyValue.key);
        waitKeyValue.valueExpr = this.rewrite(waitKeyValue.valueExpr);
        this.result = waitKeyValue;
    }

    @Override
    public void visit(BLangXMLElementFilter xmlElementFilter) {
        xmlElementFilter.impConversionExpr = this.rewrite(xmlElementFilter.impConversionExpr);
        this.result = xmlElementFilter;
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        xmlElementAccess.expr = this.rewrite(xmlElementAccess.expr);
        this.result = xmlElementAccess;
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        xmlNavigation.expr = this.rewrite(xmlNavigation.expr);
        this.result = xmlNavigation;
    }

    @Override
    public void visit(BLangExtendedXMLNavigationAccess extendedXmlNavigationAccess) {
        extendedXmlNavigationAccess.stepExpr = this.rewrite(extendedXmlNavigationAccess.stepExpr);
        this.result = extendedXmlNavigationAccess;
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        blockNode.stmts.forEach(this::acceptNode);
        this.result = blockNode;
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockStmtNode) {
        this.result = lockStmtNode;
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockNode) {
        this.result = unLockNode;
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignNode) {
        compoundAssignNode.expr = this.rewrite(compoundAssignNode.expr);
        compoundAssignNode.modifiedExpr = this.rewrite(compoundAssignNode.modifiedExpr);
        compoundAssignNode.varRef = this.rewrite(compoundAssignNode.varRef);
        this.result = compoundAssignNode;
    }

    @Override
    public void visit(BLangRetry retryNode) {
        this.result = retryNode;
    }

    @Override
    public void visit(BLangContinue continueNode) {
        this.result = continueNode;
    }

    @Override
    public void visit(BLangBreak breakNode) {
        this.result = breakNode;
    }

    @Override
    public void visit(BLangPanic panicNode) {
        panicNode.expr = this.rewrite(panicNode.expr);
        this.result = panicNode;
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.acceptNode(xmlnsStmtNode.xmlnsDecl);
        this.result = xmlnsStmtNode;
    }

    @Override
    public void visit(BLangIf ifNode) {
        ifNode.expr = this.rewrite(ifNode.expr);
        this.acceptNode(ifNode.body);
        this.acceptNode(ifNode.elseStmt);
        this.result = ifNode;
    }

    @Override
    public void visit(BLangMatchStatement matchStmt) {
        this.acceptNode(matchStmt.expr);
        matchStmt.matchClauses.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangMatchClause matchClause) {
        matchClause.matchPatterns.forEach(this::acceptNode);
        this.acceptNode(matchClause.matchGuard);
        HashMap<String, BSymbol> prevIdentifiers = new HashMap<String, BSymbol>(this.identifiers);
        this.identifiers.putAll(matchClause.declaredVars);
        this.acceptNode(matchClause.blockStmt);
        this.identifiers = prevIdentifiers;
    }

    @Override
    public void visit(BLangVarBindingPatternMatchPattern varBindingPattern) {
    }

    @Override
    public void visit(BLangConstPattern constPattern) {
    }

    @Override
    public void visit(BLangWildCardMatchPattern constPattern) {
    }

    @Override
    public void visit(BLangMatchGuard matchGuard) {
        this.acceptNode(matchGuard.expr);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        SymbolEnv prevQueryEnv = this.queryEnv;
        boolean prevWithinQuery = this.withinQuery;
        this.withinQuery = true;
        queryAction.getQueryClauses().forEach(this::acceptNode);
        this.withinQuery = prevWithinQuery;
        this.queryEnv = prevQueryEnv;
        this.result = queryAction;
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        SymbolEnv prevQueryEnv = this.queryEnv;
        boolean prevWithinQuery = this.withinQuery;
        this.withinQuery = true;
        queryExpr.getQueryClauses().forEach(this::acceptNode);
        this.withinQuery = prevWithinQuery;
        this.queryEnv = prevQueryEnv;
        this.result = queryExpr;
    }

    @Override
    public void visit(BLangForeach foreach) {
        foreach.collection = this.rewrite(foreach.collection);
        this.acceptNode(foreach.body);
        this.result = foreach;
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        this.queryEnv = fromClause.env;
        fromClause.collection = this.rewrite(fromClause.collection);
        VariableNode var = fromClause.variableDefinitionNode.getVariable();
        if (var.getKind() == NodeKind.VARIABLE) {
            BLangSimpleVariable simpleVar = (BLangSimpleVariable)fromClause.variableDefinitionNode.getVariable();
            this.identifiers.put(simpleVar.name.value, simpleVar.symbol);
        }
        this.result = fromClause;
    }

    @Override
    public void visit(BLangJoinClause joinClause) {
        joinClause.collection = this.rewrite(joinClause.collection);
        this.acceptNode((BLangVariable)joinClause.variableDefinitionNode.getVariable());
        joinClause.onClause.lhsExpr = this.rewrite(joinClause.onClause.lhsExpr);
        joinClause.onClause.rhsExpr = this.rewrite(joinClause.onClause.rhsExpr);
        this.result = joinClause;
    }

    @Override
    public void visit(BLangLetClause letClause) {
        for (BLangLetVariable letVar : letClause.letVarDeclarations) {
            this.acceptNode((BLangNode)((Object)letVar.definitionNode));
        }
        this.result = letClause;
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        selectClause.expression = this.rewrite(selectClause.expression);
        this.result = selectClause;
    }

    @Override
    public void visit(BLangCollectClause collectClause) {
        this.updateIdentifiers(collectClause.env);
        collectClause.expression = this.rewrite(collectClause.expression);
        this.result = collectClause;
    }

    void updateIdentifiers(SymbolEnv env) {
        for (Map.Entry<String, BSymbol> identifier : this.identifiers.entrySet()) {
            BSymbol symbol = this.symResolver.lookupSymbolInGivenScope(env, Names.fromString(identifier.getKey()), 0x100000004L);
            if (symbol == this.symTable.notFoundSymbol || identifier.getValue().closure) continue;
            this.identifiers.put(identifier.getKey(), symbol);
        }
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        whereClause.expression = this.rewrite(whereClause.expression);
        this.result = whereClause;
    }

    @Override
    public void visit(BLangDoClause doClause) {
        doClause.body.getStatements().forEach(this::acceptNode);
        this.result = doClause;
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause) {
        onConflictClause.expression = this.rewrite(onConflictClause.expression);
        this.result = onConflictClause;
    }

    @Override
    public void visit(BLangLimitClause limitClause) {
        limitClause.expression = this.rewrite(limitClause.expression);
        this.result = limitClause;
    }

    @Override
    public void visit(BLangOrderByClause orderByClause) {
        for (OrderKeyNode orderKey : orderByClause.orderByKeyList) {
            ((BLangOrderKey)orderKey).expression = this.rewrite(((BLangOrderKey)orderKey).expression);
        }
        this.result = orderByClause;
    }

    @Override
    public void visit(BLangGroupByClause groupByClause) {
        groupByClause.groupingKeyList.forEach(this::acceptNode);
        this.updateIdentifiers(groupByClause.env);
        this.result = groupByClause;
    }

    @Override
    public void visit(BLangGroupingKey groupingKey) {
        this.acceptNode(groupingKey.variableDef);
        groupingKey.variableRef = this.rewrite(groupingKey.variableRef);
        this.result = groupingKey;
    }

    @Override
    public void visit(BLangWhile whileNode) {
        whileNode.expr = this.rewrite(whileNode.expr);
        this.acceptNode(whileNode.body);
        this.result = whileNode;
    }

    @Override
    public void visit(BLangDo doNode) {
        doNode.body.stmts.forEach(this::acceptNode);
        this.acceptNode(doNode.onFailClause);
        this.result = doNode;
    }

    @Override
    public void visit(BLangOnFailClause onFailClause) {
        onFailClause.body.stmts.forEach(this::acceptNode);
        this.result = onFailClause;
    }

    @Override
    public void visit(BLangFail failNode) {
        failNode.expr = this.rewrite(failNode.expr);
        this.result = failNode;
    }

    @Override
    public void visit(BLangLock lockNode) {
        this.acceptNode(lockNode.body);
        this.result = lockNode;
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.acceptNode(transactionNode.transactionBody);
        this.result = transactionNode;
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        stmt.varRef = this.rewrite(stmt.varRef);
        stmt.expr = this.rewrite(stmt.expr);
        this.result = stmt;
    }

    @Override
    public void visit(BLangRecordDestructure stmt) {
        stmt.expr = this.rewrite(stmt.expr);
        stmt.varRef = this.rewrite(stmt.varRef);
        this.result = stmt;
    }

    @Override
    public void visit(BLangErrorDestructure stmt) {
        stmt.expr = this.rewrite(stmt.expr);
        stmt.varRef = this.rewrite(stmt.varRef);
        this.result = stmt;
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        forkJoin.workers.forEach(this::acceptNode);
        this.result = forkJoin;
    }

    @Override
    public void visit(BLangWorkerAsyncSendExpr asyncSendExpr) {
        this.acceptNode(asyncSendExpr.expr);
    }

    @Override
    public void visit(BLangAlternateWorkerReceive altWorkerReceive) {
        for (BLangWorkerReceive bLangWorkerReceive : altWorkerReceive.getWorkerReceives()) {
            this.acceptNode(bLangWorkerReceive);
        }
        this.result = altWorkerReceive;
    }

    @Override
    public void visit(BLangMultipleWorkerReceive multipleWorkerReceive) {
        for (BLangMultipleWorkerReceive.BLangReceiveField rvField : multipleWorkerReceive.getReceiveFields()) {
            this.acceptNode(rvField.getKey());
            this.acceptNode(rvField.getWorkerReceive());
        }
        this.result = multipleWorkerReceive;
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        this.result = workerReceiveNode;
    }

    @Override
    public void visit(BLangInvocation.BLangResourceAccessInvocation resourceAccessInvocation) {
        this.rewrite(resourceAccessInvocation.argExprs);
        this.rewrite(resourceAccessInvocation.restArgs);
        this.rewrite(resourceAccessInvocation.resourceAccessPathSegments.exprs);
        resourceAccessInvocation.expr = this.rewrite(resourceAccessInvocation.expr);
        this.result = resourceAccessInvocation;
    }

    @Override
    public void visit(BLangRegExpTemplateLiteral regExpTemplateLiteral) {
        List<BLangExpression> interpolationsList = this.symResolver.getListOfInterpolations(regExpTemplateLiteral.reDisjunction.sequenceList);
        this.rewrite(interpolationsList);
        this.result = regExpTemplateLiteral;
    }

    @Override
    public void visit(BLangNaturalExpression naturalExpression) {
        this.rewrite(naturalExpression.arguments);
        this.rewrite(naturalExpression.strings);
        this.rewrite(naturalExpression.insertions);
        this.result = naturalExpression;
    }

    private void acceptNode(BLangNode node) {
        if (node == null) {
            return;
        }
        node.accept(this);
    }

    <E extends BLangNode> E rewrite(E node) {
        if (node == null) {
            return null;
        }
        node.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        return (E)resultNode;
    }

    private <E extends BLangNode> List<E> rewrite(List<E> nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewrite((BLangNode)nodeList.get(i)));
        }
        return nodeList;
    }
}

