/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.converters;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.repository.CompilerInput;

public class FileSystemSourceInput
implements CompilerInput {
    private final Path path;
    private Path packageRoot;
    private byte[] code = null;
    private SyntaxTree tree = null;
    private String entryName = null;

    public FileSystemSourceInput(Path path) {
        this.path = path;
    }

    public FileSystemSourceInput(Path filePath, Path packageRoot) {
        this.path = filePath;
        this.packageRoot = packageRoot;
    }

    @Override
    public String getEntryName() {
        if (this.entryName != null) {
            return this.entryName;
        }
        if (this.packageRoot != null) {
            File pkgRoot = new File(this.packageRoot.toString());
            File file = new File(this.path.toString());
            return pkgRoot.toURI().relativize(file.toURI()).getPath();
        }
        Path fileName = this.path.getFileName();
        this.entryName = fileName != null ? fileName.toString() : this.path.toString();
        return this.entryName;
    }

    @Override
    public byte[] getCode() {
        if (this.code != null) {
            return this.code;
        }
        try {
            byte[] code = Files.readAllBytes(this.path);
            if (this.isBLangBinaryFile(this.path)) {
                this.path.getFileSystem().close();
            }
            this.code = code;
            return code;
        }
        catch (IOException e) {
            throw new BLangCompilerException("Error reading source file " + String.valueOf(this.path));
        }
    }

    @Override
    public SyntaxTree getTree() {
        if (this.tree != null) {
            return this.tree;
        }
        this.tree = SyntaxTree.from((TextDocument)TextDocuments.from(FileSystemSourceInput.getCodeSupplier(this.isBLangBinaryFile(this.path), this.path)), (String)this.path.getFileName().toString());
        return this.tree;
    }

    public Path getPath() {
        return this.path;
    }

    public String toString() {
        return this.path.toString();
    }

    private boolean isBLangBinaryFile(Path path) {
        return path.toString().endsWith(".bala");
    }

    private static Supplier<String> getCodeSupplier(boolean isBLangBinaryFile, Path path) {
        return () -> {
            try {
                byte[] code = Files.readAllBytes(path);
                if (isBLangBinaryFile) {
                    path.getFileSystem().close();
                }
                return new String(code);
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading source file " + String.valueOf(path), e);
            }
        };
    }
}

