/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.converters;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompilerInput;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.FileSystemSourceInput;
import org.wso2.ballerinalang.compiler.packaging.converters.FilterSearch;
import org.wso2.ballerinalang.compiler.packaging.converters.SortablePath;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.RepoUtils;
import org.wso2.ballerinalang.util.TomlParserUtils;

public class PathConverter
implements Converter<Path> {
    private final Path root;
    private final PathMatcher isResourceFile;
    private final PathMatcher isTestResourceFile;

    public PathConverter(Path root) {
        this.root = root;
        this.isResourceFile = root.getFileSystem().getPathMatcher("glob:src/*/resources/**");
        this.isTestResourceFile = root.getFileSystem().getPathMatcher("glob:src/*/tests/resources/**");
    }

    private boolean isBalWithTest(Path path, BasicFileAttributes attributes) {
        Path fileName = path.getFileName();
        Path relativeToRoot = this.root.relativize(path);
        if (this.isResourceFile.matches(relativeToRoot) || this.isTestResourceFile.matches(relativeToRoot)) {
            return false;
        }
        return attributes.isRegularFile() && fileName != null && fileName.toString().endsWith(".bal");
    }

    @Override
    public Path combine(Path path, String pathPart) {
        return path.resolve(pathPart);
    }

    @Override
    public Stream<Path> getLatestVersion(Path path, PackageID packageID) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                List<Path> pathList;
                try (Stream<Path> stream = Files.list(path);){
                    pathList = stream.map(SortablePath::new).filter(SortablePath::valid).sorted(Comparator.reverseOrder()).limit(1L).map(SortablePath::getPath).toList();
                }
                if (packageID != null && packageID.version.value.isEmpty() && !packageID.orgName.equals(Names.BUILTIN_ORG) && !packageID.orgName.equals(Names.ANON_ORG) && !pathList.isEmpty()) {
                    packageID.version = new Name(pathList.get(0).toFile().getName());
                }
                return pathList.stream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Stream.of(new Path[0]);
    }

    @Override
    public Stream<Path> expandBalWithTest(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Stream<Path> stream;
            block9: {
                Stream<Path> paths = Files.find(path, Integer.MAX_VALUE, this::isBalWithTest, new FileVisitOption[0]);
                try {
                    stream = paths.sorted();
                    if (paths == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (paths != null) {
                            try {
                                paths.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                paths.close();
            }
            return stream;
        }
        return Stream.of(new Path[0]);
    }

    @Override
    public Stream<Path> expandBal(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                ArrayList<Path> excludePaths = new ArrayList<Path>();
                excludePaths.add(Path.of("tests", new String[0]));
                excludePaths.add(Path.of("resources", new String[0]));
                FilterSearch filterSearch = new FilterSearch(excludePaths);
                Files.walkFileTree(path, filterSearch);
                return filterSearch.getPathList().stream().sorted();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Stream.of(new Path[0]);
    }

    @Override
    public Path start() {
        return this.root;
    }

    @Override
    public Stream<CompilerInput> finalize(Path path, PackageID pkgId) {
        if (pkgId.version.value.isEmpty() && !pkgId.orgName.equals(Names.BUILTIN_ORG) && !pkgId.orgName.equals(Names.ANON_ORG)) {
            Manifest manifest = TomlParserUtils.getManifest(this.root);
            pkgId.version = new Name(manifest.getProject().getVersion());
        }
        if ((!ProjectDirs.isProject(this.root) || RepoUtils.isBallerinaStandaloneFile(path)) && Files.isRegularFile(path, new LinkOption[0])) {
            return Stream.of(new FileSystemSourceInput(path, this.root.resolve(pkgId.name.value)));
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return Stream.of(new FileSystemSourceInput(path, this.root.resolve("src").resolve(pkgId.name.value)));
        }
        return Stream.of(new CompilerInput[0]);
    }

    public String toString() {
        return this.root.toString();
    }

    public Path getRoot() {
        return this.root;
    }
}

