/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class BLangAnonymousModelHelper {
    private final Map<PackageID, Integer> anonTypeCount;
    private final Map<PackageID, Integer> anonServiceCount;
    private final Map<PackageID, Integer> anonFunctionCount;
    private final Map<PackageID, Integer> anonForkCount;
    private final Map<PackageID, Integer> distinctTypeIdCount;
    private final Map<PackageID, Integer> rawTemplateTypeCount;
    private final Map<PackageID, Integer> tupleVarCount;
    private final Map<PackageID, Integer> recordVarCount;
    private final Map<PackageID, Integer> errorVarCount;
    private final Map<PackageID, Integer> intersectionRecordCount;
    private final Map<PackageID, Integer> intersectionErrorCount;
    private final Map<PackageID, Integer> naturalGeneratorCount;
    private final Map<PackageID, Map<String, Integer>> anonTypesNamesPerPkg;
    public static final String ANON_PREFIX = "$anon";
    private static final String ANON_TYPE = "$anonType$";
    public static final String LAMBDA = "$lambda$";
    private static final String SERVICE = "$$service$";
    private static final String ANON_SERVICE = "$anonService$";
    private static final String BUILTIN_ANON_TYPE = "$anonType$builtin$";
    private static final String BUILTIN_LAMBDA = "$lambda$builtin$";
    private static final String FORK = "$fork$";
    private static final String RAW_TEMPLATE_TYPE = "$rawTemplate$";
    private static final String ANON_INTERSECTION_RECORD = "$anonIntersectionRecordType$";
    private static final String ANON_INTERSECTION_ERROR_TYPE = "$anonIntersectionErrorType$";
    private static final String TUPLE_VAR = "$tupleVar$";
    private static final String RECORD_VAR = "$recordVar$";
    private static final String ERROR_VAR = "$errorVar$";
    private static final String NATURAL_GENERATOR_VAR = "$naturalGeneratorVar$";
    private static final String DOLLAR = "$";
    private static final CompilerContext.Key<BLangAnonymousModelHelper> ANONYMOUS_MODEL_HELPER_KEY = new CompilerContext.Key();

    private BLangAnonymousModelHelper(CompilerContext context) {
        context.put(ANONYMOUS_MODEL_HELPER_KEY, this);
        this.anonTypeCount = new HashMap<PackageID, Integer>();
        this.anonServiceCount = new HashMap<PackageID, Integer>();
        this.anonFunctionCount = new HashMap<PackageID, Integer>();
        this.anonForkCount = new HashMap<PackageID, Integer>();
        this.rawTemplateTypeCount = new HashMap<PackageID, Integer>();
        this.tupleVarCount = new HashMap<PackageID, Integer>();
        this.recordVarCount = new HashMap<PackageID, Integer>();
        this.errorVarCount = new HashMap<PackageID, Integer>();
        this.intersectionRecordCount = new HashMap<PackageID, Integer>();
        this.intersectionErrorCount = new HashMap<PackageID, Integer>();
        this.distinctTypeIdCount = new HashMap<PackageID, Integer>();
        this.naturalGeneratorCount = new HashMap<PackageID, Integer>();
        this.anonTypesNamesPerPkg = new HashMap<PackageID, Map<String, Integer>>();
    }

    public static BLangAnonymousModelHelper getInstance(CompilerContext context) {
        BLangAnonymousModelHelper helper = context.get(ANONYMOUS_MODEL_HELPER_KEY);
        if (helper == null) {
            helper = new BLangAnonymousModelHelper(context);
        }
        return helper;
    }

    public String getNextAnonymousTypeKey(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.anonTypeCount.get(packageID)).orElse(0);
        this.anonTypeCount.put(packageID, nextValue + 1);
        if (PackageID.ANNOTATIONS.equals(packageID)) {
            return "$anonType$builtin$_" + nextValue;
        }
        return "$anonType$_" + nextValue;
    }

    public String getNextAnonymousTypeKey(PackageID packageID, Collection<String> suffixes) {
        if (suffixes.isEmpty()) {
            return this.getNextAnonymousTypeKey(packageID);
        }
        return this.createAnonTypeName(suffixes, packageID);
    }

    private String createAnonTypeName(Collection<String> suffixes, PackageID pkgId) {
        StringBuilder name = new StringBuilder(ANON_TYPE);
        for (String suffix : suffixes) {
            name.append(suffix).append(DOLLAR);
        }
        Map anonTypesNames = this.anonTypesNamesPerPkg.computeIfAbsent(pkgId, key -> new HashMap());
        String nameStr = name.toString();
        anonTypesNames.putIfAbsent(nameStr, 0);
        Integer id = (Integer)anonTypesNames.get(nameStr);
        anonTypesNames.put(nameStr, id + 1);
        return String.valueOf(name) + "_" + id;
    }

    String getNextAnonymousServiceTypeKey(PackageID packageID, String serviceName) {
        Integer nextValue = Optional.ofNullable(this.anonServiceCount.get(packageID)).orElse(0);
        this.anonServiceCount.put(packageID, nextValue + 1);
        return serviceName + "$$service$_" + nextValue;
    }

    String getNextAnonymousServiceVarKey(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.anonServiceCount.get(packageID)).orElse(0);
        this.anonServiceCount.put(packageID, nextValue + 1);
        return "$anonService$_" + nextValue;
    }

    public String getNextAnonymousFunctionKey(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.anonFunctionCount.get(packageID)).orElse(0);
        this.anonFunctionCount.put(packageID, nextValue + 1);
        return "$lambda$_" + nextValue;
    }

    public String getNextAnonymousForkKey(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.anonFunctionCount.get(packageID)).orElse(0);
        this.anonFunctionCount.put(packageID, nextValue + 1);
        return "$fork$_" + nextValue;
    }

    public String getNextAnonymousTypeId(PackageID packageID) {
        Integer nextValue = Optional.ofNullable(this.distinctTypeIdCount.get(packageID)).orElse(0);
        this.distinctTypeIdCount.put(packageID, nextValue + 1);
        return nextValue.toString();
    }

    public String getNextRawTemplateTypeKey(PackageID packageID, Name rawTemplateTypeName) {
        Integer nextValue = this.rawTemplateTypeCount.getOrDefault(packageID, 0);
        this.rawTemplateTypeCount.put(packageID, nextValue + 1);
        return RAW_TEMPLATE_TYPE + rawTemplateTypeName.value + "$_" + nextValue;
    }

    public String getNextTupleVarKey(PackageID packageID) {
        Integer nextValue = this.tupleVarCount.getOrDefault(packageID, 0);
        this.tupleVarCount.put(packageID, nextValue + 1);
        return "$tupleVar$_" + nextValue;
    }

    public String getNextRecordVarKey(PackageID packageID) {
        Integer nextValue = this.recordVarCount.getOrDefault(packageID, 0);
        this.recordVarCount.put(packageID, nextValue + 1);
        return "$recordVar$_" + nextValue;
    }

    public String getNextErrorVarKey(PackageID packageID) {
        Integer nextValue = this.errorVarCount.getOrDefault(packageID, 0);
        this.errorVarCount.put(packageID, nextValue + 1);
        return "$errorVar$_" + nextValue;
    }

    public boolean isAnonymousType(BSymbol symbol) {
        return symbol.name.value.startsWith(ANON_TYPE);
    }

    public String getNextAnonymousIntersectionErrorDetailTypeName(PackageID packageID) {
        Integer nextValue = this.intersectionRecordCount.getOrDefault(packageID, 0);
        this.intersectionRecordCount.put(packageID, nextValue + 1);
        return "$anonIntersectionRecordType$_" + nextValue;
    }

    public String getNextAnonymousIntersectionErrorTypeName(PackageID packageID) {
        Integer nextValue = this.intersectionErrorCount.getOrDefault(packageID, 0);
        this.intersectionErrorCount.put(packageID, nextValue + 1);
        return "$anonIntersectionErrorType$_" + nextValue;
    }

    public String getNextNaturalGeneratorVariableName(PackageID packageID) {
        Integer nextValue = this.naturalGeneratorCount.getOrDefault(packageID, 0);
        this.naturalGeneratorCount.put(packageID, nextValue + 1);
        return "$naturalGeneratorVar$_" + nextValue;
    }
}

