/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.identifier.Utils;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.ActionNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.statements.StatementNode;
import org.ballerinalang.model.tree.statements.VariableDefinitionNode;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.ballerinalang.util.diagnostic.DiagnosticHintCode;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.MainFunctionValidator;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ReachabilityAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeChecker;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangRetrySpec;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.SimpleBLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangCaptureBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorCauseBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorFieldBindingPatterns;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorMessageBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangFieldBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangListBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangMappingBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangNamedArgBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangSimpleBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangWildCardBindingPattern;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangCollectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupingKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAlternateWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCollectContextInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExtendedXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInferredTypedescDefaultNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchGuard;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMultipleWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNaturalExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRegExpTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangValueExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerAsyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSendReceiveExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLFilterStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLIndexedStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLMethodCallStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangConstPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorCauseMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorFieldMatchPatterns;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorMessageMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangFieldMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangListMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMappingMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangNamedArgMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangSimpleMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangVarBindingPatternMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangWildCardMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class CodeAnalyzer
extends SimpleBLangNodeAnalyzer<AnalyzerData> {
    private static final CompilerContext.Key<CodeAnalyzer> CODE_ANALYZER_KEY = new CompilerContext.Key();
    private static final String NO_MESSAGE_ERROR_TYPE = "NoMessage";
    private static final String NATURAL_LANG_LIB_NAME = "lang.natural";
    private static final String CODE_ANNOTATION = "code";
    private final SymbolResolver symResolver;
    private final SymbolTable symTable;
    private final Types types;
    private final BLangDiagnosticLog dlog;
    private final TypeChecker typeChecker;
    private final Names names;
    private final ReachabilityAnalyzer reachabilityAnalyzer;
    private final boolean experimentalFeaturesEnabled;

    public static CodeAnalyzer getInstance(CompilerContext context) {
        CodeAnalyzer codeGenerator = context.get(CODE_ANALYZER_KEY);
        if (codeGenerator == null) {
            codeGenerator = new CodeAnalyzer(context);
        }
        return codeGenerator;
    }

    public CodeAnalyzer(CompilerContext context) {
        context.put(CODE_ANALYZER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.typeChecker = TypeChecker.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.reachabilityAnalyzer = ReachabilityAnalyzer.getInstance(context);
        this.experimentalFeaturesEnabled = Boolean.parseBoolean(CompilerOptions.getInstance(context).get(CompilerOptionName.EXPERIMENTAL));
    }

    public BLangPackage analyze(BLangPackage pkgNode) {
        AnalyzerData data = new AnalyzerData();
        this.visitNode(pkgNode, data);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode, AnalyzerData data) {
        this.dlog.setCurrentPackageId(pkgNode.packageID);
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.CODE_ANALYZE)) {
            return;
        }
        data.parent = pkgNode;
        data.env = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        this.analyzeTopLevelNodes(pkgNode, data);
        pkgNode.getTestablePkgs().forEach(testablePackage -> this.visitNode((BLangNode)testablePackage, data));
    }

    @Override
    public void visit(BLangTestablePackage node, AnalyzerData data) {
        this.visit((BLangPackage)node, data);
    }

    private void analyzeTopLevelNodes(BLangPackage pkgNode, AnalyzerData data) {
        List<TopLevelNode> topLevelNodes = pkgNode.topLevelNodes;
        for (int i = 0; i < topLevelNodes.size(); ++i) {
            this.analyzeNode((BLangNode)((Object)topLevelNodes.get(i)), data);
        }
        pkgNode.completedPhases.add(CompilerPhase.CODE_ANALYZE);
    }

    @Override
    public void analyzeNode(BLangNode node, AnalyzerData data) {
        BLangNode parent;
        SymbolEnv prevEnv = data.env;
        node.parent = parent = data.parent;
        data.parent = node;
        this.visitNode(node, data);
        data.parent = parent;
        data.env = prevEnv;
    }

    private void analyzeTypeNode(BLangType node, AnalyzerData data) {
        if (node == null) {
            return;
        }
        this.analyzeNode((BLangNode)node, data);
    }

    @Override
    public void visit(BLangCompilationUnit compUnitNode, AnalyzerData data) {
        compUnitNode.topLevelNodes.forEach(e -> this.analyzeNode((BLangNode)((Object)e), data));
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition, AnalyzerData data) {
        this.analyzeTypeNode(typeDefinition.typeNode, data);
        typeDefinition.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, data));
    }

    @Override
    public void visit(BLangClassDefinition classDefinition, AnalyzerData data) {
        data.env = SymbolEnv.createClassEnv(classDefinition, classDefinition.symbol.scope, data.env);
        for (BLangSimpleVariable field : classDefinition.fields) {
            DefaultValueState prevDefaultValueState = data.defaultValueState;
            data.defaultValueState = DefaultValueState.OBJECT_FIELD_INITIALIZER;
            this.analyzeNode((BLangNode)field, data);
            data.defaultValueState = prevDefaultValueState;
        }
        ArrayList<BLangFunction> bLangFunctionList = new ArrayList<BLangFunction>(classDefinition.functions);
        if (classDefinition.initFunction != null) {
            bLangFunctionList.add(classDefinition.initFunction);
        }
        bLangFunctionList.sort(Comparator.comparingInt(function -> function.pos.lineRange().startLine().line()));
        for (BLangFunction function2 : bLangFunctionList) {
            this.analyzeNode((BLangNode)function2, data);
        }
        classDefinition.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, data));
    }

    @Override
    public void visit(BLangObjectConstructorExpression objectConstructorExpression, AnalyzerData data) {
        this.visit(objectConstructorExpression.typeInit, data);
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef, AnalyzerData data) {
        this.analyzeNode((BLangNode)bLangTupleVariableDef.var, data);
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef, AnalyzerData data) {
        this.analyzeNode((BLangNode)bLangRecordVariableDef.var, data);
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef, AnalyzerData data) {
        this.analyzeNode((BLangNode)bLangErrorVariableDef.errorVariable, data);
    }

    @Override
    public void visit(BLangResourceFunction funcNode, AnalyzerData data) {
        this.visit((BLangFunction)funcNode, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(BLangFunction funcNode, AnalyzerData data) {
        this.validateParams(funcNode, data);
        this.analyzeNode((BLangNode)funcNode.returnTypeNode, data);
        boolean isLambda = funcNode.flagSet.contains((Object)Flag.LAMBDA);
        if (isLambda) {
            return;
        }
        if (Symbols.isPublic(funcNode.symbol) && !this.isMethodInServiceDeclaration(funcNode)) {
            funcNode.symbol.params.forEach(symbol -> this.analyzeExportableTypeRef(funcNode.symbol, symbol.type.tsymbol, true, funcNode.pos));
            if (funcNode.symbol.restParam != null) {
                this.analyzeExportableTypeRef(funcNode.symbol, funcNode.symbol.restParam.type.tsymbol, true, funcNode.restParam.pos);
            }
            this.analyzeExportableTypeRef(funcNode.symbol, funcNode.symbol.retType.tsymbol, true, funcNode.returnTypeNode.pos);
        }
        if ("main".equals(funcNode.name.value)) {
            new MainFunctionValidator(this.types, this.dlog).validateMainFunction(funcNode);
        }
        this.validateModuleInitFunction(funcNode);
        try {
            this.initNewWorkerActionSystem(data);
            data.workerActionSystemStack.peek().startWorkerActionStateMachine("function", funcNode.pos, funcNode);
            this.visitFunction(funcNode, data);
            data.workerActionSystemStack.peek().endWorkerActionStateMachine();
        }
        finally {
            this.finalizeCurrentWorkerActionSystem(data);
        }
        funcNode.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, data));
        this.validateCodeAnnotation(funcNode);
        this.validateNamedWorkerUniqueReferences(data);
    }

    private boolean isMethodInServiceDeclaration(BLangFunction func) {
        BLangNode parent = func.parent;
        return parent.getKind() == NodeKind.CLASS_DEFN && Symbols.isFlagOn(((BLangClassDefinition)parent).symbol.flags, 262144L);
    }

    private void validateNamedWorkerUniqueReferences(AnalyzerData data) {
        for (Set<BLangNode> nodes : data.workerReferences.values()) {
            if (nodes.size() <= 1) continue;
            for (BLangNode node : nodes) {
                this.dlog.error(node.pos, DiagnosticErrorCode.ILLEGAL_WORKER_REFERENCE_AS_A_VARIABLE_REFERENCE, node);
            }
        }
        data.workerReferences.clear();
    }

    private void validateParams(BLangFunction funcNode, AnalyzerData data) {
        for (BLangSimpleVariable parameter : funcNode.requiredParams) {
            this.analyzeNode((BLangNode)parameter, data);
        }
        if (funcNode.restParam != null) {
            this.analyzeNode((BLangNode)funcNode.restParam, data);
        }
    }

    private void visitFunction(BLangFunction funcNode, AnalyzerData data) {
        boolean failureHandled = data.failureHandled;
        data.failureHandled = false;
        data.env = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, data.env);
        data.returnWithinTransactionCheckStack.push(true);
        data.returnTypes.push(new LinkedHashSet());
        data.transactionalFuncCheckStack.push(funcNode.flagSet.contains((Object)Flag.TRANSACTIONAL));
        if (Symbols.isNative(funcNode.symbol)) {
            return;
        }
        if (this.isPublicInvokableNode(funcNode)) {
            this.analyzeNode((BLangNode)funcNode.returnTypeNode, data);
        }
        if (funcNode.body != null) {
            DefaultValueState prevDefaultValueState = data.defaultValueState;
            if (this.inDefaultValue(prevDefaultValueState)) {
                data.defaultValueState = DefaultValueState.FUNCTION_IN_DEFAULT_VALUE;
            }
            this.analyzeNode((BLangNode)funcNode.body, data);
            data.defaultValueState = prevDefaultValueState;
        }
        this.reachabilityAnalyzer.analyzeReachability((BLangNode)funcNode, data.env);
        data.returnTypes.pop();
        data.returnWithinTransactionCheckStack.pop();
        data.transactionalFuncCheckStack.pop();
        data.failureHandled = failureHandled;
    }

    private boolean isPublicInvokableNode(BLangInvokableNode invNode) {
        return Symbols.isPublic(invNode.symbol) && (SymbolKind.PACKAGE.equals((Object)invNode.symbol.owner.getKind()) || Symbols.isPublic(invNode.symbol.owner));
    }

    @Override
    public void visit(BLangBlockFunctionBody body, AnalyzerData data) {
        boolean prevWithinTxScope = data.withinTransactionScope;
        boolean prevLoopAlterNotAllowed = data.loopAlterNotAllowed;
        boolean bl = data.loopAlterNotAllowed = data.loopCount > 0;
        if (!prevWithinTxScope) {
            data.withinTransactionScope = data.transactionalFuncCheckStack.peek();
        }
        data.env = SymbolEnv.createFuncBodyEnv(body, data.env);
        for (BLangStatement e : body.stmts) {
            data.inInternallyDefinedBlockStmt = true;
            this.analyzeNode((BLangNode)e, data);
        }
        data.inInternallyDefinedBlockStmt = false;
        if (data.transactionalFuncCheckStack.peek().booleanValue()) {
            data.withinTransactionScope = prevWithinTxScope;
        }
        data.loopAlterNotAllowed = prevLoopAlterNotAllowed;
    }

    @Override
    public void visit(BLangExprFunctionBody body, AnalyzerData data) {
        this.analyzeExpr(body.expr, data);
    }

    @Override
    public void visit(BLangExternalFunctionBody body, AnalyzerData data) {
    }

    @Override
    public void visit(BLangForkJoin forkJoin, AnalyzerData data) {
        if (forkJoin.workers.isEmpty()) {
            this.dlog.error(forkJoin.pos, DiagnosticErrorCode.INVALID_FOR_JOIN_SYNTAX_EMPTY_FORK, new Object[0]);
        }
    }

    @Override
    public void visit(BLangTransaction transactionNode, AnalyzerData data) {
        if (data.transactionalFuncCheckStack.peek().booleanValue()) {
            this.dlog.error(transactionNode.pos, DiagnosticErrorCode.TRANSACTION_CANNOT_BE_USED_WITHIN_TRANSACTIONAL_SCOPE, new Object[0]);
            return;
        }
        boolean previousWithinTxScope = data.withinTransactionScope;
        int previousCommitCount = data.commitCount;
        int previousRollbackCount = data.rollbackCount;
        boolean prevCommitRollbackAllowed = data.commitRollbackAllowed;
        data.commitRollbackAllowed = true;
        data.commitCount = 0;
        data.rollbackCount = 0;
        data.withinTransactionScope = true;
        data.loopWithinTransactionCheckStack.push(false);
        data.returnWithinTransactionCheckStack.push(false);
        ++data.transactionCount;
        boolean onFailExists = transactionNode.onFailClause != null;
        boolean failureHandled = data.failureHandled;
        if (onFailExists) {
            data.failureHandled = true;
        }
        this.analyzeNode((BLangNode)transactionNode.transactionBody, data);
        data.failureHandled = failureHandled;
        if (data.commitCount < 1) {
            this.dlog.error(transactionNode.pos, DiagnosticErrorCode.INVALID_COMMIT_COUNT, new Object[0]);
        }
        --data.transactionCount;
        data.withinTransactionScope = previousWithinTxScope;
        data.commitCount = previousCommitCount;
        data.rollbackCount = previousRollbackCount;
        data.commitRollbackAllowed = prevCommitRollbackAllowed;
        data.returnWithinTransactionCheckStack.pop();
        data.loopWithinTransactionCheckStack.pop();
        this.analyseOnFailClause(onFailExists, transactionNode.onFailClause, data);
    }

    private void analyzeOnFailClause(BLangOnFailClause onFailClause, AnalyzerData data) {
        if (onFailClause != null) {
            this.analyzeNode((BLangNode)onFailClause, data);
        }
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr, AnalyzerData data) {
    }

    @Override
    public void visit(BLangCommitExpr commitExpr, AnalyzerData data) {
        ++data.commitCount;
        ++data.commitCountWithinBlock;
        if (data.transactionCount == 0) {
            this.dlog.error(commitExpr.pos, DiagnosticErrorCode.COMMIT_CANNOT_BE_OUTSIDE_TRANSACTION_BLOCK, new Object[0]);
            return;
        }
        if (data.transactionalFuncCheckStack.peek().booleanValue()) {
            this.dlog.error(commitExpr.pos, DiagnosticErrorCode.COMMIT_CANNOT_BE_WITHIN_TRANSACTIONAL_FUNCTION, new Object[0]);
            return;
        }
        if (!data.withinTransactionScope || !data.commitRollbackAllowed || data.loopWithinTransactionCheckStack.peek().booleanValue()) {
            this.dlog.error(commitExpr.pos, DiagnosticErrorCode.COMMIT_NOT_ALLOWED, new Object[0]);
            return;
        }
        data.withinTransactionScope = false;
    }

    @Override
    public void visit(BLangRollback rollbackNode, AnalyzerData data) {
        ++data.rollbackCount;
        ++data.rollbackCountWithinBlock;
        if (data.transactionCount == 0 && !data.withinTransactionScope) {
            this.dlog.error(rollbackNode.pos, DiagnosticErrorCode.ROLLBACK_CANNOT_BE_OUTSIDE_TRANSACTION_BLOCK, new Object[0]);
            return;
        }
        if (!data.transactionalFuncCheckStack.isEmpty() && data.transactionalFuncCheckStack.peek().booleanValue()) {
            this.dlog.error(rollbackNode.pos, DiagnosticErrorCode.ROLLBACK_CANNOT_BE_WITHIN_TRANSACTIONAL_FUNCTION, new Object[0]);
            return;
        }
        if (!data.withinTransactionScope || !data.commitRollbackAllowed || !data.loopWithinTransactionCheckStack.isEmpty() && data.loopWithinTransactionCheckStack.peek().booleanValue()) {
            this.dlog.error(rollbackNode.pos, DiagnosticErrorCode.ROLLBACK_NOT_ALLOWED, new Object[0]);
            return;
        }
        data.withinTransactionScope = false;
        this.analyzeExpr(rollbackNode.expr, data);
    }

    @Override
    public void visit(BLangRetry retryNode, AnalyzerData data) {
        boolean onFailExists = retryNode.onFailClause != null;
        boolean failureHandled = data.failureHandled;
        if (onFailExists) {
            data.failureHandled = true;
        }
        this.visitNode(retryNode.retrySpec, data);
        this.visitNode(retryNode.retryBody, data);
        data.failureHandled = failureHandled;
        this.analyseOnFailClause(onFailExists, retryNode.onFailClause, data);
    }

    @Override
    public void visit(BLangRetrySpec retrySpec, AnalyzerData data) {
        if (retrySpec.retryManagerType != null) {
            BSymbol retryManagerTypeSymbol = this.symTable.langErrorModuleSymbol.scope.lookup((Name)Names.fromString((String)"RetryManager")).symbol;
            BType abstractRetryManagerType = retryManagerTypeSymbol.type;
            if (!this.types.isAssignable(retrySpec.retryManagerType.getBType(), abstractRetryManagerType)) {
                this.dlog.error(retrySpec.pos, DiagnosticErrorCode.INVALID_INTERFACE_ON_NON_ABSTRACT_OBJECT, "shouldRetry", retrySpec.retryManagerType.getBType());
            }
        }
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction, AnalyzerData data) {
        this.analyzeNode((BLangNode)retryTransaction.retrySpec, data);
        this.analyzeNode((BLangNode)retryTransaction.transaction, data);
    }

    @Override
    public void visit(BLangBlockStmt blockNode, AnalyzerData data) {
        int prevCommitCount = data.commitCountWithinBlock;
        int prevRollbackCount = data.rollbackCountWithinBlock;
        data.commitCountWithinBlock = 0;
        data.rollbackCountWithinBlock = 0;
        boolean inInternallyDefinedBlockStmt = data.inInternallyDefinedBlockStmt;
        data.inInternallyDefinedBlockStmt = this.checkBlockIsAnInternalBlockInImmediateFunctionBody(blockNode);
        data.env = SymbolEnv.createBlockEnv(blockNode, data.env);
        blockNode.stmts.forEach(e -> this.analyzeNode((BLangNode)e, data));
        data.inInternallyDefinedBlockStmt = inInternallyDefinedBlockStmt;
        if (data.commitCountWithinBlock > 1 || data.rollbackCountWithinBlock > 1) {
            this.dlog.error(blockNode.pos, DiagnosticErrorCode.MAX_ONE_COMMIT_ROLLBACK_ALLOWED_WITHIN_A_BRANCH, new Object[0]);
        }
        data.commitCountWithinBlock = prevCommitCount;
        data.rollbackCountWithinBlock = prevRollbackCount;
    }

    private boolean checkBlockIsAnInternalBlockInImmediateFunctionBody(BLangNode node) {
        BLangNode parent = node.parent;
        while (parent != null) {
            NodeKind kind = parent.getKind();
            if (kind == NodeKind.BLOCK_FUNCTION_BODY) {
                return true;
            }
            if (kind == NodeKind.BLOCK) {
                parent = parent.parent;
                continue;
            }
            return false;
        }
        return false;
    }

    @Override
    public void visit(BLangReturn returnStmt, AnalyzerData data) {
        if (this.checkReturnValidityInTransaction(data)) {
            this.dlog.error(returnStmt.pos, DiagnosticErrorCode.RETURN_CANNOT_BE_USED_TO_EXIT_TRANSACTION, new Object[0]);
            return;
        }
        this.analyzeExpr(returnStmt.expr, data);
        data.returnTypes.peek().add(returnStmt.expr.getBType());
    }

    @Override
    public void visit(BLangIf ifStmt, AnalyzerData data) {
        boolean independentBlocks = false;
        int prevCommitCount = data.commitCount;
        int prevRollbackCount = data.rollbackCount;
        BLangStatement elseStmt = ifStmt.elseStmt;
        if (data.withinTransactionScope && elseStmt != null && elseStmt.getKind() != NodeKind.IF) {
            independentBlocks = true;
            data.commitRollbackAllowed = true;
        }
        boolean prevTxMode = data.withinTransactionScope;
        if ((ifStmt.expr.getKind() == NodeKind.GROUP_EXPR ? ((BLangGroupExpr)ifStmt.expr).expression.getKind() : ifStmt.expr.getKind()) == NodeKind.TRANSACTIONAL_EXPRESSION) {
            data.withinTransactionScope = true;
        }
        BLangBlockStmt body = ifStmt.body;
        this.analyzeNode((BLangNode)body, data);
        if (ifStmt.expr.getKind() == NodeKind.TRANSACTIONAL_EXPRESSION) {
            data.withinTransactionScope = prevTxMode;
        }
        if (elseStmt != null) {
            if (independentBlocks) {
                data.commitRollbackAllowed = true;
                data.withinTransactionScope = true;
            }
            this.analyzeNode((BLangNode)elseStmt, data);
            if (prevCommitCount != data.commitCount || prevRollbackCount != data.rollbackCount) {
                data.commitRollbackAllowed = false;
            }
        }
        this.analyzeExpr(ifStmt.expr, data);
    }

    @Override
    public void visit(BLangMatchStatement matchStatement, AnalyzerData data) {
        this.analyzeExpr(matchStatement.expr, data);
        boolean onFailExists = matchStatement.onFailClause != null;
        boolean failureHandled = data.failureHandled;
        if (onFailExists) {
            data.failureHandled = true;
        }
        List<BLangMatchClause> matchClauses = matchStatement.matchClauses;
        int clausesSize = matchClauses.size();
        for (int i = 0; i < clausesSize; ++i) {
            BLangMatchClause firstClause = matchClauses.get(i);
            for (int j = i + 1; j < clausesSize; ++j) {
                BLangMatchClause secondClause = matchClauses.get(j);
                if (!this.checkSimilarMatchGuard(firstClause.matchGuard, secondClause.matchGuard)) {
                    if (firstClause.matchGuard != null) continue;
                    this.checkSimilarMatchPatternsBetweenClauses(firstClause, secondClause);
                    continue;
                }
                this.checkSimilarMatchPatternsBetweenClauses(firstClause, secondClause);
            }
            this.analyzeNode((BLangNode)firstClause, data);
        }
        data.failureHandled = failureHandled;
        this.analyzeOnFailClause(matchStatement.onFailClause, data);
    }

    @Override
    public void visit(BLangMatchClause matchClause, AnalyzerData data) {
        HashMap<String, BVarSymbol> variablesInMatchPattern = new HashMap<String, BVarSymbol>();
        boolean patternListContainsSameVars = true;
        List<BLangMatchPattern> matchPatterns = matchClause.matchPatterns;
        BLangMatchGuard matchGuard = matchClause.matchGuard;
        for (int i = 0; i < matchPatterns.size(); ++i) {
            BLangMatchPattern matchPattern = matchPatterns.get(i);
            if (matchPattern.getBType() == this.symTable.noType) {
                this.dlog.warning(matchPattern.pos, DiagnosticWarningCode.MATCH_STMT_UNMATCHED_PATTERN, new Object[0]);
            }
            if (patternListContainsSameVars) {
                patternListContainsSameVars = this.compareVariables(variablesInMatchPattern, matchPattern);
            }
            for (int j = i - 1; j >= 0; --j) {
                if (!this.checkSimilarMatchPatterns(matchPatterns.get(j), matchPattern)) continue;
                this.dlog.warning(matchPattern.pos, DiagnosticWarningCode.MATCH_STMT_PATTERN_UNREACHABLE, new Object[0]);
            }
            this.analyzeNode((BLangNode)matchPattern, data);
        }
        if (matchGuard != null) {
            this.analyzeNode((BLangNode)matchGuard, data);
        }
        if (!patternListContainsSameVars) {
            this.dlog.error(matchClause.pos, DiagnosticErrorCode.MATCH_PATTERNS_SHOULD_CONTAIN_SAME_SET_OF_VARIABLES, new Object[0]);
        }
        this.analyzeNode((BLangNode)matchClause.blockStmt, data);
    }

    @Override
    public void visit(BLangMappingMatchPattern mappingMatchPattern, AnalyzerData data) {
    }

    @Override
    public void visit(BLangFieldMatchPattern fieldMatchPattern, AnalyzerData data) {
    }

    @Override
    public void visit(BLangMatchGuard matchGuard, AnalyzerData data) {
        this.analyzeExpr(matchGuard.expr, data);
    }

    private void checkSimilarMatchPatternsBetweenClauses(BLangMatchClause firstClause, BLangMatchClause secondClause) {
        for (BLangMatchPattern firstMatchPattern : firstClause.matchPatterns) {
            for (BLangMatchPattern secondMatchPattern : secondClause.matchPatterns) {
                if (!this.checkSimilarMatchPatterns(firstMatchPattern, secondMatchPattern)) continue;
                this.dlog.warning(secondMatchPattern.pos, DiagnosticWarningCode.MATCH_STMT_PATTERN_UNREACHABLE, new Object[0]);
            }
        }
    }

    private boolean checkSimilarMatchPatterns(BLangMatchPattern firstPattern, BLangMatchPattern secondPattern) {
        NodeKind secondPatternKind;
        NodeKind firstPatternKind = firstPattern.getKind();
        if (firstPatternKind != (secondPatternKind = secondPattern.getKind())) {
            if (firstPatternKind == NodeKind.VAR_BINDING_PATTERN_MATCH_PATTERN) {
                return this.checkEmptyListOrMapMatchWithVarBindingPatternMatch(secondPattern, (BLangVarBindingPatternMatchPattern)firstPattern);
            }
            if (secondPatternKind == NodeKind.VAR_BINDING_PATTERN_MATCH_PATTERN) {
                return this.checkEmptyListOrMapMatchWithVarBindingPatternMatch(firstPattern, (BLangVarBindingPatternMatchPattern)secondPattern);
            }
            return false;
        }
        return switch (firstPatternKind) {
            case NodeKind.WILDCARD_MATCH_PATTERN, NodeKind.REST_MATCH_PATTERN -> true;
            case NodeKind.CONST_MATCH_PATTERN -> this.checkSimilarConstMatchPattern((BLangConstPattern)firstPattern, (BLangConstPattern)secondPattern);
            case NodeKind.VAR_BINDING_PATTERN_MATCH_PATTERN -> this.checkSimilarBindingPatterns(((BLangVarBindingPatternMatchPattern)firstPattern).getBindingPattern(), ((BLangVarBindingPatternMatchPattern)secondPattern).getBindingPattern());
            case NodeKind.LIST_MATCH_PATTERN -> this.checkSimilarListMatchPattern((BLangListMatchPattern)firstPattern, (BLangListMatchPattern)secondPattern);
            case NodeKind.MAPPING_MATCH_PATTERN -> this.checkSimilarMappingMatchPattern((BLangMappingMatchPattern)firstPattern, (BLangMappingMatchPattern)secondPattern);
            case NodeKind.ERROR_MATCH_PATTERN -> this.checkSimilarErrorMatchPattern((BLangErrorMatchPattern)firstPattern, (BLangErrorMatchPattern)secondPattern);
            default -> false;
        };
    }

    private boolean checkEmptyListOrMapMatchWithVarBindingPatternMatch(BLangMatchPattern firstPattern, BLangVarBindingPatternMatchPattern secondPattern) {
        if (firstPattern.getKind() == NodeKind.LIST_MATCH_PATTERN) {
            BLangBindingPattern bindingPattern = secondPattern.getBindingPattern();
            if (bindingPattern.getKind() != NodeKind.LIST_BINDING_PATTERN) {
                return false;
            }
            BLangListMatchPattern listMatchPattern = (BLangListMatchPattern)firstPattern;
            BLangListBindingPattern listBindingPattern = (BLangListBindingPattern)bindingPattern;
            return listMatchPattern.matchPatterns.isEmpty() && listBindingPattern.bindingPatterns.isEmpty() && listMatchPattern.restMatchPattern == null && listBindingPattern.restBindingPattern == null;
        }
        if (firstPattern.getKind() == NodeKind.MAPPING_MATCH_PATTERN) {
            BLangBindingPattern bindingPattern = secondPattern.getBindingPattern();
            if (secondPattern.getBindingPattern().getKind() != NodeKind.MAPPING_BINDING_PATTERN) {
                return false;
            }
            BLangMappingMatchPattern mappingMatchPattern = (BLangMappingMatchPattern)firstPattern;
            BLangMappingBindingPattern mappingBindingPattern = (BLangMappingBindingPattern)bindingPattern;
            return mappingMatchPattern.fieldMatchPatterns.isEmpty() && mappingBindingPattern.fieldBindingPatterns.isEmpty() && mappingMatchPattern.restMatchPattern == null && mappingBindingPattern.restBindingPattern == null;
        }
        return false;
    }

    private boolean checkSimilarErrorMatchPattern(BLangErrorMatchPattern firstErrorMatchPattern, BLangErrorMatchPattern secondErrorMatchPattern) {
        if (firstErrorMatchPattern == null || secondErrorMatchPattern == null) {
            return false;
        }
        if (!this.checkSimilarErrorTypeReference(firstErrorMatchPattern.errorTypeReference, secondErrorMatchPattern.errorTypeReference)) {
            return false;
        }
        if (!this.checkSimilarErrorMessagePattern(firstErrorMatchPattern.errorMessageMatchPattern, secondErrorMatchPattern.errorMessageMatchPattern)) {
            return false;
        }
        if (!this.checkSimilarErrorCauseMatchPattern(firstErrorMatchPattern.errorCauseMatchPattern, secondErrorMatchPattern.errorCauseMatchPattern)) {
            return false;
        }
        return this.checkSimilarErrorFieldMatchPatterns(firstErrorMatchPattern.errorFieldMatchPatterns, secondErrorMatchPattern.errorFieldMatchPatterns);
    }

    private boolean checkSimilarErrorTypeReference(BLangUserDefinedType firstErrorTypeRef, BLangUserDefinedType secondErrorTypeRef) {
        if (firstErrorTypeRef != null && secondErrorTypeRef != null) {
            return firstErrorTypeRef.typeName.value.equals(secondErrorTypeRef.typeName.value);
        }
        return firstErrorTypeRef == null && secondErrorTypeRef == null;
    }

    private boolean checkSimilarErrorMessagePattern(BLangErrorMessageMatchPattern firstErrorMsgMatchPattern, BLangErrorMessageMatchPattern secondErrorMsgMatchPattern) {
        if (firstErrorMsgMatchPattern != null && secondErrorMsgMatchPattern != null) {
            return this.checkSimilarSimpleMatchPattern(firstErrorMsgMatchPattern.simpleMatchPattern, secondErrorMsgMatchPattern.simpleMatchPattern);
        }
        return firstErrorMsgMatchPattern == null && secondErrorMsgMatchPattern == null;
    }

    private boolean checkSimilarSimpleMatchPattern(BLangSimpleMatchPattern firstSimpleMatchPattern, BLangSimpleMatchPattern secondSimpleMatchPattern) {
        if (firstSimpleMatchPattern != null && secondSimpleMatchPattern != null) {
            if (firstSimpleMatchPattern.varVariableName != null) {
                return true;
            }
            BLangConstPattern firstConstPattern = firstSimpleMatchPattern.constPattern;
            BLangConstPattern secondConstPattern = secondSimpleMatchPattern.constPattern;
            if (firstConstPattern != null) {
                if (secondConstPattern != null) {
                    return this.checkSimilarConstMatchPattern(firstConstPattern, secondConstPattern);
                }
                return false;
            }
            return secondSimpleMatchPattern.varVariableName == null;
        }
        return firstSimpleMatchPattern == null && secondSimpleMatchPattern == null;
    }

    private boolean checkSimilarErrorCauseMatchPattern(BLangErrorCauseMatchPattern firstErrorCauseMatchPattern, BLangErrorCauseMatchPattern secondErrorCauseMatchPattern) {
        if (firstErrorCauseMatchPattern != null && secondErrorCauseMatchPattern != null) {
            if (!this.checkSimilarSimpleMatchPattern(firstErrorCauseMatchPattern.simpleMatchPattern, secondErrorCauseMatchPattern.simpleMatchPattern)) {
                return false;
            }
            return this.checkSimilarErrorMatchPattern(firstErrorCauseMatchPattern.errorMatchPattern, secondErrorCauseMatchPattern.errorMatchPattern);
        }
        return firstErrorCauseMatchPattern == null && secondErrorCauseMatchPattern == null;
    }

    private boolean checkSimilarErrorFieldMatchPatterns(BLangErrorFieldMatchPatterns firstErrorFieldMatchPatterns, BLangErrorFieldMatchPatterns secondErrorFieldMatchPatterns) {
        if (firstErrorFieldMatchPatterns == null) {
            return true;
        }
        List<BLangNamedArgMatchPattern> firstNamedArgPatterns = firstErrorFieldMatchPatterns.namedArgMatchPatterns;
        int firstNamedArgPatternsSize = firstNamedArgPatterns.size();
        if (firstNamedArgPatternsSize == 0) {
            return true;
        }
        if (secondErrorFieldMatchPatterns == null) {
            return false;
        }
        List<BLangNamedArgMatchPattern> secondNamedArgPatterns = secondErrorFieldMatchPatterns.namedArgMatchPatterns;
        if (firstNamedArgPatternsSize > secondNamedArgPatterns.size()) {
            return false;
        }
        for (int i = 0; i < firstNamedArgPatternsSize; ++i) {
            if (this.checkSimilarNamedArgMatchPatterns(firstNamedArgPatterns.get(i), secondNamedArgPatterns.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean checkSimilarNamedArgMatchPatterns(BLangNamedArgMatchPattern firstNamedArgMatchPattern, BLangNamedArgMatchPattern secondNamedArgMatchPattern) {
        if (firstNamedArgMatchPattern.argName.value.equals(secondNamedArgMatchPattern.argName.value)) {
            return this.checkSimilarMatchPatterns(firstNamedArgMatchPattern.matchPattern, secondNamedArgMatchPattern.matchPattern);
        }
        return false;
    }

    private boolean checkSimilarConstMatchPattern(BLangConstPattern firstConstMatchPattern, BLangConstPattern secondConstMatchPattern) {
        Object firstConstValue = this.getConstValue(firstConstMatchPattern).keySet().iterator().next();
        Object secondConstValue = this.getConstValue(secondConstMatchPattern).keySet().iterator().next();
        BType firstConstType = this.getConstValue(firstConstMatchPattern).values().iterator().next();
        BType secondConstType = this.getConstValue(secondConstMatchPattern).values().iterator().next();
        if (firstConstValue == null || secondConstValue == null) {
            return false;
        }
        if (firstConstValue.equals(secondConstValue)) {
            return true;
        }
        if (firstConstType != null && Types.getImpliedType((BType)firstConstType).tag == 33) {
            firstConstValue = this.getConstValueFromFiniteType((BFiniteType)firstConstType);
        }
        if (secondConstType != null && Types.getImpliedType((BType)secondConstType).tag == 33) {
            secondConstValue = this.getConstValueFromFiniteType((BFiniteType)secondConstType);
        }
        if (firstConstValue == null || secondConstValue == null) {
            return false;
        }
        return firstConstValue.equals(secondConstValue);
    }

    private HashMap<Object, BType> getConstValue(BLangConstPattern constPattern) {
        HashMap<Object, BType> constValAndType = new HashMap<Object, BType>();
        switch (constPattern.expr.getKind()) {
            case NUMERIC_LITERAL: {
                constValAndType.put(((BLangNumericLiteral)constPattern.expr).value, null);
                break;
            }
            case LITERAL: {
                constValAndType.put(((BLangLiteral)constPattern.expr).value, null);
                break;
            }
            case SIMPLE_VARIABLE_REF: {
                constValAndType.put(((BLangSimpleVarRef)constPattern.expr).variableName, constPattern.getBType());
                break;
            }
            case UNARY_EXPR: {
                BLangNumericLiteral newNumericLiteral = Types.constructNumericLiteralFromUnaryExpr((BLangUnaryExpr)constPattern.expr);
                constValAndType.put(newNumericLiteral.value, null);
            }
        }
        return constValAndType;
    }

    private Object getConstValueFromFiniteType(BFiniteType type) {
        Optional value = Core.singleShape((SemType)type.semType());
        return value.map(v -> v.value).orElse(null);
    }

    private boolean checkSimilarListMatchPattern(BLangListMatchPattern firstListMatchPattern, BLangListMatchPattern secondListMatchPattern) {
        int secondPatternsSize;
        List<BLangMatchPattern> firstMatchPatterns = firstListMatchPattern.matchPatterns;
        List<BLangMatchPattern> secondMatchPatterns = secondListMatchPattern.matchPatterns;
        int firstPatternsSize = firstMatchPatterns.size();
        if (firstPatternsSize <= (secondPatternsSize = secondMatchPatterns.size())) {
            for (int i = 0; i < firstPatternsSize; ++i) {
                if (this.checkSimilarMatchPatterns(firstMatchPatterns.get(i), secondMatchPatterns.get(i))) continue;
                return false;
            }
            if (firstPatternsSize == secondPatternsSize) {
                if (firstListMatchPattern.restMatchPattern != null) {
                    return true;
                }
                return secondListMatchPattern.restMatchPattern == null;
            }
            return firstListMatchPattern.restMatchPattern != null;
        }
        return false;
    }

    private boolean checkSimilarMappingMatchPattern(BLangMappingMatchPattern firstMappingMatchPattern, BLangMappingMatchPattern secondMappingMatchPattern) {
        List<BLangFieldMatchPattern> firstFieldMatchPatterns = firstMappingMatchPattern.fieldMatchPatterns;
        List<BLangFieldMatchPattern> secondFieldMatchPatterns = secondMappingMatchPattern.fieldMatchPatterns;
        return this.checkSimilarFieldMatchPatterns(firstFieldMatchPatterns, secondFieldMatchPatterns);
    }

    private boolean checkSimilarFieldMatchPatterns(List<BLangFieldMatchPattern> firstFieldMatchPatterns, List<BLangFieldMatchPattern> secondFieldMatchPatterns) {
        for (BLangFieldMatchPattern firstFieldMatchPattern : firstFieldMatchPatterns) {
            boolean isSamePattern = false;
            for (BLangFieldMatchPattern secondFieldMatchPattern : secondFieldMatchPatterns) {
                if (!this.checkSimilarFieldMatchPattern(firstFieldMatchPattern, secondFieldMatchPattern)) continue;
                isSamePattern = true;
                break;
            }
            if (isSamePattern) continue;
            return false;
        }
        return true;
    }

    private boolean checkSimilarFieldMatchPattern(BLangFieldMatchPattern firstFieldMatchPattern, BLangFieldMatchPattern secondFieldMatchPattern) {
        return firstFieldMatchPattern.fieldName.value.equals(secondFieldMatchPattern.fieldName.value) && this.checkSimilarMatchPatterns(firstFieldMatchPattern.matchPattern, secondFieldMatchPattern.matchPattern);
    }

    private boolean checkSimilarBindingPatterns(BLangBindingPattern firstBidingPattern, BLangBindingPattern secondBindingPattern) {
        NodeKind secondBindingPatternKind;
        NodeKind firstBindingPatternKind = firstBidingPattern.getKind();
        if (firstBindingPatternKind != (secondBindingPatternKind = secondBindingPattern.getKind())) {
            return false;
        }
        return switch (firstBindingPatternKind) {
            case NodeKind.WILDCARD_BINDING_PATTERN, NodeKind.REST_BINDING_PATTERN, NodeKind.CAPTURE_BINDING_PATTERN -> true;
            case NodeKind.LIST_BINDING_PATTERN -> this.checkSimilarListBindingPatterns((BLangListBindingPattern)firstBidingPattern, (BLangListBindingPattern)secondBindingPattern);
            case NodeKind.MAPPING_BINDING_PATTERN -> this.checkSimilarMappingBindingPattern((BLangMappingBindingPattern)firstBidingPattern, (BLangMappingBindingPattern)secondBindingPattern);
            case NodeKind.ERROR_BINDING_PATTERN -> this.checkSimilarErrorBindingPatterns((BLangErrorBindingPattern)firstBidingPattern, (BLangErrorBindingPattern)secondBindingPattern);
            default -> false;
        };
    }

    private boolean checkSimilarMappingBindingPattern(BLangMappingBindingPattern firstMappingBindingPattern, BLangMappingBindingPattern secondMappingBindingPattern) {
        List<BLangFieldBindingPattern> firstFieldBindingPatterns = firstMappingBindingPattern.fieldBindingPatterns;
        List<BLangFieldBindingPattern> secondFieldBindingPatterns = secondMappingBindingPattern.fieldBindingPatterns;
        return this.checkSimilarFieldBindingPatterns(firstFieldBindingPatterns, secondFieldBindingPatterns);
    }

    private boolean checkSimilarFieldBindingPatterns(List<BLangFieldBindingPattern> firstFieldBindingPatterns, List<BLangFieldBindingPattern> secondFieldBindingPatterns) {
        for (BLangFieldBindingPattern firstFieldBindingPattern : firstFieldBindingPatterns) {
            boolean isSamePattern = false;
            for (BLangFieldBindingPattern secondFieldBindingPattern : secondFieldBindingPatterns) {
                if (!this.checkSimilarFieldBindingPattern(firstFieldBindingPattern, secondFieldBindingPattern)) continue;
                isSamePattern = true;
                break;
            }
            if (isSamePattern) continue;
            return false;
        }
        return true;
    }

    private boolean checkSimilarFieldBindingPattern(BLangFieldBindingPattern firstFieldBindingPattern, BLangFieldBindingPattern secondFieldBindingPattern) {
        boolean hasSameFieldNames = firstFieldBindingPattern.fieldName.value.equals(secondFieldBindingPattern.fieldName.value);
        if (firstFieldBindingPattern.bindingPattern.getKind() == secondFieldBindingPattern.bindingPattern.getKind()) {
            return hasSameFieldNames && this.checkSimilarBindingPatterns(firstFieldBindingPattern.bindingPattern, secondFieldBindingPattern.bindingPattern);
        }
        return hasSameFieldNames && firstFieldBindingPattern.bindingPattern.getKind() == NodeKind.CAPTURE_BINDING_PATTERN;
    }

    private boolean checkSimilarListBindingPatterns(BLangListBindingPattern firstBindingPattern, BLangListBindingPattern secondBindingPattern) {
        int secondPatternsSize;
        List<BLangBindingPattern> firstPatterns = firstBindingPattern.bindingPatterns;
        List<BLangBindingPattern> secondPatterns = secondBindingPattern.bindingPatterns;
        int firstPatternsSize = firstPatterns.size();
        if (firstPatternsSize <= (secondPatternsSize = secondPatterns.size())) {
            for (int i = 0; i < firstPatternsSize; ++i) {
                if (this.checkSimilarBindingPatterns(firstPatterns.get(i), secondPatterns.get(i))) continue;
                return firstPatterns.get(i).getKind() == NodeKind.CAPTURE_BINDING_PATTERN;
            }
            if (firstPatternsSize == secondPatternsSize) {
                if (firstBindingPattern.restBindingPattern != null) {
                    return true;
                }
                return secondBindingPattern.restBindingPattern == null;
            }
            return secondBindingPattern.restBindingPattern != null;
        }
        return false;
    }

    private boolean checkSimilarErrorBindingPatterns(BLangErrorBindingPattern firstErrorBindingPattern, BLangErrorBindingPattern secondErrorBindingPattern) {
        if (firstErrorBindingPattern == null || secondErrorBindingPattern == null) {
            return false;
        }
        if (!this.checkSimilarErrorTypeReference(firstErrorBindingPattern.errorTypeReference, secondErrorBindingPattern.errorTypeReference)) {
            return false;
        }
        if (!this.checkSimilarErrorMessageBindingPattern(firstErrorBindingPattern.errorMessageBindingPattern, secondErrorBindingPattern.errorMessageBindingPattern)) {
            return false;
        }
        if (!this.checkSimilarErrorCauseBindingPattern(firstErrorBindingPattern.errorCauseBindingPattern, secondErrorBindingPattern.errorCauseBindingPattern)) {
            return false;
        }
        return this.checkSimilarErrorFieldBindingPatterns(firstErrorBindingPattern.errorFieldBindingPatterns, secondErrorBindingPattern.errorFieldBindingPatterns);
    }

    private boolean checkSimilarErrorMessageBindingPattern(BLangErrorMessageBindingPattern firstErrorMsgBindingPattern, BLangErrorMessageBindingPattern secondErrorMsgBindingPattern) {
        if (firstErrorMsgBindingPattern != null && secondErrorMsgBindingPattern != null) {
            return this.checkSimilarSimpleBindingPattern(firstErrorMsgBindingPattern.simpleBindingPattern, secondErrorMsgBindingPattern.simpleBindingPattern);
        }
        return firstErrorMsgBindingPattern == null && secondErrorMsgBindingPattern == null;
    }

    private boolean checkSimilarSimpleBindingPattern(BLangSimpleBindingPattern firstSimpleBindingPattern, BLangSimpleBindingPattern secondSimpleBindingPattern) {
        if (firstSimpleBindingPattern != null && secondSimpleBindingPattern != null) {
            BLangCaptureBindingPattern firstCaptureBindingPattern = firstSimpleBindingPattern.captureBindingPattern;
            BLangCaptureBindingPattern secondCaptureBindingPattern = secondSimpleBindingPattern.captureBindingPattern;
            if (firstCaptureBindingPattern != null && secondCaptureBindingPattern != null) {
                return this.checkSimilarBindingPatterns(firstCaptureBindingPattern, secondCaptureBindingPattern);
            }
            return firstSimpleBindingPattern.wildCardBindingPattern != null;
        }
        return firstSimpleBindingPattern == null && secondSimpleBindingPattern == null;
    }

    private boolean checkSimilarErrorCauseBindingPattern(BLangErrorCauseBindingPattern firstErrorCauseBindingPattern, BLangErrorCauseBindingPattern secondErrorCauseBindingPattern) {
        if (firstErrorCauseBindingPattern != null && secondErrorCauseBindingPattern != null) {
            if (!this.checkSimilarSimpleBindingPattern(firstErrorCauseBindingPattern.simpleBindingPattern, secondErrorCauseBindingPattern.simpleBindingPattern)) {
                return false;
            }
            return this.checkSimilarErrorBindingPatterns(firstErrorCauseBindingPattern.errorBindingPattern, secondErrorCauseBindingPattern.errorBindingPattern);
        }
        return firstErrorCauseBindingPattern == null && secondErrorCauseBindingPattern == null;
    }

    private boolean checkSimilarErrorFieldBindingPatterns(BLangErrorFieldBindingPatterns firstErrorFieldBindingPatterns, BLangErrorFieldBindingPatterns secondErrorFieldBindingPatterns) {
        if (firstErrorFieldBindingPatterns == null) {
            return true;
        }
        List<BLangNamedArgBindingPattern> firstNamedArgPatterns = firstErrorFieldBindingPatterns.namedArgBindingPatterns;
        int firstNamedArgPatternsSize = firstNamedArgPatterns.size();
        if (firstNamedArgPatternsSize == 0) {
            return true;
        }
        if (secondErrorFieldBindingPatterns == null) {
            return false;
        }
        List<BLangNamedArgBindingPattern> secondNamedArgPatterns = secondErrorFieldBindingPatterns.namedArgBindingPatterns;
        if (firstNamedArgPatternsSize > secondNamedArgPatterns.size()) {
            return false;
        }
        for (int i = 0; i < firstNamedArgPatternsSize; ++i) {
            if (this.checkSimilarNamedArgBindingPatterns(firstNamedArgPatterns.get(i), secondNamedArgPatterns.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean checkSimilarNamedArgBindingPatterns(BLangNamedArgBindingPattern firstNamedArgBindingPattern, BLangNamedArgBindingPattern secondNamedArgBindingPattern) {
        if (firstNamedArgBindingPattern.argName.value.equals(secondNamedArgBindingPattern.argName.value)) {
            return this.checkSimilarBindingPatterns(firstNamedArgBindingPattern.bindingPattern, secondNamedArgBindingPattern.bindingPattern);
        }
        return false;
    }

    private boolean checkSimilarMatchGuard(BLangMatchGuard firstMatchGuard, BLangMatchGuard secondMatchGuard) {
        if (firstMatchGuard == null && secondMatchGuard == null) {
            return true;
        }
        if (firstMatchGuard == null || secondMatchGuard == null) {
            return false;
        }
        if (firstMatchGuard.expr.getKind() == NodeKind.TYPE_TEST_EXPR && secondMatchGuard.expr.getKind() == NodeKind.TYPE_TEST_EXPR && ((BLangTypeTestExpr)firstMatchGuard.expr).expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangTypeTestExpr)secondMatchGuard.expr).expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangTypeTestExpr firstTypeTest = (BLangTypeTestExpr)firstMatchGuard.expr;
            BLangTypeTestExpr secondTypeTest = (BLangTypeTestExpr)secondMatchGuard.expr;
            return ((BLangSimpleVarRef)firstTypeTest.expr).variableName.toString().equals(((BLangSimpleVarRef)secondTypeTest.expr).variableName.toString()) && this.types.isAssignable(firstTypeTest.typeNode.getBType(), secondTypeTest.typeNode.getBType());
        }
        return false;
    }

    private boolean compareVariables(Map<String, BVarSymbol> varsInPreviousMatchPattern, BLangMatchPattern matchPattern) {
        Map<String, BVarSymbol> varsInCurrentMatchPattern = matchPattern.declaredVars;
        if (varsInPreviousMatchPattern.isEmpty()) {
            varsInPreviousMatchPattern.putAll(varsInCurrentMatchPattern);
            return true;
        }
        if (varsInPreviousMatchPattern.size() != varsInCurrentMatchPattern.size()) {
            return false;
        }
        for (String identifier : varsInPreviousMatchPattern.keySet()) {
            if (varsInCurrentMatchPattern.containsKey(identifier)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(BLangWildCardMatchPattern wildCardMatchPattern, AnalyzerData data) {
        wildCardMatchPattern.isLastPattern = wildCardMatchPattern.matchExpr != null && this.types.isAssignable(wildCardMatchPattern.matchExpr.getBType(), this.symTable.anyType);
    }

    @Override
    public void visit(BLangConstPattern constMatchPattern, AnalyzerData data) {
        this.analyzeNode((BLangNode)constMatchPattern.expr, data);
    }

    @Override
    public void visit(BLangVarBindingPatternMatchPattern varBindingPattern, AnalyzerData data) {
        BLangBindingPattern bindingPattern = varBindingPattern.getBindingPattern();
        this.analyzeNode((BLangNode)bindingPattern, data);
        switch (bindingPattern.getKind()) {
            case WILDCARD_BINDING_PATTERN: {
                varBindingPattern.isLastPattern = varBindingPattern.matchExpr != null && this.types.isAssignable(varBindingPattern.matchExpr.getBType(), this.symTable.anyType);
                return;
            }
            case CAPTURE_BINDING_PATTERN: {
                varBindingPattern.isLastPattern = varBindingPattern.matchExpr != null && !varBindingPattern.matchGuardIsAvailable;
                return;
            }
            case LIST_BINDING_PATTERN: {
                if (varBindingPattern.matchExpr == null) {
                    return;
                }
                varBindingPattern.isLastPattern = this.types.isAssignable(varBindingPattern.matchExpr.getBType(), varBindingPattern.getBType());
            }
        }
    }

    @Override
    public void visit(BLangMappingBindingPattern mappingBindingPattern, AnalyzerData data) {
    }

    @Override
    public void visit(BLangWildCardBindingPattern wildCardBindingPattern, AnalyzerData data) {
    }

    @Override
    public void visit(BLangListMatchPattern listMatchPattern, AnalyzerData data) {
        if (listMatchPattern.matchExpr == null) {
            return;
        }
        listMatchPattern.isLastPattern = this.types.isAssignable(listMatchPattern.matchExpr.getBType(), listMatchPattern.getBType()) && !this.isConstMatchPatternExist(listMatchPattern);
    }

    private boolean isConstMatchPatternExist(BLangMatchPattern matchPattern) {
        return switch (matchPattern.getKind()) {
            case NodeKind.CONST_MATCH_PATTERN -> true;
            case NodeKind.LIST_MATCH_PATTERN -> {
                for (BLangMatchPattern memberMatchPattern : ((BLangListMatchPattern)matchPattern).matchPatterns) {
                    if (!this.isConstMatchPatternExist(memberMatchPattern)) continue;
                    yield true;
                }
                yield false;
            }
            case NodeKind.MAPPING_MATCH_PATTERN -> {
                for (BLangFieldMatchPattern fieldMatchPattern : ((BLangMappingMatchPattern)matchPattern).fieldMatchPatterns) {
                    if (!this.isConstMatchPatternExist(fieldMatchPattern.matchPattern)) continue;
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public void visit(BLangCaptureBindingPattern captureBindingPattern, AnalyzerData data) {
    }

    @Override
    public void visit(BLangListBindingPattern listBindingPattern, AnalyzerData data) {
    }

    @Override
    public void visit(BLangErrorMatchPattern errorMatchPattern, AnalyzerData data) {
    }

    @Override
    public void visit(BLangErrorBindingPattern errorBindingPattern, AnalyzerData data) {
    }

    @Override
    public void visit(BLangForeach foreach, AnalyzerData data) {
        data.loopWithinTransactionCheckStack.push(true);
        boolean onFailExists = foreach.onFailClause != null;
        boolean failureHandled = data.failureHandled;
        if (onFailExists) {
            data.failureHandled = true;
        }
        ++data.loopCount;
        BLangBlockStmt body = foreach.body;
        data.env = SymbolEnv.createLoopEnv(foreach, data.env);
        this.analyzeNode((BLangNode)body, data);
        --data.loopCount;
        data.failureHandled = failureHandled;
        data.loopWithinTransactionCheckStack.pop();
        this.analyzeExpr(foreach.collection, data);
        this.analyseOnFailClause(onFailExists, foreach.onFailClause, data);
    }

    @Override
    public void visit(BLangWhile whileNode, AnalyzerData data) {
        data.loopWithinTransactionCheckStack.push(true);
        boolean onFailExists = whileNode.onFailClause != null;
        boolean failureHandled = data.failureHandled;
        if (onFailExists) {
            data.failureHandled = true;
        }
        ++data.loopCount;
        BLangBlockStmt body = whileNode.body;
        data.env = SymbolEnv.createLoopEnv(whileNode, data.env);
        this.analyzeNode((BLangNode)body, data);
        --data.loopCount;
        data.failureHandled = failureHandled;
        data.loopWithinTransactionCheckStack.pop();
        this.analyzeExpr(whileNode.expr, data);
        this.analyseOnFailClause(onFailExists, whileNode.onFailClause, data);
    }

    @Override
    public void visit(BLangDo doNode, AnalyzerData data) {
        boolean onFailExists = doNode.onFailClause != null;
        boolean failureHandled = data.failureHandled;
        if (onFailExists) {
            data.failureHandled = true;
        }
        this.analyzeNode((BLangNode)doNode.body, data);
        data.failureHandled = failureHandled;
        this.analyseOnFailClause(onFailExists, doNode.onFailClause, data);
    }

    @Override
    public void visit(BLangFail failNode, AnalyzerData data) {
        data.failVisited = true;
        this.analyzeExpr(failNode.expr, data);
        if (data.env.scope.owner.getKind() == SymbolKind.PACKAGE) {
            return;
        }
        this.typeChecker.checkExpr(failNode.expr, data.env);
        if (!data.failureHandled) {
            BType exprType = data.env.enclInvokable.getReturnTypeNode().getBType();
            data.returnTypes.peek().add(exprType);
            BType type = failNode.expr.getBType();
            if (!this.types.isSubtype(this.types.getErrorIntersection(type.semType()), exprType.semType())) {
                this.dlog.error(failNode.pos, DiagnosticErrorCode.FAIL_EXPR_NO_MATCHING_ERROR_RETURN_IN_ENCL_INVOKABLE, new Object[0]);
            }
        }
    }

    @Override
    public void visit(BLangLock lockNode, AnalyzerData data) {
        boolean onFailExists = lockNode.onFailClause != null;
        boolean failureHandled = data.failureHandled;
        if (onFailExists) {
            data.failureHandled = true;
        }
        boolean previousWithinLockBlock = data.withinLockBlock;
        data.withinLockBlock = true;
        lockNode.body.stmts.forEach(e -> this.analyzeNode((BLangNode)e, data));
        data.withinLockBlock = previousWithinLockBlock;
        data.failureHandled = failureHandled;
        this.analyseOnFailClause(onFailExists, lockNode.onFailClause, data);
    }

    @Override
    public void visit(BLangContinue continueNode, AnalyzerData data) {
        if (data.loopCount == 0) {
            this.dlog.error(continueNode.pos, DiagnosticErrorCode.CONTINUE_CANNOT_BE_OUTSIDE_LOOP, new Object[0]);
            return;
        }
        if (this.checkNextBreakValidityInTransaction(data)) {
            this.dlog.error(continueNode.pos, DiagnosticErrorCode.CONTINUE_CANNOT_BE_USED_TO_EXIT_TRANSACTION, new Object[0]);
            return;
        }
        if (data.loopAlterNotAllowed) {
            this.dlog.error(continueNode.pos, DiagnosticErrorCode.CONTINUE_NOT_ALLOWED, new Object[0]);
        }
    }

    @Override
    public void visit(BLangImportPackage importPkgNode, AnalyzerData data) {
        BPackageSymbol pkgSymbol = importPkgNode.symbol;
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgSymbol);
        if (pkgEnv == null) {
            return;
        }
        this.analyzeNode(pkgEnv.node, data);
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode, AnalyzerData data) {
    }

    @Override
    public void visit(BLangService serviceNode, AnalyzerData data) {
    }

    private void analyzeExportableTypeRef(BSymbol owner, BTypeSymbol symbol, boolean inFuncSignature, Location pos) {
        if (!inFuncSignature && Symbols.isFlagOn(owner.flags, 2048L)) {
            return;
        }
        if (Symbols.isPublic(owner)) {
            HashSet<BTypeSymbol> visitedSymbols = new HashSet<BTypeSymbol>();
            this.checkForExportableType(symbol, pos, visitedSymbols);
        }
    }

    private void checkForExportableType(BTypeSymbol symbol, Location pos, HashSet<BTypeSymbol> visitedSymbols) {
        if (symbol == null || symbol.type == null || Symbols.isFlagOn(symbol.flags, 0x200000L)) {
            return;
        }
        if (!visitedSymbols.add(symbol)) {
            return;
        }
        BType type = Types.getImpliedType(symbol.type);
        switch (type.tag) {
            case 20: {
                this.checkForExportableType(((BArrayType)type).eType.tsymbol, pos, visitedSymbols);
                return;
            }
            case 31: {
                BTupleType tupleType = (BTupleType)type;
                tupleType.getTupleTypes().forEach(t -> this.checkForExportableType(t.tsymbol, pos, visitedSymbols));
                if (tupleType.restType != null) {
                    this.checkForExportableType(tupleType.restType.tsymbol, pos, visitedSymbols);
                }
                return;
            }
            case 16: {
                this.checkForExportableType(((BMapType)type).constraint.tsymbol, pos, visitedSymbols);
                return;
            }
            case 12: {
                if (!Symbols.isFlagOn(symbol.flags, 2048L)) break;
                BRecordType recordType = (BRecordType)type;
                recordType.fields.values().forEach(f -> this.checkForExportableType(f.type.tsymbol, pos, visitedSymbols));
                if (recordType.restFieldType != null) {
                    this.checkForExportableType(recordType.restFieldType.tsymbol, pos, visitedSymbols);
                }
                return;
            }
            case 9: {
                BTableType tableType = (BTableType)type;
                if (tableType.constraint != null) {
                    this.checkForExportableType(tableType.constraint.tsymbol, pos, visitedSymbols);
                }
                return;
            }
            case 15: {
                BStreamType streamType = (BStreamType)type;
                if (streamType.constraint != null) {
                    this.checkForExportableType(streamType.constraint.tsymbol, pos, visitedSymbols);
                }
                return;
            }
            case 17: {
                BInvokableType invokableType = (BInvokableType)type;
                if (Symbols.isFlagOn(invokableType.getFlags(), 0x8000000000L)) {
                    return;
                }
                if (invokableType.paramTypes != null) {
                    for (BType paramType : invokableType.paramTypes) {
                        this.checkForExportableType(paramType.tsymbol, pos, visitedSymbols);
                    }
                }
                if (invokableType.restType != null) {
                    this.checkForExportableType(invokableType.restType.tsymbol, pos, visitedSymbols);
                }
                this.checkForExportableType(invokableType.retType.tsymbol, pos, visitedSymbols);
                return;
            }
            case 52: {
                BTypeSymbol parameterizedType = ((BParameterizedType)type).paramValueType.tsymbol;
                this.checkForExportableType(parameterizedType, pos, visitedSymbols);
                return;
            }
            case 29: {
                if (!Symbols.isFlagOn(symbol.flags, 2048L)) break;
                this.checkForExportableType(((BErrorType)type).detailType.tsymbol, pos, visitedSymbols);
                return;
            }
        }
        if (!Symbols.isPublic(symbol)) {
            this.dlog.warning(pos, DiagnosticWarningCode.ATTEMPT_EXPOSE_NON_PUBLIC_SYMBOL, symbol.name);
        }
    }

    @Override
    public void visit(BLangLetExpression letExpression, AnalyzerData data) {
        long ownerSymTag = data.env.scope.owner.tag;
        if ((ownerSymTag & 0x2805CL) == 163932L) {
            this.dlog.error(letExpression.pos, DiagnosticErrorCode.LET_EXPRESSION_NOT_YET_SUPPORTED_RECORD_FIELD, new Object[0]);
        } else if ((ownerSymTag & 0x1805CL) == 98396L) {
            this.dlog.error(letExpression.pos, DiagnosticErrorCode.LET_EXPRESSION_NOT_YET_SUPPORTED_OBJECT_FIELD, new Object[0]);
        }
        data.env = letExpression.env;
        for (BLangLetVariable letVariable : letExpression.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVariable.definitionNode), data);
        }
        this.analyzeExpr(letExpression.expr, data);
    }

    @Override
    public void visit(BLangSimpleVariable varNode, AnalyzerData data) {
        this.analyzeTypeNode(varNode.typeNode, data);
        DefaultValueState prevDefaultValueState = data.defaultValueState;
        if (varNode.flagSet.contains((Object)Flag.DEFAULTABLE_PARAM)) {
            data.defaultValueState = DefaultValueState.PARAMETER_DEFAULT;
        }
        this.analyzeExpr(varNode.expr, data);
        data.defaultValueState = prevDefaultValueState;
        if (Objects.isNull(varNode.symbol)) {
            return;
        }
        if (!Symbols.isPublic(varNode.symbol)) {
            return;
        }
        long ownerSymTag = data.env.scope.owner.tag;
        if ((ownerSymTag & 0x2805CL) == 163932L || (ownerSymTag & 0x1805CL) == 98396L) {
            this.analyzeExportableTypeRef(data.env.scope.owner, varNode.getBType().tsymbol, false, varNode.pos);
        } else if ((ownerSymTag & 0x100L) != 256L) {
            this.analyzeExportableTypeRef(varNode.symbol, varNode.getBType().tsymbol, false, varNode.pos);
        }
        varNode.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, data));
    }

    private boolean isValidInferredArray(BLangNode node) {
        switch (node.getKind()) {
            case INTERSECTION_TYPE_NODE: 
            case UNION_TYPE_NODE: {
                return this.isValidInferredArray(node.parent);
            }
            case VARIABLE: {
                BLangSimpleVariable varNode = (BLangSimpleVariable)node;
                BLangExpression expr = varNode.expr;
                return expr != null && this.isValidContextForInferredArray(node.parent) && this.isValidVariableForInferredArray(expr);
            }
            case CONSTANT: {
                BLangConstant constant = (BLangConstant)node;
                return constant.expr != null && this.isValidContextForInferredArray(node.parent) && this.isValidVariableForInferredArray(constant.expr);
            }
        }
        return false;
    }

    private boolean isValidContextForInferredArray(BLangNode node) {
        return switch (node.getKind()) {
            case NodeKind.PACKAGE, NodeKind.EXPR_FUNCTION_BODY, NodeKind.BLOCK_FUNCTION_BODY, NodeKind.BLOCK -> true;
            case NodeKind.VARIABLE_DEF -> this.isValidContextForInferredArray(node.parent);
            default -> false;
        };
    }

    private boolean isValidVariableForInferredArray(BLangNode node) {
        switch (node.getKind()) {
            case LITERAL: {
                if (node.getBType().tag != 20 && node.getBType().tag != 31) break;
                return true;
            }
            case LIST_CONSTRUCTOR_EXPR: {
                return true;
            }
            case GROUP_EXPR: {
                return this.isValidVariableForInferredArray(((BLangGroupExpr)node).expression);
            }
        }
        return false;
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable, AnalyzerData data) {
        if (bLangTupleVariable.typeNode != null) {
            this.analyzeNode((BLangNode)bLangTupleVariable.typeNode, data);
        }
        this.analyzeExpr(bLangTupleVariable.expr, data);
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable, AnalyzerData data) {
        if (bLangRecordVariable.typeNode != null) {
            this.analyzeNode((BLangNode)bLangRecordVariable.typeNode, data);
        }
        this.analyzeExpr(bLangRecordVariable.expr, data);
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable, AnalyzerData data) {
        if (bLangErrorVariable.typeNode != null) {
            this.analyzeNode((BLangNode)bLangErrorVariable.typeNode, data);
        }
        this.analyzeExpr(bLangErrorVariable.expr, data);
    }

    @Override
    public void visit(BLangIdentifier identifierNode, AnalyzerData data) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode, AnalyzerData data) {
        annotationNode.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, data));
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode, AnalyzerData data) {
        this.analyzeExpr(annAttachmentNode.expr, data);
        BAnnotationSymbol annotationSymbol = annAttachmentNode.annotationSymbol;
        if (annotationSymbol != null && Symbols.isFlagOn(annotationSymbol.flags, 16L)) {
            this.logDeprecatedWaring(annAttachmentNode.annotationName.toString(), annotationSymbol, annAttachmentNode.pos);
        }
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode, AnalyzerData data) {
        this.analyzeNode((BLangNode)varDefNode.var, data);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignment, AnalyzerData data) {
        BLangValueExpression varRef = compoundAssignment.varRef;
        this.analyzeExpr(varRef, data);
        this.analyzeExpr(compoundAssignment.expr, data);
    }

    @Override
    public void visit(BLangAssignment assignNode, AnalyzerData data) {
        BLangExpression varRef = assignNode.varRef;
        this.analyzeExpr(varRef, data);
        this.analyzeExpr(assignNode.expr, data);
    }

    @Override
    public void visit(BLangRecordDestructure stmt, AnalyzerData data) {
        List<BLangExpression> varRefs = this.getVarRefs(stmt.varRef);
        this.checkDuplicateVarRefs(varRefs);
        this.analyzeExpr(stmt.varRef, data);
        this.analyzeExpr(stmt.expr, data);
    }

    @Override
    public void visit(BLangErrorDestructure stmt, AnalyzerData data) {
        List<BLangExpression> varRefs = this.getVarRefs(stmt.varRef);
        this.checkDuplicateVarRefs(varRefs);
        this.analyzeExpr(stmt.varRef, data);
        this.analyzeExpr(stmt.expr, data);
    }

    @Override
    public void visit(BLangTupleDestructure stmt, AnalyzerData data) {
        List<BLangExpression> varRefs = this.getVarRefs(stmt.varRef);
        this.checkDuplicateVarRefs(varRefs);
        this.analyzeExpr(stmt.varRef, data);
        this.analyzeExpr(stmt.expr, data);
    }

    private void checkDuplicateVarRefs(List<BLangExpression> varRefs) {
        this.checkDuplicateVarRefs(varRefs, new HashSet<BSymbol>());
    }

    private void checkDuplicateVarRefs(List<BLangExpression> varRefs, Set<BSymbol> symbols) {
        for (BLangExpression varRef : varRefs) {
            NodeKind kind = varRef.getKind();
            switch (kind) {
                case SIMPLE_VARIABLE_REF: {
                    BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)varRef;
                    if (simpleVarRef.symbol == null || symbols.add(simpleVarRef.symbol)) break;
                    this.dlog.error(varRef.pos, DiagnosticErrorCode.DUPLICATE_VARIABLE_IN_BINDING_PATTERN, simpleVarRef.symbol);
                    break;
                }
                case RECORD_VARIABLE_REF: {
                    this.checkDuplicateVarRefs(this.getVarRefs((BLangRecordVarRef)varRef), symbols);
                    break;
                }
                case ERROR_VARIABLE_REF: {
                    this.checkDuplicateVarRefs(this.getVarRefs((BLangErrorVarRef)varRef), symbols);
                    break;
                }
                case TUPLE_VARIABLE_REF: {
                    this.checkDuplicateVarRefs(this.getVarRefs((BLangTupleVarRef)varRef), symbols);
                    break;
                }
            }
        }
    }

    private List<BLangExpression> getVarRefs(BLangRecordVarRef varRef) {
        return Stream.concat(varRef.recordRefFields.stream().map(e -> e.variableReference), Stream.ofNullable(varRef.restParam)).toList();
    }

    private List<BLangExpression> getVarRefs(BLangErrorVarRef varRef) {
        ArrayList<BLangExpression> varRefs = new ArrayList<BLangExpression>();
        if (varRef.message != null) {
            varRefs.add(varRef.message);
        }
        if (varRef.cause != null) {
            varRefs.add(varRef.cause);
        }
        varRefs.addAll(varRef.detail.stream().map(e -> e.expr).toList());
        if (varRef.restVar != null) {
            varRefs.add(varRef.restVar);
        }
        return varRefs;
    }

    private List<BLangExpression> getVarRefs(BLangTupleVarRef varRef) {
        ArrayList<BLangExpression> varRefs = new ArrayList<BLangExpression>(varRef.expressions);
        if (varRef.restParam != null) {
            varRefs.add(varRef.restParam);
        }
        return varRefs;
    }

    @Override
    public void visit(BLangBreak breakNode, AnalyzerData data) {
        if (data.loopCount == 0) {
            this.dlog.error(breakNode.pos, DiagnosticErrorCode.BREAK_CANNOT_BE_OUTSIDE_LOOP, new Object[0]);
            return;
        }
        if (this.checkNextBreakValidityInTransaction(data)) {
            this.dlog.error(breakNode.pos, DiagnosticErrorCode.BREAK_CANNOT_BE_USED_TO_EXIT_TRANSACTION, new Object[0]);
            return;
        }
        if (data.loopAlterNotAllowed) {
            this.dlog.error(breakNode.pos, DiagnosticErrorCode.BREAK_NOT_ALLOWED, new Object[0]);
        }
    }

    @Override
    public void visit(BLangPanic panicNode, AnalyzerData data) {
        this.analyzeExpr(panicNode.expr, data);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode, AnalyzerData data) {
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode, AnalyzerData data) {
        BLangExpression expr = exprStmtNode.expr;
        this.analyzeExpr(expr, data);
    }

    private boolean isInWorker(SymbolEnv env) {
        return env.enclInvokable.flagSet.contains((Object)Flag.WORKER);
    }

    private boolean isSendAllowedLocation(BLangFunctionBody enclInvokableBody, BLangNode node) {
        return this.isCommunicationAllowedContext(enclInvokableBody, node, this::isSendAllowedContext);
    }

    private boolean isReceiveAllowedLocation(BLangFunctionBody enclInvokableBody, BLangNode node) {
        return this.isCommunicationAllowedContext(enclInvokableBody, node, this::isReceiveAllowedContext);
    }

    private boolean isSendAllowedContext(BLangNode bLangNode) {
        return this.isReceiveAllowedContext(bLangNode) || bLangNode.getKind() == NodeKind.IF || bLangNode.getKind() == NodeKind.ON_FAIL;
    }

    private boolean isReceiveAllowedContext(BLangNode bLangNode) {
        return switch (bLangNode.getKind()) {
            case NodeKind.BLOCK_FUNCTION_BODY, NodeKind.BLOCK, NodeKind.DO_STMT -> true;
            default -> false;
        };
    }

    private boolean isCommunicationAllowedContext(BLangFunctionBody enclInvokableBody, BLangNode node, Predicate<BLangNode> contextChecker) {
        if (enclInvokableBody == node) {
            return true;
        }
        BLangNode parentNode = node.parent;
        if (contextChecker.test(parentNode)) {
            return this.isCommunicationAllowedContext(enclInvokableBody, parentNode, contextChecker);
        }
        return false;
    }

    private boolean withinIfOrOnFail(BLangFunctionBody enclInvokableBody, BLangNode node) {
        if (enclInvokableBody == node) {
            return false;
        }
        BLangNode parentNode = node.parent;
        if (parentNode.getKind() == NodeKind.IF || parentNode.getKind() == NodeKind.ON_FAIL) {
            return true;
        }
        return this.withinIfOrOnFail(enclInvokableBody, parentNode);
    }

    private boolean isDefaultWorkerCommunication(String workerIdentifier) {
        return workerIdentifier.equals("function");
    }

    private boolean workerExists(BType type, String workerName, SymbolEnv env) {
        if (this.isDefaultWorkerCommunication(workerName) && this.isInWorker(env)) {
            return true;
        }
        if (type == this.symTable.semanticError) {
            return false;
        }
        BType refType = Types.getImpliedType(type);
        return refType.tag == 32 && ((BFutureType)refType).workerDerivative;
    }

    @Override
    public void visit(BLangWorkerAsyncSendExpr asyncSendExpr, AnalyzerData data) {
        String workerName;
        boolean invalidSendPos;
        BType type;
        BSymbol receiver = this.symResolver.lookupSymbolInMainSpace(data.env, this.names.fromIdNode(asyncSendExpr.workerIdentifier));
        if ((receiver.tag & 0x34L) != 52L) {
            receiver = this.symTable.notFoundSymbol;
        }
        this.verifyPeerCommunication(asyncSendExpr.pos, receiver, asyncSendExpr.workerIdentifier.value, data.env);
        WorkerActionSystem was = data.workerActionSystemStack.peek();
        if (data.withinLockBlock) {
            this.dlog.error(asyncSendExpr.pos, DiagnosticErrorCode.WORKER_SEND_ACTION_NOT_ALLOWED_IN_LOCK_STATEMENT, new Object[0]);
            was.hasErrors = true;
        }
        if ((type = asyncSendExpr.expr.getBType()) == this.symTable.semanticError) {
            was.hasErrors = true;
        } else if (asyncSendExpr.expr instanceof ActionNode) {
            this.dlog.error(asyncSendExpr.expr.pos, DiagnosticErrorCode.INVALID_SEND_EXPR, new Object[0]);
        }
        boolean bl = invalidSendPos = data.withinQuery || !this.isSendAllowedLocation(data.env.enclInvokable.body, data.env.node) && !data.inInternallyDefinedBlockStmt;
        if (invalidSendPos) {
            this.dlog.error(asyncSendExpr.pos, DiagnosticErrorCode.UNSUPPORTED_WORKER_SEND_POSITION, new Object[0]);
            was.hasErrors = true;
        }
        if (!this.workerExists(asyncSendExpr.workerType, workerName = asyncSendExpr.workerIdentifier.getValue(), data.env) || !this.isWorkerFromFunction(data.env, Names.fromString(workerName)) && !workerName.equals("function")) {
            this.dlog.error(asyncSendExpr.pos, DiagnosticErrorCode.UNDEFINED_WORKER, workerName);
            was.hasErrors = true;
        }
        boolean withinIfOrOnFail = !invalidSendPos && this.withinIfOrOnFail(data.env.enclInvokable.body, data.env.node);
        this.setWorkerSendSendTypeDetails(asyncSendExpr, asyncSendExpr.expr.getBType(), withinIfOrOnFail, data);
        was.addWorkerAction(asyncSendExpr);
        this.analyzeExpr(asyncSendExpr.expr, data);
        this.validateActionParentNode(asyncSendExpr.pos, asyncSendExpr.expr);
    }

    private void setWorkerSendSendTypeDetails(BLangWorkerSendExpr workerSendExpr, BType exprType, boolean withinIfOrOnFail, AnalyzerData data) {
        BType sendType;
        boolean noMessagePossible;
        Set returnTypesUpToNow = data.returnTypes.peek();
        LinkedHashSet<BType> returnTypeAndSendType = new LinkedHashSet<BType>(){
            {
                Comparator.comparing(BType::toString);
            }
        };
        boolean hasNonErrorReturn = false;
        for (BType returnType : returnTypesUpToNow) {
            this.addErrorTypesToSet(returnType, returnTypeAndSendType);
            if (!this.hasNonErrorType(returnType)) continue;
            hasNonErrorReturn = true;
        }
        returnTypeAndSendType.add(exprType);
        BType sendTypeWithNoMsgIgnored = returnTypeAndSendType.size() > 1 ? BUnionType.create(this.symTable.typeEnv(), null, returnTypeAndSendType) : exprType;
        boolean bl = noMessagePossible = withinIfOrOnFail || hasNonErrorReturn;
        if (noMessagePossible) {
            BSymbol noMsgErrSymbol = this.symTable.langErrorModuleSymbol.scope.lookup((Name)Names.fromString((String)NO_MESSAGE_ERROR_TYPE)).symbol;
            returnTypeAndSendType.add(noMsgErrSymbol.getType());
            sendType = returnTypeAndSendType.size() > 1 ? BUnionType.create(this.symTable.typeEnv(), null, returnTypeAndSendType) : exprType;
        } else {
            sendType = sendTypeWithNoMsgIgnored;
        }
        workerSendExpr.sendType = sendType;
        workerSendExpr.sendTypeWithNoMsgIgnored = sendTypeWithNoMsgIgnored;
        workerSendExpr.noMessagePossible = noMessagePossible;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr, AnalyzerData data) {
        boolean invalidSendPos;
        BSymbol receiver = this.symResolver.lookupSymbolInMainSpace(data.env, this.names.fromIdNode(syncSendExpr.workerIdentifier));
        if ((receiver.tag & 0x34L) != 52L) {
            receiver = this.symTable.notFoundSymbol;
        }
        this.verifyPeerCommunication(syncSendExpr.pos, receiver, syncSendExpr.workerIdentifier.value, data.env);
        this.validateActionParentNode(syncSendExpr.pos, syncSendExpr);
        String workerName = syncSendExpr.workerIdentifier.getValue();
        WorkerActionSystem was = data.workerActionSystemStack.peek();
        if (data.withinLockBlock) {
            this.dlog.error(syncSendExpr.pos, DiagnosticErrorCode.WORKER_SEND_ACTION_NOT_ALLOWED_IN_LOCK_STATEMENT, new Object[0]);
            was.hasErrors = true;
        }
        boolean bl = invalidSendPos = data.withinQuery || !this.isSendAllowedLocation(data.env.enclInvokable.body, data.env.node) && !data.inInternallyDefinedBlockStmt;
        if (invalidSendPos) {
            this.dlog.error(syncSendExpr.pos, DiagnosticErrorCode.UNSUPPORTED_WORKER_SEND_POSITION, new Object[0]);
            was.hasErrors = true;
        }
        if (!this.workerExists(syncSendExpr.workerType, workerName, data.env)) {
            this.dlog.error(syncSendExpr.pos, DiagnosticErrorCode.UNDEFINED_WORKER, syncSendExpr.workerSymbol);
            was.hasErrors = true;
        }
        syncSendExpr.setBType(BUnionType.create(this.symTable.typeEnv(), null, this.symTable.nilType, this.symTable.errorType));
        boolean withinIfOrOnFail = !invalidSendPos && this.withinIfOrOnFail(data.env.enclInvokable.body, data.env.node);
        this.setWorkerSendSendTypeDetails(syncSendExpr, syncSendExpr.expr.getBType(), withinIfOrOnFail, data);
        was.addWorkerAction(syncSendExpr);
        this.analyzeExpr(syncSendExpr.expr, data);
    }

    @Override
    public void visit(BLangAlternateWorkerReceive altWorkerReceive, AnalyzerData data) {
        data.workerActionSystemStack.peek().alternateWorkerReceives.add(altWorkerReceive);
        for (BLangWorkerReceive bLangWorkerReceive : altWorkerReceive.getWorkerReceives()) {
            this.analyzeExpr(bLangWorkerReceive, data);
        }
    }

    @Override
    public void visit(BLangMultipleWorkerReceive multipleWorkerReceive, AnalyzerData data) {
        for (BLangMultipleWorkerReceive.BLangReceiveField rvField : multipleWorkerReceive.getReceiveFields()) {
            this.analyzeExpr(rvField.getWorkerReceive(), data);
        }
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode, AnalyzerData data) {
        Location workerReceivePos = workerReceiveNode.pos;
        this.validateActionParentNode(workerReceivePos, workerReceiveNode);
        BSymbol sender = this.symResolver.lookupSymbolInMainSpace(data.env, this.names.fromIdNode(workerReceiveNode.workerIdentifier));
        if ((sender.tag & 0x34L) != 52L) {
            sender = this.symTable.notFoundSymbol;
        }
        this.verifyPeerCommunication(workerReceivePos, sender, workerReceiveNode.workerIdentifier.value, data.env);
        WorkerActionSystem was = data.workerActionSystemStack.peek();
        if (data.withinLockBlock) {
            this.dlog.error(workerReceivePos, DiagnosticErrorCode.WORKER_RECEIVE_ACTION_NOT_ALLOWED_IN_LOCK_STATEMENT, new Object[0]);
            was.hasErrors = true;
        }
        String workerName = workerReceiveNode.workerIdentifier.getValue();
        if (data.withinQuery || !this.isReceiveAllowedLocation(data.env.enclInvokable.body, data.env.node) && !data.inInternallyDefinedBlockStmt) {
            this.dlog.error(workerReceivePos, DiagnosticErrorCode.INVALID_WORKER_RECEIVE_POSITION, new Object[0]);
            was.hasErrors = true;
        }
        if (!this.workerExists(workerReceiveNode.workerType, workerName, data.env)) {
            this.dlog.error(workerReceivePos, DiagnosticErrorCode.UNDEFINED_WORKER, workerName);
            was.hasErrors = true;
        }
        workerReceiveNode.matchingSendsError = this.createAccumulatedErrorTypeForMatchingSyncSend(data, workerReceivePos);
        was.addWorkerAction(workerReceiveNode);
    }

    private void verifyPeerCommunication(Location pos, BSymbol otherWorker, String otherWorkerName, SymbolEnv env) {
        if (env.enclEnv.node.getKind() != NodeKind.FUNCTION) {
            return;
        }
        BLangFunction funcNode = (BLangFunction)env.enclEnv.node;
        Set flagSet = funcNode.flagSet;
        Name workerDerivedName = Names.fromString("0" + otherWorker.name.value);
        if (flagSet.contains((Object)Flag.WORKER)) {
            if (otherWorkerName.equals("function")) {
                if (flagSet.contains((Object)Flag.FORKED)) {
                    this.dlog.error(pos, DiagnosticErrorCode.WORKER_INTERACTIONS_ONLY_ALLOWED_BETWEEN_PEERS, new Object[0]);
                }
                return;
            }
            Scope enclFunctionScope = env.enclEnv.enclEnv.scope;
            BInvokableSymbol wLambda = (BInvokableSymbol)enclFunctionScope.lookup((Name)workerDerivedName).symbol;
            if (wLambda != null && funcNode.anonForkName != null && !funcNode.anonForkName.equals(wLambda.enclForkName)) {
                this.dlog.error(pos, DiagnosticErrorCode.WORKER_INTERACTIONS_ONLY_ALLOWED_BETWEEN_PEERS, new Object[0]);
            }
        } else {
            BInvokableSymbol wLambda = (BInvokableSymbol)env.scope.lookup((Name)workerDerivedName).symbol;
            if (wLambda != null && wLambda.enclForkName != null) {
                this.dlog.error(pos, DiagnosticErrorCode.WORKER_INTERACTIONS_ONLY_ALLOWED_BETWEEN_PEERS, new Object[0]);
            }
        }
    }

    public BType createAccumulatedErrorTypeForMatchingSyncSend(AnalyzerData data, Location workerReceivePos) {
        LinkedHashSet<BType> returnTypesUpToNow = data.returnTypes.peek();
        LinkedHashSet<BType> returnTypeAndSendType = new LinkedHashSet<BType>();
        boolean hasNonErrorReturn = false;
        for (BType returnType : returnTypesUpToNow) {
            if (this.hasNonErrorType(returnType)) {
                hasNonErrorReturn = true;
                continue;
            }
            returnTypeAndSendType.add(returnType);
        }
        if (hasNonErrorReturn) {
            this.dlog.error(workerReceivePos, DiagnosticErrorCode.WORKER_RECEIVE_AFTER_NON_ERROR_RETURN, new Object[0]);
        }
        returnTypeAndSendType.add(this.symTable.nilType);
        if (returnTypeAndSendType.size() > 1) {
            return BUnionType.create(this.symTable.typeEnv(), null, returnTypeAndSendType);
        }
        return this.symTable.nilType;
    }

    private void addErrorTypesToSet(BType returnType, LinkedHashSet<BType> errorTypes) {
        if (returnType == null) {
            return;
        }
        BType effType = Types.getImpliedType(this.types.getTypeWithEffectiveIntersectionTypes(returnType));
        if (effType.tag == 29) {
            errorTypes.add(returnType);
        } else if (effType.tag == 21) {
            for (BType memberType : ((BUnionType)effType).getMemberTypes()) {
                BType t = Types.getImpliedType(this.types.getTypeWithEffectiveIntersectionTypes(memberType));
                if (t.tag != 29) continue;
                errorTypes.add(memberType);
            }
        }
    }

    private boolean hasNonErrorType(BType returnType) {
        return !Core.isSubtypeSimple((SemType)returnType.semType(), (BasicTypeBitSet)PredefinedType.ERROR);
    }

    @Override
    public void visit(BLangLiteral literalExpr, AnalyzerData data) {
    }

    @Override
    public void visit(BLangConstRef constRef, AnalyzerData data) {
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr, AnalyzerData data) {
        for (BLangExpression expr : listConstructorExpr.exprs) {
            if (expr.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                expr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
            }
            this.analyzeExpr(expr, data);
        }
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr, AnalyzerData data) {
        this.analyzeExprs(tableConstructorExpr.recordLiteralList, data);
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral, AnalyzerData data) {
        BType referredType = Types.getImpliedType(recordLiteral.getBType());
        boolean isRecord = referredType.tag == 12;
        List<RecordLiteralNode.RecordField> recordLiteralFields = recordLiteral.fields;
        LinkedHashMap<String, BField> recordFields = null;
        if (isRecord) {
            recordFields = ((BRecordType)referredType).getFields();
        }
        for (RecordLiteralNode.RecordField field : recordLiteralFields) {
            if (field.isKeyValueField()) {
                this.analyzeExpr(((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr, data);
                this.reportIfDeprecatedUsage(((BLangRecordLiteral.BLangRecordKeyValueField)field).key.fieldSymbol, recordLiteral, ((BLangRecordLiteral.BLangRecordKeyValueField)field).pos);
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BField matchingField;
                BLangRecordLiteral.BLangRecordVarNameField recField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                this.analyzeExpr(recField, data);
                if (!isRecord || (matchingField = recordFields.get(recField.symbol.getName().getValue())) == null) continue;
                this.reportIfDeprecatedUsage(matchingField.symbol, recordLiteral, recField.pos);
                continue;
            }
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            this.analyzeExpr(spreadField.expr, data);
            BType spreadFieldType = Types.getImpliedType(spreadField.expr.getBType());
            if (!isRecord || spreadFieldType == null || spreadFieldType.tag != 12) continue;
            for (BField fieldEntry : ((BRecordType)spreadFieldType).getFields().values()) {
                BField matchingField = recordFields.get(fieldEntry.getName().getValue());
                if (matchingField == null) continue;
                this.reportIfDeprecatedUsage(matchingField.symbol, recordLiteral, spreadField.expr.pos);
            }
        }
        HashSet<Object> names = new HashSet<Object>();
        HashSet<String> neverTypedKeys = new HashSet<String>();
        boolean isOpenRecord = isRecord && !((BRecordType)referredType).sealed;
        boolean isInferredRecordForMapCET = isRecord && recordLiteral.expectedType != null && Types.getImpliedType((BType)recordLiteral.expectedType).tag == 16;
        BLangRecordLiteral.BLangRecordSpreadOperatorField inclusiveTypeSpreadField = null;
        for (RecordLiteralNode.RecordField field : recordLiteralFields) {
            Object name;
            BLangExpression keyExpr;
            if (field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP) {
                BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOpField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
                BLangExpression spreadOpExpr = spreadOpField.expr;
                this.analyzeExpr(spreadOpExpr, data);
                BType spreadOpExprType = Types.getImpliedType(spreadOpExpr.getBType());
                int spreadFieldTypeTag = spreadOpExprType.tag;
                if (spreadFieldTypeTag == 16) {
                    if (inclusiveTypeSpreadField != null) {
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.MULTIPLE_INCLUSIVE_TYPES, new Object[0]);
                        continue;
                    }
                    inclusiveTypeSpreadField = spreadOpField;
                    if (recordLiteralFields.size() > 1) {
                        if (names.isEmpty()) continue;
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.SPREAD_FIELD_MAY_DULPICATE_ALREADY_SPECIFIED_KEYS, spreadOpExpr);
                        continue;
                    }
                }
                if (spreadFieldTypeTag != 12) continue;
                BRecordType spreadExprRecordType = (BRecordType)spreadOpExprType;
                boolean isSpreadExprRecordTypeSealed = spreadExprRecordType.sealed;
                if (!isSpreadExprRecordTypeSealed) {
                    if (inclusiveTypeSpreadField != null) {
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.MULTIPLE_INCLUSIVE_TYPES, new Object[0]);
                    } else {
                        inclusiveTypeSpreadField = spreadOpField;
                    }
                }
                LinkedHashMap<String, BField> fieldsInRecordType = this.getUnescapedFieldList(spreadExprRecordType.fields);
                for (Object e : names) {
                    if (fieldsInRecordType.containsKey(e) || isSpreadExprRecordTypeSealed) continue;
                    this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.SPREAD_FIELD_MAY_DULPICATE_ALREADY_SPECIFIED_KEYS, spreadOpExpr);
                    break;
                }
                for (String string : fieldsInRecordType.keySet()) {
                    BField bField = fieldsInRecordType.get(string);
                    BType bFieldType = Types.getImpliedType(bField.type);
                    if (names.contains(string)) {
                        if (bFieldType.tag == 50) continue;
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.DUPLICATE_KEY_IN_RECORD_LITERAL_SPREAD_OP, referredType.getKind().typeName(), string, spreadOpField);
                        continue;
                    }
                    if (bFieldType.tag == 50) {
                        neverTypedKeys.add(string);
                        continue;
                    }
                    if (!neverTypedKeys.remove(string) && inclusiveTypeSpreadField != null && isSpreadExprRecordTypeSealed) {
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.POSSIBLE_DUPLICATE_OF_FIELD_SPECIFIED_VIA_SPREAD_OP, Types.getImpliedType(recordLiteral.expectedType).getKind().typeName(), bField.symbol, spreadOpField);
                    }
                    names.add(string);
                }
                continue;
            }
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKey key = ((BLangRecordLiteral.BLangRecordKeyValueField)field).key;
                keyExpr = key.expr;
                if (key.computedKey) {
                    this.analyzeExpr(keyExpr, data);
                    continue;
                }
            } else {
                keyExpr = (BLangRecordLiteral.BLangRecordVarNameField)field;
            }
            if (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                name = ((BLangSimpleVarRef)keyExpr).variableName.value;
                String unescapedName = Utils.unescapeJava((String)name);
                if (names.contains(unescapedName)) {
                    this.dlog.error(keyExpr.pos, DiagnosticErrorCode.DUPLICATE_KEY_IN_MAPPING_CONSTRUCTOR, Types.getImpliedType(recordLiteral.expectedType).getKind().typeName(), unescapedName);
                } else if (inclusiveTypeSpreadField != null && !neverTypedKeys.contains(unescapedName)) {
                    this.dlog.error(keyExpr.pos, DiagnosticErrorCode.POSSIBLE_DUPLICATE_OF_FIELD_SPECIFIED_VIA_SPREAD_OP, unescapedName, inclusiveTypeSpreadField);
                }
                if (!isInferredRecordForMapCET && isOpenRecord && !((BRecordType)referredType).fields.containsKey(name)) {
                    this.dlog.error(keyExpr.pos, DiagnosticErrorCode.INVALID_RECORD_LITERAL_IDENTIFIER_KEY, unescapedName);
                }
                names.add(unescapedName);
                continue;
            }
            if (keyExpr.getKind() != NodeKind.LITERAL && keyExpr.getKind() != NodeKind.NUMERIC_LITERAL) continue;
            name = ((BLangLiteral)keyExpr).value;
            if (names.contains(name)) {
                this.dlog.error(keyExpr.pos, DiagnosticErrorCode.DUPLICATE_KEY_IN_MAPPING_CONSTRUCTOR, Types.getImpliedType(recordLiteral.parent.getBType()).getKind().typeName(), name);
            } else if (inclusiveTypeSpreadField != null && !neverTypedKeys.contains(name)) {
                this.dlog.error(keyExpr.pos, DiagnosticErrorCode.POSSIBLE_DUPLICATE_OF_FIELD_SPECIFIED_VIA_SPREAD_OP, name, inclusiveTypeSpreadField);
            }
            names.add(name);
        }
        if (isInferredRecordForMapCET) {
            recordLiteral.expectedType = referredType;
        }
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordVarNameField node, AnalyzerData data) {
        this.visit((BLangSimpleVarRef)node, data);
    }

    private LinkedHashMap<String, BField> getUnescapedFieldList(LinkedHashMap<String, BField> fieldMap) {
        LinkedHashMap<String, BField> newMap = new LinkedHashMap<String, BField>();
        for (String key : fieldMap.keySet()) {
            newMap.put(Utils.unescapeJava((String)key), fieldMap.get(key));
        }
        return newMap;
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr, AnalyzerData data) {
        BSymbol symbol;
        switch (varRefExpr.parent.getKind()) {
            case WORKER_RECEIVE: 
            case WORKER_ASYNC_SEND: 
            case WORKER_SYNC_SEND: {
                return;
            }
        }
        if (varRefExpr.getBType() != null && Types.getImpliedType((BType)varRefExpr.getBType()).tag == 32) {
            this.trackNamedWorkerReferences(varRefExpr, data);
        }
        if ((symbol = varRefExpr.symbol) != null && Symbols.isFlagOn(symbol.flags, 16L)) {
            this.logDeprecatedWaring(varRefExpr.variableName.toString(), symbol, varRefExpr.pos);
        }
    }

    private void trackNamedWorkerReferences(BLangSimpleVarRef varRefExpr, AnalyzerData data) {
        if (varRefExpr.symbol == null || (varRefExpr.symbol.flags & 0x800000L) != 0x800000L) {
            return;
        }
        data.workerReferences.computeIfAbsent(varRefExpr.symbol, s -> new LinkedHashSet());
        data.workerReferences.get(varRefExpr.symbol).add(varRefExpr);
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr, AnalyzerData data) {
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr, AnalyzerData data) {
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr, AnalyzerData data) {
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr, AnalyzerData data) {
        this.analyzeFieldBasedAccessExpr(fieldAccessExpr, data);
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess prefixedFieldBasedAccess, AnalyzerData data) {
        this.analyzeFieldBasedAccessExpr(prefixedFieldBasedAccess, data);
    }

    private void analyzeFieldBasedAccessExpr(BLangFieldBasedAccess fieldAccessExpr, AnalyzerData data) {
        BLangExpression expr = fieldAccessExpr.expr;
        this.analyzeExpr(expr, data);
        this.reportIfDeprecatedUsage(fieldAccessExpr.symbol, expr, fieldAccessExpr.pos);
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr, AnalyzerData data) {
        this.analyzeExpr(indexAccessExpr.indexExpr, data);
        this.analyzeExpr(indexAccessExpr.expr, data);
    }

    @Override
    public void visit(BLangInvocation invocationExpr, AnalyzerData data) {
        this.analyzeExpr(invocationExpr.expr, data);
        this.analyzeExprs(invocationExpr.requiredArgs, data);
        this.analyzeExprs(invocationExpr.restArgs, data);
        this.validateInvocationInMatchGuard(invocationExpr);
        if (invocationExpr.symbol != null && invocationExpr.symbol.kind == SymbolKind.FUNCTION) {
            BSymbol funcSymbol = invocationExpr.symbol;
            if (Symbols.isFlagOn(funcSymbol.flags, 0x2000000L) && !data.withinTransactionScope) {
                this.dlog.error(invocationExpr.pos, DiagnosticErrorCode.TRANSACTIONAL_FUNC_INVOKE_PROHIBITED, new Object[0]);
                return;
            }
            if (Symbols.isFlagOn(funcSymbol.flags, 16L)) {
                this.logDeprecatedWarningForInvocation(invocationExpr);
            }
        }
        this.analyzeInvocationParams(invocationExpr, data);
    }

    @Override
    public void visit(BLangCollectContextInvocation node, AnalyzerData data) {
        this.analyzeExpr(node.invocation, data);
    }

    @Override
    public void visit(BLangErrorConstructorExpr errorConstructorExpr, AnalyzerData data) {
        this.analyzeExprs(errorConstructorExpr.positionalArgs, data);
        if (!errorConstructorExpr.namedArgs.isEmpty()) {
            this.analyzeExprs(errorConstructorExpr.namedArgs, data);
        }
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocation, AnalyzerData data) {
        this.validateInvocationInMatchGuard(actionInvocation);
        if (!actionInvocation.async && !data.withinTransactionScope && Symbols.isFlagOn(actionInvocation.symbol.flags, 0x2000000L)) {
            this.dlog.error(actionInvocation.pos, DiagnosticErrorCode.TRANSACTIONAL_FUNC_INVOKE_PROHIBITED, actionInvocation.symbol);
            return;
        }
        if (actionInvocation.async && data.withinTransactionScope && !Symbols.isFlagOn(actionInvocation.symbol.flags, 0x2000000L)) {
            this.dlog.error(actionInvocation.pos, DiagnosticErrorCode.USAGE_OF_START_WITHIN_TRANSACTION_IS_PROHIBITED, new Object[0]);
            return;
        }
        this.analyzeExpr(actionInvocation.expr, data);
        this.analyzeExprs(actionInvocation.requiredArgs, data);
        this.analyzeExprs(actionInvocation.restArgs, data);
        if (actionInvocation.symbol != null && actionInvocation.symbol.kind == SymbolKind.FUNCTION && Symbols.isFlagOn(actionInvocation.symbol.flags, 16L)) {
            this.logDeprecatedWarningForInvocation(actionInvocation);
        }
        if (actionInvocation.flagSet.contains((Object)Flag.TRANSACTIONAL) && !data.withinTransactionScope) {
            this.dlog.error(actionInvocation.pos, DiagnosticErrorCode.TRANSACTIONAL_FUNC_INVOKE_PROHIBITED, new Object[0]);
            return;
        }
        if (actionInvocation.async && data.withinLockBlock) {
            this.dlog.error(actionInvocation.pos, actionInvocation.functionPointerInvocation ? DiagnosticErrorCode.USAGE_OF_WORKER_WITHIN_LOCK_IS_PROHIBITED : DiagnosticErrorCode.USAGE_OF_START_WITHIN_LOCK_IS_PROHIBITED, new Object[0]);
            return;
        }
        if (actionInvocation.symbol != null && (actionInvocation.symbol.tag & 0x4000100L) == 0x4000100L) {
            this.dlog.error(actionInvocation.pos, DiagnosticErrorCode.INVALID_FUNCTIONAL_CONSTRUCTOR_INVOCATION, actionInvocation.symbol);
            return;
        }
        this.validateActionInvocation(actionInvocation.pos, actionInvocation);
        if (!actionInvocation.async && data.withinTransactionScope) {
            actionInvocation.invokedInsideTransaction = true;
        }
    }

    @Override
    public void visit(BLangInvocation.BLangResourceAccessInvocation resourceActionInvocation, AnalyzerData data) {
        this.validateInvocationInMatchGuard(resourceActionInvocation);
        this.analyzeExpr(resourceActionInvocation.expr, data);
        this.analyzeExprs(resourceActionInvocation.requiredArgs, data);
        this.analyzeExprs(resourceActionInvocation.restArgs, data);
        this.analyzeExpr(resourceActionInvocation.resourceAccessPathSegments, data);
        resourceActionInvocation.invokedInsideTransaction = data.withinTransactionScope;
        if (Symbols.isFlagOn(resourceActionInvocation.symbol.flags, 0x2000000L) && !data.withinTransactionScope) {
            this.dlog.error(resourceActionInvocation.pos, DiagnosticErrorCode.TRANSACTIONAL_FUNC_INVOKE_PROHIBITED, new Object[0]);
            return;
        }
        if (Symbols.isFlagOn(resourceActionInvocation.symbol.flags, 16L)) {
            this.logDeprecatedWarningForInvocation(resourceActionInvocation);
        }
        this.validateActionInvocation(resourceActionInvocation.pos, resourceActionInvocation);
    }

    private void logDeprecatedWarningForInvocation(BLangInvocation invocationExpr) {
        Object deprecatedConstruct = invocationExpr.name.toString();
        BLangExpression expr = invocationExpr.expr;
        BSymbol funcSymbol = invocationExpr.symbol;
        if (expr != null) {
            deprecatedConstruct = this.generateDeprecatedConstructString(expr, (String)deprecatedConstruct, funcSymbol);
        } else if (!Names.DOT.equals(funcSymbol.pkgID.name)) {
            deprecatedConstruct = String.valueOf(funcSymbol.pkgID) + ":" + (String)deprecatedConstruct;
        }
        this.dlog.warning(invocationExpr.pos, DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT, deprecatedConstruct);
    }

    private String generateDeprecatedConstructString(BLangExpression expr, String fieldOrMethodName, BSymbol symbol) {
        BType bType = expr.getBType();
        if (bType.tag == 14) {
            return String.valueOf(bType) + "." + (String)fieldOrMethodName;
        }
        if (bType.tag == 34) {
            BObjectType objectType = (BObjectType)bType;
            if (objectType.classDef == null || !objectType.classDef.internal) {
                fieldOrMethodName = String.valueOf(bType) + "." + (String)fieldOrMethodName;
            }
            return fieldOrMethodName;
        }
        if (symbol.kind == SymbolKind.FUNCTION && !Names.DOT.equals(symbol.pkgID.name)) {
            fieldOrMethodName = String.valueOf(symbol.pkgID) + ":" + (String)fieldOrMethodName;
        }
        return fieldOrMethodName;
    }

    private void validateActionInvocation(Location pos, BLangInvocation iExpr) {
        if (iExpr.expr != null) {
            NodeKind clientNodeKind = iExpr.expr.getKind();
            if (clientNodeKind == NodeKind.FIELD_BASED_ACCESS_EXPR) {
                BLangFieldBasedAccess fieldBasedAccess = (BLangFieldBasedAccess)iExpr.expr;
                if (fieldBasedAccess.expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
                    this.dlog.error(pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION_AS_EXPR, new Object[0]);
                } else {
                    BLangSimpleVarRef selfName = (BLangSimpleVarRef)fieldBasedAccess.expr;
                    if (!Names.SELF.equals(selfName.symbol.name)) {
                        this.dlog.error(pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION_AS_EXPR, new Object[0]);
                    }
                }
            } else if (clientNodeKind != NodeKind.SIMPLE_VARIABLE_REF && clientNodeKind != NodeKind.GROUP_EXPR) {
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION_AS_EXPR, new Object[0]);
            }
        }
        this.validateActionParentNode(pos, iExpr);
    }

    private boolean validateActionParentNode(Location pos, BLangNode node) {
        BLangNode parent = node.parent;
        while (parent != null) {
            NodeKind kind = parent.getKind();
            if (parent instanceof StatementNode || this.checkActionInQuery(kind)) {
                return true;
            }
            if (!(parent instanceof ActionNode) && !(parent instanceof BLangVariable) && kind != NodeKind.CHECK_EXPR && kind != NodeKind.CHECK_PANIC_EXPR && kind != NodeKind.TRAP_EXPR && kind != NodeKind.GROUP_EXPR && kind != NodeKind.TYPE_CONVERSION_EXPR || parent instanceof BLangInvocation.BLangActionInvocation) break;
            parent = parent.parent;
        }
        this.dlog.error(pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION_AS_EXPR, new Object[0]);
        return false;
    }

    private boolean checkActionInQuery(NodeKind parentKind) {
        return parentKind == NodeKind.FROM || parentKind == NodeKind.SELECT || parentKind == NodeKind.LET_CLAUSE;
    }

    @Override
    public void visit(BLangTypeInit cIExpr, AnalyzerData data) {
        this.analyzeExprs(cIExpr.argsExpr, data);
        this.analyzeExpr(cIExpr.initInvocation, data);
        BType type = cIExpr.getBType();
        if (cIExpr.userDefinedType != null && Symbols.isFlagOn(type.tsymbol.flags, 16L)) {
            this.logDeprecatedWaring(((BLangUserDefinedType)cIExpr.userDefinedType).typeName.toString(), type.tsymbol, cIExpr.pos);
        }
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr, AnalyzerData data) {
        this.analyzeExpr(ternaryExpr.expr, data);
        this.analyzeExpr(ternaryExpr.thenExpr, data);
        this.analyzeExpr(ternaryExpr.elseExpr, data);
    }

    @Override
    public void visit(BLangWaitExpr awaitExpr, AnalyzerData data) {
        BLangExpression expr = awaitExpr.getExpression();
        boolean validWaitFuture = this.validateWaitFutureExpr(expr);
        this.analyzeExpr(expr, data);
        boolean validActionParent = this.validateActionParentNode(awaitExpr.pos, awaitExpr);
        WorkerActionSystem was = data.workerActionSystemStack.peek();
        was.addWorkerAction(awaitExpr, data.env);
        was.hasErrors = !validWaitFuture && !validActionParent;
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr, AnalyzerData data) {
        boolean validWaitFuture = true;
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyValue : waitForAllExpr.keyValuePairs) {
            BLangExpression expr = keyValue.valueExpr != null ? keyValue.valueExpr : keyValue.keyExpr;
            validWaitFuture = validWaitFuture && this.validateWaitFutureExpr(expr);
            this.analyzeExpr(expr, data);
        }
        boolean validActionParent = this.validateActionParentNode(waitForAllExpr.pos, waitForAllExpr);
        WorkerActionSystem was = data.workerActionSystemStack.peek();
        was.addWorkerAction(waitForAllExpr, data.env);
        was.hasErrors = !validWaitFuture && !validActionParent;
    }

    private boolean validateWaitFutureExpr(BLangExpression expr) {
        if (expr.getKind() == NodeKind.RECORD_LITERAL_EXPR) {
            this.dlog.error(expr.pos, DiagnosticErrorCode.INVALID_WAIT_MAPPING_CONSTRUCTORS, new Object[0]);
            return false;
        }
        if (expr instanceof ActionNode) {
            this.dlog.error(expr.pos, DiagnosticErrorCode.INVALID_WAIT_ACTIONS, new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess, AnalyzerData data) {
        this.analyzeExpr(xmlElementAccess.expr, data);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation, AnalyzerData data) {
        this.analyzeExpr(xmlNavigation.expr, data);
    }

    @Override
    public void visit(BLangExtendedXMLNavigationAccess extendedXmlNavigationAccess, AnalyzerData data) {
        this.analyzeExpr(extendedXmlNavigationAccess.stepExpr, data);
        extendedXmlNavigationAccess.extensions.forEach(extension -> this.analyzeNode((BLangNode)extension, data));
    }

    @Override
    public void visit(BLangXMLIndexedStepExtend xmlIndexedStepExtend, AnalyzerData data) {
        this.analyzeExpr(xmlIndexedStepExtend.indexExpr, data);
    }

    @Override
    public void visit(BLangXMLFilterStepExtend xmlFilterStepExtend, AnalyzerData data) {
    }

    @Override
    public void visit(BLangXMLMethodCallStepExtend xmlMethodCallStepExtend, AnalyzerData data) {
        this.analyzeExpr(xmlMethodCallStepExtend.invocation, data);
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr, AnalyzerData data) {
        BLangIdentifier flushWrkIdentifier = workerFlushExpr.workerIdentifier;
        Deque<WorkerActionSystem> workerActionSystems = data.workerActionSystemStack;
        WorkerActionSystem currentWrkerAction = workerActionSystems.peek();
        List<BLangWorkerAsyncSendExpr> sendStmts = this.getAsyncSendStmtsOfWorker(currentWrkerAction);
        if (flushWrkIdentifier != null) {
            List<BLangWorkerAsyncSendExpr> sendsToGivenWrkr = sendStmts.stream().filter(bLangNode -> bLangNode.workerIdentifier.equals(flushWrkIdentifier)).toList();
            if (sendsToGivenWrkr.isEmpty()) {
                this.dlog.error(workerFlushExpr.pos, DiagnosticErrorCode.INVALID_WORKER_FLUSH_FOR_WORKER, workerFlushExpr.workerSymbol, currentWrkerAction.currentWorkerId());
                return;
            }
            sendStmts = sendsToGivenWrkr;
        } else if (sendStmts.isEmpty()) {
            this.dlog.error(workerFlushExpr.pos, DiagnosticErrorCode.INVALID_WORKER_FLUSH, currentWrkerAction.currentWorkerId());
            return;
        }
        workerFlushExpr.cachedWorkerSendStmts = sendStmts;
        this.validateActionParentNode(workerFlushExpr.pos, workerFlushExpr);
    }

    private List<BLangWorkerAsyncSendExpr> getAsyncSendStmtsOfWorker(WorkerActionSystem currentWorkerAction) {
        List<BLangNode> actions = currentWorkerAction.workerActionStateMachines.peek().actions;
        return actions.stream().filter(CodeAnalyzer::isWorkerSend).map(bLangNode -> (BLangWorkerAsyncSendExpr)bLangNode).toList();
    }

    @Override
    public void visit(BLangTrapExpr trapExpr, AnalyzerData data) {
        this.analyzeExpr(trapExpr.expr, data);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr, AnalyzerData data) {
        if (this.validateBinaryExpr(binaryExpr)) {
            this.analyzeExpr(binaryExpr.lhsExpr, data);
            this.analyzeExpr(binaryExpr.rhsExpr, data);
        }
    }

    private boolean validateBinaryExpr(BLangBinaryExpr binaryExpr) {
        int lhsTypeTag = Types.getImpliedType((BType)binaryExpr.lhsExpr.getBType()).tag;
        int rhsTypeTag = Types.getImpliedType((BType)binaryExpr.rhsExpr.getBType()).tag;
        if (lhsTypeTag != 32 && rhsTypeTag != 32) {
            return true;
        }
        BLangNode parentNode = binaryExpr.parent;
        if (parentNode == null) {
            return false;
        }
        if (parentNode.getKind() == NodeKind.WAIT_EXPR) {
            return true;
        }
        if (parentNode.getKind() != NodeKind.BINARY_EXPR && binaryExpr.opKind == OperatorKind.BITWISE_OR) {
            this.dlog.error(binaryExpr.pos, DiagnosticErrorCode.OPERATOR_NOT_SUPPORTED, new Object[]{OperatorKind.BITWISE_OR, this.symTable.futureType});
            return false;
        }
        if (parentNode.getKind() == NodeKind.BINARY_EXPR) {
            return this.validateBinaryExpr((BLangBinaryExpr)parentNode);
        }
        return true;
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr, AnalyzerData data) {
        this.analyzeExpr(elvisExpr.lhsExpr, data);
        this.analyzeExpr(elvisExpr.rhsExpr, data);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr, AnalyzerData data) {
        this.analyzeExpr(groupExpr.expression, data);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr, AnalyzerData data) {
        this.analyzeExpr(unaryExpr.expr, data);
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr, AnalyzerData data) {
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr, AnalyzerData data) {
        this.analyzeExpr(conversionExpr.expr, data);
        conversionExpr.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, data));
    }

    @Override
    public void visit(BLangXMLQName xmlQName, AnalyzerData data) {
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute, AnalyzerData data) {
        this.analyzeExpr(xmlAttribute.name, data);
        this.analyzeExpr(xmlAttribute.value, data);
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral, AnalyzerData data) {
        this.analyzeExpr(xmlElementLiteral.startTagName, data);
        this.analyzeExpr(xmlElementLiteral.endTagName, data);
        this.analyzeExprs(xmlElementLiteral.attributes, data);
        this.analyzeExprs(xmlElementLiteral.children, data);
    }

    @Override
    public void visit(BLangXMLSequenceLiteral xmlSequenceLiteral, AnalyzerData data) {
        this.analyzeExprs(xmlSequenceLiteral.xmlItems, data);
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral, AnalyzerData data) {
        this.analyzeExprs(xmlTextLiteral.textFragments, data);
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral, AnalyzerData data) {
        this.analyzeExprs(xmlCommentLiteral.textFragments, data);
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral, AnalyzerData data) {
        this.analyzeExprs(xmlProcInsLiteral.dataFragments, data);
        this.analyzeExpr(xmlProcInsLiteral.target, data);
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString, AnalyzerData data) {
        this.analyzeExprs(xmlQuotedString.textFragments, data);
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral, AnalyzerData data) {
        this.analyzeExprs(stringTemplateLiteral.exprs, data);
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral, AnalyzerData data) {
        this.analyzeExprs(rawTemplateLiteral.strings, data);
        this.analyzeExprs(rawTemplateLiteral.insertions, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction, AnalyzerData data) {
        String workerVarName;
        boolean isWorker = false;
        this.analyzeNode((BLangNode)bLangLambdaFunction.function, data);
        if (bLangLambdaFunction.function.flagSet.contains((Object)Flag.TRANSACTIONAL) && bLangLambdaFunction.function.flagSet.contains((Object)Flag.WORKER) && !data.withinTransactionScope) {
            this.dlog.error(bLangLambdaFunction.pos, DiagnosticErrorCode.TRANSACTIONAL_WORKER_OUT_OF_TRANSACTIONAL_SCOPE, bLangLambdaFunction);
            return;
        }
        if (bLangLambdaFunction.parent.getKind() == NodeKind.VARIABLE && (workerVarName = ((BLangSimpleVariable)bLangLambdaFunction.parent).name.value).startsWith("0")) {
            String workerName = workerVarName.substring(1);
            isWorker = true;
            data.workerActionSystemStack.peek().startWorkerActionStateMachine(workerName, bLangLambdaFunction.function.pos, bLangLambdaFunction.function);
        }
        if (isWorker) {
            this.visitFunction(bLangLambdaFunction.function, data);
        } else {
            try {
                this.initNewWorkerActionSystem(data);
                data.workerActionSystemStack.peek().startWorkerActionStateMachine("function", bLangLambdaFunction.pos, bLangLambdaFunction.function);
                this.visitFunction(bLangLambdaFunction.function, data);
                data.workerActionSystemStack.peek().endWorkerActionStateMachine();
            }
            finally {
                this.finalizeCurrentWorkerActionSystem(data);
            }
        }
        if (isWorker) {
            data.workerActionSystemStack.peek().endWorkerActionStateMachine();
        }
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction, AnalyzerData data) {
        DefaultValueState prevDefaultValueState = data.defaultValueState;
        if (this.inDefaultValue(prevDefaultValueState)) {
            data.defaultValueState = DefaultValueState.FUNCTION_IN_DEFAULT_VALUE;
        }
        this.analyzeExpr(bLangArrowFunction.body.expr, data);
        data.defaultValueState = prevDefaultValueState;
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode, AnalyzerData data) {
        data.env = SymbolEnv.createTypeEnv(recordTypeNode, recordTypeNode.symbol.scope, data.env);
        for (BLangSimpleVariable field : recordTypeNode.fields) {
            DefaultValueState prevDefaultValueState = data.defaultValueState;
            data.defaultValueState = DefaultValueState.RECORD_FIELD_DEFAULT;
            this.analyzeNode((BLangNode)field, data);
            data.defaultValueState = prevDefaultValueState;
        }
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode, AnalyzerData data) {
        data.env = SymbolEnv.createTypeEnv(objectTypeNode, objectTypeNode.symbol.scope, data.env);
        for (BLangSimpleVariable field : objectTypeNode.fields) {
            this.analyzeNode((BLangNode)field, data);
        }
        ArrayList<BLangFunction> bLangFunctionList = new ArrayList<BLangFunction>(objectTypeNode.functions);
        if (objectTypeNode.initFunction != null) {
            bLangFunctionList.add(objectTypeNode.initFunction);
        }
        bLangFunctionList.sort(Comparator.comparingInt(function -> function.pos.lineRange().startLine().line()));
        for (BLangFunction function2 : bLangFunctionList) {
            this.analyzeNode((BLangNode)function2, data);
        }
    }

    @Override
    public void visit(BLangValueType valueType, AnalyzerData data) {
    }

    @Override
    public void visit(BLangArrayType arrayType, AnalyzerData data) {
        if (this.containsInferredArraySizesOfHigherDimensions(arrayType.sizes)) {
            this.dlog.error(arrayType.pos, DiagnosticErrorCode.INFER_SIZE_ONLY_SUPPORTED_IN_FIRST_DIMENSION, new Object[0]);
        } else if (this.isSizeInferredArray(arrayType.sizes) && !this.isValidInferredArray(arrayType.parent)) {
            this.dlog.error(arrayType.pos, DiagnosticErrorCode.CANNOT_INFER_SIZE_ARRAY_SIZE_FROM_THE_CONTEXT, new Object[0]);
        }
        this.analyzeTypeNode(arrayType.elemtype, data);
    }

    private boolean isSizeInferredArray(List<BLangExpression> indexSizes) {
        return !indexSizes.isEmpty() && this.isInferredArrayIndicator(indexSizes.get(indexSizes.size() - 1));
    }

    private boolean isInferredArrayIndicator(BLangExpression size) {
        return size.getKind() == NodeKind.LITERAL && ((BLangLiteral)size).value.equals(-2);
    }

    private boolean containsInferredArraySizesOfHigherDimensions(List<BLangExpression> sizes) {
        if (sizes.size() < 2) {
            return false;
        }
        for (int i = 0; i < sizes.size() - 1; ++i) {
            if (!this.isInferredArrayIndicator(sizes.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType, AnalyzerData data) {
    }

    @Override
    public void visit(BLangConstrainedType constrainedType, AnalyzerData data) {
        this.analyzeTypeNode(constrainedType.constraint, data);
    }

    @Override
    public void visit(BLangStreamType streamType, AnalyzerData data) {
        this.analyzeTypeNode(streamType.constraint, data);
        this.analyzeTypeNode(streamType.error, data);
    }

    @Override
    public void visit(BLangTableTypeNode tableType, AnalyzerData data) {
        this.analyzeTypeNode(tableType.constraint, data);
        if (tableType.tableKeyTypeConstraint != null) {
            this.analyzeTypeNode(tableType.tableKeyTypeConstraint.keyType, data);
        }
    }

    @Override
    public void visit(BLangErrorType errorType, AnalyzerData data) {
        BLangType constraint;
        BLangType detailType = errorType.detailType;
        if (detailType != null && detailType.getKind() == NodeKind.CONSTRAINED_TYPE && (constraint = ((BLangConstrainedType)detailType).constraint).getKind() == NodeKind.USER_DEFINED_TYPE) {
            BLangUserDefinedType userDefinedType = (BLangUserDefinedType)constraint;
            if (userDefinedType.typeName.value.equals("$IntersectedErrorDetail$")) {
                return;
            }
        }
        this.analyzeTypeNode(errorType.detailType, data);
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType, AnalyzerData data) {
        BTypeSymbol typeSymbol = userDefinedType.getBType().tsymbol;
        if (typeSymbol != null && Symbols.isFlagOn(typeSymbol.flags, 16L)) {
            this.logDeprecatedWaring(userDefinedType.typeName.toString(), typeSymbol, userDefinedType.pos);
        }
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode, AnalyzerData data) {
        tupleTypeNode.members.forEach(member -> this.analyzeNode((BLangNode)member, data));
        this.analyzeTypeNode(tupleTypeNode.restParamType, data);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode, AnalyzerData data) {
        unionTypeNode.memberTypeNodes.forEach(memberType -> this.analyzeTypeNode((BLangType)memberType, data));
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode, AnalyzerData data) {
        for (BLangType constituentTypeNode : intersectionTypeNode.constituentTypeNodes) {
            this.analyzeTypeNode(constituentTypeNode, data);
        }
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode, AnalyzerData data) {
        if (functionTypeNode.flagSet.contains((Object)Flag.ANY_FUNCTION)) {
            return;
        }
        functionTypeNode.params.forEach(node -> this.analyzeNode((BLangNode)node, data));
        this.analyzeTypeNode(functionTypeNode.returnTypeNode, data);
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode, AnalyzerData data) {
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression, AnalyzerData data) {
        this.analyzeExpr(bLangVarArgsExpression.expr, data);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression, AnalyzerData data) {
        this.analyzeExpr(bLangNamedArgsExpression.expr, data);
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr, AnalyzerData data) {
        boolean ignoreErrForCheckExpr;
        data.failVisited = true;
        this.analyzeExpr(checkedExpr.expr, data);
        DefaultValueState defaultValueState = data.defaultValueState;
        if (defaultValueState == DefaultValueState.PARAMETER_DEFAULT) {
            this.dlog.error(checkedExpr.pos, DiagnosticErrorCode.INVALID_USAGE_OF_CHECK_IN_PARAMETER_DEFAULT, new Object[0]);
            return;
        }
        if (defaultValueState == DefaultValueState.RECORD_FIELD_DEFAULT) {
            this.dlog.error(checkedExpr.pos, DiagnosticErrorCode.INVALID_USAGE_OF_CHECK_IN_RECORD_FIELD_DEFAULT_EXPRESSION, new Object[0]);
            return;
        }
        if (defaultValueState == DefaultValueState.OBJECT_FIELD_INITIALIZER) {
            BAttachedFunction initializerFunc = ((BObjectTypeSymbol)this.getEnclosingClass((SymbolEnv)data.env).getBType().tsymbol).initializerFunc;
            if (initializerFunc == null) {
                this.dlog.error(checkedExpr.pos, DiagnosticErrorCode.INVALID_USAGE_OF_CHECK_IN_OBJECT_FIELD_INITIALIZER_IN_OBJECT_WITH_NO_INIT_METHOD, new Object[0]);
                return;
            }
            BType exprErrorTypes = this.types.getErrorTypes(checkedExpr.expr.getBType());
            if (exprErrorTypes == this.symTable.semanticError) {
                return;
            }
            BType initMethodReturnType = initializerFunc.type.retType;
            if (!this.types.isAssignable(exprErrorTypes, initMethodReturnType)) {
                this.dlog.error(checkedExpr.pos, DiagnosticErrorCode.INVALID_USAGE_OF_CHECK_IN_OBJECT_FIELD_INITIALIZER_WITH_INIT_METHOD_RETURN_TYPE_MISMATCH, initMethodReturnType, exprErrorTypes);
            }
            return;
        }
        if (data.env.scope.owner.getKind() == SymbolKind.PACKAGE) {
            return;
        }
        BLangInvokableNode enclInvokable = data.env.enclInvokable;
        if (enclInvokable == null) {
            return;
        }
        BType exprType = Types.getImpliedType(enclInvokable.getReturnTypeNode().getBType());
        BType checkedExprType = checkedExpr.expr.getBType();
        SemType errorType = this.types.getErrorIntersection(checkedExprType.semType());
        if (Core.isNever((SemType)errorType)) {
            return;
        }
        boolean bl = ignoreErrForCheckExpr = data.withinQuery && data.queryConstructType == Types.QueryConstructType.STREAM;
        if (!(data.failureHandled || ignoreErrForCheckExpr || this.types.isSubtype(errorType, exprType.semType()) || this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(checkedExprType))) {
            this.dlog.error(checkedExpr.pos, DiagnosticErrorCode.CHECKED_EXPR_NO_MATCHING_ERROR_RETURN_IN_ENCL_INVOKABLE, new Object[0]);
        }
        BType errorTypes = exprType.tag == 21 ? this.types.getErrorType((BUnionType)exprType) : exprType;
        data.returnTypes.peek().add(errorTypes);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanicExpr, AnalyzerData data) {
        this.analyzeExpr(checkPanicExpr.expr, data);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr, AnalyzerData data) {
    }

    @Override
    public void visit(BLangQueryExpr queryExpr, AnalyzerData data) {
        boolean prevQueryToTableWithKey = data.queryToTableWithKey;
        Types.QueryConstructType prevQueryConstructType = data.queryConstructType;
        data.queryConstructType = this.types.getQueryConstructType(queryExpr);
        data.queryToTableWithKey = queryExpr.isTable() && !queryExpr.fieldNameIdentifierList.isEmpty();
        boolean prevWithinQuery = data.withinQuery;
        data.withinQuery = true;
        int fromCount = 0;
        for (BLangNode clause : queryExpr.getQueryClauses()) {
            if (clause.getKind() == NodeKind.FROM) {
                BLangFromClause fromClause = (BLangFromClause)clause;
                BLangExpression collection = (BLangExpression)fromClause.getCollection();
                if (++fromCount > 1 && 15 == Types.getImpliedType((BType)collection.getBType()).tag) {
                    this.dlog.error(collection.pos, DiagnosticErrorCode.NOT_ALLOWED_STREAM_USAGE_WITH_FROM, new Object[0]);
                }
            }
            this.analyzeNode(clause, data);
        }
        data.withinQuery = prevWithinQuery;
        data.queryToTableWithKey = prevQueryToTableWithKey;
        data.queryConstructType = prevQueryConstructType;
    }

    @Override
    public void visit(BLangQueryAction queryAction, AnalyzerData data) {
        boolean prevWithinQuery = data.withinQuery;
        data.withinQuery = true;
        int fromCount = 0;
        for (BLangNode clause : queryAction.getQueryClauses()) {
            if (clause.getKind() == NodeKind.FROM) {
                BLangFromClause fromClause = (BLangFromClause)clause;
                BLangExpression collection = (BLangExpression)fromClause.getCollection();
                if (++fromCount > 1 && 15 == Types.getImpliedType((BType)collection.getBType()).tag) {
                    this.dlog.error(collection.pos, DiagnosticErrorCode.NOT_ALLOWED_STREAM_USAGE_WITH_FROM, new Object[0]);
                }
            }
            this.analyzeNode(clause, data);
        }
        this.validateActionParentNode(queryAction.pos, queryAction);
        data.withinQuery = prevWithinQuery;
    }

    @Override
    public void visit(BLangFromClause fromClause, AnalyzerData data) {
        this.analyzeExpr(fromClause.collection, data);
    }

    @Override
    public void visit(BLangJoinClause joinClause, AnalyzerData data) {
        this.analyzeExpr(joinClause.collection, data);
        if (joinClause.onClause != null) {
            this.analyzeNode((BLangNode)joinClause.onClause, data);
        }
    }

    @Override
    public void visit(BLangLetClause letClause, AnalyzerData data) {
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVariable.definitionNode.getVariable()), data);
        }
    }

    @Override
    public void visit(BLangWhereClause whereClause, AnalyzerData data) {
        this.analyzeExpr(whereClause.expression, data);
    }

    @Override
    public void visit(BLangOnClause onClause, AnalyzerData data) {
        this.analyzeExpr(onClause.lhsExpr, data);
        this.analyzeExpr(onClause.rhsExpr, data);
    }

    @Override
    public void visit(BLangOrderByClause orderByClause, AnalyzerData data) {
        orderByClause.orderByKeyList.forEach(value -> this.analyzeExpr((BLangExpression)value.getOrderKey(), data));
    }

    @Override
    public void visit(BLangGroupByClause node, AnalyzerData data) {
        node.groupingKeyList.forEach(value -> this.analyzeNode((BLangNode)value, data));
    }

    @Override
    public void visit(BLangGroupingKey node, AnalyzerData data) {
        this.analyzeNode((BLangNode)node.getGroupingKey(), data);
    }

    @Override
    public void visit(BLangSelectClause selectClause, AnalyzerData data) {
        this.analyzeExpr(selectClause.expression, data);
    }

    @Override
    public void visit(BLangCollectClause node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause, AnalyzerData data) {
        this.analyzeExpr(onConflictClause.expression, data);
        if (!data.queryToTableWithKey && data.queryConstructType != Types.QueryConstructType.MAP) {
            this.dlog.error(onConflictClause.pos, DiagnosticErrorCode.ON_CONFLICT_ONLY_WORKS_WITH_MAPS_OR_TABLES_WITH_KEY_SPECIFIER, new Object[0]);
        }
    }

    @Override
    public void visit(BLangDoClause doClause, AnalyzerData data) {
        this.analyzeNode((BLangNode)doClause.body, data);
    }

    @Override
    public void visit(BLangOnFailClause onFailClause, AnalyzerData data) {
        BLangNode onFailVarNode;
        boolean currentFailVisited = data.failVisited;
        data.failVisited = false;
        VariableDefinitionNode onFailVarDefNode = onFailClause.variableDefinitionNode;
        if (onFailVarDefNode != null && (onFailVarNode = (BLangNode)((Object)onFailClause.getVariableDefinitionNode().getVariable())) != null) {
            this.analyzeNode(onFailVarNode, data);
        }
        this.analyzeNode((BLangNode)onFailClause.body, data);
        onFailClause.bodyContainsFail = data.failVisited;
        data.failVisited = currentFailVisited;
    }

    private void analyseOnFailClause(boolean onFailExists, BLangOnFailClause onFailClause, AnalyzerData data) {
        if (onFailExists) {
            this.analyzeOnFailClause(onFailClause, data);
        }
    }

    @Override
    public void visit(BLangLimitClause limitClause, AnalyzerData data) {
        this.analyzeExpr(limitClause.expression, data);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr, AnalyzerData data) {
        BLangExpression expr = typeTestExpr.expr;
        this.analyzeNode((BLangNode)expr, data);
        BType exprType = expr.getBType();
        BType typeNodeType = typeTestExpr.typeNode.getBType();
        if (typeNodeType == this.symTable.semanticError || exprType == this.symTable.semanticError) {
            return;
        }
        if (this.types.isAssignable(exprType, typeNodeType)) {
            if (typeTestExpr.isNegation) {
                this.dlog.hint(typeTestExpr.pos, DiagnosticHintCode.EXPRESSION_ALWAYS_FALSE, new Object[0]);
                return;
            }
            if (this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(exprType)) {
                this.dlog.hint(typeTestExpr.pos, DiagnosticHintCode.UNNECESSARY_CONDITION_FOR_VARIABLE_OF_TYPE_NEVER, new Object[0]);
                return;
            }
            this.dlog.hint(typeTestExpr.pos, DiagnosticHintCode.UNNECESSARY_CONDITION, new Object[0]);
            return;
        }
        if (!this.types.intersectionExists(expr.getBType().semType(), typeNodeType.semType())) {
            this.dlog.error(typeTestExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_CHECK, exprType, typeNodeType);
        }
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr, AnalyzerData data) {
        this.analyzeExpr(annotAccessExpr.expr, data);
        BAnnotationSymbol annotationSymbol = annotAccessExpr.annotationSymbol;
        if (annotationSymbol != null && Symbols.isFlagOn(annotationSymbol.flags, 16L)) {
            this.logDeprecatedWaring(annotAccessExpr.annotationName.toString(), annotationSymbol, annotAccessExpr.pos);
        }
    }

    @Override
    public void visit(BLangRegExpTemplateLiteral regExpTemplateLiteral, AnalyzerData data) {
        List<BLangExpression> interpolationsList = this.symResolver.getListOfInterpolations(regExpTemplateLiteral.reDisjunction.sequenceList);
        interpolationsList.forEach(interpolation -> this.analyzeExpr(interpolation, data));
    }

    private void logDeprecatedWaring(String deprecatedConstruct, BSymbol symbol, Location pos) {
        if (!Names.DOT.equals(symbol.pkgID.name)) {
            deprecatedConstruct = String.valueOf(symbol.pkgID) + ":" + (String)deprecatedConstruct;
        }
        this.dlog.warning(pos, DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT, deprecatedConstruct);
    }

    @Override
    public void visit(BLangInferredTypedescDefaultNode inferTypedescExpr, AnalyzerData data) {
    }

    @Override
    public void visit(BLangNaturalExpression naturalExpression, AnalyzerData data) {
        this.checkExperimentalOption(naturalExpression.pos, "natural expression");
        this.analyzeExprs(naturalExpression.arguments, data);
        this.analyzeExprs(naturalExpression.strings, data);
        this.analyzeExprs(naturalExpression.insertions, data);
    }

    private <E extends BLangExpression> void analyzeExpr(E node, AnalyzerData data) {
        if (node == null) {
            return;
        }
        SymbolEnv prevEnv = data.env;
        BLangNode parent = data.parent;
        node.parent = data.parent;
        data.parent = node;
        node.accept(this, (AnalyzerData)data);
        data.parent = parent;
        this.checkAccess(node, data);
        this.checkExpressionValidity(node, data);
        data.env = prevEnv;
    }

    private <E extends BLangExpression> void checkExpressionValidity(E exprNode, AnalyzerData data) {
        if (exprNode.getKind() == NodeKind.GROUP_EXPR || !this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(exprNode.getBType())) {
            return;
        }
        if (!this.checkExpressionInValidParent(exprNode.parent, data)) {
            this.dlog.error(exprNode.pos, DiagnosticErrorCode.EXPRESSION_OF_NEVER_TYPE_NOT_ALLOWED, new Object[0]);
        }
    }

    private boolean checkExpressionInValidParent(BLangNode currentParent, AnalyzerData data) {
        if (currentParent == null) {
            return false;
        }
        if (currentParent.getKind() == NodeKind.GROUP_EXPR) {
            return this.checkExpressionInValidParent(currentParent.parent, data);
        }
        return currentParent.getKind() == NodeKind.EXPRESSION_STATEMENT || currentParent.getKind() == NodeKind.VARIABLE && Types.getImpliedType((BType)((BLangSimpleVariable)data.parent).typeNode.getBType()).tag == 32 || currentParent.getKind() == NodeKind.TRAP_EXPR;
    }

    @Override
    public void visit(BLangConstant constant, AnalyzerData data) {
        this.analyzeTypeNode(constant.typeNode, data);
        this.analyzeNode((BLangNode)constant.expr, data);
        this.analyzeExportableTypeRef(constant.symbol, constant.symbol.type.tsymbol, false, constant.pos);
        constant.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, data));
    }

    private <E extends BLangExpression> void checkAccess(E node, AnalyzerData data) {
        if (node.getBType() != null) {
            this.checkAccessSymbol(Types.getImpliedType((BType)node.getBType()).tsymbol, data.env.enclPkg.symbol.pkgID, node.pos);
        }
        if (node.getKind() == NodeKind.INVOCATION) {
            BLangInvocation bLangInvocation = (BLangInvocation)node;
            this.checkAccessSymbol(bLangInvocation.symbol, data.env.enclPkg.symbol.pkgID, bLangInvocation.pos);
        }
    }

    private void checkAccessSymbol(BSymbol symbol, PackageID pkgID, Location position) {
        if (symbol == null) {
            return;
        }
        if (!pkgID.equals(symbol.pkgID) && !Symbols.isPublic(symbol)) {
            this.dlog.error(position, DiagnosticErrorCode.ATTEMPT_REFER_NON_ACCESSIBLE_SYMBOL, symbol.name);
        }
    }

    private <E extends BLangExpression> void analyzeExprs(List<E> nodeList, AnalyzerData data) {
        for (BLangExpression e : nodeList) {
            this.analyzeExpr(e, data);
        }
    }

    private void initNewWorkerActionSystem(AnalyzerData data) {
        data.workerActionSystemStack.push(new WorkerActionSystem());
    }

    private void finalizeCurrentWorkerActionSystem(AnalyzerData data) {
        WorkerActionSystem was = data.workerActionSystemStack.pop();
        if (!was.hasErrors) {
            this.validateWorkerInteractions(was, data);
        }
    }

    private static boolean isWorkerSend(BLangNode action) {
        return action.getKind() == NodeKind.WORKER_ASYNC_SEND;
    }

    private static boolean isWorkerSyncSend(BLangNode action) {
        return action.getKind() == NodeKind.WORKER_SYNC_SEND;
    }

    private static boolean isWorkerSendOrReceive(BLangNode action) {
        return switch (action.getKind()) {
            case NodeKind.WORKER_RECEIVE, NodeKind.WORKER_ASYNC_SEND, NodeKind.WORKER_SYNC_SEND -> true;
            default -> false;
        };
    }

    private static boolean isWaitAction(BLangNode action) {
        return action.getKind() == NodeKind.WAIT_EXPR;
    }

    private String extractWorkerId(BLangNode action) {
        if (CodeAnalyzer.isWorkerSend(action)) {
            return ((BLangWorkerAsyncSendExpr)action).workerIdentifier.value;
        }
        if (CodeAnalyzer.isWorkerSyncSend(action)) {
            return ((BLangWorkerSyncSendExpr)action).workerIdentifier.value;
        }
        return ((BLangWorkerReceive)action).workerIdentifier.value;
    }

    private void validateWorkerInteractions(WorkerActionSystem workerActionSystem, AnalyzerData data) {
        boolean systemRunning;
        if (!this.validateWorkerInteractionsAfterWaitAction(workerActionSystem)) {
            return;
        }
        data.workerSystemMovementSequence = 0;
        int systemIterationCount = 0;
        int prevWorkerSystemMovementSequence = data.workerSystemMovementSequence;
        do {
            systemRunning = false;
            ++systemIterationCount;
            for (WorkerActionStateMachine worker : workerActionSystem.finshedWorkers) {
                WorkerActionStateMachine otherSM;
                if (worker.done()) continue;
                BLangNode currentAction = worker.currentAction();
                if (CodeAnalyzer.isWaitAction(currentAction)) {
                    this.handleWaitAction(workerActionSystem, currentAction, worker, data);
                    systemRunning = true;
                    continue;
                }
                if (!CodeAnalyzer.isWorkerSend(currentAction) && !CodeAnalyzer.isWorkerSyncSend(currentAction) || (otherSM = workerActionSystem.find(this.extractWorkerId(currentAction))).done()) continue;
                if (CodeAnalyzer.isWaitAction(otherSM.currentAction())) {
                    systemRunning = false;
                    continue;
                }
                if (!otherSM.currentIsReceive(worker.workerId)) continue;
                BLangWorkerReceive receive = (BLangWorkerReceive)otherSM.currentAction();
                BLangWorkerSendExpr send = (BLangWorkerSendExpr)currentAction;
                this.validateWorkerActionParameters(send, receive);
                BLangWorkerSendReceiveExpr.Channel channel = CodeAnalyzer.createChannel(workerActionSystem, worker, otherSM);
                receive.setChannel(channel);
                send.setChannel(channel);
                otherSM.next();
                ++data.workerSystemMovementSequence;
                worker.next();
                ++data.workerSystemMovementSequence;
                systemRunning = true;
                otherSM.node.sendsToThis.add(channel);
                worker.node.sendsToThis.add(channel);
            }
            if (systemIterationCount <= workerActionSystem.finshedWorkers.size()) continue;
            systemIterationCount = 0;
            if (prevWorkerSystemMovementSequence == data.workerSystemMovementSequence) {
                systemRunning = false;
            }
            prevWorkerSystemMovementSequence = data.workerSystemMovementSequence;
        } while (systemRunning);
        if (workerActionSystem.everyoneDone()) {
            for (BLangAlternateWorkerReceive alternateWorkerRv : workerActionSystem.alternateWorkerReceives) {
                this.typeCheckAlternateReceive(alternateWorkerRv);
            }
        } else {
            this.reportInvalidWorkerInteractionDiagnostics(workerActionSystem);
        }
    }

    private void typeCheckAlternateReceive(BLangAlternateWorkerReceive altWorkerRv) {
        LinkedHashSet<BType> altTypes = new LinkedHashSet<BType>();
        boolean noMessagePossible = true;
        for (BLangWorkerReceive workerRv : altWorkerRv.getWorkerReceives()) {
            altTypes.add(workerRv.send.sendTypeWithNoMsgIgnored);
            if (workerRv.send.noMessagePossible) continue;
            noMessagePossible = false;
        }
        if (noMessagePossible) {
            BSymbol noMsgErrSymbol = this.symTable.langErrorModuleSymbol.scope.lookup((Name)Names.fromString((String)NO_MESSAGE_ERROR_TYPE)).symbol;
            altTypes.add(noMsgErrSymbol.getType());
        }
        BType actualType = altTypes.size() > 1 ? BUnionType.create(this.symTable.typeEnv(), null, altTypes) : (BType)altTypes.iterator().next();
        this.types.checkType(altWorkerRv, actualType, altWorkerRv.expectedType);
    }

    private static BLangWorkerSendReceiveExpr.Channel createChannel(WorkerActionSystem workerActionSystem, WorkerActionStateMachine worker, WorkerActionStateMachine otherSM) {
        String workerPairId = BLangWorkerSendReceiveExpr.Channel.workerPairId(worker.workerId, otherSM.workerId);
        Integer eventIndex = workerActionSystem.workerEventIndexMap.getOrDefault(workerPairId, 0);
        eventIndex = eventIndex + 1;
        workerActionSystem.workerEventIndexMap.put(workerPairId, eventIndex);
        return new BLangWorkerSendReceiveExpr.Channel(worker.workerId, otherSM.workerId, eventIndex);
    }

    private boolean validateWorkerInteractionsAfterWaitAction(WorkerActionSystem workerActionSystem) {
        boolean isValid = true;
        for (WorkerActionStateMachine worker : workerActionSystem.finshedWorkers) {
            HashSet<String> waitingOnWorkerSet = new HashSet<String>();
            for (BLangNode action : worker.actions) {
                if (CodeAnalyzer.isWaitAction(action)) {
                    if (action instanceof BLangWaitForAllExpr) {
                        BLangWaitForAllExpr waitForAllExpr = (BLangWaitForAllExpr)action;
                        for (BLangWaitForAllExpr.BLangWaitKeyValue keyValuePair : waitForAllExpr.keyValuePairs) {
                            BSymbol workerSymbol = this.getWorkerSymbol(keyValuePair);
                            if (workerSymbol == null) continue;
                            waitingOnWorkerSet.add(workerSymbol.name.value);
                        }
                        continue;
                    }
                    BLangWaitExpr wait = (BLangWaitExpr)action;
                    for (String workerName : this.getWorkerNameList(wait.exprList.get(0), workerActionSystem.getActionEnvironment(wait))) {
                        waitingOnWorkerSet.add(workerName);
                    }
                    continue;
                }
                if (CodeAnalyzer.isWorkerSend(action)) {
                    BLangWorkerAsyncSendExpr send = (BLangWorkerAsyncSendExpr)action;
                    if (!waitingOnWorkerSet.contains(send.workerIdentifier.value)) continue;
                    this.dlog.error(action.pos, DiagnosticErrorCode.WORKER_INTERACTION_AFTER_WAIT_ACTION, action);
                    isValid = false;
                    continue;
                }
                if (CodeAnalyzer.isWorkerSyncSend(action)) {
                    BLangWorkerSyncSendExpr syncSend = (BLangWorkerSyncSendExpr)action;
                    if (!waitingOnWorkerSet.contains(syncSend.workerIdentifier.value)) continue;
                    this.dlog.error(action.pos, DiagnosticErrorCode.WORKER_INTERACTION_AFTER_WAIT_ACTION, action);
                    isValid = false;
                    continue;
                }
                if (action.getKind() != NodeKind.WORKER_RECEIVE) continue;
                BLangWorkerReceive receive = (BLangWorkerReceive)action;
                if (!waitingOnWorkerSet.contains(receive.workerIdentifier.value)) continue;
                this.dlog.error(action.pos, DiagnosticErrorCode.WORKER_INTERACTION_AFTER_WAIT_ACTION, action);
                isValid = false;
            }
        }
        return isValid;
    }

    private void handleWaitAction(WorkerActionSystem workerActionSystem, BLangNode currentAction, WorkerActionStateMachine worker, AnalyzerData data) {
        block4: {
            block3: {
                if (!(currentAction instanceof BLangWaitForAllExpr)) break block3;
                BLangWaitForAllExpr waitForAllExpr = (BLangWaitForAllExpr)currentAction;
                boolean allWorkersAreDone = true;
                for (BLangWaitForAllExpr.BLangWaitKeyValue keyValuePair : waitForAllExpr.keyValuePairs) {
                    BSymbol workerSymbol = this.getWorkerSymbol(keyValuePair);
                    if (!this.isWorkerSymbol(workerSymbol)) continue;
                    Name workerName = workerSymbol.name;
                    if (!this.isWorkerFromFunction(workerActionSystem.getActionEnvironment(currentAction), workerName)) continue;
                    WorkerActionStateMachine otherSM = workerActionSystem.find(workerName.value);
                    allWorkersAreDone = allWorkersAreDone && otherSM.done();
                }
                if (!allWorkersAreDone) break block4;
                worker.next();
                ++data.workerSystemMovementSequence;
                break block4;
            }
            BLangWaitExpr wait = (BLangWaitExpr)currentAction;
            List<String> workerNameList = this.getWorkerNameList(wait.exprList.get(0), workerActionSystem.getActionEnvironment(currentAction));
            if (workerNameList.isEmpty()) {
                worker.next();
                ++data.workerSystemMovementSequence;
            }
            for (String workerName : workerNameList) {
                WorkerActionStateMachine otherSM = workerActionSystem.find(workerName);
                if (!otherSM.done()) continue;
                worker.next();
                ++data.workerSystemMovementSequence;
                break;
            }
        }
    }

    private BSymbol getWorkerSymbol(BLangWaitForAllExpr.BLangWaitKeyValue keyValuePair) {
        BLangExpression value = keyValuePair.getValue();
        if (value != null && value.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            return ((BLangSimpleVarRef)value).symbol;
        }
        if (keyValuePair.keyExpr != null && keyValuePair.keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            return ((BLangSimpleVarRef)keyValuePair.keyExpr).symbol;
        }
        return null;
    }

    private List<String> getWorkerNameList(BLangExpression expr, SymbolEnv functionEnv) {
        ArrayList<String> workerNames = new ArrayList<String>();
        this.populateWorkerNameList(expr, workerNames, functionEnv);
        return workerNames;
    }

    private void populateWorkerNameList(BLangExpression expr, ArrayList<String> workerNames, SymbolEnv functionEnv) {
        if (expr.getKind() == NodeKind.BINARY_EXPR) {
            BLangBinaryExpr binaryExpr = (BLangBinaryExpr)expr;
            this.populateWorkerNameList(binaryExpr.lhsExpr, workerNames, functionEnv);
            this.populateWorkerNameList(binaryExpr.rhsExpr, workerNames, functionEnv);
        } else if (expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)expr;
            if (this.isWorkerSymbol(varRef.symbol) && this.isWorkerFromFunction(functionEnv, varRef.symbol.name)) {
                workerNames.add(varRef.variableName.value);
            }
        }
    }

    private boolean isWorkerFromFunction(SymbolEnv functionEnv, Name workerName) {
        Set<Flag> flagSet;
        if (functionEnv == null) {
            return false;
        }
        if (functionEnv.scope.lookup((Name)workerName).symbol != null) {
            return true;
        }
        if (functionEnv.enclInvokable != null && (flagSet = functionEnv.enclInvokable.flagSet).contains((Object)Flag.LAMBDA) && !flagSet.contains((Object)Flag.WORKER)) {
            return false;
        }
        return this.isWorkerFromFunction(functionEnv.enclEnv, workerName);
    }

    private boolean isWorkerSymbol(BSymbol symbol) {
        return symbol != null && (symbol.flags & 0x800000L) == 0x800000L;
    }

    private void reportInvalidWorkerInteractionDiagnostics(WorkerActionSystem workerActionSystem) {
        boolean hasSendReceivePairingError = false;
        for (WorkerActionStateMachine worker : workerActionSystem.finshedWorkers) {
            for (BLangNode action : worker.actions) {
                if (!CodeAnalyzer.isWorkerSendOrReceive(action) || ((BLangWorkerSendReceiveExpr)action).getChannel() != null) continue;
                hasSendReceivePairingError = true;
                DiagnosticErrorCode errorCode = action.getKind() == NodeKind.WORKER_RECEIVE ? DiagnosticErrorCode.INVALID_WORKER_RECEIVE_NO_MATCHING_WORKER_SEND : DiagnosticErrorCode.INVALID_WORKER_SEND_NO_MATCHING_WORKER_RECEIVE;
                this.dlog.error(action.pos, errorCode, new Object[0]);
            }
        }
        if (!hasSendReceivePairingError) {
            this.dlog.error(workerActionSystem.getRootPosition(), DiagnosticErrorCode.INVALID_WORKER_INTERACTION, workerActionSystem.toString());
        }
    }

    private void validateWorkerActionParameters(BLangWorkerSendExpr send, BLangWorkerReceive receive) {
        send.receive = receive;
        receive.send = send;
        NodeKind parentKind = receive.parent.getKind();
        if (NodeKind.ALTERNATE_WORKER_RECEIVE != receive.parent.getKind()) {
            this.types.checkType(receive, send.sendType, receive.getBType());
            this.addImplicitCast(send.sendType, receive);
        }
        if (parentKind == NodeKind.TRAP_EXPR || parentKind == NodeKind.CHECK_EXPR || parentKind == NodeKind.CHECK_PANIC_EXPR || parentKind == NodeKind.FAIL) {
            this.typeChecker.checkExpr((BLangExpression)receive.parent, receive.env);
        }
        if (send.getKind() == NodeKind.WORKER_ASYNC_SEND) {
            this.types.checkType(send.pos, this.symTable.nilType, send.expectedType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
            return;
        }
        NodeKind parentNodeKind = send.parent.getKind();
        if (parentNodeKind == NodeKind.VARIABLE) {
            BLangSimpleVariable variable = (BLangSimpleVariable)send.parent;
            if (variable.isDeclaredWithVar) {
                variable.symbol.type = send.expectedType = receive.matchingSendsError;
                variable.setBType(send.expectedType);
            }
        } else if (parentNodeKind == NodeKind.ASSIGNMENT) {
            BSymbol varSymbol;
            BLangAssignment assignment = (BLangAssignment)send.parent;
            if (assignment.varRef.getKind() == NodeKind.SIMPLE_VARIABLE_REF && (varSymbol = ((BLangSimpleVarRef)assignment.varRef).symbol) != null) {
                send.expectedType = varSymbol.type;
            }
        }
        if (receive.matchingSendsError != this.symTable.nilType && parentNodeKind == NodeKind.EXPRESSION_STATEMENT) {
            this.dlog.error(send.pos, DiagnosticErrorCode.ASSIGNMENT_REQUIRED, send.workerSymbol);
        } else {
            this.types.checkType(send.pos, receive.matchingSendsError, send.expectedType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
        }
    }

    private void addImplicitCast(BType actualType, BLangWorkerReceive receive) {
        if (receive.getBType() != null && receive.getBType() != this.symTable.semanticError) {
            this.types.setImplicitCastExpr(receive, actualType, receive.getBType());
            receive.setBType(actualType);
        }
    }

    private boolean checkNextBreakValidityInTransaction(AnalyzerData data) {
        return data.loopWithinTransactionCheckStack.peek() == false && data.transactionCount > 0 && data.withinTransactionScope;
    }

    private boolean checkReturnValidityInTransaction(AnalyzerData data) {
        return data.returnWithinTransactionCheckStack.peek() == false && data.transactionCount > 0 && data.withinTransactionScope;
    }

    private void analyzeInvocationParams(BLangInvocation iExpr, AnalyzerData data) {
        if (iExpr.symbol == null) {
            return;
        }
        BType invocableType = Types.getImpliedType(iExpr.symbol.type);
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)iExpr.symbol;
        List<BVarSymbol> reqParamSymbols = invokableSymbol.params;
        int parameterCountForPositionalArgs = ((BInvokableType)invocableType).getParameterTypes().size();
        int visitedArgCount = 0;
        block4: for (BLangExpression expr : iExpr.argExprs) {
            switch (expr.getKind()) {
                case NAMED_ARGS_EXPR: {
                    this.reportIfDeprecatedUsage(((BLangNamedArgsExpression)expr).varSymbol, expr, expr.pos);
                    ++visitedArgCount;
                    break;
                }
                case REST_ARGS_EXPR: {
                    if (visitedArgCount >= parameterCountForPositionalArgs) {
                        this.reportIfDeprecatedUsage(invokableSymbol.restParam, expr, expr.pos);
                        continue block4;
                    }
                    BLangExpression restExpr = ((BLangRestArgsExpression)expr).expr;
                    if (restExpr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
                        visitedArgCount = this.analyzeRestArgsAgainstReqParams((BLangListConstructorExpr)restExpr, visitedArgCount, reqParamSymbols, invokableSymbol.restParam);
                        continue block4;
                    }
                    for (int i = visitedArgCount; i < parameterCountForPositionalArgs; ++i) {
                        this.reportIfDeprecatedUsage(reqParamSymbols.get(i), expr, expr.pos);
                    }
                    continue block4;
                }
                default: {
                    if (visitedArgCount < parameterCountForPositionalArgs) {
                        BVarSymbol paramSymbol = reqParamSymbols.get(visitedArgCount);
                        this.reportIfDeprecatedUsage(paramSymbol, expr, expr.pos);
                        if (Symbols.isFlagOn(reqParamSymbols.get((int)visitedArgCount).flags, 0x400000000L)) {
                            this.analyzeExpr(expr, data);
                        }
                    } else {
                        this.reportIfDeprecatedUsage(invokableSymbol.restParam, expr, expr.pos);
                    }
                    ++visitedArgCount;
                }
            }
        }
    }

    private int analyzeRestArgsAgainstReqParams(BLangListConstructorExpr listConstructorExpr, int visitedArgCount, List<BVarSymbol> reqParamSymbols, BVarSymbol restParamSymbol) {
        for (BLangExpression expr : listConstructorExpr.exprs) {
            if (visitedArgCount >= reqParamSymbols.size()) {
                this.reportIfDeprecatedUsage(restParamSymbol, expr, expr.pos);
                continue;
            }
            if (expr.getKind() != NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                this.reportIfDeprecatedUsage(reqParamSymbols.get(visitedArgCount++), expr, expr.pos);
                continue;
            }
            BLangExpression innerExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
            if (innerExpr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
                visitedArgCount = this.analyzeRestArgsAgainstReqParams((BLangListConstructorExpr)innerExpr, visitedArgCount, reqParamSymbols, restParamSymbol);
                continue;
            }
            for (int i = visitedArgCount; i < reqParamSymbols.size(); ++i) {
                this.reportIfDeprecatedUsage(reqParamSymbols.get(i), innerExpr, innerExpr.pos);
            }
        }
        return visitedArgCount;
    }

    private void validateModuleInitFunction(BLangFunction funcNode) {
        if (funcNode.attachedFunction || !Names.USER_DEFINED_INIT_SUFFIX.value.equals(funcNode.name.value)) {
            return;
        }
        if (Symbols.isPublic(funcNode.symbol)) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.MODULE_INIT_CANNOT_BE_PUBLIC, new Object[0]);
        }
        if (!funcNode.requiredParams.isEmpty() || funcNode.restParam != null) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.MODULE_INIT_CANNOT_HAVE_PARAMS, new Object[0]);
        }
        this.types.validateErrorOrNilReturn(funcNode, DiagnosticErrorCode.MODULE_INIT_RETURN_SHOULD_BE_ERROR_OR_NIL);
    }

    private boolean reportIfDeprecatedUsage(BSymbol constructSymbol, BLangExpression expr, Location usagePos) {
        if (constructSymbol != null && Symbols.isFlagOn(constructSymbol.flags, 16L)) {
            this.dlog.warning(usagePos, DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT, this.generateDeprecatedConstructString(expr, constructSymbol.name.getValue(), constructSymbol));
            return true;
        }
        return false;
    }

    private BLangNode getEnclosingClass(SymbolEnv env) {
        BLangNode node = env.node;
        while (node.getKind() != NodeKind.CLASS_DEFN) {
            env = env.enclEnv;
            node = env.node;
        }
        return node;
    }

    private void validateInvocationInMatchGuard(BLangInvocation invocation) {
        boolean callsNonIsolatedFunction;
        BLangExpression matchedExpr = this.getMatchedExprIfCalledInMatchGuard(invocation);
        if (matchedExpr == null) {
            return;
        }
        BType matchedExprType = matchedExpr.getBType();
        if (this.types.isInherentlyImmutableType(matchedExprType) || Symbols.isFlagOn(matchedExprType.getFlags(), 32L)) {
            return;
        }
        BSymbol invocationSymbol = invocation.symbol;
        if (invocationSymbol == null) {
            BLangNode parent = invocation.parent;
            if (parent == null || parent.getKind() != NodeKind.TYPE_INIT_EXPR) {
                return;
            }
            BLangTypeInit newExpr = (BLangTypeInit)parent;
            if (Types.getImpliedType((BType)newExpr.getBType()).tag != 15) {
                return;
            }
            List<BLangExpression> argsExpr = newExpr.argsExpr;
            if (argsExpr.isEmpty()) {
                return;
            }
            BLangExpression streamImplementorExpr = argsExpr.get(0);
            BType type = streamImplementorExpr.getBType();
            if (!this.types.isInherentlyImmutableType(type) && !Symbols.isFlagOn(type.getFlags(), 32L)) {
                this.dlog.error(streamImplementorExpr.pos, DiagnosticErrorCode.INVALID_CALL_WITH_MUTABLE_ARGS_IN_MATCH_GUARD, new Object[0]);
            }
            return;
        }
        long flags = invocationSymbol.flags;
        boolean methodCall = Symbols.isFlagOn(flags, 8L);
        boolean bl = callsNonIsolatedFunction = !Symbols.isFlagOn(flags, 0x20000000L) || methodCall && !Symbols.isFlagOn(invocationSymbol.owner.flags, 0x20000000L);
        if (callsNonIsolatedFunction) {
            this.dlog.error(invocation.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_CALL_IN_MATCH_GUARD, new Object[0]);
        }
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>(invocation.requiredArgs);
        args.addAll(invocation.restArgs);
        for (BLangExpression arg : args) {
            BType type = arg.getBType();
            if (type == this.symTable.semanticError || this.types.isInherentlyImmutableType(type) || Symbols.isFlagOn(type.getFlags(), 32L)) continue;
            this.dlog.error(arg.pos, DiagnosticErrorCode.INVALID_CALL_WITH_MUTABLE_ARGS_IN_MATCH_GUARD, new Object[0]);
        }
    }

    private BLangExpression getMatchedExprIfCalledInMatchGuard(BLangInvocation invocation) {
        BLangNode prevParent = invocation;
        BLangNode parent = invocation.parent;
        boolean encounteredMatchGuard = false;
        while (parent != null) {
            NodeKind parentKind = parent.getKind();
            switch (parentKind) {
                case LAMBDA: 
                case FUNCTION: 
                case RESOURCE_FUNC: {
                    return null;
                }
                case MATCH_CLAUSE: {
                    if (encounteredMatchGuard) {
                        return ((BLangMatchStatement)parent.parent).expr;
                    }
                    return null;
                }
                case MATCH_GUARD: {
                    encounteredMatchGuard = true;
                    break;
                }
                case INVOCATION: {
                    BLangInvocation parentInvocation = (BLangInvocation)parent;
                    if (!parentInvocation.langLibInvocation && prevParent == parentInvocation.expr) break;
                    return null;
                }
            }
            prevParent = parent;
            parent = parent.parent;
        }
        return null;
    }

    private void checkExperimentalOption(Location pos, String feature) {
        if (!this.experimentalFeaturesEnabled) {
            this.dlog.error(pos, DiagnosticErrorCode.INVALID_USE_OF_EXPERIMENTAL_FEATURE, feature);
        }
    }

    private void validateCodeAnnotation(BLangFunction function) {
        if (!Symbols.isNative(function.symbol)) {
            return;
        }
        BLangExternalFunctionBody externalFunctionBody = (BLangExternalFunctionBody)function.body;
        for (BLangAnnotationAttachment annotAttachment : externalFunctionBody.annAttachments) {
            BAnnotationSymbol annotSymbol = annotAttachment.annotationSymbol;
            PackageID pkgID = annotSymbol.pkgID;
            Name orgName = pkgID.orgName;
            String pkgName = pkgID.pkgName.value;
            if (!Names.BALLERINA_ORG.equals(orgName) || !NATURAL_LANG_LIB_NAME.equals(pkgName) || !CODE_ANNOTATION.equals(annotSymbol.name.value)) continue;
            this.checkExperimentalOption(annotAttachment.pos, "code generation");
            break;
        }
    }

    private boolean inDefaultValue(DefaultValueState prevDefaultValueState) {
        return prevDefaultValueState == DefaultValueState.RECORD_FIELD_DEFAULT || prevDefaultValueState == DefaultValueState.OBJECT_FIELD_INITIALIZER || prevDefaultValueState == DefaultValueState.PARAMETER_DEFAULT;
    }

    public static class AnalyzerData {
        SymbolEnv env;
        BLangNode parent;
        int loopCount;
        boolean loopAlterNotAllowed;
        boolean inInternallyDefinedBlockStmt;
        int workerSystemMovementSequence;
        Deque<WorkerActionSystem> workerActionSystemStack = new ArrayDeque<WorkerActionSystem>();
        Map<BSymbol, Set<BLangNode>> workerReferences = new HashMap<BSymbol, Set<BLangNode>>();
        int transactionCount;
        boolean withinTransactionScope;
        int commitCount;
        int rollbackCount;
        boolean commitRollbackAllowed;
        int commitCountWithinBlock;
        int rollbackCountWithinBlock;
        Deque<Boolean> loopWithinTransactionCheckStack = new ArrayDeque<Boolean>();
        Deque<Boolean> returnWithinTransactionCheckStack = new ArrayDeque<Boolean>();
        Deque<Boolean> transactionalFuncCheckStack = new ArrayDeque<Boolean>();
        boolean withinLockBlock;
        boolean failureHandled;
        boolean failVisited;
        boolean queryToTableWithKey;
        boolean withinQuery;
        Types.QueryConstructType queryConstructType;
        Deque<LinkedHashSet<BType>> returnTypes = new ArrayDeque<LinkedHashSet<BType>>();
        DefaultValueState defaultValueState = DefaultValueState.NOT_IN_DEFAULT_VALUE;
    }

    private static enum DefaultValueState {
        NOT_IN_DEFAULT_VALUE,
        PARAMETER_DEFAULT,
        RECORD_FIELD_DEFAULT,
        OBJECT_FIELD_INITIALIZER,
        FUNCTION_IN_DEFAULT_VALUE;

    }

    private static class WorkerActionSystem {
        public final List<BLangAlternateWorkerReceive> alternateWorkerReceives = new ArrayList<BLangAlternateWorkerReceive>();
        public List<WorkerActionStateMachine> finshedWorkers = new ArrayList<WorkerActionStateMachine>();
        private final Deque<WorkerActionStateMachine> workerActionStateMachines = new ArrayDeque<WorkerActionStateMachine>();
        private final Map<BLangNode, SymbolEnv> workerInteractionEnvironments = new IdentityHashMap<BLangNode, SymbolEnv>();
        private final Map<String, Integer> workerEventIndexMap = new HashMap<String, Integer>();
        private boolean hasErrors = false;

        private WorkerActionSystem() {
        }

        public void startWorkerActionStateMachine(String workerId, Location pos, BLangFunction node) {
            this.workerActionStateMachines.push(new WorkerActionStateMachine(pos, workerId, node));
        }

        public void endWorkerActionStateMachine() {
            this.finshedWorkers.add(this.workerActionStateMachines.pop());
        }

        public void addWorkerAction(BLangNode action) {
            this.workerActionStateMachines.peek().actions.add(action);
        }

        public WorkerActionStateMachine find(String workerId) {
            for (WorkerActionStateMachine worker : this.finshedWorkers) {
                if (!worker.workerId.equals(workerId)) continue;
                return worker;
            }
            throw new AssertionError((Object)("Reference to non existing worker " + workerId));
        }

        public boolean everyoneDone() {
            return this.finshedWorkers.stream().allMatch(WorkerActionStateMachine::done);
        }

        public Location getRootPosition() {
            return this.finshedWorkers.iterator().next().pos;
        }

        public String toString() {
            return this.finshedWorkers.toString();
        }

        public String currentWorkerId() {
            return this.workerActionStateMachines.peek().workerId;
        }

        public void addWorkerAction(BLangNode action, SymbolEnv env) {
            this.addWorkerAction(action);
            this.workerInteractionEnvironments.put(action, env);
        }

        private SymbolEnv getActionEnvironment(BLangNode currentAction) {
            return this.workerInteractionEnvironments.get(currentAction);
        }
    }

    private static class WorkerActionStateMachine {
        private static final String WORKER_SM_FINISHED = "FINISHED";
        public int currentState;
        public List<BLangNode> actions = new ArrayList<BLangNode>();
        public Location pos;
        public String workerId;
        public BLangFunction node;

        public WorkerActionStateMachine(Location pos, String workerId, BLangFunction node) {
            this.pos = pos;
            this.workerId = workerId;
            this.node = node;
        }

        public boolean done() {
            return this.actions.size() == this.currentState;
        }

        public BLangNode currentAction() {
            return this.actions.get(this.currentState);
        }

        public boolean currentIsReceive(String sourceWorkerId) {
            if (this.done()) {
                return false;
            }
            BLangNode action = this.currentAction();
            return !CodeAnalyzer.isWorkerSend(action) && !CodeAnalyzer.isWorkerSyncSend(action) && !CodeAnalyzer.isWaitAction(action) && ((BLangWorkerReceive)action).workerIdentifier.value.equals(sourceWorkerId);
        }

        public void next() {
            ++this.currentState;
        }

        public String toString() {
            if (this.done()) {
                return WORKER_SM_FINISHED;
            }
            BLangNode action = this.currentAction();
            if (CodeAnalyzer.isWorkerSend(action)) {
                return ((BLangWorkerAsyncSendExpr)action).toActionString();
            }
            if (CodeAnalyzer.isWorkerSyncSend(action)) {
                return ((BLangWorkerSyncSendExpr)action).toActionString();
            }
            if (CodeAnalyzer.isWaitAction(action)) {
                return action.toString();
            }
            return ((BLangWorkerReceive)action).toActionString();
        }
    }
}

