/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.tree.DocReferenceErrorType;
import org.ballerinalang.model.tree.DocumentableNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownReferenceDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.SimpleBLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangCollectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupingKey;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkDownDeprecatedParametersDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkDownDeprecationDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownReturnParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class DocumentationAnalyzer
extends SimpleBLangNodeAnalyzer<AnalyzerData> {
    private static final CompilerContext.Key<DocumentationAnalyzer> DOCUMENTATION_ANALYZER_KEY = new CompilerContext.Key();
    private final BLangDiagnosticLog dlog;
    private final SymbolResolver symResolver;
    private final SymbolTable symTable;
    private final Names names;

    public static DocumentationAnalyzer getInstance(CompilerContext context) {
        DocumentationAnalyzer documentationAnalyzer = context.get(DOCUMENTATION_ANALYZER_KEY);
        if (documentationAnalyzer == null) {
            documentationAnalyzer = new DocumentationAnalyzer(context);
        }
        return documentationAnalyzer;
    }

    private DocumentationAnalyzer(CompilerContext context) {
        context.put(DOCUMENTATION_ANALYZER_KEY, this);
        this.symResolver = SymbolResolver.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.names = Names.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    public BLangPackage analyze(BLangPackage pkgNode) {
        AnalyzerData data = new AnalyzerData();
        this.visitNode(pkgNode, data);
        return pkgNode;
    }

    @Override
    public void analyzeNode(BLangNode node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangPackage pkgNode, AnalyzerData data) {
        this.dlog.setCurrentPackageId(pkgNode.packageID);
        data.env = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        pkgNode.topLevelNodes.forEach(topLevelNode -> this.visitNode((BLangNode)((Object)topLevelNode), data));
        pkgNode.completedPhases.add(CompilerPhase.CODE_ANALYZE);
        pkgNode.getTestablePkgs().forEach(t -> this.visitNode((BLangNode)t, data));
    }

    @Override
    public void visit(BLangConstant constant, AnalyzerData data) {
        this.validateNoParameters(constant);
        this.validateReturnParameter(constant, null, false);
        this.validateReferences(constant, data);
        this.validateDeprecationDocumentation(constant.markdownDocumentationAttachment, Symbols.isFlagOn(constant.symbol.flags, 16L), constant.pos);
        this.validateDeprecatedParametersDocumentation(constant.markdownDocumentationAttachment, constant.pos);
    }

    @Override
    public void visit(BLangSimpleVariable varNode, AnalyzerData data) {
        this.validateNoParameters(varNode);
        this.validateReturnParameter(varNode, null, false);
        this.validateReferences(varNode, data);
        this.validateDeprecationDocumentation(varNode.markdownDocumentationAttachment, false, varNode.pos);
        this.validateDeprecatedParametersDocumentation(varNode.markdownDocumentationAttachment, varNode.pos);
    }

    @Override
    public void visit(BLangTupleVariable tupleVariableNode, AnalyzerData data) {
        this.validateNoParameters(tupleVariableNode);
        this.validateReturnParameter(tupleVariableNode, null, false);
        this.validateReferences(tupleVariableNode, data);
        this.validateDeprecationDocumentation(tupleVariableNode.markdownDocumentationAttachment, false, tupleVariableNode.pos);
        this.validateDeprecatedParametersDocumentation(tupleVariableNode.markdownDocumentationAttachment, tupleVariableNode.pos);
    }

    @Override
    public void visit(BLangResourceFunction funcNode, AnalyzerData data) {
        this.visit((BLangFunction)funcNode, data);
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable, AnalyzerData data) {
        this.validateNoParameters(bLangRecordVariable);
        this.validateReturnParameter(bLangRecordVariable, null, false);
        this.validateReferences(bLangRecordVariable, data);
        this.validateDeprecationDocumentation(bLangRecordVariable.markdownDocumentationAttachment, false, bLangRecordVariable.pos);
        this.validateDeprecatedParametersDocumentation(bLangRecordVariable.markdownDocumentationAttachment, bLangRecordVariable.pos);
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable, AnalyzerData data) {
        this.validateNoParameters(bLangErrorVariable);
        this.validateReturnParameter(bLangErrorVariable, null, false);
        this.validateReferences(bLangErrorVariable, data);
        this.validateDeprecationDocumentation(bLangErrorVariable.markdownDocumentationAttachment, false, bLangErrorVariable.pos);
        this.validateDeprecatedParametersDocumentation(bLangErrorVariable.markdownDocumentationAttachment, bLangErrorVariable.pos);
    }

    @Override
    public void visit(BLangFunction funcNode, AnalyzerData data) {
        this.validateParameters(funcNode, funcNode.getParameters(), funcNode.restParam, DiagnosticWarningCode.UNDOCUMENTED_PARAMETER, DiagnosticWarningCode.NO_SUCH_DOCUMENTABLE_PARAMETER, DiagnosticWarningCode.PARAMETER_ALREADY_DOCUMENTED);
        this.validateDeprecatedParameters(funcNode, funcNode.getParameters(), funcNode.restParam);
        this.validateReferences(funcNode, data);
        boolean hasReturn = true;
        if (funcNode.returnTypeNode.getKind() == NodeKind.VALUE_TYPE) {
            hasReturn = ((BLangValueType)funcNode.returnTypeNode).typeKind != TypeKind.NIL;
        }
        this.validateReturnParameter(funcNode, funcNode, hasReturn);
        this.validateDeprecationDocumentation(funcNode.markdownDocumentationAttachment, Symbols.isFlagOn(funcNode.symbol.flags, 16L), funcNode.pos);
    }

    @Override
    public void visit(BLangService serviceNode, AnalyzerData data) {
        this.validateNoParameters(serviceNode);
        this.validateReturnParameter(serviceNode, null, false);
        this.validateReferences(serviceNode, data);
        this.validateDeprecationDocumentation(serviceNode.markdownDocumentationAttachment, false, serviceNode.pos);
        this.validateDeprecatedParametersDocumentation(serviceNode.markdownDocumentationAttachment, serviceNode.pos);
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition, AnalyzerData data) {
        BLangType typeNode = typeDefinition.getTypeNode();
        NodeKind kind = typeDefinition.typeNode.getKind();
        if (kind == NodeKind.OBJECT_TYPE || kind == NodeKind.RECORD_TYPE) {
            this.validateDocumentationOfObjectOrRecord(typeDefinition, ((BLangStructureTypeNode)typeNode).fields, data);
        }
        if (kind == NodeKind.OBJECT_TYPE) {
            ((BLangObjectTypeNode)typeDefinition.getTypeNode()).getFunctions().forEach(t -> this.visitNode((BLangNode)t, data));
        }
        if (typeDefinition.symbol != null) {
            this.validateDeprecationDocumentation(typeDefinition.markdownDocumentationAttachment, Symbols.isFlagOn(typeDefinition.symbol.flags, 16L), typeDefinition.pos);
        }
        this.validateDeprecatedParametersDocumentation(typeDefinition.markdownDocumentationAttachment, typeDefinition.pos);
    }

    @Override
    public void visit(BLangCollectClause node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangGroupByClause node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangGroupingKey node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangClassDefinition classDefinition, AnalyzerData data) {
        this.validateParameters(classDefinition, classDefinition.fields, null, DiagnosticWarningCode.UNDOCUMENTED_FIELD, DiagnosticWarningCode.NO_SUCH_DOCUMENTABLE_FIELD, DiagnosticWarningCode.FIELD_ALREADY_DOCUMENTED);
        this.validateReturnParameter(classDefinition, null, false);
        this.validateReferences(classDefinition, data);
        for (BLangSimpleVariable field : classDefinition.fields) {
            this.validateReferences(field, data);
            this.validateDeprecationDocumentation(field.getMarkdownDocumentationAttachment(), Symbols.isFlagOn(field.symbol.flags, 16L), field.getPosition());
        }
        classDefinition.functions.forEach(t -> this.visitNode((BLangNode)t, data));
        this.validateDeprecationDocumentation(classDefinition.markdownDocumentationAttachment, Symbols.isFlagOn(classDefinition.symbol.flags, 16L), classDefinition.pos);
        this.validateDeprecatedParametersDocumentation(classDefinition.markdownDocumentationAttachment, classDefinition.pos);
    }

    private void validateDeprecationDocumentation(BLangMarkdownDocumentation documentation, boolean isDeprecationAnnotationAvailable, Location pos) {
        boolean isDeprecationDocumentationAvailable;
        if (documentation == null) {
            return;
        }
        BLangMarkDownDeprecationDocumentation deprecationDocumentation = documentation.getDeprecationDocumentation();
        boolean bl = isDeprecationDocumentationAvailable = deprecationDocumentation != null && deprecationDocumentation.isCorrectDeprecationLine;
        if (isDeprecationDocumentationAvailable && !isDeprecationAnnotationAvailable) {
            this.dlog.warning(deprecationDocumentation.pos, DiagnosticWarningCode.INVALID_DEPRECATION_DOCUMENTATION, new Object[0]);
        } else if (!isDeprecationDocumentationAvailable && isDeprecationAnnotationAvailable) {
            this.dlog.warning(pos, DiagnosticWarningCode.DEPRECATION_DOCUMENTATION_SHOULD_BE_AVAILABLE, new Object[0]);
        }
    }

    public void validateDeprecatedParametersDocumentation(BLangMarkdownDocumentation documentation, Location location) {
        if (documentation == null) {
            return;
        }
        BLangMarkDownDeprecatedParametersDocumentation deprecatedParametersDocumentation = documentation.getDeprecatedParametersDocumentation();
        if (deprecatedParametersDocumentation != null) {
            this.dlog.warning(location, DiagnosticWarningCode.DEPRECATED_PARAMETERS_DOCUMENTATION_NOT_ALLOWED, new Object[0]);
        }
    }

    private void validateReferences(DocumentableNode documentableNode, AnalyzerData data) {
        BLangMarkdownDocumentation documentation = documentableNode.getMarkdownDocumentationAttachment();
        if (documentation == null) {
            return;
        }
        List references = documentation.getReferences();
        for (BLangMarkdownReferenceDocumentation reference : references) {
            DocReferenceErrorType status;
            if (reference.hasParserWarnings || (status = this.validateIdentifier(reference, documentableNode, data)) == DocReferenceErrorType.NO_ERROR) continue;
            if (status == DocReferenceErrorType.REFERENCE_ERROR) {
                this.dlog.warning(reference.pos, DiagnosticWarningCode.INVALID_DOCUMENTATION_REFERENCE, reference.referenceName, reference.getType().getValue());
                continue;
            }
            this.dlog.warning(reference.pos, DiagnosticWarningCode.INVALID_USAGE_OF_PARAMETER_REFERENCE, reference.referenceName);
        }
    }

    private void validateDocumentationOfObjectOrRecord(BLangTypeDefinition typeDefinition, List<BLangSimpleVariable> fields, AnalyzerData data) {
        this.validateParameters(typeDefinition, fields, null, DiagnosticWarningCode.UNDOCUMENTED_FIELD, DiagnosticWarningCode.NO_SUCH_DOCUMENTABLE_FIELD, DiagnosticWarningCode.FIELD_ALREADY_DOCUMENTED);
        this.validateReturnParameter(typeDefinition, null, false);
        this.validateReferences(typeDefinition, data);
        for (BLangSimpleVariable field : fields) {
            this.validateReferences(field, data);
            this.validateDeprecationDocumentation(field.getMarkdownDocumentationAttachment(), Symbols.isFlagOn(field.symbol.flags, 16L), field.getPosition());
        }
    }

    private DocReferenceErrorType validateIdentifier(BLangMarkdownReferenceDocumentation reference, DocumentableNode documentableNode, AnalyzerData data) {
        long tag = -1L;
        SymbolEnv env = data.env;
        switch (reference.getType()) {
            case PARAMETER: {
                if (documentableNode.getKind() == NodeKind.FUNCTION) {
                    BLangFunction funcNode = (BLangFunction)documentableNode;
                    env = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, data.env);
                    tag = 52L;
                    break;
                }
                return DocReferenceErrorType.PARAMETER_REFERENCE_ERROR;
            }
            case SERVICE: {
                tag = 132L;
                break;
            }
            case TYPE: {
                tag = 12L;
                break;
            }
            case VARIABLE: 
            case VAR: {
                tag = 52L;
                break;
            }
            case ANNOTATION: {
                tag = 2L;
                break;
            }
            case MODULE: {
                tag = 1L;
                break;
            }
            case CONST: {
                tag = 0x100001CL;
                break;
            }
            case BACKTICK_CONTENT: 
            case FUNCTION: {
                tag = 820L;
            }
        }
        BSymbol symbol = this.resolveFullyQualifiedSymbol(reference.pos, env, reference.qualifier, reference.typeName, reference.identifier, tag);
        return symbol != this.symTable.notFoundSymbol ? DocReferenceErrorType.NO_ERROR : DocReferenceErrorType.REFERENCE_ERROR;
    }

    private BSymbol resolveFullyQualifiedSymbol(Location location, SymbolEnv env, String packageId, String type, String identifier, long tag) {
        BSymbol typeSymbol;
        Name identifierName = Names.fromString(identifier);
        Name pkgName = Names.fromString(packageId);
        Name typeName = Names.fromString(type);
        SymbolEnv pkgEnv = env;
        if (pkgName != Names.EMPTY) {
            BSymbol pkgSymbol = this.symResolver.resolvePrefixSymbol(env, pkgName, Names.fromString(location.lineRange().fileName()));
            if (pkgSymbol == this.symTable.notFoundSymbol) {
                return this.symTable.notFoundSymbol;
            }
            if (pkgSymbol.tag == 4097L) {
                BPackageSymbol symbol = (BPackageSymbol)pkgSymbol;
                pkgEnv = this.symTable.pkgEnvMap.get(symbol);
            }
        }
        if (typeName == Names.EMPTY) {
            if ((tag & 1L) == 1L) {
                return this.symResolver.lookupPrefixSpaceSymbolInPackage(location, env, pkgName, identifierName);
            }
            if ((tag & 2L) == 2L) {
                return this.symResolver.lookupAnnotationSpaceSymbolInPackage(location, env, pkgName, identifierName);
            }
            if ((tag & 4L) == 4L) {
                return this.symResolver.lookupMainSpaceSymbolInPackage(location, env, pkgName, identifierName);
            }
        }
        if ((typeSymbol = this.symResolver.lookupMainSpaceSymbolInPackage(location, env, pkgName, typeName)) == this.symTable.notFoundSymbol) {
            return this.symTable.notFoundSymbol;
        }
        if (typeSymbol.tag == 98396L) {
            BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)typeSymbol;
            String functionID = String.valueOf(typeName) + "." + String.valueOf(identifierName);
            Name functionName = Names.fromString(functionID);
            return this.symResolver.lookupMemberSymbol(location, objectTypeSymbol.scope, pkgEnv, functionName, tag);
        }
        return this.symTable.notFoundSymbol;
    }

    private void validateParameters(DocumentableNode documentableNode, List<BLangSimpleVariable> actualParameters, BLangSimpleVariable restParam, DiagnosticCode undocumentedParameter, DiagnosticCode noSuchParameter, DiagnosticCode parameterAlreadyDefined) {
        BLangMarkdownDocumentation documentation = documentableNode.getMarkdownDocumentationAttachment();
        if (documentation == null) {
            return;
        }
        List<String> fieldsDocumentedAtFieldLevel = this.getDocumentedFields(actualParameters);
        Map<String, BLangMarkdownParameterDocumentation> documentedParameterMap = this.getDocumentedParameters(documentation.parameters, fieldsDocumentedAtFieldLevel, parameterAlreadyDefined);
        actualParameters.forEach(parameter -> {
            String name = parameter.getName().getValue();
            BLangMarkdownParameterDocumentation param = (BLangMarkdownParameterDocumentation)documentedParameterMap.get(name);
            if (param != null) {
                param.setSymbol(parameter.symbol);
                documentedParameterMap.remove(name);
            } else {
                if (Symbols.isFlagOn(parameter.symbol.flags, 1L) && parameter.markdownDocumentationAttachment == null) {
                    this.dlog.warning(parameter.pos, undocumentedParameter, name);
                }
                if (documentableNode.getKind() == NodeKind.FUNCTION) {
                    this.dlog.warning(parameter.pos, undocumentedParameter, name);
                }
            }
        });
        if (restParam != null) {
            String name2 = restParam.getName().value;
            BLangMarkdownParameterDocumentation param = documentedParameterMap.get(name2);
            if (param != null) {
                param.setSymbol(restParam.symbol);
                documentedParameterMap.remove(name2);
            } else {
                this.dlog.warning(restParam.pos, undocumentedParameter, name2);
            }
        }
        documentedParameterMap.forEach((name, node) -> this.dlog.warning(node.pos, noSuchParameter, name));
    }

    private void validateNoParameters(DocumentableNode documentableNode) {
        BLangMarkdownDocumentation documentation = documentableNode.getMarkdownDocumentationAttachment();
        if (documentation == null) {
            return;
        }
        Map<String, BLangMarkdownParameterDocumentation> parameterDocumentations = documentation.getParameterDocumentations();
        if (parameterDocumentations.isEmpty()) {
            return;
        }
        parameterDocumentations.forEach((parameter, parameterDocumentation) -> this.dlog.warning(parameterDocumentation.pos, DiagnosticWarningCode.NO_SUCH_DOCUMENTABLE_PARAMETER, parameter));
    }

    private void validateReturnParameter(DocumentableNode documentableNode, BLangNode node, boolean isExpected) {
        BLangMarkdownDocumentation documentationAttachment = documentableNode.getMarkdownDocumentationAttachment();
        if (documentationAttachment == null) {
            return;
        }
        BLangMarkdownReturnParameterDocumentation returnParameter = documentationAttachment.getReturnParameter();
        if (returnParameter == null && isExpected) {
            this.dlog.warning(documentationAttachment.pos, DiagnosticWarningCode.UNDOCUMENTED_RETURN_PARAMETER, new Object[0]);
        } else if (returnParameter != null && !isExpected) {
            this.dlog.warning(returnParameter.pos, DiagnosticWarningCode.NO_DOCUMENTABLE_RETURN_PARAMETER, new Object[0]);
        } else if (returnParameter != null) {
            returnParameter.setReturnType(((BLangFunction)node).getReturnTypeNode().getBType());
        }
    }

    private List<String> getDocumentedFields(List<? extends SimpleVariableNode> actualParameters) {
        ArrayList<String> fieldsDocumentedAtFieldLevel = new ArrayList<String>();
        for (SimpleVariableNode simpleVariableNode : actualParameters) {
            if (simpleVariableNode.getMarkdownDocumentationAttachment() == null) continue;
            fieldsDocumentedAtFieldLevel.add(simpleVariableNode.getName().getValue());
        }
        return fieldsDocumentedAtFieldLevel;
    }

    private Map<String, BLangMarkdownParameterDocumentation> getDocumentedParameters(LinkedList<BLangMarkdownParameterDocumentation> deprecatedParameters, List<String> fieldsDocumentedFields, DiagnosticCode parameterAlreadyDefined) {
        HashMap<String, BLangMarkdownParameterDocumentation> documentedDeprecatedParameterMap = new HashMap<String, BLangMarkdownParameterDocumentation>();
        for (BLangMarkdownParameterDocumentation parameter : deprecatedParameters) {
            String parameterName = parameter.getParameterName().getValue();
            if (documentedDeprecatedParameterMap.containsKey(parameterName) || fieldsDocumentedFields.contains(parameterName)) {
                this.dlog.warning(parameter.pos, parameterAlreadyDefined, parameterName);
                continue;
            }
            documentedDeprecatedParameterMap.put(parameterName, parameter);
        }
        return documentedDeprecatedParameterMap;
    }

    private void validateDeprecatedParameters(DocumentableNode documentableNode, List<BLangSimpleVariable> actualParameters, BLangSimpleVariable restParam) {
        BLangMarkdownDocumentation documentation = documentableNode.getMarkdownDocumentationAttachment();
        if (documentation == null) {
            return;
        }
        HashMap<String, BLangMarkdownParameterDocumentation> documentedDeprecatedParameterMap = new HashMap<String, BLangMarkdownParameterDocumentation>();
        if (documentation.deprecatedParametersDocumentation != null) {
            documentedDeprecatedParameterMap = this.getDocumentedParameters(documentation.deprecatedParametersDocumentation.parameters, new ArrayList<String>(), DiagnosticWarningCode.PARAMETER_ALREADY_DOCUMENTED);
        }
        for (BLangSimpleVariable parameter : actualParameters) {
            this.validateDeprecatedParameter(documentedDeprecatedParameterMap, parameter);
        }
        if (restParam != null) {
            this.validateDeprecatedParameter(documentedDeprecatedParameterMap, restParam);
        }
        documentedDeprecatedParameterMap.forEach((name, node) -> this.dlog.warning(node.pos, DiagnosticWarningCode.NO_SUCH_DOCUMENTABLE_PARAMETER, name));
    }

    private void validateDeprecatedParameter(Map<String, BLangMarkdownParameterDocumentation> documentedDeprecatedParameterMap, BLangSimpleVariable parameter) {
        String name = parameter.getName().value;
        if (!documentedDeprecatedParameterMap.containsKey(name)) {
            if (Symbols.isFlagOn(parameter.symbol.flags, 16L)) {
                this.dlog.warning(((BLangAnnotationAttachment)parameter.annAttachments.get((int)0)).pos, DiagnosticWarningCode.DEPRECATION_DOCUMENTATION_SHOULD_BE_AVAILABLE, new Object[0]);
            }
        } else {
            if (!Symbols.isFlagOn(parameter.symbol.flags, 16L)) {
                this.dlog.warning(documentedDeprecatedParameterMap.get((Object)name).pos, DiagnosticWarningCode.INVALID_DEPRECATION_DOCUMENTATION, new Object[0]);
            }
            documentedDeprecatedParameterMap.remove(name);
        }
    }

    public static class AnalyzerData {
        SymbolEnv env;
    }
}

