/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.compiler.api.symbols.DiagnosticState;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OrderedNode;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.TypeDefinition;
import org.ballerinalang.model.tree.types.TypeNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.parser.BLangMissingNodesHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConstantValueResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BEnumSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BServiceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BWorkerSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLAttributeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangResourcePathSegment;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeyTypeConstraint;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkDownDeprecatedParametersDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkDownDeprecationDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.util.Flags;

public class SymbolEnter
extends BLangNodeVisitor {
    private static final CompilerContext.Key<SymbolEnter> SYMBOL_ENTER_KEY = new CompilerContext.Key();
    private final SymbolTable symTable;
    private final Names names;
    private final SymbolResolver symResolver;
    private final BLangDiagnosticLog dlog;
    private final Types types;
    private final SourceDirectory sourceDirectory;
    private final TypeResolver typeResolver;
    private final ConstantValueResolver constResolver;
    private List<BLangNode> unresolvedTypes;
    private Set<BLangNode> unresolvedRecordDueToFields;
    private boolean resolveRecordsUnresolvedDueToFields;
    private final HashSet<LocationData> unknownTypeRefs;
    private final List<PackageID> importedPackages;
    private int typePrecedence;
    private final TypeParamAnalyzer typeParamAnalyzer;
    private final BLangAnonymousModelHelper anonymousModelHelper;
    private final BLangMissingNodesHelper missingNodesHelper;
    private final PackageCache packageCache;
    private final List<BLangNode> intersectionTypes;
    private SymbolEnv env;
    private static final String DEPRECATION_ANNOTATION = "deprecated";
    private static final String ANONYMOUS_RECORD_NAME = "anonymous-record";

    public static SymbolEnter getInstance(CompilerContext context) {
        SymbolEnter symbolEnter = context.get(SYMBOL_ENTER_KEY);
        if (symbolEnter == null) {
            symbolEnter = new SymbolEnter(context);
        }
        return symbolEnter;
    }

    public SymbolEnter(CompilerContext context) {
        context.put(SYMBOL_ENTER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.types = Types.getInstance(context);
        this.typeParamAnalyzer = TypeParamAnalyzer.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.typeResolver = TypeResolver.getInstance(context);
        this.sourceDirectory = context.get(SourceDirectory.class);
        this.importedPackages = new ArrayList<PackageID>();
        this.unknownTypeRefs = new HashSet();
        this.missingNodesHelper = BLangMissingNodesHelper.getInstance(context);
        this.packageCache = PackageCache.getInstance(context);
        this.constResolver = ConstantValueResolver.getInstance(context);
        this.intersectionTypes = new ArrayList<BLangNode>();
    }

    private void cleanup() {
        this.unknownTypeRefs.clear();
    }

    public BLangPackage definePackage(BLangPackage pkgNode) {
        this.dlog.setCurrentPackageId(pkgNode.packageID);
        this.populatePackageNode(pkgNode);
        this.defineNode(pkgNode, this.symTable.pkgEnvMap.get(this.symTable.langAnnotationModuleSymbol));
        return pkgNode;
    }

    public void defineClassDefinition(BLangClassDefinition classNode, SymbolEnv env) {
        if (classNode.definitionCompleted) {
            return;
        }
        this.populateDistinctTypeIdsFromIncludedTypeReferences(classNode);
        this.defineFieldsOfClassDef(classNode, env);
        this.defineReferencedFieldsOfClassDef(classNode, env);
        this.defineFunctionsOfClassDef(env, classNode);
        this.setReadOnlynessOfClassDef(classNode, env);
        this.defineReadOnlyIncludedFieldsAndMethods(classNode, env);
        classNode.definitionCompleted = true;
    }

    public void defineNode(BLangNode node, SymbolEnv env) {
        SymbolEnv prevEnv = this.env;
        this.env = env;
        node.accept(this);
        this.env = prevEnv;
    }

    public BLangPackage defineTestablePackage(BLangTestablePackage pkgNode, SymbolEnv env) {
        this.populatePackageNode(pkgNode);
        this.defineNode(pkgNode, env);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.DEFINE)) {
            return;
        }
        BPackageSymbol pkgSymbol = Symbols.isFlagOn(Flags.asMask(pkgNode.flagSet), 8192L) ? Symbols.createPackageSymbol(pkgNode.packageID, this.symTable, Flags.asMask(pkgNode.flagSet), SymbolOrigin.SOURCE) : Symbols.createPackageSymbol(pkgNode.packageID, this.symTable, SymbolOrigin.SOURCE);
        if (PackageID.isLangLibPackageID(pkgSymbol.pkgID)) {
            this.populateLangLibInSymTable(pkgSymbol);
        }
        if (pkgNode.moduleContextDataHolder != null) {
            pkgSymbol.exported = pkgNode.moduleContextDataHolder.isExported();
            pkgSymbol.descriptor = pkgNode.moduleContextDataHolder.descriptor();
        }
        pkgNode.symbol = pkgSymbol;
        SymbolEnv pkgEnv = SymbolEnv.createPkgEnv(pkgNode, pkgSymbol.scope, this.env);
        this.symTable.pkgEnvMap.put(pkgSymbol, pkgEnv);
        this.symTable.immutableTypeMaps.remove(Types.getPackageIdString(pkgSymbol.pkgID));
        this.importedPackages.add(pkgNode.packageID);
        this.defineConstructs(pkgNode, pkgEnv);
        pkgNode.getTestablePkgs().forEach(testablePackage -> this.defineTestablePackage((BLangTestablePackage)testablePackage, pkgEnv));
        pkgNode.completedPhases.add(CompilerPhase.DEFINE);
        this.cleanup();
        this.importedPackages.remove(pkgNode.packageID);
    }

    private void defineConstructs(BLangPackage pkgNode, SymbolEnv pkgEnv) {
        HashMap importPkgHolder = new HashMap();
        pkgNode.imports.forEach(importNode -> {
            String qualifiedName = importNode.getQualifiedPackageName();
            if (importPkgHolder.containsKey(qualifiedName)) {
                ((ImportResolveHolder)importPkgHolder.get((Object)qualifiedName)).unresolved.add((BLangImportPackage)importNode);
                return;
            }
            this.defineNode((BLangNode)importNode, pkgEnv);
            if (importNode.symbol != null) {
                importPkgHolder.put(qualifiedName, new ImportResolveHolder((BLangImportPackage)importNode));
            }
        });
        for (ImportResolveHolder importHolder : importPkgHolder.values()) {
            BPackageSymbol pkgSymbol = importHolder.resolved.symbol;
            for (BLangImportPackage unresolvedPkg : importHolder.unresolved) {
                BPackageSymbol importSymbol = importHolder.resolved.symbol;
                Name resolvedPkgAlias = this.names.fromIdNode(importHolder.resolved.alias);
                Name unresolvedPkgAlias = this.names.fromIdNode(unresolvedPkg.alias);
                if (!Names.IGNORE.equals(unresolvedPkgAlias) && unresolvedPkgAlias.equals(resolvedPkgAlias) && importSymbol.compUnit.equals(this.names.fromIdNode(unresolvedPkg.compUnit))) {
                    if (this.isSameImport(unresolvedPkg, importSymbol)) {
                        this.dlog.error(unresolvedPkg.pos, DiagnosticErrorCode.REDECLARED_IMPORT_MODULE, unresolvedPkg.getQualifiedPackageName());
                        continue;
                    }
                    this.dlog.error(unresolvedPkg.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, unresolvedPkgAlias);
                    continue;
                }
                unresolvedPkg.symbol = pkgSymbol;
                BPackageSymbol symbol = this.dupPackageSymbolAndSetCompUnit(pkgSymbol, this.names.fromIdNode(unresolvedPkg.compUnit));
                symbol.scope = pkgSymbol.scope;
                unresolvedPkg.symbol = symbol;
                pkgEnv.scope.define(unresolvedPkgAlias, symbol);
            }
        }
        if (!PackageID.ANNOTATIONS.equals(pkgNode.packageID)) {
            this.initPredeclaredModules(this.symTable.predeclaredModules, pkgNode.compUnits, pkgEnv);
        }
        this.typePrecedence = 0;
        ArrayList<BLangNode> moduleDefs = new ArrayList<BLangNode>();
        moduleDefs.addAll(pkgNode.constants);
        moduleDefs.addAll(pkgNode.typeDefinitions);
        moduleDefs.addAll(pkgNode.xmlnsList);
        moduleDefs.addAll(this.getClassDefinitions(pkgNode.topLevelNodes));
        this.env = pkgEnv;
        this.typeResolver.defineBTypes(moduleDefs, pkgEnv);
        pkgEnv.logErrors = true;
        pkgNode.typeDefinitions.sort(this.getTypePrecedenceComparator());
        moduleDefs.sort(this.getTypePrecedenceComparator());
        this.defineErrorDetails(pkgNode.typeDefinitions, pkgEnv);
        this.defineFunctions(moduleDefs, pkgEnv);
        this.validateIntersectionTypeDefinitions(pkgNode.typeDefinitions, pkgNode.packageID);
        this.defineUndefinedReadOnlyTypes(pkgNode.typeDefinitions, moduleDefs, pkgEnv);
        pkgNode.services.forEach(service -> this.defineNode((BLangNode)service, pkgEnv));
        for (BLangFunction bLangFunction : pkgNode.functions) {
            if (bLangFunction.flagSet.contains((Object)Flag.LAMBDA)) continue;
            this.defineNode(bLangFunction, pkgEnv);
        }
        pkgNode.annotations.forEach(annot -> this.defineNode((BLangNode)annot, pkgEnv));
        for (BLangVariable variable : pkgNode.globalVars) {
            BLangExpression expr = variable.expr;
            if (expr != null && expr.getKind() == NodeKind.LAMBDA) {
                this.defineNode(((BLangLambdaFunction)expr).function, pkgEnv);
                if (variable.isDeclaredWithVar) {
                    this.setTypeFromLambdaExpr(variable);
                }
            }
            this.defineNode(variable, pkgEnv);
        }
        for (BLangVariable var : pkgNode.globalVars) {
            BTypeSymbol tSymbol;
            BVarSymbol varSymbol;
            if (var.getKind() != NodeKind.VARIABLE || (varSymbol = var.symbol) == null || (tSymbol = varSymbol.type.tsymbol) == null || !Symbols.isFlagOn(tSymbol.flags, 65536L)) continue;
            varSymbol.tag = 16436L;
        }
        this.typeResolver.clearUnknownTypeRefs();
    }

    public void defineReferencedFieldsOfClassDef(BLangClassDefinition classDefinition, SymbolEnv pkgEnv) {
        SymbolEnv typeDefEnv = classDefinition.typeDefEnv;
        BObjectTypeSymbol tSymbol = (BObjectTypeSymbol)classDefinition.symbol;
        BObjectType objType = (BObjectType)tSymbol.type;
        this.defineReferencedClassFields(classDefinition, typeDefEnv, objType, false);
    }

    private void defineErrorType(Location pos, BErrorType errorType, SymbolEnv env) {
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(env.enclPkg.symbol);
        BTypeSymbol errorTSymbol = errorType.tsymbol;
        errorTSymbol.scope = new Scope(errorTSymbol);
        if (this.symResolver.checkForUniqueSymbol(pos, pkgEnv, errorTSymbol)) {
            pkgEnv.scope.define(errorTSymbol.name, errorTSymbol);
        }
    }

    public boolean isObjectCtor(BLangClassDefinition classDefinition) {
        if (!classDefinition.isObjectContructorDecl && classDefinition.isServiceDecl) {
            return false;
        }
        return classDefinition.flagSet.contains((Object)Flag.OBJECT_CTOR);
    }

    public void defineDistinctClassAndObjectDefinitionIndividual(BLangNode node) {
        if (node.getKind() == NodeKind.CLASS_DEFN) {
            BLangClassDefinition classDefinition = (BLangClassDefinition)node;
            if (this.isObjectCtor(classDefinition)) {
                return;
            }
            this.populateDistinctTypeIdsFromIncludedTypeReferences((BLangClassDefinition)node);
        } else if (node.getKind() == NodeKind.TYPE_DEFINITION) {
            this.populateDistinctTypeIdsFromIncludedTypeReferences((BLangTypeDefinition)node);
        }
    }

    public void populateDistinctTypeIdsFromIncludedTypeReferences(BLangTypeDefinition typeDefinition) {
        block6: {
            block5: {
                if (typeDefinition.typeNode.getKind() != NodeKind.INTERSECTION_TYPE_NODE) break block5;
                if (typeDefinition.typeNode.getBType() == null) {
                    return;
                }
                BType definingType = this.types.getTypeWithEffectiveIntersectionTypes(typeDefinition.typeNode.getBType());
                definingType = Types.getImpliedType(definingType);
                if (definingType.tag != 34) {
                    return;
                }
                BObjectType definigObjType = (BObjectType)definingType;
                BLangIntersectionTypeNode typeNode = (BLangIntersectionTypeNode)typeDefinition.typeNode;
                for (BLangType constituentTypeNode : typeNode.getConstituentTypeNodes()) {
                    BType constituentType = Types.getImpliedType(constituentTypeNode.getBType());
                    if (constituentType.tag != 34) continue;
                    definigObjType.typeIdSet.add(((BObjectType)constituentType).typeIdSet);
                }
                break block6;
            }
            if (typeDefinition.typeNode.getKind() != NodeKind.OBJECT_TYPE) break block6;
            BLangObjectTypeNode objectTypeNode = (BLangObjectTypeNode)typeDefinition.typeNode;
            BTypeIdSet typeIdSet = ((BObjectType)objectTypeNode.getBType()).typeIdSet;
            for (BLangType typeRef : objectTypeNode.typeRefs) {
                BType type = typeRef.getBType();
                if (type == null) {
                    return;
                }
                type = this.types.getTypeWithEffectiveIntersectionTypes(type);
                type = Types.getImpliedType(type);
                if (type.tag != 34) continue;
                BObjectType refType = (BObjectType)type;
                typeIdSet.add(refType.typeIdSet);
            }
        }
    }

    public void populateDistinctTypeIdsFromIncludedTypeReferences(BLangClassDefinition typeDef) {
        BLangClassDefinition classDefinition = typeDef;
        BTypeIdSet typeIdSet = ((BObjectType)classDefinition.getBType()).typeIdSet;
        for (BLangType typeRef : classDefinition.typeRefs) {
            BType type = this.types.getTypeWithEffectiveIntersectionTypes(typeRef.getBType());
            type = Types.getImpliedType(type);
            if (type.tag != 34) continue;
            BObjectType refType = (BObjectType)type;
            typeIdSet.add(refType.typeIdSet);
        }
    }

    private Comparator<BLangNode> getTypePrecedenceComparator() {
        return (l, r) -> {
            if (l instanceof OrderedNode) {
                OrderedNode lNode = (OrderedNode)((Object)l);
                if (r instanceof OrderedNode) {
                    OrderedNode rNode = (OrderedNode)((Object)r);
                    return lNode.getPrecedence() - rNode.getPrecedence();
                }
            }
            return 0;
        };
    }

    private void defineFunctionsOfClassDef(SymbolEnv pkgEnv, BLangClassDefinition classDefinition) {
        this.validateInclusionsForNonPrivateMembers(classDefinition.typeRefs);
        BObjectType objectType = (BObjectType)classDefinition.symbol.type;
        if (objectType.mutableType != null) {
            return;
        }
        SymbolEnv objMethodsEnv = SymbolEnv.createClassMethodsEnv(classDefinition, (BObjectTypeSymbol)classDefinition.symbol, pkgEnv);
        if (classDefinition.isObjectContructorDecl) {
            classDefinition.oceEnvData.objMethodsEnv = objMethodsEnv;
        }
        this.defineClassInitFunction(classDefinition, objMethodsEnv);
        classDefinition.functions.forEach(f -> {
            f.flagSet.add(Flag.FINAL);
            f.setReceiver(ASTBuilderUtil.createReceiver(classDefinition.pos, objectType));
            this.defineNode((BLangNode)f, objMethodsEnv);
        });
        this.defineIncludedMethods(classDefinition, objMethodsEnv, false);
    }

    private void defineIncludedMethods(BLangClassDefinition classDefinition, SymbolEnv objMethodsEnv, boolean defineReadOnlyInclusionsOnly) {
        HashSet<String> includedFunctionNames = new HashSet<String>();
        if (defineReadOnlyInclusionsOnly) {
            for (BAttachedFunction function : ((BObjectTypeSymbol)classDefinition.getBType().tsymbol).referencedFunctions) {
                includedFunctionNames.add(function.funcName.value);
            }
        }
        for (BLangType typeRef : classDefinition.typeRefs) {
            BType type = Types.getReferredType(typeRef.getBType());
            if (type == null || type == this.symTable.semanticError) {
                return;
            }
            if (type.tag == 22) {
                if (!defineReadOnlyInclusionsOnly) continue;
                type = ((BIntersectionType)type).effectiveType;
            } else if (defineReadOnlyInclusionsOnly ? !this.isImmutable((BObjectType)type) : this.isImmutable((BObjectType)type)) continue;
            List functions = ((BObjectTypeSymbol)type.tsymbol).attachedFuncs;
            for (BAttachedFunction function : functions) {
                this.defineReferencedFunction(classDefinition.pos, classDefinition.flagSet, objMethodsEnv, typeRef, function, includedFunctionNames, classDefinition.symbol, classDefinition.functions, classDefinition.internal);
            }
        }
    }

    private void defineReferencedClassFields(BLangClassDefinition classDefinition, SymbolEnv typeDefEnv, BObjectType objType, boolean defineReadOnlyInclusionsOnly) {
        if (classDefinition.typeRefs.isEmpty()) {
            return;
        }
        HashSet<BTypeSymbol> referencedTypes = new HashSet<BTypeSymbol>(classDefinition.typeRefs.size());
        ArrayList<BLangType> invalidTypeRefs = new ArrayList<BLangType>(classDefinition.typeRefs.size());
        HashMap<String, BLangSimpleVariable> fieldNames = new HashMap<String, BLangSimpleVariable>(classDefinition.fields.size());
        for (BLangSimpleVariable fieldVariable : classDefinition.fields) {
            fieldNames.put(fieldVariable.name.value, fieldVariable);
        }
        ArrayList<BLangSimpleVariable> referencedFields = new ArrayList<BLangSimpleVariable>();
        for (BLangType typeRef : classDefinition.typeRefs) {
            BType referredType = Types.getReferredType(this.symResolver.resolveTypeNode(typeRef, typeDefEnv));
            if (referredType == this.symTable.semanticError) continue;
            int tag = Types.getImpliedType((BType)classDefinition.getBType()).tag;
            if (tag == 34) {
                if (this.isInvalidIncludedTypeInClass(referredType)) {
                    if (!defineReadOnlyInclusionsOnly) {
                        this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_REFERENCE, typeRef);
                    }
                    invalidTypeRefs.add(typeRef);
                    continue;
                }
                BObjectType objectType = null;
                if (referredType.tag == 22) {
                    if (!defineReadOnlyInclusionsOnly) {
                        continue;
                    }
                } else {
                    objectType = (BObjectType)referredType;
                    if (defineReadOnlyInclusionsOnly ? !this.isImmutable(objectType) : this.isImmutable(objectType)) {
                        continue;
                    }
                }
            } else if (defineReadOnlyInclusionsOnly) continue;
            if (!referencedTypes.add(referredType.tsymbol)) {
                this.dlog.error(typeRef.pos, DiagnosticErrorCode.REDECLARED_TYPE_REFERENCE, typeRef);
                continue;
            }
            BType effectiveIncludedType = referredType;
            if (tag == 34) {
                BObjectType objectType;
                if (referredType.tag == 22) {
                    objectType = (BObjectType)((BIntersectionType)referredType).effectiveType;
                    effectiveIncludedType = objectType;
                } else {
                    objectType = (BObjectType)referredType;
                }
                if (!classDefinition.symbol.pkgID.equals(referredType.tsymbol.pkgID)) {
                    boolean errored = false;
                    for (BField field : objectType.fields.values()) {
                        if (Symbols.isPublic(field.symbol)) continue;
                        this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_REFERENCE_NON_PUBLIC_MEMBERS, typeRef);
                        invalidTypeRefs.add(typeRef);
                        errored = true;
                        break;
                    }
                    if (errored) continue;
                    for (BAttachedFunction func : ((BObjectTypeSymbol)objectType.tsymbol).attachedFuncs) {
                        if (Symbols.isPublic(func.symbol)) continue;
                        this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_REFERENCE_NON_PUBLIC_MEMBERS, typeRef);
                        invalidTypeRefs.add(typeRef);
                        errored = true;
                        break;
                    }
                    if (errored) continue;
                }
            }
            for (BField field : ((BStructureType)effectiveIncludedType).fields.values()) {
                if (fieldNames.containsKey(field.name.value)) {
                    BLangSimpleVariable existingVariable = (BLangSimpleVariable)fieldNames.get(field.name.value);
                    if (existingVariable.flagSet.contains((Object)Flag.PUBLIC) == Symbols.isFlagOn(field.symbol.flags, 1L) && existingVariable.flagSet.contains((Object)Flag.PRIVATE) == Symbols.isFlagOn(field.symbol.flags, 1024L)) continue;
                    this.dlog.error(existingVariable.pos, DiagnosticErrorCode.MISMATCHED_VISIBILITY_QUALIFIERS_IN_OBJECT_FIELD, existingVariable.name.value);
                    continue;
                }
                BLangSimpleVariable var = ASTBuilderUtil.createVariable(typeRef.pos, field.name.value, field.type);
                var.flagSet = field.symbol.getFlags();
                referencedFields.add(var);
            }
        }
        classDefinition.typeRefs.removeAll(invalidTypeRefs);
        for (BLangSimpleVariable field : referencedFields) {
            this.defineNode(field, typeDefEnv);
            if (field.symbol.type == this.symTable.semanticError) continue;
            objType.fields.put(field.name.value, new BField(this.names.fromIdNode(field.name), field.pos, field.symbol));
        }
        classDefinition.referencedFields.addAll(referencedFields);
    }

    private List<BLangClassDefinition> getClassDefinitions(List<TopLevelNode> topLevelNodes) {
        ArrayList<BLangClassDefinition> classDefinitions = new ArrayList<BLangClassDefinition>();
        for (TopLevelNode topLevelNode : topLevelNodes) {
            if (topLevelNode.getKind() != NodeKind.CLASS_DEFN) continue;
            classDefinitions.add((BLangClassDefinition)topLevelNode);
        }
        return classDefinitions;
    }

    @Override
    public void visit(BLangObjectConstructorExpression objectCtorExpression) {
        this.visit(objectCtorExpression.classNode);
        objectCtorExpression.setBType(objectCtorExpression.classNode.getBType());
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        EnumSet<Flag> flags = EnumSet.copyOf(classDefinition.flagSet);
        boolean isPublicType = flags.contains((Object)Flag.PUBLIC);
        Name className = this.names.fromIdNode(classDefinition.name);
        Name classOrigName = this.names.originalNameFromIdNode(classDefinition.name);
        BClassSymbol tSymbol = Symbols.createClassSymbol(Flags.asMask(flags), className, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, classDefinition.name.pos, this.getOrigin(className, flags), classDefinition.isServiceDecl);
        tSymbol.originalName = classOrigName;
        tSymbol.scope = new Scope(tSymbol);
        tSymbol.markdownDocumentation = this.getMarkdownDocAttachment(classDefinition.markdownDocumentationAttachment);
        long typeFlags = 0L;
        if (flags.contains((Object)Flag.READONLY)) {
            typeFlags |= 0x20L;
        }
        if (flags.contains((Object)Flag.ISOLATED)) {
            typeFlags |= 0x20000000L;
        }
        if (flags.contains((Object)Flag.SERVICE)) {
            typeFlags |= 0x40000L;
        }
        if (flags.contains((Object)Flag.OBJECT_CTOR)) {
            typeFlags |= 0x100000000L;
        }
        BObjectType objectType = new BObjectType(this.symTable.typeEnv(), (BTypeSymbol)tSymbol, typeFlags);
        if (classDefinition.isObjectContructorDecl || flags.contains((Object)Flag.OBJECT_CTOR)) {
            classDefinition.oceEnvData.objectType = objectType;
            objectType.classDef = classDefinition;
        }
        if (flags.contains((Object)Flag.DISTINCT)) {
            objectType.typeIdSet = BTypeIdSet.from(this.env.enclPkg.symbol.pkgID, classDefinition.name.value, isPublicType);
        }
        if (flags.contains((Object)Flag.CLIENT)) {
            objectType.addFlags(65536L);
        }
        tSymbol.type = objectType;
        classDefinition.setBType(objectType);
        classDefinition.setDeterminedType(objectType);
        classDefinition.symbol = tSymbol;
        if (this.isDeprecated(classDefinition.annAttachments)) {
            tSymbol.flags |= 0x10L;
        }
        for (BLangType typeRef : classDefinition.typeRefs) {
            BType referencedType = this.symResolver.resolveTypeNode(typeRef, this.env);
            if (referencedType == this.symTable.noType && !this.unresolvedTypes.contains(classDefinition)) {
                this.unresolvedTypes.add(classDefinition);
                return;
            }
            objectType.typeInclusions.add(referencedType);
        }
        classDefinition.setPrecedence(this.typePrecedence++);
        if (this.symResolver.checkForUniqueSymbol(classDefinition.pos, this.env, tSymbol)) {
            this.env.scope.define(tSymbol.name, tSymbol);
        }
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        Name annotName = this.names.fromIdNode(annotationNode.name);
        Name annotOrigName = this.names.originalNameFromIdNode(annotationNode.name);
        BAnnotationSymbol annotationSymbol = Symbols.createAnnotationSymbol(Flags.asMask(annotationNode.flagSet), annotationNode.getAttachPoints(), annotName, annotOrigName, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, annotationNode.name.pos, this.getOrigin(annotName));
        annotationSymbol.markdownDocumentation = this.getMarkdownDocAttachment(annotationNode.markdownDocumentationAttachment);
        if (this.isDeprecated(annotationNode.annAttachments)) {
            annotationSymbol.flags |= 0x10L;
        }
        annotationSymbol.type = new BAnnotationType(annotationSymbol);
        annotationNode.symbol = annotationSymbol;
        this.defineSymbol(annotationNode.name.pos, annotationSymbol);
        SymbolEnv annotationEnv = SymbolEnv.createAnnotationEnv(annotationNode, annotationSymbol.scope, this.env);
        BLangType annotTypeNode = annotationNode.typeNode;
        if (annotTypeNode != null) {
            BType type;
            annotationSymbol.attachedType = type = this.symResolver.resolveTypeNode(annotTypeNode, annotationEnv);
            if (!this.isValidAnnotationType(type)) {
                this.dlog.error(annotTypeNode.pos, DiagnosticErrorCode.ANNOTATION_INVALID_TYPE, type);
            }
        }
        if (!annotationNode.flagSet.contains((Object)Flag.CONSTANT) && annotationNode.getAttachPoints().stream().anyMatch(attachPoint -> attachPoint.source)) {
            this.dlog.error(annotationNode.pos, DiagnosticErrorCode.ANNOTATION_REQUIRES_CONST, new Object[0]);
        }
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        PackageID pkgId;
        BPackageSymbol bPackageSymbol;
        Name version;
        Name orgName;
        BSymbol importSymbol;
        Name pkgAlias = this.names.fromIdNode(importPkgNode.alias);
        if (!Names.IGNORE.equals(pkgAlias) && (importSymbol = this.symResolver.resolvePrefixSymbol(this.env, pkgAlias, this.names.fromIdNode(importPkgNode.compUnit))) != this.symTable.notFoundSymbol) {
            if (this.isSameImport(importPkgNode, (BPackageSymbol)importSymbol)) {
                this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.REDECLARED_IMPORT_MODULE, importPkgNode.getQualifiedPackageName());
            } else {
                this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, pkgAlias);
            }
            return;
        }
        Name pkgName = null;
        PackageID enclPackageID = this.env.enclPkg.packageID;
        if (!this.isNullOrEmpty(importPkgNode.orgName.value)) {
            orgName = this.names.fromIdNode(importPkgNode.orgName);
            version = !this.isNullOrEmpty(importPkgNode.version.value) ? this.names.fromIdNode(importPkgNode.version) : Names.EMPTY;
        } else {
            orgName = enclPackageID.orgName;
            pkgName = enclPackageID.pkgName;
            version = Names.DEFAULT_VERSION.equals(enclPackageID.version) ? Names.EMPTY : enclPackageID.version;
        }
        List<Name> nameComps = importPkgNode.pkgNameComps.stream().map(identifier -> this.names.fromIdNode((BLangIdentifier)identifier)).toList();
        Name moduleName = new Name(nameComps.stream().map(Name::getValue).collect(Collectors.joining(".")));
        if (pkgName == null) {
            pkgName = moduleName;
        }
        if ((bPackageSymbol = this.packageCache.getSymbol(pkgId = new PackageID(orgName, pkgName, moduleName, version, null))) != null && this.env.enclPkg.moduleContextDataHolder != null) {
            boolean isCurrentPackageModuleImport;
            boolean bl = isCurrentPackageModuleImport = this.env.enclPkg.moduleContextDataHolder.descriptor().org() == bPackageSymbol.descriptor.org() && this.env.enclPkg.moduleContextDataHolder.descriptor().packageName() == bPackageSymbol.descriptor.packageName();
            if (!isCurrentPackageModuleImport && !bPackageSymbol.exported) {
                this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.MODULE_NOT_FOUND, bPackageSymbol.toString() + " is not exported");
                return;
            }
        }
        if (!(!pkgId.equals(PackageID.ANNOTATIONS) && !pkgId.equals(PackageID.INTERNAL) && !pkgId.equals(PackageID.QUERY) || enclPackageID.orgName.equals(Names.BALLERINA_ORG) && enclPackageID.name.value.startsWith(Names.LANG.value))) {
            this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.MODULE_NOT_FOUND, importPkgNode.getQualifiedPackageName());
            return;
        }
        if (this.importedPackages.contains(pkgId)) {
            int index = this.importedPackages.indexOf(pkgId);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = index; i < this.importedPackages.size(); ++i) {
                stringBuilder.append(this.importedPackages.get(i).toString()).append(" -> ");
            }
            stringBuilder.append(pkgId);
            this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.CYCLIC_MODULE_IMPORTS_DETECTED, stringBuilder.toString());
            return;
        }
        boolean samePkg = false;
        PackageID entryPackage = this.importedPackages.get(0);
        if (entryPackage.isUnnamed == pkgId.isUnnamed) {
            boolean bl = samePkg = !entryPackage.isUnnamed || entryPackage.sourceFileName.equals(pkgId.sourceFileName);
        }
        if (samePkg && entryPackage.orgName.equals(pkgId.orgName) && entryPackage.name.equals(pkgId.name)) {
            StringBuilder stringBuilder = new StringBuilder();
            String entryPackageString = this.importedPackages.get(0).toString();
            int packageIndex = entryPackageString.indexOf(":");
            if (packageIndex != -1) {
                entryPackageString = entryPackageString.substring(0, packageIndex);
            }
            stringBuilder.append(entryPackageString).append(" -> ");
            for (int i = 1; i < this.importedPackages.size(); ++i) {
                stringBuilder.append(this.importedPackages.get(i).toString()).append(" -> ");
            }
            stringBuilder.append(pkgId);
            this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.CYCLIC_MODULE_IMPORTS_DETECTED, stringBuilder.toString());
            return;
        }
        BPackageSymbol pkgSymbol = this.packageCache.getSymbol(pkgId);
        if (pkgSymbol == null) {
            this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.MODULE_NOT_FOUND, importPkgNode.getQualifiedPackageName());
            return;
        }
        Set<BPackageSymbol> imports = ((BPackageSymbol)this.env.scope.owner).imports;
        imports.add(pkgSymbol);
        BPackageSymbol symbol = this.dupPackageSymbolAndSetCompUnit(pkgSymbol, this.names.fromIdNode(importPkgNode.compUnit));
        if (!Names.IGNORE.equals(pkgAlias)) {
            symbol.importPrefix = pkgAlias;
        }
        symbol.scope = pkgSymbol.scope;
        importPkgNode.symbol = symbol;
        this.env.scope.define(pkgAlias, symbol);
    }

    public void initPredeclaredModules(Map<Name, BPackageSymbol> predeclaredModules, List<BLangCompilationUnit> compUnits, SymbolEnv env) {
        this.env = env;
        for (Map.Entry<Name, BPackageSymbol> predeclaredModuleEntry : predeclaredModules.entrySet()) {
            Name alias = predeclaredModuleEntry.getKey();
            BPackageSymbol packageSymbol = predeclaredModuleEntry.getValue();
            int index = 0;
            Scope.ScopeEntry entry = this.env.scope.lookup(alias);
            if (entry == Scope.NOT_FOUND_ENTRY && !compUnits.isEmpty()) {
                this.env.scope.define(alias, this.dupPackageSymbolAndSetCompUnit(packageSymbol, new Name(compUnits.get((int)index++).name)));
                entry = this.env.scope.lookup(alias);
            }
            for (int i = index; i < compUnits.size(); ++i) {
                boolean isUndefinedModule = true;
                String compUnitName = compUnits.get((int)i).name;
                if (((BPackageSymbol)entry.symbol).compUnit.value.equals(compUnitName)) {
                    isUndefinedModule = false;
                }
                while (entry.next != Scope.NOT_FOUND_ENTRY) {
                    if (((BPackageSymbol)entry.next.symbol).compUnit.value.equals(compUnitName)) {
                        isUndefinedModule = false;
                        break;
                    }
                    entry = entry.next;
                }
                if (!isUndefinedModule) continue;
                entry.next = new Scope.ScopeEntry(this.dupPackageSymbolAndSetCompUnit(packageSymbol, new Name(compUnitName)), Scope.NOT_FOUND_ENTRY);
            }
        }
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        this.defineXMLNS(this.env, xmlnsNode);
    }

    public void defineXMLNS(SymbolEnv symEnv, BLangXMLNS xmlnsNode) {
        String nsURI = "";
        if (xmlnsNode.namespaceURI.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangConstantValue constantValue;
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)xmlnsNode.namespaceURI;
            if (Symbols.isFlagOn(varRef.symbol.flags, 16384L) && (constantValue = ((BConstantSymbol)varRef.symbol).value) != null) {
                nsURI = constantValue.toString();
                this.checkInvalidNameSpaceDeclaration(xmlnsNode.pos, xmlnsNode.prefix, nsURI);
            }
        } else {
            nsURI = (String)((BLangLiteral)xmlnsNode.namespaceURI).value;
            this.checkInvalidNameSpaceDeclaration(xmlnsNode.pos, xmlnsNode.prefix, nsURI);
        }
        if (xmlnsNode.prefix.value == null) {
            xmlnsNode.prefix.value = "";
        }
        Name prefix = this.names.fromIdNode(xmlnsNode.prefix);
        Location nsSymbolPos = prefix.value.isEmpty() ? xmlnsNode.pos : xmlnsNode.prefix.pos;
        BLangIdentifier compUnit = xmlnsNode.compUnit;
        BXMLNSSymbol xmlnsSymbol = Symbols.createXMLNSSymbol(prefix, nsURI, symEnv.enclPkg.symbol.pkgID, symEnv.scope.owner, nsSymbolPos, this.getOrigin(prefix), compUnit != null ? this.names.fromIdNode(compUnit) : null);
        xmlnsNode.symbol = xmlnsSymbol;
        BSymbol foundSym = this.symResolver.lookupSymbolInPrefixSpace(symEnv, xmlnsSymbol.name);
        if ((foundSym.tag & 0x1001L) != 4097L) {
            foundSym = this.symTable.notFoundSymbol;
        }
        if (foundSym != this.symTable.notFoundSymbol) {
            this.dlog.error(xmlnsNode.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, xmlnsSymbol.name);
            return;
        }
        this.defineSymbol(xmlnsNode.prefix.pos, xmlnsSymbol);
    }

    private void checkInvalidNameSpaceDeclaration(Location pos, BLangIdentifier prefix, String nsURI) {
        if (!this.nullOrEmpty(prefix.value) && nsURI.isEmpty()) {
            this.dlog.error(pos, DiagnosticErrorCode.INVALID_NAMESPACE_DECLARATION, prefix);
        }
    }

    private boolean nullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.defineNode(xmlnsStmtNode.xmlnsDecl, this.env);
    }

    private void populateUndefinedErrorIntersection(BLangTypeDefinition typeDef, SymbolEnv env) {
        long flags = 0L;
        if (typeDef.flagSet.contains((Object)Flag.PUBLIC)) {
            flags = 1L;
        }
        BErrorType intersectionErrorType = this.types.createErrorType(null, flags, env);
        intersectionErrorType.tsymbol.name = Names.fromString(typeDef.name.value);
        this.defineErrorType(typeDef.pos, intersectionErrorType, env);
        this.intersectionTypes.add(typeDef);
    }

    boolean isErrorIntersectionTypeCreatingNewType(BLangNode typeDef, SymbolEnv env) {
        boolean isIntersectionType;
        boolean bl = isIntersectionType = typeDef.getKind() == NodeKind.TYPE_DEFINITION && ((BLangTypeDefinition)typeDef).typeNode.getKind() == NodeKind.INTERSECTION_TYPE_NODE;
        if (!isIntersectionType) {
            return false;
        }
        BLangIntersectionTypeNode intersectionTypeNode = (BLangIntersectionTypeNode)((BLangTypeDefinition)typeDef).typeNode;
        int errorTypeCount = 0;
        for (BLangType type : intersectionTypeNode.constituentTypeNodes) {
            BType bType = this.symResolver.resolveTypeNode(type, env);
            if (Types.getImpliedType((BType)bType).tag != 29) continue;
            ++errorTypeCount;
        }
        return errorTypeCount > 1;
    }

    private void checkErrors(SymbolEnv env, BLangNode unresolvedType, BLangNode currentTypeOrClassNode, Deque<String> visitedNodes, boolean fromStructuredType) {
        switch (currentTypeOrClassNode.getKind()) {
            case ARRAY_TYPE: {
                this.checkErrors(env, unresolvedType, ((BLangArrayType)currentTypeOrClassNode).elemtype, visitedNodes, true);
                break;
            }
            case UNION_TYPE_NODE: {
                List<BLangType> memberTypeNodes = ((BLangUnionTypeNode)currentTypeOrClassNode).memberTypeNodes;
                for (BLangType memberTypeNode : memberTypeNodes) {
                    this.checkErrors(env, unresolvedType, memberTypeNode, visitedNodes, fromStructuredType);
                }
                break;
            }
            case INTERSECTION_TYPE_NODE: {
                List<BLangType> memberTypeNodes = ((BLangIntersectionTypeNode)currentTypeOrClassNode).constituentTypeNodes;
                for (BLangType memberTypeNode : memberTypeNodes) {
                    this.checkErrors(env, unresolvedType, memberTypeNode, visitedNodes, fromStructuredType);
                }
                break;
            }
            case TUPLE_TYPE_NODE: {
                BLangTupleTypeNode tupleNode = (BLangTupleTypeNode)currentTypeOrClassNode;
                List<BLangType> tupleMemberTypes = tupleNode.getMemberTypeNodes();
                for (BLangType memberTypeNode : tupleMemberTypes) {
                    this.checkErrors(env, unresolvedType, memberTypeNode, visitedNodes, true);
                }
                if (tupleNode.restParamType == null) break;
                this.checkErrors(env, unresolvedType, tupleNode.restParamType, visitedNodes, true);
                break;
            }
            case CONSTRAINED_TYPE: {
                this.checkErrors(env, unresolvedType, ((BLangConstrainedType)currentTypeOrClassNode).constraint, visitedNodes, true);
                break;
            }
            case TABLE_TYPE: {
                this.checkErrors(env, unresolvedType, ((BLangTableTypeNode)currentTypeOrClassNode).constraint, visitedNodes, true);
                break;
            }
            case STREAM_TYPE: {
                this.checkErrors(env, unresolvedType, ((BLangStreamType)currentTypeOrClassNode).constraint, visitedNodes, true);
                BLangType completionType = ((BLangStreamType)currentTypeOrClassNode).error;
                if (completionType == null) break;
                this.checkErrors(env, unresolvedType, completionType, visitedNodes, true);
                break;
            }
            case USER_DEFINED_TYPE: {
                this.checkErrorsOfUserDefinedType(env, unresolvedType, (BLangUserDefinedType)currentTypeOrClassNode, visitedNodes, fromStructuredType);
                break;
            }
            case BUILT_IN_REF_TYPE: 
            case FINITE_TYPE_NODE: 
            case VALUE_TYPE: 
            case ERROR_TYPE: {
                break;
            }
            case FUNCTION_TYPE: {
                BLangFunctionTypeNode functionTypeNode = (BLangFunctionTypeNode)currentTypeOrClassNode;
                functionTypeNode.params.forEach(p -> this.checkErrors(env, unresolvedType, p.typeNode, visitedNodes, fromStructuredType));
                if (functionTypeNode.restParam != null) {
                    this.checkErrors(env, unresolvedType, functionTypeNode.restParam.typeNode, visitedNodes, fromStructuredType);
                }
                if (functionTypeNode.returnTypeNode == null) break;
                this.checkErrors(env, unresolvedType, functionTypeNode.returnTypeNode, visitedNodes, fromStructuredType);
                break;
            }
            case RECORD_TYPE: {
                for (TypeNode typeNode : ((BLangRecordTypeNode)currentTypeOrClassNode).getTypeReferences()) {
                    this.checkErrors(env, unresolvedType, (BLangType)typeNode, visitedNodes, true);
                }
                break;
            }
            case OBJECT_TYPE: {
                for (TypeNode typeNode : ((BLangObjectTypeNode)currentTypeOrClassNode).getTypeReferences()) {
                    this.checkErrors(env, unresolvedType, (BLangType)typeNode, visitedNodes, true);
                }
                break;
            }
            case CLASS_DEFN: {
                for (TypeNode typeNode : ((BLangClassDefinition)currentTypeOrClassNode).typeRefs) {
                    this.checkErrors(env, unresolvedType, (BLangType)typeNode, visitedNodes, true);
                }
                break;
            }
            default: {
                throw new RuntimeException("unhandled type kind: " + String.valueOf((Object)currentTypeOrClassNode.getKind()));
            }
        }
    }

    private boolean isTypeConstructorAvailable(NodeKind unresolvedType) {
        return switch (unresolvedType) {
            case NodeKind.ARRAY_TYPE, NodeKind.TUPLE_TYPE_NODE, NodeKind.CONSTRAINED_TYPE, NodeKind.TABLE_TYPE, NodeKind.STREAM_TYPE, NodeKind.ERROR_TYPE, NodeKind.FUNCTION_TYPE, NodeKind.RECORD_TYPE, NodeKind.OBJECT_TYPE -> true;
            default -> false;
        };
    }

    private void checkErrorsOfUserDefinedType(SymbolEnv env, BLangNode unresolvedType, BLangUserDefinedType currentTypeOrClassNode, Deque<String> visitedNodes, boolean fromStructuredType) {
        boolean typeDef;
        String currentTypeNodeName = currentTypeOrClassNode.typeName.value;
        if (currentTypeNodeName.startsWith("$")) {
            return;
        }
        String unresolvedTypeNodeName = SymbolEnter.getTypeOrClassName(unresolvedType);
        boolean sameTypeNode = unresolvedTypeNodeName.equals(currentTypeNodeName);
        boolean isVisited = visitedNodes.contains(currentTypeNodeName);
        boolean bl = typeDef = unresolvedType.getKind() == NodeKind.TYPE_DEFINITION;
        if (sameTypeNode || isVisited) {
            if (typeDef) {
                BLangTypeDefinition typeDefinition = (BLangTypeDefinition)unresolvedType;
                NodeKind unresolvedTypeNodeKind = typeDefinition.getTypeNode().getKind();
                if (fromStructuredType && (unresolvedTypeNodeKind == NodeKind.UNION_TYPE_NODE || unresolvedTypeNodeKind == NodeKind.TUPLE_TYPE_NODE)) {
                    typeDefinition.hasCyclicReference = true;
                    return;
                }
                if (unresolvedTypeNodeKind != NodeKind.OBJECT_TYPE && this.isTypeConstructorAvailable(unresolvedTypeNodeKind) && !sameTypeNode) {
                    return;
                }
            }
            if (isVisited) {
                ArrayList<String> dependencyList = new ArrayList<String>();
                for (String node2 : visitedNodes) {
                    dependencyList.add(0, node2);
                    if (!node2.equals(currentTypeNodeName)) continue;
                    break;
                }
                if (!sameTypeNode && dependencyList.size() == 1 && ((String)dependencyList.get(0)).equals(currentTypeNodeName)) {
                    return;
                }
                dependencyList.add(currentTypeNodeName);
                this.dlog.error(unresolvedType.getPosition(), DiagnosticErrorCode.CYCLIC_TYPE_REFERENCE, dependencyList);
            } else {
                visitedNodes.push(currentTypeNodeName);
                this.dlog.error(unresolvedType.getPosition(), DiagnosticErrorCode.CYCLIC_TYPE_REFERENCE, visitedNodes);
                visitedNodes.remove(currentTypeNodeName);
            }
        } else {
            List<BLangNode> typeDefinitions = this.unresolvedTypes.stream().filter(node -> SymbolEnter.getTypeOrClassName(node).equals(currentTypeNodeName)).toList();
            if (typeDefinitions.isEmpty()) {
                BType referredType = this.symResolver.resolveTypeNode(currentTypeOrClassNode, env);
                if (referredType != this.symTable.noType) {
                    return;
                }
                LocationData locationData = new LocationData(currentTypeNodeName, currentTypeOrClassNode.pos.lineRange().startLine().line(), currentTypeOrClassNode.pos.lineRange().startLine().offset());
                if (this.unknownTypeRefs.add(locationData)) {
                    this.dlog.error(currentTypeOrClassNode.pos, DiagnosticErrorCode.UNKNOWN_TYPE, currentTypeNodeName);
                }
            } else {
                for (BLangNode typeDefinition : typeDefinitions) {
                    if (typeDefinition.getKind() == NodeKind.TYPE_DEFINITION) {
                        BLangTypeDefinition langTypeDefinition = (BLangTypeDefinition)typeDefinition;
                        String typeName = langTypeDefinition.getName().getValue();
                        visitedNodes.push(typeName);
                        this.checkErrors(env, unresolvedType, langTypeDefinition.getTypeNode(), visitedNodes, fromStructuredType);
                        visitedNodes.pop();
                        continue;
                    }
                    BLangClassDefinition classDefinition = (BLangClassDefinition)typeDefinition;
                    visitedNodes.push(classDefinition.getName().getValue());
                    this.checkErrors(env, unresolvedType, classDefinition, visitedNodes, fromStructuredType);
                    visitedNodes.pop();
                }
            }
        }
    }

    public static String getTypeOrClassName(BLangNode node) {
        if (node.getKind() == NodeKind.TYPE_DEFINITION || node.getKind() == NodeKind.CONSTANT) {
            return ((TypeDefinition)((Object)node)).getName().getValue();
        }
        return ((BLangClassDefinition)node).getName().getValue();
    }

    public boolean isUnknownTypeRef(BLangUserDefinedType bLangUserDefinedType) {
        LinePosition startLine = bLangUserDefinedType.pos.lineRange().startLine();
        LocationData locationData = new LocationData(bLangUserDefinedType.typeName.value, startLine.line(), startLine.offset());
        return this.unknownTypeRefs.contains(locationData);
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        boolean isErrorIntersection;
        BLangStructureTypeNode structureTypeNode;
        BType definedType = typeDefinition.hasCyclicReference ? this.getCyclicDefinedType(typeDefinition, this.env) : this.symResolver.resolveTypeNode(typeDefinition.typeNode, this.env);
        if (definedType == this.symTable.semanticError) {
            this.invalidateAlreadyDefinedErrorType(typeDefinition);
            return;
        }
        if (definedType == this.symTable.noType) {
            if (!this.unresolvedTypes.contains(typeDefinition)) {
                this.unresolvedTypes.add(typeDefinition);
            }
            return;
        }
        boolean hasTypeInclusions = false;
        NodeKind typeNodeKind = typeDefinition.typeNode.getKind();
        if (typeNodeKind == NodeKind.TUPLE_TYPE_NODE && definedType.tsymbol.scope == null) {
            definedType.tsymbol.scope = new Scope(definedType.tsymbol);
        }
        if (typeNodeKind == NodeKind.OBJECT_TYPE || typeNodeKind == NodeKind.RECORD_TYPE) {
            if (definedType.tsymbol.scope == null) {
                definedType.tsymbol.scope = new Scope(definedType.tsymbol);
            }
            structureTypeNode = (BLangStructureTypeNode)typeDefinition.typeNode;
            for (BLangType typeRef : structureTypeNode.typeRefs) {
                hasTypeInclusions = true;
                BType referencedType = this.symResolver.resolveTypeNode(typeRef, this.env);
                if (referencedType != this.symTable.noType || this.unresolvedTypes.contains(typeDefinition)) continue;
                this.unresolvedTypes.add(typeDefinition);
                return;
            }
        }
        if (hasTypeInclusions && !this.resolveRecordsUnresolvedDueToFields && typeNodeKind == NodeKind.RECORD_TYPE) {
            structureTypeNode = (BLangStructureTypeNode)typeDefinition.typeNode;
            for (BLangSimpleVariable variable : structureTypeNode.fields) {
                Scope scope;
                if (variable.typeNode.getKind() == NodeKind.FUNCTION_TYPE) continue;
                structureTypeNode.symbol.scope = scope = new Scope(structureTypeNode.symbol);
                SymbolEnv typeEnv = SymbolEnv.createTypeEnv(structureTypeNode, scope, this.env);
                BType referencedType = this.symResolver.resolveTypeNode(variable.typeNode, typeEnv);
                if (referencedType != this.symTable.noType || !this.unresolvedRecordDueToFields.add(typeDefinition) || this.unresolvedTypes.contains(typeDefinition)) continue;
                this.unresolvedTypes.add(typeDefinition);
                return;
            }
        }
        if (typeDefinition.flagSet.contains((Object)Flag.ENUM)) {
            definedType.tsymbol = this.createEnumSymbol(typeDefinition, definedType);
        }
        typeDefinition.setPrecedence(this.typePrecedence++);
        BSymbol typeDefSymbol = Symbols.createTypeDefinitionSymbol(Flags.asMask(typeDefinition.flagSet), this.names.fromIdNode(typeDefinition.name), this.env.enclPkg.packageID, definedType, this.env.scope.owner, typeDefinition.name.pos, this.getOrigin(typeDefinition.name.value));
        typeDefSymbol.markdownDocumentation = this.getMarkdownDocAttachment(typeDefinition.markdownDocumentationAttachment);
        BTypeSymbol typeSymbol = new BTypeSymbol(0x20000000L, typeDefSymbol.flags, typeDefSymbol.name, typeDefSymbol.pkgID, typeDefSymbol.type, typeDefSymbol.owner, typeDefSymbol.pos, typeDefSymbol.origin);
        typeSymbol.markdownDocumentation = typeDefSymbol.markdownDocumentation;
        typeDefSymbol.referenceType = new BTypeReferenceType(definedType, typeSymbol, typeDefSymbol.type.getFlags());
        boolean isLabel = true;
        if (definedType.tsymbol.name == Names.EMPTY) {
            isLabel = false;
            definedType.tsymbol.name = this.names.fromIdNode(typeDefinition.name);
            definedType.tsymbol.originalName = this.names.originalNameFromIdNode(typeDefinition.name);
            definedType.tsymbol.flags |= typeDefSymbol.flags;
            definedType.tsymbol.markdownDocumentation = typeDefSymbol.markdownDocumentation;
            definedType.tsymbol.pkgID = this.env.enclPkg.packageID;
            if (definedType.tsymbol.tag == 294940L) {
                definedType.tsymbol.owner = this.env.scope.owner;
            }
        }
        if ((definedType.tsymbol.kind == SymbolKind.OBJECT && !Symbols.isFlagOn(definedType.tsymbol.flags, 0x10000000L) || definedType.tsymbol.kind == SymbolKind.RECORD) && ((BStructureTypeSymbol)definedType.tsymbol).typeDefinitionSymbol == null) {
            ((BStructureTypeSymbol)definedType.tsymbol).typeDefinitionSymbol = typeDefSymbol;
        }
        if (typeDefinition.flagSet.contains((Object)Flag.ENUM)) {
            typeDefSymbol = definedType.tsymbol;
            typeDefSymbol.pos = typeDefinition.name.pos;
        }
        if (isErrorIntersection = this.isErrorIntersectionTypeCreatingNewType(typeDefinition, this.env)) {
            this.populateAllReadyDefinedErrorIntersection(definedType, typeDefinition, this.env);
        }
        BType referenceConstraintType = Types.getReferredType(definedType);
        this.handleDistinctDefinition(typeDefinition, typeDefSymbol, definedType, referenceConstraintType);
        typeDefSymbol.flags |= Flags.asMask(typeDefinition.flagSet);
        typeDefSymbol.flags &= this.getPublicFlagResetingMask(typeDefinition.flagSet, typeDefinition.typeNode);
        if (this.isDeprecated(typeDefinition.annAttachments)) {
            typeDefSymbol.flags |= 0x10L;
        }
        if (Symbols.isFlagOn(typeDefSymbol.flags, 2048L)) {
            typeDefSymbol.origin = SymbolOrigin.VIRTUAL;
        }
        if (typeDefinition.annAttachments.stream().anyMatch(attachment -> attachment.annotationName.value.equals(Names.ANNOTATION_TYPE_PARAM.value))) {
            if (PackageID.isLangLibPackageID(this.env.enclPkg.packageID)) {
                typeDefSymbol.type = this.typeParamAnalyzer.createTypeParam(typeDefSymbol);
                typeDefSymbol.flags |= 0x200000L;
            } else {
                this.dlog.error(typeDefinition.pos, DiagnosticErrorCode.TYPE_PARAM_OUTSIDE_LANG_MODULE, new Object[0]);
            }
        }
        definedType.addFlags(typeDefSymbol.flags);
        typeDefinition.symbol = typeDefSymbol;
        if (typeDefinition.hasCyclicReference) {
            typeDefinition.getBType().tsymbol = definedType.tsymbol;
        } else {
            boolean isLanglibModule = PackageID.isLangLibPackageID(this.env.enclPkg.packageID);
            if (isLanglibModule) {
                this.handleLangLibTypes(typeDefinition);
                return;
            }
            if (!isErrorIntersection || this.lookupTypeSymbol(this.env, typeDefinition.name) == this.symTable.notFoundSymbol) {
                this.defineSymbol(typeDefinition.name.pos, typeDefSymbol);
            }
        }
    }

    public void handleDistinctDefinition(BLangTypeDefinition typeDefinition, BSymbol typeDefSymbol, BType definedType, BType referenceConstraintType) {
        BType distinctType = definedType;
        if (this.isDistinctFlagPresent(typeDefinition)) {
            if (referenceConstraintType.getKind() == TypeKind.ERROR) {
                distinctType = this.getDistinctErrorType(typeDefinition, (BErrorType)referenceConstraintType, typeDefSymbol);
                typeDefinition.typeNode.setBType(distinctType);
            } else if (referenceConstraintType.getKind() == TypeKind.OBJECT) {
                distinctType = this.getDistinctObjectType(typeDefinition, (BObjectType)referenceConstraintType, referenceConstraintType.tsymbol);
                typeDefinition.typeNode.setBType(distinctType);
            }
            if (((BTypeDefinitionSymbol)typeDefSymbol).referenceType != null) {
                ((BTypeDefinitionSymbol)typeDefSymbol).referenceType.referredType = distinctType;
            }
            definedType.addFlags(0x8000000L);
        }
    }

    public void invalidateAlreadyDefinedErrorType(BLangTypeDefinition typeDefinition) {
        BSymbol alreadyDefinedTypeSymbol = this.lookupTypeSymbol(this.env, typeDefinition.name);
        if (Types.getImpliedType((BType)alreadyDefinedTypeSymbol.type).tag == 29) {
            alreadyDefinedTypeSymbol.type = this.symTable.errorType;
        }
    }

    private void populateErrorTypeIds(BErrorType effectiveType, BLangIntersectionTypeNode typeNode, String name, boolean distinctFlagPresentInTypeDef) {
        BTypeIdSet typeIdSet = BTypeIdSet.emptySet();
        int numberOfDistinctConstituentTypes = 0;
        for (BLangType constituentType : typeNode.constituentTypeNodes) {
            BType resolvedTypeNode = this.symResolver.resolveTypeNode(constituentType, this.env);
            BType type = Types.getImpliedType(resolvedTypeNode);
            if (type.getKind() != TypeKind.ERROR) continue;
            if (constituentType.flagSet.contains((Object)Flag.DISTINCT)) {
                ++numberOfDistinctConstituentTypes;
                typeIdSet.addSecondarySet(((BErrorType)type).typeIdSet.getAll());
                continue;
            }
            typeIdSet.add(((BErrorType)type).typeIdSet);
        }
        if (numberOfDistinctConstituentTypes == 1 || numberOfDistinctConstituentTypes == 0 && distinctFlagPresentInTypeDef) {
            effectiveType.typeIdSet = BTypeIdSet.from(this.env.enclPkg.packageID, name, true, typeIdSet);
        } else {
            for (BLangType constituentType : typeNode.constituentTypeNodes) {
                if (!constituentType.flagSet.contains((Object)Flag.DISTINCT)) continue;
                typeIdSet.add(BTypeIdSet.from(this.env.enclPkg.packageID, this.anonymousModelHelper.getNextAnonymousTypeId(this.env.enclPkg.packageID), true));
            }
            effectiveType.typeIdSet = typeIdSet;
        }
    }

    public void populateAllReadyDefinedErrorIntersection(BType definedType, BLangTypeDefinition typeDefinition, SymbolEnv env) {
        BSymbol bSymbol = this.lookupTypeSymbol(env, typeDefinition.name);
        BErrorType alreadyDefinedErrorType = (BErrorType)bSymbol.type;
        boolean distinctFlagPresent = typeDefinition.typeNode.flagSet.contains((Object)Flag.DISTINCT);
        BIntersectionType intersectionType = (BIntersectionType)definedType;
        BErrorType errorType = (BErrorType)intersectionType.effectiveType;
        this.populateErrorTypeIds(errorType, (BLangIntersectionTypeNode)typeDefinition.typeNode, typeDefinition.name.value, distinctFlagPresent);
        alreadyDefinedErrorType.typeIdSet = errorType.typeIdSet;
        alreadyDefinedErrorType.detailType = errorType.detailType;
        alreadyDefinedErrorType.setFlags(errorType.getFlags());
        alreadyDefinedErrorType.name = errorType.name;
        intersectionType.effectiveType = alreadyDefinedErrorType;
        if (!errorType.typeIdSet.isEmpty()) {
            definedType.addFlags(0x8000000L);
        }
    }

    public BSymbol lookupTypeSymbol(SymbolEnv env, BLangIdentifier name) {
        return this.symResolver.lookupSymbolInMainSpace(env, Names.fromString(name.value));
    }

    private BEnumSymbol createEnumSymbol(BLangTypeDefinition typeDefinition, BType definedType) {
        ArrayList<BConstantSymbol> enumMembers = new ArrayList<BConstantSymbol>();
        List<BLangType> members = ((BLangUnionTypeNode)typeDefinition.typeNode).memberTypeNodes;
        for (BLangType member : members) {
            enumMembers.add((BConstantSymbol)((BLangUserDefinedType)member).symbol);
        }
        BEnumSymbol enumSymbol = new BEnumSymbol(enumMembers, Flags.asMask(typeDefinition.flagSet), this.names.fromIdNode(typeDefinition.name), this.names.fromIdNode(typeDefinition.name), this.env.enclPkg.symbol.pkgID, definedType, this.env.scope.owner, typeDefinition.pos, SymbolOrigin.SOURCE);
        enumSymbol.name = this.names.fromIdNode(typeDefinition.name);
        enumSymbol.originalName = this.names.fromIdNode(typeDefinition.name);
        enumSymbol.flags |= Flags.asMask(typeDefinition.flagSet);
        enumSymbol.markdownDocumentation = this.getMarkdownDocAttachment(typeDefinition.markdownDocumentationAttachment);
        enumSymbol.pkgID = this.env.enclPkg.packageID;
        return enumSymbol;
    }

    private BObjectType getDistinctObjectType(BLangTypeDefinition typeDefinition, BObjectType definedType, BTypeSymbol typeDefSymbol) {
        BTypeSymbol tSymbol = typeDefSymbol.kind == SymbolKind.TYPE_DEF ? typeDefSymbol.type.tsymbol : typeDefSymbol;
        BObjectType definedObjType = definedType;
        if (definedObjType.tsymbol != tSymbol) {
            BObjectType objType = new BObjectType(this.symTable.typeEnv(), tSymbol);
            tSymbol.type = objType;
            definedObjType = objType;
        }
        boolean isPublicType = typeDefinition.flagSet.contains((Object)Flag.PUBLIC);
        definedObjType.typeIdSet = this.calculateTypeIdSet(typeDefinition, isPublicType, definedType.typeIdSet);
        return definedObjType;
    }

    private void defineTypeInMainScope(BTypeSymbol typeDefSymbol, BLangTypeDefinition typeDef, SymbolEnv env) {
        if (PackageID.isLangLibPackageID(env.enclPkg.packageID)) {
            typeDefSymbol.origin = SymbolOrigin.BUILTIN;
            this.handleLangLibTypes(typeDef);
        } else {
            this.defineSymbol(typeDef.name.pos, typeDefSymbol, env);
        }
    }

    private BType defineSymbolForCyclicTypeDefinition(BLangTypeDefinition typeDef, SymbolEnv env) {
        BType newTypeNode;
        Name newTypeDefName = this.names.fromIdNode(typeDef.name);
        BTypeSymbol typeDefSymbol = switch (typeDef.typeNode.getKind()) {
            case NodeKind.TUPLE_TYPE_NODE -> {
                newTypeNode = new BTupleType(this.symTable.typeEnv(), null, new ArrayList<BTupleMember>(), true);
                yield Symbols.createTypeSymbol(4227100L, Flags.asMask(typeDef.flagSet), newTypeDefName, env.enclPkg.symbol.pkgID, newTypeNode, env.scope.owner, typeDef.name.pos, SymbolOrigin.SOURCE);
            }
            default -> {
                newTypeNode = BUnionType.create(this.symTable.typeEnv(), null, new LinkedHashSet<BType>(), true);
                yield Symbols.createTypeSymbol(1081372L, Flags.asMask(typeDef.flagSet), newTypeDefName, env.enclPkg.symbol.pkgID, newTypeNode, env.scope.owner, typeDef.name.pos, SymbolOrigin.SOURCE);
            }
        };
        typeDef.symbol = typeDefSymbol;
        this.defineTypeInMainScope(typeDefSymbol, typeDef, env);
        newTypeNode.tsymbol = typeDefSymbol;
        newTypeNode.addFlags(typeDefSymbol.flags);
        return newTypeNode;
    }

    private BType getCyclicDefinedType(BLangTypeDefinition typeDef, SymbolEnv env) {
        BSymbol foundSym = this.symResolver.lookupSymbolInMainSpace(env, this.names.fromIdNode(typeDef.name));
        BType newTypeNode = foundSym.type;
        BType resolvedTypeNodes = Types.getImpliedType(this.symResolver.resolveTypeNode(typeDef.typeNode, env));
        if (resolvedTypeNodes == this.symTable.noType) {
            return this.symTable.semanticError;
        }
        switch (resolvedTypeNodes.tag) {
            case 31: {
                BTupleType definedTupleType = (BTupleType)resolvedTypeNodes;
                for (BType member : definedTupleType.getTupleTypes()) {
                    BVarSymbol varSymbol;
                    if (((BTupleType)newTypeNode).addMembers(new BTupleMember(member, varSymbol = Symbols.createVarSymbolForTupleMember(member)))) continue;
                    return this.constructDependencyListError(typeDef, member);
                }
                if (((BTupleType)newTypeNode).addRestType(definedTupleType.restType)) break;
                return this.constructDependencyListError(typeDef, definedTupleType.restType);
            }
            default: {
                BUnionType definedUnionType = (BUnionType)resolvedTypeNodes;
                for (BType member : definedUnionType.getMemberTypes()) {
                    ((BUnionType)newTypeNode).add(member);
                }
            }
        }
        typeDef.typeNode.setBType(newTypeNode);
        typeDef.typeNode.getBType().tsymbol.type = newTypeNode;
        typeDef.symbol.type = newTypeNode;
        typeDef.setBType(newTypeNode);
        return newTypeNode;
    }

    private void defineAllUnresolvedCyclicTypesInScope(SymbolEnv env) {
        SymbolEnv prevEnv = this.env;
        this.env = env;
        for (BLangNode unresolvedNode : this.unresolvedTypes) {
            if (unresolvedNode.getKind() != NodeKind.TYPE_DEFINITION || !((BLangTypeDefinition)unresolvedNode).hasCyclicReference) continue;
            this.defineSymbolForCyclicTypeDefinition((BLangTypeDefinition)unresolvedNode, env);
        }
        this.env = prevEnv;
    }

    private BType constructDependencyListError(BLangTypeDefinition typeDef, BType member) {
        ArrayList<String> dependencyList = new ArrayList<String>();
        dependencyList.add(SymbolEnter.getTypeOrClassName(typeDef));
        dependencyList.add(member.tsymbol.name.value);
        this.dlog.error(typeDef.getPosition(), DiagnosticErrorCode.CYCLIC_TYPE_REFERENCE, dependencyList);
        return this.symTable.semanticError;
    }

    private BErrorType getDistinctErrorType(BLangTypeDefinition typeDefinition, BErrorType definedType, BSymbol typeDefSymbol) {
        BErrorType definedErrorType = definedType;
        if (definedErrorType.tsymbol != typeDefSymbol) {
            BTypeSymbol typeSymbol = new BTypeSymbol(32796L, typeDefSymbol.flags, typeDefSymbol.name, typeDefSymbol.pkgID, null, typeDefSymbol.owner, typeDefSymbol.pos, typeDefSymbol.origin);
            BErrorType bErrorType = new BErrorType(this.symTable.typeEnv(), typeSymbol);
            typeSymbol.type = bErrorType;
            bErrorType.detailType = definedErrorType.detailType;
            typeDefSymbol.type = bErrorType;
            definedErrorType = bErrorType;
        }
        boolean isPublicType = typeDefinition.flagSet.contains((Object)Flag.PUBLIC);
        definedErrorType.typeIdSet = this.calculateTypeIdSet(typeDefinition, isPublicType, definedType.typeIdSet);
        return definedErrorType;
    }

    private BTypeIdSet calculateTypeIdSet(BLangTypeDefinition typeDefinition, boolean isPublicType, BTypeIdSet secondary) {
        String name = typeDefinition.flagSet.contains((Object)Flag.ANONYMOUS) ? this.anonymousModelHelper.getNextAnonymousTypeId(this.env.enclPkg.packageID) : typeDefinition.getName().value;
        return BTypeIdSet.from(this.env.enclPkg.packageID, name, isPublicType, secondary);
    }

    private boolean isDistinctFlagPresent(BLangTypeDefinition typeDefinition) {
        return typeDefinition.typeNode.flagSet.contains((Object)Flag.DISTINCT);
    }

    private void handleLangLibTypes(BLangTypeDefinition typeDefinition) {
        if (typeDefinition.annAttachments.isEmpty()) {
            this.defineSymbol(typeDefinition.name.pos, typeDefinition.symbol);
            return;
        }
        BLangAnnotationAttachment attachment = typeDefinition.annAttachments.get(0);
        if (attachment.annotationName.value.equals(Names.ANNOTATION_TYPE_PARAM.value)) {
            BSymbol typeDefSymbol = typeDefinition.symbol;
            typeDefSymbol.type = this.typeParamAnalyzer.createTypeParam(typeDefSymbol);
            typeDefSymbol.flags |= 0x200000L;
        } else if (attachment.annotationName.value.equals(Names.ANNOTATION_BUILTIN_SUBTYPE.value)) {
            BType type;
            typeDefinition.symbol.type = type = this.symTable.getLangLibSubType(typeDefinition.name.value);
            typeDefinition.symbol.flags |= type.tsymbol.flags;
            ((BTypeDefinitionSymbol)typeDefinition.symbol).referenceType.tsymbol.flags |= type.tsymbol.flags;
            ((BTypeDefinitionSymbol)typeDefinition.symbol).referenceType.referredType = type;
            typeDefinition.setBType(type);
            typeDefinition.typeNode.setBType(type);
            typeDefinition.isBuiltinTypeDef = true;
        } else {
            throw new IllegalStateException("Not supported annotation attachment at:" + String.valueOf(attachment.pos));
        }
        this.defineSymbol(typeDefinition.name.pos, typeDefinition.symbol);
    }

    public void handleLangLibTypes(BLangTypeDefinition typeDefinition, SymbolEnv env) {
        if (typeDefinition.annAttachments.isEmpty()) {
            this.defineSymbol(typeDefinition.name.pos, typeDefinition.symbol, env);
            return;
        }
        BLangAnnotationAttachment attachment = typeDefinition.annAttachments.get(0);
        if (attachment.annotationName.value.equals(Names.ANNOTATION_TYPE_PARAM.value)) {
            BSymbol typeDefSymbol = typeDefinition.symbol;
            typeDefSymbol.type = this.typeParamAnalyzer.createTypeParam(typeDefSymbol);
            typeDefSymbol.flags |= 0x200000L;
        } else if (attachment.annotationName.value.equals(Names.ANNOTATION_BUILTIN_SUBTYPE.value)) {
            BType type;
            typeDefinition.symbol.type = type = this.symTable.getLangLibSubType(typeDefinition.name.value);
            typeDefinition.symbol.flags |= type.tsymbol.flags;
            ((BTypeDefinitionSymbol)typeDefinition.symbol).referenceType.tsymbol.flags |= type.tsymbol.flags;
            ((BTypeDefinitionSymbol)typeDefinition.symbol).referenceType.referredType = type;
            typeDefinition.setBType(type);
            typeDefinition.typeNode.setBType(type);
            typeDefinition.isBuiltinTypeDef = true;
        } else {
            throw new IllegalStateException("Not supported annotation attachment at:" + String.valueOf(attachment.pos));
        }
        this.defineSymbol(typeDefinition.name.pos, typeDefinition.symbol, env);
    }

    public long getPublicFlagResetingMask(Set<Flag> flagSet, BLangType typeNode) {
        boolean isAnonType;
        boolean bl = isAnonType = typeNode instanceof BLangStructureTypeNode && ((BLangStructureTypeNode)typeNode).isAnonymous;
        if (flagSet.contains((Object)Flag.PUBLIC) || isAnonType) {
            return Long.MAX_VALUE;
        }
        return -2L;
    }

    @Override
    public void visit(BLangService serviceNode) {
        this.defineNode(serviceNode.serviceVariable, this.env);
        Name generatedServiceName = Names.fromString("service$" + serviceNode.serviceClass.symbol.name.value);
        BType type = serviceNode.serviceClass.typeRefs.isEmpty() ? null : serviceNode.serviceClass.typeRefs.get(0).getBType();
        BServiceSymbol serviceSymbol = new BServiceSymbol((BClassSymbol)serviceNode.serviceClass.symbol, Flags.asMask(serviceNode.flagSet), generatedServiceName, this.env.enclPkg.symbol.pkgID, type, (BSymbol)this.env.enclPkg.symbol, serviceNode.pos, SymbolOrigin.SOURCE);
        serviceNode.symbol = serviceSymbol;
        if (!serviceNode.absoluteResourcePath.isEmpty()) {
            if ("/".equals(serviceNode.absoluteResourcePath.get(0).getValue())) {
                serviceSymbol.setAbsResourcePath(Collections.emptyList());
            } else {
                ArrayList<String> list = new ArrayList<String>(serviceNode.absoluteResourcePath.size());
                for (IdentifierNode identifierNode : serviceNode.absoluteResourcePath) {
                    list.add(identifierNode.getValue());
                }
                serviceSymbol.setAbsResourcePath(list);
            }
        }
        if (serviceNode.serviceNameLiteral != null) {
            serviceSymbol.setAttachPointStringLiteral(serviceNode.serviceNameLiteral.value.toString());
        }
        this.env.scope.define(serviceSymbol.name, serviceSymbol);
    }

    @Override
    public void visit(BLangResourceFunction funcNode) {
        boolean validAttachedFunc = this.validateFuncReceiver(funcNode);
        if (PackageID.isLangLibPackageID(this.env.enclPkg.symbol.pkgID)) {
            funcNode.flagSet.add(Flag.LANG_LIB);
        }
        BInvokableSymbol funcSymbol = Symbols.createFunctionSymbol(Flags.asMask(funcNode.flagSet), this.getFuncSymbolName(funcNode), this.getFuncSymbolOriginalName(funcNode), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, funcNode.hasBody(), funcNode.name.pos, SymbolOrigin.SOURCE);
        funcSymbol.source = funcNode.pos.lineRange().fileName();
        funcSymbol.markdownDocumentation = this.getMarkdownDocAttachment(funcNode.markdownDocumentationAttachment);
        SymbolEnv invokableEnv = SymbolEnv.createFunctionEnv(funcNode, funcSymbol.scope, this.env);
        this.defineInvokableSymbol(funcNode, funcSymbol, invokableEnv);
        funcNode.setBType(funcSymbol.type);
        if (this.isDeprecated(funcNode.annAttachments)) {
            funcSymbol.flags |= 0x10L;
        }
        if (funcNode.receiver != null) {
            this.defineAttachedFunctions(funcNode, funcSymbol, invokableEnv, validAttachedFunc);
        }
    }

    @Override
    public void visit(BLangFunction funcNode) {
        boolean validAttachedFunc = this.validateFuncReceiver(funcNode);
        boolean remoteFlagSetOnNode = Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 32768L);
        if (!funcNode.attachedFunction && Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 1024L)) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.PRIVATE_FUNCTION_VISIBILITY, funcNode.name);
        }
        if (funcNode.receiver == null && !funcNode.attachedFunction && remoteFlagSetOnNode) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.REMOTE_IN_NON_OBJECT_FUNCTION, funcNode.name.value);
        }
        if (PackageID.isLangLibPackageID(this.env.enclPkg.symbol.pkgID)) {
            funcNode.flagSet.add(Flag.LANG_LIB);
        }
        Location symbolPos = funcNode.flagSet.contains((Object)Flag.LAMBDA) ? this.symTable.builtinPos : funcNode.name.pos;
        BInvokableSymbol funcSymbol = Symbols.createFunctionSymbol(Flags.asMask(funcNode.flagSet), this.getFuncSymbolName(funcNode), this.getFuncSymbolOriginalName(funcNode), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, funcNode.hasBody(), symbolPos, this.getOrigin(funcNode.name.value));
        funcSymbol.source = funcNode.pos.lineRange().fileName();
        funcSymbol.markdownDocumentation = this.getMarkdownDocAttachment(funcNode.markdownDocumentationAttachment);
        NodeKind previousNodeKind = this.env.node.getKind();
        SymbolEnv invokableEnv = previousNodeKind == NodeKind.CLASS_DEFN ? SymbolEnv.createFunctionEnv(funcNode, funcSymbol.scope, this.fieldsRemovedEnv(this.env, ((BLangClassDefinition)this.env.node).fields)) : (previousNodeKind == NodeKind.OBJECT_TYPE ? SymbolEnv.createFunctionEnv(funcNode, funcSymbol.scope, this.fieldsRemovedEnv(this.env, ((BLangObjectTypeNode)this.env.node).fields)) : SymbolEnv.createFunctionEnv(funcNode, funcSymbol.scope, this.env));
        this.defineInvokableSymbol(funcNode, funcSymbol, invokableEnv);
        funcNode.setBType(funcSymbol.type);
        if (Symbols.isFlagOn(funcSymbol.flags, 0x100000L)) {
            funcSymbol.origin = SymbolOrigin.VIRTUAL;
        }
        if (this.isDeprecated(funcNode.annAttachments)) {
            funcSymbol.flags |= 0x10L;
        }
        if (funcNode.receiver != null) {
            this.defineAttachedFunctions(funcNode, funcSymbol, invokableEnv, validAttachedFunc);
        }
    }

    private SymbolEnv fieldsRemovedEnv(SymbolEnv currentEnv, List<BLangSimpleVariable> fields) {
        if (fields.isEmpty()) {
            return currentEnv;
        }
        Scope currentScope = currentEnv.scope;
        Scope newScope = new Scope(currentScope.owner);
        newScope.entries.putAll(currentScope.entries);
        Map<Name, Scope.ScopeEntry> entries = newScope.entries;
        for (BLangSimpleVariable field : fields) {
            entries.remove(Names.fromString(field.name.value));
        }
        SymbolEnv newEnv = new SymbolEnv(currentEnv.node, newScope);
        currentEnv.copyTo(newEnv, currentEnv.enclEnv);
        return newEnv;
    }

    public boolean isDeprecated(List<BLangAnnotationAttachment> annAttachments) {
        for (BLangAnnotationAttachment annotationAttachment : annAttachments) {
            if (!annotationAttachment.annotationName.getValue().equals(DEPRECATION_ANNOTATION)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(BLangConstant constant) {
        BConstantSymbol constantSymbol;
        BType staticType;
        if (constant.typeNode != null) {
            staticType = this.symResolver.resolveTypeNode(constant.typeNode, this.env);
            if (staticType == this.symTable.noType) {
                constant.symbol = this.getConstantSymbol(constant);
                if (!this.unresolvedTypes.contains(constant)) {
                    this.unresolvedTypes.add(constant);
                }
                return;
            }
        } else {
            staticType = this.symTable.semanticError;
        }
        constant.symbol = constantSymbol = this.getConstantSymbol(constant);
        NodeKind nodeKind = constant.expr.getKind();
        if (nodeKind == NodeKind.LITERAL || nodeKind == NodeKind.NUMERIC_LITERAL) {
            if (constant.typeNode != null) {
                BType referredType = Types.getImpliedType(staticType);
                if (this.types.isValidLiteral((BLangLiteral)constant.expr, referredType)) {
                    BLangFiniteTypeNode finiteType = (BLangFiniteTypeNode)constant.associatedTypeDefinition.typeNode;
                    BLangExpression valueSpaceExpr = finiteType.valueSpace.iterator().next();
                    valueSpaceExpr.setBType(referredType);
                    this.defineNode(constant.associatedTypeDefinition, this.env);
                    constantSymbol.type = constant.associatedTypeDefinition.symbol.type;
                    constantSymbol.literalType = referredType;
                } else {
                    this.defineNode(constant.associatedTypeDefinition, this.env);
                    constantSymbol.type = staticType;
                    constantSymbol.literalType = constant.expr.getBType();
                }
            } else {
                this.defineNode(constant.associatedTypeDefinition, this.env);
                constantSymbol.type = constant.associatedTypeDefinition.symbol.type;
                constantSymbol.literalType = constant.expr.getBType();
            }
            if (constantSymbol.type.tag != 14) {
                constantSymbol.type.tsymbol.flags |= constant.associatedTypeDefinition.symbol.flags;
            }
        } else if (nodeKind == NodeKind.UNARY_EXPR && constant.typeNode == null && this.types.isLiteralInUnaryAllowed((BLangUnaryExpr)constant.expr)) {
            BLangUnaryExpr unaryConstant = (BLangUnaryExpr)constant.expr;
            BLangNumericLiteral literal = (BLangNumericLiteral)TreeBuilder.createNumericLiteralExpression();
            Types.setValueOfNumericLiteral(literal, unaryConstant);
            literal.isConstant = true;
            literal.setBType(unaryConstant.expr.getBType());
            ((BLangFiniteTypeNode)constant.getAssociatedTypeDefinition().getTypeNode()).valueSpace.set(0, literal);
            this.defineNode(constant.associatedTypeDefinition, this.env);
            constantSymbol.type = constant.associatedTypeDefinition.symbol.type;
            constantSymbol.literalType = unaryConstant.expr.getBType();
        } else if (constant.typeNode != null) {
            constantSymbol.type = constantSymbol.literalType = staticType;
        }
        constantSymbol.markdownDocumentation = this.getMarkdownDocAttachment(constant.markdownDocumentationAttachment);
        if (this.isDeprecated(constant.annAttachments)) {
            constantSymbol.flags |= 0x10L;
        }
        if (!this.symResolver.checkForUniqueSymbol(constant.name.pos, this.env, constantSymbol)) {
            return;
        }
        if (constant.symbol.name == Names.IGNORE) {
            return;
        }
        this.env.scope.define(constantSymbol.name, constantSymbol);
    }

    public BConstantSymbol getConstantSymbol(BLangConstant constant) {
        Name name = this.names.fromIdNode(constant.name);
        PackageID pkgID = this.env.enclPkg.symbol.pkgID;
        return new BConstantSymbol(Flags.asMask(constant.flagSet), name, this.names.originalNameFromIdNode(constant.name), pkgID, this.symTable.semanticError, this.symTable.noType, this.env.scope.owner, constant.name.pos, this.getOrigin(name));
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        if (varNode.getBType() == null) {
            if (varNode.typeNode != null) {
                if (varNode.typeNode.getBType() != null) {
                    varNode.setBType(varNode.typeNode.getBType());
                } else {
                    varNode.setBType(this.symResolver.resolveTypeNode(varNode.typeNode, this.env));
                }
            } else {
                varNode.setBType(this.symTable.noType);
            }
        }
        Name varName = this.names.fromIdNode(varNode.name);
        Name varOrigName = this.names.originalNameFromIdNode(varNode.name);
        if (varName == Names.IGNORE || varNode.symbol != null) {
            return;
        }
        BVarSymbol varSymbol = this.defineVarSymbol(varNode.name.pos, varNode.flagSet, varNode.getBType(), varName, varOrigName, this.env, varNode.internal);
        if (this.isDeprecated(varNode.annAttachments)) {
            varSymbol.flags |= 0x10L;
        }
        if (varSymbol.type == this.symTable.semanticError && varSymbol.state == DiagnosticState.VALID) {
            varSymbol.state = DiagnosticState.UNKNOWN_TYPE;
        }
        varSymbol.markdownDocumentation = this.getMarkdownDocAttachment(varNode.markdownDocumentationAttachment);
        varNode.symbol = varSymbol;
        if (varNode.symbol.type.tsymbol != null && Symbols.isFlagOn(varNode.symbol.type.tsymbol.flags, 65536L)) {
            varSymbol.tag = 16436L;
        }
        if (Types.getImpliedType((BType)varSymbol.type).tag == 32 && ((BFutureType)Types.getImpliedType((BType)varSymbol.type)).workerDerivative) {
            Iterator lambdaFunctions = this.env.enclPkg.lambdaFunctions.iterator();
            while (lambdaFunctions.hasNext()) {
                BLangLambdaFunction lambdaFunction = (BLangLambdaFunction)lambdaFunctions.next();
                BLangInvokableNode enclInvokable = lambdaFunction.capturedClosureEnv.enclInvokable;
                if (!lambdaFunctions.hasNext() || enclInvokable == null || varSymbol.owner != enclInvokable.symbol) continue;
                lambdaFunction.capturedClosureEnv.scope.define(varSymbol.name, varSymbol);
            }
        }
        if (Types.getImpliedType((BType)varSymbol.type).tag == 17) {
            BInvokableSymbol symbol = (BInvokableSymbol)varSymbol;
            BTypeSymbol typeSymbol = Types.getImpliedType((BType)varSymbol.type).tsymbol;
            BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)typeSymbol;
            symbol.params = tsymbol.params == null ? null : new ArrayList<BVarSymbol>(tsymbol.params);
            symbol.restParam = tsymbol.restParam;
            symbol.retType = tsymbol.returnType;
        }
        if ((this.env.scope.owner.tag & 0x2805CL) != 163932L && !varNode.flagSet.contains((Object)Flag.NEVER_ALLOWED) && (this.env.scope.owner.tag & 0x40801CL) != 4227100L && this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(varSymbol.type)) {
            if (varNode.flagSet.contains((Object)Flag.REQUIRED_PARAM) || varNode.flagSet.contains((Object)Flag.DEFAULTABLE_PARAM)) {
                this.dlog.error(varNode.pos, DiagnosticErrorCode.NEVER_TYPE_NOT_ALLOWED_FOR_REQUIRED_DEFAULTABLE_PARAMS, new Object[0]);
            } else if ((this.env.scope.owner.tag & 0x1805CL) == 98396L) {
                this.dlog.error(varNode.pos, DiagnosticErrorCode.NEVER_TYPED_OBJECT_FIELD_NOT_ALLOWED, new Object[0]);
            } else {
                this.dlog.error(varNode.pos, DiagnosticErrorCode.NEVER_TYPED_VAR_DEF_NOT_ALLOWED, new Object[0]);
            }
        }
    }

    @Override
    public void visit(BLangTupleVariable varNode) {
        if (varNode.isDeclaredWithVar) {
            varNode.symbol = this.defineVarSymbol(varNode.pos, varNode.flagSet, this.symTable.noType, Names.fromString(this.anonymousModelHelper.getNextTupleVarKey(this.env.enclPkg.packageID)), this.env, true);
            ArrayList<BLangVariable> memberVariables = new ArrayList<BLangVariable>(varNode.memberVariables);
            if (varNode.restVariable != null) {
                memberVariables.add(varNode.restVariable);
            }
            for (BLangVariable memberVar : memberVariables) {
                memberVar.isDeclaredWithVar = true;
                this.defineNode(memberVar, this.env);
            }
            return;
        }
        if (varNode.getBType() == null) {
            varNode.setBType(this.symResolver.resolveTypeNode(varNode.typeNode, this.env));
        }
        if (!this.checkTypeAndVarCountConsistency(varNode, this.env)) {
            varNode.setBType(this.symTable.semanticError);
            return;
        }
    }

    boolean checkTypeAndVarCountConsistency(BLangTupleVariable var, SymbolEnv env) {
        if (var.symbol == null) {
            Name varName = Names.fromString(this.anonymousModelHelper.getNextTupleVarKey(env.enclPkg.packageID));
            var.symbol = this.defineVarSymbol(var.pos, var.flagSet, var.getBType(), varName, env, true);
        }
        return this.checkTypeAndVarCountConsistency(var, null, env);
    }

    boolean checkTypeAndVarCountConsistency(BLangTupleVariable varNode, BTupleType tupleTypeNode, SymbolEnv env) {
        BType type;
        if (tupleTypeNode == null) {
            BType bType = varNode.getBType();
            BType referredType = Types.getImpliedType(bType);
            switch (referredType.tag) {
                case 21: {
                    BVarSymbol varSymbol;
                    Set<BType> unionType = this.types.expandAndGetMemberTypesRecursive(referredType);
                    ArrayList<BType> possibleTypes = new ArrayList<BType>();
                    for (BType type2 : unionType) {
                        BType referredPossibleType = Types.getImpliedType(type2);
                        if (!(31 == referredPossibleType.tag && this.checkMemVarCountMatchWithMemTypeCount(varNode, (BTupleType)referredPossibleType) || 18 == referredPossibleType.tag || 11 == referredPossibleType.tag || 20 == referredPossibleType.tag && ((BArrayType)referredPossibleType).state != BArrayState.OPEN)) continue;
                        possibleTypes.add(type2);
                    }
                    if (possibleTypes.isEmpty()) {
                        if (varNode.isDeclaredWithVar) {
                            this.dlog.error(varNode.pos, DiagnosticErrorCode.INVALID_LIST_BINDING_PATTERN, new Object[0]);
                            return false;
                        }
                        this.dlog.error(varNode.pos, DiagnosticErrorCode.INVALID_LIST_BINDING_PATTERN_DECL, bType);
                        return false;
                    }
                    if (possibleTypes.size() > 1) {
                        ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
                        for (int i = 0; i < varNode.memberVariables.size(); ++i) {
                            LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
                            for (BType possibleType : possibleTypes) {
                                possibleType = Types.getImpliedType(possibleType);
                                if (possibleType.tag == 31) {
                                    memberTypes.add(((BTupleType)possibleType).getTupleTypes().get(i));
                                    continue;
                                }
                                if (possibleType.tag == 20) {
                                    memberTypes.add(((BArrayType)possibleType).eType);
                                    continue;
                                }
                                BVarSymbol varSymbol2 = Symbols.createVarSymbolForTupleMember(referredType);
                                members.add(new BTupleMember(referredType, varSymbol2));
                            }
                            if (memberTypes.size() > 1) {
                                BUnionType type3 = BUnionType.create(this.symTable.typeEnv(), null, memberTypes);
                                varSymbol = new BVarSymbol(type3.getFlags(), null, null, type3, null, null, null);
                                members.add(new BTupleMember(type3, varSymbol));
                                continue;
                            }
                            memberTypes.forEach(m -> members.add(new BTupleMember((BType)m, Symbols.createVarSymbolForTupleMember(m))));
                        }
                        tupleTypeNode = new BTupleType(this.symTable.typeEnv(), members);
                        tupleTypeNode.restType = this.getPossibleRestTypeForUnion(varNode, possibleTypes);
                        break;
                    }
                    BType referredPossibleType = Types.getImpliedType((BType)possibleTypes.get(0));
                    if (referredPossibleType.tag == 31) {
                        tupleTypeNode = (BTupleType)referredPossibleType;
                        tupleTypeNode.restType = this.getPossibleRestTypeForUnion(varNode, possibleTypes);
                        break;
                    }
                    ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
                    for (int i = 0; i < varNode.memberVariables.size(); ++i) {
                        BType type4 = (BType)possibleTypes.get(0);
                        varSymbol = Symbols.createVarSymbolForTupleMember(type4);
                        members.add(new BTupleMember(type4, varSymbol));
                    }
                    tupleTypeNode = new BTupleType(this.symTable.typeEnv(), members);
                    tupleTypeNode.restType = this.getPossibleRestTypeForUnion(varNode, possibleTypes);
                    break;
                }
                case 11: 
                case 18: {
                    BVarSymbol varSymbol;
                    ArrayList<BTupleMember> memberTupleTypes = new ArrayList<BTupleMember>();
                    for (int i = 0; i < varNode.memberVariables.size(); ++i) {
                        varSymbol = Symbols.createVarSymbolForTupleMember(referredType);
                        memberTupleTypes.add(new BTupleMember(referredType, varSymbol));
                    }
                    tupleTypeNode = new BTupleType(this.symTable.typeEnv(), memberTupleTypes);
                    if (varNode.restVariable == null) break;
                    tupleTypeNode.restType = referredType;
                    break;
                }
                case 31: {
                    tupleTypeNode = (BTupleType)referredType;
                    break;
                }
                case 20: {
                    ArrayList<BTupleMember> tupleTypes = new ArrayList<BTupleMember>();
                    BArrayType arrayType = (BArrayType)referredType;
                    tupleTypeNode = new BTupleType(this.symTable.typeEnv(), tupleTypes);
                    BType eType = arrayType.eType;
                    for (int i = 0; i < arrayType.getSize(); ++i) {
                        BType type5 = arrayType.eType;
                        BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(type5);
                        tupleTypes.add(new BTupleMember(type5, varSymbol));
                    }
                    if (varNode.restVariable == null) break;
                    tupleTypeNode.restType = eType;
                    break;
                }
                default: {
                    this.dlog.error(varNode.pos, DiagnosticErrorCode.INVALID_LIST_BINDING_PATTERN_DECL, bType);
                    return false;
                }
            }
        }
        if (!this.checkMemVarCountMatchWithMemTypeCount(varNode, tupleTypeNode)) {
            this.dlog.error(varNode.pos, DiagnosticErrorCode.INVALID_LIST_BINDING_PATTERN, new Object[0]);
            return false;
        }
        int ignoredCount = 0;
        int i = 0;
        List<BType> tupleMemberTypes = tupleTypeNode.getTupleTypes();
        for (BLangVariable var : varNode.memberVariables) {
            type = tupleMemberTypes.get(i);
            ++i;
            if (var.getKind() == NodeKind.VARIABLE) {
                BLangSimpleVariable simpleVar = (BLangSimpleVariable)var;
                Name varName = this.names.fromIdNode(simpleVar.name);
                if (varName == Names.IGNORE) {
                    ++ignoredCount;
                    simpleVar.setBType(this.symTable.anyType);
                    if (this.types.isAssignable(type, this.symTable.anyType)) continue;
                    this.dlog.error(varNode.pos, DiagnosticErrorCode.WILD_CARD_BINDING_PATTERN_ONLY_SUPPORTS_TYPE_ANY, new Object[0]);
                    continue;
                }
            }
            this.defineMemberNode(var, env, type);
        }
        if (varNode.restVariable != null) {
            List<BTupleMember> tupleMembers = tupleTypeNode.getMembers();
            int tupleNodeMemCount = tupleMembers.size();
            int varNodeMemCount = varNode.memberVariables.size();
            BType restType = tupleTypeNode.restType;
            ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
            if (varNodeMemCount < tupleNodeMemCount) {
                for (int j = varNodeMemCount; j < tupleNodeMemCount; ++j) {
                    members.add(tupleMembers.get(j));
                }
            }
            if (!members.isEmpty()) {
                BTupleType restTupleType = new BTupleType(this.symTable.typeEnv(), members);
                restTupleType.restType = restType;
                type = restTupleType;
            } else {
                type = restType != null ? new BArrayType(this.symTable.typeEnv(), restType) : null;
            }
            this.defineMemberNode(varNode.restVariable, env, type);
        }
        if (!varNode.memberVariables.isEmpty() && ignoredCount == varNode.memberVariables.size() && varNode.restVariable == null) {
            this.dlog.error(varNode.pos, DiagnosticErrorCode.NO_NEW_VARIABLES_VAR_ASSIGNMENT, new Object[0]);
            return false;
        }
        return true;
    }

    private BType getPossibleRestTypeForUnion(BLangTupleVariable varNode, List<BType> possibleTypes) {
        if (varNode.restVariable == null) {
            return null;
        }
        LinkedHashSet<BType> memberRestTypes = new LinkedHashSet<BType>();
        for (BType possibleType : possibleTypes) {
            BType referredPossibleType = Types.getImpliedType(possibleType);
            if (referredPossibleType.tag == 31) {
                BTupleType tupleType = (BTupleType)referredPossibleType;
                List<BType> tupleMemberTypes = tupleType.getTupleTypes();
                for (int j = varNode.memberVariables.size(); j < tupleMemberTypes.size(); ++j) {
                    memberRestTypes.add(tupleMemberTypes.get(j));
                }
                if (tupleType.restType == null) continue;
                memberRestTypes.add(tupleType.restType);
                continue;
            }
            if (referredPossibleType.tag == 20) {
                memberRestTypes.add(((BArrayType)referredPossibleType).eType);
                continue;
            }
            memberRestTypes.add(possibleType);
        }
        if (!memberRestTypes.isEmpty()) {
            return memberRestTypes.size() > 1 ? BUnionType.create(this.symTable.typeEnv(), null, memberRestTypes) : (BType)memberRestTypes.iterator().next();
        }
        return varNode.getBType();
    }

    private boolean checkMemVarCountMatchWithMemTypeCount(BLangTupleVariable varNode, BTupleType tupleTypeNode) {
        int memberVarsSize = varNode.memberVariables.size();
        BLangVariable restVariable = varNode.restVariable;
        int tupleTypesSize = tupleTypeNode.getMembers().size();
        if (memberVarsSize > tupleTypesSize || tupleTypesSize == memberVarsSize && restVariable != null && tupleTypeNode.restType == null) {
            return false;
        }
        return restVariable != null || tupleTypesSize == memberVarsSize && tupleTypeNode.restType == null;
    }

    @Override
    public void visit(BLangRecordVariable recordVar) {
        if (recordVar.isDeclaredWithVar) {
            recordVar.symbol = this.defineVarSymbol(recordVar.pos, recordVar.flagSet, this.symTable.noType, Names.fromString(this.anonymousModelHelper.getNextRecordVarKey(this.env.enclPkg.packageID)), this.env, true);
            for (BLangRecordVariable.BLangRecordVariableKeyValue variable : recordVar.variableList) {
                BLangVariable value = variable.getValue();
                value.isDeclaredWithVar = true;
                this.defineNode(value, this.env);
            }
            BLangSimpleVariable restParam = (BLangSimpleVariable)recordVar.restParam;
            if (restParam != null) {
                restParam.isDeclaredWithVar = true;
                this.defineNode(restParam, this.env);
            }
            return;
        }
        if (recordVar.getBType() == null) {
            recordVar.setBType(this.symResolver.resolveTypeNode(recordVar.typeNode, this.env));
        }
        if (!this.symbolEnterAndValidateRecordVariable(recordVar, this.env)) {
            recordVar.setBType(this.symTable.semanticError);
            return;
        }
    }

    boolean symbolEnterAndValidateRecordVariable(BLangRecordVariable var, SymbolEnv env) {
        if (var.symbol == null) {
            Name varName = Names.fromString(this.anonymousModelHelper.getNextRecordVarKey(env.enclPkg.packageID));
            var.symbol = this.defineVarSymbol(var.pos, var.flagSet, var.getBType(), varName, env, true);
        }
        return this.validateRecordVariable(var, env);
    }

    boolean validateRecordVariable(BLangRecordVariable recordVar, SymbolEnv env) {
        BRecordType recordVarType;
        BType recordType = Types.getImpliedType(recordVar.getBType());
        switch (recordType.tag) {
            case 21: {
                BUnionType unionType = (BUnionType)recordType;
                Set<BType> bTypes = this.types.expandAndGetMemberTypesRecursive(unionType);
                List<BType> possibleTypes = bTypes.stream().filter(rec -> this.doesRecordContainKeys((BType)rec, recordVar.variableList, recordVar.restParam != null)).toList();
                if (possibleTypes.isEmpty()) {
                    this.dlog.error(recordVar.pos, DiagnosticErrorCode.INVALID_RECORD_BINDING_PATTERN, recordType);
                    return false;
                }
                if (possibleTypes.size() > 1) {
                    recordVarType = this.populatePossibleFields(recordVar, possibleTypes, env);
                    break;
                }
                BType possibleType = Types.getImpliedType(possibleTypes.get(0));
                int possibleTypeTag = possibleType.tag;
                if (possibleTypeTag == 12) {
                    recordVarType = (BRecordType)possibleType;
                    break;
                }
                if (possibleTypeTag == 16) {
                    recordVarType = this.createSameTypedFieldsRecordType(recordVar, ((BMapType)possibleType).constraint, env);
                    break;
                }
                recordVarType = this.createSameTypedFieldsRecordType(recordVar, possibleTypes.get(0), env);
                break;
            }
            case 12: {
                recordVarType = (BRecordType)recordType;
                break;
            }
            case 16: {
                recordVarType = this.createSameTypedFieldsRecordType(recordVar, ((BMapType)recordType).constraint, env);
                break;
            }
            default: {
                this.dlog.error(recordVar.pos, DiagnosticErrorCode.INVALID_RECORD_BINDING_PATTERN, recordType);
                return false;
            }
        }
        return this.defineVariableList(recordVar, recordVarType, env);
    }

    private BRecordType populatePossibleFields(BLangRecordVariable recordVar, List<BType> possibleTypes, SymbolEnv env) {
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(2048L, Names.fromString(ANONYMOUS_RECORD_NAME), env.enclPkg.symbol.pkgID, null, env.scope.owner, recordVar.pos, SymbolOrigin.SOURCE);
        BRecordType recordVarType = (BRecordType)this.symTable.recordType;
        List<String> mappedFields = recordVar.variableList.stream().map(varKeyValue -> varKeyValue.getKey().value).toList();
        LinkedHashMap<String, BField> fields = this.populateAndGetPossibleFieldsForRecVar(recordVar.pos, possibleTypes, mappedFields, recordSymbol, env);
        if (recordVar.restParam != null) {
            recordVarType.restFieldType = this.createRestFieldFromPossibleTypes(recordVar.pos, env, possibleTypes, fields, recordSymbol);
        }
        recordVarType.tsymbol = recordSymbol;
        recordVarType.fields = fields;
        recordSymbol.type = recordVarType;
        return recordVarType;
    }

    private BType createRestFieldFromPossibleTypes(Location pos, SymbolEnv env, List<BType> possibleTypes, LinkedHashMap<String, BField> boundedFields, BSymbol recordSymbol) {
        BType restFieldType;
        LinkedHashSet<BType> restFieldMemberTypes = new LinkedHashSet<BType>();
        final ArrayList<LinkedHashMap<String, BField>> possibleRecordFieldMapList = new ArrayList<LinkedHashMap<String, BField>>();
        for (BType possibleType : possibleTypes) {
            BType referredPossibleType = Types.getImpliedType(possibleType);
            if (referredPossibleType.tag == 12) {
                BRecordType recordType = (BRecordType)referredPossibleType;
                possibleRecordFieldMapList.add(recordType.fields);
                restFieldMemberTypes.add(recordType.restFieldType);
                continue;
            }
            if (referredPossibleType.tag == 16) {
                restFieldMemberTypes.add(((BMapType)referredPossibleType).constraint);
                continue;
            }
            restFieldMemberTypes.add(possibleType);
        }
        BType bType = restFieldType = restFieldMemberTypes.size() > 1 ? BUnionType.create(this.symTable.typeEnv(), null, restFieldMemberTypes) : (BType)restFieldMemberTypes.iterator().next();
        if (!possibleRecordFieldMapList.isEmpty()) {
            List<String> intersectionFields = this.getIntersectionFields(possibleRecordFieldMapList);
            LinkedHashMap<String, BField> unmappedMembers = this.populateAndGetPossibleFieldsForRecVar(pos, possibleTypes, intersectionFields, recordSymbol, env);
            LinkedHashMap<String, BField> optionalFields = new LinkedHashMap<String, BField>(){
                {
                    possibleRecordFieldMapList.forEach((? super T map) -> this.putAll(map));
                }
            };
            intersectionFields.forEach(optionalFields::remove);
            boundedFields.keySet().forEach(unmappedMembers::remove);
            for (BField field : optionalFields.values()) {
                field.symbol.flags = this.setSymbolAsOptional(field.symbol.flags);
            }
            unmappedMembers.putAll((Map<String, BField>)optionalFields);
            BRecordType restRecord = new BRecordType(this.symTable.typeEnv(), null);
            restRecord.fields = unmappedMembers;
            restRecord.restFieldType = restFieldType;
            restFieldType = restRecord;
        }
        return restFieldType;
    }

    private List<String> getIntersectionFields(List<LinkedHashMap<String, BField>> fieldList) {
        LinkedHashMap<String, BField> intersectionMap = fieldList.get(0);
        HashSet<String> intersectionSet = new HashSet<String>(intersectionMap.keySet());
        for (int i = 1; i < fieldList.size(); ++i) {
            LinkedHashMap<String, BField> map = fieldList.get(i);
            HashSet<String> set = new HashSet<String>(map.keySet());
            intersectionSet.retainAll(set);
        }
        return new ArrayList<String>(intersectionSet);
    }

    private LinkedHashMap<String, BField> populateAndGetPossibleFieldsForRecVar(Location pos, List<BType> possibleTypes, List<String> fieldNames, BSymbol recordSymbol, SymbolEnv env) {
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        for (String fieldName : fieldNames) {
            LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
            for (BType possibleType : possibleTypes) {
                BType referredPossibleType = Types.getImpliedType(possibleType);
                if (referredPossibleType.tag == 12) {
                    BRecordType possibleRecordType = (BRecordType)referredPossibleType;
                    if (possibleRecordType.fields.containsKey(fieldName)) {
                        BField field = (BField)possibleRecordType.fields.get(fieldName);
                        if (Symbols.isOptional(field.symbol)) {
                            memberTypes.add(this.symTable.nilType);
                        }
                        memberTypes.add(field.type);
                        continue;
                    }
                    memberTypes.add(possibleRecordType.restFieldType);
                    memberTypes.add(this.symTable.nilType);
                    continue;
                }
                if (referredPossibleType.tag == 16) {
                    BMapType possibleMapType = (BMapType)referredPossibleType;
                    memberTypes.add(possibleMapType.constraint);
                    continue;
                }
                memberTypes.add(possibleType);
            }
            BType fieldType = memberTypes.size() > 1 ? BUnionType.create(this.symTable.typeEnv(), null, memberTypes) : (BType)memberTypes.iterator().next();
            BField field = new BField(Names.fromString(fieldName), pos, new BVarSymbol(0L, Names.fromString(fieldName), env.enclPkg.symbol.pkgID, fieldType, recordSymbol, pos, SymbolOrigin.SOURCE));
            fields.put(field.name.value, field);
        }
        return fields;
    }

    private BRecordType createSameTypedFieldsRecordType(BLangRecordVariable recordVar, BType fieldTypes, SymbolEnv env) {
        BType fieldType = fieldTypes.isNullable() ? fieldTypes : BUnionType.create(this.symTable.typeEnv(), null, fieldTypes, this.symTable.nilType);
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(2048L, Names.fromString(ANONYMOUS_RECORD_NAME), env.enclPkg.symbol.pkgID, null, env.scope.owner, recordVar.pos, SymbolOrigin.SOURCE);
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        for (BLangRecordVariable.BLangRecordVariableKeyValue bLangRecordVariableKeyValue : recordVar.variableList) {
            Name fieldName = this.names.fromIdNode(bLangRecordVariableKeyValue.key);
            BField bField = new BField(fieldName, recordVar.pos, new BVarSymbol(0L, fieldName, this.names.originalNameFromIdNode(bLangRecordVariableKeyValue.key), env.enclPkg.symbol.pkgID, fieldType, (BSymbol)recordSymbol, recordVar.pos, SymbolOrigin.SOURCE));
            fields.put(fieldName.getValue(), bField);
        }
        BRecordType recordVarType = (BRecordType)this.symTable.recordType;
        recordVarType.fields = fields;
        recordSymbol.type = recordVarType;
        recordVarType.tsymbol = recordSymbol;
        recordVarType.sealed = false;
        recordVarType.restFieldType = fieldTypes;
        return recordVarType;
    }

    private boolean defineVariableList(BLangRecordVariable recordVar, BRecordType recordVarType, SymbolEnv env) {
        LinkedHashMap recordVarTypeFields = recordVarType.fields;
        boolean validRecord = true;
        int ignoredCount = 0;
        for (BLangRecordVariable.BLangRecordVariableKeyValue variable : recordVar.variableList) {
            BField field;
            BLangVariable value = variable.getValue();
            String key = variable.key.value;
            if (value.getKind() == NodeKind.VARIABLE) {
                BLangSimpleVariable simpleVar = (BLangSimpleVariable)value;
                Name varName = this.names.fromIdNode(simpleVar.name);
                if (varName == Names.IGNORE) {
                    ++ignoredCount;
                    simpleVar.setBType(this.symTable.anyType);
                    if (!recordVarTypeFields.containsKey(key) || this.types.isAssignable(((BField)recordVarTypeFields.get((Object)key)).type, this.symTable.anyType)) continue;
                    this.dlog.error(variable.valueBindingPattern.pos, DiagnosticErrorCode.WILD_CARD_BINDING_PATTERN_ONLY_SUPPORTS_TYPE_ANY, new Object[0]);
                    continue;
                }
            }
            if (Types.getImpliedType((BType)recordVar.getBType()).tag == 16) {
                validRecord = false;
                this.dlog.error(variable.key.pos, DiagnosticErrorCode.INVALID_FIELD_BINDING_PATTERN_WITH_NON_REQUIRED_FIELD, new Object[0]);
            }
            if ((field = (BField)recordVarTypeFields.get(key)) == null) {
                validRecord = false;
                if (recordVarType.sealed) {
                    this.dlog.error(recordVar.pos, DiagnosticErrorCode.INVALID_FIELD_IN_RECORD_BINDING_PATTERN, key, recordVar.getBType());
                    continue;
                }
                this.dlog.error(variable.key.pos, DiagnosticErrorCode.INVALID_FIELD_BINDING_PATTERN_WITH_NON_REQUIRED_FIELD, new Object[0]);
                continue;
            }
            BType fieldType = Symbols.isOptional(field.symbol) ? this.types.addNilForNillableAccessType(field.type) : field.type;
            this.defineMemberNode(value, env, fieldType);
        }
        if (!recordVar.variableList.isEmpty() && ignoredCount == recordVar.variableList.size() && recordVar.restParam == null) {
            this.dlog.error(recordVar.pos, DiagnosticErrorCode.NO_NEW_VARIABLES_VAR_ASSIGNMENT, new Object[0]);
            return false;
        }
        if (recordVar.restParam != null) {
            BType restType = this.getRestParamType(recordVarType);
            List<String> varList = recordVar.variableList.stream().map(t -> t.getKey().value).toList();
            BRecordType restConstraint = this.createRecordTypeForRestField(recordVar.restParam.getPosition(), env, recordVarType, varList, restType);
            this.defineMemberNode(recordVar.restParam, env, restConstraint);
        }
        return validRecord;
    }

    private boolean doesRecordContainKeys(BType varType, List<BLangRecordVariable.BLangRecordVariableKeyValue> variableList, boolean hasRestParam) {
        varType = Types.getImpliedType(varType);
        if (varType.tag == 16 || varType.tag == 18 || varType.tag == 11) {
            return true;
        }
        if (varType.tag != 12) {
            return false;
        }
        BRecordType recordVarType = (BRecordType)varType;
        LinkedHashMap recordVarTypeFields = recordVarType.fields;
        for (BLangRecordVariable.BLangRecordVariableKeyValue var : variableList) {
            if (recordVarTypeFields.containsKey(var.key.value) || !recordVarType.sealed) continue;
            return false;
        }
        if (!hasRestParam) {
            return true;
        }
        return !recordVarType.sealed;
    }

    public BRecordTypeSymbol createAnonRecordSymbol(SymbolEnv env, Location pos) {
        EnumSet<Flag> flags = EnumSet.of(Flag.PUBLIC, Flag.ANONYMOUS);
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(Flags.asMask(flags), Names.EMPTY, env.enclPkg.packageID, null, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        recordSymbol.name = Names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(env.enclPkg.packageID));
        recordSymbol.scope = new Scope(recordSymbol);
        return recordSymbol;
    }

    BType getRestParamType(BRecordType recordType) {
        if (recordType.restFieldType != null) {
            BType memberType = recordType.restFieldType;
            BType referredMemberType = Types.getImpliedType(memberType);
            if (referredMemberType.tag == 12) {
                return this.getRestParamType((BRecordType)referredMemberType);
            }
            return memberType;
        }
        SemType s = recordType.semType();
        SemType anydata = this.types.anydata();
        if (SemTypes.containsBasicType((SemType)s, (BasicTypeBitSet)PredefinedType.ERROR)) {
            if (this.types.isSubtype(s, Core.union((SemType)anydata, (SemType)PredefinedType.ERROR))) {
                return this.symTable.pureType;
            }
            return BUnionType.create(this.symTable.typeEnv(), null, this.symTable.anyType, this.symTable.errorType);
        }
        if (this.types.isSubtype(s, anydata)) {
            return this.symTable.anydataType;
        }
        return this.symTable.anyType;
    }

    public BType getRestMatchPatternConstraintType(BRecordType recordType, Map<String, BField> remainingFields, BType restVarSymbolMapType) {
        BType restFieldType;
        LinkedHashSet<BType> constraintTypes = new LinkedHashSet<BType>();
        for (BField field : remainingFields.values()) {
            constraintTypes.add(field.type);
        }
        if (!recordType.sealed && !this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(restFieldType = recordType.restFieldType)) {
            constraintTypes.add(restFieldType);
        }
        BType restConstraintType = constraintTypes.isEmpty() ? this.symTable.neverType : (constraintTypes.size() == 1 ? (BType)constraintTypes.iterator().next() : BUnionType.create(this.symTable.typeEnv(), null, constraintTypes));
        return restVarSymbolMapType.tag == 24 ? restConstraintType : this.types.mergeTypes(restVarSymbolMapType, restConstraintType);
    }

    BRecordType createRecordTypeForRestField(Location pos, SymbolEnv env, final BRecordType recordType, List<String> variableList, BType restConstraint) {
        BRecordTypeSymbol recordSymbol = this.createAnonRecordSymbol(env, pos);
        BRecordType recordVarType = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)recordSymbol);
        recordSymbol.type = recordVarType;
        LinkedHashMap<String, BField> unMappedFields = new LinkedHashMap<String, BField>(){
            {
                this.putAll(recordType.fields);
                BType referredRestFieldType = Types.getImpliedType(recordType.restFieldType);
                if (referredRestFieldType.tag == 12) {
                    this.putAll(((BRecordType)referredRestFieldType).fields);
                }
            }
        };
        if (recordType.sealed && restConstraint.tag == 24) {
            this.setRestRecordFields(pos, env, unMappedFields, variableList, null, recordVarType);
        } else {
            this.setRestRecordFields(pos, env, unMappedFields, variableList, restConstraint, recordVarType);
        }
        BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(recordVarType, env.enclPkg.packageID, this.symTable, pos);
        TypeDefBuilderHelper.createTypeDefinitionForTSymbol(recordVarType, recordSymbol, recordTypeNode, env);
        return recordVarType;
    }

    void setRestRecordFields(Location pos, SymbolEnv env, LinkedHashMap<String, BField> unMappedFields, List<String> variableList, BType restConstraint, BRecordType targetRestRecType) {
        BField newField;
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        LinkedHashMap<String, BField> markAsOptional = new LinkedHashMap<String, BField>();
        if (!targetRestRecType.fields.isEmpty()) {
            fields.putAll(targetRestRecType.fields);
            List<String> intersectionFields = this.getIntersectionFields(Arrays.asList(targetRestRecType.fields, unMappedFields));
            markAsOptional.putAll(unMappedFields);
            markAsOptional.putAll(targetRestRecType.fields);
            intersectionFields.forEach(markAsOptional::remove);
        }
        for (String fieldName : variableList) {
            unMappedFields.remove(fieldName);
            newField = new BField(Names.fromString(fieldName), pos, new BVarSymbol(4096L, Names.fromString(fieldName), env.enclPkg.symbol.pkgID, this.symTable.neverType, targetRestRecType.tsymbol, pos, SymbolOrigin.VIRTUAL));
            fields.put(fieldName, newField);
        }
        for (BField field : unMappedFields.values()) {
            if (fields.containsKey(field.name.value)) {
                BField targetField = (BField)fields.get(field.getName().value);
                targetField.type = this.types.mergeTypes(targetField.type, field.type);
                continue;
            }
            newField = new BField(field.name, pos, new BVarSymbol(field.symbol.flags, field.name, env.enclPkg.symbol.pkgID, field.type, targetRestRecType.tsymbol, pos, SymbolOrigin.VIRTUAL));
            fields.put(field.name.value, newField);
            targetRestRecType.tsymbol.scope.define(newField.name, newField.symbol);
        }
        for (BField optionalField : markAsOptional.values()) {
            optionalField.symbol.flags = this.setSymbolAsOptional(optionalField.symbol.flags);
        }
        targetRestRecType.fields = fields;
        if (restConstraint == null) {
            targetRestRecType.restFieldType = new BNoType(24);
            targetRestRecType.sealed = true;
        } else {
            targetRestRecType.restFieldType = restConstraint;
        }
    }

    private long setSymbolAsOptional(long existingFlags) {
        Set<Flag> unmaskedFlags = Flags.unMask(existingFlags);
        unmaskedFlags.remove((Object)Flag.REQUIRED);
        unmaskedFlags.add(Flag.OPTIONAL);
        return Flags.asMask(unmaskedFlags);
    }

    @Override
    public void visit(BLangErrorVariable errorVar) {
        if (errorVar.isDeclaredWithVar) {
            BLangVariable cause;
            errorVar.symbol = this.defineVarSymbol(errorVar.pos, errorVar.flagSet, this.symTable.noType, Names.fromString(this.anonymousModelHelper.getNextErrorVarKey(this.env.enclPkg.packageID)), this.env, true);
            BLangSimpleVariable errorMsg = errorVar.message;
            if (errorMsg != null) {
                errorMsg.isDeclaredWithVar = true;
                this.defineNode(errorMsg, this.env);
            }
            if ((cause = errorVar.cause) != null) {
                cause.isDeclaredWithVar = true;
                this.defineNode(cause, this.env);
            }
            for (BLangErrorVariable.BLangErrorDetailEntry detailEntry : errorVar.detail) {
                BLangVariable value = detailEntry.getValue();
                value.isDeclaredWithVar = true;
                this.defineNode(value, this.env);
            }
            BLangSimpleVariable restDetail = errorVar.restDetail;
            if (restDetail != null) {
                restDetail.isDeclaredWithVar = true;
                this.defineNode(restDetail, this.env);
            }
            return;
        }
        if (errorVar.getBType() == null) {
            errorVar.setBType(this.symResolver.resolveTypeNode(errorVar.typeNode, this.env));
        }
        if (!this.symbolEnterAndValidateErrorVariable(errorVar, this.env)) {
            errorVar.setBType(this.symTable.semanticError);
            return;
        }
    }

    boolean symbolEnterAndValidateErrorVariable(BLangErrorVariable var, SymbolEnv env) {
        if (var.symbol == null) {
            Name varName = Names.fromString(this.anonymousModelHelper.getNextErrorVarKey(env.enclPkg.packageID));
            var.symbol = this.defineVarSymbol(var.pos, var.flagSet, var.getBType(), varName, env, true);
        }
        return this.validateErrorVariable(var, env);
    }

    boolean validateErrorVariable(BLangErrorVariable errorVariable, SymbolEnv env) {
        BErrorType errorType;
        BType varType = Types.getImpliedType(errorVariable.getBType());
        switch (varType.tag) {
            case 21: {
                BUnionType unionType = (BUnionType)varType;
                List<BErrorType> possibleTypes = this.types.getAllTypes(unionType, true).stream().filter(type -> 29 == Types.getImpliedType((BType)type).tag).map(BErrorType.class::cast).toList();
                if (possibleTypes.isEmpty()) {
                    this.dlog.error(errorVariable.pos, DiagnosticErrorCode.INVALID_ERROR_BINDING_PATTERN, varType);
                    return false;
                }
                if (possibleTypes.size() > 1) {
                    LinkedHashSet<BType> detailType = new LinkedHashSet<BType>();
                    for (BErrorType possibleErrType : possibleTypes) {
                        detailType.add(possibleErrType.detailType);
                    }
                    BType errorDetailType = detailType.size() > 1 ? BUnionType.create(this.symTable.typeEnv(), null, detailType) : (BType)detailType.iterator().next();
                    errorType = new BErrorType(this.symTable.typeEnv(), null, errorDetailType);
                    break;
                }
                errorType = possibleTypes.get(0);
                break;
            }
            case 29: {
                errorType = (BErrorType)varType;
                break;
            }
            case 28: {
                return false;
            }
            default: {
                this.dlog.error(errorVariable.pos, DiagnosticErrorCode.INVALID_ERROR_BINDING_PATTERN, varType);
                return false;
            }
        }
        errorVariable.setBType(errorType);
        if (!errorVariable.isInMatchStmt) {
            BLangVariable errorCause;
            BLangSimpleVariable errorMsg = errorVariable.message;
            if (errorMsg != null) {
                this.defineMemberNode(errorVariable.message, env, this.symTable.stringType);
            }
            if ((errorCause = errorVariable.cause) != null) {
                if (errorCause.getKind() == NodeKind.VARIABLE && this.names.fromIdNode(((BLangSimpleVariable)errorCause).name) == Names.IGNORE) {
                    this.dlog.error(errorCause.pos, DiagnosticErrorCode.CANNOT_USE_WILDCARD_BINDING_PATTERN_FOR_ERROR_CAUSE, new Object[0]);
                    return false;
                }
                this.defineMemberNode(errorCause, env, this.symTable.errorOrNilType);
            }
        }
        if (errorVariable.detail == null || errorVariable.detail.isEmpty() && !this.isRestDetailBindingAvailable(errorVariable)) {
            return this.validateErrorMessageMatchPatternSyntax(errorVariable, env);
        }
        BType detailType = Types.getImpliedType(errorType.detailType);
        if (detailType.getKind() == TypeKind.RECORD || detailType.getKind() == TypeKind.MAP) {
            return this.validateErrorVariable(errorVariable, errorType, env);
        }
        if (detailType.getKind() == TypeKind.UNION) {
            BErrorTypeSymbol errorTypeSymbol = new BErrorTypeSymbol(294940L, 1L, Names.ERROR, env.enclPkg.packageID, this.symTable.errorType, env.scope.owner, errorVariable.pos, SymbolOrigin.SOURCE);
            errorVariable.setBType(new BErrorType(this.symTable.typeEnv(), (BTypeSymbol)errorTypeSymbol, this.symTable.detailType));
            return this.validateErrorVariable(errorVariable, env);
        }
        if (this.isRestDetailBindingAvailable(errorVariable)) {
            this.defineMemberNode(errorVariable.restDetail, env, this.symTable.detailType);
        }
        return true;
    }

    private boolean validateErrorVariable(BLangErrorVariable errorVariable, BErrorType errorType, SymbolEnv env) {
        BLangSimpleVariable errorMsg = errorVariable.message;
        if (errorMsg != null && errorMsg.symbol == null) {
            this.defineMemberNode(errorMsg, env, this.symTable.stringType);
        }
        BRecordType recordType = this.getDetailAsARecordType(errorType);
        LinkedHashMap detailFields = recordType.fields;
        HashSet<String> matchedDetailFields = new HashSet<String>();
        for (BLangErrorVariable.BLangErrorDetailEntry errorDetailEntry : errorVariable.detail) {
            boolean isIgnoredVar;
            String entryName = errorDetailEntry.key.getValue();
            matchedDetailFields.add(entryName);
            BField entryField = (BField)detailFields.get(entryName);
            BLangVariable boundVar = errorDetailEntry.valueBindingPattern;
            if (entryField != null) {
                if ((entryField.symbol.flags & 0x1000L) == 4096L) {
                    boundVar.setBType(BUnionType.create(this.symTable.typeEnv(), null, entryField.type, this.symTable.nilType));
                } else {
                    boundVar.setBType(entryField.type);
                }
                errorDetailEntry.keySymbol = entryField.symbol;
            } else {
                if (recordType.sealed) {
                    this.dlog.error(errorVariable.pos, DiagnosticErrorCode.INVALID_ERROR_BINDING_PATTERN, errorVariable.getBType());
                    boundVar.setBType(this.symTable.semanticError);
                    return false;
                }
                boundVar.setBType(BUnionType.create(this.symTable.typeEnv(), null, recordType.restFieldType, this.symTable.nilType));
            }
            if (isIgnoredVar = boundVar.getKind() == NodeKind.VARIABLE && ((BLangSimpleVariable)boundVar).name.value.equals(Names.IGNORE.value)) continue;
            this.defineMemberNode(boundVar, env, boundVar.getBType());
        }
        if (this.isRestDetailBindingAvailable(errorVariable)) {
            BTypeSymbol typeSymbol = this.createTypeSymbol(12L, env);
            BType constraint = this.getRestMapConstraintType(detailFields, matchedDetailFields, recordType);
            BMapType restType = new BMapType(this.symTable.typeEnv(), 16, constraint, typeSymbol);
            typeSymbol.type = restType;
            errorVariable.restDetail.setBType(restType);
            this.defineMemberNode(errorVariable.restDetail, env, restType);
        }
        return true;
    }

    BRecordType getDetailAsARecordType(BErrorType errorType) {
        BType detailType = Types.getImpliedType(errorType.detailType);
        if (detailType.getKind() == TypeKind.RECORD) {
            return (BRecordType)detailType;
        }
        BRecordType detailRecord = new BRecordType(this.symTable.typeEnv(), null);
        BMapType detailMap = (BMapType)detailType;
        detailRecord.sealed = false;
        detailRecord.restFieldType = detailMap.constraint;
        return detailRecord;
    }

    private BType getRestMapConstraintType(Map<String, BField> errorDetailFields, Set<String> matchedDetailFields, BRecordType recordType) {
        BUnionType restUnionType = BUnionType.create(this.symTable.typeEnv(), null, new BType[0]);
        if (!recordType.sealed) {
            BType referredRestFieldType = Types.getImpliedType(recordType.restFieldType);
            if (referredRestFieldType.tag == 21) {
                BUnionType bUnionType = (BUnionType)referredRestFieldType;
                if (bUnionType.isCyclic && errorDetailFields.entrySet().isEmpty()) {
                    restUnionType.isCyclic = true;
                    restUnionType.tsymbol = bUnionType.tsymbol;
                }
            } else {
                restUnionType.add(recordType.restFieldType);
            }
        }
        for (Map.Entry entry : errorDetailFields.entrySet()) {
            BType type;
            if (matchedDetailFields.contains(entry.getKey()) || this.types.isAssignable(type = ((BField)entry.getValue()).getType(), restUnionType)) continue;
            restUnionType.add(type);
        }
        Set memberTypes = restUnionType.getMemberTypes();
        if (memberTypes.size() == 1) {
            return (BType)memberTypes.iterator().next();
        }
        return restUnionType;
    }

    private boolean validateErrorMessageMatchPatternSyntax(BLangErrorVariable errorVariable, SymbolEnv env) {
        if (errorVariable.isInMatchStmt && !errorVariable.reasonVarPrefixAvailable && errorVariable.reasonMatchConst == null && this.isReasonSpecified(errorVariable)) {
            BSymbol reasonConst = this.symResolver.lookupSymbolInMainSpace(env.enclEnv, Names.fromString(errorVariable.message.name.value));
            if ((reasonConst.tag & 0x100001CL) != 0x100001CL) {
                this.dlog.error(errorVariable.message.pos, DiagnosticErrorCode.INVALID_ERROR_REASON_BINDING_PATTERN, errorVariable.message.name);
            } else {
                this.dlog.error(errorVariable.message.pos, DiagnosticErrorCode.UNSUPPORTED_ERROR_REASON_CONST_MATCH, new Object[0]);
            }
            return false;
        }
        return true;
    }

    private boolean isReasonSpecified(BLangErrorVariable errorVariable) {
        return !this.isIgnoredOrEmpty(errorVariable.message);
    }

    boolean isIgnoredOrEmpty(BLangSimpleVariable varNode) {
        return varNode.name.value.equals(Names.IGNORE.value) || varNode.name.value.isEmpty();
    }

    private boolean isRestDetailBindingAvailable(BLangErrorVariable errorVariable) {
        return errorVariable.restDetail != null && !errorVariable.restDetail.name.value.equals(Names.IGNORE.value);
    }

    private BTypeSymbol createTypeSymbol(long type, SymbolEnv env) {
        return new BTypeSymbol(type, 1L, Names.EMPTY, env.enclPkg.packageID, null, env.scope.owner, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
    }

    private void defineMemberNode(BLangVariable memberVar, SymbolEnv env, BType type) {
        memberVar.setBType(type);
        if ((env.scope.owner.tag & 0x1001L) == 4097L && memberVar.isDeclaredWithVar) {
            memberVar.symbol.type = type;
            memberVar.isDeclaredWithVar = false;
            if (memberVar.getKind() == NodeKind.VARIABLE) {
                return;
            }
        }
        this.defineNode(memberVar, env);
    }

    @Override
    public void visit(BLangXMLAttribute bLangXMLAttribute) {
        Name prefix;
        BXMLNSSymbol xmlnsSymbol;
        String symbolName;
        if (bLangXMLAttribute.name.getKind() != NodeKind.XML_QNAME) {
            return;
        }
        BLangXMLQName qname = (BLangXMLQName)bLangXMLAttribute.name;
        if (!bLangXMLAttribute.isNamespaceDeclr) {
            BXMLAttributeSymbol attrSymbol = new BXMLAttributeSymbol(qname.localname.value, qname.namespaceURI, this.env.enclPkg.symbol.pkgID, this.env.scope.owner, bLangXMLAttribute.pos, SymbolOrigin.SOURCE);
            if (this.missingNodesHelper.isMissingNode(qname.localname.value) || qname.namespaceURI != null && this.missingNodesHelper.isMissingNode(qname.namespaceURI)) {
                attrSymbol.origin = SymbolOrigin.VIRTUAL;
            }
            if (this.symResolver.checkForUniqueMemberSymbol(bLangXMLAttribute.pos, this.env, attrSymbol)) {
                this.env.scope.define(attrSymbol.name, attrSymbol);
                bLangXMLAttribute.symbol = attrSymbol;
            }
            return;
        }
        List<BLangExpression> exprs = bLangXMLAttribute.value.textFragments;
        String nsURI = null;
        NodeKind nodeKind = exprs.get(0).getKind();
        if (exprs.size() == 1 && (nodeKind == NodeKind.LITERAL || nodeKind == NodeKind.NUMERIC_LITERAL)) {
            nsURI = (String)((BLangLiteral)exprs.get((int)0)).value;
        }
        if ((symbolName = qname.localname.value).equals("xmlns")) {
            symbolName = "";
        }
        if (this.symResolver.checkForUniqueMemberSymbol(bLangXMLAttribute.pos, this.env, xmlnsSymbol = new BXMLNSSymbol(prefix = Names.fromString(symbolName), nsURI, this.env.enclPkg.symbol.pkgID, this.env.scope.owner, qname.localname.pos, this.getOrigin(prefix)))) {
            this.env.scope.define(xmlnsSymbol.name, xmlnsSymbol);
            bLangXMLAttribute.symbol = xmlnsSymbol;
        }
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        recordTypeNode.typeDefEnv = SymbolEnv.createTypeEnv(recordTypeNode, recordTypeNode.symbol.scope, this.env);
        this.defineRecordTypeNode(recordTypeNode);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        for (BLangType type : unionTypeNode.memberTypeNodes) {
            this.defineNode(type, this.env);
        }
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
        for (BLangType type : intersectionTypeNode.constituentTypeNodes) {
            this.defineNode(type, this.env);
        }
    }

    private void defineRecordTypeNode(BLangRecordTypeNode recordTypeNode) {
        BRecordType recordType = (BRecordType)recordTypeNode.symbol.type;
        recordTypeNode.setBType(recordType);
        this.resolveFields(recordType, recordTypeNode);
        this.resolveFieldsIncluded(recordType, recordTypeNode);
        recordType.sealed = recordTypeNode.sealed;
        if (recordTypeNode.sealed && recordTypeNode.restFieldType != null) {
            this.dlog.error(recordTypeNode.restFieldType.pos, DiagnosticErrorCode.REST_FIELD_NOT_ALLOWED_IN_CLOSED_RECORDS, new Object[0]);
            return;
        }
        ArrayList<BType> fieldTypes = new ArrayList<BType>(recordType.fields.size());
        for (BField field : recordType.fields.values()) {
            BType type = field.type;
            fieldTypes.add(type);
        }
        if (recordTypeNode.restFieldType == null) {
            this.symResolver.markParameterizedType((BType)recordType, fieldTypes);
            if (recordTypeNode.sealed) {
                recordType.restFieldType = this.symTable.noType;
                return;
            }
            recordType.restFieldType = this.symTable.anydataType;
            return;
        }
        recordType.restFieldType = this.symResolver.resolveTypeNode(recordTypeNode.restFieldType, this.env);
        fieldTypes.add(recordType.restFieldType);
        this.symResolver.markParameterizedType((BType)recordType, fieldTypes);
    }

    private Collector<BField, ?, LinkedHashMap<String, BField>> getFieldCollector() {
        BinaryOperator mergeFunc = (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
        return Collectors.toMap(field -> field.name.value, Function.identity(), mergeFunc, LinkedHashMap::new);
    }

    private void populateLangLibInSymTable(BPackageSymbol packageSymbol) {
        PackageID langLib = packageSymbol.pkgID;
        if (langLib.equals(PackageID.ARRAY)) {
            this.symTable.langArrayModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.DECIMAL)) {
            this.symTable.langDecimalModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.ERROR)) {
            this.symTable.langErrorModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.FLOAT)) {
            this.symTable.langFloatModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.FUNCTION)) {
            this.symTable.langFunctionModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.FUTURE)) {
            this.symTable.langFutureModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.INT)) {
            this.symTable.langIntModuleSymbol = packageSymbol;
            this.symTable.updateIntSubtypeOwners();
            return;
        }
        if (langLib.equals(PackageID.MAP)) {
            this.symTable.langMapModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.NATURAL)) {
            this.symTable.langNaturalModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.OBJECT)) {
            this.symTable.langObjectModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.STREAM)) {
            this.symTable.langStreamModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.STRING)) {
            this.symTable.langStringModuleSymbol = packageSymbol;
            this.symTable.updateStringSubtypeOwners();
            return;
        }
        if (langLib.equals(PackageID.TABLE)) {
            this.symTable.langTableModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.TYPEDESC)) {
            this.symTable.langTypedescModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.VALUE)) {
            this.symTable.langValueModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.XML)) {
            this.symTable.langXmlModuleSymbol = packageSymbol;
            this.symTable.updateXMLSubtypeOwners();
            return;
        }
        if (langLib.equals(PackageID.BOOLEAN)) {
            this.symTable.langBooleanModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.QUERY)) {
            this.symTable.langQueryModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.TRANSACTION)) {
            this.symTable.langTransactionModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.REGEXP)) {
            this.symTable.langRegexpModuleSymbol = packageSymbol;
            this.symTable.updateRegExpTypeOwners();
            return;
        }
    }

    public boolean isValidAnnotationType(BType type) {
        SemType memberTy;
        SemType t = type.semType();
        if (SemTypes.isSubtype((Context)this.types.semTypeCtx, (SemType)t, (SemType)this.symTable.trueType.semType())) {
            return true;
        }
        SemType cloneable = Core.createCloneable((Context)this.types.semTypeCtx);
        if (SemTypes.isSubtypeSimple((SemType)t, (BasicTypeBitSet)PredefinedType.MAPPING)) {
            return SemTypes.isSubtype((Context)this.types.semTypeCtx, (SemType)t, (SemType)cloneable);
        }
        if (SemTypes.isSubtypeSimple((SemType)t, (BasicTypeBitSet)PredefinedType.LIST) && SemTypes.isSubtypeSimple((SemType)(memberTy = Core.listMemberTypeInnerVal((Context)this.types.semTypeCtx, (SemType)t, (SemType)PredefinedType.INT)), (BasicTypeBitSet)PredefinedType.MAPPING)) {
            return SemTypes.isSubtype((Context)this.types.semTypeCtx, (SemType)memberTy, (SemType)cloneable);
        }
        return false;
    }

    private void populatePackageNode(BLangPackage pkgNode) {
        List<BLangCompilationUnit> compUnits = pkgNode.getCompilationUnits();
        compUnits.forEach(compUnit -> this.populateCompilationUnit(pkgNode, (BLangCompilationUnit)compUnit));
    }

    private void populateCompilationUnit(BLangPackage pkgNode, BLangCompilationUnit compUnit) {
        compUnit.getTopLevelNodes().forEach(node -> this.addTopLevelNode(pkgNode, (TopLevelNode)node));
    }

    private void addTopLevelNode(BLangPackage pkgNode, TopLevelNode node) {
        NodeKind kind = node.getKind();
        if (kind != NodeKind.PACKAGE_DECLARATION && kind != NodeKind.IMPORT) {
            pkgNode.topLevelNodes.add(node);
        }
        switch (kind) {
            case IMPORT: {
                pkgNode.imports.add((BLangImportPackage)node);
                break;
            }
            case FUNCTION: {
                pkgNode.functions.add((BLangFunction)node);
                break;
            }
            case TYPE_DEFINITION: {
                pkgNode.typeDefinitions.add((BLangTypeDefinition)node);
                break;
            }
            case SERVICE: {
                pkgNode.services.add((BLangService)node);
                break;
            }
            case VARIABLE: 
            case TUPLE_VARIABLE: 
            case RECORD_VARIABLE: 
            case ERROR_VARIABLE: {
                pkgNode.globalVars.add((BLangVariable)node);
                break;
            }
            case ANNOTATION: {
                pkgNode.annotations.add((BLangAnnotation)node);
                break;
            }
            case XMLNS: {
                pkgNode.xmlnsList.add((BLangXMLNS)node);
                break;
            }
            case CONSTANT: {
                pkgNode.constants.add((BLangConstant)node);
                break;
            }
            case CLASS_DEFN: {
                pkgNode.classDefinitions.add((BLangClassDefinition)node);
            }
        }
    }

    private void defineErrorDetails(List<BLangTypeDefinition> typeDefNodes, SymbolEnv pkgEnv) {
        for (BLangTypeDefinition typeDef : typeDefNodes) {
            SymbolEnv typeDefEnv;
            BLangType typeNode = typeDef.typeNode;
            BType referredType = Types.getImpliedType(typeNode.getBType());
            if (typeNode.getKind() == NodeKind.ERROR_TYPE) {
                typeDefEnv = SymbolEnv.createTypeEnv(typeNode, typeDef.symbol.scope, pkgEnv);
                BLangErrorType errorTypeNode = (BLangErrorType)typeNode;
                BType typeDefType = typeDef.symbol.type;
                ((BErrorType)typeDefType).detailType = this.getDetailType(typeDefEnv, errorTypeNode);
                continue;
            }
            if (referredType == null || referredType.tag != 29) continue;
            typeDefEnv = SymbolEnv.createTypeEnv(typeNode, typeDef.symbol.scope, pkgEnv);
            BType detailType = ((BErrorType)referredType).detailType;
            if (detailType != this.symTable.noType) continue;
            BType resolvedType = this.symResolver.resolveTypeNode(typeNode, typeDefEnv);
            BErrorType type = (BErrorType)Types.getImpliedType(resolvedType);
            ((BErrorType)Types.getImpliedType((BType)typeDef.symbol.type)).detailType = type.detailType;
        }
    }

    private BType getDetailType(SymbolEnv typeDefEnv, BLangErrorType errorTypeNode) {
        BLangType constraint;
        BLangType detailType = errorTypeNode.detailType;
        if (detailType != null && detailType.getKind() == NodeKind.CONSTRAINED_TYPE && (constraint = ((BLangConstrainedType)detailType).constraint).getKind() == NodeKind.USER_DEFINED_TYPE) {
            BLangUserDefinedType userDefinedType = (BLangUserDefinedType)constraint;
            if (userDefinedType.typeName.value.equals("$IntersectedErrorDetail$")) {
                errorTypeNode.detailType = null;
                return ((BErrorType)errorTypeNode.getBType()).detailType;
            }
        }
        return Optional.ofNullable(errorTypeNode.detailType).map(bLangType -> this.symResolver.resolveTypeNode((BLangType)bLangType, typeDefEnv)).orElse(this.symTable.detailType);
    }

    public void defineFieldsOfClassDef(BLangClassDefinition classDefinition, SymbolEnv env) {
        SymbolEnv typeDefEnv = SymbolEnv.createClassEnv(classDefinition, classDefinition.symbol.scope, env);
        BObjectTypeSymbol tSymbol = (BObjectTypeSymbol)classDefinition.symbol;
        BObjectType objType = (BObjectType)tSymbol.type;
        if (classDefinition.isObjectContructorDecl) {
            classDefinition.oceEnvData.fieldEnv = typeDefEnv;
        }
        classDefinition.typeDefEnv = typeDefEnv;
        for (BLangSimpleVariable field : classDefinition.fields) {
            this.defineNode(field, typeDefEnv);
            if (field.expr != null) {
                field.symbol.isDefaultable = true;
            }
            if (field.symbol.type == this.symTable.semanticError) continue;
            objType.fields.put(field.name.value, new BField(this.names.fromIdNode(field.name), field.pos, field.symbol));
        }
    }

    public void defineFields(BLangTypeDefinition typeDef, SymbolEnv pkgEnv) {
        SymbolEnv typeDefEnv;
        NodeKind nodeKind = typeDef.typeNode.getKind();
        if (nodeKind != NodeKind.RECORD_TYPE) {
            this.defineNode(typeDef.typeNode, pkgEnv);
            return;
        }
        BStructureType structureType = (BStructureType)typeDef.symbol.type;
        BLangStructureTypeNode structureTypeNode = (BLangStructureTypeNode)typeDef.typeNode;
        if (typeDef.symbol.kind == SymbolKind.TYPE_DEF && structureType.tsymbol.kind == SymbolKind.RECORD) {
            BLangRecordTypeNode recordTypeNode = (BLangRecordTypeNode)structureTypeNode;
            BRecordType recordType = (BRecordType)structureType;
            recordType.sealed = recordTypeNode.sealed;
        }
        Scope recordScope = structureType.tsymbol.scope;
        structureTypeNode.typeDefEnv = typeDefEnv = SymbolEnv.createTypeEnv(structureTypeNode, recordScope, pkgEnv);
        this.resolveFields(structureType, structureTypeNode);
        if (structureTypeNode.typeRefs.isEmpty()) {
            this.defineReferencedFieldsOfRecordTypeDef(typeDef);
        }
    }

    private void resolveFields(BStructureType structureType, BLangStructureTypeNode structureTypeNode) {
        LinkedHashMap<String, BField> result = new LinkedHashMap<String, BField>();
        for (BLangSimpleVariable field : structureTypeNode.fields) {
            this.defineNode(field, structureTypeNode.typeDefEnv);
            Name key = this.names.fromIdNode(field.name);
            BField bField = new BField(key, field.pos, field.symbol);
            if (field.symbol.type == this.symTable.semanticError) {
                result.put(key.value, bField);
                continue;
            }
            field.symbol.isDefaultable = field.expr != null;
            result.put(key.value, bField);
        }
        structureType.fields = result;
    }

    public void defineReferencedFieldsOfRecordTypeDef(BLangTypeDefinition typeDef) {
        if (typeDef.referencedFieldsDefined) {
            return;
        }
        NodeKind nodeKind = typeDef.typeNode.getKind();
        if (nodeKind != NodeKind.OBJECT_TYPE && nodeKind != NodeKind.RECORD_TYPE) {
            return;
        }
        this.resolveReferencedFields(typeDef);
        this.resolveRestField(typeDef);
        typeDef.referencedFieldsDefined = true;
    }

    private void resolveRestField(BLangTypeDefinition typeDef) {
        BStructureType structureType = (BStructureType)typeDef.symbol.type;
        BLangStructureTypeNode structureTypeNode = (BLangStructureTypeNode)typeDef.typeNode;
        if (typeDef.symbol.kind == SymbolKind.TYPE_DEF && structureType.tsymbol.kind != SymbolKind.RECORD) {
            return;
        }
        SymbolEnv typeDefEnv = structureTypeNode.typeDefEnv;
        BLangRecordTypeNode recordTypeNode = (BLangRecordTypeNode)structureTypeNode;
        BRecordType recordType = (BRecordType)structureType;
        recordType.sealed = recordTypeNode.sealed;
        if (recordTypeNode.sealed && recordTypeNode.restFieldType != null) {
            this.dlog.error(recordTypeNode.restFieldType.pos, DiagnosticErrorCode.REST_FIELD_NOT_ALLOWED_IN_CLOSED_RECORDS, new Object[0]);
            return;
        }
        if (recordTypeNode.restFieldType != null) {
            recordType.restFieldType = this.symResolver.resolveTypeNode(recordTypeNode.restFieldType, typeDefEnv);
            return;
        }
        if (!recordTypeNode.sealed) {
            recordType.restFieldType = this.symTable.anydataType;
            return;
        }
        for (BLangType typeRef : recordTypeNode.typeRefs) {
            BType restFieldType;
            BLangTypeDefinition typeDefinition;
            BType refType = Types.getImpliedType(typeRef.getBType());
            if (this.typeResolver.resolvingStructureTypes.contains((BStructureType)refType) && (typeDefinition = this.typeResolver.getTypeDefinition(refType.tsymbol.name.value)) != null) {
                this.resolveRestField(typeDefinition);
            }
            if (refType.tag != 12 || (restFieldType = ((BRecordType)refType).restFieldType) == this.symTable.noType) continue;
            if (recordType.restFieldType != null && !this.types.isSameType(recordType.restFieldType, restFieldType)) {
                recordType.restFieldType = this.symTable.noType;
                this.dlog.error(recordTypeNode.pos, DiagnosticErrorCode.CANNOT_USE_TYPE_INCLUSION_WITH_MORE_THAN_ONE_OPEN_RECORD_WITH_DIFFERENT_REST_DESCRIPTOR_TYPES, new Object[0]);
                return;
            }
            recordType.restFieldType = restFieldType;
            recordType.sealed = false;
        }
        if (recordType.restFieldType != null) {
            return;
        }
        recordType.restFieldType = this.symTable.noType;
    }

    private void resolveReferencedFields(BLangTypeDefinition typeDef) {
        BStructureType structureType = (BStructureType)typeDef.symbol.type;
        BLangStructureTypeNode structureTypeNode = (BLangStructureTypeNode)typeDef.typeNode;
        this.resolveFieldsIncluded(structureType, structureTypeNode);
    }

    private void resolveFieldsIncluded(BStructureType structureType, BLangStructureTypeNode structureTypeNode) {
        this.resolveIncludedFields(structureTypeNode);
        this.populateResolvedTypeRefs(structureType, structureTypeNode);
        this.defineReferencedFields(structureType, structureTypeNode);
    }

    private void populateResolvedTypeRefs(BStructureType structureType, BLangStructureTypeNode structureTypeNode) {
        List<BLangType> typeRefs = structureTypeNode.typeRefs;
        structureType.typeInclusions = new ArrayList<BType>(typeRefs.size());
        for (BLangType tRef : typeRefs) {
            structureType.typeInclusions.add(tRef.getBType());
        }
    }

    private void defineReferencedFields(BStructureType structureType, BLangStructureTypeNode structureTypeNode) {
        SymbolEnv typeDefEnv = structureTypeNode.typeDefEnv;
        for (BLangSimpleVariable field : structureTypeNode.includedFields) {
            this.defineNode(field, typeDefEnv);
            if (field.symbol.type == this.symTable.semanticError) continue;
            structureType.fields.put(field.name.value, new BField(this.names.fromIdNode(field.name), field.pos, field.symbol));
        }
    }

    private void defineFunctions(List<BLangNode> typeDefNodes, SymbolEnv pkgEnv) {
        for (BLangNode node : typeDefNodes) {
            if (node.getKind() == NodeKind.CLASS_DEFN) {
                BLangClassDefinition classDef = (BLangClassDefinition)node;
                if (this.isObjectCtor(classDef)) continue;
                this.defineFunctionsOfClassDef(pkgEnv, classDef);
                continue;
            }
            if (node.getKind() != NodeKind.TYPE_DEFINITION) continue;
            this.defineFunctionsOfObjectTypeDef(pkgEnv, (BLangTypeDefinition)node);
        }
    }

    private void validateInclusionsForNonPrivateMembers(List<BLangType> inclusions) {
        for (BLangType inclusion : inclusions) {
            BType type = Types.getImpliedType(inclusion.getBType());
            if (type.tag != 34) continue;
            BObjectType objectType = (BObjectType)type;
            boolean hasPrivateMember = false;
            for (BField field : objectType.fields.values()) {
                if (!Symbols.isFlagOn(field.symbol.flags, 1024L)) continue;
                hasPrivateMember = true;
                break;
            }
            if (!hasPrivateMember) {
                for (BAttachedFunction method : ((BObjectTypeSymbol)type.tsymbol).attachedFuncs) {
                    if (!Symbols.isFlagOn(method.symbol.flags, 1024L)) continue;
                    hasPrivateMember = true;
                    break;
                }
            }
            if (!hasPrivateMember) continue;
            this.dlog.error(inclusion.pos, DiagnosticErrorCode.INVALID_INCLUSION_OF_OBJECT_WITH_PRIVATE_MEMBERS, new Object[0]);
        }
    }

    private void defineFunctionsOfObjectTypeDef(SymbolEnv pkgEnv, BLangTypeDefinition node) {
        BLangTypeDefinition typeDefinition = node;
        BLangType typeNode = typeDefinition.typeNode;
        if (typeNode.getKind() == NodeKind.OBJECT_TYPE) {
            this.validateInclusionsForNonPrivateMembers(((BLangObjectTypeNode)typeNode).typeRefs);
        }
        BLangTypeDefinition typeDef = node;
        if (typeDef.typeNode.getKind() == NodeKind.OBJECT_TYPE) {
            BObjectType objectType = (BObjectType)typeDef.symbol.type;
            if (objectType.mutableType != null) {
                return;
            }
            BLangObjectTypeNode objTypeNode = (BLangObjectTypeNode)typeDef.typeNode;
            SymbolEnv objMethodsEnv = SymbolEnv.createObjectMethodsEnv(objTypeNode, (BObjectTypeSymbol)objTypeNode.symbol, pkgEnv);
            this.defineObjectInitFunction(objTypeNode, objMethodsEnv);
            objTypeNode.functions.forEach(f -> {
                f.flagSet.add(Flag.FINAL);
                f.setReceiver(ASTBuilderUtil.createReceiver(typeDef.pos, objectType));
                this.defineNode((BLangNode)f, objMethodsEnv);
            });
            HashSet<String> includedFunctionNames = new HashSet<String>();
            for (BLangType typeRef : objTypeNode.typeRefs) {
                if (typeRef.getBType().tsymbol == null) continue;
                BTypeSymbol objectSymbol = Types.getImpliedType((BType)typeRef.getBType()).tsymbol;
                if (objectSymbol.kind != SymbolKind.OBJECT) continue;
                List functions = ((BObjectTypeSymbol)objectSymbol).attachedFuncs;
                for (BAttachedFunction function : functions) {
                    this.defineReferencedFunction(typeDef.pos, typeDef.flagSet, objMethodsEnv, typeRef, function, includedFunctionNames, typeDef.symbol, ((BLangObjectTypeNode)typeDef.typeNode).functions, node.internal);
                }
            }
        }
    }

    private void validateIntersectionTypeDefinitions(List<BLangTypeDefinition> typeDefNodes, PackageID packageID) {
        HashSet<BType> loggedTypes = new HashSet<BType>();
        for (BLangTypeDefinition typeDefNode : typeDefNodes) {
            BStructureType immutableType;
            BStructureType mutableType;
            BLangType typeNode = typeDefNode.typeNode;
            NodeKind kind = typeNode.getKind();
            if (kind == NodeKind.INTERSECTION_TYPE_NODE) {
                BType bType = typeNode.getBType();
                if (bType.tag != 22) continue;
                BIntersectionType intersectionType = (BIntersectionType)bType;
                bType = intersectionType.effectiveType;
                if (this.types.isInherentlyImmutableType(bType) || !loggedTypes.add(bType)) continue;
                boolean hasNonReadOnlyElement = false;
                for (BType constituentType : intersectionType.getConstituentTypes()) {
                    if (Types.getImpliedType(constituentType) == this.symTable.readonlyType || this.types.isInherentlyImmutableType(constituentType) || this.types.isSelectivelyImmutableType(constituentType, true, packageID) || Types.getImpliedType((BType)constituentType).tag == 29) continue;
                    hasNonReadOnlyElement = true;
                    break;
                }
                if (!hasNonReadOnlyElement) continue;
                this.dlog.error(typeDefNode.typeNode.pos, DiagnosticErrorCode.INVALID_INTERSECTION_TYPE, typeNode);
                typeNode.setBType(this.symTable.semanticError);
                continue;
            }
            if (kind == NodeKind.OBJECT_TYPE) {
                currentType = (BObjectType)typeNode.getBType();
                mutableType = currentType.mutableType;
                if (mutableType == null) continue;
                immutableType = currentType;
            } else {
                if (kind != NodeKind.RECORD_TYPE) continue;
                currentType = (BRecordType)typeNode.getBType();
                mutableType = ((BRecordType)currentType).mutableType;
                if (mutableType == null) continue;
                immutableType = currentType;
            }
            if (!loggedTypes.add(immutableType) || this.types.isSelectivelyImmutableType((BType)mutableType, true, packageID)) continue;
            this.dlog.error(typeDefNode.typeNode.pos, DiagnosticErrorCode.INVALID_INTERSECTION_TYPE, typeDefNode.name);
            typeNode.setBType(this.symTable.semanticError);
        }
    }

    private void defineUndefinedReadOnlyTypes(List<BLangTypeDefinition> typeDefNodes, List<BLangNode> typeDefs, SymbolEnv pkgEnv) {
        this.populateImmutableTypeFieldsAndMembers(typeDefNodes, pkgEnv);
        this.validateFieldsAndSetReadOnlyType(typeDefs, pkgEnv);
        this.defineReadOnlyInclusions(typeDefs, pkgEnv);
    }

    private void populateImmutableTypeFieldsAndMembers(List<BLangTypeDefinition> typeDefNodes, SymbolEnv pkgEnv) {
        for (BLangTypeDefinition typeDef : typeDefNodes) {
            NodeKind nodeKind = typeDef.typeNode.getKind();
            if (nodeKind == NodeKind.OBJECT_TYPE ? ((BObjectType)typeDef.symbol.type).mutableType == null : nodeKind != NodeKind.RECORD_TYPE || ((BRecordType)typeDef.symbol.type).mutableType == null) continue;
            SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(typeDef.typeNode, typeDef.symbol.scope, pkgEnv);
            ImmutableTypeCloner.defineUndefinedImmutableFields(typeDef, this.types, typeDefEnv, this.symTable, this.anonymousModelHelper, this.names);
            if (nodeKind != NodeKind.OBJECT_TYPE) continue;
            BObjectType immutableObjectType = (BObjectType)typeDef.symbol.type;
            BObjectType mutableObjectType = immutableObjectType.mutableType;
            ImmutableTypeCloner.defineObjectFunctions((BObjectTypeSymbol)immutableObjectType.tsymbol, (BObjectTypeSymbol)mutableObjectType.tsymbol, this.names, this.symTable);
        }
    }

    private void validateFieldsAndSetReadOnlyType(List<BLangNode> typeDefNodes, SymbolEnv pkgEnv) {
        for (BLangNode typeDefOrClass : typeDefNodes) {
            if (typeDefOrClass.getKind() == NodeKind.CLASS_DEFN) {
                BLangClassDefinition classDefinition = (BLangClassDefinition)typeDefOrClass;
                if (this.isObjectCtor(classDefinition)) continue;
                this.setReadOnlynessOfClassDef(classDefinition, pkgEnv);
                continue;
            }
            if (typeDefOrClass.getKind() != NodeKind.TYPE_DEFINITION) continue;
            BLangTypeDefinition typeDef = (BLangTypeDefinition)typeDefOrClass;
            BLangType typeNode = typeDef.typeNode;
            NodeKind nodeKind = typeNode.getKind();
            if (nodeKind != NodeKind.OBJECT_TYPE && nodeKind != NodeKind.RECORD_TYPE) continue;
            BSymbol symbol = typeDef.symbol;
            BStructureType structureType = (BStructureType)Types.getImpliedType(symbol.type);
            if (Symbols.isFlagOn(structureType.getFlags(), 32L)) {
                if (structureType.tag != 34) continue;
                BObjectType objectType = (BObjectType)structureType;
                if (objectType.mutableType != null) continue;
                Location pos = typeDef.pos;
                if (!this.types.isSelectivelyImmutableType((BType)objectType, new HashSet<BType>(), pkgEnv.enclPkg.packageID)) {
                    this.dlog.error(pos, DiagnosticErrorCode.INVALID_READONLY_OBJECT_TYPE, objectType);
                    return;
                }
                SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(typeNode, symbol.scope, pkgEnv);
                for (BField field : objectType.fields.values()) {
                    BType type = field.type;
                    Set<Flag> flagSet = typeNode.getKind() == NodeKind.OBJECT_TYPE ? typeNode.flagSet : (typeNode.getKind() == NodeKind.USER_DEFINED_TYPE ? typeNode.flagSet : new HashSet<Flag>());
                    if (!this.types.isInherentlyImmutableType(type)) {
                        field.type = field.symbol.type = ImmutableTypeCloner.getImmutableIntersectionType(pos, this.types, type, typeDefEnv, this.symTable, this.anonymousModelHelper, this.names, flagSet);
                    }
                    field.symbol.flags |= 0x20L;
                }
                continue;
            }
            if (nodeKind != NodeKind.RECORD_TYPE) continue;
            BRecordType recordType = (BRecordType)structureType;
            if (!recordType.sealed && Types.getImpliedType((BType)recordType.restFieldType).tag != 50) continue;
            boolean allImmutableFields = true;
            Collection<BField> fields = structureType.fields.values();
            for (BField field : fields) {
                if (Symbols.isFlagOn(field.symbol.flags, 32L)) continue;
                allImmutableFields = false;
                break;
            }
            if (!allImmutableFields) continue;
            structureType.tsymbol.flags |= 0x20L;
            structureType.addFlags(32L);
        }
    }

    private void defineReadOnlyInclusions(List<BLangNode> typeDefs, SymbolEnv pkgEnv) {
        for (BLangNode typeDef : typeDefs) {
            BLangClassDefinition classDefinition;
            if (typeDef.getKind() != NodeKind.CLASS_DEFN || this.isObjectCtor(classDefinition = (BLangClassDefinition)typeDef)) continue;
            this.defineReadOnlyIncludedFieldsAndMethods(classDefinition, pkgEnv);
            classDefinition.definitionCompleted = true;
        }
    }

    public void defineReadOnlyIncludedFieldsAndMethods(BLangClassDefinition classDefinition, SymbolEnv pkgEnv) {
        SymbolEnv typeDefEnv = SymbolEnv.createClassEnv(classDefinition, classDefinition.symbol.scope, pkgEnv);
        BObjectType objType = (BObjectType)classDefinition.symbol.type;
        this.defineReferencedClassFields(classDefinition, typeDefEnv, objType, true);
        SymbolEnv objMethodsEnv = SymbolEnv.createClassMethodsEnv(classDefinition, (BObjectTypeSymbol)classDefinition.symbol, pkgEnv);
        this.defineIncludedMethods(classDefinition, objMethodsEnv, true);
    }

    private void setReadOnlynessOfClassDef(BLangClassDefinition classDef, SymbolEnv pkgEnv) {
        BObjectType objectType = (BObjectType)classDef.getBType();
        Location pos = classDef.pos;
        if (Symbols.isFlagOn(classDef.getBType().getFlags(), 32L)) {
            if (!this.types.isSelectivelyImmutableType((BType)objectType, new HashSet<BType>(), pkgEnv.enclPkg.packageID)) {
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_READONLY_OBJECT_TYPE, objectType);
                return;
            }
            ImmutableTypeCloner.markFieldsAsImmutable(classDef, pkgEnv, objectType, this.types, this.anonymousModelHelper, this.symTable, this.names, pos);
        } else if (classDef.isObjectContructorDecl) {
            Collection fields = objectType.fields.values();
            if (fields.isEmpty()) {
                return;
            }
            for (BField field : fields) {
                if (Symbols.isFlagOn(field.symbol.flags, 4L) && Symbols.isFlagOn(field.type.getFlags(), 32L)) continue;
                return;
            }
            classDef.getBType().tsymbol.flags |= 0x20L;
            classDef.getBType().addFlags(32L);
        }
    }

    private void defineInvokableSymbol(BLangInvokableNode invokableNode, BInvokableSymbol funcSymbol, SymbolEnv invokableEnv) {
        invokableNode.symbol = funcSymbol;
        this.defineSymbol(invokableNode.name.pos, funcSymbol);
        invokableEnv.scope = funcSymbol.scope;
        this.defineInvokableSymbolParams(invokableNode, funcSymbol, invokableEnv);
        if (Symbols.isFlagOn(funcSymbol.type.tsymbol.flags, 0x20000000L)) {
            funcSymbol.type.addFlags(0x20000000L);
        }
        if (Symbols.isFlagOn(funcSymbol.type.tsymbol.flags, 0x2000000L)) {
            funcSymbol.type.addFlags(0x2000000L);
        }
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
    }

    @Override
    public void visit(BLangErrorType errorType) {
        if (errorType.detailType != null) {
            this.defineNode(errorType.detailType, this.env);
        }
    }

    @Override
    public void visit(BLangValueType valueType) {
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefTypeNode) {
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        this.defineNode(arrayType.elemtype, this.env);
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        this.defineNode(constrainedType.type, this.env);
        this.defineNode(constrainedType.constraint, this.env);
    }

    @Override
    public void visit(BLangStreamType streamType) {
        this.defineNode(streamType.constraint, this.env);
        this.defineNode(streamType.type, this.env);
        if (streamType.error != null) {
            this.defineNode(streamType.error, this.env);
        }
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        for (BLangType memType : tupleTypeNode.getMemberTypeNodes()) {
            this.defineNode(memType, this.env);
        }
        if (tupleTypeNode.restParamType != null) {
            this.defineNode(tupleTypeNode.restParamType, this.env);
        }
    }

    @Override
    public void visit(BLangTableTypeNode tableTypeNode) {
        this.defineNode(tableTypeNode.constraint, this.env);
        this.defineNode(tableTypeNode.type, this.env);
        if (tableTypeNode.tableKeyTypeConstraint != null) {
            this.defineNode(tableTypeNode.tableKeyTypeConstraint, this.env);
        }
    }

    @Override
    public void visit(BLangTableKeyTypeConstraint keyTypeConstraint) {
        this.defineNode(keyTypeConstraint.keyType, this.env);
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        objectTypeNode.typeDefEnv = SymbolEnv.createTypeEnv(objectTypeNode, objectTypeNode.symbol.scope, this.env);
        this.resolveFields((BObjectType)objectTypeNode.symbol.type, objectTypeNode);
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(functionTypeNode, functionTypeNode.getBType().tsymbol.scope, this.env);
        this.defineInvokableTypeNode(functionTypeNode, Flags.asMask(functionTypeNode.flagSet), typeDefEnv);
    }

    private List<BVarSymbol> defineParameters(List<BLangSimpleVariable> params, SymbolEnv typeDefEnv) {
        boolean foundDefaultableParam = false;
        boolean foundIncludedRecordParam = false;
        ArrayList<BVarSymbol> paramSymbols = new ArrayList<BVarSymbol>();
        HashSet<String> requiredParamNames = new HashSet<String>();
        for (BLangSimpleVariable varNode : params) {
            boolean isDefaultableParam = varNode.expr != null;
            boolean isIncludedRecordParam = varNode.flagSet.contains((Object)Flag.INCLUDED);
            this.defineNode(varNode, typeDefEnv);
            if (isDefaultableParam) {
                foundDefaultableParam = true;
            } else if (isIncludedRecordParam) {
                foundIncludedRecordParam = true;
            }
            if (isDefaultableParam) {
                if (foundIncludedRecordParam) {
                    this.dlog.error(varNode.pos, DiagnosticErrorCode.DEFAULTABLE_PARAM_DEFINED_AFTER_INCLUDED_RECORD_PARAM, new Object[0]);
                }
            } else if (!isIncludedRecordParam) {
                if (foundDefaultableParam) {
                    this.dlog.error(varNode.pos, DiagnosticErrorCode.REQUIRED_PARAM_DEFINED_AFTER_DEFAULTABLE_PARAM, new Object[0]);
                } else if (foundIncludedRecordParam) {
                    this.dlog.error(varNode.pos, DiagnosticErrorCode.REQUIRED_PARAM_DEFINED_AFTER_INCLUDED_RECORD_PARAM, new Object[0]);
                }
            }
            BVarSymbol symbol = varNode.symbol;
            if (varNode.expr != null) {
                symbol.flags |= 0x1000L;
                symbol.isDefaultable = true;
                if (varNode.expr.getKind() == NodeKind.INFER_TYPEDESC_EXPR) {
                    symbol.flags |= 0x10000000000L;
                }
            }
            if (varNode.flagSet.contains((Object)Flag.INCLUDED)) {
                requiredParamNames.add(symbol.name.value);
                BType varNodeType = Types.getImpliedType(varNode.getBType());
                if (varNodeType.getKind() == TypeKind.RECORD) {
                    symbol.flags |= 0x400000000L;
                    LinkedHashMap fields = ((BRecordType)varNodeType).fields;
                    for (String fieldName : fields.keySet()) {
                        BField field = (BField)fields.get(fieldName);
                        if (Types.getImpliedType((BType)field.symbol.type).tag == 50 || requiredParamNames.add(fieldName)) continue;
                        this.dlog.error(varNode.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, fieldName);
                    }
                } else {
                    this.dlog.error(varNode.typeNode.pos, DiagnosticErrorCode.EXPECTED_RECORD_TYPE_AS_INCLUDED_PARAMETER, new Object[0]);
                }
            } else {
                requiredParamNames.add(symbol.name.value);
            }
            paramSymbols.add(symbol);
        }
        return paramSymbols;
    }

    public void defineInvokableTypeNode(BLangFunctionTypeNode functionTypeNode, long flags, SymbolEnv env) {
        BInvokableTypeSymbol invokableTypeSymbol = (BInvokableTypeSymbol)functionTypeNode.getBType().tsymbol;
        List<BVarSymbol> paramSymbols = this.defineParameters(functionTypeNode.params, env);
        invokableTypeSymbol.params = paramSymbols;
        BType retType = null;
        BLangType retTypeNode = functionTypeNode.returnTypeNode;
        if (retTypeNode != null) {
            this.symResolver.resolveTypeNode(retTypeNode, env);
            invokableTypeSymbol.returnType = retTypeNode.getBType();
            retType = retTypeNode.getBType();
        }
        BType restType = null;
        BLangVariable restParam = functionTypeNode.restParam;
        if (restParam != null) {
            this.defineNode(restParam, env);
            invokableTypeSymbol.restParam = restParam.symbol;
            restType = restParam.getBType();
        }
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        for (BVarSymbol paramSym : paramSymbols) {
            BType type = paramSym.type;
            paramTypes.add(type);
        }
        BInvokableType bInvokableType = (BInvokableType)invokableTypeSymbol.type;
        bInvokableType.paramTypes = paramTypes;
        bInvokableType.retType = retType;
        bInvokableType.restType = restType;
        bInvokableType.addFlags(flags);
        functionTypeNode.setBType(bInvokableType);
        ArrayList<BType> allConstituentTypes = new ArrayList<BType>(paramTypes);
        allConstituentTypes.add(restType);
        allConstituentTypes.add(retType);
        this.symResolver.markParameterizedType((BType)bInvokableType, allConstituentTypes);
    }

    void defineInvokableSymbolParams(BLangInvokableNode invokableNode, BInvokableSymbol invokableSymbol, SymbolEnv invokableEnv) {
        BType retType;
        invokableNode.clonedEnv = invokableEnv.shallowClone();
        List<BVarSymbol> paramSymbols = this.defineParameters(invokableNode.requiredParams, invokableEnv);
        if (!invokableNode.desugaredReturnType) {
            this.symResolver.resolveTypeNode(invokableNode.returnTypeNode, invokableEnv);
        }
        invokableSymbol.params = paramSymbols;
        invokableSymbol.retType = retType = invokableNode.returnTypeNode.getBType();
        this.symResolver.validateInferTypedescParams(invokableNode.pos, invokableNode.getParameters(), retType);
        ArrayList<BType> paramTypes = new ArrayList<BType>(paramSymbols.stream().map(paramSym -> paramSym.type).toList());
        BInvokableTypeSymbol functionTypeSymbol = Symbols.createInvokableTypeSymbol(33587228L, invokableSymbol.flags, invokableEnv.enclPkg.symbol.pkgID, invokableSymbol.type, invokableEnv.scope.owner, invokableNode.pos, SymbolOrigin.SOURCE);
        functionTypeSymbol.params = invokableSymbol.params == null ? null : new ArrayList<BVarSymbol>(invokableSymbol.params);
        functionTypeSymbol.returnType = invokableSymbol.retType;
        BType restType = null;
        if (invokableNode.restParam != null) {
            this.defineNode(invokableNode.restParam, invokableEnv);
            functionTypeSymbol.restParam = invokableSymbol.restParam = invokableNode.restParam.symbol;
            restType = invokableSymbol.restParam.type;
        }
        invokableSymbol.type = new BInvokableType(this.symTable.typeEnv(), paramTypes, restType, retType, null);
        invokableSymbol.type.tsymbol = functionTypeSymbol;
        invokableSymbol.type.tsymbol.type = invokableSymbol.type;
    }

    public void defineSymbol(Location pos, BSymbol symbol) {
        symbol.scope = new Scope(symbol);
        if (this.symResolver.checkForUniqueSymbol(pos, this.env, symbol)) {
            this.env.scope.define(symbol.name, symbol);
        }
    }

    public void defineSymbol(Location pos, BSymbol symbol, SymbolEnv env) {
        symbol.scope = new Scope(symbol);
        if (this.symResolver.checkForUniqueSymbol(pos, env, symbol)) {
            env.scope.define(symbol.name, symbol);
        }
    }

    public void defineShadowedSymbol(Location pos, BSymbol symbol, SymbolEnv env) {
        symbol.scope = new Scope(symbol);
        if (this.symResolver.checkForUniqueSymbolInCurrentScope(pos, env, symbol, symbol.tag)) {
            env.scope.define(symbol.name, symbol);
        }
    }

    public void defineTypeNarrowedSymbol(Location location, SymbolEnv targetEnv, BVarSymbol symbol, BType type, boolean isInternal) {
        if (symbol.owner.tag == 4097L) {
            return;
        }
        BVarSymbol varSymbol = this.createVarSymbol(symbol.flags, type, symbol.name, targetEnv, symbol.pos, isInternal);
        type = Types.getImpliedType(type);
        if (type.tag == 17 && type.tsymbol != null) {
            BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)type.tsymbol;
            BInvokableSymbol invokableSymbol = (BInvokableSymbol)varSymbol;
            invokableSymbol.params = tsymbol.params == null ? null : new ArrayList<BVarSymbol>(tsymbol.params);
            invokableSymbol.restParam = tsymbol.restParam;
            invokableSymbol.retType = tsymbol.returnType;
            invokableSymbol.flags = tsymbol.flags;
        }
        varSymbol.originalName = symbol.getOriginalName();
        varSymbol.owner = symbol.owner;
        varSymbol.originalSymbol = symbol;
        this.defineShadowedSymbol(location, varSymbol, targetEnv);
    }

    public BVarSymbol defineVarSymbol(Location pos, Set<Flag> flagSet, BType varType, Name varName, SymbolEnv env, boolean isInternal) {
        return this.defineVarSymbol(pos, flagSet, varType, varName, varName, env, isInternal);
    }

    public BVarSymbol defineVarSymbol(Location pos, Set<Flag> flagSet, BType varType, Name varName, Name origName, SymbolEnv env, boolean isInternal) {
        boolean isMemberOfFunc;
        Scope enclScope = env.scope;
        BVarSymbol varSymbol = this.createVarSymbol(flagSet, varType, varName, env, pos, isInternal);
        if (varSymbol.name == Names.EMPTY) {
            return varSymbol;
        }
        boolean bl = isMemberOfFunc = flagSet.contains((Object)Flag.REQUIRED_PARAM) || flagSet.contains((Object)Flag.DEFAULTABLE_PARAM) || flagSet.contains((Object)Flag.REST_PARAM) || flagSet.contains((Object)Flag.INCLUDED);
        boolean considerAsMemberSymbol = isMemberOfFunc ? env.enclEnv.enclInvokable == null : flagSet.contains((Object)Flag.FIELD);
        varSymbol.originalName = origName;
        if (considerAsMemberSymbol && !this.symResolver.checkForUniqueMemberSymbol(pos, env, varSymbol) || !considerAsMemberSymbol && !this.symResolver.checkForUniqueSymbol(pos, env, varSymbol)) {
            varSymbol.type = this.symTable.semanticError;
            varSymbol.state = DiagnosticState.REDECLARED;
        }
        enclScope.define(varSymbol.name, varSymbol);
        return varSymbol;
    }

    public void defineExistingVarSymbolInEnv(BVarSymbol varSymbol, SymbolEnv env) {
        if (!this.symResolver.checkForUniqueSymbol(env, varSymbol)) {
            varSymbol.type = this.symTable.semanticError;
            varSymbol.state = DiagnosticState.REDECLARED;
        }
        env.scope.define(varSymbol.name, varSymbol);
    }

    public BVarSymbol createVarSymbol(Set<Flag> flagSet, BType varType, Name varName, SymbolEnv env, Location pos, boolean isInternal) {
        return this.createVarSymbol(Flags.asMask(flagSet), varType, varName, env, pos, isInternal);
    }

    public BVarSymbol createVarSymbol(long flags, BType type, Name varName, SymbolEnv env, Location location, boolean isInternal) {
        BVarSymbol varSymbol;
        BType varType = Types.getImpliedType(type);
        if (varType.tag == 17) {
            varSymbol = new BInvokableSymbol(52L, flags, varName, env.enclPkg.symbol.pkgID, type, env.scope.owner, location, isInternal ? SymbolOrigin.VIRTUAL : this.getOrigin(varName));
            varSymbol.kind = SymbolKind.FUNCTION;
            BInvokableTypeSymbol invokableTypeSymbol = (BInvokableTypeSymbol)varType.tsymbol;
            BVarSymbol invokableSymbol = varSymbol;
            invokableSymbol.params = invokableTypeSymbol.params;
            invokableSymbol.restParam = invokableTypeSymbol.restParam;
            invokableSymbol.retType = invokableTypeSymbol.returnType;
            if (varName.value.startsWith("0")) {
                varSymbol.flags |= 0x800000L;
            }
        } else if (Symbols.isFlagOn(flags, 0x800000L)) {
            varSymbol = new BWorkerSymbol(flags, varName, env.enclPkg.symbol.pkgID, type, env.scope.owner, location, isInternal ? SymbolOrigin.VIRTUAL : this.getOrigin(varName));
            this.resolveAssociatedWorkerFunc((BWorkerSymbol)varSymbol, env);
        } else {
            varSymbol = new BVarSymbol(flags, varName, env.enclPkg.symbol.pkgID, type, env.scope.owner, location, isInternal ? SymbolOrigin.VIRTUAL : this.getOrigin(varName));
            if (varType.tsymbol != null && Symbols.isFlagOn(varType.tsymbol.flags, 65536L)) {
                varSymbol.tag = 16436L;
            }
        }
        return varSymbol;
    }

    private void resolveAssociatedWorkerFunc(BWorkerSymbol worker, SymbolEnv env) {
        LineRange workerVarPos = worker.pos.lineRange();
        for (BLangLambdaFunction lambdaFn : env.enclPkg.lambdaFunctions) {
            LineRange workerBodyPos = lambdaFn.function.pos.lineRange();
            Location targetRangePos = env.node.pos;
            if (targetRangePos == null) {
                targetRangePos = env.enclInvokable.pos;
            }
            if (!worker.name.value.equals(lambdaFn.function.defaultWorkerName.value) || !this.withinRange(workerVarPos, targetRangePos.lineRange()) || !this.withinRange(workerBodyPos, targetRangePos.lineRange())) continue;
            worker.setAssociatedFuncSymbol(lambdaFn.function.symbol);
            return;
        }
        throw new IllegalStateException("Matching function node not found for worker: " + worker.name.value + " at " + String.valueOf(worker.pos));
    }

    private void defineObjectInitFunction(BLangObjectTypeNode object, SymbolEnv conEnv) {
        BLangFunction initFunction = object.initFunction;
        if (initFunction == null) {
            return;
        }
        initFunction.receiver = ASTBuilderUtil.createReceiver(object.pos, object.getBType());
        initFunction.attachedFunction = true;
        initFunction.flagSet.add(Flag.ATTACHED);
        this.defineNode(initFunction, conEnv);
    }

    private void defineClassInitFunction(BLangClassDefinition classDefinition, SymbolEnv conEnv) {
        BLangFunction initFunction = classDefinition.initFunction;
        if (initFunction == null) {
            return;
        }
        initFunction.receiver = ASTBuilderUtil.createReceiver(classDefinition.pos, classDefinition.getBType());
        initFunction.attachedFunction = true;
        initFunction.flagSet.add(Flag.ATTACHED);
        this.defineNode(initFunction, conEnv);
    }

    private void defineAttachedFunctions(BLangFunction funcNode, BInvokableSymbol funcSymbol, SymbolEnv invokableEnv, boolean isValidAttachedFunc) {
        BTypeSymbol typeSymbol = funcNode.receiver.getBType().tsymbol;
        if (isValidAttachedFunc && typeSymbol.tag == 98396L) {
            this.validateFunctionsAttachedToObject(funcNode, funcSymbol);
        }
        this.defineNode(funcNode.receiver, invokableEnv);
        funcSymbol.receiverSymbol = funcNode.receiver.symbol;
    }

    private void validateFunctionsAttachedToObject(BLangFunction funcNode, BInvokableSymbol funcSymbol) {
        BInvokableType funcType = (BInvokableType)funcSymbol.type;
        BObjectTypeSymbol objectSymbol = (BObjectTypeSymbol)funcNode.receiver.getBType().tsymbol;
        BAttachedFunction attachedFunc = funcNode.getKind() == NodeKind.RESOURCE_FUNC ? this.createResourceFunction(funcNode, funcSymbol, funcType) : new BAttachedFunction(this.names.fromIdNode(funcNode.name), funcSymbol, funcType, funcNode.pos);
        this.validateRemoteFunctionAttachedToObject(funcNode, objectSymbol);
        this.validateResourceFunctionAttachedToObject(funcNode, objectSymbol);
        if (!funcNode.objInitFunction) {
            objectSymbol.attachedFuncs.add(attachedFunc);
            return;
        }
        this.types.validateErrorOrNilReturn(funcNode, DiagnosticErrorCode.INVALID_OBJECT_CONSTRUCTOR);
        objectSymbol.initializerFunc = attachedFunc;
    }

    private BAttachedFunction createResourceFunction(BLangFunction funcNode, BInvokableSymbol funcSymbol, BInvokableType funcType) {
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)funcNode.receiver.getBType().tsymbol;
        BLangResourceFunction resourceFunction = (BLangResourceFunction)funcNode;
        Name accessor = this.names.fromIdNode(resourceFunction.methodName);
        List<BVarSymbol> pathParamSymbols = resourceFunction.pathParams.stream().map(p -> {
            p.symbol.kind = SymbolKind.PATH_PARAMETER;
            return p.symbol;
        }).toList();
        BVarSymbol restPathParamSym = null;
        if (resourceFunction.restPathParam != null) {
            restPathParamSym = resourceFunction.restPathParam.symbol;
            restPathParamSym.kind = SymbolKind.PATH_REST_PARAMETER;
        }
        BResourceFunction bResourceFunction = new BResourceFunction(this.names.fromIdNode(funcNode.name), funcSymbol, funcType, accessor, pathParamSymbols, restPathParamSym, funcNode.pos);
        List<BLangResourcePathSegment> pathSegments = resourceFunction.resourcePathSegments;
        int resourcePathCount = pathSegments.size();
        ArrayList<BResourcePathSegmentSymbol> pathSegmentSymbols = new ArrayList<BResourcePathSegmentSymbol>(resourcePathCount);
        BResourcePathSegmentSymbol parentResource = null;
        for (BLangResourcePathSegment pathSegment : pathSegments) {
            Name resourcePathSymbolName = Names.fromString(pathSegment.name.originalValue);
            BType resourcePathSegmentType = pathSegment.typeNode == null ? this.symTable.noType : this.symResolver.resolveTypeNode(pathSegment.typeNode, this.env);
            pathSegment.setBType(resourcePathSegmentType);
            BResourcePathSegmentSymbol pathSym = Symbols.createResourcePathSegmentSymbol(resourcePathSymbolName, this.env.enclPkg.symbol.pkgID, resourcePathSegmentType, objectTypeSymbol, pathSegment.pos, parentResource, bResourceFunction, SymbolOrigin.SOURCE);
            objectTypeSymbol.resourcePathSegmentScope.define(pathSym.name, pathSym);
            pathSegmentSymbols.add(pathSym);
            pathSegment.symbol = pathSym;
            parentResource = pathSym;
        }
        bResourceFunction.pathSegmentSymbols = pathSegmentSymbols;
        return bResourceFunction;
    }

    private void validateRemoteFunctionAttachedToObject(BLangFunction funcNode, BObjectTypeSymbol objectSymbol) {
        if (!Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 32768L)) {
            return;
        }
        funcNode.symbol.flags |= 0x8000L;
        funcNode.symbol.flags |= 1L;
        if (!this.isNetworkQualified(objectSymbol)) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.REMOTE_FUNCTION_IN_NON_NETWORK_OBJECT, new Object[0]);
        }
    }

    private boolean isNetworkQualified(BObjectTypeSymbol objectSymbol) {
        return Symbols.isFlagOn(objectSymbol.flags, 65536L) || Symbols.isFlagOn(objectSymbol.flags, 262144L);
    }

    private void validateResourceFunctionAttachedToObject(BLangFunction funcNode, BObjectTypeSymbol objectSymbol) {
        if (!Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 131072L)) {
            return;
        }
        funcNode.symbol.flags |= 0x20000L;
        funcNode.symbol.flags |= 1L;
        if (!this.isNetworkQualified(objectSymbol)) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.RESOURCE_METHODS_ARE_ONLY_ALLOWED_IN_SERVICE_OR_CLIENT_OBJECTS, new Object[0]);
        }
    }

    private boolean validateFuncReceiver(BLangFunction funcNode) {
        if (funcNode.receiver == null) {
            return true;
        }
        if (funcNode.receiver.getBType() == null) {
            funcNode.receiver.setBType(this.symResolver.resolveTypeNode(funcNode.receiver.typeNode, this.env));
        }
        BType receiverType = funcNode.receiver.getBType();
        if (receiverType.tag == 28) {
            return true;
        }
        BType referredReceiverType = Types.getImpliedType(receiverType);
        if (referredReceiverType.tag == 34 && !this.env.enclPkg.symbol.pkgID.equals(receiverType.tsymbol.pkgID)) {
            this.dlog.error(funcNode.receiver.pos, DiagnosticErrorCode.FUNC_DEFINED_ON_NON_LOCAL_TYPE, funcNode.name.value, receiverType.toString());
            return false;
        }
        return true;
    }

    private Name getFuncSymbolName(BLangFunction funcNode) {
        if (funcNode.receiver != null) {
            return Names.fromString(Symbols.getAttachedFuncSymbolName(funcNode.receiver.getBType().tsymbol.name.value, funcNode.name.value));
        }
        return this.names.fromIdNode(funcNode.name);
    }

    private Name getFuncSymbolOriginalName(BLangFunction funcNode) {
        return this.names.originalNameFromIdNode(funcNode.name);
    }

    public MarkdownDocAttachment getMarkdownDocAttachment(BLangMarkdownDocumentation docNode) {
        if (docNode == null) {
            return new MarkdownDocAttachment(0);
        }
        MarkdownDocAttachment docAttachment = new MarkdownDocAttachment(docNode.getParameters().size());
        docAttachment.description = docNode.getDocumentation();
        for (BLangMarkdownParameterDocumentation p : docNode.getParameters()) {
            docAttachment.parameters.add(new MarkdownDocAttachment.Parameter(p.parameterName.originalValue, p.getParameterDocumentation()));
        }
        docAttachment.returnValueDescription = docNode.getReturnParameterDocumentation();
        BLangMarkDownDeprecationDocumentation deprecatedDocs = docNode.getDeprecationDocumentation();
        if (deprecatedDocs == null) {
            return docAttachment;
        }
        docAttachment.deprecatedDocumentation = deprecatedDocs.getDocumentation();
        BLangMarkDownDeprecatedParametersDocumentation deprecatedParamsDocs = docNode.getDeprecatedParametersDocumentation();
        if (deprecatedParamsDocs == null) {
            return docAttachment;
        }
        for (BLangMarkdownParameterDocumentation param : deprecatedParamsDocs.getParameters()) {
            docAttachment.deprecatedParams.add(new MarkdownDocAttachment.Parameter(param.parameterName.value, param.getParameterDocumentation()));
        }
        return docAttachment;
    }

    private void resolveIncludedFields(BLangStructureTypeNode structureTypeNode) {
        SymbolEnv typeDefEnv = structureTypeNode.typeDefEnv;
        List<BLangType> typeRefs = structureTypeNode.typeRefs;
        int typeRefSize = typeRefs.size();
        HashSet referencedTypes = new HashSet(typeRefSize);
        ArrayList invalidTypeRefs = new ArrayList(typeRefSize);
        HashMap<String, BLangSimpleVariable> fieldNames = new HashMap<String, BLangSimpleVariable>(structureTypeNode.fields.size());
        for (BLangSimpleVariable fieldVariable : structureTypeNode.fields) {
            fieldNames.put(fieldVariable.name.value, fieldVariable);
        }
        structureTypeNode.includedFields = typeRefs.stream().flatMap(typeRef -> {
            BType referredType = this.symResolver.resolveTypeNode((BLangType)typeRef, typeDefEnv);
            if ((referredType = Types.getReferredType(referredType)) == this.symTable.semanticError) {
                return Stream.empty();
            }
            if (!referencedTypes.add(referredType.tsymbol)) {
                this.dlog.error(typeRef.pos, DiagnosticErrorCode.REDECLARED_TYPE_REFERENCE, typeRef);
                return Stream.empty();
            }
            int referredTypeTag = referredType.tag;
            if (Types.getImpliedType((BType)structureTypeNode.getBType()).tag == 34) {
                if (referredTypeTag != 34) {
                    DiagnosticErrorCode errorCode = DiagnosticErrorCode.INCOMPATIBLE_TYPE_REFERENCE;
                    if (referredTypeTag == 22 && this.isReadOnlyAndObjectIntersection((BIntersectionType)referredType)) {
                        errorCode = DiagnosticErrorCode.INVALID_READ_ONLY_TYPEDESC_INCLUSION_IN_OBJECT_TYPEDESC;
                    }
                    this.dlog.error(typeRef.pos, errorCode, typeRef);
                    invalidTypeRefs.add(typeRef);
                    return Stream.empty();
                }
                BObjectType objectType = (BObjectType)referredType;
                if (!structureTypeNode.symbol.pkgID.equals(referredType.tsymbol.pkgID)) {
                    for (BField field2 : objectType.fields.values()) {
                        if (Symbols.isPublic(field2.symbol)) continue;
                        this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_REFERENCE_NON_PUBLIC_MEMBERS, typeRef);
                        invalidTypeRefs.add(typeRef);
                        return Stream.empty();
                    }
                    for (BAttachedFunction func : ((BObjectTypeSymbol)objectType.tsymbol).attachedFuncs) {
                        if (Symbols.isPublic(func.symbol)) continue;
                        this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_REFERENCE_NON_PUBLIC_MEMBERS, typeRef);
                        invalidTypeRefs.add(typeRef);
                        return Stream.empty();
                    }
                }
            }
            if (structureTypeNode.getBType().tag == 12 && referredTypeTag != 12) {
                this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_RECORD_TYPE_REFERENCE, typeRef);
                invalidTypeRefs.add(typeRef);
                return Stream.empty();
            }
            if ((referredTypeTag == 12 || referredTypeTag == 34) && this.typeResolver.resolvingStructureTypes.contains((BStructureType)referredType)) {
                ArrayList<BLangSimpleVariable> includedFields = new ArrayList<BLangSimpleVariable>();
                this.typeResolver.getFieldsOfStructureType(referredType.tsymbol.name.value, includedFields);
                return includedFields.stream().filter(f -> {
                    if (fieldNames.containsKey(f.name.value)) {
                        BLangSimpleVariable existingVariable = (BLangSimpleVariable)fieldNames.get(f.name.value);
                        if (existingVariable.flagSet.contains((Object)Flag.PUBLIC) != f.flagSet.contains((Object)Flag.PUBLIC)) {
                            this.dlog.error(existingVariable.pos, DiagnosticErrorCode.MISMATCHED_VISIBILITY_QUALIFIERS_IN_OBJECT_FIELD, existingVariable.name.value);
                        }
                        return false;
                    }
                    return true;
                }).map(field -> {
                    BLangSimpleVariable var = ASTBuilderUtil.createVariable(typeRef.pos, field.name.value, field.getBType());
                    var.typeNode = field.typeNode;
                    var.flagSet = field.getFlags();
                    return var;
                });
            }
            return ((BStructureType)referredType).fields.values().stream().filter(f -> {
                if (fieldNames.containsKey(f.name.value)) {
                    BLangSimpleVariable existingVariable = (BLangSimpleVariable)fieldNames.get(f.name.value);
                    if (existingVariable.flagSet.contains((Object)Flag.PUBLIC) != Symbols.isFlagOn(f.symbol.flags, 1L)) {
                        this.dlog.error(existingVariable.pos, DiagnosticErrorCode.MISMATCHED_VISIBILITY_QUALIFIERS_IN_OBJECT_FIELD, existingVariable.name.value);
                    }
                    return false;
                }
                return true;
            }).map(field -> {
                BLangSimpleVariable var = ASTBuilderUtil.createVariable(typeRef.pos, field.name.value, field.type);
                var.flagSet = field.symbol.getFlags();
                return var;
            });
        }).toList();
        structureTypeNode.typeRefs.removeAll(invalidTypeRefs);
    }

    private void defineReferencedFunction(Location location, Set<Flag> flagSet, SymbolEnv objEnv, BLangType typeRef, BAttachedFunction referencedFunc, Set<String> includedFunctionNames, BSymbol typeDefSymbol, List<BLangFunction> declaredFunctions, boolean isInternal) {
        BAttachedFunction attachedFunc;
        typeDefSymbol = typeDefSymbol.tag == 32796L ? typeDefSymbol.type.tsymbol : typeDefSymbol;
        String referencedFuncName = referencedFunc.funcName.value;
        Name funcName = Names.fromString(Symbols.getAttachedFuncSymbolName(typeDefSymbol.name.value, referencedFuncName));
        BSymbol matchingObjFuncSym = this.symResolver.lookupSymbolInMainSpace(objEnv, funcName);
        BInvokableSymbol referencedFuncSymbol = referencedFunc.symbol;
        if (matchingObjFuncSym != this.symTable.notFoundSymbol) {
            Location methodPos;
            BLangFunction matchingFunc;
            if (!includedFunctionNames.add(referencedFuncName)) {
                this.dlog.error(typeRef.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, referencedFuncName);
                return;
            }
            if (!this.hasSameFunctionSignature((BInvokableSymbol)matchingObjFuncSym, referencedFuncSymbol)) {
                matchingFunc = this.findFunctionBySymbol(declaredFunctions, matchingObjFuncSym);
                methodPos = matchingFunc != null ? matchingFunc.pos : typeRef.pos;
                this.dlog.error(methodPos, DiagnosticErrorCode.REFERRED_FUNCTION_SIGNATURE_MISMATCH, this.getCompleteFunctionSignature(referencedFuncSymbol), this.getCompleteFunctionSignature((BInvokableSymbol)matchingObjFuncSym));
            }
            if (Symbols.isFunctionDeclaration(matchingObjFuncSym) && Symbols.isFunctionDeclaration(referencedFuncSymbol) && !this.types.isAssignable(matchingObjFuncSym.type, referencedFunc.type)) {
                matchingFunc = this.findFunctionBySymbol(declaredFunctions, matchingObjFuncSym);
                methodPos = matchingFunc != null ? matchingFunc.pos : typeRef.pos;
                this.dlog.error(methodPos, DiagnosticErrorCode.REDECLARED_FUNCTION_FROM_TYPE_REFERENCE, referencedFunc.funcName, typeRef);
            }
            return;
        }
        if (Symbols.isPrivate(referencedFuncSymbol)) {
            return;
        }
        BInvokableSymbol funcSymbol = ASTBuilderUtil.duplicateFunctionDeclarationSymbol(this.symTable.typeEnv(), referencedFuncSymbol, typeDefSymbol, funcName, typeDefSymbol.pkgID, typeRef.pos, this.getOrigin(funcName));
        this.defineSymbol(typeRef.pos, funcSymbol, objEnv);
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(null, funcSymbol.scope, objEnv);
        funcSymbol.params.forEach(param -> this.defineSymbol(typeRef.pos, (BSymbol)param, funcEnv));
        if (funcSymbol.restParam != null) {
            this.defineSymbol(typeRef.pos, funcSymbol.restParam, funcEnv);
        }
        funcSymbol.receiverSymbol = this.defineVarSymbol(location, flagSet, typeDefSymbol.type, Names.SELF, funcEnv, isInternal);
        if (referencedFunc instanceof BResourceFunction) {
            BResourceFunction resourceFunction = (BResourceFunction)referencedFunc;
            BResourceFunction cacheFunc = new BResourceFunction(referencedFunc.funcName, funcSymbol, (BInvokableType)funcSymbol.type, resourceFunction.accessor, resourceFunction.pathParams, resourceFunction.restPathParam, referencedFunc.pos);
            cacheFunc.pathSegmentSymbols = resourceFunction.pathSegmentSymbols;
            attachedFunc = cacheFunc;
        } else {
            attachedFunc = new BAttachedFunction(referencedFunc.funcName, funcSymbol, (BInvokableType)funcSymbol.type, referencedFunc.pos);
        }
        ((BObjectTypeSymbol)typeDefSymbol).attachedFuncs.add(attachedFunc);
        ((BObjectTypeSymbol)typeDefSymbol).referencedFunctions.add(attachedFunc);
    }

    private BLangFunction findFunctionBySymbol(List<BLangFunction> declaredFunctions, BSymbol symbol) {
        for (BLangFunction fn : declaredFunctions) {
            if (fn.symbol != symbol) continue;
            return fn;
        }
        return null;
    }

    private boolean hasSameFunctionSignature(BInvokableSymbol attachedFuncSym, BInvokableSymbol referencedFuncSym) {
        if (!this.hasSameVisibilityModifier(referencedFuncSym.flags, attachedFuncSym.flags)) {
            return false;
        }
        return Symbols.isRemote(attachedFuncSym) == Symbols.isRemote(referencedFuncSym) && this.types.isAssignable(attachedFuncSym.type, referencedFuncSym.type);
    }

    private boolean hasSameVisibilityModifier(long flags1, long flags2) {
        long xorOfFlags = flags1 ^ flags2;
        return (xorOfFlags & 1L) != 1L && (xorOfFlags & 0x400L) != 1024L;
    }

    private String getCompleteFunctionSignature(BInvokableSymbol funcSymbol) {
        StringBuilder signatureBuilder = new StringBuilder();
        StringJoiner paramListBuilder = new StringJoiner(", ", "(", ")");
        if (Symbols.isRemote(funcSymbol)) {
            signatureBuilder.append("remote ");
        } else if (Symbols.isPublic(funcSymbol)) {
            signatureBuilder.append("public ");
        } else if (Symbols.isPrivate(funcSymbol)) {
            signatureBuilder.append("private ");
        }
        signatureBuilder.append("function ").append(funcSymbol.name.value.split("\\.")[1]);
        funcSymbol.params.forEach(param -> paramListBuilder.add(param.type.toString()));
        if (funcSymbol.restParam != null) {
            paramListBuilder.add(((BArrayType)funcSymbol.restParam.type).eType.toString() + "...");
        }
        signatureBuilder.append(paramListBuilder.toString());
        if (funcSymbol.retType != this.symTable.nilType) {
            signatureBuilder.append(" returns ").append(funcSymbol.retType.toString());
        }
        return signatureBuilder.toString();
    }

    private BPackageSymbol dupPackageSymbolAndSetCompUnit(BPackageSymbol originalSymbol, Name compUnit) {
        BPackageSymbol copy = new BPackageSymbol(originalSymbol.pkgID, originalSymbol.owner, originalSymbol.flags, originalSymbol.pos, originalSymbol.origin);
        copy.initFunctionSymbol = originalSymbol.initFunctionSymbol;
        copy.startFunctionSymbol = originalSymbol.startFunctionSymbol;
        copy.stopFunctionSymbol = originalSymbol.stopFunctionSymbol;
        copy.testInitFunctionSymbol = originalSymbol.testInitFunctionSymbol;
        copy.testStartFunctionSymbol = originalSymbol.testStartFunctionSymbol;
        copy.testStopFunctionSymbol = originalSymbol.testStopFunctionSymbol;
        copy.packageFile = originalSymbol.packageFile;
        copy.compiledPackage = originalSymbol.compiledPackage;
        copy.entryPointExists = originalSymbol.entryPointExists;
        copy.scope = originalSymbol.scope;
        copy.owner = originalSymbol.owner;
        copy.compUnit = compUnit;
        copy.importPrefix = originalSymbol.importPrefix;
        return copy;
    }

    private boolean isSameImport(BLangImportPackage importPkgNode, BPackageSymbol importSymbol) {
        if (!importPkgNode.orgName.value.equals(importSymbol.pkgID.orgName.value)) {
            return false;
        }
        BLangIdentifier pkgName = importPkgNode.pkgNameComps.get(importPkgNode.pkgNameComps.size() - 1);
        return pkgName.value.equals(importSymbol.pkgID.name.value);
    }

    private void setTypeFromLambdaExpr(BLangVariable variable) {
        BLangFunction function = ((BLangLambdaFunction)variable.expr).function;
        BInvokableType invokableType = (BInvokableType)function.symbol.type;
        if (function.flagSet.contains((Object)Flag.ISOLATED)) {
            invokableType.addFlags(0x20000000L);
            invokableType.tsymbol.flags |= 0x20000000L;
        }
        if (function.flagSet.contains((Object)Flag.TRANSACTIONAL)) {
            invokableType.addFlags(0x2000000L);
            invokableType.tsymbol.flags |= 0x2000000L;
        }
        variable.setBType(invokableType);
    }

    public SymbolOrigin getOrigin(Name name, Set<Flag> flags) {
        if (flags.contains((Object)Flag.ANONYMOUS) && (flags.contains((Object)Flag.SERVICE) || flags.contains((Object)Flag.CLASS)) || this.missingNodesHelper.isMissingNode(name)) {
            return SymbolOrigin.VIRTUAL;
        }
        return SymbolOrigin.SOURCE;
    }

    private SymbolOrigin getOrigin(Name name) {
        return this.getOrigin(name.value);
    }

    public SymbolOrigin getOrigin(String name) {
        if (this.missingNodesHelper.isMissingNode(name)) {
            return SymbolOrigin.VIRTUAL;
        }
        return SymbolOrigin.SOURCE;
    }

    private boolean isInvalidIncludedTypeInClass(BType includedType) {
        includedType = Types.getReferredType(includedType);
        int tag = includedType.tag;
        if (tag == 34) {
            return false;
        }
        if (tag != 22) {
            return true;
        }
        for (BType constituentType : ((BIntersectionType)includedType).getConstituentTypes()) {
            int constituentTypeTag = Types.getImpliedType((BType)constituentType).tag;
            if (constituentTypeTag == 34 || constituentTypeTag == 38) continue;
            return true;
        }
        return false;
    }

    private boolean isImmutable(BObjectType objectType) {
        if (Symbols.isFlagOn(objectType.getFlags(), 32L)) {
            return true;
        }
        Collection fields = objectType.fields.values();
        if (fields.isEmpty()) {
            return false;
        }
        for (BField field : fields) {
            if (Symbols.isFlagOn(field.symbol.flags, 4L) && Symbols.isFlagOn(field.type.getFlags(), 32L)) continue;
            return false;
        }
        return true;
    }

    private boolean isReadOnlyAndObjectIntersection(BIntersectionType referredType) {
        BType effectiveType = referredType.effectiveType;
        if (Types.getImpliedType((BType)effectiveType).tag != 34 || !Symbols.isFlagOn(effectiveType.getFlags(), 32L)) {
            return false;
        }
        for (BType constituentType : referredType.getConstituentTypes()) {
            if (Types.getImpliedType((BType)constituentType).tag != 38) continue;
            return true;
        }
        return false;
    }

    private boolean withinRange(LineRange srcRange, LineRange targetRange) {
        int startLine = srcRange.startLine().line();
        int startOffset = srcRange.startLine().offset();
        int endLine = srcRange.endLine().line();
        int endOffset = srcRange.endLine().offset();
        int enclStartLine = targetRange.startLine().line();
        int enclEndLine = targetRange.endLine().line();
        int enclStartOffset = targetRange.startLine().offset();
        int enclEndOffset = targetRange.endLine().offset();
        return targetRange.fileName().equals(srcRange.fileName()) && (startLine == enclStartLine && startOffset >= enclStartOffset || startLine > enclStartLine) && (endLine == enclEndLine && endOffset <= enclEndOffset || endLine < enclEndLine);
    }

    public static class ImportResolveHolder {
        public BLangImportPackage resolved;
        public List<BLangImportPackage> unresolved;

        public ImportResolveHolder() {
            this.unresolved = new ArrayList<BLangImportPackage>();
        }

        public ImportResolveHolder(BLangImportPackage resolved) {
            this.resolved = resolved;
            this.unresolved = new ArrayList<BLangImportPackage>();
        }
    }

    private static class LocationData {
        private final String name;
        private final int row;
        private final int column;

        LocationData(String name, int row, int column) {
            this.name = name;
            this.row = row;
            this.column = column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocationData that = (LocationData)o;
            return this.row == that.row && this.column == that.column && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.row, this.column);
        }
    }
}

