/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.PredefinedType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.parser.BLangMissingNodesHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConstantValueResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemanticAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeySpecifier;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCapturingGroups;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReSequence;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReTerm;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.compiler.util.Unifier;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.Lists;

public class SymbolResolver
extends BLangNodeTransformer<AnalyzerData, BType> {
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF5;
    private static final CompilerContext.Key<SymbolResolver> SYMBOL_RESOLVER_KEY = new CompilerContext.Key();
    private final SymbolTable symTable;
    private final Names names;
    private final BLangDiagnosticLog dlog;
    private final Types types;
    private final SymbolEnter symbolEnter;
    private final TypeResolver typeResolver;
    private final BLangAnonymousModelHelper anonymousModelHelper;
    private final BLangMissingNodesHelper missingNodesHelper;
    private final Unifier unifier;
    private final SemanticAnalyzer semanticAnalyzer;
    private final Stack<String> anonTypeNameSuffixes;

    public static SymbolResolver getInstance(CompilerContext context) {
        SymbolResolver symbolResolver = context.get(SYMBOL_RESOLVER_KEY);
        if (symbolResolver == null) {
            symbolResolver = new SymbolResolver(context);
        }
        return symbolResolver;
    }

    public SymbolResolver(CompilerContext context) {
        context.put(SYMBOL_RESOLVER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.types = Types.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.typeResolver = TypeResolver.getInstance(context);
        this.missingNodesHelper = BLangMissingNodesHelper.getInstance(context);
        this.semanticAnalyzer = SemanticAnalyzer.getInstance(context);
        this.unifier = new Unifier();
        this.anonTypeNameSuffixes = new Stack();
    }

    @Override
    public BType transformNode(BLangNode node, AnalyzerData props) {
        return this.symTable.neverType;
    }

    public boolean checkForUniqueSymbol(Location pos, SymbolEnv env, BSymbol symbol) {
        int dotPosition;
        BSymbol foundSym = this.symTable.notFoundSymbol;
        long expSymTag = symbol.tag;
        if ((expSymTag & 1L) == 1L) {
            foundSym = this.lookupSymbolInPrefixSpace(env, symbol.name);
        } else if ((expSymTag & 2L) == 2L) {
            foundSym = this.lookupSymbolInAnnotationSpace(env, symbol.name);
        } else if ((expSymTag & 0x4000100L) == 0x4000100L) {
            foundSym = this.lookupSymbolInConstructorSpace(env, symbol.name);
        } else if ((expSymTag & 4L) == 4L) {
            foundSym = this.lookupSymbolForDecl(env, symbol.name, 4L);
        }
        if (foundSym == this.symTable.notFoundSymbol && expSymTag == 820L && (dotPosition = symbol.name.value.indexOf(46)) > 0 && dotPosition != symbol.name.value.length()) {
            String funcName = symbol.name.value.substring(dotPosition + 1);
            foundSym = this.lookupSymbolForDecl(env, Names.fromString(funcName), 4L);
        }
        if (foundSym == this.symTable.notFoundSymbol) {
            return true;
        }
        if (symbol.tag == 8193L && this.isDistinctXMLNSSymbol((BXMLNSSymbol)symbol, (BXMLNSSymbol)foundSym)) {
            return true;
        }
        if (!this.isDistinctSymbol(pos, symbol, foundSym)) {
            return false;
        }
        if (this.isRedeclaredSymbol(symbol, foundSym)) {
            Name name = symbol.name;
            if (Symbols.isRemote(symbol) ^ Symbols.isRemote(foundSym)) {
                this.dlog.error(pos, DiagnosticErrorCode.UNSUPPORTED_REMOTE_METHOD_NAME_IN_SCOPE, name);
                return false;
            }
            if (symbol.kind != SymbolKind.CONSTANT) {
                this.dlog.error(pos, DiagnosticErrorCode.REDECLARED_SYMBOL, name);
            }
            return false;
        }
        return (foundSym.tag & 0x84L) != 132L;
    }

    private boolean isRedeclaredSymbol(BSymbol symbol, BSymbol foundSym) {
        return this.hasSameOwner(symbol, foundSym) || this.isSymbolRedeclaredInTestPackage(symbol, foundSym) || this.isRedeclaredTypeDefinitionSymbol(symbol, foundSym);
    }

    public boolean checkForUniqueSymbol(SymbolEnv env, BSymbol symbol) {
        BSymbol foundSym = this.lookupSymbolInMainSpace(env, symbol.name);
        if (foundSym == this.symTable.notFoundSymbol) {
            return true;
        }
        if (symbol.tag == 0x4000100L && foundSym.tag == 294940L) {
            return false;
        }
        return !this.hasSameOwner(symbol, foundSym);
    }

    public boolean checkForUniqueSymbolInCurrentScope(Location pos, SymbolEnv env, BSymbol symbol, long expSymTag) {
        BSymbol foundSym = this.lookupSymbolInGivenScope(env, symbol.name, expSymTag);
        if (foundSym == this.symTable.notFoundSymbol) {
            return true;
        }
        return this.isDistinctSymbol(pos, symbol, foundSym);
    }

    private boolean isDistinctSymbol(Location pos, BSymbol symbol, BSymbol foundSym) {
        if (symbol.tag == 0x4000100L && foundSym.tag == 294940L) {
            return false;
        }
        if (this.isSymbolDefinedInRootPkgLvl(foundSym)) {
            this.dlog.error(pos, DiagnosticErrorCode.REDECLARED_BUILTIN_SYMBOL, symbol.name);
            return false;
        }
        return true;
    }

    private boolean hasSameOwner(BSymbol symbol, BSymbol foundSym) {
        if (foundSym.owner == symbol.owner) {
            return true;
        }
        if (Symbols.isFlagOn(symbol.owner.flags, 0x100000L) && (foundSym.owner.tag & 0x100L) == 256L) {
            return true;
        }
        if ((symbol.owner.tag & 0x8000000L) == 0x8000000L && (foundSym.owner.tag & 0x100L) == 256L) {
            return true;
        }
        if ((symbol.owner.tag & 0x200801CL) == 33587228L && (foundSym.owner.tag & 0x100L) == 256L) {
            return true;
        }
        if (Symbols.isFlagOn(symbol.owner.flags, 0x100000000L) && (foundSym.owner.tag & 0x100L) == 256L) {
            if (Symbols.isFlagOn(symbol.flags, 8L) || Symbols.isFlagOn(foundSym.flags, 8L)) {
                return false;
            }
            return !foundSym.name.value.equals(Names.SELF.value) && !symbol.name.value.equals(Names.SELF.value);
        }
        return false;
    }

    private boolean isRedeclaredTypeDefinitionSymbol(BSymbol symbol, BSymbol foundSym) {
        if (symbol.kind != SymbolKind.TYPE_DEF && foundSym.kind != SymbolKind.TYPE_DEF) {
            return false;
        }
        if (symbol.kind == SymbolKind.TYPE_DEF) {
            return this.hasSameOwner(symbol.type.tsymbol, foundSym);
        }
        return this.hasSameOwner(symbol, foundSym.type.tsymbol);
    }

    private boolean isSymbolRedeclaredInTestPackage(BSymbol symbol, BSymbol foundSym) {
        return Symbols.isFlagOn(symbol.owner.flags, 8192L) && !Symbols.isFlagOn(foundSym.owner.flags, 8192L);
    }

    private boolean isSymbolDefinedInRootPkgLvl(BSymbol foundSym) {
        long foundSymTag = foundSym.tag;
        return this.symTable.rootPkgSymbol.pkgID.equals(foundSym.pkgID) && (foundSymTag & 0x14L) == 20L;
    }

    public BSymbol lookupSymbolInGivenScope(SymbolEnv env, Name name, long expSymTag) {
        Scope.ScopeEntry entry = env.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if (this.symTable.rootPkgSymbol.pkgID.equals(entry.symbol.pkgID) && (entry.symbol.tag & 0x14L) == 20L) {
                return entry.symbol;
            }
            if ((entry.symbol.tag & expSymTag) == expSymTag && !this.isFieldRefFromWithinARecord(entry.symbol, env)) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        return this.symTable.notFoundSymbol;
    }

    public boolean checkForUniqueMemberSymbol(Location pos, SymbolEnv env, BSymbol symbol) {
        BSymbol foundSym = this.lookupMemberSymbol(pos, env.scope, env, symbol.name, symbol.tag);
        if (foundSym != this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.REDECLARED_SYMBOL, symbol.name);
            return false;
        }
        return true;
    }

    public BSymbol resolveBinaryOperator(OperatorKind opKind, BType lhsType, BType rhsType) {
        return this.resolveOperator(Names.fromString(opKind.value()), Lists.of(lhsType, rhsType));
    }

    private BSymbol createEqualityOperator(OperatorKind opKind, BType lhsType, BType rhsType) {
        List<BType> paramTypes = Lists.of(lhsType, rhsType);
        BType retType = this.symTable.booleanType;
        BInvokableType opType = new BInvokableType(this.symTable.typeEnv(), paramTypes, retType, null);
        return new BOperatorSymbol(Names.fromString(opKind.value()), null, opType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
    }

    public BSymbol resolveUnaryOperator(OperatorKind opKind, BType type) {
        return this.resolveOperator(Names.fromString(opKind.value()), Lists.of(type));
    }

    public BSymbol resolveOperator(Name name, List<BType> types) {
        Scope.ScopeEntry entry = this.symTable.rootScope.lookup(name);
        return this.resolveOperator(entry, types);
    }

    private BSymbol createBinaryComparisonOperator(OperatorKind opKind, BType lhsType, BType rhsType) {
        List<BType> paramTypes = Lists.of(lhsType, rhsType);
        BInvokableType opType = new BInvokableType(this.symTable.typeEnv(), paramTypes, this.symTable.booleanType, null);
        return new BOperatorSymbol(Names.fromString(opKind.value()), null, opType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
    }

    private BSymbol createBinaryOperator(OperatorKind opKind, BType lhsType, BType rhsType, BType retType) {
        List<BType> paramTypes = Lists.of(lhsType, rhsType);
        BInvokableType opType = new BInvokableType(this.symTable.typeEnv(), paramTypes, retType, null);
        return new BOperatorSymbol(Names.fromString(opKind.value()), null, opType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
    }

    BSymbol createUnaryOperator(OperatorKind kind, BType type, BType retType) {
        List<BType> paramTypes = Lists.of(type);
        BInvokableType opType = new BInvokableType(this.symTable.typeEnv(), paramTypes, retType, null);
        return new BOperatorSymbol(Names.fromString(kind.value()), null, opType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
    }

    public BSymbol resolvePkgSymbol(Location pos, SymbolEnv env, Name pkgAlias) {
        if (pkgAlias == Names.EMPTY) {
            return env.enclPkg.symbol;
        }
        BSymbol pkgSymbol = this.lookupSymbolInPrefixSpace(env, pkgAlias);
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias.value);
        }
        return pkgSymbol;
    }

    public BSymbol resolvePrefixSymbol(SymbolEnv env, Name pkgAlias, Name compUnit) {
        if (pkgAlias == Names.EMPTY) {
            return env.enclPkg.symbol;
        }
        Scope.ScopeEntry entry = env.scope.lookup(pkgAlias);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            BSymbol symbol = entry.symbol;
            long tag = symbol.tag;
            if (this.isDistinctXMLNSSymbol(symbol, compUnit)) {
                return symbol;
            }
            if ((tag & 0x2001L) != 8193L && (tag & 1L) == 1L && ((BPackageSymbol)symbol).compUnit.equals(compUnit)) {
                ((BPackageSymbol)symbol).isUsed = true;
                return symbol;
            }
            entry = entry.next;
        }
        if (env.enclEnv != null) {
            return this.resolvePrefixSymbol(env.enclEnv, pkgAlias, compUnit);
        }
        return this.symTable.notFoundSymbol;
    }

    private boolean isDistinctXMLNSSymbol(BSymbol symbol, Name compUnit) {
        if (symbol instanceof BXMLNSSymbol) {
            BXMLNSSymbol bxmlnsSymbol = (BXMLNSSymbol)symbol;
            Name xmlnsCompUnit = bxmlnsSymbol.compUnit;
            return xmlnsCompUnit == null || xmlnsCompUnit.equals(compUnit);
        }
        return false;
    }

    public BSymbol resolveAnnotation(Location pos, SymbolEnv env, Name pkgAlias, Name annotationName) {
        return this.lookupAnnotationSpaceSymbolInPackage(pos, env, pkgAlias, annotationName);
    }

    public BSymbol resolveStructField(Location location, SymbolEnv env, Name fieldName, BTypeSymbol structSymbol) {
        return this.lookupMemberSymbol(location, structSymbol.scope, env, fieldName, 52L);
    }

    public BSymbol resolveObjectField(Location location, SymbolEnv env, Name fieldName, BTypeSymbol objectSymbol) {
        return this.lookupMemberSymbol(location, objectSymbol.scope, env, fieldName, 52L);
    }

    public BSymbol resolveObjectMethod(Location pos, SymbolEnv env, Name fieldName, BObjectTypeSymbol objectSymbol) {
        return this.lookupMemberSymbol(pos, objectSymbol.scope, env, fieldName, 52L);
    }

    public BSymbol resolveInvocableObjectField(Location pos, SymbolEnv env, Name fieldName, BObjectTypeSymbol objectTypeSymbol) {
        return this.lookupMemberSymbol(pos, objectTypeSymbol.scope, env, fieldName, 52L);
    }

    public BType resolveTypeNode(BLangType typeNode, SymbolEnv env) {
        AnalyzerData data = new AnalyzerData(env);
        return this.resolveTypeNode(typeNode, data, env, DiagnosticErrorCode.UNKNOWN_TYPE);
    }

    public BType resolveTypeNode(BLangType typeNode, SymbolEnv env, DiagnosticCode diagCode) {
        AnalyzerData data = new AnalyzerData(env);
        return this.resolveTypeNode(typeNode, data, env, diagCode);
    }

    private BType resolveTypeNode(BLangType typeNode, AnalyzerData data, SymbolEnv env) {
        return this.resolveTypeNode(typeNode, data, env, DiagnosticErrorCode.UNKNOWN_TYPE);
    }

    private BType resolveTypeNode(BLangType typeNode, AnalyzerData data, SymbolEnv env, DiagnosticCode diagCode) {
        if (typeNode == null) {
            return this.symTable.neverType;
        }
        SymbolEnv prevEnv = data.env;
        DiagnosticCode preDiagCode = data.diagCode;
        data.env = env;
        data.diagCode = diagCode;
        BType resultType = typeNode.apply(this, data);
        data.env = prevEnv;
        data.diagCode = preDiagCode;
        BType refType = Types.getImpliedType(resultType);
        if (refType != this.symTable.noType) {
            if (typeNode.nullable && resultType.tag == 21) {
                BUnionType unionType = (BUnionType)refType;
                unionType.add(this.symTable.nilType);
            } else if (typeNode.nullable && resultType.tag != 7 && resultType.tag != 18) {
                resultType = BUnionType.create(this.symTable.typeEnv(), null, resultType, this.symTable.nilType);
            } else if (typeNode.nullable && refType.tag != 7 && refType.tag != 18) {
                resultType = BUnionType.create(this.symTable.typeEnv(), null, resultType, this.symTable.nilType);
            }
        }
        this.validateDistinctType(typeNode, resultType);
        typeNode.setBType(resultType);
        return resultType;
    }

    public void validateDistinctType(BLangType typeNode, BType type) {
        if (typeNode.flagSet.contains((Object)Flag.DISTINCT) && !this.isDistinctAllowedOnType(type)) {
            this.dlog.error(typeNode.pos, DiagnosticErrorCode.DISTINCT_TYPING_ONLY_SUPPORT_OBJECTS_AND_ERRORS, new Object[0]);
        }
    }

    private boolean isDistinctAllowedOnType(BType type) {
        if (type.tag == 14) {
            return this.isDistinctAllowedOnType(Types.getImpliedType(type));
        }
        if (type.tag == 22) {
            for (BType constituentType : ((BIntersectionType)type).getConstituentTypes()) {
                if (this.isDistinctAllowedOnType(constituentType)) continue;
                return false;
            }
            return true;
        }
        if (type.tag == 21) {
            for (BType memberType : ((BUnionType)type).getMemberTypes()) {
                if (this.isDistinctAllowedOnType(memberType)) continue;
                return false;
            }
            return true;
        }
        return type.tag == 29 || type.tag == 34 || type.tag == 24 || type.tag == 28;
    }

    private BSymbol lookupSymbolForDecl(SymbolEnv env, Name name, long expSymTag) {
        Scope.ScopeEntry entry = env.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & expSymTag) == expSymTag) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        if (env.enclEnv != null) {
            return this.lookupSymbol(env.enclEnv, name, expSymTag);
        }
        return this.symTable.notFoundSymbol;
    }

    private BSymbol lookupSymbol(SymbolEnv env, Name name, long expSymTag) {
        Scope.ScopeEntry entry = env.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & expSymTag) == expSymTag && !this.isFieldRefFromWithinARecord(entry.symbol, env)) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        if (env.enclEnv != null) {
            return this.lookupSymbol(env.enclEnv, name, expSymTag);
        }
        return this.symTable.notFoundSymbol;
    }

    private boolean isFieldRefFromWithinARecord(BSymbol symbol, SymbolEnv env) {
        return (symbol.owner.tag & 0x2805CL) == 163932L && env.enclType != null && env.enclType.getKind() == NodeKind.RECORD_TYPE;
    }

    public BSymbol lookupSymbolInMainSpace(SymbolEnv env, Name name) {
        return this.lookupSymbol(env, name, 4L);
    }

    public BSymbol lookupSymbolInAnnotationSpace(SymbolEnv env, Name name) {
        return this.lookupSymbol(env, name, 2L);
    }

    public BSymbol lookupSymbolInPrefixSpace(SymbolEnv env, Name name) {
        return this.lookupSymbol(env, name, 1L);
    }

    public BSymbol lookupSymbolInConstructorSpace(SymbolEnv env, Name name) {
        return this.lookupSymbol(env, name, 0x4000100L);
    }

    public BSymbol lookupLangLibMethod(BType type, Name name, SymbolEnv env) {
        BSymbol bSymbol;
        BType referredType = Types.getImpliedType(type);
        if (this.symTable.langAnnotationModuleSymbol == null) {
            return this.symTable.notFoundSymbol;
        }
        switch (referredType.tag) {
            case 20: 
            case 31: {
                bSymbol = this.lookupMethodInModule(this.symTable.langArrayModuleSymbol, name, env);
                break;
            }
            case 4: {
                bSymbol = this.lookupMethodInModule(this.symTable.langDecimalModuleSymbol, name, env);
                break;
            }
            case 29: {
                bSymbol = this.lookupMethodInModule(this.symTable.langErrorModuleSymbol, name, env);
                break;
            }
            case 3: {
                bSymbol = this.lookupMethodInModule(this.symTable.langFloatModuleSymbol, name, env);
                break;
            }
            case 32: {
                bSymbol = this.lookupMethodInModule(this.symTable.langFutureModuleSymbol, name, env);
                break;
            }
            case 1: 
            case 2: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                bSymbol = this.lookupMethodInModule(this.symTable.langIntModuleSymbol, name, env);
                break;
            }
            case 12: 
            case 16: {
                bSymbol = this.lookupMethodInModule(this.symTable.langMapModuleSymbol, name, env);
                break;
            }
            case 34: {
                bSymbol = this.lookupMethodInModule(this.symTable.langObjectModuleSymbol, name, env);
                break;
            }
            case 15: {
                bSymbol = this.lookupMethodInModule(this.symTable.langStreamModuleSymbol, name, env);
                break;
            }
            case 9: {
                bSymbol = this.lookupMethodInModule(this.symTable.langTableModuleSymbol, name, env);
                break;
            }
            case 5: 
            case 45: {
                bSymbol = this.lookupMethodInModule(this.symTable.langStringModuleSymbol, name, env);
                break;
            }
            case 13: {
                bSymbol = this.lookupMethodInModule(this.symTable.langTypedescModuleSymbol, name, env);
                break;
            }
            case 8: 
            case 46: 
            case 47: 
            case 48: {
                bSymbol = this.lookupMethodInModule(this.symTable.langXmlModuleSymbol, name, env);
                break;
            }
            case 49: {
                bSymbol = this.lookupMethodInModule(this.symTable.langXmlModuleSymbol, name, env);
                if (bSymbol != this.symTable.notFoundSymbol) break;
                bSymbol = this.lookupMethodInModule(this.symTable.langStringModuleSymbol, name, env);
                break;
            }
            case 6: {
                bSymbol = this.lookupMethodInModule(this.symTable.langBooleanModuleSymbol, name, env);
                break;
            }
            case 21: {
                Iterator itr = ((HashSet)((BUnionType)referredType).getMemberTypes()).iterator();
                if (!itr.hasNext()) {
                    throw new IllegalArgumentException(String.format("Union type '%s' does not have member types", type));
                }
                BType member = Types.getImpliedType((BType)itr.next());
                if (TypeTags.isIntegerTypeTag(member.tag) || member.tag == 2) {
                    member = this.symTable.intType;
                } else if (TypeTags.isStringTypeTag(member.tag)) {
                    member = this.symTable.stringType;
                }
                if (this.types.isSubTypeOfBaseType(type, member.tag)) {
                    bSymbol = this.lookupLangLibMethod(member, name, env);
                    break;
                }
                bSymbol = this.symTable.notFoundSymbol;
                break;
            }
            case 33: {
                if (this.types.isAssignable(type, this.symTable.intType)) {
                    return this.lookupLangLibMethod(this.symTable.intType, name, env);
                }
                if (this.types.isAssignable(type, this.symTable.stringType)) {
                    return this.lookupLangLibMethod(this.symTable.stringType, name, env);
                }
                if (this.types.isAssignable(type, this.symTable.decimalType)) {
                    return this.lookupLangLibMethod(this.symTable.decimalType, name, env);
                }
                if (this.types.isAssignable(type, this.symTable.floatType)) {
                    return this.lookupLangLibMethod(this.symTable.floatType, name, env);
                }
                if (this.types.isAssignable(type, this.symTable.booleanType)) {
                    return this.lookupLangLibMethod(this.symTable.booleanType, name, env);
                }
                bSymbol = this.symTable.notFoundSymbol;
                break;
            }
            case 53: {
                bSymbol = this.lookupMethodInModule(this.symTable.langRegexpModuleSymbol, name, env);
                break;
            }
            default: {
                bSymbol = this.symTable.notFoundSymbol;
            }
        }
        if (bSymbol == this.symTable.notFoundSymbol && referredType.tag != 34) {
            bSymbol = this.lookupMethodInModule(this.symTable.langValueModuleSymbol, name, env);
        }
        if (bSymbol == this.symTable.notFoundSymbol) {
            bSymbol = this.lookupMethodInModule(this.symTable.langInternalModuleSymbol, name, env);
        }
        return bSymbol;
    }

    public BSymbol lookupClosureVarSymbol(SymbolEnv env, BSymbol symbol) {
        Scope.ScopeEntry entry = env.scope.lookup(symbol.name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if (entry.symbol == symbol) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        if (env.enclEnv == null || env.enclEnv.node == null) {
            return this.symTable.notFoundSymbol;
        }
        return this.lookupClosureVarSymbol(env.enclEnv, symbol);
    }

    public BSymbol lookupMainSpaceSymbolInPackage(Location pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return this.lookupSymbolInMainSpace(env, name);
        }
        BSymbol pkgSymbol = this.resolvePrefixSymbol(env, pkgAlias, Names.fromString(pos.lineRange().fileName()));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias.value);
            return pkgSymbol;
        }
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 4L);
    }

    public BSymbol lookupMainSpaceSymbolInPackage(BSymbol pkgSymbol, Location pos, SymbolEnv env, Name name) {
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 4L);
    }

    public BSymbol lookupPrefixSpaceSymbolInPackage(Location pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return this.lookupSymbolInPrefixSpace(env, name);
        }
        BSymbol pkgSymbol = this.resolvePrefixSymbol(env, pkgAlias, Names.fromString(pos.lineRange().fileName()));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias.value);
            return pkgSymbol;
        }
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 1L);
    }

    public BSymbol lookupAnnotationSpaceSymbolInPackage(Location pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return this.lookupSymbolInAnnotationSpace(env, name);
        }
        BSymbol pkgSymbol = this.resolvePrefixSymbol(env, pkgAlias, Names.fromString(pos.lineRange().fileName()));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias.value);
            return pkgSymbol;
        }
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 2L);
    }

    public BSymbol lookupConstructorSpaceSymbolInPackage(Location pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return this.lookupSymbolInConstructorSpace(env, name);
        }
        BSymbol pkgSymbol = this.resolvePrefixSymbol(env, pkgAlias, Names.fromString(pos.lineRange().fileName()));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias.value);
            return pkgSymbol;
        }
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 0x4000100L);
    }

    public BSymbol lookupMethodInModule(BPackageSymbol moduleSymbol, Name name, SymbolEnv env) {
        Scope.ScopeEntry entry = moduleSymbol.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0x334L) != 820L) {
                entry = entry.next;
                continue;
            }
            if (this.isMemberAccessAllowed(env, entry.symbol)) {
                return entry.symbol;
            }
            return this.symTable.notFoundSymbol;
        }
        return this.symTable.notFoundSymbol;
    }

    public BSymbol lookupMemberSymbol(Location pos, Scope scope, SymbolEnv env, Name name, long expSymTag) {
        Scope.ScopeEntry entry = scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & expSymTag) != expSymTag) {
                entry = entry.next;
                continue;
            }
            if (this.isMemberAccessAllowed(env, entry.symbol)) {
                return entry.symbol;
            }
            this.dlog.error(pos, DiagnosticErrorCode.ATTEMPT_REFER_NON_ACCESSIBLE_SYMBOL, entry.symbol.name);
            return this.symTable.notFoundSymbol;
        }
        return this.symTable.notFoundSymbol;
    }

    public BSymbol lookupPossibleMemberSymbol(Scope scope, Name name, long expSymTag) {
        Scope.ScopeEntry entry = scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & expSymTag) != expSymTag) {
                entry = entry.next;
                continue;
            }
            return entry.symbol;
        }
        return this.symTable.notFoundSymbol;
    }

    public Map<Name, BXMLNSSymbol> resolveAllNamespaces(SymbolEnv env) {
        LinkedHashMap<Name, BXMLNSSymbol> namespaces = new LinkedHashMap<Name, BXMLNSSymbol>();
        this.addNamespacesInScope(namespaces, env);
        return namespaces;
    }

    public void boostrapErrorType() {
        Scope.ScopeEntry entry = this.symTable.rootPkgSymbol.scope.lookup(Names.ERROR);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0xCL) != 12L) {
                entry = entry.next;
                continue;
            }
            this.symTable.errorType = (BErrorType)Types.getImpliedType(entry.symbol.type);
            this.symTable.detailType = (BMapType)this.symTable.errorType.detailType;
            return;
        }
        throw new IllegalStateException("built-in error not found ?");
    }

    public void defineOperators() {
        this.symTable.defineOperators();
    }

    public void bootstrapAnydataType() {
        Scope.ScopeEntry entry = this.symTable.langAnnotationModuleSymbol.scope.lookup(Names.ANYDATA);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0xCL) != 12L) {
                entry = entry.next;
                continue;
            }
            BUnionType type = (BUnionType)Types.getImpliedType(entry.symbol.type);
            this.symTable.anydataType = new BAnydataType(this.types.semTypeCtx, type);
            Optional<BIntersectionType> immutableType = Types.getImmutableType(this.symTable, PackageID.ANNOTATIONS, type);
            if (immutableType.isPresent()) {
                Types.addImmutableType(this.symTable, PackageID.ANNOTATIONS, this.symTable.anydataType, immutableType.get());
            }
            this.symTable.anydataOrReadonly = BUnionType.create(this.symTable.typeEnv(), null, this.symTable.anydataType, this.symTable.readonlyType);
            entry.symbol.type = this.symTable.anydataType;
            entry.symbol.origin = SymbolOrigin.BUILTIN;
            this.symTable.anydataType.tsymbol = new BTypeSymbol(12L, 1L, Names.ANYDATA, PackageID.ANNOTATIONS, this.symTable.anydataType, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.BUILTIN);
            return;
        }
        throw new IllegalStateException("built-in 'anydata' type not found");
    }

    public void bootstrapJsonType() {
        Scope.ScopeEntry entry = this.symTable.langAnnotationModuleSymbol.scope.lookup(Names.JSON);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0xCL) != 12L) {
                entry = entry.next;
                continue;
            }
            BUnionType type = (BUnionType)Types.getImpliedType(entry.symbol.type);
            this.symTable.jsonType = new BJSONType(this.types.semTypeCtx, type);
            Optional<BIntersectionType> immutableType = Types.getImmutableType(this.symTable, PackageID.ANNOTATIONS, type);
            if (immutableType.isPresent()) {
                Types.addImmutableType(this.symTable, PackageID.ANNOTATIONS, this.symTable.jsonType, immutableType.get());
            }
            this.symTable.jsonType.tsymbol = new BTypeSymbol(12L, 1L, Names.JSON, PackageID.ANNOTATIONS, this.symTable.jsonType, this.symTable.langAnnotationModuleSymbol, this.symTable.builtinPos, SymbolOrigin.BUILTIN);
            entry.symbol.type = this.symTable.jsonType;
            entry.symbol.origin = SymbolOrigin.BUILTIN;
            return;
        }
        throw new IllegalStateException("built-in 'json' type not found");
    }

    public void bootstrapCloneableType() {
        if (this.symTable.langValueModuleSymbol != null) {
            Scope.ScopeEntry entry = this.symTable.langValueModuleSymbol.scope.lookup(Names.CLONEABLE);
            while (entry != Scope.NOT_FOUND_ENTRY) {
                if ((entry.symbol.tag & 0xCL) != 12L) {
                    entry = entry.next;
                    continue;
                }
                this.symTable.cloneableType = (BUnionType)Types.getImpliedType(entry.symbol.type);
                this.symTable.cloneableType.tsymbol = new BTypeSymbol(12L, 1L, Names.CLONEABLE, PackageID.VALUE, this.symTable.cloneableType, this.symTable.langValueModuleSymbol, this.symTable.builtinPos, SymbolOrigin.BUILTIN);
                this.symTable.detailType = new BMapType(this.symTable.typeEnv(), 16, this.symTable.cloneableType, null);
                this.symTable.errorType = new BErrorType(this.symTable.typeEnv(), null, this.symTable.detailType);
                this.symTable.errorType.tsymbol = new BErrorTypeSymbol(294940L, 1L, Names.ERROR, this.symTable.rootPkgSymbol.pkgID, this.symTable.errorType, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.BUILTIN);
                this.symTable.errorOrNilType = BUnionType.create(this.symTable.typeEnv(), null, this.symTable.errorType, this.symTable.nilType);
                this.symTable.anyOrErrorType = BUnionType.create(this.symTable.typeEnv(), null, this.symTable.anyType, this.symTable.errorType);
                this.symTable.mapAllType = new BMapType(this.symTable.typeEnv(), 16, this.symTable.anyOrErrorType, null);
                this.symTable.arrayAllType = new BArrayType(this.symTable.typeEnv(), this.symTable.anyOrErrorType);
                this.symTable.typeDesc.constraint = this.symTable.anyOrErrorType;
                this.symTable.futureType.constraint = this.symTable.anyOrErrorType;
                this.symTable.pureType = BUnionType.create(this.symTable.typeEnv(), null, this.symTable.anydataType, this.symTable.errorType);
                return;
            }
            throw new IllegalStateException("built-in 'lang.value:Cloneable' type not found");
        }
        Scope.ScopeEntry entry = this.symTable.rootPkgSymbol.scope.lookup(Names.CLONEABLE_INTERNAL);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0xCL) != 12L) {
                entry = entry.next;
                continue;
            }
            entry.symbol.type = this.symTable.cloneableType;
            break;
        }
    }

    public void bootstrapIntRangeType() {
        Scope.ScopeEntry entry = this.symTable.langInternalModuleSymbol.scope.lookup(Names.CREATE_INT_RANGE);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0x100L) != 256L) {
                entry = entry.next;
                continue;
            }
            this.symTable.intRangeType = (BObjectType)Types.getImpliedType(((BInvokableType)entry.symbol.type).retType);
            this.symTable.defineIntRangeOperations();
            return;
        }
        throw new IllegalStateException("built-in Integer Range type not found ?");
    }

    public void bootstrapIterableType() {
        Scope.ScopeEntry entry = this.symTable.langObjectModuleSymbol.scope.lookup(Names.OBJECT_ITERABLE);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0xCL) != 12L) {
                entry = entry.next;
                continue;
            }
            this.symTable.iterableType = (BObjectType)Types.getImpliedType(entry.symbol.type);
            return;
        }
        throw new IllegalStateException("built-in distinct Iterable type not found ?");
    }

    public void loadRawTemplateType() {
        Scope.ScopeEntry entry = this.symTable.langObjectModuleSymbol.scope.lookup(Names.RAW_TEMPLATE);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0xCL) != 12L) {
                entry = entry.next;
                continue;
            }
            this.symTable.rawTemplateType = (BObjectType)entry.symbol.type;
            return;
        }
        throw new IllegalStateException("'lang.object:RawTemplate' type not found");
    }

    public void loadNaturalGeneratorType() {
        Scope.ScopeEntry entry = this.symTable.langNaturalModuleSymbol.scope.lookup(Names.NATURAL_GENERATOR);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            BSymbol symbol = entry.symbol;
            if ((symbol.tag & 0xCL) != 12L) {
                entry = entry.next;
                continue;
            }
            this.symTable.naturalGeneratorType = (BObjectType)symbol.type;
            return;
        }
        throw new IllegalStateException("'lang.natural:Generator' type not found");
    }

    @Override
    public BType transform(BLangValueType valueTypeNode, AnalyzerData data) {
        return this.visitBuiltInTypeNode(valueTypeNode, data, valueTypeNode.typeKind);
    }

    @Override
    public BType transform(BLangBuiltInRefTypeNode builtInRefType, AnalyzerData data) {
        return this.visitBuiltInTypeNode(builtInRefType, data, builtInRefType.typeKind);
    }

    @Override
    public BType transform(BLangArrayType arrayTypeNode, AnalyzerData data) {
        BType resultType = this.resolveTypeNode(arrayTypeNode.elemtype, data, data.env, data.diagCode);
        if (resultType == this.symTable.noType) {
            return resultType;
        }
        boolean isError = false;
        for (int i = 0; i < arrayTypeNode.dimensions; ++i) {
            BArrayType arrType;
            BTypeSymbol arrayTypeSymbol = Symbols.createTypeSymbol(8421404L, 1L, Names.EMPTY, data.env.enclPkg.symbol.pkgID, null, data.env.scope.owner, arrayTypeNode.pos, SymbolOrigin.SOURCE);
            if (arrayTypeNode.sizes.isEmpty()) {
                arrType = new BArrayType(this.symTable.typeEnv(), resultType, arrayTypeSymbol);
            } else {
                BLangExpression size = arrayTypeNode.sizes.get(i);
                if (size.getKind() == NodeKind.LITERAL || size.getKind() == NodeKind.NUMERIC_LITERAL) {
                    Integer sizeIndicator = (Integer)((BLangLiteral)size).getValue();
                    BArrayState arrayState = sizeIndicator == -1 ? BArrayState.OPEN : (sizeIndicator == -2 ? BArrayState.INFERRED : BArrayState.CLOSED);
                    arrType = new BArrayType(this.symTable.typeEnv(), resultType, arrayTypeSymbol, sizeIndicator, arrayState);
                } else {
                    int length;
                    BSymbol sizeSymbol;
                    if (size.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
                        this.dlog.error(size.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.intType, ((BLangTypedescExpr)size).getTypeNode());
                        isError = true;
                        continue;
                    }
                    BLangSimpleVarRef sizeReference = (BLangSimpleVarRef)size;
                    Name pkgAlias = this.names.fromIdNode(sizeReference.pkgAlias);
                    Name typeName = this.names.fromIdNode(sizeReference.variableName);
                    sizeReference.symbol = sizeSymbol = this.lookupMainSpaceSymbolInPackage(size.pos, data.env, pkgAlias, typeName);
                    if (this.symTable.notFoundSymbol == sizeSymbol) {
                        this.dlog.error(arrayTypeNode.pos, DiagnosticErrorCode.UNDEFINED_SYMBOL, size);
                        isError = true;
                        continue;
                    }
                    if (sizeSymbol.tag != 0x100001CL) {
                        this.dlog.error(size.pos, DiagnosticErrorCode.INVALID_ARRAY_SIZE_REFERENCE, sizeSymbol);
                        isError = true;
                        continue;
                    }
                    BConstantSymbol sizeConstSymbol = (BConstantSymbol)sizeSymbol;
                    BType lengthLiteralType = Types.getImpliedType(sizeConstSymbol.literalType);
                    if (lengthLiteralType.tag != 1) {
                        this.dlog.error(size.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.intType, sizeConstSymbol.literalType);
                        isError = true;
                        continue;
                    }
                    long lengthCheck = Long.parseLong(sizeConstSymbol.type.toString());
                    if (lengthCheck > 0x7FFFFFF5L) {
                        length = 0;
                        this.dlog.error(size.pos, DiagnosticErrorCode.ARRAY_LENGTH_GREATER_THAT_2147483637_NOT_YET_SUPPORTED, new Object[0]);
                    } else if (lengthCheck < 0L) {
                        length = 0;
                        this.dlog.error(size.pos, DiagnosticErrorCode.INVALID_ARRAY_LENGTH, new Object[0]);
                    } else {
                        length = (int)lengthCheck;
                    }
                    arrType = new BArrayType(this.symTable.typeEnv(), resultType, arrayTypeSymbol, length, BArrayState.CLOSED);
                }
            }
            resultType = arrayTypeSymbol.type = arrType;
            this.markParameterizedType((BType)arrType, arrType.eType);
        }
        if (isError) {
            resultType = this.symTable.semanticError;
        }
        return resultType;
    }

    @Override
    public BType transform(BLangUnionTypeNode unionTypeNode, AnalyzerData data) {
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
        for (BLangType langType : unionTypeNode.memberTypeNodes) {
            memberTypes.add(this.resolveTypeNode(langType, data.env));
        }
        if (memberTypes.contains(this.symTable.noType)) {
            return this.symTable.noType;
        }
        BTypeSymbol unionTypeSymbol = Symbols.createTypeSymbol(1081372L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, data.env.enclPkg.symbol.pkgID, null, data.env.scope.owner, unionTypeNode.pos, SymbolOrigin.SOURCE);
        BUnionType unionType = BUnionType.create(this.symTable.typeEnv(), unionTypeSymbol, memberTypes);
        unionTypeSymbol.type = unionType;
        this.markParameterizedType((BType)unionType, memberTypes);
        return unionType;
    }

    @Override
    public BType transform(BLangIntersectionTypeNode intersectionTypeNode, AnalyzerData data) {
        return this.computeIntersectionType(intersectionTypeNode, data);
    }

    @Override
    public BType transform(BLangObjectTypeNode objectTypeNode, AnalyzerData data) {
        EnumSet<Flag> flags = EnumSet.copyOf(objectTypeNode.flagSet);
        if (objectTypeNode.isAnonymous) {
            flags.add(Flag.PUBLIC);
        }
        int typeFlags = 0;
        if (flags.contains((Object)Flag.READONLY)) {
            typeFlags = (int)((long)typeFlags | 0x20L);
        }
        if (flags.contains((Object)Flag.ISOLATED)) {
            typeFlags = (int)((long)typeFlags | 0x20000000L);
        }
        if (flags.contains((Object)Flag.SERVICE)) {
            typeFlags = (int)((long)typeFlags | 0x40000L);
        }
        BObjectTypeSymbol objectSymbol = Symbols.createObjectSymbol(Flags.asMask(flags), Names.EMPTY, data.env.enclPkg.symbol.pkgID, null, data.env.scope.owner, objectTypeNode.pos, SymbolOrigin.SOURCE);
        BObjectType objectType = new BObjectType(this.symTable.typeEnv(), (BTypeSymbol)objectSymbol, (long)typeFlags);
        objectSymbol.type = objectType;
        objectTypeNode.symbol = objectSymbol;
        return objectType;
    }

    @Override
    public BType transform(BLangRecordTypeNode recordTypeNode, AnalyzerData data) {
        if (recordTypeNode.symbol == null) {
            EnumSet<Flag> flags = recordTypeNode.isAnonymous ? EnumSet.of(Flag.PUBLIC, Flag.ANONYMOUS) : EnumSet.noneOf(Flag.class);
            BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(Flags.asMask(flags), Names.EMPTY, data.env.enclPkg.symbol.pkgID, null, data.env.scope.owner, recordTypeNode.pos, recordTypeNode.isAnonymous ? SymbolOrigin.VIRTUAL : SymbolOrigin.SOURCE);
            BRecordType recordType = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)recordSymbol);
            recordSymbol.type = recordType;
            recordTypeNode.symbol = recordSymbol;
            if (data.env.node.getKind() != NodeKind.PACKAGE) {
                recordSymbol.name = Names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(data.env.enclPkg.packageID));
                this.symbolEnter.defineSymbol(recordTypeNode.pos, recordTypeNode.symbol, data.env);
                this.symbolEnter.defineNode(recordTypeNode, data.env);
            }
            return recordType;
        }
        return recordTypeNode.symbol.type;
    }

    @Override
    public BType transform(BLangStreamType streamTypeNode, AnalyzerData data) {
        BType error;
        BType type = this.resolveTypeNode(streamTypeNode.type, data, data.env);
        BType constraintType = this.resolveTypeNode(streamTypeNode.constraint, data, data.env);
        BType bType = error = streamTypeNode.error != null ? this.resolveTypeNode(streamTypeNode.error, data, data.env) : this.symTable.nilType;
        if (constraintType == this.symTable.noType) {
            return this.symTable.noType;
        }
        BStreamType streamType = new BStreamType(this.symTable.typeEnv(), 15, constraintType, error, null);
        BTypeSymbol typeSymbol = type.tsymbol;
        streamType.tsymbol = Symbols.createTypeSymbol(typeSymbol.tag, typeSymbol.flags, typeSymbol.name, typeSymbol.originalName, typeSymbol.pkgID, streamType, data.env.scope.owner, streamTypeNode.pos, SymbolOrigin.SOURCE);
        this.markParameterizedType((BType)streamType, constraintType);
        if (error != null) {
            this.markParameterizedType((BType)streamType, error);
        }
        return streamType;
    }

    @Override
    public BType transform(BLangTableTypeNode tableTypeNode, AnalyzerData data) {
        BType type = this.resolveTypeNode(tableTypeNode.type, data, data.env);
        BType constraintType = this.resolveTypeNode(tableTypeNode.constraint, data, data.env);
        if (constraintType == this.symTable.noType) {
            return this.symTable.noType;
        }
        BTableType tableType = new BTableType(this.symTable.typeEnv(), constraintType, null);
        BTypeSymbol typeSymbol = type.tsymbol;
        tableType.tsymbol = Symbols.createTypeSymbol(12L, Flags.asMask(EnumSet.noneOf(Flag.class)), typeSymbol.name, typeSymbol.originalName, typeSymbol.pkgID, tableType, data.env.scope.owner, tableTypeNode.pos, SymbolOrigin.SOURCE);
        tableType.tsymbol.flags = typeSymbol.flags;
        tableType.constraintPos = tableTypeNode.constraint.pos;
        tableType.isTypeInlineDefined = tableTypeNode.isTypeInlineDefined;
        if (tableTypeNode.tableKeyTypeConstraint != null) {
            tableType.keyTypeConstraint = this.resolveTypeNode(tableTypeNode.tableKeyTypeConstraint.keyType, data, data.env);
            tableType.keyPos = tableTypeNode.tableKeyTypeConstraint.pos;
        } else if (tableTypeNode.tableKeySpecifier != null) {
            BLangTableKeySpecifier tableKeySpecifier = tableTypeNode.tableKeySpecifier;
            ArrayList<String> fieldNameList = new ArrayList<String>();
            for (IdentifierNode identifier : tableKeySpecifier.fieldNameIdentifierList) {
                fieldNameList.add(((BLangIdentifier)identifier).value);
            }
            tableType.fieldNameList = fieldNameList;
            tableType.keyPos = tableKeySpecifier.pos;
        }
        if (!(Types.getImpliedType((BType)constraintType).tag != 16 || tableType.fieldNameList.isEmpty() && tableType.keyTypeConstraint == null || tableType.tsymbol.owner.getFlags().contains((Object)Flag.LANG_LIB))) {
            this.dlog.error(tableType.keyPos, DiagnosticErrorCode.KEY_CONSTRAINT_NOT_SUPPORTED_FOR_TABLE_WITH_MAP_CONSTRAINT, new Object[0]);
            return this.symTable.semanticError;
        }
        this.markParameterizedType((BType)tableType, constraintType);
        tableTypeNode.tableType = tableType;
        return tableType;
    }

    @Override
    public BType transform(BLangFiniteTypeNode finiteTypeNode, AnalyzerData data) {
        return this.typeResolver.resolveSingletonType(finiteTypeNode, data.env);
    }

    @Override
    public BType transform(BLangTupleTypeNode tupleTypeNode, AnalyzerData data) {
        ArrayList<BLangSimpleVariable> members = new ArrayList<BLangSimpleVariable>(tupleTypeNode.members.size());
        BTypeSymbol tupleTypeSymbol = Symbols.createTypeSymbol(4227100L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, data.env.enclPkg.symbol.pkgID, null, data.env.scope.owner, tupleTypeNode.pos, SymbolOrigin.SOURCE);
        SymbolEnv tupleEnv = SymbolEnv.createTypeEnv(tupleTypeNode, new Scope(tupleTypeSymbol), data.env);
        boolean hasUndefinedMember = false;
        for (BLangSimpleVariable member2 : tupleTypeNode.members) {
            BType bType = member2.getBType();
            if (bType == null) {
                this.symbolEnter.defineNode(member2, tupleEnv);
            } else if (bType == this.symTable.noType) {
                member2.setBType(null);
                this.symbolEnter.defineNode(member2, tupleEnv);
            }
            if (member2.getBType() == this.symTable.noType) {
                hasUndefinedMember = true;
            }
            members.add(member2);
        }
        if (hasUndefinedMember) {
            return this.symTable.noType;
        }
        ArrayList<BTupleMember> tupleMembers = new ArrayList<BTupleMember>();
        members.forEach(member -> tupleMembers.add(new BTupleMember(member.getBType(), new BVarSymbol(member.getBType().getFlags(), member.symbol.name, member.symbol.pkgID, member.getBType(), member.symbol.owner, member.pos, SymbolOrigin.SOURCE))));
        BTupleType tupleType = new BTupleType(this.symTable.typeEnv(), tupleTypeSymbol, tupleMembers);
        tupleTypeSymbol.type = tupleType;
        if (tupleTypeNode.restParamType != null) {
            BType tupleRestType = this.resolveTypeNode(tupleTypeNode.restParamType, data, data.env);
            if (tupleRestType == this.symTable.noType) {
                return this.symTable.noType;
            }
            tupleType.restType = tupleRestType;
            this.markParameterizedType((BType)tupleType, tupleType.restType);
        }
        this.markParameterizedType((BType)tupleType, tupleType.getTupleTypes());
        return tupleType;
    }

    @Override
    public BType transform(BLangErrorType errorTypeNode, AnalyzerData data) {
        BType detailType = Optional.ofNullable(errorTypeNode.detailType).map(bLangType -> this.resolveTypeNode((BLangType)bLangType, data, data.env)).orElse(this.symTable.detailType);
        if (errorTypeNode.isAnonymous) {
            errorTypeNode.flagSet.add(Flag.PUBLIC);
            errorTypeNode.flagSet.add(Flag.ANONYMOUS);
        }
        BErrorType bErrorType = this.symTable.errorType;
        boolean distinctErrorDef = errorTypeNode.flagSet.contains((Object)Flag.DISTINCT);
        if (detailType == this.symTable.detailType && !distinctErrorDef && !data.env.enclPkg.packageID.equals(PackageID.ANNOTATIONS)) {
            return bErrorType;
        }
        BErrorTypeSymbol errorTypeSymbol = Symbols.createErrorSymbol(Flags.asMask(errorTypeNode.flagSet), Names.EMPTY, data.env.enclPkg.packageID, null, data.env.scope.owner, errorTypeNode.pos, SymbolOrigin.SOURCE);
        PackageID packageID = data.env.enclPkg.packageID;
        if (data.env.node.getKind() != NodeKind.PACKAGE) {
            errorTypeSymbol.name = Names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(packageID));
            this.symbolEnter.defineSymbol(errorTypeNode.pos, errorTypeSymbol, data.env);
        }
        BErrorType errorType = new BErrorType(this.symTable.typeEnv(), (BTypeSymbol)errorTypeSymbol, detailType);
        errorType.addFlags(errorTypeSymbol.flags);
        errorTypeSymbol.type = errorType;
        this.markParameterizedType((BType)errorType, detailType);
        errorType.typeIdSet = BTypeIdSet.emptySet();
        if (errorTypeNode.isAnonymous && errorTypeNode.flagSet.contains((Object)Flag.DISTINCT)) {
            errorType.typeIdSet.add(BTypeIdSet.from(packageID, this.anonymousModelHelper.getNextAnonymousTypeId(packageID), true));
        }
        return errorType;
    }

    @Override
    public BType transform(BLangConstrainedType constrainedTypeNode, AnalyzerData data) {
        BType constrainedType;
        BType type = this.resolveTypeNode(constrainedTypeNode.type, data, data.env);
        BType constraintType = this.resolveTypeNode(constrainedTypeNode.constraint, data, data.env);
        if (constraintType == this.symTable.noType) {
            return this.symTable.noType;
        }
        if (type.tag == 32) {
            constrainedType = new BFutureType(this.symTable.typeEnv(), constraintType, null);
        } else if (type.tag == 16) {
            constrainedType = new BMapType(this.symTable.typeEnv(), 16, constraintType, null);
        } else if (type.tag == 13) {
            constrainedType = new BTypedescType(this.symTable.typeEnv(), constraintType, null);
        } else if (type.tag == 8) {
            if (Types.getImpliedType((BType)constraintType).tag == 52) {
                BType typedescType = ((BParameterizedType)constraintType).paramSymbol.type;
                BType typedescConstraint = ((BTypedescType)typedescType).constraint;
                this.validateXMLConstraintType(typedescConstraint, constrainedTypeNode.pos);
            } else {
                this.validateXMLConstraintType(constraintType, constrainedTypeNode.pos);
            }
            constrainedType = new BXMLType(constraintType, null);
        } else {
            return this.symTable.neverType;
        }
        BTypeSymbol typeSymbol = type.tsymbol;
        constrainedType.tsymbol = Symbols.createTypeSymbol(typeSymbol.tag, typeSymbol.flags, typeSymbol.name, typeSymbol.originalName, typeSymbol.pkgID, constrainedType, typeSymbol.owner, constrainedTypeNode.pos, SymbolOrigin.SOURCE);
        this.markParameterizedType(constrainedType, constraintType);
        return constrainedType;
    }

    public void validateXMLConstraintType(BType type, Location pos) {
        if (!SemTypeHelper.isSubtypeSimple(type, PredefinedType.XML)) {
            this.dlog.error(pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_CONSTRAINT, this.symTable.xmlType, type);
        }
    }

    @Override
    public BType transform(BLangUserDefinedType userDefinedTypeNode, AnalyzerData data) {
        boolean isCloneableTypeDef;
        String name = userDefinedTypeNode.typeName.value;
        BLangIdentifier pkgAliasIdentifier = userDefinedTypeNode.pkgAlias;
        Name pkgAlias = this.names.fromIdNode(pkgAliasIdentifier);
        BLangIdentifier typeNameIdentifier = userDefinedTypeNode.typeName;
        Name typeName = this.names.fromIdNode(typeNameIdentifier);
        BSymbol symbol = this.symTable.notFoundSymbol;
        SymbolEnv env = data.env;
        if (env.scope.owner.tag == 2L) {
            symbol = this.lookupAnnotationSpaceSymbolInPackage(userDefinedTypeNode.pos, env, pkgAlias, typeName);
        }
        if (symbol == this.symTable.notFoundSymbol) {
            BSymbol refSymbol;
            BSymbol tempSymbol = this.lookupMainSpaceSymbolInPackage(userDefinedTypeNode.pos, env, pkgAlias, typeName);
            BSymbol bSymbol = refSymbol = tempSymbol.tag == 32796L ? Types.getImpliedType((BType)tempSymbol.type).tsymbol : tempSymbol;
            if (refSymbol == null) {
                refSymbol = tempSymbol;
            }
            NodeKind envNodeKind = data.env.node.getKind();
            if ((refSymbol.tag & 0xCL) == 12L) {
                symbol = tempSymbol;
            } else if (Symbols.isTagOn(refSymbol, 52L) && (envNodeKind == NodeKind.FUNCTION || envNodeKind == NodeKind.RESOURCE_FUNC)) {
                BType paramValType;
                BLangFunction func = (BLangFunction)data.env.node;
                boolean errored = false;
                if (func.returnTypeNode == null || func.hasBody() && func.body.getKind() != NodeKind.EXTERN_FUNCTION_BODY) {
                    this.dlog.error(userDefinedTypeNode.pos, DiagnosticErrorCode.INVALID_NON_EXTERNAL_DEPENDENTLY_TYPED_FUNCTION, new Object[0]);
                    errored = true;
                }
                if (tempSymbol.type != null && Types.getImpliedType((BType)tempSymbol.type).tag != 13) {
                    this.dlog.error(userDefinedTypeNode.pos, DiagnosticErrorCode.INVALID_PARAM_TYPE_FOR_RETURN_TYPE, tempSymbol.type);
                    errored = true;
                }
                if (errored) {
                    return this.symTable.semanticError;
                }
                ParameterizedTypeInfo parameterizedTypeInfo = this.getTypedescParamValueType(func.requiredParams, data, refSymbol);
                BType bType = paramValType = parameterizedTypeInfo == null ? null : parameterizedTypeInfo.paramValueType;
                if (paramValType == this.symTable.semanticError) {
                    return this.symTable.semanticError;
                }
                if (paramValType != null) {
                    BTypeSymbol tSymbol = new BTypeSymbol(12L, 0x4000000L | tempSymbol.flags, tempSymbol.name, tempSymbol.originalName, tempSymbol.pkgID, null, func.symbol, tempSymbol.pos, SymbolOrigin.VIRTUAL);
                    tSymbol.type = new BParameterizedType(paramValType, (BVarSymbol)tempSymbol, tSymbol, tempSymbol.name, parameterizedTypeInfo.index);
                    tSymbol.type.addFlags(0x4000000L);
                    userDefinedTypeNode.symbol = tSymbol;
                    return tSymbol.type;
                }
            } else if (Symbols.isTagOn(tempSymbol, 52L) && (env.node.getKind() == NodeKind.FUNCTION_TYPE || env.node.getKind() == NodeKind.TUPLE_TYPE_NODE)) {
                BType paramValType;
                SymbolEnv symbolEnv = env;
                BLangFunction func = null;
                BLangFunctionTypeNode funcTypeNode = null;
                ParameterizedTypeInfo parameterizedTypeInfo = null;
                while ((symbolEnv.node.getKind() == NodeKind.FUNCTION_TYPE || symbolEnv.node.getKind() == NodeKind.FUNCTION || symbolEnv.node.getKind() == NodeKind.TUPLE_TYPE_NODE) && parameterizedTypeInfo == null) {
                    if (symbolEnv.node.getKind() == NodeKind.FUNCTION_TYPE) {
                        funcTypeNode = (BLangFunctionTypeNode)symbolEnv.node;
                        parameterizedTypeInfo = this.getTypedescParamValueType(funcTypeNode.params, data, tempSymbol);
                    } else if (symbolEnv.node.getKind() == NodeKind.FUNCTION) {
                        func = (BLangFunction)symbolEnv.node;
                        parameterizedTypeInfo = this.getTypedescParamValueType(func.requiredParams, data, tempSymbol);
                    }
                    symbolEnv = symbolEnv.enclEnv;
                }
                BType bType = paramValType = parameterizedTypeInfo == null ? null : parameterizedTypeInfo.paramValueType;
                if (paramValType == this.symTable.semanticError) {
                    return this.symTable.semanticError;
                }
                BSymbol bSymbol2 = null;
                if (func != null) {
                    bSymbol2 = func.symbol;
                } else if (funcTypeNode != null) {
                    bSymbol2 = funcTypeNode.getBType().tsymbol;
                }
                if (paramValType != null) {
                    BTypeSymbol tSymbol = new BTypeSymbol(12L, 0x4000000L | tempSymbol.flags, tempSymbol.name, tempSymbol.pkgID, null, bSymbol2, tempSymbol.pos, SymbolOrigin.VIRTUAL);
                    tSymbol.type = new BParameterizedType(paramValType, (BVarSymbol)tempSymbol, tSymbol, tempSymbol.name, parameterizedTypeInfo.index);
                    tSymbol.type.addFlags(0x4000000L);
                    userDefinedTypeNode.symbol = tSymbol;
                    return tSymbol.type;
                }
            }
        }
        if (symbol == this.symTable.notFoundSymbol) {
            symbol = this.lookupMemberSymbol(userDefinedTypeNode.pos, this.symTable.rootScope, env, typeName, 20L);
        }
        if (env.logErrors && symbol == this.symTable.notFoundSymbol) {
            if (!this.missingNodesHelper.isMissingNode(pkgAlias) && !this.missingNodesHelper.isMissingNode(typeName) && !this.symbolEnter.isUnknownTypeRef(userDefinedTypeNode) && this.typeResolver.isNotUnknownTypeRef(userDefinedTypeNode)) {
                this.dlog.error(userDefinedTypeNode.pos, data.diagCode, typeName);
            }
            return this.symTable.semanticError;
        }
        userDefinedTypeNode.symbol = symbol;
        BType type = symbol.type;
        boolean bl = isCloneableTypeDef = type.tag == 21 && this.types.isCloneableType((BUnionType)type);
        if (symbol.kind == SymbolKind.TYPE_DEF && !Symbols.isFlagOn(symbol.flags, 2048L) && !isCloneableTypeDef) {
            BTypeReferenceType referenceType = ((BTypeDefinitionSymbol)symbol).referenceType;
            referenceType.addFlags(symbol.type.getFlags());
            referenceType.tsymbol.flags |= symbol.type.getFlags();
            return referenceType;
        }
        if (type.getKind() != TypeKind.OTHER) {
            return type;
        }
        return this.typeResolver.validateModuleLevelDef(name, pkgAlias, typeName, userDefinedTypeNode);
    }

    public ParameterizedTypeInfo getTypedescParamValueType(List<BLangSimpleVariable> params, AnalyzerData data, BSymbol varSym) {
        for (int i = 0; i < params.size(); ++i) {
            BLangSimpleVariable param = params.get(i);
            if (!param.name.value.equals(varSym.name.value)) continue;
            if (param.expr == null || param.expr.getKind() == NodeKind.INFER_TYPEDESC_EXPR) {
                return new ParameterizedTypeInfo(((BTypedescType)Types.getImpliedType((BType)varSym.type)).constraint, i);
            }
            NodeKind defaultValueExprKind = param.expr.getKind();
            if (defaultValueExprKind == NodeKind.TYPEDESC_EXPRESSION) {
                return new ParameterizedTypeInfo(this.resolveTypeNode(((BLangTypedescExpr)param.expr).typeNode, data, data.env), i);
            }
            if (defaultValueExprKind == NodeKind.SIMPLE_VARIABLE_REF) {
                Name varName = this.names.fromIdNode(((BLangSimpleVarRef)param.expr).variableName);
                BSymbol typeRefSym = this.lookupSymbolInMainSpace(data.env, varName);
                if (typeRefSym != this.symTable.notFoundSymbol) {
                    return new ParameterizedTypeInfo(typeRefSym.type, i);
                }
                return new ParameterizedTypeInfo(this.symTable.semanticError);
            }
            this.dlog.error(param.pos, DiagnosticErrorCode.INVALID_TYPEDESC_PARAM, new Object[0]);
            return new ParameterizedTypeInfo(this.symTable.semanticError);
        }
        return null;
    }

    @Override
    public BType transform(BLangFunctionTypeNode functionTypeNode, AnalyzerData data) {
        SymbolEnv env = data.env;
        if (functionTypeNode.getBType() == null) {
            BInvokableType invokableType;
            if (functionTypeNode.flagSet.contains((Object)Flag.ANY_FUNCTION)) {
                invokableType = new BInvokableType(this.symTable.typeEnv(), List.of(), null, null, null);
                invokableType.setFlags(Flags.asMask(functionTypeNode.flagSet));
                BInvokableTypeSymbol invokableTypeSymbol = Symbols.createInvokableTypeSymbol(33587228L, Flags.asMask(functionTypeNode.flagSet), env.enclPkg.symbol.pkgID, invokableType, env.scope.owner, functionTypeNode.pos, SymbolOrigin.VIRTUAL);
                invokableTypeSymbol.params = null;
                invokableTypeSymbol.restParam = null;
                invokableTypeSymbol.returnType = null;
                invokableType.tsymbol = invokableTypeSymbol;
            } else {
                BInvokableTypeSymbol invokableTypeSymbol = Symbols.createInvokableTypeSymbol(33587228L, Flags.asMask(functionTypeNode.flagSet), env.enclPkg.symbol.pkgID, functionTypeNode.getBType(), env.scope.owner, functionTypeNode.pos, SymbolOrigin.VIRTUAL);
                invokableType = new BInvokableType(this.symTable.typeEnv(), (BTypeSymbol)invokableTypeSymbol);
                invokableTypeSymbol.type = invokableType;
                invokableTypeSymbol.name = Names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(env.enclPkg.packageID));
                this.symbolEnter.defineSymbol(functionTypeNode.pos, invokableTypeSymbol, env);
                if (env.node.getKind() != NodeKind.PACKAGE || !functionTypeNode.inTypeDefinitionContext) {
                    functionTypeNode.setBType(invokableType);
                    this.symbolEnter.defineNode(functionTypeNode, env);
                }
            }
            List<BLangSimpleVariable> params = functionTypeNode.getParams();
            Location pos = functionTypeNode.pos;
            BLangType returnTypeNode = functionTypeNode.returnTypeNode;
            this.validateInferTypedescParams(pos, params, returnTypeNode == null ? null : invokableType);
            return invokableType;
        }
        return functionTypeNode.getBType();
    }

    public Map<Name, List<Scope.ScopeEntry>> getAllVisibleInScopeSymbols(SymbolEnv env) {
        HashMap<Name, List<Scope.ScopeEntry>> visibleEntries = new HashMap<Name, List<Scope.ScopeEntry>>();
        env.scope.entries.forEach((key, value) -> {
            ArrayList<Scope.ScopeEntry> entryList = new ArrayList<Scope.ScopeEntry>();
            entryList.add((Scope.ScopeEntry)value);
            visibleEntries.put((Name)key, (List<Scope.ScopeEntry>)entryList);
        });
        if (env.enclEnv != null) {
            this.getAllVisibleInScopeSymbols(env.enclEnv).forEach((name, entryList) -> {
                if (!visibleEntries.containsKey(name)) {
                    visibleEntries.put((Name)name, (List<Scope.ScopeEntry>)entryList);
                } else {
                    List scopeEntries = (List)visibleEntries.get(name);
                    entryList.forEach(scopeEntry -> {
                        if (!scopeEntries.contains(scopeEntry) && !this.isModuleLevelVar(scopeEntry.symbol)) {
                            scopeEntries.add(scopeEntry);
                        }
                    });
                }
            });
        }
        return visibleEntries;
    }

    public BSymbol getBinaryEqualityForTypeSets(OperatorKind opKind, BType lhsType, BType rhsType, BLangBinaryExpr binaryExpr, SymbolEnv env) {
        boolean validEqualityIntersectionExists;
        switch (opKind) {
            case EQUAL: 
            case NOT_EQUAL: {
                validEqualityIntersectionExists = this.types.validEqualityIntersectionExists(lhsType, rhsType);
                break;
            }
            case REF_EQUAL: 
            case REF_NOT_EQUAL: {
                validEqualityIntersectionExists = this.types.intersectionExists(lhsType.semType(), rhsType.semType());
                break;
            }
            default: {
                return this.symTable.notFoundSymbol;
            }
        }
        if (validEqualityIntersectionExists) {
            if (!this.types.isValueType(lhsType) && !this.types.isValueType(rhsType) || this.types.isValueType(lhsType) && this.types.isValueType(rhsType)) {
                return this.createEqualityOperator(opKind, lhsType, rhsType);
            }
            this.types.setImplicitCastExpr(binaryExpr.rhsExpr, rhsType, this.symTable.anyType);
            this.types.setImplicitCastExpr(binaryExpr.lhsExpr, lhsType, this.symTable.anyType);
            return switch (opKind) {
                case OperatorKind.REF_EQUAL -> this.createEqualityOperator(OperatorKind.EQUAL, this.symTable.anyType, this.symTable.anyType);
                case OperatorKind.REF_NOT_EQUAL -> this.createEqualityOperator(OperatorKind.NOT_EQUAL, this.symTable.anyType, this.symTable.anyType);
                default -> this.createEqualityOperator(opKind, this.symTable.anyType, this.symTable.anyType);
            };
        }
        return this.symTable.notFoundSymbol;
    }

    public BSymbol getBitwiseShiftOpsForTypeSets(OperatorKind opKind, BType lhsType, BType rhsType) {
        boolean validIntTypesExists;
        switch (opKind) {
            case BITWISE_LEFT_SHIFT: 
            case BITWISE_RIGHT_SHIFT: 
            case BITWISE_UNSIGNED_RIGHT_SHIFT: {
                validIntTypesExists = this.types.validIntegerTypeExists(lhsType) && this.types.validIntegerTypeExists(rhsType);
                break;
            }
            default: {
                return this.symTable.notFoundSymbol;
            }
        }
        if (validIntTypesExists) {
            switch (opKind) {
                case BITWISE_LEFT_SHIFT: {
                    return this.createShiftOperator(opKind, lhsType, rhsType);
                }
                case BITWISE_RIGHT_SHIFT: 
                case BITWISE_UNSIGNED_RIGHT_SHIFT: {
                    return switch (Types.getImpliedType((BType)lhsType).tag) {
                        case 2, 42, 43, 44 -> this.createBinaryOperator(opKind, lhsType, rhsType, lhsType);
                        default -> this.createShiftOperator(opKind, lhsType, rhsType);
                    };
                }
            }
        }
        return this.symTable.notFoundSymbol;
    }

    private BSymbol createShiftOperator(OperatorKind opKind, BType lhsType, BType rhsType) {
        if (lhsType.isNullable() || rhsType.isNullable()) {
            BUnionType intOptional = BUnionType.create(this.symTable.typeEnv(), null, this.symTable.intType, this.symTable.nilType);
            return this.createBinaryOperator(opKind, lhsType, rhsType, intOptional);
        }
        return this.createBinaryOperator(opKind, lhsType, rhsType, this.symTable.intType);
    }

    public BSymbol getArithmeticOpsForTypeSets(OperatorKind opKind, BType lhsType, BType rhsType) {
        boolean validNumericOrStringTypeExists;
        switch (opKind) {
            case ADD: {
                validNumericOrStringTypeExists = this.types.validNumericTypeExists(lhsType) && this.types.validNumericTypeExists(rhsType) || this.types.validStringOrXmlTypeExists(lhsType) && this.types.validStringOrXmlTypeExists(rhsType);
                break;
            }
            case SUB: 
            case DIV: 
            case MUL: 
            case MOD: {
                validNumericOrStringTypeExists = this.types.validNumericTypeExists(lhsType) && this.types.validNumericTypeExists(rhsType);
                break;
            }
            default: {
                return this.symTable.notFoundSymbol;
            }
        }
        if (validNumericOrStringTypeExists) {
            BType returnType;
            BType compatibleType2;
            BType compatibleType1 = lhsType.isNullable() ? this.types.findCompatibleType(this.types.getSafeType(lhsType, true, false)) : this.types.findCompatibleType(lhsType);
            if (compatibleType1 != (compatibleType2 = rhsType.isNullable() ? this.types.findCompatibleType(this.types.getSafeType(rhsType, true, false)) : this.types.findCompatibleType(rhsType)) && this.types.isBasicNumericType(compatibleType1) && !this.isIntFloatingPointMultiplication(opKind, compatibleType1, compatibleType2)) {
                return this.symTable.notFoundSymbol;
            }
            BType bType = returnType = compatibleType1.tag < compatibleType2.tag ? compatibleType2 : compatibleType1;
            if (lhsType.isNullable() || rhsType.isNullable()) {
                returnType = BUnionType.create(this.symTable.typeEnv(), null, returnType, this.symTable.nilType);
            }
            return this.createBinaryOperator(opKind, lhsType, rhsType, returnType);
        }
        return this.symTable.notFoundSymbol;
    }

    private boolean isIntFloatingPointMultiplication(OperatorKind opKind, BType lhsCompatibleType, BType rhsCompatibleType) {
        return switch (opKind) {
            case OperatorKind.MUL -> {
                if (lhsCompatibleType.tag == 1 && this.isFloatingPointType(rhsCompatibleType) || rhsCompatibleType.tag == 1 && this.isFloatingPointType(lhsCompatibleType)) {
                    yield true;
                }
                yield false;
            }
            case OperatorKind.DIV, OperatorKind.MOD -> {
                if (this.isFloatingPointType(lhsCompatibleType) && rhsCompatibleType.tag == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean isFloatingPointType(BType type) {
        return type.tag == 4 || type.tag == 3;
    }

    public BSymbol getUnaryOpsForTypeSets(OperatorKind opKind, BType type) {
        boolean validNumericTypeExists;
        switch (opKind) {
            case ADD: 
            case SUB: {
                validNumericTypeExists = this.types.validNumericTypeExists(type);
                break;
            }
            default: {
                return this.symTable.notFoundSymbol;
            }
        }
        if (!validNumericTypeExists) {
            return this.symTable.notFoundSymbol;
        }
        if (opKind == OperatorKind.ADD) {
            return this.createUnaryOperator(opKind, type, type);
        }
        if (type.isNullable()) {
            BType compatibleType = this.types.findCompatibleType(this.types.getSafeType(type, true, false));
            return this.createUnaryOperator(opKind, type, BUnionType.create(this.symTable.typeEnv(), null, compatibleType, this.symTable.nilType));
        }
        return this.createUnaryOperator(opKind, type, this.types.findCompatibleType(type));
    }

    public BSymbol getBinaryBitwiseOpsForTypeSets(OperatorKind opKind, BType lhsType, BType rhsType) {
        boolean validIntTypesExists;
        BType referredLhsType = Types.getImpliedType(lhsType);
        BType referredRhsType = Types.getImpliedType(rhsType);
        switch (opKind) {
            case BITWISE_AND: 
            case BITWISE_OR: 
            case BITWISE_XOR: {
                validIntTypesExists = this.types.validIntegerTypeExists(lhsType) && this.types.validIntegerTypeExists(rhsType);
                break;
            }
            default: {
                return this.symTable.notFoundSymbol;
            }
        }
        if (validIntTypesExists) {
            switch (opKind) {
                case BITWISE_AND: {
                    switch (referredLhsType.tag) {
                        case 2: 
                        case 42: 
                        case 43: 
                        case 44: {
                            return this.createBinaryOperator(opKind, lhsType, rhsType, lhsType);
                        }
                    }
                    switch (referredRhsType.tag) {
                        case 2: 
                        case 42: 
                        case 43: 
                        case 44: {
                            return this.createBinaryOperator(opKind, lhsType, rhsType, rhsType);
                        }
                    }
                    if (referredLhsType.isNullable() || referredRhsType.isNullable()) {
                        BUnionType intOptional = BUnionType.create(this.symTable.typeEnv(), null, this.symTable.intType, this.symTable.nilType);
                        return this.createBinaryOperator(opKind, lhsType, rhsType, intOptional);
                    }
                    return this.createBinaryOperator(opKind, lhsType, rhsType, this.symTable.intType);
                }
                case BITWISE_OR: 
                case BITWISE_XOR: {
                    if (referredLhsType.isNullable() || referredRhsType.isNullable()) {
                        BUnionType intOptional = BUnionType.create(this.symTable.typeEnv(), null, this.symTable.intType, this.symTable.nilType);
                        return this.createBinaryOperator(opKind, lhsType, rhsType, intOptional);
                    }
                    return this.createBinaryOperator(opKind, lhsType, rhsType, this.symTable.intType);
                }
            }
        }
        return this.symTable.notFoundSymbol;
    }

    public BSymbol getBinaryComparisonOpForTypeSets(OperatorKind opKind, BType lhsType, BType rhsType) {
        boolean validOrderedTypesExist;
        switch (opKind) {
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: {
                validOrderedTypesExist = this.types.comparable(lhsType, rhsType);
                break;
            }
            default: {
                return this.symTable.notFoundSymbol;
            }
        }
        if (validOrderedTypesExist) {
            return switch (opKind) {
                case OperatorKind.LESS_THAN -> this.createBinaryComparisonOperator(OperatorKind.LESS_THAN, lhsType, rhsType);
                case OperatorKind.LESS_EQUAL -> this.createBinaryComparisonOperator(OperatorKind.LESS_EQUAL, lhsType, rhsType);
                case OperatorKind.GREATER_THAN -> this.createBinaryComparisonOperator(OperatorKind.GREATER_THAN, lhsType, rhsType);
                default -> this.createBinaryComparisonOperator(OperatorKind.GREATER_EQUAL, lhsType, rhsType);
            };
        }
        return this.symTable.notFoundSymbol;
    }

    public BSymbol getRangeOpsForTypeSets(OperatorKind opKind, BType lhsType, BType rhsType) {
        boolean validIntTypesExists;
        if (opKind != OperatorKind.CLOSED_RANGE && opKind != OperatorKind.HALF_OPEN_RANGE) {
            return this.symTable.notFoundSymbol;
        }
        boolean bl = validIntTypesExists = this.types.validIntegerTypeExists(lhsType) && this.types.validIntegerTypeExists(rhsType);
        if (!validIntTypesExists) {
            return this.symTable.notFoundSymbol;
        }
        return this.createBinaryOperator(opKind, lhsType, rhsType, this.symTable.intRangeType);
    }

    public boolean isBinaryShiftOperator(OperatorKind binaryOpKind) {
        return binaryOpKind == OperatorKind.BITWISE_LEFT_SHIFT || binaryOpKind == OperatorKind.BITWISE_RIGHT_SHIFT || binaryOpKind == OperatorKind.BITWISE_UNSIGNED_RIGHT_SHIFT;
    }

    public boolean isArithmeticOperator(OperatorKind binaryOpKind) {
        return binaryOpKind == OperatorKind.ADD || binaryOpKind == OperatorKind.SUB || binaryOpKind == OperatorKind.DIV || binaryOpKind == OperatorKind.MUL || binaryOpKind == OperatorKind.MOD;
    }

    public boolean isBinaryComparisonOperator(OperatorKind binaryOpKind) {
        return binaryOpKind == OperatorKind.LESS_THAN || binaryOpKind == OperatorKind.LESS_EQUAL || binaryOpKind == OperatorKind.GREATER_THAN || binaryOpKind == OperatorKind.GREATER_EQUAL;
    }

    public boolean markParameterizedType(BType type, BType constituentType) {
        if (Symbols.isFlagOn(constituentType.getFlags(), 0x4000000L)) {
            type.tsymbol.flags |= 0x4000000L;
            type.addFlags(0x4000000L);
            return true;
        }
        return false;
    }

    public void markParameterizedType(BType enclosingType, Collection<BType> constituentTypes) {
        if (Symbols.isFlagOn(enclosingType.getFlags(), 0x4000000L)) {
            return;
        }
        for (BType type : constituentTypes) {
            if (type != null && this.markParameterizedType(enclosingType, type)) break;
        }
    }

    private BSymbol resolveOperator(Scope.ScopeEntry entry, List<BType> typeList) {
        BSymbol foundSymbol = this.symTable.notFoundSymbol;
        while (entry != Scope.NOT_FOUND_ENTRY) {
            BInvokableType opType = (BInvokableType)entry.symbol.type;
            if (typeList.size() == opType.paramTypes.size()) {
                boolean match = true;
                for (int i = 0; i < typeList.size(); ++i) {
                    BType t = Types.getImpliedType(typeList.get(i));
                    if (t.getKind() == TypeKind.UNION && opType.paramTypes.get(i).getKind() == TypeKind.UNION) {
                        if (this.types.isSameTypeIncludingTags(t, opType.paramTypes.get(i))) continue;
                        match = false;
                        continue;
                    }
                    if (t.tag == opType.paramTypes.get((int)i).tag) continue;
                    match = false;
                    break;
                }
                if (match) {
                    foundSymbol = entry.symbol;
                    break;
                }
            }
            entry = entry.next;
        }
        return foundSymbol;
    }

    public BType visitBuiltInTypeNode(BLangType typeNode, AnalyzerData data, TypeKind typeKind) {
        Name typeName = this.names.fromTypeKind(typeKind);
        BSymbol typeSymbol = this.lookupMemberSymbol(typeNode.pos, this.symTable.rootScope, data.env, typeName, 12L);
        if (typeSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(typeNode.pos, data.diagCode, typeName);
        }
        typeNode.setBType(typeSymbol.type);
        return typeSymbol.type;
    }

    private void addNamespacesInScope(Map<Name, BXMLNSSymbol> namespaces, SymbolEnv env) {
        if (env == null) {
            return;
        }
        env.scope.entries.forEach((name, scopeEntry) -> {
            if (scopeEntry.symbol.kind == SymbolKind.XMLNS) {
                BXMLNSSymbol nsSymbol = (BXMLNSSymbol)scopeEntry.symbol;
                if (!namespaces.containsKey(name)) {
                    namespaces.put((Name)name, nsSymbol);
                }
            }
        });
        this.addNamespacesInScope(namespaces, env.enclEnv);
    }

    private boolean isMemberAccessAllowed(SymbolEnv env, BSymbol symbol) {
        if (Symbols.isPublic(symbol)) {
            return true;
        }
        if (!Symbols.isPrivate(symbol)) {
            return env.enclPkg.symbol.pkgID.equals(symbol.pkgID);
        }
        if (env.enclType != null) {
            return env.enclType.getBType().tsymbol == symbol.owner;
        }
        return this.isMemberAllowed(env, symbol);
    }

    private boolean isMemberAllowed(SymbolEnv env, BSymbol symbol) {
        return env != null && (env.enclInvokable != null && env.enclInvokable.symbol.receiverSymbol != null && env.enclInvokable.symbol.receiverSymbol.type.tsymbol == symbol.owner || this.isMemberAllowed(env.enclEnv, symbol));
    }

    private BType computeIntersectionType(BLangIntersectionTypeNode intersectionTypeNode, AnalyzerData data) {
        boolean hasReadOnlyType;
        List<BLangType> constituentTypeNodes = intersectionTypeNode.constituentTypeNodes;
        HashMap<BType, BLangType> typeBLangTypeMap = new HashMap<BType, BLangType>();
        boolean validIntersection = true;
        boolean isErrorIntersection = false;
        boolean isAlreadyExistingType = false;
        BLangType bLangTypeOne = constituentTypeNodes.get(0);
        BType typeOne = this.resolveTypeNode(bLangTypeOne, data, data.env);
        if (typeOne == this.symTable.noType) {
            return this.symTable.noType;
        }
        typeBLangTypeMap.put(typeOne, bLangTypeOne);
        BLangType bLangTypeTwo = constituentTypeNodes.get(1);
        BType typeTwo = this.resolveTypeNode(bLangTypeTwo, data, data.env);
        if (typeTwo == this.symTable.noType) {
            return this.symTable.noType;
        }
        BType typeOneReference = Types.getImpliedType(typeOne);
        BType typeTwoReference = Types.getImpliedType(typeTwo);
        typeBLangTypeMap.put(typeTwo, bLangTypeTwo);
        boolean bl = hasReadOnlyType = typeOneReference == this.symTable.readonlyType || typeTwoReference == this.symTable.readonlyType;
        if (typeOneReference.tag == 29 || typeTwoReference.tag == 29) {
            isErrorIntersection = true;
        }
        if (!hasReadOnlyType && !isErrorIntersection) {
            this.dlog.error(intersectionTypeNode.pos, DiagnosticErrorCode.UNSUPPORTED_TYPE_INTERSECTION, new Object[0]);
            for (int i = 2; i < constituentTypeNodes.size(); ++i) {
                this.resolveTypeNode(constituentTypeNodes.get(i), data.env);
            }
            return this.symTable.semanticError;
        }
        BType potentialIntersectionType = this.getPotentialIntersection(Types.IntersectionContext.from(this.dlog, bLangTypeOne.pos, bLangTypeTwo.pos), typeOne, typeTwo, data.env);
        if (typeOne == potentialIntersectionType || typeTwo == potentialIntersectionType) {
            isAlreadyExistingType = true;
        }
        LinkedHashSet<BType> constituentBTypes = new LinkedHashSet<BType>();
        constituentBTypes.add(typeOne);
        constituentBTypes.add(typeTwo);
        if (potentialIntersectionType == this.symTable.semanticError) {
            validIntersection = false;
        } else {
            for (int i = 2; i < constituentTypeNodes.size(); ++i) {
                BLangType bLangType = constituentTypeNodes.get(i);
                BType type = this.resolveTypeNode(bLangType, data, data.env);
                if (Types.getImpliedType((BType)type).tag == 29) {
                    isErrorIntersection = true;
                }
                typeBLangTypeMap.put(type, bLangType);
                if (!hasReadOnlyType) {
                    boolean bl2 = hasReadOnlyType = type == this.symTable.readonlyType;
                }
                if (type == this.symTable.noType) {
                    return this.symTable.noType;
                }
                BType tempIntersectionType = this.getPotentialIntersection(Types.IntersectionContext.from(this.dlog, bLangTypeOne.pos, bLangTypeTwo.pos), potentialIntersectionType, type, data.env);
                if (tempIntersectionType == this.symTable.semanticError) {
                    validIntersection = false;
                    break;
                }
                if (type == tempIntersectionType) {
                    potentialIntersectionType = type;
                    isAlreadyExistingType = true;
                } else if (potentialIntersectionType != tempIntersectionType) {
                    potentialIntersectionType = tempIntersectionType;
                    isAlreadyExistingType = false;
                }
                constituentBTypes.add(type);
            }
        }
        if (!validIntersection) {
            this.dlog.error(intersectionTypeNode.pos, DiagnosticErrorCode.INVALID_INTERSECTION_TYPE, intersectionTypeNode);
            return this.symTable.semanticError;
        }
        if (isErrorIntersection && !isAlreadyExistingType) {
            BSymbol detailTypeSymbol;
            BType detailType = ((BErrorType)potentialIntersectionType).detailType;
            boolean existingErrorDetailType = false;
            if (detailType.tsymbol != null && (detailTypeSymbol = this.lookupSymbolInMainSpace(data.env, detailType.tsymbol.name)) != this.symTable.notFoundSymbol) {
                existingErrorDetailType = true;
            }
            return this.createIntersectionErrorType((BErrorType)potentialIntersectionType, intersectionTypeNode.pos, constituentBTypes, existingErrorDetailType, data.env);
        }
        if (this.types.isInherentlyImmutableType(potentialIntersectionType) || Symbols.isFlagOn(potentialIntersectionType.getFlags(), 32L) && !this.types.isSubTypeOfBaseType(potentialIntersectionType, 34)) {
            BTypeSymbol effectiveTypeTSymbol = potentialIntersectionType.tsymbol;
            return this.createIntersectionType(potentialIntersectionType, constituentBTypes, effectiveTypeTSymbol.pkgID, effectiveTypeTSymbol.owner, intersectionTypeNode.pos);
        }
        PackageID packageID = data.env.enclPkg.packageID;
        if (!this.types.isSelectivelyImmutableType(potentialIntersectionType, false, packageID)) {
            if (this.types.isSelectivelyImmutableType(potentialIntersectionType, packageID)) {
                this.dlog.error(intersectionTypeNode.pos, DiagnosticErrorCode.INVALID_READONLY_OBJECT_INTERSECTION_TYPE, new Object[0]);
            } else {
                this.dlog.error(intersectionTypeNode.pos, DiagnosticErrorCode.INVALID_READONLY_INTERSECTION_TYPE, potentialIntersectionType);
            }
            return this.symTable.semanticError;
        }
        BLangType typeNode = (BLangType)typeBLangTypeMap.get(potentialIntersectionType);
        Set<Object> flagSet = typeNode == null ? new HashSet() : (typeNode.getKind() == NodeKind.OBJECT_TYPE ? typeNode.flagSet : (typeNode.getKind() == NodeKind.USER_DEFINED_TYPE ? typeNode.flagSet : new HashSet()));
        return ImmutableTypeCloner.getImmutableIntersectionType(intersectionTypeNode.pos, this.types, potentialIntersectionType, data.env, this.symTable, this.anonymousModelHelper, this.names, flagSet);
    }

    public BIntersectionType createIntersectionErrorType(BErrorType intersectionErrorType, Location pos, LinkedHashSet<BType> constituentBTypes, boolean isAlreadyDefinedDetailType, SymbolEnv env) {
        BSymbol owner = intersectionErrorType.tsymbol.owner;
        PackageID pkgId = intersectionErrorType.tsymbol.pkgID;
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(env.enclPkg.symbol);
        BType detailType = Types.getImpliedType(intersectionErrorType.detailType);
        if (!isAlreadyDefinedDetailType && detailType.tag == 12) {
            this.defineErrorDetailRecord((BRecordType)detailType, pos, pkgEnv);
        }
        return this.createIntersectionType(intersectionErrorType, constituentBTypes, pkgId, owner, pos);
    }

    private void defineErrorDetailRecord(BRecordType detailRecord, Location pos, SymbolEnv env) {
        BRecordTypeSymbol detailRecordSymbol = (BRecordTypeSymbol)detailRecord.tsymbol;
        for (BField field : detailRecord.fields.values()) {
            BVarSymbol fieldSymbol = field.symbol;
            detailRecordSymbol.scope.define(fieldSymbol.name, fieldSymbol);
        }
        BLangRecordTypeNode detailRecordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(new ArrayList<BLangSimpleVariable>(), detailRecord, pos);
        BLangTypeDefinition detailRecordTypeDefinition = TypeDefBuilderHelper.createTypeDefinitionForTSymbol(detailRecord, detailRecordSymbol, detailRecordTypeNode, env);
        detailRecordTypeDefinition.pos = pos;
    }

    private BIntersectionType createIntersectionType(BType effectiveType, LinkedHashSet<BType> constituentBTypes, PackageID pkgId, BSymbol owner, Location pos) {
        BTypeSymbol intersectionTypeSymbol = Symbols.createTypeSymbol(2129948L, 0L, Names.EMPTY, pkgId, null, owner, pos, SymbolOrigin.VIRTUAL);
        BIntersectionType intersectionType = new BIntersectionType(intersectionTypeSymbol, constituentBTypes, effectiveType, effectiveType.getFlags());
        intersectionTypeSymbol.type = intersectionType;
        return intersectionType;
    }

    public BType getPotentialIntersection(Types.IntersectionContext intersectionContext, BType lhsType, BType rhsType, SymbolEnv env) {
        if (Types.getImpliedType(lhsType) == this.symTable.readonlyType) {
            return rhsType;
        }
        if (Types.getImpliedType(rhsType) == this.symTable.readonlyType) {
            return lhsType;
        }
        return this.types.getTypeIntersection(intersectionContext, lhsType, rhsType, env);
    }

    boolean validateInferTypedescParams(Location pos, List<? extends BLangVariable> parameters, BType retType) {
        int inferTypedescParamCount = 0;
        BVarSymbol paramWithInferredTypedescDefault = null;
        Location inferDefaultLocation = null;
        for (BLangVariable bLangVariable : parameters) {
            BType type = Types.getImpliedType(bLangVariable.getBType());
            BLangExpression expr = bLangVariable.expr;
            if (type == null || type.tag != 13 || expr == null || expr.getKind() != NodeKind.INFER_TYPEDESC_EXPR) continue;
            paramWithInferredTypedescDefault = bLangVariable.symbol;
            inferDefaultLocation = expr.pos;
            ++inferTypedescParamCount;
        }
        if (inferTypedescParamCount > 1) {
            this.dlog.error(pos, DiagnosticErrorCode.MULTIPLE_INFER_TYPEDESC_PARAMS, new Object[0]);
            return false;
        }
        if (paramWithInferredTypedescDefault == null) {
            return true;
        }
        if (retType == null) {
            this.dlog.error(inferDefaultLocation, DiagnosticErrorCode.CANNOT_USE_INFERRED_TYPEDESC_DEFAULT_WITH_UNREFERENCED_PARAM, new Object[0]);
            return false;
        }
        if (this.unifier.refersInferableParamName(paramWithInferredTypedescDefault.name.value, retType)) {
            return true;
        }
        this.dlog.error(inferDefaultLocation, DiagnosticErrorCode.CANNOT_USE_INFERRED_TYPEDESC_DEFAULT_WITH_UNREFERENCED_PARAM, new Object[0]);
        return false;
    }

    private boolean isModuleLevelVar(BSymbol symbol) {
        return symbol.getKind() == SymbolKind.VARIABLE && symbol.owner.getKind() == SymbolKind.PACKAGE;
    }

    public void populateAnnotationAttachmentSymbol(BLangAnnotationAttachment annotationAttachment, SymbolEnv env, ConstantValueResolver constantValueResolver) {
        this.populateAnnotationAttachmentSymbol(annotationAttachment, env, constantValueResolver, new ArrayDeque<String>());
    }

    public void populateAnnotationAttachmentSymbol(BLangAnnotationAttachment annotationAttachment, SymbolEnv env, ConstantValueResolver constantValueResolver, Deque<String> anonTypeNameSuffixes) {
        BLangConstantValue constAnnotationValue;
        BAnnotationSymbol annotationSymbol = annotationAttachment.annotationSymbol;
        if (annotationSymbol == null) {
            return;
        }
        if (!Symbols.isFlagOn(annotationSymbol.flags, 16384L)) {
            annotationAttachment.annotationAttachmentSymbol = new BAnnotationAttachmentSymbol(annotationSymbol, env.enclPkg.packageID, env.scope.owner, annotationAttachment.pos, SymbolOrigin.SOURCE, annotationSymbol.attachedType);
            return;
        }
        BLangExpression expr = annotationAttachment.expr;
        BType attachedType = annotationAttachment.annotationSymbol.attachedType;
        if (attachedType == null) {
            attachedType = this.symTable.trueType;
        } else {
            attachedType = Types.getImpliedType(attachedType);
            attachedType = attachedType.tag == 20 ? ((BArrayType)attachedType).eType : attachedType;
        }
        boolean isSourceOnlyAnon = this.isSourceAnonOnly(annotationSymbol.points);
        BConstantSymbol constantSymbol = new BConstantSymbol(0L, Names.EMPTY, Names.EMPTY, env.enclPkg.packageID, attachedType, attachedType, env.scope.owner, annotationAttachment.pos, SymbolOrigin.VIRTUAL);
        if (expr == null) {
            if (this.types.isAssignable(attachedType, this.symTable.trueType)) {
                constantSymbol.value = constAnnotationValue = new BLangConstantValue(true, this.symTable.booleanType);
            } else {
                BLangRecordLiteral mappingConstructor = (BLangRecordLiteral)TreeBuilder.createRecordLiteralNode();
                mappingConstructor.setBType(attachedType);
                mappingConstructor.typeChecked = true;
                constAnnotationValue = constantValueResolver.constructBLangConstantValueWithExactType(mappingConstructor, constantSymbol, env);
            }
        } else {
            constAnnotationValue = constantValueResolver.constructBLangConstantValueWithExactType(expr, constantSymbol, env, anonTypeNameSuffixes, isSourceOnlyAnon);
        }
        constantSymbol.type = constAnnotationValue.type;
        annotationAttachment.annotationAttachmentSymbol = new BAnnotationAttachmentSymbol.BConstAnnotationAttachmentSymbol(annotationSymbol, env.enclPkg.packageID, env.scope.owner, annotationAttachment.pos, SymbolOrigin.SOURCE, constantSymbol);
    }

    private boolean isSourceAnonOnly(Set<AttachPoint> attachPoints) {
        for (AttachPoint attachPoint : attachPoints) {
            if (attachPoint.source) continue;
            return false;
        }
        return true;
    }

    public Set<BVarSymbol> getConfigVarSymbolsIncludingImportedModules(BPackageSymbol packageSymbol) {
        HashSet<BVarSymbol> configVars = new HashSet<BVarSymbol>();
        this.populateConfigurableVars(packageSymbol, configVars);
        if (!packageSymbol.imports.isEmpty()) {
            for (BPackageSymbol importSymbol : packageSymbol.imports) {
                this.populateConfigurableVars(importSymbol, configVars);
            }
        }
        return configVars;
    }

    private void populateConfigurableVars(BPackageSymbol pkgSymbol, Set<BVarSymbol> configVars) {
        for (Scope.ScopeEntry entry : pkgSymbol.scope.entries.values()) {
            BSymbol symbol = entry.symbol;
            if (symbol == null) continue;
            if (symbol.tag == 32796L) {
                symbol = symbol.type.tsymbol;
            }
            if (symbol.tag != 52L || !Symbols.isFlagOn(symbol.flags, 0x80000000L)) continue;
            configVars.add((BVarSymbol)symbol);
        }
    }

    public BAnnotationSymbol getStrandAnnotationSymbol() {
        return (BAnnotationSymbol)this.lookupSymbolInAnnotationSpace(this.symTable.pkgEnvMap.get(this.symTable.rootPkgSymbol), Names.fromString("strand"));
    }

    public BPackageSymbol getModuleForPackageId(PackageID packageID) {
        return this.symTable.pkgEnvMap.keySet().stream().filter(moduleSymbol -> packageID.equals(moduleSymbol.pkgID)).findFirst().get();
    }

    public List<BLangExpression> getListOfInterpolations(List<BLangExpression> sequenceList) {
        ArrayList<BLangExpression> interpolationsList = new ArrayList<BLangExpression>();
        for (BLangExpression seq : sequenceList) {
            if (seq.getKind() != NodeKind.REG_EXP_SEQUENCE) continue;
            BLangReSequence sequence = (BLangReSequence)seq;
            for (BLangReTerm term : sequence.termList) {
                if (term.getKind() != NodeKind.REG_EXP_ATOM_QUANTIFIER) continue;
                BLangExpression atom = ((BLangReAtomQuantifier)term).atom;
                NodeKind kind = atom.getKind();
                if (!this.isReAtomNode(kind)) {
                    interpolationsList.add(atom);
                    continue;
                }
                if (kind != NodeKind.REG_EXP_CAPTURING_GROUP) continue;
                interpolationsList.addAll(this.getListOfInterpolations(((BLangReCapturingGroups)atom).disjunction.sequenceList));
            }
        }
        return interpolationsList;
    }

    public boolean isReAtomNode(NodeKind kind) {
        return switch (kind) {
            case NodeKind.REG_EXP_ATOM_CHAR_ESCAPE, NodeKind.REG_EXP_CHARACTER_CLASS, NodeKind.REG_EXP_CAPTURING_GROUP -> true;
            default -> false;
        };
    }

    private boolean isDistinctXMLNSSymbol(BXMLNSSymbol symbol, BXMLNSSymbol foundSym) {
        boolean isSymModuleXmlns;
        Name foundSymCompUnit = foundSym.compUnit;
        Name symbolCompUnit = symbol.compUnit;
        boolean isFoundSymModuleXmlns = foundSymCompUnit != null;
        boolean bl = isSymModuleXmlns = symbolCompUnit != null;
        if (isFoundSymModuleXmlns && isSymModuleXmlns) {
            return !foundSymCompUnit.value.equals(symbolCompUnit.value);
        }
        return isFoundSymModuleXmlns || isSymModuleXmlns;
    }

    public static class AnalyzerData {
        SymbolEnv env;
        DiagnosticCode diagCode;

        public AnalyzerData(SymbolEnv env) {
            this.env = env;
        }
    }

    public static class ParameterizedTypeInfo {
        BType paramValueType;
        int index = -1;

        private ParameterizedTypeInfo(BType paramValueType) {
            this.paramValueType = paramValueType;
        }

        private ParameterizedTypeInfo(BType paramValueType, int index) {
            this.paramValueType = paramValueType;
            this.index = index;
        }
    }
}

