/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.identifier.Utils;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.EnumerableCharString;
import io.ballerina.types.EnumerableString;
import io.ballerina.types.EnumerableType;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import io.ballerina.types.subtypedata.CharStringSubtype;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.NonCharStringSubtype;
import io.ballerina.types.subtypedata.Range;
import io.ballerina.types.subtypedata.StringSubtype;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.InvokableSymbol;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.ActionNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.expressions.NamedArgNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.expressions.XMLNavigationAccess;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.parser.BLangMissingNodesHelper;
import org.wso2.ballerinalang.compiler.parser.NodeCloner;
import org.wso2.ballerinalang.compiler.semantics.analyzer.QueryTypeChecker;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemanticAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeNarrower;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BLetSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.semantics.model.types.SemNamedType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeySpecifier;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.OCEDynamicEnvironmentData;
import org.wso2.ballerinalang.compiler.tree.SimpleBLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAlternateWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExtendedXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInferredTypedescDefaultNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMultipleWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNaturalExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRegExpTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangValueExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerAsyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLFilterStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLIndexedStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLMethodCallStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.ClosureVarSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;
import org.wso2.ballerinalang.compiler.util.FieldKind;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.NumericLiteralSupport;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.compiler.util.Unifier;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.Lists;

public class TypeChecker
extends SimpleBLangNodeAnalyzer<AnalyzerData> {
    private static final CompilerContext.Key<TypeChecker> TYPE_CHECKER_KEY = new CompilerContext.Key();
    private static final Set<String> LIST_LENGTH_MODIFIER_FUNCTIONS = new HashSet<String>();
    private static final Map<String, HashSet<String>> MODIFIER_FUNCTIONS = new HashMap<String, HashSet<String>>();
    private static final String LIST_LANG_LIB = "lang.array";
    private static final String MAP_LANG_LIB = "lang.map";
    private static final String TABLE_LANG_LIB = "lang.table";
    private static final String VALUE_LANG_LIB = "lang.value";
    private static final String XML_LANG_LIB = "lang.xml";
    private static final String FUNCTION_NAME_PUSH = "push";
    private static final String FUNCTION_NAME_POP = "pop";
    private static final String FUNCTION_NAME_SHIFT = "shift";
    private static final String FUNCTION_NAME_UNSHIFT = "unshift";
    private static final String FUNCTION_NAME_ENSURE_TYPE = "ensureType";
    private final BLangAnonymousModelHelper anonymousModelHelper;
    private final BLangDiagnosticLog dlog;
    private final BLangMissingNodesHelper missingNodesHelper;
    private final Names names;
    private final NodeCloner nodeCloner;
    private final SemanticAnalyzer semanticAnalyzer;
    private final SymbolEnter symbolEnter;
    private final SymbolResolver symResolver;
    private final SymbolTable symTable;
    private final TypeNarrower typeNarrower;
    private final TypeParamAnalyzer typeParamAnalyzer;
    private final Types types;
    private final Unifier unifier;
    protected final QueryTypeChecker queryTypeChecker;
    private final TypeResolver typeResolver;
    private final Env typeEnv;

    public static TypeChecker getInstance(CompilerContext context) {
        TypeChecker typeChecker = context.get(TYPE_CHECKER_KEY);
        if (typeChecker == null) {
            typeChecker = new TypeChecker(context);
        }
        return typeChecker;
    }

    public TypeChecker(CompilerContext context) {
        context.put(TYPE_CHECKER_KEY, this);
        this.names = Names.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.nodeCloner = NodeCloner.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.typeNarrower = TypeNarrower.getInstance(context);
        this.typeParamAnalyzer = TypeParamAnalyzer.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.semanticAnalyzer = SemanticAnalyzer.getInstance(context);
        this.missingNodesHelper = BLangMissingNodesHelper.getInstance(context);
        this.unifier = new Unifier();
        this.queryTypeChecker = QueryTypeChecker.getInstance(context);
        this.typeResolver = TypeResolver.getInstance(context);
        this.typeEnv = this.types.typeEnv();
    }

    public TypeChecker(CompilerContext context, CompilerContext.Key<TypeChecker> key) {
        context.put(key, this);
        this.names = Names.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.nodeCloner = NodeCloner.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.typeNarrower = TypeNarrower.getInstance(context);
        this.typeParamAnalyzer = TypeParamAnalyzer.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.semanticAnalyzer = SemanticAnalyzer.getInstance(context);
        this.missingNodesHelper = BLangMissingNodesHelper.getInstance(context);
        this.unifier = new Unifier();
        this.queryTypeChecker = null;
        this.typeEnv = this.types.typeEnv();
        this.typeResolver = TypeResolver.getInstance(context);
    }

    private BType checkExpr(BLangExpression expr, SymbolEnv env, AnalyzerData data) {
        return this.checkExpr(expr, env, this.symTable.noType, data);
    }

    private BType checkExpr(BLangExpression expr, AnalyzerData data) {
        return this.checkExpr(expr, data.env, this.symTable.noType, data);
    }

    private BType checkExpr(BLangExpression expr, SymbolEnv env, BType expType, AnalyzerData data) {
        return this.checkExpr(expr, env, expType, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data);
    }

    private BType checkExpr(BLangExpression expr, BType expType, AnalyzerData data) {
        return this.checkExpr(expr, data.env, expType, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data);
    }

    public BType checkExpr(BLangExpression expr, SymbolEnv env) {
        return this.checkExpr(expr, env, this.symTable.noType, new ArrayDeque<SymbolEnv>());
    }

    public BType checkExpr(BLangExpression expr, SymbolEnv env, Deque<SymbolEnv> prevEnvs, Types.CommonAnalyzerData commonAnalyzerData) {
        return this.checkExpr(expr, env, this.symTable.noType, prevEnvs, commonAnalyzerData);
    }

    public BType checkExpr(BLangExpression expr, SymbolEnv env, BType expType, Deque<SymbolEnv> prevEnvs) {
        AnalyzerData data = new AnalyzerData();
        data.env = env;
        data.prevEnvs = prevEnvs;
        data.commonAnalyzerData.queryFinalClauses = new ArrayDeque<BLangNode>();
        data.commonAnalyzerData.queryEnvs = new ArrayDeque<SymbolEnv>();
        return this.checkExpr(expr, env, expType, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data);
    }

    public BType checkExpr(BLangExpression expr, SymbolEnv env, BType expType, Deque<SymbolEnv> prevEnvs, Types.CommonAnalyzerData commonAnalyzerData) {
        AnalyzerData data = new AnalyzerData();
        data.env = env;
        data.prevEnvs = prevEnvs;
        data.commonAnalyzerData = commonAnalyzerData;
        return this.checkExpr(expr, env, expType, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data);
    }

    @Override
    public void analyzeNode(BLangNode node, AnalyzerData data) {
    }

    @Override
    public void visit(BLangPackage node, AnalyzerData data) {
    }

    public BType checkExpr(BLangExpression expr, SymbolEnv env, BType expType, DiagnosticCode diagCode, AnalyzerData data) {
        if (expr.typeChecked) {
            return expr.getBType();
        }
        SymbolEnv prevEnv = data.env;
        BType preExpType = data.expType;
        DiagnosticCode preDiagCode = data.diagCode;
        data.env = env;
        data.diagCode = diagCode;
        data.expType = expType;
        data.isTypeChecked = true;
        expr.expectedType = expType;
        expr.accept(this, data);
        expr.setTypeCheckedType(data.resultType);
        expr.typeChecked = data.isTypeChecked;
        data.env = prevEnv;
        data.expType = preExpType;
        data.diagCode = preDiagCode;
        this.validateAndSetExprExpectedType(expr, data);
        return data.resultType;
    }

    private void analyzeObjectConstructor(BLangNode node, SymbolEnv env, AnalyzerData data) {
        if (!data.commonAnalyzerData.nonErrorLoggingCheck) {
            this.semanticAnalyzer.analyzeNode(node, env, data.commonAnalyzerData);
        }
    }

    public void validateAndSetExprExpectedType(BLangExpression expr, AnalyzerData data) {
        if (data.resultType.tag == 28) {
            return;
        }
        if (expr.getKind() == NodeKind.RECORD_LITERAL_EXPR && expr.expectedType != null && Types.getImpliedType((BType)expr.expectedType).tag == 16 && Types.getImpliedType((BType)expr.getBType()).tag == 12) {
            return;
        }
        expr.expectedType = data.resultType;
    }

    @Override
    public void visit(BLangLiteral literalExpr, AnalyzerData data) {
        BType literalType = this.setLiteralValueAndGetType(literalExpr, data.expType, data);
        if (literalType == this.symTable.semanticError) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        if (literalExpr.isFiniteContext) {
            return;
        }
        data.resultType = this.types.checkType(literalExpr, literalType, data.expType);
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess, AnalyzerData data) {
        this.checkXMLNamespacePrefixes(xmlElementAccess.filters, data);
        this.checkExpr(xmlElementAccess.expr, this.symTable.xmlType, data);
        data.resultType = this.types.checkType(xmlElementAccess, this.symTable.xmlElementSeqType, data.expType);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation, AnalyzerData data) {
        this.checkXMLNamespacePrefixes(xmlNavigation.filters, data);
        this.checkExpr(xmlNavigation.expr, this.symTable.xmlType, data);
        BType actualType = xmlNavigation.navAccessType == XMLNavigationAccess.NavAccessType.CHILDREN ? this.symTable.xmlType : this.symTable.xmlElementSeqType;
        this.types.checkType(xmlNavigation, actualType, data.expType);
        data.resultType = actualType;
    }

    @Override
    public void visit(BLangExtendedXMLNavigationAccess extendedXmlNavigationAccess, AnalyzerData data) {
        BType expType = data.expType;
        this.checkExpr((BLangExpression)extendedXmlNavigationAccess.stepExpr, data);
        data.expType = this.symTable.xmlType;
        extendedXmlNavigationAccess.extensions.forEach(extension -> extension.accept(this, data));
        data.resultType = this.types.checkType(extendedXmlNavigationAccess, data.resultType, expType);
    }

    @Override
    public void visit(BLangXMLIndexedStepExtend xmlIndexedStepExtend, AnalyzerData data) {
        BType prevResultType = data.resultType;
        this.checkExpr(xmlIndexedStepExtend.indexExpr, this.symTable.intType, data);
        data.resultType = prevResultType;
    }

    @Override
    public void visit(BLangXMLFilterStepExtend xmlFilterStepExtend, AnalyzerData data) {
        this.checkXMLNamespacePrefixes(xmlFilterStepExtend.filters, data);
        data.resultType = this.symTable.xmlElementSeqType;
    }

    @Override
    public void visit(BLangXMLMethodCallStepExtend xmlMethodCallStepExtend, AnalyzerData data) {
        this.checkExpr((BLangExpression)xmlMethodCallStepExtend.invocation, data.expType, data);
    }

    private void checkXMLNamespacePrefixes(List<BLangXMLElementFilter> filters, AnalyzerData data) {
        Map<Name, BXMLNSSymbol> nameBXMLNSSymbolMap = this.symResolver.resolveAllNamespaces(data.env);
        BXMLNSSymbol defaultNSSymbol = nameBXMLNSSymbolMap.get(Names.fromString(""));
        boolean hasDefaultNS = defaultNSSymbol != null;
        for (BLangXMLElementFilter filter : filters) {
            String namespace = filter.namespace;
            if (!namespace.isEmpty()) {
                Name nsName = Names.fromString(namespace);
                BXMLNSSymbol nsSymbol = nameBXMLNSSymbolMap.get(nsName);
                if (nsSymbol == null) {
                    this.dlog.error(filter.nsPos, DiagnosticErrorCode.CANNOT_FIND_XML_NAMESPACE, nsName);
                }
                filter.namespaceSymbol = nsSymbol;
                continue;
            }
            if (!hasDefaultNS) continue;
            filter.namespaceSymbol = defaultNSSymbol;
        }
    }

    private int getPreferredMemberTypeTag(BFiniteType finiteType) {
        BasicTypeBitSet basicTypeBitSet = Core.widenToBasicTypes((SemType)finiteType.semType());
        if ((basicTypeBitSet.bitset & PredefinedType.INT.bitset) != 0) {
            return 1;
        }
        if ((basicTypeBitSet.bitset & PredefinedType.FLOAT.bitset) != 0) {
            return 3;
        }
        if ((basicTypeBitSet.bitset & PredefinedType.DECIMAL.bitset) != 0) {
            return 4;
        }
        return 24;
    }

    private BType getFiniteTypeMatchWithIntType(BLangNumericLiteral literalExpr, BFiniteType finiteType, AnalyzerData data) {
        if (this.literalAssignableToFiniteType(literalExpr, finiteType, 1)) {
            this.setLiteralValueForFiniteType(literalExpr, this.symTable.intType, data);
            return this.symTable.intType;
        }
        return this.symTable.noType;
    }

    private BType getFiniteTypeMatchWithIntLiteral(BLangNumericLiteral literalExpr, BFiniteType finiteType, Object literalValue, BType compatibleType, AnalyzerData data) {
        BType intLiteralType = this.getFiniteTypeMatchWithIntType(literalExpr, finiteType, data);
        if (intLiteralType != this.symTable.noType) {
            return intLiteralType;
        }
        int typeTag = this.getPreferredMemberTypeTag(finiteType);
        if (typeTag == 24) {
            return this.symTable.intType;
        }
        if (this.literalAssignableToFiniteType(literalExpr, finiteType, typeTag)) {
            BType type = this.symTable.getTypeFromTag(typeTag);
            this.setLiteralValueForFiniteType(literalExpr, type, data);
            literalExpr.value = String.valueOf(literalValue);
            return type;
        }
        if (literalValue instanceof Double) {
            return this.symTable.floatType;
        }
        if (literalValue instanceof String) {
            return this.symTable.decimalType;
        }
        if (compatibleType.tag == 2) {
            return this.symTable.intType;
        }
        return compatibleType;
    }

    private BType silentIntTypeCheck(BLangNumericLiteral literalExpr, Object literalValue, BType expType, AnalyzerData data) {
        boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
        data.commonAnalyzerData.nonErrorLoggingCheck = true;
        GlobalStateSnapshot previousGlobalState = this.getGlobalStateSnapshotAndResetGlobalState();
        this.dlog.mute();
        BType exprCompatibleType = this.getIntegerLiteralType(this.nodeCloner.cloneNode(literalExpr), literalValue, expType, data);
        data.commonAnalyzerData.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
        this.restoreGlobalState(previousGlobalState);
        if (!prevNonErrorLoggingCheck) {
            this.dlog.unmute();
        }
        return exprCompatibleType;
    }

    private BType checkIfOutOfRangeAndReturnType(BFiniteType finiteType, BLangNumericLiteral literalExpr, Object literalValue, AnalyzerData data) {
        BType resIntegerLiteralType = this.symTable.semanticError;
        ArrayList<BType> compatibleTypes = new ArrayList<BType>();
        Set<BType> broadTypes = SemTypeHelper.broadTypes(finiteType, this.symTable);
        for (BType broadType : broadTypes) {
            resIntegerLiteralType = this.silentIntTypeCheck(literalExpr, literalValue, broadType, data);
            if (resIntegerLiteralType == this.symTable.semanticError) continue;
            compatibleTypes.add(resIntegerLiteralType);
        }
        for (int i = 1; i <= 4; ++i) {
            for (BType type : compatibleTypes) {
                if (Types.getReferredType((BType)type).tag != i) continue;
                return type;
            }
        }
        this.dlog.error(literalExpr.pos, DiagnosticErrorCode.OUT_OF_RANGE, literalExpr.originalValue, literalExpr.getBType());
        return resIntegerLiteralType;
    }

    public BType getIntegerLiteralType(BLangNumericLiteral literalExpr, Object literalValue, BType expType, AnalyzerData data) {
        BType expectedType = Types.getImpliedType(expType);
        if (expectedType.tag == 2 || TypeTags.isIntegerTypeTag(expectedType.tag)) {
            BType resultType = this.getIntLiteralType(expType, literalValue, data);
            if (resultType == this.symTable.semanticError) {
                this.dlog.error(literalExpr.pos, DiagnosticErrorCode.OUT_OF_RANGE, literalExpr.originalValue, expType);
            }
            return resultType;
        }
        if (expectedType.tag == 3) {
            if (literalValue instanceof String) {
                this.dlog.error(literalExpr.pos, DiagnosticErrorCode.OUT_OF_RANGE, literalExpr.originalValue, expectedType);
                return this.symTable.semanticError;
            }
            literalExpr.value = literalValue instanceof Double ? literalValue : Double.valueOf(((Long)literalValue).doubleValue());
            return this.symTable.floatType;
        }
        if (expectedType.tag == 4) {
            literalExpr.value = String.valueOf(literalValue);
            return this.symTable.decimalType;
        }
        if (expectedType.tag == 33) {
            BFiniteType finiteType = (BFiniteType)expectedType;
            BType compatibleType = this.checkIfOutOfRangeAndReturnType(finiteType, literalExpr, literalValue, data);
            if (compatibleType == this.symTable.semanticError) {
                return compatibleType;
            }
            return this.getFiniteTypeMatchWithIntLiteral(literalExpr, finiteType, literalValue, compatibleType, data);
        }
        if (expectedType.tag == 21) {
            BType finiteTypeMatchingByte;
            BUnionType expectedUnionType = (BUnionType)expectedType;
            List<BType> memberTypes = this.types.getAllTypes(expectedUnionType, true);
            for (BType memType : memberTypes) {
                int tag = memType.tag;
                if (TypeTags.isIntegerTypeTag(tag) || tag == 2) {
                    BType intLiteralType = this.getIntLiteralType(memType, literalValue, data);
                    if (intLiteralType != memType) continue;
                    return intLiteralType;
                }
                if (tag != 7 && tag != 11 && tag != 18) continue;
                if (literalValue instanceof Double) {
                    return this.symTable.floatType;
                }
                if (literalValue instanceof String) {
                    return this.symTable.decimalType;
                }
                return this.symTable.intType;
            }
            BType finiteType = this.getFiniteTypeWithValuesOfSingleType(expectedUnionType, this.symTable.intType);
            if (finiteType != this.symTable.semanticError) {
                BType setType = this.setLiteralValueAndGetType(literalExpr, finiteType, data);
                if (literalExpr.isFiniteContext) {
                    return setType;
                }
            }
            if ((finiteTypeMatchingByte = this.getFiniteTypeWithValuesOfSingleType(expectedUnionType, this.symTable.byteType)) != this.symTable.semanticError) {
                finiteType = finiteTypeMatchingByte;
                BType setType = this.setLiteralValueAndGetType(literalExpr, finiteType, data);
                if (literalExpr.isFiniteContext) {
                    return setType;
                }
            }
            return this.getTypeMatchingFloatOrDecimal(finiteType, memberTypes, literalExpr, expectedUnionType, data);
        }
        if (!(literalValue instanceof Long)) {
            this.dlog.error(literalExpr.pos, DiagnosticErrorCode.OUT_OF_RANGE, literalExpr.originalValue, literalExpr.getBType());
            return this.symTable.semanticError;
        }
        return this.symTable.intType;
    }

    public BType getTypeOfLiteralWithFloatDiscriminator(BLangNumericLiteral literalExpr, Object literalValue, BType expType, AnalyzerData data) {
        BUnionType unionType;
        BType unionMember;
        String numericLiteral = NumericLiteralSupport.stripDiscriminator(String.valueOf(literalValue));
        if (!this.types.validateFloatLiteral(literalExpr.pos, numericLiteral)) {
            return this.symTable.semanticError;
        }
        literalExpr.value = Double.parseDouble(numericLiteral);
        BType referredType = Types.getImpliedType(expType);
        if (referredType.tag == 33) {
            BFiniteType finiteType = (BFiniteType)referredType;
            if (this.literalAssignableToFiniteType(literalExpr, finiteType, 3)) {
                this.setLiteralValueForFiniteType(literalExpr, this.symTable.floatType, data);
                return this.symTable.floatType;
            }
        } else if (referredType.tag == 21 && (unionMember = this.getAndSetAssignableUnionMember(literalExpr, unionType = (BUnionType)referredType, this.symTable.floatType, data)) != this.symTable.noType) {
            return unionMember;
        }
        return this.symTable.floatType;
    }

    public BType getTypeOfLiteralWithDecimalDiscriminator(BLangNumericLiteral literalExpr, Object literalValue, BType expType, AnalyzerData data) {
        BUnionType unionType;
        BType unionMember;
        literalExpr.value = NumericLiteralSupport.stripDiscriminator(String.valueOf(literalValue));
        if (!this.types.isValidDecimalNumber(literalExpr.pos, literalExpr.value.toString())) {
            return this.symTable.semanticError;
        }
        BType referredType = Types.getImpliedType(expType);
        if (referredType.tag == 33) {
            BFiniteType finiteType = (BFiniteType)referredType;
            if (this.literalAssignableToFiniteType(literalExpr, finiteType, 4)) {
                this.setLiteralValueForFiniteType(literalExpr, this.symTable.decimalType, data);
                return this.symTable.decimalType;
            }
        } else if (referredType.tag == 21 && (unionMember = this.getAndSetAssignableUnionMember(literalExpr, unionType = (BUnionType)expType, this.symTable.decimalType, data)) != this.symTable.noType) {
            return unionMember;
        }
        return this.symTable.decimalType;
    }

    public BType getTypeOfDecimalFloatingPointLiteral(BLangNumericLiteral literalExpr, Object literalValue, BType expType, AnalyzerData data) {
        BType expectedType = Types.getImpliedType(expType);
        String numericLiteral = String.valueOf(literalValue);
        if (expectedType != null) {
            if (expectedType.tag == 4) {
                if (this.types.isValidDecimalNumber(literalExpr.pos, literalExpr.value.toString())) {
                    return this.symTable.decimalType;
                }
                return this.symTable.semanticError;
            }
            if (expectedType.tag == 3) {
                if (!this.types.validateFloatLiteral(literalExpr.pos, numericLiteral)) {
                    data.resultType = this.symTable.semanticError;
                    return this.symTable.semanticError;
                }
                return this.symTable.floatType;
            }
            if (expectedType.tag == 33) {
                BType basicType;
                BasicTypeBitSet basicTypeBitSet = Core.widenToBasicTypes((SemType)expectedType.semType());
                if ((basicTypeBitSet.bitset & PredefinedType.FLOAT.bitset) != 0) {
                    basicType = this.symTable.floatType;
                } else if ((basicTypeBitSet.bitset & PredefinedType.DECIMAL.bitset) != 0) {
                    basicType = this.symTable.decimalType;
                } else {
                    return literalExpr.getBType();
                }
                if (this.literalAssignableToFiniteType(literalExpr, (BFiniteType)expectedType, basicType.tag)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, basicType, data);
                    this.setLiteralValueForFiniteType(literalExpr, valueType, data);
                    return valueType;
                }
                return basicType;
            }
            if (expectedType.tag == 21) {
                BUnionType unionType = (BUnionType)expectedType;
                for (int tag = 3; tag <= 4; ++tag) {
                    BType unionMember = this.getAndSetAssignableUnionMember(literalExpr, unionType, this.symTable.getTypeFromTag(tag), data);
                    if (unionMember == this.symTable.floatType && !this.types.validateFloatLiteral(literalExpr.pos, numericLiteral)) {
                        return this.symTable.semanticError;
                    }
                    if (unionMember == this.symTable.noType) continue;
                    return unionMember;
                }
            }
        }
        return this.types.validateFloatLiteral(literalExpr.pos, numericLiteral) ? this.symTable.floatType : this.symTable.semanticError;
    }

    public BType getTypeOfHexFloatingPointLiteral(BLangNumericLiteral literalExpr, Object literalValue, BType expType, AnalyzerData data) {
        BUnionType unionType;
        BType unionMember;
        String numericLiteral = String.valueOf(literalValue);
        if (!this.types.validateFloatLiteral(literalExpr.pos, numericLiteral)) {
            return this.symTable.semanticError;
        }
        literalExpr.value = Double.parseDouble(numericLiteral);
        BType referredType = Types.getImpliedType(expType);
        if (referredType.tag == 33) {
            BFiniteType finiteType = (BFiniteType)referredType;
            if (this.literalAssignableToFiniteType(literalExpr, finiteType, 3)) {
                this.setLiteralValueForFiniteType(literalExpr, this.symTable.floatType, data);
                return this.symTable.floatType;
            }
        } else if (referredType.tag == 21 && (unionMember = this.getAndSetAssignableUnionMember(literalExpr, unionType = (BUnionType)referredType, this.symTable.floatType, data)) != this.symTable.noType) {
            return unionMember;
        }
        return this.symTable.floatType;
    }

    public BType setLiteralValueAndGetType(BLangLiteral literalExpr, BType expType, AnalyzerData data) {
        BUnionType unionType;
        boolean foundMember;
        literalExpr.isFiniteContext = false;
        Object literalValue = literalExpr.value;
        BType expectedType = Types.getImpliedType(expType);
        if (literalExpr.getKind() == NodeKind.NUMERIC_LITERAL) {
            BLangNumericLiteral numericLiteral = (BLangNumericLiteral)literalExpr;
            if (numericLiteral.kind == NodeKind.INTEGER_LITERAL) {
                return this.getIntegerLiteralType(numericLiteral, literalValue, expectedType, data);
            }
            if (numericLiteral.kind == NodeKind.DECIMAL_FLOATING_POINT_LITERAL) {
                if (NumericLiteralSupport.isFloatDiscriminated(numericLiteral.originalValue)) {
                    return this.getTypeOfLiteralWithFloatDiscriminator(numericLiteral, literalValue, expectedType, data);
                }
                if (NumericLiteralSupport.isDecimalDiscriminated(numericLiteral.originalValue)) {
                    return this.getTypeOfLiteralWithDecimalDiscriminator(numericLiteral, literalValue, expectedType, data);
                }
                return this.getTypeOfDecimalFloatingPointLiteral(numericLiteral, literalValue, expectedType, data);
            }
            return this.getTypeOfHexFloatingPointLiteral(numericLiteral, literalValue, expectedType, data);
        }
        BType literalType = this.symTable.getTypeFromTag(Types.getImpliedType((BType)literalExpr.getBType()).tag);
        if (literalType.tag == 5 && this.types.isCharLiteralValue((String)literalValue)) {
            boolean foundMember2;
            if (expectedType.tag == 45) {
                return this.symTable.charStringType;
            }
            if (expectedType.tag == 21) {
                HashSet<BType> memberTypes = new HashSet<BType>(this.types.getAllTypes(expectedType, true));
                for (BType memType : memberTypes) {
                    memType = Types.getImpliedType(memType);
                    if (TypeTags.isStringTypeTag(memType.tag)) {
                        return this.setLiteralValueAndGetType(literalExpr, memType, data);
                    }
                    if (memType.tag == 7 || memType.tag == 11 || memType.tag == 18) {
                        return this.setLiteralValueAndGetType(literalExpr, this.symTable.charStringType, data);
                    }
                    if (memType.tag != 33 || !this.types.isAssignableToFiniteType(memType, literalExpr)) continue;
                    this.setLiteralValueForFiniteType(literalExpr, this.symTable.charStringType, data);
                    return literalType;
                }
            }
            if (foundMember2 = this.types.isAssignableToFiniteType(expectedType, literalExpr)) {
                this.setLiteralValueForFiniteType(literalExpr, literalType, data);
                return literalType;
            }
        } else if (expectedType.tag == 33) {
            boolean foundMember3 = this.types.isAssignableToFiniteType(expectedType, literalExpr);
            if (foundMember3) {
                this.setLiteralValueForFiniteType(literalExpr, literalType, data);
                return literalType;
            }
        } else if (expectedType.tag == 21 && (foundMember = this.types.getAllTypes(unionType = (BUnionType)expectedType, true).stream().anyMatch(memberType -> this.types.isAssignableToFiniteType((BType)memberType, literalExpr)))) {
            this.setLiteralValueForFiniteType(literalExpr, literalType, data);
            return literalType;
        }
        BType referedType = Types.getImpliedType(literalExpr.getBType());
        if (referedType.tag == 20 && ((BArrayType)referedType).eType.tag == 2) {
            return referedType;
        }
        if (referedType.tag == 35) {
            byte[] byteArray = this.types.convertToByteArray((String)literalExpr.value);
            literalType = new BArrayType(this.typeEnv, this.symTable.byteType, null, byteArray.length, BArrayState.CLOSED);
            if (Symbols.isFlagOn(expectedType.getFlags(), 32L)) {
                literalType = ImmutableTypeCloner.getEffectiveImmutableType(literalExpr.pos, this.types, literalType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            if (expectedType.tag == 20) {
                BArrayType arrayType = (BArrayType)expectedType;
                if (arrayType.state == BArrayState.INFERRED) {
                    arrayType.setSize(byteArray.length);
                    arrayType.state = BArrayState.CLOSED;
                }
            }
        }
        return literalType;
    }

    private BType getTypeMatchingFloatOrDecimal(BType finiteType, List<BType> memberTypes, BLangLiteral literalExpr, BUnionType expType, AnalyzerData data) {
        for (int tag = 3; tag <= 4; ++tag) {
            if (finiteType != this.symTable.semanticError) continue;
            BType type = this.symTable.getTypeFromTag(tag);
            for (BType memType : memberTypes) {
                if (Types.getImpliedType((BType)memType).tag != tag) continue;
                return this.setLiteralValueAndGetType(literalExpr, type, data);
            }
            finiteType = this.getFiniteTypeWithValuesOfSingleType(expType, type);
            if (finiteType == this.symTable.semanticError) continue;
            BType setType = this.setLiteralValueAndGetType(literalExpr, finiteType, data);
            if (!literalExpr.isFiniteContext) continue;
            return setType;
        }
        if (finiteType.tag == 33) {
            return this.checkIfOutOfRangeAndReturnType((BFiniteType)finiteType, (BLangNumericLiteral)literalExpr, literalExpr.value, data);
        }
        return this.symTable.intType;
    }

    private BType getAndSetAssignableUnionMember(BLangLiteral literalExpr, BUnionType expType, BType desiredType, AnalyzerData data) {
        BType setType;
        List<BType> members = this.types.getAllTypes(expType, true);
        HashSet memberTypes = new HashSet();
        members.forEach(member -> memberTypes.addAll(members));
        if (memberTypes.stream().anyMatch(memType -> {
            int memTypeTag = Types.getImpliedType((BType)memType).tag;
            return memTypeTag == desiredType.tag || memTypeTag == 7 || memTypeTag == 11 || memTypeTag == 18;
        })) {
            return desiredType;
        }
        BType finiteType = this.getFiniteTypeWithValuesOfSingleType(expType, desiredType);
        if (finiteType != this.symTable.semanticError && (setType = this.setLiteralValueAndGetType(literalExpr, finiteType, data)) != this.symTable.semanticError) {
            return setType;
        }
        return this.symTable.noType;
    }

    private boolean literalAssignableToFiniteType(BLangNumericLiteral literalExpr, BFiniteType finiteType, int targetTypeTag) {
        return this.types.checkLiteralAssignabilityBasedOnType(literalExpr, finiteType, targetTypeTag);
    }

    public void setLiteralValueForFiniteType(BLangLiteral literalExpr, BType type, AnalyzerData data) {
        this.types.setImplicitCastExpr(literalExpr, type, data.expType);
        data.resultType = type;
        literalExpr.isFiniteContext = true;
    }

    private BType getFiniteTypeWithValuesOfSingleType(BUnionType unionType, BType matchType) {
        assert (matchType.tag == 2 || matchType.tag == 1 || matchType.tag == 3 || matchType.tag == 4);
        List<BFiniteType> finiteTypeMembers = this.types.getAllTypes(unionType, true).stream().filter(memType -> Types.getImpliedType((BType)memType).tag == 33).map(memFiniteType -> (BFiniteType)memFiniteType).toList();
        if (finiteTypeMembers.isEmpty()) {
            return this.symTable.semanticError;
        }
        ArrayList<SemNamedType> newValueSpace = new ArrayList<SemNamedType>();
        for (BFiniteType finiteType : finiteTypeMembers) {
            for (SemNamedType semNamedType : finiteType.valueSpace) {
                if (!SemTypes.isSubtype((Context)this.types.semTypeCtx, (SemType)semNamedType.semType(), (SemType)matchType.semType())) continue;
                newValueSpace.add(semNamedType);
            }
        }
        if (newValueSpace.isEmpty()) {
            return this.symTable.semanticError;
        }
        return new BFiniteType(null, (SemNamedType[])newValueSpace.toArray(SemNamedType[]::new));
    }

    private BType getIntLiteralType(BType expType, Object literalValue, AnalyzerData data) {
        if (!(literalValue instanceof Long)) {
            data.resultType = this.symTable.semanticError;
            return this.symTable.semanticError;
        }
        Long longValue = (Long)literalValue;
        switch (Types.getImpliedType((BType)expType).tag) {
            case 1: {
                return this.symTable.intType;
            }
            case 2: {
                if (!this.types.isByteLiteralValue(longValue)) break;
                return this.symTable.byteType;
            }
            case 39: {
                if (!this.types.isSigned32LiteralValue(longValue)) break;
                return this.symTable.signed32IntType;
            }
            case 40: {
                if (!this.types.isSigned16LiteralValue(longValue)) break;
                return this.symTable.signed16IntType;
            }
            case 41: {
                if (!this.types.isSigned8LiteralValue(longValue)) break;
                return this.symTable.signed8IntType;
            }
            case 42: {
                if (!this.types.isUnsigned32LiteralValue(longValue)) break;
                return this.symTable.unsigned32IntType;
            }
            case 43: {
                if (!this.types.isUnsigned16LiteralValue(longValue)) break;
                return this.symTable.unsigned16IntType;
            }
            case 44: {
                if (!this.types.isUnsigned8LiteralValue(longValue)) break;
                return this.symTable.unsigned8IntType;
            }
        }
        return this.symTable.intType;
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructor, AnalyzerData data) {
        BType expType = data.expType;
        BType referredExpType = Types.getImpliedType(expType);
        if (referredExpType.tag == 24 || referredExpType.tag == 38) {
            BType inferredType = this.getInferredTupleType(listConstructor, expType, data);
            data.resultType = inferredType == this.symTable.semanticError ? this.symTable.semanticError : this.types.checkType(listConstructor, inferredType, expType);
            return;
        }
        data.resultType = this.checkListConstructorCompatibility(expType, listConstructor, data);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr, AnalyzerData data) {
        BType expType = data.expType;
        BType applicableExpType = Types.getImpliedType(expType);
        if (applicableExpType.tag == 24 || applicableExpType.tag == 18 || applicableExpType.tag == 11) {
            BType inherentMemberType;
            InferredTupleDetails inferredTupleDetails = this.checkExprList(new ArrayList<BLangExpression>(tableConstructorExpr.recordLiteralList), data);
            List<BType> memTypes2 = inferredTupleDetails.fixedMemberTypes;
            for (BType bType : memTypes2) {
                if (bType != this.symTable.semanticError) continue;
                data.resultType = this.symTable.semanticError;
                return;
            }
            if (applicableExpType.tag == 24 && tableConstructorExpr.recordLiteralList.isEmpty()) {
                this.dlog.error(tableConstructorExpr.pos, DiagnosticErrorCode.CANNOT_INFER_MEMBER_TYPE_FOR_TABLE, new Object[0]);
                data.resultType = this.symTable.semanticError;
                return;
            }
            if (applicableExpType.tag == 18 && tableConstructorExpr.tableKeySpecifier != null) {
                this.dlog.error(tableConstructorExpr.tableKeySpecifier.pos, DiagnosticErrorCode.KEY_SPECIFIER_NOT_ALLOWED_FOR_TARGET_ANY, new Object[0]);
                data.resultType = this.symTable.semanticError;
                return;
            }
            if (tableConstructorExpr.tableKeySpecifier == null && applicableExpType.tag != 24) {
                inherentMemberType = this.getMappingConstructorCompatibleNonUnionType(expType, data);
            } else {
                inherentMemberType = this.inferTableMemberType(memTypes2, tableConstructorExpr, data);
                for (BLangRecordLiteral recordLiteral : tableConstructorExpr.recordLiteralList) {
                    recordLiteral.setBType(inherentMemberType);
                }
            }
            BTableType bTableType = new BTableType(this.typeEnv, inherentMemberType, null);
            if (!this.validateTableConstructorExpr(tableConstructorExpr, bTableType, data)) {
                data.resultType = this.symTable.semanticError;
                return;
            }
            if (this.checkKeySpecifier(tableConstructorExpr, bTableType, data)) {
                return;
            }
            data.resultType = bTableType;
            return;
        }
        if (applicableExpType.tag == 9) {
            ArrayList<BType> memTypes = new ArrayList<BType>();
            Iterator<BLangRecordLiteral> memTypes2 = tableConstructorExpr.recordLiteralList.iterator();
            while (memTypes2.hasNext()) {
                void var8_18;
                BType recordType;
                BLangRecordLiteral recordLiteral;
                BLangRecordLiteral bLangRecordLiteral = recordLiteral = memTypes2.next();
                if (data.commonAnalyzerData.nonErrorLoggingCheck) {
                    ++bLangRecordLiteral.cloneAttempt;
                    BLangRecordLiteral bLangRecordLiteral2 = this.nodeCloner.cloneNode(recordLiteral);
                }
                if ((recordType = this.checkExpr((BLangExpression)var8_18, ((BTableType)applicableExpType).constraint, data)) == this.symTable.semanticError) {
                    data.resultType = this.symTable.semanticError;
                    return;
                }
                memTypes.add(recordType);
            }
            if (!this.validateKeySpecifierInTableConstructor((BTableType)applicableExpType, tableConstructorExpr.recordLiteralList, data) || !this.validateTableConstructorExpr(tableConstructorExpr, (BTableType)applicableExpType, data)) {
                data.resultType = this.symTable.semanticError;
                return;
            }
            BTableType expectedTableType = (BTableType)applicableExpType;
            if (expectedTableType.constraint.tag == 16 && expectedTableType.isTypeInlineDefined) {
                if (this.validateMapConstraintTable(applicableExpType)) {
                    data.resultType = this.symTable.semanticError;
                    return;
                }
                data.resultType = expType;
                return;
            }
            BTableType tableType = new BTableType(this.typeEnv, this.inferTableMemberType(memTypes, applicableExpType), null);
            if (Symbols.isFlagOn(applicableExpType.getFlags(), 32L)) {
                tableType.addFlags(32L);
            }
            if (this.checkKeySpecifier(tableConstructorExpr, tableType, data)) {
                return;
            }
            if (!expectedTableType.fieldNameList.isEmpty() && tableType.fieldNameList.isEmpty()) {
                tableType.fieldNameList = expectedTableType.fieldNameList;
            }
            data.resultType = this.isSameTableType(tableType, (BTableType)applicableExpType) ? expType : tableType;
        } else if (applicableExpType.tag == 21) {
            boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
            data.commonAnalyzerData.nonErrorLoggingCheck = true;
            GlobalStateSnapshot previousGlobalState = this.getGlobalStateSnapshotAndResetGlobalState();
            this.dlog.mute();
            ArrayList<BType> matchingTypes = new ArrayList<BType>();
            BUnionType bUnionType = (BUnionType)applicableExpType;
            for (BType memType : bUnionType.getMemberTypes()) {
                BType resultType;
                this.dlog.resetErrorCount();
                BLangTableConstructorExpr clonedTableExpr = tableConstructorExpr;
                if (data.commonAnalyzerData.nonErrorLoggingCheck) {
                    ++tableConstructorExpr.cloneAttempt;
                    clonedTableExpr = this.nodeCloner.cloneNode(tableConstructorExpr);
                }
                if ((resultType = this.checkExpr((BLangExpression)clonedTableExpr, memType, data)) == this.symTable.semanticError || this.dlog.errorCount() != 0 || !this.types.isUniqueType(matchingTypes, resultType)) continue;
                matchingTypes.add(resultType);
            }
            data.commonAnalyzerData.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
            this.restoreGlobalState(previousGlobalState);
            if (!prevNonErrorLoggingCheck) {
                this.dlog.unmute();
            }
            if (matchingTypes.isEmpty()) {
                BLangTableConstructorExpr exprToLog = tableConstructorExpr;
                if (data.commonAnalyzerData.nonErrorLoggingCheck) {
                    ++tableConstructorExpr.cloneAttempt;
                    exprToLog = this.nodeCloner.cloneNode(tableConstructorExpr);
                }
                this.dlog.error(tableConstructorExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, expType, this.getInferredTableType(exprToLog, data));
            } else if (matchingTypes.size() != 1) {
                this.dlog.error(tableConstructorExpr.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, expType);
            } else {
                data.resultType = this.checkExpr((BLangExpression)tableConstructorExpr, (BType)matchingTypes.get(0), data);
                return;
            }
            data.resultType = this.symTable.semanticError;
        } else {
            data.resultType = this.types.checkType(tableConstructorExpr.pos, this.getInferredTableType(this.nodeCloner.cloneNode(tableConstructorExpr), data), expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
        }
    }

    private BType getInferredTableType(BLangTableConstructorExpr exprToLog, AnalyzerData data) {
        InferredTupleDetails inferredTupleDetails = this.checkExprList(new ArrayList<BLangExpression>(exprToLog.recordLiteralList), data);
        List<BType> memTypes = inferredTupleDetails.fixedMemberTypes;
        for (BType memType : memTypes) {
            if (memType != this.symTable.semanticError) continue;
            return this.symTable.semanticError;
        }
        return new BTableType(this.typeEnv, this.inferTableMemberType(memTypes, exprToLog, data), null);
    }

    private boolean checkKeySpecifier(BLangTableConstructorExpr tableConstructorExpr, BTableType tableType, AnalyzerData data) {
        if (tableConstructorExpr.tableKeySpecifier != null) {
            if (!this.validateTableKeyValue(this.getTableKeyNameList(tableConstructorExpr.tableKeySpecifier), tableConstructorExpr.recordLiteralList, tableType.constraint, data)) {
                data.resultType = this.symTable.semanticError;
                return true;
            }
            tableType.fieldNameList = this.getTableKeyNameList(tableConstructorExpr.tableKeySpecifier);
        }
        return false;
    }

    private BType inferTableMemberType(List<BType> memTypes, BType expType) {
        if (memTypes.isEmpty()) {
            return ((BTableType)expType).constraint;
        }
        LinkedHashSet<BType> result = new LinkedHashSet<BType>();
        result.add(memTypes.get(0));
        BUnionType unionType = BUnionType.create(this.typeEnv, null, result);
        for (int i = 1; i < memTypes.size(); ++i) {
            BType source = memTypes.get(i);
            if (this.types.isAssignable(source, unionType)) continue;
            result.add(source);
            unionType = BUnionType.create(this.typeEnv, null, result);
        }
        if (((HashSet)unionType.getMemberTypes()).size() == 1) {
            return memTypes.get(0);
        }
        return unionType;
    }

    private BType inferTableMemberType(List<BType> memTypes, BLangTableConstructorExpr tableConstructorExpr, AnalyzerData data) {
        BLangTableKeySpecifier keySpecifier = tableConstructorExpr.tableKeySpecifier;
        ArrayList<String> keySpecifierFieldNames = new ArrayList<String>();
        ArrayList<BType> restFieldTypes = new ArrayList<BType>();
        if (keySpecifier != null) {
            for (IdentifierNode identifierNode : keySpecifier.fieldNameIdentifierList) {
                keySpecifierFieldNames.add(((BLangIdentifier)identifierNode).value);
            }
        }
        LinkedHashMap<String, 6> fieldNameToFields = new LinkedHashMap<String, 6>();
        for (BType memType : memTypes) {
            BRecordType member = (BRecordType)memType;
            for (Map.Entry entry : member.fields.entrySet()) {
                String key = (String)entry.getKey();
                final BField field = (BField)entry.getValue();
                if (fieldNameToFields.containsKey(key)) {
                    ((List)fieldNameToFields.get(key)).add(field);
                    continue;
                }
                fieldNameToFields.put(key, new ArrayList<BField>(){
                    {
                        this.add(field);
                    }
                });
            }
            if (member.sealed) continue;
            restFieldTypes.add(member.restFieldType);
        }
        LinkedHashSet<BField> linkedHashSet = new LinkedHashSet<BField>();
        int memTypesSize = memTypes.size();
        for (Map.Entry entry : fieldNameToFields.entrySet()) {
            boolean isOptional;
            String fieldName = (String)entry.getKey();
            List fields = (List)entry.getValue();
            ArrayList<BType> types = new ArrayList<BType>();
            for (BField field : fields) {
                types.add(field.getType());
            }
            for (BType memType : memTypes) {
                BRecordType bMemType = (BRecordType)memType;
                if (bMemType.sealed || bMemType.fields.containsKey(fieldName)) continue;
                BType restFieldType = bMemType.restFieldType;
                types.add(restFieldType);
            }
            BField resultantField = this.createFieldWithType((BField)fields.get(0), types);
            boolean bl = isOptional = this.hasOptionalFields(fields) || fields.size() != memTypesSize;
            resultantField.symbol.flags = isOptional ? 4096L : (keySpecifierFieldNames.contains(fieldName) ? 288L : 256L);
            linkedHashSet.add(resultantField);
        }
        return this.createTableConstraintRecordType(linkedHashSet, restFieldTypes, tableConstructorExpr.pos, data);
    }

    private boolean isSameTableType(BTableType source, BTableType target) {
        return target.keyTypeConstraint != this.symTable.neverType && source.constraint.equals(target.constraint) && source.fieldNameList.equals(target.fieldNameList);
    }

    private BField createFieldWithType(BField field, List<BType> bTypes) {
        BType resultantType = this.getResultantType(bTypes);
        BVarSymbol originalSymbol = field.symbol;
        BVarSymbol fieldSymbol = new BVarSymbol(originalSymbol.flags, originalSymbol.name, originalSymbol.pkgID, resultantType, originalSymbol.owner, originalSymbol.pos, SymbolOrigin.VIRTUAL);
        return new BField(field.name, field.pos, fieldSymbol);
    }

    private BType getResultantType(List<BType> bTypes) {
        LinkedHashSet<BType> bTypeSet = new LinkedHashSet<BType>(bTypes);
        ArrayList<BType> flattenBTypes = new ArrayList<BType>(bTypes.size());
        this.addFlattenMemberTypes(flattenBTypes, bTypeSet);
        return this.getRepresentativeBroadType(flattenBTypes);
    }

    private void addFlattenMemberTypes(List<BType> flattenBTypes, LinkedHashSet<BType> bTypes) {
        block3: for (BType memberType : bTypes) {
            BType referredMemberType = Types.getImpliedType(memberType);
            switch (referredMemberType.tag) {
                case 21: {
                    this.addFlattenMemberTypes(flattenBTypes, (LinkedHashSet<BType>)((BUnionType)referredMemberType).getMemberTypes());
                    continue block3;
                }
            }
            BType bType = memberType;
            flattenBTypes.add(bType);
        }
    }

    private boolean hasOptionalFields(List<BField> fields) {
        for (BField field : fields) {
            if (!field.symbol.getFlags().contains((Object)Flag.OPTIONAL)) continue;
            return true;
        }
        return false;
    }

    private BRecordType createTableConstraintRecordType(Set<BField> inferredFields, List<BType> restFieldTypes, Location pos, AnalyzerData data) {
        PackageID pkgID = data.env.enclPkg.symbol.pkgID;
        BRecordTypeSymbol recordSymbol = this.createRecordTypeSymbol(pkgID, pos, SymbolOrigin.VIRTUAL, data);
        for (BField field : inferredFields) {
            recordSymbol.scope.define(field.name, field.symbol);
        }
        BRecordType recordType = new BRecordType(this.typeEnv, (BTypeSymbol)recordSymbol);
        recordType.fields = inferredFields.stream().collect(this.getFieldCollector());
        recordSymbol.type = recordType;
        recordType.tsymbol = recordSymbol;
        BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(recordType, pkgID, this.symTable, pos);
        TypeDefBuilderHelper.createTypeDefinitionForTSymbol(recordType, recordSymbol, recordTypeNode, data.env);
        if (restFieldTypes.isEmpty()) {
            recordType.sealed = true;
            recordType.restFieldType = this.symTable.noType;
        } else {
            recordType.restFieldType = this.getResultantType(restFieldTypes);
        }
        return recordType;
    }

    private Collector<BField, ?, LinkedHashMap<String, BField>> getFieldCollector() {
        BinaryOperator mergeFunc = (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
        return Collectors.toMap(field -> field.name.value, Function.identity(), mergeFunc, LinkedHashMap::new);
    }

    private boolean validateKeySpecifierInTableConstructor(BTableType tableType, List<BLangRecordLiteral> recordLiterals, AnalyzerData data) {
        List<String> fieldNameList = tableType.fieldNameList;
        if (!fieldNameList.isEmpty()) {
            return this.validateTableKeyValue(fieldNameList, recordLiterals, tableType.constraint, data);
        }
        return true;
    }

    private boolean validateTableKeyValue(List<String> keySpecifierFieldNames, List<BLangRecordLiteral> rows, BType constraint, AnalyzerData data) {
        for (BLangRecordLiteral row : rows) {
            for (String fieldName : keySpecifierFieldNames) {
                BField field = this.types.getTableConstraintField(constraint, fieldName);
                BLangExpression recordKeyValueField = this.getRecordKeyValueField(row, fieldName);
                if (recordKeyValueField != null && this.isConstExpression(recordKeyValueField)) continue;
                if (recordKeyValueField == null && this.isFieldWithDefaultValue(field)) {
                    this.dlog.error(row.pos, DiagnosticErrorCode.UNSUPPORTED_USAGE_OF_DEFAULT_VALUES_FOR_KEY_FIELD_IN_TABLE_MEMBER, new Object[0]);
                } else {
                    this.dlog.error(row.pos, DiagnosticErrorCode.KEY_SPECIFIER_FIELD_VALUE_MUST_BE_CONSTANT_EXPR, fieldName);
                }
                data.resultType = this.symTable.semanticError;
            }
        }
        return data.resultType != this.symTable.semanticError;
    }

    private boolean isFieldWithDefaultValue(BField field) {
        long flags = field.symbol.flags;
        return !Symbols.isFlagOn(flags, 256L) && !Symbols.isFlagOn(flags, 4096L);
    }

    private boolean isConstExpression(BLangExpression expression) {
        switch (expression.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: 
            case XML_ELEMENT_LITERAL: 
            case XML_TEXT_LITERAL: 
            case TABLE_CONSTRUCTOR_EXPR: 
            case REG_EXP_TEMPLATE_LITERAL: {
                return true;
            }
            case SIMPLE_VARIABLE_REF: {
                BSymbol varSymbol = ((BLangSimpleVarRef)expression).symbol;
                return varSymbol == null || (varSymbol.tag & 0x100001CL) == 0x100001CL;
            }
            case STRING_TEMPLATE_LITERAL: {
                return this.checkNestedConstExpr(((BLangStringTemplateLiteral)expression).exprs);
            }
            case TERNARY_EXPR: {
                BLangTernaryExpr ternaryExpr = (BLangTernaryExpr)expression;
                return this.isConstExpression(ternaryExpr.expr) && this.isConstExpression(ternaryExpr.thenExpr) && this.isConstExpression(ternaryExpr.elseExpr);
            }
            case UNARY_EXPR: {
                return this.isConstExpression(((BLangUnaryExpr)expression).expr);
            }
            case BINARY_EXPR: {
                BLangBinaryExpr binaryExpr = (BLangBinaryExpr)expression;
                return this.isConstExpression(binaryExpr.lhsExpr) && this.isConstExpression(binaryExpr.rhsExpr);
            }
            case GROUP_EXPR: {
                return this.isConstExpression(((BLangGroupExpr)expression).expression);
            }
            case TYPE_CONVERSION_EXPR: {
                return this.isConstExpression(((BLangTypeConversionExpr)expression).expr);
            }
            case TYPE_TEST_EXPR: {
                return this.isConstExpression(((BLangTypeTestExpr)expression).expr);
            }
            case LIST_CONSTRUCTOR_EXPR: {
                return this.checkNestedConstExpr(((BLangListConstructorExpr)expression).exprs);
            }
            case LIST_CONSTRUCTOR_SPREAD_OP: {
                return this.isConstExpression(((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expression).expr);
            }
            case RECORD_LITERAL_EXPR: {
                BLangRecordLiteral recordLiteral = (BLangRecordLiteral)expression;
                List<RecordLiteralNode.RecordField> fields = recordLiteral.getFields();
                for (RecordLiteralNode.RecordField field : fields) {
                    switch (field.getKind()) {
                        case RECORD_LITERAL_KEY_VALUE: {
                            if (this.isConstExpression(((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr) && this.isConstExpression(((BLangRecordLiteral.BLangRecordKeyValueField)field).key.expr)) break;
                            return false;
                        }
                        case RECORD_LITERAL_SPREAD_OP: {
                            if (this.isConstExpression(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr)) break;
                            return false;
                        }
                        case SIMPLE_VARIABLE_REF: {
                            if (this.isConstExpression((BLangRecordLiteral.BLangRecordVarNameField)field)) break;
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkNestedConstExpr(List<? extends BLangExpression> expressions) {
        for (BLangExpression bLangExpression : expressions) {
            if (this.isConstExpression(bLangExpression)) continue;
            return false;
        }
        return true;
    }

    private BLangExpression getRecordKeyValueField(BLangRecordLiteral recordLiteral, String fieldName) {
        for (RecordLiteralNode.RecordField recordField : recordLiteral.fields) {
            if (recordField.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField recordKeyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)recordField;
                if (!fieldName.equals(recordKeyValueField.key.toString())) continue;
                return recordKeyValueField.valueExpr;
            }
            if (recordField.getKind() != NodeKind.SIMPLE_VARIABLE_REF || !fieldName.equals(((BLangRecordLiteral.BLangRecordVarNameField)recordField).variableName.value)) continue;
            return (BLangRecordLiteral.BLangRecordVarNameField)recordField;
        }
        return null;
    }

    public boolean validateKeySpecifier(List<String> fieldNameList, BType constraint, Location pos) {
        for (String fieldName : fieldNameList) {
            BField field = this.types.getTableConstraintField(constraint, fieldName);
            if (field == null) {
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_FIELD_NAMES_IN_KEY_SPECIFIER, fieldName, constraint);
                return true;
            }
            if (!Symbols.isFlagOn(field.symbol.flags, 32L)) {
                this.dlog.error(pos, DiagnosticErrorCode.KEY_SPECIFIER_FIELD_MUST_BE_READONLY, fieldName);
                return true;
            }
            if (Symbols.isFlagOn(field.symbol.flags, 4096L)) {
                this.dlog.error(pos, DiagnosticErrorCode.KEY_SPECIFIER_FIELD_MUST_BE_REQUIRED, fieldName);
                return true;
            }
            if (this.types.isAssignable(field.type, this.symTable.anydataType)) continue;
            this.dlog.error(pos, DiagnosticErrorCode.KEY_SPECIFIER_FIELD_MUST_BE_ANYDATA, fieldName, constraint);
            return true;
        }
        return false;
    }

    private boolean validateTableConstructorExpr(BLangTableConstructorExpr tableConstructorExpr, BTableType tableType, AnalyzerData data) {
        BType keyTypeConstraint;
        boolean isKeySpecifierEmpty;
        BType constraintType = tableType.constraint;
        ArrayList<String> fieldNameList = new ArrayList<String>();
        boolean bl = isKeySpecifierEmpty = tableConstructorExpr.tableKeySpecifier == null;
        if (!isKeySpecifierEmpty) {
            fieldNameList.addAll(this.getTableKeyNameList(tableConstructorExpr.tableKeySpecifier));
            if (tableType.fieldNameList.isEmpty() && this.validateKeySpecifier(fieldNameList, constraintType, tableConstructorExpr.tableKeySpecifier.pos)) {
                data.resultType = this.symTable.semanticError;
                return false;
            }
            if (!tableType.fieldNameList.isEmpty() && !tableType.fieldNameList.equals(fieldNameList)) {
                this.dlog.error(tableConstructorExpr.tableKeySpecifier.pos, DiagnosticErrorCode.TABLE_KEY_SPECIFIER_MISMATCH, tableType.fieldNameList.toString(), ((Object)fieldNameList).toString());
                data.resultType = this.symTable.semanticError;
                return false;
            }
        }
        if ((keyTypeConstraint = tableType.keyTypeConstraint) != null) {
            BType referredKeyTypeConstraint = Types.getImpliedType(keyTypeConstraint);
            ArrayList<BType> memberTypes = new ArrayList<BType>();
            switch (referredKeyTypeConstraint.tag) {
                case 31: {
                    memberTypes.addAll(((BTupleType)referredKeyTypeConstraint).getTupleTypes());
                    break;
                }
                case 12: {
                    LinkedHashMap<String, BField> fieldList = ((BRecordType)referredKeyTypeConstraint).getFields();
                    memberTypes.addAll(fieldList.entrySet().stream().filter(e -> fieldNameList.contains(e.getKey())).map(entry -> ((BField)entry.getValue()).type).toList());
                    if (!memberTypes.isEmpty()) break;
                    memberTypes.add(keyTypeConstraint);
                    break;
                }
                default: {
                    memberTypes.add(keyTypeConstraint);
                }
            }
            if (isKeySpecifierEmpty && referredKeyTypeConstraint.tag == 50) {
                return true;
            }
            if (isKeySpecifierEmpty || tableConstructorExpr.tableKeySpecifier.fieldNameIdentifierList.size() != memberTypes.size()) {
                if (isKeySpecifierEmpty) {
                    this.dlog.error(tableConstructorExpr.pos, DiagnosticErrorCode.KEY_SPECIFIER_EMPTY_FOR_PROVIDED_KEY_CONSTRAINT, memberTypes);
                } else {
                    this.dlog.error(tableConstructorExpr.pos, DiagnosticErrorCode.KEY_SPECIFIER_SIZE_MISMATCH_WITH_KEY_CONSTRAINT, memberTypes, tableConstructorExpr.tableKeySpecifier.fieldNameIdentifierList);
                }
                data.resultType = this.symTable.semanticError;
                return false;
            }
            List<IdentifierNode> fieldNameIdentifierList = tableConstructorExpr.tableKeySpecifier.fieldNameIdentifierList;
            int index = 0;
            for (IdentifierNode identifier : fieldNameIdentifierList) {
                BField field = this.types.getTableConstraintField(constraintType, ((BLangIdentifier)identifier).value);
                if (field == null || !this.types.isAssignable(field.type, (BType)memberTypes.get(index))) {
                    this.dlog.error(tableConstructorExpr.tableKeySpecifier.pos, DiagnosticErrorCode.KEY_SPECIFIER_MISMATCH_WITH_KEY_CONSTRAINT, fieldNameIdentifierList.toString(), ((Object)memberTypes).toString());
                    data.resultType = this.symTable.semanticError;
                    return false;
                }
                ++index;
            }
        }
        return true;
    }

    public boolean validateMapConstraintTable(BType expType) {
        if (!(expType == null || ((BTableType)expType).fieldNameList.isEmpty() && ((BTableType)expType).keyTypeConstraint == null || expType.tsymbol.owner.getFlags().contains((Object)Flag.LANG_LIB))) {
            this.dlog.error(((BTableType)expType).keyPos, DiagnosticErrorCode.KEY_CONSTRAINT_NOT_SUPPORTED_FOR_TABLE_WITH_MAP_CONSTRAINT, new Object[0]);
            return true;
        }
        return false;
    }

    private List<String> getTableKeyNameList(BLangTableKeySpecifier tableKeySpecifier) {
        ArrayList<String> fieldNamesList = new ArrayList<String>();
        for (IdentifierNode identifier : tableKeySpecifier.fieldNameIdentifierList) {
            fieldNamesList.add(((BLangIdentifier)identifier).value);
        }
        return fieldNamesList;
    }

    private BType createTableKeyConstraint(List<String> fieldNames, BType constraintType) {
        if (fieldNames.isEmpty()) {
            return this.symTable.semanticError;
        }
        ArrayList<BTupleMember> memTypes = new ArrayList<BTupleMember>();
        for (String fieldName : fieldNames) {
            BField tableConstraintField = this.types.getTableConstraintField(constraintType, fieldName);
            if (tableConstraintField == null) {
                return this.symTable.semanticError;
            }
            BType fieldType = tableConstraintField.type;
            BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(fieldType);
            memTypes.add(new BTupleMember(fieldType, varSymbol));
        }
        if (memTypes.size() == 1) {
            return ((BTupleMember)memTypes.get((int)0)).type;
        }
        return new BTupleType(this.typeEnv, memTypes);
    }

    protected BType checkListConstructorCompatibility(BType bType, BLangListConstructorExpr listConstructor, AnalyzerData data) {
        BType refType = Types.getImpliedType(bType);
        BType compatibleType = this.checkListConstructorCompatibility(refType, bType, listConstructor, data);
        return compatibleType == refType ? bType : compatibleType;
    }

    private BType checkListConstructorCompatibility(BType referredType, BType originalType, BLangListConstructorExpr listConstructor, AnalyzerData data) {
        int tag = referredType.tag;
        if (tag == 21) {
            boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
            GlobalStateSnapshot previousGlobalState = this.getGlobalStateSnapshotAndResetGlobalState();
            data.commonAnalyzerData.nonErrorLoggingCheck = true;
            this.dlog.mute();
            ArrayList<BType> compatibleTypes = new ArrayList<BType>();
            boolean erroredExpType = false;
            for (BType memberType2 : ((BUnionType)referredType).getMemberTypes()) {
                if (memberType2 == this.symTable.semanticError) {
                    if (erroredExpType) continue;
                    erroredExpType = true;
                    continue;
                }
                BType listCompatibleMemType = this.getListConstructorCompatibleNonUnionType(memberType2, data);
                if (listCompatibleMemType == this.symTable.semanticError) continue;
                this.dlog.resetErrorCount();
                BType memCompatibiltyType = this.checkListConstructorCompatibility(listCompatibleMemType, listConstructor, data);
                if (memCompatibiltyType == this.symTable.semanticError || this.dlog.errorCount() != 0 || !this.types.isUniqueType(compatibleTypes, memCompatibiltyType)) continue;
                compatibleTypes.add(memCompatibiltyType);
            }
            data.commonAnalyzerData.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
            this.restoreGlobalState(previousGlobalState);
            if (!prevNonErrorLoggingCheck) {
                this.dlog.unmute();
            }
            if (compatibleTypes.isEmpty()) {
                BLangListConstructorExpr exprToLog = listConstructor;
                if (data.commonAnalyzerData.nonErrorLoggingCheck) {
                    ++listConstructor.cloneAttempt;
                    exprToLog = this.nodeCloner.cloneNode(listConstructor);
                }
                BType inferredTupleType = this.getInferredTupleType(exprToLog, this.symTable.noType, data);
                if (!erroredExpType && inferredTupleType != this.symTable.semanticError) {
                    this.dlog.error(listConstructor.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data.expType, inferredTupleType);
                }
                return this.symTable.semanticError;
            }
            if (compatibleTypes.size() != 1) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, data.expType);
                return this.symTable.semanticError;
            }
            return this.checkListConstructorCompatibility((BType)compatibleTypes.get(0), listConstructor, data);
        }
        BType possibleType = this.getListConstructorCompatibleNonUnionType(referredType, data);
        switch (possibleType.tag) {
            case 20: {
                return this.checkArrayType(listConstructor, (BArrayType)possibleType, data);
            }
            case 31: {
                return this.checkTupleType(listConstructor, (BTupleType)possibleType, data);
            }
            case 38: {
                return this.checkReadOnlyListType(listConstructor, data);
            }
            case 13: {
                listConstructor.isTypedescExpr = true;
                InferredTupleDetails inferredTupleDetails = new InferredTupleDetails();
                for (BLangExpression expr : listConstructor.exprs) {
                    BType resultType;
                    if (expr.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                        BLangExpression spreadOpExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
                        BType spreadOpExprType = this.checkExpr(spreadOpExpr, this.symTable.noType, data);
                        this.updateInferredTupleDetailsFromSpreadMember(expr.pos, spreadOpExprType, inferredTupleDetails);
                        continue;
                    }
                    BType memberType3 = resultType = this.checkExpr(expr, this.symTable.noType, data);
                    if (expr.getKind() == NodeKind.TYPEDESC_EXPRESSION) {
                        memberType3 = ((BLangTypedescExpr)expr).resolvedType;
                    } else if (expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                        memberType3 = ((BLangSimpleVarRef)expr).symbol.type;
                    }
                    if (inferredTupleDetails.restMemberTypes.isEmpty()) {
                        inferredTupleDetails.fixedMemberTypes.add(memberType3);
                        continue;
                    }
                    inferredTupleDetails.restMemberTypes.add(memberType3);
                }
                ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
                inferredTupleDetails.fixedMemberTypes.forEach(memberType -> members.add(new BTupleMember((BType)memberType, new BVarSymbol(memberType.getFlags(), null, null, (BType)memberType, null, null, null))));
                BTupleType tupleType = new BTupleType(this.typeEnv, members);
                if (!inferredTupleDetails.restMemberTypes.isEmpty()) {
                    tupleType.restType = this.getRepresentativeBroadType(inferredTupleDetails.restMemberTypes);
                }
                listConstructor.typedescType = tupleType;
                return new BTypedescType(this.typeEnv, listConstructor.typedescType, null);
            }
        }
        if (referredType == this.symTable.semanticError) {
            this.getInferredTupleType(listConstructor, this.symTable.semanticError, data);
        } else if (!data.commonAnalyzerData.nonErrorLoggingCheck) {
            this.dlog.error(listConstructor.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, originalType, this.getInferredTupleType(listConstructor, this.symTable.noType, data));
        }
        return this.symTable.semanticError;
    }

    private void updateInferredTupleDetailsFromSpreadMember(Location spreadMemberPos, BType spreadOpExprType, InferredTupleDetails inferredTupleDetails) {
        BType originalExprType = spreadOpExprType;
        spreadOpExprType = Types.getImpliedType(spreadOpExprType);
        if (!inferredTupleDetails.restMemberTypes.isEmpty()) {
            if (spreadOpExprType.tag == 31) {
                BTupleType bTupleType = (BTupleType)spreadOpExprType;
                bTupleType.getTupleTypes().forEach(t -> inferredTupleDetails.restMemberTypes.add((BType)t));
                if (!this.types.isFixedLengthTuple(bTupleType)) {
                    inferredTupleDetails.restMemberTypes.add(bTupleType.restType);
                }
            } else if (spreadOpExprType.tag == 20) {
                BArrayType bArrayType = (BArrayType)spreadOpExprType;
                inferredTupleDetails.restMemberTypes.add(bArrayType.eType);
            } else {
                this.dlog.error(spreadMemberPos, DiagnosticErrorCode.CANNOT_INFER_TYPE_FROM_SPREAD_OP, originalExprType);
                inferredTupleDetails.restMemberTypes.add(this.symTable.semanticError);
            }
            return;
        }
        if (spreadOpExprType.tag == 31) {
            BTupleType bTupleType = (BTupleType)spreadOpExprType;
            inferredTupleDetails.fixedMemberTypes.addAll(bTupleType.getTupleTypes());
            if (!this.types.isFixedLengthTuple(bTupleType)) {
                inferredTupleDetails.restMemberTypes.add(bTupleType.restType);
            }
        } else if (spreadOpExprType.tag == 20) {
            BArrayType bArrayType = (BArrayType)spreadOpExprType;
            if (bArrayType.state == BArrayState.CLOSED) {
                for (int i = 0; i < bArrayType.getSize(); ++i) {
                    BType memberType = bArrayType.eType;
                    inferredTupleDetails.fixedMemberTypes.add(memberType);
                }
            } else {
                inferredTupleDetails.restMemberTypes.add(bArrayType.eType);
            }
        } else {
            this.dlog.error(spreadMemberPos, DiagnosticErrorCode.CANNOT_INFER_TYPE_FROM_SPREAD_OP, originalExprType);
            inferredTupleDetails.fixedMemberTypes.add(this.symTable.semanticError);
        }
    }

    private BType getListConstructorCompatibleNonUnionType(BType type, AnalyzerData data) {
        BType referredType = Types.getImpliedType(type);
        return switch (referredType.tag) {
            case 13, 20, 31, 38 -> type;
            case 7 -> {
                if (!Symbols.isFlagOn(referredType.getFlags(), 32L)) {
                    yield this.symTable.arrayJsonType;
                }
                yield ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.arrayJsonType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 11 -> {
                if (!Symbols.isFlagOn(referredType.getFlags(), 32L)) {
                    yield this.symTable.arrayAnydataType;
                }
                yield ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.arrayAnydataType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 18 -> {
                if (!Symbols.isFlagOn(referredType.getFlags(), 32L)) {
                    yield this.symTable.arrayAllType;
                }
                yield ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.arrayAllType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            default -> this.symTable.semanticError;
        };
    }

    private BType checkArrayType(BLangListConstructorExpr listConstructor, BArrayType arrayType, AnalyzerData data) {
        int listExprSize = 0;
        if (arrayType.state != BArrayState.OPEN) {
            block8: for (BLangExpression expr : listConstructor.exprs) {
                if (expr.getKind() != NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                    ++listExprSize;
                    continue;
                }
                BLangExpression spreadOpExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
                BType spreadOpType = this.checkExpr(spreadOpExpr, data);
                spreadOpType = Types.getImpliedType(spreadOpType);
                switch (spreadOpType.tag) {
                    case 20: {
                        int arraySize = ((BArrayType)spreadOpType).getSize();
                        if (arraySize >= 0) {
                            listExprSize += arraySize;
                            continue block8;
                        }
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.INVALID_SPREAD_OP_FIXED_LENGTH_LIST_EXPECTED, new Object[0]);
                        return this.symTable.semanticError;
                    }
                    case 31: {
                        BTupleType tType = (BTupleType)spreadOpType;
                        if (this.types.isFixedLengthTuple(tType)) {
                            listExprSize += tType.getMembers().size();
                            continue block8;
                        }
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.INVALID_SPREAD_OP_FIXED_LENGTH_LIST_EXPECTED, new Object[0]);
                        return this.symTable.semanticError;
                    }
                }
            }
        }
        BType eType = arrayType.eType;
        if (arrayType.state == BArrayState.INFERRED) {
            arrayType.setSize(listExprSize);
            arrayType.state = BArrayState.CLOSED;
        } else if (arrayType.state != BArrayState.OPEN && arrayType.getSize() != listExprSize) {
            if (arrayType.getSize() < listExprSize) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.MISMATCHING_ARRAY_LITERAL_VALUES, arrayType.getSize(), listExprSize);
                return this.symTable.semanticError;
            }
            if (!this.types.hasFillerValue(eType)) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.INVALID_LIST_CONSTRUCTOR_ELEMENT_TYPE, data.expType);
                return this.symTable.semanticError;
            }
        }
        boolean errored = false;
        block9: for (BLangExpression expr : listConstructor.exprs) {
            if (expr.getKind() != NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                errored |= this.exprIncompatible(eType, expr, data);
                continue;
            }
            BLangExpression spreadOpExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
            BType spreadOpType = this.checkExpr(spreadOpExpr, data);
            BType spreadOpReferredType = Types.getImpliedType(spreadOpType);
            switch (spreadOpReferredType.tag) {
                case 20: {
                    BType spreadOpeType = ((BArrayType)spreadOpReferredType).eType;
                    if (!this.types.typeIncompatible(spreadOpExpr.pos, spreadOpeType, eType)) continue block9;
                    return this.symTable.semanticError;
                }
                case 31: {
                    BTupleType spreadOpTuple = (BTupleType)spreadOpReferredType;
                    List<BType> tupleTypes = spreadOpTuple.getTupleTypes();
                    for (BType tupleMemberType : tupleTypes) {
                        if (!this.types.typeIncompatible(spreadOpExpr.pos, tupleMemberType, eType)) continue;
                        return this.symTable.semanticError;
                    }
                    if (this.types.isFixedLengthTuple(spreadOpTuple) || !this.types.typeIncompatible(spreadOpExpr.pos, spreadOpTuple.restType, eType)) continue block9;
                    return this.symTable.semanticError;
                }
            }
            this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES_LIST_SPREAD_OP, spreadOpType);
            return this.symTable.semanticError;
        }
        return errored ? this.symTable.semanticError : arrayType;
    }

    private BType checkTupleType(BLangListConstructorExpr listConstructor, BTupleType tupleType, AnalyzerData data) {
        List<BLangExpression> exprs = listConstructor.exprs;
        List<BTupleMember> members = tupleType.getMembers();
        int memberTypeSize = members.size();
        BType restType = tupleType.restType;
        if (this.types.isFixedLengthTuple(tupleType)) {
            int listExprSize = 0;
            block8: for (BLangExpression expr : exprs) {
                if (expr.getKind() != NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                    ++listExprSize;
                    continue;
                }
                BLangExpression spreadOpExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
                BType spreadOpType = this.checkExpr(spreadOpExpr, data);
                spreadOpType = Types.getImpliedType(spreadOpType);
                switch (spreadOpType.tag) {
                    case 20: {
                        int arraySize = ((BArrayType)spreadOpType).getSize();
                        if (arraySize >= 0) {
                            listExprSize += arraySize;
                            continue block8;
                        }
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.INVALID_SPREAD_OP_FIXED_LENGTH_LIST_EXPECTED, new Object[0]);
                        return this.symTable.semanticError;
                    }
                    case 31: {
                        BTupleType tType = (BTupleType)spreadOpType;
                        if (this.types.isFixedLengthTuple(tType)) {
                            listExprSize += tType.getMembers().size();
                            continue block8;
                        }
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.INVALID_SPREAD_OP_FIXED_LENGTH_LIST_EXPECTED, new Object[0]);
                        return this.symTable.semanticError;
                    }
                }
            }
            if (listExprSize < memberTypeSize) {
                for (int i = listExprSize; i < memberTypeSize; ++i) {
                    if (!data.isResourceAccessPathSegments && this.types.hasFillerValue(members.get((int)i).type)) continue;
                    this.dlog.error(listConstructor.pos, DiagnosticErrorCode.INVALID_LIST_CONSTRUCTOR_ELEMENT_TYPE, members.get(i));
                    return this.symTable.semanticError;
                }
            } else if (listExprSize > memberTypeSize) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.TUPLE_AND_EXPRESSION_SIZE_DOES_NOT_MATCH, new Object[0]);
                return this.symTable.semanticError;
            }
        }
        boolean errored = false;
        int nonRestTypeIndex = 0;
        block10: for (BLangExpression expr : exprs) {
            BArrayType targetType;
            BType possibleType;
            int remainNonRestCount = memberTypeSize - nonRestTypeIndex;
            if (expr.getKind() != NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                if (remainNonRestCount > 0) {
                    errored |= this.exprIncompatible(members.get((int)nonRestTypeIndex).type, expr, data);
                    ++nonRestTypeIndex;
                    continue;
                }
                errored |= this.exprIncompatible(restType, expr, data);
                continue;
            }
            BLangExpression spreadOpExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
            BType spreadOpType = restType != null && restType != this.symTable.noType && remainNonRestCount == 0 ? ((possibleType = this.silentTypeCheckExpr(spreadOpExpr, targetType = new BArrayType(this.typeEnv, restType), data)) == this.symTable.semanticError ? this.checkExpr(spreadOpExpr, data) : this.checkExpr(spreadOpExpr, targetType, data)) : this.checkExpr(spreadOpExpr, data);
            BType spreadOpReferredType = Types.getImpliedType(spreadOpType);
            switch (spreadOpReferredType.tag) {
                case 20: {
                    BArrayType spreadOpArray = (BArrayType)spreadOpReferredType;
                    if (spreadOpArray.state == BArrayState.CLOSED) {
                        for (int i = 0; i < spreadOpArray.getSize() && nonRestTypeIndex < memberTypeSize; ++i, ++nonRestTypeIndex) {
                            if (!this.types.typeIncompatible(spreadOpExpr.pos, spreadOpArray.eType, members.get((int)nonRestTypeIndex).type)) continue;
                            return this.symTable.semanticError;
                        }
                        if (remainNonRestCount >= spreadOpArray.getSize() || !this.types.typeIncompatible(spreadOpExpr.pos, spreadOpArray.eType, restType)) continue block10;
                        return this.symTable.semanticError;
                    }
                    if (remainNonRestCount > 0) {
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.INVALID_SPREAD_OP_FIXED_MEMBER_EXPECTED, members.get(nonRestTypeIndex));
                        return this.symTable.semanticError;
                    }
                    if (!this.types.typeIncompatible(spreadOpExpr.pos, spreadOpArray.eType, restType)) continue block10;
                    return this.symTable.semanticError;
                }
                case 31: {
                    int i;
                    BTupleType spreadOpTuple = (BTupleType)spreadOpReferredType;
                    List<BType> tupleMemberTypes = spreadOpTuple.getTupleTypes();
                    int spreadOpMemberTypeSize = tupleMemberTypes.size();
                    if (this.types.isFixedLengthTuple(spreadOpTuple)) {
                        for (i = 0; i < spreadOpMemberTypeSize && nonRestTypeIndex < memberTypeSize; ++i, ++nonRestTypeIndex) {
                            if (!this.types.typeIncompatible(spreadOpExpr.pos, tupleMemberTypes.get(i), members.get((int)nonRestTypeIndex).type)) continue;
                            return this.symTable.semanticError;
                        }
                        for (i = remainNonRestCount; i < spreadOpMemberTypeSize; ++i) {
                            if (!this.types.typeIncompatible(spreadOpExpr.pos, tupleMemberTypes.get(i), restType)) continue;
                            return this.symTable.semanticError;
                        }
                        continue block10;
                    }
                    if (spreadOpMemberTypeSize < remainNonRestCount) {
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.INVALID_SPREAD_OP_FIXED_MEMBER_EXPECTED, members.get(nonRestTypeIndex + spreadOpMemberTypeSize));
                        return this.symTable.semanticError;
                    }
                    i = 0;
                    while (nonRestTypeIndex < memberTypeSize) {
                        if (this.types.typeIncompatible(spreadOpExpr.pos, tupleMemberTypes.get(i), members.get((int)nonRestTypeIndex).type)) {
                            return this.symTable.semanticError;
                        }
                        ++i;
                        ++nonRestTypeIndex;
                    }
                    for (i = nonRestTypeIndex; i < spreadOpMemberTypeSize; ++i) {
                        if (!this.types.typeIncompatible(spreadOpExpr.pos, tupleMemberTypes.get(i), restType)) continue;
                        return this.symTable.semanticError;
                    }
                    if (!this.types.typeIncompatible(spreadOpExpr.pos, spreadOpTuple.restType, restType)) continue block10;
                    return this.symTable.semanticError;
                }
            }
            this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES_LIST_SPREAD_OP, spreadOpType);
            return this.symTable.semanticError;
        }
        while (nonRestTypeIndex < memberTypeSize) {
            if (data.isResourceAccessPathSegments || !this.types.hasFillerValue(members.get((int)nonRestTypeIndex).type)) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.INVALID_LIST_CONSTRUCTOR_ELEMENT_TYPE, members.get(nonRestTypeIndex));
                return this.symTable.semanticError;
            }
            ++nonRestTypeIndex;
        }
        return errored ? this.symTable.semanticError : tupleType;
    }

    private BType checkReadOnlyListType(BLangListConstructorExpr listConstructor, AnalyzerData data) {
        if (!data.commonAnalyzerData.nonErrorLoggingCheck) {
            BType inferredType = this.getInferredTupleType(listConstructor, this.symTable.readonlyType, data);
            if (inferredType == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            return this.types.checkType(listConstructor, inferredType, this.symTable.readonlyType);
        }
        for (BLangExpression expr : listConstructor.exprs) {
            if (expr.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                expr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
            }
            if (!this.exprIncompatible(this.symTable.readonlyType, expr, data)) continue;
            return this.symTable.semanticError;
        }
        return this.symTable.readonlyType;
    }

    private boolean exprIncompatible(BType eType, BLangExpression expr, AnalyzerData data) {
        if (expr.typeChecked) {
            return expr.getBType() == this.symTable.semanticError;
        }
        BLangExpression exprToCheck = expr;
        if (data.commonAnalyzerData.nonErrorLoggingCheck) {
            ++expr.cloneAttempt;
            exprToCheck = this.nodeCloner.cloneNode(expr);
        }
        return this.checkExpr(exprToCheck, eType, data) == this.symTable.semanticError;
    }

    private InferredTupleDetails checkExprList(List<BLangExpression> exprs, AnalyzerData data) {
        return this.checkExprList(exprs, this.symTable.noType, data);
    }

    private InferredTupleDetails checkExprList(List<BLangExpression> exprs, BType expType, AnalyzerData data) {
        InferredTupleDetails inferredTupleDetails = new InferredTupleDetails();
        SymbolEnv prevEnv = data.env;
        BType preExpType = data.expType;
        data.expType = expType;
        for (BLangExpression e : exprs) {
            if (e.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                BLangExpression spreadOpExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)e).expr;
                BType spreadOpExprType = this.checkExpr(spreadOpExpr, expType, data);
                this.updateInferredTupleDetailsFromSpreadMember(e.pos, spreadOpExprType, inferredTupleDetails);
                continue;
            }
            this.checkExpr(e, expType, data);
            if (inferredTupleDetails.restMemberTypes.isEmpty()) {
                inferredTupleDetails.fixedMemberTypes.add(data.resultType);
                continue;
            }
            inferredTupleDetails.restMemberTypes.add(data.resultType);
        }
        data.env = prevEnv;
        data.expType = preExpType;
        return inferredTupleDetails;
    }

    protected BType getInferredTupleType(BLangListConstructorExpr listConstructor, BType expType, AnalyzerData data) {
        InferredTupleDetails inferredTupleDetails = this.checkExprList(listConstructor.exprs, expType, data);
        List<BType> fixedMemberTypes = inferredTupleDetails.fixedMemberTypes;
        List<BType> restMemberTypes = inferredTupleDetails.restMemberTypes;
        for (BType memType : fixedMemberTypes) {
            if (memType != this.symTable.semanticError) continue;
            return this.symTable.semanticError;
        }
        for (BType memType : restMemberTypes) {
            if (memType != this.symTable.semanticError) continue;
            return this.symTable.semanticError;
        }
        ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
        fixedMemberTypes.forEach(memberType -> members.add(new BTupleMember((BType)memberType, new BVarSymbol(memberType.getFlags(), null, null, (BType)memberType, null, null, null))));
        BTupleType tupleType = new BTupleType(this.typeEnv, members);
        if (!restMemberTypes.isEmpty()) {
            tupleType.restType = this.getRepresentativeBroadType(restMemberTypes);
        }
        if (Types.getImpliedType((BType)expType).tag != 38) {
            return tupleType;
        }
        tupleType.addFlags(32L);
        return tupleType;
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral, AnalyzerData data) {
        BType expType = data.expType;
        int expTypeTag = Types.getImpliedType((BType)expType).tag;
        if (expTypeTag == 24 || expTypeTag == 38) {
            expType = this.defineInferredRecordType(recordLiteral, expType, data);
        } else if (expTypeTag == 34) {
            this.dlog.error(recordLiteral.pos, DiagnosticErrorCode.INVALID_RECORD_LITERAL, expType);
            data.resultType = this.symTable.semanticError;
            return;
        }
        data.resultType = this.getEffectiveMappingType(recordLiteral, this.checkMappingConstructorCompatibility(expType, recordLiteral, data), data);
    }

    public BType getEffectiveMappingType(BLangRecordLiteral recordLiteral, BType applicableMappingType, AnalyzerData data) {
        BType refType = Types.getImpliedType(applicableMappingType);
        if (applicableMappingType == this.symTable.semanticError || refType.tag == 12 && Symbols.isFlagOn(applicableMappingType.getFlags(), 32L)) {
            return applicableMappingType;
        }
        LinkedHashMap<String, RecordLiteralNode.RecordField> readOnlyFields = new LinkedHashMap<String, RecordLiteralNode.RecordField>();
        LinkedHashMap applicableTypeFields = refType.tag == 12 ? ((BRecordType)refType).fields : new LinkedHashMap();
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            String name;
            if (field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP) continue;
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                if (!keyValueField.readonly) continue;
                BLangExpression keyExpr = keyValueField.key.expr;
                name = keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF ? ((BLangSimpleVarRef)keyExpr).variableName.value : (String)((BLangLiteral)keyExpr).value;
            } else {
                BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                if (!varNameField.readonly) continue;
                name = varNameField.variableName.value;
            }
            if (applicableTypeFields.containsKey(name) && Symbols.isFlagOn(((BField)applicableTypeFields.get((Object)name)).symbol.flags, 32L)) continue;
            readOnlyFields.put(name, field);
        }
        if (readOnlyFields.isEmpty()) {
            return applicableMappingType;
        }
        PackageID pkgID = data.env.enclPkg.symbol.pkgID;
        Location pos = recordLiteral.pos;
        BRecordTypeSymbol recordSymbol = this.createRecordTypeSymbol(pkgID, pos, SymbolOrigin.VIRTUAL, data);
        LinkedHashMap<Object, BField> newFields = new LinkedHashMap<Object, BField>();
        for (Map.Entry entry : readOnlyFields.entrySet()) {
            RecordLiteralNode.RecordField field = (RecordLiteralNode.RecordField)entry.getValue();
            String key = (String)entry.getKey();
            Name name = Names.fromString(key);
            BType readOnlyFieldType = field.isKeyValueField() ? ((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr.getBType() : ((BLangRecordLiteral.BLangRecordVarNameField)field).getBType();
            BVarSymbol fieldSymbol = new BVarSymbol(Flags.asMask((Set<Flag>)new HashSet<Flag>(){
                {
                    this.add(Flag.REQUIRED);
                    this.add(Flag.READONLY);
                }
            }), name, pkgID, readOnlyFieldType, recordSymbol, ((BLangNode)((Object)field)).pos, SymbolOrigin.VIRTUAL);
            newFields.put(key, new BField(name, null, fieldSymbol));
            recordSymbol.scope.define(name, fieldSymbol);
        }
        BRecordType recordType = new BRecordType(this.typeEnv, (BTypeSymbol)recordSymbol, recordSymbol.flags);
        if (refType.tag == 16) {
            recordType.sealed = false;
            recordType.restFieldType = ((BMapType)refType).constraint;
        } else {
            BRecordType bRecordType = (BRecordType)refType;
            boolean allReadOnlyFields = true;
            for (Map.Entry entry : bRecordType.fields.entrySet()) {
                String fieldName = (String)entry.getKey();
                BField field = (BField)entry.getValue();
                if (readOnlyFields.containsKey(fieldName)) continue;
                BVarSymbol origFieldSymbol = field.symbol;
                long origFieldFlags = origFieldSymbol.flags;
                if (allReadOnlyFields && !Symbols.isFlagOn(origFieldFlags, 32L)) {
                    allReadOnlyFields = false;
                }
                BVarSymbol fieldSymbol = new BVarSymbol(origFieldFlags, field.name, pkgID, origFieldSymbol.type, recordSymbol, field.pos, SymbolOrigin.VIRTUAL);
                newFields.put(fieldName, new BField(field.name, null, fieldSymbol));
                recordSymbol.scope.define(field.name, fieldSymbol);
            }
            recordType.sealed = bRecordType.sealed;
            recordType.restFieldType = bRecordType.restFieldType;
            if (recordType.sealed && allReadOnlyFields) {
                recordType.addFlags(32L);
                recordType.tsymbol.flags |= 0x20L;
            }
        }
        recordType.fields = newFields;
        recordSymbol.type = recordType;
        recordType.tsymbol = recordSymbol;
        BLangRecordTypeNode bLangRecordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(recordType, pkgID, this.symTable, pos);
        TypeDefBuilderHelper.createTypeDefinitionForTSymbol(recordType, recordSymbol, bLangRecordTypeNode, data.env);
        if (refType.tag == 12) {
            BRecordType applicableRecordType = (BRecordType)refType;
            BTypeSymbol applicableRecordTypeSymbol = applicableRecordType.tsymbol;
            BLangUserDefinedType bLangUserDefinedType = new BLangUserDefinedType(ASTBuilderUtil.createIdentifier(pos, TypeDefBuilderHelper.getPackageAlias(data.env, pos.lineRange().fileName(), applicableRecordTypeSymbol.pkgID)), ASTBuilderUtil.createIdentifier(pos, applicableRecordTypeSymbol.name.value));
            bLangUserDefinedType.pos = pos;
            bLangUserDefinedType.setBType(applicableRecordType);
            bLangRecordTypeNode.typeRefs.add(bLangUserDefinedType);
        } else if (refType.tag == 16) {
            recordLiteral.expectedType = applicableMappingType;
        }
        return recordType;
    }

    public BType checkMappingConstructorCompatibility(BType bType, BLangRecordLiteral mappingConstructor, AnalyzerData data) {
        int tag = bType.tag;
        if (tag == 21) {
            boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
            data.commonAnalyzerData.nonErrorLoggingCheck = true;
            GlobalStateSnapshot previousGlobalState = this.getGlobalStateSnapshotAndResetGlobalState();
            this.dlog.mute();
            ArrayList<BType> compatibleTypes = new ArrayList<BType>();
            boolean erroredExpType = false;
            for (BType memberType : ((BUnionType)bType).getMemberTypes()) {
                if (memberType == this.symTable.semanticError) {
                    if (erroredExpType) continue;
                    erroredExpType = true;
                    continue;
                }
                BType listCompatibleMemType = this.getMappingConstructorCompatibleNonUnionType(memberType, data);
                if (listCompatibleMemType == this.symTable.semanticError) continue;
                this.dlog.resetErrorCount();
                BType memCompatibiltyType = this.checkMappingConstructorCompatibility(listCompatibleMemType, mappingConstructor, data);
                if (memCompatibiltyType == this.symTable.semanticError || this.dlog.errorCount() != 0 || !this.types.isUniqueType(compatibleTypes, memCompatibiltyType)) continue;
                compatibleTypes.add(memCompatibiltyType);
            }
            data.commonAnalyzerData.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
            this.restoreGlobalState(previousGlobalState);
            if (!prevNonErrorLoggingCheck) {
                this.dlog.unmute();
            }
            if (compatibleTypes.isEmpty()) {
                if (!erroredExpType) {
                    this.reportIncompatibleMappingConstructorError(mappingConstructor, bType, data);
                }
                this.validateSpecifiedFields(mappingConstructor, this.symTable.semanticError, data);
                return this.symTable.semanticError;
            }
            if (compatibleTypes.size() != 1) {
                this.dlog.error(mappingConstructor.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, bType);
                this.validateSpecifiedFields(mappingConstructor, this.symTable.semanticError, data);
                return this.symTable.semanticError;
            }
            return this.checkMappingConstructorCompatibility((BType)compatibleTypes.get(0), mappingConstructor, data);
        }
        if (tag == 14 || tag == 22) {
            BType refType = Types.getImpliedType(bType);
            BType compatibleType = this.checkMappingConstructorCompatibility(refType, mappingConstructor, data);
            return compatibleType == refType ? bType : compatibleType;
        }
        BType possibleType = this.getMappingConstructorCompatibleNonUnionType(bType, data);
        switch (possibleType.tag) {
            case 16: {
                return this.validateSpecifiedFields(mappingConstructor, possibleType, data) ? possibleType : this.symTable.semanticError;
            }
            case 12: {
                boolean isSpecifiedFieldsValid = this.validateSpecifiedFields(mappingConstructor, possibleType, data);
                boolean hasAllRequiredFields = this.validateRequiredFields((BRecordType)possibleType, mappingConstructor.fields, mappingConstructor.pos, data);
                return isSpecifiedFieldsValid && hasAllRequiredFields ? possibleType : this.symTable.semanticError;
            }
            case 38: {
                return this.checkReadOnlyMappingType(mappingConstructor, data);
            }
        }
        this.reportIncompatibleMappingConstructorError(mappingConstructor, bType, data);
        this.validateSpecifiedFields(mappingConstructor, this.symTable.semanticError, data);
        return this.symTable.semanticError;
    }

    private BType checkReadOnlyMappingType(BLangRecordLiteral mappingConstructor, AnalyzerData data) {
        if (!data.commonAnalyzerData.nonErrorLoggingCheck) {
            BType inferredType = this.defineInferredRecordType(mappingConstructor, this.symTable.readonlyType, data);
            if (inferredType == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            return this.checkMappingConstructorCompatibility(inferredType, mappingConstructor, data);
        }
        for (RecordLiteralNode.RecordField field : mappingConstructor.fields) {
            BLangExpression exprToCheck = field.isKeyValueField() ? ((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr : (field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP ? ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr : (BLangRecordLiteral.BLangRecordVarNameField)field);
            if (!this.exprIncompatible(this.symTable.readonlyType, exprToCheck, data)) continue;
            return this.symTable.semanticError;
        }
        return this.symTable.readonlyType;
    }

    private BType getMappingConstructorCompatibleNonUnionType(BType type, AnalyzerData data) {
        switch (type.tag) {
            case 12: 
            case 16: 
            case 38: {
                return type;
            }
            case 7: {
                return !Symbols.isFlagOn(type.getFlags(), 32L) ? this.symTable.mapJsonType : ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.mapJsonType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 11: {
                return !Symbols.isFlagOn(type.getFlags(), 32L) ? this.symTable.mapAnydataType : ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.mapAnydataType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 18: {
                return !Symbols.isFlagOn(type.getFlags(), 32L) ? this.symTable.mapAllType : ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.mapAllType, data.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 22: {
                return ((BIntersectionType)type).effectiveType;
            }
            case 14: {
                BType refType = Types.getImpliedType(type);
                BType compatibleType = this.getMappingConstructorCompatibleNonUnionType(refType, data);
                return compatibleType == refType ? type : compatibleType;
            }
        }
        return this.symTable.semanticError;
    }

    private void reportIncompatibleMappingConstructorError(BLangRecordLiteral mappingConstructorExpr, BType expType, AnalyzerData data) {
        if (expType == this.symTable.semanticError) {
            return;
        }
        BType referredExpType = Types.getImpliedType(expType);
        if (referredExpType.tag != 21) {
            this.dlog.error(mappingConstructorExpr.pos, DiagnosticErrorCode.MAPPING_CONSTRUCTOR_COMPATIBLE_TYPE_NOT_FOUND, expType);
            return;
        }
        BUnionType unionType = (BUnionType)referredExpType;
        BType[] memberTypes = this.types.getAllTypes(unionType, true).toArray(new BType[0]);
        if (memberTypes.length == 2) {
            BRecordType recType = null;
            BType firstMemberType = Types.getImpliedType(memberTypes[0]);
            BType secondMemberType = Types.getImpliedType(memberTypes[1]);
            if (firstMemberType.tag == 12 && secondMemberType.tag == 10) {
                recType = (BRecordType)firstMemberType;
            } else if (secondMemberType.tag == 12 && firstMemberType.tag == 10) {
                recType = (BRecordType)secondMemberType;
            }
            if (recType != null) {
                this.validateSpecifiedFields(mappingConstructorExpr, recType, data);
                this.validateRequiredFields(recType, mappingConstructorExpr.fields, mappingConstructorExpr.pos, data);
                return;
            }
        }
        for (BType bType : memberTypes) {
            if (!this.types.isMappingConstructorCompatibleType(bType)) continue;
            this.dlog.error(mappingConstructorExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_MAPPING_CONSTRUCTOR, unionType);
            return;
        }
        this.dlog.error(mappingConstructorExpr.pos, DiagnosticErrorCode.MAPPING_CONSTRUCTOR_COMPATIBLE_TYPE_NOT_FOUND, unionType);
    }

    private boolean validateSpecifiedFields(BLangRecordLiteral mappingConstructor, BType possibleType, AnalyzerData data) {
        boolean isFieldsValid = true;
        for (RecordLiteralNode.RecordField field : mappingConstructor.fields) {
            BType checkedType = this.checkMappingField(field, Types.getImpliedType(possibleType), data);
            if (!isFieldsValid || checkedType != this.symTable.semanticError) continue;
            isFieldsValid = false;
        }
        return isFieldsValid;
    }

    private void determineDefaultValues(Map<String, BType> typesOfDefaultValues, BRecordType mutableType, AnalyzerData data) {
        if (mutableType.tsymbol == null || mutableType.tsymbol.pkgID == data.env.enclPkg.packageID) {
            this.findDefaultValuesFromEnclosingPackage(data.env.enclPkg.typeDefinitions, mutableType, data, typesOfDefaultValues);
        } else {
            this.findDefaultValuesFromTypeSymbol(mutableType, typesOfDefaultValues, data);
        }
    }

    private boolean validateRequiredFields(BRecordType type, List<RecordLiteralNode.RecordField> specifiedFields, Location pos, AnalyzerData data) {
        boolean hasReadOnlyIntersection;
        HashMap<String, BType> typesOfDefaultValues = new HashMap<String, BType>();
        BRecordType mutableType = type.mutableType;
        boolean bl = hasReadOnlyIntersection = mutableType != null;
        if (hasReadOnlyIntersection) {
            this.determineDefaultValues(typesOfDefaultValues, mutableType, data);
        }
        HashSet<String> specifiedFieldNames = this.getFieldNames(specifiedFields, data);
        boolean hasMissingRequiredFields = false;
        for (BField field : type.fields.values()) {
            String fieldName = field.name.value;
            boolean isFieldRequired = Symbols.isFlagOn(field.symbol.flags, 256L);
            if (hasReadOnlyIntersection && !isFieldRequired && typesOfDefaultValues.containsKey(fieldName) && !this.types.isAssignable((BType)typesOfDefaultValues.get(fieldName), this.symTable.cloneableType)) {
                isFieldRequired = true;
            }
            if (!isFieldRequired || specifiedFieldNames.contains(fieldName) || this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(field.type)) continue;
            this.dlog.error(pos, DiagnosticErrorCode.MISSING_REQUIRED_RECORD_FIELD, field.name);
            hasMissingRequiredFields = true;
        }
        return !hasMissingRequiredFields;
    }

    private void findDefaultValuesFromEnclosingPackage(List<BLangTypeDefinition> typeDefinitions, BRecordType mutableType, AnalyzerData data, Map<String, BType> typesOfDefaultValues) {
        for (BLangTypeDefinition typeDefinition : typeDefinitions) {
            BType type = typeDefinition.getBType();
            if (type != null && type.tag != 12 || type != mutableType) continue;
            BLangRecordTypeNode recordTypeNode = (BLangRecordTypeNode)typeDefinition.typeNode;
            for (BLangSimpleVariable simpleVariable : recordTypeNode.fields) {
                if (!simpleVariable.symbol.isDefaultable) continue;
                typesOfDefaultValues.put(simpleVariable.name.value, simpleVariable.expr.getBType());
            }
            List typeInclusions = mutableType.typeInclusions;
            for (BType typeInclusion : typeInclusions) {
                this.determineDefaultValues(typesOfDefaultValues, (BRecordType)Types.getImpliedType(typeInclusion), data);
            }
        }
    }

    private void findDefaultValuesFromTypeSymbol(BRecordType mutableType, Map<String, BType> typesOfDefaultValues, AnalyzerData data) {
        Map<String, BInvokableSymbol> defaultValues = ((BRecordTypeSymbol)mutableType.tsymbol).defaultValues;
        for (String name : defaultValues.keySet()) {
            typesOfDefaultValues.put(name, defaultValues.get((Object)name).retType);
        }
        List typeInclusions = mutableType.typeInclusions;
        for (BType typeInclusion : typeInclusions) {
            this.determineDefaultValues(typesOfDefaultValues, (BRecordType)Types.getImpliedType(typeInclusion), data);
        }
    }

    private HashSet<String> getFieldNames(List<RecordLiteralNode.RecordField> specifiedFields, AnalyzerData data) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (RecordLiteralNode.RecordField specifiedField : specifiedFields) {
            if (specifiedField.isKeyValueField()) {
                String name = this.getKeyValueFieldName((BLangRecordLiteral.BLangRecordKeyValueField)specifiedField);
                if (name == null) continue;
                fieldNames.add(name);
                continue;
            }
            if (specifiedField.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                fieldNames.add(this.getVarNameFieldName((BLangRecordLiteral.BLangRecordVarNameField)specifiedField));
                continue;
            }
            fieldNames.addAll(this.getSpreadOpFieldRequiredFieldNames((BLangRecordLiteral.BLangRecordSpreadOperatorField)specifiedField, data));
        }
        return fieldNames;
    }

    String getKeyValueFieldName(BLangRecordLiteral.BLangRecordKeyValueField field) {
        BLangRecordLiteral.BLangRecordKey key = field.key;
        if (key.computedKey) {
            return null;
        }
        BLangExpression keyExpr = key.expr;
        if (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            return ((BLangSimpleVarRef)keyExpr).variableName.value;
        }
        if (keyExpr.getKind() == NodeKind.LITERAL) {
            return (String)((BLangLiteral)keyExpr).value;
        }
        return null;
    }

    private String getVarNameFieldName(BLangRecordLiteral.BLangRecordVarNameField field) {
        return field.variableName.value;
    }

    private List<String> getSpreadOpFieldRequiredFieldNames(BLangRecordLiteral.BLangRecordSpreadOperatorField field, AnalyzerData data) {
        BType spreadType = Types.getImpliedType(this.checkExpr(field.expr, data));
        if (spreadType.tag != 12) {
            return Collections.emptyList();
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (BField bField : ((BRecordType)spreadType).getFields().values()) {
            if (Symbols.isOptional(bField.symbol)) continue;
            fieldNames.add(bField.name.value);
        }
        return fieldNames;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr, AnalyzerData data) {
        if (workerFlushExpr.workerIdentifier != null) {
            String workerName = workerFlushExpr.workerIdentifier.getValue();
            if (!this.workerExists(data.env, workerName)) {
                this.dlog.error(workerFlushExpr.pos, DiagnosticErrorCode.UNDEFINED_WORKER, workerName);
            } else {
                BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(data.env, Names.fromString(workerName));
                if (symbol != this.symTable.notFoundSymbol) {
                    workerFlushExpr.workerSymbol = symbol;
                }
            }
        }
        BUnionType actualType = BUnionType.create(this.typeEnv, null, this.symTable.errorType, this.symTable.nilType);
        data.resultType = this.types.checkType(workerFlushExpr, actualType, data.expType);
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr, AnalyzerData data) {
        String workerName;
        BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(data.env, this.names.fromIdNode(syncSendExpr.workerIdentifier));
        if (this.symTable.notFoundSymbol.equals(symbol)) {
            syncSendExpr.workerType = this.symTable.semanticError;
        } else {
            syncSendExpr.workerType = symbol.type;
            syncSendExpr.workerSymbol = symbol;
        }
        syncSendExpr.env = data.env;
        this.checkExpr(syncSendExpr.expr, data);
        if (!this.types.isAssignable(syncSendExpr.expr.getBType(), this.symTable.cloneableType)) {
            this.dlog.error(syncSendExpr.pos, DiagnosticErrorCode.INVALID_TYPE_FOR_SEND, syncSendExpr.expr.getBType());
        }
        if (!this.workerExists(data.env, workerName = syncSendExpr.workerIdentifier.getValue())) {
            this.dlog.error(syncSendExpr.pos, DiagnosticErrorCode.UNDEFINED_WORKER, workerName);
        }
        syncSendExpr.expectedType = data.expType;
        data.resultType = data.expType == this.symTable.noType ? this.symTable.nilType : data.expType;
    }

    @Override
    public void visit(BLangWorkerAsyncSendExpr asyncSendExpr, AnalyzerData data) {
        String workerName;
        BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(data.env, this.names.fromIdNode(asyncSendExpr.workerIdentifier));
        if (this.symTable.notFoundSymbol.tag == symbol.tag) {
            asyncSendExpr.workerType = this.symTable.semanticError;
        } else {
            asyncSendExpr.workerType = symbol.type;
            asyncSendExpr.workerSymbol = symbol;
        }
        asyncSendExpr.env = data.env;
        this.checkExpr(asyncSendExpr.expr, data);
        if (!this.types.isAssignable(asyncSendExpr.expr.getBType(), this.symTable.cloneableType)) {
            this.dlog.error(asyncSendExpr.pos, DiagnosticErrorCode.INVALID_TYPE_FOR_SEND, asyncSendExpr.expr.getBType());
        }
        if (!this.workerExists(data.env, workerName = asyncSendExpr.workerIdentifier.getValue())) {
            this.dlog.error(asyncSendExpr.pos, DiagnosticErrorCode.UNDEFINED_WORKER, workerName);
        }
        asyncSendExpr.expectedType = data.expType;
        data.resultType = this.symTable.nilType;
    }

    @Override
    public void visit(BLangAlternateWorkerReceive altWorkerReceive, AnalyzerData data) {
        for (BLangWorkerReceive bLangWorkerReceive : altWorkerReceive.getWorkerReceives()) {
            bLangWorkerReceive.accept(this, data);
        }
        altWorkerReceive.setBType(data.expType);
        data.resultType = data.expType;
    }

    @Override
    public void visit(BLangMultipleWorkerReceive multipleWorkerReceive, AnalyzerData data) {
        BType receiveFieldExpType;
        BType compatibleType = this.validateAndGetMultipleReceiveCompatibleType(data.expType, multipleWorkerReceive, data);
        if (this.symTable.semanticError.tag == compatibleType.tag) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        multipleWorkerReceive.setBType(compatibleType);
        if (12 == compatibleType.tag) {
            BRecordType recordType = (BRecordType)compatibleType;
            for (BLangMultipleWorkerReceive.BLangReceiveField receiveFiled : multipleWorkerReceive.getReceiveFields()) {
                BField bField = (BField)recordType.fields.get(receiveFiled.getKey().value);
                BType receiveFieldExpType2 = bField != null ? bField.type : recordType.restFieldType;
                this.checkExpr((BLangExpression)receiveFiled.getWorkerReceive(), receiveFieldExpType2, data);
            }
            data.resultType = compatibleType;
            return;
        }
        if (16 == compatibleType.tag) {
            receiveFieldExpType = ((BMapType)compatibleType).constraint;
        } else {
            assert (38 == compatibleType.tag);
            receiveFieldExpType = compatibleType;
        }
        for (BLangMultipleWorkerReceive.BLangReceiveField receiveFiled : multipleWorkerReceive.getReceiveFields()) {
            this.checkExpr((BLangExpression)receiveFiled.getWorkerReceive(), receiveFieldExpType, data);
        }
        data.resultType = compatibleType;
    }

    private BType validateAndGetMultipleReceiveCompatibleType(BType bType, BLangMultipleWorkerReceive multipleWorkerReceive, AnalyzerData data) {
        HashSet<String> multipleReceiveFieldNames = new HashSet<String>();
        for (BLangMultipleWorkerReceive.BLangReceiveField receiveField : multipleWorkerReceive.getReceiveFields()) {
            BLangIdentifier key = receiveField.getKey();
            String fieldName = key.value;
            if (multipleReceiveFieldNames.add(fieldName)) continue;
            this.dlog.error(key.pos, DiagnosticErrorCode.DUPLICATE_KEY_IN_MULTIPLE_RECEIVE, fieldName);
        }
        BType impliedType = Types.getImpliedType(bType);
        if (impliedType.tag == 24) {
            this.dlog.error(multipleWorkerReceive.pos, DiagnosticErrorCode.RECEIVE_ACTION_NOT_SUPPORTED_WITH_VAR, new Object[0]);
            return this.symTable.semanticError;
        }
        if (impliedType.tag != 21) {
            BType compatibleType = this.getMappingConstructorCompatibleNonUnionType(impliedType, data);
            if (this.symTable.semanticError.tag == compatibleType.tag || 12 == compatibleType.tag && !this.fieldsCompatibleWithRecord(multipleReceiveFieldNames, (BRecordType)compatibleType)) {
                this.dlog.error(multipleWorkerReceive.pos, DiagnosticErrorCode.MULTIPLE_RECEIVE_COMPATIBLE_TYPE_NOT_FOUND, impliedType);
                return this.symTable.semanticError;
            }
            return compatibleType;
        }
        ArrayList<BType> compatibleTypes = new ArrayList<BType>();
        for (BType memberType : ((BUnionType)impliedType).getMemberTypes()) {
            BType impType = Types.getImpliedType(memberType);
            BType compatibleType = this.getMappingConstructorCompatibleNonUnionType(impType, data);
            if (12 == compatibleType.tag && !this.fieldsCompatibleWithRecord(multipleReceiveFieldNames, (BRecordType)compatibleType) || this.symTable.semanticError.tag == compatibleType.tag) continue;
            compatibleTypes.add(compatibleType);
        }
        if (compatibleTypes.isEmpty()) {
            this.dlog.error(multipleWorkerReceive.pos, DiagnosticErrorCode.MULTIPLE_RECEIVE_COMPATIBLE_TYPE_NOT_FOUND, impliedType);
            return this.symTable.semanticError;
        }
        if (compatibleTypes.size() > 1) {
            this.dlog.error(multipleWorkerReceive.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, impliedType);
            return this.symTable.semanticError;
        }
        return (BType)compatibleTypes.get(0);
    }

    private boolean fieldsCompatibleWithRecord(HashSet<String> fieldNames, BRecordType recordType) {
        HashSet<String> clonedFieldNames = new HashSet<String>(fieldNames);
        for (BField field : recordType.fields.values()) {
            if (this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(field.type) || clonedFieldNames.remove(field.name.value) || !Symbols.isFlagOn(field.symbol.flags, 256L)) continue;
            return false;
        }
        if (!clonedFieldNames.isEmpty()) {
            return recordType.restFieldType != null && recordType.restFieldType.tag != 24;
        }
        return true;
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveExpr, AnalyzerData data) {
        BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(data.env, this.names.fromIdNode(workerReceiveExpr.workerIdentifier));
        workerReceiveExpr.env = data.env;
        if (this.symTable.notFoundSymbol.equals(symbol)) {
            workerReceiveExpr.workerType = this.symTable.semanticError;
        } else {
            workerReceiveExpr.workerType = symbol.type;
            workerReceiveExpr.workerSymbol = symbol;
        }
        if (this.symTable.noType == data.expType) {
            this.dlog.error(workerReceiveExpr.pos, DiagnosticErrorCode.RECEIVE_ACTION_NOT_SUPPORTED_WITH_VAR, new Object[0]);
        }
        workerReceiveExpr.setBType(data.expType);
        data.resultType = data.expType;
    }

    private boolean workerExists(SymbolEnv env, String workerName) {
        if (workerName.equals("function")) {
            return true;
        }
        BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(env, new Name(workerName));
        BType bType = Types.getImpliedType(symbol.type);
        return symbol != this.symTable.notFoundSymbol && bType.tag == 32 && ((BFutureType)bType).workerDerivative;
    }

    @Override
    public void visit(BLangConstRef constRef, AnalyzerData data) {
        constRef.symbol = this.symResolver.lookupMainSpaceSymbolInPackage(constRef.pos, data.env, this.names.fromIdNode(constRef.pkgAlias), this.names.fromIdNode(constRef.variableName));
        this.types.setImplicitCastExpr(constRef, constRef.getBType(), data.expType);
        data.resultType = constRef.getBType();
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr, AnalyzerData data) {
        BSymbol pkgSymbol;
        BType actualType = this.symTable.semanticError;
        BLangIdentifier identifier = varRefExpr.variableName;
        Name varName = this.names.fromIdNode(identifier);
        if (varName == Names.IGNORE) {
            varRefExpr.setBType(this.symTable.anyType);
            varRefExpr.symbol = new BVarSymbol(0L, true, varName, this.names.originalNameFromIdNode(identifier), data.env.enclPkg.symbol.pkgID, varRefExpr.getBType(), data.env.scope.owner, varRefExpr.pos, SymbolOrigin.VIRTUAL);
            data.resultType = varRefExpr.getBType();
            return;
        }
        Name compUnitName = this.getCurrentCompUnit(varRefExpr);
        varRefExpr.pkgSymbol = pkgSymbol = this.symResolver.resolvePrefixSymbol(data.env, this.names.fromIdNode(varRefExpr.pkgAlias), compUnitName);
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            varRefExpr.symbol = this.symTable.notFoundSymbol;
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.UNDEFINED_MODULE, varRefExpr.pkgAlias);
        }
        if (pkgSymbol.tag == 8193L) {
            actualType = this.symTable.stringType;
        } else if (pkgSymbol != this.symTable.notFoundSymbol) {
            BSymbol symbol = this.symResolver.lookupMainSpaceSymbolInPackage(varRefExpr.pos, data.env, this.names.fromIdNode(varRefExpr.pkgAlias), varName);
            BLangType enclType = data.env.enclType;
            if (symbol == this.symTable.notFoundSymbol && enclType != null && enclType.getBType().tsymbol.scope != null) {
                Name objFuncName = Names.fromString(Symbols.getAttachedFuncSymbolName(enclType.getBType().tsymbol.name.value, varName.value));
                symbol = this.symResolver.resolveStructField(varRefExpr.pos, data.env, objFuncName, enclType.getBType().tsymbol);
            }
            if ((symbol.tag & 0x34L) == 52L) {
                BVarSymbol varSym = (BVarSymbol)symbol;
                this.checkSelfReferences(varRefExpr.pos, data.env, varSym);
                varRefExpr.symbol = varSym;
                actualType = varSym.type;
                this.markAndRegisterClosureVariable(symbol, varRefExpr.pos, data.env, data);
            } else if ((symbol.tag & 0x801CL) == 32796L) {
                if (symbol.kind == SymbolKind.TYPE_DEF) {
                    BTypeDefinitionSymbol typeDefSym = (BTypeDefinitionSymbol)symbol;
                    actualType = Types.getImpliedType((BType)symbol.type).tag == 13 ? typeDefSym.referenceType : new BTypedescType(this.typeEnv, typeDefSym.referenceType, null);
                } else {
                    actualType = symbol.type.tag == 13 ? symbol.type : new BTypedescType(this.typeEnv, symbol.type, null);
                }
                varRefExpr.symbol = symbol;
            } else if ((symbol.tag & 0x100001CL) == 0x100001CL) {
                BConstantSymbol constSymbol = (BConstantSymbol)symbol;
                varRefExpr.symbol = constSymbol;
                BType symbolType = symbol.type;
                BType expectedType = Types.getImpliedType(data.expType);
                if (symbolType != this.symTable.noType && expectedType.tag == 33 || expectedType.tag == 21 && this.types.getAllTypes(expectedType, true).stream().anyMatch(memType -> Types.getImpliedType((BType)memType).tag == 33 && this.types.isAssignable(symbolType, (BType)memType))) {
                    actualType = symbolType;
                } else {
                    actualType = constSymbol.literalType;
                    if (actualType.tag == 1 && this.types.isContainSubtypeOfInt(expectedType)) {
                        if (expectedType.tag != 21) {
                            actualType = this.types.isAssignable(symbolType, expectedType) ? expectedType : actualType;
                        } else {
                            Optional<BType> posibleType = this.types.getAllTypes(expectedType, true).stream().filter(targetMemType -> this.types.isAssignable(symbolType, (BType)targetMemType)).findFirst();
                            BType bType = actualType = posibleType.isPresent() ? posibleType.get() : actualType;
                        }
                    }
                }
                if (varRefExpr.isLValue || varRefExpr.isCompoundAssignmentLValue) {
                    actualType = this.symTable.semanticError;
                    this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_CONSTANT_VALUE, new Object[0]);
                }
            } else {
                varRefExpr.symbol = symbol;
                this.logUndefinedSymbolError(varRefExpr.pos, varName.value);
            }
        }
        BType expType = Types.getImpliedType(data.expType);
        if (expType.tag == 20 && this.isArrayOpenSealedType((BArrayType)expType)) {
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.CANNOT_INFER_SIZE_ARRAY_SIZE_FROM_THE_CONTEXT, new Object[0]);
            data.resultType = this.symTable.semanticError;
            return;
        }
        data.resultType = this.types.checkType(varRefExpr, actualType, data.expType);
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr, AnalyzerData data) {
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        String recordName = this.anonymousModelHelper.getNextAnonymousTypeKey(data.env.enclPkg.symbol.pkgID);
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(2048L, Names.fromString(recordName), data.env.enclPkg.symbol.pkgID, null, data.env.scope.owner, varRefExpr.pos, SymbolOrigin.SOURCE);
        this.symbolEnter.defineSymbol(varRefExpr.pos, recordSymbol, data.env);
        boolean unresolvedReference = false;
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue recordRefField : varRefExpr.recordRefFields) {
            BLangVariableReference bLangVarReference = (BLangVariableReference)recordRefField.variableReference;
            bLangVarReference.isLValue = true;
            this.checkExpr(recordRefField.variableReference, data);
            if (bLangVarReference.symbol == null || bLangVarReference.symbol == this.symTable.notFoundSymbol || !this.isValidVariableReference(recordRefField.variableReference)) {
                unresolvedReference = true;
                continue;
            }
            BVarSymbol bVarSymbol = (BVarSymbol)bLangVarReference.symbol;
            BField field = new BField(this.names.fromIdNode(recordRefField.variableName), varRefExpr.pos, new BVarSymbol(0L, this.names.fromIdNode(recordRefField.variableName), this.names.originalNameFromIdNode(recordRefField.variableName), data.env.enclPkg.symbol.pkgID, bVarSymbol.type, (BSymbol)recordSymbol, varRefExpr.pos, SymbolOrigin.SOURCE));
            fields.put(field.name.value, field);
        }
        BLangExpression restParam = varRefExpr.restParam;
        if (restParam != null) {
            this.checkExpr(restParam, data);
            boolean bl = unresolvedReference = !this.isValidVariableReference(restParam);
        }
        if (unresolvedReference) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        BRecordType bRecordType = new BRecordType(this.typeEnv, (BTypeSymbol)recordSymbol);
        bRecordType.fields = fields;
        recordSymbol.type = bRecordType;
        varRefExpr.symbol = new BVarSymbol(0L, recordSymbol.name, recordSymbol.getOriginalName(), data.env.enclPkg.symbol.pkgID, (BType)bRecordType, data.env.scope.owner, varRefExpr.pos, SymbolOrigin.SOURCE);
        if (restParam == null) {
            bRecordType.restFieldType = this.symTable.anyOrErrorType;
        } else if (restParam.getBType() == this.symTable.semanticError) {
            bRecordType.restFieldType = this.symTable.mapType;
        } else {
            BType restParamType = Types.getImpliedType(restParam.getBType());
            BType restFieldType = restParamType.tag == 12 ? ((BRecordType)restParamType).restFieldType : (restParamType.tag == 16 ? ((BMapType)restParamType).constraint : restParam.getBType());
            bRecordType.restFieldType = restFieldType;
        }
        data.resultType = bRecordType;
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr, AnalyzerData data) {
        BType errorRefRestFieldType;
        if (varRefExpr.typeNode != null) {
            BType bType = this.symResolver.resolveTypeNode(varRefExpr.typeNode, data.env);
            varRefExpr.setBType(bType);
            this.checkIndirectErrorVarRef(varRefExpr, data);
            data.resultType = bType;
            return;
        }
        if (varRefExpr.message != null) {
            varRefExpr.message.isLValue = true;
            this.checkExpr((BLangExpression)varRefExpr.message, data);
            if (!this.types.isAssignable(this.symTable.stringType, varRefExpr.message.getBType())) {
                this.dlog.error(varRefExpr.message.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.stringType, varRefExpr.message.getBType());
            }
        }
        if (varRefExpr.cause != null) {
            varRefExpr.cause.isLValue = true;
            this.checkExpr((BLangExpression)varRefExpr.cause, data);
            if (!this.types.isAssignable(this.symTable.errorOrNilType, varRefExpr.cause.getBType())) {
                this.dlog.error(varRefExpr.cause.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.errorOrNilType, varRefExpr.cause.getBType());
            }
        }
        boolean unresolvedReference = false;
        for (BLangNamedArgsExpression detailItem : varRefExpr.detail) {
            BLangVariableReference refItem = (BLangVariableReference)detailItem.expr;
            refItem.isLValue = true;
            this.checkExpr((BLangExpression)refItem, data);
            if (this.types.isFunctionVarRef(refItem)) {
                this.dlog.error(refItem.pos, DiagnosticErrorCode.INVALID_ASSIGNMENT_DECLARATION_FINAL, Names.FUNCTION);
                unresolvedReference = true;
            }
            if (!this.isValidVariableReference(refItem)) {
                unresolvedReference = true;
                continue;
            }
            if (refItem.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR || refItem.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
                this.dlog.error(refItem.pos, DiagnosticErrorCode.INVALID_VARIABLE_REFERENCE_IN_BINDING_PATTERN, refItem);
                unresolvedReference = true;
                continue;
            }
            if (refItem.symbol != null) continue;
            unresolvedReference = true;
        }
        if (varRefExpr.restVar != null) {
            varRefExpr.restVar.isLValue = true;
            if (varRefExpr.restVar.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                this.checkExpr((BLangExpression)varRefExpr.restVar, data);
                boolean bl = unresolvedReference = unresolvedReference || varRefExpr.restVar.symbol == null || !this.isValidVariableReference(varRefExpr.restVar);
            }
        }
        if (unresolvedReference) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        if (varRefExpr.restVar == null) {
            errorRefRestFieldType = this.symTable.anydataOrReadonly;
        } else if (varRefExpr.restVar.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangSimpleVarRef)varRefExpr.restVar).variableName.value.equals(Names.IGNORE.value)) {
            errorRefRestFieldType = this.symTable.anydataOrReadonly;
        } else if (varRefExpr.restVar.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR || varRefExpr.restVar.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR) {
            errorRefRestFieldType = varRefExpr.restVar.getBType();
        } else if (Types.getImpliedType((BType)varRefExpr.restVar.getBType()).tag == 16) {
            errorRefRestFieldType = ((BMapType)Types.getImpliedType((BType)varRefExpr.restVar.getBType())).constraint;
        } else {
            this.dlog.error(varRefExpr.restVar.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, varRefExpr.restVar.getBType(), this.symTable.detailType);
            data.resultType = this.symTable.semanticError;
            return;
        }
        BType errorDetailType = errorRefRestFieldType == this.symTable.anydataOrReadonly ? this.symTable.errorType.detailType : new BMapType(this.typeEnv, 16, errorRefRestFieldType, null, 1L);
        data.resultType = new BErrorType(this.typeEnv, this.symTable.errorType.tsymbol, errorDetailType);
    }

    private void checkIndirectErrorVarRef(BLangErrorVarRef varRefExpr, AnalyzerData data) {
        for (BLangNamedArgsExpression detailItem : varRefExpr.detail) {
            this.checkExpr(detailItem.expr, data);
            this.checkExpr((BLangExpression)detailItem, detailItem.expr.getBType(), data);
        }
        if (varRefExpr.restVar != null) {
            this.checkExpr((BLangExpression)varRefExpr.restVar, data);
        }
        if (varRefExpr.message != null) {
            varRefExpr.message.isLValue = true;
            this.checkExpr((BLangExpression)varRefExpr.message, data);
        }
        if (varRefExpr.cause != null) {
            varRefExpr.cause.isLValue = true;
            this.checkExpr((BLangExpression)varRefExpr.cause, data);
        }
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr, AnalyzerData data) {
        ArrayList<BTupleMember> results = new ArrayList<BTupleMember>();
        for (int i = 0; i < varRefExpr.expressions.size(); ++i) {
            ((BLangVariableReference)varRefExpr.expressions.get((int)i)).isLValue = true;
            BType memberType = this.checkExpr(varRefExpr.expressions.get(i), this.symTable.noType, data);
            BVarSymbol varSymbol = new BVarSymbol(memberType.getFlags(), null, null, memberType, null, null, null);
            results.add(new BTupleMember(memberType, varSymbol));
        }
        BTupleType actualType = new BTupleType(this.typeEnv, results);
        if (varRefExpr.restParam != null) {
            BLangExpression restExpr = varRefExpr.restParam;
            ((BLangVariableReference)restExpr).isLValue = true;
            BType checkedType = this.checkExpr(restExpr, this.symTable.noType, data);
            BType referredCheckedType = Types.getImpliedType(checkedType);
            if (referredCheckedType.tag != 20 && referredCheckedType.tag != 31) {
                this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_TYPE_FOR_REST_DESCRIPTOR, checkedType);
                data.resultType = this.symTable.semanticError;
                return;
            }
            actualType.restType = referredCheckedType.tag == 20 ? ((BArrayType)referredCheckedType).eType : checkedType;
        }
        data.resultType = this.types.checkType(varRefExpr, actualType, data.expType);
    }

    public boolean isArrayOpenSealedType(BArrayType arrayType) {
        if (arrayType.state == BArrayState.INFERRED) {
            return true;
        }
        BType elementType = Types.getImpliedType(arrayType.eType);
        if (elementType.tag == 20) {
            return this.isArrayOpenSealedType((BArrayType)elementType);
        }
        return false;
    }

    private SymbolEnv findEnclosingInvokableEnv(SymbolEnv env, BLangInvokableNode encInvokable) {
        if (env.enclEnv.node == null) {
            return env;
        }
        NodeKind kind = env.enclEnv.node.getKind();
        if (kind == NodeKind.ARROW_EXPR || kind == NodeKind.ON_FAIL) {
            return env.enclEnv;
        }
        if (kind == NodeKind.CLASS_DEFN) {
            return env.enclEnv.enclEnv;
        }
        if (env.enclInvokable != null && env.enclInvokable == encInvokable) {
            return this.findEnclosingInvokableEnv(env.enclEnv, encInvokable);
        }
        return env;
    }

    private SymbolEnv findEnclosingInvokableEnv(SymbolEnv env, BLangRecordTypeNode recordTypeNode) {
        NodeKind kind;
        if (env.enclEnv.node != null && ((kind = env.enclEnv.node.getKind()) == NodeKind.ARROW_EXPR || kind == NodeKind.ON_FAIL || kind == NodeKind.CLASS_DEFN)) {
            return env.enclEnv;
        }
        if (env.enclType != null && env.enclType == recordTypeNode) {
            return this.findEnclosingInvokableEnv(env.enclEnv, recordTypeNode);
        }
        return env;
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess prefixedFieldBasedAccess, AnalyzerData data) {
        this.checkFieldBasedAccess(prefixedFieldBasedAccess, true, data);
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr, AnalyzerData data) {
        this.checkFieldBasedAccess(fieldAccessExpr, false, data);
    }

    private void checkFieldBasedAccess(BLangFieldBasedAccess fieldAccessExpr, boolean isNsPrefixed, AnalyzerData data) {
        BType actualType;
        this.markLeafNode(fieldAccessExpr);
        BLangExpression containerExpression = fieldAccessExpr.expr;
        if (containerExpression instanceof BLangValueExpression) {
            BLangValueExpression valueExpression = (BLangValueExpression)containerExpression;
            valueExpression.isLValue = fieldAccessExpr.isLValue;
            valueExpression.isCompoundAssignmentLValue = fieldAccessExpr.isCompoundAssignmentLValue;
        }
        BType varRefType = this.types.getTypeWithEffectiveIntersectionTypes(this.checkExpr(containerExpression, data));
        if (isNsPrefixed && !this.isXmlAccess(fieldAccessExpr)) {
            this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.INVALID_FIELD_ACCESS_EXPRESSION, new Object[0]);
            data.resultType = this.symTable.semanticError;
            return;
        }
        if (fieldAccessExpr.optionalFieldAccess) {
            if (fieldAccessExpr.isLValue || fieldAccessExpr.isCompoundAssignmentLValue) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.OPTIONAL_FIELD_ACCESS_NOT_REQUIRED_ON_LHS, new Object[0]);
                data.resultType = this.symTable.semanticError;
                return;
            }
            actualType = this.checkOptionalFieldAccessExpr(fieldAccessExpr, varRefType, this.names.fromIdNode(fieldAccessExpr.field), data);
        } else {
            actualType = this.checkFieldAccessExpr(fieldAccessExpr, varRefType, this.names.fromIdNode(fieldAccessExpr.field), data);
            if (actualType != this.symTable.semanticError && (fieldAccessExpr.isLValue || fieldAccessExpr.isCompoundAssignmentLValue)) {
                if (this.isAllReadonlyTypes(varRefType)) {
                    BType referredType = Types.getImpliedType(varRefType);
                    if (referredType.tag != 34 || !this.isInitializationInInit(referredType, data)) {
                        this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_READONLY_VALUE_OF_TYPE, varRefType);
                        data.resultType = this.symTable.semanticError;
                        return;
                    }
                } else if (this.types.isSubTypeOfBaseType(varRefType, 12) && this.isInvalidReadonlyFieldUpdate(varRefType, fieldAccessExpr.field.value)) {
                    this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_READONLY_RECORD_FIELD, fieldAccessExpr.field.value, varRefType);
                    data.resultType = this.symTable.semanticError;
                    return;
                }
            }
        }
        data.resultType = this.types.checkType(fieldAccessExpr, actualType, data.expType);
    }

    private boolean isAllReadonlyTypes(BType type) {
        type = Types.getImpliedType(type);
        if (type.tag != 21) {
            return Symbols.isFlagOn(type.getFlags(), 32L);
        }
        for (BType memberType : ((BUnionType)type).getMemberTypes()) {
            if (this.isAllReadonlyTypes(memberType)) continue;
            return false;
        }
        return true;
    }

    private boolean isInitializationInInit(BType type, AnalyzerData data) {
        BObjectType objectType = (BObjectType)type;
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)objectType.tsymbol;
        BAttachedFunction initializerFunc = objectTypeSymbol.initializerFunc;
        return data.env.enclInvokable != null && initializerFunc != null && data.env.enclInvokable.symbol == initializerFunc.symbol;
    }

    private boolean isInvalidReadonlyFieldUpdate(BType type, String fieldName) {
        if (Types.getImpliedType((BType)type).tag == 12) {
            if (Symbols.isFlagOn(type.getFlags(), 32L)) {
                return true;
            }
            BRecordType recordType = (BRecordType)Types.getImpliedType(type);
            for (BField field : recordType.fields.values()) {
                if (!field.name.value.equals(fieldName)) continue;
                return Symbols.isFlagOn(field.symbol.flags, 32L);
            }
            return recordType.sealed;
        }
        boolean allInvalidUpdates = true;
        for (BType memberType : ((BUnionType)Types.getImpliedType(type)).getMemberTypes()) {
            if (this.isInvalidReadonlyFieldUpdate(memberType, fieldName)) continue;
            allInvalidUpdates = false;
        }
        return allInvalidUpdates;
    }

    private boolean isXmlAccess(BLangFieldBasedAccess fieldAccessExpr) {
        BLangExpression expr = fieldAccessExpr.expr;
        BType exprType = Types.getImpliedType(expr.getBType());
        if (exprType.tag == 8 || exprType.tag == 46) {
            return true;
        }
        if (expr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR && this.hasLaxOriginalType((BLangFieldBasedAccess)expr) && exprType.tag == 21) {
            SemType s = exprType.semType();
            return SemTypes.containsType((Context)this.types.semTypeCtx, (SemType)s, (SemType)PredefinedType.XML_ELEMENT);
        }
        return false;
    }

    @Override
    public void visit(BLangIndexBasedAccess indexBasedAccessExpr, AnalyzerData data) {
        boolean isStringValue;
        this.markLeafNode(indexBasedAccessExpr);
        BLangExpression containerExpression = indexBasedAccessExpr.expr;
        if (containerExpression.getKind() == NodeKind.TYPEDESC_EXPRESSION) {
            this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_MEMBER_ACCESS, ((BLangTypedescExpr)containerExpression).typeNode);
            data.resultType = this.symTable.semanticError;
            return;
        }
        if (containerExpression instanceof BLangValueExpression) {
            BLangValueExpression valueExpression = (BLangValueExpression)containerExpression;
            valueExpression.isLValue = indexBasedAccessExpr.isLValue;
            valueExpression.isCompoundAssignmentLValue = indexBasedAccessExpr.isCompoundAssignmentLValue;
        }
        boolean bl = isStringValue = containerExpression.getBType() != null && Types.getImpliedType((BType)containerExpression.getBType()).tag == 5;
        if (!isStringValue) {
            this.checkExpr(containerExpression, this.symTable.noType, data);
        }
        BType exprType = containerExpression.getBType();
        BLangExpression indexExpr = indexBasedAccessExpr.indexExpr;
        if (indexExpr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR && Types.getImpliedType((BType)exprType).tag != 9) {
            this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.MULTI_KEY_MEMBER_ACCESS_NOT_SUPPORTED, exprType);
            data.resultType = this.symTable.semanticError;
            return;
        }
        BType actualType = this.checkIndexAccessExpr(indexBasedAccessExpr, data);
        if (actualType != this.symTable.semanticError && (indexBasedAccessExpr.isLValue || indexBasedAccessExpr.isCompoundAssignmentLValue)) {
            if (this.isAllReadonlyTypes(exprType)) {
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_READONLY_VALUE_OF_TYPE, exprType);
                data.resultType = this.symTable.semanticError;
                return;
            }
            if (this.types.isSubTypeOfBaseType(exprType, 12) && this.isConstExpr(indexExpr) && this.isInvalidReadonlyFieldUpdate(exprType, this.getConstFieldName(indexExpr))) {
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_READONLY_RECORD_FIELD, this.getConstFieldName(indexExpr), exprType);
                data.resultType = this.symTable.semanticError;
                return;
            }
        }
        if (indexBasedAccessExpr.isLValue) {
            indexBasedAccessExpr.originalType = actualType;
            indexBasedAccessExpr.setBType(actualType);
            data.resultType = actualType;
            return;
        }
        data.resultType = this.types.checkType(indexBasedAccessExpr, actualType, data.expType);
    }

    @Override
    public void visit(BLangInvocation iExpr, AnalyzerData data) {
        if (iExpr.expr == null) {
            this.checkFunctionInvocationExpr(iExpr, data);
            return;
        }
        if (this.invalidModuleAliasUsage(iExpr)) {
            return;
        }
        this.checkExpr(iExpr.expr, this.symTable.noType, data);
        BType varRefType = iExpr.expr.getBType();
        this.visitInvocation(iExpr, varRefType, data);
    }

    private void visitInvocation(BLangInvocation iExpr, BType varRefType, AnalyzerData data) {
        BType referredVarRefType = Types.getImpliedType(varRefType);
        switch (referredVarRefType.tag) {
            case 34: {
                this.checkObjectFunctionInvocationExpr(iExpr, (BObjectType)referredVarRefType, data);
                break;
            }
            case 12: {
                this.checkFieldFunctionPointer(iExpr, data);
                break;
            }
            case 24: {
                this.dlog.error(iExpr.pos, DiagnosticErrorCode.UNDEFINED_FUNCTION, iExpr.name);
                break;
            }
            case 28: {
                break;
            }
            default: {
                this.checkInLangLib(iExpr, varRefType, data);
            }
        }
    }

    @Override
    public void visit(BLangErrorConstructorExpr errorConstructorExpr, AnalyzerData data) {
        BErrorType errorType;
        BType selectedCandidate;
        BLangUserDefinedType userProvidedTypeRef = errorConstructorExpr.errorTypeRef;
        if (userProvidedTypeRef != null) {
            this.symResolver.resolveTypeNode((BLangType)userProvidedTypeRef, data.env, DiagnosticErrorCode.UNDEFINED_ERROR_TYPE_DESCRIPTOR);
        }
        this.validateErrorConstructorPositionalArgs(errorConstructorExpr, data);
        List<BType> expandedCandidates = this.getTypeCandidatesForErrorConstructor(errorConstructorExpr, data);
        ArrayList<BType> errorDetailTypes = new ArrayList<BType>(expandedCandidates.size());
        for (BType expandedCandidate : expandedCandidates) {
            BType detailType = ((BErrorType)Types.getImpliedType((BType)expandedCandidate)).detailType;
            errorDetailTypes.add(Types.getImpliedType(detailType));
        }
        BType detailCandidate = errorDetailTypes.size() == 1 ? (BType)errorDetailTypes.get(0) : BUnionType.create(this.typeEnv, null, new LinkedHashSet<BType>(errorDetailTypes));
        BLangRecordLiteral recordLiteral = this.createRecordLiteralForErrorConstructor(errorConstructorExpr);
        BType inferredDetailType = this.checkExprSilent(recordLiteral, detailCandidate, data);
        int index = errorDetailTypes.indexOf(inferredDetailType);
        BType bType = selectedCandidate = index < 0 ? this.symTable.semanticError : expandedCandidates.get(index);
        if (selectedCandidate != this.symTable.semanticError && (userProvidedTypeRef == null || Types.getImpliedType(userProvidedTypeRef.getBType()) == Types.getImpliedType(selectedCandidate))) {
            this.checkProvidedErrorDetails(errorConstructorExpr, inferredDetailType, data);
            data.resultType = this.types.checkType(errorConstructorExpr.pos, selectedCandidate, data.expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
            return;
        }
        if (userProvidedTypeRef == null && errorDetailTypes.size() > 1) {
            this.dlog.error(errorConstructorExpr.pos, DiagnosticErrorCode.CANNOT_INFER_ERROR_TYPE, data.expType);
        }
        boolean validTypeRefFound = false;
        if (userProvidedTypeRef != null && Types.getImpliedType((BType)userProvidedTypeRef.getBType()).tag == 29) {
            errorType = (BErrorType)Types.getImpliedType(userProvidedTypeRef.getBType());
            validTypeRefFound = true;
        } else {
            errorType = expandedCandidates.size() == 1 ? (BErrorType)Types.getImpliedType(expandedCandidates.get(0)) : this.symTable.errorType;
        }
        List<BLangNamedArgsExpression> namedArgs = this.checkProvidedErrorDetails(errorConstructorExpr, errorType.detailType, data);
        BType detailType = errorType.detailType;
        if (Types.getImpliedType((BType)detailType).tag == 16) {
            BType errorDetailTypeConstraint = ((BMapType)Types.getImpliedType((BType)detailType)).constraint;
            for (BLangNamedArgsExpression namedArgExpr : namedArgs) {
                if (Types.getImpliedType((BType)errorDetailTypeConstraint).tag != 21 || this.types.isAssignable(namedArgExpr.expr.getBType(), errorDetailTypeConstraint)) continue;
                this.dlog.error(namedArgExpr.pos, DiagnosticErrorCode.INVALID_ERROR_DETAIL_ARG_TYPE, namedArgExpr.name, errorDetailTypeConstraint, namedArgExpr.expr.getBType());
            }
        } else if (Types.getImpliedType((BType)detailType).tag == 12) {
            BRecordType targetErrorDetailRec = (BRecordType)Types.getImpliedType(errorType.detailType);
            LinkedList missingRequiredFields = targetErrorDetailRec.fields.values().stream().filter(f -> (f.symbol.flags & 0x100L) == 256L).map(f -> f.name.value).collect(Collectors.toCollection(LinkedList::new));
            LinkedHashMap targetFields = targetErrorDetailRec.fields;
            for (BLangNamedArgsExpression namedArg : namedArgs) {
                BField field = (BField)targetFields.get(namedArg.name.value);
                Location pos = namedArg.pos;
                if (field == null) {
                    if (targetErrorDetailRec.sealed) {
                        this.dlog.error(pos, DiagnosticErrorCode.UNKNOWN_DETAIL_ARG_TO_CLOSED_ERROR_DETAIL_REC, namedArg.name, targetErrorDetailRec);
                        continue;
                    }
                    if (!targetFields.isEmpty() || this.types.isAssignable(namedArg.expr.getBType(), targetErrorDetailRec.restFieldType)) continue;
                    this.dlog.error(pos, DiagnosticErrorCode.INVALID_ERROR_DETAIL_REST_ARG_TYPE, namedArg.name, targetErrorDetailRec);
                    continue;
                }
                missingRequiredFields.remove(namedArg.name.value);
                if (Types.getImpliedType((BType)field.type).tag != 21 || this.types.isAssignable(namedArg.expr.getBType(), field.type)) continue;
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_ERROR_DETAIL_ARG_TYPE, namedArg.name, field.type, namedArg.expr.getBType());
            }
            for (String requiredField : missingRequiredFields) {
                this.dlog.error(errorConstructorExpr.pos, DiagnosticErrorCode.MISSING_ERROR_DETAIL_ARG, requiredField);
            }
        }
        if (userProvidedTypeRef != null) {
            errorConstructorExpr.setBType(Types.getImpliedType(userProvidedTypeRef.getBType()));
        } else {
            errorConstructorExpr.setBType(errorType);
        }
        BType resolvedType = errorConstructorExpr.getBType();
        if (resolvedType != this.symTable.semanticError && data.expType != this.symTable.noType && !this.types.isAssignable(resolvedType, data.expType)) {
            if (validTypeRefFound) {
                this.dlog.error(errorConstructorExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data.expType, userProvidedTypeRef);
            } else {
                this.dlog.error(errorConstructorExpr.pos, DiagnosticErrorCode.ERROR_CONSTRUCTOR_COMPATIBLE_TYPE_NOT_FOUND, data.expType);
            }
            data.resultType = this.symTable.semanticError;
            return;
        }
        data.resultType = resolvedType;
    }

    private void validateErrorConstructorPositionalArgs(BLangErrorConstructorExpr errorConstructorExpr, AnalyzerData data) {
        if (errorConstructorExpr.positionalArgs.isEmpty()) {
            return;
        }
        this.checkExpr(errorConstructorExpr.positionalArgs.get(0), this.symTable.stringType, data);
        int positionalArgCount = errorConstructorExpr.positionalArgs.size();
        if (positionalArgCount > 1) {
            this.checkExpr(errorConstructorExpr.positionalArgs.get(1), this.symTable.errorOrNilType, data);
        }
    }

    protected BType checkExprSilent(BLangExpression expr, BType expType, AnalyzerData data) {
        boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
        data.commonAnalyzerData.nonErrorLoggingCheck = true;
        this.dlog.mute();
        GlobalStateSnapshot previousGlobalState = this.getGlobalStateSnapshotAndResetGlobalState();
        BType type = this.checkExpr(expr, expType, data);
        data.commonAnalyzerData.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
        this.restoreGlobalState(previousGlobalState);
        if (!prevNonErrorLoggingCheck) {
            this.dlog.unmute();
        }
        return type;
    }

    protected BType checkExprSilent(BLangExpression expr, SymbolEnv env, BType expType, AnalyzerData data) {
        SymbolEnv prevEnv = data.env;
        data.env = env;
        BType type = this.checkExprSilent(this.nodeCloner.cloneNode(expr), expType, data);
        data.env = prevEnv;
        return type;
    }

    private BLangRecordLiteral createRecordLiteralForErrorConstructor(BLangErrorConstructorExpr errorConstructorExpr) {
        BLangRecordLiteral recordLiteral = (BLangRecordLiteral)TreeBuilder.createRecordLiteralNode();
        for (NamedArgNode namedArgNode : errorConstructorExpr.getNamedArgs()) {
            BLangRecordLiteral.BLangRecordKeyValueField field = (BLangRecordLiteral.BLangRecordKeyValueField)TreeBuilder.createRecordKeyValue();
            field.valueExpr = (BLangExpression)namedArgNode.getExpression();
            BLangLiteral expr = new BLangLiteral();
            expr.value = namedArgNode.getName().value;
            expr.setBType(this.symTable.stringType);
            field.key = new BLangRecordLiteral.BLangRecordKey(expr);
            recordLiteral.fields.add(field);
        }
        return recordLiteral;
    }

    private List<BType> getTypeCandidatesForErrorConstructor(BLangErrorConstructorExpr errorConstructorExpr, AnalyzerData data) {
        BLangUserDefinedType errorTypeRef = errorConstructorExpr.errorTypeRef;
        if (errorTypeRef == null) {
            int expReferredTypeTag = Types.getImpliedType((BType)data.expType).tag;
            if (expReferredTypeTag == 29) {
                return List.of(data.expType);
            }
            if (expReferredTypeTag == 50) {
                return List.of(this.symTable.errorType);
            }
            if (this.types.isAssignable(data.expType, this.symTable.errorType) || Types.getImpliedType((BType)data.expType).tag == 21) {
                return this.expandExpectedErrorTypes(data.expType);
            }
        } else {
            BType errorType = Types.getImpliedType(errorTypeRef.getBType());
            if (errorType.tag != 29) {
                if (errorType.tag != 28) {
                    this.dlog.error(errorTypeRef.pos, DiagnosticErrorCode.INVALID_ERROR_TYPE_REFERENCE, errorTypeRef);
                    errorConstructorExpr.errorTypeRef.setBType(this.symTable.semanticError);
                }
            } else {
                return List.of(errorTypeRef.getBType());
            }
        }
        return List.of(this.symTable.errorType);
    }

    private List<BType> expandExpectedErrorTypes(BType candidateType) {
        BType referredType = Types.getImpliedType(candidateType);
        ArrayList<BType> expandedCandidates = new ArrayList<BType>();
        if (referredType.tag == 21) {
            for (BType memberType : ((BUnionType)referredType).getMemberTypes()) {
                if (memberType.tag == 28 || !this.types.isAssignable(memberType, this.symTable.errorType)) continue;
                expandedCandidates.add(memberType);
            }
        } else if (candidateType.tag != 28 && this.types.isAssignable(candidateType, this.symTable.errorType)) {
            expandedCandidates.add(candidateType);
        }
        return expandedCandidates;
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation aInv, AnalyzerData data) {
        if (aInv.expr == null) {
            this.checkFunctionInvocationExpr(aInv, data);
            return;
        }
        if (this.invalidModuleAliasUsage(aInv)) {
            return;
        }
        this.checkExpr(aInv.expr, this.symTable.noType, data);
        BLangExpression varRef = aInv.expr;
        this.checkActionInvocation(aInv, varRef.getBType(), data);
    }

    @Override
    public void visit(BLangInvocation.BLangResourceAccessInvocation resourceAccessInvocation, AnalyzerData data) {
        this.checkExpr(resourceAccessInvocation.expr, data);
        BType lhsExprType = resourceAccessInvocation.expr.getBType();
        BType referredLhsExprType = Types.getImpliedType(lhsExprType);
        if (referredLhsExprType.tag != 34 || !Symbols.isFlagOn(referredLhsExprType.tsymbol.flags, 65536L)) {
            this.dlog.error(resourceAccessInvocation.expr.pos, DiagnosticErrorCode.CLIENT_RESOURCE_ACCESS_ACTION_IS_ONLY_ALLOWED_ON_CLIENT_OBJECTS, new Object[0]);
            data.resultType = this.symTable.semanticError;
            return;
        }
        BObjectTypeSymbol objectTypeSym = (BObjectTypeSymbol)referredLhsExprType.tsymbol;
        if (!this.validateResourceAccessPathSegmentTypes(resourceAccessInvocation.resourceAccessPathSegments, data)) {
            return;
        }
        ArrayList<BResourceFunction> resourceFunctions = new ArrayList<BResourceFunction>();
        data.isResourceAccessPathSegments = true;
        for (BAttachedFunction targetFunc : objectTypeSym.attachedFuncs) {
            if (!Symbols.isResource(targetFunc.symbol)) continue;
            BResourceFunction resourceFunction = (BResourceFunction)targetFunc;
            BLangExpression clonedResourceAccPathSeg = this.nodeCloner.cloneNode(resourceAccessInvocation.resourceAccessPathSegments);
            BType resolvedType = this.checkExprSilent(clonedResourceAccPathSeg, this.getResourcePathType(resourceFunction.pathSegmentSymbols), data);
            if (resolvedType == this.symTable.semanticError) continue;
            resourceFunctions.add(resourceFunction);
        }
        if (resourceFunctions.isEmpty()) {
            this.handleResourceAccessError(resourceAccessInvocation.resourceAccessPathSegments, resourceAccessInvocation.resourceAccessPathSegments.pos, DiagnosticErrorCode.UNDEFINED_RESOURCE, data, lhsExprType);
            return;
        }
        resourceFunctions.removeIf(func -> !func.accessor.value.equals(resourceAccessInvocation.name.value));
        int targetResourceFuncCount = resourceFunctions.size();
        if (targetResourceFuncCount == 0) {
            this.handleResourceAccessError(resourceAccessInvocation.resourceAccessPathSegments, resourceAccessInvocation.name.pos, DiagnosticErrorCode.UNDEFINED_RESOURCE_METHOD, data, resourceAccessInvocation.name, lhsExprType);
            return;
        }
        if (targetResourceFuncCount > 1) {
            Optional<BResourceFunction> first = resourceFunctions.stream().filter(func -> func.pathSegmentSymbols.stream().allMatch(segment -> segment.kind == SymbolKind.RESOURCE_PATH_IDENTIFIER_SEGMENT)).findFirst();
            if (first.isPresent()) {
                resourceFunctions = new ArrayList<BResourceFunction>(List.of(first.get()));
            } else {
                this.handleResourceAccessError(resourceAccessInvocation.resourceAccessPathSegments, resourceAccessInvocation.pos, DiagnosticErrorCode.AMBIGUOUS_RESOURCE_ACCESS_NOT_YET_SUPPORTED, data, lhsExprType);
                return;
            }
        }
        BResourceFunction targetResourceFunc = (BResourceFunction)resourceFunctions.get(0);
        this.checkExpr((BLangExpression)resourceAccessInvocation.resourceAccessPathSegments, this.getResourcePathType(targetResourceFunc.pathSegmentSymbols), data);
        resourceAccessInvocation.symbol = targetResourceFunc.symbol;
        resourceAccessInvocation.targetResourceFunc = targetResourceFunc;
        this.checkResourceAccessParamAndReturnType(resourceAccessInvocation, targetResourceFunc, data);
    }

    private void handleResourceAccessError(BLangListConstructorExpr resourceAccessPathSegments, Location diagnosticLocation, DiagnosticErrorCode errorCode, AnalyzerData data, Object ... dlogArgs) {
        this.checkExpr((BLangExpression)resourceAccessPathSegments, data);
        this.dlog.error(diagnosticLocation, errorCode, dlogArgs);
        data.resultType = this.symTable.semanticError;
    }

    private BTupleType getResourcePathType(List<BResourcePathSegmentSymbol> pathSegmentSymbols) {
        BType restType = null;
        int pathSegmentCount = pathSegmentSymbols.size();
        BResourcePathSegmentSymbol lastPathSegmentSym = pathSegmentSymbols.get(pathSegmentCount - 1);
        if (lastPathSegmentSym.kind == SymbolKind.RESOURCE_PATH_REST_PARAM_SEGMENT) {
            restType = lastPathSegmentSym.type;
            --pathSegmentCount;
        }
        BTupleType resourcePathType = new BTupleType(this.typeEnv, new ArrayList<BTupleMember>());
        if (pathSegmentCount > 0 && lastPathSegmentSym.kind != SymbolKind.RESOURCE_ROOT_PATH_SEGMENT) {
            for (BResourcePathSegmentSymbol s : pathSegmentSymbols.subList(0, pathSegmentCount)) {
                BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(s.type);
                resourcePathType.addMembers(new BTupleMember(s.type, varSymbol));
            }
        }
        resourcePathType.restType = restType;
        return resourcePathType;
    }

    public boolean validateResourceAccessPathSegmentTypes(BLangListConstructorExpr rAPathSegments, AnalyzerData data) {
        boolean isValidResourceAccessPathSegmentTypes = true;
        BLangListConstructorExpr clonedRAPathSegments = this.nodeCloner.cloneNode(rAPathSegments);
        for (BLangExpression pathSegment : clonedRAPathSegments.exprs) {
            BLangExpression clonedPathSegment = this.nodeCloner.cloneNode(pathSegment);
            if (clonedPathSegment.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                BLangExpression spreadOpExpr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)clonedPathSegment).expr;
                BType pathSegmentType = this.checkExpr(spreadOpExpr, data);
                if (this.types.isAssignable(pathSegmentType, new BArrayType(this.typeEnv, this.symTable.pathParamAllowedType))) continue;
                this.dlog.error(clonedPathSegment.getPosition(), DiagnosticErrorCode.UNSUPPORTED_RESOURCE_ACCESS_REST_SEGMENT_TYPE, pathSegmentType);
                isValidResourceAccessPathSegmentTypes = false;
                continue;
            }
            BType pathSegmentType = this.checkExpr(clonedPathSegment, data);
            if (this.types.isAssignable(pathSegmentType, this.symTable.pathParamAllowedType)) continue;
            this.dlog.error(clonedPathSegment.getPosition(), DiagnosticErrorCode.UNSUPPORTED_COMPUTED_RESOURCE_ACCESS_PATH_SEGMENT_TYPE, pathSegmentType);
            isValidResourceAccessPathSegmentTypes = false;
        }
        return isValidResourceAccessPathSegmentTypes;
    }

    public void checkResourceAccessParamAndReturnType(BLangInvocation.BLangResourceAccessInvocation resourceAccessInvoc, BResourceFunction targetResourceFunc, AnalyzerData data) {
        BInvokableSymbol targetResourceSym = targetResourceFunc.symbol;
        BInvokableType targetResourceSymType = targetResourceSym.getType();
        List<BVarSymbol> originalInvocableTSymParams = ((BInvokableTypeSymbol)targetResourceSymType.tsymbol).params;
        List<BType> originalInvocableSymParamTypes = targetResourceSymType.paramTypes;
        int pathParamCount = targetResourceFunc.pathParams.size() + (targetResourceFunc.restPathParam == null ? 0 : 1);
        int totalParamsCount = originalInvocableSymParamTypes.size();
        int functionParamCount = totalParamsCount - pathParamCount;
        ArrayList<BVarSymbol> params = new ArrayList<BVarSymbol>(functionParamCount);
        ArrayList<BType> paramTypes = new ArrayList<BType>(functionParamCount);
        params.addAll(originalInvocableTSymParams.subList(pathParamCount, totalParamsCount));
        paramTypes.addAll(originalInvocableSymParamTypes.subList(pathParamCount, totalParamsCount));
        ((BInvokableTypeSymbol)targetResourceSymType.tsymbol).params = params;
        targetResourceSym.params = params;
        targetResourceSymType.paramTypes = paramTypes;
        this.checkInvocationParamAndReturnType(resourceAccessInvoc, data);
        ((BInvokableTypeSymbol)targetResourceSymType.tsymbol).params = originalInvocableTSymParams;
        targetResourceSym.params = originalInvocableTSymParams;
        targetResourceSymType.paramTypes = originalInvocableSymParamTypes;
    }

    private void checkActionInvocation(BLangInvocation.BLangActionInvocation aInv, BType type, AnalyzerData data) {
        BType referredType = Types.getImpliedType(type);
        switch (referredType.tag) {
            case 34: {
                this.checkActionInvocation(aInv, (BObjectType)referredType, data);
                break;
            }
            case 12: {
                this.checkFieldFunctionPointer(aInv, data);
                break;
            }
            case 24: {
                this.dlog.error(aInv.pos, DiagnosticErrorCode.UNDEFINED_FUNCTION, aInv.name);
                data.resultType = this.symTable.semanticError;
                break;
            }
            default: {
                this.dlog.error(aInv.pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION, type);
                data.resultType = this.symTable.semanticError;
            }
        }
    }

    private boolean invalidModuleAliasUsage(BLangInvocation invocation) {
        Name pkgAlias = this.names.fromIdNode(invocation.pkgAlias);
        if (pkgAlias != Names.EMPTY) {
            this.dlog.error(invocation.pos, DiagnosticErrorCode.PKG_ALIAS_NOT_ALLOWED_HERE, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public void visit(BLangLetExpression letExpression, AnalyzerData data) {
        BLetSymbol letSymbol = new BLetSymbol(0x8000000L, Flags.asMask(new HashSet<Flag>(Lists.of(new Flag[0]))), new Name(String.format("$let_symbol_%d$", data.commonAnalyzerData.letCount++)), data.env.enclPkg.symbol.pkgID, letExpression.getBType(), data.env.scope.owner, letExpression.pos);
        letExpression.env = SymbolEnv.createExprEnv(letExpression, data.env, letSymbol);
        for (BLangLetVariable letVariable : letExpression.letVarDeclarations) {
            this.semanticAnalyzer.analyzeNode((BLangNode)((Object)letVariable.definitionNode), letExpression.env, data.commonAnalyzerData);
        }
        BType exprType = this.checkExpr(letExpression.expr, letExpression.env, data.expType, data);
        this.types.checkType(letExpression, exprType, data.expType);
    }

    private void checkInLangLib(BLangInvocation iExpr, BType varRefType, AnalyzerData data) {
        BSymbol langLibMethodSymbol = this.getLangLibMethod(iExpr, varRefType, data);
        if (langLibMethodSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(iExpr.name.pos, DiagnosticErrorCode.UNDEFINED_FUNCTION_IN_TYPE, iExpr.name.value, iExpr.expr.getBType());
            data.resultType = this.symTable.semanticError;
            return;
        }
        if (this.checkInvalidImmutableValueUpdate(iExpr, varRefType, langLibMethodSymbol, data)) {
            return;
        }
        this.checkIllegalStorageSizeChangeMethodCall(iExpr, varRefType, data);
    }

    private boolean checkInvalidImmutableValueUpdate(BLangInvocation iExpr, BType varRefType, BSymbol langLibMethodSymbol, AnalyzerData data) {
        if (!Symbols.isFlagOn(varRefType.getFlags(), 32L)) {
            return false;
        }
        String packageId = langLibMethodSymbol.pkgID.name.value;
        if (!MODIFIER_FUNCTIONS.containsKey(packageId)) {
            return false;
        }
        String funcName = langLibMethodSymbol.name.value;
        if (!MODIFIER_FUNCTIONS.get(packageId).contains(funcName)) {
            return false;
        }
        if (funcName.equals("mergeJson") && Types.getImpliedType((BType)varRefType).tag != 16) {
            return false;
        }
        if (funcName.equals("strip") && TypeTags.isXMLTypeTag(Types.getImpliedType((BType)varRefType).tag)) {
            return false;
        }
        this.dlog.error(iExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_READONLY_VALUE_OF_TYPE, varRefType);
        data.resultType = this.symTable.semanticError;
        return true;
    }

    private void checkIllegalStorageSizeChangeMethodCall(BLangInvocation iExpr, BType varRefType, AnalyzerData data) {
        String invocationName = iExpr.name.getValue();
        if (!LIST_LENGTH_MODIFIER_FUNCTIONS.contains(invocationName)) {
            return;
        }
        if (this.types.isFixedLengthList(varRefType)) {
            this.dlog.error(iExpr.name.pos, DiagnosticErrorCode.ILLEGAL_FUNCTION_CHANGE_LIST_SIZE, invocationName, varRefType);
            data.resultType = this.symTable.semanticError;
            return;
        }
        if (this.isShiftOnIncompatibleTuples(varRefType, invocationName)) {
            this.dlog.error(iExpr.name.pos, DiagnosticErrorCode.ILLEGAL_FUNCTION_CHANGE_TUPLE_SHAPE, invocationName, varRefType);
            data.resultType = this.symTable.semanticError;
            return;
        }
    }

    private boolean isShiftOnIncompatibleTuples(BType varRefType, String invocationName) {
        varRefType = Types.getImpliedType(varRefType);
        if (varRefType.tag == 31 && invocationName.compareTo(FUNCTION_NAME_SHIFT) == 0 && this.hasDifferentTypeThanRest((BTupleType)varRefType)) {
            return true;
        }
        if (varRefType.tag == 21 && invocationName.compareTo(FUNCTION_NAME_SHIFT) == 0) {
            BUnionType unionVarRef = (BUnionType)varRefType;
            boolean allMemberAreFixedShapeTuples = true;
            for (BType member : unionVarRef.getMemberTypes()) {
                if (member.tag != 31) {
                    allMemberAreFixedShapeTuples = false;
                    break;
                }
                if (this.hasDifferentTypeThanRest((BTupleType)member)) continue;
                allMemberAreFixedShapeTuples = false;
                break;
            }
            return allMemberAreFixedShapeTuples;
        }
        return false;
    }

    private boolean hasDifferentTypeThanRest(BTupleType tupleType) {
        if (tupleType.restType == null) {
            return false;
        }
        for (BType member : tupleType.getTupleTypes()) {
            if (this.types.isSameType(tupleType.restType, member)) continue;
            return true;
        }
        return false;
    }

    private void checkFieldFunctionPointer(BLangInvocation iExpr, AnalyzerData data) {
        BType type = this.checkExpr(iExpr.expr, data.env);
        this.checkIfLangLibMethodExists(iExpr, type, iExpr.name.pos, DiagnosticErrorCode.INVALID_FUNCTION_INVOCATION, data, type);
    }

    private void checkIfLangLibMethodExists(BLangInvocation iExpr, BType varRefType, Location pos, DiagnosticErrorCode errCode, AnalyzerData data, Object ... diagMsgArgs) {
        BSymbol langLibMethodSymbol = this.getLangLibMethod(iExpr, varRefType, data);
        if (langLibMethodSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, errCode, diagMsgArgs);
            data.resultType = this.symTable.semanticError;
        } else {
            this.checkInvalidImmutableValueUpdate(iExpr, varRefType, langLibMethodSymbol, data);
        }
    }

    @Override
    public void visit(BLangObjectConstructorExpression objectCtorExpression, AnalyzerData data) {
        BLangClassDefinition classNode = objectCtorExpression.classNode;
        classNode.oceEnvData.capturedClosureEnv = data.env;
        BLangClassDefinition originalClass = classNode.oceEnvData.originalClass;
        if (originalClass.cloneRef != null && !objectCtorExpression.defined) {
            classNode = (BLangClassDefinition)originalClass.cloneRef;
            this.symbolEnter.defineClassDefinition(classNode, data.env);
            objectCtorExpression.defined = true;
        }
        if (objectCtorExpression.referenceType == null && objectCtorExpression.expectedType != null) {
            BObjectType objectType = (BObjectType)objectCtorExpression.classNode.getBType();
            BType effectiveType = Types.getImpliedType(objectCtorExpression.expectedType);
            if (effectiveType.tag == 34) {
                BObjectType expObjType = (BObjectType)Types.getImpliedType(effectiveType);
                objectType.typeIdSet = expObjType.typeIdSet;
            } else if (effectiveType.tag != 24 && !this.checkAndLoadTypeIdSet(objectCtorExpression.expectedType, objectType)) {
                this.dlog.error(objectCtorExpression.pos, DiagnosticErrorCode.INVALID_TYPE_OBJECT_CONSTRUCTOR, objectCtorExpression.expectedType);
                data.resultType = this.symTable.semanticError;
                return;
            }
        }
        BLangTypeInit cIExpr = objectCtorExpression.typeInit;
        BType actualType = this.symResolver.resolveTypeNode(cIExpr.userDefinedType, data.env);
        if (actualType == this.symTable.semanticError) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        BObjectType actualObjectType = (BObjectType)actualType;
        List<BLangType> typeRefs = classNode.typeRefs;
        SymbolEnv typeDefEnv = SymbolEnv.createObjectConstructorObjectEnv(classNode, data.env);
        classNode.oceEnvData.typeInit = objectCtorExpression.typeInit;
        this.dlog.unmute();
        if (Symbols.isFlagOn(data.expType.getFlags(), 32L)) {
            this.handleObjectConstrExprForReadOnly(objectCtorExpression, actualObjectType, typeDefEnv, false, data);
        } else if (!typeRefs.isEmpty() && Symbols.isFlagOn(typeRefs.get(0).getBType().getFlags(), 32L)) {
            this.handleObjectConstrExprForReadOnly(objectCtorExpression, actualObjectType, typeDefEnv, true, data);
        } else {
            this.semanticAnalyzer.analyzeNode((BLangNode)classNode, typeDefEnv);
        }
        this.dlog.unmute();
        this.markConstructedObjectIsolatedness(actualObjectType);
        if (((BObjectTypeSymbol)actualType.tsymbol).initializerFunc != null) {
            BLangInvocation initInvocation = (BLangInvocation)cIExpr.initInvocation;
            initInvocation.symbol = ((BObjectTypeSymbol)actualType.tsymbol).initializerFunc.symbol;
            this.checkInvocationParam(initInvocation, data);
            cIExpr.initInvocation.setBType(((BInvokableSymbol)initInvocation.symbol).retType);
        } else if (!this.isValidInitInvocation(cIExpr, (BObjectType)actualType, data)) {
            return;
        }
        if (cIExpr.initInvocation.getBType() == null) {
            cIExpr.initInvocation.setBType(this.symTable.nilType);
        }
        BType actualTypeInitType = this.getObjectConstructorReturnType(actualType, cIExpr.initInvocation.getBType(), data);
        data.resultType = this.types.checkType(cIExpr, actualTypeInitType, data.expType);
    }

    private boolean isDefiniteObjectType(BType bType, Set<BTypeIdSet> typeIdSets) {
        BType type = Types.getImpliedType(bType);
        if (type.tag != 34 && type.tag != 21) {
            return false;
        }
        HashSet<BType> visitedTypes = new HashSet<BType>();
        if (!this.collectObjectTypeIds(bType, typeIdSets, visitedTypes)) {
            return false;
        }
        return typeIdSets.size() <= 1;
    }

    private boolean collectObjectTypeIds(BType type, Set<BTypeIdSet> typeIdSets, Set<BType> visitedTypes) {
        BType referredType = Types.getImpliedType(type);
        if (referredType.tag == 34) {
            BObjectType objectType = (BObjectType)referredType;
            typeIdSets.add(objectType.typeIdSet);
            return true;
        }
        if (referredType.tag == 21) {
            if (!visitedTypes.add(type)) {
                return true;
            }
            for (BType member : ((BUnionType)referredType).getMemberTypes()) {
                if (this.collectObjectTypeIds(member, typeIdSets, visitedTypes)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkAndLoadTypeIdSet(BType type, BObjectType objectType) {
        HashSet<BTypeIdSet> typeIdSets = new HashSet<BTypeIdSet>();
        if (!this.isDefiniteObjectType(type, typeIdSets)) {
            return false;
        }
        if (typeIdSets.isEmpty()) {
            objectType.typeIdSet = BTypeIdSet.emptySet();
            return true;
        }
        Iterator typeIdIterator = typeIdSets.iterator();
        if (typeIdIterator.hasNext()) {
            BTypeIdSet typeIdSet;
            objectType.typeIdSet = typeIdSet = (BTypeIdSet)typeIdIterator.next();
            return true;
        }
        return true;
    }

    @Override
    public void visit(BLangTypeInit cIExpr, AnalyzerData data) {
        BType referredExpType = Types.getImpliedType(data.expType);
        if (referredExpType.tag == 18 && cIExpr.userDefinedType == null || referredExpType.tag == 12) {
            this.dlog.error(cIExpr.pos, DiagnosticErrorCode.INVALID_TYPE_NEW_LITERAL, data.expType);
            data.resultType = this.symTable.semanticError;
            return;
        }
        BType actualType = cIExpr.userDefinedType != null ? this.symResolver.resolveTypeNode(cIExpr.userDefinedType, data.env) : data.expType;
        if (actualType == this.symTable.semanticError) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        data.resultType = this.checkObjectCompatibility(actualType, cIExpr, data);
    }

    private BType checkObjectCompatibility(BType actualType, BLangTypeInit cIExpr, AnalyzerData data) {
        if ((actualType = this.checkObjectType(actualType, cIExpr, data)) == this.symTable.semanticError) {
            return actualType;
        }
        if (cIExpr.initInvocation.getBType() == null) {
            cIExpr.initInvocation.setBType(this.symTable.nilType);
        }
        BType actualTypeInitType = this.getObjectConstructorReturnType(actualType, cIExpr.initInvocation.getBType(), data);
        return this.types.checkType(cIExpr, actualTypeInitType, data.expType);
    }

    private BType checkObjectType(BType actualType, BLangTypeInit cIExpr, AnalyzerData data) {
        BLangInvocation initInvocation = (BLangInvocation)cIExpr.initInvocation;
        switch (actualType.tag) {
            case 34: {
                BObjectType actualObjectType = (BObjectType)actualType;
                if ((actualType.tsymbol.flags & 0x10000000L) != 0x10000000L) {
                    this.dlog.error(cIExpr.pos, DiagnosticErrorCode.CANNOT_INITIALIZE_ABSTRACT_OBJECT, actualType.tsymbol);
                    initInvocation.argExprs.forEach(expr -> this.checkExpr((BLangExpression)expr, this.symTable.noType, data));
                    return this.symTable.semanticError;
                }
                if (actualObjectType.classDef != null && actualObjectType.classDef.flagSet.contains((Object)Flag.OBJECT_CTOR)) {
                    if (cIExpr.initInvocation != null && actualObjectType.classDef.oceEnvData.typeInit != null) {
                        actualObjectType.classDef.oceEnvData.typeInit = cIExpr;
                    }
                    this.markConstructedObjectIsolatedness(actualObjectType);
                }
                if (((BObjectTypeSymbol)actualType.tsymbol).initializerFunc != null) {
                    initInvocation.symbol = ((BObjectTypeSymbol)actualType.tsymbol).initializerFunc.symbol;
                    this.checkInvocationParam(initInvocation, data);
                    initInvocation.setBType(((BInvokableSymbol)initInvocation.symbol).retType);
                    break;
                }
                if (this.isValidInitInvocation(cIExpr, (BObjectType)actualType, data)) break;
                return this.symTable.semanticError;
            }
            case 15: {
                BType completionType;
                if (initInvocation.argExprs.size() > 1) {
                    this.dlog.error(cIExpr.pos, DiagnosticErrorCode.INVALID_STREAM_CONSTRUCTOR, initInvocation);
                    return this.symTable.semanticError;
                }
                BStreamType actualStreamType = (BStreamType)actualType;
                if (actualStreamType.completionType != null && !this.types.isAssignable(completionType = actualStreamType.completionType, this.symTable.errorOrNilType)) {
                    this.dlog.error(cIExpr.pos, DiagnosticErrorCode.ERROR_TYPE_EXPECTED, completionType.toString());
                    return this.symTable.semanticError;
                }
                BUnionType expectedNextReturnType = this.createNextReturnType(cIExpr.pos, (BStreamType)actualType, data);
                if (initInvocation.argExprs.isEmpty()) {
                    if (!this.types.containsNilType(actualStreamType.completionType)) {
                        this.dlog.error(cIExpr.pos, DiagnosticErrorCode.INVALID_UNBOUNDED_STREAM_CONSTRUCTOR_ITERATOR, expectedNextReturnType);
                        return this.symTable.semanticError;
                    }
                } else {
                    BUnionType nextReturnType;
                    BLangExpression iteratorExpr = initInvocation.argExprs.get(0);
                    BType constructType = this.checkExpr(iteratorExpr, this.symTable.noType, data);
                    BType referredConstructType = Types.getImpliedType(constructType);
                    if (referredConstructType.tag != 34) {
                        this.dlog.error(iteratorExpr.pos, DiagnosticErrorCode.INVALID_STREAM_CONSTRUCTOR_ITERATOR, expectedNextReturnType, constructType);
                        return this.symTable.semanticError;
                    }
                    BAttachedFunction closeFunc = this.types.getAttachedFuncFromObject((BObjectType)referredConstructType, "close");
                    if (closeFunc != null) {
                        BType closeableIteratorType = this.symTable.langQueryModuleSymbol.scope.lookup((Name)Names.ABSTRACT_STREAM_CLOSEABLE_ITERATOR).symbol.type;
                        if (!this.types.isAssignable(constructType, closeableIteratorType)) {
                            this.dlog.error(iteratorExpr.pos, DiagnosticErrorCode.INVALID_STREAM_CONSTRUCTOR_CLOSEABLE_ITERATOR, expectedNextReturnType, constructType);
                            return this.symTable.semanticError;
                        }
                    } else {
                        BType iteratorType = this.symTable.langQueryModuleSymbol.scope.lookup((Name)Names.ABSTRACT_STREAM_ITERATOR).symbol.type;
                        if (!this.types.isAssignable(constructType, iteratorType)) {
                            this.dlog.error(iteratorExpr.pos, DiagnosticErrorCode.INVALID_STREAM_CONSTRUCTOR_ITERATOR, expectedNextReturnType, constructType);
                            return this.symTable.semanticError;
                        }
                    }
                    if ((nextReturnType = this.types.getVarTypeFromIteratorFuncReturnType(constructType)) != null) {
                        this.types.checkType(iteratorExpr.pos, (BType)nextReturnType, (BType)expectedNextReturnType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
                    } else {
                        this.dlog.error(referredConstructType.tsymbol.getPosition(), DiagnosticErrorCode.INVALID_NEXT_METHOD_RETURN_TYPE, expectedNextReturnType);
                    }
                }
                if (data.expType.tag != 24 && !this.types.isAssignable(actualType, data.expType)) {
                    this.dlog.error(cIExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data.expType, actualType);
                    return this.symTable.semanticError;
                }
                return actualType;
            }
            case 21: {
                List<BType> matchingMembers = this.findMembersWithMatchingInitFunc(cIExpr, (BUnionType)actualType, data);
                BType matchedType = this.getMatchingType(matchingMembers, cIExpr, actualType, data);
                initInvocation.setBType(this.symTable.nilType);
                BType referredMatchedType = Types.getImpliedType(matchedType);
                if (referredMatchedType.tag == 34) {
                    if (((BObjectTypeSymbol)referredMatchedType.tsymbol).initializerFunc != null) {
                        initInvocation.symbol = ((BObjectTypeSymbol)referredMatchedType.tsymbol).initializerFunc.symbol;
                        this.checkInvocationParam(initInvocation, data);
                        initInvocation.setBType(((BInvokableSymbol)initInvocation.symbol).retType);
                        actualType = matchedType;
                        break;
                    }
                    if (!this.isValidInitInvocation(cIExpr, (BObjectType)referredMatchedType, data)) {
                        return this.symTable.semanticError;
                    }
                }
                this.types.checkType(cIExpr, matchedType, data.expType);
                cIExpr.setBType(matchedType);
                return matchedType;
            }
            case 14: {
                BType refType = Types.getImpliedType(actualType);
                BType compatibleType = this.checkObjectType(refType, cIExpr, data);
                return compatibleType == refType ? actualType : compatibleType;
            }
            case 22: {
                return this.checkObjectType(((BIntersectionType)actualType).effectiveType, cIExpr, data);
            }
            default: {
                this.dlog.error(cIExpr.pos, DiagnosticErrorCode.CANNOT_INFER_OBJECT_TYPE_FROM_LHS, actualType);
                return this.symTable.semanticError;
            }
        }
        return actualType;
    }

    private BUnionType createNextReturnType(Location pos, BStreamType streamType, AnalyzerData data) {
        BRecordType recordType = new BRecordType(this.typeEnv, null, 2048L);
        recordType.restFieldType = this.symTable.noType;
        recordType.sealed = true;
        Name fieldName = Names.VALUE;
        BField field = new BField(fieldName, pos, new BVarSymbol(1L, fieldName, data.env.enclPkg.packageID, streamType.constraint, data.env.scope.owner, pos, SymbolOrigin.VIRTUAL));
        field.type = streamType.constraint;
        recordType.fields.put(field.name.value, field);
        recordType.tsymbol = Symbols.createRecordSymbol(2048L, Names.EMPTY, data.env.enclPkg.packageID, recordType, data.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        recordType.tsymbol.scope = new Scope(data.env.scope.owner);
        recordType.tsymbol.scope.define(fieldName, field.symbol);
        LinkedHashSet<BType> retTypeMembers = new LinkedHashSet<BType>();
        retTypeMembers.add(recordType);
        retTypeMembers.addAll(this.types.getAllTypes(streamType.completionType, false));
        BUnionType unionType = BUnionType.create(this.typeEnv, null, new BType[0]);
        unionType.addAll(retTypeMembers);
        unionType.tsymbol = Symbols.createTypeSymbol(1081372L, 0L, Names.EMPTY, data.env.enclPkg.symbol.pkgID, unionType, data.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        return unionType;
    }

    private boolean isValidInitInvocation(BLangTypeInit cIExpr, BObjectType objType, AnalyzerData data) {
        BLangInvocation initInvocation = (BLangInvocation)cIExpr.initInvocation;
        if (!initInvocation.argExprs.isEmpty() && ((BObjectTypeSymbol)objType.tsymbol).initializerFunc == null) {
            this.dlog.error(cIExpr.pos, DiagnosticErrorCode.TOO_MANY_ARGS_FUNC_CALL, initInvocation.name.value);
            initInvocation.argExprs.forEach(expr -> this.checkExpr((BLangExpression)expr, this.symTable.noType, data));
            data.resultType = this.symTable.semanticError;
            return false;
        }
        return true;
    }

    private BType getObjectConstructorReturnType(BType objType, BType initRetType, AnalyzerData data) {
        initRetType = Types.getImpliedType(initRetType);
        if (initRetType.tag == 21) {
            LinkedHashSet<BType> retTypeMembers = new LinkedHashSet<BType>();
            retTypeMembers.add(objType);
            retTypeMembers.addAll(((BUnionType)initRetType).getMemberTypes());
            retTypeMembers.remove(this.symTable.nilType);
            BUnionType unionType = BUnionType.create(this.typeEnv, null, retTypeMembers);
            unionType.tsymbol = Symbols.createTypeSymbol(1081372L, 0L, Names.EMPTY, data.env.enclPkg.symbol.pkgID, unionType, data.env.scope.owner, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
            return unionType;
        }
        if (initRetType.tag == 10) {
            return objType;
        }
        return this.symTable.semanticError;
    }

    private List<BType> findMembersWithMatchingInitFunc(BLangTypeInit cIExpr, BUnionType lhsUnionType, AnalyzerData data) {
        int objectCount = 0;
        for (BType type : lhsUnionType.getMemberTypes()) {
            BType memberType = Types.getImpliedType(type);
            int tag = memberType.tag;
            if (tag != 34) continue;
            ++objectCount;
        }
        boolean containsSingleObject = objectCount == 1;
        ArrayList<BType> matchingLhsMemberTypes = new ArrayList<BType>();
        for (BType type : lhsUnionType.getMemberTypes()) {
            BType memberType = Types.getImpliedType(type);
            if (memberType.tag != 34) continue;
            if ((memberType.tsymbol.flags & 0x10000000L) != 0x10000000L) {
                this.dlog.error(cIExpr.pos, DiagnosticErrorCode.CANNOT_INITIALIZE_ABSTRACT_OBJECT, lhsUnionType.tsymbol);
            }
            if (containsSingleObject) {
                return Collections.singletonList(type);
            }
            BAttachedFunction initializerFunc = ((BObjectTypeSymbol)memberType.tsymbol).initializerFunc;
            if (!this.isArgsMatchesFunction(cIExpr.argsExpr, initializerFunc, data)) continue;
            matchingLhsMemberTypes.add(type);
        }
        return matchingLhsMemberTypes;
    }

    private BType getMatchingType(List<BType> matchingLhsMembers, BLangTypeInit cIExpr, BType lhsUnion, AnalyzerData data) {
        if (matchingLhsMembers.isEmpty()) {
            this.dlog.error(cIExpr.pos, DiagnosticErrorCode.CANNOT_INFER_OBJECT_TYPE_FROM_LHS, lhsUnion);
            data.resultType = this.symTable.semanticError;
            return this.symTable.semanticError;
        }
        if (matchingLhsMembers.size() == 1) {
            return matchingLhsMembers.get(0);
        }
        this.dlog.error(cIExpr.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, lhsUnion);
        data.resultType = this.symTable.semanticError;
        return this.symTable.semanticError;
    }

    private boolean isArgsMatchesFunction(List<BLangExpression> invocationArguments, BAttachedFunction function, AnalyzerData data) {
        invocationArguments.forEach(expr -> this.checkExpr((BLangExpression)expr, this.symTable.noType, data));
        if (function == null) {
            return invocationArguments.isEmpty();
        }
        if (function.symbol.params.isEmpty() && invocationArguments.isEmpty()) {
            return true;
        }
        ArrayList<BLangNamedArgsExpression> namedArgs = new ArrayList<BLangNamedArgsExpression>();
        ArrayList<BLangExpression> positionalArgs = new ArrayList<BLangExpression>();
        for (BLangExpression argument : invocationArguments) {
            if (argument.getKind() == NodeKind.NAMED_ARGS_EXPR) {
                namedArgs.add((BLangNamedArgsExpression)argument);
                continue;
            }
            positionalArgs.add(argument);
        }
        List requiredParams = function.symbol.params.stream().filter(param -> !param.isDefaultable).collect(Collectors.toList());
        if (requiredParams.size() > invocationArguments.size()) {
            return false;
        }
        List defaultableParams = function.symbol.params.stream().filter(param -> param.isDefaultable).collect(Collectors.toList());
        int givenRequiredParamCount = 0;
        for (int i = 0; i < positionalArgs.size(); ++i) {
            if (function.symbol.params.size() > i) {
                ++givenRequiredParamCount;
                BVarSymbol functionParam = function.symbol.params.get(i);
                if (!this.types.isAssignable(((BLangExpression)positionalArgs.get(i)).getBType(), functionParam.type)) {
                    return false;
                }
                requiredParams.remove(functionParam);
                defaultableParams.remove(functionParam);
                continue;
            }
            if (function.symbol.restParam != null) {
                BType restParamType = ((BArrayType)function.symbol.restParam.type).eType;
                if (this.types.isAssignable(((BLangExpression)positionalArgs.get(i)).getBType(), restParamType)) continue;
                return false;
            }
            return false;
        }
        for (BLangNamedArgsExpression namedArg : namedArgs) {
            boolean foundNamedArg = false;
            List<BVarSymbol> params = function.symbol.params;
            for (int i = givenRequiredParamCount; i < params.size(); ++i) {
                BVarSymbol functionParam = params.get(i);
                if (!namedArg.name.value.equals(functionParam.name.value)) continue;
                foundNamedArg = true;
                BType namedArgExprType = this.checkExpr(namedArg.expr, data);
                if (!this.types.isAssignable(functionParam.type, namedArgExprType)) {
                    return false;
                }
                requiredParams.remove(functionParam);
                defaultableParams.remove(functionParam);
            }
            if (foundNamedArg) continue;
            return false;
        }
        return requiredParams.size() <= 0;
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr, AnalyzerData data) {
        this.setResultTypeForWaitForAllExpr(waitForAllExpr, data.expType, data);
        waitForAllExpr.setBType(data.resultType);
        if (data.resultType != null && data.resultType != this.symTable.semanticError) {
            this.types.setImplicitCastExpr(waitForAllExpr, waitForAllExpr.getBType(), data.expType);
        }
    }

    private void setResultTypeForWaitForAllExpr(BLangWaitForAllExpr waitForAllExpr, BType expType, AnalyzerData data) {
        BType referredType = Types.getImpliedType(expType);
        switch (referredType.tag) {
            case 12: {
                this.checkTypesForRecords(waitForAllExpr, data);
                break;
            }
            case 16: {
                this.checkTypesForMap(waitForAllExpr, ((BMapType)referredType).constraint, data);
                LinkedHashSet<BType> memberTypesForMap = this.collectWaitExprTypes(waitForAllExpr.keyValuePairs);
                if (memberTypesForMap.size() == 1) {
                    data.resultType = new BMapType(this.typeEnv, 16, (BType)memberTypesForMap.iterator().next(), this.symTable.mapType.tsymbol);
                    break;
                }
                BUnionType constraintTypeForMap = BUnionType.create(this.typeEnv, null, memberTypesForMap);
                data.resultType = new BMapType(this.typeEnv, 16, constraintTypeForMap, this.symTable.mapType.tsymbol);
                break;
            }
            case 18: 
            case 24: {
                this.checkTypesForMap(waitForAllExpr, expType, data);
                LinkedHashSet<BType> memberTypes = this.collectWaitExprTypes(waitForAllExpr.keyValuePairs);
                if (memberTypes.size() == 1) {
                    data.resultType = new BMapType(this.typeEnv, 16, (BType)memberTypes.iterator().next(), this.symTable.mapType.tsymbol);
                    break;
                }
                BUnionType constraintType = BUnionType.create(this.typeEnv, null, memberTypes);
                data.resultType = new BMapType(this.typeEnv, 16, constraintType, this.symTable.mapType.tsymbol);
                break;
            }
            default: {
                this.dlog.error(waitForAllExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, expType, this.getWaitForAllExprReturnType(waitForAllExpr, waitForAllExpr.pos, data));
                data.resultType = this.symTable.semanticError;
            }
        }
    }

    private BRecordType getWaitForAllExprReturnType(BLangWaitForAllExpr waitExpr, Location pos, AnalyzerData data) {
        BRecordType retType = new BRecordType(this.typeEnv, null, 2048L);
        List<BLangWaitForAllExpr.BLangWaitKeyValue> keyVals = waitExpr.keyValuePairs;
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyVal : keyVals) {
            BLangIdentifier fieldName = keyVal.valueExpr == null || keyVal.valueExpr.getKind() != NodeKind.SIMPLE_VARIABLE_REF ? keyVal.key : ((BLangSimpleVarRef)keyVal.valueExpr).variableName;
            BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(data.env, this.names.fromIdNode(fieldName));
            BType referredSymType = Types.getImpliedType(symbol.type);
            BType fieldType = referredSymType.tag == 32 ? ((BFutureType)referredSymType).constraint : symbol.type;
            BField field = new BField(this.names.fromIdNode(keyVal.key), null, new BVarSymbol(0L, this.names.fromIdNode(keyVal.key), this.names.originalNameFromIdNode(keyVal.key), data.env.enclPkg.packageID, fieldType, null, keyVal.pos, SymbolOrigin.VIRTUAL));
            retType.fields.put(field.name.value, field);
        }
        retType.restFieldType = this.symTable.noType;
        retType.sealed = true;
        retType.tsymbol = Symbols.createRecordSymbol(2048L, Names.EMPTY, data.env.enclPkg.packageID, retType, null, pos, SymbolOrigin.VIRTUAL);
        return retType;
    }

    private LinkedHashSet<BType> collectWaitExprTypes(List<BLangWaitForAllExpr.BLangWaitKeyValue> keyVals) {
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyVal : keyVals) {
            BType bType = keyVal.keyExpr != null ? keyVal.keyExpr.getBType() : keyVal.valueExpr.getBType();
            BType referredBType = Types.getImpliedType(bType);
            if (referredBType.tag == 32) {
                memberTypes.add(((BFutureType)referredBType).constraint);
                continue;
            }
            memberTypes.add(bType);
        }
        return memberTypes;
    }

    private void checkTypesForMap(BLangWaitForAllExpr waitForAllExpr, BType expType, AnalyzerData data) {
        List<BLangWaitForAllExpr.BLangWaitKeyValue> keyValuePairs = waitForAllExpr.keyValuePairs;
        keyValuePairs.forEach(keyVal -> this.checkWaitKeyValExpr((BLangWaitForAllExpr.BLangWaitKeyValue)keyVal, expType, data));
    }

    private void checkTypesForRecords(BLangWaitForAllExpr waitExpr, AnalyzerData data) {
        List<BLangWaitForAllExpr.BLangWaitKeyValue> rhsFields = waitExpr.getKeyValuePairs();
        LinkedHashMap lhsFields = ((BRecordType)Types.getImpliedType((BType)data.expType)).fields;
        if (((BRecordType)Types.getImpliedType((BType)data.expType)).sealed && rhsFields.size() > lhsFields.size()) {
            this.dlog.error(waitExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data.expType, this.getWaitForAllExprReturnType(waitExpr, waitExpr.pos, data));
            data.resultType = this.symTable.semanticError;
            return;
        }
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyVal : rhsFields) {
            String key = keyVal.key.value;
            BLangExpression valueExpr = keyVal.valueExpr;
            if (valueExpr != null && this.isBinaryBitwiseOperatorExpr(valueExpr)) {
                this.dlog.error(valueExpr.pos, DiagnosticErrorCode.CANNOT_USE_ALTERNATE_WAIT_ACTION_WITHIN_MULTIPLE_WAIT_ACTION, new Object[0]);
                data.resultType = this.symTable.semanticError;
                continue;
            }
            if (!lhsFields.containsKey(key)) {
                if (((BRecordType)Types.getImpliedType((BType)data.expType)).sealed) {
                    this.dlog.error(waitExpr.pos, DiagnosticErrorCode.INVALID_FIELD_NAME_RECORD_LITERAL, key, data.expType);
                    data.resultType = this.symTable.semanticError;
                    continue;
                }
                BType restFieldType = ((BRecordType)Types.getImpliedType((BType)data.expType)).restFieldType;
                this.checkWaitKeyValExpr(keyVal, restFieldType, data);
                continue;
            }
            this.checkWaitKeyValExpr(keyVal, ((BField)lhsFields.get((Object)key)).type, data);
            keyVal.keySymbol = ((BField)lhsFields.get((Object)key)).symbol;
        }
        this.checkMissingReqFieldsForWait((BRecordType)Types.getImpliedType(data.expType), rhsFields, waitExpr.pos);
        if (this.symTable.semanticError != data.resultType) {
            data.resultType = data.expType;
        }
    }

    private boolean isBinaryBitwiseOperatorExpr(BLangExpression valueExpr) {
        if (valueExpr.getKind() == NodeKind.GROUP_EXPR) {
            return this.isBinaryBitwiseOperatorExpr(((BLangGroupExpr)valueExpr).expression);
        }
        return valueExpr.getKind() == NodeKind.BINARY_EXPR && ((BLangBinaryExpr)valueExpr).opKind == OperatorKind.BITWISE_OR;
    }

    private void checkMissingReqFieldsForWait(BRecordType type, List<BLangWaitForAllExpr.BLangWaitKeyValue> keyValPairs, Location pos) {
        type.fields.values().forEach(field -> {
            boolean hasField = keyValPairs.stream().anyMatch(keyVal -> field.name.value.equals(keyVal.key.value));
            if (!hasField && Symbols.isFlagOn(field.symbol.flags, 256L)) {
                this.dlog.error(pos, DiagnosticErrorCode.MISSING_REQUIRED_RECORD_FIELD, field.name);
            }
        });
    }

    private void checkWaitKeyValExpr(BLangWaitForAllExpr.BLangWaitKeyValue keyVal, BType type, AnalyzerData data) {
        BLangExpression expr;
        if (keyVal.keyExpr != null) {
            BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(data.env, this.names.fromIdNode(((BLangSimpleVarRef)keyVal.keyExpr).variableName));
            keyVal.keyExpr.setBType(symbol.type);
            expr = keyVal.keyExpr;
        } else {
            expr = keyVal.valueExpr;
        }
        BFutureType futureType = new BFutureType(this.typeEnv, type, null);
        this.checkExpr(expr, futureType, data);
        this.setEventualTypeForExpression(expr, type, data);
    }

    private void setEventualTypeForExpression(BLangExpression expression, BType currentExpectedType, AnalyzerData data) {
        if (expression == null) {
            return;
        }
        if (this.isSimpleWorkerReference(expression, data)) {
            return;
        }
        BType expectedType = expression.expectedType;
        if (expectedType.tag != 32) {
            this.dlog.error(expression.pos, DiagnosticErrorCode.EXPRESSION_OF_FUTURE_TYPE_EXPECTED, expectedType);
            return;
        }
        BFutureType futureType = (BFutureType)expectedType;
        BType currentType = futureType.constraint;
        if (this.types.containsErrorType(currentType)) {
            return;
        }
        BUnionType eventualType = BUnionType.create(this.typeEnv, null, currentType, this.symTable.errorType);
        BType referredExpType = Types.getImpliedType(currentExpectedType);
        if (referredExpType.tag != 24 && referredExpType.tag != 10 && !this.types.isAssignable(eventualType, currentExpectedType)) {
            this.dlog.error(expression.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_WAIT_FUTURE_EXPR, currentExpectedType, eventualType, expression);
        }
        futureType.setConstraint(eventualType);
    }

    private void setEventualTypeForWaitExpression(BLangExpression expression, Location pos, AnalyzerData data) {
        if (data.resultType == this.symTable.semanticError || this.types.containsErrorType(data.resultType)) {
            return;
        }
        if (this.isSimpleWorkerReference(expression, data)) {
            return;
        }
        BType currentExpectedType = ((BFutureType)data.expType).constraint;
        BType referredExpType = Types.getImpliedType(currentExpectedType);
        BUnionType eventualType = BUnionType.create(this.typeEnv, null, data.resultType, this.symTable.errorType);
        if (referredExpType.tag == 24 || referredExpType.tag == 10) {
            data.resultType = eventualType;
            return;
        }
        if (!this.types.isAssignable(eventualType, currentExpectedType)) {
            this.dlog.error(pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_WAIT_FUTURE_EXPR, currentExpectedType, eventualType, expression);
            data.resultType = this.symTable.semanticError;
            return;
        }
        BType referredResultType = Types.getImpliedType(data.resultType);
        if (referredResultType.tag == 32) {
            ((BFutureType)data.resultType).setConstraint(eventualType);
        } else {
            data.resultType = eventualType;
        }
    }

    private void setEventualTypeForAlternateWaitExpression(BLangExpression expression, Location pos, AnalyzerData data) {
        if (data.resultType == this.symTable.semanticError || expression.getKind() != NodeKind.BINARY_EXPR || this.types.containsErrorType(data.resultType)) {
            return;
        }
        if (this.types.containsErrorType(data.resultType)) {
            return;
        }
        if (!this.isReferencingNonWorker((BLangBinaryExpr)expression, data)) {
            return;
        }
        BType currentExpectedType = ((BFutureType)data.expType).constraint;
        BType referredExpType = Types.getImpliedType(currentExpectedType);
        BUnionType eventualType = BUnionType.create(this.typeEnv, null, data.resultType, this.symTable.errorType);
        if (referredExpType.tag == 24 || referredExpType.tag == 10) {
            data.resultType = eventualType;
            return;
        }
        if (!this.types.isAssignable(eventualType, currentExpectedType)) {
            this.dlog.error(pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_WAIT_FUTURE_EXPR, currentExpectedType, eventualType, expression);
            data.resultType = this.symTable.semanticError;
            return;
        }
        BType referredResultType = Types.getImpliedType(data.resultType);
        if (referredResultType.tag == 32) {
            ((BFutureType)referredResultType).setConstraint(eventualType);
        } else {
            data.resultType = eventualType;
        }
    }

    private boolean isSimpleWorkerReference(BLangExpression expression, AnalyzerData data) {
        if (expression.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return false;
        }
        BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)expression;
        BSymbol varRefSymbol = simpleVarRef.symbol;
        if (varRefSymbol == null) {
            return false;
        }
        return this.workerExists(data.env, simpleVarRef.variableName.value);
    }

    private boolean isReferencingNonWorker(BLangBinaryExpr binaryExpr, AnalyzerData data) {
        BLangExpression lhsExpr = binaryExpr.lhsExpr;
        BLangExpression rhsExpr = binaryExpr.rhsExpr;
        if (this.isReferencingNonWorker(lhsExpr, data)) {
            return true;
        }
        return this.isReferencingNonWorker(rhsExpr, data);
    }

    private boolean isReferencingNonWorker(BLangExpression expression, AnalyzerData data) {
        if (expression.getKind() == NodeKind.BINARY_EXPR) {
            return this.isReferencingNonWorker((BLangBinaryExpr)expression, data);
        }
        if (expression.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)expression;
            BSymbol varRefSymbol = simpleVarRef.symbol;
            String varRefSymbolName = varRefSymbol.getName().value;
            if (this.workerExists(data.env, varRefSymbolName)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr, AnalyzerData data) {
        BType condExprType = this.checkExpr(ternaryExpr.expr, this.symTable.booleanType, data);
        SymbolEnv thenEnv = this.typeNarrower.evaluateTruth(ternaryExpr.expr, ternaryExpr.thenExpr, data.env);
        BType thenActualType = this.silentTypeCheckExpr(ternaryExpr.thenExpr, this.symTable.noType, data);
        BType thenType = this.checkExpr(ternaryExpr.thenExpr, thenEnv, data.expType, data);
        SymbolEnv elseEnv = this.typeNarrower.evaluateFalsity(ternaryExpr.expr, ternaryExpr.elseExpr, data.env, false);
        BType elseActualType = this.silentTypeCheckExpr(ternaryExpr.elseExpr, this.symTable.noType, data);
        BType elseType = this.checkExpr(ternaryExpr.elseExpr, elseEnv, data.expType, data);
        data.resultType = condExprType == this.symTable.semanticError || thenType == this.symTable.semanticError || elseType == this.symTable.semanticError ? this.symTable.semanticError : (data.expType == this.symTable.noType ? this.getConditionalExprType(thenType, elseType) : data.expType);
        ternaryExpr.setDeterminedType(this.getConditionalExprType(thenActualType, elseActualType));
    }

    private BType getConditionalExprType(BType lhsType, BType rhsType) {
        if (this.types.isAssignable(rhsType, lhsType)) {
            return lhsType;
        }
        if (this.types.isAssignable(lhsType, rhsType)) {
            return rhsType;
        }
        return BUnionType.create(this.typeEnv, null, lhsType, rhsType);
    }

    @Override
    public void visit(BLangWaitExpr waitExpr, AnalyzerData data) {
        data.expType = new BFutureType(this.typeEnv, data.expType, null);
        this.checkExpr(waitExpr.getExpression(), data.expType, data);
        BType referredResultType = Types.getImpliedType(data.resultType);
        if (referredResultType.tag == 21) {
            LinkedHashSet<BType> memberTypes = this.collectMemberTypes((BUnionType)referredResultType, new LinkedHashSet<BType>());
            data.resultType = memberTypes.size() == 1 ? memberTypes.toArray(new BType[0])[0] : BUnionType.create(this.typeEnv, null, memberTypes);
        } else if (data.resultType != this.symTable.semanticError) {
            data.resultType = ((BFutureType)data.resultType).constraint;
        }
        BLangExpression waitFutureExpression = waitExpr.getExpression();
        if (waitFutureExpression.getKind() == NodeKind.BINARY_EXPR) {
            this.setEventualTypeForAlternateWaitExpression(waitFutureExpression, waitExpr.pos, data);
        } else {
            this.setEventualTypeForWaitExpression(waitFutureExpression, waitExpr.pos, data);
        }
        waitExpr.setBType(data.resultType);
        if (data.resultType != null && data.resultType != this.symTable.semanticError) {
            this.types.setImplicitCastExpr(waitExpr, waitExpr.getBType(), ((BFutureType)data.expType).constraint);
        }
    }

    private LinkedHashSet<BType> collectMemberTypes(BUnionType unionType, LinkedHashSet<BType> memberTypes) {
        for (BType memberType : unionType.getMemberTypes()) {
            BType referredMemberType = Types.getImpliedType(memberType);
            if (referredMemberType.tag == 32) {
                memberTypes.add(((BFutureType)referredMemberType).constraint);
                continue;
            }
            memberTypes.add(memberType);
        }
        return memberTypes;
    }

    @Override
    public void visit(BLangTrapExpr trapExpr, AnalyzerData data) {
        BType actualType;
        boolean definedWithVar;
        boolean firstVisit = trapExpr.expr.getBType() == null;
        BType exprType = this.checkExpr(trapExpr.expr, data.expType, data);
        boolean bl = definedWithVar = data.expType == this.symTable.noType;
        if (trapExpr.expr.getKind() == NodeKind.WORKER_RECEIVE) {
            if (firstVisit) {
                data.isTypeChecked = false;
                data.resultType = data.expType;
                return;
            }
            data.expType = trapExpr.getBType();
            exprType = trapExpr.expr.getBType();
        }
        if (data.expType == this.symTable.semanticError || exprType == this.symTable.semanticError) {
            actualType = this.symTable.semanticError;
        } else {
            LinkedHashSet<BType> resultTypes = new LinkedHashSet<BType>();
            BType referredExprType = Types.getImpliedType(exprType);
            if (referredExprType.tag == 21) {
                resultTypes.addAll(((BUnionType)referredExprType).getMemberTypes());
            } else {
                resultTypes.add(exprType);
            }
            resultTypes.add(this.symTable.errorType);
            actualType = BUnionType.create(this.typeEnv, null, resultTypes);
        }
        data.resultType = this.types.checkType(trapExpr, actualType, data.expType);
        if (definedWithVar && data.resultType != null && data.resultType != this.symTable.semanticError) {
            this.types.setImplicitCastExpr(trapExpr.expr, trapExpr.expr.getBType(), data.resultType);
        }
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr, AnalyzerData data) {
        if (Types.getImpliedType((BType)data.expType).tag == 32 && binaryExpr.opKind == OperatorKind.BITWISE_OR) {
            BType lhsResultType = this.checkExpr(binaryExpr.lhsExpr, data.expType, data);
            BType rhsResultType = this.checkExpr(binaryExpr.rhsExpr, data.expType, data);
            if (lhsResultType == this.symTable.semanticError || rhsResultType == this.symTable.semanticError) {
                data.resultType = this.symTable.semanticError;
                return;
            }
            data.resultType = BUnionType.create(this.typeEnv, null, lhsResultType, rhsResultType);
            return;
        }
        BType referredExpType = Types.getImpliedType(binaryExpr.expectedType);
        BType lhsType = referredExpType.tag == 3 || referredExpType.tag == 4 || this.isOptionalFloatOrDecimal(referredExpType) ? this.checkAndGetType(binaryExpr.lhsExpr, data.env, binaryExpr, data) : this.checkExpr(binaryExpr.lhsExpr, data);
        SymbolEnv rhsExprEnv = binaryExpr.opKind == OperatorKind.AND ? this.typeNarrower.evaluateTruth(binaryExpr.lhsExpr, binaryExpr.rhsExpr, data.env, true) : (binaryExpr.opKind == OperatorKind.OR ? this.typeNarrower.evaluateFalsity(binaryExpr.lhsExpr, binaryExpr.rhsExpr, data.env, true) : data.env);
        BType rhsType = referredExpType.tag == 3 || referredExpType.tag == 4 || this.isOptionalFloatOrDecimal(referredExpType) ? this.checkAndGetType(binaryExpr.rhsExpr, rhsExprEnv, binaryExpr, data) : this.checkExpr(binaryExpr.rhsExpr, rhsExprEnv, data);
        BType actualType = this.symTable.semanticError;
        switch (binaryExpr.opKind) {
            case ADD: {
                BType leftConstituent = this.getXMLConstituents(lhsType);
                BType rightConstituent = this.getXMLConstituents(rhsType);
                if (leftConstituent != null && rightConstituent != null) {
                    actualType = new BXMLType(BUnionType.create(this.typeEnv, null, leftConstituent, rightConstituent), null);
                    break;
                }
                if (leftConstituent != null || rightConstituent != null) {
                    if (leftConstituent != null && this.types.isAssignable(rhsType, this.symTable.stringType)) {
                        actualType = this.getXmlStringBinaryOpResultType(lhsType, leftConstituent, data.env, binaryExpr.pos);
                        break;
                    }
                    if (rightConstituent != null && this.types.isAssignable(lhsType, this.symTable.stringType)) {
                        actualType = this.getXmlStringBinaryOpResultType(rhsType, rightConstituent, data.env, binaryExpr.pos);
                        break;
                    }
                }
            }
            default: {
                if (lhsType == this.symTable.semanticError || rhsType == this.symTable.semanticError) break;
                BSymbol opSymbol = this.symResolver.resolveBinaryOperator(binaryExpr.opKind, lhsType, rhsType);
                if (opSymbol == this.symTable.notFoundSymbol) {
                    opSymbol = this.symResolver.getBitwiseShiftOpsForTypeSets(binaryExpr.opKind, lhsType, rhsType);
                }
                if (opSymbol == this.symTable.notFoundSymbol) {
                    opSymbol = this.symResolver.getBinaryBitwiseOpsForTypeSets(binaryExpr.opKind, lhsType, rhsType);
                }
                if (opSymbol == this.symTable.notFoundSymbol) {
                    opSymbol = this.symResolver.getArithmeticOpsForTypeSets(binaryExpr.opKind, lhsType, rhsType);
                }
                if (opSymbol == this.symTable.notFoundSymbol) {
                    opSymbol = this.symResolver.getBinaryEqualityForTypeSets(binaryExpr.opKind, lhsType, rhsType, binaryExpr, data.env);
                }
                if (opSymbol == this.symTable.notFoundSymbol) {
                    opSymbol = this.symResolver.getBinaryComparisonOpForTypeSets(binaryExpr.opKind, lhsType, rhsType);
                }
                if (opSymbol == this.symTable.notFoundSymbol) {
                    opSymbol = this.symResolver.getRangeOpsForTypeSets(binaryExpr.opKind, lhsType, rhsType);
                }
                if (opSymbol == this.symTable.notFoundSymbol) {
                    DiagnosticErrorCode errorCode = DiagnosticErrorCode.BINARY_OP_INCOMPATIBLE_TYPES;
                    int rhsTypeTag = Types.getImpliedType((BType)rhsType).tag;
                    if (!(binaryExpr.opKind != OperatorKind.DIV && binaryExpr.opKind != OperatorKind.MOD || Types.getImpliedType((BType)lhsType).tag != 1 || rhsTypeTag != 4 && rhsTypeTag != 3)) {
                        errorCode = DiagnosticErrorCode.BINARY_OP_INCOMPATIBLE_TYPES_INT_FLOAT_DIVISION;
                    }
                    if (binaryExpr.opKind == OperatorKind.UNDEFINED) break;
                    this.dlog.error(binaryExpr.pos, errorCode, new Object[]{binaryExpr.opKind, lhsType, rhsType});
                    break;
                }
                binaryExpr.opSymbol = (BOperatorSymbol)opSymbol;
                actualType = opSymbol.type.getReturnType();
            }
        }
        data.resultType = this.types.checkType(binaryExpr, actualType, data.expType);
    }

    private BType getXmlStringBinaryOpResultType(BType opType, BType constituentType, SymbolEnv env, Location pos) {
        if (this.types.isAssignable(this.symTable.xmlTextType, constituentType)) {
            return opType;
        }
        BTypeSymbol typeSymbol = Symbols.createTypeSymbol(1081372L, 0L, Names.EMPTY, env.enclPkg.symbol.pkgID, null, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BXMLType type = new BXMLType(BUnionType.create(this.typeEnv, typeSymbol, constituentType, this.symTable.xmlTextType), null);
        typeSymbol.type = type;
        return type;
    }

    public boolean isOptionalFloatOrDecimal(BType expectedType) {
        if (!expectedType.isNullable()) {
            return false;
        }
        SemType t = Core.diff((SemType)expectedType.semType(), (SemType)PredefinedType.NIL);
        return PredefinedType.FLOAT.equals((Object)t) || PredefinedType.DECIMAL.equals((Object)t);
    }

    private BType checkAndGetType(BLangExpression expr, SymbolEnv env, BLangBinaryExpr binaryExpr, AnalyzerData data) {
        boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
        data.commonAnalyzerData.nonErrorLoggingCheck = true;
        GlobalStateSnapshot previousGlobalState = this.getGlobalStateSnapshotAndResetGlobalState();
        this.dlog.mute();
        ++expr.cloneAttempt;
        BType exprCompatibleType = this.checkExpr(this.nodeCloner.cloneNode(expr), env, binaryExpr.expectedType, data);
        data.commonAnalyzerData.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
        int errorCount = this.dlog.errorCount();
        this.restoreGlobalState(previousGlobalState);
        if (!prevNonErrorLoggingCheck) {
            this.dlog.unmute();
        }
        if (errorCount == 0 && exprCompatibleType != this.symTable.semanticError) {
            return this.checkExpr(expr, env, binaryExpr.expectedType, data);
        }
        return this.checkExpr(expr, env, data);
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr, AnalyzerData data) {
        data.resultType = this.types.checkType(transactionalExpr, this.symTable.booleanType, data.expType);
    }

    @Override
    public void visit(BLangCommitExpr commitExpr, AnalyzerData data) {
        BUnionType actualType = BUnionType.create(this.typeEnv, null, this.symTable.errorType, this.symTable.nilType);
        data.resultType = this.types.checkType(commitExpr, actualType, data.expType);
    }

    private BType getXMLConstituents(BType bType) {
        BType type = Types.getImpliedType(bType);
        BType constituent = null;
        if (type.tag == 8) {
            constituent = ((BXMLType)type).constraint;
        } else if (TypeTags.isXMLNonSequenceType(type.tag)) {
            constituent = bType;
        }
        return constituent;
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr, AnalyzerData data) {
        BType lhsType = this.checkExpr(elvisExpr.lhsExpr, data);
        BType lhsActualType = lhsType == this.symTable.semanticError ? this.symTable.semanticError : this.validateElvisExprLhsExpr(elvisExpr, lhsType);
        BType rhsActualType = this.silentTypeCheckExpr(elvisExpr.rhsExpr, this.symTable.noType, data);
        BType rhsReturnType = this.checkExpr(elvisExpr.rhsExpr, data.expType, data);
        BType lhsReturnType = this.types.checkType(elvisExpr.lhsExpr.pos, lhsActualType, data.expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
        data.resultType = rhsReturnType == this.symTable.semanticError || lhsReturnType == this.symTable.semanticError ? this.symTable.semanticError : (data.expType == this.symTable.noType ? this.getConditionalExprType(lhsReturnType, rhsReturnType) : data.expType);
        elvisExpr.setDeterminedType(this.getConditionalExprType(lhsActualType, rhsActualType));
    }

    @Override
    public void visit(BLangGroupExpr groupExpr, AnalyzerData data) {
        data.resultType = this.checkExpr(groupExpr.expression, data.expType, data);
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr, AnalyzerData data) {
        int resolveTypeTag;
        if (accessExpr.resolvedType == null) {
            accessExpr.resolvedType = this.symResolver.resolveTypeNode(accessExpr.typeNode, data.env);
        }
        BType actualType = (resolveTypeTag = Types.getImpliedType((BType)accessExpr.resolvedType).tag) != 13 && resolveTypeTag != 24 ? new BTypedescType(this.typeEnv, accessExpr.resolvedType, null) : accessExpr.resolvedType;
        data.resultType = this.types.checkType(accessExpr, actualType, data.expType);
    }

    public LinkedHashSet<BType> getBasicNumericTypes(Set<BType> memberTypes) {
        LinkedHashSet<BType> basicNumericTypes = new LinkedHashSet<BType>(memberTypes.size());
        for (BType value : memberTypes) {
            BType referredType = Types.getImpliedType(value);
            int typeTag = referredType.tag;
            if (TypeTags.isIntegerTypeTag(typeTag)) {
                basicNumericTypes.add(this.symTable.intType);
                continue;
            }
            if (typeTag == 3 || typeTag == 4) {
                basicNumericTypes.add(value);
                continue;
            }
            if (typeTag == 7 || typeTag == 11 || typeTag == 18) {
                basicNumericTypes.add(this.symTable.intType);
                basicNumericTypes.add(this.symTable.floatType);
                basicNumericTypes.add(this.symTable.decimalType);
                break;
            }
            if (typeTag != 33) continue;
            basicNumericTypes.addAll(SemTypeHelper.broadTypes((BFiniteType)referredType, this.symTable));
        }
        return basicNumericTypes;
    }

    public BType createFiniteTypeForNumericUnaryExpr(BLangUnaryExpr unaryExpr, AnalyzerData data) {
        BLangNumericLiteral newNumericLiteral = Types.constructNumericLiteralFromUnaryExpr(unaryExpr);
        BTypeSymbol finiteTypeSymbol = Symbols.createTypeSymbol(557084L, 0L, Names.EMPTY, data.env.enclPkg.symbol.pkgID, null, data.env.scope.owner, unaryExpr.pos, SymbolOrigin.SOURCE);
        BFiniteType finiteType = BFiniteType.newSingletonBFiniteType(finiteTypeSymbol, SemTypeHelper.resolveSingletonType(newNumericLiteral));
        finiteTypeSymbol.type = finiteType;
        this.types.setImplicitCastExpr(unaryExpr, unaryExpr.expr.getBType(), data.expType);
        return finiteType;
    }

    public BType getNewExpectedTypeForFiniteAndUnion(Set<BType> numericTypes, BType newExpectedType) {
        LinkedHashSet<BType> basicNumericTypes = this.getBasicNumericTypes(numericTypes);
        if (basicNumericTypes.size() == 1) {
            newExpectedType = (BType)basicNumericTypes.iterator().next();
        } else if (basicNumericTypes.size() > 1) {
            newExpectedType = BUnionType.create(this.typeEnv, null, basicNumericTypes);
        }
        return newExpectedType;
    }

    public BType setExpectedTypeForSubtractionOperator(AnalyzerData data) {
        BType newExpectedType = data.expType;
        BType referredType = Types.getImpliedType(newExpectedType);
        int referredTypeTag = referredType.tag;
        if (TypeTags.isIntegerTypeTag(referredTypeTag)) {
            newExpectedType = this.types.getTypeIntersection(Types.IntersectionContext.compilerInternalIntersectionTestContext(), BUnionType.create(this.typeEnv, null, this.symTable.intType, this.symTable.floatType, this.symTable.decimalType), this.symTable.intType, data.env);
        } else if (referredTypeTag == 3 || referredTypeTag == 4) {
            newExpectedType = this.types.getTypeIntersection(Types.IntersectionContext.compilerInternalIntersectionTestContext(), BUnionType.create(this.typeEnv, null, this.symTable.intType, this.symTable.floatType, this.symTable.decimalType), referredType, data.env);
        } else if (referredTypeTag == 33) {
            Set<BType> typesInValueSpace = SemTypeHelper.broadTypes((BFiniteType)referredType, this.symTable);
            newExpectedType = this.getNewExpectedTypeForFiniteAndUnion(typesInValueSpace, newExpectedType);
        } else if (referredTypeTag == 21) {
            newExpectedType = this.getNewExpectedTypeForFiniteAndUnion(((BUnionType)referredType).getMemberTypes(), newExpectedType);
        } else if (referredTypeTag == 7 || referredTypeTag == 11 || referredTypeTag == 18) {
            newExpectedType = BUnionType.create(this.typeEnv, null, this.symTable.intType, this.symTable.floatType, this.symTable.decimalType);
        }
        return newExpectedType;
    }

    public BType getActualTypeForOtherUnaryExpr(BLangUnaryExpr unaryExpr, AnalyzerData data) {
        BType tempActualType;
        BType exprType;
        boolean isAddOrSubOperator;
        BType actualType = this.symTable.semanticError;
        BType newExpectedType = data.expType;
        BType referredType = Types.getImpliedType(newExpectedType);
        int referredTypeTag = referredType.tag;
        boolean bl = isAddOrSubOperator = OperatorKind.SUB.equals((Object)unaryExpr.operator) || OperatorKind.ADD.equals((Object)unaryExpr.operator);
        if (OperatorKind.SUB.equals((Object)unaryExpr.operator)) {
            newExpectedType = this.setExpectedTypeForSubtractionOperator(data);
        }
        if ((newExpectedType = this.silentTypeCheckExpr(unaryExpr.expr, newExpectedType, data)) != this.symTable.semanticError) {
            exprType = isAddOrSubOperator ? this.checkExpr(unaryExpr.expr, newExpectedType, data) : this.checkExpr(unaryExpr.expr, data);
        } else {
            BType bType = exprType = isAddOrSubOperator ? this.checkExpr(unaryExpr.expr, data.expType, data) : this.checkExpr(unaryExpr.expr, data);
        }
        if (exprType != this.symTable.semanticError) {
            BSymbol symbol = this.symResolver.resolveUnaryOperator(unaryExpr.operator, exprType);
            if (symbol == this.symTable.notFoundSymbol) {
                symbol = this.symResolver.getUnaryOpsForTypeSets(unaryExpr.operator, exprType);
            }
            if (symbol == this.symTable.notFoundSymbol) {
                this.dlog.error(unaryExpr.pos, DiagnosticErrorCode.UNARY_OP_INCOMPATIBLE_TYPES, new Object[]{unaryExpr.operator, exprType});
            } else {
                unaryExpr.opSymbol = (BOperatorSymbol)symbol;
                actualType = symbol.type.getReturnType();
            }
        }
        if (isAddOrSubOperator && exprType != this.symTable.semanticError && this.types.isExpressionInUnaryValid(unaryExpr.expr) && (referredTypeTag == 33 || referredTypeTag == 21)) {
            if (referredTypeTag == 33) {
                actualType = this.createFiniteTypeForNumericUnaryExpr(unaryExpr, data);
            } else {
                BUnionType newReferredType;
                BType tempActualType2;
                if (this.silentCompatibleFiniteMembersInUnionTypeCheck(unaryExpr, (BUnionType)referredType, data)) {
                    return this.createFiniteTypeForNumericUnaryExpr(unaryExpr, data);
                }
                LinkedHashSet<BType> intTypesInUnion = this.getIntSubtypesInUnionType((BUnionType)referredType);
                if (!intTypesInUnion.isEmpty() && (tempActualType2 = this.checkCompatibilityWithConstructedNumericLiteral(unaryExpr, newReferredType = BUnionType.create(this.typeEnv, null, intTypesInUnion), data)) != this.symTable.semanticError) {
                    return tempActualType2;
                }
            }
        } else if (isAddOrSubOperator && exprType != this.symTable.semanticError && TypeTags.isIntegerTypeTag(referredTypeTag) && referredTypeTag != 1 && unaryExpr.expr.getKind() == NodeKind.NUMERIC_LITERAL && (tempActualType = this.checkCompatibilityWithConstructedNumericLiteral(unaryExpr, referredType, data)) != this.symTable.semanticError) {
            return tempActualType;
        }
        return actualType;
    }

    public BType checkCompatibilityWithConstructedNumericLiteral(BLangUnaryExpr unaryExpr, BType referredType, AnalyzerData data) {
        if (!this.types.isExpressionInUnaryValid(unaryExpr.expr)) {
            return this.silentTypeCheckExpr(unaryExpr.expr, referredType, data);
        }
        BLangNumericLiteral numericLiteral = Types.constructNumericLiteralFromUnaryExpr(unaryExpr);
        return this.silentTypeCheckExpr(numericLiteral, referredType, data);
    }

    public LinkedHashSet<BType> getIntSubtypesInUnionType(BUnionType expectedType) {
        LinkedHashSet<BType> intTypesInUnion = new LinkedHashSet<BType>(((HashSet)expectedType.getMemberTypes()).size());
        for (BType type : expectedType.getMemberTypes()) {
            BType referredType = Types.getImpliedType(type);
            if (referredType.tag == 1 || !TypeTags.isIntegerTypeTag(referredType.tag)) continue;
            intTypesInUnion.add(type);
        }
        return intTypesInUnion;
    }

    public boolean silentCompatibleFiniteMembersInUnionTypeCheck(BLangUnaryExpr unaryExpr, BUnionType expectedType, AnalyzerData data) {
        boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
        data.commonAnalyzerData.nonErrorLoggingCheck = true;
        GlobalStateSnapshot previousGlobalState = this.getGlobalStateSnapshotAndResetGlobalState();
        this.dlog.mute();
        for (BType type : expectedType.getMemberTypes()) {
            BType compatibleTypeOfUnaryExpression = this.checkExpr((BLangExpression)this.nodeCloner.cloneNode(unaryExpr), Types.getImpliedType(type), data);
            if (Types.getImpliedType((BType)compatibleTypeOfUnaryExpression).tag != 33) continue;
            this.unmuteDlog(data, prevNonErrorLoggingCheck, previousGlobalState);
            return true;
        }
        this.unmuteDlog(data, prevNonErrorLoggingCheck, previousGlobalState);
        return false;
    }

    private void unmuteDlog(AnalyzerData data, boolean prevNonErrorLoggingCheck, GlobalStateSnapshot previousGlobalState) {
        data.commonAnalyzerData.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
        this.restoreGlobalState(previousGlobalState);
        if (!prevNonErrorLoggingCheck) {
            this.dlog.unmute();
        }
    }

    public BType silentTypeCheckExpr(BLangExpression expr, BType referredType, AnalyzerData data) {
        boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
        data.commonAnalyzerData.nonErrorLoggingCheck = true;
        GlobalStateSnapshot previousGlobalState = this.getGlobalStateSnapshotAndResetGlobalState();
        this.dlog.mute();
        BType exprCompatibleType = this.checkExpr(this.nodeCloner.cloneNode(expr), referredType, data);
        this.unmuteDlog(data, prevNonErrorLoggingCheck, previousGlobalState);
        return exprCompatibleType;
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr, AnalyzerData data) {
        BType actualType = this.symTable.semanticError;
        if (OperatorKind.UNTAINT.equals((Object)unaryExpr.operator)) {
            BType exprType = this.checkExpr(unaryExpr.expr, data);
            if (exprType != this.symTable.semanticError) {
                actualType = exprType;
            }
        } else if (OperatorKind.TYPEOF.equals((Object)unaryExpr.operator)) {
            BType exprType = this.checkExpr(unaryExpr.expr, data);
            if (exprType != this.symTable.semanticError) {
                actualType = new BTypedescType(this.typeEnv, exprType, null);
            }
        } else {
            actualType = this.getActualTypeForOtherUnaryExpr(unaryExpr, data);
        }
        data.resultType = this.types.checkType(unaryExpr, actualType, data.expType);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr, AnalyzerData data) {
        BType targetType;
        BType actualType = this.symTable.semanticError;
        for (BLangAnnotationAttachment annAttachment : conversionExpr.annAttachments) {
            annAttachment.attachPoints.add(AttachPoint.Point.TYPE);
            this.semanticAnalyzer.analyzeNode((BLangNode)annAttachment, data.env);
        }
        BLangExpression expr = conversionExpr.expr;
        if (conversionExpr.typeNode == null) {
            if (!conversionExpr.annAttachments.isEmpty()) {
                data.resultType = this.checkExpr(expr, data.expType, data);
            }
            return;
        }
        if (conversionExpr.typeNode.getKind() == NodeKind.FINITE_TYPE_NODE) {
            this.semanticAnalyzer.analyzeNode((BLangNode)conversionExpr.typeNode, data.env);
        }
        conversionExpr.targetType = targetType = this.getEffectiveReadOnlyType(conversionExpr.typeNode.pos, this.symResolver.resolveTypeNode(conversionExpr.typeNode, data.env), data);
        boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
        data.commonAnalyzerData.nonErrorLoggingCheck = true;
        GlobalStateSnapshot previousGlobalState = this.getGlobalStateSnapshotAndResetGlobalState();
        this.dlog.mute();
        BType exprCompatibleType = this.checkExpr(this.nodeCloner.cloneNode(expr), targetType, data);
        data.commonAnalyzerData.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
        int errorCount = this.dlog.errorCount();
        this.restoreGlobalState(previousGlobalState);
        if (!prevNonErrorLoggingCheck) {
            this.dlog.unmute();
        }
        if (errorCount == 0 && exprCompatibleType != this.symTable.semanticError || this.requireTypeInference(expr, false) && this.isNotObjectConstructorWithObjectSuperTypeInTypeCastExpr(expr, targetType)) {
            this.checkExpr(expr, targetType, data);
        } else {
            this.checkExpr(expr, this.symTable.noType, data);
        }
        BType exprType = expr.getBType();
        if (this.types.isTypeCastable(exprType, targetType)) {
            actualType = targetType;
        } else if (exprType != this.symTable.semanticError && exprType != this.symTable.noType) {
            this.dlog.error(conversionExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES_CAST, exprType, targetType);
        }
        data.resultType = this.types.checkType(conversionExpr, actualType, data.expType);
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction, AnalyzerData data) {
        SymbolEnv currentEnv = data.env;
        if (data.commonAnalyzerData.nonErrorLoggingCheck) {
            BLangFunction funcNode = bLangLambdaFunction.function;
            BInvokableSymbol funcSymbol = Symbols.createFunctionSymbol(Flags.asMask(funcNode.flagSet), this.names.fromIdNode(funcNode.name), Names.EMPTY, currentEnv.enclPkg.symbol.pkgID, null, currentEnv.scope.owner, funcNode.hasBody(), funcNode.pos, SymbolOrigin.VIRTUAL);
            funcSymbol.scope = new Scope(funcSymbol);
            SymbolEnv invokableEnv = SymbolEnv.createFunctionEnv(funcNode, funcSymbol.scope, currentEnv);
            invokableEnv.scope = funcSymbol.scope;
            this.symbolEnter.defineInvokableSymbolParams(bLangLambdaFunction.function, funcSymbol, invokableEnv);
            funcNode.setBType(funcSymbol.type);
        } else if (bLangLambdaFunction.function.symbol == null) {
            this.symbolEnter.defineNode(bLangLambdaFunction.function, currentEnv);
        }
        bLangLambdaFunction.setBType(bLangLambdaFunction.function.getBType());
        bLangLambdaFunction.capturedClosureEnv = data.env.createClone();
        if (!data.commonAnalyzerData.nonErrorLoggingCheck) {
            if (bLangLambdaFunction.function.flagSet.contains((Object)Flag.WORKER)) {
                currentEnv.enclPkg.lambdaFunctions.add(bLangLambdaFunction);
            } else {
                this.semanticAnalyzer.analyzeNode((BLangNode)bLangLambdaFunction.function, bLangLambdaFunction.capturedClosureEnv);
            }
        }
        data.resultType = this.types.checkType(bLangLambdaFunction, bLangLambdaFunction.getBType(), data.expType);
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction, AnalyzerData data) {
        BUnionType unionType;
        BType invokableType;
        BType expectedType = Types.getImpliedType(data.expType);
        if (expectedType.tag == 21 && (invokableType = (unionType = (BUnionType)expectedType).getMemberTypes().stream().filter(type -> Types.getImpliedType((BType)type).tag == 17).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() != 1) {
                return null;
            }
            return (BType)list.get(0);
        }))) != null) {
            expectedType = invokableType;
        }
        if (expectedType.tag != 17 || Symbols.isFlagOn(expectedType.getFlags(), 0x8000000000L)) {
            this.dlog.error(bLangArrowFunction.pos, DiagnosticErrorCode.ARROW_EXPRESSION_CANNOT_INFER_TYPE_FROM_LHS, new Object[0]);
            data.resultType = this.symTable.semanticError;
            return;
        }
        BInvokableType expectedInvocation = (BInvokableType)expectedType;
        this.populateArrowExprParamTypes(bLangArrowFunction, expectedInvocation.paramTypes, data);
        bLangArrowFunction.body.expr.setBType(this.populateArrowExprReturn(bLangArrowFunction, expectedInvocation.retType, data));
        if (expectedInvocation.retType.tag == 24) {
            expectedInvocation.retType = bLangArrowFunction.body.expr.getBType();
        }
        for (BLangSimpleVariable simpleVariable : bLangArrowFunction.params) {
            if (simpleVariable.symbol == null) continue;
            this.symResolver.checkForUniqueSymbol(simpleVariable.pos, data.env, simpleVariable.symbol);
        }
        data.resultType = bLangArrowFunction.funcType = expectedInvocation;
    }

    @Override
    public void visit(BLangXMLQName bLangXMLQName, AnalyzerData data) {
        String prefix = bLangXMLQName.prefix.value;
        data.resultType = this.types.checkType(bLangXMLQName, this.symTable.stringType, data.expType);
        if (data.env.node.getKind() == NodeKind.XML_ATTRIBUTE && prefix.isEmpty() && bLangXMLQName.localname.value.equals("xmlns")) {
            ((BLangXMLAttribute)data.env.node).isNamespaceDeclr = true;
            return;
        }
        if (data.env.node.getKind() == NodeKind.XML_ATTRIBUTE && prefix.equals("xmlns")) {
            ((BLangXMLAttribute)data.env.node).isNamespaceDeclr = true;
            return;
        }
        if (prefix.equals("xmlns")) {
            this.dlog.error(bLangXMLQName.pos, DiagnosticErrorCode.INVALID_NAMESPACE_PREFIX, prefix);
            bLangXMLQName.setBType(this.symTable.semanticError);
            return;
        }
        if (bLangXMLQName.prefix.value.isEmpty()) {
            return;
        }
        BSymbol xmlnsSymbol = this.symResolver.lookupSymbolInPrefixSpace(data.env, this.names.fromIdNode(bLangXMLQName.prefix));
        if (prefix.isEmpty() && xmlnsSymbol == this.symTable.notFoundSymbol) {
            return;
        }
        if (!prefix.isEmpty() && xmlnsSymbol == this.symTable.notFoundSymbol) {
            this.logUndefinedSymbolError(bLangXMLQName.pos, prefix);
            bLangXMLQName.setBType(this.symTable.semanticError);
            return;
        }
        if (xmlnsSymbol.getKind() == SymbolKind.PACKAGE) {
            xmlnsSymbol = this.findXMLNamespaceFromPackageConst(bLangXMLQName.localname.value, bLangXMLQName.prefix.value, (BPackageSymbol)xmlnsSymbol, bLangXMLQName.pos, data);
        }
        if (xmlnsSymbol == null || xmlnsSymbol.getKind() != SymbolKind.XMLNS) {
            data.resultType = this.symTable.semanticError;
            return;
        }
        bLangXMLQName.nsSymbol = (BXMLNSSymbol)xmlnsSymbol;
        bLangXMLQName.namespaceURI = bLangXMLQName.nsSymbol.namespaceURI;
    }

    private BConstantSymbol getSymbolOfXmlQualifiedName(String localname, String prefix, BPackageSymbol pkgSymbol, Location pos, AnalyzerData data) {
        BSymbol constSymbol = this.symResolver.lookupPossibleMemberSymbol(pkgSymbol.scope, Names.fromString(localname), 0x100001CL);
        if (constSymbol == this.symTable.notFoundSymbol) {
            if (!this.missingNodesHelper.isMissingNode(prefix) && !this.missingNodesHelper.isMissingNode(localname)) {
                this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_CONSTANT_SYMBOL, prefix + ":" + localname);
            }
            return null;
        }
        if (!data.env.enclPkg.packageID.equals(pkgSymbol.pkgID) && !Symbols.isPublic(constSymbol)) {
            this.dlog.error(pos, DiagnosticErrorCode.ATTEMPT_REFER_NON_ACCESSIBLE_SYMBOL, constSymbol.name);
            return null;
        }
        BConstantSymbol constantSymbol = (BConstantSymbol)constSymbol;
        if (constantSymbol.literalType.tag != 5) {
            this.dlog.error(pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.stringType, constantSymbol.literalType);
            return null;
        }
        pkgSymbol.isUsed = true;
        return constantSymbol;
    }

    private BSymbol findXMLNamespaceFromPackageConst(String localname, String prefix, BPackageSymbol pkgSymbol, Location pos, AnalyzerData data) {
        BConstantSymbol constantSymbol = this.getSymbolOfXmlQualifiedName(localname, prefix, pkgSymbol, pos, data);
        if (constantSymbol == null) {
            return null;
        }
        String constVal = (String)constantSymbol.value.value;
        int s = constVal.indexOf(123);
        int e = constVal.lastIndexOf(125);
        if (e > s + 1) {
            pkgSymbol.isUsed = true;
            String nsURI = constVal.substring(s + 1, e);
            String local = constVal.substring(e);
            return new BXMLNSSymbol(Names.fromString(local), nsURI, constantSymbol.pkgID, constantSymbol.owner, pos, SymbolOrigin.SOURCE);
        }
        this.dlog.error(pos, DiagnosticErrorCode.INVALID_ATTRIBUTE_REFERENCE, prefix + ":" + localname);
        return null;
    }

    @Override
    public void visit(BLangXMLAttribute bLangXMLAttribute, AnalyzerData data) {
        SymbolEnv xmlAttributeEnv = SymbolEnv.getXMLAttributeEnv(bLangXMLAttribute, data.env);
        BLangXMLQName name = (BLangXMLQName)bLangXMLAttribute.name;
        this.checkExpr((BLangExpression)name, xmlAttributeEnv, this.symTable.stringType, data);
        if (name.prefix.value.isEmpty()) {
            name.namespaceURI = null;
        }
        this.checkExpr((BLangExpression)bLangXMLAttribute.value, xmlAttributeEnv, this.symTable.stringType, data);
        this.symbolEnter.defineNode(bLangXMLAttribute, data.env);
    }

    @Override
    public void visit(BLangXMLElementLiteral bLangXMLElementLiteral, AnalyzerData data) {
        SymbolEnv xmlElementEnv = SymbolEnv.getXMLElementEnv(bLangXMLElementLiteral, data.env);
        HashSet<String> usedPrefixes = new HashSet<String>();
        BLangIdentifier elemNamePrefix = ((BLangXMLQName)bLangXMLElementLiteral.startTagName).prefix;
        if (elemNamePrefix != null && !elemNamePrefix.value.isEmpty()) {
            usedPrefixes.add(elemNamePrefix.value);
        }
        for (BLangXMLAttribute attribute2 : bLangXMLElementLiteral.attributes) {
            BLangIdentifier prefix;
            if (attribute2.name.getKind() == NodeKind.XML_QNAME && this.isXmlNamespaceAttribute(attribute2)) {
                BLangXMLQuotedString value = attribute2.value;
                if (value.getKind() == NodeKind.XML_QUOTED_STRING && value.textFragments.size() > 1) {
                    this.dlog.error(value.pos, DiagnosticErrorCode.INVALID_XML_NS_INTERPOLATION, new Object[0]);
                }
                this.checkExpr((BLangExpression)attribute2, xmlElementEnv, this.symTable.noType, data);
            }
            if ((prefix = ((BLangXMLQName)attribute2.name).prefix) == null || prefix.value.isEmpty()) continue;
            usedPrefixes.add(prefix.value);
        }
        bLangXMLElementLiteral.attributes.forEach(attribute -> {
            if (attribute.name.getKind() != NodeKind.XML_QNAME || !this.isXmlNamespaceAttribute((BLangXMLAttribute)attribute)) {
                this.checkExpr((BLangExpression)attribute, xmlElementEnv, this.symTable.noType, data);
            }
        });
        Map<Name, BXMLNSSymbol> namespaces = this.symResolver.resolveAllNamespaces(xmlElementEnv);
        Name defaultNs = Names.fromString("");
        if (namespaces.containsKey(defaultNs)) {
            bLangXMLElementLiteral.defaultNsSymbol = namespaces.remove(defaultNs);
        }
        for (Map.Entry<Name, BXMLNSSymbol> nsEntry : namespaces.entrySet()) {
            if (!usedPrefixes.contains(nsEntry.getKey().value)) continue;
            bLangXMLElementLiteral.namespacesInScope.put(nsEntry.getKey(), nsEntry.getValue());
        }
        this.validateTags(bLangXMLElementLiteral, xmlElementEnv, data);
        bLangXMLElementLiteral.modifiedChildren = this.concatSimilarKindXMLNodes(bLangXMLElementLiteral.children, xmlElementEnv, data);
        if (data.expType == this.symTable.noType) {
            data.resultType = this.types.checkType(bLangXMLElementLiteral, this.symTable.xmlElementType, data.expType);
            return;
        }
        data.resultType = this.checkXmlSubTypeLiteralCompatibility(bLangXMLElementLiteral.pos, this.symTable.xmlElementType, data.expType, data);
        if (Symbols.isFlagOn(data.resultType.getFlags(), 32L)) {
            this.markChildrenAsImmutable(bLangXMLElementLiteral, data);
        }
    }

    private boolean isXmlNamespaceAttribute(BLangXMLAttribute attribute) {
        BLangXMLQName attrName = (BLangXMLQName)attribute.name;
        return attrName.prefix.value.isEmpty() && attrName.localname.value.equals("xmlns") || attrName.prefix.value.equals("xmlns");
    }

    public BType getXMLSequenceType(BType xmlSubType) {
        return switch (Types.getImpliedType((BType)xmlSubType).tag) {
            case 46 -> new BXMLType(this.symTable.xmlElementType, null);
            case 48 -> new BXMLType(this.symTable.xmlCommentType, null);
            case 47 -> new BXMLType(this.symTable.xmlPIType, null);
            default -> this.symTable.xmlTextType;
        };
    }

    @Override
    public void visit(BLangXMLSequenceLiteral bLangXMLSequenceLiteral, AnalyzerData data) {
        BType expType = Types.getImpliedType(data.expType);
        if (expType.tag != 8 && expType.tag != 21 && expType.tag != 49 && expType.tag != 18 && expType.tag != 11 && expType != this.symTable.noType) {
            this.dlog.error(bLangXMLSequenceLiteral.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data.expType, "XML Sequence");
            data.resultType = this.symTable.semanticError;
            return;
        }
        ArrayList<BType> xmlTypesInSequence = new ArrayList<BType>();
        for (BLangExpression expressionItem : bLangXMLSequenceLiteral.xmlItems) {
            data.resultType = this.checkExpr(expressionItem, data.expType, data);
            if (xmlTypesInSequence.contains(data.resultType)) continue;
            xmlTypesInSequence.add(data.resultType);
        }
        if (expType.tag == 8 || expType == this.symTable.noType) {
            if (xmlTypesInSequence.size() == 1) {
                data.resultType = this.getXMLSequenceType((BType)xmlTypesInSequence.get(0));
                return;
            }
            data.resultType = this.symTable.xmlType;
            return;
        }
        if (expType.tag == 49) {
            data.resultType = this.symTable.xmlTextType;
            return;
        }
        if (expType.tag == 18) {
            data.resultType = this.symTable.anyType;
            return;
        }
        if (expType.tag == 11) {
            data.resultType = this.symTable.anydataType;
            return;
        }
        for (BType item : ((BUnionType)expType).getMemberTypes()) {
            if (!this.types.isAssignable(this.symTable.xmlType, item = Types.getImpliedType(item))) continue;
            data.resultType = this.symTable.xmlType;
            return;
        }
        this.dlog.error(bLangXMLSequenceLiteral.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, expType, this.symTable.xmlType);
        data.resultType = this.symTable.semanticError;
    }

    @Override
    public void visit(BLangXMLTextLiteral bLangXMLTextLiteral, AnalyzerData data) {
        List<BLangExpression> literalValues = bLangXMLTextLiteral.textFragments;
        this.checkStringTemplateExprs(literalValues, data);
        BLangExpression xmlExpression = literalValues.get(0);
        if (literalValues.size() == 1 && xmlExpression.getKind() == NodeKind.LITERAL && ((String)((BLangLiteral)xmlExpression).value).isEmpty()) {
            data.resultType = this.types.checkType(bLangXMLTextLiteral, this.symTable.xmlNeverType, data.expType);
            return;
        }
        data.resultType = this.types.checkType(bLangXMLTextLiteral, this.symTable.xmlTextType, data.expType);
    }

    @Override
    public void visit(BLangXMLCommentLiteral bLangXMLCommentLiteral, AnalyzerData data) {
        this.checkStringTemplateExprs(bLangXMLCommentLiteral.textFragments, data);
        if (data.expType == this.symTable.noType) {
            data.resultType = this.types.checkType(bLangXMLCommentLiteral, this.symTable.xmlCommentType, data.expType);
            return;
        }
        data.resultType = this.checkXmlSubTypeLiteralCompatibility(bLangXMLCommentLiteral.pos, this.symTable.xmlCommentType, data.expType, data);
    }

    @Override
    public void visit(BLangXMLProcInsLiteral bLangXMLProcInsLiteral, AnalyzerData data) {
        this.checkExpr((BLangExpression)bLangXMLProcInsLiteral.target, this.symTable.stringType, data);
        this.checkStringTemplateExprs(bLangXMLProcInsLiteral.dataFragments, data);
        if (data.expType == this.symTable.noType) {
            data.resultType = this.types.checkType(bLangXMLProcInsLiteral, this.symTable.xmlPIType, data.expType);
            return;
        }
        data.resultType = this.checkXmlSubTypeLiteralCompatibility(bLangXMLProcInsLiteral.pos, this.symTable.xmlPIType, data.expType, data);
    }

    @Override
    public void visit(BLangXMLQuotedString bLangXMLQuotedString, AnalyzerData data) {
        this.checkStringTemplateExprs(bLangXMLQuotedString.textFragments, data);
        data.resultType = this.types.checkType(bLangXMLQuotedString, this.symTable.stringType, data.expType);
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral, AnalyzerData data) {
        this.checkStringTemplateExprs(stringTemplateLiteral.exprs, data);
        data.resultType = this.types.checkType(stringTemplateLiteral, this.symTable.stringType, data.expType);
    }

    @Override
    public void visit(BLangRegExpTemplateLiteral regExpTemplateLiteral, AnalyzerData data) {
        this.semanticAnalyzer.analyzeNode((BLangNode)regExpTemplateLiteral, data.env);
        List<BLangExpression> interpolationsList = this.symResolver.getListOfInterpolations(regExpTemplateLiteral.reDisjunction.sequenceList);
        interpolationsList.forEach(interpolation -> this.checkExpr((BLangExpression)interpolation, data));
        data.resultType = this.types.checkType(regExpTemplateLiteral, this.symTable.regExpType, data.expType);
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral, AnalyzerData data) {
        BType insertionsType;
        BType type = this.determineRawTemplateLiteralType(rawTemplateLiteral, data.expType);
        if (type == this.symTable.semanticError) {
            data.resultType = type;
            return;
        }
        BObjectType literalType = (BObjectType)Types.getImpliedType(type);
        BType stringsType = ((BField)literalType.fields.get((Object)"strings")).type;
        if (this.evaluateRawTemplateExprs(rawTemplateLiteral.strings, stringsType, DiagnosticErrorCode.INVALID_NUM_STRINGS, rawTemplateLiteral.pos, data)) {
            type = this.symTable.semanticError;
        }
        if (this.evaluateRawTemplateExprs(rawTemplateLiteral.insertions, insertionsType = ((BField)literalType.fields.get((Object)"insertions")).type, DiagnosticErrorCode.INVALID_NUM_INSERTIONS, rawTemplateLiteral.pos, data)) {
            type = this.symTable.semanticError;
        }
        data.resultType = type;
    }

    private BType determineRawTemplateLiteralType(BLangRawTemplateLiteral rawTemplateLiteral, BType expType) {
        if (expType == this.symTable.noType || this.containsAnyType(expType)) {
            return this.symTable.rawTemplateType;
        }
        BType compatibleType = this.getCompatibleRawTemplateType(expType, rawTemplateLiteral.pos);
        BType type = this.types.checkType(rawTemplateLiteral, compatibleType, (BType)this.symTable.rawTemplateType, (DiagnosticCode)DiagnosticErrorCode.INVALID_RAW_TEMPLATE_TYPE);
        if (type == this.symTable.semanticError) {
            return type;
        }
        if (Symbols.isFlagOn(type.tsymbol.flags, 0x10000000L)) {
            this.dlog.error(rawTemplateLiteral.pos, DiagnosticErrorCode.INVALID_RAW_TEMPLATE_ASSIGNMENT, type);
            return this.symTable.semanticError;
        }
        BObjectType litObjType = (BObjectType)Types.getImpliedType(type);
        BObjectTypeSymbol objTSymbol = (BObjectTypeSymbol)litObjType.tsymbol;
        if (litObjType.fields.size() > 2) {
            this.dlog.error(rawTemplateLiteral.pos, DiagnosticErrorCode.INVALID_NUM_FIELDS, litObjType);
            type = this.symTable.semanticError;
        }
        if (!objTSymbol.attachedFuncs.isEmpty()) {
            this.dlog.error(rawTemplateLiteral.pos, DiagnosticErrorCode.METHODS_NOT_ALLOWED, litObjType);
            type = this.symTable.semanticError;
        }
        return type;
    }

    private boolean evaluateRawTemplateExprs(List<? extends BLangExpression> exprs, BType fieldType, DiagnosticCode code, Location pos, AnalyzerData data) {
        BType listType = Types.getImpliedType(fieldType);
        boolean errored = false;
        if (listType.tag == 20) {
            BArrayType arrayType = (BArrayType)listType;
            if (arrayType.state == BArrayState.CLOSED && exprs.size() != arrayType.getSize()) {
                this.dlog.error(pos, code, arrayType.getSize(), exprs.size());
                return false;
            }
            for (BLangExpression bLangExpression : exprs) {
                errored = this.checkExpr(bLangExpression, arrayType.eType, data) == this.symTable.semanticError || errored;
            }
        } else if (listType.tag == 31) {
            int i;
            int n;
            BTupleType tupleType = (BTupleType)listType;
            int size = exprs.size();
            if (size < (n = tupleType.getMembers().size()) || size > n && tupleType.restType == null) {
                this.dlog.error(pos, code, n, size);
                return false;
            }
            List<BType> memberTypes = tupleType.getTupleTypes();
            for (i = 0; i < n; ++i) {
                errored = this.checkExpr(exprs.get(i), memberTypes.get(i), data) == this.symTable.semanticError || errored;
            }
            if (size > n) {
                while (i < size) {
                    errored = this.checkExpr(exprs.get(i), tupleType.restType, data) == this.symTable.semanticError || errored;
                    ++i;
                }
            }
        } else {
            throw new IllegalStateException("Expected a list type, but found: " + String.valueOf(listType));
        }
        return errored;
    }

    private boolean containsAnyType(BType bType) {
        return SemTypeHelper.containsType(this.types.semTypeCtx, bType, (SemType)PredefinedType.ANY);
    }

    private BType getCompatibleRawTemplateType(BType bType, Location pos) {
        BType expType = Types.getImpliedType(bType);
        if (expType.tag != 21) {
            return bType;
        }
        BUnionType unionType = (BUnionType)expType;
        ArrayList<BType> compatibleTypes = new ArrayList<BType>();
        for (BType type : unionType.getMemberTypes()) {
            if (!this.types.isAssignable(type, this.symTable.rawTemplateType)) continue;
            compatibleTypes.add(type);
        }
        if (compatibleTypes.isEmpty()) {
            return bType;
        }
        if (compatibleTypes.size() > 1) {
            this.dlog.error(pos, DiagnosticErrorCode.MULTIPLE_COMPATIBLE_RAW_TEMPLATE_TYPES, this.symTable.rawTemplateType, bType);
            return this.symTable.semanticError;
        }
        return (BType)compatibleTypes.get(0);
    }

    @Override
    public void visit(BLangRestArgsExpression bLangRestArgExpression, AnalyzerData data) {
        data.resultType = this.checkExpr(bLangRestArgExpression.expr, data.expType, data);
    }

    @Override
    public void visit(BLangInferredTypedescDefaultNode inferTypedescExpr, AnalyzerData data) {
        BType referredType = Types.getImpliedType(data.expType);
        if (referredType.tag != 13) {
            this.dlog.error(inferTypedescExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data.expType, this.symTable.typeDesc);
            data.resultType = this.symTable.semanticError;
            return;
        }
        data.resultType = referredType;
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression, AnalyzerData data) {
        data.resultType = this.checkExpr(bLangNamedArgsExpression.expr, data.env, data.expType, data);
        bLangNamedArgsExpression.setBType(bLangNamedArgsExpression.expr.getBType());
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr, AnalyzerData data) {
        this.visitCheckAndCheckPanicExpr(checkedExpr, data);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkedExpr, AnalyzerData data) {
        this.visitCheckAndCheckPanicExpr(checkedExpr, data);
    }

    @Override
    public void visit(BLangQueryExpr queryExpr, AnalyzerData data) {
        this.queryTypeChecker.checkQueryType(queryExpr, data);
    }

    @Override
    public void visit(BLangQueryAction queryAction, AnalyzerData data) {
        this.queryTypeChecker.checkQueryAction(queryAction, data);
    }

    @Override
    public void visit(BLangDo doNode, AnalyzerData data) {
        if (doNode.onFailClause != null) {
            doNode.onFailClause.accept(this, data);
        }
    }

    @Override
    public void visit(BLangOnFailClause onFailClause, AnalyzerData data) {
        onFailClause.body.stmts.forEach(stmt -> stmt.accept(this, data));
    }

    protected void visitCheckAndCheckPanicExpr(BLangCheckedExpr checkedExpr, AnalyzerData data) {
        BType exprType;
        boolean firstVisit;
        OperatorKind operatorKind = checkedExpr.getKind() == NodeKind.CHECK_EXPR ? OperatorKind.CHECK : OperatorKind.CHECK_PANIC;
        BLangExpression exprWithCheckingKeyword = checkedExpr.expr;
        boolean bl = firstVisit = exprWithCheckingKeyword.getBType() == null;
        BType checkExprCandidateType = data.expType == this.symTable.noType ? this.symTable.noType : ((exprType = this.getCandidateType(checkedExpr, data.expType, data)) == this.symTable.semanticError ? BUnionType.create(this.typeEnv, null, data.expType, this.symTable.errorType) : this.addDefaultErrorIfNoErrorComponentFound(data.expType));
        if (checkedExpr.getKind() == NodeKind.CHECK_EXPR && this.types.isSubTypeOfSimpleBasicTypeOrString(data.expType)) {
            this.rewriteWithEnsureTypeFunc(checkedExpr, checkExprCandidateType, data);
        }
        exprType = this.checkExpr(checkedExpr.expr, checkExprCandidateType, data);
        if (checkedExpr.expr.getKind() == NodeKind.WORKER_RECEIVE) {
            if (firstVisit) {
                data.isTypeChecked = false;
                data.resultType = data.expType;
                return;
            }
            data.expType = checkedExpr.getBType();
            exprType = checkedExpr.expr.getBType();
        }
        boolean isErrorType = exprType.tag != 28 && this.types.isAssignable(exprType, this.symTable.errorType);
        BType referredExprType = Types.getImpliedType(exprType);
        if (referredExprType.tag != 21 && !isErrorType) {
            if (referredExprType.tag == 38) {
                checkedExpr.equivalentErrorTypeList = new ArrayList<BType>(1){
                    {
                        this.add(TypeChecker.this.symTable.errorType);
                    }
                };
                data.resultType = this.symTable.anyAndReadonly;
                return;
            }
            if (exprType != this.symTable.semanticError) {
                this.dlog.warning(checkedExpr.expr.pos, DiagnosticWarningCode.CHECKED_EXPR_INVALID_USAGE_NO_ERROR_TYPE_IN_RHS, operatorKind.value());
                checkedExpr.isRedundantChecking = true;
                data.resultType = checkedExpr.expr.getBType();
                this.resetImpConversionExpr(checkedExpr.expr, data.resultType, data.expType);
            }
            checkedExpr.setBType(this.symTable.semanticError);
            return;
        }
        ArrayList<BType> errorTypes = new ArrayList<BType>();
        ArrayList<BType> nonErrorTypes = new ArrayList<BType>();
        if (!isErrorType) {
            for (BType memberType : this.types.getAllTypes(exprType, true)) {
                if (Types.getImpliedType((BType)memberType).tag == 38) {
                    errorTypes.add(this.symTable.errorType);
                    nonErrorTypes.add(this.symTable.anyAndReadonly);
                    continue;
                }
                if (this.types.isAssignable(memberType, this.symTable.errorType)) {
                    errorTypes.add(memberType);
                    continue;
                }
                nonErrorTypes.add(memberType);
            }
        } else {
            errorTypes.add(exprType);
        }
        if (operatorKind == OperatorKind.CHECK && !data.commonAnalyzerData.errorTypes.isEmpty()) {
            data.commonAnalyzerData.errorTypes.peek().add(this.types.getErrorTypes(checkedExpr.expr.getBType()));
        }
        checkedExpr.equivalentErrorTypeList = errorTypes;
        if (errorTypes.isEmpty()) {
            this.dlog.warning(checkedExpr.expr.pos, DiagnosticWarningCode.CHECKED_EXPR_INVALID_USAGE_NO_ERROR_TYPE_IN_RHS, operatorKind.value());
            checkedExpr.isRedundantChecking = true;
            this.resetImpConversionExpr(checkedExpr.expr, data.resultType, data.expType);
            checkedExpr.setBType(this.symTable.semanticError);
            return;
        }
        BType actualType = nonErrorTypes.isEmpty() ? this.symTable.neverType : (nonErrorTypes.size() == 1 ? (BType)nonErrorTypes.get(0) : BUnionType.create(this.typeEnv, null, new LinkedHashSet<BType>(nonErrorTypes)));
        data.resultType = this.types.checkType(checkedExpr, actualType, data.expType);
    }

    protected void resetImpConversionExpr(BLangExpression expr, BType actualType, BType targetType) {
        expr.impConversionExpr = null;
        this.types.setImplicitCastExpr(expr, actualType, targetType);
    }

    private void rewriteWithEnsureTypeFunc(BLangCheckedExpr checkedExpr, BType type, AnalyzerData data) {
        SemType candidateLaxType;
        BType rhsType = this.getCandidateType(checkedExpr, type, data);
        if (rhsType == this.symTable.semanticError) {
            rhsType = this.getCandidateType(checkedExpr, rhsType, data);
        }
        if (!this.types.isLaxFieldAccessAllowed(candidateLaxType = this.getCandidateLaxType(checkedExpr.expr, rhsType))) {
            return;
        }
        ArrayList<BLangExpression> argExprs = new ArrayList<BLangExpression>();
        BTypedescType typedescType = new BTypedescType(this.typeEnv, data.expType, null);
        BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
        typedescExpr.resolvedType = data.expType;
        typedescExpr.setBType(typedescType);
        argExprs.add(typedescExpr);
        BLangInvocation invocation = ASTBuilderUtil.createLangLibInvocationNode(FUNCTION_NAME_ENSURE_TYPE, argExprs, checkedExpr.expr, checkedExpr.pos);
        invocation.symbol = this.symResolver.lookupLangLibMethod(type, Names.fromString(invocation.name.value), data.env);
        invocation.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        checkedExpr.expr = invocation;
    }

    private SemType getCandidateLaxType(BLangNode expr, BType rhsType) {
        SemType t = rhsType.semType();
        if (expr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR) {
            return this.types.getErrorLiftType(t);
        }
        return t;
    }

    private BType getCandidateType(BLangCheckedExpr checkedExpr, BType checkExprCandidateType, AnalyzerData data) {
        boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
        data.commonAnalyzerData.nonErrorLoggingCheck = true;
        this.dlog.mute();
        GlobalStateSnapshot previousGlobalState = this.getGlobalStateSnapshotAndResetGlobalState();
        ++checkedExpr.expr.cloneAttempt;
        BLangExpression clone = this.nodeCloner.cloneNode(checkedExpr.expr);
        BType rhsType = checkExprCandidateType == this.symTable.semanticError ? this.checkExpr(clone, data) : this.checkExpr(clone, checkExprCandidateType, data);
        data.commonAnalyzerData.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
        this.restoreGlobalState(previousGlobalState);
        if (!prevNonErrorLoggingCheck) {
            this.dlog.unmute();
        }
        return rhsType;
    }

    private BType addDefaultErrorIfNoErrorComponentFound(BType type) {
        for (BType t : this.types.getAllTypes(type, false)) {
            if (!this.types.isAssignable(t, this.symTable.errorType)) continue;
            return type;
        }
        return BUnionType.create(this.typeEnv, null, type, this.symTable.errorType);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr, AnalyzerData data) {
        data.resultType = serviceConstructorExpr.serviceNode.symbol.type;
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr, AnalyzerData data) {
        typeTestExpr.typeNode.setBType(this.symResolver.resolveTypeNode(typeTestExpr.typeNode, data.env));
        this.checkExpr(typeTestExpr.expr, data);
        data.resultType = this.types.checkType(typeTestExpr, this.symTable.booleanType, data.expType);
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr, AnalyzerData data) {
        this.checkExpr(annotAccessExpr.expr, this.symTable.typeDesc, data);
        BType actualType = this.symTable.semanticError;
        BSymbol symbol = this.symResolver.resolveAnnotation(annotAccessExpr.pos, data.env, Names.fromString(annotAccessExpr.pkgAlias.getValue()), Names.fromString(annotAccessExpr.annotationName.getValue()));
        if (symbol == this.symTable.notFoundSymbol) {
            this.dlog.error(annotAccessExpr.pos, DiagnosticErrorCode.UNDEFINED_ANNOTATION, annotAccessExpr.annotationName.getValue());
        } else {
            annotAccessExpr.annotationSymbol = (BAnnotationSymbol)symbol;
            BType annotType = ((BAnnotationSymbol)symbol).attachedType == null ? this.symTable.trueType : ((BAnnotationSymbol)symbol).attachedType;
            actualType = BUnionType.create(this.typeEnv, null, annotType, this.symTable.nilType);
        }
        data.resultType = this.types.checkType(annotAccessExpr, actualType, data.expType);
    }

    @Override
    public void visit(BLangNaturalExpression naturalExpression, AnalyzerData data) {
        BType type = data.expType;
        SemType expTypeSemType = type.semType();
        boolean isConstNaturalExpr = naturalExpression.isConstExpr;
        if (!isConstNaturalExpr && !this.types.isSubtype(this.symTable.errorType, expTypeSemType)) {
            this.dlog.error(naturalExpression.pos, DiagnosticErrorCode.EXPECTED_TYPE_FOR_NATURAL_EXPR_MUST_CONTAIN_ERROR, new Object[0]);
            type = this.symTable.semanticError;
        } else if (this.types.isSubtype(expTypeSemType, this.symTable.errorType.semType())) {
            this.dlog.error(naturalExpression.pos, isConstNaturalExpr ? DiagnosticErrorCode.EXPECTED_TYPE_FOR_CONST_NATURAL_EXPR_MUST_BE_A_SUBTYPE_OF_ANYDATA : DiagnosticErrorCode.EXPECTED_TYPE_FOR_NATURAL_EXPR_MUST_CONTAIN_A_UNION_OF_NON_ERROR_AND_ERROR, new Object[0]);
            type = this.symTable.semanticError;
        }
        SemType errorLiftedType = this.types.getErrorLiftType(expTypeSemType);
        if (isConstNaturalExpr) {
            if (!this.types.isSubtype(errorLiftedType, this.symTable.anydataType.semType())) {
                this.dlog.error(naturalExpression.pos, DiagnosticErrorCode.EXPECTED_TYPE_FOR_CONST_NATURAL_EXPR_MUST_BE_A_SUBTYPE_OF_ANYDATA, new Object[0]);
                type = this.symTable.semanticError;
            }
        } else if (!this.types.isSubtype(errorLiftedType, this.symTable.pureType.semType())) {
            this.dlog.error(naturalExpression.pos, DiagnosticErrorCode.EXPECTED_TYPE_FOR_NATURAL_EXPR_MUST_BE_A_SUBTYPE_OF_ANYDATA_OR_ERROR, new Object[0]);
            type = this.symTable.semanticError;
        }
        this.checkNaturalExprArguments(naturalExpression, data);
        this.checkNaturalExprInsertions(naturalExpression, data);
        data.resultType = type;
    }

    private void checkNaturalExprArguments(BLangNaturalExpression naturalExpression, AnalyzerData data) {
        List<BLangExpression> arguments = naturalExpression.arguments;
        int size = arguments.size();
        if (naturalExpression.isConstExpr) {
            if (arguments.isEmpty()) {
                return;
            }
            this.dlog.error(arguments.getFirst().pos, DiagnosticErrorCode.EXPECTED_NO_ARGS_IN_A_CONST_NATURAL_EXPR, size);
            for (BLangExpression argument : arguments) {
                this.checkExpr(argument, this.symTable.anyType, data);
            }
            return;
        }
        if (size == 0) {
            this.dlog.error(naturalExpression.pos, DiagnosticErrorCode.EXPECTED_A_SINGLE_ARG_OF_TYPE_GENERATOR_IN_A_NATURAL_EXPR, size);
            return;
        }
        this.checkExpr(arguments.getFirst(), this.symTable.naturalGeneratorType, data);
        if (size == 1) {
            return;
        }
        this.dlog.error(naturalExpression.pos, DiagnosticErrorCode.EXPECTED_A_SINGLE_ARG_OF_TYPE_GENERATOR_IN_A_NATURAL_EXPR, size);
        for (int i = 0; i < size; ++i) {
            this.checkExpr(arguments.get(i), this.symTable.anyType, data);
        }
    }

    private boolean isValidVariableReference(BLangExpression varRef) {
        return switch (varRef.getKind()) {
            case NodeKind.SIMPLE_VARIABLE_REF, NodeKind.RECORD_VARIABLE_REF, NodeKind.TUPLE_VARIABLE_REF, NodeKind.ERROR_VARIABLE_REF, NodeKind.FIELD_BASED_ACCESS_EXPR, NodeKind.INDEX_BASED_ACCESS_EXPR, NodeKind.XML_ATTRIBUTE_ACCESS_EXPR -> true;
            default -> {
                this.dlog.error(varRef.pos, DiagnosticErrorCode.INVALID_RECORD_BINDING_PATTERN, varRef.getBType());
                yield false;
            }
        };
    }

    private BType getEffectiveReadOnlyType(Location pos, BType type, AnalyzerData data) {
        BType origTargetType = Types.getReferredType(type);
        if (origTargetType == this.symTable.readonlyType) {
            if (this.types.isInherentlyImmutableType(data.expType) || !this.types.isSelectivelyImmutableType(data.expType, data.env.enclPkg.packageID)) {
                return type;
            }
            return ImmutableTypeCloner.getImmutableIntersectionType(pos, this.types, data.expType, data.env, this.symTable, this.anonymousModelHelper, this.names, new HashSet<Flag>());
        }
        if (origTargetType.tag != 21) {
            return type;
        }
        boolean hasReadOnlyType = false;
        LinkedHashSet<BType> nonReadOnlyTypes = new LinkedHashSet<BType>();
        for (BType memberType : ((BUnionType)origTargetType).getMemberTypes()) {
            if (memberType == this.symTable.readonlyType) {
                hasReadOnlyType = true;
                continue;
            }
            nonReadOnlyTypes.add(memberType);
        }
        if (!hasReadOnlyType) {
            return type;
        }
        if (this.types.isInherentlyImmutableType(data.expType) || !this.types.isSelectivelyImmutableType(data.expType, data.env.enclPkg.packageID)) {
            return type;
        }
        BUnionType nonReadOnlyUnion = BUnionType.create(this.typeEnv, null, nonReadOnlyTypes);
        nonReadOnlyUnion.add(ImmutableTypeCloner.getImmutableIntersectionType(pos, this.types, data.expType, data.env, this.symTable, this.anonymousModelHelper, this.names, new HashSet<Flag>()));
        return nonReadOnlyUnion;
    }

    private BType populateArrowExprReturn(BLangArrowFunction bLangArrowFunction, BType expectedRetType, AnalyzerData data) {
        SymbolEnv arrowFunctionEnv = SymbolEnv.createArrowFunctionSymbolEnv(bLangArrowFunction, data.env);
        bLangArrowFunction.params.forEach(param -> this.symbolEnter.defineNode((BLangNode)param, arrowFunctionEnv));
        return this.checkExpr(bLangArrowFunction.body.expr, arrowFunctionEnv, expectedRetType, data);
    }

    private void populateArrowExprParamTypes(BLangArrowFunction bLangArrowFunction, List<BType> paramTypes, AnalyzerData data) {
        if (paramTypes.size() != bLangArrowFunction.params.size()) {
            this.dlog.error(bLangArrowFunction.pos, DiagnosticErrorCode.ARROW_EXPRESSION_MISMATCHED_PARAMETER_LENGTH, paramTypes.size(), bLangArrowFunction.params.size());
            data.resultType = this.symTable.semanticError;
            bLangArrowFunction.params.forEach(param -> param.setBType(this.symTable.semanticError));
            return;
        }
        for (int i = 0; i < bLangArrowFunction.params.size(); ++i) {
            BLangSimpleVariable paramIdentifier = bLangArrowFunction.params.get(i);
            BType bType = paramTypes.get(i);
            BLangValueType valueTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
            valueTypeNode.setTypeKind(bType.getKind());
            valueTypeNode.pos = this.symTable.builtinPos;
            paramIdentifier.setTypeNode(valueTypeNode);
            paramIdentifier.setBType(bType);
        }
    }

    public void checkSelfReferences(Location pos, SymbolEnv env, BVarSymbol varSymbol) {
        if (env.enclVarSym == varSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.SELF_REFERENCE_VAR, varSymbol.name);
        }
    }

    private void checkFunctionInvocationExpr(BLangInvocation iExpr, AnalyzerData data) {
        boolean langLibPackageID;
        Name funcName = this.names.fromIdNode(iExpr.name);
        Name pkgAlias = this.names.fromIdNode(iExpr.pkgAlias);
        BSymbol funcSymbol = this.symTable.notFoundSymbol;
        BSymbol pkgSymbol = this.symResolver.resolvePrefixSymbol(data.env, pkgAlias, this.getCurrentCompUnit(iExpr));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias);
        } else {
            BSymbol symbol = this.symResolver.lookupMainSpaceSymbolInPackage(iExpr.pos, data.env, pkgAlias, funcName);
            if ((symbol.tag & 0x34L) == 52L) {
                funcSymbol = symbol;
            }
            if (this.symTable.rootPkgSymbol.pkgID.equals(symbol.pkgID) && (symbol.tag & 0x14L) == 20L) {
                funcSymbol = symbol;
            }
            if (funcSymbol == this.symTable.notFoundSymbol || (funcSymbol.tag & 0xCL) == 12L) {
                BSymbol ctor = this.symResolver.lookupConstructorSpaceSymbolInPackage(iExpr.pos, data.env, pkgAlias, funcName);
                BSymbol bSymbol = funcSymbol = ctor != this.symTable.notFoundSymbol ? ctor : funcSymbol;
            }
        }
        if (funcSymbol != this.symTable.notFoundSymbol && this.isNotFunction(funcSymbol)) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.FUNCTION_CALL_SYNTAX_NOT_DEFINED, funcSymbol.type);
            iExpr.argExprs.forEach(arg -> this.checkExpr((BLangExpression)arg, data));
            data.resultType = this.symTable.semanticError;
            return;
        }
        if (funcSymbol == this.symTable.notFoundSymbol) {
            if (!this.missingNodesHelper.isMissingNode(funcName)) {
                this.dlog.error(iExpr.pos, DiagnosticErrorCode.UNDEFINED_FUNCTION, funcName);
            }
            iExpr.argExprs.forEach(arg -> this.checkExpr((BLangExpression)arg, data));
            data.resultType = this.symTable.semanticError;
            return;
        }
        if (this.isFunctionPointer(funcSymbol)) {
            iExpr.functionPointerInvocation = true;
            this.markAndRegisterClosureVariable(funcSymbol, iExpr.pos, data.env, data);
        }
        if (Symbols.isFlagOn(funcSymbol.flags, 32768L)) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION_SYNTAX, iExpr.name.value);
        }
        if (Symbols.isFlagOn(funcSymbol.flags, 131072L)) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_RESOURCE_FUNCTION_INVOCATION, new Object[0]);
        }
        if (langLibPackageID = PackageID.isLangLibPackageID(pkgSymbol.pkgID)) {
            data.env = SymbolEnv.createInvocationEnv(iExpr, data.env);
        }
        iExpr.symbol = funcSymbol;
        this.checkInvocationParamAndReturnType(iExpr, data);
        if (langLibPackageID && !iExpr.argExprs.isEmpty()) {
            this.checkInvalidImmutableValueUpdate(iExpr, iExpr.argExprs.get(0).getBType(), funcSymbol, data);
        }
    }

    protected void markAndRegisterClosureVariable(BSymbol symbol, Location pos, SymbolEnv env, AnalyzerData data) {
        BSymbol resolvedSymbol;
        BLangInvokableNode encInvokable = env.enclInvokable;
        BLangNode bLangNode = env.node;
        if (env.enclType != null && env.enclType.getKind() == NodeKind.FUNCTION_TYPE || (symbol.owner.tag & 0x1001L) == 4097L && bLangNode.getKind() != NodeKind.ARROW_EXPR && bLangNode.getKind() != NodeKind.EXPR_FUNCTION_BODY && encInvokable != null && !encInvokable.flagSet.contains((Object)Flag.LAMBDA) && !encInvokable.flagSet.contains((Object)Flag.OBJECT_CTOR)) {
            return;
        }
        if (!symbol.closure && this.searchClosureVariableInExpressions(symbol, pos, env, encInvokable, bLangNode)) {
            return;
        }
        BLangNode node = bLangNode;
        if (this.isObjectCtorClass(node)) {
            BLangClassDefinition classDef = (BLangClassDefinition)node;
            OCEDynamicEnvironmentData oceData = classDef.oceEnvData;
            BLangFunction currentFunc = (BLangFunction)encInvokable;
            if (currentFunc != null && !currentFunc.attachedFunction && currentFunc.symbol.receiverSymbol != symbol && (resolvedSymbol = this.symResolver.lookupClosureVarSymbol(oceData.capturedClosureEnv, symbol)) != this.symTable.notFoundSymbol && !resolvedSymbol.closure && resolvedSymbol.owner.getKind() != SymbolKind.PACKAGE) {
                this.updateObjectCtorClosureSymbols(pos, currentFunc, resolvedSymbol, classDef, data);
                return;
            }
        }
        SymbolEnv cEnv = env;
        while (node != null) {
            if (node.getKind() == NodeKind.FUNCTION) {
                BLangFunction function = (BLangFunction)node;
                if (!function.flagSet.contains((Object)Flag.OBJECT_CTOR) && !function.flagSet.contains((Object)Flag.ATTACHED)) break;
            }
            if (!symbol.closure && this.searchClosureVariableInExpressions(symbol, pos, cEnv, encInvokable, node)) {
                return;
            }
            if (this.isObjectCtorClass(node)) {
                BLangFunction currentFunction = (BLangFunction)encInvokable;
                if (currentFunction != null && currentFunction.attachedFunction && currentFunction.symbol.receiverSymbol == symbol) {
                    return;
                }
                SymbolEnv encInvokableEnv = this.findEnclosingInvokableEnv(cEnv, encInvokable);
                resolvedSymbol = this.symResolver.lookupClosureVarSymbol(encInvokableEnv, symbol);
                BLangClassDefinition classDef = (BLangClassDefinition)node;
                if (resolvedSymbol == this.symTable.notFoundSymbol || resolvedSymbol.owner.getKind() == SymbolKind.PACKAGE) break;
                this.updateObjectCtorClosureSymbols(pos, currentFunction, resolvedSymbol, classDef, data);
                return;
            }
            SymbolEnv enclEnv = cEnv.enclEnv;
            if (enclEnv == null) break;
            cEnv = enclEnv;
            node = cEnv.node;
        }
    }

    private boolean isObjectCtorClass(BLangNode node) {
        return node.getKind() == NodeKind.CLASS_DEFN && ((BLangClassDefinition)node).flagSet.contains((Object)Flag.OBJECT_CTOR);
    }

    private boolean searchClosureVariableInExpressions(BSymbol symbol, Location pos, SymbolEnv env, BLangInvokableNode encInvokable, BLangNode bLangNode) {
        SymbolEnv encInvokableEnv;
        BSymbol resolvedSymbol;
        if (encInvokable != null && encInvokable.flagSet.contains((Object)Flag.LAMBDA) && !CompilerUtils.isInParameterList(symbol, encInvokable.requiredParams) && (resolvedSymbol = this.symResolver.lookupClosureVarSymbol(encInvokableEnv = this.findEnclosingInvokableEnv(env, encInvokable), symbol)) != this.symTable.notFoundSymbol && !encInvokable.flagSet.contains((Object)Flag.ATTACHED)) {
            resolvedSymbol.closure = true;
            ((BLangFunction)encInvokable).closureVarSymbols.add(new ClosureVarSymbol(resolvedSymbol, pos));
            return true;
        }
        if (bLangNode.getKind() == NodeKind.ARROW_EXPR && !CompilerUtils.isInParameterList(symbol, ((BLangArrowFunction)bLangNode).params) && (resolvedSymbol = this.symResolver.lookupClosureVarSymbol(encInvokableEnv = this.findEnclosingInvokableEnv(env, encInvokable), symbol)) != this.symTable.notFoundSymbol) {
            resolvedSymbol.closure = true;
            ((BLangArrowFunction)bLangNode).closureVarSymbols.add(new ClosureVarSymbol(resolvedSymbol, pos));
            return true;
        }
        return false;
    }

    private void updateObjectCtorClosureSymbols(Location pos, BLangFunction currentFunction, BSymbol resolvedSymbol, BLangClassDefinition classDef, AnalyzerData data) {
        classDef.hasClosureVars = true;
        resolvedSymbol.closure = true;
        if (currentFunction != null) {
            currentFunction.closureVarSymbols.add(new ClosureVarSymbol(resolvedSymbol, pos));
        }
        OCEDynamicEnvironmentData oceEnvData = classDef.oceEnvData;
        if (currentFunction != null && (currentFunction.symbol.params.contains(resolvedSymbol) || currentFunction.symbol.restParam == resolvedSymbol)) {
            oceEnvData.closureFuncSymbols.add(resolvedSymbol);
        } else {
            oceEnvData.closureBlockSymbols.add(resolvedSymbol);
        }
        this.updateProceedingClasses(data.env.enclEnv, oceEnvData, classDef);
    }

    private void updateProceedingClasses(SymbolEnv envArg, OCEDynamicEnvironmentData oceEnvData, BLangClassDefinition origClassDef) {
        BLangNode node;
        SymbolEnv localEnv = envArg;
        while (localEnv != null && (node = localEnv.node).getKind() != NodeKind.PACKAGE) {
            BLangClassDefinition classDef;
            if (node.getKind() == NodeKind.CLASS_DEFN && (classDef = (BLangClassDefinition)node) != origClassDef) {
                classDef.hasClosureVars = true;
                OCEDynamicEnvironmentData parentOceData = classDef.oceEnvData;
                oceEnvData.parents.push(classDef);
                parentOceData.closureFuncSymbols.addAll(oceEnvData.closureFuncSymbols);
                parentOceData.closureBlockSymbols.addAll(oceEnvData.closureBlockSymbols);
            }
            localEnv = localEnv.enclEnv;
        }
    }

    private boolean isNotFunction(BSymbol funcSymbol) {
        if ((funcSymbol.tag & 0x334L) == 820L || (funcSymbol.tag & 0x4000100L) == 0x4000100L) {
            return false;
        }
        return !this.isFunctionPointer(funcSymbol);
    }

    private boolean isFunctionPointer(BSymbol funcSymbol) {
        if ((funcSymbol.tag & 0x334L) == 820L) {
            return false;
        }
        return (funcSymbol.tag & 0x334L) == 52L && funcSymbol.kind == SymbolKind.FUNCTION && !Symbols.isNative(funcSymbol);
    }

    private List<BLangNamedArgsExpression> checkProvidedErrorDetails(BLangErrorConstructorExpr errorConstructorExpr, BType expectedType, AnalyzerData data) {
        ArrayList<BLangNamedArgsExpression> namedArgs = new ArrayList<BLangNamedArgsExpression>(errorConstructorExpr.namedArgs.size());
        for (BLangNamedArgsExpression namedArgsExpression : errorConstructorExpr.namedArgs) {
            BType target = this.checkErrCtrTargetTypeAndSetSymbol(namedArgsExpression, expectedType);
            if (Types.getImpliedType((BType)target).tag != 21) {
                this.checkExpr((BLangExpression)namedArgsExpression, target, data);
            } else {
                this.checkExpr((BLangExpression)namedArgsExpression, data);
            }
            namedArgs.add(namedArgsExpression);
        }
        return namedArgs;
    }

    private BType checkErrCtrTargetTypeAndSetSymbol(BLangNamedArgsExpression namedArgsExpression, BType expectedType) {
        BType type = Types.getImpliedType(expectedType);
        if (type == this.symTable.semanticError) {
            return this.symTable.semanticError;
        }
        if (type.tag == 16) {
            return ((BMapType)type).constraint;
        }
        if (type.tag != 12) {
            return this.symTable.semanticError;
        }
        BRecordType recordType = (BRecordType)type;
        BField targetField = (BField)recordType.fields.get(namedArgsExpression.name.value);
        if (targetField != null) {
            namedArgsExpression.varSymbol = targetField.symbol;
            return targetField.type;
        }
        if (!recordType.sealed && !recordType.fields.isEmpty()) {
            this.dlog.error(namedArgsExpression.pos, DiagnosticErrorCode.INVALID_REST_DETAIL_ARG, namedArgsExpression.name, recordType);
        }
        return recordType.sealed ? this.symTable.noType : recordType.restFieldType;
    }

    private void checkObjectFunctionInvocationExpr(BLangInvocation iExpr, BObjectType objectType, AnalyzerData data) {
        BSymbol invocableField;
        if (!(objectType.getKind() != TypeKind.SERVICE || iExpr.expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && Names.SELF.equals(((BLangSimpleVarRef)iExpr.expr).symbol.name))) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.SERVICE_FUNCTION_INVALID_INVOCATION, new Object[0]);
            return;
        }
        Name funcName = Names.fromString(Symbols.getAttachedFuncSymbolName(objectType.tsymbol.name.value, iExpr.name.value));
        BSymbol funcSymbol = this.symResolver.resolveObjectMethod(iExpr.pos, data.env, funcName, (BObjectTypeSymbol)objectType.tsymbol);
        if (funcSymbol == this.symTable.notFoundSymbol && (invocableField = this.symResolver.resolveInvocableObjectField(iExpr.pos, data.env, this.names.fromIdNode(iExpr.name), (BObjectTypeSymbol)objectType.tsymbol)) != this.symTable.notFoundSymbol && invocableField.kind == SymbolKind.FUNCTION) {
            funcSymbol = invocableField;
            iExpr.functionPointerInvocation = true;
        }
        if (funcSymbol == this.symTable.notFoundSymbol || Types.getImpliedType((BType)funcSymbol.type).tag != 17) {
            if (!this.checkLangLibMethodInvocationExpr(iExpr, objectType, data)) {
                this.dlog.error(iExpr.name.pos, DiagnosticErrorCode.UNDEFINED_METHOD_IN_OBJECT, iExpr.name.value, objectType);
                data.resultType = this.symTable.semanticError;
                return;
            }
        } else {
            iExpr.symbol = funcSymbol;
        }
        if (iExpr.name.value.equals(Names.USER_DEFINED_INIT_SUFFIX.value) && (iExpr.expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF || !Names.SELF.equals(((BLangSimpleVarRef)iExpr.expr).symbol.name))) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_INIT_INVOCATION, new Object[0]);
        }
        if (Symbols.isFlagOn(funcSymbol.flags, 32768L)) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION_SYNTAX, iExpr.name.value);
        }
        if (Symbols.isFlagOn(funcSymbol.flags, 131072L)) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_RESOURCE_FUNCTION_INVOCATION, new Object[0]);
        }
        this.checkInvocationParamAndReturnType(iExpr, data);
    }

    private void checkActionInvocation(BLangInvocation.BLangActionInvocation aInv, BObjectType expType, AnalyzerData data) {
        BSymbol invocableField;
        if (this.checkInvalidActionInvocation(aInv)) {
            this.dlog.error(aInv.pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION, aInv.expr.getBType());
            data.resultType = this.symTable.semanticError;
            aInv.symbol = this.symTable.notFoundSymbol;
            return;
        }
        Name remoteMethodQName = Names.fromString(Symbols.getAttachedFuncSymbolName(expType.tsymbol.name.value, aInv.name.value));
        Name actionName = this.names.fromIdNode(aInv.name);
        BSymbol remoteFuncSymbol = this.symResolver.resolveObjectMethod(aInv.pos, data.env, remoteMethodQName, (BObjectTypeSymbol)Types.getImpliedType((BType)expType).tsymbol);
        if (remoteFuncSymbol == this.symTable.notFoundSymbol && (invocableField = this.symResolver.resolveInvocableObjectField(aInv.pos, data.env, this.names.fromIdNode(aInv.name), (BObjectTypeSymbol)expType.tsymbol)) != this.symTable.notFoundSymbol && invocableField.kind == SymbolKind.FUNCTION) {
            remoteFuncSymbol = invocableField;
            aInv.functionPointerInvocation = true;
        }
        if (remoteFuncSymbol == this.symTable.notFoundSymbol && !this.checkLangLibMethodInvocationExpr(aInv, expType, data)) {
            this.dlog.error(aInv.name.pos, DiagnosticErrorCode.UNDEFINED_METHOD_IN_OBJECT, aInv.name.value, expType);
            data.resultType = this.symTable.semanticError;
            return;
        }
        if (!Symbols.isFlagOn(remoteFuncSymbol.flags, 32768L) && !aInv.async) {
            this.dlog.error(aInv.pos, DiagnosticErrorCode.INVALID_METHOD_INVOCATION_SYNTAX, actionName);
            data.resultType = this.symTable.semanticError;
            return;
        }
        if (Symbols.isFlagOn(remoteFuncSymbol.flags, 32768L) && Symbols.isFlagOn(expType.getFlags(), 65536L) && this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember((BType)((InvokableSymbol)((Object)remoteFuncSymbol)).getReturnType())) {
            this.dlog.error(aInv.pos, DiagnosticErrorCode.INVALID_CLIENT_REMOTE_METHOD_CALL, new Object[0]);
        }
        aInv.symbol = remoteFuncSymbol;
        this.checkInvocationParamAndReturnType(aInv, data);
    }

    private boolean checkInvalidActionInvocation(BLangInvocation.BLangActionInvocation aInv) {
        return aInv.expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && (((BLangSimpleVarRef)aInv.expr).symbol.tag & 0x4034L) != 16436L && !aInv.async;
    }

    private boolean checkLangLibMethodInvocationExpr(BLangInvocation iExpr, BType bType, AnalyzerData data) {
        return this.getLangLibMethod(iExpr, bType, data) != this.symTable.notFoundSymbol;
    }

    private BSymbol getLangLibMethod(BLangInvocation iExpr, BType bType, AnalyzerData data) {
        Name funcName = Names.fromString(iExpr.name.value);
        BSymbol funcSymbol = this.symResolver.lookupLangLibMethod(bType, funcName, data.env);
        if (funcSymbol == this.symTable.notFoundSymbol) {
            return this.symTable.notFoundSymbol;
        }
        iExpr.symbol = funcSymbol;
        iExpr.langLibInvocation = true;
        SymbolEnv enclEnv = data.env;
        data.env = SymbolEnv.createInvocationEnv(iExpr, data.env);
        iExpr.argExprs.add(0, iExpr.expr);
        this.checkInvocationParamAndReturnType(iExpr, data);
        data.env = enclEnv;
        return funcSymbol;
    }

    private void checkInvocationParamAndReturnType(BLangInvocation iExpr, AnalyzerData data) {
        BType actualType = this.checkInvocationParam(iExpr, data);
        data.resultType = this.types.checkType(iExpr, actualType, data.expType);
    }

    private BVarSymbol incRecordParamAllowAdditionalFields(List<BVarSymbol> openIncRecordParams, Set<String> requiredParamNames) {
        if (openIncRecordParams.size() != 1) {
            return null;
        }
        LinkedHashMap fields = ((BRecordType)Types.getImpliedType((BType)openIncRecordParams.get((int)0).type)).fields;
        for (String paramName : requiredParamNames) {
            if (fields.containsKey(paramName)) continue;
            return null;
        }
        return openIncRecordParams.get(0);
    }

    private BVarSymbol checkForIncRecordParamAllowAdditionalFields(BInvokableSymbol invokableSymbol, List<BVarSymbol> incRecordParams) {
        HashSet<String> requiredParamNames = new HashSet<String>();
        ArrayList<BVarSymbol> openIncRecordParams = new ArrayList<BVarSymbol>();
        for (BVarSymbol paramSymbol : invokableSymbol.params) {
            BType paramType = Types.getImpliedType(paramSymbol.type);
            if (Symbols.isFlagOn(Flags.asMask(paramSymbol.getFlags()), 0x400000000L) && paramType.getKind() == TypeKind.RECORD) {
                boolean recordWithDisallowFieldsOnly = true;
                LinkedHashMap fields = ((BRecordType)paramType).fields;
                for (String fieldName : fields.keySet()) {
                    BField field = (BField)fields.get(fieldName);
                    if (Types.getImpliedType((BType)field.symbol.type).tag == 50) continue;
                    recordWithDisallowFieldsOnly = false;
                    incRecordParams.add(field.symbol);
                    requiredParamNames.add(fieldName);
                }
                if (!recordWithDisallowFieldsOnly || ((BRecordType)paramType).restFieldType == this.symTable.noType) continue;
                openIncRecordParams.add(paramSymbol);
                continue;
            }
            requiredParamNames.add(paramSymbol.name.value);
        }
        return this.incRecordParamAllowAdditionalFields(openIncRecordParams, requiredParamNames);
    }

    private BType checkInvocationParam(BLangInvocation iExpr, AnalyzerData data) {
        if (Symbols.isFlagOn(iExpr.symbol.type.getFlags(), 0x8000000000L)) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_FUNCTION_POINTER_INVOCATION_WITH_TYPE, new Object[0]);
            return this.symTable.semanticError;
        }
        BType invocableType = Types.getImpliedType(iExpr.symbol.type);
        if (invocableType.tag != 17) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_FUNCTION_INVOCATION, iExpr.symbol.type);
            return this.symTable.noType;
        }
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)iExpr.symbol;
        List<BType> paramTypes = ((BInvokableType)invocableType).getParameterTypes();
        ArrayList<BVarSymbol> incRecordParams = new ArrayList<BVarSymbol>();
        BVarSymbol incRecordParamAllowAdditionalFields = this.checkForIncRecordParamAllowAdditionalFields(invokableSymbol, incRecordParams);
        int parameterCountForPositionalArgs = paramTypes.size();
        int parameterCountForNamedArgs = parameterCountForPositionalArgs + incRecordParams.size();
        iExpr.requiredArgs = new ArrayList<BLangExpression>();
        block4: for (BVarSymbol symbol : invokableSymbol.params) {
            LinkedHashMap fields;
            if (!Symbols.isFlagOn(Flags.asMask(symbol.getFlags()), 0x400000000L) || Types.getImpliedType((BType)symbol.type).tag != 12 || (fields = ((BRecordType)Types.getImpliedType((BType)symbol.type)).fields).isEmpty()) continue;
            for (String field : fields.keySet()) {
                if (Types.getImpliedType((BType)((BField)fields.get((Object)field)).type).tag == 50) continue;
                --parameterCountForNamedArgs;
                continue block4;
            }
        }
        int i = 0;
        BLangExpression vararg = null;
        boolean foundNamedArg = false;
        boolean incRecordAllowAdditionalFields = incRecordParamAllowAdditionalFields != null;
        block6: for (BLangExpression expr : iExpr.argExprs) {
            switch (expr.getKind()) {
                case NAMED_ARGS_EXPR: {
                    foundNamedArg = true;
                    boolean namedArgForIncRecordParam = this.isNamedArgForIncRecordParam(((BLangNamedArgsExpression)expr).name.value, incRecordParamAllowAdditionalFields);
                    if (i < parameterCountForNamedArgs) {
                        if (namedArgForIncRecordParam) {
                            incRecordAllowAdditionalFields = false;
                        }
                        iExpr.requiredArgs.add(expr);
                    } else if (incRecordAllowAdditionalFields && !namedArgForIncRecordParam) {
                        iExpr.requiredArgs.add(expr);
                    } else {
                        boolean referringToARest = invokableSymbol.restParam != null && invokableSymbol.restParam.name.value.equals(((BLangNamedArgsExpression)expr).name.value);
                        DiagnosticErrorCode errorCode = referringToARest ? DiagnosticErrorCode.NAMED_ARG_NOT_ALLOWED_FOR_REST_PARAM : DiagnosticErrorCode.TOO_MANY_ARGS_FUNC_CALL;
                        this.checkTypeParamExpr(expr, this.symTable.noType, iExpr.langLibInvocation, data);
                        this.dlog.error(expr.pos, errorCode, iExpr.name.value);
                    }
                    ++i;
                    continue block6;
                }
                case REST_ARGS_EXPR: {
                    if (foundNamedArg) {
                        this.dlog.error(expr.pos, DiagnosticErrorCode.REST_ARG_DEFINED_AFTER_NAMED_ARG, new Object[0]);
                        continue block6;
                    }
                    vararg = expr;
                    continue block6;
                }
            }
            if (foundNamedArg) {
                this.dlog.error(expr.pos, DiagnosticErrorCode.POSITIONAL_ARG_DEFINED_AFTER_NAMED_ARG, new Object[0]);
            }
            if (i < parameterCountForPositionalArgs) {
                if (Symbols.isFlagOn(invokableSymbol.params.get((int)i).flags, 0x400000000L)) {
                    incRecordAllowAdditionalFields = false;
                }
                iExpr.requiredArgs.add(expr);
            } else {
                iExpr.restArgs.add(expr);
            }
            ++i;
        }
        return this.checkInvocationArgs(iExpr, paramTypes, vararg, incRecordParams, incRecordParamAllowAdditionalFields, data);
    }

    private boolean isNamedArgForIncRecordParam(String namedArgName, BVarSymbol incRecordParam) {
        return incRecordParam != null && namedArgName.equals(incRecordParam.name.value);
    }

    private BType checkInvocationArgs(BLangInvocation iExpr, List<BType> paramTypes, BLangExpression vararg, List<BVarSymbol> incRecordParams, BVarSymbol incRecordParamAllowAdditionalFields, AnalyzerData data) {
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)iExpr.symbol;
        BInvokableType bInvokableType = (BInvokableType)Types.getImpliedType(invokableSymbol.type);
        BInvokableTypeSymbol invokableTypeSymbol = (BInvokableTypeSymbol)bInvokableType.tsymbol;
        ArrayList<BVarSymbol> nonRestParams = new ArrayList<BVarSymbol>(invokableSymbol.params);
        List<BLangExpression> nonRestArgs = iExpr.requiredArgs;
        ArrayList<Object> valueProvidedParams = new ArrayList<Object>();
        int nonRestArgCount = nonRestArgs.size();
        ArrayList<BVarSymbol> requiredParams = new ArrayList<BVarSymbol>(nonRestParams.size() + nonRestArgCount);
        ArrayList<BVarSymbol> requiredIncRecordParams = new ArrayList<BVarSymbol>(incRecordParams.size() + nonRestArgCount);
        for (BVarSymbol bVarSymbol : nonRestParams) {
            if (bVarSymbol.isDefaultable) continue;
            requiredParams.add(bVarSymbol);
        }
        ArrayList<String> includedRecordParamFieldNames = new ArrayList<String>(incRecordParams.size());
        for (BVarSymbol incRecordParam : incRecordParams) {
            if (Symbols.isFlagOn(Flags.asMask(incRecordParam.getFlags()), 256L)) {
                requiredIncRecordParams.add(incRecordParam);
            }
            includedRecordParamFieldNames.add(incRecordParam.name.value);
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<BLangExpression> namedArgs = new ArrayList<BLangExpression>();
        for (int i = 0; i < nonRestArgCount; ++i) {
            BLangExpression arg = nonRestArgs.get(i);
            if (i == 0 && arg.typeChecked && iExpr.expr != null && iExpr.expr == arg) {
                BType expectedType = paramTypes.get(i);
                Object actualType = arg.getBType();
                if (Types.getImpliedType(expectedType) == this.symTable.charStringType) {
                    ++arg.cloneAttempt;
                    BLangExpression clonedArg = this.nodeCloner.cloneNode(arg);
                    BType argType = this.checkExprSilent(clonedArg, expectedType, data);
                    if (argType != this.symTable.semanticError) {
                        actualType = argType;
                    }
                }
                this.types.checkType(arg.pos, (BType)actualType, expectedType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
                this.types.setImplicitCastExpr(arg, arg.getBType(), expectedType);
            }
            if (arg.getKind() != NodeKind.NAMED_ARGS_EXPR) {
                if (i >= nonRestParams.size()) break;
                BVarSymbol param = (BVarSymbol)nonRestParams.get(i);
                if (Symbols.isFlagOn(param.flags, 0x400000000L)) {
                    this.populateIncludedRecordParams(param, hashSet, includedRecordParamFieldNames);
                }
                this.checkTypeParamExpr(arg, param.type, iExpr.langLibInvocation, data);
                valueProvidedParams.add(param);
                requiredParams.remove(param);
                continue;
            }
            if (arg.getKind() != NodeKind.NAMED_ARGS_EXPR) continue;
            BLangIdentifier argName = ((NamedArgNode)((Object)arg)).getName();
            BVarSymbol varSym = this.checkParameterNameForDefaultArgument(argName, ((BLangNamedArgsExpression)arg).expr, nonRestParams, incRecordParams, incRecordParamAllowAdditionalFields, data);
            if (varSym == null) {
                this.checkTypeParamExpr(arg, this.symTable.noType, iExpr.langLibInvocation, data);
                this.dlog.error(arg.pos, DiagnosticErrorCode.UNDEFINED_PARAMETER, argName);
                break;
            }
            if (Symbols.isFlagOn(varSym.flags, 0x400000000L)) {
                this.populateIncludedRecordParams(varSym, hashSet, includedRecordParamFieldNames);
            } else {
                namedArgs.add(arg);
            }
            requiredParams.remove(varSym);
            requiredIncRecordParams.remove(varSym);
            if (valueProvidedParams.contains(varSym)) {
                this.dlog.error(arg.pos, DiagnosticErrorCode.DUPLICATE_NAMED_ARGS, varSym.name.value);
                continue;
            }
            this.checkTypeParamExpr(arg, varSym.type, iExpr.langLibInvocation, data);
            ((BLangNamedArgsExpression)arg).varSymbol = varSym;
            valueProvidedParams.add(varSym);
        }
        this.checkSameNamedArgsInIncludedRecords(namedArgs, hashSet);
        BVarSymbol restParam = invokableTypeSymbol.restParam;
        boolean errored = false;
        if (!requiredParams.isEmpty() && vararg == null) {
            for (BVarSymbol requiredParam : requiredParams) {
                if (Symbols.isFlagOn(Flags.asMask(requiredParam.getFlags()), 0x400000000L)) continue;
                this.dlog.error(iExpr.pos, DiagnosticErrorCode.MISSING_REQUIRED_PARAMETER, requiredParam.name, iExpr.name.value);
                errored = true;
            }
        }
        if (!requiredIncRecordParams.isEmpty() && !requiredParams.isEmpty()) {
            for (BVarSymbol requiredIncRecordParam : requiredIncRecordParams) {
                for (BVarSymbol requiredParam : requiredParams) {
                    if (Types.getImpliedType(requiredParam.type) != Types.getImpliedType(requiredIncRecordParam.owner.type)) continue;
                    this.dlog.error(iExpr.pos, DiagnosticErrorCode.MISSING_REQUIRED_PARAMETER, requiredIncRecordParam.name, iExpr.name.value);
                    errored = true;
                }
            }
        }
        if (restParam == null && (!iExpr.restArgs.isEmpty() || vararg != null && valueProvidedParams.size() == nonRestParams.size())) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.TOO_MANY_ARGS_FUNC_CALL, iExpr.name.value);
            errored = true;
        }
        if (errored) {
            return this.symTable.semanticError;
        }
        BType listTypeRestArg = restParam == null ? null : restParam.type;
        BType referredListTypeRestArg = Types.getImpliedType(listTypeRestArg);
        BRecordType mappingTypeRestArg = null;
        if (vararg != null && nonRestArgs.size() < nonRestParams.size()) {
            PackageID pkgID = data.env.enclPkg.symbol.pkgID;
            ArrayList<BTupleMember> tupleMembers = new ArrayList<BTupleMember>();
            BRecordTypeSymbol recordSymbol = this.createRecordTypeSymbol(pkgID, null, SymbolOrigin.VIRTUAL, data);
            mappingTypeRestArg = new BRecordType(this.typeEnv, (BTypeSymbol)recordSymbol);
            LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
            BType tupleRestType = null;
            for (int j = nonRestArgs.size(); j < nonRestParams.size(); ++j) {
                BType paramType = paramTypes.get(j);
                BVarSymbol nonRestParam = (BVarSymbol)nonRestParams.get(j);
                Name paramName = nonRestParam.name;
                BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(paramType);
                tupleMembers.add(new BTupleMember(paramType, varSymbol));
                final boolean required = requiredParams.contains(nonRestParam);
                BVarSymbol fieldSymbol = new BVarSymbol(Flags.asMask((Set<Flag>)new HashSet<Flag>(){
                    {
                        this.add(required ? Flag.REQUIRED : Flag.OPTIONAL);
                    }
                }), paramName, nonRestParam.getOriginalName(), pkgID, paramType, (BSymbol)recordSymbol, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
                fields.put(paramName.value, new BField(paramName, null, fieldSymbol));
            }
            if (referredListTypeRestArg != null) {
                if (referredListTypeRestArg.tag == 20) {
                    tupleRestType = ((BArrayType)referredListTypeRestArg).eType;
                } else if (referredListTypeRestArg.tag == 31) {
                    BTupleType restTupleType = (BTupleType)referredListTypeRestArg;
                    tupleMembers.addAll(restTupleType.getMembers());
                    restTupleType.getMembers().forEach(t -> tupleMembers.add((BTupleMember)t));
                    if (restTupleType.restType != null) {
                        tupleRestType = restTupleType.restType;
                    }
                }
            }
            BTupleType tupleType = new BTupleType(this.typeEnv, tupleMembers);
            tupleType.restType = tupleRestType;
            listTypeRestArg = tupleType;
            referredListTypeRestArg = tupleType;
            mappingTypeRestArg.sealed = true;
            mappingTypeRestArg.restFieldType = this.symTable.noType;
            mappingTypeRestArg.fields = fields;
            recordSymbol.type = mappingTypeRestArg;
            mappingTypeRestArg.tsymbol = recordSymbol;
        }
        if (!(listTypeRestArg != null || vararg == null && iExpr.restArgs.isEmpty())) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.TOO_MANY_ARGS_FUNC_CALL, iExpr.name.value);
            return this.symTable.semanticError;
        }
        BType restType = null;
        if (vararg != null && !iExpr.restArgs.isEmpty()) {
            elementType = ((BArrayType)referredListTypeRestArg).eType;
            for (BLangExpression restArg : iExpr.restArgs) {
                this.checkTypeParamExpr(restArg, elementType, true, data);
            }
            this.checkTypeParamExpr(vararg, listTypeRestArg, iExpr.langLibInvocation, data);
            iExpr.restArgs.add(vararg);
            restType = data.resultType;
        } else if (vararg != null) {
            iExpr.restArgs.add(vararg);
            if (mappingTypeRestArg != null) {
                LinkedHashSet<BType> restTypes = new LinkedHashSet<BType>();
                restTypes.add(listTypeRestArg);
                restTypes.add(mappingTypeRestArg);
                BUnionType actualType = BUnionType.create(this.typeEnv, null, restTypes);
                this.checkTypeParamExpr(vararg, actualType, iExpr.langLibInvocation, data);
            } else {
                this.checkTypeParamExpr(vararg, listTypeRestArg, iExpr.langLibInvocation, data);
            }
            restType = data.resultType;
        } else if (!iExpr.restArgs.isEmpty()) {
            if (referredListTypeRestArg.tag == 20) {
                elementType = ((BArrayType)referredListTypeRestArg).eType;
                for (BLangExpression restArg : iExpr.restArgs) {
                    this.checkTypeParamExpr(restArg, elementType, true, data);
                    if (restType == this.symTable.semanticError || data.resultType != this.symTable.semanticError) continue;
                    restType = data.resultType;
                }
            } else if (referredListTypeRestArg.tag == 31) {
                BTupleType tupleType = (BTupleType)referredListTypeRestArg;
                List<BType> tupleMemberTypes = tupleType.getTupleTypes();
                BType tupleRestType = tupleType.restType;
                int tupleMemCount = tupleMemberTypes.size();
                for (int j = 0; j < iExpr.restArgs.size(); ++j) {
                    BLangExpression restArg = iExpr.restArgs.get(j);
                    BType memType = j < tupleMemCount ? tupleMemberTypes.get(j) : tupleRestType;
                    this.checkTypeParamExpr(restArg, memType, true, data);
                    if (restType == this.symTable.semanticError || data.resultType != this.symTable.semanticError) continue;
                    restType = data.resultType;
                }
            } else {
                for (BLangExpression restArg : iExpr.restArgs) {
                    this.checkExpr(restArg, this.symTable.semanticError, data);
                }
                data.resultType = this.symTable.semanticError;
            }
        }
        BType retType = this.typeParamAnalyzer.getReturnTypeParams(data.env, bInvokableType.getReturnType());
        long invokableSymbolFlags = invokableSymbol.flags;
        if (restType != this.symTable.semanticError && (Symbols.isFlagOn(invokableSymbolFlags, 128L) || Symbols.isFlagOn(invokableSymbolFlags, 2L)) && Symbols.isFlagOn(retType.getFlags(), 0x4000000L)) {
            retType = this.unifier.build(this.typeEnv, retType, data.expType, iExpr, this.types, this.symTable, this.dlog);
        }
        boolean langLibPackageID = PackageID.isLangLibPackageID(iExpr.symbol.pkgID);
        String sortFuncName = "sort";
        if (langLibPackageID && sortFuncName.equals(iExpr.name.value)) {
            this.checkArrayLibSortFuncArgs(iExpr);
        }
        if (iExpr instanceof ActionNode && iExpr.async) {
            return this.generateFutureType(invokableSymbol, retType);
        }
        return retType;
    }

    private void populateIncludedRecordParams(BVarSymbol param, HashSet<String> includedRecordFields, List<String> includedRecordParamNames) {
        BType paramType = Types.getImpliedType(param.type);
        if (paramType.tag != 12) {
            return;
        }
        Set fields = ((BRecordType)paramType).fields.keySet();
        for (String field : fields) {
            if (!includedRecordParamNames.contains(field)) continue;
            includedRecordFields.add(field);
        }
    }

    private void checkSameNamedArgsInIncludedRecords(List<BLangExpression> namedArgs, HashSet<String> incRecordFields) {
        if (incRecordFields.isEmpty()) {
            return;
        }
        for (BLangExpression namedArg : namedArgs) {
            String argName = ((NamedArgNode)((Object)namedArg)).getName().value;
            if (!incRecordFields.contains(argName)) continue;
            this.dlog.error(namedArg.pos, DiagnosticErrorCode.CANNOT_SPECIFY_NAMED_ARG_FOR_FIELD_OF_INCLUDED_RECORD_WHEN_ARG_SPECIFIED_FOR_INCLUDED_RECORD, new Object[0]);
        }
    }

    private void checkArrayLibSortFuncArgs(BLangInvocation iExpr) {
        BType returnType;
        Location pos;
        List<BLangExpression> argExprs = iExpr.argExprs;
        BLangExpression keyFunction = null;
        for (int i = 0; i < argExprs.size(); ++i) {
            BLangExpression arg = argExprs.get(i);
            if (arg.getKind() == NodeKind.NAMED_ARGS_EXPR) {
                BLangNamedArgsExpression argExpr = (BLangNamedArgsExpression)arg;
                if (!argExpr.name.value.equals("key")) continue;
                keyFunction = argExpr.expr;
                break;
            }
            if (i != 2) continue;
            keyFunction = arg;
            break;
        }
        BLangExpression arrExpr = argExprs.get(0);
        BType arrType = arrExpr.getBType();
        boolean isOrderedType = this.types.isOrderedType(arrType);
        if (keyFunction == null) {
            if (!isOrderedType) {
                this.dlog.error(arrExpr.pos, DiagnosticErrorCode.INVALID_SORT_ARRAY_MEMBER_TYPE, arrType);
            }
            return;
        }
        BType keyFunctionType = Types.getImpliedType(keyFunction.getBType());
        if (keyFunctionType.tag == 28) {
            return;
        }
        if (keyFunctionType.tag == 10) {
            if (!isOrderedType) {
                this.dlog.error(arrExpr.pos, DiagnosticErrorCode.INVALID_SORT_ARRAY_MEMBER_TYPE, arrType);
            }
            return;
        }
        if (keyFunction.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            pos = keyFunction.pos;
            returnType = keyFunction.getBType().getReturnType();
        } else if (keyFunction.getKind() == NodeKind.ARROW_EXPR) {
            BLangArrowFunction arrowFunction = (BLangArrowFunction)keyFunction;
            pos = arrowFunction.body.expr.pos;
            returnType = arrowFunction.body.expr.getBType();
            if (returnType.tag == 28) {
                return;
            }
        } else {
            BLangLambdaFunction keyLambdaFunction = (BLangLambdaFunction)keyFunction;
            pos = keyLambdaFunction.function.pos;
            returnType = keyLambdaFunction.function.getBType().getReturnType();
        }
        if (!this.types.isOrderedType(returnType)) {
            this.dlog.error(pos, DiagnosticErrorCode.INVALID_SORT_FUNC_RETURN_TYPE, returnType);
        }
    }

    private BVarSymbol checkParameterNameForDefaultArgument(BLangIdentifier argName, BLangExpression expr, List<BVarSymbol> nonRestParams, List<BVarSymbol> incRecordParams, BVarSymbol incRecordParamAllowAdditionalFields, AnalyzerData data) {
        for (BVarSymbol nonRestParam : nonRestParams) {
            if (!nonRestParam.getName().value.equals(argName.value)) continue;
            return nonRestParam;
        }
        for (BVarSymbol incRecordParam : incRecordParams) {
            if (!incRecordParam.getName().value.equals(argName.value)) continue;
            return incRecordParam;
        }
        if (incRecordParamAllowAdditionalFields != null) {
            BRecordType incRecordType = (BRecordType)Types.getImpliedType(incRecordParamAllowAdditionalFields.type);
            this.checkExpr(expr, incRecordType.restFieldType, data);
            if (!incRecordType.fields.containsKey(argName.value)) {
                return new BVarSymbol(0L, this.names.fromIdNode(argName), this.names.originalNameFromIdNode(argName), null, this.symTable.noType, null, argName.pos, SymbolOrigin.VIRTUAL);
            }
        }
        return null;
    }

    private BFutureType generateFutureType(BInvokableSymbol invocableSymbol, BType retType) {
        boolean isWorkerStart = Symbols.isFlagOn(invocableSymbol.flags, 0x800000L);
        return new BFutureType(this.typeEnv, retType, null, isWorkerStart);
    }

    protected void checkTypeParamExpr(BLangExpression arg, BType expectedType, AnalyzerData data) {
        this.checkTypeParamExpr(arg, expectedType, true, data);
    }

    private void checkTypeParamExpr(BLangExpression arg, BType expectedType, boolean inferTypeForNumericLiteral, AnalyzerData data) {
        this.checkTypeParamExpr(arg.pos, arg, expectedType, inferTypeForNumericLiteral, data);
    }

    private void checkTypeParamExpr(Location pos, BLangExpression arg, BType expectedType, boolean inferTypeForNumericLiteral, AnalyzerData data) {
        SymbolEnv env = data.env;
        if (this.typeParamAnalyzer.notRequireTypeParams(env)) {
            this.checkExpr(arg, expectedType, data);
            return;
        }
        if (this.requireTypeInference(arg, inferTypeForNumericLiteral)) {
            BType expType = this.typeParamAnalyzer.getMatchingBoundType(expectedType, env);
            BType inferredType = this.checkExpr(arg, expType, data);
            this.typeParamAnalyzer.checkForTypeParamsInArg(arg, pos, inferredType, data.env, expectedType);
            this.types.checkType(arg.pos, inferredType, expectedType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
            return;
        }
        this.checkExpr(arg, expectedType, data);
        this.typeParamAnalyzer.checkForTypeParamsInArg(arg, pos, arg.getBType(), data.env, expectedType);
    }

    private boolean requireTypeInference(BLangExpression expr, boolean inferTypeForNumericLiteral) {
        return switch (expr.getKind()) {
            case NodeKind.GROUP_EXPR -> this.requireTypeInference(((BLangGroupExpr)expr).expression, inferTypeForNumericLiteral);
            case NodeKind.TABLE_CONSTRUCTOR_EXPR, NodeKind.LIST_CONSTRUCTOR_EXPR, NodeKind.RECORD_LITERAL_EXPR, NodeKind.ARROW_EXPR, NodeKind.OBJECT_CTOR_EXPRESSION, NodeKind.RAW_TEMPLATE_LITERAL, NodeKind.TYPE_INIT_EXPR, NodeKind.ERROR_CONSTRUCTOR_EXPRESSION -> true;
            case NodeKind.NUMERIC_LITERAL, NodeKind.TERNARY_EXPR, NodeKind.ELVIS_EXPR -> inferTypeForNumericLiteral;
            default -> false;
        };
    }

    private boolean isNotObjectConstructorWithObjectSuperTypeInTypeCastExpr(BLangExpression expression, BType targetType) {
        if (expression.getKind() != NodeKind.OBJECT_CTOR_EXPRESSION) {
            return true;
        }
        targetType = Types.getImpliedType(targetType);
        int tag = targetType.tag;
        if (tag == 34) {
            return !this.isAllObjectsObjectType((BObjectType)targetType);
        }
        if (tag != 21) {
            return false;
        }
        for (BType memberType : ((BUnionType)targetType).getMemberTypes()) {
            memberType = Types.getImpliedType(memberType);
            if (memberType.tag != 34 || !this.isAllObjectsObjectType((BObjectType)memberType)) continue;
            return false;
        }
        return true;
    }

    private boolean isAllObjectsObjectType(BObjectType objectType) {
        return objectType.fields.isEmpty() && ((BObjectTypeSymbol)objectType.tsymbol).attachedFuncs.isEmpty();
    }

    private BType checkMappingField(RecordLiteralNode.RecordField field, BType mappingType, AnalyzerData data) {
        BType fieldType = this.symTable.semanticError;
        boolean keyValueField = field.isKeyValueField();
        boolean spreadOpField = field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP;
        boolean readOnlyConstructorField = false;
        String fieldName = null;
        Location pos = null;
        BLangExpression valueExpr = null;
        if (keyValueField) {
            valueExpr = ((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr;
        } else if (!spreadOpField) {
            valueExpr = (BLangRecordLiteral.BLangRecordVarNameField)field;
        }
        boolean isOptional = false;
        switch (mappingType.tag) {
            case 12: {
                if (keyValueField) {
                    BLangRecordLiteral.BLangRecordKeyValueField keyValField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                    BLangRecordLiteral.BLangRecordKey key = keyValField.key;
                    TypeSymbolPair typeSymbolPair = this.checkRecordLiteralKeyExpr(key.expr, key.computedKey, (BRecordType)mappingType, data);
                    BVarSymbol fieldSymbol = typeSymbolPair.fieldSymbol;
                    if (fieldSymbol != null && Symbols.isOptional(fieldSymbol)) {
                        isOptional = true;
                    }
                    fieldType = typeSymbolPair.determinedType;
                    key.fieldSymbol = fieldSymbol;
                    readOnlyConstructorField = keyValField.readonly;
                    pos = key.expr.pos;
                    fieldName = this.getKeyValueFieldName(keyValField);
                    break;
                }
                if (spreadOpField) {
                    BLangExpression spreadExpr = ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr;
                    this.checkExpr(spreadExpr, data);
                    BRecordType mappingRecordType = (BRecordType)mappingType;
                    BType spreadExprType = Types.getImpliedType(spreadExpr.getBType());
                    if (spreadExprType.tag == 16) {
                        return this.types.checkType(spreadExpr.pos, ((BMapType)spreadExprType).constraint, this.getAllFieldType(mappingRecordType), (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
                    }
                    if (spreadExprType.tag != 12) {
                        this.dlog.error(spreadExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES_SPREAD_OP, spreadExprType);
                        return this.symTable.semanticError;
                    }
                    BRecordType spreadRecordType = (BRecordType)spreadExprType;
                    boolean errored = false;
                    for (BField bField : spreadRecordType.fields.values()) {
                        BSymbol fieldSymbol;
                        BType expectedFieldType;
                        BType specFieldType = bField.type;
                        if (this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(specFieldType) || (expectedFieldType = this.checkRecordLiteralKeyByName(spreadExpr.pos, fieldSymbol = this.symResolver.resolveStructField(spreadExpr.pos, data.env, bField.name, mappingType.tsymbol), bField.name, mappingRecordType)) == this.symTable.semanticError || this.types.isAssignable(specFieldType, expectedFieldType)) continue;
                        this.dlog.error(spreadExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES_FIELD, expectedFieldType, bField.name, specFieldType);
                        if (errored) continue;
                        errored = true;
                    }
                    if (!spreadRecordType.sealed) {
                        if (mappingRecordType.sealed) {
                            this.dlog.error(spreadExpr.pos, DiagnosticErrorCode.INVALID_SPREAD_FIELD_TO_CREATE_CLOSED_RECORD_FROM_OPEN_RECORD, spreadRecordType);
                            errored = true;
                        } else if (!this.types.isAssignable(spreadRecordType.restFieldType, mappingRecordType.restFieldType)) {
                            this.dlog.error(spreadExpr.pos, DiagnosticErrorCode.INVALID_SPREAD_FIELD_REST_FIELD_MISMATCH, spreadRecordType, spreadRecordType.restFieldType, mappingRecordType.restFieldType);
                            errored = true;
                        }
                    }
                    return errored ? this.symTable.semanticError : this.symTable.noType;
                }
                BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                TypeSymbolPair typeSymbolPair = this.checkRecordLiteralKeyExpr(varNameField, false, (BRecordType)mappingType, data);
                BVarSymbol fieldSymbol = typeSymbolPair.fieldSymbol;
                if (fieldSymbol != null && Symbols.isOptional(fieldSymbol)) {
                    isOptional = true;
                }
                fieldType = typeSymbolPair.determinedType;
                readOnlyConstructorField = varNameField.readonly;
                pos = varNameField.pos;
                fieldName = this.getVarNameFieldName(varNameField);
                break;
            }
            case 16: {
                boolean validMapKey;
                if (spreadOpField) {
                    BLangExpression spreadExp = ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr;
                    BType spreadOpType = this.checkExpr(spreadExp, data);
                    BType spreadOpMemberType = this.checkSpreadFieldWithMapType(spreadOpType);
                    if (spreadOpMemberType.tag == this.symTable.semanticError.tag) {
                        this.dlog.error(spreadExp.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES_SPREAD_OP, spreadOpType);
                        return this.symTable.semanticError;
                    }
                    return this.types.checkType(spreadExp.pos, spreadOpMemberType, ((BMapType)mappingType).constraint, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
                }
                if (keyValueField) {
                    BLangRecordLiteral.BLangRecordKeyValueField keyValField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                    BLangRecordLiteral.BLangRecordKey key = keyValField.key;
                    validMapKey = this.checkValidJsonOrMapLiteralKeyExpr(key.expr, key.computedKey, data);
                    readOnlyConstructorField = keyValField.readonly;
                    pos = key.pos;
                    fieldName = this.getKeyValueFieldName(keyValField);
                } else {
                    BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                    validMapKey = this.checkValidJsonOrMapLiteralKeyExpr(varNameField, false, data);
                    readOnlyConstructorField = varNameField.readonly;
                    pos = varNameField.pos;
                    fieldName = this.getVarNameFieldName(varNameField);
                }
                BType bType = fieldType = validMapKey ? ((BMapType)mappingType).constraint : this.symTable.semanticError;
            }
        }
        if (readOnlyConstructorField) {
            if (this.types.isSelectivelyImmutableType(fieldType, data.env.enclPkg.packageID)) {
                fieldType = ImmutableTypeCloner.getImmutableIntersectionType(pos, this.types, fieldType, data.env, this.symTable, this.anonymousModelHelper, this.names, new HashSet<Flag>());
            } else if (!this.types.isInherentlyImmutableType(fieldType)) {
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_READONLY_MAPPING_FIELD, fieldName, fieldType);
                fieldType = this.symTable.semanticError;
            }
        }
        if (spreadOpField) {
            valueExpr = ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr;
        }
        BLangExpression exprToCheck = valueExpr;
        if (data.commonAnalyzerData.nonErrorLoggingCheck) {
            exprToCheck = this.nodeCloner.cloneNode(valueExpr);
        } else {
            ((BLangNode)((Object)field)).setBType(fieldType);
        }
        return this.checkExpr(exprToCheck, data.env, isOptional ? this.types.addNilForNillableAccessType(fieldType) : fieldType, data);
    }

    private BType checkSpreadFieldWithMapType(BType spreadOpType) {
        spreadOpType = Types.getImpliedType(spreadOpType);
        switch (spreadOpType.tag) {
            case 12: {
                ArrayList<BType> types = new ArrayList<BType>();
                BRecordType recordType = (BRecordType)spreadOpType;
                for (BField recField : recordType.fields.values()) {
                    types.add(recField.type);
                }
                if (!recordType.sealed) {
                    types.add(recordType.restFieldType);
                }
                return this.getRepresentativeBroadType(types);
            }
            case 16: {
                return ((BMapType)spreadOpType).constraint;
            }
        }
        return this.symTable.semanticError;
    }

    private TypeSymbolPair checkRecordLiteralKeyExpr(BLangExpression keyExpr, boolean computedKey, BRecordType recordType, AnalyzerData data) {
        Name fieldName;
        if (computedKey) {
            this.checkExpr(keyExpr, this.symTable.stringType, data);
            if (keyExpr.getBType() == this.symTable.semanticError) {
                return new TypeSymbolPair(null, this.symTable.semanticError);
            }
            LinkedHashSet fieldTypes = recordType.fields.values().stream().map(field -> field.type).collect(Collectors.toCollection(LinkedHashSet::new));
            if (recordType.restFieldType.tag != 24) {
                fieldTypes.add(recordType.restFieldType);
            }
            return new TypeSymbolPair(null, BUnionType.create(this.typeEnv, null, fieldTypes));
        }
        if (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)keyExpr;
            fieldName = this.names.fromIdNode(varRef.variableName);
        } else if (keyExpr.getKind() == NodeKind.LITERAL && keyExpr.getBType().tag == 5) {
            fieldName = Names.fromString((String)((BLangLiteral)keyExpr).value);
        } else {
            this.dlog.error(keyExpr.pos, DiagnosticErrorCode.INVALID_RECORD_LITERAL_KEY, new Object[0]);
            return new TypeSymbolPair(null, this.symTable.semanticError);
        }
        BSymbol fieldSymbol = this.symResolver.resolveStructField(keyExpr.pos, data.env, fieldName, recordType.tsymbol);
        BType type = this.checkRecordLiteralKeyByName(keyExpr.pos, fieldSymbol, fieldName, recordType);
        return new TypeSymbolPair(fieldSymbol instanceof BVarSymbol ? (BVarSymbol)fieldSymbol : null, type);
    }

    private BType checkRecordLiteralKeyByName(Location location, BSymbol fieldSymbol, Name key, BRecordType recordType) {
        if (fieldSymbol != this.symTable.notFoundSymbol) {
            return fieldSymbol.type;
        }
        if (recordType.sealed) {
            this.dlog.error(location, DiagnosticErrorCode.UNDEFINED_STRUCTURE_FIELD_WITH_TYPE, key, recordType.tsymbol.type.getKind().typeName(), recordType);
            return this.symTable.semanticError;
        }
        return recordType.restFieldType;
    }

    private BType getAllFieldType(BRecordType recordType) {
        LinkedHashSet<BType> possibleTypes = new LinkedHashSet<BType>();
        for (BField field : recordType.fields.values()) {
            possibleTypes.add(field.type);
        }
        BType restFieldType = recordType.restFieldType;
        if (restFieldType != null && restFieldType != this.symTable.noType) {
            possibleTypes.add(restFieldType);
        }
        return BUnionType.create(this.typeEnv, null, possibleTypes);
    }

    private boolean checkValidJsonOrMapLiteralKeyExpr(BLangExpression keyExpr, boolean computedKey, AnalyzerData data) {
        if (computedKey) {
            this.checkExpr(keyExpr, this.symTable.stringType, data);
            return keyExpr.getBType() != this.symTable.semanticError;
        }
        if (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF || keyExpr.getKind() == NodeKind.LITERAL && keyExpr.getBType().tag == 5) {
            return true;
        }
        this.dlog.error(keyExpr.pos, DiagnosticErrorCode.INVALID_RECORD_LITERAL_KEY, new Object[0]);
        return false;
    }

    private BType checkRecordRequiredFieldAccess(BLangAccessExpression varReferExpr, Name fieldName, BRecordType recordType, AnalyzerData data) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(varReferExpr.pos, data.env, fieldName, recordType.tsymbol);
        if (Symbols.isOptional(fieldSymbol) || fieldSymbol == this.symTable.notFoundSymbol) {
            return this.symTable.semanticError;
        }
        varReferExpr.symbol = fieldSymbol;
        return fieldSymbol.type;
    }

    private BType checkRecordOptionalFieldAccess(BLangAccessExpression varReferExpr, Name fieldName, BRecordType recordType, AnalyzerData data) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(varReferExpr.pos, data.env, fieldName, recordType.tsymbol);
        if (fieldSymbol == this.symTable.notFoundSymbol || !Symbols.isOptional(fieldSymbol)) {
            return this.symTable.semanticError;
        }
        varReferExpr.symbol = fieldSymbol;
        return fieldSymbol.type;
    }

    private BType checkRecordRestFieldAccess(BLangAccessExpression varReferExpr, Name fieldName, BRecordType recordType, AnalyzerData data) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(varReferExpr.pos, data.env, fieldName, recordType.tsymbol);
        if (fieldSymbol != this.symTable.notFoundSymbol) {
            return this.symTable.semanticError;
        }
        if (recordType.sealed) {
            return this.symTable.semanticError;
        }
        return recordType.restFieldType;
    }

    private BType checkObjectFieldAccess(BLangFieldBasedAccess bLangFieldBasedAccess, Name fieldName, BObjectType objectType, AnalyzerData data) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(bLangFieldBasedAccess.pos, data.env, fieldName, objectType.tsymbol);
        if (fieldSymbol != this.symTable.notFoundSymbol) {
            bLangFieldBasedAccess.symbol = fieldSymbol;
            return fieldSymbol.type;
        }
        Name objFuncName = Names.fromString(Symbols.getAttachedFuncSymbolName(objectType.tsymbol.name.value, fieldName.value));
        fieldSymbol = this.symResolver.resolveObjectField(bLangFieldBasedAccess.pos, data.env, objFuncName, objectType.tsymbol);
        if (fieldSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(bLangFieldBasedAccess.field.pos, DiagnosticErrorCode.UNDEFINED_STRUCTURE_FIELD_WITH_TYPE, fieldName, objectType.tsymbol.type.getKind().typeName(), objectType.tsymbol);
            return this.symTable.semanticError;
        }
        if (Symbols.isFlagOn(fieldSymbol.flags, 32768L)) {
            this.dlog.error(bLangFieldBasedAccess.field.pos, DiagnosticErrorCode.CANNOT_USE_FIELD_ACCESS_TO_ACCESS_A_REMOTE_METHOD, new Object[0]);
            return this.symTable.semanticError;
        }
        if (Symbols.isFlagOn(fieldSymbol.type.getFlags(), 0x20000000L) && !Symbols.isFlagOn(objectType.getFlags(), 0x20000000L)) {
            fieldSymbol = ASTBuilderUtil.duplicateInvokableSymbol(this.typeEnv, (BInvokableSymbol)fieldSymbol);
            fieldSymbol.flags &= 0xFFFFFFFFDFFFFFFFL;
            fieldSymbol.type.setFlags(fieldSymbol.type.getFlags() & 0xFFFFFFFFDFFFFFFFL);
        }
        bLangFieldBasedAccess.symbol = fieldSymbol;
        return fieldSymbol.type;
    }

    private BType checkTupleFieldType(BType tupleType, int indexValue) {
        BTupleType bTupleType = (BTupleType)tupleType;
        List<BType> tupleMemberTypes = bTupleType.getTupleTypes();
        if (tupleMemberTypes.size() <= indexValue && bTupleType.restType != null) {
            return bTupleType.restType;
        }
        if (indexValue < 0 || tupleMemberTypes.size() <= indexValue) {
            return this.symTable.semanticError;
        }
        return tupleMemberTypes.get(indexValue);
    }

    private void validateTags(BLangXMLElementLiteral bLangXMLElementLiteral, SymbolEnv xmlElementEnv, AnalyzerData data) {
        BLangExpression startTagName = bLangXMLElementLiteral.startTagName;
        this.checkExpr(startTagName, xmlElementEnv, this.symTable.stringType, data);
        BLangExpression endTagName = bLangXMLElementLiteral.endTagName;
        if (endTagName == null) {
            return;
        }
        this.checkExpr(endTagName, xmlElementEnv, this.symTable.stringType, data);
        if (startTagName.getKind() == NodeKind.XML_QNAME && endTagName.getKind() == NodeKind.XML_QNAME && startTagName.equals(endTagName)) {
            return;
        }
        if (startTagName.getKind() != NodeKind.XML_QNAME && endTagName.getKind() != NodeKind.XML_QNAME) {
            return;
        }
        this.dlog.error(bLangXMLElementLiteral.pos, DiagnosticErrorCode.XML_TAGS_MISMATCH, new Object[0]);
    }

    private void checkStringTemplateExprs(List<? extends BLangExpression> exprs, AnalyzerData data) {
        for (BLangExpression bLangExpression : exprs) {
            this.checkExpr(bLangExpression, data);
            BType type = bLangExpression.getBType();
            if (type == this.symTable.semanticError || this.types.isNonNilSimpleBasicTypeOrString(type)) continue;
            this.dlog.error(bLangExpression.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.interpolationAllowedType, type);
        }
    }

    private List<BLangExpression> concatSimilarKindXMLNodes(List<BLangExpression> exprs, SymbolEnv xmlElementEnv, AnalyzerData data) {
        ArrayList<BLangExpression> newChildren = new ArrayList<BLangExpression>();
        ArrayList<BLangExpression> tempConcatExpressions = new ArrayList<BLangExpression>();
        for (BLangExpression expr : exprs) {
            boolean prevNonErrorLoggingCheck = data.commonAnalyzerData.nonErrorLoggingCheck;
            data.commonAnalyzerData.nonErrorLoggingCheck = true;
            GlobalStateSnapshot previousGlobalState = this.getGlobalStateSnapshotAndResetGlobalState();
            this.dlog.mute();
            BType exprType = this.checkExpr(this.nodeCloner.cloneNode(expr), xmlElementEnv, this.symTable.xmlType, data);
            data.commonAnalyzerData.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
            int errorCount = this.dlog.errorCount();
            this.restoreGlobalState(previousGlobalState);
            if (!prevNonErrorLoggingCheck) {
                this.dlog.unmute();
            }
            exprType = errorCount == 0 && exprType != this.symTable.semanticError ? this.checkExpr(expr, xmlElementEnv, this.symTable.xmlType, data) : this.checkExpr(expr, xmlElementEnv, data);
            if (TypeTags.isXMLTypeTag(Types.getImpliedType((BType)exprType).tag)) {
                if (!tempConcatExpressions.isEmpty()) {
                    newChildren.add(this.getXMLTextLiteral(tempConcatExpressions));
                    tempConcatExpressions = new ArrayList();
                }
                newChildren.add(expr);
                continue;
            }
            BType type = expr.getBType();
            BType referredType = Types.getImpliedType(type);
            if (referredType.tag >= 7 && !TypeTags.isIntegerTypeTag(referredType.tag) && !TypeTags.isStringTypeTag(referredType.tag)) {
                if (referredType == this.symTable.semanticError || TypeTags.isXMLTypeTag(referredType.tag)) continue;
                this.dlog.error(expr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, BUnionType.create(this.typeEnv, null, this.symTable.intType, this.symTable.floatType, this.symTable.decimalType, this.symTable.stringType, this.symTable.booleanType, this.symTable.xmlType), type);
                continue;
            }
            tempConcatExpressions.add(expr);
        }
        if (!tempConcatExpressions.isEmpty()) {
            newChildren.add(this.getXMLTextLiteral(tempConcatExpressions));
        }
        return newChildren;
    }

    private BLangExpression getXMLTextLiteral(List<BLangExpression> exprs) {
        BLangXMLTextLiteral xmlTextLiteral = (BLangXMLTextLiteral)TreeBuilder.createXMLTextLiteralNode();
        xmlTextLiteral.textFragments = exprs;
        xmlTextLiteral.pos = exprs.get((int)0).pos;
        xmlTextLiteral.setBType(this.symTable.xmlType);
        return xmlTextLiteral;
    }

    private boolean returnsNull(BLangAccessExpression accessExpr) {
        BType parentType = Types.getImpliedType(accessExpr.expr.getBType());
        if (parentType.isNullable() && parentType.tag != 7) {
            return true;
        }
        if (parentType.tag != 16) {
            return false;
        }
        if (accessExpr.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR && parentType.tag == 16) {
            BType constraintType = Types.getImpliedType(((BMapType)parentType).constraint);
            return constraintType != null && constraintType.tag != 18 && constraintType.tag != 7;
        }
        return false;
    }

    private BType checkObjectFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName, AnalyzerData data) {
        varRefType = Types.getImpliedType(varRefType);
        if (varRefType.tag == 34) {
            return this.checkObjectFieldAccess(fieldAccessExpr, fieldName, (BObjectType)varRefType, data);
        }
        Set memberTypes = ((BUnionType)varRefType).getMemberTypes();
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : memberTypes) {
            BType individualFieldType = this.checkObjectFieldAccess(fieldAccessExpr, fieldName, (BObjectType)memType, data);
            if (individualFieldType == this.symTable.semanticError) {
                return individualFieldType;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(this.typeEnv, null, fieldTypeMembers);
    }

    private BType checkRecordFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType type, Name fieldName, AnalyzerData data) {
        BType varRefType = Types.getImpliedType(type);
        if (varRefType.tag == 12) {
            BSymbol fieldSymbol = this.symResolver.resolveStructField(fieldAccessExpr.pos, data.env, fieldName, varRefType.tsymbol);
            if (Symbols.isOptional(fieldSymbol) && !fieldSymbol.type.isNullable() && !fieldAccessExpr.isLValue) {
                fieldAccessExpr.symbol = fieldSymbol;
                return this.types.addNilForNillableAccessType(fieldSymbol.type);
            }
            return this.checkRecordRequiredFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType, data);
        }
        Set memberTypes = ((BUnionType)varRefType).getMemberTypes();
        for (BType memType : memberTypes) {
            BSymbol fieldSymbol = this.symResolver.resolveStructField(fieldAccessExpr.pos, data.env, fieldName, memType.tsymbol);
            if (!fieldSymbol.type.isNullable() || !this.isFieldOptionalInRecords((BUnionType)varRefType, fieldName, fieldAccessExpr, data)) continue;
            return this.symTable.semanticError;
        }
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : memberTypes) {
            BType individualFieldType = this.checkRecordFieldAccessExpr(fieldAccessExpr, memType, fieldName, data);
            if (individualFieldType == this.symTable.semanticError) {
                return individualFieldType;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(this.typeEnv, null, fieldTypeMembers);
    }

    private boolean isFieldOptionalInRecords(BUnionType unionType, Name fieldName, BLangFieldBasedAccess fieldAccessExpr, AnalyzerData data) {
        Set memberTypes = unionType.getMemberTypes();
        for (BType memType : memberTypes) {
            BSymbol fieldSymbol = this.symResolver.resolveStructField(fieldAccessExpr.pos, data.env, fieldName, memType.tsymbol);
            if (!Symbols.isOptional(fieldSymbol)) continue;
            return true;
        }
        return false;
    }

    private BType checkRecordFieldAccessLhsExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName, AnalyzerData data) {
        varRefType = Types.getImpliedType(varRefType);
        if (varRefType.tag == 12) {
            BType fieldType = this.checkRecordRequiredFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType, data);
            if (fieldType != this.symTable.semanticError) {
                return fieldType;
            }
            return this.checkRecordOptionalFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType, data);
        }
        Set memberTypes = ((BUnionType)varRefType).getMemberTypes();
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : memberTypes) {
            BType individualFieldType = this.checkRecordFieldAccessLhsExpr(fieldAccessExpr, memType, fieldName, data);
            if (individualFieldType == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(this.typeEnv, null, fieldTypeMembers);
    }

    private BType checkOptionalRecordFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName, AnalyzerData data) {
        BType refType = Types.getImpliedType(varRefType);
        if (refType.tag == 12) {
            BType fieldType = this.checkRecordRequiredFieldAccess(fieldAccessExpr, fieldName, (BRecordType)refType, data);
            if (fieldType != this.symTable.semanticError) {
                return fieldType;
            }
            fieldType = this.checkRecordOptionalFieldAccess(fieldAccessExpr, fieldName, (BRecordType)refType, data);
            if (fieldType == this.symTable.semanticError) {
                return fieldType;
            }
            return this.types.addNilForNillableAccessType(fieldType);
        }
        Set memberTypes = ((BUnionType)refType).getMemberTypes();
        boolean nonMatchedRecordExists = false;
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : memberTypes) {
            BType individualFieldType = this.checkOptionalRecordFieldAccessExpr(fieldAccessExpr, memType, fieldName, data);
            if (individualFieldType == this.symTable.semanticError) {
                nonMatchedRecordExists = true;
                continue;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.isEmpty()) {
            return this.symTable.semanticError;
        }
        BType fieldType = fieldTypeMembers.size() == 1 ? (BType)fieldTypeMembers.iterator().next() : BUnionType.create(this.typeEnv, null, fieldTypeMembers);
        return nonMatchedRecordExists ? this.types.addNilForNillableAccessType(fieldType) : fieldType;
    }

    private RecordUnionDiagnostics checkRecordUnion(BLangFieldBasedAccess fieldAccessExpr, Set<BType> memberTypes, Name fieldName, AnalyzerData data) {
        RecordUnionDiagnostics recordUnionDiagnostics = new RecordUnionDiagnostics();
        for (BType memberType : memberTypes) {
            BRecordType recordMember = (BRecordType)Types.getImpliedType(memberType);
            if (recordMember.getFields().containsKey(fieldName.getValue())) {
                if (!this.isNilableType(fieldAccessExpr, memberType, fieldName, data)) continue;
                recordUnionDiagnostics.nilableInRecords.add(recordMember);
                continue;
            }
            recordUnionDiagnostics.undeclaredInRecords.add(recordMember);
        }
        return recordUnionDiagnostics;
    }

    private boolean isNilableType(BLangFieldBasedAccess fieldAccessExpr, BType memberType, Name fieldName, AnalyzerData data) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(fieldAccessExpr.pos, data.env, fieldName, memberType.tsymbol);
        return fieldSymbol.type.isNullable();
    }

    private void logRhsFieldAccExprErrors(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName, AnalyzerData data) {
        varRefType = Types.getImpliedType(varRefType);
        if (varRefType.tag == 12) {
            BRecordType recordVarRefType = (BRecordType)varRefType;
            boolean isFieldDeclared = recordVarRefType.getFields().containsKey(fieldName.getValue());
            if (isFieldDeclared) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.FIELD_ACCESS_CANNOT_BE_USED_TO_ACCESS_OPTIONAL_FIELDS, new Object[0]);
            } else if (recordVarRefType.sealed) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.UNDECLARED_FIELD_IN_RECORD, fieldName, varRefType);
            } else {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.INVALID_FIELD_ACCESS_IN_RECORD_TYPE, fieldName, varRefType);
            }
        } else {
            Set memberTypes = ((BUnionType)varRefType).getMemberTypes();
            RecordUnionDiagnostics recUnionInfo = this.checkRecordUnion(fieldAccessExpr, memberTypes, fieldName, data);
            if (recUnionInfo.hasNilableAndUndeclared()) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.UNDECLARED_AND_NILABLE_FIELDS_IN_UNION_OF_RECORDS, fieldName, recUnionInfo.recordsToString(recUnionInfo.undeclaredInRecords), recUnionInfo.recordsToString(recUnionInfo.nilableInRecords));
            } else if (recUnionInfo.hasUndeclared()) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.UNDECLARED_FIELD_IN_UNION_OF_RECORDS, fieldName, recUnionInfo.recordsToString(recUnionInfo.undeclaredInRecords));
            } else if (recUnionInfo.hasNilable()) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.NILABLE_FIELD_IN_UNION_OF_RECORDS, fieldName, recUnionInfo.recordsToString(recUnionInfo.nilableInRecords));
            }
        }
    }

    private BType checkFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName, AnalyzerData data) {
        BType actualType = this.symTable.semanticError;
        BType referredVarRefType = Types.getImpliedType(varRefType);
        if (this.types.isSubTypeOfBaseType(varRefType, 34)) {
            fieldAccessExpr.originalType = actualType = this.checkObjectFieldAccessExpr(fieldAccessExpr, varRefType, fieldName, data);
        } else if (this.types.isSubTypeOfBaseType(varRefType, 12)) {
            actualType = this.checkRecordFieldAccessExpr(fieldAccessExpr, varRefType, fieldName, data);
            if (actualType != this.symTable.semanticError) {
                fieldAccessExpr.originalType = actualType;
                return actualType;
            }
            if (!fieldAccessExpr.isLValue) {
                this.logRhsFieldAccExprErrors(fieldAccessExpr, varRefType, fieldName, data);
                return actualType;
            }
            fieldAccessExpr.originalType = actualType = this.checkRecordFieldAccessLhsExpr(fieldAccessExpr, varRefType, fieldName, data);
            if (actualType == this.symTable.semanticError) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.UNDEFINED_STRUCTURE_FIELD_WITH_TYPE, fieldName, varRefType.getKind() == TypeKind.UNION ? "union" : referredVarRefType.getKind().typeName(), varRefType);
            }
        } else if (this.types.isLaxFieldAccessAllowed(varRefType)) {
            if (fieldAccessExpr.isLValue) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_FIELD_ACCESS_FOR_ASSIGNMENT, varRefType);
                return this.symTable.semanticError;
            }
            if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
                this.resolveXMLNamespace((BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess)fieldAccessExpr, data);
            }
            BType laxFieldAccessType = this.getLaxFieldAccessType(varRefType);
            actualType = BUnionType.create(this.typeEnv, null, laxFieldAccessType, this.symTable.errorType);
            fieldAccessExpr.originalType = laxFieldAccessType;
        } else if (fieldAccessExpr.expr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR && this.hasLaxOriginalType((BLangFieldBasedAccess)fieldAccessExpr.expr)) {
            BType laxFieldAccessType = this.getLaxFieldAccessType(((BLangFieldBasedAccess)fieldAccessExpr.expr).originalType);
            if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
                this.resolveXMLNamespace((BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess)fieldAccessExpr, data);
            }
            actualType = BUnionType.create(this.typeEnv, null, laxFieldAccessType, this.symTable.errorType);
            fieldAccessExpr.errorSafeNavigation = true;
            fieldAccessExpr.originalType = laxFieldAccessType;
        } else if (TypeTags.isXMLTypeTag(referredVarRefType.tag)) {
            if (fieldAccessExpr.isLValue) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_XML_SEQUENCE, new Object[0]);
            }
            fieldAccessExpr.originalType = actualType = this.symTable.xmlType;
        } else if (referredVarRefType.tag != 28) {
            this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_FIELD_ACCESS, varRefType);
        }
        return actualType;
    }

    private void resolveXMLNamespace(BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess fieldAccessExpr, AnalyzerData data) {
        BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess prefixedFieldAccess = fieldAccessExpr;
        String nsPrefix = prefixedFieldAccess.prefix.value;
        BSymbol nsSymbol = this.symResolver.lookupSymbolInPrefixSpace(data.env, Names.fromString(nsPrefix));
        if (nsSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(prefixedFieldAccess.prefix.pos, DiagnosticErrorCode.CANNOT_FIND_XML_NAMESPACE, prefixedFieldAccess.prefix);
        } else {
            prefixedFieldAccess.symbol = nsSymbol.getKind() == SymbolKind.PACKAGE ? this.getSymbolOfXmlQualifiedName(prefixedFieldAccess.field.value, prefixedFieldAccess.prefix.value, (BPackageSymbol)nsSymbol, fieldAccessExpr.field.pos, data) : nsSymbol;
        }
    }

    private boolean hasLaxOriginalType(BLangFieldBasedAccess fieldBasedAccess) {
        return fieldBasedAccess.originalType != null && this.types.isLaxFieldAccessAllowed(fieldBasedAccess.originalType);
    }

    private BType getLaxFieldAccessType(BType exprType) {
        exprType = Types.getImpliedType(exprType);
        switch (exprType.tag) {
            case 7: {
                return this.symTable.jsonType;
            }
            case 8: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                return this.symTable.stringType;
            }
            case 16: {
                return ((BMapType)exprType).constraint;
            }
            case 21: {
                BUnionType unionType = (BUnionType)exprType;
                if (this.types.isSameType(Core.createJson((Context)this.types.semTypeCtx), unionType.semType())) {
                    return this.symTable.jsonType;
                }
                LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
                unionType.getMemberTypes().forEach(bType -> memberTypes.add(this.getLaxFieldAccessType((BType)bType)));
                return memberTypes.size() == 1 ? (BType)memberTypes.iterator().next() : BUnionType.create(this.typeEnv, null, memberTypes);
            }
        }
        return this.symTable.semanticError;
    }

    private BType checkOptionalFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName, AnalyzerData data) {
        Set memTypes;
        BType actualType = this.symTable.semanticError;
        boolean nillableExprType = false;
        BType referredType = Types.getImpliedType(varRefType);
        if (referredType.tag == 21 && (memTypes = ((BUnionType)referredType).getMemberTypes()).contains(this.symTable.nilType)) {
            LinkedHashSet<BType> nilRemovedSet = new LinkedHashSet<BType>();
            for (BType bType : memTypes) {
                if (bType != this.symTable.nilType) {
                    nilRemovedSet.add(bType);
                    continue;
                }
                nillableExprType = true;
            }
            BType bType = referredType = nilRemovedSet.size() == 1 ? (BType)nilRemovedSet.iterator().next() : BUnionType.create(this.typeEnv, null, nilRemovedSet);
        }
        if (this.types.isSubTypeOfBaseType(referredType, 12)) {
            actualType = this.checkOptionalRecordFieldAccessExpr(fieldAccessExpr, referredType, fieldName, data);
            if (actualType == this.symTable.semanticError) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_OPTIONAL_FIELD_ACCESS_FOR_FIELD, varRefType, fieldName);
            }
            fieldAccessExpr.nilSafeNavigation = nillableExprType;
            fieldAccessExpr.originalType = fieldAccessExpr.leafNode || !nillableExprType ? actualType : this.types.getTypeWithoutNil(actualType);
        } else if (this.types.isLaxFieldAccessAllowed(referredType)) {
            laxFieldAccessType = this.getLaxFieldAccessType(referredType);
            BType bType = actualType = this.accessCouldResultInError(referredType) ? BUnionType.create(this.typeEnv, null, laxFieldAccessType, this.symTable.errorType) : laxFieldAccessType;
            if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
                this.resolveXMLNamespace((BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess)fieldAccessExpr, data);
            }
            fieldAccessExpr.originalType = laxFieldAccessType;
            fieldAccessExpr.nilSafeNavigation = true;
            nillableExprType = true;
        } else if (fieldAccessExpr.expr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR && this.hasLaxOriginalType((BLangFieldBasedAccess)fieldAccessExpr.expr)) {
            laxFieldAccessType = this.getLaxFieldAccessType(((BLangFieldBasedAccess)fieldAccessExpr.expr).originalType);
            BType bType = actualType = this.accessCouldResultInError(referredType) ? BUnionType.create(this.typeEnv, null, laxFieldAccessType, this.symTable.errorType) : laxFieldAccessType;
            if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
                this.resolveXMLNamespace((BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess)fieldAccessExpr, data);
            }
            fieldAccessExpr.errorSafeNavigation = true;
            fieldAccessExpr.originalType = laxFieldAccessType;
            fieldAccessExpr.nilSafeNavigation = true;
            nillableExprType = true;
        } else if (varRefType.tag != 28) {
            this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_OPTIONAL_FIELD_ACCESS, varRefType);
        }
        if (nillableExprType && actualType != this.symTable.semanticError && !actualType.isNullable()) {
            actualType = BUnionType.create(this.typeEnv, null, actualType, this.symTable.nilType);
        }
        return actualType;
    }

    private boolean accessCouldResultInError(BType bType) {
        SemType s = bType.semType();
        return SemTypes.containsBasicType((SemType)s, (BasicTypeBitSet)PredefinedType.XML) || SemTypes.containsType((Context)this.types.semTypeCtx, (SemType)s, (SemType)Core.createJson((Context)this.types.semTypeCtx));
    }

    private BType checkIndexAccessExpr(BLangIndexBasedAccess indexBasedAccessExpr, AnalyzerData data) {
        Set memTypes;
        BType effectiveType = this.types.getTypeWithEffectiveIntersectionTypes(indexBasedAccessExpr.expr.getBType());
        BType varRefType = Types.getImpliedType(effectiveType);
        boolean nillableExprType = false;
        if (varRefType.tag == 21 && (memTypes = ((BUnionType)varRefType).getMemberTypes()).contains(this.symTable.nilType)) {
            LinkedHashSet<BType> nilRemovedSet = new LinkedHashSet<BType>();
            for (BType bType : memTypes) {
                if (bType != this.symTable.nilType) {
                    nilRemovedSet.add(bType);
                    continue;
                }
                nillableExprType = true;
            }
            if (nillableExprType) {
                BType bType = varRefType = nilRemovedSet.size() == 1 ? (BType)nilRemovedSet.iterator().next() : BUnionType.create(this.typeEnv, null, nilRemovedSet);
                if (!this.types.isSubTypeOfMapping(varRefType.semType())) {
                    this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_MEMBER_ACCESS, indexBasedAccessExpr.expr.getBType());
                    return this.symTable.semanticError;
                }
                if (indexBasedAccessExpr.isLValue || indexBasedAccessExpr.isCompoundAssignmentLValue) {
                    this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_MEMBER_ACCESS_FOR_ASSIGNMENT, indexBasedAccessExpr.expr.getBType());
                    return this.symTable.semanticError;
                }
            }
        }
        BLangExpression indexExpr = indexBasedAccessExpr.indexExpr;
        BType actualType = this.symTable.semanticError;
        if (varRefType == this.symTable.semanticError) {
            indexBasedAccessExpr.indexExpr.setBType(this.symTable.semanticError);
            return this.symTable.semanticError;
        }
        if (this.types.isSubTypeOfMapping(varRefType.semType())) {
            this.checkExpr(indexExpr, this.symTable.stringType, data);
            if (indexExpr.getBType() == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            actualType = this.checkMappingIndexBasedAccess(indexBasedAccessExpr, varRefType, data);
            if (actualType == this.symTable.semanticError) {
                if (this.isConstExpr(indexExpr)) {
                    String fieldName = this.getConstFieldName(indexExpr);
                    this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.UNDEFINED_STRUCTURE_FIELD, fieldName, indexBasedAccessExpr.expr.getBType());
                    return actualType;
                }
                this.dlog.error(indexExpr.pos, DiagnosticErrorCode.INVALID_RECORD_MEMBER_ACCESS_EXPR, indexExpr.getBType());
                return actualType;
            }
            indexBasedAccessExpr.nilSafeNavigation = nillableExprType;
            indexBasedAccessExpr.originalType = indexBasedAccessExpr.leafNode || !nillableExprType ? actualType : this.types.getTypeWithoutNil(actualType);
        } else if (this.types.isSubTypeOfList(varRefType)) {
            this.checkExpr(indexExpr, this.symTable.intType, data);
            if (indexExpr.getBType() == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            indexBasedAccessExpr.originalType = actualType = this.checkListIndexBasedAccess(indexBasedAccessExpr, varRefType);
            if (actualType == this.symTable.semanticError) {
                if (this.isConstExpr(indexExpr)) {
                    this.dlog.error(indexBasedAccessExpr.indexExpr.pos, DiagnosticErrorCode.LIST_INDEX_OUT_OF_RANGE, this.getConstIndex(indexExpr));
                    return actualType;
                }
                this.dlog.error(indexExpr.pos, DiagnosticErrorCode.INVALID_LIST_MEMBER_ACCESS_EXPR, indexExpr.getBType());
                return actualType;
            }
        } else if (this.types.isAssignable(varRefType, this.symTable.stringType)) {
            if (indexBasedAccessExpr.isLValue) {
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_MEMBER_ACCESS_FOR_ASSIGNMENT, indexBasedAccessExpr.expr.getBType());
                return this.symTable.semanticError;
            }
            this.checkExpr(indexExpr, this.symTable.intType, data);
            if (indexExpr.getBType() == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            indexBasedAccessExpr.originalType = this.symTable.charStringType;
            actualType = this.symTable.charStringType;
        } else if (this.types.isAssignable(varRefType, this.symTable.xmlType)) {
            BType xmlMemberAccessType;
            if (indexBasedAccessExpr.isLValue) {
                indexExpr.setBType(this.symTable.semanticError);
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_XML_SEQUENCE, new Object[0]);
                return actualType;
            }
            BType type = this.checkExpr(indexExpr, this.symTable.intType, data);
            if (type == this.symTable.semanticError) {
                return type;
            }
            indexBasedAccessExpr.originalType = xmlMemberAccessType = this.getXmlMemberAccessType(varRefType);
            actualType = xmlMemberAccessType;
        } else if (varRefType.tag == 9) {
            BType resultType;
            if (indexBasedAccessExpr.isLValue) {
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_TABLE_USING_MEMBER_ACCESS, varRefType);
                return this.symTable.semanticError;
            }
            BTableType tableType = (BTableType)Types.getImpliedType(indexBasedAccessExpr.expr.getBType());
            BType keyTypeConstraint = tableType.keyTypeConstraint;
            if (tableType.keyTypeConstraint == null && (keyTypeConstraint = this.createTableKeyConstraint(tableType.fieldNameList, tableType.constraint)) == this.symTable.semanticError) {
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.MEMBER_ACCESS_NOT_SUPPORTED_FOR_KEYLESS_TABLE, indexBasedAccessExpr.expr);
                return this.symTable.semanticError;
            }
            BType indexExprType = this.checkExpr(indexExpr, keyTypeConstraint, data);
            if (indexExprType == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            if (data.expType.tag != 24 && (resultType = this.checkExpr(indexBasedAccessExpr.expr, data.expType, data)) == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            BType constraint = tableType.constraint;
            actualType = this.types.addNilForNillableAccessType(constraint);
            indexBasedAccessExpr.originalType = indexBasedAccessExpr.leafNode || !nillableExprType ? actualType : this.types.getTypeWithoutNil(actualType);
        } else {
            indexBasedAccessExpr.indexExpr.setBType(this.symTable.semanticError);
            this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_MEMBER_ACCESS, indexBasedAccessExpr.expr.getBType());
            return this.symTable.semanticError;
        }
        if (nillableExprType && !actualType.isNullable()) {
            actualType = BUnionType.create(this.typeEnv, null, actualType, this.symTable.nilType);
        }
        return actualType;
    }

    private BType getXmlMemberAccessType(BType varRefType) {
        BType xmlMemberAccessType;
        if (varRefType.tag == 21) {
            Set memberTypes = ((BUnionType)varRefType).getMemberTypes();
            LinkedHashSet<BType> effectiveMemberTypes = new LinkedHashSet<BType>(((HashSet)memberTypes).size());
            for (BType memberType : memberTypes) {
                if ((memberType = Types.getImpliedType(memberType)) == this.symTable.xmlNeverType) {
                    effectiveMemberTypes.add(this.symTable.xmlNeverType);
                    continue;
                }
                effectiveMemberTypes.add(this.getXMLConstituents(memberType));
            }
            xmlMemberAccessType = effectiveMemberTypes.size() == 1 ? (BType)effectiveMemberTypes.iterator().next() : BUnionType.create(this.typeEnv, null, effectiveMemberTypes);
        } else {
            xmlMemberAccessType = this.getXMLConstituents(varRefType);
        }
        if (this.types.isAssignable(xmlMemberAccessType, this.symTable.neverType)) {
            return this.symTable.xmlNeverType;
        }
        if (this.types.isAssignable(this.symTable.xmlNeverType, xmlMemberAccessType)) {
            return xmlMemberAccessType;
        }
        return BUnionType.create(this.typeEnv, null, xmlMemberAccessType, this.symTable.xmlNeverType);
    }

    private Long getConstIndex(BLangExpression indexExpr) {
        return switch (indexExpr.getKind()) {
            case NodeKind.GROUP_EXPR -> {
                BLangGroupExpr groupExpr = (BLangGroupExpr)indexExpr;
                yield this.getConstIndex(groupExpr.expression);
            }
            case NodeKind.NUMERIC_LITERAL -> (Long)((BLangLiteral)indexExpr).value;
            case NodeKind.UNARY_EXPR -> {
                BLangNumericLiteral numericLiteral = Types.constructNumericLiteralFromUnaryExpr((BLangUnaryExpr)indexExpr);
                yield (Long)numericLiteral.value;
            }
            default -> (Long)((BConstantSymbol)((BLangSimpleVarRef)indexExpr).symbol).value.value;
        };
    }

    private String getConstFieldName(BLangExpression indexExpr) {
        return switch (indexExpr.getKind()) {
            case NodeKind.GROUP_EXPR -> {
                BLangGroupExpr groupExpr = (BLangGroupExpr)indexExpr;
                yield this.getConstFieldName(groupExpr.expression);
            }
            case NodeKind.LITERAL -> (String)((BLangLiteral)indexExpr).value;
            default -> (String)((BConstantSymbol)((BLangSimpleVarRef)indexExpr).symbol).value.value;
        };
    }

    private BType checkArrayIndexBasedAccess(BLangIndexBasedAccess indexBasedAccess, BType indexExprType, BArrayType arrayType) {
        BType actualType = this.symTable.semanticError;
        indexExprType = Types.getImpliedType(indexExprType);
        int tag = indexExprType.tag;
        if (tag == 2 || TypeTags.isIntegerTypeTag(tag)) {
            BLangExpression indexExpr = indexBasedAccess.indexExpr;
            if (!this.isConstExpr(indexExpr) || arrayType.state == BArrayState.OPEN) {
                return arrayType.eType;
            }
            Long indexVal = this.getConstIndex(indexExpr);
            return indexVal >= (long)arrayType.getSize() || indexVal < 0L ? this.symTable.semanticError : arrayType.eType;
        }
        switch (tag) {
            case 33: {
                SemType t = indexExprType.semType();
                long maxIndexValue = arrayType.state == BArrayState.OPEN ? Long.MAX_VALUE : (long)(arrayType.getSize() - 1);
                ComplexSemType allowedInts = PredefinedType.basicSubtype((BasicTypeCode)BasicTypeCode.BT_INT, (ProperSubtypeData)IntSubtype.createSingleRangeSubtype((long)0L, (long)maxIndexValue));
                if (Core.isEmpty((Context)this.types.semTypeCtx, (SemType)SemTypes.intersect((SemType)t, (SemType)allowedInts))) {
                    return this.symTable.semanticError;
                }
                actualType = arrayType.eType;
                break;
            }
            case 21: {
                BType possibleType;
                ArrayList<BFiniteType> finiteTypes = new ArrayList<BFiniteType>();
                for (Object memType : ((BUnionType)indexExprType).getMemberTypes()) {
                    memType = Types.getReferredType((BType)memType);
                    if (((BType)memType).tag == 33) {
                        finiteTypes.add((BFiniteType)memType);
                        continue;
                    }
                    possibleType = this.checkArrayIndexBasedAccess(indexBasedAccess, (BType)memType, arrayType);
                    if (possibleType != this.symTable.semanticError) continue;
                    return this.symTable.semanticError;
                }
                if (!finiteTypes.isEmpty()) {
                    ArrayList<SemNamedType> newValueSpace = new ArrayList<SemNamedType>();
                    for (BFiniteType ft : finiteTypes) {
                        newValueSpace.addAll(Arrays.asList(ft.valueSpace));
                    }
                    BFiniteType finiteType = new BFiniteType(null, (SemNamedType[])newValueSpace.toArray(SemNamedType[]::new));
                    possibleType = this.checkArrayIndexBasedAccess(indexBasedAccess, finiteType, arrayType);
                    if (possibleType == this.symTable.semanticError) {
                        return this.symTable.semanticError;
                    }
                }
                actualType = arrayType.eType;
            }
        }
        return actualType;
    }

    private BType checkListIndexBasedAccess(BLangIndexBasedAccess accessExpr, BType type) {
        if (type.tag == 20) {
            return this.checkArrayIndexBasedAccess(accessExpr, accessExpr.indexExpr.getBType(), (BArrayType)type);
        }
        if (type.tag == 31) {
            return this.checkTupleIndexBasedAccess(accessExpr, (BTupleType)type, accessExpr.indexExpr.getBType());
        }
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : ((BUnionType)type).getMemberTypes()) {
            BType individualFieldType = this.checkListIndexBasedAccess(accessExpr, memType);
            if (individualFieldType == this.symTable.semanticError) continue;
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.isEmpty()) {
            return this.symTable.semanticError;
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(this.typeEnv, null, fieldTypeMembers);
    }

    private BType checkTupleIndexBasedAccess(BLangIndexBasedAccess accessExpr, BTupleType tuple, BType currentType) {
        BType actualType = this.symTable.semanticError;
        BLangExpression indexExpr = accessExpr.indexExpr;
        currentType = Types.getImpliedType(currentType);
        int tag = currentType.tag;
        if (tag == 2 || TypeTags.isIntegerTypeTag(tag)) {
            if (this.isConstExpr(indexExpr)) {
                return this.checkTupleFieldType(tuple, this.getConstIndex(indexExpr).intValue());
            }
            LinkedHashSet<BType> tupleTypes = this.collectTupleFieldTypes(tuple, new LinkedHashSet<BType>());
            return tupleTypes.size() == 1 ? (BType)tupleTypes.iterator().next() : BUnionType.create(this.typeEnv, null, tupleTypes);
        }
        switch (tag) {
            case 33: {
                LinkedHashSet<BType> possibleTypes = new LinkedHashSet<BType>();
                SemType t = currentType.semType();
                Optional<SubtypeData> properSubtypeData = this.getProperSubtypeData(t, BasicTypeCode.BT_INT);
                if (properSubtypeData.isEmpty()) {
                    return this.symTable.semanticError;
                }
                IntSubtype intSubtype = (IntSubtype)properSubtypeData.get();
                for (Range range : intSubtype.ranges) {
                    for (long indexVal = range.min; indexVal <= range.max; ++indexVal) {
                        BType fieldType = this.checkTupleFieldType(tuple, (int)indexVal);
                        if (fieldType.tag == 28) continue;
                        possibleTypes.add(fieldType);
                    }
                }
                if (possibleTypes.isEmpty()) {
                    return this.symTable.semanticError;
                }
                actualType = possibleTypes.size() == 1 ? (BType)possibleTypes.iterator().next() : BUnionType.create(this.typeEnv, null, possibleTypes);
                break;
            }
            case 21: {
                LinkedHashSet<BType> possibleTypesByMember = new LinkedHashSet<BType>();
                ArrayList finiteTypes = new ArrayList();
                ((BUnionType)currentType).getMemberTypes().forEach(memType -> {
                    memType = Types.getImpliedType(memType);
                    if (memType.tag == 33) {
                        finiteTypes.add((BFiniteType)memType);
                    } else {
                        BType possibleType = this.checkTupleIndexBasedAccess(accessExpr, tuple, (BType)memType);
                        if (possibleType.tag == 21) {
                            possibleTypesByMember.addAll(((BUnionType)possibleType).getMemberTypes());
                        } else {
                            possibleTypesByMember.add(possibleType);
                        }
                    }
                });
                if (!finiteTypes.isEmpty()) {
                    ArrayList<SemNamedType> newValueSpace = new ArrayList<SemNamedType>();
                    for (BFiniteType ft : finiteTypes) {
                        newValueSpace.addAll(Arrays.asList(ft.valueSpace));
                    }
                    BFiniteType finiteType = new BFiniteType(null, (SemNamedType[])newValueSpace.toArray(SemNamedType[]::new));
                    BType possibleType = this.checkTupleIndexBasedAccess(accessExpr, tuple, finiteType);
                    if (possibleType.tag == 21) {
                        possibleTypesByMember.addAll(((BUnionType)possibleType).getMemberTypes());
                    } else {
                        possibleTypesByMember.add(possibleType);
                    }
                }
                if (possibleTypesByMember.contains(this.symTable.semanticError)) {
                    return this.symTable.semanticError;
                }
                actualType = possibleTypesByMember.size() == 1 ? (BType)possibleTypesByMember.iterator().next() : BUnionType.create(this.typeEnv, null, possibleTypesByMember);
            }
        }
        return actualType;
    }

    private LinkedHashSet<BType> collectTupleFieldTypes(BTupleType tupleType, LinkedHashSet<BType> memberTypes) {
        tupleType.getTupleTypes().forEach(memberType -> {
            BType referredMemberType = Types.getImpliedType(memberType);
            if (referredMemberType.tag == 21) {
                this.collectMemberTypes((BUnionType)referredMemberType, memberTypes);
            } else {
                memberTypes.add((BType)memberType);
            }
        });
        BType tupleRestType = tupleType.restType;
        if (tupleRestType != null) {
            memberTypes.add(tupleRestType);
        }
        return memberTypes;
    }

    private BType checkMappingIndexBasedAccess(BLangIndexBasedAccess accessExpr, BType bType, AnalyzerData data) {
        BType type = Types.getImpliedType(bType);
        if (type.tag == 16) {
            BType constraint = Types.getReferredType(((BMapType)type).constraint);
            return accessExpr.isLValue ? constraint : this.types.addNilForNillableAccessType(constraint);
        }
        if (type.tag == 12) {
            return this.checkRecordIndexBasedAccess(accessExpr, (BRecordType)type, accessExpr.indexExpr.getBType(), data);
        }
        boolean nonMatchedRecordExists = false;
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : ((BUnionType)type).getMemberTypes()) {
            BType individualFieldType = this.checkMappingIndexBasedAccess(accessExpr, memType, data);
            if (individualFieldType == this.symTable.semanticError) {
                nonMatchedRecordExists = true;
                continue;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.isEmpty()) {
            return this.symTable.semanticError;
        }
        BType fieldType = fieldTypeMembers.size() == 1 ? (BType)fieldTypeMembers.iterator().next() : BUnionType.create(this.typeEnv, null, fieldTypeMembers);
        return nonMatchedRecordExists ? this.types.addNilForNillableAccessType(fieldType) : fieldType;
    }

    private BType checkRecordIndexBasedAccess(BLangIndexBasedAccess accessExpr, BRecordType record, BType currentType, AnalyzerData data) {
        BType actualType = this.symTable.semanticError;
        BLangExpression indexExpr = accessExpr.indexExpr;
        currentType = Types.getImpliedType(currentType);
        switch (currentType.tag) {
            case 5: 
            case 45: {
                if (this.isConstExpr(indexExpr)) {
                    String fieldName = Utils.escapeSpecialCharacters((String)this.getConstFieldName(indexExpr));
                    actualType = this.checkRecordRequiredFieldAccess(accessExpr, Names.fromString(fieldName), record, data);
                    if (actualType != this.symTable.semanticError) {
                        return actualType;
                    }
                    actualType = this.checkRecordOptionalFieldAccess(accessExpr, Names.fromString(fieldName), record, data);
                    if (actualType == this.symTable.semanticError) {
                        actualType = this.checkRecordRestFieldAccess(accessExpr, Names.fromString(fieldName), record, data);
                        if (actualType == this.symTable.semanticError) {
                            return actualType;
                        }
                        if (actualType == this.symTable.neverType) {
                            return actualType;
                        }
                        return this.types.addNilForNillableAccessType(actualType);
                    }
                    if (accessExpr.isLValue) {
                        return actualType;
                    }
                    return this.types.addNilForNillableAccessType(actualType);
                }
                LinkedHashSet fieldTypes = record.fields.values().stream().map(field -> field.type).collect(Collectors.toCollection(LinkedHashSet::new));
                if (record.restFieldType.tag != 24) {
                    fieldTypes.add(record.restFieldType);
                }
                if (!accessExpr.isLValue && fieldTypes.stream().noneMatch(BType::isNullable)) {
                    fieldTypes.add(this.symTable.nilType);
                }
                actualType = fieldTypes.size() == 1 ? (BType)fieldTypes.iterator().next() : BUnionType.create(this.typeEnv, null, fieldTypes);
                break;
            }
            case 33: {
                LinkedHashSet<BType> possibleTypes = new LinkedHashSet<BType>();
                SemType t = currentType.semType();
                Optional<SubtypeData> properSubtypeData = this.getProperSubtypeData(t, BasicTypeCode.BT_STRING);
                if (properSubtypeData.isEmpty()) {
                    return this.symTable.semanticError;
                }
                Set<String> values = TypeChecker.getStringValueSpace((StringSubtype)properSubtypeData.get());
                for (String fieldName : values) {
                    BType fieldType = this.checkRecordRequiredFieldAccess(accessExpr, Names.fromString(fieldName), record, data);
                    if (fieldType == this.symTable.semanticError) {
                        fieldType = this.checkRecordOptionalFieldAccess(accessExpr, Names.fromString(fieldName), record, data);
                        if (fieldType == this.symTable.semanticError) {
                            fieldType = this.checkRecordRestFieldAccess(accessExpr, Names.fromString(fieldName), record, data);
                        }
                        if (fieldType != this.symTable.semanticError) {
                            fieldType = this.types.addNilForNillableAccessType(fieldType);
                        }
                    }
                    if (fieldType.tag == 28) continue;
                    possibleTypes.add(fieldType);
                }
                if (possibleTypes.isEmpty()) {
                    return this.symTable.semanticError;
                }
                if (!accessExpr.isLValue && possibleTypes.stream().noneMatch(BType::isNullable)) {
                    possibleTypes.add(this.symTable.nilType);
                }
                actualType = possibleTypes.size() == 1 ? (BType)possibleTypes.iterator().next() : BUnionType.create(this.typeEnv, null, possibleTypes);
                break;
            }
            case 21: {
                LinkedHashSet<BType> possibleTypesByMember = new LinkedHashSet<BType>();
                ArrayList finiteTypes = new ArrayList();
                this.types.getAllTypes(currentType, true).forEach(memType -> {
                    if (memType.tag == 33) {
                        finiteTypes.add((BFiniteType)memType);
                    } else {
                        BType possibleType = this.checkRecordIndexBasedAccess(accessExpr, record, (BType)memType, data);
                        if (possibleType.tag == 21) {
                            possibleTypesByMember.addAll(((BUnionType)possibleType).getMemberTypes());
                        } else {
                            possibleTypesByMember.add(possibleType);
                        }
                    }
                });
                if (!finiteTypes.isEmpty()) {
                    ArrayList<SemNamedType> newValueSpace = new ArrayList<SemNamedType>();
                    for (BFiniteType ft : finiteTypes) {
                        newValueSpace.addAll(Arrays.asList(ft.valueSpace));
                    }
                    BFiniteType finiteType = new BFiniteType(null, (SemNamedType[])newValueSpace.toArray(SemNamedType[]::new));
                    BType possibleType = this.checkRecordIndexBasedAccess(accessExpr, record, finiteType, data);
                    if (possibleType.tag == 21) {
                        possibleTypesByMember.addAll(((BUnionType)possibleType).getMemberTypes());
                    } else {
                        possibleTypesByMember.add(possibleType);
                    }
                }
                if (possibleTypesByMember.contains(this.symTable.semanticError)) {
                    return this.symTable.semanticError;
                }
                actualType = possibleTypesByMember.size() == 1 ? (BType)possibleTypesByMember.iterator().next() : BUnionType.create(this.typeEnv, null, possibleTypesByMember);
            }
        }
        return actualType;
    }

    private Optional<SubtypeData> getProperSubtypeData(SemType t, BasicTypeCode u) {
        if (t instanceof BasicTypeBitSet) {
            return Optional.empty();
        }
        SubtypeData sd = Core.getComplexSubtypeData((ComplexSemType)((ComplexSemType)t), (BasicTypeCode)u);
        if (sd instanceof AllOrNothingSubtype) {
            return Optional.empty();
        }
        return Optional.of(sd);
    }

    private static Set<String> getStringValueSpace(StringSubtype stringSubtype) {
        HashSet<String> values = new HashSet<String>();
        CharStringSubtype charStringSubtype = stringSubtype.getChar();
        assert (charStringSubtype.allowed);
        for (EnumerableType enumerableType : charStringSubtype.values()) {
            EnumerableCharString s = (EnumerableCharString)enumerableType;
            values.add(s.value);
        }
        NonCharStringSubtype nonCharStringSubtype = stringSubtype.getNonChar();
        assert (nonCharStringSubtype.allowed);
        for (EnumerableType enumerableType : nonCharStringSubtype.values()) {
            EnumerableString s = (EnumerableString)enumerableType;
            values.add(s.value);
        }
        return values;
    }

    private boolean isConstExpr(BLangExpression expression) {
        switch (expression.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: {
                return true;
            }
            case GROUP_EXPR: {
                BLangGroupExpr groupExpr = (BLangGroupExpr)expression;
                return this.isConstExpr(groupExpr.expression);
            }
            case SIMPLE_VARIABLE_REF: {
                return (((BLangSimpleVarRef)expression).symbol.tag & 0x100001CL) == 0x100001CL;
            }
            case UNARY_EXPR: {
                BLangUnaryExpr unaryExpr = (BLangUnaryExpr)expression;
                if (this.types.isLiteralInUnaryAllowed(unaryExpr)) {
                    return this.isConstExpr(unaryExpr.expr);
                }
                return false;
            }
        }
        return false;
    }

    public Name getCurrentCompUnit(BLangNode node) {
        return Names.fromString(node.pos.lineRange().fileName());
    }

    private BType getRepresentativeBroadType(List<BType> inferredTypeList) {
        block0: for (int i = 0; i < inferredTypeList.size(); ++i) {
            BType type = inferredTypeList.get(i);
            if (type.tag == 28) {
                return type;
            }
            for (int j = i + 1; j < inferredTypeList.size(); ++j) {
                BType otherType = inferredTypeList.get(j);
                if (otherType.tag == 28) {
                    return otherType;
                }
                if (this.types.isAssignable(otherType, type)) {
                    inferredTypeList.remove(j);
                    --j;
                    continue;
                }
                if (!this.types.isAssignable(type, otherType)) continue;
                inferredTypeList.remove(i);
                --i;
                continue block0;
            }
        }
        if (inferredTypeList.size() == 1) {
            return inferredTypeList.get(0);
        }
        return BUnionType.create(this.typeEnv, null, inferredTypeList.toArray(new BType[0]));
    }

    public BType defineInferredRecordType(BLangRecordLiteral recordLiteral, BType expType, AnalyzerData data) {
        SymbolEnv env = data.env;
        PackageID pkgID = env.enclPkg.symbol.pkgID;
        BRecordTypeSymbol recordSymbol = this.createRecordTypeSymbol(pkgID, recordLiteral.pos, SymbolOrigin.VIRTUAL, data);
        LinkedHashMap<String, FieldInfo> nonRestFieldTypes = new LinkedHashMap<String, FieldInfo>();
        ArrayList<BType> restFieldTypes = new ArrayList<BType>();
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                BLangRecordLiteral.BLangRecordKey bLangRecordKey = keyValue.key;
                BLangExpression expression = keyValue.valueExpr;
                BLangExpression keyExpr = bLangRecordKey.expr;
                if (bLangRecordKey.computedKey) {
                    this.checkExpr(keyExpr, this.symTable.stringType, data);
                    BType exprType = this.checkExpr(expression, expType, data);
                    if (!this.types.isUniqueType(restFieldTypes, exprType)) continue;
                    restFieldTypes.add(exprType);
                    continue;
                }
                this.addToNonRestFieldTypes(nonRestFieldTypes, this.getKeyName(keyExpr), keyValue.readonly ? this.checkExpr(expression, this.symTable.readonlyType, data) : this.checkExpr(expression, expType, data), true, keyValue.readonly);
                continue;
            }
            if (field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP) {
                BType restFieldType;
                BType constraintType;
                BType spreadOpType = this.checkExpr(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr, expType, data);
                BType bType = Types.getImpliedType(spreadOpType);
                if (bType.tag == 16 && this.types.isUniqueType(restFieldTypes, constraintType = ((BMapType)bType).constraint)) {
                    restFieldTypes.add(constraintType);
                }
                if (bType.tag != 12) continue;
                BRecordType recordType = (BRecordType)bType;
                for (BField recField : recordType.fields.values()) {
                    this.addToNonRestFieldTypes(nonRestFieldTypes, recField.name.value, recField.type, !Symbols.isOptional(recField.symbol), false);
                }
                if (recordType.sealed || !this.types.isUniqueType(restFieldTypes, restFieldType = recordType.restFieldType)) continue;
                restFieldTypes.add(restFieldType);
                continue;
            }
            BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
            this.addToNonRestFieldTypes(nonRestFieldTypes, this.getKeyName(varNameField), varNameField.readonly ? this.checkExpr((BLangExpression)varNameField, this.symTable.readonlyType, data) : this.checkExpr((BLangExpression)varNameField, expType, data), true, varNameField.readonly);
        }
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        boolean allReadOnlyNonRestFields = true;
        for (Map.Entry entry : nonRestFieldTypes.entrySet()) {
            FieldInfo fieldInfo = (FieldInfo)entry.getValue();
            List<BType> types = fieldInfo.types;
            if (types.contains(this.symTable.semanticError)) {
                return this.symTable.semanticError;
            }
            String key = (String)entry.getKey();
            Name fieldName = Names.fromString(key);
            BType type = types.size() == 1 ? types.get(0) : BUnionType.create(this.typeEnv, null, types.toArray(new BType[0]));
            HashSet<Flag> flags = new HashSet<Flag>();
            if (fieldInfo.required) {
                flags.add(Flag.REQUIRED);
            } else {
                flags.add(Flag.OPTIONAL);
            }
            if (fieldInfo.readonly) {
                flags.add(Flag.READONLY);
            } else if (allReadOnlyNonRestFields) {
                allReadOnlyNonRestFields = false;
            }
            BVarSymbol fieldSymbol = new BVarSymbol(Flags.asMask(flags), fieldName, pkgID, type, recordSymbol, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
            fields.put(fieldName.value, new BField(fieldName, null, fieldSymbol));
            recordSymbol.scope.define(fieldName, fieldSymbol);
        }
        BRecordType recordType = new BRecordType(this.typeEnv, (BTypeSymbol)recordSymbol);
        recordType.fields = fields;
        if (restFieldTypes.contains(this.symTable.semanticError)) {
            return this.symTable.semanticError;
        }
        if (restFieldTypes.isEmpty()) {
            recordType.sealed = true;
            recordType.restFieldType = this.symTable.noType;
        } else {
            recordType.restFieldType = restFieldTypes.size() == 1 ? (BType)restFieldTypes.get(0) : BUnionType.create(this.typeEnv, null, restFieldTypes.toArray(new BType[0]));
        }
        recordSymbol.type = recordType;
        recordType.tsymbol = recordSymbol;
        if (expType == this.symTable.readonlyType || recordType.sealed && allReadOnlyNonRestFields) {
            recordType.addFlags(32L);
            recordSymbol.flags |= 0x20L;
        }
        BLangRecordTypeNode bLangRecordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(recordType, pkgID, this.symTable, recordLiteral.pos);
        TypeDefBuilderHelper.createTypeDefinitionForTSymbol(recordType, recordSymbol, bLangRecordTypeNode, env);
        return recordType;
    }

    private BRecordTypeSymbol createRecordTypeSymbol(PackageID pkgID, Location location, SymbolOrigin origin, AnalyzerData data) {
        SymbolEnv env = data.env;
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(2048L, Names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(pkgID)), pkgID, null, env.scope.owner, location, origin);
        recordSymbol.scope = new Scope(recordSymbol);
        return recordSymbol;
    }

    private String getKeyName(BLangExpression key) {
        return key.getKind() == NodeKind.SIMPLE_VARIABLE_REF ? ((BLangSimpleVarRef)key).variableName.value : (String)((BLangLiteral)key).value;
    }

    private void addToNonRestFieldTypes(Map<String, FieldInfo> nonRestFieldTypes, String keyString, final BType exprType, boolean required, boolean readonly) {
        if (!nonRestFieldTypes.containsKey(keyString)) {
            nonRestFieldTypes.put(keyString, new FieldInfo((List<BType>)new ArrayList<BType>(){
                {
                    this.add(exprType);
                }
            }, required, readonly));
            return;
        }
        FieldInfo fieldInfo = nonRestFieldTypes.get(keyString);
        List<BType> typeList = fieldInfo.types;
        if (this.types.isUniqueType(typeList, exprType)) {
            typeList.add(exprType);
        }
        if (required && !fieldInfo.required) {
            fieldInfo.required = true;
        }
    }

    private BType checkXmlSubTypeLiteralCompatibility(Location location, BXMLSubType mutableXmlSubType, BType expType, AnalyzerData data) {
        boolean unionExpType;
        if (expType == this.symTable.semanticError) {
            return expType;
        }
        BType referredExpType = Types.getImpliedType(expType);
        boolean bl = unionExpType = referredExpType.tag == 21;
        if (referredExpType == mutableXmlSubType) {
            return expType;
        }
        if (!unionExpType && this.types.isAssignable(mutableXmlSubType, expType)) {
            return mutableXmlSubType;
        }
        BXMLSubType immutableXmlSubType = (BXMLSubType)ImmutableTypeCloner.getEffectiveImmutableType(location, this.types, mutableXmlSubType, data.env, this.symTable, this.anonymousModelHelper, this.names);
        if (referredExpType == immutableXmlSubType) {
            return expType;
        }
        if (!unionExpType && this.types.isAssignable(immutableXmlSubType, expType)) {
            return immutableXmlSubType;
        }
        if (!unionExpType) {
            this.dlog.error(location, DiagnosticErrorCode.INCOMPATIBLE_TYPES, expType, mutableXmlSubType);
            return this.symTable.semanticError;
        }
        ArrayList<BType> compatibleTypes = new ArrayList<BType>();
        for (BType memberType : ((BUnionType)referredExpType).getMemberTypes()) {
            if (compatibleTypes.contains(memberType)) continue;
            if (memberType == mutableXmlSubType || memberType == immutableXmlSubType) {
                compatibleTypes.add(memberType);
                continue;
            }
            if (this.types.isAssignable(mutableXmlSubType, memberType) && !compatibleTypes.contains(mutableXmlSubType)) {
                compatibleTypes.add(mutableXmlSubType);
                continue;
            }
            if (!this.types.isAssignable(immutableXmlSubType, memberType) || compatibleTypes.contains(immutableXmlSubType)) continue;
            compatibleTypes.add(immutableXmlSubType);
        }
        if (compatibleTypes.isEmpty()) {
            this.dlog.error(location, DiagnosticErrorCode.INCOMPATIBLE_TYPES, expType, mutableXmlSubType);
            return this.symTable.semanticError;
        }
        if (compatibleTypes.size() == 1) {
            return (BType)compatibleTypes.get(0);
        }
        this.dlog.error(location, DiagnosticErrorCode.AMBIGUOUS_TYPES, expType);
        return this.symTable.semanticError;
    }

    private void markChildrenAsImmutable(BLangXMLElementLiteral bLangXMLElementLiteral, AnalyzerData data) {
        for (BLangExpression modifiedChild : bLangXMLElementLiteral.modifiedChildren) {
            BType childType = modifiedChild.getBType();
            if (Symbols.isFlagOn(childType.getFlags(), 32L) || !this.types.isSelectivelyImmutableType(childType, data.env.enclPkg.packageID)) continue;
            modifiedChild.setBType(ImmutableTypeCloner.getEffectiveImmutableType(modifiedChild.pos, this.types, childType, data.env, this.symTable, this.anonymousModelHelper, this.names));
            if (modifiedChild.getKind() != NodeKind.XML_ELEMENT_LITERAL) continue;
            this.markChildrenAsImmutable((BLangXMLElementLiteral)modifiedChild, data);
        }
    }

    public void logUndefinedSymbolError(Location pos, String name) {
        if (!this.missingNodesHelper.isMissingNode(name)) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_SYMBOL, name);
        }
    }

    private void markTypeAsIsolated(BType actualType) {
        actualType.addFlags(0x20000000L);
        actualType.tsymbol.flags |= 0x20000000L;
    }

    private void handleObjectConstrExprForReadOnly(BLangObjectConstructorExpression objectCtorExpr, BObjectType actualObjectType, SymbolEnv env, boolean logErrors, AnalyzerData data) {
        BLangClassDefinition classDefForConstructor = objectCtorExpr.classNode;
        boolean hasNeverReadOnlyField = false;
        for (BField field : actualObjectType.fields.values()) {
            BType fieldType = field.type;
            if (this.types.isInherentlyImmutableType(fieldType) || this.types.isSelectivelyImmutableType(fieldType, false, data.env.enclPkg.packageID)) continue;
            this.analyzeObjectConstructor(classDefForConstructor, env, data);
            hasNeverReadOnlyField = true;
            if (!logErrors) {
                return;
            }
            this.dlog.error(field.pos, DiagnosticErrorCode.INVALID_FIELD_IN_OBJECT_CONSTUCTOR_EXPR_WITH_READONLY_REFERENCE, fieldType);
        }
        if (hasNeverReadOnlyField) {
            return;
        }
        classDefForConstructor.flagSet.add(Flag.READONLY);
        actualObjectType.addFlags(32L);
        actualObjectType.tsymbol.flags |= 0x20L;
        ImmutableTypeCloner.markFieldsAsImmutable(classDefForConstructor, env, actualObjectType, this.types, this.anonymousModelHelper, this.symTable, this.names, objectCtorExpr.pos);
        this.analyzeObjectConstructor(classDefForConstructor, env, data);
    }

    private void markConstructedObjectIsolatedness(BObjectType actualObjectType) {
        if (actualObjectType.markedIsolatedness) {
            return;
        }
        if (Symbols.isFlagOn(actualObjectType.getFlags(), 32L)) {
            this.markTypeAsIsolated(actualObjectType);
            return;
        }
        for (BField field : actualObjectType.fields.values()) {
            if (Symbols.isFlagOn(field.symbol.flags, 4L) && this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(field.type)) continue;
            return;
        }
        this.markTypeAsIsolated(actualObjectType);
        actualObjectType.markedIsolatedness = true;
    }

    private void markLeafNode(BLangAccessExpression accessExpression) {
        BLangNode parent = accessExpression.parent;
        if (parent == null) {
            accessExpression.leafNode = true;
            return;
        }
        NodeKind kind = parent.getKind();
        while (kind == NodeKind.GROUP_EXPR) {
            parent = parent.parent;
            if (parent == null) {
                accessExpression.leafNode = true;
                break;
            }
            kind = parent.getKind();
        }
        if (kind != NodeKind.FIELD_BASED_ACCESS_EXPR && kind != NodeKind.INDEX_BASED_ACCESS_EXPR) {
            accessExpression.leafNode = true;
        }
    }

    private BType validateElvisExprLhsExpr(BLangElvisExpr elvisExpr, BType lhsType) {
        LinkedHashSet<BType> memberTypes;
        int size;
        BType referencedType = Types.getImpliedType(lhsType);
        if (!referencedType.isNullable()) {
            this.dlog.error(elvisExpr.pos, DiagnosticErrorCode.OPERATOR_NOT_SUPPORTED, new Object[]{OperatorKind.ELVIS, lhsType});
            return this.symTable.semanticError;
        }
        int tag = referencedType.tag;
        BType actualType = tag == 21 || tag == 7 || tag == 11 || tag == 33 ? ((size = (memberTypes = this.getTypeWithoutNilForNonAnyTypeWithNil(referencedType)).size()) == 0 ? this.symTable.neverType : (size == 1 ? (BType)memberTypes.iterator().next() : BUnionType.create(this.typeEnv, null, memberTypes))) : referencedType;
        if (this.types.isAssignable(referencedType, this.symTable.nilType) || actualType == this.symTable.neverType) {
            this.dlog.error(elvisExpr.pos, DiagnosticErrorCode.NIL_CONDITIONAL_EXPR_NOT_YET_SUPPORTED_WITH_NIL, new Object[0]);
            actualType = this.symTable.semanticError;
        }
        return actualType;
    }

    private LinkedHashSet<BType> getTypeWithoutNilForNonAnyTypeWithNil(BType type) {
        BType referredType = Types.getImpliedType(type);
        if (referredType.tag == 33) {
            BFiniteType finiteType = (BFiniteType)referredType;
            ArrayList<SemNamedType> newValueSpace = new ArrayList<SemNamedType>(finiteType.valueSpace.length);
            for (SemNamedType semNamedType : finiteType.valueSpace) {
                if (PredefinedType.NIL.equals((Object)semNamedType.semType())) continue;
                newValueSpace.add(semNamedType);
            }
            if (newValueSpace.isEmpty()) {
                return new LinkedHashSet<BType>(0);
            }
            final BFiniteType ft = new BFiniteType(null, (SemNamedType[])newValueSpace.toArray(SemNamedType[]::new));
            return new LinkedHashSet<BType>(1){
                {
                    super(arg0);
                    this.add(ft);
                }
            };
        }
        BUnionType unionType = (BUnionType)referredType;
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
        for (BType memberType : unionType.getMemberTypes()) {
            int tag = Types.getImpliedType((BType)memberType).tag;
            if (tag == 7 || tag == 11 || tag == 33) {
                memberTypes.addAll(this.getTypeWithoutNilForNonAnyTypeWithNil(memberType));
                continue;
            }
            if (this.types.isAssignable(memberType, this.symTable.nilType)) continue;
            memberTypes.add(memberType);
        }
        return memberTypes;
    }

    public GlobalStateSnapshot getGlobalStateSnapshotAndResetGlobalState() {
        GlobalStateSnapshot globalStateSnapshot = new GlobalStateSnapshot(this.typeResolver.getUnknownTypeRefs(), this.dlog.errorCount());
        this.typeResolver.setUnknownTypeRefs(new HashSet<TypeResolver.LocationData>());
        this.dlog.resetErrorCount();
        return globalStateSnapshot;
    }

    public void restoreGlobalState(GlobalStateSnapshot globalStateSnapshot) {
        this.typeResolver.setUnknownTypeRefs(globalStateSnapshot.unknownTypeRefs);
        this.dlog.setErrorCount(globalStateSnapshot.errorCount);
    }

    private void checkNaturalExprInsertions(BLangNaturalExpression naturalExpression, AnalyzerData data) {
        boolean isConstNaturalExpr = naturalExpression.isConstExpr;
        for (BLangExpression expr : naturalExpression.insertions) {
            this.checkExpr(expr, this.symTable.anydataType, data);
            if (!isConstNaturalExpr || this.isConstExpression(expr)) continue;
            this.dlog.error(expr.pos, DiagnosticErrorCode.CONST_NATURAL_EXPR_CAN_HAVE_ONLY_CONST_EXPR_INSERTION, new Object[0]);
        }
    }

    static {
        LIST_LENGTH_MODIFIER_FUNCTIONS.add(FUNCTION_NAME_PUSH);
        LIST_LENGTH_MODIFIER_FUNCTIONS.add(FUNCTION_NAME_POP);
        LIST_LENGTH_MODIFIER_FUNCTIONS.add(FUNCTION_NAME_SHIFT);
        LIST_LENGTH_MODIFIER_FUNCTIONS.add(FUNCTION_NAME_UNSHIFT);
        MODIFIER_FUNCTIONS.put(LIST_LANG_LIB, new HashSet<String>(){
            {
                this.add("remove");
                this.add("removeAll");
                this.add("setLength");
                this.add("reverse");
                this.add("sort");
                this.add(TypeChecker.FUNCTION_NAME_POP);
                this.add(TypeChecker.FUNCTION_NAME_PUSH);
                this.add(TypeChecker.FUNCTION_NAME_SHIFT);
                this.add(TypeChecker.FUNCTION_NAME_UNSHIFT);
            }
        });
        MODIFIER_FUNCTIONS.put(MAP_LANG_LIB, new HashSet<String>(){
            {
                this.add("remove");
                this.add("removeIfHasKey");
                this.add("removeAll");
            }
        });
        MODIFIER_FUNCTIONS.put(TABLE_LANG_LIB, new HashSet<String>(){
            {
                this.add("put");
                this.add("add");
                this.add("remove");
                this.add("removeIfHasKey");
                this.add("removeAll");
            }
        });
        MODIFIER_FUNCTIONS.put(VALUE_LANG_LIB, new HashSet<String>(){
            {
                this.add("mergeJson");
            }
        });
        MODIFIER_FUNCTIONS.put(XML_LANG_LIB, new HashSet<String>(){
            {
                this.add("setName");
                this.add("setChildren");
                this.add("strip");
            }
        });
    }

    public static class AnalyzerData {
        public SymbolEnv env;
        boolean isTypeChecked;
        Deque<SymbolEnv> prevEnvs;
        Types.CommonAnalyzerData commonAnalyzerData = new Types.CommonAnalyzerData();
        DiagnosticCode diagCode;
        BType expType;
        BType resultType;
        boolean isResourceAccessPathSegments = false;
        QueryTypeChecker.AnalyzerData queryData = new QueryTypeChecker.AnalyzerData();
        Set<String> queryVariables;
    }

    public record GlobalStateSnapshot(HashSet<TypeResolver.LocationData> unknownTypeRefs, int errorCount) {
    }

    private static class InferredTupleDetails {
        List<BType> fixedMemberTypes = new ArrayList<BType>();
        List<BType> restMemberTypes = new ArrayList<BType>();

        private InferredTupleDetails() {
        }
    }

    private static class TypeSymbolPair {
        private final BVarSymbol fieldSymbol;
        private final BType determinedType;

        public TypeSymbolPair(BVarSymbol fieldSymbol, BType determinedType) {
            this.fieldSymbol = fieldSymbol;
            this.determinedType = determinedType;
        }
    }

    private static class RecordUnionDiagnostics {
        Set<BRecordType> undeclaredInRecords = new LinkedHashSet<BRecordType>();
        Set<BRecordType> nilableInRecords = new LinkedHashSet<BRecordType>();

        private RecordUnionDiagnostics() {
        }

        boolean hasUndeclared() {
            return !this.undeclaredInRecords.isEmpty();
        }

        boolean hasNilable() {
            return !this.nilableInRecords.isEmpty();
        }

        boolean hasNilableAndUndeclared() {
            return !this.nilableInRecords.isEmpty() && !this.undeclaredInRecords.isEmpty();
        }

        String recordsToString(Set<BRecordType> recordTypeSet) {
            StringBuilder recordNames = new StringBuilder();
            int recordSetSize = recordTypeSet.size();
            int index = 0;
            for (BRecordType recordType : recordTypeSet) {
                ++index;
                recordNames.append(recordType.tsymbol.getName().getValue());
                if (recordSetSize <= 1) continue;
                if (index == recordSetSize - 1) {
                    recordNames.append("', and '");
                    continue;
                }
                if (index >= recordSetSize) continue;
                recordNames.append("', '");
            }
            return recordNames.toString();
        }
    }

    private static class FieldInfo {
        List<BType> types;
        boolean required;
        boolean readonly;

        private FieldInfo(List<BType> types, boolean required, boolean readonly) {
            this.types = types;
            this.required = required;
            this.readonly = readonly;
        }
    }
}

