/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.wso2.ballerinalang.compiler.semantics.model.UniqueTypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNeverType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BPackageType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BReadonlyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.util.Names;

public class TypeHashVisitor
extends UniqueTypeVisitor<Integer> {
    private final Map<BType, Integer> visited = new HashMap<BType, Integer>();
    private final Set<BType> unresolvedTypes = new HashSet<BType>();
    private final Map<BType, Integer> cache = new HashMap<BType, Integer>();

    @Override
    public boolean isVisited(BType type) {
        return this.visited.containsKey(type);
    }

    @Override
    public void reset() {
        this.visited.clear();
        this.unresolvedTypes.clear();
    }

    public Integer getHash(BType type) {
        Integer hash = this.cache.get(type);
        if (hash != null) {
            return hash;
        }
        hash = this.visit(type);
        this.cache.put(type, hash);
        return hash;
    }

    @Override
    public Integer visit(BType type) {
        if (type == null) {
            return 0;
        }
        switch (type.tag) {
            case 18: {
                return this.visit((BAnyType)type);
            }
            case 10: {
                return this.visitNilType(type);
            }
            case 50: {
                return this.visit((BNeverType)type);
            }
            case 11: {
                return this.visit((BAnydataType)type);
            }
            case 27: {
                return this.visit((BAnnotationType)type);
            }
            case 12: {
                return this.visit((BRecordType)type);
            }
            case 29: {
                return this.visit((BErrorType)type);
            }
            case 34: {
                return this.visit((BObjectType)type);
            }
            case 20: {
                return this.visit((BArrayType)type);
            }
            case 21: {
                return this.visit((BUnionType)type);
            }
            case 13: {
                return this.visit((BTypedescType)type);
            }
            case 16: {
                return this.visit((BMapType)type);
            }
            case 33: {
                return this.visit((BFiniteType)type);
            }
            case 31: {
                return this.visit((BTupleType)type);
            }
            case 9: {
                return this.visit((BTableType)type);
            }
            case 15: {
                return this.visit((BStreamType)type);
            }
            case 22: {
                return this.visit((BIntersectionType)type);
            }
            case 38: {
                return this.visit((BReadonlyType)type);
            }
            case 52: {
                return this.visit((BParameterizedType)type);
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return this.visit((BIntSubType)type);
            }
            case 8: {
                return this.visit((BXMLType)type);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                return this.visit((BXMLSubType)type);
            }
            case 14: {
                return this.visit((BTypeReferenceType)type);
            }
            case 24: {
                return 0;
            }
        }
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        return this.addToVisited(type, this.baseHash(type));
    }

    @Override
    public Integer visit(BAnnotationType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), type.getKind().typeName());
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BArrayType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), type.getSize(), type.state.getValue(), this.visit(type.eType));
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BReadonlyType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), type.getKind().typeName());
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BAnyType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), type.getKind().typeName());
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BFutureType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), this.visit(type.constraint));
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BHandleType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), type.getKind().typeName());
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BMapType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), this.visit(type.constraint));
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BStreamType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), this.visit(type.constraint), this.visit(type.completionType));
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BTypedescType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), this.visit(type.constraint));
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BXMLType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), this.visit(type.constraint));
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BAnydataType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), type.getKind().typeName());
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BErrorType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), type.typeIdSet, this.visit(type.detailType));
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BInvokableType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        List<Integer> paramTypesHashes = this.getTypesHashes(type.paramTypes);
        Integer hash = Objects.hash(this.baseHash(type), paramTypesHashes, this.visit(type.restType), this.visit(type.retType));
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BJSONType type) {
        return this.visit((BUnionType)type);
    }

    @Override
    public Integer visit(BParameterizedType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), type.paramIndex, this.visit(type.paramValueType));
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BNeverType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), Names.NEVER.value);
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visitNilType(BType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), Names.NIL_VALUE.value);
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BNoType type) {
        return 0;
    }

    @Override
    public Integer visit(BPackageType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), type.getKind().typeName());
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BTupleType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        List<Integer> tupleTypesHashes = this.getOrderedTypesHashes(type.getTupleTypes());
        Integer hash = Objects.hash(this.baseHash(type), tupleTypesHashes, this.visit(type.restType), type.getFlags(), type.tsymbol);
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BIntersectionType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), this.visit(type.effectiveType), this.getTypesHashes(type.getConstituentTypes()));
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BTypeReferenceType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), this.visit(type.referredType), type.definitionName);
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BTableType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), type.fieldNameList, this.visit(type.constraint), this.visit(type.keyTypeConstraint));
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BFiniteType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), type.toString().hashCode());
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BStructureType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        List<Integer> fieldsHashes = this.getFieldsHashes(type.fields);
        List<Integer> typeInclHashes = this.getTypesHashes(type.typeInclusions);
        Integer hash = Objects.hash(this.baseHash(type), type.getFlags(), fieldsHashes, typeInclHashes);
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BObjectType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        List<Integer> fieldsHashes = this.getFieldsHashes(type.fields);
        List<Integer> typeInclHashes = this.getTypesHashes(type.typeInclusions);
        List<Integer> attachedFunctionsHashes = this.getFunctionsHashes(((BObjectTypeSymbol)type.tsymbol).attachedFuncs);
        Integer hash = Objects.hash(this.baseHash(type), type.getFlags(), fieldsHashes, typeInclHashes, attachedFunctionsHashes, type.typeIdSet);
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BRecordType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        List<Integer> fieldsHashes = this.getFieldsHashes(type.fields);
        List<Integer> typeInclHashes = this.getTypesHashes(type.typeInclusions);
        Integer hash = Objects.hash(this.baseHash(type), type.getFlags(), type.sealed, fieldsHashes, typeInclHashes, this.visit(type.restFieldType));
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BUnionType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), type.isCyclic, this.getTypesHashes(type.getMemberTypes()), type.getFlags());
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BIntSubType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), Names.INT.value, type.name.getValue());
        return this.addToVisited(type, hash);
    }

    @Override
    public Integer visit(BXMLSubType type) {
        if (this.isVisited(type)) {
            return this.visited.get(type);
        }
        if (this.isCyclic(type)) {
            return 0;
        }
        Integer hash = Objects.hash(this.baseHash(type), Names.XML.value, type.name.getValue());
        return this.addToVisited(type, hash);
    }

    private boolean isCyclic(BType type) {
        if (this.unresolvedTypes.contains(type)) {
            return true;
        }
        this.unresolvedTypes.add(type);
        return false;
    }

    private Integer addToVisited(BType type, Integer hash) {
        this.visited.put(type, hash);
        return hash;
    }

    private Integer baseHash(BType type) {
        return Objects.hash(type.tag);
    }

    private List<Integer> getTypesHashes(Collection<BType> types) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (BType type : types) {
            Integer visit = this.visit(type);
            list.add(visit);
        }
        list.sort(Comparator.comparingInt(Integer::intValue));
        return list;
    }

    private List<Integer> getOrderedTypesHashes(List<BType> tupleTypes) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (BType tupleType : tupleTypes) {
            Integer visit = this.visit(tupleType);
            list.add(visit);
        }
        return list;
    }

    private List<Integer> getFieldsHashes(Map<String, BField> fields) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (BField f : fields.values()) {
            Integer hash = Objects.hash(f.name.value, f.symbol != null ? Long.valueOf(f.symbol.flags) : null, this.visit(f.type));
            list.add(hash);
        }
        list.sort(Comparator.comparingInt(Integer::intValue));
        return list;
    }

    private List<Integer> getFunctionsHashes(List<BAttachedFunction> attachedFunctions) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (BAttachedFunction attachedFunction : attachedFunctions) {
            Integer functionHash = this.getFunctionHash(attachedFunction);
            list.add(functionHash);
        }
        list.sort(Comparator.comparingInt(Integer::intValue));
        return list;
    }

    private int getFunctionHash(BAttachedFunction attachedFunction) {
        if (attachedFunction == null) {
            return 0;
        }
        return Objects.hash(attachedFunction.funcName.value, attachedFunction.symbol != null ? Long.valueOf(attachedFunction.symbol.flags) : null, this.visit(attachedFunction.type));
    }
}

